"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Pagestyle extends _actor2.default {
  async getComputed(node, markMatched, onlyMatched, filter) {
    const {
      computed
    } = await this.request('getComputed', {
      node,
      markMatched,
      onlyMatched,
      filter
    });
    return computed;
  }

  async getAllUsedFontFaces(includePreviews, previewText, previewFontSize, previewFillStyle) {
    const {
      fontFaces
    } = await this.request('getAllUsedFontFaces', {
      includePreviews,
      previewText,
      previewFontSize,
      previewFillStyle
    });
    return fontFaces;
  }

  async getUsedFontFaces(node, includePreviews, previewText, previewFontSize, previewFillStyle) {
    const {
      fontFaces
    } = await this.request('getUsedFontFaces', {
      node,
      includePreviews,
      previewText,
      previewFontSize,
      previewFillStyle
    });
    return fontFaces;
  }

  async getMatchedSelectors(node, property, filter) {
    const {
      rules,
      sheets,
      matched
    } = await this.request('getMatchedSelectors', {
      node,
      property,
      filter
    });
    return {
      rules,
      sheets,
      matched
    };
  }

  getApplied(node, inherited, matchedSelectors, skipPseudo, filter) {
    return this.request('getApplied', {
      node,
      inherited,
      matchedSelectors,
      skipPseudo,
      filter
    });
  }

  async isPositionEditable(node) {
    const {
      value
    } = await this.request('isPositionEditable', {
      node
    });
    return value;
  }

  getLayout(node, autoMargins) {
    return this.request('getLayout', {
      node,
      autoMargins
    });
  }

  addNewRule(node, pseudoClasses, editAuthored) {
    return this.request('addNewRule', {
      node,
      pseudoClasses,
      editAuthored
    });
  }

}

exports.default = Pagestyle;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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