"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Actor representing an original source of a style sheet that was specified
 * in a source map.
 */
class OriginalSource extends _actor2.default {
  /**
   * Protocol method to get the text of this source.
   *
   * @return {Promise}  text of source
   */
  async getText() {
    const {
      text
    } = await this.request('getText');
    return text;
  }

}

exports.default = OriginalSource;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi9tb2RlbHMvb3JpZ2luYWxzb3VyY2UuanMiXSwibmFtZXMiOlsiT3JpZ2luYWxTb3VyY2UiLCJBY3RvciIsImdldFRleHQiLCJ0ZXh0IiwicmVxdWVzdCJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7Ozs7OztBQUVBOzs7O0FBSWUsTUFBTUEsY0FBTixTQUE2QkMsZUFBN0IsQ0FBbUM7QUFDOUM7Ozs7O0FBS0EsUUFBTUMsT0FBTixHQUFpQjtBQUNiLFVBQU07QUFBRUMsTUFBQUE7QUFBRixRQUFXLE1BQU0sS0FBS0MsT0FBTCxDQUFhLFNBQWIsQ0FBdkI7QUFDQSxXQUFPRCxJQUFQO0FBQ0g7O0FBVDZDOztrQkFBN0JILGMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgQWN0b3IgZnJvbSAnLi4vYWN0b3InXHJcblxyXG4vKipcclxuICogQWN0b3IgcmVwcmVzZW50aW5nIGFuIG9yaWdpbmFsIHNvdXJjZSBvZiBhIHN0eWxlIHNoZWV0IHRoYXQgd2FzIHNwZWNpZmllZFxyXG4gKiBpbiBhIHNvdXJjZSBtYXAuXHJcbiAqL1xyXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBPcmlnaW5hbFNvdXJjZSBleHRlbmRzIEFjdG9yIHtcclxuICAgIC8qKlxyXG4gICAgICogUHJvdG9jb2wgbWV0aG9kIHRvIGdldCB0aGUgdGV4dCBvZiB0aGlzIHNvdXJjZS5cclxuICAgICAqXHJcbiAgICAgKiBAcmV0dXJuIHtQcm9taXNlfSAgdGV4dCBvZiBzb3VyY2VcclxuICAgICAqL1xyXG4gICAgYXN5bmMgZ2V0VGV4dCAoKSB7XHJcbiAgICAgICAgY29uc3QgeyB0ZXh0IH0gPSBhd2FpdCB0aGlzLnJlcXVlc3QoJ2dldFRleHQnKVxyXG4gICAgICAgIHJldHVybiB0ZXh0XHJcbiAgICB9XHJcbn1cclxuIl19