"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A LongString actor provides a way to access "very long" strings from the
 * debugger server.
 */
class LongString extends _actor2.default {
  /**
   * Get the substring of this LongString from start to end.
   *
   * @param {Number} start
   *        The starting index.
   * @param {Number} end
   *        The ending index.
   * @return {String}  long string text
   */
  async substring(start, end) {
    const {
      substring
    } = await this.request('substring', {
      start,
      end
    });
    return substring;
  }

}

exports.default = LongString;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi9tb2RlbHMvbG9uZ1N0cmluZy5qcyJdLCJuYW1lcyI6WyJMb25nU3RyaW5nIiwiQWN0b3IiLCJzdWJzdHJpbmciLCJzdGFydCIsImVuZCIsInJlcXVlc3QiXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBOzs7Ozs7QUFFQTs7OztBQUllLE1BQU1BLFVBQU4sU0FBeUJDLGVBQXpCLENBQStCO0FBQzFDOzs7Ozs7Ozs7QUFTQSxRQUFNQyxTQUFOLENBQWlCQyxLQUFqQixFQUF3QkMsR0FBeEIsRUFBNkI7QUFDekIsVUFBTTtBQUFFRixNQUFBQTtBQUFGLFFBQWdCLE1BQU0sS0FBS0csT0FBTCxDQUFhLFdBQWIsRUFBMEI7QUFBRUYsTUFBQUEsS0FBRjtBQUFTQyxNQUFBQTtBQUFULEtBQTFCLENBQTVCO0FBQ0EsV0FBT0YsU0FBUDtBQUNIOztBQWJ5Qzs7a0JBQXpCRixVIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IEFjdG9yIGZyb20gJy4uL2FjdG9yJ1xyXG5cclxuLyoqXHJcbiAqIEEgTG9uZ1N0cmluZyBhY3RvciBwcm92aWRlcyBhIHdheSB0byBhY2Nlc3MgXCJ2ZXJ5IGxvbmdcIiBzdHJpbmdzIGZyb20gdGhlXHJcbiAqIGRlYnVnZ2VyIHNlcnZlci5cclxuICovXHJcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIExvbmdTdHJpbmcgZXh0ZW5kcyBBY3RvciB7XHJcbiAgICAvKipcclxuICAgICAqIEdldCB0aGUgc3Vic3RyaW5nIG9mIHRoaXMgTG9uZ1N0cmluZyBmcm9tIHN0YXJ0IHRvIGVuZC5cclxuICAgICAqXHJcbiAgICAgKiBAcGFyYW0ge051bWJlcn0gc3RhcnRcclxuICAgICAqICAgICAgICBUaGUgc3RhcnRpbmcgaW5kZXguXHJcbiAgICAgKiBAcGFyYW0ge051bWJlcn0gZW5kXHJcbiAgICAgKiAgICAgICAgVGhlIGVuZGluZyBpbmRleC5cclxuICAgICAqIEByZXR1cm4ge1N0cmluZ30gIGxvbmcgc3RyaW5nIHRleHRcclxuICAgICAqL1xyXG4gICAgYXN5bmMgc3Vic3RyaW5nIChzdGFydCwgZW5kKSB7XHJcbiAgICAgICAgY29uc3QgeyBzdWJzdHJpbmcgfSA9IGF3YWl0IHRoaXMucmVxdWVzdCgnc3Vic3RyaW5nJywgeyBzdGFydCwgZW5kIH0pXHJcbiAgICAgICAgcmV0dXJuIHN1YnN0cmluZ1xyXG4gICAgfVxyXG59XHJcbiJdfQ==