"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Cookies extends _actor2.default {
  /**
   * Function gets all storage fields from the browser
   */
  getFields() {
    return this.request('getFields');
  }
  /**
   * Function gets a specific cookie under a specific host
   *
   * @param {String} host
   * @param {String} name
   * @param {Object} options
   * @returns {Promise.<object>} //data
   */


  async getStoreObjects(host, name, options = {}) {
    const {
      data
    } = await this.request('getStoreObjects', {
      host: host,
      name: name,
      options: options
    });
    return data;
  }

}

exports.default = Cookies;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi9tb2RlbHMvY29va2llcy5qcyJdLCJuYW1lcyI6WyJDb29raWVzIiwiQWN0b3IiLCJnZXRGaWVsZHMiLCJyZXF1ZXN0IiwiZ2V0U3RvcmVPYmplY3RzIiwiaG9zdCIsIm5hbWUiLCJvcHRpb25zIiwiZGF0YSJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7Ozs7OztBQUVlLE1BQU1BLE9BQU4sU0FBc0JDLGVBQXRCLENBQTRCO0FBQ3ZDOzs7QUFHQUMsRUFBQUEsU0FBUyxHQUFJO0FBQ1QsV0FBTyxLQUFLQyxPQUFMLENBQWEsV0FBYixDQUFQO0FBQ0g7QUFFRDs7Ozs7Ozs7OztBQVFBLFFBQU1DLGVBQU4sQ0FBdUJDLElBQXZCLEVBQTZCQyxJQUE3QixFQUFtQ0MsT0FBTyxHQUFHLEVBQTdDLEVBQWlEO0FBQzdDLFVBQU07QUFBRUMsTUFBQUE7QUFBRixRQUFXLE1BQU0sS0FBS0wsT0FBTCxDQUFhLGlCQUFiLEVBQWdDO0FBQUNFLE1BQUFBLElBQUksRUFBRUEsSUFBUDtBQUFhQyxNQUFBQSxJQUFJLEVBQUVBLElBQW5CO0FBQXlCQyxNQUFBQSxPQUFPLEVBQUVBO0FBQWxDLEtBQWhDLENBQXZCO0FBQ0EsV0FBT0MsSUFBUDtBQUNIOztBQW5Cc0M7O2tCQUF0QlIsTyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBBY3RvciBmcm9tICcuLi9hY3RvcidcclxuXHJcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIENvb2tpZXMgZXh0ZW5kcyBBY3RvciB7XHJcbiAgICAvKipcclxuICAgICAqIEZ1bmN0aW9uIGdldHMgYWxsIHN0b3JhZ2UgZmllbGRzIGZyb20gdGhlIGJyb3dzZXJcclxuICAgICAqL1xyXG4gICAgZ2V0RmllbGRzICgpIHtcclxuICAgICAgICByZXR1cm4gdGhpcy5yZXF1ZXN0KCdnZXRGaWVsZHMnKVxyXG4gICAgfVxyXG5cclxuICAgIC8qKlxyXG4gICAgICogRnVuY3Rpb24gZ2V0cyBhIHNwZWNpZmljIGNvb2tpZSB1bmRlciBhIHNwZWNpZmljIGhvc3RcclxuICAgICAqXHJcbiAgICAgKiBAcGFyYW0ge1N0cmluZ30gaG9zdFxyXG4gICAgICogQHBhcmFtIHtTdHJpbmd9IG5hbWVcclxuICAgICAqIEBwYXJhbSB7T2JqZWN0fSBvcHRpb25zXHJcbiAgICAgKiBAcmV0dXJucyB7UHJvbWlzZS48b2JqZWN0Pn0gLy9kYXRhXHJcbiAgICAgKi9cclxuICAgIGFzeW5jIGdldFN0b3JlT2JqZWN0cyAoaG9zdCwgbmFtZSwgb3B0aW9ucyA9IHt9KSB7XHJcbiAgICAgICAgY29uc3QgeyBkYXRhIH0gPSBhd2FpdCB0aGlzLnJlcXVlc3QoJ2dldFN0b3JlT2JqZWN0cycsIHtob3N0OiBob3N0LCBuYW1lOiBuYW1lLCBvcHRpb25zOiBvcHRpb25zfSlcclxuICAgICAgICByZXR1cm4gZGF0YVxyXG4gICAgfVxyXG59XHJcbiJdfQ==