"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The timeline actor pops and forwards timeline markers registered in docshells.
 */
class Timeline extends _actor2.default {
  /**
   * Are we recording profile markers currently?
   *
   * @return {Promise.Boolean}  true if actor is profiling
   */
  async isRecording() {
    const {
      value
    } = await this.request('isRecording');
    return value;
  }
  /**
   * Start recording profile markers.
   *
   * @param {Boolean} withMarkers
   *        Boolean indicating whether or not timeline markers are emitted
   *        once they're accumulated every `DEFAULT_TIMELINE_DATA_PULL_TIMEOUT`
   *        milliseconds.
   * @param {Boolean} withTicks
   *        Boolean indicating whether a `ticks` event is fired and a
   *        FramerateActor is created.
   * @param {Boolean} withMemory
   *        Boolean indiciating whether we want memory measurements sampled.
   * @param {Boolean} withFrames
   *        Boolean indicating whether or not stack frames should be handled
   *        from timeline markers.
   * @param {Boolean} withGCEvents
   *        Boolean indicating whether or not GC markers should be emitted.
   *        TODO: Remove these fake GC markers altogether in bug 1198127.
   * @param {Boolean} withDocLoadingEvents
   *        Boolean indicating whether or not DOMContentLoaded and Load
   *        marker events are emitted.
   * @return {Promise.Number}  start time of recording
   */


  async start(withMarkers, withTicks, withMemory, withFrames, withGCEvents, withDocLoadingEvents) {
    const {
      value
    } = await this.request('start', {
      withMarkers,
      withTicks,
      withMemory,
      withFrames,
      withGCEvents,
      withDocLoadingEvents
    });
    return value;
  }
  /**
   * Stop recording profile markers.
   *
   * @return {Promise.Number}  end time of recording
   */


  async stop() {
    const {
      value
    } = await this.request('stop');
    return value;
  }

}

exports.default = Timeline;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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