"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

var _stylesheet = require("../models/stylesheet");

var _stylesheet2 = _interopRequireDefault(_stylesheet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Creates a StyleSheetsActor. StyleSheetsActor provides remote access to the
 * stylesheets of a document.
 */
class StyleSheets extends _actor2.default {
  /**
   * Protocol method for getting a list of StyleSheetActors representing
   * all the style sheets in this document.
   *
   * @return {Promise.StyleSheet[]} list of all stylesheets of this document
   */
  async getStyleSheets() {
    const {
      styleSheets
    } = await this.request('getStyleSheets');
    return styleSheets.map(payload => new _stylesheet2.default(this.client, payload));
  }
  /**
   * Create a new style sheet in the document with the given text.
   * Return an actor for it.
   *
   * @param  {Object} request
   *         Debugging protocol request object, with 'text property'
   * @return {Promise.Object}
   *         Object with 'styelSheet' property for form on new actor.
   */


  async addStyleSheet(text) {
    const {
      styleSheet
    } = await this.request('addStyleSheet', {
      text
    });
    return styleSheet;
  }

}

exports.default = StyleSheets;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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