"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _fs = require("fs");

var _fs2 = _interopRequireDefault(_fs);

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

var _longString = require("../models/longString");

var _longString2 = _interopRequireDefault(_longString);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const dataURLPreamble = 'data:image/png;base64,';

class Device extends _actor2.default {
  /**
   * Returns general info about browser an OS, e.g.
   * Example:
   * {
   *     appid: '{ec8030f7-c20a-464f-9b0e-13a3a9e97384}',
   *     apptype: 'firefox',
   *     vendor: 'Mozilla',
   *     name: 'Firefox',
   *     version: '55.0.2',
   *     appbuildid: '20170814073321',
   *     changeset: '45ab6e362747102d00fd75378727fcddcfd35f44',
   *     platformbuildid: '20170814073321',
   *     geckobuildid: '20170814073321',
   *     platformversion: '55.0.2',
   *     geckoversion: '55.0.2',
   *     locale: 'de',
   *     endianness: 'LE',
   *     hostname: 'Christian-Bromann-NAT',
   *     os: 'Darwin',
   *     platform: 'Darwin',
   *     hardware: 'unknown',
   *     arch: 'x86_64',
   *     processor: 'x86_64',
   *     compiler: 'gcc3',
   *     profile: 'firefox_dev_profile-BhzvUp',
   *     channel: 'release',
   *     dpi: 258,
   *     useragent: 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:55.0) Gecko/20100101 Firefox/55.0',
   *     width: 2560,
   *     height: 1440,
   *     physicalWidth: 2560,
   *     physicalHeight: 1440,
   *     brandName: 'Mozilla Firefox'
   * }
   *
   * @return {Promise.<Object>}    request object (see example)
   */
  async getDescription() {
    const {
      value
    } = await this.request('getDescription');
    return value;
  }
  /**
   * get Firefox wallpaper
   *
   * @return {Promise.<Object>}    request object (see example)
   */


  async getWallpaper() {
    const {
      value
    } = await this.request('getWallpaper');
    return value;
  }
  /**
   * Returns base64 data url string of the browser screenshot
   *
   * @return {Promise.<Object>}    request object (see example)
   */


  async screenshotToDataURL() {
    const {
      value
    } = await this.request('screenshotToDataURL');
    const imageBlob = new _longString2.default(this.client, value.actor);
    return imageBlob.substring(0, value.length);
  }
  /**
   * Saves browser screenshot to file
   *
   * @param  {String}  path of image file to save the screenshot to (should be PNG)
   * @return {Promise}      resolves once image is written
   */


  async screenshotToFile(path) {
    const dataUrl = await this.screenshotToDataURL();
    return new Promise((resolve, reject) => _fs2.default.writeFile(path, dataUrl.substr(dataURLPreamble.length), 'base64', err => {
      /* istanbul ignore next */
      if (err) {
        return reject(err);
      }

      return resolve();
    }));
  }

}

exports.default = Device;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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