"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Addons actor allows to handle addons in Firefox
 */
class Addons extends _actor2.default {
  /**
   * install temporary addon
   * @param  {String}  addonPath  path to the add on
   * @return {Promise.<Object>}   addon data
   */
  async installTemporaryAddon(addonPath) {
    const {
      addon
    } = this.request('installTemporaryAddon', {
      addonPath
    });
    return addon;
  }

}

exports.default = Addons;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi9kb21haW5zL2FkZG9ucy5qcyJdLCJuYW1lcyI6WyJBZGRvbnMiLCJBY3RvciIsImluc3RhbGxUZW1wb3JhcnlBZGRvbiIsImFkZG9uUGF0aCIsImFkZG9uIiwicmVxdWVzdCJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7Ozs7OztBQUVBOzs7QUFHZSxNQUFNQSxNQUFOLFNBQXFCQyxlQUFyQixDQUEyQjtBQUN0Qzs7Ozs7QUFLQSxRQUFNQyxxQkFBTixDQUE2QkMsU0FBN0IsRUFBd0M7QUFDcEMsVUFBTTtBQUFFQyxNQUFBQTtBQUFGLFFBQVksS0FBS0MsT0FBTCxDQUFhLHVCQUFiLEVBQXNDO0FBQUVGLE1BQUFBO0FBQUYsS0FBdEMsQ0FBbEI7QUFDQSxXQUFPQyxLQUFQO0FBQ0g7O0FBVHFDOztrQkFBckJKLE0iLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgQWN0b3IgZnJvbSAnLi4vYWN0b3InXHJcblxyXG4vKipcclxuICogQWRkb25zIGFjdG9yIGFsbG93cyB0byBoYW5kbGUgYWRkb25zIGluIEZpcmVmb3hcclxuICovXHJcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEFkZG9ucyBleHRlbmRzIEFjdG9yIHtcclxuICAgIC8qKlxyXG4gICAgICogaW5zdGFsbCB0ZW1wb3JhcnkgYWRkb25cclxuICAgICAqIEBwYXJhbSAge1N0cmluZ30gIGFkZG9uUGF0aCAgcGF0aCB0byB0aGUgYWRkIG9uXHJcbiAgICAgKiBAcmV0dXJuIHtQcm9taXNlLjxPYmplY3Q+fSAgIGFkZG9uIGRhdGFcclxuICAgICAqL1xyXG4gICAgYXN5bmMgaW5zdGFsbFRlbXBvcmFyeUFkZG9uIChhZGRvblBhdGgpIHtcclxuICAgICAgICBjb25zdCB7IGFkZG9uIH0gPSB0aGlzLnJlcXVlc3QoJ2luc3RhbGxUZW1wb3JhcnlBZGRvbicsIHsgYWRkb25QYXRoIH0pXHJcbiAgICAgICAgcmV0dXJuIGFkZG9uXHJcbiAgICB9XHJcbn1cclxuIl19