"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

var _actorActor = require("../models/actorActor");

var _actorActor2 = _interopRequireDefault(_actorActor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * The ActorRegistryActor allows clients to define new actors on the
 * server. This is particularly useful for addons.
 */
class ActorRegistry extends _actor2.default {
  /**
   * register actor to registry
   *
   * @param  {String}  sourceText  source text of actor
   * @param  {String}  filename    file name of actor
   * @param  {Object}  options     actor options
   * @return {Promise}             resolves once request has finished
   */
  async registerActor(sourceText, filename, options) {
    const {
      actorActor
    } = this.request('registerActor', {
      sourceText,
      filename,
      options
    });
    return new _actorActor2.default(this.client, actorActor);
  }

}

exports.default = ActorRegistry;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi9kb21haW5zL2FjdG9yUmVnaXN0cnkuanMiXSwibmFtZXMiOlsiQWN0b3JSZWdpc3RyeSIsIkFjdG9yIiwicmVnaXN0ZXJBY3RvciIsInNvdXJjZVRleHQiLCJmaWxlbmFtZSIsIm9wdGlvbnMiLCJhY3RvckFjdG9yIiwicmVxdWVzdCIsIkFjdG9yQWN0b3IiLCJjbGllbnQiXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7OztBQUVBOzs7O0FBSWUsTUFBTUEsYUFBTixTQUE0QkMsZUFBNUIsQ0FBa0M7QUFDN0M7Ozs7Ozs7O0FBUUEsUUFBTUMsYUFBTixDQUFxQkMsVUFBckIsRUFBaUNDLFFBQWpDLEVBQTJDQyxPQUEzQyxFQUFvRDtBQUNoRCxVQUFNO0FBQUVDLE1BQUFBO0FBQUYsUUFBaUIsS0FBS0MsT0FBTCxDQUFhLGVBQWIsRUFBOEI7QUFBRUosTUFBQUEsVUFBRjtBQUFjQyxNQUFBQSxRQUFkO0FBQXdCQyxNQUFBQTtBQUF4QixLQUE5QixDQUF2QjtBQUNBLFdBQU8sSUFBSUcsb0JBQUosQ0FBZSxLQUFLQyxNQUFwQixFQUE0QkgsVUFBNUIsQ0FBUDtBQUNIOztBQVo0Qzs7a0JBQTVCTixhIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IEFjdG9yIGZyb20gJy4uL2FjdG9yJ1xyXG5pbXBvcnQgQWN0b3JBY3RvciBmcm9tICcuLi9tb2RlbHMvYWN0b3JBY3RvcidcclxuXHJcbi8qXHJcbiAqIFRoZSBBY3RvclJlZ2lzdHJ5QWN0b3IgYWxsb3dzIGNsaWVudHMgdG8gZGVmaW5lIG5ldyBhY3RvcnMgb24gdGhlXHJcbiAqIHNlcnZlci4gVGhpcyBpcyBwYXJ0aWN1bGFybHkgdXNlZnVsIGZvciBhZGRvbnMuXHJcbiAqL1xyXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBBY3RvclJlZ2lzdHJ5IGV4dGVuZHMgQWN0b3Ige1xyXG4gICAgLyoqXHJcbiAgICAgKiByZWdpc3RlciBhY3RvciB0byByZWdpc3RyeVxyXG4gICAgICpcclxuICAgICAqIEBwYXJhbSAge1N0cmluZ30gIHNvdXJjZVRleHQgIHNvdXJjZSB0ZXh0IG9mIGFjdG9yXHJcbiAgICAgKiBAcGFyYW0gIHtTdHJpbmd9ICBmaWxlbmFtZSAgICBmaWxlIG5hbWUgb2YgYWN0b3JcclxuICAgICAqIEBwYXJhbSAge09iamVjdH0gIG9wdGlvbnMgICAgIGFjdG9yIG9wdGlvbnNcclxuICAgICAqIEByZXR1cm4ge1Byb21pc2V9ICAgICAgICAgICAgIHJlc29sdmVzIG9uY2UgcmVxdWVzdCBoYXMgZmluaXNoZWRcclxuICAgICAqL1xyXG4gICAgYXN5bmMgcmVnaXN0ZXJBY3RvciAoc291cmNlVGV4dCwgZmlsZW5hbWUsIG9wdGlvbnMpIHtcclxuICAgICAgICBjb25zdCB7IGFjdG9yQWN0b3IgfSA9IHRoaXMucmVxdWVzdCgncmVnaXN0ZXJBY3RvcicsIHsgc291cmNlVGV4dCwgZmlsZW5hbWUsIG9wdGlvbnMgfSlcclxuICAgICAgICByZXR1cm4gbmV3IEFjdG9yQWN0b3IodGhpcy5jbGllbnQsIGFjdG9yQWN0b3IpXHJcbiAgICB9XHJcbn1cclxuIl19