import { __assign } from "tslib";
import Path from 'path';
import { computeSha1 } from './sha1';
import { DiskCache } from './cache';
import { debug } from './debug-log';
var pkg = require('../package');
export default create;
export function create(opts) {
    if (opts === void 0) { opts = {}; }
    var _a = opts.compiler, compiler = _a === void 0 ? require('typescript') : _a, _b = opts.cachePath, cachePath = _b === void 0 ? Path.resolve(process.env.TS_CACHED_TRANSPILE_CACHE || Path.resolve(__dirname, '../.cache')) : _b;
    var diskCache = new DiskCache(cachePath);
    var transpileModule = function (input, transpileOptions) {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        var canCache = true;
        // Decide if we cannot cache for various reasons
        if (transpileOptions.renamedDependencies) {
            canCache = false;
        }
        else if (((_b = (_a = transpileOptions.transformers) === null || _a === void 0 ? void 0 : _a.after) === null || _b === void 0 ? void 0 : _b.length) || ((_d = (_c = transpileOptions.transformers) === null || _c === void 0 ? void 0 : _c.before) === null || _d === void 0 ? void 0 : _d.length) || ((_f = (_e = transpileOptions.transformers) === null || _e === void 0 ? void 0 : _e.afterDeclarations) === null || _f === void 0 ? void 0 : _f.length)) {
            canCache = false;
        }
        var outputTextCacheKey;
        var sourceMapCacheKey;
        if (canCache) {
            // compute cache keys
            var config = __assign({ selfVersion: pkg.version, typescriptVersion: compiler.version }, transpileOptions.compilerOptions);
            var configSha1 = computeSha1(Buffer.from(JSON.stringify(config), 'utf8'));
            var codeSha1 = computeSha1(Buffer.from(transpileOptions.fileName || '', 'utf8'), Buffer.from(input, 'utf8'));
            var key = configSha1 + codeSha1;
            outputTextCacheKey = key + '-outputText';
            sourceMapCacheKey = key + '-outputSourceMap';
            // try loading from cache
            var cachedOutputText = diskCache.get(outputTextCacheKey);
            var cachedSourceMapText = cachedOutputText ? diskCache.get(sourceMapCacheKey) : null;
            debug({
                message: 'attempted to load from cache',
                canCache: canCache, fileName: transpileOptions.fileName, outputTextCacheKey: outputTextCacheKey, sourceMapCacheKey: sourceMapCacheKey
            });
            // if found in cache, return cached results
            if (cachedOutputText && cachedSourceMapText) {
                return {
                    outputText: cachedOutputText.toString('utf8'),
                    sourceMapText: cachedSourceMapText.toString('utf8'),
                    diagnostics: []
                };
            }
        }
        // not found in cache; call compiler
        var _j = compiler.transpileModule(input, transpileOptions), outputText = _j.outputText, diagnostics = _j.diagnostics, sourceMapText = _j.sourceMapText;
        debug({
            message: 'called the compiler',
            canCache: canCache, fileName: transpileOptions.fileName, outputTextLength: outputText.length, diagnostics: diagnostics, sourceMapTextLength: (_g = sourceMapText) === null || _g === void 0 ? void 0 : _g.length
        });
        // if results can be cached
        if (canCache && outputText && sourceMapText && !((_h = diagnostics) === null || _h === void 0 ? void 0 : _h.length)) {
            // save to cache
            debug('saving to cache');
            diskCache.set(outputTextCacheKey, outputText);
            diskCache.set(sourceMapCacheKey, sourceMapText);
        }
        else {
            debug('cannot save cache');
        }
        // return result from compiler
        return { outputText: outputText, diagnostics: diagnostics, sourceMapText: sourceMapText };
    };
    var ret = __assign(__assign({}, compiler), { transpileModule: transpileModule });
    return ret;
}
//# sourceMappingURL=create.mjs.map