import { stringifyVariables as e, createRequest as t, formatDocument as r, makeOperation as i } from "@urql/core";

import { share as n, merge as a, mergeMap as o, fromArray as s, buffer as u, fromPromise as c, skipUntil as l, map as d, filter as f, empty as p, makeSubject as v } from "wonka";

import { _ as y } from "./5301ccd2.mjs";

import { Kind as m } from "graphql/language/kinds.mjs";

import { valueFromASTUntyped as h } from "graphql/utilities/valueFromASTUntyped.mjs";

import { print as g } from "graphql/language/printer.mjs";

function getName(e) {
  return e.name.value;
}

function getFragmentTypeName(e) {
  return e.typeCondition.name.value;
}

function getFieldAlias(e) {
  return e.alias ? e.alias.value : getName(e);
}

function getSelectionSet(e) {
  return e.selectionSet ? e.selectionSet.selections : [];
}

function getTypeCondition(e) {
  return e.typeCondition ? getName(e.typeCondition) : null;
}

function isFieldNode(e) {
  return e.kind === m.FIELD;
}

function isInlineFragment(e) {
  return e.kind === m.INLINE_FRAGMENT;
}

function getFieldArguments(e, t) {
  var r = {};
  var i = 0;
  if (e.arguments && e.arguments.length) {
    for (var n = 0, a = e.arguments.length; n < a; n++) {
      var o = e.arguments[n];
      var s = h(o.value, t);
      if (null != s) {
        r[getName(o)] = s;
        i++;
      }
    }
  }
  return i > 0 ? r : null;
}

function filterVariables(e, t) {
  if (!t || !e.variableDefinitions) {
    return;
  }
  var r = {};
  for (var i = 0, n = e.variableDefinitions.length; i < n; i++) {
    var a = getName(e.variableDefinitions[i].variable);
    r[a] = t[a];
  }
  return r;
}

function normalizeVariables(e, t) {
  var r = {};
  if (!t) {
    return r;
  }
  if (e.variableDefinitions) {
    for (var i = 0, n = e.variableDefinitions.length; i < n; i++) {
      var a = e.variableDefinitions[i];
      var o = getName(a.variable);
      r[o] = void 0 === t[o] && a.defaultValue ? h(a.defaultValue, t) : t[o];
    }
  }
  for (var s in t) {
    if (!(s in r)) {
      r[s] = t[s];
    }
  }
  return r;
}

var N = "\nhttps://bit.ly/2XbVrpR#";

var k = new Set;

var O = [];

function popDebugNode() {
  return O.pop();
}

function pushDebugNode(e, t) {
  var r = "";
  if (t.kind === m.INLINE_FRAGMENT) {
    r = e ? 'Inline Fragment on "' + e + '"' : "Inline Fragment";
  } else if (t.kind === m.OPERATION_DEFINITION) {
    r = (t.name ? '"' + t.name.value + '"' : "Unnamed") + " " + t.operation;
  } else if (t.kind === m.FRAGMENT_DEFINITION) {
    r = '"' + t.name.value + '" Fragment';
  }
  if (r) {
    O.push(r);
  }
}

function getDebugOutput() {
  return O.length ? "\n(Caused At: " + O.join(", ") + ")" : "";
}

function invariant(e, t, r) {
  if (!e) {
    var i = t || "Minfied Error #" + r + "\n";
    if ("production" !== process.env.NODE_ENV) {
      i += getDebugOutput();
    }
    var n = new Error(i + N + r);
    n.name = "Graphcache Error";
    throw n;
  }
}

function warn(e, t) {
  if (!k.has(e)) {
    console.warn(e + getDebugOutput() + N + t);
    k.add(e);
  }
}

function getMainOperation(e) {
  for (var t = 0; t < e.definitions.length; t++) {
    if (e.definitions[t].kind === m.OPERATION_DEFINITION) {
      return e.definitions[t];
    }
  }
  invariant(!1, "production" !== process.env.NODE_ENV ? "Invalid GraphQL document: All GraphQL documents must contain an OperationDefinitionnode for a query, subscription, or mutation." : "", 1);
}

function getFragments(e) {
  var t = {};
  for (var r = 0; r < e.definitions.length; r++) {
    var i = e.definitions[r];
    if (i.kind === m.FRAGMENT_DEFINITION) {
      t[getName(i)] = i;
    }
  }
  return t;
}

function shouldInclude(e, t) {
  for (var r = 0; e.directives && r < e.directives.length; r++) {
    var i = e.directives[r];
    var n = getName(i);
    if (("include" === n || "skip" === n) && i.arguments && i.arguments[0] && "if" === getName(i.arguments[0])) {
      var a = h(i.arguments[0].value, t);
      return "include" === n ? !!a : !a;
    }
  }
  return !0;
}

function isDeferred(e, t) {
  for (var r = 0; e.directives && r < e.directives.length; r++) {
    var i = e.directives[r];
    if ("defer" === getName(i)) {
      for (var n = 0; i.arguments && n < i.arguments.length; n++) {
        var a = i.arguments[r];
        if ("if" === getName(a)) {
          return !!h(a.value, t);
        }
      }
      return !0;
    }
  }
  return !1;
}

function isFieldNullable(e, t, r) {
  var i = getField(e, t, r);
  return !!i && "NON_NULL" !== i.type.kind;
}

function isListNullable(e, t, r) {
  var i = getField(e, t, r);
  if (!i) {
    return !1;
  }
  var n = "NON_NULL" === i.type.kind ? i.type.ofType : i.type;
  return "LIST" === n.kind && "NON_NULL" !== n.ofType.kind;
}

function isFieldAvailableOnType(e, t, r) {
  return 0 === r.indexOf("__") || 0 === t.indexOf("__") || !!getField(e, t, r);
}

function isInterfaceOfType(e, t, r) {
  if (!r) {
    return !1;
  }
  var i = getTypeCondition(t);
  if (!i || r === i) {
    return !0;
  } else if (e.types[i] && "OBJECT" === e.types[i].kind) {
    return i === r;
  }
  !function expectAbstractType(e, t) {
    invariant(e.types[t] && ("INTERFACE" === e.types[t].kind || "UNION" === e.types[t].kind), "production" !== process.env.NODE_ENV ? "Invalid Abstract type: The type `" + t + "` is not an Interface or Union type in the defined schema, but a fragment in the GraphQL document is using it as a type condition." : "", 5);
  }(e, i);
  expectObjectType(e, r);
  return e.isSubType(i, r);
}

function getField(e, t, r) {
  if (0 === r.indexOf("__") || 0 === t.indexOf("__")) {
    return;
  }
  expectObjectType(e, t);
  var i = e.types[t].fields[r];
  if ("production" !== process.env.NODE_ENV) {
    if (!i) {
      warn("Invalid field: The field `" + r + "` does not exist on `" + t + "`, but the GraphQL document expects it to exist.\nTraversal will continue, however this may lead to undefined behavior!", 4);
    }
  }
  return i;
}

function expectObjectType(e, t) {
  invariant(e.types[t] && "OBJECT" === e.types[t].kind, "production" !== process.env.NODE_ENV ? "Invalid Object type: The type `" + t + "` is not an object in the defined schema, but the GraphQL document is traversing it." : "", 3);
}

function warnAboutResolver(e) {
  "production" !== process.env.NODE_ENV && warn("Invalid resolver: `" + e + "` is not in the defined schema, but the `resolvers` option is referencing it.", 23);
}

function keyOfField(t, r) {
  return r ? t + "(" + e(r) + ")" : t;
}

function joinKeys(e, t) {
  return e + "." + t;
}

function fieldInfoOfKey(e) {
  var t = e.indexOf("(");
  if (t > -1) {
    return {
      fieldKey: e,
      fieldName: e.slice(0, t),
      arguments: JSON.parse(e.slice(t + 1, -1))
    };
  } else {
    return {
      fieldKey: e,
      fieldName: e,
      arguments: null
    };
  }
}

function deserializeKeyInfo(e) {
  var t = e.indexOf(".");
  return {
    entityKey: e.slice(0, t).replace(/%2e/g, "."),
    fieldKey: e.slice(t + 1)
  };
}

function makeDict() {
  return Object.create(null);
}

var _ = null;

var E = null;

var b = null;

var D = null;

var w = null;

var F = null;

var S = !1;

function makeNodeMap() {
  return {
    optimistic: makeDict(),
    base: new Map
  };
}

function makeData(e) {
  var t;
  if (e) {
    if (_.has(e)) {
      return e;
    }
    t = E.get(e) || y({}, e);
    E.set(e, t);
  } else {
    t = {};
  }
  _.add(t);
  return t;
}

function ownsData(e) {
  return !!e && _.has(e);
}

function initDataState(e, t, r, i) {
  _ = new Set;
  E = new Map;
  b = e;
  D = t;
  w = makeDict();
  S = !!i;
  if ("production" !== process.env.NODE_ENV) {
    O.length = 0;
  }
  if (!r) {
    F = null;
  } else if (i || t.optimisticOrder.length > 0) {
    if (!i && !t.commutativeKeys.has(r)) {
      reserveLayer(t, r);
    } else if (i) {
      t.commutativeKeys.delete(r);
    }
    F = r;
    !function createLayer(e, t) {
      if (-1 === e.optimisticOrder.indexOf(t)) {
        e.optimisticOrder.unshift(t);
      }
      if (!e.refLock[t]) {
        e.refLock[t] = makeDict();
        e.links.optimistic[t] = new Map;
        e.records.optimistic[t] = new Map;
      }
    }(t, r);
  } else {
    F = null;
    deleteLayer(t, r);
  }
}

function clearDataState() {
  if ("production" !== process.env.NODE_ENV) {
    getCurrentDependencies();
  }
  var t = D;
  var r = F;
  S = !1;
  F = null;
  if (r && t.optimisticOrder.indexOf(r) > -1) {
    var i = t.optimisticOrder.length;
    while (--i >= 0 && t.refLock[t.optimisticOrder[i]] && t.commutativeKeys.has(t.optimisticOrder[i]) && !t.deferredKeys.has(t.optimisticOrder[i])) {
      squashLayer(t.optimisticOrder[i]);
    }
  }
  _ = null;
  E = null;
  b = null;
  D = null;
  w = null;
  if ("production" !== process.env.NODE_ENV) {
    O.length = 0;
  }
  if ("test" !== process.env.NODE_ENV && !t.defer) {
    t.defer = !0;
    Promise.resolve().then((function() {
      initDataState("read", t, null);
      !function gc() {
        D.gc.forEach((function(e, t, r) {
          if ((D.refCount[e] || 0) > 0) {
            r.delete(e);
            return;
          }
          for (var i in D.refLock) {
            var n = D.refLock[i];
            if ((n[e] || 0) > 0) {
              return;
            }
            delete n[e];
          }
          delete D.refCount[e];
          r.delete(e);
          D.records.base.delete(e);
          var a = D.links.base.get(e);
          if (a) {
            D.links.base.delete(e);
            for (var o in a) {
              updateRCForLink(r, D.refCount, a[o], -1);
            }
          }
        }));
      }();
      !function persistData() {
        if (D.storage) {
          S = !0;
          b = "read";
          var t = makeDict();
          D.persist.forEach((function(r) {
            var i = deserializeKeyInfo(r);
            var n = i.entityKey;
            var a = i.fieldKey;
            var o;
            if (void 0 !== (o = readLink(n, a))) {
              t[r] = ":" + e(o);
            } else if (void 0 !== (o = readRecord(n, a))) {
              t[r] = e(o);
            } else {
              t[r] = void 0;
            }
          }));
          S = !1;
          D.storage.writeData(t);
          D.persist.clear();
        }
      }();
      clearDataState();
      t.defer = !1;
    }));
  }
}

function noopDataState(e, t, r) {
  if (t && !r) {
    e.deferredKeys.delete(t);
  }
  initDataState("read", e, t, r);
  clearDataState();
}

function getCurrentOperation() {
  invariant(null !== b, "production" !== process.env.NODE_ENV ? "Invalid Cache call: The cache may only be accessed or mutated duringoperations like write or query, or as part of its resolvers, updaters, or optimistic configs." : "", 2);
  return b;
}

function getCurrentDependencies() {
  invariant(null !== w, "production" !== process.env.NODE_ENV ? "Invalid Cache call: The cache may only be accessed or mutated duringoperations like write or query, or as part of its resolvers, updaters, or optimistic configs." : "", 2);
  return w;
}

function setNode(e, t, r, i) {
  var n = F ? e.optimistic[F] : e.base;
  var a = n.get(t);
  if (void 0 === a) {
    n.set(t, a = makeDict());
  }
  if (void 0 === i && !F) {
    delete a[r];
  } else {
    a[r] = i;
  }
}

function getNode(e, t, r) {
  var i;
  var n = !S && "read" === b && F && D.commutativeKeys.has(F);
  for (var a = 0, o = D.optimisticOrder.length; a < o; a++) {
    var s = D.optimisticOrder[a];
    var u = e.optimistic[s];
    n = n && s !== F;
    if (u && (!n || !D.commutativeKeys.has(s)) && (!S || "write" === b || D.commutativeKeys.has(s)) && void 0 !== (i = u.get(t)) && r in i) {
      return i[r];
    }
  }
  return void 0 !== (i = e.base.get(t)) ? i[r] : void 0;
}

function updateRCForEntity(e, t, r, i) {
  var n = void 0 !== t[r] ? t[r] : 0;
  var a = t[r] = n + i | 0;
  if (void 0 !== e) {
    if (a <= 0) {
      e.add(r);
    } else if (n <= 0 && a > 0) {
      e.delete(r);
    }
  }
}

function updateRCForLink(e, t, r, i) {
  if ("string" == typeof r) {
    updateRCForEntity(e, t, r, i);
  } else if (Array.isArray(r)) {
    for (var n = 0, a = r.length; n < a; n++) {
      if (Array.isArray(r[n])) {
        updateRCForLink(e, t, r[n], i);
      } else if (r[n]) {
        updateRCForEntity(e, t, r[n], i);
      }
    }
  }
}

function extractNodeFields(e, t, r) {
  if (void 0 !== r) {
    for (var i in r) {
      if (!t.has(i)) {
        e.push(fieldInfoOfKey(i));
        t.add(i);
      }
    }
  }
}

function extractNodeMapFields(e, t, r, i) {
  extractNodeFields(e, t, i.base.get(r));
  for (var n = 0, a = D.optimisticOrder.length; n < a; n++) {
    var o = i.optimistic[D.optimisticOrder[n]];
    if (void 0 !== o) {
      extractNodeFields(e, t, o.get(r));
    }
  }
}

function updateDependencies(e, t) {
  if ("__typename" !== t) {
    if (e !== D.queryRootKey) {
      w[e] = !0;
    } else if (void 0 !== t) {
      w[joinKeys(e, t)] = !0;
    }
  }
}

function updatePersist(e, t) {
  if (!S && D.storage) {
    D.persist.add(function serializeKeys(e, t) {
      return e.replace(/\./g, "%2e") + "." + t;
    }(e, t));
  }
}

function readRecord(e, t) {
  updateDependencies(e, t);
  return getNode(D.records, e, t);
}

function readLink(e, t) {
  updateDependencies(e, t);
  return getNode(D.links, e, t);
}

function writeRecord(e, t, r) {
  updateDependencies(e, t);
  updatePersist(e, t);
  setNode(D.records, e, t, r);
}

function writeLink(e, t, r) {
  var i = D;
  var n;
  var a;
  var o;
  if (F) {
    n = i.refLock[F] || (i.refLock[F] = makeDict());
    a = i.links.optimistic[F];
  } else {
    n = i.refCount;
    a = i.links.base;
    o = i.gc;
  }
  var s = a && a.get(e);
  var u = s && s[t];
  updateDependencies(e, t);
  updatePersist(e, t);
  setNode(i.links, e, t, r);
  updateRCForLink(o, n, u, -1);
  updateRCForLink(o, n, r, 1);
}

function reserveLayer(e, t, r) {
  var i = e.optimisticOrder.indexOf(t);
  if (-1 === i) {
    e.optimisticOrder.unshift(t);
  } else if (!e.commutativeKeys.has(t)) {
    clearLayer(e, t);
    e.optimisticOrder.splice(i, 1);
    e.optimisticOrder.unshift(t);
  }
  if (r) {
    e.deferredKeys.add(t);
  } else {
    e.deferredKeys.delete(t);
  }
  e.commutativeKeys.add(t);
}

function clearLayer(e, t) {
  if (e.refLock[t]) {
    delete e.refLock[t];
    delete e.records.optimistic[t];
    delete e.links.optimistic[t];
    e.deferredKeys.delete(t);
  }
}

function deleteLayer(e, t) {
  var r = e.optimisticOrder.indexOf(t);
  if (r > -1) {
    e.optimisticOrder.splice(r, 1);
    e.commutativeKeys.delete(t);
  }
  clearLayer(e, t);
}

function squashLayer(e) {
  var t = w;
  w = makeDict();
  var r = D.links.optimistic[e];
  if (r) {
    r.forEach((function(e, t) {
      for (var r in e) {
        writeLink(t, r, e[r]);
      }
    }));
  }
  var i = D.records.optimistic[e];
  if (i) {
    i.forEach((function(e, t) {
      for (var r in e) {
        writeRecord(t, r, e[r]);
      }
    }));
  }
  w = t;
  deleteLayer(D, e);
}

function inspectFields(e) {
  var t = D.links;
  var r = D.records;
  var i = [];
  var n = new Set;
  updateDependencies(e);
  extractNodeMapFields(i, n, e, t);
  extractNodeMapFields(i, n, e, r);
  return i;
}

var L = {
  current: null
};

var x = {
  current: !1
};

function getFieldError(e) {
  return e.__internal.path.length > 0 && e.__internal.errorMap ? e.__internal.errorMap[e.__internal.path.join(".")] : void 0;
}

function makeContext(e, t, r, i, n, a, o) {
  var s = {
    store: e,
    variables: t,
    fragments: r,
    parent: {
      __typename: i
    },
    parentTypeName: i,
    parentKey: n,
    parentFieldKey: "",
    fieldName: "",
    error: void 0,
    partial: !1,
    optimistic: !!a,
    __internal: {
      path: [],
      errorMap: void 0
    }
  };
  if (o && o.graphQLErrors) {
    for (var u = 0; u < o.graphQLErrors.length; u++) {
      var c = o.graphQLErrors[u];
      if (c.path && c.path.length) {
        if (!s.__internal.errorMap) {
          s.__internal.errorMap = Object.create(null);
        }
        s.__internal.errorMap[c.path.join(".")] = c;
      }
    }
  }
  return s;
}

function updateContext(e, t, r, i, n, a) {
  L.current = e;
  e.parent = t;
  e.parentTypeName = r;
  e.parentKey = i;
  e.parentFieldKey = n;
  e.fieldName = a;
  e.error = getFieldError(e);
}

function isFragmentHeuristicallyMatching(e, t, r, i) {
  if (!t) {
    return !1;
  }
  var n = getTypeCondition(e);
  if (!n || t === n) {
    return !0;
  }
  "production" !== process.env.NODE_ENV && warn("Heuristic Fragment Matching: A fragment is trying to match against the `" + t + "` type, but the type condition is `" + n + "`. Since GraphQL allows for interfaces `" + n + "` may be aninterface.\nA schema needs to be defined for this match to be deterministic, otherwise the fragment will be matched heuristically!", 16);
  return !getSelectionSet(e).some((function(e) {
    if (!isFieldNode(e)) {
      return !1;
    }
    var t = keyOfField(getName(e), getFieldArguments(e, i));
    return !function hasField(e, t) {
      return void 0 !== readRecord(e, t) || void 0 !== readLink(e, t);
    }(r, t);
  }));
}

function makeSelectionIterator(e, t, r, i) {
  var n = !1;
  var a;
  var o = 0;
  return function next() {
    if (!x.current && n) {
      x.current = n;
    }
    if (a) {
      var s = a();
      if (null != s) {
        return s;
      }
      a = void 0;
      n = !1;
      if ("production" !== process.env.NODE_ENV) {
        popDebugNode();
      }
    }
    while (o < r.length) {
      var u = r[o++];
      if (!shouldInclude(u, i.variables)) {
        continue;
      } else if (!isFieldNode(u)) {
        var c = !isInlineFragment(u) ? i.fragments[getName(u)] : u;
        if (void 0 !== c) {
          if (i.store.schema ? isInterfaceOfType(i.store.schema, c, e) : isFragmentHeuristicallyMatching(c, e, t, i.variables)) {
            if ("production" !== process.env.NODE_ENV) {
              pushDebugNode(e, c);
            }
            n = !!isDeferred(u, i.variables);
            if (!x.current && n) {
              x.current = n;
            }
            return (a = makeSelectionIterator(e, t, getSelectionSet(c), i))();
          }
        }
      } else {
        return u;
      }
    }
  };
}

function ensureData(e) {
  return null == e ? null : e;
}

function ensureLink(e, t) {
  if (null == t) {
    return t;
  } else if (Array.isArray(t)) {
    var r = new Array(t.length);
    for (var i = 0, n = r.length; i < n; i++) {
      r[i] = ensureLink(e, t[i]);
    }
    return r;
  }
  var a = e.keyOfEntity(t);
  if ("production" !== process.env.NODE_ENV) {
    if (!a && t && "object" == typeof t) {
      warn("Can't generate a key for link(...) item.\nYou have to pass an `id` or `_id` field or create a custom `keys` config for `" + t.__typename + "`.", 12);
    }
  }
  return a;
}

function write(e, t, r, i, n) {
  initDataState("write", e.data, n || null);
  var a = startWrite(e, t, r, i);
  clearDataState();
  return a;
}

function startWrite(e, t, r, i, n) {
  var a = getMainOperation(t.query);
  var o = {
    data: r,
    dependencies: getCurrentDependencies()
  };
  var s = e.rootFields[a.operation];
  var u = makeContext(e, normalizeVariables(a, t.variables), getFragments(t.query), s, s, !!n, i);
  if ("production" !== process.env.NODE_ENV) {
    pushDebugNode(s, a);
  }
  writeSelection(u, s, getSelectionSet(a), r);
  if ("production" !== process.env.NODE_ENV) {
    popDebugNode();
  }
  return o;
}

function writeSelection(e, t, r, i) {
  var n = t === e.store.rootFields.query;
  var a = !n && !!e.store.rootNames[t];
  var o = a || n ? t : i.__typename;
  if (!o) {
    "production" !== process.env.NODE_ENV && warn("Couldn't find __typename when writing.\nIf you're writing to the cache manually have to pass a `__typename` property on each entity in your data.", 14);
    return;
  } else if (!a && !n && t) {
    writeRecord(t, "__typename", o);
  }
  var s = makeSelectionIterator(o, t || o, r, e);
  var u;
  while (u = s()) {
    var c = getName(u);
    var l = getFieldArguments(u, e.variables);
    var d = keyOfField(c, l);
    var f = getFieldAlias(u);
    var p = i[f];
    if ("production" !== process.env.NODE_ENV) {
      if (!a && void 0 === p && !x.current) {
        "production" !== process.env.NODE_ENV && warn("Invalid undefined: The field at `" + d + "` is `undefined`, but the GraphQL query expects a " + (void 0 === u.selectionSet ? "scalar (number, boolean, etc)" : "selection set") + " for this field." + (e.optimistic ? "\nYour optimistic result may be missing a field!" : ""), 13);
        continue;
      } else if (e.store.schema && o && "__typename" !== c) {
        isFieldAvailableOnType(e.store.schema, o, c);
      }
    }
    if ("__typename" === c || void 0 === p && x.current) {
      continue;
    }
    e.__internal.path.push(f);
    if (e.optimistic && a) {
      var v = e.store.optimisticMutations[c];
      if (!v) {
        continue;
      }
      updateContext(e, i, o, o, d, c);
      p = i[f] = ensureData(v(l || {}, e.store, e));
    }
    if (u.selectionSet) {
      if (t && !a) {
        var y = joinKeys(t, d);
        writeLink(t || o, d, writeField(e, getSelectionSet(u), ensureData(p), y));
      } else {
        writeField(e, getSelectionSet(u), ensureData(p));
      }
    } else if (t && !a) {
      writeRecord(t || o, d, null !== p || !getFieldError(e) ? p : void 0);
    }
    if (a) {
      var m = e.store.updates[o][c];
      if (m) {
        updateContext(e, i, o, o, joinKeys(o, d), c);
        i[c] = p;
        m(i, l || {}, e.store, e);
      }
    }
    e.__internal.path.pop();
  }
}

var q = /^__|PageInfo|(Connection|Edge)$/;

function writeField(e, t, r, i) {
  if (Array.isArray(r)) {
    var n = new Array(r.length);
    for (var a = 0, o = r.length; a < o; a++) {
      e.__internal.path.push(a);
      var s = i ? joinKeys(i, "" + a) : void 0;
      var u = writeField(e, t, r[a], s);
      n[a] = u;
      e.__internal.path.pop();
    }
    return n;
  } else if (null === r) {
    return getFieldError(e) ? void 0 : null;
  }
  var c = e.store.keyOfEntity(r);
  var l = r.__typename;
  if ("production" !== process.env.NODE_ENV) {
    if (i && !e.store.keys[r.__typename] && null === c && "string" == typeof l && !q.test(l)) {
      warn("Invalid key: The GraphQL query at the field at `" + i + "` has a selection set, but no key could be generated for the data at this field.\nYou have to request `id` or `_id` fields for all selection sets or create a custom `keys` config for `" + l + "`.\nEntities without keys will be embedded directly on the parent entity. If this is intentional, create a `keys` config for `" + l + "` that always returns null.", 15);
    }
  }
  var d = c || i;
  writeSelection(e, d, t, r);
  return d || null;
}

function Store(e) {
  var t, r;
  this.keyOfField = keyOfField;
  this.resolveFieldByKey = this.resolve;
  if (!e) {
    e = {};
  }
  this.resolvers = e.resolvers || {};
  this.optimisticMutations = e.optimistic || {};
  this.keys = e.keys || {};
  var i = "Query";
  var n = "Mutation";
  var a = "Subscription";
  if (e.schema) {
    var o = function buildClientSchema(e) {
      var t = e.__schema;
      var r = {};
      function buildNameMap(e) {
        var t = {};
        for (var r = 0; r < e.length; r++) {
          t[e[r].name] = e[r];
        }
        return t;
      }
      function buildType(e) {
        switch (e.kind) {
         case "OBJECT":
         case "INTERFACE":
          return {
            name: e.name,
            kind: e.kind,
            interfaces: buildNameMap(e.interfaces || []),
            fields: buildNameMap(e.fields.map((function(e) {
              return {
                name: e.name,
                type: e.type,
                args: buildNameMap(e.args)
              };
            })))
          };

         case "UNION":
          return {
            name: e.name,
            kind: e.kind,
            types: buildNameMap(e.possibleTypes || [])
          };
        }
      }
      var i = {
        query: t.queryType ? t.queryType.name : null,
        mutation: t.mutationType ? t.mutationType.name : null,
        subscription: t.subscriptionType ? t.subscriptionType.name : null,
        types: void 0,
        isSubType: function isSubType(e, t) {
          var i = r[e];
          var n = r[t];
          if (!i || !n) {
            return !1;
          } else if ("UNION" === i.kind) {
            return !!i.types[t];
          } else if ("OBJECT" !== i.kind && "OBJECT" === n.kind) {
            return !!n.interfaces[e];
          } else {
            return e === t;
          }
        }
      };
      if (t.types) {
        i.types = r;
        for (var n = 0; n < t.types.length; n++) {
          var a = t.types[n];
          if (a && a.name) {
            var o = buildType(a);
            if (o) {
              r[a.name] = o;
            }
          }
        }
      }
      return i;
    }(e.schema);
    i = o.query || i;
    n = o.mutation || n;
    a = o.subscription || a;
    if (o.types) {
      this.schema = o;
    }
  }
  this.updates = ((t = {})[n] = e.updates && e.updates.Mutation || {}, t[a] = e.updates && e.updates.Subscription || {}, 
  t);
  this.rootFields = {
    query: i,
    mutation: n,
    subscription: a
  };
  this.rootNames = ((r = {})[i] = "query", r[n] = "mutation", r[a] = "subscription", 
  r);
  this.data = function make(e) {
    return {
      defer: !1,
      gc: new Set,
      persist: new Set,
      queryRootKey: e,
      refCount: makeDict(),
      refLock: makeDict(),
      links: makeNodeMap(),
      records: makeNodeMap(),
      deferredKeys: new Set,
      commutativeKeys: new Set,
      optimisticOrder: [],
      storage: null
    };
  }(i);
  if (this.schema && "production" !== process.env.NODE_ENV) {
    !function expectValidKeyingConfig(e, t) {
      if ("production" !== process.env.NODE_ENV) {
        for (var r in t) {
          if ("production" !== process.env.NODE_ENV) {
            if (!e.types[r]) {
              warn("Invalid Object type: The type `" + r + "` is not an object in the defined schema, but the `keys` option is referencing it.", 20);
            }
          }
        }
      }
    }(this.schema, this.keys);
    !function expectValidUpdatesConfig(e, t) {
      if ("production" === process.env.NODE_ENV) {
        return;
      }
      if (e.mutation) {
        var r = e.types[e.mutation].fields;
        var i = t[e.mutation] || {};
        for (var n in i) {
          if ("production" !== process.env.NODE_ENV) {
            if (void 0 === r[n]) {
              warn("Invalid mutation field: `" + n + "` is not in the defined schema, but the `updates.Mutation` option is referencing it.", 21);
            }
          }
        }
      }
      if (e.subscription) {
        var a = e.types[e.subscription].fields;
        var o = t[e.subscription] || {};
        for (var s in o) {
          if ("production" !== process.env.NODE_ENV) {
            if (void 0 === a[s]) {
              warn("Invalid subscription field: `" + s + "` is not in the defined schema, but the `updates.Subscription` option is referencing it.", 22);
            }
          }
        }
      }
    }(this.schema, this.updates);
    !function expectValidResolversConfig(e, t) {
      if ("production" === process.env.NODE_ENV) {
        return;
      }
      for (var r in t) {
        if ("Query" === r) {
          if (e.query) {
            var i = e.types[e.query].fields;
            for (var n in t.Query) {
              if (!i[n]) {
                warnAboutResolver("Query." + n);
              }
            }
          } else {
            warnAboutResolver("Query");
          }
        } else if (!e.types[r]) {
          warnAboutResolver(r);
        } else if ("INTERFACE" === e.types[r].kind || "UNION" === e.types[r].kind) {
          s = r, u = e.types[r].kind, "production" !== process.env.NODE_ENV && warn("Invalid resolver: `" + s + "` does not match to a concrete type in the schema, but the `resolvers` option is referencing it. Implement the resolver for the types that " + ("UNION" === u ? "make up the union" : "implement the interface") + " instead.", 26);
        } else {
          var a = e.types[r].fields;
          for (var o in t[r]) {
            if (!a[o]) {
              warnAboutResolver(r + "." + o);
            }
          }
        }
      }
      var s, u;
    }(this.schema, this.resolvers);
    !function expectValidOptimisticMutationsConfig(e, t) {
      if ("production" === process.env.NODE_ENV) {
        return;
      }
      if (e.mutation) {
        var r = e.types[e.mutation].fields;
        for (var i in t) {
          if ("production" !== process.env.NODE_ENV) {
            if (!r[i]) {
              warn("Invalid optimistic mutation field: `" + i + "` is not a mutation field in the defined schema, but the `optimistic` option is referencing it.", 24);
            }
          }
        }
      }
    }(this.schema, this.optimisticMutations);
  }
}

Store.prototype.keyOfEntity = function keyOfEntity(e) {
  if (L.current && e === L.current.parent) {
    return L.current.parentKey;
  }
  if (null == e || "string" == typeof e) {
    return e || null;
  }
  if (!e.__typename) {
    return null;
  }
  if (this.rootNames[e.__typename]) {
    return e.__typename;
  }
  var t;
  if (this.keys[e.__typename]) {
    t = this.keys[e.__typename](e);
  } else if (null != e.id) {
    t = "" + e.id;
  } else if (null != e._id) {
    t = "" + e._id;
  }
  return t ? e.__typename + ":" + t : null;
};

Store.prototype.resolve = function resolve(e, t, r) {
  var i = keyOfField(t, r);
  var n = this.keyOfEntity(e);
  if (!n) {
    return null;
  }
  var a = readRecord(n, i);
  if (void 0 !== a) {
    return a;
  }
  return readLink(n, i) || null;
};

Store.prototype.invalidate = function invalidate(e, t, r) {
  var i = this.keyOfEntity(e);
  invariant(i, "production" !== process.env.NODE_ENV ? "Can't generate a key for invalidate(...).\nYou have to pass an id or _id field or create a custom `keys` field for `" + typeof e == "object" ? e.__typename : e + "`." : "", 19);
  !function invalidateEntity(e, t, r) {
    var i = t ? [ {
      fieldKey: keyOfField(t, r)
    } ] : inspectFields(e);
    for (var n = 0, a = i.length; n < a; n++) {
      var o = i[n].fieldKey;
      if (void 0 !== readLink(e, o)) {
        writeLink(e, o, void 0);
      } else {
        writeRecord(e, o, void 0);
      }
    }
  }(i, t, r);
};

Store.prototype.inspectFields = function inspectFields$1(e) {
  var t = this.keyOfEntity(e);
  return t ? inspectFields(t) : [];
};

Store.prototype.updateQuery = function updateQuery(e, i) {
  var n = t(e.query, e.variables);
  n.query = r(n.query);
  var a = i(this.readQuery(n));
  if (null !== a) {
    startWrite(this, n, a);
  }
};

Store.prototype.readQuery = function readQuery(e) {
  var i = t(e.query, e.variables);
  i.query = r(i.query);
  return read(this, i).data;
};

Store.prototype.readFragment = function readFragment$1(e, t, i) {
  return function readFragment(e, t, r, i) {
    var n = getFragments(t);
    var a = Object.keys(n);
    var o = n[a[0]];
    if (!o) {
      "production" !== process.env.NODE_ENV && warn("readFragment(...) was called with an empty fragment.\nYou have to call it with at least one fragment in your GraphQL document.", 6);
      return null;
    }
    var s = getFragmentTypeName(o);
    if ("string" != typeof r && !r.__typename) {
      r.__typename = s;
    }
    var u = e.keyOfEntity(r);
    if (!u) {
      "production" !== process.env.NODE_ENV && warn("Can't generate a key for readFragment(...).\nYou have to pass an `id` or `_id` field or create a custom `keys` config for `" + s + "`.", 7);
      return null;
    }
    if ("production" !== process.env.NODE_ENV) {
      pushDebugNode(s, o);
    }
    var c = readSelection(makeContext(e, i || {}, n, s, u), u, getSelectionSet(o), makeData()) || null;
    if ("production" !== process.env.NODE_ENV) {
      popDebugNode();
    }
    return c;
  }(this, r(e), t, i);
};

Store.prototype.writeFragment = function writeFragment$1(e, t, i) {
  !function writeFragment(e, t, r, i) {
    var n = getFragments(t);
    var a = n[Object.keys(n)[0]];
    if (!a) {
      return "production" !== process.env.NODE_ENV ? warn("writeFragment(...) was called with an empty fragment.\nYou have to call it with at least one fragment in your GraphQL document.", 11) : void 0;
    }
    var o = getFragmentTypeName(a);
    var s = y({}, {
      __typename: o
    }, r);
    var u = e.keyOfEntity(s);
    if (!u) {
      return "production" !== process.env.NODE_ENV ? warn("Can't generate a key for writeFragment(...) data.\nYou have to pass an `id` or `_id` field or create a custom `keys` config for `" + o + "`.", 12) : void 0;
    }
    if ("production" !== process.env.NODE_ENV) {
      pushDebugNode(o, a);
    }
    writeSelection(makeContext(e, i || {}, n, o, u, void 0), u, getSelectionSet(a), s);
    if ("production" !== process.env.NODE_ENV) {
      popDebugNode();
    }
  }(this, r(e), t, i);
};

Store.prototype.link = function link(e, t, r, i) {
  var n = void 0 !== i ? r : null;
  var link = void 0 !== i ? i : r;
  var a = ensureLink(this, e);
  if ("string" == typeof a) {
    writeLink(a, keyOfField(t, n), ensureLink(this, link));
  }
};

function query(e, t, r, i, n) {
  initDataState("read", e.data, n);
  var a = read(e, t, r, i);
  clearDataState();
  return a;
}

function read(e, t, r, i) {
  var n = getMainOperation(t.query);
  var a = e.rootFields[n.operation];
  var o = getSelectionSet(n);
  var s = makeContext(e, normalizeVariables(n, t.variables), getFragments(t.query), a, a, !1, i);
  if ("production" !== process.env.NODE_ENV) {
    pushDebugNode(a, n);
  }
  if (!r) {
    r = makeData();
  }
  var u = a !== s.store.rootFields.query ? readRoot(s, a, o, r) : readSelection(s, a, o, r);
  if ("production" !== process.env.NODE_ENV) {
    popDebugNode();
  }
  return {
    dependencies: getCurrentDependencies(),
    partial: s.partial || !u,
    data: u || null
  };
}

function readRoot(e, t, r, i) {
  if ("string" != typeof (e.store.rootNames[t] ? t : i.__typename)) {
    return i;
  }
  var n = makeSelectionIterator(t, t, r, e);
  var a;
  var o = !1;
  var s = makeData(i);
  while (a = n()) {
    var u = getFieldAlias(a);
    var c = i[u];
    e.__internal.path.push(u);
    var l = void 0;
    if (a.selectionSet && null !== c) {
      l = readRootField(e, getSelectionSet(a), ensureData(c));
    } else {
      l = c;
    }
    o = o || l !== c;
    if (void 0 !== l) {
      s[u] = l;
    }
    e.__internal.path.pop();
  }
  return o ? s : i;
}

function readRootField(e, t, r) {
  if (Array.isArray(r)) {
    var i = new Array(r.length);
    var n = !1;
    for (var a = 0, o = r.length; a < o; a++) {
      e.__internal.path.push(a);
      i[a] = readRootField(e, t, r[a]);
      n = n || i[a] !== r[a];
      e.__internal.path.pop();
    }
    return n ? i : r;
  } else if (null === r) {
    return null;
  }
  var s = e.store.keyOfEntity(r);
  if (null !== s) {
    return readSelection(e, s, t, r) || null;
  } else {
    return readRoot(e, r.__typename, t, r);
  }
}

function readSelection(e, t, r, i, n) {
  var a = e.store;
  var o = t === a.rootFields.query;
  var s = n && a.keyOfEntity(n) || t;
  if ("production" !== process.env.NODE_ENV) {
    if (!o && e.store.rootNames[s]) {
      warn("Invalid root traversal: A selection was being read on `" + s + "` which is an uncached root type.\nThe `" + e.store.rootFields.mutation + "` and `" + e.store.rootFields.subscription + "` types are special Operation Root Types and cannot be read back from the cache.", 25);
    }
  }
  var u = !o ? readRecord(s, "__typename") || n && n.__typename : t;
  if ("string" != typeof u) {
    return;
  } else if (n && u !== n.__typename) {
    "production" !== process.env.NODE_ENV && warn("Invalid resolver data: The resolver at `" + s + "` returned an invalid typename that could not be reconciled with the cache.", 8);
    return;
  }
  var c = makeSelectionIterator(u, s, r, e);
  var l = !1;
  var d = !1;
  var f = u !== i.__typename;
  var p;
  var v = makeData(i);
  while (void 0 !== (p = c())) {
    var y = getName(p);
    var m = getFieldArguments(p, e.variables);
    var h = getFieldAlias(p);
    var g = keyOfField(y, m);
    var N = joinKeys(s, g);
    var k = readRecord(s, g);
    var O = n ? n[y] : void 0;
    var _ = a.resolvers[u];
    if ("production" !== process.env.NODE_ENV && a.schema && u) {
      isFieldAvailableOnType(a.schema, u, y);
    }
    e.__internal.path.push(h);
    var E = void 0;
    if ("__typename" === y) {
      E = u;
    } else if (void 0 !== O && void 0 === p.selectionSet) {
      E = O;
    } else if ("read" === getCurrentOperation() && _ && "function" == typeof _[y]) {
      updateContext(e, v, u, s, N, y);
      if (void 0 !== k) {
        v[h] = k;
      }
      E = _[y](v, m || {}, a, e);
      if (p.selectionSet) {
        E = resolveResolverResult(e, u, y, N, getSelectionSet(p), void 0 !== v[h] ? v[h] : i[h], E, ownsData(i));
      }
      if (a.schema && null === E && !isFieldNullable(a.schema, u, y)) {
        return;
      }
    } else if (!p.selectionSet) {
      E = k;
    } else if (void 0 !== O) {
      E = resolveResolverResult(e, u, y, N, getSelectionSet(p), void 0 !== v[h] ? v[h] : i[h], O, ownsData(i));
    } else {
      var b = readLink(s, g);
      if (void 0 !== b) {
        E = resolveLink(e, b, u, y, getSelectionSet(p), void 0 !== v[h] ? v[h] : i[h], ownsData(i));
      } else if ("object" == typeof k && null !== k) {
        E = k;
      }
    }
    if (void 0 === E && x.current) {
      l = !0;
    } else if (void 0 === E && (a.schema && isFieldNullable(a.schema, u, y) || getFieldError(e))) {
      d = !0;
      E = null;
    } else if (void 0 === E) {
      e.__internal.path.pop();
      return;
    } else {
      l = l || "__typename" !== y;
    }
    e.__internal.path.pop();
    f = f || E !== i[h];
    if (void 0 !== E) {
      v[h] = E;
    }
  }
  e.partial = e.partial || d;
  return o && d && !l ? void 0 : f ? v : i;
}

function resolveResolverResult(e, t, r, i, n, a, o, s) {
  if (Array.isArray(o)) {
    var u = e.store;
    var c = u.schema ? isListNullable(u.schema, t, r) : !1;
    var l = new Array(o.length);
    var d = !Array.isArray(a) || o.length !== a.length;
    for (var f = 0, p = o.length; f < p; f++) {
      e.__internal.path.push(f);
      var v = resolveResolverResult(e, t, r, joinKeys(i, "" + f), n, null != a ? a[f] : void 0, o[f], s);
      e.__internal.path.pop();
      if (void 0 === v && !c) {
        return;
      } else {
        e.partial = e.partial || void 0 === v && c;
        l[f] = null != v ? v : null;
        d = d || l[f] !== a[f];
      }
    }
    return d ? l : a;
  } else if (null == o) {
    return o;
  } else if (s && null === a) {
    return null;
  } else if (function isDataOrKey(e) {
    return "string" == typeof e || "object" == typeof e && "string" == typeof e.__typename;
  }(o)) {
    var y = a || makeData();
    return "string" == typeof o ? readSelection(e, o, n, y) : readSelection(e, i, n, y, o);
  } else {
    "production" !== process.env.NODE_ENV && warn("Invalid resolver value: The field at `" + i + "` is a scalar (number, boolean, etc), but the GraphQL query expects a selection set for this field.", 9);
    return;
  }
}

function resolveLink(e, t, r, i, n, a, o) {
  if (Array.isArray(t)) {
    var s = e.store;
    var u = s.schema ? isListNullable(s.schema, r, i) : !1;
    var c = new Array(t.length);
    var l = !Array.isArray(a) || c.length !== a.length;
    for (var d = 0, f = t.length; d < f; d++) {
      e.__internal.path.push(d);
      var p = resolveLink(e, t[d], r, i, n, null != a ? a[d] : void 0, o);
      e.__internal.path.pop();
      if (void 0 === p && !u) {
        return;
      } else {
        e.partial = e.partial || void 0 === p && u;
        c[d] = p || null;
        l = l || c[d] !== a[d];
      }
    }
    return l ? c : a;
  } else if (null === t || null === a && o) {
    return null;
  }
  return readSelection(e, t, n, a || makeData());
}

function addCacheOutcome(e, t) {
  return i(e.kind, e, y({}, e.context, {
    meta: y({}, e.context.meta, {
      cacheOutcome: t
    })
  }));
}

function toRequestPolicy(e, t) {
  return i(e.kind, e, y({}, e.context, {
    requestPolicy: t
  }));
}

function cacheExchange(e) {
  return function(t) {
    var v = t.forward;
    var y = t.client;
    var m = t.dispatchDebug;
    var h = new Store(e);
    var g;
    if (e && e.storage) {
      g = e.storage.readData().then((function(t) {
        !function hydrateData(e, t, r) {
          initDataState("write", e, null);
          for (var i in r) {
            var n = r[i];
            if (void 0 !== n) {
              var a = deserializeKeyInfo(i);
              var o = a.entityKey;
              var s = a.fieldKey;
              if (":" === n[0]) {
                writeLink(o, s, JSON.parse(n.slice(1)));
              } else {
                writeRecord(o, s, JSON.parse(n));
              }
            }
          }
          clearDataState();
          e.storage = t;
        }(h.data, e.storage, t);
      }));
    }
    var N = new Map;
    var k = [];
    var O = new Map;
    var _ = new Map;
    var E = makeDict();
    var b = new Set;
    var D = makeDict();
    function isBlockedByOptimisticUpdate(e) {
      for (var t in e) {
        if (E[t]) {
          return !0;
        }
      }
      return !1;
    }
    function collectPendingOperations(e, t) {
      if (t) {
        for (var r in t) {
          var i = D[r];
          if (i) {
            D[r] = [];
            for (var n = 0, a = i.length; n < a; n++) {
              e.add(i[n]);
            }
          }
        }
      }
    }
    function executePendingOperations(e, t) {
      t.forEach((function(t) {
        if (t !== e.key) {
          var r = O.get(t);
          if (r) {
            O.delete(t);
            var i = "cache-first";
            if (b.has(t)) {
              b.delete(t);
              i = "cache-and-network";
            }
            y.reexecuteOperation(toRequestPolicy(r, i));
          }
        }
      }));
    }
    function prepareForwardedOperation(e) {
      if ("query" === e.kind) {
        reserveLayer(h.data, e.key);
      } else if ("teardown" === e.kind) {
        O.delete(e.key);
        _.delete(e.key);
        noopDataState(h.data, e.key);
      } else if ("mutation" === e.kind && "network-only" !== e.context.requestPolicy) {
        var t = function writeOptimistic(e, t, r) {
          if ("production" !== process.env.NODE_ENV) {
            invariant("mutation" === getMainOperation(t.query).operation, "production" !== process.env.NODE_ENV ? "writeOptimistic(...) was called with an operation that is not a mutation.\nThis case is unsupported and should never occur." : "", 10);
          }
          initDataState("write", e.data, r, !0);
          var i = startWrite(e, t, {}, void 0, !0);
          clearDataState();
          return i;
        }(h, e, e.key).dependencies;
        if (!function isDictEmpty(e) {
          for (var t in e) {
            return !1;
          }
          return !0;
        }(t)) {
          for (var n in t) {
            E[n] = !0;
          }
          N.set(e.key, t);
          var a = new Set;
          collectPendingOperations(a, t);
          executePendingOperations(e, a);
        }
      }
      return i(e.kind, {
        key: e.key,
        query: r(e.query),
        variables: e.variables ? filterVariables(getMainOperation(e.query), e.variables) : e.variables
      }, e.context);
    }
    function updateDependencies(e, t) {
      for (var r in t) {
        (D[r] || (D[r] = [])).push(e.key);
        O.set(e.key, e);
      }
    }
    function operationResultFromCache(e) {
      var t = query(h, e, _.get(e.key));
      var r = t.data ? !t.partial ? "hit" : "partial" : "miss";
      _.set(e.key, t.data);
      updateDependencies(e, t.dependencies);
      return {
        outcome: r,
        operation: e,
        data: t.data,
        dependencies: t.dependencies
      };
    }
    function updateCacheWithResult(e, t) {
      var r = e.operation;
      var i = e.error;
      var n = e.extensions;
      var a = r.key;
      if ("mutation" === r.kind) {
        collectPendingOperations(t, N.get(a));
        N.delete(a);
      }
      reserveLayer(h.data, r.key, e.hasNext);
      var o;
      var s = e.data;
      if (s) {
        collectPendingOperations(t, write(h, r, s, e.error, a).dependencies);
        var u = query(h, r, "query" === r.kind ? _.get(r.key) || s : s, e.error, a);
        s = u.data;
        if ("query" === r.kind) {
          collectPendingOperations(t, o = u.dependencies);
          _.set(r.key, e.data);
        }
      } else {
        noopDataState(h.data, r.key);
      }
      if (o) {
        updateDependencies(e.operation, o);
      }
      return {
        data: s,
        error: i,
        extensions: n,
        operation: r
      };
    }
    return function(e) {
      var t = n(e);
      var r = g ? n(a([ o(s)(u(c(g))(t)), l(c(g))(t) ])) : t;
      var i = n(d(operationResultFromCache)(f((function(e) {
        return "query" === e.kind && "network-only" !== e.context.requestPolicy;
      }))(r)));
      var O = f((function(e) {
        return "query" !== e.kind || "network-only" === e.context.requestPolicy;
      }))(r);
      var _ = d((function(e) {
        "production" !== process.env.NODE_ENV && m({
          type: "cacheMiss",
          message: "The result could not be retrieved from the cache",
          operation: e.operation,
          source: "cacheExchange"
        });
        return addCacheOutcome(e.operation, "miss");
      }))(f((function(e) {
        return "miss" === e.outcome && "cache-only" !== e.operation.context.requestPolicy && !isBlockedByOptimisticUpdate(e.dependencies);
      }))(i));
      var D = d((function(e) {
        var t = e.operation;
        var r = e.outcome;
        var i = e.dependencies;
        var n = {
          operation: addCacheOutcome(t, r),
          data: e.data,
          error: e.error,
          extensions: e.extensions
        };
        if ("cache-and-network" === t.context.requestPolicy || "cache-first" === t.context.requestPolicy && "partial" === r) {
          n.stale = !0;
          if (!isBlockedByOptimisticUpdate(i)) {
            y.reexecuteOperation(toRequestPolicy(t, "network-only"));
          } else if ("cache-and-network" === t.context.requestPolicy) {
            b.add(t.key);
          }
        }
        "production" !== process.env.NODE_ENV && m({
          type: "cacheHit",
          message: "A requested operation was found and returned from the cache.",
          operation: e.operation,
          data: {
            value: n
          },
          source: "cacheExchange"
        });
        return n;
      }))(f((function(e) {
        return "miss" !== e.outcome || "cache-only" === e.operation.context.requestPolicy;
      }))(i));
      var w = n(v(d(prepareForwardedOperation)(a([ O, _ ]))));
      var F = d((function(e) {
        var t = new Set;
        var r = updateCacheWithResult(e, t);
        executePendingOperations(e.operation, t);
        return r;
      }))(f((function(e) {
        return !N.has(e.operation.key);
      }))(w));
      var S = o((function(e) {
        if (k.push(e) < N.size) {
          return p;
        }
        for (var t = 0; t < k.length; t++) {
          reserveLayer(h.data, k[t].operation.key);
        }
        for (var r in E) {
          delete E[r];
        }
        var i = [];
        var n = new Set;
        var a;
        while (a = k.shift()) {
          i.push(updateCacheWithResult(a, n));
        }
        executePendingOperations(e.operation, n);
        return s(i);
      }))(f((function(e) {
        return N.has(e.operation.key);
      }))(w));
      return a([ F, S, D ]);
    };
  };
}

function isOfflineError(e) {
  return e && e.networkError && !e.response && ("undefined" != typeof navigator && !1 === navigator.onLine || /request failed|failed to fetch|network\s?error/i.test(e.networkError.message));
}

function offlineExchange(e) {
  return function(r) {
    var o = e.storage;
    if (o && o.onOnline && o.readMetadata && o.writeMetadata) {
      var s = r.forward;
      var u = r.client;
      var c = r.dispatchDebug;
      var l = v();
      var d = l.source;
      var p = l.next;
      var y = e.optimistic || {};
      var m = [];
      var updateMetadata = function() {
        var e = [];
        for (var t = 0; t < m.length; t++) {
          var r = m[t];
          if ("mutation" === r.kind) {
            e.push({
              query: g(r.query),
              variables: r.variables
            });
          }
        }
        o.writeMetadata(e);
      };
      var h = !1;
      var flushQueue = function() {
        if (!h) {
          h = !0;
          for (var e = 0; e < m.length; e++) {
            var t = m[e];
            if ("mutation" === t.kind) {
              p(i("teardown", t));
            }
          }
          for (var r = 0; r < m.length; r++) {
            u.reexecuteOperation(m[r]);
          }
          m.length = 0;
          h = !1;
          updateMetadata();
        }
      };
      o.onOnline(flushQueue);
      o.readMetadata().then((function(e) {
        if (e) {
          for (var r = 0; r < e.length; r++) {
            m.push(u.createRequestOperation("mutation", t(e[r].query, e[r].variables)));
          }
          flushQueue();
        }
      }));
      var N = cacheExchange(e)({
        client: u,
        dispatchDebug: c,
        forward: function(e) {
          return f((function(e) {
            if ("mutation" === e.operation.kind && isOfflineError(e.error) && function isOptimisticMutation(e, t) {
              var r = t.variables || makeDict();
              var i = getFragments(t.query);
              var n = [].concat(getSelectionSet(getMainOperation(t.query)));
              var a;
              while (a = n.pop()) {
                if (!shouldInclude(a, r)) {
                  continue;
                } else if (!isFieldNode(a)) {
                  var o = !isInlineFragment(a) ? i[getName(a)] : a;
                  if (o) {
                    n.push.apply(n, getSelectionSet(o));
                  }
                } else if (e[getName(a)]) {
                  return !0;
                }
              }
              return !1;
            }(y, e.operation)) {
              m.push(e.operation);
              updateMetadata();
              return !1;
            }
            return !0;
          }))(s(e));
        }
      });
      return function(e) {
        var t = n(e);
        var r = a([ d, t ]);
        return f((function(e) {
          if ("query" === e.operation.kind && isOfflineError(e.error)) {
            p(toRequestPolicy(e.operation, "cache-only"));
            m.push(e.operation);
            return !1;
          }
          return !0;
        }))(N(r));
      };
    }
    return cacheExchange(e)(r);
  };
}

export { Store, cacheExchange, offlineExchange, query, write };
//# sourceMappingURL=urql-exchange-graphcache.mjs.map
