import { GraphQLError as e } from "graphql/error/GraphQLError.mjs";

import { Kind as r } from "graphql/language/kinds.mjs";

import { parse as t } from "graphql/language/parser.mjs";

import { print as n } from "graphql/language/printer.mjs";

import { make as a } from "wonka";

function rehydrateGraphQlError(r) {
  if ("string" == typeof r) {
    return new e(r);
  } else if ("object" == typeof r && r.message) {
    return new e(r.message, r.nodes, r.source, r.positions, r.path, r, r.extensions || {});
  } else {
    return r;
  }
}

var o = function(e) {
  function CombinedError(r) {
    var t = r.networkError;
    var n = r.response;
    var a = (r.graphQLErrors || []).map(rehydrateGraphQlError);
    var o = function generateErrorMessage(e, r) {
      var t = "";
      if (void 0 !== e) {
        return t = "[Network] " + e.message;
      }
      if (void 0 !== r) {
        r.forEach((function(e) {
          t += "[GraphQL] " + e.message + "\n";
        }));
      }
      return t.trim();
    }(t, a);
    e.call(this, o);
    this.name = "CombinedError";
    this.message = o;
    this.graphQLErrors = a;
    this.networkError = t;
    this.response = n;
  }
  if (e) {
    CombinedError.__proto__ = e;
  }
  (CombinedError.prototype = Object.create(e && e.prototype)).constructor = CombinedError;
  CombinedError.prototype.toString = function toString() {
    return this.message;
  };
  return CombinedError;
}(Error);

function phash(e, r) {
  e |= 0;
  for (var t = 0, n = 0 | r.length; t < n; t++) {
    e = (e << 5) + e + r.charCodeAt(t);
  }
  return e;
}

function hash(e) {
  return phash(5381, e) >>> 0;
}

var i = new Set;

var s = new WeakMap;

function stringify(e) {
  if (null === e || i.has(e)) {
    return "null";
  } else if ("object" != typeof e) {
    return JSON.stringify(e) || "";
  } else if (e.toJSON) {
    return stringify(e.toJSON());
  } else if (Array.isArray(e)) {
    var r = "[";
    for (var t = 0, n = e.length; t < n; t++) {
      if (t > 0) {
        r += ",";
      }
      var a = stringify(e[t]);
      r += a.length > 0 ? a : "null";
    }
    return r += "]";
  }
  var o = Object.keys(e).sort();
  if (!o.length && e.constructor && e.constructor !== Object) {
    var u = s.get(e) || Math.random().toString(36).slice(2);
    s.set(e, u);
    return '{"__key":"' + u + '"}';
  }
  i.add(e);
  var f = "{";
  for (var c = 0, l = o.length; c < l; c++) {
    var h = o[c];
    var p = stringify(e[h]);
    if (p) {
      if (f.length > 1) {
        f += ",";
      }
      f += stringify(h) + ":" + p;
    }
  }
  i.delete(e);
  return f += "}";
}

function stringifyVariables(e) {
  i.clear();
  return stringify(e);
}

var u = /("{3}[\s\S]*"{3}|"(?:\\.|[^"])*")/g;

var f = /([\s,]|#[^\n\r]+)+/g;

function replaceOutsideStrings(e, r) {
  return r % 2 == 0 ? e.replace(f, " ").trim() : e;
}

function stringifyDocument(e) {
  var r = ("string" != typeof e ? e.loc && e.loc.source.body || n(e) : e).split(u).map(replaceOutsideStrings).join("");
  if ("string" != typeof e) {
    var t = "definitions" in e && getOperationName(e);
    if (t) {
      r = "# " + t + "\n" + r;
    }
    if (!e.loc) {
      e.loc = {
        start: 0,
        end: r.length,
        source: {
          body: r,
          name: "gql",
          locationOffset: {
            line: 1,
            column: 1
          }
        }
      };
    }
  }
  return r;
}

var c = new Map;

function keyDocument(e) {
  var r;
  var n;
  if ("string" == typeof e) {
    r = hash(stringifyDocument(e));
    n = c.get(r) || t(e, {
      noLocation: !0
    });
  } else {
    r = e.__key || hash(stringifyDocument(e));
    n = c.get(r) || e;
  }
  if (!n.loc) {
    stringifyDocument(n);
  }
  n.__key = r;
  c.set(r, n);
  return n;
}

function createRequest(e, r) {
  if (!r) {
    r = {};
  }
  var t = keyDocument(e);
  return {
    key: phash(t.__key, stringifyVariables(r)) >>> 0,
    query: t,
    variables: r
  };
}

function getOperationName(e) {
  for (var t = 0, n = e.definitions.length; t < n; t++) {
    var a = e.definitions[t];
    if (a.kind === r.OPERATION_DEFINITION && a.name) {
      return a.name.value;
    }
  }
}

function getOperationType(e) {
  for (var t = 0, n = e.definitions.length; t < n; t++) {
    var a = e.definitions[t];
    if (a.kind === r.OPERATION_DEFINITION) {
      return a.operation;
    }
  }
}

function _extends() {
  return (_extends = Object.assign || function(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = arguments[r];
      for (var n in t) {
        if (Object.prototype.hasOwnProperty.call(t, n)) {
          e[n] = t[n];
        }
      }
    }
    return e;
  }).apply(this, arguments);
}

function makeResult(e, r, t) {
  if (!("data" in r) && !("errors" in r) || "path" in r) {
    throw new Error("No Content");
  }
  return {
    operation: e,
    data: r.data,
    error: Array.isArray(r.errors) ? new o({
      graphQLErrors: r.errors,
      response: t
    }) : void 0,
    extensions: "object" == typeof r.extensions && r.extensions || void 0,
    hasNext: !!r.hasNext
  };
}

function mergeResultPatch(e, r, t) {
  var n = _extends({}, e);
  n.hasNext = !!r.hasNext;
  if (!("path" in r)) {
    if ("data" in r) {
      n.data = r.data;
    }
    return n;
  }
  if (Array.isArray(r.errors)) {
    n.error = new o({
      graphQLErrors: n.error ? n.error.graphQLErrors.concat(r.errors) : r.errors,
      response: t
    });
  }
  var a = n.data = _extends({}, n.data);
  var i = 0;
  var s;
  while (i < r.path.length) {
    a = a[s = r.path[i++]] = Array.isArray(a[s]) ? [].concat(a[s]) : _extends({}, a[s]);
  }
  _extends(a, r.data);
  return n;
}

function makeErrorResult(e, r, t) {
  return {
    operation: e,
    data: void 0,
    error: new o({
      networkError: r,
      response: t
    }),
    extensions: void 0
  };
}

function shouldUseGet(e) {
  return "query" === e.kind && !!e.context.preferGetMethod;
}

function makeFetchBody(e) {
  return {
    query: n(e.query),
    operationName: getOperationName(e.query),
    variables: e.variables || void 0,
    extensions: void 0
  };
}

function makeFetchURL(e, r) {
  var t = shouldUseGet(e);
  var n = e.context.url;
  if (!t || !r) {
    return n;
  }
  var a = [];
  if (r.operationName) {
    a.push("operationName=" + encodeURIComponent(r.operationName));
  }
  if (r.query) {
    a.push("query=" + encodeURIComponent(r.query.replace(/#[^\n\r]+/g, " ").trim()));
  }
  if (r.variables) {
    a.push("variables=" + encodeURIComponent(stringifyVariables(r.variables)));
  }
  if (r.extensions) {
    a.push("extensions=" + encodeURIComponent(stringifyVariables(r.extensions)));
  }
  var o = n + "?" + a.join("&");
  if (o.length > 2047) {
    e.context.preferGetMethod = !1;
    return n;
  }
  return o;
}

function makeFetchOptions(e, r) {
  var t = shouldUseGet(e);
  var n = "function" == typeof e.context.fetchOptions ? e.context.fetchOptions() : e.context.fetchOptions || {};
  return _extends({}, n, {
    body: !t && r ? JSON.stringify(r) : void 0,
    method: t ? "GET" : "POST",
    headers: t ? n.headers : _extends({}, {
      "content-type": "application/json"
    }, n.headers)
  });
}

var l = "undefined" != typeof Symbol ? Symbol.asyncIterator : null;

var h = "undefined" != typeof TextDecoder ? new TextDecoder : null;

var p = /content-type:[^\r\n]*application\/json/i;

var d = /boundary="?([^=";]+)"?/i;

function makeFetchSource(e, r, t) {
  var n = "manual" === t.redirect ? 400 : 300;
  var o = e.context.fetch;
  return a((function(a) {
    var i = a.next;
    var s = a.complete;
    var u = "undefined" != typeof AbortController ? new AbortController : null;
    if (u) {
      t.signal = u.signal;
    }
    var f = !1;
    function executeIncrementalFetch(e, r, t) {
      var n = t.headers && t.headers.get("Content-Type") || "";
      if (!/multipart\/mixed/i.test(n)) {
        return t.json().then((function(n) {
          var a = makeResult(r, n, t);
          f = !0;
          e(a);
        }));
      }
      var a = "---";
      var o = n.match(d);
      if (o) {
        a = "--" + o[1];
      }
      var i;
      var cancel = function() {};
      if (l && t[l]) {
        var s = t[l]();
        i = s.next.bind(s);
      } else if ("body" in t && t.body) {
        var u = t.body.getReader();
        cancel = u.cancel.bind(u);
        i = u.read.bind(u);
      } else {
        throw new TypeError("Streaming requests unsupported");
      }
      var c = "";
      var v = !0;
      var m = null;
      var g = null;
      return i().then((function next(n) {
        if (!n.done) {
          var o = function toString(e) {
            return "Buffer" === e.constructor.name ? e.toString() : h.decode(e);
          }(n.value);
          var s = o.indexOf(a);
          if (s > -1) {
            s += c.length;
          } else {
            s = c.indexOf(a);
          }
          c += o;
          while (s > -1) {
            var u = c.slice(0, s);
            var l = c.slice(s + a.length);
            if (v) {
              v = !1;
            } else {
              var d = u.indexOf("\r\n\r\n") + 4;
              var y = u.slice(0, d);
              var x = u.slice(d, u.lastIndexOf("\r\n"));
              var b = void 0;
              if (p.test(y)) {
                try {
                  b = JSON.parse(x);
                  m = g = g ? mergeResultPatch(g, b, t) : makeResult(r, b, t);
                } catch (e) {}
              }
              if ("--" === l.slice(0, 2) || b && !b.hasNext) {
                if (!g) {
                  return e(makeResult(r, {}, t));
                }
                break;
              }
            }
            s = (c = l).indexOf(a);
          }
        } else {
          f = !0;
        }
        if (m) {
          e(m);
          m = null;
        }
        if (!n.done && (!g || g.hasNext)) {
          return i().then(next);
        }
      })).finally(cancel);
    }
    var c = !1;
    var v = !1;
    var m;
    Promise.resolve().then((function() {
      if (c) {
        return;
      }
      return (o || fetch)(r, t);
    })).then((function(r) {
      if (!r) {
        return;
      }
      v = (m = r).status < 200 || m.status >= n;
      return executeIncrementalFetch(i, e, m);
    })).then(s).catch((function(r) {
      if (f) {
        throw r;
      }
      if ("AbortError" !== r.name) {
        var t = makeErrorResult(e, v ? new Error(m.statusText) : r, m);
        i(t);
        s();
      }
    }));
    return function() {
      c = !0;
      if (u) {
        u.abort();
      }
    };
  }));
}

export { o as C, _extends as _, makeErrorResult as a, makeFetchBody as b, makeFetchURL as c, makeFetchOptions as d, makeFetchSource as e, createRequest as f, getOperationType as g, stringifyVariables as h, mergeResultPatch as i, getOperationName as j, keyDocument as k, makeResult as m, stringifyDocument as s };
//# sourceMappingURL=923bca32.mjs.map
