"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.forwardSlash = void 0;
const tslib_1 = require("tslib");
const path_1 = tslib_1.__importDefault(require("path"));
/**
 * Normalizes the given path to have forward slashes at all times.
 * This is used to resolve modules from the snapshot as they are always stored
 * with forward slashes there.
 * @category loader
 */
exports.forwardSlash = path_1.default.sep === path_1.default.posix.sep
    ? (p) => p
    : (p) => p.replace(/(\\)+/g, '/');
