"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.compileCrossOriginCallbackFiles = void 0;
var lodash_1 = __importDefault(require("lodash"));
var debug_1 = __importDefault(require("debug"));
var path = __importStar(require("path"));
var webpack_1 = __importDefault(require("webpack"));
var VirtualModulesPlugin = require('webpack-virtual-modules');
var debug = (0, debug_1.default)('cypress:webpack');
// takes the files stored by the cross-origin-callback-loader and turns
// them into config we can pass to webpack to compile all the files. the
// virtual config allows us to just use the source we have in memory without
// needing to write it to file
var getConfig = function (_a) {
    var files = _a.files, originalFilePath = _a.originalFilePath;
    var dir = path.dirname(originalFilePath);
    return files.reduce(function (memo, file) {
        var inputFileName = file.inputFileName, source = file.source;
        var inputPath = path.join(dir, inputFileName);
        memo.entry[inputFileName] = inputPath;
        memo.virtualConfig[inputPath] = source;
        return memo;
    }, { entry: {}, virtualConfig: {} });
};
var getWebpackOptions = function (_a) {
    var webpackOptions = _a.webpackOptions, entry = _a.entry, virtualConfig = _a.virtualConfig, outputDir = _a.outputDir;
    var modifiedWebpackOptions = lodash_1.default.extend({}, webpackOptions, {
        entry: entry,
        output: {
            path: outputDir,
        },
    });
    var plugins = modifiedWebpackOptions.plugins || [];
    modifiedWebpackOptions.plugins = plugins.concat(new VirtualModulesPlugin(virtualConfig));
    return modifiedWebpackOptions;
};
// the cross-origin-callback-loader extracts any cy.origin() callback functions
// that includes dependencies and stores their sources in the
// CrossOriginCallbackStore. this sends those sources through webpack again
// to process any dependencies and create bundles for each callback function
var compileCrossOriginCallbackFiles = function (files, options) {
    debug('compile cross-origin callback files: %o', files);
    var originalFilePath = options.originalFilePath, webpackOptions = options.webpackOptions;
    var outputDir = path.dirname(files[0].outputFilePath);
    var _a = getConfig({ files: files, originalFilePath: originalFilePath }), entry = _a.entry, virtualConfig = _a.virtualConfig;
    var modifiedWebpackOptions = getWebpackOptions({
        webpackOptions: webpackOptions,
        entry: entry,
        virtualConfig: virtualConfig,
        outputDir: outputDir,
    });
    return new Promise(function (resolve, reject) {
        var compiler = (0, webpack_1.default)(modifiedWebpackOptions);
        var handle = function (err) {
            if (err) {
                debug('errored compiling cross-origin callback files with: %s', err.stack);
                return reject(err);
            }
            debug('successfully compiled cross-origin callback files');
            resolve();
        };
        compiler.run(handle);
    });
};
exports.compileCrossOriginCallbackFiles = compileCrossOriginCallbackFiles;
