/// <reference types="node" />
import Module from 'module';
import type { WebpackDevServerConfig } from '../devServer';
export declare type ModuleClass = typeof Module & {
    _load(id: string, parent: Module, isMain: boolean): any;
    _resolveFilename(request: string, parent: Module, isMain: boolean, options?: {
        paths: string[];
    }): string;
    _cache: Record<string, Module>;
};
export interface PackageJson {
    name: string;
    version: string;
}
export interface SourcedDependency {
    importPath: string;
    packageJson: PackageJson;
}
export interface SourcedWebpack extends SourcedDependency {
    module: Function;
    majorVersion: 4 | 5;
}
export interface SourcedWebpackDevServer extends SourcedDependency {
    module: {
        new (...args: unknown[]): unknown;
    };
    majorVersion: 3 | 4;
}
export interface SourcedHtmlWebpackPlugin extends SourcedDependency {
    module: unknown;
    majorVersion: 4 | 5;
}
export interface SourceRelativeWebpackResult {
    framework: SourcedDependency | null;
    webpack: SourcedWebpack;
    webpackDevServer: SourcedWebpackDevServer;
    htmlWebpackPlugin: SourcedHtmlWebpackPlugin;
}
export declare const cypressWebpackPath: (config: WebpackDevServerConfig) => string;
export declare function sourceFramework(config: WebpackDevServerConfig): SourcedDependency | null;
export declare function sourceWebpack(config: WebpackDevServerConfig, framework: SourcedDependency | null): SourcedWebpack;
export declare function sourceWebpackDevServer(config: WebpackDevServerConfig, framework?: SourcedDependency | null): SourcedWebpackDevServer;
export declare function sourceHtmlWebpackPlugin(config: WebpackDevServerConfig, framework: SourcedDependency | null, webpack: SourcedWebpack): SourcedHtmlWebpackPlugin;
export declare function sourceDefaultWebpackDependencies(config: WebpackDevServerConfig): SourceRelativeWebpackResult;
export declare function getMajorVersion<T extends number>(json: PackageJson, acceptedVersions: T[]): T;
export declare function restoreLoadHook(): void;
