/// <reference types="cypress" />
import type { PresetHandlerResult, WebpackDevServerConfig } from '../devServer';
export declare type BuildOptions = Record<string, any>;
export declare type AngularWebpackDevServerConfig = Extract<WebpackDevServerConfig, {
    framework: 'angular';
}>;
declare type Configurations = {
    configurations?: {
        [configuration: string]: BuildOptions;
    };
};
export declare type AngularJsonProjectConfig = {
    projectType: string;
    root: string;
    sourceRoot: string;
    architect: {
        build: {
            options: BuildOptions;
        } & Configurations;
    };
};
declare type AngularJson = {
    defaultProject?: string;
    projects: {
        [project: string]: AngularJsonProjectConfig;
    };
};
export declare function getProjectConfig(projectRoot: string): Promise<Cypress.AngularDevServerProjectConfig>;
export declare function getAngularBuildOptions(buildOptions: BuildOptions, tsConfig: string): {
    tsConfig: string;
    aot: boolean;
    outputHashing: string;
    budgets: undefined;
    outputPath: string;
    assets: never[];
    styles: never[];
    scripts: never[];
    fileReplacements: never[];
    inlineStyleLanguage: string;
    stylePreprocessorOptions: {
        includePaths: never[];
    };
    resourcesOutputPath: undefined;
    commonChunk: boolean;
    baseHref: undefined;
    deployUrl: undefined;
    verbose: boolean;
    progress: boolean;
    i18nMissingTranslation: string;
    i18nDuplicateTranslation: string;
    localize: undefined;
    watch: boolean;
    poll: undefined;
    deleteOutputPath: boolean;
    preserveSymlinks: undefined;
    showCircularDependencies: boolean;
    subresourceIntegrity: boolean;
    serviceWorker: boolean;
    ngswConfigPath: undefined;
    statsJson: boolean;
    webWorkerTsConfig: undefined;
    crossOrigin: string;
    allowedCommonJsDependencies: never[];
    buildOptimizer: boolean;
    optimization: boolean;
    vendorChunk: boolean;
    extractLicenses: boolean;
    sourceMap: boolean;
    namedChunks: boolean;
};
export declare function generateTsConfig(devServerConfig: AngularWebpackDevServerConfig, buildOptions: BuildOptions): Promise<string>;
export declare function getTempDir(): Promise<string>;
export declare function getAngularCliModules(projectRoot: string): Promise<{
    generateBrowserWebpackConfigFromContext: any;
    getCommonConfig: any;
    getStylesConfig: any;
}>;
export declare function getAngularJson(projectRoot: string): Promise<AngularJson>;
export declare const toPosix: (filePath: string) => string;
export declare function angularHandler(devServerConfig: AngularWebpackDevServerConfig): Promise<PresetHandlerResult>;
export {};
