/// <reference types="cypress" />
/// <reference types="cypress" />
/// <reference types="node" />
import type { Configuration } from 'webpack';
import { SourceRelativeWebpackResult } from './helpers/sourceRelativeWebpackModules';
export declare type Frameworks = Extract<Cypress.DevServerConfigOptions, {
    bundler: 'webpack';
}>['framework'];
declare type FrameworkConfig = {
    framework?: Exclude<Frameworks, 'angular'>;
} | {
    framework: 'angular';
    options?: {
        projectConfig: Cypress.AngularDevServerProjectConfig;
    };
};
export declare type ConfigHandler = Partial<Configuration> | (() => Partial<Configuration> | Promise<Partial<Configuration>>);
export declare type WebpackDevServerConfig = {
    specs: Cypress.Spec[];
    cypressConfig: Cypress.PluginConfigOptions;
    devServerEvents: NodeJS.EventEmitter;
    onConfigNotFound?: (devServer: 'webpack', cwd: string, lookedIn: string[]) => void;
    webpackConfig?: ConfigHandler;
} & FrameworkConfig;
/**
 * import { devServer } from '@cypress/webpack-dev-server'
 *
 * Creates & returns a WebpackDevServer for serving files related
 * to Cypress Component Testing
 *
 * @param config
 */
export declare function devServer(devServerConfig: WebpackDevServerConfig): Promise<Cypress.ResolvedDevServerConfig>;
export declare namespace devServer {
    var create: (devServerConfig: WebpackDevServerConfig) => Promise<{
        server: unknown;
        compiler: object;
        version: 3 | 4;
    }>;
}
export declare type PresetHandlerResult = {
    frameworkConfig: Configuration;
    sourceWebpackModulesResult: SourceRelativeWebpackResult;
};
export default devServer;
