import type { WebpackDevServerConfig } from './devServer';
import type { SourceRelativeWebpackResult } from './helpers/sourceRelativeWebpackModules';
/**
 * Takes the webpack / webpackDevServer modules, the configuration provide
 * from the framework override (if any), and the configuration provided
 * from the user config (if any) and makes the final config we want to
 * serve into webpack
 */
export interface CreateFinalWebpackConfig {
    /**
     * Initial config passed to devServer
     */
    devServerConfig: WebpackDevServerConfig;
    /**
     * Result of sourcing the webpack from the
     */
    sourceWebpackModulesResult: SourceRelativeWebpackResult;
    /**
     * Framework-specific config overrides
     */
    frameworkConfig?: unknown;
}
export declare function createWebpackDevServer(config: CreateFinalWebpackConfig): Promise<{
    server: unknown;
    compiler: object;
}>;
