/// <reference types="cypress" />
/// <reference types="node" />
import type { EventEmitter } from 'events';
export interface CypressCTWebpackPluginOptions {
    files: Cypress.Cypress['spec'][];
    projectRoot: string;
    supportFile: string | false;
    devServerEvents: EventEmitter;
    webpack: Function;
}
export declare type CypressCTContextOptions = Omit<CypressCTWebpackPluginOptions, 'devServerEvents' | 'webpack'>;
export interface CypressCTWebpackContext {
    _cypress: CypressCTContextOptions;
}
export declare const normalizeError: (error: Error | string) => string;
