/// <reference types="cypress" />
/// <reference types="cypress" />
/// <reference types="node" />
import type { UserConfig } from 'vite';
declare const ALL_FRAMEWORKS: readonly ["react", "vue"];
declare type ConfigHandler = UserConfig | (() => UserConfig | Promise<UserConfig>);
export declare type ViteDevServerConfig = {
    specs: Cypress.Spec[];
    cypressConfig: Cypress.PluginConfigOptions;
    devServerEvents: NodeJS.EventEmitter;
    onConfigNotFound?: (devServer: 'vite', cwd: string, lookedIn: string[]) => void;
} & {
    framework?: typeof ALL_FRAMEWORKS[number];
    viteConfig?: ConfigHandler;
};
export declare function devServer(config: ViteDevServerConfig): Promise<Cypress.ResolvedDevServerConfig>;
export declare namespace devServer {
    var create: (devServerConfig: ViteDevServerConfig, vite: typeof import("vite")) => Promise<import("vite").ViteDevServer>;
}
export {};
