<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [StyleSheet](#stylesheet)
    -   [toggleDisabled](#toggledisabled)
    -   [getText](#gettext)
    -   [getOriginalSources](#getoriginalsources)
    -   [getOriginalLocation](#getoriginallocation)
    -   [getMediaRules](#getmediarules)
    -   [update](#update)

## StyleSheet

**Extends Actor**

A StyleSheetActor represents a stylesheet on the server.

### toggleDisabled

Toggle the disabled property of the style sheet

Returns **Promise.Object** 'disabled' - the disabled state after toggling.

### getText

Protocol method to get the text of this stylesheet.

Returns **Promise.String** text of stylesheet

### getOriginalSources

Protocol method to get the original source (actors) for this
stylesheet if it has uses source maps.

Returns **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;Promise.OriginalSource>** list of original sources of this stylesheet

### getOriginalLocation

Protocol method that gets the location in the original source of a
line, column pair in this stylesheet, if its source mapped, otherwise
a promise of the same location.

**Parameters**

-   `_line`  
-   `_column`  

Returns **Promise.Object** object with "source", "line" and "column" property

### getMediaRules

Protocol method to get the media rules for the stylesheet.

Returns **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;Promise.MediaRuleActors>** list of media rules actors

### update

Update the style sheet in place with new text.

**Parameters**

-   `text`  
-   `transition`  
-   `request` **[object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** 'text' - new text
            'transition' - whether to do CSS transition for change.

Returns **Promise.Object** request response
