<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [Highlighter](#highlighter)
    -   [showBoxModel](#showboxmodel)
    -   [hideBoxModel](#hideboxmodel)
    -   [pick](#pick)
    -   [pickAndFocus](#pickandfocus)
    -   [cancelPick](#cancelpick)

## Highlighter

**Extends Actor**

The Highlighter is the server-side entry points for any tool that wishes to
highlight elements in some way in the content document.

A little bit of vocabulary:

-   <something>HighlighterActor classes are the actors that can be used from
    the client. They do very little else than instantiate a given
    <something>Highlighter and use it to highlight elements.
-   <something>Highlighter classes aren't actors, they're just JS classes that
    know how to create and attach the actual highlighter elements on top of the
    content

The most used highlighter actor is the HighlighterActor which can be
conveniently retrieved via the InspectorActor's 'getHighlighter' method.
The InspectorActor will always return the same instance of
HighlighterActor if asked several times and this instance is used in the
toolbox to highlighter elements's box-model from the markup-view,
box model view, console, debugger, ... as well as select elements with the
pointer (pick).

Other types of highlighter actors exist and can be accessed via the
InspectorActor's 'getHighlighterByType' method.

### showBoxModel

Display the box model highlighting on a given NodeActor.
There is only one instance of the box model highlighter, so calling this
method several times won't display several highlighters, it will just move
the highlighter instance to these nodes.

**Parameters**

-   `node` **NodeActor** The node to be highlighted
-   `region` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** region of box model
-   `hideInfoBar` **[Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** true if to hide info bar
-   `hideGuides` **[Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** true if to hide guides
-   `showOnly` **[Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** true if show only
-   `onlyRegionArea` **[Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** true if only region area

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### hideBoxModel

Hide the box model highlighting if it was shown before

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### pick

Pick a node on click, and highlight hovered nodes in the process.

This method doesn't respond anything interesting, however, it starts
mousemove, and click listeners on the content document to fire
events and let connected clients know when nodes are hovered over or
clicked.

Once a node is picked, events will cease, and listeners will be removed.

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### pickAndFocus

This pick method also focuses the highlighter's target window.

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### cancelPick

cancel current pick

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response
