<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [Profiler](#profiler)
    -   [startProfiler](#startprofiler)
    -   [stopProfiler](#stopprofiler)
    -   [getProfile](#getprofile)
    -   [getFeatures](#getfeatures)
    -   [getBufferInfo](#getbufferinfo)
    -   [getStartOptions](#getstartoptions)
    -   [isActive](#isactive)
    -   [sharedLibraries](#sharedlibraries)
    -   [registerEventNotifications](#registereventnotifications)
    -   [unregisterEventNotifications](#unregistereventnotifications)
    -   [setProfilerStatusInterval](#setprofilerstatusinterval)

## Profiler

**Extends Actor**

Main interface for interacting with nsIProfiler

### startProfiler

Starts the nsIProfiler module. Doing so will discard any samples
that might have been accumulated so far.

**Parameters**

-   `entries` **[Number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** number of entries
-   `interval` **[Number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** recording interval
-   `features` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)>** list of features to include
-   `threadFilters` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)>** list of thread filters

Returns **Promise.Object** request response

### stopProfiler

Attempts to stop the nsIProfiler module.

Returns **Promise.Object** request response

### getProfile

Returns all the samples accumulated since the profiler was started,
along with the current time. The data has the following format:
{
  libs: string,
  meta: {
    interval: number,
    platform: string,
    ...
  },
  threads: \[{
    samples: \[{
      frames: [{
        line: number,
        location: string,
        category: number
      } ... ],
      name: string
      responsiveness: number
      time: number
    } ... ]
  } ... ]
}

**Parameters**

-   `startTime` **[Number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** Since the circular buffer will only grow as long as the profiler lives,
           the buffer can contain unwanted samples. Pass in a `startTime` to only
           retrieve samples that took place after the `startTime`, with 0 being
           when the profiler just started.
-   `stringify` **[Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** Whether or not the returned profile object should be a string or not to
           save JSON parse/stringify cycle if emitting over RDP.

### getFeatures

Returns an array of feature strings, describing the profiler features
that are available on this platform. Can be called while the profiler
is stopped.

Returns **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;Promise.String>** list of feature strings

### getBufferInfo

Returns an object with the values of the current status of the
circular buffer in the profiler, returning `position`, `totalSize`,
and the current `generation` of the buffer.

Returns **Promise.Object** current status of the circular buffer

### getStartOptions

Returns the configuration used that was originally passed in to start up the
profiler. Used for tests, and does not account for others using nsIProfiler.

Returns **Promise.Object** profiler configurations

### isActive

Verifies whether or not the nsIProfiler module has started.
If already active, the current time is also returned.

Returns **Promise.Boolean** true if nsIProfiler module has started

### sharedLibraries

Returns an array of objects that describes the shared libraries
which are currently loaded into our process. Can be called while the
profiler is stopped.

Returns **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;Promise.Object>** list of objects that describes the shared libraries

### registerEventNotifications

Registers handlers for the following events to be emitted
on active Profiler instances:

-   "console-api-profiler"
-   "profiler-started"
-   "profiler-stopped"
-   "profiler-status"

The ProfilerManager listens to all events, and individual
consumers filter which events they are interested in.

**Parameters**

-   `events` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)>** events to listen to

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### unregisterEventNotifications

Unregisters handlers for all system events.

**Parameters**

-   `events` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)>** events to unregister of

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### setProfilerStatusInterval

Updates the frequency that the "profiler-status" event is emitted
during recording.

**Parameters**

-   `interval` **[Number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** interval of recording
