<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [Performance](#performance)
    -   [canCurrentlyRecord](#cancurrentlyrecord)
    -   [startRecording](#startrecording)
    -   [stopRecording](#stoprecording)
    -   [isRecording](#isrecording)
    -   [getRecordings](#getrecordings)
    -   [getConfiguration](#getconfiguration)

## Performance

**Extends Actor**

-   **See: devtools/shared/shared/performance.js for documentation.**

This actor wraps the Performance module at devtools/shared/shared/performance.js
and provides RDP definitions.

### canCurrentlyRecord

Checks whether or not a new recording is supported by the PerformanceFront.

**Parameters**

-   `options`  

Returns **Promise.Boolean** true if it can record performance

### startRecording

Begins a recording session.

**Parameters**

-   `options`  

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** A promise that is resolved once recording has started.

### stopRecording

Manually ends the recording session for the corresponding PerformanceRecording.

**Parameters**

-   `options`  
-   `model` **PerformanceRecording** The corresponding PerformanceRecording that belongs to the recording
           session wished to stop.

Returns **Promise.PerformanceRecording** Returns the same model, populated with the profiling data.

### isRecording

Checks all currently stored recording handles and returns a boolean
if there is a session currently being recorded.

Returns **[Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** true if actor is currently recording

### getRecordings

Returns all current recordings.

Returns **Promise.PerformanceRecording** returns model with populated profing data

### getConfiguration

Returns the configurations set on underlying components, used in tests.
Returns an object with `probability`, `maxLogLength` for allocations, and
`features`, `threadFilters`, `entries` and `interval` for profiler.

Returns **Promise.Object** 
