<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [Memory](#memory)
    -   [attach](#attach)
    -   [detach](#detach)
    -   [getState](#getstate)
    -   [takeCensus](#takecensus)
    -   [startRecordingAllocations](#startrecordingallocations)
    -   [stopRecordingAllocations](#stoprecordingallocations)
    -   [getAllocationsSettings](#getallocationssettings)
    -   [getAllocations](#getallocations)
    -   [forceGarbageCollection](#forcegarbagecollection)
    -   [forceCycleCollection](#forcecyclecollection)
    -   [measure](#measure)
    -   [saveHeapSnapshot](#saveheapsnapshot)

## Memory

**Extends Actor**

An actor that returns memory usage data for its parent actor's window. A tab-scoped instance
of this actor will measure the memory footprint of its parent tab. A global-scoped instance
however, will measure the memory footprint of the chrome window referenced by the root actor.

This actor wraps the Memory module at devtools/server/performance/memory.js
and provides RDP definitions.

**Parameters**

-   `client`  
-   `name`  

### attach

Attach to this MemoryBridge.

This attaches the MemoryBridge's Debugger instance so that you can start
recording allocations or take a census of the heap. In addition, the
MemoryBridge will start emitting GC events.

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### detach

Detach from this MemoryBridge.

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### getState

Gets the current MemoryBridge attach/detach state.

Returns **Promise.String** attach/detach state

### takeCensus

Take a census of the heap. See js/src/doc/Debugger/Debugger.Memory.md for more information.

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### startRecordingAllocations

Start recording allocation sites.

**Parameters**

-   `options`  

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### stopRecordingAllocations

Stop recording allocation sites.

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### getAllocationsSettings

Return settings used in `startRecordingAllocations` for `probability` and `maxLogLength`.
Currently only uses in tests.

Returns **Promise.Object** allocation settings

### getAllocations

Get a list of the most recent allocations since the last time we got
allocations, as well as a summary of all allocations since we've been
recording.

Returns **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** An object of the form:  {
    allocations: [<index into "frames" below>, ...],
    allocationsTimestamps: \[
      &lt;timestamp for allocations[0]>,
      &lt;timestamp for allocations[1]>,
      ...
    ],
    allocationSizes: \[
      &lt;bytesize for allocations[0]>,
      &lt;bytesize for allocations[1]>,
      ...
    ],
    frames: [
      {
        line: <line number for this frame>,
        column: <column number for this frame>,
        source: <filename string for this frame>,
        functionDisplayName:
          <this frame's inferred function name function or null>,
        parent: <index into "frames">
      },
      ...
    ],
  }The timestamps' unit is microseconds since the epoch.Subsequent `getAllocations` request within the same recording and
tab navigation will always place the same stack frames at the same
indices as previous `getAllocations` requests in the same
recording. In other words, it is safe to use the index as a
unique, persistent id for its frame.Additionally, the root node (null) is always at index 0.We use the indices into the "frames" array to avoid repeating the
description of duplicate stack frames both when listing
allocations, and when many stacks share the same tail of older
frames. There shouldn't be any duplicates in the "frames" array,
as that would defeat the purpose of this compression trick.In the future, we might want to split out a frame's "source" and
"functionDisplayName" properties out the same way we have split
frames out with the "frames" array. While this would further
compress the size of the response packet, it would increase CPU
usage to build the packet, and it should, of course, be guided by
profiling and done only when necessary.

### forceGarbageCollection

Force a browser-wide GC.

Returns **Promise.Object** allocation settings

### forceCycleCollection

Force an XPCOM cycle collection. For more information on XPCOM cycle
collection, see <https://developer.mozilla.org/en-US/docs/Interfacing_with_the_XPCOM_cycle_collector#What_the_cycle_collector_does>

Returns **Promise.Object** request response

### measure

A method that returns a detailed breakdown of the memory consumption of the
associated window.

Returns **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** memory consumption

### saveHeapSnapshot

Save a heap snapshot scoped to the current debuggees' portion of the heap
graph.

**Parameters**

-   `boundaries` **([Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object) | null)** 

Returns **[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** The snapshot id.
