<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [Inspector](#inspector)
    -   [getWalker](#getwalker)
    -   [getPageStyle](#getpagestyle)
    -   [getHighlighter](#gethighlighter)
    -   [getHighlighterByType](#gethighlighterbytype)
    -   [getImageDataFromURL](#getimagedatafromurl)
    -   [resolveRelativeURL](#resolverelativeurl)
    -   [pickColorFromPage](#pickcolorfrompage)
    -   [cancelPickColorFromPage](#cancelpickcolorfrompage)
    -   [supportsHighlighters](#supportshighlighters)

## Inspector

**Extends Actor**

Server side of the inspector actor, which is used to create
inspector-related actors, including the walker.

### getWalker

Get walker

**Parameters**

-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Walker options

Returns **Promise.Object** Walker

### getPageStyle

Get page style actor.

Returns **Promise.Pagestyle** Pagestyle actor

### getHighlighter

The most used highlighter actor is the HighlighterActor which can be conveniently
retrieved by this method. The same instance will always be returned by this method
when called several times. The highlighter actor returned here is used to highlighter
elements's box-models from the markup-view, box model, console, debugger, ... as well
as select elements with the pointer (pick).

**Parameters**

-   `autohide` **[Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** Optionally autohide the highlighter after an element has been picked

Returns **Promise.Highlighter** instance of highlighter

### getHighlighterByType

If consumers need to display several highlighters at the same time or different types of
highlighters, then this method should be used, passing the type name of the highlighter
needed as argument. A new instance will be created everytime the method is called, so it's
up to the consumer to release it when it is not needed anymore

**Parameters**

-   `typeName` **[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** The type of highlighter to create

Returns **Promise.Highlighter** The highlighter actor instance or null if the typeName passed
                               doesn't match any available highlighter

### getImageDataFromURL

Get the node's image data if any (for canvas and img nodes). Returns an imageData object with
the actual data being a LongStringActor and a size json object. The image data is transmitted
as a base64 encoded png data-uri. The method rejects if the node isn't an image or if the
image is missing.

Accepts a maxDim request parameter to resize images that are larger. This is important as the
resizing occurs server-side so that image-data being transfered in the longstring back to the
client will be that much smaller.

**Parameters**

-   `url` **[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** image url
-   `maxDim` **[Number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** resizing parameter

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** image data

### resolveRelativeURL

Resolve a URL to its absolute form, in the scope of a given content window.

**Parameters**

-   `url` **[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** url to be resolved
-   `node` **NodeActor** If provided, the owner window of this node will be used to resolve
                              the URL. Otherwise, the top-level content window will be used instead.

Returns **Promise.String** resolved url

### pickColorFromPage

Pick a color from the page using the eye-dropper. This method doesn't return anything
but will cause events to be sent to the front when a color is picked or when the user
cancels the picker.

**Parameters**

-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** color picker options

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### cancelPickColorFromPage

After the pickColorFromPage method is called, the only way to dismiss the eye-dropper
highlighter is for the user to click in the page and select a color. If you need to
dismiss the eye-dropper programatically instead, use this method.

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response

### supportsHighlighters

Check if the current document supports highlighters using a canvasFrame anonymous
content container (ie all highlighters except the SimpleOutlineHighlighter).
It is impossible to detect the feature programmatically as some document types simply
don't render the canvasFrame without throwing any error.

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)** request response
