<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [Emulation](#emulation)
    -   [setDPPXOverride](#setdppxoverride)
    -   [getDPPXOverride](#getdppxoverride)
    -   [clearDPPXOverride](#cleardppxoverride)
    -   [setNetworkThrottling](#setnetworkthrottling)
    -   [getNetworkThrottling](#getnetworkthrottling)
    -   [clearNetworkThrottling](#clearnetworkthrottling)
    -   [setTouchEventsOverride](#settoucheventsoverride)
    -   [getTouchEventsOverride](#gettoucheventsoverride)
    -   [clearTouchEventsOverride](#cleartoucheventsoverride)
    -   [setUserAgentOverride](#setuseragentoverride)
    -   [getUserAgentOverride](#getuseragentoverride)
    -   [clearUserAgentOverride](#clearuseragentoverride)

## Emulation

**Extends Actor**

This actor overrides various browser features to simulate different environments to
test how pages perform under various conditions.

The design below, which saves the previous value of each property before setting, is
needed because it's possible to have multiple copies of this actor for a single page.
When some instance of this actor changes a property, we want it to be able to restore
that property to the way it was found before the change.

A subtle aspect of the code below is that all get\* methods must return non-undefined
values, so that the absence of a previous value can be distinguished from the value for
"no override" for each of the properties.

### setDPPXOverride

overwrite DPPX value

**Parameters**

-   `dppx` **Nimber** dppx value

Returns **Promise.Boolean** true if value has changed

### getDPPXOverride

get current DPPX value

Returns **Promise.Number** current dppx value

### clearDPPXOverride

clear DPPX value

Returns **Promise.Boolean** true if value has changed

### setNetworkThrottling

Transform the RDP format into the internal format and then set network throttling.

**Parameters**

-   `downloadThroughput` **[Number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** throughput in byte/s
-   `uploadThroughput` **[Number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** throughput in byte/s
-   `latency` **[Number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** latency time in ms

Returns **Promise.Boolean** true if value has changed

### getNetworkThrottling

Get network throttling and then transform the internal format into the RDP format.

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** state of current throttle

### clearNetworkThrottling

clear network throttling

Returns **Promise.Boolean** true if value has changed

### setTouchEventsOverride

overwrite touch events

**Parameters**

-   `flag` **[Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** true if overwrite is enabled

Returns **Promise.Boolean** true if value has changed

### getTouchEventsOverride

check if touch event overwrite is enabled

Returns **Promise.Boolean** true if enabled

### clearTouchEventsOverride

clear state of touch event overwrite

Returns **Promise.Boolean** true if enabled

### setUserAgentOverride

Overwrite user agent

**Parameters**

-   `userAgent` **[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** new user agent

Returns **Promise.Boolean** true if value has changed

### getUserAgentOverride

Get current user agent overwrite

Returns **Promise.String** current user agent

### clearUserAgentOverride

Clear user agent overwrite

Returns **Promise.Boolean** true if value has changed
