<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [CSSUsage](#cssusage)
    -   [start](#start)
    -   [stop](#stop)
    -   [toggle](#toggle)
    -   [oneshot](#oneshot)
    -   [createEditorReport](#createeditorreport)
    -   [createEditorReportForSheet](#createeditorreportforsheet)
    -   [createPageReport](#createpagereport)

## CSSUsage

**Extends Actor**

CSSUsage manages the collection of CSS usage data.
The core of a CSSUsage is a JSON-able data structure called \_knownRules
which looks like this:
This records the CSSStyleRules and their usage.
The format is:
    Map({
      <CSS-URL>\|<START-LINE>\|<START-COLUMN>: {
        selectorText: &lt;CSSStyleRule.selectorText>,
        test: &lt;simplify(CSSStyleRule.selectorText)>,
        cssText: &lt;CSSStyleRule.cssText>,
        isUsed: &lt;TRUE|FALSE>,
        presentOn: Set([ <HTML-URL>, ... ]),
        preLoadOn: Set([ <HTML-URL>, ... ]),
        isError: &lt;TRUE|FALSE>,
      }
    })

For example:
    this.\_knownRules = Map({
      "<http://eg.com/styles1.css|15|0">: {
        selectorText: "p.quote:hover",
        test: "p.quote",
        cssText: "p.quote { color: red; }",
        isUsed: true,
        presentOn: Set([ "http://eg.com/page1.html", ... ]),
        preLoadOn: Set([ "http://eg.com/page1.html" ]),
        isError: false,
      }, ...
    });

### start

Begin recording usage data

**Parameters**

-   `url` **[Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** It's best if we start by reloading the current page
                                  because that starts the test at a known point, but there could be reasons
                                  why we don't want to do that (e.g. the page contains state that will be
                                  lost across a reload) (optional, default `false`)

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** request response

### stop

Cease recording usage data

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** request response

### toggle

Start/stop recording usage data depending on what we're currently doing.

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** request response

### oneshot

Running start() quickly followed by stop() does a bunch of unnecessary work, so this cuts all that out

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** request response

### createEditorReport

Returns a JSONable structure designed to help marking up the style editor,
which describes the CSS selector usage.
Example:
[
    {
        selectorText: "p#content",
        usage: "unused|used",
        start: { line: 3, column: 0 },
    },
    ...
]

**Parameters**

-   `url` **[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** url of page you want to audit

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** request response

### createEditorReportForSheet

Compute the stylesheet URL and delegate the report creation to createEditorReport.
See createEditorReport documentation.

**Parameters**

-   `url` **[String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** url of page you want to audit

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** request response

### createPageReport

Returns a JSONable structure designed for the page report which shows
the recommended changes to a page.

"preload" means that a rule is used before the load event happens, which
means that the page could by optimized by placing it in a <style> element
at the top of the page, moving the <link> elements to the bottom.

Example:
  {
    preload: \[
      {
        url: "<http://example.org/page1.html">,
        shortUrl: "page1.html",
        rules: [
          {
            url: "http://example.org/style1.css",
            shortUrl: "style1.css",
            start: { line: 3, column: 4 },
            selectorText: "p#content",
            formattedCssText: "p#content {\n  color: red;\n }\n"
         },
         ...
        ]
      }
    ],
    unused: \[
      {
        url: "<http://example.org/style1.css">,
        shortUrl: "style1.css",
        rules: [ ... ]
      }
    ]
  }

Returns **[Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** request response
