"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addEventListener = addEventListener;
exports.removeEventListeners = removeEventListeners;
exports.transformEvaluateArgs = transformEvaluateArgs;
exports.transformEvaluateScript = transformEvaluateScript;

function addEventListener(emitter, eventName, handler) {
  emitter.on(eventName, handler);
  return {
    emitter,
    eventName,
    handler
  };
}

function removeEventListeners(listeners) {
  for (const listener of listeners) {
    listener.emitter.removeListener(listener.eventName, listener.handler);
  }

  listeners.splice(0, listeners.length);
}

function transformEvaluateArgs(args) {
  args = Array.isArray(args) ? args : [args];
  return JSON.stringify(args.map(arg => {
    if (typeof arg === 'function') {
      return arg.toString();
    }

    return arg;
  }));
}

function transformEvaluateScript(script, argsTransformed) {
  if (typeof script === 'function') {
    return `(${script}).apply(window, ${argsTransformed})`;
  }

  return `(function () { ${script} }).apply(window, ${argsTransformed})`;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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