"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("./actor");

var _actor2 = _interopRequireDefault(_actor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Tab extends _actor2.default {
  constructor(client, name, data) {
    super(client, name, data);
    this._onTabNavigated = null;
    this.on('tabNavigated', event => {
      if (event.state === 'stop') {
        this._onTabNavigated && this._onTabNavigated(event);
      }
    });
  }

  get console() {
    return this._get('console');
  }

  get network() {
    return this._get('console', 'network');
  }

  get storage() {
    return this._get('storage');
  }

  get memory() {
    return this._get('memory');
  }

  get performance() {
    return this._get('performance');
  }

  get profiler() {
    return this._get('profiler');
  }

  get timeline() {
    return this._get('timeline');
  }

  get styleSheets() {
    return this._get('styleSheets');
  }

  get cssUsage() {
    return this._get('cssUsage');
  }

  get cssProperties() {
    return this._get('cssProperties');
  }

  get emulation() {
    return this._get('emulation');
  }

  get inspector() {
    return this._get('inspector');
  }
  /**
   * Firefox 75: Gets Tab's actors
   * @returns {Promise} request promise
   */


  async getTarget() {
    let targets = await this.request('getTarget');
    this.name = targets.frame.actor;
    this.data = targets.frame;
    this.setActors(this.data);
  }
  /**
   * Disable/Enables cache
   * @param {Boolean} disable
   * @returns {Promise} request promise
   */


  cacheDisabled(disable) {
    return this.request('reconfigure', {
      'options': {
        cacheDisabled: disable
      }
    });
  }
  /**
   * Calls a callback on tab navigated event
   * @param  {Function} callback  function to be called
   */


  onTabNavigated(callback) {
    this._onTabNavigated = callback;
  }
  /**
   * attach to tab
   * @return {Promise}  request promise
   */


  attach() {
    return this.request('attach');
  }
  /**
   * detach from tab
   * @return {Promise}  request promise
   */


  detach() {
    return this.request('detach');
  }
  /**
   * reloads current page url
   * @return {Promise}  request promise
   */


  reload() {
    return this.request('reload');
  }
  /**
   * navigates to a certain url
   * @param  {string}  url to navigate to
   * @return {Promise}     request promise
   */


  navigateTo(url) {
    return this.request('navigateTo', {
      url
    });
  }

}

exports.default = Tab;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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