"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

var _longString = require("./longString");

var _longString2 = _interopRequireDefault(_longString);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Request extends _actor2.default {
  constructor(client, event) {
    super(client, event.actor);
    this.startedDateTime = event.startedDateTime;
    this.timeStamp = event.timeStamp;
    this.url = event.url;
    this.method = event.method;
    this.isXHR = event.isXHR;
    this.fromCache = event.fromCache;
    this.cause = event.cause;
    this.private = event.private;
    this.on('networkEventUpdate', this.onUpdate.bind(this));
  }
  /**
   * Retrieve the request headers from the given NetworkEventActor.
   */


  getRequestHeaders() {
    return this.request('getRequestHeaders');
  }
  /**
   * Retrieve the request cookies from the given NetworkEventActor.
   */


  getRequestCookies() {
    return this.request('getRequestCookies');
  }
  /**
   * Retrieve the request post data from the given NetworkEventActor.
   * if this type is a LongString, call LongString to retrive the rest of the data
   * @returns {Promise.<String>}
   */


  async getRequestPostData() {
    const {
      postData
    } = await this.request('getRequestPostData');

    if (postData.text.type && postData.text.type === 'longString') {
      const longPost = new _longString2.default(this.client, postData.text.actor);
      return longPost.substring(0, postData.text.length);
    }

    return postData.text;
  }
  /**
   * Retrieve the response headers from the given NetworkEventActor.
   */


  getResponseHeaders() {
    return this.request('getResponseHeaders');
  }
  /**
   * Retrieve the response cookies from the given NetworkEventActor.
   */


  getResponseCookies() {
    return this.request('getResponseCookies');
  }
  /**
   * Retrieve the response content from the given NetworkEventActor.
   */


  getResponseContent() {
    const data = this.request('getResponseContent');

    if (data.content && data.content.text.type && data.content.text.type === 'longString') {
      const longPost = new _longString2.default(this.client, data.content.text.actor);
      return longPost.substring(0, data.content.text.length);
    }

    return data;
  }
  /**
   * Retrieve the timing information for the given NetworkEventActor.
   */


  getEventTimings() {
    return this.request('getEventTimings');
  }

  getResponseStart() {
    return this.request('getResponseStart');
  }

  onUpdate(e) {
    const type = `on${e.updateType[0].toUpperCase()}${e.updateType.slice(1)}`;
    this.emit(type, e);
  }
  /**
   * Retrieve the security information for the given NetworkEventActor.
   */


  getSecurityInfo() {
    return this.request('getSecurityInfo');
  }

}

exports.default = Request;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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