"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Logger;

const debug = require('debug')('@benmalka/foxdriver')

var _package = require("../package.json");

var _package2 = _interopRequireDefault(_package);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * levels that are available from `npmlog`
 */
const NPM_LEVELS = ['silly', 'verbose', 'debug', 'info', 'http', 'warn', 'error', 'chrome', 'firefox'];

function Logger(component) {
  const wrappedLogger = {};
  const prefix = _package2.default.name + (component ? `:${component}` : '');
  /**
   * allow access to the level of the underlying logger
   */

  Object.defineProperty(wrappedLogger, 'level', {
    get: () => {
    },
    set: newValue => {
    },
    enumerable: true,
    configurable: true
  });
  /**
   * add all the levels from `npmlog`, and map to the underlying logger
   */

  for (let level of NPM_LEVELS) {
    wrappedLogger[level] = (...args) => {
      // @see https://github.com/cypress-io/cypress/issues/7723
      debug(prefix, ...args)
    };
  }

  if (process.env.NODE_ENV && process.env.NODE_ENV === 'development') {
    wrappedLogger.level = 'verbose';
  }

  wrappedLogger.levels = NPM_LEVELS;
  return wrappedLogger;
}

module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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