"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _launcher = require("./launcher");

var _launcher2 = _interopRequireDefault(_launcher);

var _browser = require("./browser");

var _browser2 = _interopRequireDefault(_browser);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Foxdriver {
  static async attach(host, port) {
    if (typeof host !== 'string' || typeof port !== 'number') {
      throw new Error('attach() requires host and port parameter');
    }

    const browser = new _browser2.default(host, port);
    const tabs = await browser.connect();
    return {
      browser,
      tabs
    };
  }

  static launch(options) {
    return _launcher2.default.launch(options);
  }

}

exports.default = Foxdriver;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL2xpYi9pbmRleC5qcyJdLCJuYW1lcyI6WyJGb3hkcml2ZXIiLCJhdHRhY2giLCJob3N0IiwicG9ydCIsIkVycm9yIiwiYnJvd3NlciIsIkJyb3dzZXIiLCJ0YWJzIiwiY29ubmVjdCIsImxhdW5jaCIsIm9wdGlvbnMiLCJMYXVuY2hlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7Ozs7QUFDQTs7Ozs7O0FBRWUsTUFBTUEsU0FBTixDQUFnQjtBQUMzQixlQUFhQyxNQUFiLENBQXFCQyxJQUFyQixFQUEyQkMsSUFBM0IsRUFBaUM7QUFDN0IsUUFBSSxPQUFPRCxJQUFQLEtBQWdCLFFBQWhCLElBQTRCLE9BQU9DLElBQVAsS0FBZ0IsUUFBaEQsRUFBMEQ7QUFDdEQsWUFBTSxJQUFJQyxLQUFKLENBQVUsMkNBQVYsQ0FBTjtBQUNIOztBQUVELFVBQU1DLE9BQU8sR0FBRyxJQUFJQyxpQkFBSixDQUFZSixJQUFaLEVBQWtCQyxJQUFsQixDQUFoQjtBQUNBLFVBQU1JLElBQUksR0FBRyxNQUFNRixPQUFPLENBQUNHLE9BQVIsRUFBbkI7QUFDQSxXQUFPO0FBQUVILE1BQUFBLE9BQUY7QUFBV0UsTUFBQUE7QUFBWCxLQUFQO0FBQ0g7O0FBRUQsU0FBT0UsTUFBUCxDQUFlQyxPQUFmLEVBQXdCO0FBQ3BCLFdBQU9DLG1CQUFTRixNQUFULENBQWdCQyxPQUFoQixDQUFQO0FBQ0g7O0FBYjBCOztrQkFBVlYsUyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBMYXVuY2hlciBmcm9tICcuL2xhdW5jaGVyJ1xyXG5pbXBvcnQgQnJvd3NlciBmcm9tICcuL2Jyb3dzZXInXHJcblxyXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBGb3hkcml2ZXIge1xyXG4gICAgc3RhdGljIGFzeW5jIGF0dGFjaCAoaG9zdCwgcG9ydCkge1xyXG4gICAgICAgIGlmICh0eXBlb2YgaG9zdCAhPT0gJ3N0cmluZycgfHwgdHlwZW9mIHBvcnQgIT09ICdudW1iZXInKSB7XHJcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcignYXR0YWNoKCkgcmVxdWlyZXMgaG9zdCBhbmQgcG9ydCBwYXJhbWV0ZXInKVxyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgY29uc3QgYnJvd3NlciA9IG5ldyBCcm93c2VyKGhvc3QsIHBvcnQpXHJcbiAgICAgICAgY29uc3QgdGFicyA9IGF3YWl0IGJyb3dzZXIuY29ubmVjdCgpXHJcbiAgICAgICAgcmV0dXJuIHsgYnJvd3NlciwgdGFicyB9XHJcbiAgICB9XHJcblxyXG4gICAgc3RhdGljIGxhdW5jaCAob3B0aW9ucykge1xyXG4gICAgICAgIHJldHVybiBMYXVuY2hlci5sYXVuY2gob3B0aW9ucylcclxuICAgIH1cclxufVxyXG4iXX0=