"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

var _cookies = require("../models/cookies");

var _cookies2 = _interopRequireDefault(_cookies);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Storage extends _actor2.default {
  constructor(client, name) {
    super(client, name);
    this.hosts = {};
  }
  /**
   * Get storage list and register each to the client
   *
   * @return {Promise.<Object>} request response
   */


  async listStores() {
    const storages = await this.request('listStores');

    if (storages.cookies) {
      this.hosts.cookies = Object.keys(storages.cookies.hosts);
      this.cookies = new _cookies2.default(this.client, storages.cookies.actor);
    }

    return storages;
  }

}

exports.default = Storage;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi9kb21haW5zL3N0b3JhZ2UuanMiXSwibmFtZXMiOlsiU3RvcmFnZSIsIkFjdG9yIiwiY29uc3RydWN0b3IiLCJjbGllbnQiLCJuYW1lIiwiaG9zdHMiLCJsaXN0U3RvcmVzIiwic3RvcmFnZXMiLCJyZXF1ZXN0IiwiY29va2llcyIsIk9iamVjdCIsImtleXMiLCJDb29raWVzIiwiYWN0b3IiXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7OztBQUVlLE1BQU1BLE9BQU4sU0FBc0JDLGVBQXRCLENBQTRCO0FBQ3ZDQyxFQUFBQSxXQUFXLENBQUVDLE1BQUYsRUFBVUMsSUFBVixFQUFnQjtBQUN2QixVQUFNRCxNQUFOLEVBQWNDLElBQWQ7QUFDQSxTQUFLQyxLQUFMLEdBQWEsRUFBYjtBQUNIO0FBRUQ7Ozs7Ozs7QUFLQSxRQUFNQyxVQUFOLEdBQW9CO0FBQ2hCLFVBQU1DLFFBQVEsR0FBRyxNQUFNLEtBQUtDLE9BQUwsQ0FBYSxZQUFiLENBQXZCOztBQUNBLFFBQUlELFFBQVEsQ0FBQ0UsT0FBYixFQUFzQjtBQUNsQixXQUFLSixLQUFMLENBQVdJLE9BQVgsR0FBcUJDLE1BQU0sQ0FBQ0MsSUFBUCxDQUFZSixRQUFRLENBQUNFLE9BQVQsQ0FBaUJKLEtBQTdCLENBQXJCO0FBQ0EsV0FBS0ksT0FBTCxHQUFlLElBQUlHLGlCQUFKLENBQVksS0FBS1QsTUFBakIsRUFBeUJJLFFBQVEsQ0FBQ0UsT0FBVCxDQUFpQkksS0FBMUMsQ0FBZjtBQUNIOztBQUNELFdBQU9OLFFBQVA7QUFDSDs7QUFsQnNDOztrQkFBdEJQLE8iLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgQWN0b3IgZnJvbSAnLi4vYWN0b3InXHJcbmltcG9ydCBDb29raWVzIGZyb20gJy4uL21vZGVscy9jb29raWVzJ1xyXG5cclxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU3RvcmFnZSBleHRlbmRzIEFjdG9yIHtcclxuICAgIGNvbnN0cnVjdG9yIChjbGllbnQsIG5hbWUpIHtcclxuICAgICAgICBzdXBlcihjbGllbnQsIG5hbWUpXHJcbiAgICAgICAgdGhpcy5ob3N0cyA9IHt9XHJcbiAgICB9XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBHZXQgc3RvcmFnZSBsaXN0IGFuZCByZWdpc3RlciBlYWNoIHRvIHRoZSBjbGllbnRcclxuICAgICAqXHJcbiAgICAgKiBAcmV0dXJuIHtQcm9taXNlLjxPYmplY3Q+fSByZXF1ZXN0IHJlc3BvbnNlXHJcbiAgICAgKi9cclxuICAgIGFzeW5jIGxpc3RTdG9yZXMgKCkge1xyXG4gICAgICAgIGNvbnN0IHN0b3JhZ2VzID0gYXdhaXQgdGhpcy5yZXF1ZXN0KCdsaXN0U3RvcmVzJylcclxuICAgICAgICBpZiAoc3RvcmFnZXMuY29va2llcykge1xyXG4gICAgICAgICAgICB0aGlzLmhvc3RzLmNvb2tpZXMgPSBPYmplY3Qua2V5cyhzdG9yYWdlcy5jb29raWVzLmhvc3RzKVxyXG4gICAgICAgICAgICB0aGlzLmNvb2tpZXMgPSBuZXcgQ29va2llcyh0aGlzLmNsaWVudCwgc3RvcmFnZXMuY29va2llcy5hY3RvcilcclxuICAgICAgICB9XHJcbiAgICAgICAgcmV0dXJuIHN0b3JhZ2VzXHJcbiAgICB9XHJcbn1cclxuIl19