"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Actor to manage browser preferences.
 */
class Preference extends _actor2.default {
  /**
   * Get boolean preference.
   *
   * @param  {String}  value    name of preference
   * @return {Promise.Boolean}  preference value
   */
  async getBoolPref(value) {
    const response = await this.request('getBoolPref', {
      value
    });
    return response.value;
  }
  /**
   * Get char preference.
   *
   * @param  {String}  value  name of preference
   * @return {Promise.Char}   preference value
   */


  async getCharPref(value) {
    const response = await this.request('getCharPref', {
      value
    });
    return response.value;
  }
  /**
   * Get integer preference.
   *
   * @param  {String}  value    name of preference
   * @return {Promise.Number}   preference value
   */


  async getIntPref(value) {
    const response = await this.request('getIntPref', {
      value
    });
    return response.value;
  }
  /**
   * Get all preferences.
   *
   * @return {Promise.Object[]}  list of preferences
   */


  async getAllPrefs() {
    const {
      value
    } = await this.request('getAllPrefs');
    return value;
  }
  /**
   * Set boolean preference.
   *
   * @param {String}  name   preference name
   * @param {Boolean} value  preference value
   * @return {Promise}       request response
   */


  setBoolPref(name, value) {
    return this.request('setBoolPref', {
      name,
      value
    });
  }
  /**
   * Set char preference.
   *
   * @param {String}  name   preference name
   * @param {Char}    value  preference value
   * @return {Promise}       request response
   */


  setCharPref(name, value) {
    return this.request('setCharPref', {
      name,
      value
    });
  }
  /**
   * Set integer preference.
   *
   * @param {String}  name   preference name
   * @param {Number}  value  preference value
   * @return {Promise}       request response
   */


  setIntPref(name, value) {
    return this.request('setIntPref', {
      name,
      value
    });
  }
  /**
   * Clear user set preference
   * @param  {Srting} name  name of preference
   * @return {Promise}      request response
   */


  clearUserPref(name) {
    return this.request('clearUserPref', {
      name
    });
  }

}

exports.default = Preference;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi9kb21haW5zL3ByZWZlcmVuY2UuanMiXSwibmFtZXMiOlsiUHJlZmVyZW5jZSIsIkFjdG9yIiwiZ2V0Qm9vbFByZWYiLCJ2YWx1ZSIsInJlc3BvbnNlIiwicmVxdWVzdCIsImdldENoYXJQcmVmIiwiZ2V0SW50UHJlZiIsImdldEFsbFByZWZzIiwic2V0Qm9vbFByZWYiLCJuYW1lIiwic2V0Q2hhclByZWYiLCJzZXRJbnRQcmVmIiwiY2xlYXJVc2VyUHJlZiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7Ozs7OztBQUVBOzs7QUFHZSxNQUFNQSxVQUFOLFNBQXlCQyxlQUF6QixDQUErQjtBQUMxQzs7Ozs7O0FBTUEsUUFBTUMsV0FBTixDQUFtQkMsS0FBbkIsRUFBMEI7QUFDdEIsVUFBTUMsUUFBUSxHQUFHLE1BQU0sS0FBS0MsT0FBTCxDQUFhLGFBQWIsRUFBNEI7QUFBRUYsTUFBQUE7QUFBRixLQUE1QixDQUF2QjtBQUNBLFdBQU9DLFFBQVEsQ0FBQ0QsS0FBaEI7QUFDSDtBQUVEOzs7Ozs7OztBQU1BLFFBQU1HLFdBQU4sQ0FBbUJILEtBQW5CLEVBQTBCO0FBQ3RCLFVBQU1DLFFBQVEsR0FBRyxNQUFNLEtBQUtDLE9BQUwsQ0FBYSxhQUFiLEVBQTRCO0FBQUVGLE1BQUFBO0FBQUYsS0FBNUIsQ0FBdkI7QUFDQSxXQUFPQyxRQUFRLENBQUNELEtBQWhCO0FBQ0g7QUFFRDs7Ozs7Ozs7QUFNQSxRQUFNSSxVQUFOLENBQWtCSixLQUFsQixFQUF5QjtBQUNyQixVQUFNQyxRQUFRLEdBQUcsTUFBTSxLQUFLQyxPQUFMLENBQWEsWUFBYixFQUEyQjtBQUFFRixNQUFBQTtBQUFGLEtBQTNCLENBQXZCO0FBQ0EsV0FBT0MsUUFBUSxDQUFDRCxLQUFoQjtBQUNIO0FBRUQ7Ozs7Ozs7QUFLQSxRQUFNSyxXQUFOLEdBQXFCO0FBQ2pCLFVBQU07QUFBRUwsTUFBQUE7QUFBRixRQUFZLE1BQU0sS0FBS0UsT0FBTCxDQUFhLGFBQWIsQ0FBeEI7QUFDQSxXQUFPRixLQUFQO0FBQ0g7QUFFRDs7Ozs7Ozs7O0FBT0FNLEVBQUFBLFdBQVcsQ0FBRUMsSUFBRixFQUFRUCxLQUFSLEVBQWU7QUFDdEIsV0FBTyxLQUFLRSxPQUFMLENBQWEsYUFBYixFQUE0QjtBQUFFSyxNQUFBQSxJQUFGO0FBQVFQLE1BQUFBO0FBQVIsS0FBNUIsQ0FBUDtBQUNIO0FBRUQ7Ozs7Ozs7OztBQU9BUSxFQUFBQSxXQUFXLENBQUVELElBQUYsRUFBUVAsS0FBUixFQUFlO0FBQ3RCLFdBQU8sS0FBS0UsT0FBTCxDQUFhLGFBQWIsRUFBNEI7QUFBRUssTUFBQUEsSUFBRjtBQUFRUCxNQUFBQTtBQUFSLEtBQTVCLENBQVA7QUFDSDtBQUVEOzs7Ozs7Ozs7QUFPQVMsRUFBQUEsVUFBVSxDQUFFRixJQUFGLEVBQVFQLEtBQVIsRUFBZTtBQUNyQixXQUFPLEtBQUtFLE9BQUwsQ0FBYSxZQUFiLEVBQTJCO0FBQUVLLE1BQUFBLElBQUY7QUFBUVAsTUFBQUE7QUFBUixLQUEzQixDQUFQO0FBQ0g7QUFFRDs7Ozs7OztBQUtBVSxFQUFBQSxhQUFhLENBQUVILElBQUYsRUFBUTtBQUNqQixXQUFPLEtBQUtMLE9BQUwsQ0FBYSxlQUFiLEVBQThCO0FBQUVLLE1BQUFBO0FBQUYsS0FBOUIsQ0FBUDtBQUNIOztBQXBGeUM7O2tCQUF6QlYsVSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBBY3RvciBmcm9tICcuLi9hY3RvcidcclxuXHJcbi8qKlxyXG4gKiBBY3RvciB0byBtYW5hZ2UgYnJvd3NlciBwcmVmZXJlbmNlcy5cclxuICovXHJcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFByZWZlcmVuY2UgZXh0ZW5kcyBBY3RvciB7XHJcbiAgICAvKipcclxuICAgICAqIEdldCBib29sZWFuIHByZWZlcmVuY2UuXHJcbiAgICAgKlxyXG4gICAgICogQHBhcmFtICB7U3RyaW5nfSAgdmFsdWUgICAgbmFtZSBvZiBwcmVmZXJlbmNlXHJcbiAgICAgKiBAcmV0dXJuIHtQcm9taXNlLkJvb2xlYW59ICBwcmVmZXJlbmNlIHZhbHVlXHJcbiAgICAgKi9cclxuICAgIGFzeW5jIGdldEJvb2xQcmVmICh2YWx1ZSkge1xyXG4gICAgICAgIGNvbnN0IHJlc3BvbnNlID0gYXdhaXQgdGhpcy5yZXF1ZXN0KCdnZXRCb29sUHJlZicsIHsgdmFsdWUgfSlcclxuICAgICAgICByZXR1cm4gcmVzcG9uc2UudmFsdWVcclxuICAgIH1cclxuXHJcbiAgICAvKipcclxuICAgICAqIEdldCBjaGFyIHByZWZlcmVuY2UuXHJcbiAgICAgKlxyXG4gICAgICogQHBhcmFtICB7U3RyaW5nfSAgdmFsdWUgIG5hbWUgb2YgcHJlZmVyZW5jZVxyXG4gICAgICogQHJldHVybiB7UHJvbWlzZS5DaGFyfSAgIHByZWZlcmVuY2UgdmFsdWVcclxuICAgICAqL1xyXG4gICAgYXN5bmMgZ2V0Q2hhclByZWYgKHZhbHVlKSB7XHJcbiAgICAgICAgY29uc3QgcmVzcG9uc2UgPSBhd2FpdCB0aGlzLnJlcXVlc3QoJ2dldENoYXJQcmVmJywgeyB2YWx1ZSB9KVxyXG4gICAgICAgIHJldHVybiByZXNwb25zZS52YWx1ZVxyXG4gICAgfVxyXG5cclxuICAgIC8qKlxyXG4gICAgICogR2V0IGludGVnZXIgcHJlZmVyZW5jZS5cclxuICAgICAqXHJcbiAgICAgKiBAcGFyYW0gIHtTdHJpbmd9ICB2YWx1ZSAgICBuYW1lIG9mIHByZWZlcmVuY2VcclxuICAgICAqIEByZXR1cm4ge1Byb21pc2UuTnVtYmVyfSAgIHByZWZlcmVuY2UgdmFsdWVcclxuICAgICAqL1xyXG4gICAgYXN5bmMgZ2V0SW50UHJlZiAodmFsdWUpIHtcclxuICAgICAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IHRoaXMucmVxdWVzdCgnZ2V0SW50UHJlZicsIHsgdmFsdWUgfSlcclxuICAgICAgICByZXR1cm4gcmVzcG9uc2UudmFsdWVcclxuICAgIH1cclxuXHJcbiAgICAvKipcclxuICAgICAqIEdldCBhbGwgcHJlZmVyZW5jZXMuXHJcbiAgICAgKlxyXG4gICAgICogQHJldHVybiB7UHJvbWlzZS5PYmplY3RbXX0gIGxpc3Qgb2YgcHJlZmVyZW5jZXNcclxuICAgICAqL1xyXG4gICAgYXN5bmMgZ2V0QWxsUHJlZnMgKCkge1xyXG4gICAgICAgIGNvbnN0IHsgdmFsdWUgfSA9IGF3YWl0IHRoaXMucmVxdWVzdCgnZ2V0QWxsUHJlZnMnKVxyXG4gICAgICAgIHJldHVybiB2YWx1ZVxyXG4gICAgfVxyXG5cclxuICAgIC8qKlxyXG4gICAgICogU2V0IGJvb2xlYW4gcHJlZmVyZW5jZS5cclxuICAgICAqXHJcbiAgICAgKiBAcGFyYW0ge1N0cmluZ30gIG5hbWUgICBwcmVmZXJlbmNlIG5hbWVcclxuICAgICAqIEBwYXJhbSB7Qm9vbGVhbn0gdmFsdWUgIHByZWZlcmVuY2UgdmFsdWVcclxuICAgICAqIEByZXR1cm4ge1Byb21pc2V9ICAgICAgIHJlcXVlc3QgcmVzcG9uc2VcclxuICAgICAqL1xyXG4gICAgc2V0Qm9vbFByZWYgKG5hbWUsIHZhbHVlKSB7XHJcbiAgICAgICAgcmV0dXJuIHRoaXMucmVxdWVzdCgnc2V0Qm9vbFByZWYnLCB7IG5hbWUsIHZhbHVlIH0pXHJcbiAgICB9XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBTZXQgY2hhciBwcmVmZXJlbmNlLlxyXG4gICAgICpcclxuICAgICAqIEBwYXJhbSB7U3RyaW5nfSAgbmFtZSAgIHByZWZlcmVuY2UgbmFtZVxyXG4gICAgICogQHBhcmFtIHtDaGFyfSAgICB2YWx1ZSAgcHJlZmVyZW5jZSB2YWx1ZVxyXG4gICAgICogQHJldHVybiB7UHJvbWlzZX0gICAgICAgcmVxdWVzdCByZXNwb25zZVxyXG4gICAgICovXHJcbiAgICBzZXRDaGFyUHJlZiAobmFtZSwgdmFsdWUpIHtcclxuICAgICAgICByZXR1cm4gdGhpcy5yZXF1ZXN0KCdzZXRDaGFyUHJlZicsIHsgbmFtZSwgdmFsdWUgfSlcclxuICAgIH1cclxuXHJcbiAgICAvKipcclxuICAgICAqIFNldCBpbnRlZ2VyIHByZWZlcmVuY2UuXHJcbiAgICAgKlxyXG4gICAgICogQHBhcmFtIHtTdHJpbmd9ICBuYW1lICAgcHJlZmVyZW5jZSBuYW1lXHJcbiAgICAgKiBAcGFyYW0ge051bWJlcn0gIHZhbHVlICBwcmVmZXJlbmNlIHZhbHVlXHJcbiAgICAgKiBAcmV0dXJuIHtQcm9taXNlfSAgICAgICByZXF1ZXN0IHJlc3BvbnNlXHJcbiAgICAgKi9cclxuICAgIHNldEludFByZWYgKG5hbWUsIHZhbHVlKSB7XHJcbiAgICAgICAgcmV0dXJuIHRoaXMucmVxdWVzdCgnc2V0SW50UHJlZicsIHsgbmFtZSwgdmFsdWUgfSlcclxuICAgIH1cclxuXHJcbiAgICAvKipcclxuICAgICAqIENsZWFyIHVzZXIgc2V0IHByZWZlcmVuY2VcclxuICAgICAqIEBwYXJhbSAge1NydGluZ30gbmFtZSAgbmFtZSBvZiBwcmVmZXJlbmNlXHJcbiAgICAgKiBAcmV0dXJuIHtQcm9taXNlfSAgICAgIHJlcXVlc3QgcmVzcG9uc2VcclxuICAgICAqL1xyXG4gICAgY2xlYXJVc2VyUHJlZiAobmFtZSkge1xyXG4gICAgICAgIHJldHVybiB0aGlzLnJlcXVlc3QoJ2NsZWFyVXNlclByZWYnLCB7IG5hbWUgfSlcclxuICAgIH1cclxufVxyXG4iXX0=