"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This actor wraps the Performance module at devtools/shared/shared/performance.js
 * and provides RDP definitions.
 *
 * @see devtools/shared/shared/performance.js for documentation.
 */
class Performance extends _actor2.default {
  connect(options) {
    return this.request('connect', {
      options
    });
  }
  /**
   * Checks whether or not a new recording is supported by the PerformanceFront.
   *
   * @return {Promise.Boolean}  true if it can record performance
   */


  async canCurrentlyRecord(options) {
    const {
      value
    } = await this.request('canCurrentlyRecord');
    return value;
  }
  /**
   * Begins a recording session.
   *
   * @param  {Boolean}  options.withMarkers
   *                    include markers
   * @param  {Boolean}  options.withTicks
   *                    include ticks
   * @param  {Boolean}  options.withMemory
   *                    include memory
   * @param  {Boolean}  options.withAllocations
   *                    include allocations
   * @param  {Boolean}  options.allocationsSampleProbability
   *                    include allocation sample probability
   * @param  {Boolean}  options.allocationsMaxLogLength
   *                    include allocations max log length
   * @param  {Boolean}  options.bufferSize
   *                    include buffer size
   * @param  {Boolean}  options.sampleFrequency
   *                    include sample frequency
   * @param  {Boolean}  options.console
   *                    include console
   * @param  {String}   options.label
   *                    label of session recording
   * @param  {Boolean}  options.realtimeMarkers
   *                    use real time markers
   *
   * @return {Promise.<Object>} A promise that is resolved once recording has started.
   */


  async startRecording(options) {
    const {
      recording
    } = await this.request('startRecording', {
      options
    });
    return recording;
  }
  /**
   * Manually ends the recording session for the corresponding PerformanceRecording.
   *
   * @param {PerformanceRecording} model
   *        The corresponding PerformanceRecording that belongs to the recording
   *        session wished to stop.
   * @return {Promise.PerformanceRecording}
   *         Returns the same model, populated with the profiling data.
   */


  async stopRecording(options) {
    const {
      recording
    } = await this.request('stopRecording', {
      options
    });
    return recording;
  }
  /**
   * Checks all currently stored recording handles and returns a boolean
   * if there is a session currently being recorded.
   *
   * @return {Boolean} true if actor is currently recording
   */


  async isRecording() {
    const {
      isRecording
    } = await this.request('isRecording');
    return isRecording;
  }
  /**
   * Returns all current recordings.
   * @return {Promise.PerformanceRecording}  returns model with populated profing data
   */


  async getRecordings() {
    const {
      recordings
    } = await this.request('getRecordings');
    return recordings;
  }
  /**
   * Returns the configurations set on underlying components, used in tests.
   * Returns an object with `probability`, `maxLogLength` for allocations, and
   * `features`, `threadFilters`, `entries` and `interval` for profiler.
   *
   * @return {Promise.Object}
   */


  async getConfiguration() {
    const {
      config
    } = await this.request('getConfiguration');
    return config;
  }

}

exports.default = Performance;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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