"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

var _request = require("../models/request");

var _request2 = _interopRequireDefault(_request);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Network extends _actor2.default {
  constructor(client, name) {
    super(client, name);
    this.isEnabled = false;
    this.on('networkEvent', event => {
      const request = new _request2.default(client, event.eventActor);
      this.emit('request', request);
    });
  }
  /**
   * Start the given Network listeners.
   *
   * @param  {String[]} listeners  console listeners to listen to (default: NetworkActivity)
   * @return {Promise}             resolves once request has finished
   */


  startListeners(listeners = Network.listeners) {
    this.isEnabled = true;
    return this.request('startListeners', {
      listeners
    });
  }
  /**
   * Stop the given Web Console listeners.
   *
   * @param  {String[]} listeners  console listeners to stop listen to (default: NetworkActivity)
   * @return {Promise}             resolves once request has finished
   */


  stopListeners(listeners = Network.listeners) {
    this.isEnabled = false;
    return this.request('stopListeners', {
      listeners
    });
  }
  /**
   * Send a HTTP request with the given data.
   * @param  {Request} request  The details of the HTTP request
   * @return {Promise}          resolves once request has finished
   */


  sendHTTPRequest(request) {
    return this.request('sendHTTPRequest', {
      request
    });
  }

}

exports.default = Network;

_defineProperty(Network, "listeners", ['NetworkActivity']);

module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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