"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _actor = require("../actor");

var _actor2 = _interopRequireDefault(_actor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The HeapSnapshotFileActor handles transferring heap snapshot files from the
 * server to the client. This has to be a global actor in the parent process
 * because child processes are sandboxed and do not have access to the file
 * system.
 */
class HeapSnapshotFile extends _actor2.default {
  /**
   * transfer heap snapshot
   *
   * @param  {String} snapshotId  id of heap snapshot file
   * @return {Promise.<Object>}   request response
   */
  getHeapSnapshot(snapshotId) {
    return this.request('transferHeapSnapshot', {
      snapshotId
    });
  }

}

exports.default = HeapSnapshotFile;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL2xpYi9kb21haW5zL2hlYXBTbmFwc2hvdEZpbGUuanMiXSwibmFtZXMiOlsiSGVhcFNuYXBzaG90RmlsZSIsIkFjdG9yIiwiZ2V0SGVhcFNuYXBzaG90Iiwic25hcHNob3RJZCIsInJlcXVlc3QiXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBOzs7Ozs7QUFFQTs7Ozs7O0FBTWUsTUFBTUEsZ0JBQU4sU0FBK0JDLGVBQS9CLENBQXFDO0FBQ2hEOzs7Ozs7QUFNQUMsRUFBQUEsZUFBZSxDQUFFQyxVQUFGLEVBQWM7QUFDekIsV0FBTyxLQUFLQyxPQUFMLENBQWEsc0JBQWIsRUFBcUM7QUFBRUQsTUFBQUE7QUFBRixLQUFyQyxDQUFQO0FBQ0g7O0FBVCtDOztrQkFBL0JILGdCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IEFjdG9yIGZyb20gJy4uL2FjdG9yJ1xyXG5cclxuLyoqXHJcbiAqIFRoZSBIZWFwU25hcHNob3RGaWxlQWN0b3IgaGFuZGxlcyB0cmFuc2ZlcnJpbmcgaGVhcCBzbmFwc2hvdCBmaWxlcyBmcm9tIHRoZVxyXG4gKiBzZXJ2ZXIgdG8gdGhlIGNsaWVudC4gVGhpcyBoYXMgdG8gYmUgYSBnbG9iYWwgYWN0b3IgaW4gdGhlIHBhcmVudCBwcm9jZXNzXHJcbiAqIGJlY2F1c2UgY2hpbGQgcHJvY2Vzc2VzIGFyZSBzYW5kYm94ZWQgYW5kIGRvIG5vdCBoYXZlIGFjY2VzcyB0byB0aGUgZmlsZVxyXG4gKiBzeXN0ZW0uXHJcbiAqL1xyXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBIZWFwU25hcHNob3RGaWxlIGV4dGVuZHMgQWN0b3Ige1xyXG4gICAgLyoqXHJcbiAgICAgKiB0cmFuc2ZlciBoZWFwIHNuYXBzaG90XHJcbiAgICAgKlxyXG4gICAgICogQHBhcmFtICB7U3RyaW5nfSBzbmFwc2hvdElkICBpZCBvZiBoZWFwIHNuYXBzaG90IGZpbGVcclxuICAgICAqIEByZXR1cm4ge1Byb21pc2UuPE9iamVjdD59ICAgcmVxdWVzdCByZXNwb25zZVxyXG4gICAgICovXHJcbiAgICBnZXRIZWFwU25hcHNob3QgKHNuYXBzaG90SWQpIHtcclxuICAgICAgICByZXR1cm4gdGhpcy5yZXF1ZXN0KCd0cmFuc2ZlckhlYXBTbmFwc2hvdCcsIHsgc25hcHNob3RJZCB9KVxyXG4gICAgfVxyXG59XHJcbiJdfQ==