"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _events = require("events");

var _events2 = _interopRequireDefault(_events);

var _logger = require("./logger");

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Actor extends _events2.default {
  constructor(client, name, data) {
    super();
    this.client = client;
    this.name = name;
    this.isEnabled = false;
    this.data = data;
    this.log = (0, _logger2.default)(`Actor:${name}`);
    this.client.on('message', message => {
      if (message.from === this.name) {
        this.emit(message.type, message);
      }
    });
    this._registeredDomains = {};
    this.setActors(data);
  }

  setActors(payload = {}) {
    this._actors = Object.keys(payload).filter(key => key.endsWith('Actor')).reduce((obj, key) => {
      obj[key] = payload[key];
      return obj;
    }, {});
  }

  async request(type, message = {}) {
    message.to = this.name;
    message.type = type;
    const result = await this.client.makeRequest(message);

    if (result.error) {
      throw new Error(`${result.message} (${result.error})`);
    }

    return result;
  }

  _get(domain, alias) {
    const apiName = alias || domain;
    const actorId = this._actors[`${domain}Actor`];

    if (!this._registeredDomains[apiName] && actorId) {
      /**
       * require domain actor dynamically
       */
      const Domain = require(`./domains/${apiName}`);

      this._registeredDomains[apiName] = new Domain(this.client, actorId);
      this.log.info(`registered ${apiName} with actor id ${actorId}`);
    }

    return this._registeredDomains[apiName];
  }

}

exports.default = Actor;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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