(function polyfill() {
  const relList = document.createElement("link").relList;
  if (relList && relList.supports && relList.supports("modulepreload")) {
    return;
  }
  for (const link4 of document.querySelectorAll('link[rel="modulepreload"]')) {
    processPreload(link4);
  }
  new MutationObserver((mutations) => {
    for (const mutation of mutations) {
      if (mutation.type !== "childList") {
        continue;
      }
      for (const node of mutation.addedNodes) {
        if (node.tagName === "LINK" && node.rel === "modulepreload")
          processPreload(node);
      }
    }
  }).observe(document, { childList: true, subtree: true });
  function getFetchOpts(script2) {
    const fetchOpts = {};
    if (script2.integrity)
      fetchOpts.integrity = script2.integrity;
    if (script2.referrerpolicy)
      fetchOpts.referrerPolicy = script2.referrerpolicy;
    if (script2.crossorigin === "use-credentials")
      fetchOpts.credentials = "include";
    else if (script2.crossorigin === "anonymous")
      fetchOpts.credentials = "omit";
    else
      fetchOpts.credentials = "same-origin";
    return fetchOpts;
  }
  function processPreload(link4) {
    if (link4.ep)
      return;
    link4.ep = true;
    const fetchOpts = getFetchOpts(link4);
    fetch(link4.href, fetchOpts);
  }
})();
function makeMap(str, expectsLowerCase) {
  const map2 = /* @__PURE__ */ Object.create(null);
  const list3 = str.split(",");
  for (let i2 = 0; i2 < list3.length; i2++) {
    map2[list3[i2]] = true;
  }
  return expectsLowerCase ? (val) => !!map2[val.toLowerCase()] : (val) => !!map2[val];
}
const GLOBALS_WHITE_LISTED = "Infinity,undefined,NaN,isFinite,isNaN,parseFloat,parseInt,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,Math,Number,Date,Array,Object,Boolean,String,RegExp,Map,Set,JSON,Intl,BigInt";
const isGloballyWhitelisted = /* @__PURE__ */ makeMap(GLOBALS_WHITE_LISTED);
const specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
const isSpecialBooleanAttr = /* @__PURE__ */ makeMap(specialBooleanAttrs);
function includeBooleanAttr(value) {
  return !!value || value === "";
}
function normalizeStyle(value) {
  if (isArray$2(value)) {
    const res = {};
    for (let i2 = 0; i2 < value.length; i2++) {
      const item = value[i2];
      const normalized = isString$5(item) ? parseStringStyle(item) : normalizeStyle(item);
      if (normalized) {
        for (const key in normalized) {
          res[key] = normalized[key];
        }
      }
    }
    return res;
  } else if (isString$5(value)) {
    return value;
  } else if (isObject$5(value)) {
    return value;
  }
}
const listDelimiterRE = /;(?![^(]*\))/g;
const propertyDelimiterRE = /:(.+)/;
function parseStringStyle(cssText) {
  const ret = {};
  cssText.split(listDelimiterRE).forEach((item) => {
    if (item) {
      const tmp = item.split(propertyDelimiterRE);
      tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
    }
  });
  return ret;
}
function normalizeClass(value) {
  let res = "";
  if (isString$5(value)) {
    res = value;
  } else if (isArray$2(value)) {
    for (let i2 = 0; i2 < value.length; i2++) {
      const normalized = normalizeClass(value[i2]);
      if (normalized) {
        res += normalized + " ";
      }
    }
  } else if (isObject$5(value)) {
    for (const name2 in value) {
      if (value[name2]) {
        res += name2 + " ";
      }
    }
  }
  return res.trim();
}
function normalizeProps(props) {
  if (!props)
    return null;
  let { class: klass, style } = props;
  if (klass && !isString$5(klass)) {
    props.class = normalizeClass(klass);
  }
  if (style) {
    props.style = normalizeStyle(style);
  }
  return props;
}
function looseCompareArrays(a2, b2) {
  if (a2.length !== b2.length)
    return false;
  let equal = true;
  for (let i2 = 0; equal && i2 < a2.length; i2++) {
    equal = looseEqual(a2[i2], b2[i2]);
  }
  return equal;
}
function looseEqual(a2, b2) {
  if (a2 === b2)
    return true;
  let aValidType = isDate$1(a2);
  let bValidType = isDate$1(b2);
  if (aValidType || bValidType) {
    return aValidType && bValidType ? a2.getTime() === b2.getTime() : false;
  }
  aValidType = isArray$2(a2);
  bValidType = isArray$2(b2);
  if (aValidType || bValidType) {
    return aValidType && bValidType ? looseCompareArrays(a2, b2) : false;
  }
  aValidType = isObject$5(a2);
  bValidType = isObject$5(b2);
  if (aValidType || bValidType) {
    if (!aValidType || !bValidType) {
      return false;
    }
    const aKeysCount = Object.keys(a2).length;
    const bKeysCount = Object.keys(b2).length;
    if (aKeysCount !== bKeysCount) {
      return false;
    }
    for (const key in a2) {
      const aHasKey = a2.hasOwnProperty(key);
      const bHasKey = b2.hasOwnProperty(key);
      if (aHasKey && !bHasKey || !aHasKey && bHasKey || !looseEqual(a2[key], b2[key])) {
        return false;
      }
    }
  }
  return String(a2) === String(b2);
}
function looseIndexOf(arr, val) {
  return arr.findIndex((item) => looseEqual(item, val));
}
const toDisplayString$1 = (val) => {
  return isString$5(val) ? val : val == null ? "" : isArray$2(val) || isObject$5(val) && (val.toString === objectToString$2 || !isFunction$4(val.toString)) ? JSON.stringify(val, replacer, 2) : String(val);
};
const replacer = (_key, val) => {
  if (val && val.__v_isRef) {
    return replacer(_key, val.value);
  } else if (isMap(val)) {
    return {
      [`Map(${val.size})`]: [...val.entries()].reduce((entries, [key, val2]) => {
        entries[`${key} =>`] = val2;
        return entries;
      }, {})
    };
  } else if (isSet(val)) {
    return {
      [`Set(${val.size})`]: [...val.values()]
    };
  } else if (isObject$5(val) && !isArray$2(val) && !isPlainObject$3(val)) {
    return String(val);
  }
  return val;
};
const EMPTY_OBJ = {};
const EMPTY_ARR = [];
const NOOP = () => {
};
const NO = () => false;
const onRE = /^on[^a-z]/;
const isOn = (key) => onRE.test(key);
const isModelListener = (key) => key.startsWith("onUpdate:");
const extend = Object.assign;
const remove = (arr, el2) => {
  const i2 = arr.indexOf(el2);
  if (i2 > -1) {
    arr.splice(i2, 1);
  }
};
const hasOwnProperty$3 = Object.prototype.hasOwnProperty;
const hasOwn$1 = (val, key) => hasOwnProperty$3.call(val, key);
const isArray$2 = Array.isArray;
const isMap = (val) => toTypeString$2(val) === "[object Map]";
const isSet = (val) => toTypeString$2(val) === "[object Set]";
const isDate$1 = (val) => val instanceof Date;
const isFunction$4 = (val) => typeof val === "function";
const isString$5 = (val) => typeof val === "string";
const isSymbol = (val) => typeof val === "symbol";
const isObject$5 = (val) => val !== null && typeof val === "object";
const isPromise = (val) => {
  return isObject$5(val) && isFunction$4(val.then) && isFunction$4(val.catch);
};
const objectToString$2 = Object.prototype.toString;
const toTypeString$2 = (value) => objectToString$2.call(value);
const toRawType = (value) => {
  return toTypeString$2(value).slice(8, -1);
};
const isPlainObject$3 = (val) => toTypeString$2(val) === "[object Object]";
const isIntegerKey = (key) => isString$5(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
const isReservedProp = /* @__PURE__ */ makeMap(
  ",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"
);
const cacheStringFunction = (fn) => {
  const cache2 = /* @__PURE__ */ Object.create(null);
  return (str) => {
    const hit = cache2[str];
    return hit || (cache2[str] = fn(str));
  };
};
const camelizeRE = /-(\w)/g;
const camelize = cacheStringFunction((str) => {
  return str.replace(camelizeRE, (_2, c2) => c2 ? c2.toUpperCase() : "");
});
const hyphenateRE = /\B([A-Z])/g;
const hyphenate = cacheStringFunction((str) => str.replace(hyphenateRE, "-$1").toLowerCase());
const capitalize = cacheStringFunction((str) => str.charAt(0).toUpperCase() + str.slice(1));
const toHandlerKey = cacheStringFunction((str) => str ? `on${capitalize(str)}` : ``);
const hasChanged = (value, oldValue) => !Object.is(value, oldValue);
const invokeArrayFns = (fns, arg) => {
  for (let i2 = 0; i2 < fns.length; i2++) {
    fns[i2](arg);
  }
};
const def = (obj, key, value) => {
  Object.defineProperty(obj, key, {
    configurable: true,
    enumerable: false,
    value
  });
};
const toNumber = (val) => {
  const n = parseFloat(val);
  return isNaN(n) ? val : n;
};
let _globalThis$2;
const getGlobalThis$2 = () => {
  return _globalThis$2 || (_globalThis$2 = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
};
let activeEffectScope;
class EffectScope {
  constructor(detached = false) {
    this.active = true;
    this.effects = [];
    this.cleanups = [];
    if (!detached && activeEffectScope) {
      this.parent = activeEffectScope;
      this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(this) - 1;
    }
  }
  run(fn) {
    if (this.active) {
      try {
        activeEffectScope = this;
        return fn();
      } finally {
        activeEffectScope = this.parent;
      }
    }
  }
  on() {
    activeEffectScope = this;
  }
  off() {
    activeEffectScope = this.parent;
  }
  stop(fromParent) {
    if (this.active) {
      let i2, l2;
      for (i2 = 0, l2 = this.effects.length; i2 < l2; i2++) {
        this.effects[i2].stop();
      }
      for (i2 = 0, l2 = this.cleanups.length; i2 < l2; i2++) {
        this.cleanups[i2]();
      }
      if (this.scopes) {
        for (i2 = 0, l2 = this.scopes.length; i2 < l2; i2++) {
          this.scopes[i2].stop(true);
        }
      }
      if (this.parent && !fromParent) {
        const last = this.parent.scopes.pop();
        if (last && last !== this) {
          this.parent.scopes[this.index] = last;
          last.index = this.index;
        }
      }
      this.active = false;
    }
  }
}
function effectScope(detached) {
  return new EffectScope(detached);
}
function recordEffectScope(effect2, scope = activeEffectScope) {
  if (scope && scope.active) {
    scope.effects.push(effect2);
  }
}
function getCurrentScope() {
  return activeEffectScope;
}
function onScopeDispose(fn) {
  if (activeEffectScope) {
    activeEffectScope.cleanups.push(fn);
  }
}
const createDep = (effects) => {
  const dep = new Set(effects);
  dep.w = 0;
  dep.n = 0;
  return dep;
};
const wasTracked = (dep) => (dep.w & trackOpBit) > 0;
const newTracked = (dep) => (dep.n & trackOpBit) > 0;
const initDepMarkers = ({ deps }) => {
  if (deps.length) {
    for (let i2 = 0; i2 < deps.length; i2++) {
      deps[i2].w |= trackOpBit;
    }
  }
};
const finalizeDepMarkers = (effect2) => {
  const { deps } = effect2;
  if (deps.length) {
    let ptr = 0;
    for (let i2 = 0; i2 < deps.length; i2++) {
      const dep = deps[i2];
      if (wasTracked(dep) && !newTracked(dep)) {
        dep.delete(effect2);
      } else {
        deps[ptr++] = dep;
      }
      dep.w &= ~trackOpBit;
      dep.n &= ~trackOpBit;
    }
    deps.length = ptr;
  }
};
const targetMap = /* @__PURE__ */ new WeakMap();
let effectTrackDepth = 0;
let trackOpBit = 1;
const maxMarkerBits = 30;
let activeEffect;
const ITERATE_KEY = Symbol("");
const MAP_KEY_ITERATE_KEY = Symbol("");
class ReactiveEffect {
  constructor(fn, scheduler = null, scope) {
    this.fn = fn;
    this.scheduler = scheduler;
    this.active = true;
    this.deps = [];
    this.parent = void 0;
    recordEffectScope(this, scope);
  }
  run() {
    if (!this.active) {
      return this.fn();
    }
    let parent = activeEffect;
    let lastShouldTrack = shouldTrack;
    while (parent) {
      if (parent === this) {
        return;
      }
      parent = parent.parent;
    }
    try {
      this.parent = activeEffect;
      activeEffect = this;
      shouldTrack = true;
      trackOpBit = 1 << ++effectTrackDepth;
      if (effectTrackDepth <= maxMarkerBits) {
        initDepMarkers(this);
      } else {
        cleanupEffect(this);
      }
      return this.fn();
    } finally {
      if (effectTrackDepth <= maxMarkerBits) {
        finalizeDepMarkers(this);
      }
      trackOpBit = 1 << --effectTrackDepth;
      activeEffect = this.parent;
      shouldTrack = lastShouldTrack;
      this.parent = void 0;
    }
  }
  stop() {
    if (this.active) {
      cleanupEffect(this);
      if (this.onStop) {
        this.onStop();
      }
      this.active = false;
    }
  }
}
function cleanupEffect(effect2) {
  const { deps } = effect2;
  if (deps.length) {
    for (let i2 = 0; i2 < deps.length; i2++) {
      deps[i2].delete(effect2);
    }
    deps.length = 0;
  }
}
function effect(fn, options2) {
  if (fn.effect) {
    fn = fn.effect.fn;
  }
  const _effect = new ReactiveEffect(fn);
  if (options2) {
    extend(_effect, options2);
    if (options2.scope)
      recordEffectScope(_effect, options2.scope);
  }
  if (!options2 || !options2.lazy) {
    _effect.run();
  }
  const runner = _effect.run.bind(_effect);
  runner.effect = _effect;
  return runner;
}
function stop(runner) {
  runner.effect.stop();
}
let shouldTrack = true;
const trackStack = [];
function pauseTracking() {
  trackStack.push(shouldTrack);
  shouldTrack = false;
}
function resetTracking() {
  const last = trackStack.pop();
  shouldTrack = last === void 0 ? true : last;
}
function track(target2, type2, key) {
  if (shouldTrack && activeEffect) {
    let depsMap = targetMap.get(target2);
    if (!depsMap) {
      targetMap.set(target2, depsMap = /* @__PURE__ */ new Map());
    }
    let dep = depsMap.get(key);
    if (!dep) {
      depsMap.set(key, dep = createDep());
    }
    trackEffects(dep);
  }
}
function trackEffects(dep, debuggerEventExtraInfo) {
  let shouldTrack2 = false;
  if (effectTrackDepth <= maxMarkerBits) {
    if (!newTracked(dep)) {
      dep.n |= trackOpBit;
      shouldTrack2 = !wasTracked(dep);
    }
  } else {
    shouldTrack2 = !dep.has(activeEffect);
  }
  if (shouldTrack2) {
    dep.add(activeEffect);
    activeEffect.deps.push(dep);
  }
}
function trigger$1(target2, type2, key, newValue, oldValue, oldTarget) {
  const depsMap = targetMap.get(target2);
  if (!depsMap) {
    return;
  }
  let deps = [];
  if (type2 === "clear") {
    deps = [...depsMap.values()];
  } else if (key === "length" && isArray$2(target2)) {
    depsMap.forEach((dep, key2) => {
      if (key2 === "length" || key2 >= newValue) {
        deps.push(dep);
      }
    });
  } else {
    if (key !== void 0) {
      deps.push(depsMap.get(key));
    }
    switch (type2) {
      case "add":
        if (!isArray$2(target2)) {
          deps.push(depsMap.get(ITERATE_KEY));
          if (isMap(target2)) {
            deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
          }
        } else if (isIntegerKey(key)) {
          deps.push(depsMap.get("length"));
        }
        break;
      case "delete":
        if (!isArray$2(target2)) {
          deps.push(depsMap.get(ITERATE_KEY));
          if (isMap(target2)) {
            deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
          }
        }
        break;
      case "set":
        if (isMap(target2)) {
          deps.push(depsMap.get(ITERATE_KEY));
        }
        break;
    }
  }
  if (deps.length === 1) {
    if (deps[0]) {
      {
        triggerEffects(deps[0]);
      }
    }
  } else {
    const effects = [];
    for (const dep of deps) {
      if (dep) {
        effects.push(...dep);
      }
    }
    {
      triggerEffects(createDep(effects));
    }
  }
}
function triggerEffects(dep, debuggerEventExtraInfo) {
  for (const effect2 of isArray$2(dep) ? dep : [...dep]) {
    if (effect2 !== activeEffect || effect2.allowRecurse) {
      if (effect2.scheduler) {
        effect2.scheduler();
      } else {
        effect2.run();
      }
    }
  }
}
const isNonTrackableKeys = /* @__PURE__ */ makeMap(`__proto__,__v_isRef,__isVue`);
const builtInSymbols = new Set(Object.getOwnPropertyNames(Symbol).map((key) => Symbol[key]).filter(isSymbol));
const get$1 = /* @__PURE__ */ createGetter();
const shallowGet = /* @__PURE__ */ createGetter(false, true);
const readonlyGet = /* @__PURE__ */ createGetter(true);
const shallowReadonlyGet = /* @__PURE__ */ createGetter(true, true);
const arrayInstrumentations = /* @__PURE__ */ createArrayInstrumentations();
function createArrayInstrumentations() {
  const instrumentations = {};
  ["includes", "indexOf", "lastIndexOf"].forEach((key) => {
    instrumentations[key] = function(...args) {
      const arr = toRaw(this);
      for (let i2 = 0, l2 = this.length; i2 < l2; i2++) {
        track(arr, "get", i2 + "");
      }
      const res = arr[key](...args);
      if (res === -1 || res === false) {
        return arr[key](...args.map(toRaw));
      } else {
        return res;
      }
    };
  });
  ["push", "pop", "shift", "unshift", "splice"].forEach((key) => {
    instrumentations[key] = function(...args) {
      pauseTracking();
      const res = toRaw(this)[key].apply(this, args);
      resetTracking();
      return res;
    };
  });
  return instrumentations;
}
function createGetter(isReadonly2 = false, shallow = false) {
  return function get2(target2, key, receiver) {
    if (key === "__v_isReactive") {
      return !isReadonly2;
    } else if (key === "__v_isReadonly") {
      return isReadonly2;
    } else if (key === "__v_isShallow") {
      return shallow;
    } else if (key === "__v_raw" && receiver === (isReadonly2 ? shallow ? shallowReadonlyMap : readonlyMap : shallow ? shallowReactiveMap : reactiveMap).get(target2)) {
      return target2;
    }
    const targetIsArray = isArray$2(target2);
    if (!isReadonly2 && targetIsArray && hasOwn$1(arrayInstrumentations, key)) {
      return Reflect.get(arrayInstrumentations, key, receiver);
    }
    const res = Reflect.get(target2, key, receiver);
    if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
      return res;
    }
    if (!isReadonly2) {
      track(target2, "get", key);
    }
    if (shallow) {
      return res;
    }
    if (isRef(res)) {
      const shouldUnwrap = !targetIsArray || !isIntegerKey(key);
      return shouldUnwrap ? res.value : res;
    }
    if (isObject$5(res)) {
      return isReadonly2 ? readonly(res) : reactive(res);
    }
    return res;
  };
}
const set = /* @__PURE__ */ createSetter();
const shallowSet = /* @__PURE__ */ createSetter(true);
function createSetter(shallow = false) {
  return function set3(target2, key, value, receiver) {
    let oldValue = target2[key];
    if (isReadonly(oldValue) && isRef(oldValue) && !isRef(value)) {
      return false;
    }
    if (!shallow && !isReadonly(value)) {
      if (!isShallow(value)) {
        value = toRaw(value);
        oldValue = toRaw(oldValue);
      }
      if (!isArray$2(target2) && isRef(oldValue) && !isRef(value)) {
        oldValue.value = value;
        return true;
      }
    }
    const hadKey = isArray$2(target2) && isIntegerKey(key) ? Number(key) < target2.length : hasOwn$1(target2, key);
    const result = Reflect.set(target2, key, value, receiver);
    if (target2 === toRaw(receiver)) {
      if (!hadKey) {
        trigger$1(target2, "add", key, value);
      } else if (hasChanged(value, oldValue)) {
        trigger$1(target2, "set", key, value);
      }
    }
    return result;
  };
}
function deleteProperty(target2, key) {
  const hadKey = hasOwn$1(target2, key);
  target2[key];
  const result = Reflect.deleteProperty(target2, key);
  if (result && hadKey) {
    trigger$1(target2, "delete", key, void 0);
  }
  return result;
}
function has$1(target2, key) {
  const result = Reflect.has(target2, key);
  if (!isSymbol(key) || !builtInSymbols.has(key)) {
    track(target2, "has", key);
  }
  return result;
}
function ownKeys(target2) {
  track(target2, "iterate", isArray$2(target2) ? "length" : ITERATE_KEY);
  return Reflect.ownKeys(target2);
}
const mutableHandlers = {
  get: get$1,
  set,
  deleteProperty,
  has: has$1,
  ownKeys
};
const readonlyHandlers = {
  get: readonlyGet,
  set(target2, key) {
    return true;
  },
  deleteProperty(target2, key) {
    return true;
  }
};
const shallowReactiveHandlers = /* @__PURE__ */ extend({}, mutableHandlers, {
  get: shallowGet,
  set: shallowSet
});
const shallowReadonlyHandlers = /* @__PURE__ */ extend({}, readonlyHandlers, {
  get: shallowReadonlyGet
});
const toShallow = (value) => value;
const getProto = (v) => Reflect.getPrototypeOf(v);
function get$1$1(target2, key, isReadonly2 = false, isShallow2 = false) {
  target2 = target2["__v_raw"];
  const rawTarget = toRaw(target2);
  const rawKey = toRaw(key);
  if (key !== rawKey) {
    !isReadonly2 && track(rawTarget, "get", key);
  }
  !isReadonly2 && track(rawTarget, "get", rawKey);
  const { has: has2 } = getProto(rawTarget);
  const wrap2 = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
  if (has2.call(rawTarget, key)) {
    return wrap2(target2.get(key));
  } else if (has2.call(rawTarget, rawKey)) {
    return wrap2(target2.get(rawKey));
  } else if (target2 !== rawTarget) {
    target2.get(key);
  }
}
function has$1$1(key, isReadonly2 = false) {
  const target2 = this["__v_raw"];
  const rawTarget = toRaw(target2);
  const rawKey = toRaw(key);
  if (key !== rawKey) {
    !isReadonly2 && track(rawTarget, "has", key);
  }
  !isReadonly2 && track(rawTarget, "has", rawKey);
  return key === rawKey ? target2.has(key) : target2.has(key) || target2.has(rawKey);
}
function size$1(target2, isReadonly2 = false) {
  target2 = target2["__v_raw"];
  !isReadonly2 && track(toRaw(target2), "iterate", ITERATE_KEY);
  return Reflect.get(target2, "size", target2);
}
function add(value) {
  value = toRaw(value);
  const target2 = toRaw(this);
  const proto2 = getProto(target2);
  const hadKey = proto2.has.call(target2, value);
  if (!hadKey) {
    target2.add(value);
    trigger$1(target2, "add", value, value);
  }
  return this;
}
function set$1(key, value) {
  value = toRaw(value);
  const target2 = toRaw(this);
  const { has: has2, get: get2 } = getProto(target2);
  let hadKey = has2.call(target2, key);
  if (!hadKey) {
    key = toRaw(key);
    hadKey = has2.call(target2, key);
  }
  const oldValue = get2.call(target2, key);
  target2.set(key, value);
  if (!hadKey) {
    trigger$1(target2, "add", key, value);
  } else if (hasChanged(value, oldValue)) {
    trigger$1(target2, "set", key, value);
  }
  return this;
}
function deleteEntry(key) {
  const target2 = toRaw(this);
  const { has: has2, get: get2 } = getProto(target2);
  let hadKey = has2.call(target2, key);
  if (!hadKey) {
    key = toRaw(key);
    hadKey = has2.call(target2, key);
  }
  get2 ? get2.call(target2, key) : void 0;
  const result = target2.delete(key);
  if (hadKey) {
    trigger$1(target2, "delete", key, void 0);
  }
  return result;
}
function clear() {
  const target2 = toRaw(this);
  const hadItems = target2.size !== 0;
  const result = target2.clear();
  if (hadItems) {
    trigger$1(target2, "clear", void 0, void 0);
  }
  return result;
}
function createForEach(isReadonly2, isShallow2) {
  return function forEach(callback, thisArg) {
    const observed = this;
    const target2 = observed["__v_raw"];
    const rawTarget = toRaw(target2);
    const wrap2 = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
    !isReadonly2 && track(rawTarget, "iterate", ITERATE_KEY);
    return target2.forEach((value, key) => {
      return callback.call(thisArg, wrap2(value), wrap2(key), observed);
    });
  };
}
function createIterableMethod(method, isReadonly2, isShallow2) {
  return function(...args) {
    const target2 = this["__v_raw"];
    const rawTarget = toRaw(target2);
    const targetIsMap = isMap(rawTarget);
    const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
    const isKeyOnly = method === "keys" && targetIsMap;
    const innerIterator = target2[method](...args);
    const wrap2 = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
    !isReadonly2 && track(rawTarget, "iterate", isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY);
    return {
      next() {
        const { value, done } = innerIterator.next();
        return done ? { value, done } : {
          value: isPair ? [wrap2(value[0]), wrap2(value[1])] : wrap2(value),
          done
        };
      },
      [Symbol.iterator]() {
        return this;
      }
    };
  };
}
function createReadonlyMethod(type2) {
  return function(...args) {
    return type2 === "delete" ? false : this;
  };
}
function createInstrumentations() {
  const mutableInstrumentations2 = {
    get(key) {
      return get$1$1(this, key);
    },
    get size() {
      return size$1(this);
    },
    has: has$1$1,
    add,
    set: set$1,
    delete: deleteEntry,
    clear,
    forEach: createForEach(false, false)
  };
  const shallowInstrumentations2 = {
    get(key) {
      return get$1$1(this, key, false, true);
    },
    get size() {
      return size$1(this);
    },
    has: has$1$1,
    add,
    set: set$1,
    delete: deleteEntry,
    clear,
    forEach: createForEach(false, true)
  };
  const readonlyInstrumentations2 = {
    get(key) {
      return get$1$1(this, key, true);
    },
    get size() {
      return size$1(this, true);
    },
    has(key) {
      return has$1$1.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, false)
  };
  const shallowReadonlyInstrumentations2 = {
    get(key) {
      return get$1$1(this, key, true, true);
    },
    get size() {
      return size$1(this, true);
    },
    has(key) {
      return has$1$1.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, true)
  };
  const iteratorMethods = ["keys", "values", "entries", Symbol.iterator];
  iteratorMethods.forEach((method) => {
    mutableInstrumentations2[method] = createIterableMethod(method, false, false);
    readonlyInstrumentations2[method] = createIterableMethod(method, true, false);
    shallowInstrumentations2[method] = createIterableMethod(method, false, true);
    shallowReadonlyInstrumentations2[method] = createIterableMethod(method, true, true);
  });
  return [
    mutableInstrumentations2,
    readonlyInstrumentations2,
    shallowInstrumentations2,
    shallowReadonlyInstrumentations2
  ];
}
const [mutableInstrumentations, readonlyInstrumentations, shallowInstrumentations, shallowReadonlyInstrumentations] = /* @__PURE__ */ createInstrumentations();
function createInstrumentationGetter(isReadonly2, shallow) {
  const instrumentations = shallow ? isReadonly2 ? shallowReadonlyInstrumentations : shallowInstrumentations : isReadonly2 ? readonlyInstrumentations : mutableInstrumentations;
  return (target2, key, receiver) => {
    if (key === "__v_isReactive") {
      return !isReadonly2;
    } else if (key === "__v_isReadonly") {
      return isReadonly2;
    } else if (key === "__v_raw") {
      return target2;
    }
    return Reflect.get(hasOwn$1(instrumentations, key) && key in target2 ? instrumentations : target2, key, receiver);
  };
}
const mutableCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(false, false)
};
const shallowCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(false, true)
};
const readonlyCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(true, false)
};
const shallowReadonlyCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(true, true)
};
const reactiveMap = /* @__PURE__ */ new WeakMap();
const shallowReactiveMap = /* @__PURE__ */ new WeakMap();
const readonlyMap = /* @__PURE__ */ new WeakMap();
const shallowReadonlyMap = /* @__PURE__ */ new WeakMap();
function targetTypeMap(rawType) {
  switch (rawType) {
    case "Object":
    case "Array":
      return 1;
    case "Map":
    case "Set":
    case "WeakMap":
    case "WeakSet":
      return 2;
    default:
      return 0;
  }
}
function getTargetType(value) {
  return value["__v_skip"] || !Object.isExtensible(value) ? 0 : targetTypeMap(toRawType(value));
}
function reactive(target2) {
  if (isReadonly(target2)) {
    return target2;
  }
  return createReactiveObject(target2, false, mutableHandlers, mutableCollectionHandlers, reactiveMap);
}
function shallowReactive(target2) {
  return createReactiveObject(target2, false, shallowReactiveHandlers, shallowCollectionHandlers, shallowReactiveMap);
}
function readonly(target2) {
  return createReactiveObject(target2, true, readonlyHandlers, readonlyCollectionHandlers, readonlyMap);
}
function shallowReadonly(target2) {
  return createReactiveObject(target2, true, shallowReadonlyHandlers, shallowReadonlyCollectionHandlers, shallowReadonlyMap);
}
function createReactiveObject(target2, isReadonly2, baseHandlers, collectionHandlers, proxyMap) {
  if (!isObject$5(target2)) {
    return target2;
  }
  if (target2["__v_raw"] && !(isReadonly2 && target2["__v_isReactive"])) {
    return target2;
  }
  const existingProxy = proxyMap.get(target2);
  if (existingProxy) {
    return existingProxy;
  }
  const targetType = getTargetType(target2);
  if (targetType === 0) {
    return target2;
  }
  const proxy = new Proxy(target2, targetType === 2 ? collectionHandlers : baseHandlers);
  proxyMap.set(target2, proxy);
  return proxy;
}
function isReactive(value) {
  if (isReadonly(value)) {
    return isReactive(value["__v_raw"]);
  }
  return !!(value && value["__v_isReactive"]);
}
function isReadonly(value) {
  return !!(value && value["__v_isReadonly"]);
}
function isShallow(value) {
  return !!(value && value["__v_isShallow"]);
}
function isProxy(value) {
  return isReactive(value) || isReadonly(value);
}
function toRaw(observed) {
  const raw = observed && observed["__v_raw"];
  return raw ? toRaw(raw) : observed;
}
function markRaw(value) {
  def(value, "__v_skip", true);
  return value;
}
const toReactive = (value) => isObject$5(value) ? reactive(value) : value;
const toReadonly = (value) => isObject$5(value) ? readonly(value) : value;
function trackRefValue(ref2) {
  if (shouldTrack && activeEffect) {
    ref2 = toRaw(ref2);
    {
      trackEffects(ref2.dep || (ref2.dep = createDep()));
    }
  }
}
function triggerRefValue(ref2, newVal) {
  ref2 = toRaw(ref2);
  if (ref2.dep) {
    {
      triggerEffects(ref2.dep);
    }
  }
}
function isRef(r2) {
  return !!(r2 && r2.__v_isRef === true);
}
function ref(value) {
  return createRef(value, false);
}
function shallowRef(value) {
  return createRef(value, true);
}
function createRef(rawValue, shallow) {
  if (isRef(rawValue)) {
    return rawValue;
  }
  return new RefImpl(rawValue, shallow);
}
class RefImpl {
  constructor(value, __v_isShallow) {
    this.__v_isShallow = __v_isShallow;
    this.dep = void 0;
    this.__v_isRef = true;
    this._rawValue = __v_isShallow ? value : toRaw(value);
    this._value = __v_isShallow ? value : toReactive(value);
  }
  get value() {
    trackRefValue(this);
    return this._value;
  }
  set value(newVal) {
    newVal = this.__v_isShallow ? newVal : toRaw(newVal);
    if (hasChanged(newVal, this._rawValue)) {
      this._rawValue = newVal;
      this._value = this.__v_isShallow ? newVal : toReactive(newVal);
      triggerRefValue(this);
    }
  }
}
function triggerRef(ref2) {
  triggerRefValue(ref2);
}
function unref(ref2) {
  return isRef(ref2) ? ref2.value : ref2;
}
const shallowUnwrapHandlers = {
  get: (target2, key, receiver) => unref(Reflect.get(target2, key, receiver)),
  set: (target2, key, value, receiver) => {
    const oldValue = target2[key];
    if (isRef(oldValue) && !isRef(value)) {
      oldValue.value = value;
      return true;
    } else {
      return Reflect.set(target2, key, value, receiver);
    }
  }
};
function proxyRefs(objectWithRefs) {
  return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
}
class CustomRefImpl {
  constructor(factory) {
    this.dep = void 0;
    this.__v_isRef = true;
    const { get: get2, set: set3 } = factory(() => trackRefValue(this), () => triggerRefValue(this));
    this._get = get2;
    this._set = set3;
  }
  get value() {
    return this._get();
  }
  set value(newVal) {
    this._set(newVal);
  }
}
function customRef(factory) {
  return new CustomRefImpl(factory);
}
function toRefs(object) {
  const ret = isArray$2(object) ? new Array(object.length) : {};
  for (const key in object) {
    ret[key] = toRef(object, key);
  }
  return ret;
}
class ObjectRefImpl {
  constructor(_object, _key, _defaultValue) {
    this._object = _object;
    this._key = _key;
    this._defaultValue = _defaultValue;
    this.__v_isRef = true;
  }
  get value() {
    const val = this._object[this._key];
    return val === void 0 ? this._defaultValue : val;
  }
  set value(newVal) {
    this._object[this._key] = newVal;
  }
}
function toRef(object, key, defaultValue) {
  const val = object[key];
  return isRef(val) ? val : new ObjectRefImpl(object, key, defaultValue);
}
class ComputedRefImpl {
  constructor(getter, _setter, isReadonly2, isSSR) {
    this._setter = _setter;
    this.dep = void 0;
    this.__v_isRef = true;
    this._dirty = true;
    this.effect = new ReactiveEffect(getter, () => {
      if (!this._dirty) {
        this._dirty = true;
        triggerRefValue(this);
      }
    });
    this.effect.computed = this;
    this.effect.active = this._cacheable = !isSSR;
    this["__v_isReadonly"] = isReadonly2;
  }
  get value() {
    const self2 = toRaw(this);
    trackRefValue(self2);
    if (self2._dirty || !self2._cacheable) {
      self2._dirty = false;
      self2._value = self2.effect.run();
    }
    return self2._value;
  }
  set value(newValue) {
    this._setter(newValue);
  }
}
function computed$1(getterOrOptions, debugOptions, isSSR = false) {
  let getter;
  let setter;
  const onlyGetter = isFunction$4(getterOrOptions);
  if (onlyGetter) {
    getter = getterOrOptions;
    setter = NOOP;
  } else {
    getter = getterOrOptions.get;
    setter = getterOrOptions.set;
  }
  const cRef = new ComputedRefImpl(getter, setter, onlyGetter || !setter, isSSR);
  return cRef;
}
Promise.resolve();
const stack = [];
function warn$1(msg, ...args) {
  pauseTracking();
  const instance = stack.length ? stack[stack.length - 1].component : null;
  const appWarnHandler = instance && instance.appContext.config.warnHandler;
  const trace = getComponentTrace();
  if (appWarnHandler) {
    callWithErrorHandling(appWarnHandler, instance, 11, [
      msg + args.join(""),
      instance && instance.proxy,
      trace.map(({ vnode }) => `at <${formatComponentName(instance, vnode.type)}>`).join("\n"),
      trace
    ]);
  } else {
    const warnArgs = [`[Vue warn]: ${msg}`, ...args];
    if (trace.length && true) {
      warnArgs.push(`
`, ...formatTrace(trace));
    }
    console.warn(...warnArgs);
  }
  resetTracking();
}
function getComponentTrace() {
  let currentVNode = stack[stack.length - 1];
  if (!currentVNode) {
    return [];
  }
  const normalizedStack = [];
  while (currentVNode) {
    const last = normalizedStack[0];
    if (last && last.vnode === currentVNode) {
      last.recurseCount++;
    } else {
      normalizedStack.push({
        vnode: currentVNode,
        recurseCount: 0
      });
    }
    const parentInstance = currentVNode.component && currentVNode.component.parent;
    currentVNode = parentInstance && parentInstance.vnode;
  }
  return normalizedStack;
}
function formatTrace(trace) {
  const logs = [];
  trace.forEach((entry, i2) => {
    logs.push(...i2 === 0 ? [] : [`
`], ...formatTraceEntry(entry));
  });
  return logs;
}
function formatTraceEntry({ vnode, recurseCount }) {
  const postfix = recurseCount > 0 ? `... (${recurseCount} recursive calls)` : ``;
  const isRoot = vnode.component ? vnode.component.parent == null : false;
  const open = ` at <${formatComponentName(vnode.component, vnode.type, isRoot)}`;
  const close = `>` + postfix;
  return vnode.props ? [open, ...formatProps(vnode.props), close] : [open + close];
}
function formatProps(props) {
  const res = [];
  const keys = Object.keys(props);
  keys.slice(0, 3).forEach((key) => {
    res.push(...formatProp(key, props[key]));
  });
  if (keys.length > 3) {
    res.push(` ...`);
  }
  return res;
}
function formatProp(key, value, raw) {
  if (isString$5(value)) {
    value = JSON.stringify(value);
    return raw ? value : [`${key}=${value}`];
  } else if (typeof value === "number" || typeof value === "boolean" || value == null) {
    return raw ? value : [`${key}=${value}`];
  } else if (isRef(value)) {
    value = formatProp(key, toRaw(value.value), true);
    return raw ? value : [`${key}=Ref<`, value, `>`];
  } else if (isFunction$4(value)) {
    return [`${key}=fn${value.name ? `<${value.name}>` : ``}`];
  } else {
    value = toRaw(value);
    return raw ? value : [`${key}=`, value];
  }
}
function callWithErrorHandling(fn, instance, type2, args) {
  let res;
  try {
    res = args ? fn(...args) : fn();
  } catch (err) {
    handleError(err, instance, type2);
  }
  return res;
}
function callWithAsyncErrorHandling(fn, instance, type2, args) {
  if (isFunction$4(fn)) {
    const res = callWithErrorHandling(fn, instance, type2, args);
    if (res && isPromise(res)) {
      res.catch((err) => {
        handleError(err, instance, type2);
      });
    }
    return res;
  }
  const values = [];
  for (let i2 = 0; i2 < fn.length; i2++) {
    values.push(callWithAsyncErrorHandling(fn[i2], instance, type2, args));
  }
  return values;
}
function handleError(err, instance, type2, throwInDev = true) {
  const contextVNode = instance ? instance.vnode : null;
  if (instance) {
    let cur = instance.parent;
    const exposedInstance = instance.proxy;
    const errorInfo = type2;
    while (cur) {
      const errorCapturedHooks = cur.ec;
      if (errorCapturedHooks) {
        for (let i2 = 0; i2 < errorCapturedHooks.length; i2++) {
          if (errorCapturedHooks[i2](err, exposedInstance, errorInfo) === false) {
            return;
          }
        }
      }
      cur = cur.parent;
    }
    const appErrorHandler = instance.appContext.config.errorHandler;
    if (appErrorHandler) {
      callWithErrorHandling(appErrorHandler, null, 10, [err, exposedInstance, errorInfo]);
      return;
    }
  }
  logError(err, type2, contextVNode, throwInDev);
}
function logError(err, type2, contextVNode, throwInDev = true) {
  {
    console.error(err);
  }
}
let isFlushing = false;
let isFlushPending = false;
const queue = [];
let flushIndex = 0;
const pendingPreFlushCbs = [];
let activePreFlushCbs = null;
let preFlushIndex = 0;
const pendingPostFlushCbs = [];
let activePostFlushCbs = null;
let postFlushIndex = 0;
const resolvedPromise = Promise.resolve();
let currentFlushPromise = null;
let currentPreFlushParentJob = null;
function nextTick(fn) {
  const p2 = currentFlushPromise || resolvedPromise;
  return fn ? p2.then(this ? fn.bind(this) : fn) : p2;
}
function findInsertionIndex(id2) {
  let start = flushIndex + 1;
  let end = queue.length;
  while (start < end) {
    const middle = start + end >>> 1;
    const middleJobId = getId$1(queue[middle]);
    middleJobId < id2 ? start = middle + 1 : end = middle;
  }
  return start;
}
function queueJob(job) {
  if ((!queue.length || !queue.includes(job, isFlushing && job.allowRecurse ? flushIndex + 1 : flushIndex)) && job !== currentPreFlushParentJob) {
    if (job.id == null) {
      queue.push(job);
    } else {
      queue.splice(findInsertionIndex(job.id), 0, job);
    }
    queueFlush();
  }
}
function queueFlush() {
  if (!isFlushing && !isFlushPending) {
    isFlushPending = true;
    currentFlushPromise = resolvedPromise.then(flushJobs);
  }
}
function invalidateJob(job) {
  const i2 = queue.indexOf(job);
  if (i2 > flushIndex) {
    queue.splice(i2, 1);
  }
}
function queueCb(cb, activeQueue, pendingQueue, index2) {
  if (!isArray$2(cb)) {
    if (!activeQueue || !activeQueue.includes(cb, cb.allowRecurse ? index2 + 1 : index2)) {
      pendingQueue.push(cb);
    }
  } else {
    pendingQueue.push(...cb);
  }
  queueFlush();
}
function queuePreFlushCb(cb) {
  queueCb(cb, activePreFlushCbs, pendingPreFlushCbs, preFlushIndex);
}
function queuePostFlushCb(cb) {
  queueCb(cb, activePostFlushCbs, pendingPostFlushCbs, postFlushIndex);
}
function flushPreFlushCbs(seen, parentJob = null) {
  if (pendingPreFlushCbs.length) {
    currentPreFlushParentJob = parentJob;
    activePreFlushCbs = [...new Set(pendingPreFlushCbs)];
    pendingPreFlushCbs.length = 0;
    for (preFlushIndex = 0; preFlushIndex < activePreFlushCbs.length; preFlushIndex++) {
      activePreFlushCbs[preFlushIndex]();
    }
    activePreFlushCbs = null;
    preFlushIndex = 0;
    currentPreFlushParentJob = null;
    flushPreFlushCbs(seen, parentJob);
  }
}
function flushPostFlushCbs(seen) {
  if (pendingPostFlushCbs.length) {
    const deduped = [...new Set(pendingPostFlushCbs)];
    pendingPostFlushCbs.length = 0;
    if (activePostFlushCbs) {
      activePostFlushCbs.push(...deduped);
      return;
    }
    activePostFlushCbs = deduped;
    activePostFlushCbs.sort((a2, b2) => getId$1(a2) - getId$1(b2));
    for (postFlushIndex = 0; postFlushIndex < activePostFlushCbs.length; postFlushIndex++) {
      activePostFlushCbs[postFlushIndex]();
    }
    activePostFlushCbs = null;
    postFlushIndex = 0;
  }
}
const getId$1 = (job) => job.id == null ? Infinity : job.id;
function flushJobs(seen) {
  isFlushPending = false;
  isFlushing = true;
  flushPreFlushCbs(seen);
  queue.sort((a2, b2) => getId$1(a2) - getId$1(b2));
  const check2 = NOOP;
  try {
    for (flushIndex = 0; flushIndex < queue.length; flushIndex++) {
      const job = queue[flushIndex];
      if (job && job.active !== false) {
        if (false)
          ;
        callWithErrorHandling(job, null, 14);
      }
    }
  } finally {
    flushIndex = 0;
    queue.length = 0;
    flushPostFlushCbs();
    isFlushing = false;
    currentFlushPromise = null;
    if (queue.length || pendingPreFlushCbs.length || pendingPostFlushCbs.length) {
      flushJobs(seen);
    }
  }
}
let devtools$1;
let buffer = [];
function setDevtoolsHook(hook, target2) {
  var _a2, _b2;
  devtools$1 = hook;
  if (devtools$1) {
    devtools$1.enabled = true;
    buffer.forEach(({ event, args }) => devtools$1.emit(event, ...args));
    buffer = [];
  } else if (typeof window !== "undefined" && window.HTMLElement && !((_b2 = (_a2 = window.navigator) === null || _a2 === void 0 ? void 0 : _a2.userAgent) === null || _b2 === void 0 ? void 0 : _b2.includes("jsdom"))) {
    const replay = target2.__VUE_DEVTOOLS_HOOK_REPLAY__ = target2.__VUE_DEVTOOLS_HOOK_REPLAY__ || [];
    replay.push((newHook) => {
      setDevtoolsHook(newHook, target2);
    });
    setTimeout(() => {
      if (!devtools$1) {
        target2.__VUE_DEVTOOLS_HOOK_REPLAY__ = null;
        buffer = [];
      }
    }, 3e3);
  } else {
    buffer = [];
  }
}
function emit$1(instance, event, ...rawArgs) {
  const props = instance.vnode.props || EMPTY_OBJ;
  let args = rawArgs;
  const isModelListener2 = event.startsWith("update:");
  const modelArg = isModelListener2 && event.slice(7);
  if (modelArg && modelArg in props) {
    const modifiersKey = `${modelArg === "modelValue" ? "model" : modelArg}Modifiers`;
    const { number: number2, trim: trim2 } = props[modifiersKey] || EMPTY_OBJ;
    if (trim2) {
      args = rawArgs.map((a2) => a2.trim());
    } else if (number2) {
      args = rawArgs.map(toNumber);
    }
  }
  let handlerName;
  let handler = props[handlerName = toHandlerKey(event)] || props[handlerName = toHandlerKey(camelize(event))];
  if (!handler && isModelListener2) {
    handler = props[handlerName = toHandlerKey(hyphenate(event))];
  }
  if (handler) {
    callWithAsyncErrorHandling(handler, instance, 6, args);
  }
  const onceHandler = props[handlerName + `Once`];
  if (onceHandler) {
    if (!instance.emitted) {
      instance.emitted = {};
    } else if (instance.emitted[handlerName]) {
      return;
    }
    instance.emitted[handlerName] = true;
    callWithAsyncErrorHandling(onceHandler, instance, 6, args);
  }
}
function normalizeEmitsOptions(comp2, appContext, asMixin = false) {
  const cache2 = appContext.emitsCache;
  const cached = cache2.get(comp2);
  if (cached !== void 0) {
    return cached;
  }
  const raw = comp2.emits;
  let normalized = {};
  let hasExtends = false;
  if (!isFunction$4(comp2)) {
    const extendEmits = (raw2) => {
      const normalizedFromExtend = normalizeEmitsOptions(raw2, appContext, true);
      if (normalizedFromExtend) {
        hasExtends = true;
        extend(normalized, normalizedFromExtend);
      }
    };
    if (!asMixin && appContext.mixins.length) {
      appContext.mixins.forEach(extendEmits);
    }
    if (comp2.extends) {
      extendEmits(comp2.extends);
    }
    if (comp2.mixins) {
      comp2.mixins.forEach(extendEmits);
    }
  }
  if (!raw && !hasExtends) {
    cache2.set(comp2, null);
    return null;
  }
  if (isArray$2(raw)) {
    raw.forEach((key) => normalized[key] = null);
  } else {
    extend(normalized, raw);
  }
  cache2.set(comp2, normalized);
  return normalized;
}
function isEmitListener(options2, key) {
  if (!options2 || !isOn(key)) {
    return false;
  }
  key = key.slice(2).replace(/Once$/, "");
  return hasOwn$1(options2, key[0].toLowerCase() + key.slice(1)) || hasOwn$1(options2, hyphenate(key)) || hasOwn$1(options2, key);
}
let currentRenderingInstance = null;
let currentScopeId = null;
function setCurrentRenderingInstance(instance) {
  const prev2 = currentRenderingInstance;
  currentRenderingInstance = instance;
  currentScopeId = instance && instance.type.__scopeId || null;
  return prev2;
}
function pushScopeId(id2) {
  currentScopeId = id2;
}
function popScopeId() {
  currentScopeId = null;
}
const withScopeId = (_id) => withCtx;
function withCtx(fn, ctx = currentRenderingInstance, isNonScopedSlot) {
  if (!ctx)
    return fn;
  if (fn._n) {
    return fn;
  }
  const renderFnWithContext = (...args) => {
    if (renderFnWithContext._d) {
      setBlockTracking(-1);
    }
    const prevInstance = setCurrentRenderingInstance(ctx);
    const res = fn(...args);
    setCurrentRenderingInstance(prevInstance);
    if (renderFnWithContext._d) {
      setBlockTracking(1);
    }
    return res;
  };
  renderFnWithContext._n = true;
  renderFnWithContext._c = true;
  renderFnWithContext._d = true;
  return renderFnWithContext;
}
function markAttrsAccessed() {
}
function renderComponentRoot(instance) {
  const { type: Component, vnode, proxy, withProxy, props, propsOptions: [propsOptions], slots, attrs, emit, render: render2, renderCache, data, setupState, ctx, inheritAttrs } = instance;
  let result;
  let fallthroughAttrs;
  const prev2 = setCurrentRenderingInstance(instance);
  try {
    if (vnode.shapeFlag & 4) {
      const proxyToUse = withProxy || proxy;
      result = normalizeVNode(render2.call(proxyToUse, proxyToUse, renderCache, props, setupState, data, ctx));
      fallthroughAttrs = attrs;
    } else {
      const render3 = Component;
      if (false)
        ;
      result = normalizeVNode(render3.length > 1 ? render3(props, false ? {
        get attrs() {
          markAttrsAccessed();
          return attrs;
        },
        slots,
        emit
      } : { attrs, slots, emit }) : render3(props, null));
      fallthroughAttrs = Component.props ? attrs : getFunctionalFallthrough(attrs);
    }
  } catch (err) {
    blockStack.length = 0;
    handleError(err, instance, 1);
    result = createVNode(Comment);
  }
  let root = result;
  if (fallthroughAttrs && inheritAttrs !== false) {
    const keys = Object.keys(fallthroughAttrs);
    const { shapeFlag } = root;
    if (keys.length) {
      if (shapeFlag & (1 | 6)) {
        if (propsOptions && keys.some(isModelListener)) {
          fallthroughAttrs = filterModelListeners(fallthroughAttrs, propsOptions);
        }
        root = cloneVNode(root, fallthroughAttrs);
      }
    }
  }
  if (vnode.dirs) {
    root.dirs = root.dirs ? root.dirs.concat(vnode.dirs) : vnode.dirs;
  }
  if (vnode.transition) {
    root.transition = vnode.transition;
  }
  {
    result = root;
  }
  setCurrentRenderingInstance(prev2);
  return result;
}
function filterSingleRoot(children) {
  let singleRoot;
  for (let i2 = 0; i2 < children.length; i2++) {
    const child = children[i2];
    if (isVNode(child)) {
      if (child.type !== Comment || child.children === "v-if") {
        if (singleRoot) {
          return;
        } else {
          singleRoot = child;
        }
      }
    } else {
      return;
    }
  }
  return singleRoot;
}
const getFunctionalFallthrough = (attrs) => {
  let res;
  for (const key in attrs) {
    if (key === "class" || key === "style" || isOn(key)) {
      (res || (res = {}))[key] = attrs[key];
    }
  }
  return res;
};
const filterModelListeners = (attrs, props) => {
  const res = {};
  for (const key in attrs) {
    if (!isModelListener(key) || !(key.slice(9) in props)) {
      res[key] = attrs[key];
    }
  }
  return res;
};
function shouldUpdateComponent(prevVNode, nextVNode, optimized) {
  const { props: prevProps, children: prevChildren, component } = prevVNode;
  const { props: nextProps, children: nextChildren, patchFlag } = nextVNode;
  const emits = component.emitsOptions;
  if (nextVNode.dirs || nextVNode.transition) {
    return true;
  }
  if (optimized && patchFlag >= 0) {
    if (patchFlag & 1024) {
      return true;
    }
    if (patchFlag & 16) {
      if (!prevProps) {
        return !!nextProps;
      }
      return hasPropsChanged(prevProps, nextProps, emits);
    } else if (patchFlag & 8) {
      const dynamicProps = nextVNode.dynamicProps;
      for (let i2 = 0; i2 < dynamicProps.length; i2++) {
        const key = dynamicProps[i2];
        if (nextProps[key] !== prevProps[key] && !isEmitListener(emits, key)) {
          return true;
        }
      }
    }
  } else {
    if (prevChildren || nextChildren) {
      if (!nextChildren || !nextChildren.$stable) {
        return true;
      }
    }
    if (prevProps === nextProps) {
      return false;
    }
    if (!prevProps) {
      return !!nextProps;
    }
    if (!nextProps) {
      return true;
    }
    return hasPropsChanged(prevProps, nextProps, emits);
  }
  return false;
}
function hasPropsChanged(prevProps, nextProps, emitsOptions) {
  const nextKeys = Object.keys(nextProps);
  if (nextKeys.length !== Object.keys(prevProps).length) {
    return true;
  }
  for (let i2 = 0; i2 < nextKeys.length; i2++) {
    const key = nextKeys[i2];
    if (nextProps[key] !== prevProps[key] && !isEmitListener(emitsOptions, key)) {
      return true;
    }
  }
  return false;
}
function updateHOCHostEl({ vnode, parent }, el2) {
  while (parent && parent.subTree === vnode) {
    (vnode = parent.vnode).el = el2;
    parent = parent.parent;
  }
}
const isSuspense = (type2) => type2.__isSuspense;
const SuspenseImpl = {
  name: "Suspense",
  __isSuspense: true,
  process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, rendererInternals) {
    if (n1 == null) {
      mountSuspense(n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, rendererInternals);
    } else {
      patchSuspense(n1, n2, container, anchor, parentComponent, isSVG, slotScopeIds, optimized, rendererInternals);
    }
  },
  hydrate: hydrateSuspense,
  create: createSuspenseBoundary,
  normalize: normalizeSuspenseChildren
};
const Suspense = SuspenseImpl;
function triggerEvent(vnode, name2) {
  const eventListener = vnode.props && vnode.props[name2];
  if (isFunction$4(eventListener)) {
    eventListener();
  }
}
function mountSuspense(vnode, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, rendererInternals) {
  const { p: patch, o: { createElement } } = rendererInternals;
  const hiddenContainer = createElement("div");
  const suspense = vnode.suspense = createSuspenseBoundary(vnode, parentSuspense, parentComponent, container, hiddenContainer, anchor, isSVG, slotScopeIds, optimized, rendererInternals);
  patch(null, suspense.pendingBranch = vnode.ssContent, hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds);
  if (suspense.deps > 0) {
    triggerEvent(vnode, "onPending");
    triggerEvent(vnode, "onFallback");
    patch(
      null,
      vnode.ssFallback,
      container,
      anchor,
      parentComponent,
      null,
      isSVG,
      slotScopeIds
    );
    setActiveBranch(suspense, vnode.ssFallback);
  } else {
    suspense.resolve();
  }
}
function patchSuspense(n1, n2, container, anchor, parentComponent, isSVG, slotScopeIds, optimized, { p: patch, um: unmount, o: { createElement } }) {
  const suspense = n2.suspense = n1.suspense;
  suspense.vnode = n2;
  n2.el = n1.el;
  const newBranch = n2.ssContent;
  const newFallback = n2.ssFallback;
  const { activeBranch, pendingBranch, isInFallback, isHydrating } = suspense;
  if (pendingBranch) {
    suspense.pendingBranch = newBranch;
    if (isSameVNodeType(newBranch, pendingBranch)) {
      patch(pendingBranch, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);
      if (suspense.deps <= 0) {
        suspense.resolve();
      } else if (isInFallback) {
        patch(
          activeBranch,
          newFallback,
          container,
          anchor,
          parentComponent,
          null,
          isSVG,
          slotScopeIds,
          optimized
        );
        setActiveBranch(suspense, newFallback);
      }
    } else {
      suspense.pendingId++;
      if (isHydrating) {
        suspense.isHydrating = false;
        suspense.activeBranch = pendingBranch;
      } else {
        unmount(pendingBranch, parentComponent, suspense);
      }
      suspense.deps = 0;
      suspense.effects.length = 0;
      suspense.hiddenContainer = createElement("div");
      if (isInFallback) {
        patch(null, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);
        if (suspense.deps <= 0) {
          suspense.resolve();
        } else {
          patch(
            activeBranch,
            newFallback,
            container,
            anchor,
            parentComponent,
            null,
            isSVG,
            slotScopeIds,
            optimized
          );
          setActiveBranch(suspense, newFallback);
        }
      } else if (activeBranch && isSameVNodeType(newBranch, activeBranch)) {
        patch(activeBranch, newBranch, container, anchor, parentComponent, suspense, isSVG, slotScopeIds, optimized);
        suspense.resolve(true);
      } else {
        patch(null, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);
        if (suspense.deps <= 0) {
          suspense.resolve();
        }
      }
    }
  } else {
    if (activeBranch && isSameVNodeType(newBranch, activeBranch)) {
      patch(activeBranch, newBranch, container, anchor, parentComponent, suspense, isSVG, slotScopeIds, optimized);
      setActiveBranch(suspense, newBranch);
    } else {
      triggerEvent(n2, "onPending");
      suspense.pendingBranch = newBranch;
      suspense.pendingId++;
      patch(null, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);
      if (suspense.deps <= 0) {
        suspense.resolve();
      } else {
        const { timeout, pendingId } = suspense;
        if (timeout > 0) {
          setTimeout(() => {
            if (suspense.pendingId === pendingId) {
              suspense.fallback(newFallback);
            }
          }, timeout);
        } else if (timeout === 0) {
          suspense.fallback(newFallback);
        }
      }
    }
  }
}
function createSuspenseBoundary(vnode, parent, parentComponent, container, hiddenContainer, anchor, isSVG, slotScopeIds, optimized, rendererInternals, isHydrating = false) {
  const { p: patch, m: move, um: unmount, n: next, o: { parentNode, remove: remove2 } } = rendererInternals;
  const timeout = toNumber(vnode.props && vnode.props.timeout);
  const suspense = {
    vnode,
    parent,
    parentComponent,
    isSVG,
    container,
    hiddenContainer,
    anchor,
    deps: 0,
    pendingId: 0,
    timeout: typeof timeout === "number" ? timeout : -1,
    activeBranch: null,
    pendingBranch: null,
    isInFallback: true,
    isHydrating,
    isUnmounted: false,
    effects: [],
    resolve(resume = false) {
      const { vnode: vnode2, activeBranch, pendingBranch, pendingId, effects, parentComponent: parentComponent2, container: container2 } = suspense;
      if (suspense.isHydrating) {
        suspense.isHydrating = false;
      } else if (!resume) {
        const delayEnter = activeBranch && pendingBranch.transition && pendingBranch.transition.mode === "out-in";
        if (delayEnter) {
          activeBranch.transition.afterLeave = () => {
            if (pendingId === suspense.pendingId) {
              move(pendingBranch, container2, anchor2, 0);
            }
          };
        }
        let { anchor: anchor2 } = suspense;
        if (activeBranch) {
          anchor2 = next(activeBranch);
          unmount(activeBranch, parentComponent2, suspense, true);
        }
        if (!delayEnter) {
          move(pendingBranch, container2, anchor2, 0);
        }
      }
      setActiveBranch(suspense, pendingBranch);
      suspense.pendingBranch = null;
      suspense.isInFallback = false;
      let parent2 = suspense.parent;
      let hasUnresolvedAncestor = false;
      while (parent2) {
        if (parent2.pendingBranch) {
          parent2.effects.push(...effects);
          hasUnresolvedAncestor = true;
          break;
        }
        parent2 = parent2.parent;
      }
      if (!hasUnresolvedAncestor) {
        queuePostFlushCb(effects);
      }
      suspense.effects = [];
      triggerEvent(vnode2, "onResolve");
    },
    fallback(fallbackVNode) {
      if (!suspense.pendingBranch) {
        return;
      }
      const { vnode: vnode2, activeBranch, parentComponent: parentComponent2, container: container2, isSVG: isSVG2 } = suspense;
      triggerEvent(vnode2, "onFallback");
      const anchor2 = next(activeBranch);
      const mountFallback = () => {
        if (!suspense.isInFallback) {
          return;
        }
        patch(
          null,
          fallbackVNode,
          container2,
          anchor2,
          parentComponent2,
          null,
          isSVG2,
          slotScopeIds,
          optimized
        );
        setActiveBranch(suspense, fallbackVNode);
      };
      const delayEnter = fallbackVNode.transition && fallbackVNode.transition.mode === "out-in";
      if (delayEnter) {
        activeBranch.transition.afterLeave = mountFallback;
      }
      suspense.isInFallback = true;
      unmount(
        activeBranch,
        parentComponent2,
        null,
        true
      );
      if (!delayEnter) {
        mountFallback();
      }
    },
    move(container2, anchor2, type2) {
      suspense.activeBranch && move(suspense.activeBranch, container2, anchor2, type2);
      suspense.container = container2;
    },
    next() {
      return suspense.activeBranch && next(suspense.activeBranch);
    },
    registerDep(instance, setupRenderEffect) {
      const isInPendingSuspense = !!suspense.pendingBranch;
      if (isInPendingSuspense) {
        suspense.deps++;
      }
      const hydratedEl = instance.vnode.el;
      instance.asyncDep.catch((err) => {
        handleError(err, instance, 0);
      }).then((asyncSetupResult) => {
        if (instance.isUnmounted || suspense.isUnmounted || suspense.pendingId !== instance.suspenseId) {
          return;
        }
        instance.asyncResolved = true;
        const { vnode: vnode2 } = instance;
        handleSetupResult(instance, asyncSetupResult, false);
        if (hydratedEl) {
          vnode2.el = hydratedEl;
        }
        const placeholder = !hydratedEl && instance.subTree.el;
        setupRenderEffect(
          instance,
          vnode2,
          parentNode(hydratedEl || instance.subTree.el),
          hydratedEl ? null : next(instance.subTree),
          suspense,
          isSVG,
          optimized
        );
        if (placeholder) {
          remove2(placeholder);
        }
        updateHOCHostEl(instance, vnode2.el);
        if (isInPendingSuspense && --suspense.deps === 0) {
          suspense.resolve();
        }
      });
    },
    unmount(parentSuspense, doRemove) {
      suspense.isUnmounted = true;
      if (suspense.activeBranch) {
        unmount(suspense.activeBranch, parentComponent, parentSuspense, doRemove);
      }
      if (suspense.pendingBranch) {
        unmount(suspense.pendingBranch, parentComponent, parentSuspense, doRemove);
      }
    }
  };
  return suspense;
}
function hydrateSuspense(node, vnode, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, rendererInternals, hydrateNode) {
  const suspense = vnode.suspense = createSuspenseBoundary(vnode, parentSuspense, parentComponent, node.parentNode, document.createElement("div"), null, isSVG, slotScopeIds, optimized, rendererInternals, true);
  const result = hydrateNode(node, suspense.pendingBranch = vnode.ssContent, parentComponent, suspense, slotScopeIds, optimized);
  if (suspense.deps === 0) {
    suspense.resolve();
  }
  return result;
}
function normalizeSuspenseChildren(vnode) {
  const { shapeFlag, children } = vnode;
  const isSlotChildren = shapeFlag & 32;
  vnode.ssContent = normalizeSuspenseSlot(isSlotChildren ? children.default : children);
  vnode.ssFallback = isSlotChildren ? normalizeSuspenseSlot(children.fallback) : createVNode(Comment);
}
function normalizeSuspenseSlot(s2) {
  let block3;
  if (isFunction$4(s2)) {
    const trackBlock = isBlockTreeEnabled && s2._c;
    if (trackBlock) {
      s2._d = false;
      openBlock();
    }
    s2 = s2();
    if (trackBlock) {
      s2._d = true;
      block3 = currentBlock;
      closeBlock();
    }
  }
  if (isArray$2(s2)) {
    const singleChild = filterSingleRoot(s2);
    s2 = singleChild;
  }
  s2 = normalizeVNode(s2);
  if (block3 && !s2.dynamicChildren) {
    s2.dynamicChildren = block3.filter((c2) => c2 !== s2);
  }
  return s2;
}
function queueEffectWithSuspense(fn, suspense) {
  if (suspense && suspense.pendingBranch) {
    if (isArray$2(fn)) {
      suspense.effects.push(...fn);
    } else {
      suspense.effects.push(fn);
    }
  } else {
    queuePostFlushCb(fn);
  }
}
function setActiveBranch(suspense, branch) {
  suspense.activeBranch = branch;
  const { vnode, parentComponent } = suspense;
  const el2 = vnode.el = branch.el;
  if (parentComponent && parentComponent.subTree === vnode) {
    parentComponent.vnode.el = el2;
    updateHOCHostEl(parentComponent, el2);
  }
}
function provide(key, value) {
  if (!currentInstance)
    ;
  else {
    let provides = currentInstance.provides;
    const parentProvides = currentInstance.parent && currentInstance.parent.provides;
    if (parentProvides === provides) {
      provides = currentInstance.provides = Object.create(parentProvides);
    }
    provides[key] = value;
  }
}
function inject(key, defaultValue, treatDefaultAsFactory = false) {
  const instance = currentInstance || currentRenderingInstance;
  if (instance) {
    const provides = instance.parent == null ? instance.vnode.appContext && instance.vnode.appContext.provides : instance.parent.provides;
    if (provides && key in provides) {
      return provides[key];
    } else if (arguments.length > 1) {
      return treatDefaultAsFactory && isFunction$4(defaultValue) ? defaultValue.call(instance.proxy) : defaultValue;
    } else
      ;
  }
}
function watchEffect(effect2, options2) {
  return doWatch(effect2, null, options2);
}
function watchPostEffect(effect2, options2) {
  return doWatch(effect2, null, { flush: "post" });
}
function watchSyncEffect(effect2, options2) {
  return doWatch(effect2, null, { flush: "sync" });
}
const INITIAL_WATCHER_VALUE = {};
function watch(source, cb, options2) {
  return doWatch(source, cb, options2);
}
function doWatch(source, cb, { immediate, deep, flush, onTrack, onTrigger } = EMPTY_OBJ) {
  const instance = currentInstance;
  let getter;
  let forceTrigger = false;
  let isMultiSource = false;
  if (isRef(source)) {
    getter = () => source.value;
    forceTrigger = isShallow(source);
  } else if (isReactive(source)) {
    getter = () => source;
    deep = true;
  } else if (isArray$2(source)) {
    isMultiSource = true;
    forceTrigger = source.some(isReactive);
    getter = () => source.map((s2) => {
      if (isRef(s2)) {
        return s2.value;
      } else if (isReactive(s2)) {
        return traverse(s2);
      } else if (isFunction$4(s2)) {
        return callWithErrorHandling(s2, instance, 2);
      } else
        ;
    });
  } else if (isFunction$4(source)) {
    if (cb) {
      getter = () => callWithErrorHandling(source, instance, 2);
    } else {
      getter = () => {
        if (instance && instance.isUnmounted) {
          return;
        }
        if (cleanup) {
          cleanup();
        }
        return callWithAsyncErrorHandling(source, instance, 3, [onCleanup]);
      };
    }
  } else {
    getter = NOOP;
  }
  if (cb && deep) {
    const baseGetter = getter;
    getter = () => traverse(baseGetter());
  }
  let cleanup;
  let onCleanup = (fn) => {
    cleanup = effect2.onStop = () => {
      callWithErrorHandling(fn, instance, 4);
    };
  };
  if (isInSSRComponentSetup) {
    onCleanup = NOOP;
    if (!cb) {
      getter();
    } else if (immediate) {
      callWithAsyncErrorHandling(cb, instance, 3, [
        getter(),
        isMultiSource ? [] : void 0,
        onCleanup
      ]);
    }
    return NOOP;
  }
  let oldValue = isMultiSource ? [] : INITIAL_WATCHER_VALUE;
  const job = () => {
    if (!effect2.active) {
      return;
    }
    if (cb) {
      const newValue = effect2.run();
      if (deep || forceTrigger || (isMultiSource ? newValue.some((v, i2) => hasChanged(v, oldValue[i2])) : hasChanged(newValue, oldValue)) || false) {
        if (cleanup) {
          cleanup();
        }
        callWithAsyncErrorHandling(cb, instance, 3, [
          newValue,
          oldValue === INITIAL_WATCHER_VALUE ? void 0 : oldValue,
          onCleanup
        ]);
        oldValue = newValue;
      }
    } else {
      effect2.run();
    }
  };
  job.allowRecurse = !!cb;
  let scheduler;
  if (flush === "sync") {
    scheduler = job;
  } else if (flush === "post") {
    scheduler = () => queuePostRenderEffect(job, instance && instance.suspense);
  } else {
    scheduler = () => {
      if (!instance || instance.isMounted) {
        queuePreFlushCb(job);
      } else {
        job();
      }
    };
  }
  const effect2 = new ReactiveEffect(getter, scheduler);
  if (cb) {
    if (immediate) {
      job();
    } else {
      oldValue = effect2.run();
    }
  } else if (flush === "post") {
    queuePostRenderEffect(effect2.run.bind(effect2), instance && instance.suspense);
  } else {
    effect2.run();
  }
  return () => {
    effect2.stop();
    if (instance && instance.scope) {
      remove(instance.scope.effects, effect2);
    }
  };
}
function instanceWatch(source, value, options2) {
  const publicThis = this.proxy;
  const getter = isString$5(source) ? source.includes(".") ? createPathGetter(publicThis, source) : () => publicThis[source] : source.bind(publicThis, publicThis);
  let cb;
  if (isFunction$4(value)) {
    cb = value;
  } else {
    cb = value.handler;
    options2 = value;
  }
  const cur = currentInstance;
  setCurrentInstance(this);
  const res = doWatch(getter, cb.bind(publicThis), options2);
  if (cur) {
    setCurrentInstance(cur);
  } else {
    unsetCurrentInstance();
  }
  return res;
}
function createPathGetter(ctx, path) {
  const segments = path.split(".");
  return () => {
    let cur = ctx;
    for (let i2 = 0; i2 < segments.length && cur; i2++) {
      cur = cur[segments[i2]];
    }
    return cur;
  };
}
function traverse(value, seen) {
  if (!isObject$5(value) || value["__v_skip"]) {
    return value;
  }
  seen = seen || /* @__PURE__ */ new Set();
  if (seen.has(value)) {
    return value;
  }
  seen.add(value);
  if (isRef(value)) {
    traverse(value.value, seen);
  } else if (isArray$2(value)) {
    for (let i2 = 0; i2 < value.length; i2++) {
      traverse(value[i2], seen);
    }
  } else if (isSet(value) || isMap(value)) {
    value.forEach((v) => {
      traverse(v, seen);
    });
  } else if (isPlainObject$3(value)) {
    for (const key in value) {
      traverse(value[key], seen);
    }
  }
  return value;
}
function useTransitionState() {
  const state = {
    isMounted: false,
    isLeaving: false,
    isUnmounting: false,
    leavingVNodes: /* @__PURE__ */ new Map()
  };
  onMounted(() => {
    state.isMounted = true;
  });
  onBeforeUnmount(() => {
    state.isUnmounting = true;
  });
  return state;
}
const TransitionHookValidator = [Function, Array];
const BaseTransitionImpl = {
  name: `BaseTransition`,
  props: {
    mode: String,
    appear: Boolean,
    persisted: Boolean,
    onBeforeEnter: TransitionHookValidator,
    onEnter: TransitionHookValidator,
    onAfterEnter: TransitionHookValidator,
    onEnterCancelled: TransitionHookValidator,
    onBeforeLeave: TransitionHookValidator,
    onLeave: TransitionHookValidator,
    onAfterLeave: TransitionHookValidator,
    onLeaveCancelled: TransitionHookValidator,
    onBeforeAppear: TransitionHookValidator,
    onAppear: TransitionHookValidator,
    onAfterAppear: TransitionHookValidator,
    onAppearCancelled: TransitionHookValidator
  },
  setup(props, { slots }) {
    const instance = getCurrentInstance();
    const state = useTransitionState();
    let prevTransitionKey;
    return () => {
      const children = slots.default && getTransitionRawChildren(slots.default(), true);
      if (!children || !children.length) {
        return;
      }
      const rawProps = toRaw(props);
      const { mode } = rawProps;
      const child = children[0];
      if (state.isLeaving) {
        return emptyPlaceholder(child);
      }
      const innerChild = getKeepAliveChild(child);
      if (!innerChild) {
        return emptyPlaceholder(child);
      }
      const enterHooks = resolveTransitionHooks(innerChild, rawProps, state, instance);
      setTransitionHooks(innerChild, enterHooks);
      const oldChild = instance.subTree;
      const oldInnerChild = oldChild && getKeepAliveChild(oldChild);
      let transitionKeyChanged = false;
      const { getTransitionKey } = innerChild.type;
      if (getTransitionKey) {
        const key = getTransitionKey();
        if (prevTransitionKey === void 0) {
          prevTransitionKey = key;
        } else if (key !== prevTransitionKey) {
          prevTransitionKey = key;
          transitionKeyChanged = true;
        }
      }
      if (oldInnerChild && oldInnerChild.type !== Comment && (!isSameVNodeType(innerChild, oldInnerChild) || transitionKeyChanged)) {
        const leavingHooks = resolveTransitionHooks(oldInnerChild, rawProps, state, instance);
        setTransitionHooks(oldInnerChild, leavingHooks);
        if (mode === "out-in") {
          state.isLeaving = true;
          leavingHooks.afterLeave = () => {
            state.isLeaving = false;
            instance.update();
          };
          return emptyPlaceholder(child);
        } else if (mode === "in-out" && innerChild.type !== Comment) {
          leavingHooks.delayLeave = (el2, earlyRemove, delayedLeave) => {
            const leavingVNodesCache = getLeavingNodesForType(state, oldInnerChild);
            leavingVNodesCache[String(oldInnerChild.key)] = oldInnerChild;
            el2._leaveCb = () => {
              earlyRemove();
              el2._leaveCb = void 0;
              delete enterHooks.delayedLeave;
            };
            enterHooks.delayedLeave = delayedLeave;
          };
        }
      }
      return child;
    };
  }
};
const BaseTransition = BaseTransitionImpl;
function getLeavingNodesForType(state, vnode) {
  const { leavingVNodes } = state;
  let leavingVNodesCache = leavingVNodes.get(vnode.type);
  if (!leavingVNodesCache) {
    leavingVNodesCache = /* @__PURE__ */ Object.create(null);
    leavingVNodes.set(vnode.type, leavingVNodesCache);
  }
  return leavingVNodesCache;
}
function resolveTransitionHooks(vnode, props, state, instance) {
  const { appear, mode, persisted = false, onBeforeEnter, onEnter, onAfterEnter, onEnterCancelled, onBeforeLeave, onLeave, onAfterLeave, onLeaveCancelled, onBeforeAppear, onAppear, onAfterAppear, onAppearCancelled } = props;
  const key = String(vnode.key);
  const leavingVNodesCache = getLeavingNodesForType(state, vnode);
  const callHook2 = (hook, args) => {
    hook && callWithAsyncErrorHandling(hook, instance, 9, args);
  };
  const hooks = {
    mode,
    persisted,
    beforeEnter(el2) {
      let hook = onBeforeEnter;
      if (!state.isMounted) {
        if (appear) {
          hook = onBeforeAppear || onBeforeEnter;
        } else {
          return;
        }
      }
      if (el2._leaveCb) {
        el2._leaveCb(true);
      }
      const leavingVNode = leavingVNodesCache[key];
      if (leavingVNode && isSameVNodeType(vnode, leavingVNode) && leavingVNode.el._leaveCb) {
        leavingVNode.el._leaveCb();
      }
      callHook2(hook, [el2]);
    },
    enter(el2) {
      let hook = onEnter;
      let afterHook = onAfterEnter;
      let cancelHook = onEnterCancelled;
      if (!state.isMounted) {
        if (appear) {
          hook = onAppear || onEnter;
          afterHook = onAfterAppear || onAfterEnter;
          cancelHook = onAppearCancelled || onEnterCancelled;
        } else {
          return;
        }
      }
      let called = false;
      const done = el2._enterCb = (cancelled) => {
        if (called)
          return;
        called = true;
        if (cancelled) {
          callHook2(cancelHook, [el2]);
        } else {
          callHook2(afterHook, [el2]);
        }
        if (hooks.delayedLeave) {
          hooks.delayedLeave();
        }
        el2._enterCb = void 0;
      };
      if (hook) {
        hook(el2, done);
        if (hook.length <= 1) {
          done();
        }
      } else {
        done();
      }
    },
    leave(el2, remove2) {
      const key2 = String(vnode.key);
      if (el2._enterCb) {
        el2._enterCb(true);
      }
      if (state.isUnmounting) {
        return remove2();
      }
      callHook2(onBeforeLeave, [el2]);
      let called = false;
      const done = el2._leaveCb = (cancelled) => {
        if (called)
          return;
        called = true;
        remove2();
        if (cancelled) {
          callHook2(onLeaveCancelled, [el2]);
        } else {
          callHook2(onAfterLeave, [el2]);
        }
        el2._leaveCb = void 0;
        if (leavingVNodesCache[key2] === vnode) {
          delete leavingVNodesCache[key2];
        }
      };
      leavingVNodesCache[key2] = vnode;
      if (onLeave) {
        onLeave(el2, done);
        if (onLeave.length <= 1) {
          done();
        }
      } else {
        done();
      }
    },
    clone(vnode2) {
      return resolveTransitionHooks(vnode2, props, state, instance);
    }
  };
  return hooks;
}
function emptyPlaceholder(vnode) {
  if (isKeepAlive(vnode)) {
    vnode = cloneVNode(vnode);
    vnode.children = null;
    return vnode;
  }
}
function getKeepAliveChild(vnode) {
  return isKeepAlive(vnode) ? vnode.children ? vnode.children[0] : void 0 : vnode;
}
function setTransitionHooks(vnode, hooks) {
  if (vnode.shapeFlag & 6 && vnode.component) {
    setTransitionHooks(vnode.component.subTree, hooks);
  } else if (vnode.shapeFlag & 128) {
    vnode.ssContent.transition = hooks.clone(vnode.ssContent);
    vnode.ssFallback.transition = hooks.clone(vnode.ssFallback);
  } else {
    vnode.transition = hooks;
  }
}
function getTransitionRawChildren(children, keepComment = false) {
  let ret = [];
  let keyedFragmentCount = 0;
  for (let i2 = 0; i2 < children.length; i2++) {
    const child = children[i2];
    if (child.type === Fragment) {
      if (child.patchFlag & 128)
        keyedFragmentCount++;
      ret = ret.concat(getTransitionRawChildren(child.children, keepComment));
    } else if (keepComment || child.type !== Comment) {
      ret.push(child);
    }
  }
  if (keyedFragmentCount > 1) {
    for (let i2 = 0; i2 < ret.length; i2++) {
      ret[i2].patchFlag = -2;
    }
  }
  return ret;
}
function defineComponent(options2) {
  return isFunction$4(options2) ? { setup: options2, name: options2.name } : options2;
}
const isAsyncWrapper = (i2) => !!i2.type.__asyncLoader;
function defineAsyncComponent(source) {
  if (isFunction$4(source)) {
    source = { loader: source };
  }
  const {
    loader,
    loadingComponent,
    errorComponent,
    delay = 200,
    timeout,
    suspensible = true,
    onError: userOnError
  } = source;
  let pendingRequest = null;
  let resolvedComp;
  let retries = 0;
  const retry = () => {
    retries++;
    pendingRequest = null;
    return load();
  };
  const load = () => {
    let thisRequest;
    return pendingRequest || (thisRequest = pendingRequest = loader().catch((err) => {
      err = err instanceof Error ? err : new Error(String(err));
      if (userOnError) {
        return new Promise((resolve3, reject) => {
          const userRetry = () => resolve3(retry());
          const userFail = () => reject(err);
          userOnError(err, userRetry, userFail, retries + 1);
        });
      } else {
        throw err;
      }
    }).then((comp2) => {
      if (thisRequest !== pendingRequest && pendingRequest) {
        return pendingRequest;
      }
      if (comp2 && (comp2.__esModule || comp2[Symbol.toStringTag] === "Module")) {
        comp2 = comp2.default;
      }
      resolvedComp = comp2;
      return comp2;
    }));
  };
  return defineComponent({
    name: "AsyncComponentWrapper",
    __asyncLoader: load,
    get __asyncResolved() {
      return resolvedComp;
    },
    setup() {
      const instance = currentInstance;
      if (resolvedComp) {
        return () => createInnerComp(resolvedComp, instance);
      }
      const onError = (err) => {
        pendingRequest = null;
        handleError(err, instance, 13, !errorComponent);
      };
      if (suspensible && instance.suspense || isInSSRComponentSetup) {
        return load().then((comp2) => {
          return () => createInnerComp(comp2, instance);
        }).catch((err) => {
          onError(err);
          return () => errorComponent ? createVNode(errorComponent, {
            error: err
          }) : null;
        });
      }
      const loaded = ref(false);
      const error2 = ref();
      const delayed = ref(!!delay);
      if (delay) {
        setTimeout(() => {
          delayed.value = false;
        }, delay);
      }
      if (timeout != null) {
        setTimeout(() => {
          if (!loaded.value && !error2.value) {
            const err = new Error(`Async component timed out after ${timeout}ms.`);
            onError(err);
            error2.value = err;
          }
        }, timeout);
      }
      load().then(() => {
        loaded.value = true;
        if (instance.parent && isKeepAlive(instance.parent.vnode)) {
          queueJob(instance.parent.update);
        }
      }).catch((err) => {
        onError(err);
        error2.value = err;
      });
      return () => {
        if (loaded.value && resolvedComp) {
          return createInnerComp(resolvedComp, instance);
        } else if (error2.value && errorComponent) {
          return createVNode(errorComponent, {
            error: error2.value
          });
        } else if (loadingComponent && !delayed.value) {
          return createVNode(loadingComponent);
        }
      };
    }
  });
}
function createInnerComp(comp2, { vnode: { ref: ref2, props, children } }) {
  const vnode = createVNode(comp2, props, children);
  vnode.ref = ref2;
  return vnode;
}
const isKeepAlive = (vnode) => vnode.type.__isKeepAlive;
const KeepAliveImpl = {
  name: `KeepAlive`,
  __isKeepAlive: true,
  props: {
    include: [String, RegExp, Array],
    exclude: [String, RegExp, Array],
    max: [String, Number]
  },
  setup(props, { slots }) {
    const instance = getCurrentInstance();
    const sharedContext = instance.ctx;
    if (!sharedContext.renderer) {
      return slots.default;
    }
    const cache2 = /* @__PURE__ */ new Map();
    const keys = /* @__PURE__ */ new Set();
    let current = null;
    const parentSuspense = instance.suspense;
    const { renderer: { p: patch, m: move, um: _unmount, o: { createElement } } } = sharedContext;
    const storageContainer = createElement("div");
    sharedContext.activate = (vnode, container, anchor, isSVG, optimized) => {
      const instance2 = vnode.component;
      move(vnode, container, anchor, 0, parentSuspense);
      patch(instance2.vnode, vnode, container, anchor, instance2, parentSuspense, isSVG, vnode.slotScopeIds, optimized);
      queuePostRenderEffect(() => {
        instance2.isDeactivated = false;
        if (instance2.a) {
          invokeArrayFns(instance2.a);
        }
        const vnodeHook = vnode.props && vnode.props.onVnodeMounted;
        if (vnodeHook) {
          invokeVNodeHook(vnodeHook, instance2.parent, vnode);
        }
      }, parentSuspense);
    };
    sharedContext.deactivate = (vnode) => {
      const instance2 = vnode.component;
      move(vnode, storageContainer, null, 1, parentSuspense);
      queuePostRenderEffect(() => {
        if (instance2.da) {
          invokeArrayFns(instance2.da);
        }
        const vnodeHook = vnode.props && vnode.props.onVnodeUnmounted;
        if (vnodeHook) {
          invokeVNodeHook(vnodeHook, instance2.parent, vnode);
        }
        instance2.isDeactivated = true;
      }, parentSuspense);
    };
    function unmount(vnode) {
      resetShapeFlag(vnode);
      _unmount(vnode, instance, parentSuspense, true);
    }
    function pruneCache(filter) {
      cache2.forEach((vnode, key) => {
        const name2 = getComponentName(vnode.type);
        if (name2 && (!filter || !filter(name2))) {
          pruneCacheEntry(key);
        }
      });
    }
    function pruneCacheEntry(key) {
      const cached = cache2.get(key);
      if (!current || cached.type !== current.type) {
        unmount(cached);
      } else if (current) {
        resetShapeFlag(current);
      }
      cache2.delete(key);
      keys.delete(key);
    }
    watch(
      () => [props.include, props.exclude],
      ([include, exclude]) => {
        include && pruneCache((name2) => matches$1(include, name2));
        exclude && pruneCache((name2) => !matches$1(exclude, name2));
      },
      { flush: "post", deep: true }
    );
    let pendingCacheKey = null;
    const cacheSubtree = () => {
      if (pendingCacheKey != null) {
        cache2.set(pendingCacheKey, getInnerChild(instance.subTree));
      }
    };
    onMounted(cacheSubtree);
    onUpdated(cacheSubtree);
    onBeforeUnmount(() => {
      cache2.forEach((cached) => {
        const { subTree, suspense } = instance;
        const vnode = getInnerChild(subTree);
        if (cached.type === vnode.type) {
          resetShapeFlag(vnode);
          const da = vnode.component.da;
          da && queuePostRenderEffect(da, suspense);
          return;
        }
        unmount(cached);
      });
    });
    return () => {
      pendingCacheKey = null;
      if (!slots.default) {
        return null;
      }
      const children = slots.default();
      const rawVNode = children[0];
      if (children.length > 1) {
        current = null;
        return children;
      } else if (!isVNode(rawVNode) || !(rawVNode.shapeFlag & 4) && !(rawVNode.shapeFlag & 128)) {
        current = null;
        return rawVNode;
      }
      let vnode = getInnerChild(rawVNode);
      const comp2 = vnode.type;
      const name2 = getComponentName(isAsyncWrapper(vnode) ? vnode.type.__asyncResolved || {} : comp2);
      const { include, exclude, max: max2 } = props;
      if (include && (!name2 || !matches$1(include, name2)) || exclude && name2 && matches$1(exclude, name2)) {
        current = vnode;
        return rawVNode;
      }
      const key = vnode.key == null ? comp2 : vnode.key;
      const cachedVNode = cache2.get(key);
      if (vnode.el) {
        vnode = cloneVNode(vnode);
        if (rawVNode.shapeFlag & 128) {
          rawVNode.ssContent = vnode;
        }
      }
      pendingCacheKey = key;
      if (cachedVNode) {
        vnode.el = cachedVNode.el;
        vnode.component = cachedVNode.component;
        if (vnode.transition) {
          setTransitionHooks(vnode, vnode.transition);
        }
        vnode.shapeFlag |= 512;
        keys.delete(key);
        keys.add(key);
      } else {
        keys.add(key);
        if (max2 && keys.size > parseInt(max2, 10)) {
          pruneCacheEntry(keys.values().next().value);
        }
      }
      vnode.shapeFlag |= 256;
      current = vnode;
      return rawVNode;
    };
  }
};
const KeepAlive = KeepAliveImpl;
function matches$1(pattern, name2) {
  if (isArray$2(pattern)) {
    return pattern.some((p2) => matches$1(p2, name2));
  } else if (isString$5(pattern)) {
    return pattern.split(",").includes(name2);
  } else if (pattern.test) {
    return pattern.test(name2);
  }
  return false;
}
function onActivated(hook, target2) {
  registerKeepAliveHook(hook, "a", target2);
}
function onDeactivated(hook, target2) {
  registerKeepAliveHook(hook, "da", target2);
}
function registerKeepAliveHook(hook, type2, target2 = currentInstance) {
  const wrappedHook = hook.__wdc || (hook.__wdc = () => {
    let current = target2;
    while (current) {
      if (current.isDeactivated) {
        return;
      }
      current = current.parent;
    }
    return hook();
  });
  injectHook(type2, wrappedHook, target2);
  if (target2) {
    let current = target2.parent;
    while (current && current.parent) {
      if (isKeepAlive(current.parent.vnode)) {
        injectToKeepAliveRoot(wrappedHook, type2, target2, current);
      }
      current = current.parent;
    }
  }
}
function injectToKeepAliveRoot(hook, type2, target2, keepAliveRoot) {
  const injected = injectHook(type2, hook, keepAliveRoot, true);
  onUnmounted(() => {
    remove(keepAliveRoot[type2], injected);
  }, target2);
}
function resetShapeFlag(vnode) {
  let shapeFlag = vnode.shapeFlag;
  if (shapeFlag & 256) {
    shapeFlag -= 256;
  }
  if (shapeFlag & 512) {
    shapeFlag -= 512;
  }
  vnode.shapeFlag = shapeFlag;
}
function getInnerChild(vnode) {
  return vnode.shapeFlag & 128 ? vnode.ssContent : vnode;
}
function injectHook(type2, hook, target2 = currentInstance, prepend = false) {
  if (target2) {
    const hooks = target2[type2] || (target2[type2] = []);
    const wrappedHook = hook.__weh || (hook.__weh = (...args) => {
      if (target2.isUnmounted) {
        return;
      }
      pauseTracking();
      setCurrentInstance(target2);
      const res = callWithAsyncErrorHandling(hook, target2, type2, args);
      unsetCurrentInstance();
      resetTracking();
      return res;
    });
    if (prepend) {
      hooks.unshift(wrappedHook);
    } else {
      hooks.push(wrappedHook);
    }
    return wrappedHook;
  }
}
const createHook = (lifecycle) => (hook, target2 = currentInstance) => (!isInSSRComponentSetup || lifecycle === "sp") && injectHook(lifecycle, hook, target2);
const onBeforeMount = createHook("bm");
const onMounted = createHook("m");
const onBeforeUpdate = createHook("bu");
const onUpdated = createHook("u");
const onBeforeUnmount = createHook("bum");
const onUnmounted = createHook("um");
const onServerPrefetch = createHook("sp");
const onRenderTriggered = createHook("rtg");
const onRenderTracked = createHook("rtc");
function onErrorCaptured(hook, target2 = currentInstance) {
  injectHook("ec", hook, target2);
}
let shouldCacheAccess = true;
function applyOptions(instance) {
  const options2 = resolveMergedOptions(instance);
  const publicThis = instance.proxy;
  const ctx = instance.ctx;
  shouldCacheAccess = false;
  if (options2.beforeCreate) {
    callHook$1(options2.beforeCreate, instance, "bc");
  }
  const {
    data: dataOptions,
    computed: computedOptions,
    methods,
    watch: watchOptions,
    provide: provideOptions,
    inject: injectOptions,
    created,
    beforeMount,
    mounted,
    beforeUpdate,
    updated,
    activated,
    deactivated,
    beforeDestroy,
    beforeUnmount,
    destroyed,
    unmounted,
    render: render2,
    renderTracked,
    renderTriggered,
    errorCaptured,
    serverPrefetch,
    expose,
    inheritAttrs,
    components,
    directives,
    filters
  } = options2;
  const checkDuplicateProperties = null;
  if (injectOptions) {
    resolveInjections(injectOptions, ctx, checkDuplicateProperties, instance.appContext.config.unwrapInjectedRef);
  }
  if (methods) {
    for (const key in methods) {
      const methodHandler = methods[key];
      if (isFunction$4(methodHandler)) {
        {
          ctx[key] = methodHandler.bind(publicThis);
        }
      }
    }
  }
  if (dataOptions) {
    const data = dataOptions.call(publicThis, publicThis);
    if (!isObject$5(data))
      ;
    else {
      instance.data = reactive(data);
    }
  }
  shouldCacheAccess = true;
  if (computedOptions) {
    for (const key in computedOptions) {
      const opt = computedOptions[key];
      const get2 = isFunction$4(opt) ? opt.bind(publicThis, publicThis) : isFunction$4(opt.get) ? opt.get.bind(publicThis, publicThis) : NOOP;
      const set3 = !isFunction$4(opt) && isFunction$4(opt.set) ? opt.set.bind(publicThis) : NOOP;
      const c2 = computed({
        get: get2,
        set: set3
      });
      Object.defineProperty(ctx, key, {
        enumerable: true,
        configurable: true,
        get: () => c2.value,
        set: (v) => c2.value = v
      });
    }
  }
  if (watchOptions) {
    for (const key in watchOptions) {
      createWatcher(watchOptions[key], ctx, publicThis, key);
    }
  }
  if (provideOptions) {
    const provides = isFunction$4(provideOptions) ? provideOptions.call(publicThis) : provideOptions;
    Reflect.ownKeys(provides).forEach((key) => {
      provide(key, provides[key]);
    });
  }
  if (created) {
    callHook$1(created, instance, "c");
  }
  function registerLifecycleHook(register, hook) {
    if (isArray$2(hook)) {
      hook.forEach((_hook) => register(_hook.bind(publicThis)));
    } else if (hook) {
      register(hook.bind(publicThis));
    }
  }
  registerLifecycleHook(onBeforeMount, beforeMount);
  registerLifecycleHook(onMounted, mounted);
  registerLifecycleHook(onBeforeUpdate, beforeUpdate);
  registerLifecycleHook(onUpdated, updated);
  registerLifecycleHook(onActivated, activated);
  registerLifecycleHook(onDeactivated, deactivated);
  registerLifecycleHook(onErrorCaptured, errorCaptured);
  registerLifecycleHook(onRenderTracked, renderTracked);
  registerLifecycleHook(onRenderTriggered, renderTriggered);
  registerLifecycleHook(onBeforeUnmount, beforeUnmount);
  registerLifecycleHook(onUnmounted, unmounted);
  registerLifecycleHook(onServerPrefetch, serverPrefetch);
  if (isArray$2(expose)) {
    if (expose.length) {
      const exposed = instance.exposed || (instance.exposed = {});
      expose.forEach((key) => {
        Object.defineProperty(exposed, key, {
          get: () => publicThis[key],
          set: (val) => publicThis[key] = val
        });
      });
    } else if (!instance.exposed) {
      instance.exposed = {};
    }
  }
  if (render2 && instance.render === NOOP) {
    instance.render = render2;
  }
  if (inheritAttrs != null) {
    instance.inheritAttrs = inheritAttrs;
  }
  if (components)
    instance.components = components;
  if (directives)
    instance.directives = directives;
}
function resolveInjections(injectOptions, ctx, checkDuplicateProperties = NOOP, unwrapRef = false) {
  if (isArray$2(injectOptions)) {
    injectOptions = normalizeInject(injectOptions);
  }
  for (const key in injectOptions) {
    const opt = injectOptions[key];
    let injected;
    if (isObject$5(opt)) {
      if ("default" in opt) {
        injected = inject(opt.from || key, opt.default, true);
      } else {
        injected = inject(opt.from || key);
      }
    } else {
      injected = inject(opt);
    }
    if (isRef(injected)) {
      if (unwrapRef) {
        Object.defineProperty(ctx, key, {
          enumerable: true,
          configurable: true,
          get: () => injected.value,
          set: (v) => injected.value = v
        });
      } else {
        ctx[key] = injected;
      }
    } else {
      ctx[key] = injected;
    }
  }
}
function callHook$1(hook, instance, type2) {
  callWithAsyncErrorHandling(isArray$2(hook) ? hook.map((h2) => h2.bind(instance.proxy)) : hook.bind(instance.proxy), instance, type2);
}
function createWatcher(raw, ctx, publicThis, key) {
  const getter = key.includes(".") ? createPathGetter(publicThis, key) : () => publicThis[key];
  if (isString$5(raw)) {
    const handler = ctx[raw];
    if (isFunction$4(handler)) {
      watch(getter, handler);
    }
  } else if (isFunction$4(raw)) {
    watch(getter, raw.bind(publicThis));
  } else if (isObject$5(raw)) {
    if (isArray$2(raw)) {
      raw.forEach((r2) => createWatcher(r2, ctx, publicThis, key));
    } else {
      const handler = isFunction$4(raw.handler) ? raw.handler.bind(publicThis) : ctx[raw.handler];
      if (isFunction$4(handler)) {
        watch(getter, handler, raw);
      }
    }
  } else
    ;
}
function resolveMergedOptions(instance) {
  const base2 = instance.type;
  const { mixins, extends: extendsOptions } = base2;
  const { mixins: globalMixins, optionsCache: cache2, config: { optionMergeStrategies } } = instance.appContext;
  const cached = cache2.get(base2);
  let resolved;
  if (cached) {
    resolved = cached;
  } else if (!globalMixins.length && !mixins && !extendsOptions) {
    {
      resolved = base2;
    }
  } else {
    resolved = {};
    if (globalMixins.length) {
      globalMixins.forEach((m2) => mergeOptions(resolved, m2, optionMergeStrategies, true));
    }
    mergeOptions(resolved, base2, optionMergeStrategies);
  }
  cache2.set(base2, resolved);
  return resolved;
}
function mergeOptions(to, from, strats, asMixin = false) {
  const { mixins, extends: extendsOptions } = from;
  if (extendsOptions) {
    mergeOptions(to, extendsOptions, strats, true);
  }
  if (mixins) {
    mixins.forEach((m2) => mergeOptions(to, m2, strats, true));
  }
  for (const key in from) {
    if (asMixin && key === "expose")
      ;
    else {
      const strat = internalOptionMergeStrats[key] || strats && strats[key];
      to[key] = strat ? strat(to[key], from[key]) : from[key];
    }
  }
  return to;
}
const internalOptionMergeStrats = {
  data: mergeDataFn,
  props: mergeObjectOptions,
  emits: mergeObjectOptions,
  methods: mergeObjectOptions,
  computed: mergeObjectOptions,
  beforeCreate: mergeAsArray,
  created: mergeAsArray,
  beforeMount: mergeAsArray,
  mounted: mergeAsArray,
  beforeUpdate: mergeAsArray,
  updated: mergeAsArray,
  beforeDestroy: mergeAsArray,
  beforeUnmount: mergeAsArray,
  destroyed: mergeAsArray,
  unmounted: mergeAsArray,
  activated: mergeAsArray,
  deactivated: mergeAsArray,
  errorCaptured: mergeAsArray,
  serverPrefetch: mergeAsArray,
  components: mergeObjectOptions,
  directives: mergeObjectOptions,
  watch: mergeWatchOptions,
  provide: mergeDataFn,
  inject: mergeInject
};
function mergeDataFn(to, from) {
  if (!from) {
    return to;
  }
  if (!to) {
    return from;
  }
  return function mergedDataFn() {
    return extend(isFunction$4(to) ? to.call(this, this) : to, isFunction$4(from) ? from.call(this, this) : from);
  };
}
function mergeInject(to, from) {
  return mergeObjectOptions(normalizeInject(to), normalizeInject(from));
}
function normalizeInject(raw) {
  if (isArray$2(raw)) {
    const res = {};
    for (let i2 = 0; i2 < raw.length; i2++) {
      res[raw[i2]] = raw[i2];
    }
    return res;
  }
  return raw;
}
function mergeAsArray(to, from) {
  return to ? [...new Set([].concat(to, from))] : from;
}
function mergeObjectOptions(to, from) {
  return to ? extend(extend(/* @__PURE__ */ Object.create(null), to), from) : from;
}
function mergeWatchOptions(to, from) {
  if (!to)
    return from;
  if (!from)
    return to;
  const merged = extend(/* @__PURE__ */ Object.create(null), to);
  for (const key in from) {
    merged[key] = mergeAsArray(to[key], from[key]);
  }
  return merged;
}
function initProps(instance, rawProps, isStateful, isSSR = false) {
  const props = {};
  const attrs = {};
  def(attrs, InternalObjectKey, 1);
  instance.propsDefaults = /* @__PURE__ */ Object.create(null);
  setFullProps(instance, rawProps, props, attrs);
  for (const key in instance.propsOptions[0]) {
    if (!(key in props)) {
      props[key] = void 0;
    }
  }
  if (isStateful) {
    instance.props = isSSR ? props : shallowReactive(props);
  } else {
    if (!instance.type.props) {
      instance.props = attrs;
    } else {
      instance.props = props;
    }
  }
  instance.attrs = attrs;
}
function updateProps(instance, rawProps, rawPrevProps, optimized) {
  const { props, attrs, vnode: { patchFlag } } = instance;
  const rawCurrentProps = toRaw(props);
  const [options2] = instance.propsOptions;
  let hasAttrsChanged = false;
  if ((optimized || patchFlag > 0) && !(patchFlag & 16)) {
    if (patchFlag & 8) {
      const propsToUpdate = instance.vnode.dynamicProps;
      for (let i2 = 0; i2 < propsToUpdate.length; i2++) {
        let key = propsToUpdate[i2];
        const value = rawProps[key];
        if (options2) {
          if (hasOwn$1(attrs, key)) {
            if (value !== attrs[key]) {
              attrs[key] = value;
              hasAttrsChanged = true;
            }
          } else {
            const camelizedKey = camelize(key);
            props[camelizedKey] = resolvePropValue(options2, rawCurrentProps, camelizedKey, value, instance, false);
          }
        } else {
          if (value !== attrs[key]) {
            attrs[key] = value;
            hasAttrsChanged = true;
          }
        }
      }
    }
  } else {
    if (setFullProps(instance, rawProps, props, attrs)) {
      hasAttrsChanged = true;
    }
    let kebabKey;
    for (const key in rawCurrentProps) {
      if (!rawProps || !hasOwn$1(rawProps, key) && ((kebabKey = hyphenate(key)) === key || !hasOwn$1(rawProps, kebabKey))) {
        if (options2) {
          if (rawPrevProps && (rawPrevProps[key] !== void 0 || rawPrevProps[kebabKey] !== void 0)) {
            props[key] = resolvePropValue(options2, rawCurrentProps, key, void 0, instance, true);
          }
        } else {
          delete props[key];
        }
      }
    }
    if (attrs !== rawCurrentProps) {
      for (const key in attrs) {
        if (!rawProps || !hasOwn$1(rawProps, key) && true) {
          delete attrs[key];
          hasAttrsChanged = true;
        }
      }
    }
  }
  if (hasAttrsChanged) {
    trigger$1(instance, "set", "$attrs");
  }
}
function setFullProps(instance, rawProps, props, attrs) {
  const [options2, needCastKeys] = instance.propsOptions;
  let hasAttrsChanged = false;
  let rawCastValues;
  if (rawProps) {
    for (let key in rawProps) {
      if (isReservedProp(key)) {
        continue;
      }
      const value = rawProps[key];
      let camelKey;
      if (options2 && hasOwn$1(options2, camelKey = camelize(key))) {
        if (!needCastKeys || !needCastKeys.includes(camelKey)) {
          props[camelKey] = value;
        } else {
          (rawCastValues || (rawCastValues = {}))[camelKey] = value;
        }
      } else if (!isEmitListener(instance.emitsOptions, key)) {
        if (!(key in attrs) || value !== attrs[key]) {
          attrs[key] = value;
          hasAttrsChanged = true;
        }
      }
    }
  }
  if (needCastKeys) {
    const rawCurrentProps = toRaw(props);
    const castValues = rawCastValues || EMPTY_OBJ;
    for (let i2 = 0; i2 < needCastKeys.length; i2++) {
      const key = needCastKeys[i2];
      props[key] = resolvePropValue(options2, rawCurrentProps, key, castValues[key], instance, !hasOwn$1(castValues, key));
    }
  }
  return hasAttrsChanged;
}
function resolvePropValue(options2, props, key, value, instance, isAbsent) {
  const opt = options2[key];
  if (opt != null) {
    const hasDefault = hasOwn$1(opt, "default");
    if (hasDefault && value === void 0) {
      const defaultValue = opt.default;
      if (opt.type !== Function && isFunction$4(defaultValue)) {
        const { propsDefaults } = instance;
        if (key in propsDefaults) {
          value = propsDefaults[key];
        } else {
          setCurrentInstance(instance);
          value = propsDefaults[key] = defaultValue.call(null, props);
          unsetCurrentInstance();
        }
      } else {
        value = defaultValue;
      }
    }
    if (opt[0]) {
      if (isAbsent && !hasDefault) {
        value = false;
      } else if (opt[1] && (value === "" || value === hyphenate(key))) {
        value = true;
      }
    }
  }
  return value;
}
function normalizePropsOptions(comp2, appContext, asMixin = false) {
  const cache2 = appContext.propsCache;
  const cached = cache2.get(comp2);
  if (cached) {
    return cached;
  }
  const raw = comp2.props;
  const normalized = {};
  const needCastKeys = [];
  let hasExtends = false;
  if (!isFunction$4(comp2)) {
    const extendProps = (raw2) => {
      hasExtends = true;
      const [props, keys] = normalizePropsOptions(raw2, appContext, true);
      extend(normalized, props);
      if (keys)
        needCastKeys.push(...keys);
    };
    if (!asMixin && appContext.mixins.length) {
      appContext.mixins.forEach(extendProps);
    }
    if (comp2.extends) {
      extendProps(comp2.extends);
    }
    if (comp2.mixins) {
      comp2.mixins.forEach(extendProps);
    }
  }
  if (!raw && !hasExtends) {
    cache2.set(comp2, EMPTY_ARR);
    return EMPTY_ARR;
  }
  if (isArray$2(raw)) {
    for (let i2 = 0; i2 < raw.length; i2++) {
      const normalizedKey = camelize(raw[i2]);
      if (validatePropName(normalizedKey)) {
        normalized[normalizedKey] = EMPTY_OBJ;
      }
    }
  } else if (raw) {
    for (const key in raw) {
      const normalizedKey = camelize(key);
      if (validatePropName(normalizedKey)) {
        const opt = raw[key];
        const prop2 = normalized[normalizedKey] = isArray$2(opt) || isFunction$4(opt) ? { type: opt } : opt;
        if (prop2) {
          const booleanIndex = getTypeIndex(Boolean, prop2.type);
          const stringIndex = getTypeIndex(String, prop2.type);
          prop2[0] = booleanIndex > -1;
          prop2[1] = stringIndex < 0 || booleanIndex < stringIndex;
          if (booleanIndex > -1 || hasOwn$1(prop2, "default")) {
            needCastKeys.push(normalizedKey);
          }
        }
      }
    }
  }
  const res = [normalized, needCastKeys];
  cache2.set(comp2, res);
  return res;
}
function validatePropName(key) {
  if (key[0] !== "$") {
    return true;
  }
  return false;
}
function getType(ctor) {
  const match3 = ctor && ctor.toString().match(/^\s*function (\w+)/);
  return match3 ? match3[1] : ctor === null ? "null" : "";
}
function isSameType(a2, b2) {
  return getType(a2) === getType(b2);
}
function getTypeIndex(type2, expectedTypes) {
  if (isArray$2(expectedTypes)) {
    return expectedTypes.findIndex((t2) => isSameType(t2, type2));
  } else if (isFunction$4(expectedTypes)) {
    return isSameType(expectedTypes, type2) ? 0 : -1;
  }
  return -1;
}
const isInternalKey = (key) => key[0] === "_" || key === "$stable";
const normalizeSlotValue = (value) => isArray$2(value) ? value.map(normalizeVNode) : [normalizeVNode(value)];
const normalizeSlot = (key, rawSlot, ctx) => {
  const normalized = withCtx((...args) => {
    return normalizeSlotValue(rawSlot(...args));
  }, ctx);
  normalized._c = false;
  return normalized;
};
const normalizeObjectSlots = (rawSlots, slots, instance) => {
  const ctx = rawSlots._ctx;
  for (const key in rawSlots) {
    if (isInternalKey(key))
      continue;
    const value = rawSlots[key];
    if (isFunction$4(value)) {
      slots[key] = normalizeSlot(key, value, ctx);
    } else if (value != null) {
      const normalized = normalizeSlotValue(value);
      slots[key] = () => normalized;
    }
  }
};
const normalizeVNodeSlots = (instance, children) => {
  const normalized = normalizeSlotValue(children);
  instance.slots.default = () => normalized;
};
const initSlots = (instance, children) => {
  if (instance.vnode.shapeFlag & 32) {
    const type2 = children._;
    if (type2) {
      instance.slots = toRaw(children);
      def(children, "_", type2);
    } else {
      normalizeObjectSlots(children, instance.slots = {});
    }
  } else {
    instance.slots = {};
    if (children) {
      normalizeVNodeSlots(instance, children);
    }
  }
  def(instance.slots, InternalObjectKey, 1);
};
const updateSlots = (instance, children, optimized) => {
  const { vnode, slots } = instance;
  let needDeletionCheck = true;
  let deletionComparisonTarget = EMPTY_OBJ;
  if (vnode.shapeFlag & 32) {
    const type2 = children._;
    if (type2) {
      if (optimized && type2 === 1) {
        needDeletionCheck = false;
      } else {
        extend(slots, children);
        if (!optimized && type2 === 1) {
          delete slots._;
        }
      }
    } else {
      needDeletionCheck = !children.$stable;
      normalizeObjectSlots(children, slots);
    }
    deletionComparisonTarget = children;
  } else if (children) {
    normalizeVNodeSlots(instance, children);
    deletionComparisonTarget = { default: 1 };
  }
  if (needDeletionCheck) {
    for (const key in slots) {
      if (!isInternalKey(key) && !(key in deletionComparisonTarget)) {
        delete slots[key];
      }
    }
  }
};
function withDirectives(vnode, directives) {
  const internalInstance = currentRenderingInstance;
  if (internalInstance === null) {
    return vnode;
  }
  const instance = internalInstance.proxy;
  const bindings = vnode.dirs || (vnode.dirs = []);
  for (let i2 = 0; i2 < directives.length; i2++) {
    let [dir, value, arg, modifiers = EMPTY_OBJ] = directives[i2];
    if (isFunction$4(dir)) {
      dir = {
        mounted: dir,
        updated: dir
      };
    }
    if (dir.deep) {
      traverse(value);
    }
    bindings.push({
      dir,
      instance,
      value,
      oldValue: void 0,
      arg,
      modifiers
    });
  }
  return vnode;
}
function invokeDirectiveHook(vnode, prevVNode, instance, name2) {
  const bindings = vnode.dirs;
  const oldBindings = prevVNode && prevVNode.dirs;
  for (let i2 = 0; i2 < bindings.length; i2++) {
    const binding = bindings[i2];
    if (oldBindings) {
      binding.oldValue = oldBindings[i2].value;
    }
    let hook = binding.dir[name2];
    if (hook) {
      pauseTracking();
      callWithAsyncErrorHandling(hook, instance, 8, [
        vnode.el,
        binding,
        vnode,
        prevVNode
      ]);
      resetTracking();
    }
  }
}
function createAppContext() {
  return {
    app: null,
    config: {
      isNativeTag: NO,
      performance: false,
      globalProperties: {},
      optionMergeStrategies: {},
      errorHandler: void 0,
      warnHandler: void 0,
      compilerOptions: {}
    },
    mixins: [],
    components: {},
    directives: {},
    provides: /* @__PURE__ */ Object.create(null),
    optionsCache: /* @__PURE__ */ new WeakMap(),
    propsCache: /* @__PURE__ */ new WeakMap(),
    emitsCache: /* @__PURE__ */ new WeakMap()
  };
}
let uid = 0;
function createAppAPI(render2, hydrate2) {
  return function createApp2(rootComponent, rootProps = null) {
    if (rootProps != null && !isObject$5(rootProps)) {
      rootProps = null;
    }
    const context = createAppContext();
    const installedPlugins = /* @__PURE__ */ new Set();
    let isMounted = false;
    const app2 = context.app = {
      _uid: uid++,
      _component: rootComponent,
      _props: rootProps,
      _container: null,
      _context: context,
      _instance: null,
      version: version$9,
      get config() {
        return context.config;
      },
      set config(v) {
      },
      use(plugin, ...options2) {
        if (installedPlugins.has(plugin))
          ;
        else if (plugin && isFunction$4(plugin.install)) {
          installedPlugins.add(plugin);
          plugin.install(app2, ...options2);
        } else if (isFunction$4(plugin)) {
          installedPlugins.add(plugin);
          plugin(app2, ...options2);
        } else
          ;
        return app2;
      },
      mixin(mixin) {
        {
          if (!context.mixins.includes(mixin)) {
            context.mixins.push(mixin);
          }
        }
        return app2;
      },
      component(name2, component) {
        if (!component) {
          return context.components[name2];
        }
        context.components[name2] = component;
        return app2;
      },
      directive(name2, directive) {
        if (!directive) {
          return context.directives[name2];
        }
        context.directives[name2] = directive;
        return app2;
      },
      mount(rootContainer, isHydrate, isSVG) {
        if (!isMounted) {
          const vnode = createVNode(rootComponent, rootProps);
          vnode.appContext = context;
          if (isHydrate && hydrate2) {
            hydrate2(vnode, rootContainer);
          } else {
            render2(vnode, rootContainer, isSVG);
          }
          isMounted = true;
          app2._container = rootContainer;
          rootContainer.__vue_app__ = app2;
          return getExposeProxy(vnode.component) || vnode.component.proxy;
        }
      },
      unmount() {
        if (isMounted) {
          render2(null, app2._container);
          delete app2._container.__vue_app__;
        }
      },
      provide(key, value) {
        context.provides[key] = value;
        return app2;
      }
    };
    return app2;
  };
}
function setRef(rawRef, oldRawRef, parentSuspense, vnode, isUnmount = false) {
  if (isArray$2(rawRef)) {
    rawRef.forEach((r2, i2) => setRef(r2, oldRawRef && (isArray$2(oldRawRef) ? oldRawRef[i2] : oldRawRef), parentSuspense, vnode, isUnmount));
    return;
  }
  if (isAsyncWrapper(vnode) && !isUnmount) {
    return;
  }
  const refValue = vnode.shapeFlag & 4 ? getExposeProxy(vnode.component) || vnode.component.proxy : vnode.el;
  const value = isUnmount ? null : refValue;
  const { i: owner, r: ref2 } = rawRef;
  const oldRef = oldRawRef && oldRawRef.r;
  const refs = owner.refs === EMPTY_OBJ ? owner.refs = {} : owner.refs;
  const setupState = owner.setupState;
  if (oldRef != null && oldRef !== ref2) {
    if (isString$5(oldRef)) {
      refs[oldRef] = null;
      if (hasOwn$1(setupState, oldRef)) {
        setupState[oldRef] = null;
      }
    } else if (isRef(oldRef)) {
      oldRef.value = null;
    }
  }
  if (isFunction$4(ref2)) {
    callWithErrorHandling(ref2, owner, 12, [value, refs]);
  } else {
    const _isString = isString$5(ref2);
    const _isRef = isRef(ref2);
    if (_isString || _isRef) {
      const doSet = () => {
        if (rawRef.f) {
          const existing = _isString ? refs[ref2] : ref2.value;
          if (isUnmount) {
            isArray$2(existing) && remove(existing, refValue);
          } else {
            if (!isArray$2(existing)) {
              if (_isString) {
                refs[ref2] = [refValue];
              } else {
                ref2.value = [refValue];
                if (rawRef.k)
                  refs[rawRef.k] = ref2.value;
              }
            } else if (!existing.includes(refValue)) {
              existing.push(refValue);
            }
          }
        } else if (_isString) {
          refs[ref2] = value;
          if (hasOwn$1(setupState, ref2)) {
            setupState[ref2] = value;
          }
        } else if (isRef(ref2)) {
          ref2.value = value;
          if (rawRef.k)
            refs[rawRef.k] = value;
        } else
          ;
      };
      if (value) {
        doSet.id = -1;
        queuePostRenderEffect(doSet, parentSuspense);
      } else {
        doSet();
      }
    }
  }
}
let hasMismatch = false;
const isSVGContainer = (container) => /svg/.test(container.namespaceURI) && container.tagName !== "foreignObject";
const isComment = (node) => node.nodeType === 8;
function createHydrationFunctions(rendererInternals) {
  const { mt: mountComponent, p: patch, o: { patchProp: patchProp2, nextSibling, parentNode, remove: remove2, insert: insert2, createComment } } = rendererInternals;
  const hydrate2 = (vnode, container) => {
    if (!container.hasChildNodes()) {
      patch(null, vnode, container);
      flushPostFlushCbs();
      return;
    }
    hasMismatch = false;
    hydrateNode(container.firstChild, vnode, null, null, null);
    flushPostFlushCbs();
    if (hasMismatch && true) {
      console.error(`Hydration completed but contains mismatches.`);
    }
  };
  const hydrateNode = (node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized = false) => {
    const isFragmentStart = isComment(node) && node.data === "[";
    const onMismatch = () => handleMismatch(node, vnode, parentComponent, parentSuspense, slotScopeIds, isFragmentStart);
    const { type: type2, ref: ref2, shapeFlag } = vnode;
    const domType = node.nodeType;
    vnode.el = node;
    let nextNode = null;
    switch (type2) {
      case Text:
        if (domType !== 3) {
          nextNode = onMismatch();
        } else {
          if (node.data !== vnode.children) {
            hasMismatch = true;
            node.data = vnode.children;
          }
          nextNode = nextSibling(node);
        }
        break;
      case Comment:
        if (domType !== 8 || isFragmentStart) {
          nextNode = onMismatch();
        } else {
          nextNode = nextSibling(node);
        }
        break;
      case Static:
        if (domType !== 1) {
          nextNode = onMismatch();
        } else {
          nextNode = node;
          const needToAdoptContent = !vnode.children.length;
          for (let i2 = 0; i2 < vnode.staticCount; i2++) {
            if (needToAdoptContent)
              vnode.children += nextNode.outerHTML;
            if (i2 === vnode.staticCount - 1) {
              vnode.anchor = nextNode;
            }
            nextNode = nextSibling(nextNode);
          }
          return nextNode;
        }
        break;
      case Fragment:
        if (!isFragmentStart) {
          nextNode = onMismatch();
        } else {
          nextNode = hydrateFragment(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized);
        }
        break;
      default:
        if (shapeFlag & 1) {
          if (domType !== 1 || vnode.type.toLowerCase() !== node.tagName.toLowerCase()) {
            nextNode = onMismatch();
          } else {
            nextNode = hydrateElement(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized);
          }
        } else if (shapeFlag & 6) {
          vnode.slotScopeIds = slotScopeIds;
          const container = parentNode(node);
          mountComponent(vnode, container, null, parentComponent, parentSuspense, isSVGContainer(container), optimized);
          nextNode = isFragmentStart ? locateClosingAsyncAnchor(node) : nextSibling(node);
          if (isAsyncWrapper(vnode)) {
            let subTree;
            if (isFragmentStart) {
              subTree = createVNode(Fragment);
              subTree.anchor = nextNode ? nextNode.previousSibling : container.lastChild;
            } else {
              subTree = node.nodeType === 3 ? createTextVNode("") : createVNode("div");
            }
            subTree.el = node;
            vnode.component.subTree = subTree;
          }
        } else if (shapeFlag & 64) {
          if (domType !== 8) {
            nextNode = onMismatch();
          } else {
            nextNode = vnode.type.hydrate(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, rendererInternals, hydrateChildren);
          }
        } else if (shapeFlag & 128) {
          nextNode = vnode.type.hydrate(node, vnode, parentComponent, parentSuspense, isSVGContainer(parentNode(node)), slotScopeIds, optimized, rendererInternals, hydrateNode);
        } else
          ;
    }
    if (ref2 != null) {
      setRef(ref2, null, parentSuspense, vnode);
    }
    return nextNode;
  };
  const hydrateElement = (el2, vnode, parentComponent, parentSuspense, slotScopeIds, optimized) => {
    optimized = optimized || !!vnode.dynamicChildren;
    const { type: type2, props, patchFlag, shapeFlag, dirs } = vnode;
    const forcePatchValue = type2 === "input" && dirs || type2 === "option";
    if (forcePatchValue || patchFlag !== -1) {
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "created");
      }
      if (props) {
        if (forcePatchValue || !optimized || patchFlag & (16 | 32)) {
          for (const key in props) {
            if (forcePatchValue && key.endsWith("value") || isOn(key) && !isReservedProp(key)) {
              patchProp2(el2, key, null, props[key], false, void 0, parentComponent);
            }
          }
        } else if (props.onClick) {
          patchProp2(el2, "onClick", null, props.onClick, false, void 0, parentComponent);
        }
      }
      let vnodeHooks;
      if (vnodeHooks = props && props.onVnodeBeforeMount) {
        invokeVNodeHook(vnodeHooks, parentComponent, vnode);
      }
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
      }
      if ((vnodeHooks = props && props.onVnodeMounted) || dirs) {
        queueEffectWithSuspense(() => {
          vnodeHooks && invokeVNodeHook(vnodeHooks, parentComponent, vnode);
          dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
        }, parentSuspense);
      }
      if (shapeFlag & 16 && !(props && (props.innerHTML || props.textContent))) {
        let next = hydrateChildren(el2.firstChild, vnode, el2, parentComponent, parentSuspense, slotScopeIds, optimized);
        while (next) {
          hasMismatch = true;
          const cur = next;
          next = next.nextSibling;
          remove2(cur);
        }
      } else if (shapeFlag & 8) {
        if (el2.textContent !== vnode.children) {
          hasMismatch = true;
          el2.textContent = vnode.children;
        }
      }
    }
    return el2.nextSibling;
  };
  const hydrateChildren = (node, parentVNode, container, parentComponent, parentSuspense, slotScopeIds, optimized) => {
    optimized = optimized || !!parentVNode.dynamicChildren;
    const children = parentVNode.children;
    const l2 = children.length;
    for (let i2 = 0; i2 < l2; i2++) {
      const vnode = optimized ? children[i2] : children[i2] = normalizeVNode(children[i2]);
      if (node) {
        node = hydrateNode(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized);
      } else if (vnode.type === Text && !vnode.children) {
        continue;
      } else {
        hasMismatch = true;
        patch(null, vnode, container, null, parentComponent, parentSuspense, isSVGContainer(container), slotScopeIds);
      }
    }
    return node;
  };
  const hydrateFragment = (node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized) => {
    const { slotScopeIds: fragmentSlotScopeIds } = vnode;
    if (fragmentSlotScopeIds) {
      slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
    }
    const container = parentNode(node);
    const next = hydrateChildren(nextSibling(node), vnode, container, parentComponent, parentSuspense, slotScopeIds, optimized);
    if (next && isComment(next) && next.data === "]") {
      return nextSibling(vnode.anchor = next);
    } else {
      hasMismatch = true;
      insert2(vnode.anchor = createComment(`]`), container, next);
      return next;
    }
  };
  const handleMismatch = (node, vnode, parentComponent, parentSuspense, slotScopeIds, isFragment) => {
    hasMismatch = true;
    vnode.el = null;
    if (isFragment) {
      const end = locateClosingAsyncAnchor(node);
      while (true) {
        const next2 = nextSibling(node);
        if (next2 && next2 !== end) {
          remove2(next2);
        } else {
          break;
        }
      }
    }
    const next = nextSibling(node);
    const container = parentNode(node);
    remove2(node);
    patch(null, vnode, container, next, parentComponent, parentSuspense, isSVGContainer(container), slotScopeIds);
    return next;
  };
  const locateClosingAsyncAnchor = (node) => {
    let match3 = 0;
    while (node) {
      node = nextSibling(node);
      if (node && isComment(node)) {
        if (node.data === "[")
          match3++;
        if (node.data === "]") {
          if (match3 === 0) {
            return nextSibling(node);
          } else {
            match3--;
          }
        }
      }
    }
    return node;
  };
  return [hydrate2, hydrateNode];
}
const queuePostRenderEffect = queueEffectWithSuspense;
function createRenderer(options2) {
  return baseCreateRenderer(options2);
}
function createHydrationRenderer(options2) {
  return baseCreateRenderer(options2, createHydrationFunctions);
}
function baseCreateRenderer(options2, createHydrationFns) {
  const target2 = getGlobalThis$2();
  target2.__VUE__ = true;
  const { insert: hostInsert, remove: hostRemove, patchProp: hostPatchProp, createElement: hostCreateElement, createText: hostCreateText, createComment: hostCreateComment, setText: hostSetText, setElementText: hostSetElementText, parentNode: hostParentNode, nextSibling: hostNextSibling, setScopeId: hostSetScopeId = NOOP, cloneNode: hostCloneNode, insertStaticContent: hostInsertStaticContent } = options2;
  const patch = (n1, n2, container, anchor = null, parentComponent = null, parentSuspense = null, isSVG = false, slotScopeIds = null, optimized = !!n2.dynamicChildren) => {
    if (n1 === n2) {
      return;
    }
    if (n1 && !isSameVNodeType(n1, n2)) {
      anchor = getNextHostNode(n1);
      unmount(n1, parentComponent, parentSuspense, true);
      n1 = null;
    }
    if (n2.patchFlag === -2) {
      optimized = false;
      n2.dynamicChildren = null;
    }
    const { type: type2, ref: ref2, shapeFlag } = n2;
    switch (type2) {
      case Text:
        processText(n1, n2, container, anchor);
        break;
      case Comment:
        processCommentNode(n1, n2, container, anchor);
        break;
      case Static:
        if (n1 == null) {
          mountStaticNode(n2, container, anchor, isSVG);
        }
        break;
      case Fragment:
        processFragment(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        break;
      default:
        if (shapeFlag & 1) {
          processElement(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (shapeFlag & 6) {
          processComponent(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (shapeFlag & 64) {
          type2.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);
        } else if (shapeFlag & 128) {
          type2.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);
        } else
          ;
    }
    if (ref2 != null && parentComponent) {
      setRef(ref2, n1 && n1.ref, parentSuspense, n2 || n1, !n2);
    }
  };
  const processText = (n1, n2, container, anchor) => {
    if (n1 == null) {
      hostInsert(n2.el = hostCreateText(n2.children), container, anchor);
    } else {
      const el2 = n2.el = n1.el;
      if (n2.children !== n1.children) {
        hostSetText(el2, n2.children);
      }
    }
  };
  const processCommentNode = (n1, n2, container, anchor) => {
    if (n1 == null) {
      hostInsert(n2.el = hostCreateComment(n2.children || ""), container, anchor);
    } else {
      n2.el = n1.el;
    }
  };
  const mountStaticNode = (n2, container, anchor, isSVG) => {
    [n2.el, n2.anchor] = hostInsertStaticContent(n2.children, container, anchor, isSVG, n2.el, n2.anchor);
  };
  const moveStaticNode = ({ el: el2, anchor }, container, nextSibling) => {
    let next;
    while (el2 && el2 !== anchor) {
      next = hostNextSibling(el2);
      hostInsert(el2, container, nextSibling);
      el2 = next;
    }
    hostInsert(anchor, container, nextSibling);
  };
  const removeStaticNode = ({ el: el2, anchor }) => {
    let next;
    while (el2 && el2 !== anchor) {
      next = hostNextSibling(el2);
      hostRemove(el2);
      el2 = next;
    }
    hostRemove(anchor);
  };
  const processElement = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    isSVG = isSVG || n2.type === "svg";
    if (n1 == null) {
      mountElement(n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    } else {
      patchElement(n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
  };
  const mountElement = (vnode, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    let el2;
    let vnodeHook;
    const { type: type2, props, shapeFlag, transition, patchFlag, dirs } = vnode;
    if (vnode.el && hostCloneNode !== void 0 && patchFlag === -1) {
      el2 = vnode.el = hostCloneNode(vnode.el);
    } else {
      el2 = vnode.el = hostCreateElement(vnode.type, isSVG, props && props.is, props);
      if (shapeFlag & 8) {
        hostSetElementText(el2, vnode.children);
      } else if (shapeFlag & 16) {
        mountChildren(vnode.children, el2, null, parentComponent, parentSuspense, isSVG && type2 !== "foreignObject", slotScopeIds, optimized);
      }
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "created");
      }
      if (props) {
        for (const key in props) {
          if (key !== "value" && !isReservedProp(key)) {
            hostPatchProp(el2, key, null, props[key], isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
          }
        }
        if ("value" in props) {
          hostPatchProp(el2, "value", null, props.value);
        }
        if (vnodeHook = props.onVnodeBeforeMount) {
          invokeVNodeHook(vnodeHook, parentComponent, vnode);
        }
      }
      setScopeId(el2, vnode, vnode.scopeId, slotScopeIds, parentComponent);
    }
    if (dirs) {
      invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
    }
    const needCallTransitionHooks = (!parentSuspense || parentSuspense && !parentSuspense.pendingBranch) && transition && !transition.persisted;
    if (needCallTransitionHooks) {
      transition.beforeEnter(el2);
    }
    hostInsert(el2, container, anchor);
    if ((vnodeHook = props && props.onVnodeMounted) || needCallTransitionHooks || dirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
        needCallTransitionHooks && transition.enter(el2);
        dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
      }, parentSuspense);
    }
  };
  const setScopeId = (el2, vnode, scopeId, slotScopeIds, parentComponent) => {
    if (scopeId) {
      hostSetScopeId(el2, scopeId);
    }
    if (slotScopeIds) {
      for (let i2 = 0; i2 < slotScopeIds.length; i2++) {
        hostSetScopeId(el2, slotScopeIds[i2]);
      }
    }
    if (parentComponent) {
      let subTree = parentComponent.subTree;
      if (vnode === subTree) {
        const parentVNode = parentComponent.vnode;
        setScopeId(el2, parentVNode, parentVNode.scopeId, parentVNode.slotScopeIds, parentComponent.parent);
      }
    }
  };
  const mountChildren = (children, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, start = 0) => {
    for (let i2 = start; i2 < children.length; i2++) {
      const child = children[i2] = optimized ? cloneIfMounted(children[i2]) : normalizeVNode(children[i2]);
      patch(null, child, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
  };
  const patchElement = (n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    const el2 = n2.el = n1.el;
    let { patchFlag, dynamicChildren, dirs } = n2;
    patchFlag |= n1.patchFlag & 16;
    const oldProps = n1.props || EMPTY_OBJ;
    const newProps = n2.props || EMPTY_OBJ;
    let vnodeHook;
    parentComponent && toggleRecurse(parentComponent, false);
    if (vnodeHook = newProps.onVnodeBeforeUpdate) {
      invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
    }
    if (dirs) {
      invokeDirectiveHook(n2, n1, parentComponent, "beforeUpdate");
    }
    parentComponent && toggleRecurse(parentComponent, true);
    const areChildrenSVG = isSVG && n2.type !== "foreignObject";
    if (dynamicChildren) {
      patchBlockChildren(n1.dynamicChildren, dynamicChildren, el2, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds);
    } else if (!optimized) {
      patchChildren(n1, n2, el2, null, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds, false);
    }
    if (patchFlag > 0) {
      if (patchFlag & 16) {
        patchProps(el2, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);
      } else {
        if (patchFlag & 2) {
          if (oldProps.class !== newProps.class) {
            hostPatchProp(el2, "class", null, newProps.class, isSVG);
          }
        }
        if (patchFlag & 4) {
          hostPatchProp(el2, "style", oldProps.style, newProps.style, isSVG);
        }
        if (patchFlag & 8) {
          const propsToUpdate = n2.dynamicProps;
          for (let i2 = 0; i2 < propsToUpdate.length; i2++) {
            const key = propsToUpdate[i2];
            const prev2 = oldProps[key];
            const next = newProps[key];
            if (next !== prev2 || key === "value") {
              hostPatchProp(el2, key, prev2, next, isSVG, n1.children, parentComponent, parentSuspense, unmountChildren);
            }
          }
        }
      }
      if (patchFlag & 1) {
        if (n1.children !== n2.children) {
          hostSetElementText(el2, n2.children);
        }
      }
    } else if (!optimized && dynamicChildren == null) {
      patchProps(el2, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);
    }
    if ((vnodeHook = newProps.onVnodeUpdated) || dirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
        dirs && invokeDirectiveHook(n2, n1, parentComponent, "updated");
      }, parentSuspense);
    }
  };
  const patchBlockChildren = (oldChildren, newChildren, fallbackContainer, parentComponent, parentSuspense, isSVG, slotScopeIds) => {
    for (let i2 = 0; i2 < newChildren.length; i2++) {
      const oldVNode = oldChildren[i2];
      const newVNode = newChildren[i2];
      const container = oldVNode.el && (oldVNode.type === Fragment || !isSameVNodeType(oldVNode, newVNode) || oldVNode.shapeFlag & (6 | 64)) ? hostParentNode(oldVNode.el) : fallbackContainer;
      patch(oldVNode, newVNode, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, true);
    }
  };
  const patchProps = (el2, vnode, oldProps, newProps, parentComponent, parentSuspense, isSVG) => {
    if (oldProps !== newProps) {
      for (const key in newProps) {
        if (isReservedProp(key))
          continue;
        const next = newProps[key];
        const prev2 = oldProps[key];
        if (next !== prev2 && key !== "value") {
          hostPatchProp(el2, key, prev2, next, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
        }
      }
      if (oldProps !== EMPTY_OBJ) {
        for (const key in oldProps) {
          if (!isReservedProp(key) && !(key in newProps)) {
            hostPatchProp(el2, key, oldProps[key], null, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
          }
        }
      }
      if ("value" in newProps) {
        hostPatchProp(el2, "value", oldProps.value, newProps.value);
      }
    }
  };
  const processFragment = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    const fragmentStartAnchor = n2.el = n1 ? n1.el : hostCreateText("");
    const fragmentEndAnchor = n2.anchor = n1 ? n1.anchor : hostCreateText("");
    let { patchFlag, dynamicChildren, slotScopeIds: fragmentSlotScopeIds } = n2;
    if (fragmentSlotScopeIds) {
      slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
    }
    if (n1 == null) {
      hostInsert(fragmentStartAnchor, container, anchor);
      hostInsert(fragmentEndAnchor, container, anchor);
      mountChildren(n2.children, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    } else {
      if (patchFlag > 0 && patchFlag & 64 && dynamicChildren && n1.dynamicChildren) {
        patchBlockChildren(n1.dynamicChildren, dynamicChildren, container, parentComponent, parentSuspense, isSVG, slotScopeIds);
        if (n2.key != null || parentComponent && n2 === parentComponent.subTree) {
          traverseStaticChildren(n1, n2, true);
        }
      } else {
        patchChildren(n1, n2, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      }
    }
  };
  const processComponent = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    n2.slotScopeIds = slotScopeIds;
    if (n1 == null) {
      if (n2.shapeFlag & 512) {
        parentComponent.ctx.activate(n2, container, anchor, isSVG, optimized);
      } else {
        mountComponent(n2, container, anchor, parentComponent, parentSuspense, isSVG, optimized);
      }
    } else {
      updateComponent(n1, n2, optimized);
    }
  };
  const mountComponent = (initialVNode, container, anchor, parentComponent, parentSuspense, isSVG, optimized) => {
    const instance = initialVNode.component = createComponentInstance(initialVNode, parentComponent, parentSuspense);
    if (isKeepAlive(initialVNode)) {
      instance.ctx.renderer = internals;
    }
    {
      setupComponent(instance);
    }
    if (instance.asyncDep) {
      parentSuspense && parentSuspense.registerDep(instance, setupRenderEffect);
      if (!initialVNode.el) {
        const placeholder = instance.subTree = createVNode(Comment);
        processCommentNode(null, placeholder, container, anchor);
      }
      return;
    }
    setupRenderEffect(instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized);
  };
  const updateComponent = (n1, n2, optimized) => {
    const instance = n2.component = n1.component;
    if (shouldUpdateComponent(n1, n2, optimized)) {
      if (instance.asyncDep && !instance.asyncResolved) {
        updateComponentPreRender(instance, n2, optimized);
        return;
      } else {
        instance.next = n2;
        invalidateJob(instance.update);
        instance.update();
      }
    } else {
      n2.component = n1.component;
      n2.el = n1.el;
      instance.vnode = n2;
    }
  };
  const setupRenderEffect = (instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized) => {
    const componentUpdateFn = () => {
      if (!instance.isMounted) {
        let vnodeHook;
        const { el: el2, props } = initialVNode;
        const { bm, m: m2, parent } = instance;
        const isAsyncWrapperVNode = isAsyncWrapper(initialVNode);
        toggleRecurse(instance, false);
        if (bm) {
          invokeArrayFns(bm);
        }
        if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeBeforeMount)) {
          invokeVNodeHook(vnodeHook, parent, initialVNode);
        }
        toggleRecurse(instance, true);
        if (el2 && hydrateNode) {
          const hydrateSubTree = () => {
            instance.subTree = renderComponentRoot(instance);
            hydrateNode(el2, instance.subTree, instance, parentSuspense, null);
          };
          if (isAsyncWrapperVNode) {
            initialVNode.type.__asyncLoader().then(
              () => !instance.isUnmounted && hydrateSubTree()
            );
          } else {
            hydrateSubTree();
          }
        } else {
          const subTree = instance.subTree = renderComponentRoot(instance);
          patch(null, subTree, container, anchor, instance, parentSuspense, isSVG);
          initialVNode.el = subTree.el;
        }
        if (m2) {
          queuePostRenderEffect(m2, parentSuspense);
        }
        if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeMounted)) {
          const scopedInitialVNode = initialVNode;
          queuePostRenderEffect(() => invokeVNodeHook(vnodeHook, parent, scopedInitialVNode), parentSuspense);
        }
        if (initialVNode.shapeFlag & 256) {
          instance.a && queuePostRenderEffect(instance.a, parentSuspense);
        }
        instance.isMounted = true;
        initialVNode = container = anchor = null;
      } else {
        let { next, bu, u: u2, parent, vnode } = instance;
        let originNext = next;
        let vnodeHook;
        toggleRecurse(instance, false);
        if (next) {
          next.el = vnode.el;
          updateComponentPreRender(instance, next, optimized);
        } else {
          next = vnode;
        }
        if (bu) {
          invokeArrayFns(bu);
        }
        if (vnodeHook = next.props && next.props.onVnodeBeforeUpdate) {
          invokeVNodeHook(vnodeHook, parent, next, vnode);
        }
        toggleRecurse(instance, true);
        const nextTree = renderComponentRoot(instance);
        const prevTree = instance.subTree;
        instance.subTree = nextTree;
        patch(
          prevTree,
          nextTree,
          hostParentNode(prevTree.el),
          getNextHostNode(prevTree),
          instance,
          parentSuspense,
          isSVG
        );
        next.el = nextTree.el;
        if (originNext === null) {
          updateHOCHostEl(instance, nextTree.el);
        }
        if (u2) {
          queuePostRenderEffect(u2, parentSuspense);
        }
        if (vnodeHook = next.props && next.props.onVnodeUpdated) {
          queuePostRenderEffect(() => invokeVNodeHook(vnodeHook, parent, next, vnode), parentSuspense);
        }
      }
    };
    const effect2 = instance.effect = new ReactiveEffect(
      componentUpdateFn,
      () => queueJob(instance.update),
      instance.scope
    );
    const update = instance.update = effect2.run.bind(effect2);
    update.id = instance.uid;
    toggleRecurse(instance, true);
    update();
  };
  const updateComponentPreRender = (instance, nextVNode, optimized) => {
    nextVNode.component = instance;
    const prevProps = instance.vnode.props;
    instance.vnode = nextVNode;
    instance.next = null;
    updateProps(instance, nextVNode.props, prevProps, optimized);
    updateSlots(instance, nextVNode.children, optimized);
    pauseTracking();
    flushPreFlushCbs(void 0, instance.update);
    resetTracking();
  };
  const patchChildren = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized = false) => {
    const c1 = n1 && n1.children;
    const prevShapeFlag = n1 ? n1.shapeFlag : 0;
    const c2 = n2.children;
    const { patchFlag, shapeFlag } = n2;
    if (patchFlag > 0) {
      if (patchFlag & 128) {
        patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        return;
      } else if (patchFlag & 256) {
        patchUnkeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        return;
      }
    }
    if (shapeFlag & 8) {
      if (prevShapeFlag & 16) {
        unmountChildren(c1, parentComponent, parentSuspense);
      }
      if (c2 !== c1) {
        hostSetElementText(container, c2);
      }
    } else {
      if (prevShapeFlag & 16) {
        if (shapeFlag & 16) {
          patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else {
          unmountChildren(c1, parentComponent, parentSuspense, true);
        }
      } else {
        if (prevShapeFlag & 8) {
          hostSetElementText(container, "");
        }
        if (shapeFlag & 16) {
          mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
      }
    }
  };
  const patchUnkeyedChildren = (c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    c1 = c1 || EMPTY_ARR;
    c2 = c2 || EMPTY_ARR;
    const oldLength = c1.length;
    const newLength = c2.length;
    const commonLength = Math.min(oldLength, newLength);
    let i2;
    for (i2 = 0; i2 < commonLength; i2++) {
      const nextChild = c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]);
      patch(c1[i2], nextChild, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
    if (oldLength > newLength) {
      unmountChildren(c1, parentComponent, parentSuspense, true, false, commonLength);
    } else {
      mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, commonLength);
    }
  };
  const patchKeyedChildren = (c1, c2, container, parentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    let i2 = 0;
    const l2 = c2.length;
    let e1 = c1.length - 1;
    let e2 = l2 - 1;
    while (i2 <= e1 && i2 <= e2) {
      const n1 = c1[i2];
      const n2 = c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]);
      if (isSameVNodeType(n1, n2)) {
        patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      } else {
        break;
      }
      i2++;
    }
    while (i2 <= e1 && i2 <= e2) {
      const n1 = c1[e1];
      const n2 = c2[e2] = optimized ? cloneIfMounted(c2[e2]) : normalizeVNode(c2[e2]);
      if (isSameVNodeType(n1, n2)) {
        patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      } else {
        break;
      }
      e1--;
      e2--;
    }
    if (i2 > e1) {
      if (i2 <= e2) {
        const nextPos = e2 + 1;
        const anchor = nextPos < l2 ? c2[nextPos].el : parentAnchor;
        while (i2 <= e2) {
          patch(null, c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]), container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
          i2++;
        }
      }
    } else if (i2 > e2) {
      while (i2 <= e1) {
        unmount(c1[i2], parentComponent, parentSuspense, true);
        i2++;
      }
    } else {
      const s1 = i2;
      const s2 = i2;
      const keyToNewIndexMap = /* @__PURE__ */ new Map();
      for (i2 = s2; i2 <= e2; i2++) {
        const nextChild = c2[i2] = optimized ? cloneIfMounted(c2[i2]) : normalizeVNode(c2[i2]);
        if (nextChild.key != null) {
          keyToNewIndexMap.set(nextChild.key, i2);
        }
      }
      let j;
      let patched = 0;
      const toBePatched = e2 - s2 + 1;
      let moved = false;
      let maxNewIndexSoFar = 0;
      const newIndexToOldIndexMap = new Array(toBePatched);
      for (i2 = 0; i2 < toBePatched; i2++)
        newIndexToOldIndexMap[i2] = 0;
      for (i2 = s1; i2 <= e1; i2++) {
        const prevChild = c1[i2];
        if (patched >= toBePatched) {
          unmount(prevChild, parentComponent, parentSuspense, true);
          continue;
        }
        let newIndex;
        if (prevChild.key != null) {
          newIndex = keyToNewIndexMap.get(prevChild.key);
        } else {
          for (j = s2; j <= e2; j++) {
            if (newIndexToOldIndexMap[j - s2] === 0 && isSameVNodeType(prevChild, c2[j])) {
              newIndex = j;
              break;
            }
          }
        }
        if (newIndex === void 0) {
          unmount(prevChild, parentComponent, parentSuspense, true);
        } else {
          newIndexToOldIndexMap[newIndex - s2] = i2 + 1;
          if (newIndex >= maxNewIndexSoFar) {
            maxNewIndexSoFar = newIndex;
          } else {
            moved = true;
          }
          patch(prevChild, c2[newIndex], container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
          patched++;
        }
      }
      const increasingNewIndexSequence = moved ? getSequence(newIndexToOldIndexMap) : EMPTY_ARR;
      j = increasingNewIndexSequence.length - 1;
      for (i2 = toBePatched - 1; i2 >= 0; i2--) {
        const nextIndex = s2 + i2;
        const nextChild = c2[nextIndex];
        const anchor = nextIndex + 1 < l2 ? c2[nextIndex + 1].el : parentAnchor;
        if (newIndexToOldIndexMap[i2] === 0) {
          patch(null, nextChild, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (moved) {
          if (j < 0 || i2 !== increasingNewIndexSequence[j]) {
            move(nextChild, container, anchor, 2);
          } else {
            j--;
          }
        }
      }
    }
  };
  const move = (vnode, container, anchor, moveType, parentSuspense = null) => {
    const { el: el2, type: type2, transition, children, shapeFlag } = vnode;
    if (shapeFlag & 6) {
      move(vnode.component.subTree, container, anchor, moveType);
      return;
    }
    if (shapeFlag & 128) {
      vnode.suspense.move(container, anchor, moveType);
      return;
    }
    if (shapeFlag & 64) {
      type2.move(vnode, container, anchor, internals);
      return;
    }
    if (type2 === Fragment) {
      hostInsert(el2, container, anchor);
      for (let i2 = 0; i2 < children.length; i2++) {
        move(children[i2], container, anchor, moveType);
      }
      hostInsert(vnode.anchor, container, anchor);
      return;
    }
    if (type2 === Static) {
      moveStaticNode(vnode, container, anchor);
      return;
    }
    const needTransition = moveType !== 2 && shapeFlag & 1 && transition;
    if (needTransition) {
      if (moveType === 0) {
        transition.beforeEnter(el2);
        hostInsert(el2, container, anchor);
        queuePostRenderEffect(() => transition.enter(el2), parentSuspense);
      } else {
        const { leave, delayLeave, afterLeave } = transition;
        const remove3 = () => hostInsert(el2, container, anchor);
        const performLeave = () => {
          leave(el2, () => {
            remove3();
            afterLeave && afterLeave();
          });
        };
        if (delayLeave) {
          delayLeave(el2, remove3, performLeave);
        } else {
          performLeave();
        }
      }
    } else {
      hostInsert(el2, container, anchor);
    }
  };
  const unmount = (vnode, parentComponent, parentSuspense, doRemove = false, optimized = false) => {
    const { type: type2, props, ref: ref2, children, dynamicChildren, shapeFlag, patchFlag, dirs } = vnode;
    if (ref2 != null) {
      setRef(ref2, null, parentSuspense, vnode, true);
    }
    if (shapeFlag & 256) {
      parentComponent.ctx.deactivate(vnode);
      return;
    }
    const shouldInvokeDirs = shapeFlag & 1 && dirs;
    const shouldInvokeVnodeHook = !isAsyncWrapper(vnode);
    let vnodeHook;
    if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeBeforeUnmount)) {
      invokeVNodeHook(vnodeHook, parentComponent, vnode);
    }
    if (shapeFlag & 6) {
      unmountComponent(vnode.component, parentSuspense, doRemove);
    } else {
      if (shapeFlag & 128) {
        vnode.suspense.unmount(parentSuspense, doRemove);
        return;
      }
      if (shouldInvokeDirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "beforeUnmount");
      }
      if (shapeFlag & 64) {
        vnode.type.remove(vnode, parentComponent, parentSuspense, optimized, internals, doRemove);
      } else if (dynamicChildren && (type2 !== Fragment || patchFlag > 0 && patchFlag & 64)) {
        unmountChildren(dynamicChildren, parentComponent, parentSuspense, false, true);
      } else if (type2 === Fragment && patchFlag & (128 | 256) || !optimized && shapeFlag & 16) {
        unmountChildren(children, parentComponent, parentSuspense);
      }
      if (doRemove) {
        remove2(vnode);
      }
    }
    if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeUnmounted) || shouldInvokeDirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
        shouldInvokeDirs && invokeDirectiveHook(vnode, null, parentComponent, "unmounted");
      }, parentSuspense);
    }
  };
  const remove2 = (vnode) => {
    const { type: type2, el: el2, anchor, transition } = vnode;
    if (type2 === Fragment) {
      removeFragment(el2, anchor);
      return;
    }
    if (type2 === Static) {
      removeStaticNode(vnode);
      return;
    }
    const performRemove = () => {
      hostRemove(el2);
      if (transition && !transition.persisted && transition.afterLeave) {
        transition.afterLeave();
      }
    };
    if (vnode.shapeFlag & 1 && transition && !transition.persisted) {
      const { leave, delayLeave } = transition;
      const performLeave = () => leave(el2, performRemove);
      if (delayLeave) {
        delayLeave(vnode.el, performRemove, performLeave);
      } else {
        performLeave();
      }
    } else {
      performRemove();
    }
  };
  const removeFragment = (cur, end) => {
    let next;
    while (cur !== end) {
      next = hostNextSibling(cur);
      hostRemove(cur);
      cur = next;
    }
    hostRemove(end);
  };
  const unmountComponent = (instance, parentSuspense, doRemove) => {
    const { bum, scope, update, subTree, um } = instance;
    if (bum) {
      invokeArrayFns(bum);
    }
    scope.stop();
    if (update) {
      update.active = false;
      unmount(subTree, instance, parentSuspense, doRemove);
    }
    if (um) {
      queuePostRenderEffect(um, parentSuspense);
    }
    queuePostRenderEffect(() => {
      instance.isUnmounted = true;
    }, parentSuspense);
    if (parentSuspense && parentSuspense.pendingBranch && !parentSuspense.isUnmounted && instance.asyncDep && !instance.asyncResolved && instance.suspenseId === parentSuspense.pendingId) {
      parentSuspense.deps--;
      if (parentSuspense.deps === 0) {
        parentSuspense.resolve();
      }
    }
  };
  const unmountChildren = (children, parentComponent, parentSuspense, doRemove = false, optimized = false, start = 0) => {
    for (let i2 = start; i2 < children.length; i2++) {
      unmount(children[i2], parentComponent, parentSuspense, doRemove, optimized);
    }
  };
  const getNextHostNode = (vnode) => {
    if (vnode.shapeFlag & 6) {
      return getNextHostNode(vnode.component.subTree);
    }
    if (vnode.shapeFlag & 128) {
      return vnode.suspense.next();
    }
    return hostNextSibling(vnode.anchor || vnode.el);
  };
  const render2 = (vnode, container, isSVG) => {
    if (vnode == null) {
      if (container._vnode) {
        unmount(container._vnode, null, null, true);
      }
    } else {
      patch(container._vnode || null, vnode, container, null, null, null, isSVG);
    }
    flushPostFlushCbs();
    container._vnode = vnode;
  };
  const internals = {
    p: patch,
    um: unmount,
    m: move,
    r: remove2,
    mt: mountComponent,
    mc: mountChildren,
    pc: patchChildren,
    pbc: patchBlockChildren,
    n: getNextHostNode,
    o: options2
  };
  let hydrate2;
  let hydrateNode;
  if (createHydrationFns) {
    [hydrate2, hydrateNode] = createHydrationFns(internals);
  }
  return {
    render: render2,
    hydrate: hydrate2,
    createApp: createAppAPI(render2, hydrate2)
  };
}
function toggleRecurse({ effect: effect2, update }, allowed) {
  effect2.allowRecurse = update.allowRecurse = allowed;
}
function traverseStaticChildren(n1, n2, shallow = false) {
  const ch1 = n1.children;
  const ch2 = n2.children;
  if (isArray$2(ch1) && isArray$2(ch2)) {
    for (let i2 = 0; i2 < ch1.length; i2++) {
      const c1 = ch1[i2];
      let c2 = ch2[i2];
      if (c2.shapeFlag & 1 && !c2.dynamicChildren) {
        if (c2.patchFlag <= 0 || c2.patchFlag === 32) {
          c2 = ch2[i2] = cloneIfMounted(ch2[i2]);
          c2.el = c1.el;
        }
        if (!shallow)
          traverseStaticChildren(c1, c2);
      }
    }
  }
}
function getSequence(arr) {
  const p2 = arr.slice();
  const result = [0];
  let i2, j, u2, v, c2;
  const len = arr.length;
  for (i2 = 0; i2 < len; i2++) {
    const arrI = arr[i2];
    if (arrI !== 0) {
      j = result[result.length - 1];
      if (arr[j] < arrI) {
        p2[i2] = j;
        result.push(i2);
        continue;
      }
      u2 = 0;
      v = result.length - 1;
      while (u2 < v) {
        c2 = u2 + v >> 1;
        if (arr[result[c2]] < arrI) {
          u2 = c2 + 1;
        } else {
          v = c2;
        }
      }
      if (arrI < arr[result[u2]]) {
        if (u2 > 0) {
          p2[i2] = result[u2 - 1];
        }
        result[u2] = i2;
      }
    }
  }
  u2 = result.length;
  v = result[u2 - 1];
  while (u2-- > 0) {
    result[u2] = v;
    v = p2[v];
  }
  return result;
}
const isTeleport = (type2) => type2.__isTeleport;
const isTeleportDisabled = (props) => props && (props.disabled || props.disabled === "");
const isTargetSVG = (target2) => typeof SVGElement !== "undefined" && target2 instanceof SVGElement;
const resolveTarget = (props, select) => {
  const targetSelector = props && props.to;
  if (isString$5(targetSelector)) {
    if (!select) {
      return null;
    } else {
      const target2 = select(targetSelector);
      return target2;
    }
  } else {
    return targetSelector;
  }
};
const TeleportImpl = {
  __isTeleport: true,
  process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals) {
    const { mc: mountChildren, pc: patchChildren, pbc: patchBlockChildren, o: { insert: insert2, querySelector, createText, createComment } } = internals;
    const disabled = isTeleportDisabled(n2.props);
    let { shapeFlag, children, dynamicChildren } = n2;
    if (n1 == null) {
      const placeholder = n2.el = createText("");
      const mainAnchor = n2.anchor = createText("");
      insert2(placeholder, container, anchor);
      insert2(mainAnchor, container, anchor);
      const target2 = n2.target = resolveTarget(n2.props, querySelector);
      const targetAnchor = n2.targetAnchor = createText("");
      if (target2) {
        insert2(targetAnchor, target2);
        isSVG = isSVG || isTargetSVG(target2);
      }
      const mount = (container2, anchor2) => {
        if (shapeFlag & 16) {
          mountChildren(children, container2, anchor2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
      };
      if (disabled) {
        mount(container, mainAnchor);
      } else if (target2) {
        mount(target2, targetAnchor);
      }
    } else {
      n2.el = n1.el;
      const mainAnchor = n2.anchor = n1.anchor;
      const target2 = n2.target = n1.target;
      const targetAnchor = n2.targetAnchor = n1.targetAnchor;
      const wasDisabled = isTeleportDisabled(n1.props);
      const currentContainer = wasDisabled ? container : target2;
      const currentAnchor = wasDisabled ? mainAnchor : targetAnchor;
      isSVG = isSVG || isTargetSVG(target2);
      if (dynamicChildren) {
        patchBlockChildren(n1.dynamicChildren, dynamicChildren, currentContainer, parentComponent, parentSuspense, isSVG, slotScopeIds);
        traverseStaticChildren(n1, n2, true);
      } else if (!optimized) {
        patchChildren(n1, n2, currentContainer, currentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, false);
      }
      if (disabled) {
        if (!wasDisabled) {
          moveTeleport(n2, container, mainAnchor, internals, 1);
        }
      } else {
        if ((n2.props && n2.props.to) !== (n1.props && n1.props.to)) {
          const nextTarget = n2.target = resolveTarget(n2.props, querySelector);
          if (nextTarget) {
            moveTeleport(n2, nextTarget, null, internals, 0);
          }
        } else if (wasDisabled) {
          moveTeleport(n2, target2, targetAnchor, internals, 1);
        }
      }
    }
  },
  remove(vnode, parentComponent, parentSuspense, optimized, { um: unmount, o: { remove: hostRemove } }, doRemove) {
    const { shapeFlag, children, anchor, targetAnchor, target: target2, props } = vnode;
    if (target2) {
      hostRemove(targetAnchor);
    }
    if (doRemove || !isTeleportDisabled(props)) {
      hostRemove(anchor);
      if (shapeFlag & 16) {
        for (let i2 = 0; i2 < children.length; i2++) {
          const child = children[i2];
          unmount(child, parentComponent, parentSuspense, true, !!child.dynamicChildren);
        }
      }
    }
  },
  move: moveTeleport,
  hydrate: hydrateTeleport
};
function moveTeleport(vnode, container, parentAnchor, { o: { insert: insert2 }, m: move }, moveType = 2) {
  if (moveType === 0) {
    insert2(vnode.targetAnchor, container, parentAnchor);
  }
  const { el: el2, anchor, shapeFlag, children, props } = vnode;
  const isReorder = moveType === 2;
  if (isReorder) {
    insert2(el2, container, parentAnchor);
  }
  if (!isReorder || isTeleportDisabled(props)) {
    if (shapeFlag & 16) {
      for (let i2 = 0; i2 < children.length; i2++) {
        move(children[i2], container, parentAnchor, 2);
      }
    }
  }
  if (isReorder) {
    insert2(anchor, container, parentAnchor);
  }
}
function hydrateTeleport(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, { o: { nextSibling, parentNode, querySelector } }, hydrateChildren) {
  const target2 = vnode.target = resolveTarget(vnode.props, querySelector);
  if (target2) {
    const targetNode = target2._lpa || target2.firstChild;
    if (vnode.shapeFlag & 16) {
      if (isTeleportDisabled(vnode.props)) {
        vnode.anchor = hydrateChildren(nextSibling(node), vnode, parentNode(node), parentComponent, parentSuspense, slotScopeIds, optimized);
        vnode.targetAnchor = targetNode;
      } else {
        vnode.anchor = nextSibling(node);
        vnode.targetAnchor = hydrateChildren(targetNode, vnode, target2, parentComponent, parentSuspense, slotScopeIds, optimized);
      }
      target2._lpa = vnode.targetAnchor && nextSibling(vnode.targetAnchor);
    }
  }
  return vnode.anchor && nextSibling(vnode.anchor);
}
const Teleport = TeleportImpl;
const COMPONENTS = "components";
const DIRECTIVES = "directives";
function resolveComponent(name2, maybeSelfReference) {
  return resolveAsset(COMPONENTS, name2, true, maybeSelfReference) || name2;
}
const NULL_DYNAMIC_COMPONENT = Symbol();
function resolveDynamicComponent(component) {
  if (isString$5(component)) {
    return resolveAsset(COMPONENTS, component, false) || component;
  } else {
    return component || NULL_DYNAMIC_COMPONENT;
  }
}
function resolveDirective(name2) {
  return resolveAsset(DIRECTIVES, name2);
}
function resolveAsset(type2, name2, warnMissing = true, maybeSelfReference = false) {
  const instance = currentRenderingInstance || currentInstance;
  if (instance) {
    const Component = instance.type;
    if (type2 === COMPONENTS) {
      const selfName = getComponentName(Component);
      if (selfName && (selfName === name2 || selfName === camelize(name2) || selfName === capitalize(camelize(name2)))) {
        return Component;
      }
    }
    const res = resolve(instance[type2] || Component[type2], name2) || resolve(instance.appContext[type2], name2);
    if (!res && maybeSelfReference) {
      return Component;
    }
    return res;
  }
}
function resolve(registry, name2) {
  return registry && (registry[name2] || registry[camelize(name2)] || registry[capitalize(camelize(name2))]);
}
const Fragment = Symbol(void 0);
const Text = Symbol(void 0);
const Comment = Symbol(void 0);
const Static = Symbol(void 0);
const blockStack = [];
let currentBlock = null;
function openBlock(disableTracking = false) {
  blockStack.push(currentBlock = disableTracking ? null : []);
}
function closeBlock() {
  blockStack.pop();
  currentBlock = blockStack[blockStack.length - 1] || null;
}
let isBlockTreeEnabled = 1;
function setBlockTracking(value) {
  isBlockTreeEnabled += value;
}
function setupBlock(vnode) {
  vnode.dynamicChildren = isBlockTreeEnabled > 0 ? currentBlock || EMPTY_ARR : null;
  closeBlock();
  if (isBlockTreeEnabled > 0 && currentBlock) {
    currentBlock.push(vnode);
  }
  return vnode;
}
function createElementBlock(type2, props, children, patchFlag, dynamicProps, shapeFlag) {
  return setupBlock(createBaseVNode(type2, props, children, patchFlag, dynamicProps, shapeFlag, true));
}
function createBlock(type2, props, children, patchFlag, dynamicProps) {
  return setupBlock(createVNode(type2, props, children, patchFlag, dynamicProps, true));
}
function isVNode(value) {
  return value ? value.__v_isVNode === true : false;
}
function isSameVNodeType(n1, n2) {
  return n1.type === n2.type && n1.key === n2.key;
}
function transformVNodeArgs(transformer) {
}
const InternalObjectKey = `__vInternal`;
const normalizeKey = ({ key }) => key != null ? key : null;
const normalizeRef = ({ ref: ref2, ref_key, ref_for }) => {
  return ref2 != null ? isString$5(ref2) || isRef(ref2) || isFunction$4(ref2) ? { i: currentRenderingInstance, r: ref2, k: ref_key, f: !!ref_for } : ref2 : null;
};
function createBaseVNode(type2, props = null, children = null, patchFlag = 0, dynamicProps = null, shapeFlag = type2 === Fragment ? 0 : 1, isBlockNode = false, needFullChildrenNormalization = false) {
  const vnode = {
    __v_isVNode: true,
    __v_skip: true,
    type: type2,
    props,
    key: props && normalizeKey(props),
    ref: props && normalizeRef(props),
    scopeId: currentScopeId,
    slotScopeIds: null,
    children,
    component: null,
    suspense: null,
    ssContent: null,
    ssFallback: null,
    dirs: null,
    transition: null,
    el: null,
    anchor: null,
    target: null,
    targetAnchor: null,
    staticCount: 0,
    shapeFlag,
    patchFlag,
    dynamicProps,
    dynamicChildren: null,
    appContext: null
  };
  if (needFullChildrenNormalization) {
    normalizeChildren(vnode, children);
    if (shapeFlag & 128) {
      type2.normalize(vnode);
    }
  } else if (children) {
    vnode.shapeFlag |= isString$5(children) ? 8 : 16;
  }
  if (isBlockTreeEnabled > 0 && !isBlockNode && currentBlock && (vnode.patchFlag > 0 || shapeFlag & 6) && vnode.patchFlag !== 32) {
    currentBlock.push(vnode);
  }
  return vnode;
}
const createVNode = _createVNode;
function _createVNode(type2, props = null, children = null, patchFlag = 0, dynamicProps = null, isBlockNode = false) {
  if (!type2 || type2 === NULL_DYNAMIC_COMPONENT) {
    type2 = Comment;
  }
  if (isVNode(type2)) {
    const cloned = cloneVNode(type2, props, true);
    if (children) {
      normalizeChildren(cloned, children);
    }
    return cloned;
  }
  if (isClassComponent(type2)) {
    type2 = type2.__vccOpts;
  }
  if (props) {
    props = guardReactiveProps(props);
    let { class: klass, style } = props;
    if (klass && !isString$5(klass)) {
      props.class = normalizeClass(klass);
    }
    if (isObject$5(style)) {
      if (isProxy(style) && !isArray$2(style)) {
        style = extend({}, style);
      }
      props.style = normalizeStyle(style);
    }
  }
  const shapeFlag = isString$5(type2) ? 1 : isSuspense(type2) ? 128 : isTeleport(type2) ? 64 : isObject$5(type2) ? 4 : isFunction$4(type2) ? 2 : 0;
  return createBaseVNode(type2, props, children, patchFlag, dynamicProps, shapeFlag, isBlockNode, true);
}
function guardReactiveProps(props) {
  if (!props)
    return null;
  return isProxy(props) || InternalObjectKey in props ? extend({}, props) : props;
}
function cloneVNode(vnode, extraProps, mergeRef = false) {
  const { props, ref: ref2, patchFlag, children } = vnode;
  const mergedProps = extraProps ? mergeProps(props || {}, extraProps) : props;
  const cloned = {
    __v_isVNode: true,
    __v_skip: true,
    type: vnode.type,
    props: mergedProps,
    key: mergedProps && normalizeKey(mergedProps),
    ref: extraProps && extraProps.ref ? mergeRef && ref2 ? isArray$2(ref2) ? ref2.concat(normalizeRef(extraProps)) : [ref2, normalizeRef(extraProps)] : normalizeRef(extraProps) : ref2,
    scopeId: vnode.scopeId,
    slotScopeIds: vnode.slotScopeIds,
    children,
    target: vnode.target,
    targetAnchor: vnode.targetAnchor,
    staticCount: vnode.staticCount,
    shapeFlag: vnode.shapeFlag,
    patchFlag: extraProps && vnode.type !== Fragment ? patchFlag === -1 ? 16 : patchFlag | 16 : patchFlag,
    dynamicProps: vnode.dynamicProps,
    dynamicChildren: vnode.dynamicChildren,
    appContext: vnode.appContext,
    dirs: vnode.dirs,
    transition: vnode.transition,
    component: vnode.component,
    suspense: vnode.suspense,
    ssContent: vnode.ssContent && cloneVNode(vnode.ssContent),
    ssFallback: vnode.ssFallback && cloneVNode(vnode.ssFallback),
    el: vnode.el,
    anchor: vnode.anchor
  };
  return cloned;
}
function createTextVNode(text3 = " ", flag = 0) {
  return createVNode(Text, null, text3, flag);
}
function createStaticVNode(content, numberOfNodes) {
  const vnode = createVNode(Static, null, content);
  vnode.staticCount = numberOfNodes;
  return vnode;
}
function createCommentVNode(text3 = "", asBlock = false) {
  return asBlock ? (openBlock(), createBlock(Comment, null, text3)) : createVNode(Comment, null, text3);
}
function normalizeVNode(child) {
  if (child == null || typeof child === "boolean") {
    return createVNode(Comment);
  } else if (isArray$2(child)) {
    return createVNode(
      Fragment,
      null,
      child.slice()
    );
  } else if (typeof child === "object") {
    return cloneIfMounted(child);
  } else {
    return createVNode(Text, null, String(child));
  }
}
function cloneIfMounted(child) {
  return child.el === null || child.memo ? child : cloneVNode(child);
}
function normalizeChildren(vnode, children) {
  let type2 = 0;
  const { shapeFlag } = vnode;
  if (children == null) {
    children = null;
  } else if (isArray$2(children)) {
    type2 = 16;
  } else if (typeof children === "object") {
    if (shapeFlag & (1 | 64)) {
      const slot = children.default;
      if (slot) {
        slot._c && (slot._d = false);
        normalizeChildren(vnode, slot());
        slot._c && (slot._d = true);
      }
      return;
    } else {
      type2 = 32;
      const slotFlag = children._;
      if (!slotFlag && !(InternalObjectKey in children)) {
        children._ctx = currentRenderingInstance;
      } else if (slotFlag === 3 && currentRenderingInstance) {
        if (currentRenderingInstance.slots._ === 1) {
          children._ = 1;
        } else {
          children._ = 2;
          vnode.patchFlag |= 1024;
        }
      }
    }
  } else if (isFunction$4(children)) {
    children = { default: children, _ctx: currentRenderingInstance };
    type2 = 32;
  } else {
    children = String(children);
    if (shapeFlag & 64) {
      type2 = 16;
      children = [createTextVNode(children)];
    } else {
      type2 = 8;
    }
  }
  vnode.children = children;
  vnode.shapeFlag |= type2;
}
function mergeProps(...args) {
  const ret = {};
  for (let i2 = 0; i2 < args.length; i2++) {
    const toMerge = args[i2];
    for (const key in toMerge) {
      if (key === "class") {
        if (ret.class !== toMerge.class) {
          ret.class = normalizeClass([ret.class, toMerge.class]);
        }
      } else if (key === "style") {
        ret.style = normalizeStyle([ret.style, toMerge.style]);
      } else if (isOn(key)) {
        const existing = ret[key];
        const incoming = toMerge[key];
        if (incoming && existing !== incoming && !(isArray$2(existing) && existing.includes(incoming))) {
          ret[key] = existing ? [].concat(existing, incoming) : incoming;
        }
      } else if (key !== "") {
        ret[key] = toMerge[key];
      }
    }
  }
  return ret;
}
function invokeVNodeHook(hook, instance, vnode, prevVNode = null) {
  callWithAsyncErrorHandling(hook, instance, 7, [
    vnode,
    prevVNode
  ]);
}
function renderList(source, renderItem, cache2, index2) {
  let ret;
  const cached = cache2 && cache2[index2];
  if (isArray$2(source) || isString$5(source)) {
    ret = new Array(source.length);
    for (let i2 = 0, l2 = source.length; i2 < l2; i2++) {
      ret[i2] = renderItem(source[i2], i2, void 0, cached && cached[i2]);
    }
  } else if (typeof source === "number") {
    ret = new Array(source);
    for (let i2 = 0; i2 < source; i2++) {
      ret[i2] = renderItem(i2 + 1, i2, void 0, cached && cached[i2]);
    }
  } else if (isObject$5(source)) {
    if (source[Symbol.iterator]) {
      ret = Array.from(source, (item, i2) => renderItem(item, i2, void 0, cached && cached[i2]));
    } else {
      const keys = Object.keys(source);
      ret = new Array(keys.length);
      for (let i2 = 0, l2 = keys.length; i2 < l2; i2++) {
        const key = keys[i2];
        ret[i2] = renderItem(source[key], key, i2, cached && cached[i2]);
      }
    }
  } else {
    ret = [];
  }
  if (cache2) {
    cache2[index2] = ret;
  }
  return ret;
}
function createSlots(slots, dynamicSlots) {
  for (let i2 = 0; i2 < dynamicSlots.length; i2++) {
    const slot = dynamicSlots[i2];
    if (isArray$2(slot)) {
      for (let j = 0; j < slot.length; j++) {
        slots[slot[j].name] = slot[j].fn;
      }
    } else if (slot) {
      slots[slot.name] = slot.fn;
    }
  }
  return slots;
}
function renderSlot(slots, name2, props = {}, fallback, noSlotted) {
  if (currentRenderingInstance.isCE) {
    return createVNode("slot", name2 === "default" ? null : { name: name2 }, fallback && fallback());
  }
  let slot = slots[name2];
  if (slot && slot._c) {
    slot._d = false;
  }
  openBlock();
  const validSlotContent = slot && ensureValidVNode(slot(props));
  const rendered = createBlock(Fragment, { key: props.key || `_${name2}` }, validSlotContent || (fallback ? fallback() : []), validSlotContent && slots._ === 1 ? 64 : -2);
  if (!noSlotted && rendered.scopeId) {
    rendered.slotScopeIds = [rendered.scopeId + "-s"];
  }
  if (slot && slot._c) {
    slot._d = true;
  }
  return rendered;
}
function ensureValidVNode(vnodes) {
  return vnodes.some((child) => {
    if (!isVNode(child))
      return true;
    if (child.type === Comment)
      return false;
    if (child.type === Fragment && !ensureValidVNode(child.children))
      return false;
    return true;
  }) ? vnodes : null;
}
function toHandlers(obj) {
  const ret = {};
  for (const key in obj) {
    ret[toHandlerKey(key)] = obj[key];
  }
  return ret;
}
const getPublicInstance = (i2) => {
  if (!i2)
    return null;
  if (isStatefulComponent(i2))
    return getExposeProxy(i2) || i2.proxy;
  return getPublicInstance(i2.parent);
};
const publicPropertiesMap = extend(/* @__PURE__ */ Object.create(null), {
  $: (i2) => i2,
  $el: (i2) => i2.vnode.el,
  $data: (i2) => i2.data,
  $props: (i2) => i2.props,
  $attrs: (i2) => i2.attrs,
  $slots: (i2) => i2.slots,
  $refs: (i2) => i2.refs,
  $parent: (i2) => getPublicInstance(i2.parent),
  $root: (i2) => getPublicInstance(i2.root),
  $emit: (i2) => i2.emit,
  $options: (i2) => resolveMergedOptions(i2),
  $forceUpdate: (i2) => () => queueJob(i2.update),
  $nextTick: (i2) => nextTick.bind(i2.proxy),
  $watch: (i2) => instanceWatch.bind(i2)
});
const PublicInstanceProxyHandlers = {
  get({ _: instance }, key) {
    const { ctx, setupState, data, props, accessCache, type: type2, appContext } = instance;
    let normalizedProps;
    if (key[0] !== "$") {
      const n = accessCache[key];
      if (n !== void 0) {
        switch (n) {
          case 1:
            return setupState[key];
          case 2:
            return data[key];
          case 4:
            return ctx[key];
          case 3:
            return props[key];
        }
      } else if (setupState !== EMPTY_OBJ && hasOwn$1(setupState, key)) {
        accessCache[key] = 1;
        return setupState[key];
      } else if (data !== EMPTY_OBJ && hasOwn$1(data, key)) {
        accessCache[key] = 2;
        return data[key];
      } else if ((normalizedProps = instance.propsOptions[0]) && hasOwn$1(normalizedProps, key)) {
        accessCache[key] = 3;
        return props[key];
      } else if (ctx !== EMPTY_OBJ && hasOwn$1(ctx, key)) {
        accessCache[key] = 4;
        return ctx[key];
      } else if (shouldCacheAccess) {
        accessCache[key] = 0;
      }
    }
    const publicGetter = publicPropertiesMap[key];
    let cssModule, globalProperties;
    if (publicGetter) {
      if (key === "$attrs") {
        track(instance, "get", key);
      }
      return publicGetter(instance);
    } else if ((cssModule = type2.__cssModules) && (cssModule = cssModule[key])) {
      return cssModule;
    } else if (ctx !== EMPTY_OBJ && hasOwn$1(ctx, key)) {
      accessCache[key] = 4;
      return ctx[key];
    } else if (globalProperties = appContext.config.globalProperties, hasOwn$1(globalProperties, key)) {
      {
        return globalProperties[key];
      }
    } else
      ;
  },
  set({ _: instance }, key, value) {
    const { data, setupState, ctx } = instance;
    if (setupState !== EMPTY_OBJ && hasOwn$1(setupState, key)) {
      setupState[key] = value;
      return true;
    } else if (data !== EMPTY_OBJ && hasOwn$1(data, key)) {
      data[key] = value;
      return true;
    } else if (hasOwn$1(instance.props, key)) {
      return false;
    }
    if (key[0] === "$" && key.slice(1) in instance) {
      return false;
    } else {
      {
        ctx[key] = value;
      }
    }
    return true;
  },
  has({ _: { data, setupState, accessCache, ctx, appContext, propsOptions } }, key) {
    let normalizedProps;
    return !!accessCache[key] || data !== EMPTY_OBJ && hasOwn$1(data, key) || setupState !== EMPTY_OBJ && hasOwn$1(setupState, key) || (normalizedProps = propsOptions[0]) && hasOwn$1(normalizedProps, key) || hasOwn$1(ctx, key) || hasOwn$1(publicPropertiesMap, key) || hasOwn$1(appContext.config.globalProperties, key);
  },
  defineProperty(target2, key, descriptor) {
    if (descriptor.get != null) {
      this.set(target2, key, descriptor.get(), null);
    } else if (descriptor.value != null) {
      this.set(target2, key, descriptor.value, null);
    }
    return Reflect.defineProperty(target2, key, descriptor);
  }
};
const RuntimeCompiledPublicInstanceProxyHandlers = /* @__PURE__ */ extend({}, PublicInstanceProxyHandlers, {
  get(target2, key) {
    if (key === Symbol.unscopables) {
      return;
    }
    return PublicInstanceProxyHandlers.get(target2, key, target2);
  },
  has(_2, key) {
    const has2 = key[0] !== "_" && !isGloballyWhitelisted(key);
    return has2;
  }
});
const emptyAppContext = createAppContext();
let uid$1 = 0;
function createComponentInstance(vnode, parent, suspense) {
  const type2 = vnode.type;
  const appContext = (parent ? parent.appContext : vnode.appContext) || emptyAppContext;
  const instance = {
    uid: uid$1++,
    vnode,
    type: type2,
    parent,
    appContext,
    root: null,
    next: null,
    subTree: null,
    effect: null,
    update: null,
    scope: new EffectScope(true),
    render: null,
    proxy: null,
    exposed: null,
    exposeProxy: null,
    withProxy: null,
    provides: parent ? parent.provides : Object.create(appContext.provides),
    accessCache: null,
    renderCache: [],
    components: null,
    directives: null,
    propsOptions: normalizePropsOptions(type2, appContext),
    emitsOptions: normalizeEmitsOptions(type2, appContext),
    emit: null,
    emitted: null,
    propsDefaults: EMPTY_OBJ,
    inheritAttrs: type2.inheritAttrs,
    ctx: EMPTY_OBJ,
    data: EMPTY_OBJ,
    props: EMPTY_OBJ,
    attrs: EMPTY_OBJ,
    slots: EMPTY_OBJ,
    refs: EMPTY_OBJ,
    setupState: EMPTY_OBJ,
    setupContext: null,
    suspense,
    suspenseId: suspense ? suspense.pendingId : 0,
    asyncDep: null,
    asyncResolved: false,
    isMounted: false,
    isUnmounted: false,
    isDeactivated: false,
    bc: null,
    c: null,
    bm: null,
    m: null,
    bu: null,
    u: null,
    um: null,
    bum: null,
    da: null,
    a: null,
    rtg: null,
    rtc: null,
    ec: null,
    sp: null
  };
  {
    instance.ctx = { _: instance };
  }
  instance.root = parent ? parent.root : instance;
  instance.emit = emit$1.bind(null, instance);
  if (vnode.ce) {
    vnode.ce(instance);
  }
  return instance;
}
let currentInstance = null;
const getCurrentInstance = () => currentInstance || currentRenderingInstance;
const setCurrentInstance = (instance) => {
  currentInstance = instance;
  instance.scope.on();
};
const unsetCurrentInstance = () => {
  currentInstance && currentInstance.scope.off();
  currentInstance = null;
};
function isStatefulComponent(instance) {
  return instance.vnode.shapeFlag & 4;
}
let isInSSRComponentSetup = false;
function setupComponent(instance, isSSR = false) {
  isInSSRComponentSetup = isSSR;
  const { props, children } = instance.vnode;
  const isStateful = isStatefulComponent(instance);
  initProps(instance, props, isStateful, isSSR);
  initSlots(instance, children);
  const setupResult = isStateful ? setupStatefulComponent(instance, isSSR) : void 0;
  isInSSRComponentSetup = false;
  return setupResult;
}
function setupStatefulComponent(instance, isSSR) {
  const Component = instance.type;
  instance.accessCache = /* @__PURE__ */ Object.create(null);
  instance.proxy = markRaw(new Proxy(instance.ctx, PublicInstanceProxyHandlers));
  const { setup: setup24 } = Component;
  if (setup24) {
    const setupContext = instance.setupContext = setup24.length > 1 ? createSetupContext(instance) : null;
    setCurrentInstance(instance);
    pauseTracking();
    const setupResult = callWithErrorHandling(setup24, instance, 0, [instance.props, setupContext]);
    resetTracking();
    unsetCurrentInstance();
    if (isPromise(setupResult)) {
      setupResult.then(unsetCurrentInstance, unsetCurrentInstance);
      if (isSSR) {
        return setupResult.then((resolvedResult) => {
          handleSetupResult(instance, resolvedResult, isSSR);
        }).catch((e) => {
          handleError(e, instance, 0);
        });
      } else {
        instance.asyncDep = setupResult;
      }
    } else {
      handleSetupResult(instance, setupResult, isSSR);
    }
  } else {
    finishComponentSetup(instance, isSSR);
  }
}
function handleSetupResult(instance, setupResult, isSSR) {
  if (isFunction$4(setupResult)) {
    if (instance.type.__ssrInlineRender) {
      instance.ssrRender = setupResult;
    } else {
      instance.render = setupResult;
    }
  } else if (isObject$5(setupResult)) {
    instance.setupState = proxyRefs(setupResult);
  } else
    ;
  finishComponentSetup(instance, isSSR);
}
let compile$2;
let installWithProxy;
function registerRuntimeCompiler(_compile) {
  compile$2 = _compile;
  installWithProxy = (i2) => {
    if (i2.render._rc) {
      i2.withProxy = new Proxy(i2.ctx, RuntimeCompiledPublicInstanceProxyHandlers);
    }
  };
}
const isRuntimeOnly = () => !compile$2;
function finishComponentSetup(instance, isSSR, skipOptions) {
  const Component = instance.type;
  if (!instance.render) {
    if (!isSSR && compile$2 && !Component.render) {
      const template = Component.template;
      if (template) {
        const { isCustomElement, compilerOptions } = instance.appContext.config;
        const { delimiters, compilerOptions: componentCompilerOptions } = Component;
        const finalCompilerOptions = extend(extend({
          isCustomElement,
          delimiters
        }, compilerOptions), componentCompilerOptions);
        Component.render = compile$2(template, finalCompilerOptions);
      }
    }
    instance.render = Component.render || NOOP;
    if (installWithProxy) {
      installWithProxy(instance);
    }
  }
  {
    setCurrentInstance(instance);
    pauseTracking();
    applyOptions(instance);
    resetTracking();
    unsetCurrentInstance();
  }
}
function createAttrsProxy(instance) {
  return new Proxy(instance.attrs, {
    get(target2, key) {
      track(instance, "get", "$attrs");
      return target2[key];
    }
  });
}
function createSetupContext(instance) {
  const expose = (exposed) => {
    instance.exposed = exposed || {};
  };
  let attrs;
  {
    return {
      get attrs() {
        return attrs || (attrs = createAttrsProxy(instance));
      },
      slots: instance.slots,
      emit: instance.emit,
      expose
    };
  }
}
function getExposeProxy(instance) {
  if (instance.exposed) {
    return instance.exposeProxy || (instance.exposeProxy = new Proxy(proxyRefs(markRaw(instance.exposed)), {
      get(target2, key) {
        if (key in target2) {
          return target2[key];
        } else if (key in publicPropertiesMap) {
          return publicPropertiesMap[key](instance);
        }
      }
    }));
  }
}
const classifyRE = /(?:^|[-_])(\w)/g;
const classify = (str) => str.replace(classifyRE, (c2) => c2.toUpperCase()).replace(/[-_]/g, "");
function getComponentName(Component) {
  return isFunction$4(Component) ? Component.displayName || Component.name : Component.name;
}
function formatComponentName(instance, Component, isRoot = false) {
  let name2 = getComponentName(Component);
  if (!name2 && Component.__file) {
    const match3 = Component.__file.match(/([^/\\]+)\.\w+$/);
    if (match3) {
      name2 = match3[1];
    }
  }
  if (!name2 && instance && instance.parent) {
    const inferFromRegistry = (registry) => {
      for (const key in registry) {
        if (registry[key] === Component) {
          return key;
        }
      }
    };
    name2 = inferFromRegistry(instance.components || instance.parent.type.components) || inferFromRegistry(instance.appContext.components);
  }
  return name2 ? classify(name2) : isRoot ? `App` : `Anonymous`;
}
function isClassComponent(value) {
  return isFunction$4(value) && "__vccOpts" in value;
}
const computed = (getterOrOptions, debugOptions) => {
  return computed$1(getterOrOptions, debugOptions, isInSSRComponentSetup);
};
function defineProps() {
  return null;
}
function defineEmits() {
  return null;
}
function defineExpose(exposed) {
}
function withDefaults(props, defaults) {
  return null;
}
function useSlots() {
  return getContext().slots;
}
function useAttrs() {
  return getContext().attrs;
}
function getContext() {
  const i2 = getCurrentInstance();
  return i2.setupContext || (i2.setupContext = createSetupContext(i2));
}
function mergeDefaults(raw, defaults) {
  const props = isArray$2(raw) ? raw.reduce((normalized, p2) => (normalized[p2] = {}, normalized), {}) : raw;
  for (const key in defaults) {
    const opt = props[key];
    if (opt) {
      if (isArray$2(opt) || isFunction$4(opt)) {
        props[key] = { type: opt, default: defaults[key] };
      } else {
        opt.default = defaults[key];
      }
    } else if (opt === null) {
      props[key] = { default: defaults[key] };
    } else
      ;
  }
  return props;
}
function createPropsRestProxy(props, excludedKeys) {
  const ret = {};
  for (const key in props) {
    if (!excludedKeys.includes(key)) {
      Object.defineProperty(ret, key, {
        enumerable: true,
        get: () => props[key]
      });
    }
  }
  return ret;
}
function withAsyncContext(getAwaitable) {
  const ctx = getCurrentInstance();
  let awaitable = getAwaitable();
  unsetCurrentInstance();
  if (isPromise(awaitable)) {
    awaitable = awaitable.catch((e) => {
      setCurrentInstance(ctx);
      throw e;
    });
  }
  return [awaitable, () => setCurrentInstance(ctx)];
}
function h$1(type2, propsOrChildren, children) {
  const l2 = arguments.length;
  if (l2 === 2) {
    if (isObject$5(propsOrChildren) && !isArray$2(propsOrChildren)) {
      if (isVNode(propsOrChildren)) {
        return createVNode(type2, null, [propsOrChildren]);
      }
      return createVNode(type2, propsOrChildren);
    } else {
      return createVNode(type2, null, propsOrChildren);
    }
  } else {
    if (l2 > 3) {
      children = Array.prototype.slice.call(arguments, 2);
    } else if (l2 === 3 && isVNode(children)) {
      children = [children];
    }
    return createVNode(type2, propsOrChildren, children);
  }
}
const ssrContextKey = Symbol(``);
const useSSRContext = () => {
  {
    const ctx = inject(ssrContextKey);
    if (!ctx) {
      warn$1(`Server rendering context not provided. Make sure to only call useSSRContext() conditionally in the server build.`);
    }
    return ctx;
  }
};
function initCustomFormatter() {
  {
    return;
  }
}
function withMemo(memo, render2, cache2, index2) {
  const cached = cache2[index2];
  if (cached && isMemoSame(cached, memo)) {
    return cached;
  }
  const ret = render2();
  ret.memo = memo.slice();
  return cache2[index2] = ret;
}
function isMemoSame(cached, memo) {
  const prev2 = cached.memo;
  if (prev2.length != memo.length) {
    return false;
  }
  for (let i2 = 0; i2 < prev2.length; i2++) {
    if (prev2[i2] !== memo[i2]) {
      return false;
    }
  }
  if (isBlockTreeEnabled > 0 && currentBlock) {
    currentBlock.push(cached);
  }
  return true;
}
const version$9 = "3.2.31";
const _ssrUtils = {
  createComponentInstance,
  setupComponent,
  renderComponentRoot,
  setCurrentRenderingInstance,
  isVNode,
  normalizeVNode
};
const ssrUtils = _ssrUtils;
const resolveFilter = null;
const compatUtils = null;
const svgNS = "http://www.w3.org/2000/svg";
const doc = typeof document !== "undefined" ? document : null;
const templateContainer = doc && doc.createElement("template");
const nodeOps = {
  insert: (child, parent, anchor) => {
    parent.insertBefore(child, anchor || null);
  },
  remove: (child) => {
    const parent = child.parentNode;
    if (parent) {
      parent.removeChild(child);
    }
  },
  createElement: (tag, isSVG, is, props) => {
    const el2 = isSVG ? doc.createElementNS(svgNS, tag) : doc.createElement(tag, is ? { is } : void 0);
    if (tag === "select" && props && props.multiple != null) {
      el2.setAttribute("multiple", props.multiple);
    }
    return el2;
  },
  createText: (text3) => doc.createTextNode(text3),
  createComment: (text3) => doc.createComment(text3),
  setText: (node, text3) => {
    node.nodeValue = text3;
  },
  setElementText: (el2, text3) => {
    el2.textContent = text3;
  },
  parentNode: (node) => node.parentNode,
  nextSibling: (node) => node.nextSibling,
  querySelector: (selector) => doc.querySelector(selector),
  setScopeId(el2, id2) {
    el2.setAttribute(id2, "");
  },
  cloneNode(el2) {
    const cloned = el2.cloneNode(true);
    if (`_value` in el2) {
      cloned._value = el2._value;
    }
    return cloned;
  },
  insertStaticContent(content, parent, anchor, isSVG, start, end) {
    const before = anchor ? anchor.previousSibling : parent.lastChild;
    if (start && (start === end || start.nextSibling)) {
      while (true) {
        parent.insertBefore(start.cloneNode(true), anchor);
        if (start === end || !(start = start.nextSibling))
          break;
      }
    } else {
      templateContainer.innerHTML = isSVG ? `<svg>${content}</svg>` : content;
      const template = templateContainer.content;
      if (isSVG) {
        const wrapper = template.firstChild;
        while (wrapper.firstChild) {
          template.appendChild(wrapper.firstChild);
        }
        template.removeChild(wrapper);
      }
      parent.insertBefore(template, anchor);
    }
    return [
      before ? before.nextSibling : parent.firstChild,
      anchor ? anchor.previousSibling : parent.lastChild
    ];
  }
};
function patchClass(el2, value, isSVG) {
  const transitionClasses = el2._vtc;
  if (transitionClasses) {
    value = (value ? [value, ...transitionClasses] : [...transitionClasses]).join(" ");
  }
  if (value == null) {
    el2.removeAttribute("class");
  } else if (isSVG) {
    el2.setAttribute("class", value);
  } else {
    el2.className = value;
  }
}
function patchStyle(el2, prev2, next) {
  const style = el2.style;
  const isCssString = isString$5(next);
  if (next && !isCssString) {
    for (const key in next) {
      setStyle(style, key, next[key]);
    }
    if (prev2 && !isString$5(prev2)) {
      for (const key in prev2) {
        if (next[key] == null) {
          setStyle(style, key, "");
        }
      }
    }
  } else {
    const currentDisplay = style.display;
    if (isCssString) {
      if (prev2 !== next) {
        style.cssText = next;
      }
    } else if (prev2) {
      el2.removeAttribute("style");
    }
    if ("_vod" in el2) {
      style.display = currentDisplay;
    }
  }
}
const importantRE = /\s*!important$/;
function setStyle(style, name2, val) {
  if (isArray$2(val)) {
    val.forEach((v) => setStyle(style, name2, v));
  } else {
    if (name2.startsWith("--")) {
      style.setProperty(name2, val);
    } else {
      const prefixed = autoPrefix(style, name2);
      if (importantRE.test(val)) {
        style.setProperty(hyphenate(prefixed), val.replace(importantRE, ""), "important");
      } else {
        style[prefixed] = val;
      }
    }
  }
}
const prefixes = ["Webkit", "Moz", "ms"];
const prefixCache = {};
function autoPrefix(style, rawName) {
  const cached = prefixCache[rawName];
  if (cached) {
    return cached;
  }
  let name2 = camelize(rawName);
  if (name2 !== "filter" && name2 in style) {
    return prefixCache[rawName] = name2;
  }
  name2 = capitalize(name2);
  for (let i2 = 0; i2 < prefixes.length; i2++) {
    const prefixed = prefixes[i2] + name2;
    if (prefixed in style) {
      return prefixCache[rawName] = prefixed;
    }
  }
  return rawName;
}
const xlinkNS = "http://www.w3.org/1999/xlink";
function patchAttr(el2, key, value, isSVG, instance) {
  if (isSVG && key.startsWith("xlink:")) {
    if (value == null) {
      el2.removeAttributeNS(xlinkNS, key.slice(6, key.length));
    } else {
      el2.setAttributeNS(xlinkNS, key, value);
    }
  } else {
    const isBoolean2 = isSpecialBooleanAttr(key);
    if (value == null || isBoolean2 && !includeBooleanAttr(value)) {
      el2.removeAttribute(key);
    } else {
      el2.setAttribute(key, isBoolean2 ? "" : value);
    }
  }
}
function patchDOMProp(el2, key, value, prevChildren, parentComponent, parentSuspense, unmountChildren) {
  if (key === "innerHTML" || key === "textContent") {
    if (prevChildren) {
      unmountChildren(prevChildren, parentComponent, parentSuspense);
    }
    el2[key] = value == null ? "" : value;
    return;
  }
  if (key === "value" && el2.tagName !== "PROGRESS" && !el2.tagName.includes("-")) {
    el2._value = value;
    const newValue = value == null ? "" : value;
    if (el2.value !== newValue || el2.tagName === "OPTION") {
      el2.value = newValue;
    }
    if (value == null) {
      el2.removeAttribute(key);
    }
    return;
  }
  if (value === "" || value == null) {
    const type2 = typeof el2[key];
    if (type2 === "boolean") {
      el2[key] = includeBooleanAttr(value);
      return;
    } else if (value == null && type2 === "string") {
      el2[key] = "";
      el2.removeAttribute(key);
      return;
    } else if (type2 === "number") {
      try {
        el2[key] = 0;
      } catch (_a2) {
      }
      el2.removeAttribute(key);
      return;
    }
  }
  try {
    el2[key] = value;
  } catch (e) {
  }
}
let _getNow = Date.now;
let skipTimestampCheck = false;
if (typeof window !== "undefined") {
  if (_getNow() > document.createEvent("Event").timeStamp) {
    _getNow = () => performance.now();
  }
  const ffMatch = navigator.userAgent.match(/firefox\/(\d+)/i);
  skipTimestampCheck = !!(ffMatch && Number(ffMatch[1]) <= 53);
}
let cachedNow = 0;
const p$2 = Promise.resolve();
const reset = () => {
  cachedNow = 0;
};
const getNow = () => cachedNow || (p$2.then(reset), cachedNow = _getNow());
function addEventListener$1(el2, event, handler, options2) {
  el2.addEventListener(event, handler, options2);
}
function removeEventListener$1(el2, event, handler, options2) {
  el2.removeEventListener(event, handler, options2);
}
function patchEvent(el2, rawName, prevValue, nextValue, instance = null) {
  const invokers = el2._vei || (el2._vei = {});
  const existingInvoker = invokers[rawName];
  if (nextValue && existingInvoker) {
    existingInvoker.value = nextValue;
  } else {
    const [name2, options2] = parseName(rawName);
    if (nextValue) {
      const invoker = invokers[rawName] = createInvoker(nextValue, instance);
      addEventListener$1(el2, name2, invoker, options2);
    } else if (existingInvoker) {
      removeEventListener$1(el2, name2, existingInvoker, options2);
      invokers[rawName] = void 0;
    }
  }
}
const optionsModifierRE = /(?:Once|Passive|Capture)$/;
function parseName(name2) {
  let options2;
  if (optionsModifierRE.test(name2)) {
    options2 = {};
    let m2;
    while (m2 = name2.match(optionsModifierRE)) {
      name2 = name2.slice(0, name2.length - m2[0].length);
      options2[m2[0].toLowerCase()] = true;
    }
  }
  return [hyphenate(name2.slice(2)), options2];
}
function createInvoker(initialValue, instance) {
  const invoker = (e) => {
    const timeStamp = e.timeStamp || _getNow();
    if (skipTimestampCheck || timeStamp >= invoker.attached - 1) {
      callWithAsyncErrorHandling(patchStopImmediatePropagation(e, invoker.value), instance, 5, [e]);
    }
  };
  invoker.value = initialValue;
  invoker.attached = getNow();
  return invoker;
}
function patchStopImmediatePropagation(e, value) {
  if (isArray$2(value)) {
    const originalStop = e.stopImmediatePropagation;
    e.stopImmediatePropagation = () => {
      originalStop.call(e);
      e._stopped = true;
    };
    return value.map((fn) => (e2) => !e2._stopped && fn && fn(e2));
  } else {
    return value;
  }
}
const nativeOnRE = /^on[a-z]/;
const patchProp = (el2, key, prevValue, nextValue, isSVG = false, prevChildren, parentComponent, parentSuspense, unmountChildren) => {
  if (key === "class") {
    patchClass(el2, nextValue, isSVG);
  } else if (key === "style") {
    patchStyle(el2, prevValue, nextValue);
  } else if (isOn(key)) {
    if (!isModelListener(key)) {
      patchEvent(el2, key, prevValue, nextValue, parentComponent);
    }
  } else if (key[0] === "." ? (key = key.slice(1), true) : key[0] === "^" ? (key = key.slice(1), false) : shouldSetAsProp(el2, key, nextValue, isSVG)) {
    patchDOMProp(el2, key, nextValue, prevChildren, parentComponent, parentSuspense, unmountChildren);
  } else {
    if (key === "true-value") {
      el2._trueValue = nextValue;
    } else if (key === "false-value") {
      el2._falseValue = nextValue;
    }
    patchAttr(el2, key, nextValue, isSVG);
  }
};
function shouldSetAsProp(el2, key, value, isSVG) {
  if (isSVG) {
    if (key === "innerHTML" || key === "textContent") {
      return true;
    }
    if (key in el2 && nativeOnRE.test(key) && isFunction$4(value)) {
      return true;
    }
    return false;
  }
  if (key === "spellcheck" || key === "draggable") {
    return false;
  }
  if (key === "form") {
    return false;
  }
  if (key === "list" && el2.tagName === "INPUT") {
    return false;
  }
  if (key === "type" && el2.tagName === "TEXTAREA") {
    return false;
  }
  if (nativeOnRE.test(key) && isString$5(value)) {
    return false;
  }
  return key in el2;
}
function defineCustomElement(options2, hydate) {
  const Comp = defineComponent(options2);
  class VueCustomElement extends VueElement {
    constructor(initialProps) {
      super(Comp, initialProps, hydate);
    }
  }
  VueCustomElement.def = Comp;
  return VueCustomElement;
}
const defineSSRCustomElement = (options2) => {
  return defineCustomElement(options2, hydrate);
};
const BaseClass = typeof HTMLElement !== "undefined" ? HTMLElement : class {
};
class VueElement extends BaseClass {
  constructor(_def, _props = {}, hydrate2) {
    super();
    this._def = _def;
    this._props = _props;
    this._instance = null;
    this._connected = false;
    this._resolved = false;
    this._numberProps = null;
    if (this.shadowRoot && hydrate2) {
      hydrate2(this._createVNode(), this.shadowRoot);
    } else {
      this.attachShadow({ mode: "open" });
    }
  }
  connectedCallback() {
    this._connected = true;
    if (!this._instance) {
      this._resolveDef();
    }
  }
  disconnectedCallback() {
    this._connected = false;
    nextTick(() => {
      if (!this._connected) {
        render$1e(null, this.shadowRoot);
        this._instance = null;
      }
    });
  }
  _resolveDef() {
    if (this._resolved) {
      return;
    }
    this._resolved = true;
    for (let i2 = 0; i2 < this.attributes.length; i2++) {
      this._setAttr(this.attributes[i2].name);
    }
    new MutationObserver((mutations) => {
      for (const m2 of mutations) {
        this._setAttr(m2.attributeName);
      }
    }).observe(this, { attributes: true });
    const resolve3 = (def2) => {
      const { props, styles } = def2;
      const hasOptions = !isArray$2(props);
      const rawKeys = props ? hasOptions ? Object.keys(props) : props : [];
      let numberProps;
      if (hasOptions) {
        for (const key in this._props) {
          const opt = props[key];
          if (opt === Number || opt && opt.type === Number) {
            this._props[key] = toNumber(this._props[key]);
            (numberProps || (numberProps = /* @__PURE__ */ Object.create(null)))[key] = true;
          }
        }
      }
      this._numberProps = numberProps;
      for (const key of Object.keys(this)) {
        if (key[0] !== "_") {
          this._setProp(key, this[key], true, false);
        }
      }
      for (const key of rawKeys.map(camelize)) {
        Object.defineProperty(this, key, {
          get() {
            return this._getProp(key);
          },
          set(val) {
            this._setProp(key, val);
          }
        });
      }
      this._applyStyles(styles);
      this._update();
    };
    const asyncDef = this._def.__asyncLoader;
    if (asyncDef) {
      asyncDef().then(resolve3);
    } else {
      resolve3(this._def);
    }
  }
  _setAttr(key) {
    let value = this.getAttribute(key);
    if (this._numberProps && this._numberProps[key]) {
      value = toNumber(value);
    }
    this._setProp(camelize(key), value, false);
  }
  _getProp(key) {
    return this._props[key];
  }
  _setProp(key, val, shouldReflect = true, shouldUpdate = true) {
    if (val !== this._props[key]) {
      this._props[key] = val;
      if (shouldUpdate && this._instance) {
        this._update();
      }
      if (shouldReflect) {
        if (val === true) {
          this.setAttribute(hyphenate(key), "");
        } else if (typeof val === "string" || typeof val === "number") {
          this.setAttribute(hyphenate(key), val + "");
        } else if (!val) {
          this.removeAttribute(hyphenate(key));
        }
      }
    }
  }
  _update() {
    render$1e(this._createVNode(), this.shadowRoot);
  }
  _createVNode() {
    const vnode = createVNode(this._def, extend({}, this._props));
    if (!this._instance) {
      vnode.ce = (instance) => {
        this._instance = instance;
        instance.isCE = true;
        instance.emit = (event, ...args) => {
          this.dispatchEvent(new CustomEvent(event, {
            detail: args
          }));
        };
        let parent = this;
        while (parent = parent && (parent.parentNode || parent.host)) {
          if (parent instanceof VueElement) {
            instance.parent = parent._instance;
            break;
          }
        }
      };
    }
    return vnode;
  }
  _applyStyles(styles) {
    if (styles) {
      styles.forEach((css) => {
        const s2 = document.createElement("style");
        s2.textContent = css;
        this.shadowRoot.appendChild(s2);
      });
    }
  }
}
function useCssModule(name2 = "$style") {
  {
    const instance = getCurrentInstance();
    if (!instance) {
      return EMPTY_OBJ;
    }
    const modules = instance.type.__cssModules;
    if (!modules) {
      return EMPTY_OBJ;
    }
    const mod = modules[name2];
    if (!mod) {
      return EMPTY_OBJ;
    }
    return mod;
  }
}
function useCssVars(getter) {
  const instance = getCurrentInstance();
  if (!instance) {
    return;
  }
  const setVars = () => setVarsOnVNode(instance.subTree, getter(instance.proxy));
  watchPostEffect(setVars);
  onMounted(() => {
    const ob = new MutationObserver(setVars);
    ob.observe(instance.subTree.el.parentNode, { childList: true });
    onUnmounted(() => ob.disconnect());
  });
}
function setVarsOnVNode(vnode, vars) {
  if (vnode.shapeFlag & 128) {
    const suspense = vnode.suspense;
    vnode = suspense.activeBranch;
    if (suspense.pendingBranch && !suspense.isHydrating) {
      suspense.effects.push(() => {
        setVarsOnVNode(suspense.activeBranch, vars);
      });
    }
  }
  while (vnode.component) {
    vnode = vnode.component.subTree;
  }
  if (vnode.shapeFlag & 1 && vnode.el) {
    setVarsOnNode(vnode.el, vars);
  } else if (vnode.type === Fragment) {
    vnode.children.forEach((c2) => setVarsOnVNode(c2, vars));
  } else if (vnode.type === Static) {
    let { el: el2, anchor } = vnode;
    while (el2) {
      setVarsOnNode(el2, vars);
      if (el2 === anchor)
        break;
      el2 = el2.nextSibling;
    }
  }
}
function setVarsOnNode(el2, vars) {
  if (el2.nodeType === 1) {
    const style = el2.style;
    for (const key in vars) {
      style.setProperty(`--${key}`, vars[key]);
    }
  }
}
const TRANSITION$1 = "transition";
const ANIMATION = "animation";
const Transition = (props, { slots }) => h$1(BaseTransition, resolveTransitionProps(props), slots);
Transition.displayName = "Transition";
const DOMTransitionPropsValidators = {
  name: String,
  type: String,
  css: {
    type: Boolean,
    default: true
  },
  duration: [String, Number, Object],
  enterFromClass: String,
  enterActiveClass: String,
  enterToClass: String,
  appearFromClass: String,
  appearActiveClass: String,
  appearToClass: String,
  leaveFromClass: String,
  leaveActiveClass: String,
  leaveToClass: String
};
const TransitionPropsValidators = Transition.props = /* @__PURE__ */ extend({}, BaseTransition.props, DOMTransitionPropsValidators);
const callHook = (hook, args = []) => {
  if (isArray$2(hook)) {
    hook.forEach((h2) => h2(...args));
  } else if (hook) {
    hook(...args);
  }
};
const hasExplicitCallback = (hook) => {
  return hook ? isArray$2(hook) ? hook.some((h2) => h2.length > 1) : hook.length > 1 : false;
};
function resolveTransitionProps(rawProps) {
  const baseProps = {};
  for (const key in rawProps) {
    if (!(key in DOMTransitionPropsValidators)) {
      baseProps[key] = rawProps[key];
    }
  }
  if (rawProps.css === false) {
    return baseProps;
  }
  const { name: name2 = "v", type: type2, duration, enterFromClass = `${name2}-enter-from`, enterActiveClass = `${name2}-enter-active`, enterToClass = `${name2}-enter-to`, appearFromClass = enterFromClass, appearActiveClass = enterActiveClass, appearToClass = enterToClass, leaveFromClass = `${name2}-leave-from`, leaveActiveClass = `${name2}-leave-active`, leaveToClass = `${name2}-leave-to` } = rawProps;
  const durations = normalizeDuration(duration);
  const enterDuration = durations && durations[0];
  const leaveDuration = durations && durations[1];
  const { onBeforeEnter, onEnter, onEnterCancelled, onLeave, onLeaveCancelled, onBeforeAppear = onBeforeEnter, onAppear = onEnter, onAppearCancelled = onEnterCancelled } = baseProps;
  const finishEnter = (el2, isAppear, done) => {
    removeTransitionClass(el2, isAppear ? appearToClass : enterToClass);
    removeTransitionClass(el2, isAppear ? appearActiveClass : enterActiveClass);
    done && done();
  };
  const finishLeave = (el2, done) => {
    removeTransitionClass(el2, leaveToClass);
    removeTransitionClass(el2, leaveActiveClass);
    done && done();
  };
  const makeEnterHook = (isAppear) => {
    return (el2, done) => {
      const hook = isAppear ? onAppear : onEnter;
      const resolve3 = () => finishEnter(el2, isAppear, done);
      callHook(hook, [el2, resolve3]);
      nextFrame$2(() => {
        removeTransitionClass(el2, isAppear ? appearFromClass : enterFromClass);
        addTransitionClass(el2, isAppear ? appearToClass : enterToClass);
        if (!hasExplicitCallback(hook)) {
          whenTransitionEnds(el2, type2, enterDuration, resolve3);
        }
      });
    };
  };
  return extend(baseProps, {
    onBeforeEnter(el2) {
      callHook(onBeforeEnter, [el2]);
      addTransitionClass(el2, enterFromClass);
      addTransitionClass(el2, enterActiveClass);
    },
    onBeforeAppear(el2) {
      callHook(onBeforeAppear, [el2]);
      addTransitionClass(el2, appearFromClass);
      addTransitionClass(el2, appearActiveClass);
    },
    onEnter: makeEnterHook(false),
    onAppear: makeEnterHook(true),
    onLeave(el2, done) {
      const resolve3 = () => finishLeave(el2, done);
      addTransitionClass(el2, leaveFromClass);
      forceReflow();
      addTransitionClass(el2, leaveActiveClass);
      nextFrame$2(() => {
        removeTransitionClass(el2, leaveFromClass);
        addTransitionClass(el2, leaveToClass);
        if (!hasExplicitCallback(onLeave)) {
          whenTransitionEnds(el2, type2, leaveDuration, resolve3);
        }
      });
      callHook(onLeave, [el2, resolve3]);
    },
    onEnterCancelled(el2) {
      finishEnter(el2, false);
      callHook(onEnterCancelled, [el2]);
    },
    onAppearCancelled(el2) {
      finishEnter(el2, true);
      callHook(onAppearCancelled, [el2]);
    },
    onLeaveCancelled(el2) {
      finishLeave(el2);
      callHook(onLeaveCancelled, [el2]);
    }
  });
}
function normalizeDuration(duration) {
  if (duration == null) {
    return null;
  } else if (isObject$5(duration)) {
    return [NumberOf(duration.enter), NumberOf(duration.leave)];
  } else {
    const n = NumberOf(duration);
    return [n, n];
  }
}
function NumberOf(val) {
  const res = toNumber(val);
  return res;
}
function addTransitionClass(el2, cls) {
  cls.split(/\s+/).forEach((c2) => c2 && el2.classList.add(c2));
  (el2._vtc || (el2._vtc = /* @__PURE__ */ new Set())).add(cls);
}
function removeTransitionClass(el2, cls) {
  cls.split(/\s+/).forEach((c2) => c2 && el2.classList.remove(c2));
  const { _vtc } = el2;
  if (_vtc) {
    _vtc.delete(cls);
    if (!_vtc.size) {
      el2._vtc = void 0;
    }
  }
}
function nextFrame$2(cb) {
  requestAnimationFrame(() => {
    requestAnimationFrame(cb);
  });
}
let endId = 0;
function whenTransitionEnds(el2, expectedType, explicitTimeout, resolve3) {
  const id2 = el2._endId = ++endId;
  const resolveIfNotStale = () => {
    if (id2 === el2._endId) {
      resolve3();
    }
  };
  if (explicitTimeout) {
    return setTimeout(resolveIfNotStale, explicitTimeout);
  }
  const { type: type2, timeout, propCount } = getTransitionInfo(el2, expectedType);
  if (!type2) {
    return resolve3();
  }
  const endEvent = type2 + "end";
  let ended = 0;
  const end = () => {
    el2.removeEventListener(endEvent, onEnd);
    resolveIfNotStale();
  };
  const onEnd = (e) => {
    if (e.target === el2 && ++ended >= propCount) {
      end();
    }
  };
  setTimeout(() => {
    if (ended < propCount) {
      end();
    }
  }, timeout + 1);
  el2.addEventListener(endEvent, onEnd);
}
function getTransitionInfo(el2, expectedType) {
  const styles = window.getComputedStyle(el2);
  const getStyleProperties = (key) => (styles[key] || "").split(", ");
  const transitionDelays = getStyleProperties(TRANSITION$1 + "Delay");
  const transitionDurations = getStyleProperties(TRANSITION$1 + "Duration");
  const transitionTimeout = getTimeout(transitionDelays, transitionDurations);
  const animationDelays = getStyleProperties(ANIMATION + "Delay");
  const animationDurations = getStyleProperties(ANIMATION + "Duration");
  const animationTimeout = getTimeout(animationDelays, animationDurations);
  let type2 = null;
  let timeout = 0;
  let propCount = 0;
  if (expectedType === TRANSITION$1) {
    if (transitionTimeout > 0) {
      type2 = TRANSITION$1;
      timeout = transitionTimeout;
      propCount = transitionDurations.length;
    }
  } else if (expectedType === ANIMATION) {
    if (animationTimeout > 0) {
      type2 = ANIMATION;
      timeout = animationTimeout;
      propCount = animationDurations.length;
    }
  } else {
    timeout = Math.max(transitionTimeout, animationTimeout);
    type2 = timeout > 0 ? transitionTimeout > animationTimeout ? TRANSITION$1 : ANIMATION : null;
    propCount = type2 ? type2 === TRANSITION$1 ? transitionDurations.length : animationDurations.length : 0;
  }
  const hasTransform = type2 === TRANSITION$1 && /\b(transform|all)(,|$)/.test(styles[TRANSITION$1 + "Property"]);
  return {
    type: type2,
    timeout,
    propCount,
    hasTransform
  };
}
function getTimeout(delays, durations) {
  while (delays.length < durations.length) {
    delays = delays.concat(delays);
  }
  return Math.max(...durations.map((d2, i2) => toMs(d2) + toMs(delays[i2])));
}
function toMs(s2) {
  return Number(s2.slice(0, -1).replace(",", ".")) * 1e3;
}
function forceReflow() {
  return document.body.offsetHeight;
}
const positionMap = /* @__PURE__ */ new WeakMap();
const newPositionMap = /* @__PURE__ */ new WeakMap();
const TransitionGroupImpl = {
  name: "TransitionGroup",
  props: /* @__PURE__ */ extend({}, TransitionPropsValidators, {
    tag: String,
    moveClass: String
  }),
  setup(props, { slots }) {
    const instance = getCurrentInstance();
    const state = useTransitionState();
    let prevChildren;
    let children;
    onUpdated(() => {
      if (!prevChildren.length) {
        return;
      }
      const moveClass = props.moveClass || `${props.name || "v"}-move`;
      if (!hasCSSTransform(prevChildren[0].el, instance.vnode.el, moveClass)) {
        return;
      }
      prevChildren.forEach(callPendingCbs);
      prevChildren.forEach(recordPosition);
      const movedChildren = prevChildren.filter(applyTranslation);
      forceReflow();
      movedChildren.forEach((c2) => {
        const el2 = c2.el;
        const style = el2.style;
        addTransitionClass(el2, moveClass);
        style.transform = style.webkitTransform = style.transitionDuration = "";
        const cb = el2._moveCb = (e) => {
          if (e && e.target !== el2) {
            return;
          }
          if (!e || /transform$/.test(e.propertyName)) {
            el2.removeEventListener("transitionend", cb);
            el2._moveCb = null;
            removeTransitionClass(el2, moveClass);
          }
        };
        el2.addEventListener("transitionend", cb);
      });
    });
    return () => {
      const rawProps = toRaw(props);
      const cssTransitionProps = resolveTransitionProps(rawProps);
      let tag = rawProps.tag || Fragment;
      prevChildren = children;
      children = slots.default ? getTransitionRawChildren(slots.default()) : [];
      for (let i2 = 0; i2 < children.length; i2++) {
        const child = children[i2];
        if (child.key != null) {
          setTransitionHooks(child, resolveTransitionHooks(child, cssTransitionProps, state, instance));
        }
      }
      if (prevChildren) {
        for (let i2 = 0; i2 < prevChildren.length; i2++) {
          const child = prevChildren[i2];
          setTransitionHooks(child, resolveTransitionHooks(child, cssTransitionProps, state, instance));
          positionMap.set(child, child.el.getBoundingClientRect());
        }
      }
      return createVNode(tag, null, children);
    };
  }
};
const TransitionGroup = TransitionGroupImpl;
function callPendingCbs(c2) {
  const el2 = c2.el;
  if (el2._moveCb) {
    el2._moveCb();
  }
  if (el2._enterCb) {
    el2._enterCb();
  }
}
function recordPosition(c2) {
  newPositionMap.set(c2, c2.el.getBoundingClientRect());
}
function applyTranslation(c2) {
  const oldPos = positionMap.get(c2);
  const newPos = newPositionMap.get(c2);
  const dx = oldPos.left - newPos.left;
  const dy = oldPos.top - newPos.top;
  if (dx || dy) {
    const s2 = c2.el.style;
    s2.transform = s2.webkitTransform = `translate(${dx}px,${dy}px)`;
    s2.transitionDuration = "0s";
    return c2;
  }
}
function hasCSSTransform(el2, root, moveClass) {
  const clone2 = el2.cloneNode();
  if (el2._vtc) {
    el2._vtc.forEach((cls) => {
      cls.split(/\s+/).forEach((c2) => c2 && clone2.classList.remove(c2));
    });
  }
  moveClass.split(/\s+/).forEach((c2) => c2 && clone2.classList.add(c2));
  clone2.style.display = "none";
  const container = root.nodeType === 1 ? root : root.parentNode;
  container.appendChild(clone2);
  const { hasTransform } = getTransitionInfo(clone2);
  container.removeChild(clone2);
  return hasTransform;
}
const getModelAssigner = (vnode) => {
  const fn = vnode.props["onUpdate:modelValue"];
  return isArray$2(fn) ? (value) => invokeArrayFns(fn, value) : fn;
};
function onCompositionStart(e) {
  e.target.composing = true;
}
function onCompositionEnd(e) {
  const target2 = e.target;
  if (target2.composing) {
    target2.composing = false;
    trigger(target2, "input");
  }
}
function trigger(el2, type2) {
  const e = document.createEvent("HTMLEvents");
  e.initEvent(type2, true, true);
  el2.dispatchEvent(e);
}
const vModelText = {
  created(el2, { modifiers: { lazy, trim: trim2, number: number2 } }, vnode) {
    el2._assign = getModelAssigner(vnode);
    const castToNumber = number2 || vnode.props && vnode.props.type === "number";
    addEventListener$1(el2, lazy ? "change" : "input", (e) => {
      if (e.target.composing)
        return;
      let domValue = el2.value;
      if (trim2) {
        domValue = domValue.trim();
      } else if (castToNumber) {
        domValue = toNumber(domValue);
      }
      el2._assign(domValue);
    });
    if (trim2) {
      addEventListener$1(el2, "change", () => {
        el2.value = el2.value.trim();
      });
    }
    if (!lazy) {
      addEventListener$1(el2, "compositionstart", onCompositionStart);
      addEventListener$1(el2, "compositionend", onCompositionEnd);
      addEventListener$1(el2, "change", onCompositionEnd);
    }
  },
  mounted(el2, { value }) {
    el2.value = value == null ? "" : value;
  },
  beforeUpdate(el2, { value, modifiers: { lazy, trim: trim2, number: number2 } }, vnode) {
    el2._assign = getModelAssigner(vnode);
    if (el2.composing)
      return;
    if (document.activeElement === el2) {
      if (lazy) {
        return;
      }
      if (trim2 && el2.value.trim() === value) {
        return;
      }
      if ((number2 || el2.type === "number") && toNumber(el2.value) === value) {
        return;
      }
    }
    const newValue = value == null ? "" : value;
    if (el2.value !== newValue) {
      el2.value = newValue;
    }
  }
};
const vModelCheckbox = {
  deep: true,
  created(el2, _2, vnode) {
    el2._assign = getModelAssigner(vnode);
    addEventListener$1(el2, "change", () => {
      const modelValue = el2._modelValue;
      const elementValue = getValue(el2);
      const checked = el2.checked;
      const assign2 = el2._assign;
      if (isArray$2(modelValue)) {
        const index2 = looseIndexOf(modelValue, elementValue);
        const found = index2 !== -1;
        if (checked && !found) {
          assign2(modelValue.concat(elementValue));
        } else if (!checked && found) {
          const filtered = [...modelValue];
          filtered.splice(index2, 1);
          assign2(filtered);
        }
      } else if (isSet(modelValue)) {
        const cloned = new Set(modelValue);
        if (checked) {
          cloned.add(elementValue);
        } else {
          cloned.delete(elementValue);
        }
        assign2(cloned);
      } else {
        assign2(getCheckboxValue(el2, checked));
      }
    });
  },
  mounted: setChecked,
  beforeUpdate(el2, binding, vnode) {
    el2._assign = getModelAssigner(vnode);
    setChecked(el2, binding, vnode);
  }
};
function setChecked(el2, { value, oldValue }, vnode) {
  el2._modelValue = value;
  if (isArray$2(value)) {
    el2.checked = looseIndexOf(value, vnode.props.value) > -1;
  } else if (isSet(value)) {
    el2.checked = value.has(vnode.props.value);
  } else if (value !== oldValue) {
    el2.checked = looseEqual(value, getCheckboxValue(el2, true));
  }
}
const vModelRadio = {
  created(el2, { value }, vnode) {
    el2.checked = looseEqual(value, vnode.props.value);
    el2._assign = getModelAssigner(vnode);
    addEventListener$1(el2, "change", () => {
      el2._assign(getValue(el2));
    });
  },
  beforeUpdate(el2, { value, oldValue }, vnode) {
    el2._assign = getModelAssigner(vnode);
    if (value !== oldValue) {
      el2.checked = looseEqual(value, vnode.props.value);
    }
  }
};
const vModelSelect = {
  deep: true,
  created(el2, { value, modifiers: { number: number2 } }, vnode) {
    const isSetModel = isSet(value);
    addEventListener$1(el2, "change", () => {
      const selectedVal = Array.prototype.filter.call(el2.options, (o2) => o2.selected).map((o2) => number2 ? toNumber(getValue(o2)) : getValue(o2));
      el2._assign(el2.multiple ? isSetModel ? new Set(selectedVal) : selectedVal : selectedVal[0]);
    });
    el2._assign = getModelAssigner(vnode);
  },
  mounted(el2, { value }) {
    setSelected(el2, value);
  },
  beforeUpdate(el2, _binding, vnode) {
    el2._assign = getModelAssigner(vnode);
  },
  updated(el2, { value }) {
    setSelected(el2, value);
  }
};
function setSelected(el2, value) {
  const isMultiple = el2.multiple;
  if (isMultiple && !isArray$2(value) && !isSet(value)) {
    return;
  }
  for (let i2 = 0, l2 = el2.options.length; i2 < l2; i2++) {
    const option = el2.options[i2];
    const optionValue = getValue(option);
    if (isMultiple) {
      if (isArray$2(value)) {
        option.selected = looseIndexOf(value, optionValue) > -1;
      } else {
        option.selected = value.has(optionValue);
      }
    } else {
      if (looseEqual(getValue(option), value)) {
        if (el2.selectedIndex !== i2)
          el2.selectedIndex = i2;
        return;
      }
    }
  }
  if (!isMultiple && el2.selectedIndex !== -1) {
    el2.selectedIndex = -1;
  }
}
function getValue(el2) {
  return "_value" in el2 ? el2._value : el2.value;
}
function getCheckboxValue(el2, checked) {
  const key = checked ? "_trueValue" : "_falseValue";
  return key in el2 ? el2[key] : checked;
}
const vModelDynamic = {
  created(el2, binding, vnode) {
    callModelHook(el2, binding, vnode, null, "created");
  },
  mounted(el2, binding, vnode) {
    callModelHook(el2, binding, vnode, null, "mounted");
  },
  beforeUpdate(el2, binding, vnode, prevVNode) {
    callModelHook(el2, binding, vnode, prevVNode, "beforeUpdate");
  },
  updated(el2, binding, vnode, prevVNode) {
    callModelHook(el2, binding, vnode, prevVNode, "updated");
  }
};
function callModelHook(el2, binding, vnode, prevVNode, hook) {
  let modelToUse;
  switch (el2.tagName) {
    case "SELECT":
      modelToUse = vModelSelect;
      break;
    case "TEXTAREA":
      modelToUse = vModelText;
      break;
    default:
      switch (vnode.props && vnode.props.type) {
        case "checkbox":
          modelToUse = vModelCheckbox;
          break;
        case "radio":
          modelToUse = vModelRadio;
          break;
        default:
          modelToUse = vModelText;
      }
  }
  const fn = modelToUse[hook];
  fn && fn(el2, binding, vnode, prevVNode);
}
function initVModelForSSR() {
  vModelText.getSSRProps = ({ value }) => ({ value });
  vModelRadio.getSSRProps = ({ value }, vnode) => {
    if (vnode.props && looseEqual(vnode.props.value, value)) {
      return { checked: true };
    }
  };
  vModelCheckbox.getSSRProps = ({ value }, vnode) => {
    if (isArray$2(value)) {
      if (vnode.props && looseIndexOf(value, vnode.props.value) > -1) {
        return { checked: true };
      }
    } else if (isSet(value)) {
      if (vnode.props && value.has(vnode.props.value)) {
        return { checked: true };
      }
    } else if (value) {
      return { checked: true };
    }
  };
}
const systemModifiers = ["ctrl", "shift", "alt", "meta"];
const modifierGuards = {
  stop: (e) => e.stopPropagation(),
  prevent: (e) => e.preventDefault(),
  self: (e) => e.target !== e.currentTarget,
  ctrl: (e) => !e.ctrlKey,
  shift: (e) => !e.shiftKey,
  alt: (e) => !e.altKey,
  meta: (e) => !e.metaKey,
  left: (e) => "button" in e && e.button !== 0,
  middle: (e) => "button" in e && e.button !== 1,
  right: (e) => "button" in e && e.button !== 2,
  exact: (e, modifiers) => systemModifiers.some((m2) => e[`${m2}Key`] && !modifiers.includes(m2))
};
const withModifiers = (fn, modifiers) => {
  return (event, ...args) => {
    for (let i2 = 0; i2 < modifiers.length; i2++) {
      const guard = modifierGuards[modifiers[i2]];
      if (guard && guard(event, modifiers))
        return;
    }
    return fn(event, ...args);
  };
};
const keyNames = {
  esc: "escape",
  space: " ",
  up: "arrow-up",
  left: "arrow-left",
  right: "arrow-right",
  down: "arrow-down",
  delete: "backspace"
};
const withKeys = (fn, modifiers) => {
  return (event) => {
    if (!("key" in event)) {
      return;
    }
    const eventKey = hyphenate(event.key);
    if (modifiers.some((k) => k === eventKey || keyNames[k] === eventKey)) {
      return fn(event);
    }
  };
};
const vShow = {
  beforeMount(el2, { value }, { transition }) {
    el2._vod = el2.style.display === "none" ? "" : el2.style.display;
    if (transition && value) {
      transition.beforeEnter(el2);
    } else {
      setDisplay(el2, value);
    }
  },
  mounted(el2, { value }, { transition }) {
    if (transition && value) {
      transition.enter(el2);
    }
  },
  updated(el2, { value, oldValue }, { transition }) {
    if (!value === !oldValue)
      return;
    if (transition) {
      if (value) {
        transition.beforeEnter(el2);
        setDisplay(el2, true);
        transition.enter(el2);
      } else {
        transition.leave(el2, () => {
          setDisplay(el2, false);
        });
      }
    } else {
      setDisplay(el2, value);
    }
  },
  beforeUnmount(el2, { value }) {
    setDisplay(el2, value);
  }
};
function setDisplay(el2, value) {
  el2.style.display = value ? el2._vod : "none";
}
function initVShowForSSR() {
  vShow.getSSRProps = ({ value }) => {
    if (!value) {
      return { style: { display: "none" } };
    }
  };
}
const rendererOptions = extend({ patchProp }, nodeOps);
let renderer$1;
let enabledHydration = false;
function ensureRenderer() {
  return renderer$1 || (renderer$1 = createRenderer(rendererOptions));
}
function ensureHydrationRenderer() {
  renderer$1 = enabledHydration ? renderer$1 : createHydrationRenderer(rendererOptions);
  enabledHydration = true;
  return renderer$1;
}
const render$1e = (...args) => {
  ensureRenderer().render(...args);
};
const hydrate = (...args) => {
  ensureHydrationRenderer().hydrate(...args);
};
const createApp = (...args) => {
  const app2 = ensureRenderer().createApp(...args);
  const { mount } = app2;
  app2.mount = (containerOrSelector) => {
    const container = normalizeContainer(containerOrSelector);
    if (!container)
      return;
    const component = app2._component;
    if (!isFunction$4(component) && !component.render && !component.template) {
      component.template = container.innerHTML;
    }
    container.innerHTML = "";
    const proxy = mount(container, false, container instanceof SVGElement);
    if (container instanceof Element) {
      container.removeAttribute("v-cloak");
      container.setAttribute("data-v-app", "");
    }
    return proxy;
  };
  return app2;
};
const createSSRApp = (...args) => {
  const app2 = ensureHydrationRenderer().createApp(...args);
  const { mount } = app2;
  app2.mount = (containerOrSelector) => {
    const container = normalizeContainer(containerOrSelector);
    if (container) {
      return mount(container, true, container instanceof SVGElement);
    }
  };
  return app2;
};
function normalizeContainer(container) {
  if (isString$5(container)) {
    const res = document.querySelector(container);
    return res;
  }
  return container;
}
let ssrDirectiveInitialized = false;
const initDirectivesForSSR = () => {
  if (!ssrDirectiveInitialized) {
    ssrDirectiveInitialized = true;
    initVModelForSSR();
    initVShowForSSR();
  }
};
const compile$1 = () => {
};
const vue_runtime_esmBundler = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  compile: compile$1,
  EffectScope,
  ReactiveEffect,
  customRef,
  effect,
  effectScope,
  getCurrentScope,
  isProxy,
  isReactive,
  isReadonly,
  isRef,
  isShallow,
  markRaw,
  onScopeDispose,
  proxyRefs,
  reactive,
  readonly,
  ref,
  shallowReactive,
  shallowReadonly,
  shallowRef,
  stop,
  toRaw,
  toRef,
  toRefs,
  triggerRef,
  unref,
  camelize,
  capitalize,
  normalizeClass,
  normalizeProps,
  normalizeStyle,
  toDisplayString: toDisplayString$1,
  toHandlerKey,
  BaseTransition,
  Comment,
  Fragment,
  KeepAlive,
  Static,
  Suspense,
  Teleport,
  Text,
  callWithAsyncErrorHandling,
  callWithErrorHandling,
  cloneVNode,
  compatUtils,
  computed,
  createBlock,
  createCommentVNode,
  createElementBlock,
  createElementVNode: createBaseVNode,
  createHydrationRenderer,
  createPropsRestProxy,
  createRenderer,
  createSlots,
  createStaticVNode,
  createTextVNode,
  createVNode,
  defineAsyncComponent,
  defineComponent,
  defineEmits,
  defineExpose,
  defineProps,
  get devtools() {
    return devtools$1;
  },
  getCurrentInstance,
  getTransitionRawChildren,
  guardReactiveProps,
  h: h$1,
  handleError,
  initCustomFormatter,
  inject,
  isMemoSame,
  isRuntimeOnly,
  isVNode,
  mergeDefaults,
  mergeProps,
  nextTick,
  onActivated,
  onBeforeMount,
  onBeforeUnmount,
  onBeforeUpdate,
  onDeactivated,
  onErrorCaptured,
  onMounted,
  onRenderTracked,
  onRenderTriggered,
  onServerPrefetch,
  onUnmounted,
  onUpdated,
  openBlock,
  popScopeId,
  provide,
  pushScopeId,
  queuePostFlushCb,
  registerRuntimeCompiler,
  renderList,
  renderSlot,
  resolveComponent,
  resolveDirective,
  resolveDynamicComponent,
  resolveFilter,
  resolveTransitionHooks,
  setBlockTracking,
  setDevtoolsHook,
  setTransitionHooks,
  ssrContextKey,
  ssrUtils,
  toHandlers,
  transformVNodeArgs,
  useAttrs,
  useSSRContext,
  useSlots,
  useTransitionState,
  version: version$9,
  warn: warn$1,
  watch,
  watchEffect,
  watchPostEffect,
  watchSyncEffect,
  withAsyncContext,
  withCtx,
  withDefaults,
  withDirectives,
  withMemo,
  withScopeId,
  Transition,
  TransitionGroup,
  VueElement,
  createApp,
  createSSRApp,
  defineCustomElement,
  defineSSRCustomElement,
  hydrate,
  initDirectivesForSSR,
  render: render$1e,
  useCssModule,
  useCssVars,
  vModelCheckbox,
  vModelDynamic,
  vModelRadio,
  vModelSelect,
  vModelText,
  vShow,
  withKeys,
  withModifiers
}, Symbol.toStringTag, { value: "Module" }));
const HeaderBar_HeaderBarQueryDocument$1 = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "HeaderBar_HeaderBarQuery" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "config" } }, { "kind": "Field", "name": { "kind": "Name", "value": "savedState" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "branch" } }, { "kind": "Field", "name": { "kind": "Name", "value": "packageManager" } }, { "kind": "Field", "name": { "kind": "Name", "value": "activeBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "displayName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "majorVersion" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "browsers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isSelected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "displayName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "majorVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isVersionSupported" } }, { "kind": "Field", "name": { "kind": "Name", "value": "warning" } }, { "kind": "Field", "name": { "kind": "Name", "value": "disabled" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "isGlobalMode" } }, { "kind": "Field", "name": { "kind": "Name", "value": "versions" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "current" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "released" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "latest" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "released" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cachedUser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }] } }] } }] };
const App_DevRelaunchDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "App_DevRelaunch" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "action" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "DevRelaunchAction" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "devRelaunch" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "action" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "action" } } }] }] } }] };
const MainLaunchpadQueryDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "MainLaunchpadQuery" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCTConfigured" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isE2EConfigured" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "packageManager" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingConfigFile" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingNodeEvents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isFullConfigReady" } }, { "kind": "Field", "name": { "kind": "Name", "value": "needsLegacyConfigMigration" } }, { "kind": "Field", "name": { "kind": "Name", "value": "activeBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "invokedFromCli" } }, { "kind": "Field", "name": { "kind": "Name", "value": "scaffoldedFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "description" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }, { "kind": "Field", "name": { "kind": "Name", "value": "contents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fileExtension" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "wizard" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "bundler" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "framework" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportedBundlers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "category" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "frameworks" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportStatus" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "category" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "allBundlers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "packagesToInstall" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "description" } }, { "kind": "Field", "name": { "kind": "Name", "value": "package" } }, { "kind": "Field", "name": { "kind": "Name", "value": "minVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "detectedVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "satisfied" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "installDependenciesCommand" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "baseError" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorStack" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUserCodeError" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeFrame" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "line" } }, { "kind": "Field", "name": { "kind": "Name", "value": "column" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeBlock" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "majorVersionWelcomeDismissed" } }, { "kind": "Field", "name": { "kind": "Name", "value": "wasBrowserSetInCLI" } }, { "kind": "Field", "name": { "kind": "Name", "value": "preferredEditorBinary" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "availableEditors" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "binary" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "isGlobalMode" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "GlobalProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectRoot" } }] } }] } }] } }] };
const Main_ResetErrorsAndLoadConfigDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "Main_ResetErrorsAndLoadConfig" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "id" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "ID" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "resetErrorAndLoadConfig" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "id" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "id" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCTConfigured" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isE2EConfigured" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "packageManager" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingConfigFile" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingNodeEvents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isFullConfigReady" } }, { "kind": "Field", "name": { "kind": "Name", "value": "needsLegacyConfigMigration" } }, { "kind": "Field", "name": { "kind": "Name", "value": "activeBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "invokedFromCli" } }, { "kind": "Field", "name": { "kind": "Name", "value": "scaffoldedFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "description" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }, { "kind": "Field", "name": { "kind": "Name", "value": "contents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fileExtension" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "wizard" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "bundler" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "framework" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportedBundlers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "category" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "frameworks" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportStatus" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "category" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "allBundlers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "packagesToInstall" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "description" } }, { "kind": "Field", "name": { "kind": "Name", "value": "package" } }, { "kind": "Field", "name": { "kind": "Name", "value": "minVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "detectedVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "satisfied" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "installDependenciesCommand" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "baseError" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorStack" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUserCodeError" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeFrame" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "line" } }, { "kind": "Field", "name": { "kind": "Name", "value": "column" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeBlock" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "majorVersionWelcomeDismissed" } }, { "kind": "Field", "name": { "kind": "Name", "value": "wasBrowserSetInCLI" } }, { "kind": "Field", "name": { "kind": "Name", "value": "preferredEditorBinary" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "availableEditors" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "binary" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "isGlobalMode" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "GlobalProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectRoot" } }] } }] } }] } }] } }] };
const Main_LaunchProjectDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "Main_LaunchProject" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "testingType" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "TestingTypeEnum" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "launchOpenProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "setProjectPreferencesInGlobalCache" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "testingType" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "testingType" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }] } }] } }] } }] };
const GlobalPage_AddProjectDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "GlobalPage_addProject" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "path" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "open" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "Boolean" } }, "defaultValue": { "kind": "BooleanValue", "value": true } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "addProject" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "path" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "path" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "open" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "open" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "GlobalProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectRoot" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "availableEditors" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "binary" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferredEditorBinary" } }] } }] } }] } }] } }] };
const GlobalPage_RemoveProjectDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "GlobalPage_RemoveProject" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "path" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "removeProject" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "path" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "path" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "GlobalProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectRoot" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "availableEditors" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "binary" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferredEditorBinary" } }] } }] } }] } }] } }] };
const GlobalPage_OpenDirectoryInIdeDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "GlobalPage_OpenDirectoryInIDE" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "path" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "openDirectoryInIDE" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "path" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "path" } } }] }] } }] };
const GlobalPage_OpenInFinderDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "GlobalPage_OpenInFinder" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "path" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "openInFinder" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "path" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "path" } } }] }] } }] };
const GlobalProjectCard_SetCurrentProjectDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "GlobalProjectCard_setCurrentProject" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "path" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setCurrentProject" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "path" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "path" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCTConfigured" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isE2EConfigured" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "packageManager" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingConfigFile" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingNodeEvents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isFullConfigReady" } }, { "kind": "Field", "name": { "kind": "Name", "value": "needsLegacyConfigMigration" } }, { "kind": "Field", "name": { "kind": "Name", "value": "activeBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "invokedFromCli" } }, { "kind": "Field", "name": { "kind": "Name", "value": "scaffoldedFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "description" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }, { "kind": "Field", "name": { "kind": "Name", "value": "contents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fileExtension" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "wizard" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "bundler" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "framework" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportedBundlers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "category" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "frameworks" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportStatus" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "category" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "allBundlers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "packagesToInstall" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "description" } }, { "kind": "Field", "name": { "kind": "Name", "value": "package" } }, { "kind": "Field", "name": { "kind": "Name", "value": "minVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "detectedVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "satisfied" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "installDependenciesCommand" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "baseError" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorStack" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUserCodeError" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeFrame" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "line" } }, { "kind": "Field", "name": { "kind": "Name", "value": "column" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeBlock" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "majorVersionWelcomeDismissed" } }, { "kind": "Field", "name": { "kind": "Name", "value": "wasBrowserSetInCLI" } }, { "kind": "Field", "name": { "kind": "Name", "value": "preferredEditorBinary" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "availableEditors" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "binary" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "isGlobalMode" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "GlobalProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectRoot" } }] } }] } }] } }] } }] };
const MigrationWizardQueryDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "MigrationWizardQuery" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "versions" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "current" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "migration" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "filteredSteps" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCurrentStep" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCompleted" } }, { "kind": "Field", "name": { "kind": "Name", "value": "index" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "shouldMigratePreExtension" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasCustomIntegrationFolder" } }, { "kind": "Field", "name": { "kind": "Name", "value": "specFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "before" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "parts" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "text" } }, { "kind": "Field", "name": { "kind": "Name", "value": "highlight" } }, { "kind": "Field", "name": { "kind": "Name", "value": "group" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "after" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "parts" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "text" } }, { "kind": "Field", "name": { "kind": "Name", "value": "highlight" } }, { "kind": "Field", "name": { "kind": "Name", "value": "group" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "manualFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "completed" } }, { "kind": "Field", "name": { "kind": "Name", "value": "files" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }, { "kind": "Field", "name": { "kind": "Name", "value": "moved" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "before" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "parts" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "text" } }, { "kind": "Field", "name": { "kind": "Name", "value": "highlight" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "after" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "parts" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "text" } }, { "kind": "Field", "name": { "kind": "Name", "value": "highlight" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "configFileNameBefore" } }, { "kind": "Field", "name": { "kind": "Name", "value": "configFileNameAfter" } }, { "kind": "Field", "name": { "kind": "Name", "value": "configBeforeCode" } }, { "kind": "Field", "name": { "kind": "Name", "value": "configAfterCode" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasCustomIntegrationTestFiles" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasCustomComponentFolder" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasCustomComponentTestFiles" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUsingTypeScript" } }] } }] } }] };
const MigrationWizard_RenameSpecsDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "MigrationWizard_RenameSpecs" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "skip" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "Boolean" } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "before" } }, "type": { "kind": "ListType", "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "after" } }, "type": { "kind": "ListType", "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migrateRenameSpecs" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "skip" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "skip" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "before" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "before" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "after" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "after" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "baseError" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorStack" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUserCodeError" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeFrame" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "line" } }, { "kind": "Field", "name": { "kind": "Name", "value": "column" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeBlock" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "migration" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "filteredSteps" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCurrentStep" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCompleted" } }] } }] } }] } }] } }] };
const MigrationWizard_RenameSpecsFolderDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "MigrationWizard_RenameSpecsFolder" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migrateRenameSpecsFolder" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "baseError" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorStack" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUserCodeError" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeFrame" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "line" } }, { "kind": "Field", "name": { "kind": "Name", "value": "column" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeBlock" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "migration" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "configFileNameBefore" } }, { "kind": "Field", "name": { "kind": "Name", "value": "configFileNameAfter" } }, { "kind": "Field", "name": { "kind": "Name", "value": "configBeforeCode" } }, { "kind": "Field", "name": { "kind": "Name", "value": "configAfterCode" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasCustomIntegrationFolder" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasCustomIntegrationTestFiles" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasCustomComponentFolder" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasCustomComponentTestFiles" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUsingTypeScript" } }, { "kind": "Field", "name": { "kind": "Name", "value": "manualFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "completed" } }, { "kind": "Field", "name": { "kind": "Name", "value": "files" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }, { "kind": "Field", "name": { "kind": "Name", "value": "moved" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "filteredSteps" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCurrentStep" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCompleted" } }] } }] } }] } }] } }] };
const MigrationWizard_SkipManualRenameDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "MigrationWizard_SkipManualRename" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migrateSkipManualRename" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migration" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "filteredSteps" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCurrentStep" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCompleted" } }] } }] } }] } }] } }] };
const MigrationWizard_RenameSupportDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "MigrationWizard_RenameSupport" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migrateRenameSupport" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migration" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "filteredSteps" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCurrentStep" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCompleted" } }] } }] } }] } }] } }] };
const MigrationWizard_FinishedRenamingComponentSpecsDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "MigrationWizard_FinishedRenamingComponentSpecs" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "finishedRenamingComponentSpecs" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migration" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "filteredSteps" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCurrentStep" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCompleted" } }] } }] } }] } }] } }] };
const MigrationWizard_ConvertFileDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "MigrationWizard_ConvertFile" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migrateConfigFile" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migration" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "filteredSteps" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCurrentStep" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCompleted" } }] } }] } }] } }] } }] };
const MigrationWizard_ReconfigureComponentTestingDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "MigrationWizard_ReconfigureComponentTesting" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migrateComponentTesting" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "needsLegacyConfigMigration" } }] } }] } }] } }] };
const RenameSpecsManual_CloseWatcherDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "RenameSpecsManual_CloseWatcher" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "migrateCloseManualRenameWatcher" } }] } }] };
const EnvironmentSetup_WizardUpdateDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "EnvironmentSetup_wizardUpdate" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "input" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "WizardUpdateInput" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "wizardUpdate" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "input" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "input" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "bundler" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "framework" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportedBundlers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "category" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "frameworks" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportStatus" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "category" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "allBundlers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }] } }] } }] };
const EnvironmentSetup_ClearTestingTypeDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "EnvironmentSetup_ClearTestingType" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "clearCurrentTestingType" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }] } }] } }] } }] };
const InstallDependencies_ScaffoldFilesDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "InstallDependencies_scaffoldFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "scaffoldTestingType" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "scaffoldedFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "description" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }, { "kind": "Field", "name": { "kind": "Name", "value": "contents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fileExtension" } }] } }] } }] } }] } }] };
const Wizard_InstalledPackagesDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "Wizard_InstalledPackages" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "wizard" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "packagesToInstall" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "description" } }, { "kind": "Field", "name": { "kind": "Name", "value": "package" } }, { "kind": "Field", "name": { "kind": "Name", "value": "minVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "detectedVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "satisfied" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "installDependenciesCommand" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "packageManager" } }] } }] } }] };
const OpenBrowserDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "OpenBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingConfigFile" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingNodeEvents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "activeBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isFocusSupported" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "browsers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "disabled" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isVersionSupported" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "displayName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "warning" } }, { "kind": "Field", "name": { "kind": "Name", "value": "majorVersion" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "browserStatus" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }] } }] } }] };
const OpenBrowser_ClearTestingTypeDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "OpenBrowser_ClearTestingType" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "clearCurrentTestingType" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }] } }] } }] } }] };
const OpenBrowser_LaunchProjectDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "OpenBrowser_LaunchProject" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "testingType" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "TestingTypeEnum" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "launchOpenProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "setProjectPreferencesInGlobalCache" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "testingType" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "testingType" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }] } }] } }] } }] };
const OpenBrowser_CloseBrowserDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "OpenBrowser_CloseBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "closeBrowser" } }] } }] };
const OpenBrowser_FocusActiveBrowserWindowDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "OpenBrowser_FocusActiveBrowserWindow" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "focusActiveBrowserWindow" } }] } }] };
const OpenBrowser_ResetLatestVersionTelemetryDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "OpenBrowser_ResetLatestVersionTelemetry" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "resetLatestVersionTelemetry" } }] } }] };
const OpenBrowserList_SetBrowserDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "OpenBrowserList_SetBrowser" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "id" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "ID" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "launchpadSetBrowser" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "id" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "id" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "activeBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isFocusSupported" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "browsers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "disabled" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isVersionSupported" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "displayName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "warning" } }, { "kind": "Field", "name": { "kind": "Name", "value": "majorVersion" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "browserStatus" } }] } }] } }] };
const OpenBrowserList_BrowserStatusChangeDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "OpenBrowserList_browserStatusChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserStatusChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "browserStatus" } }, { "kind": "Field", "name": { "kind": "Name", "value": "activeBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isFocusSupported" } }] } }] } }] } }] };
const ScaffoldedFiles_CompleteSetupDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "ScaffoldedFiles_completeSetup" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "completeSetup" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingConfigFile" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingNodeEvents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCTConfigured" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "scaffoldedFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "status" } }] } }] } }] } }] };
const TestingTypeSelectionDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "TestingTypeSelection" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "testingType" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "TestingTypeEnum" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setAndLoadCurrentTestingType" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "testingType" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "testingType" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isCTConfigured" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isE2EConfigured" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingConfigFile" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isLoadingNodeEvents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "packageManager" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "scaffoldedFiles" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "description" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }, { "kind": "Field", "name": { "kind": "Name", "value": "contents" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fileExtension" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "wizard" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "bundler" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "framework" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportedBundlers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "category" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "frameworks" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "supportStatus" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "category" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "allBundlers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "type" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isDetected" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "packagesToInstall" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "description" } }, { "kind": "Field", "name": { "kind": "Name", "value": "package" } }, { "kind": "Field", "name": { "kind": "Name", "value": "minVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "detectedVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "satisfied" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "installDependenciesCommand" } }] } }] } }] } }] };
const WarningList_RemoveWarningDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "WarningList_removeWarning" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "id" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "ID" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "dismissWarning" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "id" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "id" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }] } }] } }] } }] };
const WarningList_PingBaseUrlDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "WarningList_pingBaseUrl" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "pingBaseUrl" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }] } }] } }] } }] };
const main$1 = "";
const windi = "";
var nodejsCustomInspectSymbol = typeof Symbol === "function" && typeof Symbol.for === "function" ? Symbol.for("nodejs.util.inspect.custom") : void 0;
const nodejsCustomInspectSymbol$1 = nodejsCustomInspectSymbol;
function _typeof$2(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof$2 = function _typeof2(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof$2 = function _typeof2(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof$2(obj);
}
var MAX_ARRAY_LENGTH = 10;
var MAX_RECURSIVE_DEPTH = 2;
function inspect(value) {
  return formatValue(value, []);
}
function formatValue(value, seenValues) {
  switch (_typeof$2(value)) {
    case "string":
      return JSON.stringify(value);
    case "function":
      return value.name ? "[function ".concat(value.name, "]") : "[function]";
    case "object":
      if (value === null) {
        return "null";
      }
      return formatObjectValue(value, seenValues);
    default:
      return String(value);
  }
}
function formatObjectValue(value, previouslySeenValues) {
  if (previouslySeenValues.indexOf(value) !== -1) {
    return "[Circular]";
  }
  var seenValues = [].concat(previouslySeenValues, [value]);
  var customInspectFn = getCustomFn(value);
  if (customInspectFn !== void 0) {
    var customValue = customInspectFn.call(value);
    if (customValue !== value) {
      return typeof customValue === "string" ? customValue : formatValue(customValue, seenValues);
    }
  } else if (Array.isArray(value)) {
    return formatArray(value, seenValues);
  }
  return formatObject(value, seenValues);
}
function formatObject(object, seenValues) {
  var keys = Object.keys(object);
  if (keys.length === 0) {
    return "{}";
  }
  if (seenValues.length > MAX_RECURSIVE_DEPTH) {
    return "[" + getObjectTag(object) + "]";
  }
  var properties = keys.map(function(key) {
    var value = formatValue(object[key], seenValues);
    return key + ": " + value;
  });
  return "{ " + properties.join(", ") + " }";
}
function formatArray(array, seenValues) {
  if (array.length === 0) {
    return "[]";
  }
  if (seenValues.length > MAX_RECURSIVE_DEPTH) {
    return "[Array]";
  }
  var len = Math.min(MAX_ARRAY_LENGTH, array.length);
  var remaining = array.length - len;
  var items = [];
  for (var i2 = 0; i2 < len; ++i2) {
    items.push(formatValue(array[i2], seenValues));
  }
  if (remaining === 1) {
    items.push("... 1 more item");
  } else if (remaining > 1) {
    items.push("... ".concat(remaining, " more items"));
  }
  return "[" + items.join(", ") + "]";
}
function getCustomFn(object) {
  var customInspectFn = object[String(nodejsCustomInspectSymbol$1)];
  if (typeof customInspectFn === "function") {
    return customInspectFn;
  }
  if (typeof object.inspect === "function") {
    return object.inspect;
  }
}
function getObjectTag(object) {
  var tag = Object.prototype.toString.call(object).replace(/^\[object /, "").replace(/]$/, "");
  if (tag === "Object" && typeof object.constructor === "function") {
    var name2 = object.constructor.name;
    if (typeof name2 === "string" && name2 !== "") {
      return name2;
    }
  }
  return tag;
}
function invariant$1(condition, message) {
  var booleanCondition = Boolean(condition);
  if (!booleanCondition) {
    throw new Error(message != null ? message : "Unexpected invariant triggered.");
  }
}
function defineInspect(classObject) {
  var fn = classObject.prototype.toJSON;
  typeof fn === "function" || invariant$1(0);
  classObject.prototype.inspect = fn;
  if (nodejsCustomInspectSymbol$1) {
    classObject.prototype[nodejsCustomInspectSymbol$1] = fn;
  }
}
var Location = /* @__PURE__ */ function() {
  function Location2(startToken, endToken, source) {
    this.start = startToken.start;
    this.end = endToken.end;
    this.startToken = startToken;
    this.endToken = endToken;
    this.source = source;
  }
  var _proto = Location2.prototype;
  _proto.toJSON = function toJSON() {
    return {
      start: this.start,
      end: this.end
    };
  };
  return Location2;
}();
defineInspect(Location);
var Token$4 = /* @__PURE__ */ function() {
  function Token2(kind, start, end, line, column, prev2, value) {
    this.kind = kind;
    this.start = start;
    this.end = end;
    this.line = line;
    this.column = column;
    this.value = value;
    this.prev = prev2;
    this.next = null;
  }
  var _proto2 = Token2.prototype;
  _proto2.toJSON = function toJSON() {
    return {
      kind: this.kind,
      value: this.value,
      line: this.line,
      column: this.column
    };
  };
  return Token2;
}();
defineInspect(Token$4);
function isNode$1(maybeNode) {
  return maybeNode != null && typeof maybeNode.kind === "string";
}
var QueryDocumentKeys = {
  Name: [],
  Document: ["definitions"],
  OperationDefinition: ["name", "variableDefinitions", "directives", "selectionSet"],
  VariableDefinition: ["variable", "type", "defaultValue", "directives"],
  Variable: ["name"],
  SelectionSet: ["selections"],
  Field: ["alias", "name", "arguments", "directives", "selectionSet"],
  Argument: ["name", "value"],
  FragmentSpread: ["name", "directives"],
  InlineFragment: ["typeCondition", "directives", "selectionSet"],
  FragmentDefinition: [
    "name",
    "variableDefinitions",
    "typeCondition",
    "directives",
    "selectionSet"
  ],
  IntValue: [],
  FloatValue: [],
  StringValue: [],
  BooleanValue: [],
  NullValue: [],
  EnumValue: [],
  ListValue: ["values"],
  ObjectValue: ["fields"],
  ObjectField: ["name", "value"],
  Directive: ["name", "arguments"],
  NamedType: ["name"],
  ListType: ["type"],
  NonNullType: ["type"],
  SchemaDefinition: ["description", "directives", "operationTypes"],
  OperationTypeDefinition: ["type"],
  ScalarTypeDefinition: ["description", "name", "directives"],
  ObjectTypeDefinition: ["description", "name", "interfaces", "directives", "fields"],
  FieldDefinition: ["description", "name", "arguments", "type", "directives"],
  InputValueDefinition: ["description", "name", "type", "defaultValue", "directives"],
  InterfaceTypeDefinition: ["description", "name", "interfaces", "directives", "fields"],
  UnionTypeDefinition: ["description", "name", "directives", "types"],
  EnumTypeDefinition: ["description", "name", "directives", "values"],
  EnumValueDefinition: ["description", "name", "directives"],
  InputObjectTypeDefinition: ["description", "name", "directives", "fields"],
  DirectiveDefinition: ["description", "name", "arguments", "locations"],
  SchemaExtension: ["directives", "operationTypes"],
  ScalarTypeExtension: ["name", "directives"],
  ObjectTypeExtension: ["name", "interfaces", "directives", "fields"],
  InterfaceTypeExtension: ["name", "interfaces", "directives", "fields"],
  UnionTypeExtension: ["name", "directives", "types"],
  EnumTypeExtension: ["name", "directives", "values"],
  InputObjectTypeExtension: ["name", "directives", "fields"]
};
var BREAK = Object.freeze({});
function visit$1(root, visitor) {
  var visitorKeys = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : QueryDocumentKeys;
  var stack2 = void 0;
  var inArray = Array.isArray(root);
  var keys = [root];
  var index2 = -1;
  var edits = [];
  var node = void 0;
  var key = void 0;
  var parent = void 0;
  var path = [];
  var ancestors = [];
  var newRoot = root;
  do {
    index2++;
    var isLeaving = index2 === keys.length;
    var isEdited = isLeaving && edits.length !== 0;
    if (isLeaving) {
      key = ancestors.length === 0 ? void 0 : path[path.length - 1];
      node = parent;
      parent = ancestors.pop();
      if (isEdited) {
        if (inArray) {
          node = node.slice();
        } else {
          var clone2 = {};
          for (var _i2 = 0, _Object$keys2 = Object.keys(node); _i2 < _Object$keys2.length; _i2++) {
            var k = _Object$keys2[_i2];
            clone2[k] = node[k];
          }
          node = clone2;
        }
        var editOffset = 0;
        for (var ii2 = 0; ii2 < edits.length; ii2++) {
          var editKey = edits[ii2][0];
          var editValue = edits[ii2][1];
          if (inArray) {
            editKey -= editOffset;
          }
          if (inArray && editValue === null) {
            node.splice(editKey, 1);
            editOffset++;
          } else {
            node[editKey] = editValue;
          }
        }
      }
      index2 = stack2.index;
      keys = stack2.keys;
      edits = stack2.edits;
      inArray = stack2.inArray;
      stack2 = stack2.prev;
    } else {
      key = parent ? inArray ? index2 : keys[index2] : void 0;
      node = parent ? parent[key] : newRoot;
      if (node === null || node === void 0) {
        continue;
      }
      if (parent) {
        path.push(key);
      }
    }
    var result = void 0;
    if (!Array.isArray(node)) {
      if (!isNode$1(node)) {
        throw new Error("Invalid AST Node: ".concat(inspect(node), "."));
      }
      var visitFn = getVisitFn(visitor, node.kind, isLeaving);
      if (visitFn) {
        result = visitFn.call(visitor, node, key, parent, path, ancestors);
        if (result === BREAK) {
          break;
        }
        if (result === false) {
          if (!isLeaving) {
            path.pop();
            continue;
          }
        } else if (result !== void 0) {
          edits.push([key, result]);
          if (!isLeaving) {
            if (isNode$1(result)) {
              node = result;
            } else {
              path.pop();
              continue;
            }
          }
        }
      }
    }
    if (result === void 0 && isEdited) {
      edits.push([key, node]);
    }
    if (isLeaving) {
      path.pop();
    } else {
      var _visitorKeys$node$kin;
      stack2 = {
        inArray,
        index: index2,
        keys,
        edits,
        prev: stack2
      };
      inArray = Array.isArray(node);
      keys = inArray ? node : (_visitorKeys$node$kin = visitorKeys[node.kind]) !== null && _visitorKeys$node$kin !== void 0 ? _visitorKeys$node$kin : [];
      index2 = -1;
      edits = [];
      if (parent) {
        ancestors.push(parent);
      }
      parent = node;
    }
  } while (stack2 !== void 0);
  if (edits.length !== 0) {
    newRoot = edits[edits.length - 1][1];
  }
  return newRoot;
}
function getVisitFn(visitor, kind, isLeaving) {
  var kindVisitor = visitor[kind];
  if (kindVisitor) {
    if (!isLeaving && typeof kindVisitor === "function") {
      return kindVisitor;
    }
    var kindSpecificVisitor = isLeaving ? kindVisitor.leave : kindVisitor.enter;
    if (typeof kindSpecificVisitor === "function") {
      return kindSpecificVisitor;
    }
  } else {
    var specificVisitor = isLeaving ? visitor.leave : visitor.enter;
    if (specificVisitor) {
      if (typeof specificVisitor === "function") {
        return specificVisitor;
      }
      var specificKindVisitor = specificVisitor[kind];
      if (typeof specificKindVisitor === "function") {
        return specificKindVisitor;
      }
    }
  }
}
var Kind = Object.freeze({
  NAME: "Name",
  DOCUMENT: "Document",
  OPERATION_DEFINITION: "OperationDefinition",
  VARIABLE_DEFINITION: "VariableDefinition",
  SELECTION_SET: "SelectionSet",
  FIELD: "Field",
  ARGUMENT: "Argument",
  FRAGMENT_SPREAD: "FragmentSpread",
  INLINE_FRAGMENT: "InlineFragment",
  FRAGMENT_DEFINITION: "FragmentDefinition",
  VARIABLE: "Variable",
  INT: "IntValue",
  FLOAT: "FloatValue",
  STRING: "StringValue",
  BOOLEAN: "BooleanValue",
  NULL: "NullValue",
  ENUM: "EnumValue",
  LIST: "ListValue",
  OBJECT: "ObjectValue",
  OBJECT_FIELD: "ObjectField",
  DIRECTIVE: "Directive",
  NAMED_TYPE: "NamedType",
  LIST_TYPE: "ListType",
  NON_NULL_TYPE: "NonNullType",
  SCHEMA_DEFINITION: "SchemaDefinition",
  OPERATION_TYPE_DEFINITION: "OperationTypeDefinition",
  SCALAR_TYPE_DEFINITION: "ScalarTypeDefinition",
  OBJECT_TYPE_DEFINITION: "ObjectTypeDefinition",
  FIELD_DEFINITION: "FieldDefinition",
  INPUT_VALUE_DEFINITION: "InputValueDefinition",
  INTERFACE_TYPE_DEFINITION: "InterfaceTypeDefinition",
  UNION_TYPE_DEFINITION: "UnionTypeDefinition",
  ENUM_TYPE_DEFINITION: "EnumTypeDefinition",
  ENUM_VALUE_DEFINITION: "EnumValueDefinition",
  INPUT_OBJECT_TYPE_DEFINITION: "InputObjectTypeDefinition",
  DIRECTIVE_DEFINITION: "DirectiveDefinition",
  SCHEMA_EXTENSION: "SchemaExtension",
  SCALAR_TYPE_EXTENSION: "ScalarTypeExtension",
  OBJECT_TYPE_EXTENSION: "ObjectTypeExtension",
  INTERFACE_TYPE_EXTENSION: "InterfaceTypeExtension",
  UNION_TYPE_EXTENSION: "UnionTypeExtension",
  ENUM_TYPE_EXTENSION: "EnumTypeExtension",
  INPUT_OBJECT_TYPE_EXTENSION: "InputObjectTypeExtension"
});
function dedentBlockStringValue(rawString) {
  var lines = rawString.split(/\r\n|[\n\r]/g);
  var commonIndent = getBlockStringIndentation(rawString);
  if (commonIndent !== 0) {
    for (var i2 = 1; i2 < lines.length; i2++) {
      lines[i2] = lines[i2].slice(commonIndent);
    }
  }
  var startLine = 0;
  while (startLine < lines.length && isBlank(lines[startLine])) {
    ++startLine;
  }
  var endLine = lines.length;
  while (endLine > startLine && isBlank(lines[endLine - 1])) {
    --endLine;
  }
  return lines.slice(startLine, endLine).join("\n");
}
function isBlank(str) {
  for (var i2 = 0; i2 < str.length; ++i2) {
    if (str[i2] !== " " && str[i2] !== "	") {
      return false;
    }
  }
  return true;
}
function getBlockStringIndentation(value) {
  var _commonIndent;
  var isFirstLine = true;
  var isEmptyLine = true;
  var indent2 = 0;
  var commonIndent = null;
  for (var i2 = 0; i2 < value.length; ++i2) {
    switch (value.charCodeAt(i2)) {
      case 13:
        if (value.charCodeAt(i2 + 1) === 10) {
          ++i2;
        }
      case 10:
        isFirstLine = false;
        isEmptyLine = true;
        indent2 = 0;
        break;
      case 9:
      case 32:
        ++indent2;
        break;
      default:
        if (isEmptyLine && !isFirstLine && (commonIndent === null || indent2 < commonIndent)) {
          commonIndent = indent2;
        }
        isEmptyLine = false;
    }
  }
  return (_commonIndent = commonIndent) !== null && _commonIndent !== void 0 ? _commonIndent : 0;
}
function printBlockString(value) {
  var indentation = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "";
  var preferMultipleLines = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
  var isSingleLine = value.indexOf("\n") === -1;
  var hasLeadingSpace = value[0] === " " || value[0] === "	";
  var hasTrailingQuote = value[value.length - 1] === '"';
  var hasTrailingSlash = value[value.length - 1] === "\\";
  var printAsMultipleLines = !isSingleLine || hasTrailingQuote || hasTrailingSlash || preferMultipleLines;
  var result = "";
  if (printAsMultipleLines && !(isSingleLine && hasLeadingSpace)) {
    result += "\n" + indentation;
  }
  result += indentation ? value.replace(/\n/g, "\n" + indentation) : value;
  if (printAsMultipleLines) {
    result += "\n";
  }
  return '"""' + result.replace(/"""/g, '\\"""') + '"""';
}
function print$1(ast2) {
  return visit$1(ast2, {
    leave: printDocASTReducer
  });
}
var MAX_LINE_LENGTH = 80;
var printDocASTReducer = {
  Name: function Name(node) {
    return node.value;
  },
  Variable: function Variable(node) {
    return "$" + node.name;
  },
  Document: function Document(node) {
    return join$1(node.definitions, "\n\n") + "\n";
  },
  OperationDefinition: function OperationDefinition(node) {
    var op = node.operation;
    var name2 = node.name;
    var varDefs = wrap("(", join$1(node.variableDefinitions, ", "), ")");
    var directives = join$1(node.directives, " ");
    var selectionSet = node.selectionSet;
    return !name2 && !directives && !varDefs && op === "query" ? selectionSet : join$1([op, join$1([name2, varDefs]), directives, selectionSet], " ");
  },
  VariableDefinition: function VariableDefinition(_ref) {
    var variable = _ref.variable, type2 = _ref.type, defaultValue = _ref.defaultValue, directives = _ref.directives;
    return variable + ": " + type2 + wrap(" = ", defaultValue) + wrap(" ", join$1(directives, " "));
  },
  SelectionSet: function SelectionSet(_ref2) {
    var selections = _ref2.selections;
    return block$2(selections);
  },
  Field: function Field(_ref3) {
    var alias = _ref3.alias, name2 = _ref3.name, args = _ref3.arguments, directives = _ref3.directives, selectionSet = _ref3.selectionSet;
    var prefix = wrap("", alias, ": ") + name2;
    var argsLine = prefix + wrap("(", join$1(args, ", "), ")");
    if (argsLine.length > MAX_LINE_LENGTH) {
      argsLine = prefix + wrap("(\n", indent(join$1(args, "\n")), "\n)");
    }
    return join$1([argsLine, join$1(directives, " "), selectionSet], " ");
  },
  Argument: function Argument(_ref4) {
    var name2 = _ref4.name, value = _ref4.value;
    return name2 + ": " + value;
  },
  FragmentSpread: function FragmentSpread(_ref5) {
    var name2 = _ref5.name, directives = _ref5.directives;
    return "..." + name2 + wrap(" ", join$1(directives, " "));
  },
  InlineFragment: function InlineFragment(_ref6) {
    var typeCondition = _ref6.typeCondition, directives = _ref6.directives, selectionSet = _ref6.selectionSet;
    return join$1(["...", wrap("on ", typeCondition), join$1(directives, " "), selectionSet], " ");
  },
  FragmentDefinition: function FragmentDefinition(_ref7) {
    var name2 = _ref7.name, typeCondition = _ref7.typeCondition, variableDefinitions = _ref7.variableDefinitions, directives = _ref7.directives, selectionSet = _ref7.selectionSet;
    return "fragment ".concat(name2).concat(wrap("(", join$1(variableDefinitions, ", "), ")"), " ") + "on ".concat(typeCondition, " ").concat(wrap("", join$1(directives, " "), " ")) + selectionSet;
  },
  IntValue: function IntValue(_ref8) {
    var value = _ref8.value;
    return value;
  },
  FloatValue: function FloatValue(_ref9) {
    var value = _ref9.value;
    return value;
  },
  StringValue: function StringValue(_ref10, key) {
    var value = _ref10.value, isBlockString = _ref10.block;
    return isBlockString ? printBlockString(value, key === "description" ? "" : "  ") : JSON.stringify(value);
  },
  BooleanValue: function BooleanValue(_ref11) {
    var value = _ref11.value;
    return value ? "true" : "false";
  },
  NullValue: function NullValue() {
    return "null";
  },
  EnumValue: function EnumValue(_ref12) {
    var value = _ref12.value;
    return value;
  },
  ListValue: function ListValue(_ref13) {
    var values = _ref13.values;
    return "[" + join$1(values, ", ") + "]";
  },
  ObjectValue: function ObjectValue(_ref14) {
    var fields = _ref14.fields;
    return "{" + join$1(fields, ", ") + "}";
  },
  ObjectField: function ObjectField(_ref15) {
    var name2 = _ref15.name, value = _ref15.value;
    return name2 + ": " + value;
  },
  Directive: function Directive(_ref16) {
    var name2 = _ref16.name, args = _ref16.arguments;
    return "@" + name2 + wrap("(", join$1(args, ", "), ")");
  },
  NamedType: function NamedType(_ref17) {
    var name2 = _ref17.name;
    return name2;
  },
  ListType: function ListType(_ref18) {
    var type2 = _ref18.type;
    return "[" + type2 + "]";
  },
  NonNullType: function NonNullType(_ref19) {
    var type2 = _ref19.type;
    return type2 + "!";
  },
  SchemaDefinition: addDescription(function(_ref20) {
    var directives = _ref20.directives, operationTypes = _ref20.operationTypes;
    return join$1(["schema", join$1(directives, " "), block$2(operationTypes)], " ");
  }),
  OperationTypeDefinition: function OperationTypeDefinition(_ref21) {
    var operation = _ref21.operation, type2 = _ref21.type;
    return operation + ": " + type2;
  },
  ScalarTypeDefinition: addDescription(function(_ref22) {
    var name2 = _ref22.name, directives = _ref22.directives;
    return join$1(["scalar", name2, join$1(directives, " ")], " ");
  }),
  ObjectTypeDefinition: addDescription(function(_ref23) {
    var name2 = _ref23.name, interfaces = _ref23.interfaces, directives = _ref23.directives, fields = _ref23.fields;
    return join$1(["type", name2, wrap("implements ", join$1(interfaces, " & ")), join$1(directives, " "), block$2(fields)], " ");
  }),
  FieldDefinition: addDescription(function(_ref24) {
    var name2 = _ref24.name, args = _ref24.arguments, type2 = _ref24.type, directives = _ref24.directives;
    return name2 + (hasMultilineItems(args) ? wrap("(\n", indent(join$1(args, "\n")), "\n)") : wrap("(", join$1(args, ", "), ")")) + ": " + type2 + wrap(" ", join$1(directives, " "));
  }),
  InputValueDefinition: addDescription(function(_ref25) {
    var name2 = _ref25.name, type2 = _ref25.type, defaultValue = _ref25.defaultValue, directives = _ref25.directives;
    return join$1([name2 + ": " + type2, wrap("= ", defaultValue), join$1(directives, " ")], " ");
  }),
  InterfaceTypeDefinition: addDescription(function(_ref26) {
    var name2 = _ref26.name, interfaces = _ref26.interfaces, directives = _ref26.directives, fields = _ref26.fields;
    return join$1(["interface", name2, wrap("implements ", join$1(interfaces, " & ")), join$1(directives, " "), block$2(fields)], " ");
  }),
  UnionTypeDefinition: addDescription(function(_ref27) {
    var name2 = _ref27.name, directives = _ref27.directives, types = _ref27.types;
    return join$1(["union", name2, join$1(directives, " "), types && types.length !== 0 ? "= " + join$1(types, " | ") : ""], " ");
  }),
  EnumTypeDefinition: addDescription(function(_ref28) {
    var name2 = _ref28.name, directives = _ref28.directives, values = _ref28.values;
    return join$1(["enum", name2, join$1(directives, " "), block$2(values)], " ");
  }),
  EnumValueDefinition: addDescription(function(_ref29) {
    var name2 = _ref29.name, directives = _ref29.directives;
    return join$1([name2, join$1(directives, " ")], " ");
  }),
  InputObjectTypeDefinition: addDescription(function(_ref30) {
    var name2 = _ref30.name, directives = _ref30.directives, fields = _ref30.fields;
    return join$1(["input", name2, join$1(directives, " "), block$2(fields)], " ");
  }),
  DirectiveDefinition: addDescription(function(_ref31) {
    var name2 = _ref31.name, args = _ref31.arguments, repeatable = _ref31.repeatable, locations = _ref31.locations;
    return "directive @" + name2 + (hasMultilineItems(args) ? wrap("(\n", indent(join$1(args, "\n")), "\n)") : wrap("(", join$1(args, ", "), ")")) + (repeatable ? " repeatable" : "") + " on " + join$1(locations, " | ");
  }),
  SchemaExtension: function SchemaExtension(_ref32) {
    var directives = _ref32.directives, operationTypes = _ref32.operationTypes;
    return join$1(["extend schema", join$1(directives, " "), block$2(operationTypes)], " ");
  },
  ScalarTypeExtension: function ScalarTypeExtension(_ref33) {
    var name2 = _ref33.name, directives = _ref33.directives;
    return join$1(["extend scalar", name2, join$1(directives, " ")], " ");
  },
  ObjectTypeExtension: function ObjectTypeExtension(_ref34) {
    var name2 = _ref34.name, interfaces = _ref34.interfaces, directives = _ref34.directives, fields = _ref34.fields;
    return join$1(["extend type", name2, wrap("implements ", join$1(interfaces, " & ")), join$1(directives, " "), block$2(fields)], " ");
  },
  InterfaceTypeExtension: function InterfaceTypeExtension(_ref35) {
    var name2 = _ref35.name, interfaces = _ref35.interfaces, directives = _ref35.directives, fields = _ref35.fields;
    return join$1(["extend interface", name2, wrap("implements ", join$1(interfaces, " & ")), join$1(directives, " "), block$2(fields)], " ");
  },
  UnionTypeExtension: function UnionTypeExtension(_ref36) {
    var name2 = _ref36.name, directives = _ref36.directives, types = _ref36.types;
    return join$1(["extend union", name2, join$1(directives, " "), types && types.length !== 0 ? "= " + join$1(types, " | ") : ""], " ");
  },
  EnumTypeExtension: function EnumTypeExtension(_ref37) {
    var name2 = _ref37.name, directives = _ref37.directives, values = _ref37.values;
    return join$1(["extend enum", name2, join$1(directives, " "), block$2(values)], " ");
  },
  InputObjectTypeExtension: function InputObjectTypeExtension(_ref38) {
    var name2 = _ref38.name, directives = _ref38.directives, fields = _ref38.fields;
    return join$1(["extend input", name2, join$1(directives, " "), block$2(fields)], " ");
  }
};
function addDescription(cb) {
  return function(node) {
    return join$1([node.description, cb(node)], "\n");
  };
}
function join$1(maybeArray) {
  var _maybeArray$filter$jo;
  var separator = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "";
  return (_maybeArray$filter$jo = maybeArray === null || maybeArray === void 0 ? void 0 : maybeArray.filter(function(x2) {
    return x2;
  }).join(separator)) !== null && _maybeArray$filter$jo !== void 0 ? _maybeArray$filter$jo : "";
}
function block$2(array) {
  return wrap("{\n", indent(join$1(array, "\n")), "\n}");
}
function wrap(start, maybeString) {
  var end = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : "";
  return maybeString != null && maybeString !== "" ? start + maybeString + end : "";
}
function indent(str) {
  return wrap("  ", str.replace(/\n/g, "\n  "));
}
function isMultiline(str) {
  return str.indexOf("\n") !== -1;
}
function hasMultilineItems(maybeArray) {
  return maybeArray != null && maybeArray.some(isMultiline);
}
function _typeof$1(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof$1 = function _typeof2(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof$1 = function _typeof2(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof$1(obj);
}
function isObjectLike(value) {
  return _typeof$1(value) == "object" && value !== null;
}
var SYMBOL_TO_STRING_TAG = typeof Symbol === "function" && Symbol.toStringTag != null ? Symbol.toStringTag : "@@toStringTag";
function getLocation(source, position) {
  var lineRegexp = /\r\n|[\n\r]/g;
  var line = 1;
  var column = position + 1;
  var match3;
  while ((match3 = lineRegexp.exec(source.body)) && match3.index < position) {
    line += 1;
    column = position + 1 - (match3.index + match3[0].length);
  }
  return {
    line,
    column
  };
}
function printLocation(location2) {
  return printSourceLocation(location2.source, getLocation(location2.source, location2.start));
}
function printSourceLocation(source, sourceLocation) {
  var firstLineColumnOffset = source.locationOffset.column - 1;
  var body = whitespace(firstLineColumnOffset) + source.body;
  var lineIndex = sourceLocation.line - 1;
  var lineOffset = source.locationOffset.line - 1;
  var lineNum = sourceLocation.line + lineOffset;
  var columnOffset = sourceLocation.line === 1 ? firstLineColumnOffset : 0;
  var columnNum = sourceLocation.column + columnOffset;
  var locationStr = "".concat(source.name, ":").concat(lineNum, ":").concat(columnNum, "\n");
  var lines = body.split(/\r\n|[\n\r]/g);
  var locationLine = lines[lineIndex];
  if (locationLine.length > 120) {
    var subLineIndex = Math.floor(columnNum / 80);
    var subLineColumnNum = columnNum % 80;
    var subLines = [];
    for (var i2 = 0; i2 < locationLine.length; i2 += 80) {
      subLines.push(locationLine.slice(i2, i2 + 80));
    }
    return locationStr + printPrefixedLines([["".concat(lineNum), subLines[0]]].concat(subLines.slice(1, subLineIndex + 1).map(function(subLine) {
      return ["", subLine];
    }), [[" ", whitespace(subLineColumnNum - 1) + "^"], ["", subLines[subLineIndex + 1]]]));
  }
  return locationStr + printPrefixedLines([
    ["".concat(lineNum - 1), lines[lineIndex - 1]],
    ["".concat(lineNum), locationLine],
    ["", whitespace(columnNum - 1) + "^"],
    ["".concat(lineNum + 1), lines[lineIndex + 1]]
  ]);
}
function printPrefixedLines(lines) {
  var existingLines = lines.filter(function(_ref) {
    _ref[0];
    var line = _ref[1];
    return line !== void 0;
  });
  var padLen = Math.max.apply(Math, existingLines.map(function(_ref2) {
    var prefix = _ref2[0];
    return prefix.length;
  }));
  return existingLines.map(function(_ref3) {
    var prefix = _ref3[0], line = _ref3[1];
    return leftPad(padLen, prefix) + (line ? " | " + line : " |");
  }).join("\n");
}
function whitespace(len) {
  return Array(len + 1).join(" ");
}
function leftPad(len, str) {
  return whitespace(len - str.length) + str;
}
function _typeof(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof2(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof = function _typeof2(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof(obj);
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties$1(target2, props) {
  for (var i2 = 0; i2 < props.length; i2++) {
    var descriptor = props[i2];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target2, descriptor.key, descriptor);
  }
}
function _createClass$1(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties$1(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties$1(Constructor, staticProps);
  return Constructor;
}
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf(subClass, superClass);
}
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
function _possibleConstructorReturn(self2, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized(self2);
}
function _assertThisInitialized(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _wrapNativeSuper(Class) {
  var _cache = typeof Map === "function" ? /* @__PURE__ */ new Map() : void 0;
  _wrapNativeSuper = function _wrapNativeSuper2(Class2) {
    if (Class2 === null || !_isNativeFunction(Class2))
      return Class2;
    if (typeof Class2 !== "function") {
      throw new TypeError("Super expression must either be null or a function");
    }
    if (typeof _cache !== "undefined") {
      if (_cache.has(Class2))
        return _cache.get(Class2);
      _cache.set(Class2, Wrapper);
    }
    function Wrapper() {
      return _construct(Class2, arguments, _getPrototypeOf(this).constructor);
    }
    Wrapper.prototype = Object.create(Class2.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } });
    return _setPrototypeOf(Wrapper, Class2);
  };
  return _wrapNativeSuper(Class);
}
function _construct(Parent, args, Class) {
  if (_isNativeReflectConstruct()) {
    _construct = Reflect.construct;
  } else {
    _construct = function _construct2(Parent2, args2, Class2) {
      var a2 = [null];
      a2.push.apply(a2, args2);
      var Constructor = Function.bind.apply(Parent2, a2);
      var instance = new Constructor();
      if (Class2)
        _setPrototypeOf(instance, Class2.prototype);
      return instance;
    };
  }
  return _construct.apply(null, arguments);
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Date.prototype.toString.call(Reflect.construct(Date, [], function() {
    }));
    return true;
  } catch (e) {
    return false;
  }
}
function _isNativeFunction(fn) {
  return Function.toString.call(fn).indexOf("[native code]") !== -1;
}
function _setPrototypeOf(o2, p2) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o3, p3) {
    o3.__proto__ = p3;
    return o3;
  };
  return _setPrototypeOf(o2, p2);
}
function _getPrototypeOf(o2) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o3) {
    return o3.__proto__ || Object.getPrototypeOf(o3);
  };
  return _getPrototypeOf(o2);
}
var GraphQLError = /* @__PURE__ */ function(_Error) {
  _inherits(GraphQLError2, _Error);
  var _super = _createSuper(GraphQLError2);
  function GraphQLError2(message, nodes, source, positions, path, originalError, extensions) {
    var _locations2, _source2, _positions2, _extensions2;
    var _this;
    _classCallCheck(this, GraphQLError2);
    _this = _super.call(this, message);
    var _nodes = Array.isArray(nodes) ? nodes.length !== 0 ? nodes : void 0 : nodes ? [nodes] : void 0;
    var _source = source;
    if (!_source && _nodes) {
      var _nodes$0$loc;
      _source = (_nodes$0$loc = _nodes[0].loc) === null || _nodes$0$loc === void 0 ? void 0 : _nodes$0$loc.source;
    }
    var _positions = positions;
    if (!_positions && _nodes) {
      _positions = _nodes.reduce(function(list3, node) {
        if (node.loc) {
          list3.push(node.loc.start);
        }
        return list3;
      }, []);
    }
    if (_positions && _positions.length === 0) {
      _positions = void 0;
    }
    var _locations;
    if (positions && source) {
      _locations = positions.map(function(pos) {
        return getLocation(source, pos);
      });
    } else if (_nodes) {
      _locations = _nodes.reduce(function(list3, node) {
        if (node.loc) {
          list3.push(getLocation(node.loc.source, node.loc.start));
        }
        return list3;
      }, []);
    }
    var _extensions = extensions;
    if (_extensions == null && originalError != null) {
      var originalExtensions = originalError.extensions;
      if (isObjectLike(originalExtensions)) {
        _extensions = originalExtensions;
      }
    }
    Object.defineProperties(_assertThisInitialized(_this), {
      name: {
        value: "GraphQLError"
      },
      message: {
        value: message,
        enumerable: true,
        writable: true
      },
      locations: {
        value: (_locations2 = _locations) !== null && _locations2 !== void 0 ? _locations2 : void 0,
        enumerable: _locations != null
      },
      path: {
        value: path !== null && path !== void 0 ? path : void 0,
        enumerable: path != null
      },
      nodes: {
        value: _nodes !== null && _nodes !== void 0 ? _nodes : void 0
      },
      source: {
        value: (_source2 = _source) !== null && _source2 !== void 0 ? _source2 : void 0
      },
      positions: {
        value: (_positions2 = _positions) !== null && _positions2 !== void 0 ? _positions2 : void 0
      },
      originalError: {
        value: originalError
      },
      extensions: {
        value: (_extensions2 = _extensions) !== null && _extensions2 !== void 0 ? _extensions2 : void 0,
        enumerable: _extensions != null
      }
    });
    if (originalError !== null && originalError !== void 0 && originalError.stack) {
      Object.defineProperty(_assertThisInitialized(_this), "stack", {
        value: originalError.stack,
        writable: true,
        configurable: true
      });
      return _possibleConstructorReturn(_this);
    }
    if (Error.captureStackTrace) {
      Error.captureStackTrace(_assertThisInitialized(_this), GraphQLError2);
    } else {
      Object.defineProperty(_assertThisInitialized(_this), "stack", {
        value: Error().stack,
        writable: true,
        configurable: true
      });
    }
    return _this;
  }
  _createClass$1(GraphQLError2, [{
    key: "toString",
    value: function toString2() {
      return printError(this);
    }
  }, {
    key: SYMBOL_TO_STRING_TAG,
    get: function get2() {
      return "Object";
    }
  }]);
  return GraphQLError2;
}(/* @__PURE__ */ _wrapNativeSuper(Error));
function printError(error2) {
  var output = error2.message;
  if (error2.nodes) {
    for (var _i2 = 0, _error$nodes2 = error2.nodes; _i2 < _error$nodes2.length; _i2++) {
      var node = _error$nodes2[_i2];
      if (node.loc) {
        output += "\n\n" + printLocation(node.loc);
      }
    }
  } else if (error2.source && error2.locations) {
    for (var _i4 = 0, _error$locations2 = error2.locations; _i4 < _error$locations2.length; _i4++) {
      var location2 = _error$locations2[_i4];
      output += "\n\n" + printSourceLocation(error2.source, location2);
    }
  }
  return output;
}
function syntaxError(source, position, description) {
  return new GraphQLError("Syntax Error: ".concat(description), void 0, source, [position]);
}
var TokenKind = Object.freeze({
  SOF: "<SOF>",
  EOF: "<EOF>",
  BANG: "!",
  DOLLAR: "$",
  AMP: "&",
  PAREN_L: "(",
  PAREN_R: ")",
  SPREAD: "...",
  COLON: ":",
  EQUALS: "=",
  AT: "@",
  BRACKET_L: "[",
  BRACKET_R: "]",
  BRACE_L: "{",
  PIPE: "|",
  BRACE_R: "}",
  NAME: "Name",
  INT: "Int",
  FLOAT: "Float",
  STRING: "String",
  BLOCK_STRING: "BlockString",
  COMMENT: "Comment"
});
function devAssert(condition, message) {
  var booleanCondition = Boolean(condition);
  if (!booleanCondition) {
    throw new Error(message);
  }
}
const instanceOf = function instanceOf2(value, constructor) {
  return value instanceof constructor;
};
function _defineProperties(target2, props) {
  for (var i2 = 0; i2 < props.length; i2++) {
    var descriptor = props[i2];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target2, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  return Constructor;
}
var Source = /* @__PURE__ */ function() {
  function Source2(body) {
    var name2 = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "GraphQL request";
    var locationOffset = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {
      line: 1,
      column: 1
    };
    typeof body === "string" || devAssert(0, "Body must be a string. Received: ".concat(inspect(body), "."));
    this.body = body;
    this.name = name2;
    this.locationOffset = locationOffset;
    this.locationOffset.line > 0 || devAssert(0, "line in locationOffset is 1-indexed and must be positive.");
    this.locationOffset.column > 0 || devAssert(0, "column in locationOffset is 1-indexed and must be positive.");
  }
  _createClass(Source2, [{
    key: SYMBOL_TO_STRING_TAG,
    get: function get2() {
      return "Source";
    }
  }]);
  return Source2;
}();
function isSource(source) {
  return instanceOf(source, Source);
}
var DirectiveLocation = Object.freeze({
  QUERY: "QUERY",
  MUTATION: "MUTATION",
  SUBSCRIPTION: "SUBSCRIPTION",
  FIELD: "FIELD",
  FRAGMENT_DEFINITION: "FRAGMENT_DEFINITION",
  FRAGMENT_SPREAD: "FRAGMENT_SPREAD",
  INLINE_FRAGMENT: "INLINE_FRAGMENT",
  VARIABLE_DEFINITION: "VARIABLE_DEFINITION",
  SCHEMA: "SCHEMA",
  SCALAR: "SCALAR",
  OBJECT: "OBJECT",
  FIELD_DEFINITION: "FIELD_DEFINITION",
  ARGUMENT_DEFINITION: "ARGUMENT_DEFINITION",
  INTERFACE: "INTERFACE",
  UNION: "UNION",
  ENUM: "ENUM",
  ENUM_VALUE: "ENUM_VALUE",
  INPUT_OBJECT: "INPUT_OBJECT",
  INPUT_FIELD_DEFINITION: "INPUT_FIELD_DEFINITION"
});
var Lexer = /* @__PURE__ */ function() {
  function Lexer2(source) {
    var startOfFileToken = new Token$4(TokenKind.SOF, 0, 0, 0, 0, null);
    this.source = source;
    this.lastToken = startOfFileToken;
    this.token = startOfFileToken;
    this.line = 1;
    this.lineStart = 0;
  }
  var _proto = Lexer2.prototype;
  _proto.advance = function advance() {
    this.lastToken = this.token;
    var token2 = this.token = this.lookahead();
    return token2;
  };
  _proto.lookahead = function lookahead() {
    var token2 = this.token;
    if (token2.kind !== TokenKind.EOF) {
      do {
        var _token$next;
        token2 = (_token$next = token2.next) !== null && _token$next !== void 0 ? _token$next : token2.next = readToken(this, token2);
      } while (token2.kind === TokenKind.COMMENT);
    }
    return token2;
  };
  return Lexer2;
}();
function isPunctuatorTokenKind(kind) {
  return kind === TokenKind.BANG || kind === TokenKind.DOLLAR || kind === TokenKind.AMP || kind === TokenKind.PAREN_L || kind === TokenKind.PAREN_R || kind === TokenKind.SPREAD || kind === TokenKind.COLON || kind === TokenKind.EQUALS || kind === TokenKind.AT || kind === TokenKind.BRACKET_L || kind === TokenKind.BRACKET_R || kind === TokenKind.BRACE_L || kind === TokenKind.PIPE || kind === TokenKind.BRACE_R;
}
function printCharCode(code3) {
  return isNaN(code3) ? TokenKind.EOF : code3 < 127 ? JSON.stringify(String.fromCharCode(code3)) : '"\\u'.concat(("00" + code3.toString(16).toUpperCase()).slice(-4), '"');
}
function readToken(lexer, prev2) {
  var source = lexer.source;
  var body = source.body;
  var bodyLength = body.length;
  var pos = prev2.end;
  while (pos < bodyLength) {
    var code3 = body.charCodeAt(pos);
    var _line = lexer.line;
    var _col = 1 + pos - lexer.lineStart;
    switch (code3) {
      case 65279:
      case 9:
      case 32:
      case 44:
        ++pos;
        continue;
      case 10:
        ++pos;
        ++lexer.line;
        lexer.lineStart = pos;
        continue;
      case 13:
        if (body.charCodeAt(pos + 1) === 10) {
          pos += 2;
        } else {
          ++pos;
        }
        ++lexer.line;
        lexer.lineStart = pos;
        continue;
      case 33:
        return new Token$4(TokenKind.BANG, pos, pos + 1, _line, _col, prev2);
      case 35:
        return readComment(source, pos, _line, _col, prev2);
      case 36:
        return new Token$4(TokenKind.DOLLAR, pos, pos + 1, _line, _col, prev2);
      case 38:
        return new Token$4(TokenKind.AMP, pos, pos + 1, _line, _col, prev2);
      case 40:
        return new Token$4(TokenKind.PAREN_L, pos, pos + 1, _line, _col, prev2);
      case 41:
        return new Token$4(TokenKind.PAREN_R, pos, pos + 1, _line, _col, prev2);
      case 46:
        if (body.charCodeAt(pos + 1) === 46 && body.charCodeAt(pos + 2) === 46) {
          return new Token$4(TokenKind.SPREAD, pos, pos + 3, _line, _col, prev2);
        }
        break;
      case 58:
        return new Token$4(TokenKind.COLON, pos, pos + 1, _line, _col, prev2);
      case 61:
        return new Token$4(TokenKind.EQUALS, pos, pos + 1, _line, _col, prev2);
      case 64:
        return new Token$4(TokenKind.AT, pos, pos + 1, _line, _col, prev2);
      case 91:
        return new Token$4(TokenKind.BRACKET_L, pos, pos + 1, _line, _col, prev2);
      case 93:
        return new Token$4(TokenKind.BRACKET_R, pos, pos + 1, _line, _col, prev2);
      case 123:
        return new Token$4(TokenKind.BRACE_L, pos, pos + 1, _line, _col, prev2);
      case 124:
        return new Token$4(TokenKind.PIPE, pos, pos + 1, _line, _col, prev2);
      case 125:
        return new Token$4(TokenKind.BRACE_R, pos, pos + 1, _line, _col, prev2);
      case 34:
        if (body.charCodeAt(pos + 1) === 34 && body.charCodeAt(pos + 2) === 34) {
          return readBlockString(source, pos, _line, _col, prev2, lexer);
        }
        return readString(source, pos, _line, _col, prev2);
      case 45:
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
        return readNumber(source, pos, code3, _line, _col, prev2);
      case 65:
      case 66:
      case 67:
      case 68:
      case 69:
      case 70:
      case 71:
      case 72:
      case 73:
      case 74:
      case 75:
      case 76:
      case 77:
      case 78:
      case 79:
      case 80:
      case 81:
      case 82:
      case 83:
      case 84:
      case 85:
      case 86:
      case 87:
      case 88:
      case 89:
      case 90:
      case 95:
      case 97:
      case 98:
      case 99:
      case 100:
      case 101:
      case 102:
      case 103:
      case 104:
      case 105:
      case 106:
      case 107:
      case 108:
      case 109:
      case 110:
      case 111:
      case 112:
      case 113:
      case 114:
      case 115:
      case 116:
      case 117:
      case 118:
      case 119:
      case 120:
      case 121:
      case 122:
        return readName(source, pos, _line, _col, prev2);
    }
    throw syntaxError(source, pos, unexpectedCharacterMessage(code3));
  }
  var line = lexer.line;
  var col = 1 + pos - lexer.lineStart;
  return new Token$4(TokenKind.EOF, bodyLength, bodyLength, line, col, prev2);
}
function unexpectedCharacterMessage(code3) {
  if (code3 < 32 && code3 !== 9 && code3 !== 10 && code3 !== 13) {
    return "Cannot contain the invalid character ".concat(printCharCode(code3), ".");
  }
  if (code3 === 39) {
    return `Unexpected single quote character ('), did you mean to use a double quote (")?`;
  }
  return "Cannot parse the unexpected character ".concat(printCharCode(code3), ".");
}
function readComment(source, start, line, col, prev2) {
  var body = source.body;
  var code3;
  var position = start;
  do {
    code3 = body.charCodeAt(++position);
  } while (!isNaN(code3) && (code3 > 31 || code3 === 9));
  return new Token$4(TokenKind.COMMENT, start, position, line, col, prev2, body.slice(start + 1, position));
}
function readNumber(source, start, firstCode, line, col, prev2) {
  var body = source.body;
  var code3 = firstCode;
  var position = start;
  var isFloat = false;
  if (code3 === 45) {
    code3 = body.charCodeAt(++position);
  }
  if (code3 === 48) {
    code3 = body.charCodeAt(++position);
    if (code3 >= 48 && code3 <= 57) {
      throw syntaxError(source, position, "Invalid number, unexpected digit after 0: ".concat(printCharCode(code3), "."));
    }
  } else {
    position = readDigits(source, position, code3);
    code3 = body.charCodeAt(position);
  }
  if (code3 === 46) {
    isFloat = true;
    code3 = body.charCodeAt(++position);
    position = readDigits(source, position, code3);
    code3 = body.charCodeAt(position);
  }
  if (code3 === 69 || code3 === 101) {
    isFloat = true;
    code3 = body.charCodeAt(++position);
    if (code3 === 43 || code3 === 45) {
      code3 = body.charCodeAt(++position);
    }
    position = readDigits(source, position, code3);
    code3 = body.charCodeAt(position);
  }
  if (code3 === 46 || isNameStart(code3)) {
    throw syntaxError(source, position, "Invalid number, expected digit but got: ".concat(printCharCode(code3), "."));
  }
  return new Token$4(isFloat ? TokenKind.FLOAT : TokenKind.INT, start, position, line, col, prev2, body.slice(start, position));
}
function readDigits(source, start, firstCode) {
  var body = source.body;
  var position = start;
  var code3 = firstCode;
  if (code3 >= 48 && code3 <= 57) {
    do {
      code3 = body.charCodeAt(++position);
    } while (code3 >= 48 && code3 <= 57);
    return position;
  }
  throw syntaxError(source, position, "Invalid number, expected digit but got: ".concat(printCharCode(code3), "."));
}
function readString(source, start, line, col, prev2) {
  var body = source.body;
  var position = start + 1;
  var chunkStart = position;
  var code3 = 0;
  var value = "";
  while (position < body.length && !isNaN(code3 = body.charCodeAt(position)) && code3 !== 10 && code3 !== 13) {
    if (code3 === 34) {
      value += body.slice(chunkStart, position);
      return new Token$4(TokenKind.STRING, start, position + 1, line, col, prev2, value);
    }
    if (code3 < 32 && code3 !== 9) {
      throw syntaxError(source, position, "Invalid character within String: ".concat(printCharCode(code3), "."));
    }
    ++position;
    if (code3 === 92) {
      value += body.slice(chunkStart, position - 1);
      code3 = body.charCodeAt(position);
      switch (code3) {
        case 34:
          value += '"';
          break;
        case 47:
          value += "/";
          break;
        case 92:
          value += "\\";
          break;
        case 98:
          value += "\b";
          break;
        case 102:
          value += "\f";
          break;
        case 110:
          value += "\n";
          break;
        case 114:
          value += "\r";
          break;
        case 116:
          value += "	";
          break;
        case 117: {
          var charCode = uniCharCode(body.charCodeAt(position + 1), body.charCodeAt(position + 2), body.charCodeAt(position + 3), body.charCodeAt(position + 4));
          if (charCode < 0) {
            var invalidSequence = body.slice(position + 1, position + 5);
            throw syntaxError(source, position, "Invalid character escape sequence: \\u".concat(invalidSequence, "."));
          }
          value += String.fromCharCode(charCode);
          position += 4;
          break;
        }
        default:
          throw syntaxError(source, position, "Invalid character escape sequence: \\".concat(String.fromCharCode(code3), "."));
      }
      ++position;
      chunkStart = position;
    }
  }
  throw syntaxError(source, position, "Unterminated string.");
}
function readBlockString(source, start, line, col, prev2, lexer) {
  var body = source.body;
  var position = start + 3;
  var chunkStart = position;
  var code3 = 0;
  var rawValue = "";
  while (position < body.length && !isNaN(code3 = body.charCodeAt(position))) {
    if (code3 === 34 && body.charCodeAt(position + 1) === 34 && body.charCodeAt(position + 2) === 34) {
      rawValue += body.slice(chunkStart, position);
      return new Token$4(TokenKind.BLOCK_STRING, start, position + 3, line, col, prev2, dedentBlockStringValue(rawValue));
    }
    if (code3 < 32 && code3 !== 9 && code3 !== 10 && code3 !== 13) {
      throw syntaxError(source, position, "Invalid character within String: ".concat(printCharCode(code3), "."));
    }
    if (code3 === 10) {
      ++position;
      ++lexer.line;
      lexer.lineStart = position;
    } else if (code3 === 13) {
      if (body.charCodeAt(position + 1) === 10) {
        position += 2;
      } else {
        ++position;
      }
      ++lexer.line;
      lexer.lineStart = position;
    } else if (code3 === 92 && body.charCodeAt(position + 1) === 34 && body.charCodeAt(position + 2) === 34 && body.charCodeAt(position + 3) === 34) {
      rawValue += body.slice(chunkStart, position) + '"""';
      position += 4;
      chunkStart = position;
    } else {
      ++position;
    }
  }
  throw syntaxError(source, position, "Unterminated string.");
}
function uniCharCode(a2, b2, c2, d2) {
  return char2hex(a2) << 12 | char2hex(b2) << 8 | char2hex(c2) << 4 | char2hex(d2);
}
function char2hex(a2) {
  return a2 >= 48 && a2 <= 57 ? a2 - 48 : a2 >= 65 && a2 <= 70 ? a2 - 55 : a2 >= 97 && a2 <= 102 ? a2 - 87 : -1;
}
function readName(source, start, line, col, prev2) {
  var body = source.body;
  var bodyLength = body.length;
  var position = start + 1;
  var code3 = 0;
  while (position !== bodyLength && !isNaN(code3 = body.charCodeAt(position)) && (code3 === 95 || code3 >= 48 && code3 <= 57 || code3 >= 65 && code3 <= 90 || code3 >= 97 && code3 <= 122)) {
    ++position;
  }
  return new Token$4(TokenKind.NAME, start, position, line, col, prev2, body.slice(start, position));
}
function isNameStart(code3) {
  return code3 === 95 || code3 >= 65 && code3 <= 90 || code3 >= 97 && code3 <= 122;
}
function parse$4(source, options2) {
  var parser2 = new Parser(source, options2);
  return parser2.parseDocument();
}
var Parser = /* @__PURE__ */ function() {
  function Parser2(source, options2) {
    var sourceObj = isSource(source) ? source : new Source(source);
    this._lexer = new Lexer(sourceObj);
    this._options = options2;
  }
  var _proto = Parser2.prototype;
  _proto.parseName = function parseName2() {
    var token2 = this.expectToken(TokenKind.NAME);
    return {
      kind: Kind.NAME,
      value: token2.value,
      loc: this.loc(token2)
    };
  };
  _proto.parseDocument = function parseDocument() {
    var start = this._lexer.token;
    return {
      kind: Kind.DOCUMENT,
      definitions: this.many(TokenKind.SOF, this.parseDefinition, TokenKind.EOF),
      loc: this.loc(start)
    };
  };
  _proto.parseDefinition = function parseDefinition() {
    if (this.peek(TokenKind.NAME)) {
      switch (this._lexer.token.value) {
        case "query":
        case "mutation":
        case "subscription":
          return this.parseOperationDefinition();
        case "fragment":
          return this.parseFragmentDefinition();
        case "schema":
        case "scalar":
        case "type":
        case "interface":
        case "union":
        case "enum":
        case "input":
        case "directive":
          return this.parseTypeSystemDefinition();
        case "extend":
          return this.parseTypeSystemExtension();
      }
    } else if (this.peek(TokenKind.BRACE_L)) {
      return this.parseOperationDefinition();
    } else if (this.peekDescription()) {
      return this.parseTypeSystemDefinition();
    }
    throw this.unexpected();
  };
  _proto.parseOperationDefinition = function parseOperationDefinition() {
    var start = this._lexer.token;
    if (this.peek(TokenKind.BRACE_L)) {
      return {
        kind: Kind.OPERATION_DEFINITION,
        operation: "query",
        name: void 0,
        variableDefinitions: [],
        directives: [],
        selectionSet: this.parseSelectionSet(),
        loc: this.loc(start)
      };
    }
    var operation = this.parseOperationType();
    var name2;
    if (this.peek(TokenKind.NAME)) {
      name2 = this.parseName();
    }
    return {
      kind: Kind.OPERATION_DEFINITION,
      operation,
      name: name2,
      variableDefinitions: this.parseVariableDefinitions(),
      directives: this.parseDirectives(false),
      selectionSet: this.parseSelectionSet(),
      loc: this.loc(start)
    };
  };
  _proto.parseOperationType = function parseOperationType() {
    var operationToken = this.expectToken(TokenKind.NAME);
    switch (operationToken.value) {
      case "query":
        return "query";
      case "mutation":
        return "mutation";
      case "subscription":
        return "subscription";
    }
    throw this.unexpected(operationToken);
  };
  _proto.parseVariableDefinitions = function parseVariableDefinitions() {
    return this.optionalMany(TokenKind.PAREN_L, this.parseVariableDefinition, TokenKind.PAREN_R);
  };
  _proto.parseVariableDefinition = function parseVariableDefinition() {
    var start = this._lexer.token;
    return {
      kind: Kind.VARIABLE_DEFINITION,
      variable: this.parseVariable(),
      type: (this.expectToken(TokenKind.COLON), this.parseTypeReference()),
      defaultValue: this.expectOptionalToken(TokenKind.EQUALS) ? this.parseValueLiteral(true) : void 0,
      directives: this.parseDirectives(true),
      loc: this.loc(start)
    };
  };
  _proto.parseVariable = function parseVariable() {
    var start = this._lexer.token;
    this.expectToken(TokenKind.DOLLAR);
    return {
      kind: Kind.VARIABLE,
      name: this.parseName(),
      loc: this.loc(start)
    };
  };
  _proto.parseSelectionSet = function parseSelectionSet() {
    var start = this._lexer.token;
    return {
      kind: Kind.SELECTION_SET,
      selections: this.many(TokenKind.BRACE_L, this.parseSelection, TokenKind.BRACE_R),
      loc: this.loc(start)
    };
  };
  _proto.parseSelection = function parseSelection() {
    return this.peek(TokenKind.SPREAD) ? this.parseFragment() : this.parseField();
  };
  _proto.parseField = function parseField() {
    var start = this._lexer.token;
    var nameOrAlias = this.parseName();
    var alias;
    var name2;
    if (this.expectOptionalToken(TokenKind.COLON)) {
      alias = nameOrAlias;
      name2 = this.parseName();
    } else {
      name2 = nameOrAlias;
    }
    return {
      kind: Kind.FIELD,
      alias,
      name: name2,
      arguments: this.parseArguments(false),
      directives: this.parseDirectives(false),
      selectionSet: this.peek(TokenKind.BRACE_L) ? this.parseSelectionSet() : void 0,
      loc: this.loc(start)
    };
  };
  _proto.parseArguments = function parseArguments(isConst) {
    var item = isConst ? this.parseConstArgument : this.parseArgument;
    return this.optionalMany(TokenKind.PAREN_L, item, TokenKind.PAREN_R);
  };
  _proto.parseArgument = function parseArgument() {
    var start = this._lexer.token;
    var name2 = this.parseName();
    this.expectToken(TokenKind.COLON);
    return {
      kind: Kind.ARGUMENT,
      name: name2,
      value: this.parseValueLiteral(false),
      loc: this.loc(start)
    };
  };
  _proto.parseConstArgument = function parseConstArgument() {
    var start = this._lexer.token;
    return {
      kind: Kind.ARGUMENT,
      name: this.parseName(),
      value: (this.expectToken(TokenKind.COLON), this.parseValueLiteral(true)),
      loc: this.loc(start)
    };
  };
  _proto.parseFragment = function parseFragment() {
    var start = this._lexer.token;
    this.expectToken(TokenKind.SPREAD);
    var hasTypeCondition = this.expectOptionalKeyword("on");
    if (!hasTypeCondition && this.peek(TokenKind.NAME)) {
      return {
        kind: Kind.FRAGMENT_SPREAD,
        name: this.parseFragmentName(),
        directives: this.parseDirectives(false),
        loc: this.loc(start)
      };
    }
    return {
      kind: Kind.INLINE_FRAGMENT,
      typeCondition: hasTypeCondition ? this.parseNamedType() : void 0,
      directives: this.parseDirectives(false),
      selectionSet: this.parseSelectionSet(),
      loc: this.loc(start)
    };
  };
  _proto.parseFragmentDefinition = function parseFragmentDefinition() {
    var _this$_options;
    var start = this._lexer.token;
    this.expectKeyword("fragment");
    if (((_this$_options = this._options) === null || _this$_options === void 0 ? void 0 : _this$_options.experimentalFragmentVariables) === true) {
      return {
        kind: Kind.FRAGMENT_DEFINITION,
        name: this.parseFragmentName(),
        variableDefinitions: this.parseVariableDefinitions(),
        typeCondition: (this.expectKeyword("on"), this.parseNamedType()),
        directives: this.parseDirectives(false),
        selectionSet: this.parseSelectionSet(),
        loc: this.loc(start)
      };
    }
    return {
      kind: Kind.FRAGMENT_DEFINITION,
      name: this.parseFragmentName(),
      typeCondition: (this.expectKeyword("on"), this.parseNamedType()),
      directives: this.parseDirectives(false),
      selectionSet: this.parseSelectionSet(),
      loc: this.loc(start)
    };
  };
  _proto.parseFragmentName = function parseFragmentName() {
    if (this._lexer.token.value === "on") {
      throw this.unexpected();
    }
    return this.parseName();
  };
  _proto.parseValueLiteral = function parseValueLiteral(isConst) {
    var token2 = this._lexer.token;
    switch (token2.kind) {
      case TokenKind.BRACKET_L:
        return this.parseList(isConst);
      case TokenKind.BRACE_L:
        return this.parseObject(isConst);
      case TokenKind.INT:
        this._lexer.advance();
        return {
          kind: Kind.INT,
          value: token2.value,
          loc: this.loc(token2)
        };
      case TokenKind.FLOAT:
        this._lexer.advance();
        return {
          kind: Kind.FLOAT,
          value: token2.value,
          loc: this.loc(token2)
        };
      case TokenKind.STRING:
      case TokenKind.BLOCK_STRING:
        return this.parseStringLiteral();
      case TokenKind.NAME:
        this._lexer.advance();
        switch (token2.value) {
          case "true":
            return {
              kind: Kind.BOOLEAN,
              value: true,
              loc: this.loc(token2)
            };
          case "false":
            return {
              kind: Kind.BOOLEAN,
              value: false,
              loc: this.loc(token2)
            };
          case "null":
            return {
              kind: Kind.NULL,
              loc: this.loc(token2)
            };
          default:
            return {
              kind: Kind.ENUM,
              value: token2.value,
              loc: this.loc(token2)
            };
        }
      case TokenKind.DOLLAR:
        if (!isConst) {
          return this.parseVariable();
        }
        break;
    }
    throw this.unexpected();
  };
  _proto.parseStringLiteral = function parseStringLiteral() {
    var token2 = this._lexer.token;
    this._lexer.advance();
    return {
      kind: Kind.STRING,
      value: token2.value,
      block: token2.kind === TokenKind.BLOCK_STRING,
      loc: this.loc(token2)
    };
  };
  _proto.parseList = function parseList(isConst) {
    var _this = this;
    var start = this._lexer.token;
    var item = function item2() {
      return _this.parseValueLiteral(isConst);
    };
    return {
      kind: Kind.LIST,
      values: this.any(TokenKind.BRACKET_L, item, TokenKind.BRACKET_R),
      loc: this.loc(start)
    };
  };
  _proto.parseObject = function parseObject(isConst) {
    var _this2 = this;
    var start = this._lexer.token;
    var item = function item2() {
      return _this2.parseObjectField(isConst);
    };
    return {
      kind: Kind.OBJECT,
      fields: this.any(TokenKind.BRACE_L, item, TokenKind.BRACE_R),
      loc: this.loc(start)
    };
  };
  _proto.parseObjectField = function parseObjectField(isConst) {
    var start = this._lexer.token;
    var name2 = this.parseName();
    this.expectToken(TokenKind.COLON);
    return {
      kind: Kind.OBJECT_FIELD,
      name: name2,
      value: this.parseValueLiteral(isConst),
      loc: this.loc(start)
    };
  };
  _proto.parseDirectives = function parseDirectives(isConst) {
    var directives = [];
    while (this.peek(TokenKind.AT)) {
      directives.push(this.parseDirective(isConst));
    }
    return directives;
  };
  _proto.parseDirective = function parseDirective(isConst) {
    var start = this._lexer.token;
    this.expectToken(TokenKind.AT);
    return {
      kind: Kind.DIRECTIVE,
      name: this.parseName(),
      arguments: this.parseArguments(isConst),
      loc: this.loc(start)
    };
  };
  _proto.parseTypeReference = function parseTypeReference() {
    var start = this._lexer.token;
    var type2;
    if (this.expectOptionalToken(TokenKind.BRACKET_L)) {
      type2 = this.parseTypeReference();
      this.expectToken(TokenKind.BRACKET_R);
      type2 = {
        kind: Kind.LIST_TYPE,
        type: type2,
        loc: this.loc(start)
      };
    } else {
      type2 = this.parseNamedType();
    }
    if (this.expectOptionalToken(TokenKind.BANG)) {
      return {
        kind: Kind.NON_NULL_TYPE,
        type: type2,
        loc: this.loc(start)
      };
    }
    return type2;
  };
  _proto.parseNamedType = function parseNamedType() {
    var start = this._lexer.token;
    return {
      kind: Kind.NAMED_TYPE,
      name: this.parseName(),
      loc: this.loc(start)
    };
  };
  _proto.parseTypeSystemDefinition = function parseTypeSystemDefinition() {
    var keywordToken = this.peekDescription() ? this._lexer.lookahead() : this._lexer.token;
    if (keywordToken.kind === TokenKind.NAME) {
      switch (keywordToken.value) {
        case "schema":
          return this.parseSchemaDefinition();
        case "scalar":
          return this.parseScalarTypeDefinition();
        case "type":
          return this.parseObjectTypeDefinition();
        case "interface":
          return this.parseInterfaceTypeDefinition();
        case "union":
          return this.parseUnionTypeDefinition();
        case "enum":
          return this.parseEnumTypeDefinition();
        case "input":
          return this.parseInputObjectTypeDefinition();
        case "directive":
          return this.parseDirectiveDefinition();
      }
    }
    throw this.unexpected(keywordToken);
  };
  _proto.peekDescription = function peekDescription() {
    return this.peek(TokenKind.STRING) || this.peek(TokenKind.BLOCK_STRING);
  };
  _proto.parseDescription = function parseDescription() {
    if (this.peekDescription()) {
      return this.parseStringLiteral();
    }
  };
  _proto.parseSchemaDefinition = function parseSchemaDefinition() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("schema");
    var directives = this.parseDirectives(true);
    var operationTypes = this.many(TokenKind.BRACE_L, this.parseOperationTypeDefinition, TokenKind.BRACE_R);
    return {
      kind: Kind.SCHEMA_DEFINITION,
      description,
      directives,
      operationTypes,
      loc: this.loc(start)
    };
  };
  _proto.parseOperationTypeDefinition = function parseOperationTypeDefinition() {
    var start = this._lexer.token;
    var operation = this.parseOperationType();
    this.expectToken(TokenKind.COLON);
    var type2 = this.parseNamedType();
    return {
      kind: Kind.OPERATION_TYPE_DEFINITION,
      operation,
      type: type2,
      loc: this.loc(start)
    };
  };
  _proto.parseScalarTypeDefinition = function parseScalarTypeDefinition() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("scalar");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    return {
      kind: Kind.SCALAR_TYPE_DEFINITION,
      description,
      name: name2,
      directives,
      loc: this.loc(start)
    };
  };
  _proto.parseObjectTypeDefinition = function parseObjectTypeDefinition() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("type");
    var name2 = this.parseName();
    var interfaces = this.parseImplementsInterfaces();
    var directives = this.parseDirectives(true);
    var fields = this.parseFieldsDefinition();
    return {
      kind: Kind.OBJECT_TYPE_DEFINITION,
      description,
      name: name2,
      interfaces,
      directives,
      fields,
      loc: this.loc(start)
    };
  };
  _proto.parseImplementsInterfaces = function parseImplementsInterfaces() {
    var _this$_options2;
    if (!this.expectOptionalKeyword("implements")) {
      return [];
    }
    if (((_this$_options2 = this._options) === null || _this$_options2 === void 0 ? void 0 : _this$_options2.allowLegacySDLImplementsInterfaces) === true) {
      var types = [];
      this.expectOptionalToken(TokenKind.AMP);
      do {
        types.push(this.parseNamedType());
      } while (this.expectOptionalToken(TokenKind.AMP) || this.peek(TokenKind.NAME));
      return types;
    }
    return this.delimitedMany(TokenKind.AMP, this.parseNamedType);
  };
  _proto.parseFieldsDefinition = function parseFieldsDefinition() {
    var _this$_options3;
    if (((_this$_options3 = this._options) === null || _this$_options3 === void 0 ? void 0 : _this$_options3.allowLegacySDLEmptyFields) === true && this.peek(TokenKind.BRACE_L) && this._lexer.lookahead().kind === TokenKind.BRACE_R) {
      this._lexer.advance();
      this._lexer.advance();
      return [];
    }
    return this.optionalMany(TokenKind.BRACE_L, this.parseFieldDefinition, TokenKind.BRACE_R);
  };
  _proto.parseFieldDefinition = function parseFieldDefinition() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    var name2 = this.parseName();
    var args = this.parseArgumentDefs();
    this.expectToken(TokenKind.COLON);
    var type2 = this.parseTypeReference();
    var directives = this.parseDirectives(true);
    return {
      kind: Kind.FIELD_DEFINITION,
      description,
      name: name2,
      arguments: args,
      type: type2,
      directives,
      loc: this.loc(start)
    };
  };
  _proto.parseArgumentDefs = function parseArgumentDefs() {
    return this.optionalMany(TokenKind.PAREN_L, this.parseInputValueDef, TokenKind.PAREN_R);
  };
  _proto.parseInputValueDef = function parseInputValueDef() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    var name2 = this.parseName();
    this.expectToken(TokenKind.COLON);
    var type2 = this.parseTypeReference();
    var defaultValue;
    if (this.expectOptionalToken(TokenKind.EQUALS)) {
      defaultValue = this.parseValueLiteral(true);
    }
    var directives = this.parseDirectives(true);
    return {
      kind: Kind.INPUT_VALUE_DEFINITION,
      description,
      name: name2,
      type: type2,
      defaultValue,
      directives,
      loc: this.loc(start)
    };
  };
  _proto.parseInterfaceTypeDefinition = function parseInterfaceTypeDefinition() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("interface");
    var name2 = this.parseName();
    var interfaces = this.parseImplementsInterfaces();
    var directives = this.parseDirectives(true);
    var fields = this.parseFieldsDefinition();
    return {
      kind: Kind.INTERFACE_TYPE_DEFINITION,
      description,
      name: name2,
      interfaces,
      directives,
      fields,
      loc: this.loc(start)
    };
  };
  _proto.parseUnionTypeDefinition = function parseUnionTypeDefinition() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("union");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var types = this.parseUnionMemberTypes();
    return {
      kind: Kind.UNION_TYPE_DEFINITION,
      description,
      name: name2,
      directives,
      types,
      loc: this.loc(start)
    };
  };
  _proto.parseUnionMemberTypes = function parseUnionMemberTypes() {
    return this.expectOptionalToken(TokenKind.EQUALS) ? this.delimitedMany(TokenKind.PIPE, this.parseNamedType) : [];
  };
  _proto.parseEnumTypeDefinition = function parseEnumTypeDefinition() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("enum");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var values = this.parseEnumValuesDefinition();
    return {
      kind: Kind.ENUM_TYPE_DEFINITION,
      description,
      name: name2,
      directives,
      values,
      loc: this.loc(start)
    };
  };
  _proto.parseEnumValuesDefinition = function parseEnumValuesDefinition() {
    return this.optionalMany(TokenKind.BRACE_L, this.parseEnumValueDefinition, TokenKind.BRACE_R);
  };
  _proto.parseEnumValueDefinition = function parseEnumValueDefinition() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    return {
      kind: Kind.ENUM_VALUE_DEFINITION,
      description,
      name: name2,
      directives,
      loc: this.loc(start)
    };
  };
  _proto.parseInputObjectTypeDefinition = function parseInputObjectTypeDefinition() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("input");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var fields = this.parseInputFieldsDefinition();
    return {
      kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
      description,
      name: name2,
      directives,
      fields,
      loc: this.loc(start)
    };
  };
  _proto.parseInputFieldsDefinition = function parseInputFieldsDefinition() {
    return this.optionalMany(TokenKind.BRACE_L, this.parseInputValueDef, TokenKind.BRACE_R);
  };
  _proto.parseTypeSystemExtension = function parseTypeSystemExtension() {
    var keywordToken = this._lexer.lookahead();
    if (keywordToken.kind === TokenKind.NAME) {
      switch (keywordToken.value) {
        case "schema":
          return this.parseSchemaExtension();
        case "scalar":
          return this.parseScalarTypeExtension();
        case "type":
          return this.parseObjectTypeExtension();
        case "interface":
          return this.parseInterfaceTypeExtension();
        case "union":
          return this.parseUnionTypeExtension();
        case "enum":
          return this.parseEnumTypeExtension();
        case "input":
          return this.parseInputObjectTypeExtension();
      }
    }
    throw this.unexpected(keywordToken);
  };
  _proto.parseSchemaExtension = function parseSchemaExtension() {
    var start = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("schema");
    var directives = this.parseDirectives(true);
    var operationTypes = this.optionalMany(TokenKind.BRACE_L, this.parseOperationTypeDefinition, TokenKind.BRACE_R);
    if (directives.length === 0 && operationTypes.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.SCHEMA_EXTENSION,
      directives,
      operationTypes,
      loc: this.loc(start)
    };
  };
  _proto.parseScalarTypeExtension = function parseScalarTypeExtension() {
    var start = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("scalar");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    if (directives.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.SCALAR_TYPE_EXTENSION,
      name: name2,
      directives,
      loc: this.loc(start)
    };
  };
  _proto.parseObjectTypeExtension = function parseObjectTypeExtension() {
    var start = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("type");
    var name2 = this.parseName();
    var interfaces = this.parseImplementsInterfaces();
    var directives = this.parseDirectives(true);
    var fields = this.parseFieldsDefinition();
    if (interfaces.length === 0 && directives.length === 0 && fields.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.OBJECT_TYPE_EXTENSION,
      name: name2,
      interfaces,
      directives,
      fields,
      loc: this.loc(start)
    };
  };
  _proto.parseInterfaceTypeExtension = function parseInterfaceTypeExtension() {
    var start = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("interface");
    var name2 = this.parseName();
    var interfaces = this.parseImplementsInterfaces();
    var directives = this.parseDirectives(true);
    var fields = this.parseFieldsDefinition();
    if (interfaces.length === 0 && directives.length === 0 && fields.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.INTERFACE_TYPE_EXTENSION,
      name: name2,
      interfaces,
      directives,
      fields,
      loc: this.loc(start)
    };
  };
  _proto.parseUnionTypeExtension = function parseUnionTypeExtension() {
    var start = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("union");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var types = this.parseUnionMemberTypes();
    if (directives.length === 0 && types.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.UNION_TYPE_EXTENSION,
      name: name2,
      directives,
      types,
      loc: this.loc(start)
    };
  };
  _proto.parseEnumTypeExtension = function parseEnumTypeExtension() {
    var start = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("enum");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var values = this.parseEnumValuesDefinition();
    if (directives.length === 0 && values.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.ENUM_TYPE_EXTENSION,
      name: name2,
      directives,
      values,
      loc: this.loc(start)
    };
  };
  _proto.parseInputObjectTypeExtension = function parseInputObjectTypeExtension() {
    var start = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("input");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var fields = this.parseInputFieldsDefinition();
    if (directives.length === 0 && fields.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.INPUT_OBJECT_TYPE_EXTENSION,
      name: name2,
      directives,
      fields,
      loc: this.loc(start)
    };
  };
  _proto.parseDirectiveDefinition = function parseDirectiveDefinition() {
    var start = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("directive");
    this.expectToken(TokenKind.AT);
    var name2 = this.parseName();
    var args = this.parseArgumentDefs();
    var repeatable = this.expectOptionalKeyword("repeatable");
    this.expectKeyword("on");
    var locations = this.parseDirectiveLocations();
    return {
      kind: Kind.DIRECTIVE_DEFINITION,
      description,
      name: name2,
      arguments: args,
      repeatable,
      locations,
      loc: this.loc(start)
    };
  };
  _proto.parseDirectiveLocations = function parseDirectiveLocations() {
    return this.delimitedMany(TokenKind.PIPE, this.parseDirectiveLocation);
  };
  _proto.parseDirectiveLocation = function parseDirectiveLocation() {
    var start = this._lexer.token;
    var name2 = this.parseName();
    if (DirectiveLocation[name2.value] !== void 0) {
      return name2;
    }
    throw this.unexpected(start);
  };
  _proto.loc = function loc(startToken) {
    var _this$_options4;
    if (((_this$_options4 = this._options) === null || _this$_options4 === void 0 ? void 0 : _this$_options4.noLocation) !== true) {
      return new Location(startToken, this._lexer.lastToken, this._lexer.source);
    }
  };
  _proto.peek = function peek(kind) {
    return this._lexer.token.kind === kind;
  };
  _proto.expectToken = function expectToken(kind) {
    var token2 = this._lexer.token;
    if (token2.kind === kind) {
      this._lexer.advance();
      return token2;
    }
    throw syntaxError(this._lexer.source, token2.start, "Expected ".concat(getTokenKindDesc(kind), ", found ").concat(getTokenDesc(token2), "."));
  };
  _proto.expectOptionalToken = function expectOptionalToken(kind) {
    var token2 = this._lexer.token;
    if (token2.kind === kind) {
      this._lexer.advance();
      return token2;
    }
    return void 0;
  };
  _proto.expectKeyword = function expectKeyword(value) {
    var token2 = this._lexer.token;
    if (token2.kind === TokenKind.NAME && token2.value === value) {
      this._lexer.advance();
    } else {
      throw syntaxError(this._lexer.source, token2.start, 'Expected "'.concat(value, '", found ').concat(getTokenDesc(token2), "."));
    }
  };
  _proto.expectOptionalKeyword = function expectOptionalKeyword(value) {
    var token2 = this._lexer.token;
    if (token2.kind === TokenKind.NAME && token2.value === value) {
      this._lexer.advance();
      return true;
    }
    return false;
  };
  _proto.unexpected = function unexpected(atToken) {
    var token2 = atToken !== null && atToken !== void 0 ? atToken : this._lexer.token;
    return syntaxError(this._lexer.source, token2.start, "Unexpected ".concat(getTokenDesc(token2), "."));
  };
  _proto.any = function any(openKind, parseFn, closeKind) {
    this.expectToken(openKind);
    var nodes = [];
    while (!this.expectOptionalToken(closeKind)) {
      nodes.push(parseFn.call(this));
    }
    return nodes;
  };
  _proto.optionalMany = function optionalMany(openKind, parseFn, closeKind) {
    if (this.expectOptionalToken(openKind)) {
      var nodes = [];
      do {
        nodes.push(parseFn.call(this));
      } while (!this.expectOptionalToken(closeKind));
      return nodes;
    }
    return [];
  };
  _proto.many = function many(openKind, parseFn, closeKind) {
    this.expectToken(openKind);
    var nodes = [];
    do {
      nodes.push(parseFn.call(this));
    } while (!this.expectOptionalToken(closeKind));
    return nodes;
  };
  _proto.delimitedMany = function delimitedMany(delimiterKind, parseFn) {
    this.expectOptionalToken(delimiterKind);
    var nodes = [];
    do {
      nodes.push(parseFn.call(this));
    } while (this.expectOptionalToken(delimiterKind));
    return nodes;
  };
  return Parser2;
}();
function getTokenDesc(token2) {
  var value = token2.value;
  return getTokenKindDesc(token2.kind) + (value != null ? ' "'.concat(value, '"') : "");
}
function getTokenKindDesc(kind) {
  return isPunctuatorTokenKind(kind) ? '"'.concat(kind, '"') : kind;
}
function l$1(a2, b2) {
  b2.tag = a2;
  return b2;
}
function m() {
}
function p$1(a2) {
  return function(b2) {
    var c2 = a2.length;
    let d2 = false, e = false, f2 = false, g = 0;
    b2(
      l$1(0, [
        function(h2) {
          if (h2) {
            d2 = true;
          } else if (e) {
            f2 = true;
          } else {
            for (e = f2 = true; f2 && !d2; ) {
              g < c2 ? (h2 = a2[g], g = g + 1 | 0, f2 = false, b2(l$1(1, [h2]))) : (d2 = true, b2(0));
            }
            e = false;
          }
        }
      ])
    );
  };
}
function r() {
}
function t(a2) {
  a2(0);
}
function u$1(a2) {
  let b2 = false;
  a2(
    l$1(0, [
      function(c2) {
        c2 ? b2 = true : b2 || a2(0);
      }
    ])
  );
}
function C(a2) {
  return a2(0);
}
function D$1(a2) {
  return function(b2) {
    return function(c2) {
      let e = m, f2 = false, g = [], h2 = false;
      b2(function(b3) {
        "number" == typeof b3 ? h2 || (h2 = true, 0 === g.length && c2(0)) : b3.tag ? h2 || (f2 = false, function(a3) {
          function b4(a4) {
            "number" == typeof a4 ? 0 !== g.length && (g = g.filter(d2), a4 = 0 === g.length, h2 && a4 ? c2(0) : !f2 && a4 && (f2 = true, e(0))) : a4.tag ? 0 !== g.length && (c2(l$1(1, [a4[0]])), k(0)) : (k = a4 = a4[0], g = g.concat(a4), a4(0));
          }
          function d2(a4) {
            return a4 !== k;
          }
          let k = m;
          1 === a3.length ? a3(b4) : a3.bind(null, b4);
        }(a2(b3[0])), f2 || (f2 = true, e(0))) : e = b3[0];
      });
      c2(
        l$1(0, [
          function(a3) {
            a3 ? (h2 || (h2 = true, e(a3)), g.forEach(function(c3) {
              return c3(a3);
            }), g = []) : (f2 || h2 ? f2 = false : (f2 = true, e(0)), g.forEach(C));
          }
        ])
      );
    };
  };
}
function E$1(a2) {
  return a2;
}
function H(a2) {
  return function(b2) {
    return function(c2) {
      let d2 = false;
      return b2(function(e) {
        if ("number" == typeof e) {
          d2 || (d2 = true, c2(e));
        } else if (e.tag) {
          d2 || (a2(e[0]), c2(e));
        } else {
          var g = e[0];
          c2(
            l$1(0, [
              function(a3) {
                if (!d2) {
                  return a3 && (d2 = true), g(a3);
                }
              }
            ])
          );
        }
      });
    };
  };
}
function J$1(a2) {
  a2(0);
}
function K(a2) {
  return function(b2) {
    return function(c2) {
      function d2(a3) {
        h2 && ("number" == typeof a3 ? (h2 = false, n ? c2(a3) : f2 || (f2 = true, e(0))) : a3.tag ? (c2(a3), k ? k = false : g(0)) : (g = a3 = a3[0], k = false, a3(0)));
      }
      let e = m, f2 = false, g = m, h2 = false, k = false, n = false;
      b2(function(b3) {
        "number" == typeof b3 ? n || (n = true, h2 || c2(0)) : b3.tag ? n || (h2 && (g(1), g = m), f2 ? f2 = false : (f2 = true, e(0)), b3 = a2(b3[0]), h2 = true, b3(d2)) : e = b3[0];
      });
      c2(
        l$1(0, [
          function(a3) {
            if (a3) {
              if (n || (n = true, e(1)), h2) {
                return h2 = false, g(1);
              }
            } else {
              n || f2 || (f2 = true, e(0)), h2 && !k && (k = true, g(0));
            }
          }
        ])
      );
    };
  };
}
function M(a2) {
  return function(b2) {
    return function(c2) {
      let d2 = [], e = m;
      return b2(function(b3) {
        "number" == typeof b3 ? p$1(d2)(c2) : b3.tag ? (d2.length >= a2 && 0 < a2 && d2.shift(), d2.push(b3[0]), e(0)) : (b3 = b3[0], 0 >= a2 ? (b3(1), u$1(c2)) : (e = b3, b3(0)));
      });
    };
  };
}
function N$1(a2) {
  return function(b2) {
    let c2 = m, d2 = false;
    b2(function(e) {
      "number" == typeof e ? d2 = true : e.tag ? d2 || (a2(e[0]), c2(0)) : (c2 = e = e[0], e(0));
    });
    return {
      unsubscribe: function() {
        if (!d2) {
          return d2 = true, c2(1);
        }
      }
    };
  };
}
function O() {
}
function buffer$1(a2) {
  return function(b2) {
    return function(c2) {
      function d2(a3) {
        "number" == typeof a3 ? k || (k = true, f2(1), 0 < e.length && c2(l$1(1, [e])), c2(0)) : a3.tag ? !k && 0 < e.length && (a3 = e, e = [], c2(l$1(1, [a3]))) : g = a3[0];
      }
      let e = [], f2 = m, g = m, h2 = false, k = false;
      b2(function(b3) {
        "number" == typeof b3 ? k || (k = true, g(1), 0 < e.length && c2(l$1(1, [e])), c2(0)) : b3.tag ? k || (e.push(b3[0]), h2 ? h2 = false : (h2 = true, f2(0), g(0))) : (f2 = b3[0], a2(d2));
      });
      c2(
        l$1(0, [
          function(a3) {
            if (!k) {
              if (a3) {
                return k = true, f2(1), g(1);
              }
              if (!h2) {
                return h2 = true, f2(0), g(0);
              }
            }
          }
        ])
      );
    };
  };
}
function filter$1(a2) {
  return function(b2) {
    return function(c2) {
      let d2 = m;
      return b2(function(b3) {
        "number" == typeof b3 ? c2(b3) : b3.tag ? a2(b3[0]) ? c2(b3) : d2(0) : (d2 = b3[0], c2(b3));
      });
    };
  };
}
function fromPromise$1(a2) {
  return function(b2) {
    let c2 = false;
    a2.then(function(a3) {
      c2 || (b2(l$1(1, [a3])), b2(0));
      return Promise.resolve(void 0);
    });
    b2(
      l$1(0, [
        function(a3) {
          a3 && (c2 = true);
        }
      ])
    );
  };
}
function fromValue$1(a2) {
  return function(b2) {
    let c2 = false;
    b2(
      l$1(0, [
        function(d2) {
          d2 ? c2 = true : c2 || (c2 = true, b2(l$1(1, [a2])), b2(0));
        }
      ])
    );
  };
}
function make$1(a2) {
  return function(b2) {
    let c2 = r, d2 = false;
    c2 = a2({
      next: function(a3) {
        d2 || b2(l$1(1, [a3]));
      },
      complete: function() {
        d2 || (d2 = true, b2(0));
      }
    });
    b2(
      l$1(0, [
        function(a3) {
          if (a3 && !d2) {
            return d2 = true, c2();
          }
        }
      ])
    );
  };
}
function makeSubject$1() {
  let a2 = [], b2 = false;
  return {
    source: function(c2) {
      function b3(a3) {
        return a3 !== c2;
      }
      a2 = a2.concat(c2);
      c2(
        l$1(0, [
          function(c3) {
            c3 && (a2 = a2.filter(b3));
          }
        ])
      );
    },
    next: function(c2) {
      b2 || a2.forEach(function(a3) {
        a3(l$1(1, [c2]));
      });
    },
    complete: function() {
      b2 || (b2 = true, a2.forEach(t));
    }
  };
}
function map$1$1(a2) {
  return function(b2) {
    return function(c2) {
      return b2(function(b3) {
        b3 = "number" == typeof b3 ? 0 : b3.tag ? l$1(1, [a2(b3[0])]) : l$1(0, [b3[0]]);
        c2(b3);
      });
    };
  };
}
function merge$1(a2) {
  return D$1(E$1)(p$1(a2));
}
function onEnd$1(a2) {
  return function(b2) {
    return function(c2) {
      let d2 = false;
      return b2(function(b3) {
        if ("number" == typeof b3) {
          if (d2) {
            return;
          }
          d2 = true;
          c2(b3);
          return a2();
        }
        if (b3.tag) {
          d2 || c2(b3);
        } else {
          var e = b3[0];
          c2(
            l$1(0, [
              function(c3) {
                if (!d2) {
                  return c3 ? (d2 = true, e(c3), a2()) : e(c3);
                }
              }
            ])
          );
        }
      });
    };
  };
}
function onStart$1(a2) {
  return function(b2) {
    return function(c2) {
      return b2(function(b3) {
        "number" == typeof b3 ? c2(b3) : b3.tag ? c2(b3) : (c2(b3), a2());
      });
    };
  };
}
function pipe() {
  for (var a2 = arguments, b2 = arguments[0], c2 = 1, d2 = arguments.length; c2 < d2; c2++) {
    b2 = a2[c2](b2);
  }
  return b2;
}
function publish$1(a2) {
  return N$1(O)(a2);
}
function share$1(a2) {
  function b2(a3) {
    "number" == typeof a3 ? (c2.forEach(J$1), c2 = []) : a3.tag ? (e = false, c2.forEach(function(b3) {
      b3(a3);
    })) : d2 = a3[0];
  }
  let c2 = [], d2 = m, e = false;
  return function(f2) {
    function g(a3) {
      return a3 !== f2;
    }
    c2 = c2.concat(f2);
    1 === c2.length && a2(b2);
    f2(
      l$1(0, [
        function(a3) {
          if (a3) {
            if (c2 = c2.filter(g), 0 === c2.length) {
              return d2(1);
            }
          } else {
            e || (e = true, d2(a3));
          }
        }
      ])
    );
  };
}
function skipUntil$1(a2) {
  return function(b2) {
    return function(c2) {
      function d2(a3) {
        "number" == typeof a3 ? g && (k = true, e(1)) : a3.tag ? (g = false, f2(1)) : (f2 = a3 = a3[0], a3(0));
      }
      let e = m, f2 = m, g = true, h2 = false, k = false;
      b2(function(b3) {
        "number" == typeof b3 ? (g && f2(1), k = true, c2(0)) : b3.tag ? g || k ? h2 ? h2 = false : (h2 = true, e(0), f2(0)) : (h2 = false, c2(b3)) : (e = b3[0], a2(d2));
      });
      c2(
        l$1(0, [
          function(a3) {
            if (!k) {
              if (a3) {
                if (k = true, e(1), g) {
                  return f2(1);
                }
              } else {
                h2 || (h2 = true, g && f2(0), e(0));
              }
            }
          }
        ])
      );
    };
  };
}
function take$1(a2) {
  return function(b2) {
    return function(c2) {
      let d2 = false, e = 0, f2 = m;
      b2(function(b3) {
        "number" == typeof b3 ? d2 || (d2 = true, c2(0)) : b3.tag ? e < a2 && !d2 && (e = e + 1 | 0, c2(b3), !d2 && e >= a2 && (d2 = true, c2(0), f2(1))) : (b3 = b3[0], 0 >= a2 ? (d2 = true, c2(0), b3(1)) : f2 = b3);
      });
      c2(
        l$1(0, [
          function(b3) {
            if (!d2) {
              if (b3) {
                return d2 = true, f2(1);
              }
              if (e < a2) {
                return f2(0);
              }
            }
          }
        ])
      );
    };
  };
}
function takeUntil$1(a2) {
  return function(b2) {
    return function(c2) {
      function d2(a3) {
        "number" != typeof a3 && (a3.tag ? (e = true, f2(1), c2(0)) : (g = a3 = a3[0], a3(0)));
      }
      let e = false, f2 = m, g = m;
      b2(function(b3) {
        "number" == typeof b3 ? e || (e = true, g(1), c2(0)) : b3.tag ? e || c2(b3) : (f2 = b3[0], a2(d2));
      });
      c2(
        l$1(0, [
          function(a3) {
            if (!e) {
              return a3 ? (e = true, f2(1), g(1)) : f2(0);
            }
          }
        ])
      );
    };
  };
}
function toPromise$1(a2) {
  return new Promise(function(b2) {
    M(1)(a2)(function(a3) {
      if ("number" != typeof a3) {
        if (a3.tag) {
          b2(a3[0]);
        } else {
          a3[0](0);
        }
      }
    });
  });
}
"function" == typeof Symbol ? Symbol.observable || (Symbol.observable = Symbol("observable")) : "@@observable";
function rehydrateGraphQlError(r2) {
  if ("string" == typeof r2) {
    return new GraphQLError(r2);
  } else if ("object" == typeof r2 && r2.message) {
    return new GraphQLError(r2.message, r2.nodes, r2.source, r2.positions, r2.path, r2, r2.extensions || {});
  } else {
    return r2;
  }
}
var o = function(e) {
  function CombinedError(r2) {
    var t2 = r2.networkError;
    var n = r2.response;
    var a2 = (r2.graphQLErrors || []).map(rehydrateGraphQlError);
    var o2 = function generateErrorMessage(e2, r3) {
      var t3 = "";
      if (void 0 !== e2) {
        return t3 = "[Network] " + e2.message;
      }
      if (void 0 !== r3) {
        r3.forEach(function(e3) {
          t3 += "[GraphQL] " + e3.message + "\n";
        });
      }
      return t3.trim();
    }(t2, a2);
    e.call(this, o2);
    this.name = "CombinedError";
    this.message = o2;
    this.graphQLErrors = a2;
    this.networkError = t2;
    this.response = n;
  }
  if (e) {
    CombinedError.__proto__ = e;
  }
  (CombinedError.prototype = Object.create(e && e.prototype)).constructor = CombinedError;
  CombinedError.prototype.toString = function toString2() {
    return this.message;
  };
  return CombinedError;
}(Error);
function phash(e, r2) {
  e |= 0;
  for (var t2 = 0, n = 0 | r2.length; t2 < n; t2++) {
    e = (e << 5) + e + r2.charCodeAt(t2);
  }
  return e;
}
function hash$2(e) {
  return phash(5381, e) >>> 0;
}
var i$2 = /* @__PURE__ */ new Set();
var s = /* @__PURE__ */ new WeakMap();
function stringify(e) {
  if (null === e || i$2.has(e)) {
    return "null";
  } else if ("object" != typeof e) {
    return JSON.stringify(e) || "";
  } else if (e.toJSON) {
    return stringify(e.toJSON());
  } else if (Array.isArray(e)) {
    var r2 = "[";
    for (var t2 = 0, n = e.length; t2 < n; t2++) {
      if (t2 > 0) {
        r2 += ",";
      }
      var a2 = stringify(e[t2]);
      r2 += a2.length > 0 ? a2 : "null";
    }
    return r2 += "]";
  }
  var o2 = Object.keys(e).sort();
  if (!o2.length && e.constructor && e.constructor !== Object) {
    var u2 = s.get(e) || Math.random().toString(36).slice(2);
    s.set(e, u2);
    return '{"__key":"' + u2 + '"}';
  }
  i$2.add(e);
  var f2 = "{";
  for (var c2 = 0, l2 = o2.length; c2 < l2; c2++) {
    var h2 = o2[c2];
    var p2 = stringify(e[h2]);
    if (p2) {
      if (f2.length > 1) {
        f2 += ",";
      }
      f2 += stringify(h2) + ":" + p2;
    }
  }
  i$2.delete(e);
  return f2 += "}";
}
function stringifyVariables(e) {
  i$2.clear();
  return stringify(e);
}
var u = /("{3}[\s\S]*"{3}|"(?:\\.|[^"])*")/g;
var f = /([\s,]|#[^\n\r]+)+/g;
function replaceOutsideStrings(e, r2) {
  return r2 % 2 == 0 ? e.replace(f, " ").trim() : e;
}
function stringifyDocument(e) {
  var r2 = ("string" != typeof e ? e.loc && e.loc.source.body || print$1(e) : e).split(u).map(replaceOutsideStrings).join("");
  if ("string" != typeof e) {
    var t2 = "definitions" in e && getOperationName$1(e);
    if (t2) {
      r2 = "# " + t2 + "\n" + r2;
    }
    if (!e.loc) {
      e.loc = {
        start: 0,
        end: r2.length,
        source: {
          body: r2,
          name: "gql",
          locationOffset: {
            line: 1,
            column: 1
          }
        }
      };
    }
  }
  return r2;
}
var c = /* @__PURE__ */ new Map();
function keyDocument(e) {
  var r2;
  var n;
  if ("string" == typeof e) {
    r2 = hash$2(stringifyDocument(e));
    n = c.get(r2) || parse$4(e, {
      noLocation: true
    });
  } else {
    r2 = e.__key || hash$2(stringifyDocument(e));
    n = c.get(r2) || e;
  }
  if (!n.loc) {
    stringifyDocument(n);
  }
  n.__key = r2;
  c.set(r2, n);
  return n;
}
function createRequest(e, r2) {
  if (!r2) {
    r2 = {};
  }
  var t2 = keyDocument(e);
  return {
    key: phash(t2.__key, stringifyVariables(r2)) >>> 0,
    query: t2,
    variables: r2
  };
}
function getOperationName$1(e) {
  for (var t2 = 0, n = e.definitions.length; t2 < n; t2++) {
    var a2 = e.definitions[t2];
    if (a2.kind === Kind.OPERATION_DEFINITION && a2.name) {
      return a2.name.value;
    }
  }
}
function getOperationType(e) {
  for (var t2 = 0, n = e.definitions.length; t2 < n; t2++) {
    var a2 = e.definitions[t2];
    if (a2.kind === Kind.OPERATION_DEFINITION) {
      return a2.operation;
    }
  }
}
function _extends$3() {
  return (_extends$3 = Object.assign || function(e) {
    for (var r2 = 1; r2 < arguments.length; r2++) {
      var t2 = arguments[r2];
      for (var n in t2) {
        if (Object.prototype.hasOwnProperty.call(t2, n)) {
          e[n] = t2[n];
        }
      }
    }
    return e;
  }).apply(this, arguments);
}
function makeResult(e, r2, t2) {
  if (!("data" in r2) && !("errors" in r2) || "path" in r2) {
    throw new Error("No Content");
  }
  return {
    operation: e,
    data: r2.data,
    error: Array.isArray(r2.errors) ? new o({
      graphQLErrors: r2.errors,
      response: t2
    }) : void 0,
    extensions: "object" == typeof r2.extensions && r2.extensions || void 0,
    hasNext: !!r2.hasNext
  };
}
function mergeResultPatch(e, r2, t2) {
  var n = _extends$3({}, e);
  n.hasNext = !!r2.hasNext;
  if (!("path" in r2)) {
    if ("data" in r2) {
      n.data = r2.data;
    }
    return n;
  }
  if (Array.isArray(r2.errors)) {
    n.error = new o({
      graphQLErrors: n.error ? n.error.graphQLErrors.concat(r2.errors) : r2.errors,
      response: t2
    });
  }
  var a2 = n.data = _extends$3({}, n.data);
  var i2 = 0;
  var s2;
  while (i2 < r2.path.length) {
    a2 = a2[s2 = r2.path[i2++]] = Array.isArray(a2[s2]) ? [].concat(a2[s2]) : _extends$3({}, a2[s2]);
  }
  _extends$3(a2, r2.data);
  return n;
}
function makeErrorResult(e, r2, t2) {
  return {
    operation: e,
    data: void 0,
    error: new o({
      networkError: r2,
      response: t2
    }),
    extensions: void 0
  };
}
function shouldUseGet(e) {
  return "query" === e.kind && !!e.context.preferGetMethod;
}
function makeFetchBody(e) {
  return {
    query: print$1(e.query),
    operationName: getOperationName$1(e.query),
    variables: e.variables || void 0,
    extensions: void 0
  };
}
function makeFetchURL(e, r2) {
  var t2 = shouldUseGet(e);
  var n = e.context.url;
  if (!t2 || !r2) {
    return n;
  }
  var a2 = [];
  if (r2.operationName) {
    a2.push("operationName=" + encodeURIComponent(r2.operationName));
  }
  if (r2.query) {
    a2.push("query=" + encodeURIComponent(r2.query.replace(/#[^\n\r]+/g, " ").trim()));
  }
  if (r2.variables) {
    a2.push("variables=" + encodeURIComponent(stringifyVariables(r2.variables)));
  }
  if (r2.extensions) {
    a2.push("extensions=" + encodeURIComponent(stringifyVariables(r2.extensions)));
  }
  var o2 = n + "?" + a2.join("&");
  if (o2.length > 2047) {
    e.context.preferGetMethod = false;
    return n;
  }
  return o2;
}
function makeFetchOptions(e, r2) {
  var t2 = shouldUseGet(e);
  var n = "function" == typeof e.context.fetchOptions ? e.context.fetchOptions() : e.context.fetchOptions || {};
  return _extends$3({}, n, {
    body: !t2 && r2 ? JSON.stringify(r2) : void 0,
    method: t2 ? "GET" : "POST",
    headers: t2 ? n.headers : _extends$3({}, {
      "content-type": "application/json"
    }, n.headers)
  });
}
var l = "undefined" != typeof Symbol ? Symbol.asyncIterator : null;
var h = "undefined" != typeof TextDecoder ? new TextDecoder() : null;
var p = /content-type:[^\r\n]*application\/json/i;
var d = /boundary="?([^=";]+)"?/i;
function makeFetchSource(e, r2, t2) {
  var n = "manual" === t2.redirect ? 400 : 300;
  var o2 = e.context.fetch;
  return make$1(function(a2) {
    var i2 = a2.next;
    var s2 = a2.complete;
    var u2 = "undefined" != typeof AbortController ? new AbortController() : null;
    if (u2) {
      t2.signal = u2.signal;
    }
    var f2 = false;
    function executeIncrementalFetch(e2, r3, t3) {
      var n2 = t3.headers && t3.headers.get("Content-Type") || "";
      if (!/multipart\/mixed/i.test(n2)) {
        return t3.json().then(function(n3) {
          var a4 = makeResult(r3, n3, t3);
          f2 = true;
          e2(a4);
        });
      }
      var a3 = "---";
      var o3 = n2.match(d);
      if (o3) {
        a3 = "--" + o3[1];
      }
      var i3;
      var cancel = function() {
      };
      if (l && t3[l]) {
        var s3 = t3[l]();
        i3 = s3.next.bind(s3);
      } else if ("body" in t3 && t3.body) {
        var u3 = t3.body.getReader();
        cancel = u3.cancel.bind(u3);
        i3 = u3.read.bind(u3);
      } else {
        throw new TypeError("Streaming requests unsupported");
      }
      var c3 = "";
      var v2 = true;
      var m3 = null;
      var g = null;
      return i3().then(function next(n3) {
        if (!n3.done) {
          var o4 = function toString2(e3) {
            return "Buffer" === e3.constructor.name ? e3.toString() : h.decode(e3);
          }(n3.value);
          var s4 = o4.indexOf(a3);
          if (s4 > -1) {
            s4 += c3.length;
          } else {
            s4 = c3.indexOf(a3);
          }
          c3 += o4;
          while (s4 > -1) {
            var u4 = c3.slice(0, s4);
            var l2 = c3.slice(s4 + a3.length);
            if (v2) {
              v2 = false;
            } else {
              var d2 = u4.indexOf("\r\n\r\n") + 4;
              var y2 = u4.slice(0, d2);
              var x2 = u4.slice(d2, u4.lastIndexOf("\r\n"));
              var b2 = void 0;
              if (p.test(y2)) {
                try {
                  b2 = JSON.parse(x2);
                  m3 = g = g ? mergeResultPatch(g, b2, t3) : makeResult(r3, b2, t3);
                } catch (e3) {
                }
              }
              if ("--" === l2.slice(0, 2) || b2 && !b2.hasNext) {
                if (!g) {
                  return e2(makeResult(r3, {}, t3));
                }
                break;
              }
            }
            s4 = (c3 = l2).indexOf(a3);
          }
        } else {
          f2 = true;
        }
        if (m3) {
          e2(m3);
          m3 = null;
        }
        if (!n3.done && (!g || g.hasNext)) {
          return i3().then(next);
        }
      }).finally(cancel);
    }
    var c2 = false;
    var v = false;
    var m2;
    Promise.resolve().then(function() {
      if (c2) {
        return;
      }
      return (o2 || fetch)(r2, t2);
    }).then(function(r3) {
      if (!r3) {
        return;
      }
      v = (m2 = r3).status < 200 || m2.status >= n;
      return executeIncrementalFetch(i2, e, m2);
    }).then(s2).catch(function(r3) {
      if (f2) {
        throw r3;
      }
      if ("AbortError" !== r3.name) {
        var t3 = makeErrorResult(e, v ? new Error(m2.statusText) : r3, m2);
        i2(t3);
        s2();
      }
    });
    return function() {
      c2 = true;
      if (u2) {
        u2.abort();
      }
    };
  });
}
function collectTypes(e, n) {
  if (Array.isArray(e)) {
    for (var r2 = 0; r2 < e.length; r2++) {
      collectTypes(e[r2], n);
    }
  } else if ("object" == typeof e && null !== e) {
    for (var t2 in e) {
      if ("__typename" === t2 && "string" == typeof e[t2]) {
        n[e[t2]] = 0;
      } else {
        collectTypes(e[t2], n);
      }
    }
  }
  return n;
}
function collectTypesFromResponse(e) {
  return Object.keys(collectTypes(e, {}));
}
var formatNode = function(e) {
  if (e.selectionSet && !e.selectionSet.selections.some(function(e2) {
    return e2.kind === Kind.FIELD && "__typename" === e2.name.value && !e2.alias;
  })) {
    return _extends$3({}, e, {
      selectionSet: _extends$3({}, e.selectionSet, {
        selections: e.selectionSet.selections.concat([{
          kind: Kind.FIELD,
          name: {
            kind: Kind.NAME,
            value: "__typename"
          }
        }])
      })
    });
  }
};
var F$1 = /* @__PURE__ */ new Map();
function formatDocument(n) {
  var r2 = keyDocument(n);
  var a2 = F$1.get(r2.__key);
  if (!a2) {
    a2 = visit$1(r2, {
      Field: formatNode,
      InlineFragment: formatNode
    });
    Object.defineProperty(a2, "__key", {
      value: r2.__key,
      enumerable: false
    });
    F$1.set(r2.__key, a2);
  }
  return a2;
}
function maskTypename(e) {
  if (!e || "object" != typeof e) {
    return e;
  }
  return Object.keys(e).reduce(function(n, r2) {
    var t2 = e[r2];
    if ("__typename" === r2) {
      Object.defineProperty(n, "__typename", {
        enumerable: false,
        value: t2
      });
    } else if (Array.isArray(t2)) {
      n[r2] = t2.map(maskTypename);
    } else if (t2 && "object" == typeof t2 && "__typename" in t2) {
      n[r2] = maskTypename(t2);
    } else {
      n[r2] = t2;
    }
    return n;
  }, Array.isArray(e) ? [] : {});
}
function withPromise(e) {
  e.toPromise = function() {
    return new Promise(function(n) {
      var r2 = N$1(function(e2) {
        if (!e2.stale && !e2.hasNext) {
          Promise.resolve().then(function() {
            r2.unsubscribe();
            n(e2);
          });
        }
      })(e);
    });
  };
  return e;
}
function makeOperation(e, n, r2) {
  if (!r2) {
    r2 = n.context;
  }
  return {
    key: n.key,
    query: n.query,
    variables: n.variables,
    kind: e,
    context: r2
  };
}
function addMetadata(e, n) {
  return makeOperation(e.kind, e, _extends$3({}, e.context, {
    meta: _extends$3({}, e.context.meta, n)
  }));
}
function noop$3() {
}
function applyDefinitions(e, r2, t2) {
  for (var a2 = 0; a2 < t2.length; a2++) {
    if (t2[a2].kind === Kind.FRAGMENT_DEFINITION) {
      var o2 = t2[a2].name.value;
      var i2 = stringifyDocument(t2[a2]);
      if (!e.has(o2)) {
        e.set(o2, i2);
        r2.push(t2[a2]);
      }
    } else {
      r2.push(t2[a2]);
    }
  }
}
function gql() {
  var e = arguments;
  var r2 = /* @__PURE__ */ new Map();
  var a2 = [];
  var o2 = [];
  var i2 = Array.isArray(arguments[0]) ? arguments[0][0] : arguments[0] || "";
  for (var u2 = 1; u2 < arguments.length; u2++) {
    var c2 = e[u2];
    if (c2 && c2.definitions) {
      o2.push.apply(o2, c2.definitions);
    } else {
      i2 += c2;
    }
    i2 += e[0][u2];
  }
  applyDefinitions(r2, a2, keyDocument(i2).definitions);
  applyDefinitions(r2, a2, o2);
  return keyDocument({
    kind: Kind.DOCUMENT,
    definitions: a2
  });
}
function shouldSkip(e) {
  var n = e.kind;
  return "mutation" !== n && "query" !== n;
}
function cacheExchange$1(e) {
  var n = e.forward;
  var r2 = e.client;
  e.dispatchDebug;
  var a2 = /* @__PURE__ */ new Map();
  var i2 = /* @__PURE__ */ Object.create(null);
  function mapTypeNames(e2) {
    var n2 = makeOperation(e2.kind, e2);
    n2.query = formatDocument(e2.query);
    return n2;
  }
  function isOperationCached(e2) {
    var n2 = e2.context.requestPolicy;
    return "query" === e2.kind && "network-only" !== n2 && ("cache-only" === n2 || a2.has(e2.key));
  }
  return function(e2) {
    var u2 = share$1(e2);
    var c2 = map$1$1(function(e3) {
      var n2 = a2.get(e3.key);
      var i3 = _extends$3({}, n2, {
        operation: addMetadata(e3, {
          cacheOutcome: n2 ? "hit" : "miss"
        })
      });
      if ("cache-and-network" === e3.context.requestPolicy) {
        i3.stale = true;
        reexecuteOperation(r2, e3);
      }
      return i3;
    })(filter$1(function(e3) {
      return !shouldSkip(e3) && isOperationCached(e3);
    })(u2));
    var s2 = H(function(e3) {
      var n2 = e3.operation;
      if (!n2) {
        return;
      }
      var o2 = collectTypesFromResponse(e3.data).concat(n2.context.additionalTypenames || []);
      if ("mutation" === e3.operation.kind) {
        var u3 = /* @__PURE__ */ new Set();
        for (var c3 = 0; c3 < o2.length; c3++) {
          var s3 = o2[c3];
          var f2 = i2[s3] || (i2[s3] = /* @__PURE__ */ new Set());
          f2.forEach(function(e4) {
            u3.add(e4);
          });
          f2.clear();
        }
        u3.forEach(function(e4) {
          if (a2.has(e4)) {
            n2 = a2.get(e4).operation;
            a2.delete(e4);
            reexecuteOperation(r2, n2);
          }
        });
      } else if ("query" === n2.kind && e3.data) {
        a2.set(n2.key, e3);
        for (var p2 = 0; p2 < o2.length; p2++) {
          var l2 = o2[p2];
          (i2[l2] || (i2[l2] = /* @__PURE__ */ new Set())).add(n2.key);
        }
      }
    })(n(filter$1(function(e3) {
      return "query" !== e3.kind || "cache-only" !== e3.context.requestPolicy;
    })(map$1$1(function(e3) {
      return addMetadata(e3, {
        cacheOutcome: "miss"
      });
    })(merge$1([map$1$1(mapTypeNames)(filter$1(function(e3) {
      return !shouldSkip(e3) && !isOperationCached(e3);
    })(u2)), filter$1(function(e3) {
      return shouldSkip(e3);
    })(u2)])))));
    return merge$1([c2, s2]);
  };
}
function reexecuteOperation(e, n) {
  return e.reexecuteOperation(makeOperation(n.kind, n, _extends$3({}, n.context, {
    requestPolicy: "network-only"
  })));
}
function subscriptionExchange(e) {
  var n = e.forwardSubscription;
  var t2 = e.enableAllOperations;
  return function(e2) {
    var a2 = e2.client;
    var i2 = e2.forward;
    function isSubscriptionOperation(e3) {
      var n2 = e3.kind;
      return "subscription" === n2 || !!t2 && ("query" === n2 || "mutation" === n2);
    }
    return function(e3) {
      var t3 = share$1(e3);
      var u2 = D$1(function(e4) {
        var i3 = e4.key;
        var u3 = filter$1(function(e5) {
          return "teardown" === e5.kind && e5.key === i3;
        })(t3);
        return takeUntil$1(u3)(function createSubscriptionSource(e5) {
          var t4 = n({
            key: e5.key.toString(36),
            query: print$1(e5.query),
            variables: e5.variables,
            context: _extends$3({}, e5.context)
          });
          return make$1(function(n2) {
            var r2 = n2.next;
            var o2 = n2.complete;
            var i4 = false;
            var u4;
            Promise.resolve().then(function() {
              if (i4) {
                return;
              }
              u4 = t4.subscribe({
                next: function(n3) {
                  return r2(makeResult(e5, n3));
                },
                error: function(n3) {
                  return r2(makeErrorResult(e5, n3));
                },
                complete: function() {
                  if (!i4) {
                    i4 = true;
                    if ("subscription" === e5.kind) {
                      a2.reexecuteOperation(makeOperation("teardown", e5, e5.context));
                    }
                    o2();
                  }
                }
              });
            });
            return function() {
              i4 = true;
              if (u4) {
                u4.unsubscribe();
              }
            };
          });
        }(e4));
      })(filter$1(isSubscriptionOperation)(t3));
      var c2 = i2(filter$1(function(e4) {
        return !isSubscriptionOperation(e4);
      })(t3));
      return merge$1([u2, c2]);
    };
  };
}
function dedupExchange(e) {
  var n = e.forward;
  e.dispatchDebug;
  var t2 = /* @__PURE__ */ new Set();
  function filterIncomingOperation(e2) {
    var n2 = e2.key;
    var a2 = e2.kind;
    if ("teardown" === a2) {
      t2.delete(n2);
      return true;
    }
    if ("query" !== a2 && "subscription" !== a2) {
      return true;
    }
    var o2 = t2.has(n2);
    t2.add(n2);
    return !o2;
  }
  function afterOperationResult(e2) {
    if (!e2.hasNext) {
      t2.delete(e2.operation.key);
    }
  }
  return function(e2) {
    var r2 = filter$1(filterIncomingOperation)(e2);
    return H(afterOperationResult)(n(r2));
  };
}
function fetchExchange(e) {
  var n = e.forward;
  e.dispatchDebug;
  return function(e2) {
    var t2 = share$1(e2);
    var a2 = D$1(function(e3) {
      var n2 = e3.key;
      var a3 = filter$1(function(e4) {
        return "teardown" === e4.kind && e4.key === n2;
      })(t2);
      var o3 = makeFetchBody(e3);
      var i2 = makeFetchURL(e3, o3);
      var u2 = makeFetchOptions(e3, o3);
      return H(function(n3) {
        !n3.data ? n3.error : void 0;
      })(takeUntil$1(a3)(makeFetchSource(e3, i2, u2)));
    })(filter$1(function(e3) {
      return "query" === e3.kind || "mutation" === e3.kind;
    })(t2));
    var o2 = n(filter$1(function(e3) {
      return "query" !== e3.kind && "mutation" !== e3.kind;
    })(t2));
    return merge$1([a2, o2]);
  };
}
function fallbackExchange(e) {
  e.dispatchDebug;
  return function(e2) {
    return filter$1(function() {
      return false;
    })(H(function(e3) {
      if ("teardown" !== e3.kind && false) {
        var r2 = 'No exchange has handled operations of kind "' + e3.kind + `". Check whether you've added an exchange responsible for these operations.`;
        console.warn(r2);
      }
    })(e2));
  };
}
fallbackExchange({
  dispatchDebug: noop$3
});
function composeExchanges(e) {
  return function(n) {
    var r2 = n.client;
    n.dispatchDebug;
    return e.reduceRight(function(e2, n2) {
      return n2({
        client: r2,
        forward: e2,
        dispatchDebug: function dispatchDebug$1(e3) {
        }
      });
    }, n.forward);
  };
}
function errorExchange(e) {
  var n = e.onError;
  return function(e2) {
    var r2 = e2.forward;
    return function(e3) {
      return H(function(e4) {
        var r3 = e4.error;
        if (r3) {
          n(r3, e4.operation);
        }
      })(r2(e3));
    };
  };
}
var L$1 = [dedupExchange, cacheExchange$1, fetchExchange];
var J = function Client(e) {
  var n = /* @__PURE__ */ new Map();
  var r2 = /* @__PURE__ */ new Map();
  var t2 = [];
  var a2 = makeSubject$1();
  var i2 = a2.source;
  var u2 = a2.next;
  var c2 = false;
  function dispatchOperation(e2) {
    c2 = true;
    if (e2) {
      u2(e2);
    }
    while (e2 = t2.shift()) {
      u2(e2);
    }
    c2 = false;
  }
  function makeResultSource(e2) {
    var a3 = filter$1(function(n2) {
      return n2.operation.kind === e2.kind && n2.operation.key === e2.key && (!n2.operation.context._instance || n2.operation.context._instance === e2.context._instance);
    })(y2);
    if (f2.maskTypename) {
      a3 = map$1$1(function(e3) {
        return _extends$3({}, e3, {
          data: maskTypename(e3.data)
        });
      })(a3);
    }
    if ("mutation" === e2.kind) {
      return take$1(1)(onStart$1(function() {
        return dispatchOperation(e2);
      })(a3));
    }
    return share$1(onEnd$1(function() {
      n.delete(e2.key);
      r2.delete(e2.key);
      for (var a4 = t2.length - 1; a4 >= 0; a4--) {
        if (t2[a4].key === e2.key) {
          t2.splice(a4, 1);
        }
      }
      dispatchOperation(makeOperation("teardown", e2, e2.context));
    })(H(function(r3) {
      n.set(e2.key, r3);
    })(K(function(n2) {
      if ("query" !== e2.kind || n2.stale) {
        return fromValue$1(n2);
      }
      return merge$1([fromValue$1(n2), map$1$1(function() {
        return _extends$3({}, n2, {
          stale: true
        });
      })(take$1(1)(filter$1(function(n3) {
        return "query" === n3.kind && n3.key === e2.key && "cache-only" !== n3.context.requestPolicy;
      })(i2)))]);
    })(takeUntil$1(filter$1(function(n2) {
      return "teardown" === n2.kind && n2.key === e2.key;
    })(i2))(a3)))));
  }
  var s2 = this instanceof Client ? this : Object.create(Client.prototype);
  var f2 = _extends$3(s2, {
    url: e.url,
    fetchOptions: e.fetchOptions,
    fetch: e.fetch,
    suspense: !!e.suspense,
    requestPolicy: e.requestPolicy || "cache-first",
    preferGetMethod: !!e.preferGetMethod,
    maskTypename: !!e.maskTypename,
    operations$: i2,
    reexecuteOperation: function reexecuteOperation2(e2) {
      if ("mutation" === e2.kind || r2.has(e2.key)) {
        t2.push(e2);
        if (!c2) {
          Promise.resolve().then(dispatchOperation);
        }
      }
    },
    createOperationContext: function createOperationContext(e2) {
      if (!e2) {
        e2 = {};
      }
      return _extends$3({}, {
        _instance: void 0,
        url: f2.url,
        fetchOptions: f2.fetchOptions,
        fetch: f2.fetch,
        preferGetMethod: f2.preferGetMethod
      }, e2, {
        suspense: e2.suspense || false !== e2.suspense && f2.suspense,
        requestPolicy: e2.requestPolicy || f2.requestPolicy
      });
    },
    createRequestOperation: function createRequestOperation(e2, n2, r3) {
      getOperationType(n2.query);
      var a3 = f2.createOperationContext(r3);
      if ("mutation" === e2) {
        a3._instance = [];
      }
      return makeOperation(e2, n2, a3);
    },
    executeRequestOperation: function executeRequestOperation(e2) {
      if ("mutation" === e2.kind) {
        return makeResultSource(e2);
      }
      return make$1(function(t3) {
        var a3 = r2.get(e2.key);
        if (!a3) {
          r2.set(e2.key, a3 = makeResultSource(e2));
        }
        var i3 = "cache-and-network" === e2.context.requestPolicy || "network-only" === e2.context.requestPolicy;
        return N$1(t3.next)(onEnd$1(t3.complete)(onStart$1(function() {
          var r3 = n.get(e2.key);
          if ("subscription" === e2.kind) {
            return dispatchOperation(e2);
          } else if (i3) {
            dispatchOperation(e2);
          }
          if (null != r3 && r3 === n.get(e2.key)) {
            t3.next(i3 ? _extends$3({}, r3, {
              stale: true
            }) : r3);
          } else if (!i3) {
            dispatchOperation(e2);
          }
        })(a3))).unsubscribe;
      });
    },
    executeQuery: function executeQuery(e2, n2) {
      var r3 = f2.createRequestOperation("query", e2, n2);
      return f2.executeRequestOperation(r3);
    },
    executeSubscription: function executeSubscription(e2, n2) {
      var r3 = f2.createRequestOperation("subscription", e2, n2);
      return f2.executeRequestOperation(r3);
    },
    executeMutation: function executeMutation(e2, n2) {
      var r3 = f2.createRequestOperation("mutation", e2, n2);
      return f2.executeRequestOperation(r3);
    },
    query: function query2(e2, n2, r3) {
      if (!r3 || "boolean" != typeof r3.suspense) {
        r3 = _extends$3({}, r3, {
          suspense: false
        });
      }
      return withPromise(f2.executeQuery(createRequest(e2, n2), r3));
    },
    readQuery: function readQuery2(e2, n2, r3) {
      var t3 = null;
      N$1(function(e3) {
        t3 = e3;
      })(f2.query(e2, n2, r3)).unsubscribe();
      return t3;
    },
    subscription: function subscription(e2, n2, r3) {
      return f2.executeSubscription(createRequest(e2, n2), r3);
    },
    mutation: function mutation(e2, n2, r3) {
      return withPromise(f2.executeMutation(createRequest(e2, n2), r3));
    }
  });
  var p2 = noop$3;
  var h2 = composeExchanges(void 0 !== e.exchanges ? e.exchanges : L$1);
  var y2 = share$1(h2({
    client: f2,
    dispatchDebug: p2,
    forward: fallbackExchange({
      dispatchDebug: p2
    })
  })(i2));
  publish$1(y2);
  return f2;
};
var W = J;
function _extends$2() {
  return (_extends$2 = Object.assign || function(e) {
    for (var u2 = 1; u2 < arguments.length; u2++) {
      var n = arguments[u2];
      for (var r2 in n) {
        if (Object.prototype.hasOwnProperty.call(n, r2)) {
          e[r2] = n[r2];
        }
      }
    }
    return e;
  }).apply(this, arguments);
}
function install(u2, t2) {
  var a2;
  if (!isRef(t2)) {
    a2 = ref(t2 instanceof J ? t2 : new J(t2));
  } else {
    a2 = t2;
  }
  u2.provide("$urql", a2);
}
function useClient() {
  var e = inject("$urql");
  return e;
}
function unwrapPossibleProxy(e) {
  return e && isRef(e) ? e.value : e;
}
var y = {
  flush: "pre"
};
function useQuery(e) {
  return callUseQuery(e);
}
function callUseQuery(e, t2, a2) {
  if (void 0 === t2) {
    t2 = useClient();
  }
  if (void 0 === a2) {
    a2 = [];
  }
  var i2 = reactive(e);
  var l2 = ref();
  var v = ref(false);
  var p2 = ref(false);
  var d2 = ref();
  var b2 = ref();
  var h2 = ref();
  var x2 = isRef(e.pause) ? e.pause : ref(!!e.pause);
  var w2 = ref(createRequest(i2.query, unwrapPossibleProxy(i2.variables)));
  var P = ref();
  a2.push(watchEffect(function() {
    var e2 = createRequest(i2.query, unwrapPossibleProxy(i2.variables));
    if (w2.value.key !== e2.key) {
      w2.value = e2;
    }
  }, y));
  a2.push(watchEffect(function() {
    P.value = !x2.value ? t2.value.executeQuery(w2.value, _extends$2({}, {
      requestPolicy: i2.requestPolicy
    }, i2.context)) : void 0;
  }, y));
  var Q = {
    data: l2,
    stale: v,
    error: d2,
    operation: b2,
    extensions: h2,
    fetching: p2,
    isPaused: x2,
    executeQuery: function executeQuery(e2) {
      var u2 = P.value = t2.value.executeQuery(w2.value, _extends$2({}, {
        requestPolicy: i2.requestPolicy
      }, i2.context, e2));
      return _extends$2({}, S2, {
        then: function then(e3, n) {
          return new Promise(function(e4) {
            var n2 = false;
            var r2 = N$1(function() {
              if (!Q.fetching.value && !Q.stale.value) {
                if (r2) {
                  r2.unsubscribe();
                }
                n2 = true;
                e4(Q);
              }
            })(u2);
            if (n2) {
              r2.unsubscribe();
            }
          }).then(e3, n);
        }
      });
    },
    pause: function pause() {
      x2.value = true;
    },
    resume: function resume() {
      x2.value = false;
    }
  };
  a2.push(watchEffect(function(e2) {
    if (P.value) {
      p2.value = true;
      v.value = false;
      e2(N$1(function(e3) {
        l2.value = e3.data;
        v.value = !!e3.stale;
        p2.value = false;
        d2.value = e3.error;
        b2.value = e3.operation;
        h2.value = e3.extensions;
      })(onEnd$1(function() {
        p2.value = false;
        v.value = false;
      })(P.value)).unsubscribe);
    } else {
      p2.value = false;
      v.value = false;
    }
  }, {
    flush: "sync"
  }));
  var S2 = _extends$2({}, Q, {
    then: function then(e2, u2) {
      return new Promise(function(e3) {
        if (!P.value) {
          return e3(Q);
        }
        var u3 = false;
        var n = N$1(function() {
          if (!Q.fetching.value && !Q.stale.value) {
            if (n) {
              n.unsubscribe();
            }
            u3 = true;
            e3(Q);
          }
        })(P.value);
        if (u3) {
          n.unsubscribe();
        }
      }).then(e2, u2);
    }
  });
  return S2;
}
function useMutation(e) {
  return callUseMutation(e);
}
function callUseMutation(e, n) {
  if (void 0 === n) {
    n = useClient();
  }
  var t2 = ref();
  var a2 = ref(false);
  var i2 = ref(false);
  var o2 = ref();
  var s2 = ref();
  var l2 = ref();
  return {
    data: t2,
    stale: a2,
    fetching: i2,
    error: o2,
    operation: s2,
    extensions: l2,
    executeMutation: function executeMutation(r2, v) {
      i2.value = true;
      return toPromise$1(take$1(1)(n.value.executeMutation(createRequest(e, unwrapPossibleProxy(r2)), v || {}))).then(function(e2) {
        t2.value = e2.data;
        a2.value = !!e2.stale;
        i2.value = false;
        o2.value = e2.error;
        s2.value = e2.operation;
        l2.value = e2.extensions;
        return e2;
      });
    }
  };
}
var b$1 = {
  flush: "pre"
};
function useSubscription(e, u2) {
  return callUseSubscription(e, u2);
}
function callUseSubscription(e, t2, a2, i2) {
  if (void 0 === a2) {
    a2 = useClient();
  }
  if (void 0 === i2) {
    i2 = [];
  }
  var l2 = reactive(e);
  var v = ref();
  var p2 = ref(false);
  var d2 = ref(false);
  var y2 = ref();
  var h2 = ref();
  var x2 = ref();
  var w2 = ref(t2);
  var P = isRef(e.pause) ? e.pause : ref(!!e.pause);
  var Q = ref(createRequest(l2.query, unwrapPossibleProxy(l2.variables)));
  var S2 = ref();
  i2.push(watchEffect(function() {
    var e2 = createRequest(l2.query, unwrapPossibleProxy(l2.variables));
    if (Q.value.key !== e2.key) {
      Q.value = e2;
    }
  }, b$1));
  i2.push(watchEffect(function() {
    S2.value = !P.value ? a2.value.executeSubscription(Q.value, _extends$2({}, l2.context)) : void 0;
  }, b$1));
  i2.push(watchEffect(function(e2) {
    if (S2.value) {
      d2.value = true;
      e2(N$1(function(e3) {
        d2.value = true;
        v.value = void 0 !== e3.data ? "function" == typeof w2.value ? w2.value(v.value, e3.data) : e3.data : e3.data, y2.value = e3.error;
        x2.value = e3.extensions;
        p2.value = !!e3.stale;
        h2.value = e3.operation;
      })(onEnd$1(function() {
        d2.value = false;
      })(S2.value)).unsubscribe);
    } else {
      d2.value = false;
    }
  }, b$1));
  var m2 = {
    data: v,
    stale: p2,
    error: y2,
    operation: h2,
    extensions: x2,
    fetching: d2,
    isPaused: P,
    executeSubscription: function executeSubscription(e2) {
      S2.value = a2.value.executeSubscription(Q.value, _extends$2({}, l2.context, e2));
      return m2;
    },
    pause: function pause() {
      P.value = true;
    },
    resume: function resume() {
      P.value = false;
    }
  };
  return m2;
}
const isFunction$3 = (value) => typeof value === "function";
const isString$4 = (value) => typeof value === "string";
const isNonEmptyString = (value) => isString$4(value) && value.trim().length > 0;
const isNumber$2 = (value) => typeof value === "number";
const isUndefined = (value) => typeof value === "undefined";
const isObject$4 = (value) => typeof value === "object" && value !== null;
const isJSX = (obj) => hasProp(obj, "tag") && isNonEmptyString(obj.tag);
const isTouchEvent = (event) => window.TouchEvent && event instanceof TouchEvent;
const isToastComponent = (obj) => hasProp(obj, "component") && isToastContent(obj.component);
const isVueComponent = (c2) => isFunction$3(c2) || isObject$4(c2);
const isToastContent = (obj) => !isUndefined(obj) && (isString$4(obj) || isVueComponent(obj) || isToastComponent(obj));
const isDOMRect = (obj) => isObject$4(obj) && ["height", "width", "right", "left", "top", "bottom"].every((p2) => isNumber$2(obj[p2]));
const hasProp = (obj, propKey) => (isObject$4(obj) || isFunction$3(obj)) && propKey in obj;
const getId = ((i2) => () => i2++)(0);
function getX(event) {
  return isTouchEvent(event) ? event.targetTouches[0].clientX : event.clientX;
}
function getY(event) {
  return isTouchEvent(event) ? event.targetTouches[0].clientY : event.clientY;
}
const removeElement = (el2) => {
  if (!isUndefined(el2.remove)) {
    el2.remove();
  } else if (el2.parentNode) {
    el2.parentNode.removeChild(el2);
  }
};
const getVueComponentFromObj = (obj) => {
  if (isToastComponent(obj)) {
    return getVueComponentFromObj(obj.component);
  }
  if (isJSX(obj)) {
    return defineComponent({
      render() {
        return obj;
      }
    });
  }
  return typeof obj === "string" ? obj : toRaw(unref(obj));
};
const normalizeToastComponent = (obj) => {
  if (typeof obj === "string") {
    return obj;
  }
  const props = hasProp(obj, "props") && isObject$4(obj.props) ? obj.props : {};
  const listeners = hasProp(obj, "listeners") && isObject$4(obj.listeners) ? obj.listeners : {};
  return {
    component: getVueComponentFromObj(obj),
    props,
    listeners
  };
};
const isBrowser$1 = () => typeof window !== "undefined";
class EventBus {
  constructor() {
    this.allHandlers = {};
  }
  getHandlers(eventType) {
    return this.allHandlers[eventType] || [];
  }
  on(eventType, handler) {
    const handlers = this.getHandlers(eventType);
    handlers.push(handler);
    this.allHandlers[eventType] = handlers;
  }
  off(eventType, handler) {
    const handlers = this.getHandlers(eventType);
    handlers.splice(handlers.indexOf(handler) >>> 0, 1);
  }
  emit(eventType, event) {
    const handlers = this.getHandlers(eventType);
    handlers.forEach((handler) => handler(event));
  }
}
const isEventBusInterface = (e) => ["on", "off", "emit"].every((f2) => hasProp(e, f2) && isFunction$3(e[f2]));
var TYPE;
(function(TYPE2) {
  TYPE2["SUCCESS"] = "success";
  TYPE2["ERROR"] = "error";
  TYPE2["WARNING"] = "warning";
  TYPE2["INFO"] = "info";
  TYPE2["DEFAULT"] = "default";
})(TYPE || (TYPE = {}));
var POSITION;
(function(POSITION2) {
  POSITION2["TOP_LEFT"] = "top-left";
  POSITION2["TOP_CENTER"] = "top-center";
  POSITION2["TOP_RIGHT"] = "top-right";
  POSITION2["BOTTOM_LEFT"] = "bottom-left";
  POSITION2["BOTTOM_CENTER"] = "bottom-center";
  POSITION2["BOTTOM_RIGHT"] = "bottom-right";
})(POSITION || (POSITION = {}));
var EVENTS;
(function(EVENTS2) {
  EVENTS2["ADD"] = "add";
  EVENTS2["DISMISS"] = "dismiss";
  EVENTS2["UPDATE"] = "update";
  EVENTS2["CLEAR"] = "clear";
  EVENTS2["UPDATE_DEFAULTS"] = "update_defaults";
})(EVENTS || (EVENTS = {}));
const VT_NAMESPACE = "Vue-Toastification";
const COMMON = {
  type: {
    type: String,
    default: TYPE.DEFAULT
  },
  classNames: {
    type: [String, Array],
    default: () => []
  },
  trueBoolean: {
    type: Boolean,
    default: true
  }
};
const ICON = {
  type: COMMON.type,
  customIcon: {
    type: [String, Boolean, Object, Function],
    default: true
  }
};
const CLOSE_BUTTON = {
  component: {
    type: [String, Object, Function, Boolean],
    default: "button"
  },
  classNames: COMMON.classNames,
  showOnHover: {
    type: Boolean,
    default: false
  },
  ariaLabel: {
    type: String,
    default: "close"
  }
};
const PROGRESS_BAR = {
  timeout: {
    type: [Number, Boolean],
    default: 5e3
  },
  hideProgressBar: {
    type: Boolean,
    default: false
  },
  isRunning: {
    type: Boolean,
    default: false
  }
};
const TRANSITION = {
  transition: {
    type: [Object, String],
    default: `${VT_NAMESPACE}__bounce`
  }
};
const CORE_TOAST = {
  position: {
    type: String,
    default: POSITION.TOP_RIGHT
  },
  draggable: COMMON.trueBoolean,
  draggablePercent: {
    type: Number,
    default: 0.6
  },
  pauseOnFocusLoss: COMMON.trueBoolean,
  pauseOnHover: COMMON.trueBoolean,
  closeOnClick: COMMON.trueBoolean,
  timeout: PROGRESS_BAR.timeout,
  hideProgressBar: PROGRESS_BAR.hideProgressBar,
  toastClassName: COMMON.classNames,
  bodyClassName: COMMON.classNames,
  icon: ICON.customIcon,
  closeButton: CLOSE_BUTTON.component,
  closeButtonClassName: CLOSE_BUTTON.classNames,
  showCloseButtonOnHover: CLOSE_BUTTON.showOnHover,
  accessibility: {
    type: Object,
    default: () => ({
      toastRole: "alert",
      closeButtonLabel: "close"
    })
  },
  rtl: {
    type: Boolean,
    default: false
  },
  eventBus: {
    type: Object,
    required: true,
    default: new EventBus()
  }
};
const TOAST = {
  id: {
    type: [String, Number],
    required: true,
    default: 0
  },
  type: COMMON.type,
  content: {
    type: [String, Object, Function],
    required: true,
    default: ""
  },
  onClick: {
    type: Function,
    default: () => {
    }
  },
  onClose: {
    type: Function,
    default: () => {
    }
  }
};
const CONTAINER = {
  container: {
    type: [Object, Function],
    default: () => document.body
  },
  newestOnTop: COMMON.trueBoolean,
  maxToasts: {
    type: Number,
    default: 20
  },
  transition: TRANSITION.transition,
  toastDefaults: Object,
  filterBeforeCreate: {
    type: Function,
    default: (toast) => toast
  },
  filterToasts: {
    type: Function,
    default: (toasts) => toasts
  },
  containerClassName: COMMON.classNames,
  onMounted: Function
};
var PROPS = {
  CORE_TOAST,
  TOAST,
  CONTAINER,
  PROGRESS_BAR,
  ICON,
  TRANSITION,
  CLOSE_BUTTON
};
var script$1 = defineComponent({
  name: "VtProgressBar",
  props: PROPS.PROGRESS_BAR,
  data() {
    return {
      hasClass: true
    };
  },
  computed: {
    style() {
      return {
        animationDuration: `${this.timeout}ms`,
        animationPlayState: this.isRunning ? "running" : "paused",
        opacity: this.hideProgressBar ? 0 : 1
      };
    },
    cpClass() {
      return this.hasClass ? `${VT_NAMESPACE}__progress-bar` : "";
    }
  },
  watch: {
    timeout() {
      this.hasClass = false;
      this.$nextTick(() => this.hasClass = true);
    }
  },
  mounted() {
    this.$el.addEventListener("animationend", this.animationEnded);
  },
  beforeUnmount() {
    this.$el.removeEventListener("animationend", this.animationEnded);
  },
  methods: {
    animationEnded() {
      this.$emit("close-toast");
    }
  }
});
function render$1d(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock("div", {
    style: _ctx.style,
    class: _ctx.cpClass
  }, null, 6);
}
script$1.render = render$1d;
script$1.__file = "src/components/VtProgressBar.vue";
var script$1$1 = defineComponent({
  name: "VtCloseButton",
  props: PROPS.CLOSE_BUTTON,
  computed: {
    buttonComponent() {
      if (this.component !== false) {
        return getVueComponentFromObj(this.component);
      }
      return "button";
    },
    classes() {
      const classes = [`${VT_NAMESPACE}__close-button`];
      if (this.showOnHover) {
        classes.push("show-on-hover");
      }
      return classes.concat(this.classNames);
    }
  }
});
const _hoisted_1$2n = /* @__PURE__ */ createTextVNode(" × ");
function render$1$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(resolveDynamicComponent(_ctx.buttonComponent), mergeProps({
    "aria-label": _ctx.ariaLabel,
    class: _ctx.classes
  }, _ctx.$attrs), {
    default: withCtx(() => [
      _hoisted_1$2n
    ]),
    _: 1
  }, 16, ["aria-label", "class"]);
}
script$1$1.render = render$1$1;
script$1$1.__file = "src/components/VtCloseButton.vue";
var script$2 = {};
const _hoisted_1$1$2 = {
  "aria-hidden": "true",
  focusable: "false",
  "data-prefix": "fas",
  "data-icon": "check-circle",
  class: "svg-inline--fa fa-check-circle fa-w-16",
  role: "img",
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 512 512"
};
const _hoisted_2$24 = /* @__PURE__ */ createVNode("path", {
  fill: "currentColor",
  d: "M504 256c0 136.967-111.033 248-248 248S8 392.967 8 256 119.033 8 256 8s248 111.033 248 248zM227.314 387.314l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.249-16.379-6.249-22.628 0L216 308.118l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.249 16.379 6.249 22.628.001z"
}, null, -1);
function render$2$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock("svg", _hoisted_1$1$2, [
    _hoisted_2$24
  ]);
}
script$2.render = render$2$1;
script$2.__file = "src/components/icons/VtSuccessIcon.vue";
var script$3 = {};
const _hoisted_1$2$2 = {
  "aria-hidden": "true",
  focusable: "false",
  "data-prefix": "fas",
  "data-icon": "info-circle",
  class: "svg-inline--fa fa-info-circle fa-w-16",
  role: "img",
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 512 512"
};
const _hoisted_2$1$2 = /* @__PURE__ */ createVNode("path", {
  fill: "currentColor",
  d: "M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z"
}, null, -1);
function render$3$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock("svg", _hoisted_1$2$2, [
    _hoisted_2$1$2
  ]);
}
script$3.render = render$3$1;
script$3.__file = "src/components/icons/VtInfoIcon.vue";
var script$4 = {};
const _hoisted_1$3$1 = {
  "aria-hidden": "true",
  focusable: "false",
  "data-prefix": "fas",
  "data-icon": "exclamation-circle",
  class: "svg-inline--fa fa-exclamation-circle fa-w-16",
  role: "img",
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 512 512"
};
const _hoisted_2$2$1 = /* @__PURE__ */ createVNode("path", {
  fill: "currentColor",
  d: "M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z"
}, null, -1);
function render$4$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock("svg", _hoisted_1$3$1, [
    _hoisted_2$2$1
  ]);
}
script$4.render = render$4$1;
script$4.__file = "src/components/icons/VtWarningIcon.vue";
var script$5 = {};
const _hoisted_1$4$1 = {
  "aria-hidden": "true",
  focusable: "false",
  "data-prefix": "fas",
  "data-icon": "exclamation-triangle",
  class: "svg-inline--fa fa-exclamation-triangle fa-w-18",
  role: "img",
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 576 512"
};
const _hoisted_2$3$1 = /* @__PURE__ */ createVNode("path", {
  fill: "currentColor",
  d: "M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z"
}, null, -1);
function render$5$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock("svg", _hoisted_1$4$1, [
    _hoisted_2$3$1
  ]);
}
script$5.render = render$5$1;
script$5.__file = "src/components/icons/VtErrorIcon.vue";
var script$6 = defineComponent({
  name: "VtIcon",
  props: PROPS.ICON,
  computed: {
    customIconChildren() {
      return hasProp(this.customIcon, "iconChildren") ? this.trimValue(this.customIcon.iconChildren) : "";
    },
    customIconClass() {
      if (isString$4(this.customIcon)) {
        return this.trimValue(this.customIcon);
      } else if (hasProp(this.customIcon, "iconClass")) {
        return this.trimValue(this.customIcon.iconClass);
      }
      return "";
    },
    customIconTag() {
      if (hasProp(this.customIcon, "iconTag")) {
        return this.trimValue(this.customIcon.iconTag, "i");
      }
      return "i";
    },
    hasCustomIcon() {
      return this.customIconClass.length > 0;
    },
    component() {
      if (this.hasCustomIcon) {
        return this.customIconTag;
      }
      if (isToastContent(this.customIcon)) {
        return getVueComponentFromObj(this.customIcon);
      }
      return this.iconTypeComponent;
    },
    iconTypeComponent() {
      const types = {
        [TYPE.DEFAULT]: script$3,
        [TYPE.INFO]: script$3,
        [TYPE.SUCCESS]: script$2,
        [TYPE.ERROR]: script$5,
        [TYPE.WARNING]: script$4
      };
      return types[this.type];
    },
    iconClasses() {
      const classes = [`${VT_NAMESPACE}__icon`];
      if (this.hasCustomIcon) {
        return classes.concat(this.customIconClass);
      }
      return classes;
    }
  },
  methods: {
    trimValue(value, empty2 = "") {
      return isNonEmptyString(value) ? value.trim() : empty2;
    }
  }
});
function render$6$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(resolveDynamicComponent(_ctx.component), { class: _ctx.iconClasses }, {
    default: withCtx(() => [
      createTextVNode(toDisplayString$1(_ctx.customIconChildren), 1)
    ]),
    _: 1
  }, 8, ["class"]);
}
script$6.render = render$6$1;
script$6.__file = "src/components/VtIcon.vue";
var script$7 = defineComponent({
  name: "VtToast",
  components: {
    ProgressBar: script$1,
    CloseButton: script$1$1,
    Icon: script$6
  },
  inheritAttrs: false,
  props: Object.assign({}, PROPS.CORE_TOAST, PROPS.TOAST),
  data() {
    const data = {
      isRunning: true,
      disableTransitions: false,
      beingDragged: false,
      dragStart: 0,
      dragPos: {
        x: 0,
        y: 0
      },
      dragRect: {}
    };
    return data;
  },
  computed: {
    classes() {
      const classes = [`${VT_NAMESPACE}__toast`, `${VT_NAMESPACE}__toast--${this.type}`, `${this.position}`].concat(this.toastClassName);
      if (this.disableTransitions) {
        classes.push("disable-transition");
      }
      if (this.rtl) {
        classes.push(`${VT_NAMESPACE}__toast--rtl`);
      }
      return classes;
    },
    bodyClasses() {
      const classes = [`${VT_NAMESPACE}__toast-${isString$4(this.content) ? "body" : "component-body"}`].concat(this.bodyClassName);
      return classes;
    },
    draggableStyle() {
      if (this.dragStart === this.dragPos.x) {
        return {};
      } else if (this.beingDragged) {
        return {
          transform: `translateX(${this.dragDelta}px)`,
          opacity: 1 - Math.abs(this.dragDelta / this.removalDistance)
        };
      } else {
        return {
          transition: "transform 0.2s, opacity 0.2s",
          transform: "translateX(0)",
          opacity: 1
        };
      }
    },
    dragDelta() {
      return this.beingDragged ? this.dragPos.x - this.dragStart : 0;
    },
    removalDistance() {
      if (isDOMRect(this.dragRect)) {
        return (this.dragRect.right - this.dragRect.left) * this.draggablePercent;
      }
      return 0;
    }
  },
  mounted() {
    if (this.draggable) {
      this.draggableSetup();
    }
    if (this.pauseOnFocusLoss) {
      this.focusSetup();
    }
  },
  beforeUnmount() {
    if (this.draggable) {
      this.draggableCleanup();
    }
    if (this.pauseOnFocusLoss) {
      this.focusCleanup();
    }
  },
  methods: {
    getVueComponentFromObj,
    closeToast() {
      this.eventBus.emit(EVENTS.DISMISS, this.id);
    },
    clickHandler() {
      if (this.onClick) {
        this.onClick(this.closeToast);
      }
      if (this.closeOnClick) {
        if (!this.beingDragged || this.dragStart === this.dragPos.x) {
          this.closeToast();
        }
      }
    },
    timeoutHandler() {
      this.closeToast();
    },
    hoverPause() {
      if (this.pauseOnHover) {
        this.isRunning = false;
      }
    },
    hoverPlay() {
      if (this.pauseOnHover) {
        this.isRunning = true;
      }
    },
    focusPause() {
      this.isRunning = false;
    },
    focusPlay() {
      this.isRunning = true;
    },
    focusSetup() {
      addEventListener("blur", this.focusPause);
      addEventListener("focus", this.focusPlay);
    },
    focusCleanup() {
      removeEventListener("blur", this.focusPause);
      removeEventListener("focus", this.focusPlay);
    },
    draggableSetup() {
      const element = this.$el;
      element.addEventListener("touchstart", this.onDragStart, {
        passive: true
      });
      element.addEventListener("mousedown", this.onDragStart);
      addEventListener("touchmove", this.onDragMove, {
        passive: false
      });
      addEventListener("mousemove", this.onDragMove);
      addEventListener("touchend", this.onDragEnd);
      addEventListener("mouseup", this.onDragEnd);
    },
    draggableCleanup() {
      const element = this.$el;
      element.removeEventListener("touchstart", this.onDragStart);
      element.removeEventListener("mousedown", this.onDragStart);
      removeEventListener("touchmove", this.onDragMove);
      removeEventListener("mousemove", this.onDragMove);
      removeEventListener("touchend", this.onDragEnd);
      removeEventListener("mouseup", this.onDragEnd);
    },
    onDragStart(event) {
      this.beingDragged = true;
      this.dragPos = {
        x: getX(event),
        y: getY(event)
      };
      this.dragStart = getX(event);
      this.dragRect = this.$el.getBoundingClientRect();
    },
    onDragMove(event) {
      if (this.beingDragged) {
        event.preventDefault();
        if (this.isRunning) {
          this.isRunning = false;
        }
        this.dragPos = {
          x: getX(event),
          y: getY(event)
        };
      }
    },
    onDragEnd() {
      if (this.beingDragged) {
        if (Math.abs(this.dragDelta) >= this.removalDistance) {
          this.disableTransitions = true;
          this.$nextTick(() => this.closeToast());
        } else {
          setTimeout(() => {
            this.beingDragged = false;
            if (isDOMRect(this.dragRect) && this.pauseOnHover && this.dragRect.bottom >= this.dragPos.y && this.dragPos.y >= this.dragRect.top && this.dragRect.left <= this.dragPos.x && this.dragPos.x <= this.dragRect.right) {
              this.isRunning = false;
            } else {
              this.isRunning = true;
            }
          });
        }
      }
    }
  }
});
function render$7$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = resolveComponent("Icon");
  const _component_CloseButton = resolveComponent("CloseButton");
  const _component_ProgressBar = resolveComponent("ProgressBar");
  return openBlock(), createBlock("div", {
    class: _ctx.classes,
    style: _ctx.draggableStyle,
    onClick: _cache[1] || (_cache[1] = (...args) => _ctx.clickHandler(...args)),
    onMouseenter: _cache[2] || (_cache[2] = (...args) => _ctx.hoverPause(...args)),
    onMouseleave: _cache[3] || (_cache[3] = (...args) => _ctx.hoverPlay(...args))
  }, [
    _ctx.icon ? (openBlock(), createBlock(_component_Icon, {
      key: 0,
      "custom-icon": _ctx.icon,
      type: _ctx.type
    }, null, 8, ["custom-icon", "type"])) : createCommentVNode("v-if", true),
    createVNode("div", {
      role: _ctx.accessibility.toastRole || "alert",
      class: _ctx.bodyClasses
    }, [
      typeof _ctx.content === "string" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
        createTextVNode(toDisplayString$1(_ctx.content), 1)
      ], 64)) : (openBlock(), createBlock(resolveDynamicComponent(_ctx.getVueComponentFromObj(_ctx.content)), mergeProps({
        key: 1,
        "toast-id": _ctx.id
      }, _ctx.content.props, toHandlers(_ctx.content.listeners), { onCloseToast: _ctx.closeToast }), null, 16, ["toast-id", "onCloseToast"]))
    ], 10, ["role"]),
    !!_ctx.closeButton ? (openBlock(), createBlock(_component_CloseButton, {
      key: 1,
      component: _ctx.closeButton,
      "class-names": _ctx.closeButtonClassName,
      "show-on-hover": _ctx.showCloseButtonOnHover,
      "aria-label": _ctx.accessibility.closeButtonLabel,
      onClick: withModifiers(_ctx.closeToast, ["stop"])
    }, null, 8, ["component", "class-names", "show-on-hover", "aria-label", "onClick"])) : createCommentVNode("v-if", true),
    _ctx.timeout ? (openBlock(), createBlock(_component_ProgressBar, {
      key: 2,
      "is-running": _ctx.isRunning,
      "hide-progress-bar": _ctx.hideProgressBar,
      timeout: _ctx.timeout,
      onCloseToast: _ctx.timeoutHandler
    }, null, 8, ["is-running", "hide-progress-bar", "timeout", "onCloseToast"])) : createCommentVNode("v-if", true)
  ], 38);
}
script$7.render = render$7$1;
script$7.__file = "src/components/VtToast.vue";
var script$8 = defineComponent({
  name: "VtTransition",
  props: PROPS.TRANSITION,
  emits: ["leave"],
  methods: {
    leave(el2) {
      el2.style.left = el2.offsetLeft + "px";
      el2.style.top = el2.offsetTop + "px";
      el2.style.width = getComputedStyle(el2).width;
      el2.style.position = "absolute";
    }
  }
});
function render$8$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock(TransitionGroup, {
    tag: "div",
    "enter-active-class": _ctx.transition.enter ? _ctx.transition.enter : `${_ctx.transition}-enter-active`,
    "move-class": _ctx.transition.move ? _ctx.transition.move : `${_ctx.transition}-move`,
    "leave-active-class": _ctx.transition.leave ? _ctx.transition.leave : `${_ctx.transition}-leave-active`,
    onLeave: _ctx.leave
  }, {
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default")
    ]),
    _: 3
  }, 8, ["enter-active-class", "move-class", "leave-active-class", "onLeave"]);
}
script$8.render = render$8$1;
script$8.__file = "src/components/VtTransition.vue";
var script$9 = defineComponent({
  name: "VueToastification",
  components: {
    Toast: script$7,
    VtTransition: script$8
  },
  props: Object.assign({}, PROPS.CORE_TOAST, PROPS.CONTAINER, PROPS.TRANSITION),
  data() {
    const data = {
      count: 0,
      positions: Object.values(POSITION),
      toasts: {},
      defaults: {}
    };
    return data;
  },
  computed: {
    toastArray() {
      return Object.values(this.toasts);
    },
    filteredToasts() {
      return this.defaults.filterToasts(this.toastArray);
    }
  },
  beforeMount() {
    const events = this.eventBus;
    events.on(EVENTS.ADD, this.addToast);
    events.on(EVENTS.CLEAR, this.clearToasts);
    events.on(EVENTS.DISMISS, this.dismissToast);
    events.on(EVENTS.UPDATE, this.updateToast);
    events.on(EVENTS.UPDATE_DEFAULTS, this.updateDefaults);
    this.defaults = this.$props;
  },
  mounted() {
    this.setup(this.container);
  },
  methods: {
    async setup(container) {
      if (isFunction$3(container)) {
        container = await container();
      }
      removeElement(this.$el);
      container.appendChild(this.$el);
    },
    setToast(props) {
      if (!isUndefined(props.id)) {
        this.toasts[props.id] = props;
      }
    },
    addToast(params2) {
      params2.content = normalizeToastComponent(params2.content);
      const props = Object.assign({}, this.defaults, params2.type && this.defaults.toastDefaults && this.defaults.toastDefaults[params2.type], params2);
      const toast = this.defaults.filterBeforeCreate(props, this.toastArray);
      toast && this.setToast(toast);
    },
    dismissToast(id2) {
      const toast = this.toasts[id2];
      if (!isUndefined(toast) && !isUndefined(toast.onClose)) {
        toast.onClose();
      }
      delete this.toasts[id2];
    },
    clearToasts() {
      Object.keys(this.toasts).forEach((id2) => {
        this.dismissToast(id2);
      });
    },
    getPositionToasts(position) {
      const toasts = this.filteredToasts.filter((toast) => toast.position === position).slice(0, this.defaults.maxToasts);
      return this.defaults.newestOnTop ? toasts.reverse() : toasts;
    },
    updateDefaults(update) {
      if (!isUndefined(update.container)) {
        this.setup(update.container);
      }
      this.defaults = Object.assign({}, this.defaults, update);
    },
    updateToast({
      id: id2,
      options: options2,
      create
    }) {
      if (this.toasts[id2]) {
        if (options2.timeout && options2.timeout === this.toasts[id2].timeout) {
          options2.timeout++;
        }
        this.setToast(Object.assign({}, this.toasts[id2], options2));
      } else if (create) {
        this.addToast(Object.assign({}, {
          id: id2
        }, options2));
      }
    },
    getClasses(position) {
      const classes = [`${VT_NAMESPACE}__container`, position];
      return classes.concat(this.defaults.containerClassName);
    }
  }
});
function render$9$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Toast = resolveComponent("Toast");
  const _component_VtTransition = resolveComponent("VtTransition");
  return openBlock(), createBlock("div", null, [
    (openBlock(true), createBlock(Fragment, null, renderList(_ctx.positions, (pos) => {
      return openBlock(), createBlock("div", { key: pos }, [
        createVNode(_component_VtTransition, {
          transition: _ctx.defaults.transition,
          class: _ctx.getClasses(pos)
        }, {
          default: withCtx(() => [
            (openBlock(true), createBlock(Fragment, null, renderList(_ctx.getPositionToasts(pos), (toast) => {
              return openBlock(), createBlock(_component_Toast, mergeProps({
                key: toast.id
              }, toast), null, 16);
            }), 128))
          ]),
          _: 2
        }, 1032, ["transition", "class"])
      ]);
    }), 128))
  ]);
}
script$9.render = render$9$1;
script$9.__file = "src/components/VtToastContainer.vue";
const buildInterface = (globalOptions = {}, mountContainer = true) => {
  const events = globalOptions.eventBus = globalOptions.eventBus || new EventBus();
  if (mountContainer) {
    nextTick(() => {
      const app2 = createApp(script$9, Object.assign({}, globalOptions));
      const component = app2.mount(document.createElement("div"));
      const onMounted2 = globalOptions.onMounted;
      if (!isUndefined(onMounted2)) {
        onMounted2(component, app2);
      }
    });
  }
  const toast = (content, options2) => {
    const props = Object.assign({}, {
      id: getId(),
      type: TYPE.DEFAULT
    }, options2, {
      content
    });
    events.emit(EVENTS.ADD, props);
    return props.id;
  };
  toast.clear = () => events.emit(EVENTS.CLEAR, void 0);
  toast.updateDefaults = (update) => {
    events.emit(EVENTS.UPDATE_DEFAULTS, update);
  };
  toast.dismiss = (id2) => {
    events.emit(EVENTS.DISMISS, id2);
  };
  function updateToast(id2, {
    content,
    options: options2
  }, create = false) {
    const opt = Object.assign({}, options2, {
      content
    });
    events.emit(EVENTS.UPDATE, {
      id: id2,
      options: opt,
      create
    });
  }
  toast.update = updateToast;
  toast.success = (content, options2) => toast(content, Object.assign({}, options2, {
    type: TYPE.SUCCESS
  }));
  toast.info = (content, options2) => toast(content, Object.assign({}, options2, {
    type: TYPE.INFO
  }));
  toast.error = (content, options2) => toast(content, Object.assign({}, options2, {
    type: TYPE.ERROR
  }));
  toast.warning = (content, options2) => toast(content, Object.assign({}, options2, {
    type: TYPE.WARNING
  }));
  return toast;
};
const createMockToastInterface = () => {
  const toast = () => console.warn("[Vue Toastification] This plugin does not support SSR!");
  return new Proxy(toast, {
    get() {
      return toast;
    }
  });
};
function createToastInterface(optionsOrEventBus) {
  if (!isBrowser$1()) {
    return createMockToastInterface();
  }
  if (isEventBusInterface(optionsOrEventBus)) {
    return buildInterface({
      eventBus: optionsOrEventBus
    }, false);
  }
  return buildInterface(optionsOrEventBus, true);
}
const toastInjectionKey = Symbol("VueToastification");
const globalEventBus = new EventBus();
const VueToastificationPlugin = (App, options2) => {
  const inter = createToastInterface(Object.assign({
    eventBus: globalEventBus
  }, options2));
  App.provide(toastInjectionKey, inter);
};
const useToast = (eventBus) => {
  if (eventBus) {
    return createToastInterface(eventBus);
  }
  const toast = getCurrentInstance() ? inject(toastInjectionKey) : void 0;
  return toast ? toast : createToastInterface(globalEventBus);
};
const _hoisted_1$2m = {
  height: "1em",
  width: "1em",
  style: { "min-width": "16px", "min-height": "16px" },
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$23 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M9 12L13 8M13 8L9 4M13 8L3 8",
  stroke: "currentColor",
  class: "icon-dark",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round"
}, null, -1);
const _hoisted_3$1N = [
  _hoisted_2$23
];
function render$1c(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$2m, _hoisted_3$1N);
}
const __unplugin_components_0$n = { name: "cy-arrow-right_x16", render: render$1c };
const _hoisted_1$2l = {
  key: 0,
  class: "top-0 right-0 text-teal-600 ribbon absolute",
  "aria-hidden": "true"
};
const _hoisted_2$22 = ["disabled"];
const _hoisted_3$1M = { class: "tracking-tight text-gray-600 text-14px leading-20px" };
const _sfc_main$1y = /* @__PURE__ */ defineComponent({
  props: {
    title: null,
    description: null,
    icon: null,
    hoverIcon: { default: void 0 },
    variant: null,
    iconSize: null,
    disabled: { type: Boolean, default: false },
    badgeText: { default: "" }
  },
  emits: ["click"],
  setup(__props, { emit: emits }) {
    const props = __props;
    const classMap = {
      indigo: "icon-dark-indigo-400 icon-light-indigo-100 icon-light-secondary-jade-200 icon-dark-secondary-jade-400",
      jade: "icon-dark-jade-400 icon-light-jade-100"
    };
    const iconMargin = computed(() => {
      return props.iconSize === 64 ? 32 : 8;
    });
    const iconClass = computed(() => {
      return [`w-${props.iconSize}px h-${props.iconSize}px`, props.disabled ? "icon-dark-gray-600 icon-light-gray-100 icon-dark-secondary-gray-600 icon-light-secondary-gray-300" : classMap[props.variant]].join(" ");
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["rounded h-auto outline-none border-1 border-gray-100 text-center relative block group children:hyphens-manual", {
          "bg-gray-50 cursor-default": __props.disabled,
          "cursor-pointer focus-within-default hocus-default": !__props.disabled
        }]),
        "data-cy": "card",
        onClick: _cache[0] || (_cache[0] = ($event) => !__props.disabled && emits("click"))
      }, [
        __props.badgeText ? (openBlock(), createElementBlock("div", _hoisted_1$2l, toDisplayString$1(__props.badgeText), 1)) : createCommentVNode("", true),
        createBaseVNode("div", {
          class: normalizeClass(["mx-auto children:transition-all children:duration-300", `w-${__props.iconSize}px h-${__props.iconSize}px mb-${unref(iconMargin)}px`])
        }, [
          __props.hoverIcon ? (openBlock(), createBlock(resolveDynamicComponent(__props.hoverIcon), {
            key: 0,
            class: normalizeClass(["opacity-0 absolute", [unref(iconClass), { "group-hover:opacity-100 group-focus:opacity-100": !__props.disabled }]]),
            "data-cy": "card-icon"
          }, null, 8, ["class"])) : createCommentVNode("", true),
          (openBlock(), createBlock(resolveDynamicComponent(__props.icon), {
            class: normalizeClass([
              "opacity-100",
              [
                __props.hoverIcon && !__props.disabled ? "group-hover:opacity-0" : void 0,
                unref(iconClass)
              ]
            ]),
            "data-cy": "card-icon"
          }, null, 8, ["class"]))
        ], 2),
        createBaseVNode("button", {
          class: normalizeClass(["font-medium mx-8px mb-8px text-18px leading-24px focus:outline-transparent", {
            "text-gray-700 cursor-default": __props.disabled,
            "text-indigo-500": !__props.disabled
          }]),
          disabled: __props.disabled
        }, toDisplayString$1(__props.title), 11, _hoisted_2$22),
        createBaseVNode("p", _hoisted_3$1M, [
          renderSlot(_ctx.$slots, "default", {}, () => [
            createTextVNode(toDisplayString$1(__props.description), 1)
          ], true)
        ]),
        renderSlot(_ctx.$slots, "footer", {}, void 0, true)
      ], 2);
    };
  }
});
const Card_vue_vue_type_style_index_0_scoped_4e2cc05a_lang = "";
const _export_sfc$1 = (sfc, props) => {
  const target2 = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target2[key] = val;
  }
  return target2;
};
const Card = /* @__PURE__ */ _export_sfc$1(_sfc_main$1y, [["__scopeId", "data-v-4e2cc05a"]]);
const _hoisted_1$2k = {
  height: "1em",
  width: "1em",
  style: { "min-width": "16px", "min-height": "16px" },
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$21 = /* @__PURE__ */ createBaseVNode("circle", {
  cx: "8",
  cy: "8",
  r: "3",
  "stroke-linecap": "round",
  "stroke-linejoin": "round",
  fill: "#F3F4FA",
  stroke: "#D0D2E0",
  class: "icon-dark-stroke icon-light-fill"
}, null, -1);
const _hoisted_3$1L = [
  _hoisted_2$21
];
function render$1b(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$2k, _hoisted_3$1L);
}
const __unplugin_components_0$m = { name: "cy-grommet_x16", render: render$1b };
const _sfc_main$1x = /* @__PURE__ */ defineComponent({
  props: {
    status: { type: Boolean },
    title: null
  },
  setup(__props) {
    const props = __props;
    return (_ctx, _cache) => {
      const _component_i_cy_grommet_x16 = __unplugin_components_0$m;
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["border rounded-full font-medium p-5px pr-16px text-size-14px leading-20px inline-flex items-center relative", { "text-jade-500": props.status, "text-gray-600": !props.status }])
      }, [
        createVNode(_component_i_cy_grommet_x16, {
          class: normalizeClass(["h-16px mr-4px ml-4px w-16px", { "icon-light-jade-400 icon-dark-jade-400": props.status, "icon-dark-gray-200 icon-dark-gray-50": !props.status }])
        }, null, 8, ["class"]),
        createTextVNode(" " + toDisplayString$1(props.title), 1)
      ], 2);
    };
  }
});
const _hoisted_1$2j = {
  height: "1em",
  width: "1em",
  style: { "min-width": "64px", "min-height": "64px" },
  viewBox: "0 0 64 64",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$20 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M55.5 55C56.3284 55 57 54.3284 57 53.5V19.5C57 18.6716 56.3284 18 55.5 18H48V44.5C48 45.3285 47.3284 46 46.5 46H16V53.5C16 54.3284 16.6716 55 17.5 55H55.5Z",
  fill: "#69D3A7",
  class: "icon-light"
}, null, -1);
const _hoisted_3$1K = /* @__PURE__ */ createBaseVNode("path", {
  d: "M48 10.5C48 9.67157 47.3284 9 46.5 9H8.5C7.67157 9 7 9.67157 7 10.5V18H48V10.5Z",
  fill: "#69D3A7",
  class: "icon-light"
}, null, -1);
const _hoisted_4$15 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M7 18V44.5C7 45.3285 7.67157 46 8.5 46H16M7 18V10.5C7 9.67157 7.67157 9 8.5 9H46.5C47.3284 9 48 9.67157 48 10.5V18M7 18H48M16 46H46.5C47.3284 46 48 45.3285 48 44.5V18M16 46V53.5C16 54.3284 16.6716 55 17.5 55H55.5C56.3284 55 57 54.3284 57 53.5V19.5C57 18.6716 56.3284 18 55.5 18H48M43 13.5H25M11.9987 13.5H12.0133M16 13.5H16.0133M20 13.5H20.0133",
  stroke: "#007780",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round",
  class: "icon-dark"
}, null, -1);
const _hoisted_5$H = [
  _hoisted_2$20,
  _hoisted_3$1K,
  _hoisted_4$15
];
function render$1a(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$2j, _hoisted_5$H);
}
const IconE2E = { name: "cy-testing-type-e2e_x64", render: render$1a };
const _hoisted_1$2i = {
  height: "1em",
  width: "1em",
  style: { "min-width": "64px", "min-height": "64px" },
  viewBox: "0 0 64 64",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1$ = /* @__PURE__ */ createBaseVNode("path", {
  d: "M9 8C7.34315 8 6 9.34315 6 11V44C6 45.6569 7.34314 47 9 47H46C47.6569 47 49 45.6569 49 44V11C49 9.34315 47.6569 8 46 8H9Z",
  fill: "#69D3A7",
  class: "icon-light"
}, null, -1);
const _hoisted_3$1J = /* @__PURE__ */ createBaseVNode("path", {
  d: "M55 56C56.6569 56 58 54.6569 58 53V20C58 18.3431 56.6569 17 55 17H49V44C49 45.6569 47.6569 47 46 47H15V53C15 54.6569 16.3431 56 18 56H55Z",
  fill: "#00595D",
  class: "icon-dark"
}, null, -1);
const _hoisted_4$14 = /* @__PURE__ */ createBaseVNode("path", {
  "fill-rule": "evenodd",
  "clip-rule": "evenodd",
  d: "M49 11C49 9.34315 47.6569 8 46 8H9C7.34315 8 6 9.34315 6 11V17H49V11ZM44 11.5C44.5523 11.5 45 11.9477 45 12.5C45 13.0523 44.5523 13.5 44 13.5H25C24.4477 13.5 24 13.0523 24 12.5C24 11.9477 24.4477 11.5 25 11.5H44ZM11 13.5C10.4477 13.5 10 13.0523 10 12.5C10 11.9477 10.4477 11.5 11 11.5C11.5523 11.5 12 11.9477 12 12.5C12 13.0523 11.5523 13.5 11 13.5ZM15 11.5C14.4477 11.5 14 11.9477 14 12.5C14 13.0523 14.4477 13.5 15 13.5C15.5523 13.5 16 13.0523 16 12.5C16 11.9477 15.5523 11.5 15 11.5ZM19 13.5C18.4477 13.5 18 13.0523 18 12.5C18 11.9477 18.4477 11.5 19 11.5C19.5523 11.5 20 11.9477 20 12.5C20 13.0523 19.5523 13.5 19 13.5Z",
  fill: "#00595D",
  class: "icon-dark"
}, null, -1);
const _hoisted_5$G = [
  _hoisted_2$1$,
  _hoisted_3$1J,
  _hoisted_4$14
];
function render$19(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$2i, _hoisted_5$G);
}
const IconE2ESolid = { name: "cy-testing-type-e2e-solid_x64", render: render$19 };
const _hoisted_1$2h = {
  height: "1em",
  width: "1em",
  style: { "min-width": "64px", "min-height": "64px" },
  viewBox: "0 0 64 64",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1_ = /* @__PURE__ */ createBaseVNode("path", {
  d: "M36 5H57.5C58.3284 5 59 5.67157 59 6.5V28H36V5Z",
  fill: "#69D3A7",
  class: "icon-light"
}, null, -1);
const _hoisted_3$1I = /* @__PURE__ */ createBaseVNode("path", {
  d: "M32 32H9V53.5C9 54.3284 9.67157 55 10.5 55H32V32Z",
  fill: "#69D3A7",
  class: "icon-light"
}, null, -1);
const _hoisted_4$13 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M32 9H33V8H32V9ZM36 5V4H35V5H36ZM59 28V29H60V28H59ZM36 28H35V29H36V28ZM55 32H56V31H55V32ZM10.5 10H32V8H10.5V10ZM31 9V32H33V9H31ZM32 31H9V33H32V31ZM10 32V10.5H8V32H10ZM31 32V55H33V32H31ZM32 54H10.5V56H32V54ZM10 53.5V32H8V53.5H10ZM36 6H57.5V4H36V6ZM58 6.5V28H60V6.5H58ZM59 27H36V29H59V27ZM37 28V5H35V28H37ZM32 33H55V31H32V33ZM54 32V53.5H56V32H54ZM53.5 54H32V56H53.5V54ZM54 53.5C54 53.7761 53.7761 54 53.5 54V56C54.8807 56 56 54.8807 56 53.5H54ZM57.5 6C57.7762 6 58 6.22386 58 6.5H60C60 5.11929 58.8807 4 57.5 4V6ZM10.5 54C10.2239 54 10 53.7761 10 53.5H8C8 54.8807 9.11929 56 10.5 56V54ZM10.5 8C9.11929 8 8 9.11929 8 10.5H10C10 10.2239 10.2239 10 10.5 10V8Z",
  fill: "#007780",
  class: "icon-dark"
}, null, -1);
const _hoisted_5$F = [
  _hoisted_2$1_,
  _hoisted_3$1I,
  _hoisted_4$13
];
function render$18(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$2h, _hoisted_5$F);
}
const IconComponent = { name: "cy-testing-type-component_x64", render: render$18 };
const _hoisted_1$2g = {
  height: "1em",
  width: "1em",
  style: { "min-width": "64px", "min-height": "64px" },
  "data-cy": "testing-type-component",
  viewBox: "0 0 64 64",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1Z = /* @__PURE__ */ createBaseVNode("path", {
  d: "M36 4H57C58.6569 4 60 5.34315 60 7V28H36V4Z",
  fill: "#00595D",
  class: "icon-dark"
}, null, -1);
const _hoisted_3$1H = /* @__PURE__ */ createBaseVNode("path", {
  d: "M32 56H11C9.34315 56 8 54.6568 8 53V32H32V56Z",
  fill: "#00595D",
  class: "icon-dark"
}, null, -1);
const _hoisted_4$12 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M36 28H34C34 29.1046 34.8954 30 36 30V28ZM8 32V30C6.89543 30 6 30.8954 6 32H8ZM32 56V58C33.1046 58 34 57.1045 34 56H32ZM36 4V2H34V4H36ZM60 28V30H62V28H60ZM32 32H34C34 30.8954 33.1046 30 32 30V32ZM32 54H11V58H32V54ZM10 53V32H6V53H10ZM36 6H57V2H36V6ZM58 7V28H62V7H58ZM60 26H36V30H60V26ZM38 28V4H34V28H38ZM30 32V56H34V32H30ZM32 30H8V34H32V30ZM57 6C57.5523 6 58 6.44772 58 7H62C62 4.23858 59.7614 2 57 2V6ZM11 54C10.4477 54 10 53.5522 10 53H6C6 55.7614 8.23858 58 11 58V54Z",
  class: "icon-light"
}, null, -1);
const _hoisted_5$E = /* @__PURE__ */ createBaseVNode("path", {
  d: "M11 8H32V32H56V53C56 54.6569 54.6568 56 53 56H32L32 32H8V11C8 9.34315 9.34315 8 11 8Z",
  fill: "#69D3A7",
  class: "icon-light"
}, null, -1);
const _hoisted_6$n = [
  _hoisted_2$1Z,
  _hoisted_3$1H,
  _hoisted_4$12,
  _hoisted_5$E
];
function render$17(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$2g, _hoisted_6$n);
}
const IconComponentSolid = { name: "cy-testing-type-component-solid_x64", render: render$17 };
const hasSymbol$1 = typeof Symbol === "function" && typeof Symbol.toStringTag === "symbol";
const makeSymbol = (name2) => hasSymbol$1 ? Symbol(name2) : name2;
const isNumber$1 = (val) => typeof val === "number" && isFinite(val);
const isRegExp$2 = (val) => toTypeString$1(val) === "[object RegExp]";
const isEmptyObject$1 = (val) => isPlainObject$2(val) && Object.keys(val).length === 0;
const assign$4 = Object.assign;
let _globalThis$1;
const getGlobalThis$1 = () => {
  return _globalThis$1 || (_globalThis$1 = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
};
const hasOwnProperty$2 = Object.prototype.hasOwnProperty;
function hasOwn(obj, key) {
  return hasOwnProperty$2.call(obj, key);
}
const isArray$1 = Array.isArray;
const isFunction$2 = (val) => typeof val === "function";
const isString$3 = (val) => typeof val === "string";
const isBoolean$1 = (val) => typeof val === "boolean";
const isObject$3 = (val) => val !== null && typeof val === "object";
const objectToString$1 = Object.prototype.toString;
const toTypeString$1 = (value) => objectToString$1.call(value);
const isPlainObject$2 = (val) => toTypeString$1(val) === "[object Object]";
const generateFormatCacheKey = (locale, key, source) => friendlyJSONstringify({ l: locale, k: key, s: source });
const friendlyJSONstringify = (json) => JSON.stringify(json).replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029").replace(/\u0027/g, "\\u0027");
const isNumber = (val) => typeof val === "number" && isFinite(val);
const isDate = (val) => toTypeString(val) === "[object Date]";
const isRegExp$1 = (val) => toTypeString(val) === "[object RegExp]";
const isEmptyObject = (val) => isPlainObject$1(val) && Object.keys(val).length === 0;
function warn(msg, err) {
  if (typeof console !== "undefined") {
    console.warn(`[intlify] ` + msg);
    if (err) {
      console.warn(err.stack);
    }
  }
}
const assign$3 = Object.assign;
let _globalThis;
const getGlobalThis = () => {
  return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
};
function escapeHtml$2(rawText) {
  return rawText.replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&apos;");
}
const isArray = Array.isArray;
const isFunction$1 = (val) => typeof val === "function";
const isString$2 = (val) => typeof val === "string";
const isBoolean = (val) => typeof val === "boolean";
const isObject$2 = (val) => val !== null && typeof val === "object";
const objectToString = Object.prototype.toString;
const toTypeString = (value) => objectToString.call(value);
const isPlainObject$1 = (val) => toTypeString(val) === "[object Object]";
const toDisplayString = (val) => {
  return val == null ? "" : isArray(val) || isPlainObject$1(val) && val.toString === objectToString ? JSON.stringify(val, null, 2) : String(val);
};
const CompileErrorCodes = {
  EXPECTED_TOKEN: 1,
  INVALID_TOKEN_IN_PLACEHOLDER: 2,
  UNTERMINATED_SINGLE_QUOTE_IN_PLACEHOLDER: 3,
  UNKNOWN_ESCAPE_SEQUENCE: 4,
  INVALID_UNICODE_ESCAPE_SEQUENCE: 5,
  UNBALANCED_CLOSING_BRACE: 6,
  UNTERMINATED_CLOSING_BRACE: 7,
  EMPTY_PLACEHOLDER: 8,
  NOT_ALLOW_NEST_PLACEHOLDER: 9,
  INVALID_LINKED_FORMAT: 10,
  MUST_HAVE_MESSAGES_IN_PLURAL: 11,
  UNEXPECTED_EMPTY_LINKED_MODIFIER: 12,
  UNEXPECTED_EMPTY_LINKED_KEY: 13,
  UNEXPECTED_LEXICAL_ANALYSIS: 14,
  __EXTEND_POINT__: 15
};
function createCompileError(code3, loc, options2 = {}) {
  const { domain, messages, args } = options2;
  const msg = code3;
  const error2 = new SyntaxError(String(msg));
  error2.code = code3;
  if (loc) {
    error2.location = loc;
  }
  error2.domain = domain;
  return error2;
}
const IntlifyDevToolsHooks = {
  I18nInit: "i18n:init",
  FunctionTranslate: "function:translate"
};
const pathStateMachine = [];
pathStateMachine[0] = {
  ["w"]: [0],
  ["i"]: [3, 0],
  ["["]: [4],
  ["o"]: [7]
};
pathStateMachine[1] = {
  ["w"]: [1],
  ["."]: [2],
  ["["]: [4],
  ["o"]: [7]
};
pathStateMachine[2] = {
  ["w"]: [2],
  ["i"]: [3, 0],
  ["0"]: [3, 0]
};
pathStateMachine[3] = {
  ["i"]: [3, 0],
  ["0"]: [3, 0],
  ["w"]: [1, 1],
  ["."]: [2, 1],
  ["["]: [4, 1],
  ["o"]: [7, 1]
};
pathStateMachine[4] = {
  ["'"]: [5, 0],
  ['"']: [6, 0],
  ["["]: [
    4,
    2
  ],
  ["]"]: [1, 3],
  ["o"]: 8,
  ["l"]: [4, 0]
};
pathStateMachine[5] = {
  ["'"]: [4, 0],
  ["o"]: 8,
  ["l"]: [5, 0]
};
pathStateMachine[6] = {
  ['"']: [4, 0],
  ["o"]: 8,
  ["l"]: [6, 0]
};
const literalValueRE = /^\s?(?:true|false|-?[\d.]+|'[^']*'|"[^"]*")\s?$/;
function isLiteral(exp) {
  return literalValueRE.test(exp);
}
function stripQuotes(str) {
  const a2 = str.charCodeAt(0);
  const b2 = str.charCodeAt(str.length - 1);
  return a2 === b2 && (a2 === 34 || a2 === 39) ? str.slice(1, -1) : str;
}
function getPathCharType(ch) {
  if (ch === void 0 || ch === null) {
    return "o";
  }
  const code3 = ch.charCodeAt(0);
  switch (code3) {
    case 91:
    case 93:
    case 46:
    case 34:
    case 39:
      return ch;
    case 95:
    case 36:
    case 45:
      return "i";
    case 9:
    case 10:
    case 13:
    case 160:
    case 65279:
    case 8232:
    case 8233:
      return "w";
  }
  return "i";
}
function formatSubPath(path) {
  const trimmed = path.trim();
  if (path.charAt(0) === "0" && isNaN(parseInt(path))) {
    return false;
  }
  return isLiteral(trimmed) ? stripQuotes(trimmed) : "*" + trimmed;
}
function parse$3(path) {
  const keys = [];
  let index2 = -1;
  let mode = 0;
  let subPathDepth = 0;
  let c2;
  let key;
  let newChar;
  let type2;
  let transition;
  let action;
  let typeMap;
  const actions = [];
  actions[0] = () => {
    if (key === void 0) {
      key = newChar;
    } else {
      key += newChar;
    }
  };
  actions[1] = () => {
    if (key !== void 0) {
      keys.push(key);
      key = void 0;
    }
  };
  actions[2] = () => {
    actions[0]();
    subPathDepth++;
  };
  actions[3] = () => {
    if (subPathDepth > 0) {
      subPathDepth--;
      mode = 4;
      actions[0]();
    } else {
      subPathDepth = 0;
      if (key === void 0) {
        return false;
      }
      key = formatSubPath(key);
      if (key === false) {
        return false;
      } else {
        actions[1]();
      }
    }
  };
  function maybeUnescapeQuote() {
    const nextChar = path[index2 + 1];
    if (mode === 5 && nextChar === "'" || mode === 6 && nextChar === '"') {
      index2++;
      newChar = "\\" + nextChar;
      actions[0]();
      return true;
    }
  }
  while (mode !== null) {
    index2++;
    c2 = path[index2];
    if (c2 === "\\" && maybeUnescapeQuote()) {
      continue;
    }
    type2 = getPathCharType(c2);
    typeMap = pathStateMachine[mode];
    transition = typeMap[type2] || typeMap["l"] || 8;
    if (transition === 8) {
      return;
    }
    mode = transition[0];
    if (transition[1] !== void 0) {
      action = actions[transition[1]];
      if (action) {
        newChar = c2;
        if (action() === false) {
          return;
        }
      }
    }
    if (mode === 7) {
      return keys;
    }
  }
}
const cache$1 = /* @__PURE__ */ new Map();
function resolveWithKeyValue(obj, path) {
  return isObject$2(obj) ? obj[path] : null;
}
function resolveValue(obj, path) {
  if (!isObject$2(obj)) {
    return null;
  }
  let hit = cache$1.get(path);
  if (!hit) {
    hit = parse$3(path);
    if (hit) {
      cache$1.set(path, hit);
    }
  }
  if (!hit) {
    return null;
  }
  const len = hit.length;
  let last = obj;
  let i2 = 0;
  while (i2 < len) {
    const val = last[hit[i2]];
    if (val === void 0) {
      return null;
    }
    last = val;
    i2++;
  }
  return last;
}
const DEFAULT_MODIFIER = (str) => str;
const DEFAULT_MESSAGE = (ctx) => "";
const DEFAULT_MESSAGE_DATA_TYPE = "text";
const DEFAULT_NORMALIZE = (values) => values.length === 0 ? "" : values.join("");
const DEFAULT_INTERPOLATE = toDisplayString;
function pluralDefault(choice, choicesLength) {
  choice = Math.abs(choice);
  if (choicesLength === 2) {
    return choice ? choice > 1 ? 1 : 0 : 1;
  }
  return choice ? Math.min(choice, 2) : 0;
}
function getPluralIndex(options2) {
  const index2 = isNumber(options2.pluralIndex) ? options2.pluralIndex : -1;
  return options2.named && (isNumber(options2.named.count) || isNumber(options2.named.n)) ? isNumber(options2.named.count) ? options2.named.count : isNumber(options2.named.n) ? options2.named.n : index2 : index2;
}
function normalizeNamed(pluralIndex, props) {
  if (!props.count) {
    props.count = pluralIndex;
  }
  if (!props.n) {
    props.n = pluralIndex;
  }
}
function createMessageContext(options2 = {}) {
  const locale = options2.locale;
  const pluralIndex = getPluralIndex(options2);
  const pluralRule = isObject$2(options2.pluralRules) && isString$2(locale) && isFunction$1(options2.pluralRules[locale]) ? options2.pluralRules[locale] : pluralDefault;
  const orgPluralRule = isObject$2(options2.pluralRules) && isString$2(locale) && isFunction$1(options2.pluralRules[locale]) ? pluralDefault : void 0;
  const plural = (messages) => messages[pluralRule(pluralIndex, messages.length, orgPluralRule)];
  const _list = options2.list || [];
  const list3 = (index2) => _list[index2];
  const _named = options2.named || {};
  isNumber(options2.pluralIndex) && normalizeNamed(pluralIndex, _named);
  const named = (key) => _named[key];
  function message(key) {
    const msg = isFunction$1(options2.messages) ? options2.messages(key) : isObject$2(options2.messages) ? options2.messages[key] : false;
    return !msg ? options2.parent ? options2.parent.message(key) : DEFAULT_MESSAGE : msg;
  }
  const _modifier = (name2) => options2.modifiers ? options2.modifiers[name2] : DEFAULT_MODIFIER;
  const normalize4 = isPlainObject$1(options2.processor) && isFunction$1(options2.processor.normalize) ? options2.processor.normalize : DEFAULT_NORMALIZE;
  const interpolate = isPlainObject$1(options2.processor) && isFunction$1(options2.processor.interpolate) ? options2.processor.interpolate : DEFAULT_INTERPOLATE;
  const type2 = isPlainObject$1(options2.processor) && isString$2(options2.processor.type) ? options2.processor.type : DEFAULT_MESSAGE_DATA_TYPE;
  const ctx = {
    ["list"]: list3,
    ["named"]: named,
    ["plural"]: plural,
    ["linked"]: (key, modifier) => {
      const msg = message(key)(ctx);
      return isString$2(modifier) ? _modifier(modifier)(msg) : msg;
    },
    ["message"]: message,
    ["type"]: type2,
    ["interpolate"]: interpolate,
    ["normalize"]: normalize4
  };
  return ctx;
}
let devtools = null;
function setDevToolsHook(hook) {
  devtools = hook;
}
function initI18nDevTools(i18n, version2, meta) {
  devtools && devtools.emit(IntlifyDevToolsHooks.I18nInit, {
    timestamp: Date.now(),
    i18n,
    version: version2,
    meta
  });
}
const translateDevTools = /* @__PURE__ */ createDevToolsHook(IntlifyDevToolsHooks.FunctionTranslate);
function createDevToolsHook(hook) {
  return (payloads) => devtools && devtools.emit(hook, payloads);
}
const CoreWarnCodes = {
  NOT_FOUND_KEY: 1,
  FALLBACK_TO_TRANSLATE: 2,
  CANNOT_FORMAT_NUMBER: 3,
  FALLBACK_TO_NUMBER_FORMAT: 4,
  CANNOT_FORMAT_DATE: 5,
  FALLBACK_TO_DATE_FORMAT: 6,
  __EXTEND_POINT__: 7
};
function fallbackWithSimple(ctx, fallback, start) {
  return [.../* @__PURE__ */ new Set([
    start,
    ...isArray(fallback) ? fallback : isObject$2(fallback) ? Object.keys(fallback) : isString$2(fallback) ? [fallback] : [start]
  ])];
}
function fallbackWithLocaleChain(ctx, fallback, start) {
  const startLocale = isString$2(start) ? start : DEFAULT_LOCALE;
  const context = ctx;
  if (!context.__localeChainCache) {
    context.__localeChainCache = /* @__PURE__ */ new Map();
  }
  let chain = context.__localeChainCache.get(startLocale);
  if (!chain) {
    chain = [];
    let block3 = [start];
    while (isArray(block3)) {
      block3 = appendBlockToChain(chain, block3, fallback);
    }
    const defaults = isArray(fallback) || !isPlainObject$1(fallback) ? fallback : fallback["default"] ? fallback["default"] : null;
    block3 = isString$2(defaults) ? [defaults] : defaults;
    if (isArray(block3)) {
      appendBlockToChain(chain, block3, false);
    }
    context.__localeChainCache.set(startLocale, chain);
  }
  return chain;
}
function appendBlockToChain(chain, block3, blocks) {
  let follow = true;
  for (let i2 = 0; i2 < block3.length && isBoolean(follow); i2++) {
    const locale = block3[i2];
    if (isString$2(locale)) {
      follow = appendLocaleToChain(chain, block3[i2], blocks);
    }
  }
  return follow;
}
function appendLocaleToChain(chain, locale, blocks) {
  let follow;
  const tokens = locale.split("-");
  do {
    const target2 = tokens.join("-");
    follow = appendItemToChain(chain, target2, blocks);
    tokens.splice(-1, 1);
  } while (tokens.length && follow === true);
  return follow;
}
function appendItemToChain(chain, target2, blocks) {
  let follow = false;
  if (!chain.includes(target2)) {
    follow = true;
    if (target2) {
      follow = target2[target2.length - 1] !== "!";
      const locale = target2.replace(/!/g, "");
      chain.push(locale);
      if ((isArray(blocks) || isPlainObject$1(blocks)) && blocks[locale]) {
        follow = blocks[locale];
      }
    }
  }
  return follow;
}
const VERSION$1 = "9.2.0-beta.7";
const NOT_REOSLVED = -1;
const DEFAULT_LOCALE = "en-US";
const MISSING_RESOLVE_VALUE = "";
function getDefaultLinkedModifiers() {
  return {
    upper: (val) => isString$2(val) ? val.toUpperCase() : val,
    lower: (val) => isString$2(val) ? val.toLowerCase() : val,
    capitalize: (val) => isString$2(val) ? `${val.charAt(0).toLocaleUpperCase()}${val.substr(1)}` : val
  };
}
let _compiler;
let _resolver;
function registerMessageResolver(resolver) {
  _resolver = resolver;
}
let _fallbacker;
function registerLocaleFallbacker(fallbacker) {
  _fallbacker = fallbacker;
}
let _additionalMeta = null;
const setAdditionalMeta = (meta) => {
  _additionalMeta = meta;
};
const getAdditionalMeta = () => _additionalMeta;
let _cid = 0;
function createCoreContext(options2 = {}) {
  const version2 = isString$2(options2.version) ? options2.version : VERSION$1;
  const locale = isString$2(options2.locale) ? options2.locale : DEFAULT_LOCALE;
  const fallbackLocale = isArray(options2.fallbackLocale) || isPlainObject$1(options2.fallbackLocale) || isString$2(options2.fallbackLocale) || options2.fallbackLocale === false ? options2.fallbackLocale : locale;
  const messages = isPlainObject$1(options2.messages) ? options2.messages : { [locale]: {} };
  const datetimeFormats = isPlainObject$1(options2.datetimeFormats) ? options2.datetimeFormats : { [locale]: {} };
  const numberFormats = isPlainObject$1(options2.numberFormats) ? options2.numberFormats : { [locale]: {} };
  const modifiers = assign$3({}, options2.modifiers || {}, getDefaultLinkedModifiers());
  const pluralRules = options2.pluralRules || {};
  const missing = isFunction$1(options2.missing) ? options2.missing : null;
  const missingWarn = isBoolean(options2.missingWarn) || isRegExp$1(options2.missingWarn) ? options2.missingWarn : true;
  const fallbackWarn = isBoolean(options2.fallbackWarn) || isRegExp$1(options2.fallbackWarn) ? options2.fallbackWarn : true;
  const fallbackFormat = !!options2.fallbackFormat;
  const unresolving = !!options2.unresolving;
  const postTranslation = isFunction$1(options2.postTranslation) ? options2.postTranslation : null;
  const processor = isPlainObject$1(options2.processor) ? options2.processor : null;
  const warnHtmlMessage = isBoolean(options2.warnHtmlMessage) ? options2.warnHtmlMessage : true;
  const escapeParameter = !!options2.escapeParameter;
  const messageCompiler = isFunction$1(options2.messageCompiler) ? options2.messageCompiler : _compiler;
  const messageResolver = isFunction$1(options2.messageResolver) ? options2.messageResolver : _resolver || resolveWithKeyValue;
  const localeFallbacker = isFunction$1(options2.localeFallbacker) ? options2.localeFallbacker : _fallbacker || fallbackWithSimple;
  const onWarn = isFunction$1(options2.onWarn) ? options2.onWarn : warn;
  const internalOptions = options2;
  const __datetimeFormatters = isObject$2(internalOptions.__datetimeFormatters) ? internalOptions.__datetimeFormatters : /* @__PURE__ */ new Map();
  const __numberFormatters = isObject$2(internalOptions.__numberFormatters) ? internalOptions.__numberFormatters : /* @__PURE__ */ new Map();
  const __meta = isObject$2(internalOptions.__meta) ? internalOptions.__meta : {};
  _cid++;
  const context = {
    version: version2,
    cid: _cid,
    locale,
    fallbackLocale,
    messages,
    modifiers,
    pluralRules,
    missing,
    missingWarn,
    fallbackWarn,
    fallbackFormat,
    unresolving,
    postTranslation,
    processor,
    warnHtmlMessage,
    escapeParameter,
    messageCompiler,
    messageResolver,
    localeFallbacker,
    onWarn,
    __meta
  };
  {
    context.datetimeFormats = datetimeFormats;
    context.numberFormats = numberFormats;
    context.__datetimeFormatters = __datetimeFormatters;
    context.__numberFormatters = __numberFormatters;
  }
  if (__INTLIFY_PROD_DEVTOOLS__) {
    initI18nDevTools(context, version2, __meta);
  }
  return context;
}
function handleMissing(context, key, locale, missingWarn, type2) {
  const { missing, onWarn } = context;
  if (missing !== null) {
    const ret = missing(context, locale, key, type2);
    return isString$2(ret) ? ret : key;
  } else {
    return key;
  }
}
function updateFallbackLocale(ctx, locale, fallback) {
  const context = ctx;
  context.__localeChainCache = /* @__PURE__ */ new Map();
  ctx.localeFallbacker(ctx, fallback, locale);
}
let code$2 = CompileErrorCodes.__EXTEND_POINT__;
const inc$1 = () => code$2++;
const CoreErrorCodes = {
  INVALID_ARGUMENT: code$2,
  INVALID_DATE_ARGUMENT: inc$1(),
  INVALID_ISO_DATE_ARGUMENT: inc$1(),
  __EXTEND_POINT__: inc$1()
};
function createCoreError(code3) {
  return createCompileError(code3, null, void 0);
}
const NOOP_MESSAGE_FUNCTION = () => "";
const isMessageFunction = (val) => isFunction$1(val);
function translate(context, ...args) {
  const { fallbackFormat, postTranslation, unresolving, fallbackLocale, messages } = context;
  const [key, options2] = parseTranslateArgs(...args);
  const missingWarn = isBoolean(options2.missingWarn) ? options2.missingWarn : context.missingWarn;
  const fallbackWarn = isBoolean(options2.fallbackWarn) ? options2.fallbackWarn : context.fallbackWarn;
  const escapeParameter = isBoolean(options2.escapeParameter) ? options2.escapeParameter : context.escapeParameter;
  const resolvedMessage = !!options2.resolvedMessage;
  const defaultMsgOrKey = isString$2(options2.default) || isBoolean(options2.default) ? !isBoolean(options2.default) ? options2.default : key : fallbackFormat ? key : "";
  const enableDefaultMsg = fallbackFormat || defaultMsgOrKey !== "";
  const locale = isString$2(options2.locale) ? options2.locale : context.locale;
  escapeParameter && escapeParams(options2);
  let [format3, targetLocale, message] = !resolvedMessage ? resolveMessageFormat(context, key, locale, fallbackLocale, fallbackWarn, missingWarn) : [
    key,
    locale,
    messages[locale] || {}
  ];
  let cacheBaseKey = key;
  if (!resolvedMessage && !(isString$2(format3) || isMessageFunction(format3))) {
    if (enableDefaultMsg) {
      format3 = defaultMsgOrKey;
      cacheBaseKey = format3;
    }
  }
  if (!resolvedMessage && (!(isString$2(format3) || isMessageFunction(format3)) || !isString$2(targetLocale))) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let occurred = false;
  const errorDetector = () => {
    occurred = true;
  };
  const msg = !isMessageFunction(format3) ? compileMessageFormat(context, key, targetLocale, format3, cacheBaseKey, errorDetector) : format3;
  if (occurred) {
    return format3;
  }
  const ctxOptions = getMessageContextOptions(context, targetLocale, message, options2);
  const msgContext = createMessageContext(ctxOptions);
  const messaged = evaluateMessage(context, msg, msgContext);
  const ret = postTranslation ? postTranslation(messaged) : messaged;
  if (__INTLIFY_PROD_DEVTOOLS__) {
    const payloads = {
      timestamp: Date.now(),
      key: isString$2(key) ? key : isMessageFunction(format3) ? format3.key : "",
      locale: targetLocale || (isMessageFunction(format3) ? format3.locale : ""),
      format: isString$2(format3) ? format3 : isMessageFunction(format3) ? format3.source : "",
      message: ret
    };
    payloads.meta = assign$3({}, context.__meta, getAdditionalMeta() || {});
    translateDevTools(payloads);
  }
  return ret;
}
function escapeParams(options2) {
  if (isArray(options2.list)) {
    options2.list = options2.list.map((item) => isString$2(item) ? escapeHtml$2(item) : item);
  } else if (isObject$2(options2.named)) {
    Object.keys(options2.named).forEach((key) => {
      if (isString$2(options2.named[key])) {
        options2.named[key] = escapeHtml$2(options2.named[key]);
      }
    });
  }
}
function resolveMessageFormat(context, key, locale, fallbackLocale, fallbackWarn, missingWarn) {
  const { messages, onWarn, messageResolver: resolveValue2, localeFallbacker } = context;
  const locales = localeFallbacker(context, fallbackLocale, locale);
  let message = {};
  let targetLocale;
  let format3 = null;
  const type2 = "translate";
  for (let i2 = 0; i2 < locales.length; i2++) {
    targetLocale = locales[i2];
    message = messages[targetLocale] || {};
    if ((format3 = resolveValue2(message, key)) === null) {
      format3 = message[key];
    }
    if (isString$2(format3) || isFunction$1(format3))
      break;
    const missingRet = handleMissing(
      context,
      key,
      targetLocale,
      missingWarn,
      type2
    );
    if (missingRet !== key) {
      format3 = missingRet;
    }
  }
  return [format3, targetLocale, message];
}
function compileMessageFormat(context, key, targetLocale, format3, cacheBaseKey, errorDetector) {
  const { messageCompiler, warnHtmlMessage } = context;
  if (isMessageFunction(format3)) {
    const msg2 = format3;
    msg2.locale = msg2.locale || targetLocale;
    msg2.key = msg2.key || key;
    return msg2;
  }
  const msg = messageCompiler(format3, getCompileOptions(context, targetLocale, cacheBaseKey, format3, warnHtmlMessage, errorDetector));
  msg.locale = targetLocale;
  msg.key = key;
  msg.source = format3;
  return msg;
}
function evaluateMessage(context, msg, msgCtx) {
  const messaged = msg(msgCtx);
  return messaged;
}
function parseTranslateArgs(...args) {
  const [arg1, arg2, arg3] = args;
  const options2 = {};
  if (!isString$2(arg1) && !isNumber(arg1) && !isMessageFunction(arg1)) {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  const key = isNumber(arg1) ? String(arg1) : isMessageFunction(arg1) ? arg1 : arg1;
  if (isNumber(arg2)) {
    options2.plural = arg2;
  } else if (isString$2(arg2)) {
    options2.default = arg2;
  } else if (isPlainObject$1(arg2) && !isEmptyObject(arg2)) {
    options2.named = arg2;
  } else if (isArray(arg2)) {
    options2.list = arg2;
  }
  if (isNumber(arg3)) {
    options2.plural = arg3;
  } else if (isString$2(arg3)) {
    options2.default = arg3;
  } else if (isPlainObject$1(arg3)) {
    assign$3(options2, arg3);
  }
  return [key, options2];
}
function getCompileOptions(context, locale, key, source, warnHtmlMessage, errorDetector) {
  return {
    warnHtmlMessage,
    onError: (err) => {
      errorDetector && errorDetector(err);
      {
        throw err;
      }
    },
    onCacheKey: (source2) => generateFormatCacheKey(locale, key, source2)
  };
}
function getMessageContextOptions(context, locale, message, options2) {
  const { modifiers, pluralRules, messageResolver: resolveValue2 } = context;
  const resolveMessage = (key) => {
    const val = resolveValue2(message, key);
    if (isString$2(val)) {
      let occurred = false;
      const errorDetector = () => {
        occurred = true;
      };
      const msg = compileMessageFormat(context, key, locale, val, key, errorDetector);
      return !occurred ? msg : NOOP_MESSAGE_FUNCTION;
    } else if (isMessageFunction(val)) {
      return val;
    } else {
      return NOOP_MESSAGE_FUNCTION;
    }
  };
  const ctxOptions = {
    locale,
    modifiers,
    pluralRules,
    messages: resolveMessage
  };
  if (context.processor) {
    ctxOptions.processor = context.processor;
  }
  if (options2.list) {
    ctxOptions.list = options2.list;
  }
  if (options2.named) {
    ctxOptions.named = options2.named;
  }
  if (isNumber(options2.plural)) {
    ctxOptions.pluralIndex = options2.plural;
  }
  return ctxOptions;
}
function datetime(context, ...args) {
  const { datetimeFormats, unresolving, fallbackLocale, onWarn, localeFallbacker } = context;
  const { __datetimeFormatters } = context;
  const [key, value, options2, overrides] = parseDateTimeArgs(...args);
  const missingWarn = isBoolean(options2.missingWarn) ? options2.missingWarn : context.missingWarn;
  isBoolean(options2.fallbackWarn) ? options2.fallbackWarn : context.fallbackWarn;
  const part2 = !!options2.part;
  const locale = isString$2(options2.locale) ? options2.locale : context.locale;
  const locales = localeFallbacker(
    context,
    fallbackLocale,
    locale
  );
  if (!isString$2(key) || key === "") {
    return new Intl.DateTimeFormat(locale).format(value);
  }
  let datetimeFormat = {};
  let targetLocale;
  let format3 = null;
  const type2 = "datetime format";
  for (let i2 = 0; i2 < locales.length; i2++) {
    targetLocale = locales[i2];
    datetimeFormat = datetimeFormats[targetLocale] || {};
    format3 = datetimeFormat[key];
    if (isPlainObject$1(format3))
      break;
    handleMissing(context, key, targetLocale, missingWarn, type2);
  }
  if (!isPlainObject$1(format3) || !isString$2(targetLocale)) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let id2 = `${targetLocale}__${key}`;
  if (!isEmptyObject(overrides)) {
    id2 = `${id2}__${JSON.stringify(overrides)}`;
  }
  let formatter = __datetimeFormatters.get(id2);
  if (!formatter) {
    formatter = new Intl.DateTimeFormat(targetLocale, assign$3({}, format3, overrides));
    __datetimeFormatters.set(id2, formatter);
  }
  return !part2 ? formatter.format(value) : formatter.formatToParts(value);
}
function parseDateTimeArgs(...args) {
  const [arg1, arg2, arg3, arg4] = args;
  let options2 = {};
  let overrides = {};
  let value;
  if (isString$2(arg1)) {
    const matches2 = arg1.match(/(\d{4}-\d{2}-\d{2})(T|\s)?(.*)/);
    if (!matches2) {
      throw createCoreError(CoreErrorCodes.INVALID_ISO_DATE_ARGUMENT);
    }
    const dateTime = matches2[3] ? matches2[3].trim().startsWith("T") ? `${matches2[1].trim()}${matches2[3].trim()}` : `${matches2[1].trim()}T${matches2[3].trim()}` : matches2[1].trim();
    value = new Date(dateTime);
    try {
      value.toISOString();
    } catch (e) {
      throw createCoreError(CoreErrorCodes.INVALID_ISO_DATE_ARGUMENT);
    }
  } else if (isDate(arg1)) {
    if (isNaN(arg1.getTime())) {
      throw createCoreError(CoreErrorCodes.INVALID_DATE_ARGUMENT);
    }
    value = arg1;
  } else if (isNumber(arg1)) {
    value = arg1;
  } else {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  if (isString$2(arg2)) {
    options2.key = arg2;
  } else if (isPlainObject$1(arg2)) {
    options2 = arg2;
  }
  if (isString$2(arg3)) {
    options2.locale = arg3;
  } else if (isPlainObject$1(arg3)) {
    overrides = arg3;
  }
  if (isPlainObject$1(arg4)) {
    overrides = arg4;
  }
  return [options2.key || "", value, options2, overrides];
}
function clearDateTimeFormat(ctx, locale, format3) {
  const context = ctx;
  for (const key in format3) {
    const id2 = `${locale}__${key}`;
    if (!context.__datetimeFormatters.has(id2)) {
      continue;
    }
    context.__datetimeFormatters.delete(id2);
  }
}
function number(context, ...args) {
  const { numberFormats, unresolving, fallbackLocale, onWarn, localeFallbacker } = context;
  const { __numberFormatters } = context;
  const [key, value, options2, overrides] = parseNumberArgs(...args);
  const missingWarn = isBoolean(options2.missingWarn) ? options2.missingWarn : context.missingWarn;
  isBoolean(options2.fallbackWarn) ? options2.fallbackWarn : context.fallbackWarn;
  const part2 = !!options2.part;
  const locale = isString$2(options2.locale) ? options2.locale : context.locale;
  const locales = localeFallbacker(
    context,
    fallbackLocale,
    locale
  );
  if (!isString$2(key) || key === "") {
    return new Intl.NumberFormat(locale).format(value);
  }
  let numberFormat = {};
  let targetLocale;
  let format3 = null;
  const type2 = "number format";
  for (let i2 = 0; i2 < locales.length; i2++) {
    targetLocale = locales[i2];
    numberFormat = numberFormats[targetLocale] || {};
    format3 = numberFormat[key];
    if (isPlainObject$1(format3))
      break;
    handleMissing(context, key, targetLocale, missingWarn, type2);
  }
  if (!isPlainObject$1(format3) || !isString$2(targetLocale)) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let id2 = `${targetLocale}__${key}`;
  if (!isEmptyObject(overrides)) {
    id2 = `${id2}__${JSON.stringify(overrides)}`;
  }
  let formatter = __numberFormatters.get(id2);
  if (!formatter) {
    formatter = new Intl.NumberFormat(targetLocale, assign$3({}, format3, overrides));
    __numberFormatters.set(id2, formatter);
  }
  return !part2 ? formatter.format(value) : formatter.formatToParts(value);
}
function parseNumberArgs(...args) {
  const [arg1, arg2, arg3, arg4] = args;
  let options2 = {};
  let overrides = {};
  if (!isNumber(arg1)) {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  const value = arg1;
  if (isString$2(arg2)) {
    options2.key = arg2;
  } else if (isPlainObject$1(arg2)) {
    options2 = arg2;
  }
  if (isString$2(arg3)) {
    options2.locale = arg3;
  } else if (isPlainObject$1(arg3)) {
    overrides = arg3;
  }
  if (isPlainObject$1(arg4)) {
    overrides = arg4;
  }
  return [options2.key || "", value, options2, overrides];
}
function clearNumberFormat(ctx, locale, format3) {
  const context = ctx;
  for (const key in format3) {
    const id2 = `${locale}__${key}`;
    if (!context.__numberFormatters.has(id2)) {
      continue;
    }
    context.__numberFormatters.delete(id2);
  }
}
{
  if (typeof __INTLIFY_PROD_DEVTOOLS__ !== "boolean") {
    getGlobalThis().__INTLIFY_PROD_DEVTOOLS__ = false;
  }
}
const VERSION = "9.2.0-beta.7";
function initFeatureFlags() {
  if (typeof __INTLIFY_PROD_DEVTOOLS__ !== "boolean") {
    getGlobalThis$1().__INTLIFY_PROD_DEVTOOLS__ = false;
  }
}
CoreWarnCodes.__EXTEND_POINT__;
let code$1 = CompileErrorCodes.__EXTEND_POINT__;
const inc = () => code$1++;
const I18nErrorCodes = {
  UNEXPECTED_RETURN_TYPE: code$1,
  INVALID_ARGUMENT: inc(),
  MUST_BE_CALL_SETUP_TOP: inc(),
  NOT_INSLALLED: inc(),
  NOT_AVAILABLE_IN_LEGACY_MODE: inc(),
  REQUIRED_VALUE: inc(),
  INVALID_VALUE: inc(),
  CANNOT_SETUP_VUE_DEVTOOLS_PLUGIN: inc(),
  NOT_INSLALLED_WITH_PROVIDE: inc(),
  UNEXPECTED_ERROR: inc(),
  NOT_COMPATIBLE_LEGACY_VUE_I18N: inc(),
  BRIDGE_SUPPORT_VUE_2_ONLY: inc(),
  __EXTEND_POINT__: inc()
};
function createI18nError(code3, ...args) {
  return createCompileError(code3, null, void 0);
}
const TransrateVNodeSymbol = /* @__PURE__ */ makeSymbol("__transrateVNode");
const DatetimePartsSymbol = /* @__PURE__ */ makeSymbol("__datetimeParts");
const NumberPartsSymbol = /* @__PURE__ */ makeSymbol("__numberParts");
const SetPluralRulesSymbol = makeSymbol("__setPluralRules");
makeSymbol("__intlifyMeta");
function handleFlatJson(obj) {
  if (!isObject$3(obj)) {
    return obj;
  }
  for (const key in obj) {
    if (!hasOwn(obj, key)) {
      continue;
    }
    if (!key.includes(".")) {
      if (isObject$3(obj[key])) {
        handleFlatJson(obj[key]);
      }
    } else {
      const subKeys = key.split(".");
      const lastIndex = subKeys.length - 1;
      let currentObj = obj;
      for (let i2 = 0; i2 < lastIndex; i2++) {
        if (!(subKeys[i2] in currentObj)) {
          currentObj[subKeys[i2]] = {};
        }
        currentObj = currentObj[subKeys[i2]];
      }
      currentObj[subKeys[lastIndex]] = obj[key];
      delete obj[key];
      if (isObject$3(currentObj[subKeys[lastIndex]])) {
        handleFlatJson(currentObj[subKeys[lastIndex]]);
      }
    }
  }
  return obj;
}
function getLocaleMessages(locale, options2) {
  const { messages, __i18n, messageResolver, flatJson } = options2;
  const ret = isPlainObject$2(messages) ? messages : isArray$1(__i18n) ? {} : { [locale]: {} };
  if (isArray$1(__i18n)) {
    __i18n.forEach((custom) => {
      if ("locale" in custom && "resource" in custom) {
        const { locale: locale2, resource } = custom;
        if (locale2) {
          ret[locale2] = ret[locale2] || {};
          deepCopy(resource, ret[locale2]);
        } else {
          deepCopy(resource, ret);
        }
      } else {
        isString$3(custom) && deepCopy(JSON.parse(custom), ret);
      }
    });
  }
  if (messageResolver == null && flatJson) {
    for (const key in ret) {
      if (hasOwn(ret, key)) {
        handleFlatJson(ret[key]);
      }
    }
  }
  return ret;
}
const isNotObjectOrIsArray = (val) => !isObject$3(val) || isArray$1(val);
function deepCopy(src, des) {
  if (isNotObjectOrIsArray(src) || isNotObjectOrIsArray(des)) {
    throw createI18nError(I18nErrorCodes.INVALID_VALUE);
  }
  for (const key in src) {
    if (hasOwn(src, key)) {
      if (isNotObjectOrIsArray(src[key]) || isNotObjectOrIsArray(des[key])) {
        des[key] = src[key];
      } else {
        deepCopy(src[key], des[key]);
      }
    }
  }
}
function getComponentOptions(instance) {
  return instance.type;
}
const DEVTOOLS_META = "__INTLIFY_META__";
let composerID = 0;
function defineCoreMissingHandler(missing) {
  return (ctx, locale, key, type2) => {
    return missing(locale, key, getCurrentInstance() || void 0, type2);
  };
}
const getMetaInfo = () => {
  const instance = getCurrentInstance();
  let meta = null;
  return instance && (meta = getComponentOptions(instance)[DEVTOOLS_META]) ? { [DEVTOOLS_META]: meta } : null;
};
function createComposer(options2 = {}, VueI18nLegacy) {
  const { __root } = options2;
  const _isGlobal = __root === void 0;
  let _inheritLocale = isBoolean$1(options2.inheritLocale) ? options2.inheritLocale : true;
  const _locale = ref(
    __root && _inheritLocale ? __root.locale.value : isString$3(options2.locale) ? options2.locale : DEFAULT_LOCALE
  );
  const _fallbackLocale = ref(
    __root && _inheritLocale ? __root.fallbackLocale.value : isString$3(options2.fallbackLocale) || isArray$1(options2.fallbackLocale) || isPlainObject$2(options2.fallbackLocale) || options2.fallbackLocale === false ? options2.fallbackLocale : _locale.value
  );
  const _messages = ref(getLocaleMessages(_locale.value, options2));
  const _datetimeFormats = ref(isPlainObject$2(options2.datetimeFormats) ? options2.datetimeFormats : { [_locale.value]: {} });
  const _numberFormats = ref(isPlainObject$2(options2.numberFormats) ? options2.numberFormats : { [_locale.value]: {} });
  let _missingWarn = __root ? __root.missingWarn : isBoolean$1(options2.missingWarn) || isRegExp$2(options2.missingWarn) ? options2.missingWarn : true;
  let _fallbackWarn = __root ? __root.fallbackWarn : isBoolean$1(options2.fallbackWarn) || isRegExp$2(options2.fallbackWarn) ? options2.fallbackWarn : true;
  let _fallbackRoot = __root ? __root.fallbackRoot : isBoolean$1(options2.fallbackRoot) ? options2.fallbackRoot : true;
  let _fallbackFormat = !!options2.fallbackFormat;
  let _missing = isFunction$2(options2.missing) ? options2.missing : null;
  let _runtimeMissing = isFunction$2(options2.missing) ? defineCoreMissingHandler(options2.missing) : null;
  let _postTranslation = isFunction$2(options2.postTranslation) ? options2.postTranslation : null;
  let _warnHtmlMessage = isBoolean$1(options2.warnHtmlMessage) ? options2.warnHtmlMessage : true;
  let _escapeParameter = !!options2.escapeParameter;
  const _modifiers = __root ? __root.modifiers : isPlainObject$2(options2.modifiers) ? options2.modifiers : {};
  let _pluralRules = options2.pluralRules || __root && __root.pluralRules;
  let _context;
  function getCoreContext() {
    const ctxOptions = {
      version: VERSION,
      locale: _locale.value,
      fallbackLocale: _fallbackLocale.value,
      messages: _messages.value,
      modifiers: _modifiers,
      pluralRules: _pluralRules,
      missing: _runtimeMissing === null ? void 0 : _runtimeMissing,
      missingWarn: _missingWarn,
      fallbackWarn: _fallbackWarn,
      fallbackFormat: _fallbackFormat,
      unresolving: true,
      postTranslation: _postTranslation === null ? void 0 : _postTranslation,
      warnHtmlMessage: _warnHtmlMessage,
      escapeParameter: _escapeParameter,
      messageResolver: options2.messageResolver,
      __meta: { framework: "vue" }
    };
    {
      ctxOptions.datetimeFormats = _datetimeFormats.value;
      ctxOptions.numberFormats = _numberFormats.value;
      ctxOptions.__datetimeFormatters = isPlainObject$2(_context) ? _context.__datetimeFormatters : void 0;
      ctxOptions.__numberFormatters = isPlainObject$2(_context) ? _context.__numberFormatters : void 0;
    }
    return createCoreContext(ctxOptions);
  }
  _context = getCoreContext();
  updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
  function trackReactivityValues() {
    return [
      _locale.value,
      _fallbackLocale.value,
      _messages.value,
      _datetimeFormats.value,
      _numberFormats.value
    ];
  }
  const locale = computed({
    get: () => _locale.value,
    set: (val) => {
      _locale.value = val;
      _context.locale = _locale.value;
    }
  });
  const fallbackLocale = computed({
    get: () => _fallbackLocale.value,
    set: (val) => {
      _fallbackLocale.value = val;
      _context.fallbackLocale = _fallbackLocale.value;
      updateFallbackLocale(_context, _locale.value, val);
    }
  });
  const messages = computed(() => _messages.value);
  const datetimeFormats = /* @__PURE__ */ computed(() => _datetimeFormats.value);
  const numberFormats = /* @__PURE__ */ computed(() => _numberFormats.value);
  function getPostTranslationHandler() {
    return isFunction$2(_postTranslation) ? _postTranslation : null;
  }
  function setPostTranslationHandler(handler) {
    _postTranslation = handler;
    _context.postTranslation = handler;
  }
  function getMissingHandler() {
    return _missing;
  }
  function setMissingHandler(handler) {
    if (handler !== null) {
      _runtimeMissing = defineCoreMissingHandler(handler);
    }
    _missing = handler;
    _context.missing = _runtimeMissing;
  }
  function wrapWithDeps(fn, argumentParser, warnType, fallbackSuccess, fallbackFail, successCondition) {
    trackReactivityValues();
    let ret;
    if (__INTLIFY_PROD_DEVTOOLS__) {
      try {
        setAdditionalMeta(getMetaInfo());
        ret = fn(_context);
      } finally {
        setAdditionalMeta(null);
      }
    } else {
      ret = fn(_context);
    }
    if (isNumber$1(ret) && ret === NOT_REOSLVED) {
      const [key, arg2] = argumentParser();
      return __root && _fallbackRoot ? fallbackSuccess(__root) : fallbackFail(key);
    } else if (successCondition(ret)) {
      return ret;
    } else {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_RETURN_TYPE);
    }
  }
  function t2(...args) {
    return wrapWithDeps((context) => Reflect.apply(translate, null, [context, ...args]), () => parseTranslateArgs(...args), "translate", (root) => Reflect.apply(root.t, root, [...args]), (key) => key, (val) => isString$3(val));
  }
  function rt(...args) {
    const [arg1, arg2, arg3] = args;
    if (arg3 && !isObject$3(arg3)) {
      throw createI18nError(I18nErrorCodes.INVALID_ARGUMENT);
    }
    return t2(...[arg1, arg2, assign$4({ resolvedMessage: true }, arg3 || {})]);
  }
  function d2(...args) {
    return wrapWithDeps((context) => Reflect.apply(datetime, null, [context, ...args]), () => parseDateTimeArgs(...args), "datetime format", (root) => Reflect.apply(root.d, root, [...args]), () => MISSING_RESOLVE_VALUE, (val) => isString$3(val));
  }
  function n(...args) {
    return wrapWithDeps((context) => Reflect.apply(number, null, [context, ...args]), () => parseNumberArgs(...args), "number format", (root) => Reflect.apply(root.n, root, [...args]), () => MISSING_RESOLVE_VALUE, (val) => isString$3(val));
  }
  function normalize4(values) {
    return values.map((val) => isString$3(val) ? createVNode(Text, null, val, 0) : val);
  }
  const interpolate = (val) => val;
  const processor = {
    normalize: normalize4,
    interpolate,
    type: "vnode"
  };
  function transrateVNode(...args) {
    return wrapWithDeps(
      (context) => {
        let ret;
        const _context2 = context;
        try {
          _context2.processor = processor;
          ret = Reflect.apply(translate, null, [_context2, ...args]);
        } finally {
          _context2.processor = null;
        }
        return ret;
      },
      () => parseTranslateArgs(...args),
      "translate",
      (root) => root[TransrateVNodeSymbol](...args),
      (key) => [createVNode(Text, null, key, 0)],
      (val) => isArray$1(val)
    );
  }
  function numberParts(...args) {
    return wrapWithDeps(
      (context) => Reflect.apply(number, null, [context, ...args]),
      () => parseNumberArgs(...args),
      "number format",
      (root) => root[NumberPartsSymbol](...args),
      () => [],
      (val) => isString$3(val) || isArray$1(val)
    );
  }
  function datetimeParts(...args) {
    return wrapWithDeps(
      (context) => Reflect.apply(datetime, null, [context, ...args]),
      () => parseDateTimeArgs(...args),
      "datetime format",
      (root) => root[DatetimePartsSymbol](...args),
      () => [],
      (val) => isString$3(val) || isArray$1(val)
    );
  }
  function setPluralRules(rules) {
    _pluralRules = rules;
    _context.pluralRules = _pluralRules;
  }
  function te(key, locale2) {
    const targetLocale = isString$3(locale2) ? locale2 : _locale.value;
    const message = getLocaleMessage(targetLocale);
    return _context.messageResolver(message, key) !== null;
  }
  function resolveMessages(key) {
    let messages2 = null;
    const locales = fallbackWithLocaleChain(_context, _fallbackLocale.value, _locale.value);
    for (let i2 = 0; i2 < locales.length; i2++) {
      const targetLocaleMessages = _messages.value[locales[i2]] || {};
      const messageValue = _context.messageResolver(targetLocaleMessages, key);
      if (messageValue != null) {
        messages2 = messageValue;
        break;
      }
    }
    return messages2;
  }
  function tm(key) {
    const messages2 = resolveMessages(key);
    return messages2 != null ? messages2 : __root ? __root.tm(key) || {} : {};
  }
  function getLocaleMessage(locale2) {
    return _messages.value[locale2] || {};
  }
  function setLocaleMessage(locale2, message) {
    _messages.value[locale2] = message;
    _context.messages = _messages.value;
  }
  function mergeLocaleMessage(locale2, message) {
    _messages.value[locale2] = _messages.value[locale2] || {};
    deepCopy(message, _messages.value[locale2]);
    _context.messages = _messages.value;
  }
  function getDateTimeFormat(locale2) {
    return _datetimeFormats.value[locale2] || {};
  }
  function setDateTimeFormat(locale2, format3) {
    _datetimeFormats.value[locale2] = format3;
    _context.datetimeFormats = _datetimeFormats.value;
    clearDateTimeFormat(_context, locale2, format3);
  }
  function mergeDateTimeFormat(locale2, format3) {
    _datetimeFormats.value[locale2] = assign$4(_datetimeFormats.value[locale2] || {}, format3);
    _context.datetimeFormats = _datetimeFormats.value;
    clearDateTimeFormat(_context, locale2, format3);
  }
  function getNumberFormat(locale2) {
    return _numberFormats.value[locale2] || {};
  }
  function setNumberFormat(locale2, format3) {
    _numberFormats.value[locale2] = format3;
    _context.numberFormats = _numberFormats.value;
    clearNumberFormat(_context, locale2, format3);
  }
  function mergeNumberFormat(locale2, format3) {
    _numberFormats.value[locale2] = assign$4(_numberFormats.value[locale2] || {}, format3);
    _context.numberFormats = _numberFormats.value;
    clearNumberFormat(_context, locale2, format3);
  }
  composerID++;
  if (__root) {
    watch(__root.locale, (val) => {
      if (_inheritLocale) {
        _locale.value = val;
        _context.locale = val;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    });
    watch(__root.fallbackLocale, (val) => {
      if (_inheritLocale) {
        _fallbackLocale.value = val;
        _context.fallbackLocale = val;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    });
  }
  const composer = {
    id: composerID,
    locale,
    fallbackLocale,
    get inheritLocale() {
      return _inheritLocale;
    },
    set inheritLocale(val) {
      _inheritLocale = val;
      if (val && __root) {
        _locale.value = __root.locale.value;
        _fallbackLocale.value = __root.fallbackLocale.value;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    },
    get availableLocales() {
      return Object.keys(_messages.value).sort();
    },
    messages,
    get modifiers() {
      return _modifiers;
    },
    get pluralRules() {
      return _pluralRules || {};
    },
    get isGlobal() {
      return _isGlobal;
    },
    get missingWarn() {
      return _missingWarn;
    },
    set missingWarn(val) {
      _missingWarn = val;
      _context.missingWarn = _missingWarn;
    },
    get fallbackWarn() {
      return _fallbackWarn;
    },
    set fallbackWarn(val) {
      _fallbackWarn = val;
      _context.fallbackWarn = _fallbackWarn;
    },
    get fallbackRoot() {
      return _fallbackRoot;
    },
    set fallbackRoot(val) {
      _fallbackRoot = val;
    },
    get fallbackFormat() {
      return _fallbackFormat;
    },
    set fallbackFormat(val) {
      _fallbackFormat = val;
      _context.fallbackFormat = _fallbackFormat;
    },
    get warnHtmlMessage() {
      return _warnHtmlMessage;
    },
    set warnHtmlMessage(val) {
      _warnHtmlMessage = val;
      _context.warnHtmlMessage = val;
    },
    get escapeParameter() {
      return _escapeParameter;
    },
    set escapeParameter(val) {
      _escapeParameter = val;
      _context.escapeParameter = val;
    },
    t: t2,
    getLocaleMessage,
    setLocaleMessage,
    mergeLocaleMessage,
    getPostTranslationHandler,
    setPostTranslationHandler,
    getMissingHandler,
    setMissingHandler,
    [SetPluralRulesSymbol]: setPluralRules
  };
  {
    composer.datetimeFormats = datetimeFormats;
    composer.numberFormats = numberFormats;
    composer.rt = rt;
    composer.te = te;
    composer.tm = tm;
    composer.d = d2;
    composer.n = n;
    composer.getDateTimeFormat = getDateTimeFormat;
    composer.setDateTimeFormat = setDateTimeFormat;
    composer.mergeDateTimeFormat = mergeDateTimeFormat;
    composer.getNumberFormat = getNumberFormat;
    composer.setNumberFormat = setNumberFormat;
    composer.mergeNumberFormat = mergeNumberFormat;
    {
      composer[TransrateVNodeSymbol] = transrateVNode;
      composer[NumberPartsSymbol] = numberParts;
      composer[DatetimePartsSymbol] = datetimeParts;
    }
  }
  return composer;
}
const baseFormatProps = {
  tag: {
    type: [String, Object]
  },
  locale: {
    type: String
  },
  scope: {
    type: String,
    validator: (val) => val === "parent" || val === "global",
    default: "parent"
  },
  i18n: {
    type: Object
  }
};
const Translation = /* @__PURE__ */ defineComponent({
  name: "i18n-t",
  props: assign$4({
    keypath: {
      type: String,
      required: true
    },
    plural: {
      type: [Number, String],
      validator: (val) => isNumber$1(val) || !isNaN(val)
    }
  }, baseFormatProps),
  setup(props, context) {
    const { slots, attrs } = context;
    const i18n = props.i18n || useI18n$1({ useScope: props.scope });
    const keys = Object.keys(slots).filter((key) => key !== "_");
    return () => {
      const options2 = {};
      if (props.locale) {
        options2.locale = props.locale;
      }
      if (props.plural !== void 0) {
        options2.plural = isString$3(props.plural) ? +props.plural : props.plural;
      }
      const arg = getInterpolateArg(context, keys);
      const children = i18n[TransrateVNodeSymbol](props.keypath, arg, options2);
      const assignedAttrs = assign$4({}, attrs);
      const tag = isString$3(props.tag) || isObject$3(props.tag) ? props.tag : Fragment;
      return h$1(tag, assignedAttrs, children);
    };
  }
});
function getInterpolateArg({ slots }, keys) {
  if (keys.length === 1 && keys[0] === "default") {
    return slots.default ? slots.default() : [];
  } else {
    return keys.reduce((arg, key) => {
      const slot = slots[key];
      if (slot) {
        arg[key] = slot();
      }
      return arg;
    }, {});
  }
}
function renderFormatter(props, context, slotKeys, partFormatter) {
  const { slots, attrs } = context;
  return () => {
    const options2 = { part: true };
    let overrides = {};
    if (props.locale) {
      options2.locale = props.locale;
    }
    if (isString$3(props.format)) {
      options2.key = props.format;
    } else if (isObject$3(props.format)) {
      if (isString$3(props.format.key)) {
        options2.key = props.format.key;
      }
      overrides = Object.keys(props.format).reduce((options3, prop2) => {
        return slotKeys.includes(prop2) ? assign$4({}, options3, { [prop2]: props.format[prop2] }) : options3;
      }, {});
    }
    const parts2 = partFormatter(...[props.value, options2, overrides]);
    let children = [options2.key];
    if (isArray$1(parts2)) {
      children = parts2.map((part2, index2) => {
        const slot = slots[part2.type];
        return slot ? slot({ [part2.type]: part2.value, index: index2, parts: parts2 }) : [part2.value];
      });
    } else if (isString$3(parts2)) {
      children = [parts2];
    }
    const assignedAttrs = assign$4({}, attrs);
    const tag = isString$3(props.tag) || isObject$3(props.tag) ? props.tag : Fragment;
    return h$1(tag, assignedAttrs, children);
  };
}
const NUMBER_FORMAT_KEYS = [
  "localeMatcher",
  "style",
  "unit",
  "unitDisplay",
  "currency",
  "currencyDisplay",
  "useGrouping",
  "numberingSystem",
  "minimumIntegerDigits",
  "minimumFractionDigits",
  "maximumFractionDigits",
  "minimumSignificantDigits",
  "maximumSignificantDigits",
  "notation",
  "formatMatcher"
];
const NumberFormat = /* @__PURE__ */ defineComponent({
  name: "i18n-n",
  props: assign$4({
    value: {
      type: Number,
      required: true
    },
    format: {
      type: [String, Object]
    }
  }, baseFormatProps),
  setup(props, context) {
    const i18n = props.i18n || useI18n$1({ useScope: "parent" });
    return renderFormatter(props, context, NUMBER_FORMAT_KEYS, (...args) => i18n[NumberPartsSymbol](...args));
  }
});
const DATETIME_FORMAT_KEYS = [
  "dateStyle",
  "timeStyle",
  "fractionalSecondDigits",
  "calendar",
  "dayPeriod",
  "numberingSystem",
  "localeMatcher",
  "timeZone",
  "hour12",
  "hourCycle",
  "formatMatcher",
  "weekday",
  "era",
  "year",
  "month",
  "day",
  "hour",
  "minute",
  "second",
  "timeZoneName"
];
const DatetimeFormat = /* @__PURE__ */ defineComponent({
  name: "i18n-d",
  props: assign$4({
    value: {
      type: [Number, Date],
      required: true
    },
    format: {
      type: [String, Object]
    }
  }, baseFormatProps),
  setup(props, context) {
    const i18n = props.i18n || useI18n$1({ useScope: "parent" });
    return renderFormatter(props, context, DATETIME_FORMAT_KEYS, (...args) => i18n[DatetimePartsSymbol](...args));
  }
});
function getComposer$2(i18n, instance) {
  const i18nInternal = i18n;
  if (i18n.mode === "composition") {
    return i18nInternal.__getInstance(instance) || i18n.global;
  } else {
    const vueI18n = i18nInternal.__getInstance(instance);
    return vueI18n != null ? vueI18n.__composer : i18n.global.__composer;
  }
}
function vTDirective(i18n) {
  const bind = (el2, { instance, value, modifiers }) => {
    if (!instance || !instance.$) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    const composer = getComposer$2(i18n, instance.$);
    const parsedValue = parseValue(value);
    el2.textContent = Reflect.apply(composer.t, composer, [
      ...makeParams(parsedValue)
    ]);
  };
  return {
    beforeMount: bind,
    beforeUpdate: bind
  };
}
function parseValue(value) {
  if (isString$3(value)) {
    return { path: value };
  } else if (isPlainObject$2(value)) {
    if (!("path" in value)) {
      throw createI18nError(I18nErrorCodes.REQUIRED_VALUE, "path");
    }
    return value;
  } else {
    throw createI18nError(I18nErrorCodes.INVALID_VALUE);
  }
}
function makeParams(value) {
  const { path, locale, args, choice, plural } = value;
  const options2 = {};
  const named = args || {};
  if (isString$3(locale)) {
    options2.locale = locale;
  }
  if (isNumber$1(choice)) {
    options2.plural = choice;
  }
  if (isNumber$1(plural)) {
    options2.plural = plural;
  }
  return [path, named, options2];
}
function apply(app2, i18n, ...options2) {
  const pluginOptions = isPlainObject$2(options2[0]) ? options2[0] : {};
  const useI18nComponentName = !!pluginOptions.useI18nComponentName;
  const globalInstall = isBoolean$1(pluginOptions.globalInstall) ? pluginOptions.globalInstall : true;
  if (globalInstall) {
    app2.component(!useI18nComponentName ? Translation.name : "i18n", Translation);
    app2.component(NumberFormat.name, NumberFormat);
    app2.component(DatetimeFormat.name, DatetimeFormat);
  }
  {
    app2.directive("t", vTDirective(i18n));
  }
}
const I18nInjectionKey = /* @__PURE__ */ makeSymbol("global-vue-i18n");
function createI18n$1(options2 = {}, VueI18nLegacy) {
  const __globalInjection = !!options2.globalInjection;
  const __instances = /* @__PURE__ */ new Map();
  const __global = createGlobal(options2);
  const symbol = makeSymbol("");
  function __getInstance(component) {
    return __instances.get(component) || null;
  }
  function __setInstance(component, instance) {
    __instances.set(component, instance);
  }
  function __deleteInstance(component) {
    __instances.delete(component);
  }
  {
    const i18n = {
      get mode() {
        return "composition";
      },
      async install(app2, ...options3) {
        {
          app2.__VUE_I18N_SYMBOL__ = symbol;
          app2.provide(app2.__VUE_I18N_SYMBOL__, i18n);
        }
        if (__globalInjection) {
          injectGlobalFields(app2, i18n.global);
        }
        {
          apply(app2, i18n, ...options3);
        }
      },
      get global() {
        return __global;
      },
      __instances,
      __getInstance,
      __setInstance,
      __deleteInstance
    };
    return i18n;
  }
}
function useI18n$1(options2 = {}) {
  const instance = getCurrentInstance();
  if (instance == null) {
    throw createI18nError(I18nErrorCodes.MUST_BE_CALL_SETUP_TOP);
  }
  if (!instance.isCE && instance.appContext.app != null && !instance.appContext.app.__VUE_I18N_SYMBOL__) {
    throw createI18nError(I18nErrorCodes.NOT_INSLALLED);
  }
  const i18n = getI18nInstance(instance);
  const global2 = getGlobalComposer(i18n);
  const componentOptions = getComponentOptions(instance);
  const scope = getScope(options2, componentOptions);
  if (scope === "global") {
    adjustI18nResources(global2, options2, componentOptions);
    return global2;
  }
  if (scope === "parent") {
    let composer2 = getComposer(i18n, instance);
    if (composer2 == null) {
      composer2 = global2;
    }
    return composer2;
  }
  if (i18n.mode === "legacy") {
    throw createI18nError(I18nErrorCodes.NOT_AVAILABLE_IN_LEGACY_MODE);
  }
  const i18nInternal = i18n;
  let composer = i18nInternal.__getInstance(instance);
  if (composer == null) {
    const composerOptions = assign$4({}, options2);
    if ("__i18n" in componentOptions) {
      composerOptions.__i18n = componentOptions.__i18n;
    }
    if (global2) {
      composerOptions.__root = global2;
    }
    composer = createComposer(composerOptions);
    setupLifeCycle(i18nInternal, instance);
    i18nInternal.__setInstance(instance, composer);
  }
  return composer;
}
function createGlobal(options2, legacyMode, VueI18nLegacy) {
  {
    return createComposer(options2);
  }
}
function getI18nInstance(instance) {
  {
    const i18n = inject(!instance.isCE ? instance.appContext.app.__VUE_I18N_SYMBOL__ : I18nInjectionKey);
    if (!i18n) {
      throw createI18nError(!instance.isCE ? I18nErrorCodes.UNEXPECTED_ERROR : I18nErrorCodes.NOT_INSLALLED_WITH_PROVIDE);
    }
    return i18n;
  }
}
function getScope(options2, componentOptions) {
  return isEmptyObject$1(options2) ? "__i18n" in componentOptions ? "local" : "global" : !options2.useScope ? "local" : options2.useScope;
}
function getGlobalComposer(i18n) {
  return i18n.mode === "composition" ? i18n.global : i18n.global.__composer;
}
function adjustI18nResources(global2, options2, componentOptions) {
  let messages = isObject$3(options2.messages) ? options2.messages : {};
  if ("__i18nGlobal" in componentOptions) {
    messages = getLocaleMessages(global2.locale.value, {
      messages,
      __i18n: componentOptions.__i18nGlobal
    });
  }
  const locales = Object.keys(messages);
  if (locales.length) {
    locales.forEach((locale) => {
      global2.mergeLocaleMessage(locale, messages[locale]);
    });
  }
  {
    if (isObject$3(options2.datetimeFormats)) {
      const locales2 = Object.keys(options2.datetimeFormats);
      if (locales2.length) {
        locales2.forEach((locale) => {
          global2.mergeDateTimeFormat(locale, options2.datetimeFormats[locale]);
        });
      }
    }
    if (isObject$3(options2.numberFormats)) {
      const locales2 = Object.keys(options2.numberFormats);
      if (locales2.length) {
        locales2.forEach((locale) => {
          global2.mergeNumberFormat(locale, options2.numberFormats[locale]);
        });
      }
    }
  }
}
function getComposer(i18n, target2) {
  let composer = null;
  const root = target2.root;
  let current = target2.parent;
  while (current != null) {
    const i18nInternal = i18n;
    if (i18n.mode === "composition") {
      composer = i18nInternal.__getInstance(current);
    }
    if (composer != null) {
      break;
    }
    if (root === current) {
      break;
    }
    current = current.parent;
  }
  return composer;
}
function setupLifeCycle(i18n, target2, composer) {
  {
    onMounted(() => {
    }, target2);
    onUnmounted(() => {
      i18n.__deleteInstance(target2);
    }, target2);
  }
}
const globalExportProps = [
  "locale",
  "fallbackLocale",
  "availableLocales"
];
const globalExportMethods = ["t", "rt", "d", "n", "tm"];
function injectGlobalFields(app2, composer) {
  const i18n = /* @__PURE__ */ Object.create(null);
  globalExportProps.forEach((prop2) => {
    const desc = Object.getOwnPropertyDescriptor(composer, prop2);
    if (!desc) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    const wrap2 = isRef(desc.value) ? {
      get() {
        return desc.value.value;
      },
      set(val) {
        desc.value.value = val;
      }
    } : {
      get() {
        return desc.get && desc.get();
      }
    };
    Object.defineProperty(i18n, prop2, wrap2);
  });
  app2.config.globalProperties.$i18n = i18n;
  globalExportMethods.forEach((method) => {
    const desc = Object.getOwnPropertyDescriptor(composer, method);
    if (!desc || !desc.value) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    Object.defineProperty(app2.config.globalProperties, `$${method}`, desc);
  });
}
registerMessageResolver(resolveValue);
registerLocaleFallbacker(fallbackWithLocaleChain);
{
  initFeatureFlags();
}
if (__INTLIFY_PROD_DEVTOOLS__) {
  const target2 = getGlobalThis$1();
  target2.__INTLIFY__ = true;
  setDevToolsHook(target2.__INTLIFY_DEVTOOLS_GLOBAL_HOOK__);
}
const compiledMessages = {
  "en-US": {
    "links": {
      "learnMore": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Learn more."]);
      },
      "learnMoreButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Learn more"]);
      },
      "needHelp": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Need help"]);
      }
    },
    "components": {
      "modal": {
        "dismiss": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Dismiss"]);
        }
      },
      "fileSearch": {
        "noMatchesForExtension": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["No files found when searching for the file extension"]);
        },
        "noMatchesForFileName": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize([]);
        },
        "byFilenameInput": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Search by filename..."]);
        },
        "byExtensionInput": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Extensions to include e.g. *.tsx, *.vue"]);
        },
        "matchesIndicatorEmptyFileSearch": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize(["No matches"]), _normalize(["1 match"]), _normalize([_interpolate(_named("denominator")), " matches"])]);
        },
        "matchesIndicator": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize(["No matches"]), _normalize([_interpolate(_named("numerator")), " of ", _interpolate(_named("denominator")), " matches"]), _normalize([_interpolate(_named("numerator")), " of ", _interpolate(_named("denominator")), " matches"])]);
        }
      },
      "button": {
        "cancel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cancel"]);
        },
        "back": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Back"]);
        }
      },
      "loading": {
        "config": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Initializing config..."]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Please wait while we load your project and find browsers installed on your system"]);
          }
        }
      },
      "select": {
        "placeholder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Choose an option..."]);
        }
      },
      "alert": {
        "dismissAriaLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Dismiss"]);
        }
      },
      "specPattern": {
        "matches": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize(["No matches"]), _normalize([_interpolate(_named("n")), " match"]), _normalize([_interpolate(_named("n")), " matches"])]);
        }
      },
      "specPatternModal": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Spec pattern settings"]);
        }
      }
    },
    "clipboard": {
      "copy": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Copy"]);
      },
      "copied": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Copied!"]);
      }
    },
    "actions": {
      "close": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Close"]);
      }
    },
    "file": {
      "edit": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Edit"]);
      },
      "git": {
        "modified": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Modified"]);
        },
        "created": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Created"]);
        }
      }
    },
    "status": {
      "enabled": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Enabled"]);
      },
      "disabled": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Disabled"]);
      }
    },
    "createSpec": {
      "newSpec": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["New spec"]);
      },
      "createSpec": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Create spec"]);
      },
      "done": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Done!"]);
      },
      "noComponentsFound": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["No components found"]);
      },
      "unableToParseFile": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Unable to parse file"]);
      },
      "updateSpecPattern": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Update spec pattern"]);
      },
      "newSpecModalTitle": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Create new spec"]);
      },
      "successPage": {
        "header": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Great! The spec was successfully added"]);
        },
        "runSpecButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Okay, run the spec"]);
        },
        "createAnotherSpecButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Create another spec"]);
        }
      },
      "page": {
        "defaultPatternNoSpecs": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Create your first spec"]);
          },
          "component": {
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Since this project looks new, we recommend that you get started by creating a spec for one of your components."]);
            }
          },
          "e2e": {
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Since this project looks new, we recommend that you use the specs and tests that we've written for you to get started."]);
            }
          }
        },
        "customPatternNoSpecs": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["No specs found"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["We couldn't find any files matching the following spec patterns. You may need to move your specs or update your ", _interpolate(_list(0)), " to find them."]);
          }
        }
      },
      "noSpecsMessage": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["If you feel that you're seeing this screen in error, and there should be specs listed here, you likely need to update the spec pattern."]);
      },
      "viewSpecPatternButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["View spec pattern"]);
      },
      "e2e": {
        "importFromScaffold": {
          "header": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Scaffold example specs"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We'll generate several example specs to help guide you on how to write tests in Cypress."]);
          },
          "specsAddedHeader": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Great! We added the following files to your project:"]);
          },
          "specsAddedButton": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Okay, I got it!"]);
          },
          "specsAddingHeader": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Adding specs..."]);
          }
        },
        "importTemplateSpec": {
          "header": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Create new spec"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We'll generate a template spec file which can be used to start testing your application."]);
          },
          "chooseFilenameHeader": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Enter the path for your new spec"]);
          },
          "inputPlaceholder": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Enter a relative path..."]);
          },
          "invalidSpecWarning": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["This path is invalid because it doesn't match the following "]);
          },
          "specExtensionWarning": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We recommend naming your spec to match the following pattern: "]);
          }
        }
      },
      "component": {
        "importFromComponent": {
          "header": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Create from component"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Generate a basic component test for any of the components in this project."]);
          },
          "chooseAComponentHeader": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Choose a component"]);
          }
        },
        "importTemplateSpec": {
          "header": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Create new spec"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We'll generate a template spec file which can be used to start testing your components."]);
          },
          "invalidComponentWarning": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We couldn't generate a valid path matching your custom "]);
          }
        }
      }
    },
    "specPage": {
      "pageTitle": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Specs"]);
      },
      "newSpecButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["New spec"]);
      },
      "searchPlaceholder": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Search specs"]);
      },
      "clearSearch": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Clear search field"]);
      },
      "componentSpecsHeader": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Component specs"]);
      },
      "e2eSpecsHeader": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["E2E specs"]);
      },
      "lastUpdated": {
        "header": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Last updated"]);
        },
        "tooltip": {
          "gitStatus": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Git status"]);
          },
          "gitInfo": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["git info"]);
          },
          "gitInfoAvailable": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize([_interpolate(_list(0)), " of the spec files within this project"]);
          },
          "gitInfoUnavailable": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["Cypress is unable to detect ", _interpolate(_list(0)), " for this project and has defaulted to showing file system data instead"]);
          }
        }
      },
      "latestRuns": {
        "header": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Latest runs"]);
        },
        "headerShort": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Runs"]);
        },
        "tooltip": {
          "connected": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["The ", _interpolate(_list(0)), " in Cypress Cloud"]);
          },
          "notConnected": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["Connect to Cypress Cloud to see the ", _interpolate(_list(0))]);
          },
          "noAccess": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["Request access to this project in Cypress Cloud to view the ", _interpolate(_list(0))]);
          },
          "linkText": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["status of your latest runs"]);
          }
        }
      },
      "averageDuration": {
        "header": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Average duration"]);
        },
        "headerShort": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Duration"]);
        },
        "tooltip": {
          "connected": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["The ", _interpolate(_list(0)), " of your latest runs in Cypress Cloud"]);
          },
          "notConnected": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["Connect to Cypress Cloud to see the ", _interpolate(_list(0)), " of your latest runs"]);
          },
          "noAccess": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["Request access to this project in Cypress Cloud to view the ", _interpolate(_list(0)), " of your latest runs"]);
          },
          "linkText": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["average spec durations"]);
          }
        }
      },
      "flaky": {
        "badgeLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Flaky"]);
        },
        "severityLow": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Low"]);
        },
        "severityMedium": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Medium"]);
        },
        "severityHigh": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["High"]);
        },
        "flakyRate": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize([_interpolate(_list(0)), "% flaky rate"]);
        },
        "flakyRuns": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize([_interpolate(_named("flakyRuns")), " flaky runs / ", _interpolate(_named("totalRuns")), " total"]), _normalize([_interpolate(_named("flakyRuns")), " flaky run / ", _interpolate(_named("totalRuns")), " total"]), _normalize([_interpolate(_named("flakyRuns")), " flaky runs / ", _interpolate(_named("totalRuns")), " total"])]);
        },
        "lastFlaky": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize(["Last run flaky"]), _normalize(["Last flaky ", _interpolate(_named("runsSinceLastFlake")), " run ago"]), _normalize(["Last flaky ", _interpolate(_named("runsSinceLastFlake")), " runs ago"])]);
        }
      },
      "hoverButton": {
        "connect": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Connect"]);
        },
        "connectProject": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Connect project"]);
        },
        "connectProjectShort": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Connect"]);
        },
        "requestAccess": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Request access"]);
        },
        "requestAccessShort": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Request"]);
        },
        "requestSent": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Request sent"]);
        },
        "requestSentShort": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Sent"]);
        }
      },
      "connectProjectButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Connect your project"]);
      },
      "cloudLoginButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Log in to Cypress Cloud"]);
      },
      "reconnectProjectButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Reconnect your project"]);
      },
      "unauthorizedBannerTitle": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Request access to project"]);
      },
      "requestAccessButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Request access"]);
      },
      "requestSentButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Request sent"]);
      },
      "rows": {
        "gitTooltipSubtext": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize([_interpolate(_named("shortHash")), " by ", _interpolate(_named("author"))]);
        }
      },
      "noResultsMessage": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["No specs matched your search:"]);
      },
      "noSpecError": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Spec not found"]);
        },
        "intro": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["There is no spec matching the following location:"]);
        },
        "explainer": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["It is possible that the file has been moved or deleted. Please choose from the list of specs below."]);
        }
      },
      "offlineWarning": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["No internet connection"]);
        },
        "explainer": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Please check your internet connection to resolve this issue. When your internet connection is fixed, we will automatically attempt to fetch the run metrics from Cypress Cloud."]);
        }
      },
      "fetchFailedWarning": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Lost connection"]);
        },
        "explainer1": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["The request timed out or failed when trying to retrieve the recorded run metrics from Cypress Cloud. The information that you're seeing in the table below may be incomplete as a result."]);
        },
        "explainer2": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Please refresh the page to try again and visit our ", _interpolate(_list(0)), " if this behavior continues."]);
        },
        "refreshButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Try again"]);
        }
      },
      "banners": {
        "login": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Optimize and record your CI test runs with Cypress Cloud"]);
          },
          "contentA": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Parallelize your tests in CI and visualize every error by watching full video recordings of each test you run."]);
          },
          "contentB": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["When you configure Cypress to record tests to Cypress Cloud, you'll see data from your latest recorded runs in the Cypress app. This increased visibility into your test history allows you to debug your tests faster and more effectively, all within your local workflow."]);
          },
          "buttonLabel": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Get started with Cypress Cloud"]);
          }
        },
        "createOrganization": {
          "titleA": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Finish setting up Cypress Cloud"]);
          },
          "titleB": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Create or join an organization"]);
          },
          "content": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Join or create an organization in Cypress Cloud to access your projects and recorded test runs."]);
          },
          "buttonLabel": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Set up your organization"]);
          }
        },
        "connectProject": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Connect your project to Cypress Cloud"]);
          },
          "contentA": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["View recorded test runs directly in the Cypress app to monitor, run, and fix tests locally."]);
          },
          "contentB": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Bring your recorded test results into your local development workflow to monitor, run, and fix tests all in the Cypress app."]);
          },
          "buttonLabel": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Connect your project"]);
          }
        },
        "record": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Record your first run"]);
          },
          "content": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Record a run to see your test results in Cypress Cloud. You can then optimize your test suite, debug failing and flaky tests, and integrate with your favorite tools."]);
          }
        }
      },
      "runSelectedSpecs": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
        return _plural([_normalize(["Run ", _interpolate(_named("n")), " spec"]), _normalize(["Run ", _interpolate(_named("n")), " specs"])]);
      }
    },
    "noResults": {
      "defaultMessage": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["No results matched your search:"]);
      },
      "clearSearch": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Clear search"]);
      }
    },
    "sidebar": {
      "keyboardShortcuts": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Keyboard shortcuts"]);
        },
        "rerun": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Re-run tests"]);
        },
        "stop": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Stop tests"]);
        },
        "toggle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Toggle specs list"]);
        }
      },
      "toggleLabel": {
        "expanded": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Collapse sidebar"]);
        },
        "collapsed": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Expand sidebar"]);
        }
      },
      "nav": {
        "ariaLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Pages"]);
        }
      }
    },
    "topNav": {
      "released": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Released"]);
      },
      "version": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Version"]);
      },
      "versionUnsupported": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Unsupported"]);
      },
      "installed": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Installed"]);
      },
      "latest": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Latest"]);
      },
      "seeAllReleases": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["See all releases"]);
      },
      "runningOldVersion": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["You're currently running an old version of Cypress. Update to the latest version for the best experience."]);
      },
      "docsMenu": {
        "docsHeading": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Docs"]);
        },
        "gettingStartedTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Getting started"]);
        },
        "firstTest": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Write your first test"]);
        },
        "testingApp": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Testing your app"]);
        },
        "organizingTests": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Organizing tests"]);
        },
        "referencesTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["References"]);
        },
        "bestPractices": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Best practices"]);
        },
        "configuration": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Configuration"]);
        },
        "api": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["API"]);
        },
        "ciTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Run in CI/CD"]);
        },
        "ciSetup": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Set up CI"]);
        },
        "fasterTests": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Run tests faster"]);
        },
        "prompts": {
          "ci1": {
            "title": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Configure CI"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Optimize your tests in CI by following these guides."]);
            },
            "seeOtherGuides": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["See other guides"]);
            },
            "intro": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Introduction to CI"]);
            },
            "learnTheBasics": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Learn the basics of running Cypress in CI."]);
            }
          },
          "orchestration1": {
            "title": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Run tests faster in CI"]);
            },
            "parallelTime": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["5 mins"]);
            },
            "noParallelTime": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["12 mins"]);
            },
            "withParallelization": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["with Parallelization"]);
            },
            "withoutParallelization": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["without Parallelization"]);
            },
            "intro": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["With Smart Orchestration, you'll be able to:"]);
            },
            "bullet1": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Run spec files in parallel"]);
            },
            "bullet2": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Prioritize failed specs to run first"]);
            },
            "bullet3": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Cancel CI runs on test failure"]);
            },
            "learnMore": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Learn more"]);
            }
          }
        }
      },
      "login": {
        "bodyInitial": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Logging in gives you access to ", _interpolate(_list(0)), ". You can set up projects to be recorded and see test data from your project."]);
        },
        "bodySuccess": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["You are now logged in as ", _interpolate(_list(0)), "."]);
        },
        "bodyError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["An error occurred while attempting to log in:"]);
        },
        "bodyBrowserError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["The browser could not be opened."]);
        },
        "bodyBrowserErrorDetails": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress was unable to open your installed browser. To continue logging in, please paste this URL into your web browser:"]);
        },
        "cloud": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress Cloud"]);
        },
        "titleInitial": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Log in to Cypress"]);
        },
        "titleSuccess": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Login successful"]);
        },
        "titleFailed": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Login failed"]);
        },
        "titleBrowserError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Browser error"]);
        },
        "actionLogin": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Log in"]);
        },
        "profileMenuLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Profile and logout"]);
        },
        "actionLogout": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Log out"]);
        },
        "actionContinue": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Continue"]);
        },
        "actionOpening": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Opening browser"]);
        },
        "actionWaiting": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Waiting for you to log in"]);
        },
        "actionTryAgain": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Try again"]);
        },
        "actionCancel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cancel"]);
        }
      },
      "updateCypress": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Upgrade to Cypress"]);
        },
        "currentlyRunning": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["You are currently running Version ", _interpolate(_list(0)), " of Cypress. "]);
        },
        "pasteToUpgradeProject": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["To upgrade to the latest version for your project, first ", _interpolate(_list(0)), ", then paste the command below into your terminal:"]);
        },
        "pasteToUpgradeGlobal": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["To upgrade to the latest version, first ", _interpolate(_list(0)), ", then paste the command below into your terminal:"]);
        },
        "rememberToCloseInsert": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["close this app"]);
        }
      },
      "upgradeText": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Upgrade"]);
      },
      "global": {
        "projects": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Projects"]);
        }
      }
    },
    "launchpadErrors": {
      "generic": {
        "configErrorTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress configuration error"]);
        },
        "retryButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Try again"]);
        },
        "stackTraceLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Stack trace"]);
        },
        "docsButton": {
          "configGuide": {
            "text": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Configuration guide"]);
            },
            "link": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["https://docs.cypress.io/guides/references/configuration"]);
            }
          },
          "cloudGuide": {
            "text": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Cypress Cloud guide"]);
            },
            "link": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["https://on.cypress.io/features-dashboard"]);
            }
          },
          "docsHomepage": {
            "text": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Cypress docs"]);
            },
            "link": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["https://docs.cypress.io"]);
            }
          }
        }
      },
      "noInternet": {
        "header": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You have no internet connection"]);
        },
        "message": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Check your internet connection to pull the latest data from Cypress Cloud."]);
        },
        "connectProject": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Please check your internet connection to resolve this issue. When your internet connection is fixed, we will automatically attempt to fetch your latest runs for this project."]);
        }
      }
    },
    "setupPage": {
      "projectSetup": {
        "frameworkLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Front-end framework"]);
        },
        "frameworkPlaceholder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Pick a framework"]);
        },
        "bundlerLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Bundler"]);
        },
        "bundlerLabelDescription": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["(dev server)"]);
        },
        "bundlerPlaceholder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Pick a bundler"]);
        },
        "languageLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Language"]);
        },
        "configFileLanguageLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress config file"]);
        },
        "detected": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["(detected)"]);
        }
      },
      "step": {
        "continue": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Continue"]);
        },
        "next": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Next step"]);
        },
        "back": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Back"]);
        },
        "skip": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Skip"]);
        }
      },
      "configFile": {
        "createManually": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Create file manually"]);
        },
        "skippedLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Skipped"]);
        },
        "changesRequiredLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Changes required"]);
        },
        "changesRequiredBadge": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Changes required"]);
        },
        "changesRequiredDescription": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Please merge the code below with your existing ", _interpolate(_list(0))]);
        }
      },
      "testingCard": {
        "configured": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Configured"]);
        },
        "notConfigured": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Not Configured"]);
        },
        "running": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Running"]);
        },
        "chooseABrowser": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Choose a browser"]);
        },
        "reconfigure": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Reconfigure"]);
        },
        "disabled": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Disabled"]);
        }
      }
    },
    "globalPage": {
      "empty": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Add project"]);
        },
        "helper": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Get started by adding your first project below."]);
        },
        "dropText": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Drag your project directory here or ", _interpolate(_list(0))]);
        },
        "browseManually": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["browse manually."]);
        }
      },
      "settings": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Settings"]);
      },
      "saveChanges": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Save changes"]);
      },
      "cancel": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Cancel"]);
      },
      "externalEditorPreferences": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["External editor preferences"]);
      },
      "externalEditorPreferencesDescription1": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Select your preference for opening files on your system."]);
      },
      "externalEditorPreferencesDescription2": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
        return _normalize(["You can change this later in the ", _interpolate(_list(0)), " page."]);
      },
      "recentProjectsHeader": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Recent projects"]);
      },
      "searchPlaceholder": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Search projects"]);
      },
      "addProjectButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Add project"]);
      },
      "projectActions": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Project actions"]);
      },
      "removeProject": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Remove project"]);
      },
      "openInIDE": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Open in IDE"]);
      },
      "openInFinder": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Open in Finder"]);
      },
      "noResultsMessage": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["No projects matched your search:"]);
      }
    },
    "welcomePage": {
      "review": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Review the differences between each testing type"]);
      },
      "codeExample": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Code example"]);
      },
      "compareTypes": {
        "content": {
          "e2eTitle": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["End-to-end tests"]);
          },
          "e2eBullet1": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Visit URLs via"]);
          },
          "e2eBullet2": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Test flows and functionality across multiple pages"]);
          },
          "e2eBullet3": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Ideal for testing integrated flows in CD workflows"]);
          },
          "componentTitle": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Component tests"]);
          },
          "ctBullet1": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Import components via"]);
          },
          "ctBullet2": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Test individual components of a design system in isolation"]);
          },
          "ctBullet3": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Ideal for testing isolated flows and components in CI"]);
          }
        },
        "modalTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Key differences"]);
        }
      },
      "title": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Welcome to Cypress!"]);
      }
    },
    "settingsPage": {
      "config": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Resolved configuration"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Since the options in the ", _interpolate(_list(0)), " can be set dynamically by your development environment, please refer to the legend below to understand how the configuration options are resolved."]);
        },
        "legend": {
          "env": {
            "label": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["env"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Set from environment variables"]);
            }
          },
          "default": {
            "label": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["default"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Default values"]);
            }
          },
          "dynamic": {
            "label": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["dynamic"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
              return _normalize(["Set by the ", _interpolate(_list(0)), " function"]);
            }
          },
          "cli": {
            "label": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["cli"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Set from CLI arguments"]);
            }
          },
          "config": {
            "label": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["config"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
              return _normalize(["Set from ", _interpolate(_list(0))]);
            }
          }
        }
      },
      "proxy": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Proxy settings"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress auto-detected the following proxy settings from your operating system."]);
        },
        "bypassList": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Proxy bypass list"]);
        },
        "proxyServer": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Proxy server"]);
        }
      },
      "editor": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["External editor"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["External editor to use for editing code opened when using Cypress."]);
        },
        "noEditorSelectedPlaceholder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Choose your editor..."]);
        },
        "customPathPlaceholder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["/path/to/editor"]);
        }
      },
      "projectId": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Project ID"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["The Project ID configured for this project inside of Cypress Cloud. ", _interpolate(_list(0))]);
        }
      },
      "specPattern": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Spec patterns"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["The globs pointing Cypress to your spec files configured for this project. ", _interpolate(_list(0))]);
        }
      },
      "recordKey": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Record key"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["The Record Key configured for this project inside of Cypress Cloud. ", _interpolate(_list(0))]);
        },
        "manageKeys": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Manage keys"]);
        },
        "errorEmpty": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You do not have permission to record on this project"]);
        },
        "errorEmptyButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Request record rights"]);
        },
        "errorAccess": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You do not have permission to view this project"]);
        },
        "errorAccessPending": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Your request for access to this project is pending approval"]);
        },
        "errorAccessButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Request access"]);
        },
        "errorNotFound": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Project not found"]);
        },
        "errorNotFoundButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Connect it again"]);
        },
        "errorNotLoggedIn": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You are not connected to Cypress Cloud"]);
        },
        "errorNotLoggedInButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Log in to Cypress Cloud"]);
        }
      },
      "project": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Project settings"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Review the configuration settings currently in use for this project."]);
        }
      },
      "cloud": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress Cloud settings"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Review the configuration settings for recording to Cypress Cloud."]);
        }
      },
      "experiments": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Experiments"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["If you'd like to try out new features that we're working on, you can enable beta features for your project by turning on the experimental features you'd like to try. ", _interpolate(_list(0))]);
        },
        "experimentalFetchPolyfill": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Fetch polyfill"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Automatically replaces `window.fetch` with a polyfill that Cypress can spy on and stub. Note: `experimentalFetchPolyfill` has been deprecated in Cypress 6.0.0 and will be removed in a future release. Consider using [`cy.intercept()`](https://on.cypress.io/intercept) to intercept `fetch` requests instead."]);
          }
        },
        "experimentalInteractiveRunEvents": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Interactive run events"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Allows listening to the [`before:run`](https://on.cypress.io/before-run), [`after:run`](https://on.cypress.io/after-run), [`before:spec`](https://on.cypress.io/before-spec), and [`after:spec`](https://on.cypress.io/after-spec) events in plugins during interactive mode."]);
          }
        },
        "experimentalModifyObstructiveThirdPartyCode": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Modify obstructive third party code"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Applies `modifyObstructiveCode` to third party `.html` and `.js`, removes subresource integrity, and modifies the user agent in Electron."]);
          }
        },
        "experimentalSingleTabRunMode": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Single tab run mode"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Runs all component specs in a single tab, trading spec isolation for faster run mode execution."]);
          }
        },
        "experimentalSourceRewriting": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Source rewriting"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Enables AST-based JS/HTML rewriting. This may fix issues caused by the existing regex-based JS/HTML replacement algorithm. See [#5273](https://github.com/cypress-io/cypress/issues/5273) for details."]);
          }
        },
        "experimentalStudio": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Studio"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Generate and save commands directly to your test suite by interacting with your app as an end user would."]);
          }
        },
        "experimentalWebKitSupport": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["WebKit Support"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Adds support for testing in the WebKit browser engine used by Safari. See https://on.cypress.io/webkit-experiment for more information."]);
          }
        },
        "experimentalRunAllSpecs": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Run All Specs"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(['Enables the "Run All Specs" UI feature, allowing the execution of multiple specs sequentially.']);
          }
        },
        "experimentalOriginDependencies": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Origin Dependencies"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Enables support for `require`/`import` within `cy.origin`."]);
          }
        }
      },
      "device": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Device settings"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Review the configuration settings currently in use for this device."]);
        }
      },
      "testingPreferences": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Testing preferences"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Configure your testing environment with these flags"]);
        },
        "autoScrollingEnabled": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Auto scrolling enabled"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Scroll behavior when running tests."]);
          }
        }
      },
      "footer": {
        "text": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["You can reconfigure the ", _interpolate(_named("testingType")), " testing settings for this project if you're experiencing issues with your Cypress configuration."]);
        },
        "button": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Configuration guide"]);
        },
        "buttonLink": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["https://docs.cypress.io/guides/references/configuration"]);
        }
      }
    },
    "runs": {
      "connect": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["View your recorded runs from Cypress Cloud"]);
        },
        "smartText": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Scale your test runs with built-in Smart Orchestration."]);
        },
        "debugText": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Debug tests that fail in CI with visual feedback."]);
        },
        "chartText": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Keep your tests in tip-top shape with powerful analytics."]);
        },
        "buttonUser": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Log in to Cypress Cloud"]);
        },
        "buttonProject": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Connect your project to Cypress Cloud"]);
        },
        "modal": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Connect project"]);
          },
          "cancel": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cancel"]);
          },
          "createOrg": {
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["You need to create an organization in Cypress Cloud to continue."]);
            },
            "button": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Create organization"]);
            },
            "waitingButton": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Waiting for you to create an organization..."]);
            },
            "refreshButton": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Refresh organizations list"]);
            }
          },
          "selectProject": {
            "organization": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Organization"]);
            },
            "noOrganizationSelectedError": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["required when creating a new project"]);
            },
            "manageOrgs": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Manage organizations"]);
            },
            "project": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Project"]);
            },
            "projectName": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Project name"]);
            },
            "projectNameDisclaimer": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["(You can change this later)"]);
            },
            "createNewProject": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Create new"]);
            },
            "chooseExistingProject": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Choose an existing project"]);
            },
            "newProjectAccess": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Project access"]);
            },
            "privateLabel": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Private"]);
            },
            "privateDescription": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Only invited users can view recorded test results."]);
            },
            "publicLabel": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Public"]);
            },
            "publicDescription": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Anyone can view recorded test results."]);
            },
            "connectProject": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Connect project"]);
            },
            "createProject": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Create project"]);
            },
            "placeholderOrganizations": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Pick an organization"]);
            },
            "placeholderProjects": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Pick a project"]);
            },
            "placeholderProjectsPending": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Pick an organization first"]);
            }
          },
          "connectManually": {
            "title": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Connect project manually"]);
            },
            "warning": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["We couldn't add the projectId to your cypress.config.js file automatically."]);
            },
            "mainMessage": (ctx) => {
              const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
              return _normalize(["Manually add the ", _interpolate(_named("projectId")), " to the root of the config object in your ", _interpolate(_named("configFile")), " file."]);
            },
            "waitingButton": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Waiting for you to add the projectId..."]);
            }
          }
        },
        "errors": {
          "baseError": {
            "title": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Cypress Cloud error"]);
            }
          },
          "internalServerError": {
            "title": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Cannot connect to Cypress Cloud"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
              return _normalize(["The request times out when trying to retrieve the info from Cypress Cloud. Please refresh the page to try again and visit out ", _interpolate(_list(0)), " if this behavior continues."]);
            },
            "link": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Support Page"]);
            }
          }
        }
      },
      "connectSuccessAlert": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["This project is now connected to Cypress Cloud!"]);
        },
        "item1": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["We automatically added the ", _interpolate(_named("projectId")), " to your ", _interpolate(_named("configFile")), " file."]);
        },
        "item2": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Please ensure that your ", _interpolate(_list(0)), " file is checked into source control."]);
        }
      },
      "empty": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Record your first run to Cypress Cloud"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Run the command below in your local development terminal or in CI."]);
        }
      },
      "results": {
        "skipped": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["skipped"]);
        },
        "pending": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["pending"]);
        },
        "passed": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["passed"]);
        },
        "failed": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["failed"]);
        }
      },
      "errors": {
        "notFound": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Couldn't find your project"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["We were unable to find an existing project matching the ", _interpolate(_list(0)), " set in your Cypress config file. You can reconnect with an existing project or create a new project."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Reconnect your project"]);
          }
        },
        "unauthorized": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Request access to view the recorded runs"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["This is a private project that you do not currently have access to. Please request access from the project owner in order to view the list of runs."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Request access"]);
          }
        },
        "unauthorizedRequested": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Your access request for this project has been sent."]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["The owner of this project has been notified of your request. We'll notify you via email when your access request has been granted."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Request Sent"]);
          }
        },
        "connectionFailed": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cannot connect to Cypress Cloud"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["The request times out when trying to retrieve the recorded runs from Cypress Cloud. Please refresh the page to try again and visit out ", _interpolate(_list(0)), " if this behavior continues."]);
          },
          "link": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Support page"]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Try again"]);
          }
        }
      }
    },
    "testingType": {
      "modalTitle": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Choose a testing type"]);
      },
      "e2e": {
        "name": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["E2E Testing"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Build and test the entire experience of your application from end-to-end to ensure each flow matches your expectations."]);
        }
      },
      "component": {
        "name": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Component Testing"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Build and test your components from your design system in isolation in order to ensure each state matches your expectations."]);
        }
      },
      "componentDisabled": {
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["To test your components you must ", _interpolate(_list(0)), " as an NPM dependency for this project."]);
        },
        "link": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["install Cypress"]);
        }
      }
    },
    "migration": {
      "before": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Before"]);
      },
      "after": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["After"]);
      },
      "heresWhy": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["here's why:"]);
      },
      "renameAuto": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We recommend automatically renaming your specs in this step"]);
        },
        "changeButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["change"]);
        },
        "changedSpecFolder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We've changed the default spec folder from:"]);
        },
        "changedSpecExt": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We've changed the default spec file extension from:"]);
        },
        "changedSpecPatternExplain": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["We've changed the default spec file extension to ", _interpolate(_list(0)), " in order to avoid conflicts with any existing testing frameworks."]);
        },
        "optedOutMessage": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You've opted not to rename your spec file extension. You may need to change your specPattern later so we can still find your spec files."]);
        },
        "folderRenameMessage": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You've opted not to rename your spec file extension, we'll only rename the folder"]);
        },
        "modal": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Change the existing spec file extension"]);
          },
          "warning": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We recommend using the default extension to avoid inconsistencies, framework conflicts, and confusion with your team."]);
          },
          "line1": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cypress now supports the ability to create new spec files from within the UI for both E2E and component specs."]);
          },
          "line2": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["All new spec files created within Cypress will use the default pattern of: "]);
          },
          "line3": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We want to rename your existing specs so that they have a consistent filename pattern for both E2E and component testing."]);
          },
          "line4": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["All documentation and example code will be using: "]);
          },
          "line5": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We've changed the placement of component specs to be next to their source files (e.g. src/Button.jsx and src/Button.cy.jsx)"]);
          },
          "line6": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["The new default pattern of ", _interpolate(_list(0)), " prevents targeting conflicts with other testing frameworks. (e.g. Jest)"]);
          },
          "label": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Choose from the following filename patterns:"]);
          },
          "option1": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize([_interpolate(_list(0)), " (recommended)"]);
          },
          "option2": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Don't rename anything — keep what I have."]);
          },
          "option3": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Rename folder only."]);
          },
          "optOutAdditional": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["I may need to change my ", _interpolate(_list(0)), " later if I don't use the recommended filename extension."]);
          },
          "buttonSave": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Save changes"]);
          },
          "buttonCancel": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cancel"]);
          }
        }
      },
      "renameManual": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We need you to move your component specs manually"]);
        },
        "componentFolderRemoved": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["We've removed the ", _interpolate(_list(0)), " options from the Cypress config."]);
        },
        "addedSpecPattern": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["We've added a new ", _interpolate(_list(0)), " option in the Cypress config that tells us where to find your component specs."]);
        },
        "cannotAuto": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["We can't automatically migrate your existing component spec files. We recommend that you move the following component spec files next to your source component files (e.g. ", _interpolate(_list(0)), ")"]);
        },
        "ifSkipNote": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["If you skip this step, Cypress will still be able to find them, but any new specs that you create will automatically be created next to your component files."]);
        }
      },
      "renameSupport": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We'll automatically rename your existing E2E support file in this step"]);
        },
        "serveDifferentTypes": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We now serve different support files for E2E and Component Testing."]);
        },
        "changedSupportFile": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We've renamed the E2E support file from:"]);
        }
      },
      "configFile": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We need to migrate to the new Cypress configuration file"]);
        },
        "changedDefault": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We've changed the default Cypress config file from:"]);
        },
        "customOptions": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["We've set a custom ", _interpolate(_named("specPattern")), " option based on your ", _interpolate(_named("options")), "."]);
        },
        "willConvert": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["We'll automatically create a new ", _interpolate(_named("jsFile")), " file and seed it with your options from your existing ", _interpolate(_named("jsonFile")), "."]);
        }
      },
      "setupComponent": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You need to reconfigure Cypress for component testing"]);
        },
        "line1": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We've detected that you are currently using the experimental version of component testing."]);
        },
        "line2": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Your existing configuration is no longer compatible with new component testing configuration options."]);
        },
        "line3": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["In a previous step, we renamed your component specs, but can't automatically migrate your existing component testing configuration."]);
        },
        "line4": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["In the next screen, you'll be able to reconfigure component testing in a new guided configuration wizard."]);
        }
      },
      "wizard": {
        "title": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["Migrating to Cypress ", _interpolate(_named("version"))]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Your project requires updates to work with this version."]);
        },
        "typicalMigrationLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Typical migration:"]);
        },
        "typicalMigrationTime": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["5-10 minutes"]);
        },
        "step1": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Migrate existing specs"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["In this step, we'll automatically rename and/or move your existing spec files as needed."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Rename these specs for me"]);
          },
          "buttonSkip": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Skip renaming specs"]);
          },
          "buttonRenameFolder": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Rename the folder for me"]);
          }
        },
        "step2": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Move your existing component specs"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["In this step, you'll manually move your existing component specs to their new default location."]);
          },
          "buttonWait": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Waiting for you to move your component specs..."]);
          },
          "buttonDone": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Continue to next step"]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["I'll do this later"]);
          }
        },
        "step3": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Rename the Cypress support file"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["In this step, we'll automatically rename your existing support file."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Rename the support file for me"]);
          }
        },
        "step4": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Migrate to the new Cypress configuration file"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["In this step, we'll automatically migrate your existing Cypress configuration to the new Cypress configuration file."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Migrate the configuration for me"]);
          }
        },
        "step5": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Reconfigure component testing"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["In this step, we'll explain how you will reconfigure Cypress for component testing."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Finish migration and continue"]);
          }
        }
      }
    },
    "majorVersionWelcome": {
      "title": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["What's New in Cypress"]);
      },
      "actionContinue": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Continue"]);
      },
      "linkReleaseNotes": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["View full changelog"]);
      }
    },
    "setupWizard": {
      "selectFramework": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Project setup"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Confirm the front-end framework and bundler used in your project."]);
        }
      },
      "installDependencies": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Install dev dependencies"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Based on your previous selection, the following dependencies are required."]);
        },
        "pasteCommand": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Paste this command into your terminal to install the following packages:"]);
        },
        "waitForInstall": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Waiting for you to install the dependencies..."]);
        },
        "installed": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["installed"]);
        },
        "pendingInstall": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["pending installation"]);
        },
        "installationAlertSuccess": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You've successfully installed all required dependencies."]);
        }
      },
      "configFiles": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Configuration files"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We added the following files to your project:"]);
        }
      },
      "chooseBrowser": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Choose a browser"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["Choose your preferred browser for ", _interpolate(_named("testingType")), " testing."]);
        }
      }
    },
    "e2eProjectSetup": {
      "title": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Project setup"]);
      },
      "description": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Confirm your project's preferred language."]);
      }
    },
    "openBrowser": {
      "startComponent": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
        return _normalize(["Start Component Testing in ", _interpolate(_named("browser"))]);
      },
      "startE2E": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
        return _normalize(["Start E2E Testing in ", _interpolate(_named("browser"))]);
      },
      "openingComponent": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
        return _normalize(["Opening Component Testing in ", _interpolate(_named("browser"))]);
      },
      "openingE2E": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
        return _normalize(["Opening E2E Testing in ", _interpolate(_named("browser"))]);
      },
      "running": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
        return _normalize(["Running ", _interpolate(_named("browser"))]);
      },
      "focus": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Focus"]);
      },
      "close": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Close"]);
      },
      "switchTestingType": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Switch testing type"]);
      }
    },
    "runner": {
      "header": {
        "reviewDocs": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Review the docs"]);
        },
        "troubleRendering": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["if you're having trouble rendering your components properly."]);
        }
      },
      "snapshot": {
        "highlightsLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Highlights"]);
        },
        "testsRunningError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cannot show snapshot while tests are running"]);
        },
        "snapshotMissingError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["The snapshot is missing. Displaying current state of the DOM."]);
        },
        "defaultTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["DOM snapshot"]);
        },
        "pinnedTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Pinned"]);
        },
        "studioActiveError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cannot show snapshot while creating commands in Studio"]);
        }
      },
      "selectorPlayground": {
        "matches": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize(["No matches"]), _normalize([_interpolate(_named("n")), " match"]), _normalize([_interpolate(_named("n")), " matches"])]);
        },
        "playgroundTooltip": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Click an element to see a suggested selector"]);
        },
        "copyTooltip": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Copy to clipboard"]);
        },
        "copyTooltipAction": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Copied!"]);
        },
        "printTooltip": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Print to console"]);
        },
        "printTooltipAction": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Printed!"]);
        },
        "invalidSelector": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Invalid"]);
        },
        "selectorMethodsLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Selector methods"]);
        },
        "toggle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Toggle playground"]);
        }
      },
      "automation": {
        "disconnected": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["The Cypress extension has disconnected."]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cypress cannot run tests without this extension."]);
          },
          "reload": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Reload the browser"]);
          }
        },
        "missing": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["The Cypress extension is missing."]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cypress cannot run tests without this extension. Please choose another browser."]);
          }
        },
        "shared": {
          "link": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Read more about browser management"]);
          }
        }
      },
      "viewportTooltip": {
        "buttonText": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Review the guide on viewports"]);
        },
        "buttonHref": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["https://on.cypress.io/viewport"]);
        },
        "infoText": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["The viewport determines the width and height of your application under test. By default the viewport will be ", _interpolate(_list(0)), " by ", _interpolate(_list(1)), " for ", _interpolate(_list(2)), " testing."]);
        },
        "configText": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["Additionally, you can override this value in your ", _interpolate(_named("configFile")), " or via the ", _interpolate(_named("viewportCommand")), " command."]);
        }
      },
      "studio": {
        "studio": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Studio"]);
        },
        "studioDescription": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Generate Cypress commands by interacting with your site as an end user would. Then, save these commands directly to your test file."]);
        },
        "studioDetailedDescription": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Generate and save commands directly to your test suite by interacting with your app as an end user would. Right click on an element to add an assertion. Studio will track events that generate the following commands:"]);
        },
        "getStartedButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Get started"]);
        },
        "feedbackPrompt": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Your ", _interpolate(_list(0)), " will be highly influential to our team."]);
        },
        "experimentalMessage": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["This feature is currently experimental and we will be adding more commands and abilities in the future."]);
        },
        "feedbackLink": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["feedback"]);
        },
        "saveTest": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Save test"]);
        },
        "testName": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Test name"]);
        },
        "saveTestButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Save"]);
        },
        "closeStudio": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Close Studio"]);
        },
        "restartStudio": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Restart Studio"]);
        },
        "copyCommands": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Copy commands to clipboard"]);
        },
        "commandsCopied": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Commands copied!"]);
        },
        "availableCommands": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Available commands"]);
        },
        "giveFeedback": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Give feedback"]);
        },
        "enterValidUrl": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Enter a valid URL to visit"]);
        },
        "continue": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Continue"]);
        },
        "actionCancel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cancel"]);
        }
      }
    },
    "warnings": {
      "retry": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Try again"]);
      }
    },
    "versions": {
      "alpha": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Alpha"]);
      },
      "beta": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Beta"]);
      },
      "new": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["New"]);
      }
    }
  }
};
const rawJsonMessages = `{
  "links": {
    "learnMore": "Learn more.",
    "learnMoreButton": "Learn more",
    "needHelp": "Need help"
  },
  "components": {
    "modal": {
      "dismiss": "Dismiss"
    },
    "fileSearch": {
      "noMatchesForExtension": "No files found when searching for the file extension",
      "noMatchesForFileName": "",
      "byFilenameInput": "Search by filename...",
      "byExtensionInput": "Extensions to include e.g. *.tsx, *.vue",
      "matchesIndicatorEmptyFileSearch": "No matches | 1 match | { denominator } matches",
      "matchesIndicator": "No matches | {numerator} of {denominator} matches | {numerator} of {denominator} matches"
    },
    "button": {
      "cancel": "Cancel",
      "back": "Back"
    },
    "loading": {
      "config": {
        "title": "Initializing config...",
        "description": "Please wait while we load your project and find browsers installed on your system"
      }
    },
    "select": {
      "placeholder": "Choose an option..."
    },
    "alert": {
      "dismissAriaLabel": "Dismiss"
    },
    "specPattern": {
      "matches": "No matches | {n} match | {n} matches"
    },
    "specPatternModal": {
      "title": "Spec pattern settings"
    }
  },
  "clipboard": {
    "copy": "Copy",
    "copied": "Copied!"
  },
  "actions": {
    "close": "Close"
  },
  "file": {
    "edit": "Edit",
    "git": {
      "modified": "Modified",
      "created": "Created"
    }
  },
  "status": {
    "enabled": "Enabled",
    "disabled": "Disabled"
  },
  "createSpec": {
    "newSpec": "New spec",
    "createSpec": "Create spec",
    "done": "Done!",
    "noComponentsFound": "No components found",
    "unableToParseFile": "Unable to parse file",
    "updateSpecPattern": "Update spec pattern",
    "newSpecModalTitle": "Create new spec",
    "successPage": {
      "header": "Great! The spec was successfully added",
      "runSpecButton": "Okay, run the spec",
      "createAnotherSpecButton": "Create another spec"
    },
    "page": {
      "defaultPatternNoSpecs": {
        "title": "Create your first spec",
        "component": {
          "description": "Since this project looks new, we recommend that you get started by creating a spec for one of your components."
        },
        "e2e": {
          "description": "Since this project looks new, we recommend that you use the specs and tests that we've written for you to get started."
        }
      },
      "customPatternNoSpecs": {
        "title": "No specs found",
        "description": "We couldn't find any files matching the following spec patterns. You may need to move your specs or update your {0} to find them."
      }
    },
    "noSpecsMessage": "If you feel that you're seeing this screen in error, and there should be specs listed here, you likely need to update the spec pattern.",
    "viewSpecPatternButton": "View spec pattern",
    "e2e": {
      "importFromScaffold": {
        "header": "Scaffold example specs",
        "description": "We'll generate several example specs to help guide you on how to write tests in Cypress.",
        "specsAddedHeader": "Great! We added the following files to your project:",
        "specsAddedButton": "Okay, I got it!",
        "specsAddingHeader": "Adding specs..."
      },
      "importTemplateSpec": {
        "header": "Create new spec",
        "description": "We'll generate a template spec file which can be used to start testing your application.",
        "chooseFilenameHeader": "Enter the path for your new spec",
        "inputPlaceholder": "Enter a relative path...",
        "invalidSpecWarning": "This path is invalid because it doesn't match the following ",
        "specExtensionWarning": "We recommend naming your spec to match the following pattern: "
      }
    },
    "component": {
      "importFromComponent": {
        "header": "Create from component",
        "description": "Generate a basic component test for any of the components in this project.",
        "chooseAComponentHeader": "Choose a component"
      },
      "importTemplateSpec": {
        "header": "Create new spec",
        "description": "We'll generate a template spec file which can be used to start testing your components.",
        "invalidComponentWarning": "We couldn't generate a valid path matching your custom "
      }
    }
  },
  "specPage": {
    "pageTitle": "Specs",
    "newSpecButton": "New spec",
    "searchPlaceholder": "Search specs",
    "clearSearch": "Clear search field",
    "componentSpecsHeader": "Component specs",
    "e2eSpecsHeader": "E2E specs",
    "lastUpdated": {
      "header": "Last updated",
      "tooltip": {
        "gitStatus": "Git status",
        "gitInfo": "git info",
        "gitInfoAvailable": "{0} of the spec files within this project",
        "gitInfoUnavailable": "Cypress is unable to detect {0} for this project and has defaulted to showing file system data instead"
      }
    },
    "latestRuns": {
      "header": "Latest runs",
      "headerShort": "Runs",
      "tooltip": {
        "connected": "The {0} in Cypress Cloud",
        "notConnected": "Connect to Cypress Cloud to see the {0}",
        "noAccess": "Request access to this project in Cypress Cloud to view the {0}",
        "linkText": "status of your latest runs"
      }
    },
    "averageDuration": {
      "header": "Average duration",
      "headerShort": "Duration",
      "tooltip": {
        "connected": "The {0} of your latest runs in Cypress Cloud",
        "notConnected": "Connect to Cypress Cloud to see the {0} of your latest runs",
        "noAccess": "Request access to this project in Cypress Cloud to view the {0} of your latest runs",
        "linkText": "average spec durations"
      }
    },
    "flaky": {
      "badgeLabel": "Flaky",
      "severityLow": "Low",
      "severityMedium": "Medium",
      "severityHigh": "High",
      "flakyRate": "{0}% flaky rate",
      "flakyRuns": "{flakyRuns} flaky runs / {totalRuns} total | {flakyRuns} flaky run / {totalRuns} total | {flakyRuns} flaky runs / {totalRuns} total",
      "lastFlaky": "Last run flaky | Last flaky {runsSinceLastFlake} run ago | Last flaky {runsSinceLastFlake} runs ago"
    },
    "hoverButton": {
      "connect": "Connect",
      "connectProject": "Connect project",
      "connectProjectShort": "Connect",
      "requestAccess": "Request access",
      "requestAccessShort": "Request",
      "requestSent": "Request sent",
      "requestSentShort": "Sent"
    },
    "connectProjectButton": "Connect your project",
    "cloudLoginButton": "Log in to Cypress Cloud",
    "reconnectProjectButton": "Reconnect your project",
    "unauthorizedBannerTitle": "Request access to project",
    "requestAccessButton": "Request access",
    "requestSentButton": "Request sent",
    "rows": {
      "gitTooltipSubtext": "{shortHash} by {author}"
    },
    "noResultsMessage": "No specs matched your search:",
    "noSpecError": {
      "title": "Spec not found",
      "intro": "There is no spec matching the following location:",
      "explainer": "It is possible that the file has been moved or deleted. Please choose from the list of specs below."
    },
    "offlineWarning": {
      "title": "No internet connection",
      "explainer": "Please check your internet connection to resolve this issue. When your internet connection is fixed, we will automatically attempt to fetch the run metrics from Cypress Cloud."
    },
    "fetchFailedWarning": {
      "title": "Lost connection",
      "explainer1": "The request timed out or failed when trying to retrieve the recorded run metrics from Cypress Cloud. The information that you're seeing in the table below may be incomplete as a result.",
      "explainer2": "Please refresh the page to try again and visit our {0} if this behavior continues.",
      "refreshButton": "Try again"
    },
    "banners": {
      "login": {
        "title": "Optimize and record your CI test runs with Cypress Cloud",
        "contentA": "Parallelize your tests in CI and visualize every error by watching full video recordings of each test you run.",
        "contentB": "When you configure Cypress to record tests to Cypress Cloud, you'll see data from your latest recorded runs in the Cypress app. This increased visibility into your test history allows you to debug your tests faster and more effectively, all within your local workflow.",
        "buttonLabel": "Get started with Cypress Cloud"
      },
      "createOrganization": {
        "titleA": "Finish setting up Cypress Cloud",
        "titleB": "Create or join an organization",
        "content": "Join or create an organization in Cypress Cloud to access your projects and recorded test runs.",
        "buttonLabel": "Set up your organization"
      },
      "connectProject": {
        "title": "Connect your project to Cypress Cloud",
        "contentA": "View recorded test runs directly in the Cypress app to monitor, run, and fix tests locally.",
        "contentB": "Bring your recorded test results into your local development workflow to monitor, run, and fix tests all in the Cypress app.",
        "buttonLabel": "Connect your project"
      },
      "record": {
        "title": "Record your first run",
        "content": "Record a run to see your test results in Cypress Cloud. You can then optimize your test suite, debug failing and flaky tests, and integrate with your favorite tools."
      }
    },
    "runSelectedSpecs": "Run {n} spec | Run {n} specs"
  },
  "noResults": {
    "defaultMessage": "No results matched your search:",
    "clearSearch": "Clear search"
  },
  "sidebar": {
    "keyboardShortcuts": {
      "title": "Keyboard shortcuts",
      "rerun": "Re-run tests",
      "stop": "Stop tests",
      "toggle": "Toggle specs list"
    },
    "toggleLabel": {
      "expanded": "Collapse sidebar",
      "collapsed": "Expand sidebar"
    },
    "nav": {
      "ariaLabel": "Pages"
    }
  },
  "topNav": {
    "released": "Released",
    "version": "Version",
    "versionUnsupported": "Unsupported",
    "installed": "Installed",
    "latest": "Latest",
    "seeAllReleases": "See all releases",
    "runningOldVersion": "You're currently running an old version of Cypress. Update to the latest version for the best experience.",
    "docsMenu": {
      "docsHeading": "Docs",
      "gettingStartedTitle": "Getting started",
      "firstTest": "Write your first test",
      "testingApp": "Testing your app",
      "organizingTests": "Organizing tests",
      "referencesTitle": "References",
      "bestPractices": "Best practices",
      "configuration": "Configuration",
      "api": "API",
      "ciTitle": "Run in CI/CD",
      "ciSetup": "Set up CI",
      "fasterTests": "Run tests faster",
      "prompts": {
        "ci1": {
          "title": "Configure CI",
          "description": "Optimize your tests in CI by following these guides.",
          "seeOtherGuides": "See other guides",
          "intro": "Introduction to CI",
          "learnTheBasics": "Learn the basics of running Cypress in CI."
        },
        "orchestration1": {
          "title": "Run tests faster in CI",
          "parallelTime": "5 mins",
          "noParallelTime": "12 mins",
          "withParallelization": "with Parallelization",
          "withoutParallelization": "without Parallelization",
          "intro": "With Smart Orchestration, you'll be able to:",
          "bullet1": "Run spec files in parallel",
          "bullet2": "Prioritize failed specs to run first",
          "bullet3": "Cancel CI runs on test failure",
          "learnMore": "Learn more"
        }
      }
    },
    "login": {
      "bodyInitial": "Logging in gives you access to {0}. You can set up projects to be recorded and see test data from your project.",
      "bodySuccess": "You are now logged in as {0}.",
      "bodyError": "An error occurred while attempting to log in:",
      "bodyBrowserError": "The browser could not be opened.",
      "bodyBrowserErrorDetails": "Cypress was unable to open your installed browser. To continue logging in, please paste this URL into your web browser:",
      "cloud": "Cypress Cloud",
      "titleInitial": "Log in to Cypress",
      "titleSuccess": "Login successful",
      "titleFailed": "Login failed",
      "titleBrowserError": "Browser error",
      "actionLogin": "Log in",
      "profileMenuLabel": "Profile and logout",
      "actionLogout": "Log out",
      "actionContinue": "Continue",
      "actionOpening": "Opening browser",
      "actionWaiting": "Waiting for you to log in",
      "actionTryAgain": "Try again",
      "actionCancel": "Cancel"
    },
    "updateCypress": {
      "title": "Upgrade to Cypress",
      "currentlyRunning": "You are currently running Version {0} of Cypress. ",
      "pasteToUpgradeProject": "To upgrade to the latest version for your project, first {0}, then paste the command below into your terminal:",
      "pasteToUpgradeGlobal": "To upgrade to the latest version, first {0}, then paste the command below into your terminal:",
      "rememberToCloseInsert": "close this app"
    },
    "upgradeText": "Upgrade",
    "global": {
      "projects": "Projects"
    }
  },
  "launchpadErrors": {
    "generic": {
      "configErrorTitle": "Cypress configuration error",
      "retryButton": "Try again",
      "stackTraceLabel": "Stack trace",
      "docsButton": {
        "configGuide": {
          "text": "Configuration guide",
          "link": "https://docs.cypress.io/guides/references/configuration"
        },
        "cloudGuide": {
          "text": "Cypress Cloud guide",
          "link": "https://on.cypress.io/features-dashboard"
        },
        "docsHomepage": {
          "text": "Cypress docs",
          "link": "https://docs.cypress.io"
        }
      }
    },
    "noInternet": {
      "header": "You have no internet connection",
      "message": "Check your internet connection to pull the latest data from Cypress Cloud.",
      "connectProject": "Please check your internet connection to resolve this issue. When your internet connection is fixed, we will automatically attempt to fetch your latest runs for this project."
    }
  },
  "setupPage": {
    "projectSetup": {
      "frameworkLabel": "Front-end framework",
      "frameworkPlaceholder": "Pick a framework",
      "bundlerLabel": "Bundler",
      "bundlerLabelDescription": "(dev server)",
      "bundlerPlaceholder": "Pick a bundler",
      "languageLabel": "Language",
      "configFileLanguageLabel": "Cypress config file",
      "detected": "(detected)"
    },
    "step": {
      "continue": "Continue",
      "next": "Next step",
      "back": "Back",
      "skip": "Skip"
    },
    "configFile": {
      "createManually": "Create file manually",
      "skippedLabel": "Skipped",
      "changesRequiredLabel": "Changes required",
      "changesRequiredBadge": "Changes required",
      "changesRequiredDescription": "Please merge the code below with your existing {0}"
    },
    "testingCard": {
      "configured": "Configured",
      "notConfigured": "Not Configured",
      "running": "Running",
      "chooseABrowser": "Choose a browser",
      "reconfigure": "Reconfigure",
      "disabled": "Disabled"
    }
  },
  "globalPage": {
    "empty": {
      "title": "Add project",
      "helper": "Get started by adding your first project below.",
      "dropText": "Drag your project directory here or {0}",
      "browseManually": "browse manually."
    },
    "settings": "Settings",
    "saveChanges": "Save changes",
    "cancel": "Cancel",
    "externalEditorPreferences": "External editor preferences",
    "externalEditorPreferencesDescription1": "Select your preference for opening files on your system.",
    "externalEditorPreferencesDescription2": "You can change this later in the {0} page.",
    "recentProjectsHeader": "Recent projects",
    "searchPlaceholder": "Search projects",
    "addProjectButton": "Add project",
    "projectActions": "Project actions",
    "removeProject": "Remove project",
    "openInIDE": "Open in IDE",
    "openInFinder": "Open in Finder",
    "noResultsMessage": "No projects matched your search:"
  },
  "welcomePage": {
    "review": "Review the differences between each testing type",
    "codeExample": "Code example",
    "compareTypes": {
      "content": {
        "e2eTitle": "End-to-end tests",
        "e2eBullet1": "Visit URLs via",
        "e2eBullet2": "Test flows and functionality across multiple pages",
        "e2eBullet3": "Ideal for testing integrated flows in CD workflows",
        "componentTitle": "Component tests",
        "ctBullet1": "Import components via",
        "ctBullet2": "Test individual components of a design system in isolation",
        "ctBullet3": "Ideal for testing isolated flows and components in CI"
      },
      "modalTitle": "Key differences"
    },
    "title": "Welcome to Cypress!"
  },
  "settingsPage": {
    "config": {
      "title": "Resolved configuration",
      "description": "Since the options in the {0} can be set dynamically by your development environment, please refer to the legend below to understand how the configuration options are resolved.",
      "legend": {
        "env": {
          "label": "env",
          "description": "Set from environment variables"
        },
        "default": {
          "label": "default",
          "description": "Default values"
        },
        "dynamic": {
          "label": "dynamic",
          "description": "Set by the {0} function"
        },
        "cli": {
          "label": "cli",
          "description": "Set from CLI arguments"
        },
        "config": {
          "label": "config",
          "description": "Set from {0}"
        }
      }
    },
    "proxy": {
      "title": "Proxy settings",
      "description": "Cypress auto-detected the following proxy settings from your operating system.",
      "bypassList": "Proxy bypass list",
      "proxyServer": "Proxy server"
    },
    "editor": {
      "title": "External editor",
      "description": "External editor to use for editing code opened when using Cypress.",
      "noEditorSelectedPlaceholder": "Choose your editor...",
      "customPathPlaceholder": "/path/to/editor"
    },
    "projectId": {
      "title": "Project ID",
      "description": "The Project ID configured for this project inside of Cypress Cloud. {0}"
    },
    "specPattern": {
      "title": "Spec patterns",
      "description": "The globs pointing Cypress to your spec files configured for this project. {0}"
    },
    "recordKey": {
      "title": "Record key",
      "description": "The Record Key configured for this project inside of Cypress Cloud. {0}",
      "manageKeys": "Manage keys",
      "errorEmpty": "You do not have permission to record on this project",
      "errorEmptyButton": "Request record rights",
      "errorAccess": "You do not have permission to view this project",
      "errorAccessPending": "Your request for access to this project is pending approval",
      "errorAccessButton": "Request access",
      "errorNotFound": "Project not found",
      "errorNotFoundButton": "Connect it again",
      "errorNotLoggedIn": "You are not connected to Cypress Cloud",
      "errorNotLoggedInButton": "Log in to Cypress Cloud"
    },
    "project": {
      "title": "Project settings",
      "description": "Review the configuration settings currently in use for this project."
    },
    "cloud": {
      "title": "Cypress Cloud settings",
      "description": "Review the configuration settings for recording to Cypress Cloud."
    },
    "experiments": {
      "title": "Experiments",
      "description": "If you'd like to try out new features that we're working on, you can enable beta features for your project by turning on the experimental features you'd like to try. {0}",
      "experimentalFetchPolyfill": {
        "name": "Fetch polyfill",
        "description": "Automatically replaces \`window.fetch\` with a polyfill that Cypress can spy on and stub. Note: \`experimentalFetchPolyfill\` has been deprecated in Cypress 6.0.0 and will be removed in a future release. Consider using [\`cy.intercept()\`](https://on.cypress.io/intercept) to intercept \`fetch\` requests instead."
      },
      "experimentalInteractiveRunEvents": {
        "name": "Interactive run events",
        "description": "Allows listening to the [\`before:run\`](https://on.cypress.io/before-run), [\`after:run\`](https://on.cypress.io/after-run), [\`before:spec\`](https://on.cypress.io/before-spec), and [\`after:spec\`](https://on.cypress.io/after-spec) events in plugins during interactive mode."
      },
      "experimentalModifyObstructiveThirdPartyCode": {
        "name": "Modify obstructive third party code",
        "description": "Applies \`modifyObstructiveCode\` to third party \`.html\` and \`.js\`, removes subresource integrity, and modifies the user agent in Electron."
      },
      "experimentalSingleTabRunMode": {
        "name": "Single tab run mode",
        "description": "Runs all component specs in a single tab, trading spec isolation for faster run mode execution."
      },
      "experimentalSourceRewriting": {
        "name": "Source rewriting",
        "description": "Enables AST-based JS/HTML rewriting. This may fix issues caused by the existing regex-based JS/HTML replacement algorithm. See [#5273](https://github.com/cypress-io/cypress/issues/5273) for details."
      },
      "experimentalStudio": {
        "name": "Studio",
        "description": "Generate and save commands directly to your test suite by interacting with your app as an end user would."
      },
      "experimentalWebKitSupport": {
        "name": "WebKit Support",
        "description": "Adds support for testing in the WebKit browser engine used by Safari. See https://on.cypress.io/webkit-experiment for more information."
      },
      "experimentalRunAllSpecs": {
        "name": "Run All Specs",
        "description": "Enables the \\"Run All Specs\\" UI feature, allowing the execution of multiple specs sequentially."
      },
      "experimentalOriginDependencies": {
        "name": "Origin Dependencies",
        "description": "Enables support for \`require\`/\`import\` within \`cy.origin\`."
      }
    },
    "device": {
      "title": "Device settings",
      "description": "Review the configuration settings currently in use for this device."
    },
    "testingPreferences": {
      "title": "Testing preferences",
      "description": "Configure your testing environment with these flags",
      "autoScrollingEnabled": {
        "title": "Auto scrolling enabled",
        "description": "Scroll behavior when running tests."
      }
    },
    "footer": {
      "text": "You can reconfigure the {testingType} testing settings for this project if you're experiencing issues with your Cypress configuration.",
      "button": "Configuration guide",
      "buttonLink": "https://docs.cypress.io/guides/references/configuration"
    }
  },
  "runs": {
    "connect": {
      "title": "View your recorded runs from Cypress Cloud",
      "smartText": "Scale your test runs with built-in Smart Orchestration.",
      "debugText": "Debug tests that fail in CI with visual feedback.",
      "chartText": "Keep your tests in tip-top shape with powerful analytics.",
      "buttonUser": "Log in to Cypress Cloud",
      "buttonProject": "Connect your project to Cypress Cloud",
      "modal": {
        "title": "Connect project",
        "cancel": "Cancel",
        "createOrg": {
          "description": "You need to create an organization in Cypress Cloud to continue.",
          "button": "Create organization",
          "waitingButton": "Waiting for you to create an organization...",
          "refreshButton": "Refresh organizations list"
        },
        "selectProject": {
          "organization": "Organization",
          "noOrganizationSelectedError": "required when creating a new project",
          "manageOrgs": "Manage organizations",
          "project": "Project",
          "projectName": "Project name",
          "projectNameDisclaimer": "(You can change this later)",
          "createNewProject": "Create new",
          "chooseExistingProject": "Choose an existing project",
          "newProjectAccess": "Project access",
          "privateLabel": "Private",
          "privateDescription": "Only invited users can view recorded test results.",
          "publicLabel": "Public",
          "publicDescription": "Anyone can view recorded test results.",
          "connectProject": "Connect project",
          "createProject": "Create project",
          "placeholderOrganizations": "Pick an organization",
          "placeholderProjects": "Pick a project",
          "placeholderProjectsPending": "Pick an organization first"
        },
        "connectManually": {
          "title": "Connect project manually",
          "warning": "We couldn't add the projectId to your cypress.config.js file automatically.",
          "mainMessage": "Manually add the {projectId} to the root of the config object in your {configFile} file.",
          "waitingButton": "Waiting for you to add the projectId..."
        }
      },
      "errors": {
        "baseError": {
          "title": "Cypress Cloud error"
        },
        "internalServerError": {
          "title": "Cannot connect to Cypress Cloud",
          "description": "The request times out when trying to retrieve the info from Cypress Cloud. Please refresh the page to try again and visit out {0} if this behavior continues.",
          "link": "Support Page"
        }
      }
    },
    "connectSuccessAlert": {
      "title": "This project is now connected to Cypress Cloud!",
      "item1": "We automatically added the {projectId} to your {configFile} file.",
      "item2": "Please ensure that your {0} file is checked into source control."
    },
    "empty": {
      "title": "Record your first run to Cypress Cloud",
      "description": "Run the command below in your local development terminal or in CI."
    },
    "results": {
      "skipped": "skipped",
      "pending": "pending",
      "passed": "passed",
      "failed": "failed"
    },
    "errors": {
      "notFound": {
        "title": "Couldn't find your project",
        "description": "We were unable to find an existing project matching the {0} set in your Cypress config file. You can reconnect with an existing project or create a new project.",
        "button": "Reconnect your project"
      },
      "unauthorized": {
        "title": "Request access to view the recorded runs",
        "description": "This is a private project that you do not currently have access to. Please request access from the project owner in order to view the list of runs.",
        "button": "Request access"
      },
      "unauthorizedRequested": {
        "title": "Your access request for this project has been sent.",
        "description": "The owner of this project has been notified of your request. We'll notify you via email when your access request has been granted.",
        "button": "Request Sent"
      },
      "connectionFailed": {
        "title": "Cannot connect to Cypress Cloud",
        "description": "The request times out when trying to retrieve the recorded runs from Cypress Cloud. Please refresh the page to try again and visit out {0} if this behavior continues.",
        "link": "Support page",
        "button": "Try again"
      }
    }
  },
  "testingType": {
    "modalTitle": "Choose a testing type",
    "e2e": {
      "name": "E2E Testing",
      "description": "Build and test the entire experience of your application from end-to-end to ensure each flow matches your expectations."
    },
    "component": {
      "name": "Component Testing",
      "description": "Build and test your components from your design system in isolation in order to ensure each state matches your expectations."
    },
    "componentDisabled": {
      "description": "To test your components you must {0} as an NPM dependency for this project.",
      "link": "install Cypress"
    }
  },
  "migration": {
    "before": "Before",
    "after": "After",
    "heresWhy": "here's why:",
    "renameAuto": {
      "title": "We recommend automatically renaming your specs in this step",
      "changeButton": "change",
      "changedSpecFolder": "We've changed the default spec folder from:",
      "changedSpecExt": "We've changed the default spec file extension from:",
      "changedSpecPatternExplain": "We've changed the default spec file extension to {0} in order to avoid conflicts with any existing testing frameworks.",
      "optedOutMessage": "You've opted not to rename your spec file extension. You may need to change your specPattern later so we can still find your spec files.",
      "folderRenameMessage": "You've opted not to rename your spec file extension, we'll only rename the folder",
      "modal": {
        "title": "Change the existing spec file extension",
        "warning": "We recommend using the default extension to avoid inconsistencies, framework conflicts, and confusion with your team.",
        "line1": "Cypress now supports the ability to create new spec files from within the UI for both E2E and component specs.",
        "line2": "All new spec files created within Cypress will use the default pattern of: ",
        "line3": "We want to rename your existing specs so that they have a consistent filename pattern for both E2E and component testing.",
        "line4": "All documentation and example code will be using: ",
        "line5": "We've changed the placement of component specs to be next to their source files (e.g. src/Button.jsx and src/Button.cy.jsx)",
        "line6": "The new default pattern of {0} prevents targeting conflicts with other testing frameworks. (e.g. Jest)",
        "label": "Choose from the following filename patterns:",
        "option1": "{0} (recommended)",
        "option2": "Don't rename anything — keep what I have.",
        "option3": "Rename folder only.",
        "optOutAdditional": "I may need to change my {0} later if I don't use the recommended filename extension.",
        "buttonSave": "Save changes",
        "buttonCancel": "Cancel"
      }
    },
    "renameManual": {
      "title": "We need you to move your component specs manually",
      "componentFolderRemoved": "We've removed the {0} options from the Cypress config.",
      "addedSpecPattern": "We've added a new {0} option in the Cypress config that tells us where to find your component specs.",
      "cannotAuto": "We can't automatically migrate your existing component spec files. We recommend that you move the following component spec files next to your source component files (e.g. {0})",
      "ifSkipNote": "If you skip this step, Cypress will still be able to find them, but any new specs that you create will automatically be created next to your component files."
    },
    "renameSupport": {
      "title": "We'll automatically rename your existing E2E support file in this step",
      "serveDifferentTypes": "We now serve different support files for E2E and Component Testing.",
      "changedSupportFile": "We've renamed the E2E support file from:"
    },
    "configFile": {
      "title": "We need to migrate to the new Cypress configuration file",
      "changedDefault": "We've changed the default Cypress config file from:",
      "customOptions": "We've set a custom {specPattern} option based on your {options}.",
      "willConvert": "We'll automatically create a new {jsFile} file and seed it with your options from your existing {jsonFile}."
    },
    "setupComponent": {
      "title": "You need to reconfigure Cypress for component testing",
      "line1": "We've detected that you are currently using the experimental version of component testing.",
      "line2": "Your existing configuration is no longer compatible with new component testing configuration options.",
      "line3": "In a previous step, we renamed your component specs, but can't automatically migrate your existing component testing configuration.",
      "line4": "In the next screen, you'll be able to reconfigure component testing in a new guided configuration wizard."
    },
    "wizard": {
      "title": "Migrating to Cypress {version}",
      "description": "Your project requires updates to work with this version.",
      "typicalMigrationLabel": "Typical migration:",
      "typicalMigrationTime": "5-10 minutes",
      "step1": {
        "title": "Migrate existing specs",
        "description": "In this step, we'll automatically rename and/or move your existing spec files as needed.",
        "button": "Rename these specs for me",
        "buttonSkip": "Skip renaming specs",
        "buttonRenameFolder": "Rename the folder for me"
      },
      "step2": {
        "title": "Move your existing component specs",
        "description": "In this step, you'll manually move your existing component specs to their new default location.",
        "buttonWait": "Waiting for you to move your component specs...",
        "buttonDone": "Continue to next step",
        "button": "I'll do this later"
      },
      "step3": {
        "title": "Rename the Cypress support file",
        "description": "In this step, we'll automatically rename your existing support file.",
        "button": "Rename the support file for me"
      },
      "step4": {
        "title": "Migrate to the new Cypress configuration file",
        "description": "In this step, we'll automatically migrate your existing Cypress configuration to the new Cypress configuration file.",
        "button": "Migrate the configuration for me"
      },
      "step5": {
        "title": "Reconfigure component testing",
        "description": "In this step, we'll explain how you will reconfigure Cypress for component testing.",
        "button": "Finish migration and continue"
      }
    }
  },
  "majorVersionWelcome": {
    "title": "What's New in Cypress",
    "actionContinue": "Continue",
    "linkReleaseNotes": "View full changelog"
  },
  "setupWizard": {
    "selectFramework": {
      "title": "Project setup",
      "description": "Confirm the front-end framework and bundler used in your project."
    },
    "installDependencies": {
      "title": "Install dev dependencies",
      "description": "Based on your previous selection, the following dependencies are required.",
      "pasteCommand": "Paste this command into your terminal to install the following packages:",
      "waitForInstall": "Waiting for you to install the dependencies...",
      "installed": "installed",
      "pendingInstall": "pending installation",
      "installationAlertSuccess": "You've successfully installed all required dependencies."
    },
    "configFiles": {
      "title": "Configuration files",
      "description": "We added the following files to your project:"
    },
    "chooseBrowser": {
      "title": "Choose a browser",
      "description": "Choose your preferred browser for {testingType} testing."
    }
  },
  "e2eProjectSetup": {
    "title": "Project setup",
    "description": "Confirm your project's preferred language."
  },
  "openBrowser": {
    "startComponent": "Start Component Testing in {browser}",
    "startE2E": "Start E2E Testing in {browser}",
    "openingComponent": "Opening Component Testing in {browser}",
    "openingE2E": "Opening E2E Testing in {browser}",
    "running": "Running {browser}",
    "focus": "Focus",
    "close": "Close",
    "switchTestingType": "Switch testing type"
  },
  "runner": {
    "header": {
      "reviewDocs": "Review the docs",
      "troubleRendering": "if you're having trouble rendering your components properly."
    },
    "snapshot": {
      "highlightsLabel": "Highlights",
      "testsRunningError": "Cannot show snapshot while tests are running",
      "snapshotMissingError": "The snapshot is missing. Displaying current state of the DOM.",
      "defaultTitle": "DOM snapshot",
      "pinnedTitle": "Pinned",
      "studioActiveError": "Cannot show snapshot while creating commands in Studio"
    },
    "selectorPlayground": {
      "matches": "No matches | {n} match | {n} matches",
      "playgroundTooltip": "Click an element to see a suggested selector",
      "copyTooltip": "Copy to clipboard",
      "copyTooltipAction": "Copied!",
      "printTooltip": "Print to console",
      "printTooltipAction": "Printed!",
      "invalidSelector": "Invalid",
      "selectorMethodsLabel": "Selector methods",
      "toggle": "Toggle playground"
    },
    "automation": {
      "disconnected": {
        "title": "The Cypress extension has disconnected.",
        "description": "Cypress cannot run tests without this extension.",
        "reload": "Reload the browser"
      },
      "missing": {
        "title": "The Cypress extension is missing.",
        "description": "Cypress cannot run tests without this extension. Please choose another browser."
      },
      "shared": {
        "link": "Read more about browser management"
      }
    },
    "viewportTooltip": {
      "buttonText": "Review the guide on viewports",
      "buttonHref": "https://on.cypress.io/viewport",
      "infoText": "The viewport determines the width and height of your application under test. By default the viewport will be {0} by {1} for {2} testing.",
      "configText": "Additionally, you can override this value in your {configFile} or via the {viewportCommand} command."
    },
    "studio": {
      "studio": "Studio",
      "studioDescription": "Generate Cypress commands by interacting with your site as an end user would. Then, save these commands directly to your test file.",
      "studioDetailedDescription": "Generate and save commands directly to your test suite by interacting with your app as an end user would. Right click on an element to add an assertion. Studio will track events that generate the following commands:",
      "getStartedButton": "Get started",
      "feedbackPrompt": "Your {0} will be highly influential to our team.",
      "experimentalMessage": "This feature is currently experimental and we will be adding more commands and abilities in the future.",
      "feedbackLink": "feedback",
      "saveTest": "Save test",
      "testName": "Test name",
      "saveTestButton": "Save",
      "closeStudio": "Close Studio",
      "restartStudio": "Restart Studio",
      "copyCommands": "Copy commands to clipboard",
      "commandsCopied": "Commands copied!",
      "availableCommands": "Available commands",
      "giveFeedback": "Give feedback",
      "enterValidUrl": "Enter a valid URL to visit",
      "continue": "Continue",
      "actionCancel": "Cancel"
    }
  },
  "warnings": {
    "retry": "Try again"
  },
  "versions": {
    "alpha": "Alpha",
    "beta": "Beta",
    "new": "New"
  }
}
`;
const defaultMessages = JSON.parse(rawJsonMessages);
createI18n();
function createI18n(opts = {}) {
  return createI18n$1({
    locale: "en-US",
    messages: compiledMessages,
    ...opts
  });
}
function useI18n() {
  return useI18n$1({ useScope: "global" });
}
const _hoisted_1$2f = ["href"];
const _sfc_main$1w = /* @__PURE__ */ defineComponent({
  props: {
    href: { default: "" },
    useDefaultHocus: { type: Boolean, default: true }
  },
  setup(__props) {
    const props = __props;
    const attrs = useAttrs();
    const classes = computed(() => {
      const hocus = props.useDefaultHocus ? "hocus-link-default" : "";
      return `${attrs.class ?? "text-indigo-500"} ${hocus}`;
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("a", {
        href: props.href,
        class: normalizeClass(unref(classes))
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 10, _hoisted_1$2f);
    };
  }
});
const Auth_LogoutDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "Auth_Logout" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "logout" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }] } }] } }] };
const Auth_LoginDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "Auth_Login" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "utmSource" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "utmMedium" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "utmContent" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "login" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "utmSource" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "utmSource" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "utmContent" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "utmContent" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "utmMedium" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "utmMedium" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }] } }] } }] };
const Auth_ResetAuthStateDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "Auth_ResetAuthState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "resetAuthState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }] } }] } }] };
const ChooseExternalEditorModal_SetPreferredEditorBinaryDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "ChooseExternalEditorModal_SetPreferredEditorBinary" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setPreferences" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "value" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "type" }, "value": { "kind": "EnumValue", "value": "global" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferredEditorBinary" } }] } }] } }] } }] } }] };
const CloudViewerAndProject_RequiredDataDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "CloudViewerAndProject_RequiredData" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cachedUser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "config" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isFullConfigReady" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasNonExampleSpec" } }, { "kind": "Field", "name": { "kind": "Name", "value": "savedState" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "runs" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "10" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "url" } }] } }] } }] } }] } }] } }] } }] };
const CloudViewerAndProject_CheckCloudOrgMembershipDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "CloudViewerAndProject_CheckCloudOrgMembership" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewerChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cachedUser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "config" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isFullConfigReady" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasNonExampleSpec" } }, { "kind": "Field", "name": { "kind": "Name", "value": "savedState" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "runs" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "10" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "url" } }] } }] } }] } }] } }] } }] } }] } }] };
const HeaderBar_HeaderBarQueryDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "HeaderBar_HeaderBarQuery" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "config" } }, { "kind": "Field", "name": { "kind": "Name", "value": "savedState" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "branch" } }, { "kind": "Field", "name": { "kind": "Name", "value": "packageManager" } }, { "kind": "Field", "name": { "kind": "Name", "value": "activeBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "displayName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "majorVersion" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "browsers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isSelected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "displayName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "majorVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isVersionSupported" } }, { "kind": "Field", "name": { "kind": "Name", "value": "warning" } }, { "kind": "Field", "name": { "kind": "Name", "value": "disabled" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "isGlobalMode" } }, { "kind": "Field", "name": { "kind": "Name", "value": "versions" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "current" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "released" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "latest" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "released" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cachedUser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }] } }] } }] };
const HeaderBarContent_AuthChangeDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "HeaderBarContent_authChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "authChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cachedUser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }] } }] } }] } }] };
const GlobalPageHeader_ClearCurrentProjectDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "GlobalPageHeader_clearCurrentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "clearCurrentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "baseError" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorStack" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUserCodeError" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeFrame" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "line" } }, { "kind": "Field", "name": { "kind": "Name", "value": "column" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeBlock" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }] };
const LoginConnectModals_LoginConnectModalsQueryDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "LoginConnectModals_LoginConnectModalsQuery" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "createCloudOrganizationUrl" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }] } }] };
const OpenFileInIdeDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "OpenFileInIDE" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferredEditorBinary" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "availableEditors" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "binary" } }] } }] } }] } }] };
const OpenFileInIde_MutationDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "OpenFileInIDE_Mutation" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "input" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "FileDetailsInput" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "openFileInIDE" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "input" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "input" } } }] }] } }] };
const RecordPromptAdapterDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "RecordPromptAdapter" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "recordKeys" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "key" } }] } }] } }] } }] } }] } }] };
const UsePromptManager_SetProjectPreferencesDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "UsePromptManager_SetProjectPreferences" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setPreferences" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "type" }, "value": { "kind": "EnumValue", "value": "project" } }, { "kind": "Argument", "name": { "kind": "Name", "value": "value" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "savedState" } }] } }] } }] } }] };
const UsePromptManager_SetGlobalPreferencesDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "UsePromptManager_SetGlobalPreferences" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setPreferences" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "type" }, "value": { "kind": "EnumValue", "value": "global" } }, { "kind": "Argument", "name": { "kind": "Name", "value": "value" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "majorVersionWelcomeDismissed" } }] } }] } }] } }] } }] };
const CloudConnectModals_MonitorCloudViewerDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "CloudConnectModals_MonitorCloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewerChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "createCloudOrganizationUrl" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }] } }] } }] } }] };
const CreateCloudOrgModal_CloudOrganizationsCheckDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "CreateCloudOrgModal_CloudOrganizationsCheck" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "refreshCloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "createCloudOrganizationUrl" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }] } }] } }] } }] };
const SelectCloudProjectModal_SetProjectIdDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "SelectCloudProjectModal_SetProjectId" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "projectId" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setProjectIdInConfigFile" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "projectId" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "projectId" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "runs" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "10" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "createdAt" } }, { "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalDuration" } }, { "kind": "Field", "name": { "kind": "Name", "value": "url" } }, { "kind": "Field", "name": { "kind": "Name", "value": "tags" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalPassed" } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalFailed" } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalPending" } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalSkipped" } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalFlakyTests" } }, { "kind": "Field", "name": { "kind": "Name", "value": "commitInfo" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "authorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "authorEmail" } }, { "kind": "Field", "name": { "kind": "Name", "value": "summary" } }, { "kind": "Field", "name": { "kind": "Name", "value": "branch" } }] } }] } }] } }] } }] } }] } }] } }] } }] };
const SelectCloudProjectModal_CreateCloudProjectDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "SelectCloudProjectModal_CreateCloudProject" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "name" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "orgId" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "ID" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "public" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "Boolean" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "campaign" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "cohort" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "medium" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "source" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudProjectCreate" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "name" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "name" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "orgId" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "orgId" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "public" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "public" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "campaign" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "campaign" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "cohort" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "cohort" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "medium" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "medium" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "source" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "source" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }] } }] } }] };
const TopNav_SetPromptShownDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "TopNav_SetPromptShown" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "slug" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setPromptShown" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "slug" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "slug" } } }] }] } }] };
const VerticalBrowserListItems_SetBrowserDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "VerticalBrowserListItems_SetBrowser" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "id" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "ID" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "specPath" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "launchpadSetBrowser" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "id" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "id" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "browsers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isSelected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "displayName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "majorVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isVersionSupported" } }, { "kind": "Field", "name": { "kind": "Name", "value": "warning" } }, { "kind": "Field", "name": { "kind": "Name", "value": "disabled" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "launchOpenProject" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "specPath" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "specPath" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] };
const Clipboard_CopyToClipboardDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "Clipboard_CopyToClipboard" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "text" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "copyTextToClipboard" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "text" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "text" } } }] }] } }] };
const ExternalLink_OpenExternalDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "ExternalLink_OpenExternal" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "url" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "includeGraphqlPort" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "Boolean" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "openExternal" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "url" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "url" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "includeGraphqlPort" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "includeGraphqlPort" } } }] }] } }] };
const GlobalSubscriptions_PushFragmentDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "GlobalSubscriptions_PushFragment" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "pushFragment" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "target" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fragment" } }, { "kind": "Field", "name": { "kind": "Name", "value": "data" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errors" } }, { "kind": "Field", "name": { "kind": "Name", "value": "variables" } }, { "kind": "Field", "name": { "kind": "Name", "value": "invalidateCache" } }] } }] } }] };
const GlobalSubscriptions_ErrorWarningChangeDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "GlobalSubscriptions_ErrorWarningChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "errorWarningChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "baseError" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorStack" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUserCodeError" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeFrame" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "line" } }, { "kind": "Field", "name": { "kind": "Name", "value": "column" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeBlock" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }] } }] } }] } }] };
gql`
mutation ExternalLink_OpenExternal ($url: String!, $includeGraphqlPort: Boolean) {
  openExternal(url: $url, includeGraphqlPort: $includeGraphqlPort)
}
`;
const useExternalLink = ($href, includeGraphqlPort = false) => {
  const openExternalMutation = useMutation(ExternalLink_OpenExternalDocument);
  return (href) => {
    const resolvedHref = unref(typeof href === "string" ? href : $href);
    if (!resolvedHref) {
      return new Error(`Cannot open external link. Possible urls passed in were ${{ localHref: href, initialHref: unref($href) }}`);
    }
    return openExternalMutation.executeMutation({ url: resolvedHref, includeGraphqlPort });
  };
};
const __default__$4 = defineComponent({
  inheritAttrs: true
});
const _sfc_main$1v = /* @__PURE__ */ defineComponent({
  ...__default__$4,
  props: {
    href: { default: "" },
    useDefaultHocus: { type: Boolean, default: true },
    includeGraphqlPort: { type: Boolean, default: false }
  },
  setup(__props) {
    const props = __props;
    const open = useExternalLink(props.href, props.includeGraphqlPort);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$1w, {
        "data-cy": "external",
        href: props.href,
        "use-default-hocus": props.useDefaultHocus,
        onClick: withModifiers(unref(open), ["prevent"]),
        onKeypress: withKeys(withModifiers(unref(open), ["prevent"]), ["enter"])
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 8, ["href", "use-default-hocus", "onClick", "onKeypress"]);
    };
  }
});
const _hoisted_1$2e = {
  key: 0,
  class: "flex m-24px justify-center"
};
const _sfc_main$1u = /* @__PURE__ */ defineComponent({
  props: {
    gql: null
  },
  emits: ["pick"],
  setup(__props, { emit: emits }) {
    const props = __props;
    const { t: t2 } = useI18n();
    gql`
fragment TestingTypePicker on Query {
  currentProject {
    id
    isCTConfigured
    isE2EConfigured
    currentTestingType
  }
  invokedFromCli
}
`;
    const e2eStatus = computed(() => {
      var _a2;
      if (!((_a2 = props.gql.currentProject) == null ? void 0 : _a2.isE2EConfigured))
        return "notConfigured";
      return props.gql.currentProject.currentTestingType === "e2e" ? "running" : "configured";
    });
    const componentStatus = computed(() => {
      var _a2;
      if (!props.gql.invokedFromCli)
        return "disabled";
      if (!((_a2 = props.gql.currentProject) == null ? void 0 : _a2.isCTConfigured))
        return "notConfigured";
      return props.gql.currentProject.currentTestingType === "component" ? "running" : "configured";
    });
    const testingTypes = computed(() => {
      return [
        {
          key: "e2e",
          name: t2("testingType.e2e.name"),
          description: t2("testingType.e2e.description"),
          icon: IconE2E,
          iconSolid: IconE2ESolid,
          status: e2eStatus.value,
          badgeText: ""
        },
        {
          key: "component",
          name: t2("testingType.component.name"),
          description: t2("testingType.component.description"),
          icon: IconComponent,
          iconSolid: IconComponentSolid,
          status: componentStatus.value,
          badgeText: ""
        }
      ];
    });
    const currentTestingType = computed(() => {
      var _a2;
      return (_a2 = props.gql.currentProject) == null ? void 0 : _a2.currentTestingType;
    });
    return (_ctx, _cache) => {
      const _component_i18n_t = resolveComponent("i18n-t");
      return props.gql.currentProject ? (openBlock(), createElementBlock("div", _hoisted_1$2e, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(unref(testingTypes), (tt) => {
          return openBlock(), createBlock(Card, {
            key: tt.key,
            "data-cy-testingType": tt.key,
            title: tt.name,
            description: tt.description,
            class: "m-24px px-24px pt-36px pb-36px w-336px",
            icon: tt.icon,
            "hover-icon": tt.iconSolid,
            "icon-size": 64,
            disabled: tt.status === "disabled",
            variant: "jade",
            "badge-text": tt.badgeText,
            onClick: ($event) => emits("pick", tt.key, unref(currentTestingType)),
            onKeyup: [
              withKeys(($event) => emits("pick", tt.key, unref(currentTestingType)), ["enter"]),
              withKeys(($event) => emits("pick", tt.key, unref(currentTestingType)), ["space"])
            ]
          }, createSlots({
            footer: withCtx(() => [
              createVNode(_sfc_main$1x, {
                class: "mt-16px",
                title: unref(t2)(`setupPage.testingCard.${tt.status}`),
                status: tt.status === "configured" || tt.status === "running",
                onChooseABrowser: ($event) => emits("pick", tt.key, unref(currentTestingType))
              }, null, 8, ["title", "status", "onChooseABrowser"])
            ]),
            _: 2
          }, [
            tt.key === "component" && tt.status === "disabled" ? {
              name: "default",
              fn: withCtx(() => [
                createVNode(_component_i18n_t, {
                  scope: "global",
                  keypath: "testingType.componentDisabled.description"
                }, {
                  default: withCtx(() => [
                    createVNode(_sfc_main$1v, { href: "https://on.cypress.io/installing-cypress" }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString$1(unref(t2)("testingType.componentDisabled.link")), 1)
                      ]),
                      _: 1
                    })
                  ]),
                  _: 1
                })
              ])
            } : void 0
          ]), 1032, ["data-cy-testingType", "title", "description", "icon", "hover-icon", "disabled", "badge-text", "onClick", "onKeyup"]);
        }), 128))
      ])) : createCommentVNode("", true);
    };
  }
});
const _sfc_main$1t = /* @__PURE__ */ defineComponent({
  props: {
    gql: null
  },
  setup(__props) {
    const props = __props;
    gql`
fragment TestingTypeCards on Query {
  ...TestingTypePicker
}
`;
    gql`
mutation TestingTypeSelection($testingType: TestingTypeEnum!) {
  setAndLoadCurrentTestingType(testingType: $testingType) {
    currentProject {
      id
      currentTestingType
      isCTConfigured
      isE2EConfigured
      isLoadingConfigFile
      isLoadingNodeEvents
    }
    ...Wizard
  }
}
`;
    const mutation = useMutation(TestingTypeSelectionDocument);
    function selectTestingType(testingType) {
      if (!mutation.fetching.value) {
        mutation.executeMutation({ testingType });
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$1u, {
        gql: props.gql,
        onPick: selectTestingType
      }, null, 8, ["gql"]);
    };
  }
});
const _hoisted_1$2d = {
  height: "1em",
  width: "1em",
  style: { "min-width": "16px", "min-height": "16px" },
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1Y = /* @__PURE__ */ createBaseVNode("circle", {
  id: "Circle",
  cx: "8",
  cy: "8",
  r: "6",
  stroke: "#E1E3ED",
  class: "icon-light",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round"
}, null, -1);
const _hoisted_3$1G = /* @__PURE__ */ createBaseVNode("path", {
  id: "Progress",
  d: "M14 8C14 4.68629 11.3137 2 8 2",
  stroke: "#6470F3",
  class: "icon-dark",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round"
}, null, -1);
const _hoisted_4$11 = [
  _hoisted_2$1Y,
  _hoisted_3$1G
];
function render$16(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$2d, _hoisted_4$11);
}
const __unplugin_components_0$l = { name: "cy-loading_x16", render: render$16 };
const hasSymbol = typeof Symbol === "function" && typeof Symbol.toStringTag === "symbol";
const PolySymbol = (name2) => hasSymbol ? Symbol(name2) : "_vr_" + name2;
const routerKey = /* @__PURE__ */ PolySymbol("r");
const routeLocationKey = /* @__PURE__ */ PolySymbol("rl");
const noop$2 = () => {
};
function isSameRouteRecord(a2, b2) {
  return (a2.aliasOf || a2) === (b2.aliasOf || b2);
}
function isSameRouteLocationParams(a2, b2) {
  if (Object.keys(a2).length !== Object.keys(b2).length)
    return false;
  for (const key in a2) {
    if (!isSameRouteLocationParamsValue(a2[key], b2[key]))
      return false;
  }
  return true;
}
function isSameRouteLocationParamsValue(a2, b2) {
  return Array.isArray(a2) ? isEquivalentArray(a2, b2) : Array.isArray(b2) ? isEquivalentArray(b2, a2) : a2 === b2;
}
function isEquivalentArray(a2, b2) {
  return Array.isArray(b2) ? a2.length === b2.length && a2.every((value, i2) => value === b2[i2]) : a2.length === 1 && a2[0] === b2;
}
var NavigationType;
(function(NavigationType2) {
  NavigationType2["pop"] = "pop";
  NavigationType2["push"] = "push";
})(NavigationType || (NavigationType = {}));
var NavigationDirection;
(function(NavigationDirection2) {
  NavigationDirection2["back"] = "back";
  NavigationDirection2["forward"] = "forward";
  NavigationDirection2["unknown"] = "";
})(NavigationDirection || (NavigationDirection = {}));
var NavigationFailureType;
(function(NavigationFailureType2) {
  NavigationFailureType2[NavigationFailureType2["aborted"] = 4] = "aborted";
  NavigationFailureType2[NavigationFailureType2["cancelled"] = 8] = "cancelled";
  NavigationFailureType2[NavigationFailureType2["duplicated"] = 16] = "duplicated";
})(NavigationFailureType || (NavigationFailureType = {}));
function useLink(props) {
  const router = inject(routerKey);
  const currentRoute = inject(routeLocationKey);
  const route = computed(() => router.resolve(unref(props.to)));
  const activeRecordIndex = computed(() => {
    const { matched } = route.value;
    const { length: length2 } = matched;
    const routeMatched = matched[length2 - 1];
    const currentMatched = currentRoute.matched;
    if (!routeMatched || !currentMatched.length)
      return -1;
    const index2 = currentMatched.findIndex(isSameRouteRecord.bind(null, routeMatched));
    if (index2 > -1)
      return index2;
    const parentRecordPath = getOriginalPath(matched[length2 - 2]);
    return length2 > 1 && getOriginalPath(routeMatched) === parentRecordPath && currentMatched[currentMatched.length - 1].path !== parentRecordPath ? currentMatched.findIndex(isSameRouteRecord.bind(null, matched[length2 - 2])) : index2;
  });
  const isActive = computed(() => activeRecordIndex.value > -1 && includesParams(currentRoute.params, route.value.params));
  const isExactActive = computed(() => activeRecordIndex.value > -1 && activeRecordIndex.value === currentRoute.matched.length - 1 && isSameRouteLocationParams(currentRoute.params, route.value.params));
  function navigate(e = {}) {
    if (guardEvent(e)) {
      return router[unref(props.replace) ? "replace" : "push"](
        unref(props.to)
      ).catch(noop$2);
    }
    return Promise.resolve();
  }
  return {
    route,
    href: computed(() => route.value.href),
    isActive,
    isExactActive,
    navigate
  };
}
const RouterLinkImpl = /* @__PURE__ */ defineComponent({
  name: "RouterLink",
  props: {
    to: {
      type: [String, Object],
      required: true
    },
    replace: Boolean,
    activeClass: String,
    exactActiveClass: String,
    custom: Boolean,
    ariaCurrentValue: {
      type: String,
      default: "page"
    }
  },
  useLink,
  setup(props, { slots }) {
    const link4 = reactive(useLink(props));
    const { options: options2 } = inject(routerKey);
    const elClass = computed(() => ({
      [getLinkClass(props.activeClass, options2.linkActiveClass, "router-link-active")]: link4.isActive,
      [getLinkClass(props.exactActiveClass, options2.linkExactActiveClass, "router-link-exact-active")]: link4.isExactActive
    }));
    return () => {
      const children = slots.default && slots.default(link4);
      return props.custom ? children : h$1("a", {
        "aria-current": link4.isExactActive ? props.ariaCurrentValue : null,
        href: link4.href,
        onClick: link4.navigate,
        class: elClass.value
      }, children);
    };
  }
});
const RouterLink = RouterLinkImpl;
function guardEvent(e) {
  if (e.metaKey || e.altKey || e.ctrlKey || e.shiftKey)
    return;
  if (e.defaultPrevented)
    return;
  if (e.button !== void 0 && e.button !== 0)
    return;
  if (e.currentTarget && e.currentTarget.getAttribute) {
    const target2 = e.currentTarget.getAttribute("target");
    if (/\b_blank\b/i.test(target2))
      return;
  }
  if (e.preventDefault)
    e.preventDefault();
  return true;
}
function includesParams(outer, inner) {
  for (const key in inner) {
    const innerValue = inner[key];
    const outerValue = outer[key];
    if (typeof innerValue === "string") {
      if (innerValue !== outerValue)
        return false;
    } else {
      if (!Array.isArray(outerValue) || outerValue.length !== innerValue.length || innerValue.some((value, i2) => value !== outerValue[i2]))
        return false;
    }
  }
  return true;
}
function getOriginalPath(record) {
  return record ? record.aliasOf ? record.aliasOf.path : record.path : "";
}
const getLinkClass = (propClass, globalClass, defaultClass) => propClass != null ? propClass : globalClass != null ? globalClass : defaultClass;
const _hoisted_1$2c = {
  key: 0,
  class: "flex justify-self-start items-center"
};
const _hoisted_2$1X = { class: "flex-grow" };
const _hoisted_3$1F = {
  key: 1,
  class: "flex justify-self-start items-center"
};
const __default__$3 = defineComponent({
  inheritAttrs: true
});
const _sfc_main$1s = /* @__PURE__ */ defineComponent({
  ...__default__$3,
  props: {
    prefixIcon: null,
    suffixIcon: null,
    prefixIconClass: null,
    suffixIconClass: null
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        __props.prefixIcon || _ctx.$slots.prefix ? (openBlock(), createElementBlock("span", _hoisted_1$2c, [
          renderSlot(_ctx.$slots, "prefix", {}, () => [
            (openBlock(), createBlock(resolveDynamicComponent(__props.prefixIcon), {
              class: normalizeClass(__props.prefixIconClass)
            }, null, 8, ["class"]))
          ])
        ])) : createCommentVNode("", true),
        createBaseVNode("span", _hoisted_2$1X, [
          renderSlot(_ctx.$slots, "default")
        ]),
        __props.suffixIcon || _ctx.$slots.suffix ? (openBlock(), createElementBlock("span", _hoisted_3$1F, [
          renderSlot(_ctx.$slots, "suffix", {}, () => [
            (openBlock(), createBlock(resolveDynamicComponent(__props.suffixIcon), {
              class: normalizeClass(__props.suffixIconClass)
            }, null, 8, ["class"]))
          ])
        ])) : createCommentVNode("", true)
      ], 64);
    };
  }
});
const _hoisted_1$2b = ["disabled"];
const VariantClassesTable = {
  primary: "border-indigo-500 bg-indigo-500 text-white hocus-default",
  outline: "border-gray-100 text-indigo-600 hocus-default",
  tertiary: "text-indigo-500 bg-indigo-50 border-transparent hocus-default",
  pending: "bg-gray-500 text-white",
  link: "border-transparent text-indigo-600 hocus-default",
  linkBold: "border-transparent text-indigo-500 font-medium",
  text: "border-0",
  secondary: "bg-jade-500 text-white hocus-secondary"
};
const SizeClassesTable = {
  sm: "px-6px py-2px text-14px h-24px",
  md: "px-12px py-8px text-14px h-32px",
  lg: "px-16px py-11px max-h-40px",
  "lg-wide": "px-32px py-8px"
};
const _sfc_main$1r = /* @__PURE__ */ defineComponent({
  props: {
    prefixIcon: null,
    suffixIcon: null,
    size: null,
    variant: null,
    prefixIconClass: null,
    suffixIconClass: null,
    href: null,
    to: null,
    internalLink: { type: Boolean },
    disabled: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    const attrs = useAttrs();
    const variantClasses = computed(() => VariantClassesTable[props.variant || "primary"]);
    const sizeClasses = computed(() => SizeClassesTable[props.size || "md"]);
    const classes = computed(() => {
      return [
        variantClasses.value,
        sizeClasses.value,
        attrs.class,
        props.disabled && props.variant !== "pending" ? "opacity-50" : "",
        props.disabled ? "cursor-default" : ""
      ];
    });
    const linkVersion = computed(() => {
      if (!props.to) {
        return props.internalLink ? _sfc_main$1w : _sfc_main$1v;
      }
      return RouterLink;
    });
    const linkProps = computed(() => {
      if (props.disabled) {
        return {
          role: "link",
          ariaDisabled: "disabled",
          href: null
        };
      }
      if (props.to)
        return { to: props.to };
      if (props.href)
        return { href: props.href };
      return {};
    });
    return (_ctx, _cache) => {
      return !props.href && !props.to ? (openBlock(), createElementBlock("button", {
        key: 0,
        style: { "width": "fit-content" },
        class: normalizeClass(["border rounded flex outline-none leading-tight gap-8px items-center", unref(classes)]),
        disabled: __props.disabled
      }, [
        createVNode(_sfc_main$1s, null, createSlots({
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default")
          ]),
          _: 2
        }, [
          __props.prefixIcon || _ctx.$slots.prefix ? {
            name: "prefix",
            fn: withCtx(() => [
              renderSlot(_ctx.$slots, "prefix", {}, () => [
                (openBlock(), createBlock(resolveDynamicComponent(__props.prefixIcon), {
                  class: normalizeClass(__props.prefixIconClass)
                }, null, 8, ["class"]))
              ])
            ])
          } : void 0,
          __props.suffixIcon || _ctx.$slots.suffix ? {
            name: "suffix",
            fn: withCtx(() => [
              renderSlot(_ctx.$slots, "suffix", {}, () => [
                (openBlock(), createBlock(resolveDynamicComponent(__props.suffixIcon), {
                  class: normalizeClass(__props.suffixIconClass)
                }, null, 8, ["class"]))
              ])
            ])
          } : void 0
        ]), 1024)
      ], 10, _hoisted_1$2b)) : (openBlock(), createBlock(resolveDynamicComponent(unref(linkVersion)), mergeProps({ key: 1 }, unref(linkProps), {
        style: { "width": "fit-content" },
        class: ["border rounded flex outline-none gap-8px items-center select-none", unref(classes)],
        "use-default-hocus": false
      }), {
        default: withCtx(() => [
          createVNode(_sfc_main$1s, null, createSlots({
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            suffix: withCtx(() => [
              __props.suffixIcon || _ctx.$slots.suffix ? renderSlot(_ctx.$slots, "suffix", { key: 0 }, () => [
                (openBlock(), createBlock(resolveDynamicComponent(__props.suffixIcon), {
                  class: normalizeClass(__props.suffixIconClass)
                }, null, 8, ["class"]))
              ]) : createCommentVNode("", true)
            ]),
            _: 2
          }, [
            __props.prefixIcon || _ctx.$slots.prefix ? {
              name: "prefix",
              fn: withCtx(() => [
                renderSlot(_ctx.$slots, "prefix", {}, () => [
                  (openBlock(), createBlock(resolveDynamicComponent(__props.prefixIcon), {
                    class: normalizeClass(__props.prefixIconClass)
                  }, null, 8, ["class"]))
                ])
              ])
            } : void 0
          ]), 1024)
        ]),
        _: 3
      }, 16, ["class"]));
    };
  }
});
const _hoisted_1$2a = ["id", "aria-checked"];
const _sfc_main$1q = /* @__PURE__ */ defineComponent({
  props: {
    value: { type: Boolean, default: false },
    size: { default: "lg" },
    name: null
  },
  emits: ["update"],
  setup(__props) {
    const sizeClasses = {
      "sm": {
        container: "w-16px h-10px",
        indicator: "w-6px h-6px ml-2px",
        translate: "translate-x-6px"
      },
      "md": {
        container: "w-24px h-12px",
        indicator: "w-8px h-8px ml-2px",
        translate: "translate-x-12px"
      },
      "lg": {
        container: "w-32px h-16px",
        indicator: "w-12px h-12px ml-2px",
        translate: "translate-x-14px"
      },
      "xl": {
        container: "w-48px h-24px",
        indicator: "w-16px h-16px ml-4px",
        translate: "translate-x-24px"
      }
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("button", {
        id: __props.name,
        class: normalizeClass(["border-transparent border-1 rounded-50px relative hocus-default", [__props.value ? "bg-jade-400" : "bg-gray-300", sizeClasses[__props.size].container, {
          "!hocus:ring-0": __props.size === "sm"
        }]]),
        role: "switch",
        "aria-checked": __props.value,
        onClick: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("update", !__props.value))
      }, [
        createBaseVNode("span", {
          class: normalizeClass(["bg-white rounded-50px transform transition-transform ease-out duration-200 block toggle", [{ [sizeClasses[__props.size].translate]: __props.value }, sizeClasses[__props.size].indicator]])
        }, null, 2)
      ], 10, _hoisted_1$2a);
    };
  }
});
const _hoisted_1$29 = { class: "border-t rounded-b flex bg-gray-50 border-t-1 border-t-gray-100 py-16px px-24px gap-3" };
const _hoisted_2$1W = /* @__PURE__ */ createBaseVNode("div", { class: "flex-grow" }, null, -1);
const _hoisted_3$1E = {
  key: 2,
  class: "flex px-3 items-center"
};
const _sfc_main$1p = /* @__PURE__ */ defineComponent({
  props: {
    next: { default: void 0 },
    back: { default: void 0 },
    skip: { default: void 0 },
    nextFn: { type: Function, default: void 0 },
    backFn: { type: Function, default: void 0 },
    skipFn: { type: Function, default: void 0 },
    alt: { default: void 0 },
    altFn: { type: Function, default: void 0 },
    canNavigateForward: { type: Boolean },
    mainVariant: { default: "primary" }
  },
  setup(__props) {
    const props = __props;
    const altValue = ref(false);
    const handleAlt = () => {
      var _a2;
      altValue.value = !altValue.value;
      (_a2 = props.altFn) == null ? void 0 : _a2.call(props, altValue.value);
    };
    return (_ctx, _cache) => {
      const _component_i_cy_loading_x16 = __unplugin_components_0$l;
      const _component_i_cy_arrow_right_x16 = __unplugin_components_0$n;
      return openBlock(), createElementBlock("div", _hoisted_1$29, [
        renderSlot(_ctx.$slots, "default", {}, () => [
          __props.nextFn ? (openBlock(), createBlock(_sfc_main$1r, {
            key: 0,
            size: "lg",
            disabled: !__props.canNavigateForward,
            variant: __props.mainVariant,
            onClick: __props.nextFn
          }, createSlots({
            default: withCtx(() => [
              createTextVNode(" " + toDisplayString$1(__props.next), 1)
            ]),
            _: 2
          }, [
            __props.mainVariant === "pending" ? {
              name: "prefix",
              fn: withCtx(() => [
                __props.mainVariant === "pending" ? (openBlock(), createBlock(_component_i_cy_loading_x16, {
                  key: 0,
                  class: "animate-spin icon-dark-white icon-light-gray-400"
                })) : createCommentVNode("", true)
              ])
            } : void 0
          ]), 1032, ["disabled", "variant", "onClick"])) : createCommentVNode("", true),
          __props.backFn ? (openBlock(), createBlock(_sfc_main$1r, {
            key: 1,
            size: "lg",
            variant: "outline",
            onClick: __props.backFn
          }, {
            default: withCtx(() => [
              createTextVNode(toDisplayString$1(__props.back), 1)
            ]),
            _: 1
          }, 8, ["onClick"])) : createCommentVNode("", true),
          _hoisted_2$1W,
          __props.altFn && __props.alt ? (openBlock(), createElementBlock("div", _hoisted_3$1E, [
            createBaseVNode("label", {
              for: "altFn",
              class: "px-3 text-gray-500",
              onClick: handleAlt
            }, toDisplayString$1(__props.alt), 1),
            createVNode(_sfc_main$1q, {
              size: "lg",
              name: "altFn",
              value: altValue.value,
              onUpdate: handleAlt
            }, null, 8, ["value"])
          ])) : createCommentVNode("", true),
          __props.skipFn ? (openBlock(), createBlock(_sfc_main$1r, {
            key: 3,
            size: "lg",
            variant: "text",
            class: "text-gray-500",
            onClick: __props.skipFn
          }, {
            default: withCtx(() => [
              createTextVNode(toDisplayString$1(__props.skip) + " ", 1),
              createVNode(_component_i_cy_arrow_right_x16, { class: "inline-block h-16px w-16px icon-dark-gray-500" })
            ]),
            _: 1
          }, 8, ["onClick"])) : createCommentVNode("", true)
        ])
      ]);
    };
  }
});
const _hoisted_1$28 = { class: "mx-auto my-32px" };
const _hoisted_2$1V = {
  key: 0,
  class: "w-full mb-24px"
};
const _hoisted_3$1D = { class: "w-full border-1 border-gray-100 rounded flex flex-col" };
const _hoisted_4$10 = { class: "flex-grow" };
const _sfc_main$1o = /* @__PURE__ */ defineComponent({
  props: {
    next: { default: void 0 },
    back: { default: void 0 },
    skip: { default: void 0 },
    alt: { default: void 0 },
    showNext: { type: Boolean, default: true },
    canNavigateForward: { type: Boolean, default: void 0 },
    altFn: { type: Function, default: void 0 },
    nextFn: { type: Function, default: void 0 },
    backFn: { type: Function, default: void 0 },
    skipFn: { type: Function, default: void 0 },
    mainButtonVariant: { default: "primary" }
  },
  setup(__props) {
    const props = __props;
    const { t: t2 } = useI18n();
    const nextLabel = computed(() => props.next || t2("setupPage.step.next"));
    const backLabel = computed(() => props.back || t2("setupPage.step.back"));
    const skipLabel = computed(() => props.skip || t2("setupPage.step.skip"));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$28, [
        _ctx.$slots.accessory ? (openBlock(), createElementBlock("div", _hoisted_2$1V, [
          renderSlot(_ctx.$slots, "accessory")
        ])) : createCommentVNode("", true),
        createBaseVNode("div", _hoisted_3$1D, [
          createBaseVNode("div", _hoisted_4$10, [
            renderSlot(_ctx.$slots, "default", { backFn: __props.backFn })
          ]),
          createVNode(_sfc_main$1p, {
            "next-fn": props.nextFn,
            "can-navigate-forward": __props.canNavigateForward,
            "back-fn": __props.backFn,
            "alt-fn": __props.altFn,
            next: unref(nextLabel),
            "show-next": __props.showNext,
            back: unref(backLabel),
            alt: __props.alt,
            "main-variant": __props.mainButtonVariant,
            skip: unref(skipLabel),
            "skip-fn": __props.skipFn
          }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "button-bar")
            ]),
            _: 3
          }, 8, ["next-fn", "can-navigate-forward", "back-fn", "alt-fn", "next", "show-next", "back", "alt", "main-variant", "skip", "skip-fn"])
        ])
      ]);
    };
  }
});
const _hoisted_1$27 = {
  "data-cy": "webpack-logo",
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 774 875.7"
};
const _hoisted_2$1U = /* @__PURE__ */ createBaseVNode("path", {
  fill: "#FFF",
  d: "m387 0 387 218.9v437.9L387 875.7 0 656.8V218.9z"
}, null, -1);
const _hoisted_3$1C = /* @__PURE__ */ createBaseVNode("path", {
  fill: "#8ed6fb",
  d: "M704.9 641.7 399.8 814.3V679.9l190.1-104.6 115 66.4zm20.9-18.9V261.9l-111.6 64.5v232l111.6 64.4zM67.9 641.7 373 814.3V679.9L182.8 575.3 67.9 641.7zM47 622.8V261.9l111.6 64.5v232L47 622.8zm13.1-384.3L373 61.5v129.9L172.5 301.7l-1.6.9-110.8-64.1zm652.6 0-312.9-177v129.9l200.5 110.2 1.6.9 110.8-64z"
}, null, -1);
const _hoisted_4$$ = /* @__PURE__ */ createBaseVNode("path", {
  fill: "#1c78c0",
  d: "M373 649.3 185.4 546.1V341.8L373 450.1v199.2zm26.8 0 187.6-103.1V341.8L399.8 450.1v199.2zm-13.4-207zM198.1 318.2l188.3-103.5 188.3 103.5-188.3 108.7-188.3-108.7z"
}, null, -1);
const _hoisted_5$D = [
  _hoisted_2$1U,
  _hoisted_3$1C,
  _hoisted_4$$
];
function render$15(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$27, _hoisted_5$D);
}
const LogoWebpack = { render: render$15 };
const _hoisted_1$26 = {
  "data-cy": "vite-logo",
  viewBox: "0 0 410 404",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1T = /* @__PURE__ */ createStaticVNode('<path d="m399.641 59.525-183.998 329.02c-3.799 6.793-13.559 6.833-17.415.073L10.582 59.556C6.38 52.19 12.68 43.266 21.028 44.76l184.195 32.923c1.175.21 2.378.208 3.553-.006l180.343-32.87c8.32-1.517 14.649 7.337 10.522 14.719Z" fill="url(#a)"></path><path d="M292.965 1.574 156.801 28.255a5 5 0 0 0-4.03 4.611l-8.376 141.464c-.197 3.332 2.863 5.918 6.115 5.168l37.91-8.749c3.547-.818 6.752 2.306 6.023 5.873l-11.263 55.153c-.758 3.712 2.727 6.886 6.352 5.785l23.415-7.114c3.63-1.102 7.118 2.081 6.35 5.796l-17.899 86.633c-1.12 5.419 6.088 8.374 9.094 3.728l2.008-3.103 110.954-221.428c1.858-3.707-1.346-7.935-5.418-7.15l-39.022 7.532c-3.667.707-6.787-2.708-5.752-6.296l25.469-88.291c1.036-3.594-2.095-7.012-5.766-6.293Z" fill="url(#b)"></path><defs><linearGradient id="a" x1="6" y1="33" x2="235" y2="344" gradientUnits="userSpaceOnUse"><stop stop-color="#41D1FF"></stop><stop offset="1" stop-color="#BD34FE"></stop></linearGradient><linearGradient id="b" x1="194.651" y1="8.818" x2="236.076" y2="292.989" gradientUnits="userSpaceOnUse"><stop stop-color="#FFEA83"></stop><stop offset=".083" stop-color="#FFDD35"></stop><stop offset="1" stop-color="#FFA800"></stop></linearGradient></defs>', 3);
const _hoisted_5$C = [
  _hoisted_2$1T
];
function render$14(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$26, _hoisted_5$C);
}
const LogoVite = { render: render$14 };
const _hoisted_1$25 = {
  "data-cy": "nextjs-logo",
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 512 512"
};
const _hoisted_2$1S = /* @__PURE__ */ createBaseVNode("path", {
  class: "icon-dark",
  d: "M386.399 35.508C217.06-64.061 1.885 57.55.012 253.882c-1.828 191.716 201.063 315.545 370.02 231.163L185.56 213.636v167.997c0 18.614-35.619 18.614-35.619 0V156.421c0-14.776 27.448-15.989 35.226-3.145L395.43 470.572c157.95-101.737 155.817-338.136-9.031-435.064zm-23.756 317.939L326.91 298.87V149.458c0-13.932 35.732-13.932 35.732 0v203.989z"
}, null, -1);
const _hoisted_3$1B = [
  _hoisted_2$1S
];
function render$13(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$25, _hoisted_3$1B);
}
const LogoNext = { render: render$13 };
const _hoisted_1$24 = {
  "data-cy": "nuxtjs-logo",
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 400 400"
};
const _hoisted_2$1R = /* @__PURE__ */ createBaseVNode("g", { fill: "none" }, [
  /* @__PURE__ */ createBaseVNode("path", {
    d: "m227.921 133.451-13.689 24.102-46.815-82.447L23.704 328.17h97.303c0 13.31 10.613 24.1 23.704 24.1H23.704c-8.468 0-16.292-4.595-20.525-12.052a24.452 24.452 0 0 1 .001-24.1L146.894 63.056c4.234-7.457 12.06-12.051 20.528-12.051 8.469 0 16.294 4.594 20.529 12.05l39.97 70.397z",
    fill: "#00C58E"
  }),
  /* @__PURE__ */ createBaseVNode("path", {
    d: "M331.664 316.12 241.61 157.553 227.92 133.45l-13.689 24.102-90.044 158.567a24.452 24.452 0 0 0-.001 24.1c4.233 7.456 12.056 12.052 20.524 12.052h166.4c8.47 0 16.297-4.591 20.532-12.048a24.452 24.452 0 0 0 .001-24.104h.02zm-186.953 12.05 83.21-146.516 83.19 146.517h-166.4z",
    fill: "#2F495E"
  }),
  /* @__PURE__ */ createBaseVNode("path", {
    d: "M396.05 340.221c-4.234 7.456-12.057 12.05-20.524 12.05H311.11c13.091 0 23.704-10.79 23.704-24.1h40.662L260.099 124.986l-18.49 32.567-13.688-24.102 11.654-20.516c4.234-7.458 12.06-12.052 20.529-12.052s16.294 4.594 20.528 12.052L396.05 316.12a24.452 24.452 0 0 1 0 24.101z",
    fill: "#108775"
  })
], -1);
const _hoisted_3$1A = [
  _hoisted_2$1R
];
function render$12(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$24, _hoisted_3$1A);
}
const LogoNuxt = { render: render$12 };
const _hoisted_1$23 = {
  "data-cy": "vue-logo",
  viewBox: "0 0 261.76 226.69",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1Q = /* @__PURE__ */ createBaseVNode("path", {
  d: "m161.096.001-30.224 52.35L100.647.002H-.005L130.872 226.69 261.749 0z",
  fill: "#41b883"
}, null, -1);
const _hoisted_3$1z = /* @__PURE__ */ createBaseVNode("path", {
  d: "m161.096.001-30.224 52.35L100.647.002H52.346l78.526 136.01L209.398.001z",
  fill: "#34495e"
}, null, -1);
const _hoisted_4$_ = [
  _hoisted_2$1Q,
  _hoisted_3$1z
];
function render$11(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$23, _hoisted_4$_);
}
const LogoVue = { render: render$11 };
const _hoisted_1$22 = {
  "data-cy": "react-logo",
  viewBox: "0 0 500 500",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1P = /* @__PURE__ */ createBaseVNode("g", { fill: "#3077c6" }, [
  /* @__PURE__ */ createBaseVNode("path", { d: "M495.3 248.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V30c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V30.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1C45.2 185.4 4.7 216.1 4.7 248.5c0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3Zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9Zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9Zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1ZM250.2 382c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32Zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4ZM249.7 115c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32Zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9ZM85.2 299.1c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2ZM139 442c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7Zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1Zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6Z" }),
  /* @__PURE__ */ createBaseVNode("path", { d: "M295.6 248.5c0 25.239-20.461 45.7-45.7 45.7-25.239 0-45.7-20.461-45.7-45.7 0-25.239 20.461-45.7 45.7-45.7 25.239 0 45.7 20.461 45.7 45.7Z" })
], -1);
const _hoisted_3$1y = [
  _hoisted_2$1P
];
function render$10(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$22, _hoisted_3$1y);
}
const LogoReact = { render: render$10 };
const _hoisted_1$21 = {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 250 250",
  style: { "enable-background": "new 0 0 250 250" },
  "xml:space": "preserve"
};
const _hoisted_2$1O = /* @__PURE__ */ createBaseVNode("path", {
  style: { "fill": "#dd0031" },
  d: "M125 30 31.9 63.2l14.2 123.1L125 230l78.9-43.7 14.2-123.1z"
}, null, -1);
const _hoisted_3$1x = /* @__PURE__ */ createBaseVNode("path", {
  style: { "fill": "#c3002f" },
  d: "M125 30v22.2-.1V230l78.9-43.7 14.2-123.1L125 30z"
}, null, -1);
const _hoisted_4$Z = /* @__PURE__ */ createBaseVNode("path", {
  d: "M125 52.1 66.8 182.6h21.7l11.7-29.2h49.4l11.7 29.2H183L125 52.1zm17 83.3h-34l17-40.9 17 40.9z",
  style: { "fill": "#fff" }
}, null, -1);
const _hoisted_5$B = [
  _hoisted_2$1O,
  _hoisted_3$1x,
  _hoisted_4$Z
];
function render$$(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$21, _hoisted_5$B);
}
const LogoAngular = { render: render$$ };
const _hoisted_1$20 = {
  xmlns: "http://www.w3.org/2000/svg",
  "aria-hidden": "true",
  width: ".84em",
  height: "1em",
  viewBox: "0 0 256 308"
};
const _hoisted_2$1N = /* @__PURE__ */ createBaseVNode("path", {
  fill: "#FF3E00",
  d: "M239.682 40.707C211.113-.182 154.69-12.301 113.895 13.69L42.247 59.356a82.198 82.198 0 0 0-37.135 55.056 86.566 86.566 0 0 0 8.536 55.576 82.425 82.425 0 0 0-12.296 30.719 87.596 87.596 0 0 0 14.964 66.244c28.574 40.893 84.997 53.007 125.787 27.016l71.648-45.664a82.182 82.182 0 0 0 37.135-55.057 86.601 86.601 0 0 0-8.53-55.577 82.409 82.409 0 0 0 12.29-30.718 87.573 87.573 0 0 0-14.963-66.244"
}, null, -1);
const _hoisted_3$1w = /* @__PURE__ */ createBaseVNode("path", {
  fill: "#FFF",
  d: "M106.889 270.841c-23.102 6.007-47.497-3.036-61.103-22.648a52.685 52.685 0 0 1-9.003-39.85 49.978 49.978 0 0 1 1.713-6.693l1.35-4.115 3.671 2.697a92.447 92.447 0 0 0 28.036 14.007l2.663.808-.245 2.659a16.067 16.067 0 0 0 2.89 10.656 17.143 17.143 0 0 0 18.397 6.828 15.786 15.786 0 0 0 4.403-1.935l71.67-45.672a14.922 14.922 0 0 0 6.734-9.977 15.923 15.923 0 0 0-2.713-12.011 17.156 17.156 0 0 0-18.404-6.832 15.78 15.78 0 0 0-4.396 1.933l-27.35 17.434a52.298 52.298 0 0 1-14.553 6.391c-23.101 6.007-47.497-3.036-61.101-22.649a52.681 52.681 0 0 1-9.004-39.849 49.428 49.428 0 0 1 22.34-33.114l71.664-45.677a52.218 52.218 0 0 1 14.563-6.398c23.101-6.007 47.497 3.036 61.101 22.648a52.685 52.685 0 0 1 9.004 39.85 50.559 50.559 0 0 1-1.713 6.692l-1.35 4.116-3.67-2.693a92.373 92.373 0 0 0-28.037-14.013l-2.664-.809.246-2.658a16.099 16.099 0 0 0-2.89-10.656 17.143 17.143 0 0 0-18.398-6.828 15.786 15.786 0 0 0-4.402 1.935l-71.67 45.674a14.898 14.898 0 0 0-6.73 9.975 15.9 15.9 0 0 0 2.709 12.012 17.156 17.156 0 0 0 18.404 6.832 15.841 15.841 0 0 0 4.402-1.935l27.345-17.427a52.147 52.147 0 0 1 14.552-6.397c23.101-6.006 47.497 3.037 61.102 22.65a52.681 52.681 0 0 1 9.003 39.848 49.453 49.453 0 0 1-22.34 33.12l-71.664 45.673a52.218 52.218 0 0 1-14.563 6.398"
}, null, -1);
const _hoisted_4$Y = [
  _hoisted_2$1N,
  _hoisted_3$1w
];
function render$_(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$20, _hoisted_4$Y);
}
const LogoSvelte = { render: render$_ };
const FrameworkBundlerLogos = {
  webpack: LogoWebpack,
  vite: LogoVite,
  vue2: LogoVue,
  vue3: LogoVue,
  vueclivue2: LogoVue,
  vueclivue3: LogoVue,
  nextjs: LogoNext,
  nuxtjs: LogoNuxt,
  react: LogoReact,
  reactscripts: LogoReact,
  angular: LogoAngular,
  svelte: LogoSvelte
};
const _hoisted_1$1$ = {
  height: "1em",
  width: "1em",
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1M = /* @__PURE__ */ createBaseVNode("path", {
  d: "M2 5L8 11L14 5",
  stroke: "#1B1E2E",
  class: "icon-dark",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round"
}, null, -1);
const _hoisted_3$1v = [
  _hoisted_2$1M
];
function render$Z(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1$, _hoisted_3$1v);
}
const __unplugin_components_0$k = { name: "cy-chevron-down", render: render$Z };
const _hoisted_1$1_ = {
  width: "1em",
  height: "1em",
  preserveAspectRatio: "xMidYMid meet",
  viewBox: "0 0 24 24"
};
const _hoisted_2$1L = /* @__PURE__ */ createBaseVNode("path", {
  d: "M21 7L9 19l-5.5-5.5l1.41-1.41L9 16.17L19.59 5.59L21 7z",
  fill: "currentColor"
}, null, -1);
const _hoisted_3$1u = [
  _hoisted_2$1L
];
function render$Y(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1_, _hoisted_3$1u);
}
const __unplugin_components_1$7 = { name: "mdi-check", render: render$Y };
function _extends$1() {
  _extends$1 = Object.assign || function(target2) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source = arguments[i2];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target2[key] = source[key];
        }
      }
    }
    return target2;
  };
  return _extends$1.apply(this, arguments);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null)
    return {};
  var target2 = {};
  var sourceKeys = Object.keys(source);
  var key, i2;
  for (i2 = 0; i2 < sourceKeys.length; i2++) {
    key = sourceKeys[i2];
    if (excluded.indexOf(key) >= 0)
      continue;
    target2[key] = source[key];
  }
  return target2;
}
function _unsupportedIterableToArray(o2, minLen) {
  if (!o2)
    return;
  if (typeof o2 === "string")
    return _arrayLikeToArray(o2, minLen);
  var n = Object.prototype.toString.call(o2).slice(8, -1);
  if (n === "Object" && o2.constructor)
    n = o2.constructor.name;
  if (n === "Map" || n === "Set")
    return Array.from(o2);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
    return _arrayLikeToArray(o2, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length)
    len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++)
    arr2[i2] = arr[i2];
  return arr2;
}
function _createForOfIteratorHelperLoose(o2, allowArrayLike) {
  var it2;
  if (typeof Symbol === "undefined" || o2[Symbol.iterator] == null) {
    if (Array.isArray(o2) || (it2 = _unsupportedIterableToArray(o2)) || allowArrayLike && o2 && typeof o2.length === "number") {
      if (it2)
        o2 = it2;
      var i2 = 0;
      return function() {
        if (i2 >= o2.length)
          return {
            done: true
          };
        return {
          done: false,
          value: o2[i2++]
        };
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  it2 = o2[Symbol.iterator]();
  return it2.next.bind(it2);
}
function match(value, lookup) {
  if (value in lookup) {
    var returnValue = lookup[value];
    for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }
    return typeof returnValue === "function" ? returnValue.apply(void 0, args) : returnValue;
  }
  var error2 = new Error('Tried to handle "' + value + '" but there is no handler defined. Only defined handlers are: ' + Object.keys(lookup).map(function(key) {
    return '"' + key + '"';
  }).join(", ") + ".");
  if (Error.captureStackTrace)
    Error.captureStackTrace(error2, match);
  throw error2;
}
var Features;
(function(Features2) {
  Features2[Features2["None"] = 0] = "None";
  Features2[Features2["RenderStrategy"] = 1] = "RenderStrategy";
  Features2[Features2["Static"] = 2] = "Static";
})(Features || (Features = {}));
var RenderStrategy;
(function(RenderStrategy2) {
  RenderStrategy2[RenderStrategy2["Unmount"] = 0] = "Unmount";
  RenderStrategy2[RenderStrategy2["Hidden"] = 1] = "Hidden";
})(RenderStrategy || (RenderStrategy = {}));
function render$X(_ref) {
  var _ref$visible = _ref.visible, visible = _ref$visible === void 0 ? true : _ref$visible, _ref$features = _ref.features, features = _ref$features === void 0 ? Features.None : _ref$features, main2 = _objectWithoutPropertiesLoose(_ref, ["visible", "features"]);
  if (visible)
    return _render(main2);
  if (features & Features.Static) {
    if (main2.props["static"])
      return _render(main2);
  }
  if (features & Features.RenderStrategy) {
    var _main$props$unmount, _match;
    var strategy = ((_main$props$unmount = main2.props.unmount) != null ? _main$props$unmount : true) ? RenderStrategy.Unmount : RenderStrategy.Hidden;
    return match(strategy, (_match = {}, _match[RenderStrategy.Unmount] = function() {
      return null;
    }, _match[RenderStrategy.Hidden] = function() {
      return _render(_extends$1({}, main2, {
        props: _extends$1({}, main2.props, {
          hidden: true,
          style: {
            display: "none"
          }
        })
      }));
    }, _match));
  }
  return _render(main2);
}
function _render(_ref2) {
  var props = _ref2.props, attrs = _ref2.attrs, slots = _ref2.slots, slot = _ref2.slot, name2 = _ref2.name;
  var _omit = omit(props, ["unmount", "static"]), as = _omit.as, passThroughProps = _objectWithoutPropertiesLoose(_omit, ["as"]);
  var children = slots["default"] == null ? void 0 : slots["default"](slot);
  if (as === "template") {
    if (Object.keys(passThroughProps).length > 0 || Object.keys(attrs).length > 0) {
      var _ref3 = children != null ? children : [], firstChild = _ref3[0], other = _ref3.slice(1);
      if (!isValidElement(firstChild) || other.length > 0) {
        throw new Error(['Passing props on "template"!', "", "The current component <" + name2 + ' /> is rendering a "template".', "However we need to passthrough the following props:", Object.keys(passThroughProps).concat(Object.keys(attrs)).map(function(line) {
          return "  - " + line;
        }).join("\n"), "", "You can apply a few solutions:", ['Add an `as="..."` prop, to ensure that we render an actual element instead of a "template".', "Render a single element as the child so that we can forward the props onto that element."].map(function(line) {
          return "  - " + line;
        }).join("\n")].join("\n"));
      }
      return cloneVNode(firstChild, passThroughProps);
    }
    if (Array.isArray(children) && children.length === 1) {
      return children[0];
    }
    return children;
  }
  return h$1(as, passThroughProps, children);
}
function omit(object, keysToOmit) {
  if (keysToOmit === void 0) {
    keysToOmit = [];
  }
  var clone2 = Object.assign({}, object);
  for (var _iterator = _createForOfIteratorHelperLoose(keysToOmit), _step; !(_step = _iterator()).done; ) {
    var key = _step.value;
    if (key in clone2)
      delete clone2[key];
  }
  return clone2;
}
function isValidElement(input) {
  if (input == null)
    return false;
  if (typeof input.type === "string")
    return true;
  if (typeof input.type === "object")
    return true;
  if (typeof input.type === "function")
    return true;
  return false;
}
var Keys;
(function(Keys2) {
  Keys2["Space"] = " ";
  Keys2["Enter"] = "Enter";
  Keys2["Escape"] = "Escape";
  Keys2["Backspace"] = "Backspace";
  Keys2["ArrowLeft"] = "ArrowLeft";
  Keys2["ArrowUp"] = "ArrowUp";
  Keys2["ArrowRight"] = "ArrowRight";
  Keys2["ArrowDown"] = "ArrowDown";
  Keys2["Home"] = "Home";
  Keys2["End"] = "End";
  Keys2["PageUp"] = "PageUp";
  Keys2["PageDown"] = "PageDown";
  Keys2["Tab"] = "Tab";
})(Keys || (Keys = {}));
var id = 0;
function generateId() {
  return ++id;
}
function useId() {
  return generateId();
}
var focusableSelector = /* @__PURE__ */ ["[contentEditable=true]", "[tabindex]", "a[href]", "area[href]", "button:not([disabled])", "iframe", "input:not([disabled])", "select:not([disabled])", "textarea:not([disabled])"].map(function(selector) {
  return selector + ":not([tabindex='-1'])";
}).join(",");
var Focus;
(function(Focus2) {
  Focus2[Focus2["First"] = 1] = "First";
  Focus2[Focus2["Previous"] = 2] = "Previous";
  Focus2[Focus2["Next"] = 4] = "Next";
  Focus2[Focus2["Last"] = 8] = "Last";
  Focus2[Focus2["WrapAround"] = 16] = "WrapAround";
  Focus2[Focus2["NoScroll"] = 32] = "NoScroll";
})(Focus || (Focus = {}));
var FocusResult;
(function(FocusResult2) {
  FocusResult2[FocusResult2["Error"] = 0] = "Error";
  FocusResult2[FocusResult2["Overflow"] = 1] = "Overflow";
  FocusResult2[FocusResult2["Success"] = 2] = "Success";
  FocusResult2[FocusResult2["Underflow"] = 3] = "Underflow";
})(FocusResult || (FocusResult = {}));
var Direction;
(function(Direction2) {
  Direction2[Direction2["Previous"] = -1] = "Previous";
  Direction2[Direction2["Next"] = 1] = "Next";
})(Direction || (Direction = {}));
function getFocusableElements(container) {
  if (container === void 0) {
    container = document.body;
  }
  if (container == null)
    return [];
  return Array.from(container.querySelectorAll(focusableSelector));
}
var FocusableMode;
(function(FocusableMode2) {
  FocusableMode2[FocusableMode2["Strict"] = 0] = "Strict";
  FocusableMode2[FocusableMode2["Loose"] = 1] = "Loose";
})(FocusableMode || (FocusableMode = {}));
function isFocusableElement(element, mode) {
  var _match;
  if (mode === void 0) {
    mode = FocusableMode.Strict;
  }
  if (element === document.body)
    return false;
  return match(mode, (_match = {}, _match[FocusableMode.Strict] = function() {
    return element.matches(focusableSelector);
  }, _match[FocusableMode.Loose] = function() {
    var next = element;
    while (next !== null) {
      if (next.matches(focusableSelector))
        return true;
      next = next.parentElement;
    }
    return false;
  }, _match));
}
function focusElement(element) {
  element == null ? void 0 : element.focus({
    preventScroll: true
  });
}
function focusIn(container, focus) {
  var elements = Array.isArray(container) ? container : getFocusableElements(container);
  var active = document.activeElement;
  var direction = function() {
    if (focus & (Focus.First | Focus.Next))
      return Direction.Next;
    if (focus & (Focus.Previous | Focus.Last))
      return Direction.Previous;
    throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
  }();
  var startIndex = function() {
    if (focus & Focus.First)
      return 0;
    if (focus & Focus.Previous)
      return Math.max(0, elements.indexOf(active)) - 1;
    if (focus & Focus.Next)
      return Math.max(0, elements.indexOf(active)) + 1;
    if (focus & Focus.Last)
      return elements.length - 1;
    throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
  }();
  var focusOptions = focus & Focus.NoScroll ? {
    preventScroll: true
  } : {};
  var offset2 = 0;
  var total = elements.length;
  var next = void 0;
  do {
    var _next;
    if (offset2 >= total || offset2 + total <= 0)
      return FocusResult.Error;
    var nextIdx = startIndex + offset2;
    if (focus & Focus.WrapAround) {
      nextIdx = (nextIdx + total) % total;
    } else {
      if (nextIdx < 0)
        return FocusResult.Underflow;
      if (nextIdx >= total)
        return FocusResult.Overflow;
    }
    next = elements[nextIdx];
    (_next = next) == null ? void 0 : _next.focus(focusOptions);
    offset2 += direction;
  } while (next !== document.activeElement);
  if (!next.hasAttribute("tabindex"))
    next.setAttribute("tabindex", "0");
  return FocusResult.Success;
}
function useWindowEvent(type2, listener, options2) {
  window.addEventListener(type2, listener, options2);
  onUnmounted(function() {
    return window.removeEventListener(type2, listener, options2);
  });
}
function contains$1(containers, element) {
  for (var _iterator = _createForOfIteratorHelperLoose(containers), _step; !(_step = _iterator()).done; ) {
    var container = _step.value;
    if (container.contains(element))
      return true;
  }
  return false;
}
function useFocusTrap(containers, enabled, options2) {
  if (enabled === void 0) {
    enabled = ref(true);
  }
  if (options2 === void 0) {
    options2 = ref({});
  }
  var restoreElement = ref(typeof window !== "undefined" ? document.activeElement : null);
  var previousActiveElement = ref(null);
  function handleFocus() {
    if (!enabled.value)
      return;
    if (containers.value.size !== 1)
      return;
    var initialFocus = options2.value.initialFocus;
    var activeElement = document.activeElement;
    if (initialFocus) {
      if (initialFocus === activeElement) {
        return;
      }
    } else if (contains$1(containers.value, activeElement)) {
      return;
    }
    restoreElement.value = activeElement;
    if (initialFocus) {
      focusElement(initialFocus);
    } else {
      var couldFocus = false;
      for (var _iterator = _createForOfIteratorHelperLoose(containers.value), _step; !(_step = _iterator()).done; ) {
        var container = _step.value;
        var result = focusIn(container, Focus.First);
        if (result === FocusResult.Success) {
          couldFocus = true;
          break;
        }
      }
      if (!couldFocus)
        throw new Error("There are no focusable elements inside the <FocusTrap />");
    }
    previousActiveElement.value = document.activeElement;
  }
  function restore2() {
    focusElement(restoreElement.value);
    restoreElement.value = null;
    previousActiveElement.value = null;
  }
  watchEffect(handleFocus);
  onUpdated(function() {
    enabled.value ? handleFocus() : restore2();
  });
  onUnmounted(restore2);
  useWindowEvent("keydown", function(event) {
    if (!enabled.value)
      return;
    if (event.key !== Keys.Tab)
      return;
    if (!document.activeElement)
      return;
    if (containers.value.size !== 1)
      return;
    event.preventDefault();
    for (var _iterator2 = _createForOfIteratorHelperLoose(containers.value), _step2; !(_step2 = _iterator2()).done; ) {
      var element = _step2.value;
      var result = focusIn(element, (event.shiftKey ? Focus.Previous : Focus.Next) | Focus.WrapAround);
      if (result === FocusResult.Success) {
        previousActiveElement.value = document.activeElement;
        break;
      }
    }
  });
  useWindowEvent("focus", function(event) {
    if (!enabled.value)
      return;
    if (containers.value.size !== 1)
      return;
    var previous = previousActiveElement.value;
    if (!previous)
      return;
    var toElement = event.target;
    if (toElement && toElement instanceof HTMLElement) {
      if (!contains$1(containers.value, toElement)) {
        event.preventDefault();
        event.stopPropagation();
        focusElement(previous);
      } else {
        previousActiveElement.value = toElement;
        focusElement(toElement);
      }
    } else {
      focusElement(previousActiveElement.value);
    }
  }, true);
}
var CHILDREN_SELECTOR = "body > *";
var interactables = /* @__PURE__ */ new Set();
var originals = /* @__PURE__ */ new Map();
function inert(element) {
  element.setAttribute("aria-hidden", "true");
  element.inert = true;
}
function restore(element) {
  var original = originals.get(element);
  if (!original)
    return;
  if (original["aria-hidden"] === null)
    element.removeAttribute("aria-hidden");
  else
    element.setAttribute("aria-hidden", original["aria-hidden"]);
  element.inert = original.inert;
}
function useInertOthers(container, enabled) {
  if (enabled === void 0) {
    enabled = ref(true);
  }
  watchEffect(function(onInvalidate) {
    if (!enabled.value)
      return;
    if (!container.value)
      return;
    var element = container.value;
    interactables.add(element);
    for (var _iterator = _createForOfIteratorHelperLoose(originals.keys()), _step; !(_step = _iterator()).done; ) {
      var original = _step.value;
      if (original.contains(element)) {
        restore(original);
        originals["delete"](original);
      }
    }
    document.querySelectorAll(CHILDREN_SELECTOR).forEach(function(child) {
      if (!(child instanceof HTMLElement))
        return;
      for (var _iterator2 = _createForOfIteratorHelperLoose(interactables), _step2; !(_step2 = _iterator2()).done; ) {
        var interactable = _step2.value;
        if (child.contains(interactable))
          return;
      }
      if (interactables.size === 1) {
        originals.set(child, {
          "aria-hidden": child.getAttribute("aria-hidden"),
          inert: child.inert
        });
        inert(child);
      }
    });
    onInvalidate(function() {
      interactables["delete"](element);
      if (interactables.size > 0) {
        document.querySelectorAll(CHILDREN_SELECTOR).forEach(function(child) {
          if (!(child instanceof HTMLElement))
            return;
          if (originals.has(child))
            return;
          for (var _iterator3 = _createForOfIteratorHelperLoose(interactables), _step3; !(_step3 = _iterator3()).done; ) {
            var interactable = _step3.value;
            if (child.contains(interactable))
              return;
          }
          originals.set(child, {
            "aria-hidden": child.getAttribute("aria-hidden"),
            inert: child.inert
          });
          inert(child);
        });
      } else {
        for (var _iterator4 = _createForOfIteratorHelperLoose(originals.keys()), _step4; !(_step4 = _iterator4()).done; ) {
          var _element = _step4.value;
          restore(_element);
          originals["delete"](_element);
        }
      }
    });
  });
}
var StackContext = /* @__PURE__ */ Symbol("StackContext");
var StackMessage;
(function(StackMessage2) {
  StackMessage2[StackMessage2["AddElement"] = 0] = "AddElement";
  StackMessage2[StackMessage2["RemoveElement"] = 1] = "RemoveElement";
})(StackMessage || (StackMessage = {}));
function useStackContext() {
  return inject(StackContext, function() {
  });
}
function useElemenStack(element) {
  var notify = useStackContext();
  watchEffect(function(onInvalidate) {
    var domElement = element == null ? void 0 : element.value;
    if (!domElement)
      return;
    notify(StackMessage.AddElement, domElement);
    onInvalidate(function() {
      return notify(StackMessage.RemoveElement, domElement);
    });
  });
}
function useStackProvider(onUpdate) {
  var parentUpdate = useStackContext();
  function notify() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    onUpdate == null ? void 0 : onUpdate.apply(void 0, args);
    parentUpdate.apply(void 0, args);
  }
  provide(StackContext, notify);
}
var ForcePortalRootContext = /* @__PURE__ */ Symbol("ForcePortalRootContext");
function usePortalRoot() {
  return inject(ForcePortalRootContext, false);
}
var ForcePortalRoot = /* @__PURE__ */ defineComponent({
  name: "ForcePortalRoot",
  props: {
    as: {
      type: [Object, String],
      "default": "template"
    },
    force: {
      type: Boolean,
      "default": false
    }
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots, attrs = _ref.attrs;
    provide(ForcePortalRootContext, props.force);
    return function() {
      var passThroughProps = _objectWithoutPropertiesLoose(props, ["force"]);
      return render$X({
        props: passThroughProps,
        slot: {},
        slots,
        attrs,
        name: "ForcePortalRoot"
      });
    };
  }
});
function getPortalRoot() {
  var existingRoot = document.getElementById("headlessui-portal-root");
  if (existingRoot)
    return existingRoot;
  var root = document.createElement("div");
  root.setAttribute("id", "headlessui-portal-root");
  return document.body.appendChild(root);
}
var Portal = /* @__PURE__ */ defineComponent({
  name: "Portal",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    }
  },
  setup: function setup2(props, _ref) {
    var slots = _ref.slots, attrs = _ref.attrs;
    var forcePortalRoot = usePortalRoot();
    var groupContext = inject(PortalGroupContext, null);
    var myTarget = ref(forcePortalRoot === true ? getPortalRoot() : groupContext === null ? getPortalRoot() : groupContext.resolveTarget());
    watchEffect(function() {
      if (forcePortalRoot)
        return;
      if (groupContext === null)
        return;
      myTarget.value = groupContext.resolveTarget();
    });
    var element = ref(null);
    useElemenStack(element);
    onUnmounted(function() {
      var root = document.getElementById("headlessui-portal-root");
      if (!root)
        return;
      if (myTarget.value !== root)
        return;
      if (myTarget.value.children.length <= 0) {
        var _myTarget$value$paren;
        (_myTarget$value$paren = myTarget.value.parentElement) == null ? void 0 : _myTarget$value$paren.removeChild(myTarget.value);
      }
    });
    useStackProvider();
    return function() {
      if (myTarget.value === null)
        return null;
      var propsWeControl = {
        ref: element
      };
      return h$1(
        Teleport,
        {
          to: myTarget.value
        },
        render$X({
          props: _extends$1({}, props, propsWeControl),
          slot: {},
          attrs,
          slots,
          name: "Portal"
        })
      );
    };
  }
});
var PortalGroupContext = /* @__PURE__ */ Symbol("PortalGroupContext");
var PortalGroup = /* @__PURE__ */ defineComponent({
  name: "PortalGroup",
  props: {
    as: {
      type: [Object, String],
      "default": "template"
    },
    target: {
      type: Object,
      "default": null
    }
  },
  setup: function setup3(props, _ref2) {
    var attrs = _ref2.attrs, slots = _ref2.slots;
    var api = reactive({
      resolveTarget: function resolveTarget2() {
        return props.target;
      }
    });
    provide(PortalGroupContext, api);
    return function() {
      var passThroughProps = _objectWithoutPropertiesLoose(props, ["target"]);
      return render$X({
        props: passThroughProps,
        slot: {},
        attrs,
        slots,
        name: "PortalGroup"
      });
    };
  }
});
var DescriptionContext = /* @__PURE__ */ Symbol("DescriptionContext");
function useDescriptionContext() {
  var context = inject(DescriptionContext, null);
  if (context === null) {
    throw new Error("Missing parent");
  }
  return context;
}
function useDescriptions(_temp) {
  var _ref = _temp === void 0 ? {} : _temp, _ref$slot = _ref.slot, slot = _ref$slot === void 0 ? ref({}) : _ref$slot, _ref$name = _ref.name, name2 = _ref$name === void 0 ? "Description" : _ref$name, _ref$props = _ref.props, props = _ref$props === void 0 ? {} : _ref$props;
  var descriptionIds = ref([]);
  function register(value) {
    descriptionIds.value.push(value);
    return function() {
      var idx = descriptionIds.value.indexOf(value);
      if (idx === -1)
        return;
      descriptionIds.value.splice(idx, 1);
    };
  }
  provide(DescriptionContext, {
    register,
    slot,
    name: name2,
    props
  });
  return computed(function() {
    return descriptionIds.value.length > 0 ? descriptionIds.value.join(" ") : void 0;
  });
}
var Description = /* @__PURE__ */ defineComponent({
  name: "Description",
  props: {
    as: {
      type: [Object, String],
      "default": "p"
    }
  },
  render: function render$1() {
    var _this$context = this.context, _this$context$name = _this$context.name, name2 = _this$context$name === void 0 ? "Description" : _this$context$name, _this$context$slot = _this$context.slot, slot = _this$context$slot === void 0 ? ref({}) : _this$context$slot, _this$context$props = _this$context.props, props = _this$context$props === void 0 ? {} : _this$context$props;
    var passThroughProps = this.$props;
    var propsWeControl = _extends$1({}, Object.entries(props).reduce(function(acc, _ref2) {
      var _Object$assign;
      var key = _ref2[0], value = _ref2[1];
      return Object.assign(acc, (_Object$assign = {}, _Object$assign[key] = unref(value), _Object$assign));
    }, {}), {
      id: this.id
    });
    return render$X({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot: slot.value,
      attrs: this.$attrs,
      slots: this.$slots,
      name: name2
    });
  },
  setup: function setup4() {
    var context = useDescriptionContext();
    var id2 = "headlessui-description-" + useId();
    onMounted(function() {
      return onUnmounted(context.register(id2));
    });
    return {
      id: id2,
      context
    };
  }
});
function dom(ref2) {
  var _ref$value$$el;
  if (ref2 == null)
    return null;
  if (ref2.value == null)
    return null;
  return (_ref$value$$el = ref2.value.$el) != null ? _ref$value$$el : ref2.value;
}
var Context = /* @__PURE__ */ Symbol("Context");
var State;
(function(State2) {
  State2[State2["Open"] = 0] = "Open";
  State2[State2["Closed"] = 1] = "Closed";
})(State || (State = {}));
function useOpenClosed() {
  return inject(Context, null);
}
function useOpenClosedProvider(value) {
  provide(Context, value);
}
var DialogStates;
(function(DialogStates2) {
  DialogStates2[DialogStates2["Open"] = 0] = "Open";
  DialogStates2[DialogStates2["Closed"] = 1] = "Closed";
})(DialogStates || (DialogStates = {}));
var DialogContext = /* @__PURE__ */ Symbol("DialogContext");
function useDialogContext(component) {
  var context = inject(DialogContext, null);
  if (context === null) {
    var err = new Error("<" + component + " /> is missing a parent <Dialog /> component.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useDialogContext);
    throw err;
  }
  return context;
}
var Missing = "DC8F892D-2EBD-447C-A4C8-A03058436FF4";
var Dialog = /* @__PURE__ */ defineComponent({
  name: "Dialog",
  inheritAttrs: false,
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    },
    "static": {
      type: Boolean,
      "default": false
    },
    unmount: {
      type: Boolean,
      "default": true
    },
    open: {
      type: [Boolean, String],
      "default": Missing
    },
    initialFocus: {
      type: Object,
      "default": null
    }
  },
  emits: ["close"],
  render: function render$110() {
    var _this = this;
    var propsWeControl = _extends$1({}, this.$attrs, {
      ref: "el",
      id: this.id,
      role: "dialog",
      "aria-modal": this.dialogState === DialogStates.Open ? true : void 0,
      "aria-labelledby": this.titleId,
      "aria-describedby": this.describedby,
      onClick: this.handleClick,
      onKeydown: this.handleKeyDown
    });
    var _this$$props = this.$props, passThroughProps = _objectWithoutPropertiesLoose(_this$$props, ["open", "initialFocus"]);
    var slot = {
      open: this.dialogState === DialogStates.Open
    };
    return h$1(ForcePortalRoot, {
      force: true
    }, function() {
      return h$1(Portal, function() {
        return h$1(PortalGroup, {
          target: _this.dialogRef
        }, function() {
          return h$1(ForcePortalRoot, {
            force: false
          }, function() {
            return render$X({
              props: _extends$1({}, passThroughProps, propsWeControl),
              slot,
              attrs: _this.$attrs,
              slots: _this.$slots,
              visible: _this.visible,
              features: Features.RenderStrategy | Features.Static,
              name: "Dialog"
            });
          });
        });
      });
    });
  },
  setup: function setup5(props, _ref) {
    var emit = _ref.emit;
    var containers = ref(/* @__PURE__ */ new Set());
    var usesOpenClosedState = useOpenClosed();
    var open = computed(function() {
      if (props.open === Missing && usesOpenClosedState !== null) {
        var _match;
        return match(usesOpenClosedState.value, (_match = {}, _match[State.Open] = true, _match[State.Closed] = false, _match));
      }
      return props.open;
    });
    var hasOpen = props.open !== Missing || usesOpenClosedState !== null;
    if (!hasOpen) {
      throw new Error("You forgot to provide an `open` prop to the `Dialog`.");
    }
    if (typeof open.value !== "boolean") {
      throw new Error("You provided an `open` prop to the `Dialog`, but the value is not a boolean. Received: " + (open.value === Missing ? void 0 : props.open));
    }
    var dialogState = computed(function() {
      return props.open ? DialogStates.Open : DialogStates.Closed;
    });
    var visible = computed(function() {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === State.Open;
      }
      return dialogState.value === DialogStates.Open;
    });
    var internalDialogRef = ref(null);
    var enabled = ref(dialogState.value === DialogStates.Open);
    onUpdated(function() {
      enabled.value = dialogState.value === DialogStates.Open;
    });
    var id2 = "headlessui-dialog-" + useId();
    var focusTrapOptions = computed(function() {
      return {
        initialFocus: props.initialFocus
      };
    });
    useFocusTrap(containers, enabled, focusTrapOptions);
    useInertOthers(internalDialogRef, enabled);
    useStackProvider(function(message, element) {
      var _match2;
      return match(message, (_match2 = {}, _match2[StackMessage.AddElement] = function() {
        containers.value.add(element);
      }, _match2[StackMessage.RemoveElement] = function() {
        containers.value["delete"](element);
      }, _match2));
    });
    var describedby = useDescriptions({
      name: "DialogDescription",
      slot: computed(function() {
        return {
          open: open.value
        };
      })
    });
    var titleId = ref(null);
    var api = {
      titleId,
      dialogState,
      setTitleId: function setTitleId(id3) {
        if (titleId.value === id3)
          return;
        titleId.value = id3;
      },
      close: function close() {
        emit("close", false);
      }
    };
    provide(DialogContext, api);
    useWindowEvent("mousedown", function(event) {
      var target2 = event.target;
      if (dialogState.value !== DialogStates.Open)
        return;
      if (containers.value.size !== 1)
        return;
      if (contains$1(containers.value, target2))
        return;
      api.close();
      nextTick(function() {
        return target2 == null ? void 0 : target2.focus();
      });
    });
    watchEffect(function(onInvalidate) {
      if (dialogState.value !== DialogStates.Open)
        return;
      var overflow = document.documentElement.style.overflow;
      var paddingRight = document.documentElement.style.paddingRight;
      var scrollbarWidth = window.innerWidth - document.documentElement.clientWidth;
      document.documentElement.style.overflow = "hidden";
      document.documentElement.style.paddingRight = scrollbarWidth + "px";
      onInvalidate(function() {
        document.documentElement.style.overflow = overflow;
        document.documentElement.style.paddingRight = paddingRight;
      });
    });
    watchEffect(function(onInvalidate) {
      if (dialogState.value !== DialogStates.Open)
        return;
      var container = dom(internalDialogRef);
      if (!container)
        return;
      var observer = new IntersectionObserver(function(entries) {
        for (var _iterator = _createForOfIteratorHelperLoose(entries), _step; !(_step = _iterator()).done; ) {
          var entry = _step.value;
          if (entry.boundingClientRect.x === 0 && entry.boundingClientRect.y === 0 && entry.boundingClientRect.width === 0 && entry.boundingClientRect.height === 0) {
            api.close();
          }
        }
      });
      observer.observe(container);
      onInvalidate(function() {
        return observer.disconnect();
      });
    });
    return {
      id: id2,
      el: internalDialogRef,
      dialogRef: internalDialogRef,
      containers,
      dialogState,
      titleId,
      describedby,
      visible,
      open,
      handleClick: function handleClick(event) {
        event.stopPropagation();
      },
      handleKeyDown: function handleKeyDown(event) {
        if (event.key !== Keys.Escape)
          return;
        if (dialogState.value !== DialogStates.Open)
          return;
        if (containers.value.size > 1)
          return;
        event.preventDefault();
        event.stopPropagation();
        api.close();
      }
    };
  }
});
var DialogOverlay = /* @__PURE__ */ defineComponent({
  name: "DialogOverlay",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    }
  },
  render: function render$111() {
    var api = useDialogContext("DialogOverlay");
    var propsWeControl = {
      ref: "el",
      id: this.id,
      "aria-hidden": true,
      onClick: this.handleClick
    };
    var passThroughProps = this.$props;
    return render$X({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot: {
        open: api.dialogState.value === DialogStates.Open
      },
      attrs: this.$attrs,
      slots: this.$slots,
      name: "DialogOverlay"
    });
  },
  setup: function setup6() {
    var api = useDialogContext("DialogOverlay");
    var id2 = "headlessui-dialog-overlay-" + useId();
    return {
      id: id2,
      handleClick: function handleClick(event) {
        event.preventDefault();
        event.stopPropagation();
        api.close();
      }
    };
  }
});
var DialogTitle = /* @__PURE__ */ defineComponent({
  name: "DialogTitle",
  props: {
    as: {
      type: [Object, String],
      "default": "h2"
    }
  },
  render: function render$112() {
    var api = useDialogContext("DialogTitle");
    var propsWeControl = {
      id: this.id
    };
    var passThroughProps = this.$props;
    return render$X({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot: {
        open: api.dialogState.value === DialogStates.Open
      },
      attrs: this.$attrs,
      slots: this.$slots,
      name: "DialogTitle"
    });
  },
  setup: function setup7() {
    var api = useDialogContext("DialogTitle");
    var id2 = "headlessui-dialog-title-" + useId();
    onMounted(function() {
      api.setTitleId(id2);
      onUnmounted(function() {
        return api.setTitleId(null);
      });
    });
    return {
      id: id2
    };
  }
});
var DialogDescription = Description;
var DisclosureStates;
(function(DisclosureStates2) {
  DisclosureStates2[DisclosureStates2["Open"] = 0] = "Open";
  DisclosureStates2[DisclosureStates2["Closed"] = 1] = "Closed";
})(DisclosureStates || (DisclosureStates = {}));
function assertNever(x2) {
  throw new Error("Unexpected object: " + x2);
}
var Focus$1;
(function(Focus2) {
  Focus2[Focus2["First"] = 0] = "First";
  Focus2[Focus2["Previous"] = 1] = "Previous";
  Focus2[Focus2["Next"] = 2] = "Next";
  Focus2[Focus2["Last"] = 3] = "Last";
  Focus2[Focus2["Specific"] = 4] = "Specific";
  Focus2[Focus2["Nothing"] = 5] = "Nothing";
})(Focus$1 || (Focus$1 = {}));
function calculateActiveIndex(action, resolvers) {
  var items = resolvers.resolveItems();
  if (items.length <= 0)
    return null;
  var currentActiveIndex = resolvers.resolveActiveIndex();
  var activeIndex = currentActiveIndex != null ? currentActiveIndex : -1;
  var nextActiveIndex = function() {
    switch (action.focus) {
      case Focus$1.First:
        return items.findIndex(function(item) {
          return !resolvers.resolveDisabled(item);
        });
      case Focus$1.Previous: {
        var idx = items.slice().reverse().findIndex(function(item, idx2, all) {
          if (activeIndex !== -1 && all.length - idx2 - 1 >= activeIndex)
            return false;
          return !resolvers.resolveDisabled(item);
        });
        if (idx === -1)
          return idx;
        return items.length - 1 - idx;
      }
      case Focus$1.Next:
        return items.findIndex(function(item, idx2) {
          if (idx2 <= activeIndex)
            return false;
          return !resolvers.resolveDisabled(item);
        });
      case Focus$1.Last: {
        var _idx = items.slice().reverse().findIndex(function(item) {
          return !resolvers.resolveDisabled(item);
        });
        if (_idx === -1)
          return _idx;
        return items.length - 1 - _idx;
      }
      case Focus$1.Specific:
        return items.findIndex(function(item) {
          return resolvers.resolveId(item) === action.id;
        });
      case Focus$1.Nothing:
        return null;
      default:
        assertNever(action);
    }
  }();
  return nextActiveIndex === -1 ? currentActiveIndex : nextActiveIndex;
}
var ListboxStates;
(function(ListboxStates2) {
  ListboxStates2[ListboxStates2["Open"] = 0] = "Open";
  ListboxStates2[ListboxStates2["Closed"] = 1] = "Closed";
})(ListboxStates || (ListboxStates = {}));
function nextFrame$1(cb) {
  requestAnimationFrame(function() {
    return requestAnimationFrame(cb);
  });
}
var ListboxContext = /* @__PURE__ */ Symbol("ListboxContext");
function useListboxContext(component) {
  var context = inject(ListboxContext, null);
  if (context === null) {
    var err = new Error("<" + component + " /> is missing a parent <Listbox /> component.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useListboxContext);
    throw err;
  }
  return context;
}
var Listbox = /* @__PURE__ */ defineComponent({
  name: "Listbox",
  emits: ["update:modelValue"],
  props: {
    as: {
      type: [Object, String],
      "default": "template"
    },
    disabled: {
      type: [Boolean],
      "default": false
    },
    horizontal: {
      type: [Boolean],
      "default": false
    },
    modelValue: {
      type: [Object, String, Number, Boolean]
    }
  },
  setup: function setup8(props, _ref) {
    var slots = _ref.slots, attrs = _ref.attrs, emit = _ref.emit;
    var listboxState = ref(ListboxStates.Closed);
    var labelRef = ref(null);
    var buttonRef = ref(null);
    var optionsRef = ref(null);
    var options2 = ref([]);
    var searchQuery = ref("");
    var activeOptionIndex = ref(null);
    var value = computed(function() {
      return props.modelValue;
    });
    var api = {
      listboxState,
      value,
      orientation: computed(function() {
        return props.horizontal ? "horizontal" : "vertical";
      }),
      labelRef,
      buttonRef,
      optionsRef,
      disabled: computed(function() {
        return props.disabled;
      }),
      options: options2,
      searchQuery,
      activeOptionIndex,
      closeListbox: function closeListbox() {
        if (props.disabled)
          return;
        if (listboxState.value === ListboxStates.Closed)
          return;
        listboxState.value = ListboxStates.Closed;
        activeOptionIndex.value = null;
      },
      openListbox: function openListbox() {
        if (props.disabled)
          return;
        if (listboxState.value === ListboxStates.Open)
          return;
        listboxState.value = ListboxStates.Open;
      },
      goToOption: function goToOption(focus, id2) {
        if (props.disabled)
          return;
        if (listboxState.value === ListboxStates.Closed)
          return;
        var nextActiveOptionIndex = calculateActiveIndex(focus === Focus$1.Specific ? {
          focus: Focus$1.Specific,
          id: id2
        } : {
          focus
        }, {
          resolveItems: function resolveItems() {
            return options2.value;
          },
          resolveActiveIndex: function resolveActiveIndex() {
            return activeOptionIndex.value;
          },
          resolveId: function resolveId(option) {
            return option.id;
          },
          resolveDisabled: function resolveDisabled(option) {
            return option.dataRef.disabled;
          }
        });
        if (searchQuery.value === "" && activeOptionIndex.value === nextActiveOptionIndex)
          return;
        searchQuery.value = "";
        activeOptionIndex.value = nextActiveOptionIndex;
      },
      search: function search(value2) {
        if (props.disabled)
          return;
        if (listboxState.value === ListboxStates.Closed)
          return;
        searchQuery.value += value2.toLowerCase();
        var match3 = options2.value.findIndex(function(option) {
          return !option.dataRef.disabled && option.dataRef.textValue.startsWith(searchQuery.value);
        });
        if (match3 === -1 || match3 === activeOptionIndex.value)
          return;
        activeOptionIndex.value = match3;
      },
      clearSearch: function clearSearch() {
        if (props.disabled)
          return;
        if (listboxState.value === ListboxStates.Closed)
          return;
        if (searchQuery.value === "")
          return;
        searchQuery.value = "";
      },
      registerOption: function registerOption(id2, dataRef) {
        options2.value.push({
          id: id2,
          dataRef
        });
      },
      unregisterOption: function unregisterOption(id2) {
        var nextOptions = options2.value.slice();
        var currentActiveOption = activeOptionIndex.value !== null ? nextOptions[activeOptionIndex.value] : null;
        var idx = nextOptions.findIndex(function(a2) {
          return a2.id === id2;
        });
        if (idx !== -1)
          nextOptions.splice(idx, 1);
        options2.value = nextOptions;
        activeOptionIndex.value = function() {
          if (idx === activeOptionIndex.value)
            return null;
          if (currentActiveOption === null)
            return null;
          return nextOptions.indexOf(currentActiveOption);
        }();
      },
      select: function select(value2) {
        if (props.disabled)
          return;
        emit("update:modelValue", value2);
      }
    };
    useWindowEvent("mousedown", function(event) {
      var _dom, _dom2, _dom3;
      var target2 = event.target;
      var active = document.activeElement;
      if (listboxState.value !== ListboxStates.Open)
        return;
      if ((_dom = dom(buttonRef)) == null ? void 0 : _dom.contains(target2))
        return;
      if (!((_dom2 = dom(optionsRef)) == null ? void 0 : _dom2.contains(target2)))
        api.closeListbox();
      if (active !== document.body && (active == null ? void 0 : active.contains(target2)))
        return;
      if (!event.defaultPrevented)
        (_dom3 = dom(buttonRef)) == null ? void 0 : _dom3.focus({
          preventScroll: true
        });
    });
    provide(ListboxContext, api);
    useOpenClosedProvider(computed(function() {
      var _match;
      return match(listboxState.value, (_match = {}, _match[ListboxStates.Open] = State.Open, _match[ListboxStates.Closed] = State.Closed, _match));
    }));
    return function() {
      var slot = {
        open: listboxState.value === ListboxStates.Open,
        disabled: props.disabled
      };
      return render$X({
        props: omit(props, ["modelValue", "onUpdate:modelValue", "disabled", "horizontal"]),
        slot,
        slots,
        attrs,
        name: "Listbox"
      });
    };
  }
});
var ListboxLabel = /* @__PURE__ */ defineComponent({
  name: "ListboxLabel",
  props: {
    as: {
      type: [Object, String],
      "default": "label"
    }
  },
  render: function render$113() {
    var api = useListboxContext("ListboxLabel");
    var slot = {
      open: api.listboxState.value === ListboxStates.Open,
      disabled: api.disabled.value
    };
    var propsWeControl = {
      id: this.id,
      ref: "el",
      onClick: this.handleClick
    };
    return render$X({
      props: _extends$1({}, this.$props, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      name: "ListboxLabel"
    });
  },
  setup: function setup9() {
    var api = useListboxContext("ListboxLabel");
    var id2 = "headlessui-listbox-label-" + useId();
    return {
      id: id2,
      el: api.labelRef,
      handleClick: function handleClick() {
        var _dom4;
        (_dom4 = dom(api.buttonRef)) == null ? void 0 : _dom4.focus({
          preventScroll: true
        });
      }
    };
  }
});
var ListboxButton = /* @__PURE__ */ defineComponent({
  name: "ListboxButton",
  props: {
    as: {
      type: [Object, String],
      "default": "button"
    }
  },
  render: function render$114() {
    var _dom5, _dom6;
    var api = useListboxContext("ListboxButton");
    var slot = {
      open: api.listboxState.value === ListboxStates.Open,
      disabled: api.disabled.value
    };
    var propsWeControl = {
      ref: "el",
      id: this.id,
      type: "button",
      "aria-haspopup": true,
      "aria-controls": (_dom5 = dom(api.optionsRef)) == null ? void 0 : _dom5.id,
      "aria-expanded": api.disabled.value ? void 0 : api.listboxState.value === ListboxStates.Open,
      "aria-labelledby": api.labelRef.value ? [(_dom6 = dom(api.labelRef)) == null ? void 0 : _dom6.id, this.id].join(" ") : void 0,
      disabled: api.disabled.value === true ? true : void 0,
      onKeydown: this.handleKeyDown,
      onKeyup: this.handleKeyUp,
      onClick: this.handleClick
    };
    return render$X({
      props: _extends$1({}, this.$props, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      name: "ListboxButton"
    });
  },
  setup: function setup10() {
    var api = useListboxContext("ListboxButton");
    var id2 = "headlessui-listbox-button-" + useId();
    function handleKeyDown(event) {
      switch (event.key) {
        case Keys.Space:
        case Keys.Enter:
        case Keys.ArrowDown:
          event.preventDefault();
          api.openListbox();
          nextTick(function() {
            var _dom7;
            (_dom7 = dom(api.optionsRef)) == null ? void 0 : _dom7.focus({
              preventScroll: true
            });
            if (!api.value.value)
              api.goToOption(Focus$1.First);
          });
          break;
        case Keys.ArrowUp:
          event.preventDefault();
          api.openListbox();
          nextTick(function() {
            var _dom8;
            (_dom8 = dom(api.optionsRef)) == null ? void 0 : _dom8.focus({
              preventScroll: true
            });
            if (!api.value.value)
              api.goToOption(Focus$1.Last);
          });
          break;
      }
    }
    function handleKeyUp(event) {
      switch (event.key) {
        case Keys.Space:
          event.preventDefault();
          break;
      }
    }
    function handleClick(event) {
      if (api.disabled.value)
        return;
      if (api.listboxState.value === ListboxStates.Open) {
        api.closeListbox();
        nextTick(function() {
          var _dom9;
          return (_dom9 = dom(api.buttonRef)) == null ? void 0 : _dom9.focus({
            preventScroll: true
          });
        });
      } else {
        event.preventDefault();
        api.openListbox();
        nextFrame$1(function() {
          var _dom10;
          return (_dom10 = dom(api.optionsRef)) == null ? void 0 : _dom10.focus({
            preventScroll: true
          });
        });
      }
    }
    return {
      id: id2,
      el: api.buttonRef,
      handleKeyDown,
      handleKeyUp,
      handleClick
    };
  }
});
var ListboxOptions = /* @__PURE__ */ defineComponent({
  name: "ListboxOptions",
  props: {
    as: {
      type: [Object, String],
      "default": "ul"
    },
    "static": {
      type: Boolean,
      "default": false
    },
    unmount: {
      type: Boolean,
      "default": true
    }
  },
  render: function render$115() {
    var _api$options$value$ap, _dom$id, _dom11, _dom12;
    var api = useListboxContext("ListboxOptions");
    var slot = {
      open: api.listboxState.value === ListboxStates.Open
    };
    var propsWeControl = {
      "aria-activedescendant": api.activeOptionIndex.value === null ? void 0 : (_api$options$value$ap = api.options.value[api.activeOptionIndex.value]) == null ? void 0 : _api$options$value$ap.id,
      "aria-labelledby": (_dom$id = (_dom11 = dom(api.labelRef)) == null ? void 0 : _dom11.id) != null ? _dom$id : (_dom12 = dom(api.buttonRef)) == null ? void 0 : _dom12.id,
      "aria-orientation": api.orientation.value,
      id: this.id,
      onKeydown: this.handleKeyDown,
      role: "listbox",
      tabIndex: 0,
      ref: "el"
    };
    var passThroughProps = this.$props;
    return render$X({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      features: Features.RenderStrategy | Features.Static,
      visible: this.visible,
      name: "ListboxOptions"
    });
  },
  setup: function setup11() {
    var api = useListboxContext("ListboxOptions");
    var id2 = "headlessui-listbox-options-" + useId();
    var searchDebounce = ref(null);
    function handleKeyDown(event) {
      if (searchDebounce.value)
        clearTimeout(searchDebounce.value);
      switch (event.key) {
        case Keys.Space:
          if (api.searchQuery.value !== "") {
            event.preventDefault();
            event.stopPropagation();
            return api.search(event.key);
          }
        case Keys.Enter:
          event.preventDefault();
          event.stopPropagation();
          if (api.activeOptionIndex.value !== null) {
            var dataRef = api.options.value[api.activeOptionIndex.value].dataRef;
            api.select(dataRef.value);
          }
          api.closeListbox();
          nextTick(function() {
            var _dom13;
            return (_dom13 = dom(api.buttonRef)) == null ? void 0 : _dom13.focus({
              preventScroll: true
            });
          });
          break;
        case match(api.orientation.value, {
          vertical: Keys.ArrowDown,
          horizontal: Keys.ArrowRight
        }):
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(Focus$1.Next);
        case match(api.orientation.value, {
          vertical: Keys.ArrowUp,
          horizontal: Keys.ArrowLeft
        }):
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(Focus$1.Previous);
        case Keys.Home:
        case Keys.PageUp:
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(Focus$1.First);
        case Keys.End:
        case Keys.PageDown:
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(Focus$1.Last);
        case Keys.Escape:
          event.preventDefault();
          event.stopPropagation();
          api.closeListbox();
          nextTick(function() {
            var _dom14;
            return (_dom14 = dom(api.buttonRef)) == null ? void 0 : _dom14.focus({
              preventScroll: true
            });
          });
          break;
        case Keys.Tab:
          event.preventDefault();
          event.stopPropagation();
          break;
        default:
          if (event.key.length === 1) {
            api.search(event.key);
            searchDebounce.value = setTimeout(function() {
              return api.clearSearch();
            }, 350);
          }
          break;
      }
    }
    var usesOpenClosedState = useOpenClosed();
    var visible = computed(function() {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === State.Open;
      }
      return api.listboxState.value === ListboxStates.Open;
    });
    return {
      id: id2,
      el: api.optionsRef,
      handleKeyDown,
      visible
    };
  }
});
var ListboxOption = /* @__PURE__ */ defineComponent({
  name: "ListboxOption",
  props: {
    as: {
      type: [Object, String],
      "default": "li"
    },
    value: {
      type: [Object, String, Number, Boolean]
    },
    disabled: {
      type: Boolean,
      "default": false
    }
  },
  setup: function setup12(props, _ref2) {
    var slots = _ref2.slots, attrs = _ref2.attrs;
    var api = useListboxContext("ListboxOption");
    var id2 = "headlessui-listbox-option-" + useId();
    var active = computed(function() {
      return api.activeOptionIndex.value !== null ? api.options.value[api.activeOptionIndex.value].id === id2 : false;
    });
    var selected = computed(function() {
      return toRaw(api.value.value) === toRaw(props.value);
    });
    var dataRef = ref({
      disabled: props.disabled,
      value: props.value,
      textValue: ""
    });
    onMounted(function() {
      var _document$getElementB, _document$getElementB2;
      var textValue = (_document$getElementB = document.getElementById(id2)) == null ? void 0 : (_document$getElementB2 = _document$getElementB.textContent) == null ? void 0 : _document$getElementB2.toLowerCase().trim();
      if (textValue !== void 0)
        dataRef.value.textValue = textValue;
    });
    onMounted(function() {
      return api.registerOption(id2, dataRef);
    });
    onUnmounted(function() {
      return api.unregisterOption(id2);
    });
    onMounted(function() {
      watch([api.listboxState, selected], function() {
        var _document$getElementB3;
        if (api.listboxState.value !== ListboxStates.Open)
          return;
        if (!selected.value)
          return;
        api.goToOption(Focus$1.Specific, id2);
        (_document$getElementB3 = document.getElementById(id2)) == null ? void 0 : _document$getElementB3.focus == null ? void 0 : _document$getElementB3.focus();
      }, {
        immediate: true
      });
    });
    watchEffect(function() {
      if (api.listboxState.value !== ListboxStates.Open)
        return;
      if (!active.value)
        return;
      nextTick(function() {
        var _document$getElementB4;
        return (_document$getElementB4 = document.getElementById(id2)) == null ? void 0 : _document$getElementB4.scrollIntoView == null ? void 0 : _document$getElementB4.scrollIntoView({
          block: "nearest"
        });
      });
    });
    function handleClick(event) {
      if (props.disabled)
        return event.preventDefault();
      api.select(props.value);
      api.closeListbox();
      nextTick(function() {
        var _dom15;
        return (_dom15 = dom(api.buttonRef)) == null ? void 0 : _dom15.focus({
          preventScroll: true
        });
      });
    }
    function handleFocus() {
      if (props.disabled)
        return api.goToOption(Focus$1.Nothing);
      api.goToOption(Focus$1.Specific, id2);
    }
    function handleMove() {
      if (props.disabled)
        return;
      if (active.value)
        return;
      api.goToOption(Focus$1.Specific, id2);
    }
    function handleLeave() {
      if (props.disabled)
        return;
      if (!active.value)
        return;
      api.goToOption(Focus$1.Nothing);
    }
    return function() {
      var disabled = props.disabled;
      var slot = {
        active: active.value,
        selected: selected.value,
        disabled
      };
      var propsWeControl = {
        id: id2,
        role: "option",
        tabIndex: disabled === true ? void 0 : -1,
        "aria-disabled": disabled === true ? true : void 0,
        "aria-selected": selected.value === true ? selected.value : void 0,
        disabled: void 0,
        onClick: handleClick,
        onFocus: handleFocus,
        onPointermove: handleMove,
        onMousemove: handleMove,
        onPointerleave: handleLeave,
        onMouseleave: handleLeave
      };
      return render$X({
        props: _extends$1({}, props, propsWeControl),
        slot,
        attrs,
        slots,
        name: "ListboxOption"
      });
    };
  }
});
function useTreeWalker(_ref) {
  var container = _ref.container, accept = _ref.accept, walk = _ref.walk, enabled = _ref.enabled;
  watchEffect(function() {
    var root = container.value;
    if (!root)
      return;
    if (enabled !== void 0 && !enabled.value)
      return;
    var acceptNode = Object.assign(function(node) {
      return accept(node);
    }, {
      acceptNode: accept
    });
    var walker = document.createTreeWalker(root, NodeFilter.SHOW_ELEMENT, acceptNode, false);
    while (walker.nextNode()) {
      walk(walker.currentNode);
    }
  });
}
var MenuStates;
(function(MenuStates2) {
  MenuStates2[MenuStates2["Open"] = 0] = "Open";
  MenuStates2[MenuStates2["Closed"] = 1] = "Closed";
})(MenuStates || (MenuStates = {}));
function nextFrame$1$1(cb) {
  requestAnimationFrame(function() {
    return requestAnimationFrame(cb);
  });
}
var MenuContext = /* @__PURE__ */ Symbol("MenuContext");
function useMenuContext(component) {
  var context = inject(MenuContext, null);
  if (context === null) {
    var err = new Error("<" + component + " /> is missing a parent <Menu /> component.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useMenuContext);
    throw err;
  }
  return context;
}
var Menu$1 = /* @__PURE__ */ defineComponent({
  name: "Menu",
  props: {
    as: {
      type: [Object, String],
      "default": "template"
    }
  },
  setup: function setup13(props, _ref) {
    var slots = _ref.slots, attrs = _ref.attrs;
    var menuState = ref(MenuStates.Closed);
    var buttonRef = ref(null);
    var itemsRef = ref(null);
    var items = ref([]);
    var searchQuery = ref("");
    var activeItemIndex = ref(null);
    var api = {
      menuState,
      buttonRef,
      itemsRef,
      items,
      searchQuery,
      activeItemIndex,
      closeMenu: function closeMenu() {
        menuState.value = MenuStates.Closed;
        activeItemIndex.value = null;
      },
      openMenu: function openMenu() {
        return menuState.value = MenuStates.Open;
      },
      goToItem: function goToItem(focus, id2) {
        var nextActiveItemIndex = calculateActiveIndex(focus === Focus$1.Specific ? {
          focus: Focus$1.Specific,
          id: id2
        } : {
          focus
        }, {
          resolveItems: function resolveItems() {
            return items.value;
          },
          resolveActiveIndex: function resolveActiveIndex() {
            return activeItemIndex.value;
          },
          resolveId: function resolveId(item) {
            return item.id;
          },
          resolveDisabled: function resolveDisabled(item) {
            return item.dataRef.disabled;
          }
        });
        if (searchQuery.value === "" && activeItemIndex.value === nextActiveItemIndex)
          return;
        searchQuery.value = "";
        activeItemIndex.value = nextActiveItemIndex;
      },
      search: function search(value) {
        searchQuery.value += value.toLowerCase();
        var match3 = items.value.findIndex(function(item) {
          return item.dataRef.textValue.startsWith(searchQuery.value) && !item.dataRef.disabled;
        });
        if (match3 === -1 || match3 === activeItemIndex.value)
          return;
        activeItemIndex.value = match3;
      },
      clearSearch: function clearSearch() {
        searchQuery.value = "";
      },
      registerItem: function registerItem(id2, dataRef) {
        items.value.push({
          id: id2,
          dataRef
        });
      },
      unregisterItem: function unregisterItem(id2) {
        var nextItems = items.value.slice();
        var currentActiveItem = activeItemIndex.value !== null ? nextItems[activeItemIndex.value] : null;
        var idx = nextItems.findIndex(function(a2) {
          return a2.id === id2;
        });
        if (idx !== -1)
          nextItems.splice(idx, 1);
        items.value = nextItems;
        activeItemIndex.value = function() {
          if (idx === activeItemIndex.value)
            return null;
          if (currentActiveItem === null)
            return null;
          return nextItems.indexOf(currentActiveItem);
        }();
      }
    };
    useWindowEvent("mousedown", function(event) {
      var _dom, _dom2, _dom3;
      var target2 = event.target;
      var active = document.activeElement;
      if (menuState.value !== MenuStates.Open)
        return;
      if ((_dom = dom(buttonRef)) == null ? void 0 : _dom.contains(target2))
        return;
      if (!((_dom2 = dom(itemsRef)) == null ? void 0 : _dom2.contains(target2)))
        api.closeMenu();
      if (active !== document.body && (active == null ? void 0 : active.contains(target2)))
        return;
      if (!event.defaultPrevented)
        (_dom3 = dom(buttonRef)) == null ? void 0 : _dom3.focus({
          preventScroll: true
        });
    });
    provide(MenuContext, api);
    useOpenClosedProvider(computed(function() {
      var _match;
      return match(menuState.value, (_match = {}, _match[MenuStates.Open] = State.Open, _match[MenuStates.Closed] = State.Closed, _match));
    }));
    return function() {
      var slot = {
        open: menuState.value === MenuStates.Open
      };
      return render$X({
        props,
        slot,
        slots,
        attrs,
        name: "Menu"
      });
    };
  }
});
var MenuButton = /* @__PURE__ */ defineComponent({
  name: "MenuButton",
  props: {
    disabled: {
      type: Boolean,
      "default": false
    },
    as: {
      type: [Object, String],
      "default": "button"
    }
  },
  render: function render$116() {
    var _dom4;
    var api = useMenuContext("MenuButton");
    var slot = {
      open: api.menuState.value === MenuStates.Open
    };
    var propsWeControl = {
      ref: "el",
      id: this.id,
      type: "button",
      "aria-haspopup": true,
      "aria-controls": (_dom4 = dom(api.itemsRef)) == null ? void 0 : _dom4.id,
      "aria-expanded": this.$props.disabled ? void 0 : api.menuState.value === MenuStates.Open,
      onKeydown: this.handleKeyDown,
      onKeyup: this.handleKeyUp,
      onClick: this.handleClick
    };
    return render$X({
      props: _extends$1({}, this.$props, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      name: "MenuButton"
    });
  },
  setup: function setup14(props) {
    var api = useMenuContext("MenuButton");
    var id2 = "headlessui-menu-button-" + useId();
    function handleKeyDown(event) {
      switch (event.key) {
        case Keys.Space:
        case Keys.Enter:
        case Keys.ArrowDown:
          event.preventDefault();
          event.stopPropagation();
          api.openMenu();
          nextTick(function() {
            var _dom5;
            (_dom5 = dom(api.itemsRef)) == null ? void 0 : _dom5.focus({
              preventScroll: true
            });
            api.goToItem(Focus$1.First);
          });
          break;
        case Keys.ArrowUp:
          event.preventDefault();
          event.stopPropagation();
          api.openMenu();
          nextTick(function() {
            var _dom6;
            (_dom6 = dom(api.itemsRef)) == null ? void 0 : _dom6.focus({
              preventScroll: true
            });
            api.goToItem(Focus$1.Last);
          });
          break;
      }
    }
    function handleKeyUp(event) {
      switch (event.key) {
        case Keys.Space:
          event.preventDefault();
          break;
      }
    }
    function handleClick(event) {
      if (props.disabled)
        return;
      if (api.menuState.value === MenuStates.Open) {
        api.closeMenu();
        nextTick(function() {
          var _dom7;
          return (_dom7 = dom(api.buttonRef)) == null ? void 0 : _dom7.focus({
            preventScroll: true
          });
        });
      } else {
        event.preventDefault();
        event.stopPropagation();
        api.openMenu();
        nextFrame$1$1(function() {
          var _dom8;
          return (_dom8 = dom(api.itemsRef)) == null ? void 0 : _dom8.focus({
            preventScroll: true
          });
        });
      }
    }
    return {
      id: id2,
      el: api.buttonRef,
      handleKeyDown,
      handleKeyUp,
      handleClick
    };
  }
});
var MenuItems = /* @__PURE__ */ defineComponent({
  name: "MenuItems",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    },
    "static": {
      type: Boolean,
      "default": false
    },
    unmount: {
      type: Boolean,
      "default": true
    }
  },
  render: function render$117() {
    var _api$items$value$api$, _dom9;
    var api = useMenuContext("MenuItems");
    var slot = {
      open: api.menuState.value === MenuStates.Open
    };
    var propsWeControl = {
      "aria-activedescendant": api.activeItemIndex.value === null ? void 0 : (_api$items$value$api$ = api.items.value[api.activeItemIndex.value]) == null ? void 0 : _api$items$value$api$.id,
      "aria-labelledby": (_dom9 = dom(api.buttonRef)) == null ? void 0 : _dom9.id,
      id: this.id,
      onKeydown: this.handleKeyDown,
      onKeyup: this.handleKeyUp,
      role: "menu",
      tabIndex: 0,
      ref: "el"
    };
    var passThroughProps = this.$props;
    return render$X({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      features: Features.RenderStrategy | Features.Static,
      visible: this.visible,
      name: "MenuItems"
    });
  },
  setup: function setup15() {
    var api = useMenuContext("MenuItems");
    var id2 = "headlessui-menu-items-" + useId();
    var searchDebounce = ref(null);
    useTreeWalker({
      container: computed(function() {
        return dom(api.itemsRef);
      }),
      enabled: computed(function() {
        return api.menuState.value === MenuStates.Open;
      }),
      accept: function accept(node) {
        if (node.getAttribute("role") === "menuitem")
          return NodeFilter.FILTER_REJECT;
        if (node.hasAttribute("role"))
          return NodeFilter.FILTER_SKIP;
        return NodeFilter.FILTER_ACCEPT;
      },
      walk: function walk(node) {
        node.setAttribute("role", "none");
      }
    });
    function handleKeyDown(event) {
      if (searchDebounce.value)
        clearTimeout(searchDebounce.value);
      switch (event.key) {
        case Keys.Space:
          if (api.searchQuery.value !== "") {
            event.preventDefault();
            event.stopPropagation();
            return api.search(event.key);
          }
        case Keys.Enter:
          event.preventDefault();
          event.stopPropagation();
          if (api.activeItemIndex.value !== null) {
            var _document$getElementB;
            var _id = api.items.value[api.activeItemIndex.value].id;
            (_document$getElementB = document.getElementById(_id)) == null ? void 0 : _document$getElementB.click();
          }
          api.closeMenu();
          nextTick(function() {
            var _dom10;
            return (_dom10 = dom(api.buttonRef)) == null ? void 0 : _dom10.focus({
              preventScroll: true
            });
          });
          break;
        case Keys.ArrowDown:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(Focus$1.Next);
        case Keys.ArrowUp:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(Focus$1.Previous);
        case Keys.Home:
        case Keys.PageUp:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(Focus$1.First);
        case Keys.End:
        case Keys.PageDown:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(Focus$1.Last);
        case Keys.Escape:
          event.preventDefault();
          event.stopPropagation();
          api.closeMenu();
          nextTick(function() {
            var _dom11;
            return (_dom11 = dom(api.buttonRef)) == null ? void 0 : _dom11.focus({
              preventScroll: true
            });
          });
          break;
        case Keys.Tab:
          event.preventDefault();
          event.stopPropagation();
          break;
        default:
          if (event.key.length === 1) {
            api.search(event.key);
            searchDebounce.value = setTimeout(function() {
              return api.clearSearch();
            }, 350);
          }
          break;
      }
    }
    function handleKeyUp(event) {
      switch (event.key) {
        case Keys.Space:
          event.preventDefault();
          break;
      }
    }
    var usesOpenClosedState = useOpenClosed();
    var visible = computed(function() {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === State.Open;
      }
      return api.menuState.value === MenuStates.Open;
    });
    return {
      id: id2,
      el: api.itemsRef,
      handleKeyDown,
      handleKeyUp,
      visible
    };
  }
});
var MenuItem = /* @__PURE__ */ defineComponent({
  name: "MenuItem",
  props: {
    as: {
      type: [Object, String],
      "default": "template"
    },
    disabled: {
      type: Boolean,
      "default": false
    }
  },
  setup: function setup16(props, _ref2) {
    var slots = _ref2.slots, attrs = _ref2.attrs;
    var api = useMenuContext("MenuItem");
    var id2 = "headlessui-menu-item-" + useId();
    var active = computed(function() {
      return api.activeItemIndex.value !== null ? api.items.value[api.activeItemIndex.value].id === id2 : false;
    });
    var dataRef = ref({
      disabled: props.disabled,
      textValue: ""
    });
    onMounted(function() {
      var _document$getElementB2, _document$getElementB3;
      var textValue = (_document$getElementB2 = document.getElementById(id2)) == null ? void 0 : (_document$getElementB3 = _document$getElementB2.textContent) == null ? void 0 : _document$getElementB3.toLowerCase().trim();
      if (textValue !== void 0)
        dataRef.value.textValue = textValue;
    });
    onMounted(function() {
      return api.registerItem(id2, dataRef);
    });
    onUnmounted(function() {
      return api.unregisterItem(id2);
    });
    watchEffect(function() {
      if (api.menuState.value !== MenuStates.Open)
        return;
      if (!active.value)
        return;
      nextTick(function() {
        var _document$getElementB4;
        return (_document$getElementB4 = document.getElementById(id2)) == null ? void 0 : _document$getElementB4.scrollIntoView == null ? void 0 : _document$getElementB4.scrollIntoView({
          block: "nearest"
        });
      });
    });
    function handleClick(event) {
      if (props.disabled)
        return event.preventDefault();
      api.closeMenu();
      nextTick(function() {
        var _dom12;
        return (_dom12 = dom(api.buttonRef)) == null ? void 0 : _dom12.focus({
          preventScroll: true
        });
      });
    }
    function handleFocus() {
      if (props.disabled)
        return api.goToItem(Focus$1.Nothing);
      api.goToItem(Focus$1.Specific, id2);
    }
    function handleMove() {
      if (props.disabled)
        return;
      if (active.value)
        return;
      api.goToItem(Focus$1.Specific, id2);
    }
    function handleLeave() {
      if (props.disabled)
        return;
      if (!active.value)
        return;
      api.goToItem(Focus$1.Nothing);
    }
    return function() {
      var disabled = props.disabled;
      var slot = {
        active: active.value,
        disabled
      };
      var propsWeControl = {
        id: id2,
        role: "menuitem",
        tabIndex: disabled === true ? void 0 : -1,
        "aria-disabled": disabled === true ? true : void 0,
        onClick: handleClick,
        onFocus: handleFocus,
        onPointermove: handleMove,
        onMousemove: handleMove,
        onPointerleave: handleLeave,
        onMouseleave: handleLeave
      };
      return render$X({
        props: _extends$1({}, props, propsWeControl),
        slot,
        attrs,
        slots,
        name: "MenuItem"
      });
    };
  }
});
var PopoverStates;
(function(PopoverStates2) {
  PopoverStates2[PopoverStates2["Open"] = 0] = "Open";
  PopoverStates2[PopoverStates2["Closed"] = 1] = "Closed";
})(PopoverStates || (PopoverStates = {}));
var PopoverContext = /* @__PURE__ */ Symbol("PopoverContext");
function usePopoverContext(component) {
  var context = inject(PopoverContext, null);
  if (context === null) {
    var err = new Error("<" + component + " /> is missing a parent <" + Popover.name + " /> component.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, usePopoverContext);
    throw err;
  }
  return context;
}
var PopoverGroupContext = /* @__PURE__ */ Symbol("PopoverGroupContext");
function usePopoverGroupContext() {
  return inject(PopoverGroupContext, null);
}
var PopoverPanelContext = /* @__PURE__ */ Symbol("PopoverPanelContext");
function usePopoverPanelContext() {
  return inject(PopoverPanelContext, null);
}
var Popover = /* @__PURE__ */ defineComponent({
  name: "Popover",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    }
  },
  setup: function setup17(props, _ref) {
    var slots = _ref.slots, attrs = _ref.attrs;
    var buttonId = "headlessui-popover-button-" + useId();
    var panelId = "headlessui-popover-panel-" + useId();
    var popoverState = ref(PopoverStates.Closed);
    var button = ref(null);
    var panel = ref(null);
    var api = {
      popoverState,
      buttonId,
      panelId,
      panel,
      button,
      togglePopover: function togglePopover() {
        var _match;
        popoverState.value = match(popoverState.value, (_match = {}, _match[PopoverStates.Open] = PopoverStates.Closed, _match[PopoverStates.Closed] = PopoverStates.Open, _match));
      },
      closePopover: function closePopover() {
        if (popoverState.value === PopoverStates.Closed)
          return;
        popoverState.value = PopoverStates.Closed;
      },
      close: function close(focusableElement) {
        api.closePopover();
        var restoreElement = function() {
          if (!focusableElement)
            return dom(api.button);
          if (focusableElement instanceof HTMLElement)
            return focusableElement;
          if (focusableElement.value instanceof HTMLElement)
            return dom(focusableElement);
          return dom(api.button);
        }();
        restoreElement == null ? void 0 : restoreElement.focus();
      }
    };
    provide(PopoverContext, api);
    useOpenClosedProvider(computed(function() {
      var _match2;
      return match(popoverState.value, (_match2 = {}, _match2[PopoverStates.Open] = State.Open, _match2[PopoverStates.Closed] = State.Closed, _match2));
    }));
    var registerBag = {
      buttonId,
      panelId,
      close: function close() {
        api.closePopover();
      }
    };
    var groupContext = usePopoverGroupContext();
    var registerPopover = groupContext == null ? void 0 : groupContext.registerPopover;
    function isFocusWithinPopoverGroup() {
      var _groupContext$isFocus, _dom, _dom2;
      return (_groupContext$isFocus = groupContext == null ? void 0 : groupContext.isFocusWithinPopoverGroup()) != null ? _groupContext$isFocus : ((_dom = dom(button)) == null ? void 0 : _dom.contains(document.activeElement)) || ((_dom2 = dom(panel)) == null ? void 0 : _dom2.contains(document.activeElement));
    }
    watchEffect(function() {
      return registerPopover == null ? void 0 : registerPopover(registerBag);
    });
    useWindowEvent("focus", function() {
      if (popoverState.value !== PopoverStates.Open)
        return;
      if (isFocusWithinPopoverGroup())
        return;
      if (!button)
        return;
      if (!panel)
        return;
      api.closePopover();
    }, true);
    useWindowEvent("mousedown", function(event) {
      var _dom3, _dom4;
      var target2 = event.target;
      if (popoverState.value !== PopoverStates.Open)
        return;
      if ((_dom3 = dom(button)) == null ? void 0 : _dom3.contains(target2))
        return;
      if ((_dom4 = dom(panel)) == null ? void 0 : _dom4.contains(target2))
        return;
      api.closePopover();
      if (!isFocusableElement(target2, FocusableMode.Loose)) {
        var _dom5;
        event.preventDefault();
        (_dom5 = dom(button)) == null ? void 0 : _dom5.focus();
      }
    });
    return function() {
      var slot = {
        open: popoverState.value === PopoverStates.Open,
        close: api.close
      };
      return render$X({
        props,
        slot,
        slots,
        attrs,
        name: "Popover"
      });
    };
  }
});
var PopoverButton = /* @__PURE__ */ defineComponent({
  name: "PopoverButton",
  props: {
    as: {
      type: [Object, String],
      "default": "button"
    },
    disabled: {
      type: [Boolean],
      "default": false
    }
  },
  render: function render$118() {
    var api = usePopoverContext("PopoverButton");
    var slot = {
      open: api.popoverState.value === PopoverStates.Open
    };
    var propsWeControl = this.isWithinPanel ? {
      type: "button",
      onKeydown: this.handleKeyDown,
      onClick: this.handleClick
    } : {
      ref: "el",
      id: api.buttonId,
      type: "button",
      "aria-expanded": this.$props.disabled ? void 0 : api.popoverState.value === PopoverStates.Open,
      "aria-controls": dom(api.panel) ? api.panelId : void 0,
      disabled: this.$props.disabled ? true : void 0,
      onKeydown: this.handleKeyDown,
      onKeyup: this.handleKeyUp,
      onClick: this.handleClick
    };
    return render$X({
      props: _extends$1({}, this.$props, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      name: "PopoverButton"
    });
  },
  setup: function setup18(props) {
    var api = usePopoverContext("PopoverButton");
    var groupContext = usePopoverGroupContext();
    var closeOthers = groupContext == null ? void 0 : groupContext.closeOthers;
    var panelContext = usePopoverPanelContext();
    var isWithinPanel = panelContext === null ? false : panelContext === api.panelId;
    var activeElementRef = ref(null);
    var previousActiveElementRef = ref(typeof window === "undefined" ? null : document.activeElement);
    useWindowEvent("focus", function() {
      previousActiveElementRef.value = activeElementRef.value;
      activeElementRef.value = document.activeElement;
    }, true);
    return {
      isWithinPanel,
      el: isWithinPanel ? null : api.button,
      handleKeyDown: function handleKeyDown(event) {
        var _dom6, _dom7;
        if (isWithinPanel) {
          if (api.popoverState.value === PopoverStates.Closed)
            return;
          switch (event.key) {
            case Keys.Space:
            case Keys.Enter:
              event.preventDefault();
              event.stopPropagation();
              api.closePopover();
              (_dom6 = dom(api.button)) == null ? void 0 : _dom6.focus();
              break;
          }
        } else {
          switch (event.key) {
            case Keys.Space:
            case Keys.Enter:
              event.preventDefault();
              event.stopPropagation();
              if (api.popoverState.value === PopoverStates.Closed)
                closeOthers == null ? void 0 : closeOthers(api.buttonId);
              api.togglePopover();
              break;
            case Keys.Escape:
              if (api.popoverState.value !== PopoverStates.Open)
                return closeOthers == null ? void 0 : closeOthers(api.buttonId);
              if (!dom(api.button))
                return;
              if (!((_dom7 = dom(api.button)) == null ? void 0 : _dom7.contains(document.activeElement)))
                return;
              api.closePopover();
              break;
            case Keys.Tab:
              if (api.popoverState.value !== PopoverStates.Open)
                return;
              if (!api.panel)
                return;
              if (!api.button)
                return;
              if (event.shiftKey) {
                var _dom8, _dom9;
                if (!previousActiveElementRef.value)
                  return;
                if ((_dom8 = dom(api.button)) == null ? void 0 : _dom8.contains(previousActiveElementRef.value))
                  return;
                if ((_dom9 = dom(api.panel)) == null ? void 0 : _dom9.contains(previousActiveElementRef.value))
                  return;
                var focusableElements = getFocusableElements();
                var previousIdx = focusableElements.indexOf(previousActiveElementRef.value);
                var buttonIdx = focusableElements.indexOf(dom(api.button));
                if (buttonIdx > previousIdx)
                  return;
                event.preventDefault();
                event.stopPropagation();
                focusIn(dom(api.panel), Focus.Last);
              } else {
                event.preventDefault();
                event.stopPropagation();
                focusIn(dom(api.panel), Focus.First);
              }
              break;
          }
        }
      },
      handleKeyUp: function handleKeyUp(event) {
        var _dom10, _dom11;
        if (isWithinPanel)
          return;
        if (event.key === Keys.Space) {
          event.preventDefault();
        }
        if (api.popoverState.value !== PopoverStates.Open)
          return;
        if (!api.panel)
          return;
        if (!api.button)
          return;
        switch (event.key) {
          case Keys.Tab:
            if (!previousActiveElementRef.value)
              return;
            if ((_dom10 = dom(api.button)) == null ? void 0 : _dom10.contains(previousActiveElementRef.value))
              return;
            if ((_dom11 = dom(api.panel)) == null ? void 0 : _dom11.contains(previousActiveElementRef.value))
              return;
            var focusableElements = getFocusableElements();
            var previousIdx = focusableElements.indexOf(previousActiveElementRef.value);
            var buttonIdx = focusableElements.indexOf(dom(api.button));
            if (buttonIdx > previousIdx)
              return;
            event.preventDefault();
            event.stopPropagation();
            focusIn(dom(api.panel), Focus.Last);
            break;
        }
      },
      handleClick: function handleClick() {
        if (props.disabled)
          return;
        if (isWithinPanel) {
          var _dom12;
          api.closePopover();
          (_dom12 = dom(api.button)) == null ? void 0 : _dom12.focus();
        } else {
          var _dom13;
          if (api.popoverState.value === PopoverStates.Closed)
            closeOthers == null ? void 0 : closeOthers(api.buttonId);
          (_dom13 = dom(api.button)) == null ? void 0 : _dom13.focus();
          api.togglePopover();
        }
      },
      handleFocus: function handleFocus() {
      }
    };
  }
});
var PopoverPanel = /* @__PURE__ */ defineComponent({
  name: "PopoverPanel",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    },
    "static": {
      type: Boolean,
      "default": false
    },
    unmount: {
      type: Boolean,
      "default": true
    },
    focus: {
      type: Boolean,
      "default": false
    }
  },
  render: function render$119() {
    var api = usePopoverContext("PopoverPanel");
    var slot = {
      open: api.popoverState.value === PopoverStates.Open,
      close: api.close
    };
    var propsWeControl = {
      ref: "el",
      id: this.id,
      onKeydown: this.handleKeyDown
    };
    return render$X({
      props: _extends$1({}, this.$props, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      features: Features.RenderStrategy | Features.Static,
      visible: this.visible,
      name: "PopoverPanel"
    });
  },
  setup: function setup19(props) {
    var focus = props.focus;
    var api = usePopoverContext("PopoverPanel");
    provide(PopoverPanelContext, api.panelId);
    onUnmounted(function() {
      api.panel.value = null;
    });
    watchEffect(function() {
      var _dom14;
      if (!focus)
        return;
      if (api.popoverState.value !== PopoverStates.Open)
        return;
      if (!api.panel)
        return;
      var activeElement = document.activeElement;
      if ((_dom14 = dom(api.panel)) == null ? void 0 : _dom14.contains(activeElement))
        return;
      focusIn(dom(api.panel), Focus.First);
    });
    useWindowEvent("keydown", function(event) {
      var _dom15;
      if (api.popoverState.value !== PopoverStates.Open)
        return;
      if (!dom(api.panel))
        return;
      if (event.key !== Keys.Tab)
        return;
      if (!document.activeElement)
        return;
      if (!((_dom15 = dom(api.panel)) == null ? void 0 : _dom15.contains(document.activeElement)))
        return;
      event.preventDefault();
      var result = focusIn(dom(api.panel), event.shiftKey ? Focus.Previous : Focus.Next);
      if (result === FocusResult.Underflow) {
        var _dom16;
        return (_dom16 = dom(api.button)) == null ? void 0 : _dom16.focus();
      } else if (result === FocusResult.Overflow) {
        if (!dom(api.button))
          return;
        var elements = getFocusableElements();
        var buttonIdx = elements.indexOf(dom(api.button));
        var nextElements = elements.splice(buttonIdx + 1).filter(function(element) {
          var _dom17;
          return !((_dom17 = dom(api.panel)) == null ? void 0 : _dom17.contains(element));
        });
        if (focusIn(nextElements, Focus.First) === FocusResult.Error) {
          focusIn(document.body, Focus.First);
        }
      }
    });
    useWindowEvent("focus", function() {
      var _dom18;
      if (!focus)
        return;
      if (api.popoverState.value !== PopoverStates.Open)
        return;
      if (!dom(api.panel))
        return;
      if ((_dom18 = dom(api.panel)) == null ? void 0 : _dom18.contains(document.activeElement))
        return;
      api.closePopover();
    }, true);
    var usesOpenClosedState = useOpenClosed();
    var visible = computed(function() {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === State.Open;
      }
      return api.popoverState.value === PopoverStates.Open;
    });
    return {
      id: api.panelId,
      el: api.panel,
      handleKeyDown: function handleKeyDown(event) {
        var _dom19, _dom20;
        switch (event.key) {
          case Keys.Escape:
            if (api.popoverState.value !== PopoverStates.Open)
              return;
            if (!dom(api.panel))
              return;
            if (!((_dom19 = dom(api.panel)) == null ? void 0 : _dom19.contains(document.activeElement)))
              return;
            event.preventDefault();
            api.closePopover();
            (_dom20 = dom(api.button)) == null ? void 0 : _dom20.focus();
            break;
        }
      },
      visible
    };
  }
});
var LabelContext = /* @__PURE__ */ Symbol("LabelContext");
function useLabelContext() {
  var context = inject(LabelContext, null);
  if (context === null) {
    var err = new Error("You used a <Label /> component, but it is not inside a parent.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useLabelContext);
    throw err;
  }
  return context;
}
function useLabels(_temp) {
  var _ref = _temp === void 0 ? {} : _temp, _ref$slot = _ref.slot, slot = _ref$slot === void 0 ? {} : _ref$slot, _ref$name = _ref.name, name2 = _ref$name === void 0 ? "Label" : _ref$name, _ref$props = _ref.props, props = _ref$props === void 0 ? {} : _ref$props;
  var labelIds = ref([]);
  function register(value) {
    labelIds.value.push(value);
    return function() {
      var idx = labelIds.value.indexOf(value);
      if (idx === -1)
        return;
      labelIds.value.splice(idx, 1);
    };
  }
  provide(LabelContext, {
    register,
    slot,
    name: name2,
    props
  });
  return computed(function() {
    return labelIds.value.length > 0 ? labelIds.value.join(" ") : void 0;
  });
}
var Label = /* @__PURE__ */ defineComponent({
  name: "Label",
  props: {
    as: {
      type: [Object, String],
      "default": "label"
    },
    passive: {
      type: [Boolean],
      "default": false
    }
  },
  render: function render$120() {
    var _this$context = this.context, _this$context$name = _this$context.name, name2 = _this$context$name === void 0 ? "Label" : _this$context$name, _this$context$slot = _this$context.slot, slot = _this$context$slot === void 0 ? {} : _this$context$slot, _this$context$props = _this$context.props, props = _this$context$props === void 0 ? {} : _this$context$props;
    var _this$$props = this.$props, passive = _this$$props.passive, passThroughProps = _objectWithoutPropertiesLoose(_this$$props, ["passive"]);
    var propsWeControl = _extends$1({}, Object.entries(props).reduce(function(acc, _ref2) {
      var _Object$assign;
      var key = _ref2[0], value = _ref2[1];
      return Object.assign(acc, (_Object$assign = {}, _Object$assign[key] = unref(value), _Object$assign));
    }, {}), {
      id: this.id
    });
    var allProps = _extends$1({}, passThroughProps, propsWeControl);
    if (passive)
      delete allProps["onClick"];
    return render$X({
      props: allProps,
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      name: name2
    });
  },
  setup: function setup20() {
    var context = useLabelContext();
    var id2 = "headlessui-label-" + useId();
    onMounted(function() {
      return onUnmounted(context.register(id2));
    });
    return {
      id: id2,
      context
    };
  }
});
var RadioGroupContext = /* @__PURE__ */ Symbol("RadioGroupContext");
function useRadioGroupContext(component) {
  var context = inject(RadioGroupContext, null);
  if (context === null) {
    var err = new Error("<" + component + " /> is missing a parent <RadioGroup /> component.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useRadioGroupContext);
    throw err;
  }
  return context;
}
var RadioGroup = /* @__PURE__ */ defineComponent({
  name: "RadioGroup",
  emits: ["update:modelValue"],
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    },
    disabled: {
      type: [Boolean],
      "default": false
    },
    modelValue: {
      type: [Object, String, Number, Boolean]
    }
  },
  render: function render$121() {
    var _this$$props = this.$props, passThroughProps = _objectWithoutPropertiesLoose(_this$$props, ["modelValue", "disabled"]);
    var propsWeControl = {
      ref: "el",
      id: this.id,
      role: "radiogroup",
      "aria-labelledby": this.labelledby,
      "aria-describedby": this.describedby,
      onKeydown: this.handleKeyDown
    };
    return render$X({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot: {},
      attrs: this.$attrs,
      slots: this.$slots,
      name: "RadioGroup"
    });
  },
  setup: function setup21(props, _ref) {
    var emit = _ref.emit;
    var radioGroupRef = ref(null);
    var options2 = ref([]);
    var labelledby = useLabels({
      name: "RadioGroupLabel"
    });
    var describedby = useDescriptions({
      name: "RadioGroupDescription"
    });
    var value = computed(function() {
      return props.modelValue;
    });
    var api = {
      options: options2,
      value,
      disabled: computed(function() {
        return props.disabled;
      }),
      firstOption: computed(function() {
        return options2.value.find(function(option) {
          if (option.propsRef.disabled)
            return false;
          return true;
        });
      }),
      containsCheckedOption: computed(function() {
        return options2.value.some(function(option) {
          return toRaw(option.propsRef.value) === toRaw(props.modelValue);
        });
      }),
      change: function change(nextValue) {
        var _options$value$find;
        if (props.disabled)
          return false;
        if (value.value === nextValue)
          return false;
        var nextOption = (_options$value$find = options2.value.find(function(option) {
          return toRaw(option.propsRef.value) === toRaw(nextValue);
        })) == null ? void 0 : _options$value$find.propsRef;
        if (nextOption == null ? void 0 : nextOption.disabled)
          return false;
        emit("update:modelValue", nextValue);
        return true;
      },
      registerOption: function registerOption(action) {
        var _radioGroupRef$value;
        var orderMap = Array.from((_radioGroupRef$value = radioGroupRef.value) == null ? void 0 : _radioGroupRef$value.querySelectorAll('[id^="headlessui-radiogroup-option-"]')).reduce(function(lookup, element, index2) {
          var _Object$assign;
          return Object.assign(lookup, (_Object$assign = {}, _Object$assign[element.id] = index2, _Object$assign));
        }, {});
        options2.value.push(action);
        options2.value.sort(function(a2, z) {
          return orderMap[a2.id] - orderMap[z.id];
        });
      },
      unregisterOption: function unregisterOption(id3) {
        var idx = options2.value.findIndex(function(radio) {
          return radio.id === id3;
        });
        if (idx === -1)
          return;
        options2.value.splice(idx, 1);
      }
    };
    provide(RadioGroupContext, api);
    useTreeWalker({
      container: computed(function() {
        return dom(radioGroupRef);
      }),
      accept: function accept(node) {
        if (node.getAttribute("role") === "radio")
          return NodeFilter.FILTER_REJECT;
        if (node.hasAttribute("role"))
          return NodeFilter.FILTER_SKIP;
        return NodeFilter.FILTER_ACCEPT;
      },
      walk: function walk(node) {
        node.setAttribute("role", "none");
      }
    });
    function handleKeyDown(event) {
      if (!radioGroupRef.value)
        return;
      if (!radioGroupRef.value.contains(event.target))
        return;
      var all = options2.value.filter(function(option) {
        return option.propsRef.disabled === false;
      }).map(function(radio) {
        return radio.element;
      });
      switch (event.key) {
        case Keys.ArrowLeft:
        case Keys.ArrowUp:
          {
            event.preventDefault();
            event.stopPropagation();
            var result = focusIn(all, Focus.Previous | Focus.WrapAround);
            if (result === FocusResult.Success) {
              var activeOption = options2.value.find(function(option) {
                return option.element === document.activeElement;
              });
              if (activeOption)
                api.change(activeOption.propsRef.value);
            }
          }
          break;
        case Keys.ArrowRight:
        case Keys.ArrowDown:
          {
            event.preventDefault();
            event.stopPropagation();
            var _result = focusIn(all, Focus.Next | Focus.WrapAround);
            if (_result === FocusResult.Success) {
              var _activeOption = options2.value.find(function(option) {
                return option.element === document.activeElement;
              });
              if (_activeOption)
                api.change(_activeOption.propsRef.value);
            }
          }
          break;
        case Keys.Space:
          {
            event.preventDefault();
            event.stopPropagation();
            var _activeOption2 = options2.value.find(function(option) {
              return option.element === document.activeElement;
            });
            if (_activeOption2)
              api.change(_activeOption2.propsRef.value);
          }
          break;
      }
    }
    var id2 = "headlessui-radiogroup-" + useId();
    return {
      id: id2,
      labelledby,
      describedby,
      el: radioGroupRef,
      handleKeyDown
    };
  }
});
var OptionState;
(function(OptionState2) {
  OptionState2[OptionState2["Empty"] = 1] = "Empty";
  OptionState2[OptionState2["Active"] = 2] = "Active";
})(OptionState || (OptionState = {}));
var RadioGroupOption = /* @__PURE__ */ defineComponent({
  name: "RadioGroupOption",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    },
    value: {
      type: [Object, String, Number, Boolean]
    },
    disabled: {
      type: Boolean,
      "default": false
    }
  },
  render: function render$122() {
    var _this$$props2 = this.$props, passThroughProps = _objectWithoutPropertiesLoose(_this$$props2, ["value", "disabled"]);
    var slot = {
      checked: this.checked,
      disabled: this.disabled,
      active: Boolean(this.state & OptionState.Active)
    };
    var propsWeControl = {
      id: this.id,
      ref: "el",
      role: "radio",
      "aria-checked": this.checked ? "true" : "false",
      "aria-labelledby": this.labelledby,
      "aria-describedby": this.describedby,
      "aria-disabled": this.disabled ? true : void 0,
      tabIndex: this.tabIndex,
      onClick: this.disabled ? void 0 : this.handleClick,
      onFocus: this.disabled ? void 0 : this.handleFocus,
      onBlur: this.disabled ? void 0 : this.handleBlur
    };
    return render$X({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      name: "RadioGroupOption"
    });
  },
  setup: function setup22(props) {
    var api = useRadioGroupContext("RadioGroupOption");
    var id2 = "headlessui-radiogroup-option-" + useId();
    var labelledby = useLabels({
      name: "RadioGroupLabel"
    });
    var describedby = useDescriptions({
      name: "RadioGroupDescription"
    });
    var optionRef = ref(null);
    var propsRef = computed(function() {
      return {
        value: props.value,
        disabled: props.disabled
      };
    });
    var state = ref(OptionState.Empty);
    onMounted(function() {
      return api.registerOption({
        id: id2,
        element: optionRef,
        propsRef
      });
    });
    onUnmounted(function() {
      return api.unregisterOption(id2);
    });
    var isFirstOption = computed(function() {
      var _api$firstOption$valu;
      return ((_api$firstOption$valu = api.firstOption.value) == null ? void 0 : _api$firstOption$valu.id) === id2;
    });
    var disabled = computed(function() {
      return api.disabled.value || props.disabled;
    });
    var checked = computed(function() {
      return toRaw(api.value.value) === toRaw(props.value);
    });
    return {
      id: id2,
      el: optionRef,
      labelledby,
      describedby,
      state,
      disabled,
      checked,
      tabIndex: computed(function() {
        if (disabled.value)
          return -1;
        if (checked.value)
          return 0;
        if (!api.containsCheckedOption.value && isFirstOption.value)
          return 0;
        return -1;
      }),
      handleClick: function handleClick() {
        var _optionRef$value;
        if (!api.change(props.value))
          return;
        state.value |= OptionState.Active;
        (_optionRef$value = optionRef.value) == null ? void 0 : _optionRef$value.focus();
      },
      handleFocus: function handleFocus() {
        state.value |= OptionState.Active;
      },
      handleBlur: function handleBlur() {
        state.value &= ~OptionState.Active;
      }
    };
  }
});
var RadioGroupLabel = Label;
var Reason;
(function(Reason2) {
  Reason2["Finished"] = "finished";
  Reason2["Cancelled"] = "cancelled";
})(Reason || (Reason = {}));
var TreeStates;
(function(TreeStates2) {
  TreeStates2["Visible"] = "visible";
  TreeStates2["Hidden"] = "hidden";
})(TreeStates || (TreeStates = {}));
Features.RenderStrategy;
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x2) {
  return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
}
function getAugmentedNamespace(n) {
  var f2 = n.default;
  if (typeof f2 == "function") {
    var a2 = function a3() {
      if (this instanceof a3) {
        var args = [null];
        args.push.apply(args, arguments);
        var Ctor = Function.bind.apply(f2, args);
        return new Ctor();
      }
      return f2.apply(this, arguments);
    };
    a2.prototype = f2.prototype;
  } else
    a2 = {};
  Object.defineProperty(a2, "__esModule", { value: true });
  Object.keys(n).forEach(function(k) {
    var d2 = Object.getOwnPropertyDescriptor(n, k);
    Object.defineProperty(a2, k, d2.get ? d2 : {
      enumerable: true,
      get: function() {
        return n[k];
      }
    });
  });
  return a2;
}
var lodash = { exports: {} };
(function(module, exports) {
  (function() {
    var undefined$1;
    var VERSION2 = "4.17.21";
    var LARGE_ARRAY_SIZE = 200;
    var CORE_ERROR_TEXT = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.", FUNC_ERROR_TEXT = "Expected a function", INVALID_TEMPL_VAR_ERROR_TEXT = "Invalid `variable` option passed into `_.template`";
    var HASH_UNDEFINED = "__lodash_hash_undefined__";
    var MAX_MEMOIZE_SIZE = 500;
    var PLACEHOLDER = "__lodash_placeholder__";
    var CLONE_DEEP_FLAG = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG = 4;
    var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
    var WRAP_BIND_FLAG = 1, WRAP_BIND_KEY_FLAG = 2, WRAP_CURRY_BOUND_FLAG = 4, WRAP_CURRY_FLAG = 8, WRAP_CURRY_RIGHT_FLAG = 16, WRAP_PARTIAL_FLAG = 32, WRAP_PARTIAL_RIGHT_FLAG = 64, WRAP_ARY_FLAG = 128, WRAP_REARG_FLAG = 256, WRAP_FLIP_FLAG = 512;
    var DEFAULT_TRUNC_LENGTH = 30, DEFAULT_TRUNC_OMISSION = "...";
    var HOT_COUNT = 800, HOT_SPAN = 16;
    var LAZY_FILTER_FLAG = 1, LAZY_MAP_FLAG = 2, LAZY_WHILE_FLAG = 3;
    var INFINITY = 1 / 0, MAX_SAFE_INTEGER = 9007199254740991, MAX_INTEGER = 17976931348623157e292, NAN = 0 / 0;
    var MAX_ARRAY_LENGTH2 = 4294967295, MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH2 - 1, HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH2 >>> 1;
    var wrapFlags = [
      ["ary", WRAP_ARY_FLAG],
      ["bind", WRAP_BIND_FLAG],
      ["bindKey", WRAP_BIND_KEY_FLAG],
      ["curry", WRAP_CURRY_FLAG],
      ["curryRight", WRAP_CURRY_RIGHT_FLAG],
      ["flip", WRAP_FLIP_FLAG],
      ["partial", WRAP_PARTIAL_FLAG],
      ["partialRight", WRAP_PARTIAL_RIGHT_FLAG],
      ["rearg", WRAP_REARG_FLAG]
    ];
    var argsTag = "[object Arguments]", arrayTag = "[object Array]", asyncTag = "[object AsyncFunction]", boolTag = "[object Boolean]", dateTag = "[object Date]", domExcTag = "[object DOMException]", errorTag = "[object Error]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", mapTag = "[object Map]", numberTag = "[object Number]", nullTag = "[object Null]", objectTag = "[object Object]", promiseTag = "[object Promise]", proxyTag = "[object Proxy]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", symbolTag = "[object Symbol]", undefinedTag = "[object Undefined]", weakMapTag = "[object WeakMap]", weakSetTag = "[object WeakSet]";
    var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
    var reEmptyStringLeading = /\b__p \+= '';/g, reEmptyStringMiddle = /\b(__p \+=) '' \+/g, reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
    var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g, reUnescapedHtml = /[&<>"']/g, reHasEscapedHtml = RegExp(reEscapedHtml.source), reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
    var reEscape = /<%-([\s\S]+?)%>/g, reEvaluate = /<%([\s\S]+?)%>/g, reInterpolate = /<%=([\s\S]+?)%>/g;
    var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/, rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g, reHasRegExpChar = RegExp(reRegExpChar.source);
    var reTrimStart = /^\s+/;
    var reWhitespace = /\s/;
    var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/, reSplitDetails = /,? & /;
    var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
    var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
    var reEscapeChar = /\\(\\)?/g;
    var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
    var reFlags = /\w*$/;
    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
    var reIsBinary = /^0b[01]+$/i;
    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    var reIsOctal = /^0o[0-7]+$/i;
    var reIsUint = /^(?:0|[1-9]\d*)$/;
    var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
    var reNoMatch = /($^)/;
    var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
    var rsAstralRange = "\\ud800-\\udfff", rsComboMarksRange = "\\u0300-\\u036f", reComboHalfMarksRange = "\\ufe20-\\ufe2f", rsComboSymbolsRange = "\\u20d0-\\u20ff", rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange, rsDingbatRange = "\\u2700-\\u27bf", rsLowerRange = "a-z\\xdf-\\xf6\\xf8-\\xff", rsMathOpRange = "\\xac\\xb1\\xd7\\xf7", rsNonCharRange = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", rsPunctuationRange = "\\u2000-\\u206f", rsSpaceRange = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", rsUpperRange = "A-Z\\xc0-\\xd6\\xd8-\\xde", rsVarRange = "\\ufe0e\\ufe0f", rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
    var rsApos = "['’]", rsAstral = "[" + rsAstralRange + "]", rsBreak = "[" + rsBreakRange + "]", rsCombo = "[" + rsComboRange + "]", rsDigits = "\\d+", rsDingbat = "[" + rsDingbatRange + "]", rsLower = "[" + rsLowerRange + "]", rsMisc = "[^" + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + "]", rsFitz = "\\ud83c[\\udffb-\\udfff]", rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")", rsNonAstral = "[^" + rsAstralRange + "]", rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}", rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]", rsUpper = "[" + rsUpperRange + "]", rsZWJ = "\\u200d";
    var rsMiscLower = "(?:" + rsLower + "|" + rsMisc + ")", rsMiscUpper = "(?:" + rsUpper + "|" + rsMisc + ")", rsOptContrLower = "(?:" + rsApos + "(?:d|ll|m|re|s|t|ve))?", rsOptContrUpper = "(?:" + rsApos + "(?:D|LL|M|RE|S|T|VE))?", reOptMod = rsModifier + "?", rsOptVar = "[" + rsVarRange + "]?", rsOptJoin = "(?:" + rsZWJ + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*", rsOrdLower = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", rsOrdUpper = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", rsSeq = rsOptVar + reOptMod + rsOptJoin, rsEmoji = "(?:" + [rsDingbat, rsRegional, rsSurrPair].join("|") + ")" + rsSeq, rsSymbol = "(?:" + [rsNonAstral + rsCombo + "?", rsCombo, rsRegional, rsSurrPair, rsAstral].join("|") + ")";
    var reApos = RegExp(rsApos, "g");
    var reComboMark = RegExp(rsCombo, "g");
    var reUnicode = RegExp(rsFitz + "(?=" + rsFitz + ")|" + rsSymbol + rsSeq, "g");
    var reUnicodeWord = RegExp([
      rsUpper + "?" + rsLower + "+" + rsOptContrLower + "(?=" + [rsBreak, rsUpper, "$"].join("|") + ")",
      rsMiscUpper + "+" + rsOptContrUpper + "(?=" + [rsBreak, rsUpper + rsMiscLower, "$"].join("|") + ")",
      rsUpper + "?" + rsMiscLower + "+" + rsOptContrLower,
      rsUpper + "+" + rsOptContrUpper,
      rsOrdUpper,
      rsOrdLower,
      rsDigits,
      rsEmoji
    ].join("|"), "g");
    var reHasUnicode = RegExp("[" + rsZWJ + rsAstralRange + rsComboRange + rsVarRange + "]");
    var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
    var contextProps = [
      "Array",
      "Buffer",
      "DataView",
      "Date",
      "Error",
      "Float32Array",
      "Float64Array",
      "Function",
      "Int8Array",
      "Int16Array",
      "Int32Array",
      "Map",
      "Math",
      "Object",
      "Promise",
      "RegExp",
      "Set",
      "String",
      "Symbol",
      "TypeError",
      "Uint8Array",
      "Uint8ClampedArray",
      "Uint16Array",
      "Uint32Array",
      "WeakMap",
      "_",
      "clearTimeout",
      "isFinite",
      "parseInt",
      "setTimeout"
    ];
    var templateCounter = -1;
    var typedArrayTags = {};
    typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
    typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
    var cloneableTags = {};
    cloneableTags[argsTag] = cloneableTags[arrayTag] = cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] = cloneableTags[boolTag] = cloneableTags[dateTag] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[mapTag] = cloneableTags[numberTag] = cloneableTags[objectTag] = cloneableTags[regexpTag] = cloneableTags[setTag] = cloneableTags[stringTag] = cloneableTags[symbolTag] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
    cloneableTags[errorTag] = cloneableTags[funcTag] = cloneableTags[weakMapTag] = false;
    var deburredLetters = {
      "À": "A",
      "Á": "A",
      "Â": "A",
      "Ã": "A",
      "Ä": "A",
      "Å": "A",
      "à": "a",
      "á": "a",
      "â": "a",
      "ã": "a",
      "ä": "a",
      "å": "a",
      "Ç": "C",
      "ç": "c",
      "Ð": "D",
      "ð": "d",
      "È": "E",
      "É": "E",
      "Ê": "E",
      "Ë": "E",
      "è": "e",
      "é": "e",
      "ê": "e",
      "ë": "e",
      "Ì": "I",
      "Í": "I",
      "Î": "I",
      "Ï": "I",
      "ì": "i",
      "í": "i",
      "î": "i",
      "ï": "i",
      "Ñ": "N",
      "ñ": "n",
      "Ò": "O",
      "Ó": "O",
      "Ô": "O",
      "Õ": "O",
      "Ö": "O",
      "Ø": "O",
      "ò": "o",
      "ó": "o",
      "ô": "o",
      "õ": "o",
      "ö": "o",
      "ø": "o",
      "Ù": "U",
      "Ú": "U",
      "Û": "U",
      "Ü": "U",
      "ù": "u",
      "ú": "u",
      "û": "u",
      "ü": "u",
      "Ý": "Y",
      "ý": "y",
      "ÿ": "y",
      "Æ": "Ae",
      "æ": "ae",
      "Þ": "Th",
      "þ": "th",
      "ß": "ss",
      "Ā": "A",
      "Ă": "A",
      "Ą": "A",
      "ā": "a",
      "ă": "a",
      "ą": "a",
      "Ć": "C",
      "Ĉ": "C",
      "Ċ": "C",
      "Č": "C",
      "ć": "c",
      "ĉ": "c",
      "ċ": "c",
      "č": "c",
      "Ď": "D",
      "Đ": "D",
      "ď": "d",
      "đ": "d",
      "Ē": "E",
      "Ĕ": "E",
      "Ė": "E",
      "Ę": "E",
      "Ě": "E",
      "ē": "e",
      "ĕ": "e",
      "ė": "e",
      "ę": "e",
      "ě": "e",
      "Ĝ": "G",
      "Ğ": "G",
      "Ġ": "G",
      "Ģ": "G",
      "ĝ": "g",
      "ğ": "g",
      "ġ": "g",
      "ģ": "g",
      "Ĥ": "H",
      "Ħ": "H",
      "ĥ": "h",
      "ħ": "h",
      "Ĩ": "I",
      "Ī": "I",
      "Ĭ": "I",
      "Į": "I",
      "İ": "I",
      "ĩ": "i",
      "ī": "i",
      "ĭ": "i",
      "į": "i",
      "ı": "i",
      "Ĵ": "J",
      "ĵ": "j",
      "Ķ": "K",
      "ķ": "k",
      "ĸ": "k",
      "Ĺ": "L",
      "Ļ": "L",
      "Ľ": "L",
      "Ŀ": "L",
      "Ł": "L",
      "ĺ": "l",
      "ļ": "l",
      "ľ": "l",
      "ŀ": "l",
      "ł": "l",
      "Ń": "N",
      "Ņ": "N",
      "Ň": "N",
      "Ŋ": "N",
      "ń": "n",
      "ņ": "n",
      "ň": "n",
      "ŋ": "n",
      "Ō": "O",
      "Ŏ": "O",
      "Ő": "O",
      "ō": "o",
      "ŏ": "o",
      "ő": "o",
      "Ŕ": "R",
      "Ŗ": "R",
      "Ř": "R",
      "ŕ": "r",
      "ŗ": "r",
      "ř": "r",
      "Ś": "S",
      "Ŝ": "S",
      "Ş": "S",
      "Š": "S",
      "ś": "s",
      "ŝ": "s",
      "ş": "s",
      "š": "s",
      "Ţ": "T",
      "Ť": "T",
      "Ŧ": "T",
      "ţ": "t",
      "ť": "t",
      "ŧ": "t",
      "Ũ": "U",
      "Ū": "U",
      "Ŭ": "U",
      "Ů": "U",
      "Ű": "U",
      "Ų": "U",
      "ũ": "u",
      "ū": "u",
      "ŭ": "u",
      "ů": "u",
      "ű": "u",
      "ų": "u",
      "Ŵ": "W",
      "ŵ": "w",
      "Ŷ": "Y",
      "ŷ": "y",
      "Ÿ": "Y",
      "Ź": "Z",
      "Ż": "Z",
      "Ž": "Z",
      "ź": "z",
      "ż": "z",
      "ž": "z",
      "Ĳ": "IJ",
      "ĳ": "ij",
      "Œ": "Oe",
      "œ": "oe",
      "ŉ": "'n",
      "ſ": "s"
    };
    var htmlEscapes2 = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#39;"
    };
    var htmlUnescapes = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#39;": "'"
    };
    var stringEscapes = {
      "\\": "\\",
      "'": "'",
      "\n": "n",
      "\r": "r",
      "\u2028": "u2028",
      "\u2029": "u2029"
    };
    var freeParseFloat = parseFloat, freeParseInt = parseInt;
    var freeGlobal = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root = freeGlobal || freeSelf || Function("return this")();
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule = freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && freeGlobal.process;
    var nodeUtil = function() {
      try {
        var types = freeModule && freeModule.require && freeModule.require("util").types;
        if (types) {
          return types;
        }
        return freeProcess && freeProcess.binding && freeProcess.binding("util");
      } catch (e) {
      }
    }();
    var nodeIsArrayBuffer = nodeUtil && nodeUtil.isArrayBuffer, nodeIsDate = nodeUtil && nodeUtil.isDate, nodeIsMap = nodeUtil && nodeUtil.isMap, nodeIsRegExp = nodeUtil && nodeUtil.isRegExp, nodeIsSet = nodeUtil && nodeUtil.isSet, nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
    function apply2(func, thisArg, args) {
      switch (args.length) {
        case 0:
          return func.call(thisArg);
        case 1:
          return func.call(thisArg, args[0]);
        case 2:
          return func.call(thisArg, args[0], args[1]);
        case 3:
          return func.call(thisArg, args[0], args[1], args[2]);
      }
      return func.apply(thisArg, args);
    }
    function arrayAggregator(array, setter, iteratee, accumulator) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      while (++index2 < length2) {
        var value = array[index2];
        setter(accumulator, value, iteratee(value), array);
      }
      return accumulator;
    }
    function arrayEach(array, iteratee) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      while (++index2 < length2) {
        if (iteratee(array[index2], index2, array) === false) {
          break;
        }
      }
      return array;
    }
    function arrayEachRight(array, iteratee) {
      var length2 = array == null ? 0 : array.length;
      while (length2--) {
        if (iteratee(array[length2], length2, array) === false) {
          break;
        }
      }
      return array;
    }
    function arrayEvery(array, predicate) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      while (++index2 < length2) {
        if (!predicate(array[index2], index2, array)) {
          return false;
        }
      }
      return true;
    }
    function arrayFilter(array, predicate) {
      var index2 = -1, length2 = array == null ? 0 : array.length, resIndex = 0, result = [];
      while (++index2 < length2) {
        var value = array[index2];
        if (predicate(value, index2, array)) {
          result[resIndex++] = value;
        }
      }
      return result;
    }
    function arrayIncludes(array, value) {
      var length2 = array == null ? 0 : array.length;
      return !!length2 && baseIndexOf(array, value, 0) > -1;
    }
    function arrayIncludesWith(array, value, comparator) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      while (++index2 < length2) {
        if (comparator(value, array[index2])) {
          return true;
        }
      }
      return false;
    }
    function arrayMap(array, iteratee) {
      var index2 = -1, length2 = array == null ? 0 : array.length, result = Array(length2);
      while (++index2 < length2) {
        result[index2] = iteratee(array[index2], index2, array);
      }
      return result;
    }
    function arrayPush(array, values) {
      var index2 = -1, length2 = values.length, offset2 = array.length;
      while (++index2 < length2) {
        array[offset2 + index2] = values[index2];
      }
      return array;
    }
    function arrayReduce(array, iteratee, accumulator, initAccum) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      if (initAccum && length2) {
        accumulator = array[++index2];
      }
      while (++index2 < length2) {
        accumulator = iteratee(accumulator, array[index2], index2, array);
      }
      return accumulator;
    }
    function arrayReduceRight(array, iteratee, accumulator, initAccum) {
      var length2 = array == null ? 0 : array.length;
      if (initAccum && length2) {
        accumulator = array[--length2];
      }
      while (length2--) {
        accumulator = iteratee(accumulator, array[length2], length2, array);
      }
      return accumulator;
    }
    function arraySome(array, predicate) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      while (++index2 < length2) {
        if (predicate(array[index2], index2, array)) {
          return true;
        }
      }
      return false;
    }
    var asciiSize = baseProperty("length");
    function asciiToArray(string) {
      return string.split("");
    }
    function asciiWords(string) {
      return string.match(reAsciiWord) || [];
    }
    function baseFindKey(collection, predicate, eachFunc) {
      var result;
      eachFunc(collection, function(value, key, collection2) {
        if (predicate(value, key, collection2)) {
          result = key;
          return false;
        }
      });
      return result;
    }
    function baseFindIndex(array, predicate, fromIndex, fromRight) {
      var length2 = array.length, index2 = fromIndex + (fromRight ? 1 : -1);
      while (fromRight ? index2-- : ++index2 < length2) {
        if (predicate(array[index2], index2, array)) {
          return index2;
        }
      }
      return -1;
    }
    function baseIndexOf(array, value, fromIndex) {
      return value === value ? strictIndexOf(array, value, fromIndex) : baseFindIndex(array, baseIsNaN, fromIndex);
    }
    function baseIndexOfWith(array, value, fromIndex, comparator) {
      var index2 = fromIndex - 1, length2 = array.length;
      while (++index2 < length2) {
        if (comparator(array[index2], value)) {
          return index2;
        }
      }
      return -1;
    }
    function baseIsNaN(value) {
      return value !== value;
    }
    function baseMean(array, iteratee) {
      var length2 = array == null ? 0 : array.length;
      return length2 ? baseSum(array, iteratee) / length2 : NAN;
    }
    function baseProperty(key) {
      return function(object) {
        return object == null ? undefined$1 : object[key];
      };
    }
    function basePropertyOf(object) {
      return function(key) {
        return object == null ? undefined$1 : object[key];
      };
    }
    function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
      eachFunc(collection, function(value, index2, collection2) {
        accumulator = initAccum ? (initAccum = false, value) : iteratee(accumulator, value, index2, collection2);
      });
      return accumulator;
    }
    function baseSortBy(array, comparer) {
      var length2 = array.length;
      array.sort(comparer);
      while (length2--) {
        array[length2] = array[length2].value;
      }
      return array;
    }
    function baseSum(array, iteratee) {
      var result, index2 = -1, length2 = array.length;
      while (++index2 < length2) {
        var current = iteratee(array[index2]);
        if (current !== undefined$1) {
          result = result === undefined$1 ? current : result + current;
        }
      }
      return result;
    }
    function baseTimes(n, iteratee) {
      var index2 = -1, result = Array(n);
      while (++index2 < n) {
        result[index2] = iteratee(index2);
      }
      return result;
    }
    function baseToPairs(object, props) {
      return arrayMap(props, function(key) {
        return [key, object[key]];
      });
    }
    function baseTrim(string) {
      return string ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, "") : string;
    }
    function baseUnary(func) {
      return function(value) {
        return func(value);
      };
    }
    function baseValues(object, props) {
      return arrayMap(props, function(key) {
        return object[key];
      });
    }
    function cacheHas(cache2, key) {
      return cache2.has(key);
    }
    function charsStartIndex(strSymbols, chrSymbols) {
      var index2 = -1, length2 = strSymbols.length;
      while (++index2 < length2 && baseIndexOf(chrSymbols, strSymbols[index2], 0) > -1) {
      }
      return index2;
    }
    function charsEndIndex(strSymbols, chrSymbols) {
      var index2 = strSymbols.length;
      while (index2-- && baseIndexOf(chrSymbols, strSymbols[index2], 0) > -1) {
      }
      return index2;
    }
    function countHolders(array, placeholder) {
      var length2 = array.length, result = 0;
      while (length2--) {
        if (array[length2] === placeholder) {
          ++result;
        }
      }
      return result;
    }
    var deburrLetter = basePropertyOf(deburredLetters);
    var escapeHtmlChar = basePropertyOf(htmlEscapes2);
    function escapeStringChar(chr) {
      return "\\" + stringEscapes[chr];
    }
    function getValue2(object, key) {
      return object == null ? undefined$1 : object[key];
    }
    function hasUnicode(string) {
      return reHasUnicode.test(string);
    }
    function hasUnicodeWord(string) {
      return reHasUnicodeWord.test(string);
    }
    function iteratorToArray(iterator2) {
      var data, result = [];
      while (!(data = iterator2.next()).done) {
        result.push(data.value);
      }
      return result;
    }
    function mapToArray(map2) {
      var index2 = -1, result = Array(map2.size);
      map2.forEach(function(value, key) {
        result[++index2] = [key, value];
      });
      return result;
    }
    function overArg(func, transform) {
      return function(arg) {
        return func(transform(arg));
      };
    }
    function replaceHolders(array, placeholder) {
      var index2 = -1, length2 = array.length, resIndex = 0, result = [];
      while (++index2 < length2) {
        var value = array[index2];
        if (value === placeholder || value === PLACEHOLDER) {
          array[index2] = PLACEHOLDER;
          result[resIndex++] = index2;
        }
      }
      return result;
    }
    function setToArray(set3) {
      var index2 = -1, result = Array(set3.size);
      set3.forEach(function(value) {
        result[++index2] = value;
      });
      return result;
    }
    function setToPairs(set3) {
      var index2 = -1, result = Array(set3.size);
      set3.forEach(function(value) {
        result[++index2] = [value, value];
      });
      return result;
    }
    function strictIndexOf(array, value, fromIndex) {
      var index2 = fromIndex - 1, length2 = array.length;
      while (++index2 < length2) {
        if (array[index2] === value) {
          return index2;
        }
      }
      return -1;
    }
    function strictLastIndexOf(array, value, fromIndex) {
      var index2 = fromIndex + 1;
      while (index2--) {
        if (array[index2] === value) {
          return index2;
        }
      }
      return index2;
    }
    function stringSize(string) {
      return hasUnicode(string) ? unicodeSize(string) : asciiSize(string);
    }
    function stringToArray(string) {
      return hasUnicode(string) ? unicodeToArray(string) : asciiToArray(string);
    }
    function trimmedEndIndex(string) {
      var index2 = string.length;
      while (index2-- && reWhitespace.test(string.charAt(index2))) {
      }
      return index2;
    }
    var unescapeHtmlChar = basePropertyOf(htmlUnescapes);
    function unicodeSize(string) {
      var result = reUnicode.lastIndex = 0;
      while (reUnicode.test(string)) {
        ++result;
      }
      return result;
    }
    function unicodeToArray(string) {
      return string.match(reUnicode) || [];
    }
    function unicodeWords(string) {
      return string.match(reUnicodeWord) || [];
    }
    var runInContext = function runInContext2(context) {
      context = context == null ? root : _2.defaults(root.Object(), context, _2.pick(root, contextProps));
      var Array2 = context.Array, Date2 = context.Date, Error2 = context.Error, Function2 = context.Function, Math2 = context.Math, Object2 = context.Object, RegExp2 = context.RegExp, String2 = context.String, TypeError2 = context.TypeError;
      var arrayProto = Array2.prototype, funcProto = Function2.prototype, objectProto = Object2.prototype;
      var coreJsData = context["__core-js_shared__"];
      var funcToString = funcProto.toString;
      var hasOwnProperty2 = objectProto.hasOwnProperty;
      var idCounter = 0;
      var maskSrcKey = function() {
        var uid2 = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
        return uid2 ? "Symbol(src)_1." + uid2 : "";
      }();
      var nativeObjectToString = objectProto.toString;
      var objectCtorString = funcToString.call(Object2);
      var oldDash = root._;
      var reIsNative = RegExp2(
        "^" + funcToString.call(hasOwnProperty2).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
      );
      var Buffer2 = moduleExports ? context.Buffer : undefined$1, Symbol2 = context.Symbol, Uint8Array2 = context.Uint8Array, allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : undefined$1, getPrototype = overArg(Object2.getPrototypeOf, Object2), objectCreate = Object2.create, propertyIsEnumerable = objectProto.propertyIsEnumerable, splice = arrayProto.splice, spreadableSymbol = Symbol2 ? Symbol2.isConcatSpreadable : undefined$1, symIterator = Symbol2 ? Symbol2.iterator : undefined$1, symToStringTag = Symbol2 ? Symbol2.toStringTag : undefined$1;
      var defineProperty = function() {
        try {
          var func = getNative(Object2, "defineProperty");
          func({}, "", {});
          return func;
        } catch (e) {
        }
      }();
      var ctxClearTimeout = context.clearTimeout !== root.clearTimeout && context.clearTimeout, ctxNow = Date2 && Date2.now !== root.Date.now && Date2.now, ctxSetTimeout = context.setTimeout !== root.setTimeout && context.setTimeout;
      var nativeCeil = Math2.ceil, nativeFloor = Math2.floor, nativeGetSymbols = Object2.getOwnPropertySymbols, nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : undefined$1, nativeIsFinite = context.isFinite, nativeJoin = arrayProto.join, nativeKeys = overArg(Object2.keys, Object2), nativeMax = Math2.max, nativeMin = Math2.min, nativeNow = Date2.now, nativeParseInt = context.parseInt, nativeRandom = Math2.random, nativeReverse = arrayProto.reverse;
      var DataView = getNative(context, "DataView"), Map2 = getNative(context, "Map"), Promise2 = getNative(context, "Promise"), Set2 = getNative(context, "Set"), WeakMap2 = getNative(context, "WeakMap"), nativeCreate = getNative(Object2, "create");
      var metaMap = WeakMap2 && new WeakMap2();
      var realNames = {};
      var dataViewCtorString = toSource(DataView), mapCtorString = toSource(Map2), promiseCtorString = toSource(Promise2), setCtorString = toSource(Set2), weakMapCtorString = toSource(WeakMap2);
      var symbolProto = Symbol2 ? Symbol2.prototype : undefined$1, symbolValueOf = symbolProto ? symbolProto.valueOf : undefined$1, symbolToString = symbolProto ? symbolProto.toString : undefined$1;
      function lodash2(value) {
        if (isObjectLike2(value) && !isArray2(value) && !(value instanceof LazyWrapper)) {
          if (value instanceof LodashWrapper) {
            return value;
          }
          if (hasOwnProperty2.call(value, "__wrapped__")) {
            return wrapperClone(value);
          }
        }
        return new LodashWrapper(value);
      }
      var baseCreate = function() {
        function object() {
        }
        return function(proto2) {
          if (!isObject2(proto2)) {
            return {};
          }
          if (objectCreate) {
            return objectCreate(proto2);
          }
          object.prototype = proto2;
          var result2 = new object();
          object.prototype = undefined$1;
          return result2;
        };
      }();
      function baseLodash() {
      }
      function LodashWrapper(value, chainAll) {
        this.__wrapped__ = value;
        this.__actions__ = [];
        this.__chain__ = !!chainAll;
        this.__index__ = 0;
        this.__values__ = undefined$1;
      }
      lodash2.templateSettings = {
        "escape": reEscape,
        "evaluate": reEvaluate,
        "interpolate": reInterpolate,
        "variable": "",
        "imports": {
          "_": lodash2
        }
      };
      lodash2.prototype = baseLodash.prototype;
      lodash2.prototype.constructor = lodash2;
      LodashWrapper.prototype = baseCreate(baseLodash.prototype);
      LodashWrapper.prototype.constructor = LodashWrapper;
      function LazyWrapper(value) {
        this.__wrapped__ = value;
        this.__actions__ = [];
        this.__dir__ = 1;
        this.__filtered__ = false;
        this.__iteratees__ = [];
        this.__takeCount__ = MAX_ARRAY_LENGTH2;
        this.__views__ = [];
      }
      function lazyClone() {
        var result2 = new LazyWrapper(this.__wrapped__);
        result2.__actions__ = copyArray(this.__actions__);
        result2.__dir__ = this.__dir__;
        result2.__filtered__ = this.__filtered__;
        result2.__iteratees__ = copyArray(this.__iteratees__);
        result2.__takeCount__ = this.__takeCount__;
        result2.__views__ = copyArray(this.__views__);
        return result2;
      }
      function lazyReverse() {
        if (this.__filtered__) {
          var result2 = new LazyWrapper(this);
          result2.__dir__ = -1;
          result2.__filtered__ = true;
        } else {
          result2 = this.clone();
          result2.__dir__ *= -1;
        }
        return result2;
      }
      function lazyValue() {
        var array = this.__wrapped__.value(), dir = this.__dir__, isArr = isArray2(array), isRight = dir < 0, arrLength = isArr ? array.length : 0, view = getView(0, arrLength, this.__views__), start = view.start, end = view.end, length2 = end - start, index2 = isRight ? end : start - 1, iteratees = this.__iteratees__, iterLength = iteratees.length, resIndex = 0, takeCount = nativeMin(length2, this.__takeCount__);
        if (!isArr || !isRight && arrLength == length2 && takeCount == length2) {
          return baseWrapperValue(array, this.__actions__);
        }
        var result2 = [];
        outer:
          while (length2-- && resIndex < takeCount) {
            index2 += dir;
            var iterIndex = -1, value = array[index2];
            while (++iterIndex < iterLength) {
              var data = iteratees[iterIndex], iteratee2 = data.iteratee, type2 = data.type, computed2 = iteratee2(value);
              if (type2 == LAZY_MAP_FLAG) {
                value = computed2;
              } else if (!computed2) {
                if (type2 == LAZY_FILTER_FLAG) {
                  continue outer;
                } else {
                  break outer;
                }
              }
            }
            result2[resIndex++] = value;
          }
        return result2;
      }
      LazyWrapper.prototype = baseCreate(baseLodash.prototype);
      LazyWrapper.prototype.constructor = LazyWrapper;
      function Hash(entries) {
        var index2 = -1, length2 = entries == null ? 0 : entries.length;
        this.clear();
        while (++index2 < length2) {
          var entry = entries[index2];
          this.set(entry[0], entry[1]);
        }
      }
      function hashClear() {
        this.__data__ = nativeCreate ? nativeCreate(null) : {};
        this.size = 0;
      }
      function hashDelete(key) {
        var result2 = this.has(key) && delete this.__data__[key];
        this.size -= result2 ? 1 : 0;
        return result2;
      }
      function hashGet(key) {
        var data = this.__data__;
        if (nativeCreate) {
          var result2 = data[key];
          return result2 === HASH_UNDEFINED ? undefined$1 : result2;
        }
        return hasOwnProperty2.call(data, key) ? data[key] : undefined$1;
      }
      function hashHas(key) {
        var data = this.__data__;
        return nativeCreate ? data[key] !== undefined$1 : hasOwnProperty2.call(data, key);
      }
      function hashSet(key, value) {
        var data = this.__data__;
        this.size += this.has(key) ? 0 : 1;
        data[key] = nativeCreate && value === undefined$1 ? HASH_UNDEFINED : value;
        return this;
      }
      Hash.prototype.clear = hashClear;
      Hash.prototype["delete"] = hashDelete;
      Hash.prototype.get = hashGet;
      Hash.prototype.has = hashHas;
      Hash.prototype.set = hashSet;
      function ListCache(entries) {
        var index2 = -1, length2 = entries == null ? 0 : entries.length;
        this.clear();
        while (++index2 < length2) {
          var entry = entries[index2];
          this.set(entry[0], entry[1]);
        }
      }
      function listCacheClear() {
        this.__data__ = [];
        this.size = 0;
      }
      function listCacheDelete(key) {
        var data = this.__data__, index2 = assocIndexOf(data, key);
        if (index2 < 0) {
          return false;
        }
        var lastIndex = data.length - 1;
        if (index2 == lastIndex) {
          data.pop();
        } else {
          splice.call(data, index2, 1);
        }
        --this.size;
        return true;
      }
      function listCacheGet(key) {
        var data = this.__data__, index2 = assocIndexOf(data, key);
        return index2 < 0 ? undefined$1 : data[index2][1];
      }
      function listCacheHas(key) {
        return assocIndexOf(this.__data__, key) > -1;
      }
      function listCacheSet(key, value) {
        var data = this.__data__, index2 = assocIndexOf(data, key);
        if (index2 < 0) {
          ++this.size;
          data.push([key, value]);
        } else {
          data[index2][1] = value;
        }
        return this;
      }
      ListCache.prototype.clear = listCacheClear;
      ListCache.prototype["delete"] = listCacheDelete;
      ListCache.prototype.get = listCacheGet;
      ListCache.prototype.has = listCacheHas;
      ListCache.prototype.set = listCacheSet;
      function MapCache(entries) {
        var index2 = -1, length2 = entries == null ? 0 : entries.length;
        this.clear();
        while (++index2 < length2) {
          var entry = entries[index2];
          this.set(entry[0], entry[1]);
        }
      }
      function mapCacheClear() {
        this.size = 0;
        this.__data__ = {
          "hash": new Hash(),
          "map": new (Map2 || ListCache)(),
          "string": new Hash()
        };
      }
      function mapCacheDelete(key) {
        var result2 = getMapData(this, key)["delete"](key);
        this.size -= result2 ? 1 : 0;
        return result2;
      }
      function mapCacheGet(key) {
        return getMapData(this, key).get(key);
      }
      function mapCacheHas(key) {
        return getMapData(this, key).has(key);
      }
      function mapCacheSet(key, value) {
        var data = getMapData(this, key), size3 = data.size;
        data.set(key, value);
        this.size += data.size == size3 ? 0 : 1;
        return this;
      }
      MapCache.prototype.clear = mapCacheClear;
      MapCache.prototype["delete"] = mapCacheDelete;
      MapCache.prototype.get = mapCacheGet;
      MapCache.prototype.has = mapCacheHas;
      MapCache.prototype.set = mapCacheSet;
      function SetCache(values2) {
        var index2 = -1, length2 = values2 == null ? 0 : values2.length;
        this.__data__ = new MapCache();
        while (++index2 < length2) {
          this.add(values2[index2]);
        }
      }
      function setCacheAdd(value) {
        this.__data__.set(value, HASH_UNDEFINED);
        return this;
      }
      function setCacheHas(value) {
        return this.__data__.has(value);
      }
      SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
      SetCache.prototype.has = setCacheHas;
      function Stack(entries) {
        var data = this.__data__ = new ListCache(entries);
        this.size = data.size;
      }
      function stackClear() {
        this.__data__ = new ListCache();
        this.size = 0;
      }
      function stackDelete(key) {
        var data = this.__data__, result2 = data["delete"](key);
        this.size = data.size;
        return result2;
      }
      function stackGet(key) {
        return this.__data__.get(key);
      }
      function stackHas(key) {
        return this.__data__.has(key);
      }
      function stackSet(key, value) {
        var data = this.__data__;
        if (data instanceof ListCache) {
          var pairs = data.__data__;
          if (!Map2 || pairs.length < LARGE_ARRAY_SIZE - 1) {
            pairs.push([key, value]);
            this.size = ++data.size;
            return this;
          }
          data = this.__data__ = new MapCache(pairs);
        }
        data.set(key, value);
        this.size = data.size;
        return this;
      }
      Stack.prototype.clear = stackClear;
      Stack.prototype["delete"] = stackDelete;
      Stack.prototype.get = stackGet;
      Stack.prototype.has = stackHas;
      Stack.prototype.set = stackSet;
      function arrayLikeKeys(value, inherited) {
        var isArr = isArray2(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer(value), isType = !isArr && !isArg && !isBuff && isTypedArray(value), skipIndexes = isArr || isArg || isBuff || isType, result2 = skipIndexes ? baseTimes(value.length, String2) : [], length2 = result2.length;
        for (var key in value) {
          if ((inherited || hasOwnProperty2.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex(key, length2)))) {
            result2.push(key);
          }
        }
        return result2;
      }
      function arraySample(array) {
        var length2 = array.length;
        return length2 ? array[baseRandom(0, length2 - 1)] : undefined$1;
      }
      function arraySampleSize(array, n) {
        return shuffleSelf(copyArray(array), baseClamp(n, 0, array.length));
      }
      function arrayShuffle(array) {
        return shuffleSelf(copyArray(array));
      }
      function assignMergeValue(object, key, value) {
        if (value !== undefined$1 && !eq(object[key], value) || value === undefined$1 && !(key in object)) {
          baseAssignValue(object, key, value);
        }
      }
      function assignValue(object, key, value) {
        var objValue = object[key];
        if (!(hasOwnProperty2.call(object, key) && eq(objValue, value)) || value === undefined$1 && !(key in object)) {
          baseAssignValue(object, key, value);
        }
      }
      function assocIndexOf(array, key) {
        var length2 = array.length;
        while (length2--) {
          if (eq(array[length2][0], key)) {
            return length2;
          }
        }
        return -1;
      }
      function baseAggregator(collection, setter, iteratee2, accumulator) {
        baseEach(collection, function(value, key, collection2) {
          setter(accumulator, value, iteratee2(value), collection2);
        });
        return accumulator;
      }
      function baseAssign(object, source) {
        return object && copyObject(source, keys(source), object);
      }
      function baseAssignIn(object, source) {
        return object && copyObject(source, keysIn(source), object);
      }
      function baseAssignValue(object, key, value) {
        if (key == "__proto__" && defineProperty) {
          defineProperty(object, key, {
            "configurable": true,
            "enumerable": true,
            "value": value,
            "writable": true
          });
        } else {
          object[key] = value;
        }
      }
      function baseAt(object, paths) {
        var index2 = -1, length2 = paths.length, result2 = Array2(length2), skip = object == null;
        while (++index2 < length2) {
          result2[index2] = skip ? undefined$1 : get2(object, paths[index2]);
        }
        return result2;
      }
      function baseClamp(number2, lower, upper) {
        if (number2 === number2) {
          if (upper !== undefined$1) {
            number2 = number2 <= upper ? number2 : upper;
          }
          if (lower !== undefined$1) {
            number2 = number2 >= lower ? number2 : lower;
          }
        }
        return number2;
      }
      function baseClone(value, bitmask, customizer, key, object, stack2) {
        var result2, isDeep = bitmask & CLONE_DEEP_FLAG, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG;
        if (customizer) {
          result2 = object ? customizer(value, key, object, stack2) : customizer(value);
        }
        if (result2 !== undefined$1) {
          return result2;
        }
        if (!isObject2(value)) {
          return value;
        }
        var isArr = isArray2(value);
        if (isArr) {
          result2 = initCloneArray(value);
          if (!isDeep) {
            return copyArray(value, result2);
          }
        } else {
          var tag = getTag(value), isFunc = tag == funcTag || tag == genTag;
          if (isBuffer(value)) {
            return cloneBuffer(value, isDeep);
          }
          if (tag == objectTag || tag == argsTag || isFunc && !object) {
            result2 = isFlat || isFunc ? {} : initCloneObject(value);
            if (!isDeep) {
              return isFlat ? copySymbolsIn(value, baseAssignIn(result2, value)) : copySymbols(value, baseAssign(result2, value));
            }
          } else {
            if (!cloneableTags[tag]) {
              return object ? value : {};
            }
            result2 = initCloneByTag(value, tag, isDeep);
          }
        }
        stack2 || (stack2 = new Stack());
        var stacked = stack2.get(value);
        if (stacked) {
          return stacked;
        }
        stack2.set(value, result2);
        if (isSet2(value)) {
          value.forEach(function(subValue) {
            result2.add(baseClone(subValue, bitmask, customizer, subValue, value, stack2));
          });
        } else if (isMap2(value)) {
          value.forEach(function(subValue, key2) {
            result2.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack2));
          });
        }
        var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys : isFlat ? keysIn : keys;
        var props = isArr ? undefined$1 : keysFunc(value);
        arrayEach(props || value, function(subValue, key2) {
          if (props) {
            key2 = subValue;
            subValue = value[key2];
          }
          assignValue(result2, key2, baseClone(subValue, bitmask, customizer, key2, value, stack2));
        });
        return result2;
      }
      function baseConforms(source) {
        var props = keys(source);
        return function(object) {
          return baseConformsTo(object, source, props);
        };
      }
      function baseConformsTo(object, source, props) {
        var length2 = props.length;
        if (object == null) {
          return !length2;
        }
        object = Object2(object);
        while (length2--) {
          var key = props[length2], predicate = source[key], value = object[key];
          if (value === undefined$1 && !(key in object) || !predicate(value)) {
            return false;
          }
        }
        return true;
      }
      function baseDelay(func, wait, args) {
        if (typeof func != "function") {
          throw new TypeError2(FUNC_ERROR_TEXT);
        }
        return setTimeout2(function() {
          func.apply(undefined$1, args);
        }, wait);
      }
      function baseDifference(array, values2, iteratee2, comparator) {
        var index2 = -1, includes2 = arrayIncludes, isCommon = true, length2 = array.length, result2 = [], valuesLength = values2.length;
        if (!length2) {
          return result2;
        }
        if (iteratee2) {
          values2 = arrayMap(values2, baseUnary(iteratee2));
        }
        if (comparator) {
          includes2 = arrayIncludesWith;
          isCommon = false;
        } else if (values2.length >= LARGE_ARRAY_SIZE) {
          includes2 = cacheHas;
          isCommon = false;
          values2 = new SetCache(values2);
        }
        outer:
          while (++index2 < length2) {
            var value = array[index2], computed2 = iteratee2 == null ? value : iteratee2(value);
            value = comparator || value !== 0 ? value : 0;
            if (isCommon && computed2 === computed2) {
              var valuesIndex = valuesLength;
              while (valuesIndex--) {
                if (values2[valuesIndex] === computed2) {
                  continue outer;
                }
              }
              result2.push(value);
            } else if (!includes2(values2, computed2, comparator)) {
              result2.push(value);
            }
          }
        return result2;
      }
      var baseEach = createBaseEach(baseForOwn);
      var baseEachRight = createBaseEach(baseForOwnRight, true);
      function baseEvery(collection, predicate) {
        var result2 = true;
        baseEach(collection, function(value, index2, collection2) {
          result2 = !!predicate(value, index2, collection2);
          return result2;
        });
        return result2;
      }
      function baseExtremum(array, iteratee2, comparator) {
        var index2 = -1, length2 = array.length;
        while (++index2 < length2) {
          var value = array[index2], current = iteratee2(value);
          if (current != null && (computed2 === undefined$1 ? current === current && !isSymbol2(current) : comparator(current, computed2))) {
            var computed2 = current, result2 = value;
          }
        }
        return result2;
      }
      function baseFill(array, value, start, end) {
        var length2 = array.length;
        start = toInteger(start);
        if (start < 0) {
          start = -start > length2 ? 0 : length2 + start;
        }
        end = end === undefined$1 || end > length2 ? length2 : toInteger(end);
        if (end < 0) {
          end += length2;
        }
        end = start > end ? 0 : toLength(end);
        while (start < end) {
          array[start++] = value;
        }
        return array;
      }
      function baseFilter(collection, predicate) {
        var result2 = [];
        baseEach(collection, function(value, index2, collection2) {
          if (predicate(value, index2, collection2)) {
            result2.push(value);
          }
        });
        return result2;
      }
      function baseFlatten(array, depth, predicate, isStrict, result2) {
        var index2 = -1, length2 = array.length;
        predicate || (predicate = isFlattenable);
        result2 || (result2 = []);
        while (++index2 < length2) {
          var value = array[index2];
          if (depth > 0 && predicate(value)) {
            if (depth > 1) {
              baseFlatten(value, depth - 1, predicate, isStrict, result2);
            } else {
              arrayPush(result2, value);
            }
          } else if (!isStrict) {
            result2[result2.length] = value;
          }
        }
        return result2;
      }
      var baseFor = createBaseFor();
      var baseForRight = createBaseFor(true);
      function baseForOwn(object, iteratee2) {
        return object && baseFor(object, iteratee2, keys);
      }
      function baseForOwnRight(object, iteratee2) {
        return object && baseForRight(object, iteratee2, keys);
      }
      function baseFunctions(object, props) {
        return arrayFilter(props, function(key) {
          return isFunction2(object[key]);
        });
      }
      function baseGet(object, path) {
        path = castPath(path, object);
        var index2 = 0, length2 = path.length;
        while (object != null && index2 < length2) {
          object = object[toKey(path[index2++])];
        }
        return index2 && index2 == length2 ? object : undefined$1;
      }
      function baseGetAllKeys(object, keysFunc, symbolsFunc) {
        var result2 = keysFunc(object);
        return isArray2(object) ? result2 : arrayPush(result2, symbolsFunc(object));
      }
      function baseGetTag(value) {
        if (value == null) {
          return value === undefined$1 ? undefinedTag : nullTag;
        }
        return symToStringTag && symToStringTag in Object2(value) ? getRawTag(value) : objectToString2(value);
      }
      function baseGt(value, other) {
        return value > other;
      }
      function baseHas(object, key) {
        return object != null && hasOwnProperty2.call(object, key);
      }
      function baseHasIn(object, key) {
        return object != null && key in Object2(object);
      }
      function baseInRange(number2, start, end) {
        return number2 >= nativeMin(start, end) && number2 < nativeMax(start, end);
      }
      function baseIntersection(arrays, iteratee2, comparator) {
        var includes2 = comparator ? arrayIncludesWith : arrayIncludes, length2 = arrays[0].length, othLength = arrays.length, othIndex = othLength, caches = Array2(othLength), maxLength = Infinity, result2 = [];
        while (othIndex--) {
          var array = arrays[othIndex];
          if (othIndex && iteratee2) {
            array = arrayMap(array, baseUnary(iteratee2));
          }
          maxLength = nativeMin(array.length, maxLength);
          caches[othIndex] = !comparator && (iteratee2 || length2 >= 120 && array.length >= 120) ? new SetCache(othIndex && array) : undefined$1;
        }
        array = arrays[0];
        var index2 = -1, seen = caches[0];
        outer:
          while (++index2 < length2 && result2.length < maxLength) {
            var value = array[index2], computed2 = iteratee2 ? iteratee2(value) : value;
            value = comparator || value !== 0 ? value : 0;
            if (!(seen ? cacheHas(seen, computed2) : includes2(result2, computed2, comparator))) {
              othIndex = othLength;
              while (--othIndex) {
                var cache2 = caches[othIndex];
                if (!(cache2 ? cacheHas(cache2, computed2) : includes2(arrays[othIndex], computed2, comparator))) {
                  continue outer;
                }
              }
              if (seen) {
                seen.push(computed2);
              }
              result2.push(value);
            }
          }
        return result2;
      }
      function baseInverter(object, setter, iteratee2, accumulator) {
        baseForOwn(object, function(value, key, object2) {
          setter(accumulator, iteratee2(value), key, object2);
        });
        return accumulator;
      }
      function baseInvoke(object, path, args) {
        path = castPath(path, object);
        object = parent(object, path);
        var func = object == null ? object : object[toKey(last(path))];
        return func == null ? undefined$1 : apply2(func, object, args);
      }
      function baseIsArguments(value) {
        return isObjectLike2(value) && baseGetTag(value) == argsTag;
      }
      function baseIsArrayBuffer(value) {
        return isObjectLike2(value) && baseGetTag(value) == arrayBufferTag;
      }
      function baseIsDate(value) {
        return isObjectLike2(value) && baseGetTag(value) == dateTag;
      }
      function baseIsEqual(value, other, bitmask, customizer, stack2) {
        if (value === other) {
          return true;
        }
        if (value == null || other == null || !isObjectLike2(value) && !isObjectLike2(other)) {
          return value !== value && other !== other;
        }
        return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack2);
      }
      function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack2) {
        var objIsArr = isArray2(object), othIsArr = isArray2(other), objTag = objIsArr ? arrayTag : getTag(object), othTag = othIsArr ? arrayTag : getTag(other);
        objTag = objTag == argsTag ? objectTag : objTag;
        othTag = othTag == argsTag ? objectTag : othTag;
        var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
        if (isSameTag && isBuffer(object)) {
          if (!isBuffer(other)) {
            return false;
          }
          objIsArr = true;
          objIsObj = false;
        }
        if (isSameTag && !objIsObj) {
          stack2 || (stack2 = new Stack());
          return objIsArr || isTypedArray(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack2) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack2);
        }
        if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
          var objIsWrapped = objIsObj && hasOwnProperty2.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty2.call(other, "__wrapped__");
          if (objIsWrapped || othIsWrapped) {
            var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
            stack2 || (stack2 = new Stack());
            return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack2);
          }
        }
        if (!isSameTag) {
          return false;
        }
        stack2 || (stack2 = new Stack());
        return equalObjects(object, other, bitmask, customizer, equalFunc, stack2);
      }
      function baseIsMap(value) {
        return isObjectLike2(value) && getTag(value) == mapTag;
      }
      function baseIsMatch(object, source, matchData, customizer) {
        var index2 = matchData.length, length2 = index2, noCustomizer = !customizer;
        if (object == null) {
          return !length2;
        }
        object = Object2(object);
        while (index2--) {
          var data = matchData[index2];
          if (noCustomizer && data[2] ? data[1] !== object[data[0]] : !(data[0] in object)) {
            return false;
          }
        }
        while (++index2 < length2) {
          data = matchData[index2];
          var key = data[0], objValue = object[key], srcValue = data[1];
          if (noCustomizer && data[2]) {
            if (objValue === undefined$1 && !(key in object)) {
              return false;
            }
          } else {
            var stack2 = new Stack();
            if (customizer) {
              var result2 = customizer(objValue, srcValue, key, object, source, stack2);
            }
            if (!(result2 === undefined$1 ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack2) : result2)) {
              return false;
            }
          }
        }
        return true;
      }
      function baseIsNative(value) {
        if (!isObject2(value) || isMasked(value)) {
          return false;
        }
        var pattern = isFunction2(value) ? reIsNative : reIsHostCtor;
        return pattern.test(toSource(value));
      }
      function baseIsRegExp(value) {
        return isObjectLike2(value) && baseGetTag(value) == regexpTag;
      }
      function baseIsSet(value) {
        return isObjectLike2(value) && getTag(value) == setTag;
      }
      function baseIsTypedArray(value) {
        return isObjectLike2(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
      }
      function baseIteratee(value) {
        if (typeof value == "function") {
          return value;
        }
        if (value == null) {
          return identity;
        }
        if (typeof value == "object") {
          return isArray2(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
        }
        return property(value);
      }
      function baseKeys(object) {
        if (!isPrototype(object)) {
          return nativeKeys(object);
        }
        var result2 = [];
        for (var key in Object2(object)) {
          if (hasOwnProperty2.call(object, key) && key != "constructor") {
            result2.push(key);
          }
        }
        return result2;
      }
      function baseKeysIn(object) {
        if (!isObject2(object)) {
          return nativeKeysIn(object);
        }
        var isProto = isPrototype(object), result2 = [];
        for (var key in object) {
          if (!(key == "constructor" && (isProto || !hasOwnProperty2.call(object, key)))) {
            result2.push(key);
          }
        }
        return result2;
      }
      function baseLt(value, other) {
        return value < other;
      }
      function baseMap(collection, iteratee2) {
        var index2 = -1, result2 = isArrayLike(collection) ? Array2(collection.length) : [];
        baseEach(collection, function(value, key, collection2) {
          result2[++index2] = iteratee2(value, key, collection2);
        });
        return result2;
      }
      function baseMatches(source) {
        var matchData = getMatchData(source);
        if (matchData.length == 1 && matchData[0][2]) {
          return matchesStrictComparable(matchData[0][0], matchData[0][1]);
        }
        return function(object) {
          return object === source || baseIsMatch(object, source, matchData);
        };
      }
      function baseMatchesProperty(path, srcValue) {
        if (isKey(path) && isStrictComparable(srcValue)) {
          return matchesStrictComparable(toKey(path), srcValue);
        }
        return function(object) {
          var objValue = get2(object, path);
          return objValue === undefined$1 && objValue === srcValue ? hasIn(object, path) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
        };
      }
      function baseMerge(object, source, srcIndex, customizer, stack2) {
        if (object === source) {
          return;
        }
        baseFor(source, function(srcValue, key) {
          stack2 || (stack2 = new Stack());
          if (isObject2(srcValue)) {
            baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack2);
          } else {
            var newValue = customizer ? customizer(safeGet(object, key), srcValue, key + "", object, source, stack2) : undefined$1;
            if (newValue === undefined$1) {
              newValue = srcValue;
            }
            assignMergeValue(object, key, newValue);
          }
        }, keysIn);
      }
      function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack2) {
        var objValue = safeGet(object, key), srcValue = safeGet(source, key), stacked = stack2.get(srcValue);
        if (stacked) {
          assignMergeValue(object, key, stacked);
          return;
        }
        var newValue = customizer ? customizer(objValue, srcValue, key + "", object, source, stack2) : undefined$1;
        var isCommon = newValue === undefined$1;
        if (isCommon) {
          var isArr = isArray2(srcValue), isBuff = !isArr && isBuffer(srcValue), isTyped = !isArr && !isBuff && isTypedArray(srcValue);
          newValue = srcValue;
          if (isArr || isBuff || isTyped) {
            if (isArray2(objValue)) {
              newValue = objValue;
            } else if (isArrayLikeObject(objValue)) {
              newValue = copyArray(objValue);
            } else if (isBuff) {
              isCommon = false;
              newValue = cloneBuffer(srcValue, true);
            } else if (isTyped) {
              isCommon = false;
              newValue = cloneTypedArray(srcValue, true);
            } else {
              newValue = [];
            }
          } else if (isPlainObject2(srcValue) || isArguments(srcValue)) {
            newValue = objValue;
            if (isArguments(objValue)) {
              newValue = toPlainObject(objValue);
            } else if (!isObject2(objValue) || isFunction2(objValue)) {
              newValue = initCloneObject(srcValue);
            }
          } else {
            isCommon = false;
          }
        }
        if (isCommon) {
          stack2.set(srcValue, newValue);
          mergeFunc(newValue, srcValue, srcIndex, customizer, stack2);
          stack2["delete"](srcValue);
        }
        assignMergeValue(object, key, newValue);
      }
      function baseNth(array, n) {
        var length2 = array.length;
        if (!length2) {
          return;
        }
        n += n < 0 ? length2 : 0;
        return isIndex(n, length2) ? array[n] : undefined$1;
      }
      function baseOrderBy(collection, iteratees, orders) {
        if (iteratees.length) {
          iteratees = arrayMap(iteratees, function(iteratee2) {
            if (isArray2(iteratee2)) {
              return function(value) {
                return baseGet(value, iteratee2.length === 1 ? iteratee2[0] : iteratee2);
              };
            }
            return iteratee2;
          });
        } else {
          iteratees = [identity];
        }
        var index2 = -1;
        iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
        var result2 = baseMap(collection, function(value, key, collection2) {
          var criteria = arrayMap(iteratees, function(iteratee2) {
            return iteratee2(value);
          });
          return { "criteria": criteria, "index": ++index2, "value": value };
        });
        return baseSortBy(result2, function(object, other) {
          return compareMultiple(object, other, orders);
        });
      }
      function basePick(object, paths) {
        return basePickBy(object, paths, function(value, path) {
          return hasIn(object, path);
        });
      }
      function basePickBy(object, paths, predicate) {
        var index2 = -1, length2 = paths.length, result2 = {};
        while (++index2 < length2) {
          var path = paths[index2], value = baseGet(object, path);
          if (predicate(value, path)) {
            baseSet(result2, castPath(path, object), value);
          }
        }
        return result2;
      }
      function basePropertyDeep(path) {
        return function(object) {
          return baseGet(object, path);
        };
      }
      function basePullAll(array, values2, iteratee2, comparator) {
        var indexOf3 = comparator ? baseIndexOfWith : baseIndexOf, index2 = -1, length2 = values2.length, seen = array;
        if (array === values2) {
          values2 = copyArray(values2);
        }
        if (iteratee2) {
          seen = arrayMap(array, baseUnary(iteratee2));
        }
        while (++index2 < length2) {
          var fromIndex = 0, value = values2[index2], computed2 = iteratee2 ? iteratee2(value) : value;
          while ((fromIndex = indexOf3(seen, computed2, fromIndex, comparator)) > -1) {
            if (seen !== array) {
              splice.call(seen, fromIndex, 1);
            }
            splice.call(array, fromIndex, 1);
          }
        }
        return array;
      }
      function basePullAt(array, indexes) {
        var length2 = array ? indexes.length : 0, lastIndex = length2 - 1;
        while (length2--) {
          var index2 = indexes[length2];
          if (length2 == lastIndex || index2 !== previous) {
            var previous = index2;
            if (isIndex(index2)) {
              splice.call(array, index2, 1);
            } else {
              baseUnset(array, index2);
            }
          }
        }
        return array;
      }
      function baseRandom(lower, upper) {
        return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
      }
      function baseRange(start, end, step, fromRight) {
        var index2 = -1, length2 = nativeMax(nativeCeil((end - start) / (step || 1)), 0), result2 = Array2(length2);
        while (length2--) {
          result2[fromRight ? length2 : ++index2] = start;
          start += step;
        }
        return result2;
      }
      function baseRepeat(string, n) {
        var result2 = "";
        if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
          return result2;
        }
        do {
          if (n % 2) {
            result2 += string;
          }
          n = nativeFloor(n / 2);
          if (n) {
            string += string;
          }
        } while (n);
        return result2;
      }
      function baseRest(func, start) {
        return setToString(overRest(func, start, identity), func + "");
      }
      function baseSample(collection) {
        return arraySample(values(collection));
      }
      function baseSampleSize(collection, n) {
        var array = values(collection);
        return shuffleSelf(array, baseClamp(n, 0, array.length));
      }
      function baseSet(object, path, value, customizer) {
        if (!isObject2(object)) {
          return object;
        }
        path = castPath(path, object);
        var index2 = -1, length2 = path.length, lastIndex = length2 - 1, nested = object;
        while (nested != null && ++index2 < length2) {
          var key = toKey(path[index2]), newValue = value;
          if (key === "__proto__" || key === "constructor" || key === "prototype") {
            return object;
          }
          if (index2 != lastIndex) {
            var objValue = nested[key];
            newValue = customizer ? customizer(objValue, key, nested) : undefined$1;
            if (newValue === undefined$1) {
              newValue = isObject2(objValue) ? objValue : isIndex(path[index2 + 1]) ? [] : {};
            }
          }
          assignValue(nested, key, newValue);
          nested = nested[key];
        }
        return object;
      }
      var baseSetData = !metaMap ? identity : function(func, data) {
        metaMap.set(func, data);
        return func;
      };
      var baseSetToString = !defineProperty ? identity : function(func, string) {
        return defineProperty(func, "toString", {
          "configurable": true,
          "enumerable": false,
          "value": constant(string),
          "writable": true
        });
      };
      function baseShuffle(collection) {
        return shuffleSelf(values(collection));
      }
      function baseSlice(array, start, end) {
        var index2 = -1, length2 = array.length;
        if (start < 0) {
          start = -start > length2 ? 0 : length2 + start;
        }
        end = end > length2 ? length2 : end;
        if (end < 0) {
          end += length2;
        }
        length2 = start > end ? 0 : end - start >>> 0;
        start >>>= 0;
        var result2 = Array2(length2);
        while (++index2 < length2) {
          result2[index2] = array[index2 + start];
        }
        return result2;
      }
      function baseSome(collection, predicate) {
        var result2;
        baseEach(collection, function(value, index2, collection2) {
          result2 = predicate(value, index2, collection2);
          return !result2;
        });
        return !!result2;
      }
      function baseSortedIndex(array, value, retHighest) {
        var low = 0, high = array == null ? low : array.length;
        if (typeof value == "number" && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
          while (low < high) {
            var mid2 = low + high >>> 1, computed2 = array[mid2];
            if (computed2 !== null && !isSymbol2(computed2) && (retHighest ? computed2 <= value : computed2 < value)) {
              low = mid2 + 1;
            } else {
              high = mid2;
            }
          }
          return high;
        }
        return baseSortedIndexBy(array, value, identity, retHighest);
      }
      function baseSortedIndexBy(array, value, iteratee2, retHighest) {
        var low = 0, high = array == null ? 0 : array.length;
        if (high === 0) {
          return 0;
        }
        value = iteratee2(value);
        var valIsNaN = value !== value, valIsNull = value === null, valIsSymbol = isSymbol2(value), valIsUndefined = value === undefined$1;
        while (low < high) {
          var mid2 = nativeFloor((low + high) / 2), computed2 = iteratee2(array[mid2]), othIsDefined = computed2 !== undefined$1, othIsNull = computed2 === null, othIsReflexive = computed2 === computed2, othIsSymbol = isSymbol2(computed2);
          if (valIsNaN) {
            var setLow = retHighest || othIsReflexive;
          } else if (valIsUndefined) {
            setLow = othIsReflexive && (retHighest || othIsDefined);
          } else if (valIsNull) {
            setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
          } else if (valIsSymbol) {
            setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
          } else if (othIsNull || othIsSymbol) {
            setLow = false;
          } else {
            setLow = retHighest ? computed2 <= value : computed2 < value;
          }
          if (setLow) {
            low = mid2 + 1;
          } else {
            high = mid2;
          }
        }
        return nativeMin(high, MAX_ARRAY_INDEX);
      }
      function baseSortedUniq(array, iteratee2) {
        var index2 = -1, length2 = array.length, resIndex = 0, result2 = [];
        while (++index2 < length2) {
          var value = array[index2], computed2 = iteratee2 ? iteratee2(value) : value;
          if (!index2 || !eq(computed2, seen)) {
            var seen = computed2;
            result2[resIndex++] = value === 0 ? 0 : value;
          }
        }
        return result2;
      }
      function baseToNumber(value) {
        if (typeof value == "number") {
          return value;
        }
        if (isSymbol2(value)) {
          return NAN;
        }
        return +value;
      }
      function baseToString(value) {
        if (typeof value == "string") {
          return value;
        }
        if (isArray2(value)) {
          return arrayMap(value, baseToString) + "";
        }
        if (isSymbol2(value)) {
          return symbolToString ? symbolToString.call(value) : "";
        }
        var result2 = value + "";
        return result2 == "0" && 1 / value == -INFINITY ? "-0" : result2;
      }
      function baseUniq(array, iteratee2, comparator) {
        var index2 = -1, includes2 = arrayIncludes, length2 = array.length, isCommon = true, result2 = [], seen = result2;
        if (comparator) {
          isCommon = false;
          includes2 = arrayIncludesWith;
        } else if (length2 >= LARGE_ARRAY_SIZE) {
          var set4 = iteratee2 ? null : createSet(array);
          if (set4) {
            return setToArray(set4);
          }
          isCommon = false;
          includes2 = cacheHas;
          seen = new SetCache();
        } else {
          seen = iteratee2 ? [] : result2;
        }
        outer:
          while (++index2 < length2) {
            var value = array[index2], computed2 = iteratee2 ? iteratee2(value) : value;
            value = comparator || value !== 0 ? value : 0;
            if (isCommon && computed2 === computed2) {
              var seenIndex = seen.length;
              while (seenIndex--) {
                if (seen[seenIndex] === computed2) {
                  continue outer;
                }
              }
              if (iteratee2) {
                seen.push(computed2);
              }
              result2.push(value);
            } else if (!includes2(seen, computed2, comparator)) {
              if (seen !== result2) {
                seen.push(computed2);
              }
              result2.push(value);
            }
          }
        return result2;
      }
      function baseUnset(object, path) {
        path = castPath(path, object);
        object = parent(object, path);
        return object == null || delete object[toKey(last(path))];
      }
      function baseUpdate(object, path, updater, customizer) {
        return baseSet(object, path, updater(baseGet(object, path)), customizer);
      }
      function baseWhile(array, predicate, isDrop, fromRight) {
        var length2 = array.length, index2 = fromRight ? length2 : -1;
        while ((fromRight ? index2-- : ++index2 < length2) && predicate(array[index2], index2, array)) {
        }
        return isDrop ? baseSlice(array, fromRight ? 0 : index2, fromRight ? index2 + 1 : length2) : baseSlice(array, fromRight ? index2 + 1 : 0, fromRight ? length2 : index2);
      }
      function baseWrapperValue(value, actions) {
        var result2 = value;
        if (result2 instanceof LazyWrapper) {
          result2 = result2.value();
        }
        return arrayReduce(actions, function(result3, action) {
          return action.func.apply(action.thisArg, arrayPush([result3], action.args));
        }, result2);
      }
      function baseXor(arrays, iteratee2, comparator) {
        var length2 = arrays.length;
        if (length2 < 2) {
          return length2 ? baseUniq(arrays[0]) : [];
        }
        var index2 = -1, result2 = Array2(length2);
        while (++index2 < length2) {
          var array = arrays[index2], othIndex = -1;
          while (++othIndex < length2) {
            if (othIndex != index2) {
              result2[index2] = baseDifference(result2[index2] || array, arrays[othIndex], iteratee2, comparator);
            }
          }
        }
        return baseUniq(baseFlatten(result2, 1), iteratee2, comparator);
      }
      function baseZipObject(props, values2, assignFunc) {
        var index2 = -1, length2 = props.length, valsLength = values2.length, result2 = {};
        while (++index2 < length2) {
          var value = index2 < valsLength ? values2[index2] : undefined$1;
          assignFunc(result2, props[index2], value);
        }
        return result2;
      }
      function castArrayLikeObject(value) {
        return isArrayLikeObject(value) ? value : [];
      }
      function castFunction(value) {
        return typeof value == "function" ? value : identity;
      }
      function castPath(value, object) {
        if (isArray2(value)) {
          return value;
        }
        return isKey(value, object) ? [value] : stringToPath(toString2(value));
      }
      var castRest = baseRest;
      function castSlice(array, start, end) {
        var length2 = array.length;
        end = end === undefined$1 ? length2 : end;
        return !start && end >= length2 ? array : baseSlice(array, start, end);
      }
      var clearTimeout2 = ctxClearTimeout || function(id2) {
        return root.clearTimeout(id2);
      };
      function cloneBuffer(buffer2, isDeep) {
        if (isDeep) {
          return buffer2.slice();
        }
        var length2 = buffer2.length, result2 = allocUnsafe ? allocUnsafe(length2) : new buffer2.constructor(length2);
        buffer2.copy(result2);
        return result2;
      }
      function cloneArrayBuffer(arrayBuffer) {
        var result2 = new arrayBuffer.constructor(arrayBuffer.byteLength);
        new Uint8Array2(result2).set(new Uint8Array2(arrayBuffer));
        return result2;
      }
      function cloneDataView(dataView, isDeep) {
        var buffer2 = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
        return new dataView.constructor(buffer2, dataView.byteOffset, dataView.byteLength);
      }
      function cloneRegExp(regexp) {
        var result2 = new regexp.constructor(regexp.source, reFlags.exec(regexp));
        result2.lastIndex = regexp.lastIndex;
        return result2;
      }
      function cloneSymbol(symbol) {
        return symbolValueOf ? Object2(symbolValueOf.call(symbol)) : {};
      }
      function cloneTypedArray(typedArray, isDeep) {
        var buffer2 = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
        return new typedArray.constructor(buffer2, typedArray.byteOffset, typedArray.length);
      }
      function compareAscending(value, other) {
        if (value !== other) {
          var valIsDefined = value !== undefined$1, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = isSymbol2(value);
          var othIsDefined = other !== undefined$1, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol2(other);
          if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
            return 1;
          }
          if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
            return -1;
          }
        }
        return 0;
      }
      function compareMultiple(object, other, orders) {
        var index2 = -1, objCriteria = object.criteria, othCriteria = other.criteria, length2 = objCriteria.length, ordersLength = orders.length;
        while (++index2 < length2) {
          var result2 = compareAscending(objCriteria[index2], othCriteria[index2]);
          if (result2) {
            if (index2 >= ordersLength) {
              return result2;
            }
            var order2 = orders[index2];
            return result2 * (order2 == "desc" ? -1 : 1);
          }
        }
        return object.index - other.index;
      }
      function composeArgs(args, partials, holders, isCurried) {
        var argsIndex = -1, argsLength = args.length, holdersLength = holders.length, leftIndex = -1, leftLength = partials.length, rangeLength = nativeMax(argsLength - holdersLength, 0), result2 = Array2(leftLength + rangeLength), isUncurried = !isCurried;
        while (++leftIndex < leftLength) {
          result2[leftIndex] = partials[leftIndex];
        }
        while (++argsIndex < holdersLength) {
          if (isUncurried || argsIndex < argsLength) {
            result2[holders[argsIndex]] = args[argsIndex];
          }
        }
        while (rangeLength--) {
          result2[leftIndex++] = args[argsIndex++];
        }
        return result2;
      }
      function composeArgsRight(args, partials, holders, isCurried) {
        var argsIndex = -1, argsLength = args.length, holdersIndex = -1, holdersLength = holders.length, rightIndex = -1, rightLength = partials.length, rangeLength = nativeMax(argsLength - holdersLength, 0), result2 = Array2(rangeLength + rightLength), isUncurried = !isCurried;
        while (++argsIndex < rangeLength) {
          result2[argsIndex] = args[argsIndex];
        }
        var offset2 = argsIndex;
        while (++rightIndex < rightLength) {
          result2[offset2 + rightIndex] = partials[rightIndex];
        }
        while (++holdersIndex < holdersLength) {
          if (isUncurried || argsIndex < argsLength) {
            result2[offset2 + holders[holdersIndex]] = args[argsIndex++];
          }
        }
        return result2;
      }
      function copyArray(source, array) {
        var index2 = -1, length2 = source.length;
        array || (array = Array2(length2));
        while (++index2 < length2) {
          array[index2] = source[index2];
        }
        return array;
      }
      function copyObject(source, props, object, customizer) {
        var isNew = !object;
        object || (object = {});
        var index2 = -1, length2 = props.length;
        while (++index2 < length2) {
          var key = props[index2];
          var newValue = customizer ? customizer(object[key], source[key], key, object, source) : undefined$1;
          if (newValue === undefined$1) {
            newValue = source[key];
          }
          if (isNew) {
            baseAssignValue(object, key, newValue);
          } else {
            assignValue(object, key, newValue);
          }
        }
        return object;
      }
      function copySymbols(source, object) {
        return copyObject(source, getSymbols(source), object);
      }
      function copySymbolsIn(source, object) {
        return copyObject(source, getSymbolsIn(source), object);
      }
      function createAggregator(setter, initializer) {
        return function(collection, iteratee2) {
          var func = isArray2(collection) ? arrayAggregator : baseAggregator, accumulator = initializer ? initializer() : {};
          return func(collection, setter, getIteratee(iteratee2, 2), accumulator);
        };
      }
      function createAssigner(assigner) {
        return baseRest(function(object, sources) {
          var index2 = -1, length2 = sources.length, customizer = length2 > 1 ? sources[length2 - 1] : undefined$1, guard = length2 > 2 ? sources[2] : undefined$1;
          customizer = assigner.length > 3 && typeof customizer == "function" ? (length2--, customizer) : undefined$1;
          if (guard && isIterateeCall(sources[0], sources[1], guard)) {
            customizer = length2 < 3 ? undefined$1 : customizer;
            length2 = 1;
          }
          object = Object2(object);
          while (++index2 < length2) {
            var source = sources[index2];
            if (source) {
              assigner(object, source, index2, customizer);
            }
          }
          return object;
        });
      }
      function createBaseEach(eachFunc, fromRight) {
        return function(collection, iteratee2) {
          if (collection == null) {
            return collection;
          }
          if (!isArrayLike(collection)) {
            return eachFunc(collection, iteratee2);
          }
          var length2 = collection.length, index2 = fromRight ? length2 : -1, iterable = Object2(collection);
          while (fromRight ? index2-- : ++index2 < length2) {
            if (iteratee2(iterable[index2], index2, iterable) === false) {
              break;
            }
          }
          return collection;
        };
      }
      function createBaseFor(fromRight) {
        return function(object, iteratee2, keysFunc) {
          var index2 = -1, iterable = Object2(object), props = keysFunc(object), length2 = props.length;
          while (length2--) {
            var key = props[fromRight ? length2 : ++index2];
            if (iteratee2(iterable[key], key, iterable) === false) {
              break;
            }
          }
          return object;
        };
      }
      function createBind(func, bitmask, thisArg) {
        var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
        function wrapper() {
          var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
          return fn.apply(isBind ? thisArg : this, arguments);
        }
        return wrapper;
      }
      function createCaseFirst(methodName) {
        return function(string) {
          string = toString2(string);
          var strSymbols = hasUnicode(string) ? stringToArray(string) : undefined$1;
          var chr = strSymbols ? strSymbols[0] : string.charAt(0);
          var trailing = strSymbols ? castSlice(strSymbols, 1).join("") : string.slice(1);
          return chr[methodName]() + trailing;
        };
      }
      function createCompounder(callback) {
        return function(string) {
          return arrayReduce(words(deburr(string).replace(reApos, "")), callback, "");
        };
      }
      function createCtor(Ctor) {
        return function() {
          var args = arguments;
          switch (args.length) {
            case 0:
              return new Ctor();
            case 1:
              return new Ctor(args[0]);
            case 2:
              return new Ctor(args[0], args[1]);
            case 3:
              return new Ctor(args[0], args[1], args[2]);
            case 4:
              return new Ctor(args[0], args[1], args[2], args[3]);
            case 5:
              return new Ctor(args[0], args[1], args[2], args[3], args[4]);
            case 6:
              return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
            case 7:
              return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
          }
          var thisBinding = baseCreate(Ctor.prototype), result2 = Ctor.apply(thisBinding, args);
          return isObject2(result2) ? result2 : thisBinding;
        };
      }
      function createCurry(func, bitmask, arity) {
        var Ctor = createCtor(func);
        function wrapper() {
          var length2 = arguments.length, args = Array2(length2), index2 = length2, placeholder = getHolder(wrapper);
          while (index2--) {
            args[index2] = arguments[index2];
          }
          var holders = length2 < 3 && args[0] !== placeholder && args[length2 - 1] !== placeholder ? [] : replaceHolders(args, placeholder);
          length2 -= holders.length;
          if (length2 < arity) {
            return createRecurry(
              func,
              bitmask,
              createHybrid,
              wrapper.placeholder,
              undefined$1,
              args,
              holders,
              undefined$1,
              undefined$1,
              arity - length2
            );
          }
          var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
          return apply2(fn, this, args);
        }
        return wrapper;
      }
      function createFind(findIndexFunc) {
        return function(collection, predicate, fromIndex) {
          var iterable = Object2(collection);
          if (!isArrayLike(collection)) {
            var iteratee2 = getIteratee(predicate, 3);
            collection = keys(collection);
            predicate = function(key) {
              return iteratee2(iterable[key], key, iterable);
            };
          }
          var index2 = findIndexFunc(collection, predicate, fromIndex);
          return index2 > -1 ? iterable[iteratee2 ? collection[index2] : index2] : undefined$1;
        };
      }
      function createFlow(fromRight) {
        return flatRest(function(funcs) {
          var length2 = funcs.length, index2 = length2, prereq = LodashWrapper.prototype.thru;
          if (fromRight) {
            funcs.reverse();
          }
          while (index2--) {
            var func = funcs[index2];
            if (typeof func != "function") {
              throw new TypeError2(FUNC_ERROR_TEXT);
            }
            if (prereq && !wrapper && getFuncName(func) == "wrapper") {
              var wrapper = new LodashWrapper([], true);
            }
          }
          index2 = wrapper ? index2 : length2;
          while (++index2 < length2) {
            func = funcs[index2];
            var funcName = getFuncName(func), data = funcName == "wrapper" ? getData(func) : undefined$1;
            if (data && isLaziable(data[0]) && data[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) && !data[4].length && data[9] == 1) {
              wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
            } else {
              wrapper = func.length == 1 && isLaziable(func) ? wrapper[funcName]() : wrapper.thru(func);
            }
          }
          return function() {
            var args = arguments, value = args[0];
            if (wrapper && args.length == 1 && isArray2(value)) {
              return wrapper.plant(value).value();
            }
            var index3 = 0, result2 = length2 ? funcs[index3].apply(this, args) : value;
            while (++index3 < length2) {
              result2 = funcs[index3].call(this, result2);
            }
            return result2;
          };
        });
      }
      function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary2, arity) {
        var isAry = bitmask & WRAP_ARY_FLAG, isBind = bitmask & WRAP_BIND_FLAG, isBindKey = bitmask & WRAP_BIND_KEY_FLAG, isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG), isFlip = bitmask & WRAP_FLIP_FLAG, Ctor = isBindKey ? undefined$1 : createCtor(func);
        function wrapper() {
          var length2 = arguments.length, args = Array2(length2), index2 = length2;
          while (index2--) {
            args[index2] = arguments[index2];
          }
          if (isCurried) {
            var placeholder = getHolder(wrapper), holdersCount = countHolders(args, placeholder);
          }
          if (partials) {
            args = composeArgs(args, partials, holders, isCurried);
          }
          if (partialsRight) {
            args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
          }
          length2 -= holdersCount;
          if (isCurried && length2 < arity) {
            var newHolders = replaceHolders(args, placeholder);
            return createRecurry(
              func,
              bitmask,
              createHybrid,
              wrapper.placeholder,
              thisArg,
              args,
              newHolders,
              argPos,
              ary2,
              arity - length2
            );
          }
          var thisBinding = isBind ? thisArg : this, fn = isBindKey ? thisBinding[func] : func;
          length2 = args.length;
          if (argPos) {
            args = reorder(args, argPos);
          } else if (isFlip && length2 > 1) {
            args.reverse();
          }
          if (isAry && ary2 < length2) {
            args.length = ary2;
          }
          if (this && this !== root && this instanceof wrapper) {
            fn = Ctor || createCtor(fn);
          }
          return fn.apply(thisBinding, args);
        }
        return wrapper;
      }
      function createInverter(setter, toIteratee) {
        return function(object, iteratee2) {
          return baseInverter(object, setter, toIteratee(iteratee2), {});
        };
      }
      function createMathOperation(operator, defaultValue) {
        return function(value, other) {
          var result2;
          if (value === undefined$1 && other === undefined$1) {
            return defaultValue;
          }
          if (value !== undefined$1) {
            result2 = value;
          }
          if (other !== undefined$1) {
            if (result2 === undefined$1) {
              return other;
            }
            if (typeof value == "string" || typeof other == "string") {
              value = baseToString(value);
              other = baseToString(other);
            } else {
              value = baseToNumber(value);
              other = baseToNumber(other);
            }
            result2 = operator(value, other);
          }
          return result2;
        };
      }
      function createOver(arrayFunc) {
        return flatRest(function(iteratees) {
          iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
          return baseRest(function(args) {
            var thisArg = this;
            return arrayFunc(iteratees, function(iteratee2) {
              return apply2(iteratee2, thisArg, args);
            });
          });
        });
      }
      function createPadding(length2, chars) {
        chars = chars === undefined$1 ? " " : baseToString(chars);
        var charsLength = chars.length;
        if (charsLength < 2) {
          return charsLength ? baseRepeat(chars, length2) : chars;
        }
        var result2 = baseRepeat(chars, nativeCeil(length2 / stringSize(chars)));
        return hasUnicode(chars) ? castSlice(stringToArray(result2), 0, length2).join("") : result2.slice(0, length2);
      }
      function createPartial(func, bitmask, thisArg, partials) {
        var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
        function wrapper() {
          var argsIndex = -1, argsLength = arguments.length, leftIndex = -1, leftLength = partials.length, args = Array2(leftLength + argsLength), fn = this && this !== root && this instanceof wrapper ? Ctor : func;
          while (++leftIndex < leftLength) {
            args[leftIndex] = partials[leftIndex];
          }
          while (argsLength--) {
            args[leftIndex++] = arguments[++argsIndex];
          }
          return apply2(fn, isBind ? thisArg : this, args);
        }
        return wrapper;
      }
      function createRange(fromRight) {
        return function(start, end, step) {
          if (step && typeof step != "number" && isIterateeCall(start, end, step)) {
            end = step = undefined$1;
          }
          start = toFinite(start);
          if (end === undefined$1) {
            end = start;
            start = 0;
          } else {
            end = toFinite(end);
          }
          step = step === undefined$1 ? start < end ? 1 : -1 : toFinite(step);
          return baseRange(start, end, step, fromRight);
        };
      }
      function createRelationalOperation(operator) {
        return function(value, other) {
          if (!(typeof value == "string" && typeof other == "string")) {
            value = toNumber2(value);
            other = toNumber2(other);
          }
          return operator(value, other);
        };
      }
      function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary2, arity) {
        var isCurry = bitmask & WRAP_CURRY_FLAG, newHolders = isCurry ? holders : undefined$1, newHoldersRight = isCurry ? undefined$1 : holders, newPartials = isCurry ? partials : undefined$1, newPartialsRight = isCurry ? undefined$1 : partials;
        bitmask |= isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG;
        bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);
        if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
          bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
        }
        var newData = [
          func,
          bitmask,
          thisArg,
          newPartials,
          newHolders,
          newPartialsRight,
          newHoldersRight,
          argPos,
          ary2,
          arity
        ];
        var result2 = wrapFunc.apply(undefined$1, newData);
        if (isLaziable(func)) {
          setData(result2, newData);
        }
        result2.placeholder = placeholder;
        return setWrapToString(result2, func, bitmask);
      }
      function createRound(methodName) {
        var func = Math2[methodName];
        return function(number2, precision) {
          number2 = toNumber2(number2);
          precision = precision == null ? 0 : nativeMin(toInteger(precision), 292);
          if (precision && nativeIsFinite(number2)) {
            var pair = (toString2(number2) + "e").split("e"), value = func(pair[0] + "e" + (+pair[1] + precision));
            pair = (toString2(value) + "e").split("e");
            return +(pair[0] + "e" + (+pair[1] - precision));
          }
          return func(number2);
        };
      }
      var createSet = !(Set2 && 1 / setToArray(new Set2([, -0]))[1] == INFINITY) ? noop2 : function(values2) {
        return new Set2(values2);
      };
      function createToPairs(keysFunc) {
        return function(object) {
          var tag = getTag(object);
          if (tag == mapTag) {
            return mapToArray(object);
          }
          if (tag == setTag) {
            return setToPairs(object);
          }
          return baseToPairs(object, keysFunc(object));
        };
      }
      function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary2, arity) {
        var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
        if (!isBindKey && typeof func != "function") {
          throw new TypeError2(FUNC_ERROR_TEXT);
        }
        var length2 = partials ? partials.length : 0;
        if (!length2) {
          bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
          partials = holders = undefined$1;
        }
        ary2 = ary2 === undefined$1 ? ary2 : nativeMax(toInteger(ary2), 0);
        arity = arity === undefined$1 ? arity : toInteger(arity);
        length2 -= holders ? holders.length : 0;
        if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
          var partialsRight = partials, holdersRight = holders;
          partials = holders = undefined$1;
        }
        var data = isBindKey ? undefined$1 : getData(func);
        var newData = [
          func,
          bitmask,
          thisArg,
          partials,
          holders,
          partialsRight,
          holdersRight,
          argPos,
          ary2,
          arity
        ];
        if (data) {
          mergeData(newData, data);
        }
        func = newData[0];
        bitmask = newData[1];
        thisArg = newData[2];
        partials = newData[3];
        holders = newData[4];
        arity = newData[9] = newData[9] === undefined$1 ? isBindKey ? 0 : func.length : nativeMax(newData[9] - length2, 0);
        if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
          bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
        }
        if (!bitmask || bitmask == WRAP_BIND_FLAG) {
          var result2 = createBind(func, bitmask, thisArg);
        } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
          result2 = createCurry(func, bitmask, arity);
        } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
          result2 = createPartial(func, bitmask, thisArg, partials);
        } else {
          result2 = createHybrid.apply(undefined$1, newData);
        }
        var setter = data ? baseSetData : setData;
        return setWrapToString(setter(result2, newData), func, bitmask);
      }
      function customDefaultsAssignIn(objValue, srcValue, key, object) {
        if (objValue === undefined$1 || eq(objValue, objectProto[key]) && !hasOwnProperty2.call(object, key)) {
          return srcValue;
        }
        return objValue;
      }
      function customDefaultsMerge(objValue, srcValue, key, object, source, stack2) {
        if (isObject2(objValue) && isObject2(srcValue)) {
          stack2.set(srcValue, objValue);
          baseMerge(objValue, srcValue, undefined$1, customDefaultsMerge, stack2);
          stack2["delete"](srcValue);
        }
        return objValue;
      }
      function customOmitClone(value) {
        return isPlainObject2(value) ? undefined$1 : value;
      }
      function equalArrays(array, other, bitmask, customizer, equalFunc, stack2) {
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG, arrLength = array.length, othLength = other.length;
        if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
          return false;
        }
        var arrStacked = stack2.get(array);
        var othStacked = stack2.get(other);
        if (arrStacked && othStacked) {
          return arrStacked == other && othStacked == array;
        }
        var index2 = -1, result2 = true, seen = bitmask & COMPARE_UNORDERED_FLAG ? new SetCache() : undefined$1;
        stack2.set(array, other);
        stack2.set(other, array);
        while (++index2 < arrLength) {
          var arrValue = array[index2], othValue = other[index2];
          if (customizer) {
            var compared = isPartial ? customizer(othValue, arrValue, index2, other, array, stack2) : customizer(arrValue, othValue, index2, array, other, stack2);
          }
          if (compared !== undefined$1) {
            if (compared) {
              continue;
            }
            result2 = false;
            break;
          }
          if (seen) {
            if (!arraySome(other, function(othValue2, othIndex) {
              if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack2))) {
                return seen.push(othIndex);
              }
            })) {
              result2 = false;
              break;
            }
          } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack2))) {
            result2 = false;
            break;
          }
        }
        stack2["delete"](array);
        stack2["delete"](other);
        return result2;
      }
      function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack2) {
        switch (tag) {
          case dataViewTag:
            if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
              return false;
            }
            object = object.buffer;
            other = other.buffer;
          case arrayBufferTag:
            if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array2(object), new Uint8Array2(other))) {
              return false;
            }
            return true;
          case boolTag:
          case dateTag:
          case numberTag:
            return eq(+object, +other);
          case errorTag:
            return object.name == other.name && object.message == other.message;
          case regexpTag:
          case stringTag:
            return object == other + "";
          case mapTag:
            var convert = mapToArray;
          case setTag:
            var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
            convert || (convert = setToArray);
            if (object.size != other.size && !isPartial) {
              return false;
            }
            var stacked = stack2.get(object);
            if (stacked) {
              return stacked == other;
            }
            bitmask |= COMPARE_UNORDERED_FLAG;
            stack2.set(object, other);
            var result2 = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack2);
            stack2["delete"](object);
            return result2;
          case symbolTag:
            if (symbolValueOf) {
              return symbolValueOf.call(object) == symbolValueOf.call(other);
            }
        }
        return false;
      }
      function equalObjects(object, other, bitmask, customizer, equalFunc, stack2) {
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG, objProps = getAllKeys(object), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
        if (objLength != othLength && !isPartial) {
          return false;
        }
        var index2 = objLength;
        while (index2--) {
          var key = objProps[index2];
          if (!(isPartial ? key in other : hasOwnProperty2.call(other, key))) {
            return false;
          }
        }
        var objStacked = stack2.get(object);
        var othStacked = stack2.get(other);
        if (objStacked && othStacked) {
          return objStacked == other && othStacked == object;
        }
        var result2 = true;
        stack2.set(object, other);
        stack2.set(other, object);
        var skipCtor = isPartial;
        while (++index2 < objLength) {
          key = objProps[index2];
          var objValue = object[key], othValue = other[key];
          if (customizer) {
            var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack2) : customizer(objValue, othValue, key, object, other, stack2);
          }
          if (!(compared === undefined$1 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack2) : compared)) {
            result2 = false;
            break;
          }
          skipCtor || (skipCtor = key == "constructor");
        }
        if (result2 && !skipCtor) {
          var objCtor = object.constructor, othCtor = other.constructor;
          if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
            result2 = false;
          }
        }
        stack2["delete"](object);
        stack2["delete"](other);
        return result2;
      }
      function flatRest(func) {
        return setToString(overRest(func, undefined$1, flatten), func + "");
      }
      function getAllKeys(object) {
        return baseGetAllKeys(object, keys, getSymbols);
      }
      function getAllKeysIn(object) {
        return baseGetAllKeys(object, keysIn, getSymbolsIn);
      }
      var getData = !metaMap ? noop2 : function(func) {
        return metaMap.get(func);
      };
      function getFuncName(func) {
        var result2 = func.name + "", array = realNames[result2], length2 = hasOwnProperty2.call(realNames, result2) ? array.length : 0;
        while (length2--) {
          var data = array[length2], otherFunc = data.func;
          if (otherFunc == null || otherFunc == func) {
            return data.name;
          }
        }
        return result2;
      }
      function getHolder(func) {
        var object = hasOwnProperty2.call(lodash2, "placeholder") ? lodash2 : func;
        return object.placeholder;
      }
      function getIteratee() {
        var result2 = lodash2.iteratee || iteratee;
        result2 = result2 === iteratee ? baseIteratee : result2;
        return arguments.length ? result2(arguments[0], arguments[1]) : result2;
      }
      function getMapData(map3, key) {
        var data = map3.__data__;
        return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
      }
      function getMatchData(object) {
        var result2 = keys(object), length2 = result2.length;
        while (length2--) {
          var key = result2[length2], value = object[key];
          result2[length2] = [key, value, isStrictComparable(value)];
        }
        return result2;
      }
      function getNative(object, key) {
        var value = getValue2(object, key);
        return baseIsNative(value) ? value : undefined$1;
      }
      function getRawTag(value) {
        var isOwn = hasOwnProperty2.call(value, symToStringTag), tag = value[symToStringTag];
        try {
          value[symToStringTag] = undefined$1;
          var unmasked = true;
        } catch (e) {
        }
        var result2 = nativeObjectToString.call(value);
        if (unmasked) {
          if (isOwn) {
            value[symToStringTag] = tag;
          } else {
            delete value[symToStringTag];
          }
        }
        return result2;
      }
      var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
        if (object == null) {
          return [];
        }
        object = Object2(object);
        return arrayFilter(nativeGetSymbols(object), function(symbol) {
          return propertyIsEnumerable.call(object, symbol);
        });
      };
      var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
        var result2 = [];
        while (object) {
          arrayPush(result2, getSymbols(object));
          object = getPrototype(object);
        }
        return result2;
      };
      var getTag = baseGetTag;
      if (DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag || Map2 && getTag(new Map2()) != mapTag || Promise2 && getTag(Promise2.resolve()) != promiseTag || Set2 && getTag(new Set2()) != setTag || WeakMap2 && getTag(new WeakMap2()) != weakMapTag) {
        getTag = function(value) {
          var result2 = baseGetTag(value), Ctor = result2 == objectTag ? value.constructor : undefined$1, ctorString = Ctor ? toSource(Ctor) : "";
          if (ctorString) {
            switch (ctorString) {
              case dataViewCtorString:
                return dataViewTag;
              case mapCtorString:
                return mapTag;
              case promiseCtorString:
                return promiseTag;
              case setCtorString:
                return setTag;
              case weakMapCtorString:
                return weakMapTag;
            }
          }
          return result2;
        };
      }
      function getView(start, end, transforms) {
        var index2 = -1, length2 = transforms.length;
        while (++index2 < length2) {
          var data = transforms[index2], size3 = data.size;
          switch (data.type) {
            case "drop":
              start += size3;
              break;
            case "dropRight":
              end -= size3;
              break;
            case "take":
              end = nativeMin(end, start + size3);
              break;
            case "takeRight":
              start = nativeMax(start, end - size3);
              break;
          }
        }
        return { "start": start, "end": end };
      }
      function getWrapDetails(source) {
        var match3 = source.match(reWrapDetails);
        return match3 ? match3[1].split(reSplitDetails) : [];
      }
      function hasPath(object, path, hasFunc) {
        path = castPath(path, object);
        var index2 = -1, length2 = path.length, result2 = false;
        while (++index2 < length2) {
          var key = toKey(path[index2]);
          if (!(result2 = object != null && hasFunc(object, key))) {
            break;
          }
          object = object[key];
        }
        if (result2 || ++index2 != length2) {
          return result2;
        }
        length2 = object == null ? 0 : object.length;
        return !!length2 && isLength(length2) && isIndex(key, length2) && (isArray2(object) || isArguments(object));
      }
      function initCloneArray(array) {
        var length2 = array.length, result2 = new array.constructor(length2);
        if (length2 && typeof array[0] == "string" && hasOwnProperty2.call(array, "index")) {
          result2.index = array.index;
          result2.input = array.input;
        }
        return result2;
      }
      function initCloneObject(object) {
        return typeof object.constructor == "function" && !isPrototype(object) ? baseCreate(getPrototype(object)) : {};
      }
      function initCloneByTag(object, tag, isDeep) {
        var Ctor = object.constructor;
        switch (tag) {
          case arrayBufferTag:
            return cloneArrayBuffer(object);
          case boolTag:
          case dateTag:
            return new Ctor(+object);
          case dataViewTag:
            return cloneDataView(object, isDeep);
          case float32Tag:
          case float64Tag:
          case int8Tag:
          case int16Tag:
          case int32Tag:
          case uint8Tag:
          case uint8ClampedTag:
          case uint16Tag:
          case uint32Tag:
            return cloneTypedArray(object, isDeep);
          case mapTag:
            return new Ctor();
          case numberTag:
          case stringTag:
            return new Ctor(object);
          case regexpTag:
            return cloneRegExp(object);
          case setTag:
            return new Ctor();
          case symbolTag:
            return cloneSymbol(object);
        }
      }
      function insertWrapDetails(source, details) {
        var length2 = details.length;
        if (!length2) {
          return source;
        }
        var lastIndex = length2 - 1;
        details[lastIndex] = (length2 > 1 ? "& " : "") + details[lastIndex];
        details = details.join(length2 > 2 ? ", " : " ");
        return source.replace(reWrapComment, "{\n/* [wrapped with " + details + "] */\n");
      }
      function isFlattenable(value) {
        return isArray2(value) || isArguments(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
      }
      function isIndex(value, length2) {
        var type2 = typeof value;
        length2 = length2 == null ? MAX_SAFE_INTEGER : length2;
        return !!length2 && (type2 == "number" || type2 != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length2);
      }
      function isIterateeCall(value, index2, object) {
        if (!isObject2(object)) {
          return false;
        }
        var type2 = typeof index2;
        if (type2 == "number" ? isArrayLike(object) && isIndex(index2, object.length) : type2 == "string" && index2 in object) {
          return eq(object[index2], value);
        }
        return false;
      }
      function isKey(value, object) {
        if (isArray2(value)) {
          return false;
        }
        var type2 = typeof value;
        if (type2 == "number" || type2 == "symbol" || type2 == "boolean" || value == null || isSymbol2(value)) {
          return true;
        }
        return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object2(object);
      }
      function isKeyable(value) {
        var type2 = typeof value;
        return type2 == "string" || type2 == "number" || type2 == "symbol" || type2 == "boolean" ? value !== "__proto__" : value === null;
      }
      function isLaziable(func) {
        var funcName = getFuncName(func), other = lodash2[funcName];
        if (typeof other != "function" || !(funcName in LazyWrapper.prototype)) {
          return false;
        }
        if (func === other) {
          return true;
        }
        var data = getData(other);
        return !!data && func === data[0];
      }
      function isMasked(func) {
        return !!maskSrcKey && maskSrcKey in func;
      }
      var isMaskable = coreJsData ? isFunction2 : stubFalse;
      function isPrototype(value) {
        var Ctor = value && value.constructor, proto2 = typeof Ctor == "function" && Ctor.prototype || objectProto;
        return value === proto2;
      }
      function isStrictComparable(value) {
        return value === value && !isObject2(value);
      }
      function matchesStrictComparable(key, srcValue) {
        return function(object) {
          if (object == null) {
            return false;
          }
          return object[key] === srcValue && (srcValue !== undefined$1 || key in Object2(object));
        };
      }
      function memoizeCapped(func) {
        var result2 = memoize(func, function(key) {
          if (cache2.size === MAX_MEMOIZE_SIZE) {
            cache2.clear();
          }
          return key;
        });
        var cache2 = result2.cache;
        return result2;
      }
      function mergeData(data, source) {
        var bitmask = data[1], srcBitmask = source[1], newBitmask = bitmask | srcBitmask, isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);
        var isCombo = srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_CURRY_FLAG || srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_REARG_FLAG && data[7].length <= source[8] || srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG) && source[7].length <= source[8] && bitmask == WRAP_CURRY_FLAG;
        if (!(isCommon || isCombo)) {
          return data;
        }
        if (srcBitmask & WRAP_BIND_FLAG) {
          data[2] = source[2];
          newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
        }
        var value = source[3];
        if (value) {
          var partials = data[3];
          data[3] = partials ? composeArgs(partials, value, source[4]) : value;
          data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : source[4];
        }
        value = source[5];
        if (value) {
          partials = data[5];
          data[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
          data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : source[6];
        }
        value = source[7];
        if (value) {
          data[7] = value;
        }
        if (srcBitmask & WRAP_ARY_FLAG) {
          data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
        }
        if (data[9] == null) {
          data[9] = source[9];
        }
        data[0] = source[0];
        data[1] = newBitmask;
        return data;
      }
      function nativeKeysIn(object) {
        var result2 = [];
        if (object != null) {
          for (var key in Object2(object)) {
            result2.push(key);
          }
        }
        return result2;
      }
      function objectToString2(value) {
        return nativeObjectToString.call(value);
      }
      function overRest(func, start, transform2) {
        start = nativeMax(start === undefined$1 ? func.length - 1 : start, 0);
        return function() {
          var args = arguments, index2 = -1, length2 = nativeMax(args.length - start, 0), array = Array2(length2);
          while (++index2 < length2) {
            array[index2] = args[start + index2];
          }
          index2 = -1;
          var otherArgs = Array2(start + 1);
          while (++index2 < start) {
            otherArgs[index2] = args[index2];
          }
          otherArgs[start] = transform2(array);
          return apply2(func, this, otherArgs);
        };
      }
      function parent(object, path) {
        return path.length < 2 ? object : baseGet(object, baseSlice(path, 0, -1));
      }
      function reorder(array, indexes) {
        var arrLength = array.length, length2 = nativeMin(indexes.length, arrLength), oldArray = copyArray(array);
        while (length2--) {
          var index2 = indexes[length2];
          array[length2] = isIndex(index2, arrLength) ? oldArray[index2] : undefined$1;
        }
        return array;
      }
      function safeGet(object, key) {
        if (key === "constructor" && typeof object[key] === "function") {
          return;
        }
        if (key == "__proto__") {
          return;
        }
        return object[key];
      }
      var setData = shortOut(baseSetData);
      var setTimeout2 = ctxSetTimeout || function(func, wait) {
        return root.setTimeout(func, wait);
      };
      var setToString = shortOut(baseSetToString);
      function setWrapToString(wrapper, reference3, bitmask) {
        var source = reference3 + "";
        return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
      }
      function shortOut(func) {
        var count = 0, lastCalled = 0;
        return function() {
          var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
          lastCalled = stamp;
          if (remaining > 0) {
            if (++count >= HOT_COUNT) {
              return arguments[0];
            }
          } else {
            count = 0;
          }
          return func.apply(undefined$1, arguments);
        };
      }
      function shuffleSelf(array, size3) {
        var index2 = -1, length2 = array.length, lastIndex = length2 - 1;
        size3 = size3 === undefined$1 ? length2 : size3;
        while (++index2 < size3) {
          var rand = baseRandom(index2, lastIndex), value = array[rand];
          array[rand] = array[index2];
          array[index2] = value;
        }
        array.length = size3;
        return array;
      }
      var stringToPath = memoizeCapped(function(string) {
        var result2 = [];
        if (string.charCodeAt(0) === 46) {
          result2.push("");
        }
        string.replace(rePropName, function(match3, number2, quote, subString) {
          result2.push(quote ? subString.replace(reEscapeChar, "$1") : number2 || match3);
        });
  