"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalSettingsActions = void 0;
const tslib_1 = require("tslib");
const types_1 = require("../../../types");
const p_defer_1 = tslib_1.__importDefault(require("p-defer"));
const lodash_1 = tslib_1.__importDefault(require("lodash"));
class LocalSettingsActions {
    constructor(ctx) {
        this.ctx = ctx;
    }
    async setPreferences(stringifiedJson, type) {
        const toJson = JSON.parse(stringifiedJson);
        if (type === 'global') {
            // update local data on server
            lodash_1.default.merge(this.ctx.coreData.localSettings.preferences, toJson);
            // persist to global appData - projects/__global__/state.json
            const currentGlobalPreferences = await this.ctx._apis.localSettingsApi.getPreferences();
            const combinedResult = lodash_1.default.merge(currentGlobalPreferences, toJson);
            return this.ctx._apis.localSettingsApi.setPreferences(combinedResult);
        }
        const currentLocalPreferences = this.ctx._apis.projectApi.getCurrentProjectSavedState();
        const combinedResult = lodash_1.default.merge(currentLocalPreferences, toJson);
        // persist to project appData - for example projects/launchpad/state.json
        return this.ctx._apis.projectApi.setProjectPreferences(combinedResult);
    }
    async refreshLocalSettings() {
        var _a;
        if ((_a = this.ctx.coreData.localSettings) === null || _a === void 0 ? void 0 : _a.refreshing) {
            return;
        }
        const dfd = (0, p_defer_1.default)();
        this.ctx.coreData.localSettings.refreshing = dfd.promise;
        // TODO(tim): global unhandled error concept
        const availableEditors = await this.ctx._apis.localSettingsApi.getAvailableEditors();
        this.ctx.coreData.localSettings.availableEditors = availableEditors;
        this.ctx.coreData.localSettings.preferences = {
            ...types_1.defaultPreferences,
            ...(await this.ctx._apis.localSettingsApi.getPreferences()),
        };
        dfd.resolve();
    }
}
exports.LocalSettingsActions = LocalSettingsActions;
