"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventCollectorActions = void 0;
const tslib_1 = require("tslib");
const debug_1 = tslib_1.__importDefault(require("debug"));
const pkg = require('../../../root');
const debug = (0, debug_1.default)('cypress:data-context:actions:EventCollectorActions');
/**
 * Defaults to staging when doing development. To override to production for development,
 * explicitly set process.env.CYPRESS_INTERNAL_ENV to 'production`
 */
const cloudEnv = (process.env.CYPRESS_INTERNAL_EVENT_COLLECTOR_ENV || 'production');
class EventCollectorActions {
    constructor(ctx) {
        this.ctx = ctx;
        debug('Using %s environment for Event Collection', cloudEnv);
    }
    async recordEvent(event) {
        try {
            const cloudUrl = this.ctx.cloud.getCloudUrl(cloudEnv);
            await this.ctx.util.fetch(`${cloudUrl}/anon-collect`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'x-cypress-version': pkg.version,
                },
                body: JSON.stringify(event),
            });
            debug(`Recorded event: %o`, event);
            return true;
        }
        catch (err) {
            debug(`Failed to record event %o due to error %o`, event, err);
            return false;
        }
    }
}
exports.EventCollectorActions = EventCollectorActions;
