(function polyfill() {
  const relList = document.createElement("link").relList;
  if (relList && relList.supports && relList.supports("modulepreload")) {
    return;
  }
  for (const link4 of document.querySelectorAll('link[rel="modulepreload"]')) {
    processPreload(link4);
  }
  new MutationObserver((mutations) => {
    for (const mutation of mutations) {
      if (mutation.type !== "childList") {
        continue;
      }
      for (const node of mutation.addedNodes) {
        if (node.tagName === "LINK" && node.rel === "modulepreload")
          processPreload(node);
      }
    }
  }).observe(document, { childList: true, subtree: true });
  function getFetchOpts(script2) {
    const fetchOpts = {};
    if (script2.integrity)
      fetchOpts.integrity = script2.integrity;
    if (script2.referrerpolicy)
      fetchOpts.referrerPolicy = script2.referrerpolicy;
    if (script2.crossorigin === "use-credentials")
      fetchOpts.credentials = "include";
    else if (script2.crossorigin === "anonymous")
      fetchOpts.credentials = "omit";
    else
      fetchOpts.credentials = "same-origin";
    return fetchOpts;
  }
  function processPreload(link4) {
    if (link4.ep)
      return;
    link4.ep = true;
    const fetchOpts = getFetchOpts(link4);
    fetch(link4.href, fetchOpts);
  }
})();
function makeMap(str, expectsLowerCase) {
  const map2 = /* @__PURE__ */ Object.create(null);
  const list3 = str.split(",");
  for (let i = 0; i < list3.length; i++) {
    map2[list3[i]] = true;
  }
  return expectsLowerCase ? (val) => !!map2[val.toLowerCase()] : (val) => !!map2[val];
}
const specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
const isSpecialBooleanAttr = /* @__PURE__ */ makeMap(specialBooleanAttrs);
function includeBooleanAttr(value) {
  return !!value || value === "";
}
function normalizeStyle(value) {
  if (isArray$2(value)) {
    const res = {};
    for (let i = 0; i < value.length; i++) {
      const item = value[i];
      const normalized = isString$5(item) ? parseStringStyle(item) : normalizeStyle(item);
      if (normalized) {
        for (const key in normalized) {
          res[key] = normalized[key];
        }
      }
    }
    return res;
  } else if (isString$5(value)) {
    return value;
  } else if (isObject$6(value)) {
    return value;
  }
}
const listDelimiterRE = /;(?![^(]*\))/g;
const propertyDelimiterRE = /:(.+)/;
function parseStringStyle(cssText) {
  const ret = {};
  cssText.split(listDelimiterRE).forEach((item) => {
    if (item) {
      const tmp = item.split(propertyDelimiterRE);
      tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
    }
  });
  return ret;
}
function normalizeClass(value) {
  let res = "";
  if (isString$5(value)) {
    res = value;
  } else if (isArray$2(value)) {
    for (let i = 0; i < value.length; i++) {
      const normalized = normalizeClass(value[i]);
      if (normalized) {
        res += normalized + " ";
      }
    }
  } else if (isObject$6(value)) {
    for (const name2 in value) {
      if (value[name2]) {
        res += name2 + " ";
      }
    }
  }
  return res.trim();
}
function normalizeProps(props) {
  if (!props)
    return null;
  let { class: klass, style } = props;
  if (klass && !isString$5(klass)) {
    props.class = normalizeClass(klass);
  }
  if (style) {
    props.style = normalizeStyle(style);
  }
  return props;
}
function looseCompareArrays(a2, b2) {
  if (a2.length !== b2.length)
    return false;
  let equal = true;
  for (let i = 0; equal && i < a2.length; i++) {
    equal = looseEqual(a2[i], b2[i]);
  }
  return equal;
}
function looseEqual(a2, b2) {
  if (a2 === b2)
    return true;
  let aValidType = isDate$1(a2);
  let bValidType = isDate$1(b2);
  if (aValidType || bValidType) {
    return aValidType && bValidType ? a2.getTime() === b2.getTime() : false;
  }
  aValidType = isArray$2(a2);
  bValidType = isArray$2(b2);
  if (aValidType || bValidType) {
    return aValidType && bValidType ? looseCompareArrays(a2, b2) : false;
  }
  aValidType = isObject$6(a2);
  bValidType = isObject$6(b2);
  if (aValidType || bValidType) {
    if (!aValidType || !bValidType) {
      return false;
    }
    const aKeysCount = Object.keys(a2).length;
    const bKeysCount = Object.keys(b2).length;
    if (aKeysCount !== bKeysCount) {
      return false;
    }
    for (const key in a2) {
      const aHasKey = a2.hasOwnProperty(key);
      const bHasKey = b2.hasOwnProperty(key);
      if (aHasKey && !bHasKey || !aHasKey && bHasKey || !looseEqual(a2[key], b2[key])) {
        return false;
      }
    }
  }
  return String(a2) === String(b2);
}
function looseIndexOf(arr, val) {
  return arr.findIndex((item) => looseEqual(item, val));
}
const toDisplayString$1 = (val) => {
  return isString$5(val) ? val : val == null ? "" : isArray$2(val) || isObject$6(val) && (val.toString === objectToString$2 || !isFunction$4(val.toString)) ? JSON.stringify(val, replacer, 2) : String(val);
};
const replacer = (_key, val) => {
  if (val && val.__v_isRef) {
    return replacer(_key, val.value);
  } else if (isMap(val)) {
    return {
      [`Map(${val.size})`]: [...val.entries()].reduce((entries, [key, val2]) => {
        entries[`${key} =>`] = val2;
        return entries;
      }, {})
    };
  } else if (isSet(val)) {
    return {
      [`Set(${val.size})`]: [...val.values()]
    };
  } else if (isObject$6(val) && !isArray$2(val) && !isPlainObject$4(val)) {
    return String(val);
  }
  return val;
};
const EMPTY_OBJ = {};
const EMPTY_ARR = [];
const NOOP = () => {
};
const NO = () => false;
const onRE = /^on[^a-z]/;
const isOn = (key) => onRE.test(key);
const isModelListener = (key) => key.startsWith("onUpdate:");
const extend = Object.assign;
const remove = (arr, el2) => {
  const i = arr.indexOf(el2);
  if (i > -1) {
    arr.splice(i, 1);
  }
};
const hasOwnProperty$3 = Object.prototype.hasOwnProperty;
const hasOwn$1 = (val, key) => hasOwnProperty$3.call(val, key);
const isArray$2 = Array.isArray;
const isMap = (val) => toTypeString$2(val) === "[object Map]";
const isSet = (val) => toTypeString$2(val) === "[object Set]";
const isDate$1 = (val) => val instanceof Date;
const isFunction$4 = (val) => typeof val === "function";
const isString$5 = (val) => typeof val === "string";
const isSymbol = (val) => typeof val === "symbol";
const isObject$6 = (val) => val !== null && typeof val === "object";
const isPromise = (val) => {
  return isObject$6(val) && isFunction$4(val.then) && isFunction$4(val.catch);
};
const objectToString$2 = Object.prototype.toString;
const toTypeString$2 = (value) => objectToString$2.call(value);
const toRawType = (value) => {
  return toTypeString$2(value).slice(8, -1);
};
const isPlainObject$4 = (val) => toTypeString$2(val) === "[object Object]";
const isIntegerKey = (key) => isString$5(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
const isReservedProp = /* @__PURE__ */ makeMap(
  ",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"
);
const cacheStringFunction = (fn2) => {
  const cache2 = /* @__PURE__ */ Object.create(null);
  return (str) => {
    const hit = cache2[str];
    return hit || (cache2[str] = fn2(str));
  };
};
const camelizeRE = /-(\w)/g;
const camelize = cacheStringFunction((str) => {
  return str.replace(camelizeRE, (_2, c2) => c2 ? c2.toUpperCase() : "");
});
const hyphenateRE = /\B([A-Z])/g;
const hyphenate = cacheStringFunction((str) => str.replace(hyphenateRE, "-$1").toLowerCase());
const capitalize = cacheStringFunction((str) => str.charAt(0).toUpperCase() + str.slice(1));
const toHandlerKey = cacheStringFunction((str) => str ? `on${capitalize(str)}` : ``);
const hasChanged = (value, oldValue) => !Object.is(value, oldValue);
const invokeArrayFns = (fns, arg) => {
  for (let i = 0; i < fns.length; i++) {
    fns[i](arg);
  }
};
const def = (obj, key, value) => {
  Object.defineProperty(obj, key, {
    configurable: true,
    enumerable: false,
    value
  });
};
const toNumber = (val) => {
  const n = parseFloat(val);
  return isNaN(n) ? val : n;
};
let _globalThis$2;
const getGlobalThis$2 = () => {
  return _globalThis$2 || (_globalThis$2 = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
};
let activeEffectScope;
class EffectScope {
  constructor(detached = false) {
    this.active = true;
    this.effects = [];
    this.cleanups = [];
    if (!detached && activeEffectScope) {
      this.parent = activeEffectScope;
      this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(this) - 1;
    }
  }
  run(fn2) {
    if (this.active) {
      try {
        activeEffectScope = this;
        return fn2();
      } finally {
        activeEffectScope = this.parent;
      }
    }
  }
  on() {
    activeEffectScope = this;
  }
  off() {
    activeEffectScope = this.parent;
  }
  stop(fromParent) {
    if (this.active) {
      let i, l2;
      for (i = 0, l2 = this.effects.length; i < l2; i++) {
        this.effects[i].stop();
      }
      for (i = 0, l2 = this.cleanups.length; i < l2; i++) {
        this.cleanups[i]();
      }
      if (this.scopes) {
        for (i = 0, l2 = this.scopes.length; i < l2; i++) {
          this.scopes[i].stop(true);
        }
      }
      if (this.parent && !fromParent) {
        const last = this.parent.scopes.pop();
        if (last && last !== this) {
          this.parent.scopes[this.index] = last;
          last.index = this.index;
        }
      }
      this.active = false;
    }
  }
}
function effectScope(detached) {
  return new EffectScope(detached);
}
function recordEffectScope(effect2, scope = activeEffectScope) {
  if (scope && scope.active) {
    scope.effects.push(effect2);
  }
}
function getCurrentScope() {
  return activeEffectScope;
}
function onScopeDispose(fn2) {
  if (activeEffectScope) {
    activeEffectScope.cleanups.push(fn2);
  }
}
const createDep = (effects) => {
  const dep = new Set(effects);
  dep.w = 0;
  dep.n = 0;
  return dep;
};
const wasTracked = (dep) => (dep.w & trackOpBit) > 0;
const newTracked = (dep) => (dep.n & trackOpBit) > 0;
const initDepMarkers = ({ deps }) => {
  if (deps.length) {
    for (let i = 0; i < deps.length; i++) {
      deps[i].w |= trackOpBit;
    }
  }
};
const finalizeDepMarkers = (effect2) => {
  const { deps } = effect2;
  if (deps.length) {
    let ptr = 0;
    for (let i = 0; i < deps.length; i++) {
      const dep = deps[i];
      if (wasTracked(dep) && !newTracked(dep)) {
        dep.delete(effect2);
      } else {
        deps[ptr++] = dep;
      }
      dep.w &= ~trackOpBit;
      dep.n &= ~trackOpBit;
    }
    deps.length = ptr;
  }
};
const targetMap = /* @__PURE__ */ new WeakMap();
let effectTrackDepth = 0;
let trackOpBit = 1;
const maxMarkerBits = 30;
let activeEffect;
const ITERATE_KEY = Symbol("");
const MAP_KEY_ITERATE_KEY = Symbol("");
class ReactiveEffect {
  constructor(fn2, scheduler = null, scope) {
    this.fn = fn2;
    this.scheduler = scheduler;
    this.active = true;
    this.deps = [];
    this.parent = void 0;
    recordEffectScope(this, scope);
  }
  run() {
    if (!this.active) {
      return this.fn();
    }
    let parent = activeEffect;
    let lastShouldTrack = shouldTrack;
    while (parent) {
      if (parent === this) {
        return;
      }
      parent = parent.parent;
    }
    try {
      this.parent = activeEffect;
      activeEffect = this;
      shouldTrack = true;
      trackOpBit = 1 << ++effectTrackDepth;
      if (effectTrackDepth <= maxMarkerBits) {
        initDepMarkers(this);
      } else {
        cleanupEffect(this);
      }
      return this.fn();
    } finally {
      if (effectTrackDepth <= maxMarkerBits) {
        finalizeDepMarkers(this);
      }
      trackOpBit = 1 << --effectTrackDepth;
      activeEffect = this.parent;
      shouldTrack = lastShouldTrack;
      this.parent = void 0;
    }
  }
  stop() {
    if (this.active) {
      cleanupEffect(this);
      if (this.onStop) {
        this.onStop();
      }
      this.active = false;
    }
  }
}
function cleanupEffect(effect2) {
  const { deps } = effect2;
  if (deps.length) {
    for (let i = 0; i < deps.length; i++) {
      deps[i].delete(effect2);
    }
    deps.length = 0;
  }
}
let shouldTrack = true;
const trackStack = [];
function pauseTracking() {
  trackStack.push(shouldTrack);
  shouldTrack = false;
}
function resetTracking() {
  const last = trackStack.pop();
  shouldTrack = last === void 0 ? true : last;
}
function track(target2, type2, key) {
  if (shouldTrack && activeEffect) {
    let depsMap = targetMap.get(target2);
    if (!depsMap) {
      targetMap.set(target2, depsMap = /* @__PURE__ */ new Map());
    }
    let dep = depsMap.get(key);
    if (!dep) {
      depsMap.set(key, dep = createDep());
    }
    trackEffects(dep);
  }
}
function trackEffects(dep, debuggerEventExtraInfo) {
  let shouldTrack2 = false;
  if (effectTrackDepth <= maxMarkerBits) {
    if (!newTracked(dep)) {
      dep.n |= trackOpBit;
      shouldTrack2 = !wasTracked(dep);
    }
  } else {
    shouldTrack2 = !dep.has(activeEffect);
  }
  if (shouldTrack2) {
    dep.add(activeEffect);
    activeEffect.deps.push(dep);
  }
}
function trigger$1(target2, type2, key, newValue, oldValue, oldTarget) {
  const depsMap = targetMap.get(target2);
  if (!depsMap) {
    return;
  }
  let deps = [];
  if (type2 === "clear") {
    deps = [...depsMap.values()];
  } else if (key === "length" && isArray$2(target2)) {
    depsMap.forEach((dep, key2) => {
      if (key2 === "length" || key2 >= newValue) {
        deps.push(dep);
      }
    });
  } else {
    if (key !== void 0) {
      deps.push(depsMap.get(key));
    }
    switch (type2) {
      case "add":
        if (!isArray$2(target2)) {
          deps.push(depsMap.get(ITERATE_KEY));
          if (isMap(target2)) {
            deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
          }
        } else if (isIntegerKey(key)) {
          deps.push(depsMap.get("length"));
        }
        break;
      case "delete":
        if (!isArray$2(target2)) {
          deps.push(depsMap.get(ITERATE_KEY));
          if (isMap(target2)) {
            deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
          }
        }
        break;
      case "set":
        if (isMap(target2)) {
          deps.push(depsMap.get(ITERATE_KEY));
        }
        break;
    }
  }
  if (deps.length === 1) {
    if (deps[0]) {
      {
        triggerEffects(deps[0]);
      }
    }
  } else {
    const effects = [];
    for (const dep of deps) {
      if (dep) {
        effects.push(...dep);
      }
    }
    {
      triggerEffects(createDep(effects));
    }
  }
}
function triggerEffects(dep, debuggerEventExtraInfo) {
  for (const effect2 of isArray$2(dep) ? dep : [...dep]) {
    if (effect2 !== activeEffect || effect2.allowRecurse) {
      if (effect2.scheduler) {
        effect2.scheduler();
      } else {
        effect2.run();
      }
    }
  }
}
const isNonTrackableKeys = /* @__PURE__ */ makeMap(`__proto__,__v_isRef,__isVue`);
const builtInSymbols = new Set(Object.getOwnPropertyNames(Symbol).map((key) => Symbol[key]).filter(isSymbol));
const get$1 = /* @__PURE__ */ createGetter();
const shallowGet = /* @__PURE__ */ createGetter(false, true);
const readonlyGet = /* @__PURE__ */ createGetter(true);
const arrayInstrumentations = /* @__PURE__ */ createArrayInstrumentations();
function createArrayInstrumentations() {
  const instrumentations = {};
  ["includes", "indexOf", "lastIndexOf"].forEach((key) => {
    instrumentations[key] = function(...args) {
      const arr = toRaw(this);
      for (let i = 0, l2 = this.length; i < l2; i++) {
        track(arr, "get", i + "");
      }
      const res = arr[key](...args);
      if (res === -1 || res === false) {
        return arr[key](...args.map(toRaw));
      } else {
        return res;
      }
    };
  });
  ["push", "pop", "shift", "unshift", "splice"].forEach((key) => {
    instrumentations[key] = function(...args) {
      pauseTracking();
      const res = toRaw(this)[key].apply(this, args);
      resetTracking();
      return res;
    };
  });
  return instrumentations;
}
function createGetter(isReadonly2 = false, shallow = false) {
  return function get2(target2, key, receiver) {
    if (key === "__v_isReactive") {
      return !isReadonly2;
    } else if (key === "__v_isReadonly") {
      return isReadonly2;
    } else if (key === "__v_isShallow") {
      return shallow;
    } else if (key === "__v_raw" && receiver === (isReadonly2 ? shallow ? shallowReadonlyMap : readonlyMap : shallow ? shallowReactiveMap : reactiveMap).get(target2)) {
      return target2;
    }
    const targetIsArray = isArray$2(target2);
    if (!isReadonly2 && targetIsArray && hasOwn$1(arrayInstrumentations, key)) {
      return Reflect.get(arrayInstrumentations, key, receiver);
    }
    const res = Reflect.get(target2, key, receiver);
    if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
      return res;
    }
    if (!isReadonly2) {
      track(target2, "get", key);
    }
    if (shallow) {
      return res;
    }
    if (isRef(res)) {
      const shouldUnwrap = !targetIsArray || !isIntegerKey(key);
      return shouldUnwrap ? res.value : res;
    }
    if (isObject$6(res)) {
      return isReadonly2 ? readonly(res) : reactive(res);
    }
    return res;
  };
}
const set$1 = /* @__PURE__ */ createSetter();
const shallowSet = /* @__PURE__ */ createSetter(true);
function createSetter(shallow = false) {
  return function set3(target2, key, value, receiver) {
    let oldValue = target2[key];
    if (isReadonly(oldValue) && isRef(oldValue) && !isRef(value)) {
      return false;
    }
    if (!shallow && !isReadonly(value)) {
      if (!isShallow(value)) {
        value = toRaw(value);
        oldValue = toRaw(oldValue);
      }
      if (!isArray$2(target2) && isRef(oldValue) && !isRef(value)) {
        oldValue.value = value;
        return true;
      }
    }
    const hadKey = isArray$2(target2) && isIntegerKey(key) ? Number(key) < target2.length : hasOwn$1(target2, key);
    const result = Reflect.set(target2, key, value, receiver);
    if (target2 === toRaw(receiver)) {
      if (!hadKey) {
        trigger$1(target2, "add", key, value);
      } else if (hasChanged(value, oldValue)) {
        trigger$1(target2, "set", key, value);
      }
    }
    return result;
  };
}
function deleteProperty(target2, key) {
  const hadKey = hasOwn$1(target2, key);
  target2[key];
  const result = Reflect.deleteProperty(target2, key);
  if (result && hadKey) {
    trigger$1(target2, "delete", key, void 0);
  }
  return result;
}
function has$2(target2, key) {
  const result = Reflect.has(target2, key);
  if (!isSymbol(key) || !builtInSymbols.has(key)) {
    track(target2, "has", key);
  }
  return result;
}
function ownKeys(target2) {
  track(target2, "iterate", isArray$2(target2) ? "length" : ITERATE_KEY);
  return Reflect.ownKeys(target2);
}
const mutableHandlers = {
  get: get$1,
  set: set$1,
  deleteProperty,
  has: has$2,
  ownKeys
};
const readonlyHandlers = {
  get: readonlyGet,
  set(target2, key) {
    return true;
  },
  deleteProperty(target2, key) {
    return true;
  }
};
const shallowReactiveHandlers = /* @__PURE__ */ extend({}, mutableHandlers, {
  get: shallowGet,
  set: shallowSet
});
const toShallow = (value) => value;
const getProto = (v) => Reflect.getPrototypeOf(v);
function get$1$1(target2, key, isReadonly2 = false, isShallow2 = false) {
  target2 = target2["__v_raw"];
  const rawTarget = toRaw(target2);
  const rawKey = toRaw(key);
  if (key !== rawKey) {
    !isReadonly2 && track(rawTarget, "get", key);
  }
  !isReadonly2 && track(rawTarget, "get", rawKey);
  const { has: has2 } = getProto(rawTarget);
  const wrap2 = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
  if (has2.call(rawTarget, key)) {
    return wrap2(target2.get(key));
  } else if (has2.call(rawTarget, rawKey)) {
    return wrap2(target2.get(rawKey));
  } else if (target2 !== rawTarget) {
    target2.get(key);
  }
}
function has$1$1(key, isReadonly2 = false) {
  const target2 = this["__v_raw"];
  const rawTarget = toRaw(target2);
  const rawKey = toRaw(key);
  if (key !== rawKey) {
    !isReadonly2 && track(rawTarget, "has", key);
  }
  !isReadonly2 && track(rawTarget, "has", rawKey);
  return key === rawKey ? target2.has(key) : target2.has(key) || target2.has(rawKey);
}
function size$1(target2, isReadonly2 = false) {
  target2 = target2["__v_raw"];
  !isReadonly2 && track(toRaw(target2), "iterate", ITERATE_KEY);
  return Reflect.get(target2, "size", target2);
}
function add(value) {
  value = toRaw(value);
  const target2 = toRaw(this);
  const proto2 = getProto(target2);
  const hadKey = proto2.has.call(target2, value);
  if (!hadKey) {
    target2.add(value);
    trigger$1(target2, "add", value, value);
  }
  return this;
}
function set$1$1(key, value) {
  value = toRaw(value);
  const target2 = toRaw(this);
  const { has: has2, get: get2 } = getProto(target2);
  let hadKey = has2.call(target2, key);
  if (!hadKey) {
    key = toRaw(key);
    hadKey = has2.call(target2, key);
  }
  const oldValue = get2.call(target2, key);
  target2.set(key, value);
  if (!hadKey) {
    trigger$1(target2, "add", key, value);
  } else if (hasChanged(value, oldValue)) {
    trigger$1(target2, "set", key, value);
  }
  return this;
}
function deleteEntry(key) {
  const target2 = toRaw(this);
  const { has: has2, get: get2 } = getProto(target2);
  let hadKey = has2.call(target2, key);
  if (!hadKey) {
    key = toRaw(key);
    hadKey = has2.call(target2, key);
  }
  get2 ? get2.call(target2, key) : void 0;
  const result = target2.delete(key);
  if (hadKey) {
    trigger$1(target2, "delete", key, void 0);
  }
  return result;
}
function clear() {
  const target2 = toRaw(this);
  const hadItems = target2.size !== 0;
  const result = target2.clear();
  if (hadItems) {
    trigger$1(target2, "clear", void 0, void 0);
  }
  return result;
}
function createForEach(isReadonly2, isShallow2) {
  return function forEach(callback, thisArg) {
    const observed = this;
    const target2 = observed["__v_raw"];
    const rawTarget = toRaw(target2);
    const wrap2 = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
    !isReadonly2 && track(rawTarget, "iterate", ITERATE_KEY);
    return target2.forEach((value, key) => {
      return callback.call(thisArg, wrap2(value), wrap2(key), observed);
    });
  };
}
function createIterableMethod(method, isReadonly2, isShallow2) {
  return function(...args) {
    const target2 = this["__v_raw"];
    const rawTarget = toRaw(target2);
    const targetIsMap = isMap(rawTarget);
    const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
    const isKeyOnly = method === "keys" && targetIsMap;
    const innerIterator = target2[method](...args);
    const wrap2 = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
    !isReadonly2 && track(rawTarget, "iterate", isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY);
    return {
      next() {
        const { value, done } = innerIterator.next();
        return done ? { value, done } : {
          value: isPair ? [wrap2(value[0]), wrap2(value[1])] : wrap2(value),
          done
        };
      },
      [Symbol.iterator]() {
        return this;
      }
    };
  };
}
function createReadonlyMethod(type2) {
  return function(...args) {
    return type2 === "delete" ? false : this;
  };
}
function createInstrumentations() {
  const mutableInstrumentations2 = {
    get(key) {
      return get$1$1(this, key);
    },
    get size() {
      return size$1(this);
    },
    has: has$1$1,
    add,
    set: set$1$1,
    delete: deleteEntry,
    clear,
    forEach: createForEach(false, false)
  };
  const shallowInstrumentations2 = {
    get(key) {
      return get$1$1(this, key, false, true);
    },
    get size() {
      return size$1(this);
    },
    has: has$1$1,
    add,
    set: set$1$1,
    delete: deleteEntry,
    clear,
    forEach: createForEach(false, true)
  };
  const readonlyInstrumentations2 = {
    get(key) {
      return get$1$1(this, key, true);
    },
    get size() {
      return size$1(this, true);
    },
    has(key) {
      return has$1$1.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, false)
  };
  const shallowReadonlyInstrumentations2 = {
    get(key) {
      return get$1$1(this, key, true, true);
    },
    get size() {
      return size$1(this, true);
    },
    has(key) {
      return has$1$1.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, true)
  };
  const iteratorMethods = ["keys", "values", "entries", Symbol.iterator];
  iteratorMethods.forEach((method) => {
    mutableInstrumentations2[method] = createIterableMethod(method, false, false);
    readonlyInstrumentations2[method] = createIterableMethod(method, true, false);
    shallowInstrumentations2[method] = createIterableMethod(method, false, true);
    shallowReadonlyInstrumentations2[method] = createIterableMethod(method, true, true);
  });
  return [
    mutableInstrumentations2,
    readonlyInstrumentations2,
    shallowInstrumentations2,
    shallowReadonlyInstrumentations2
  ];
}
const [mutableInstrumentations, readonlyInstrumentations, shallowInstrumentations, shallowReadonlyInstrumentations] = /* @__PURE__ */ createInstrumentations();
function createInstrumentationGetter(isReadonly2, shallow) {
  const instrumentations = shallow ? isReadonly2 ? shallowReadonlyInstrumentations : shallowInstrumentations : isReadonly2 ? readonlyInstrumentations : mutableInstrumentations;
  return (target2, key, receiver) => {
    if (key === "__v_isReactive") {
      return !isReadonly2;
    } else if (key === "__v_isReadonly") {
      return isReadonly2;
    } else if (key === "__v_raw") {
      return target2;
    }
    return Reflect.get(hasOwn$1(instrumentations, key) && key in target2 ? instrumentations : target2, key, receiver);
  };
}
const mutableCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(false, false)
};
const shallowCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(false, true)
};
const readonlyCollectionHandlers = {
  get: /* @__PURE__ */ createInstrumentationGetter(true, false)
};
const reactiveMap = /* @__PURE__ */ new WeakMap();
const shallowReactiveMap = /* @__PURE__ */ new WeakMap();
const readonlyMap = /* @__PURE__ */ new WeakMap();
const shallowReadonlyMap = /* @__PURE__ */ new WeakMap();
function targetTypeMap(rawType) {
  switch (rawType) {
    case "Object":
    case "Array":
      return 1;
    case "Map":
    case "Set":
    case "WeakMap":
    case "WeakSet":
      return 2;
    default:
      return 0;
  }
}
function getTargetType(value) {
  return value["__v_skip"] || !Object.isExtensible(value) ? 0 : targetTypeMap(toRawType(value));
}
function reactive(target2) {
  if (isReadonly(target2)) {
    return target2;
  }
  return createReactiveObject(target2, false, mutableHandlers, mutableCollectionHandlers, reactiveMap);
}
function shallowReactive(target2) {
  return createReactiveObject(target2, false, shallowReactiveHandlers, shallowCollectionHandlers, shallowReactiveMap);
}
function readonly(target2) {
  return createReactiveObject(target2, true, readonlyHandlers, readonlyCollectionHandlers, readonlyMap);
}
function createReactiveObject(target2, isReadonly2, baseHandlers, collectionHandlers, proxyMap) {
  if (!isObject$6(target2)) {
    return target2;
  }
  if (target2["__v_raw"] && !(isReadonly2 && target2["__v_isReactive"])) {
    return target2;
  }
  const existingProxy = proxyMap.get(target2);
  if (existingProxy) {
    return existingProxy;
  }
  const targetType = getTargetType(target2);
  if (targetType === 0) {
    return target2;
  }
  const proxy = new Proxy(target2, targetType === 2 ? collectionHandlers : baseHandlers);
  proxyMap.set(target2, proxy);
  return proxy;
}
function isReactive(value) {
  if (isReadonly(value)) {
    return isReactive(value["__v_raw"]);
  }
  return !!(value && value["__v_isReactive"]);
}
function isReadonly(value) {
  return !!(value && value["__v_isReadonly"]);
}
function isShallow(value) {
  return !!(value && value["__v_isShallow"]);
}
function isProxy(value) {
  return isReactive(value) || isReadonly(value);
}
function toRaw(observed) {
  const raw = observed && observed["__v_raw"];
  return raw ? toRaw(raw) : observed;
}
function markRaw(value) {
  def(value, "__v_skip", true);
  return value;
}
const toReactive = (value) => isObject$6(value) ? reactive(value) : value;
const toReadonly = (value) => isObject$6(value) ? readonly(value) : value;
function trackRefValue(ref2) {
  if (shouldTrack && activeEffect) {
    ref2 = toRaw(ref2);
    {
      trackEffects(ref2.dep || (ref2.dep = createDep()));
    }
  }
}
function triggerRefValue(ref2, newVal) {
  ref2 = toRaw(ref2);
  if (ref2.dep) {
    {
      triggerEffects(ref2.dep);
    }
  }
}
function isRef(r2) {
  return !!(r2 && r2.__v_isRef === true);
}
function ref(value) {
  return createRef(value, false);
}
function shallowRef(value) {
  return createRef(value, true);
}
function createRef(rawValue, shallow) {
  if (isRef(rawValue)) {
    return rawValue;
  }
  return new RefImpl(rawValue, shallow);
}
class RefImpl {
  constructor(value, __v_isShallow) {
    this.__v_isShallow = __v_isShallow;
    this.dep = void 0;
    this.__v_isRef = true;
    this._rawValue = __v_isShallow ? value : toRaw(value);
    this._value = __v_isShallow ? value : toReactive(value);
  }
  get value() {
    trackRefValue(this);
    return this._value;
  }
  set value(newVal) {
    newVal = this.__v_isShallow ? newVal : toRaw(newVal);
    if (hasChanged(newVal, this._rawValue)) {
      this._rawValue = newVal;
      this._value = this.__v_isShallow ? newVal : toReactive(newVal);
      triggerRefValue(this);
    }
  }
}
function unref(ref2) {
  return isRef(ref2) ? ref2.value : ref2;
}
const shallowUnwrapHandlers = {
  get: (target2, key, receiver) => unref(Reflect.get(target2, key, receiver)),
  set: (target2, key, value, receiver) => {
    const oldValue = target2[key];
    if (isRef(oldValue) && !isRef(value)) {
      oldValue.value = value;
      return true;
    } else {
      return Reflect.set(target2, key, value, receiver);
    }
  }
};
function proxyRefs(objectWithRefs) {
  return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
}
function toRefs(object) {
  const ret = isArray$2(object) ? new Array(object.length) : {};
  for (const key in object) {
    ret[key] = toRef(object, key);
  }
  return ret;
}
class ObjectRefImpl {
  constructor(_object, _key, _defaultValue) {
    this._object = _object;
    this._key = _key;
    this._defaultValue = _defaultValue;
    this.__v_isRef = true;
  }
  get value() {
    const val = this._object[this._key];
    return val === void 0 ? this._defaultValue : val;
  }
  set value(newVal) {
    this._object[this._key] = newVal;
  }
}
function toRef(object, key, defaultValue) {
  const val = object[key];
  return isRef(val) ? val : new ObjectRefImpl(object, key, defaultValue);
}
class ComputedRefImpl {
  constructor(getter, _setter, isReadonly2, isSSR) {
    this._setter = _setter;
    this.dep = void 0;
    this.__v_isRef = true;
    this._dirty = true;
    this.effect = new ReactiveEffect(getter, () => {
      if (!this._dirty) {
        this._dirty = true;
        triggerRefValue(this);
      }
    });
    this.effect.computed = this;
    this.effect.active = this._cacheable = !isSSR;
    this["__v_isReadonly"] = isReadonly2;
  }
  get value() {
    const self2 = toRaw(this);
    trackRefValue(self2);
    if (self2._dirty || !self2._cacheable) {
      self2._dirty = false;
      self2._value = self2.effect.run();
    }
    return self2._value;
  }
  set value(newValue) {
    this._setter(newValue);
  }
}
function computed$1(getterOrOptions, debugOptions, isSSR = false) {
  let getter;
  let setter;
  const onlyGetter = isFunction$4(getterOrOptions);
  if (onlyGetter) {
    getter = getterOrOptions;
    setter = NOOP;
  } else {
    getter = getterOrOptions.get;
    setter = getterOrOptions.set;
  }
  const cRef = new ComputedRefImpl(getter, setter, onlyGetter || !setter, isSSR);
  return cRef;
}
Promise.resolve();
function callWithErrorHandling(fn2, instance, type2, args) {
  let res;
  try {
    res = args ? fn2(...args) : fn2();
  } catch (err) {
    handleError(err, instance, type2);
  }
  return res;
}
function callWithAsyncErrorHandling(fn2, instance, type2, args) {
  if (isFunction$4(fn2)) {
    const res = callWithErrorHandling(fn2, instance, type2, args);
    if (res && isPromise(res)) {
      res.catch((err) => {
        handleError(err, instance, type2);
      });
    }
    return res;
  }
  const values = [];
  for (let i = 0; i < fn2.length; i++) {
    values.push(callWithAsyncErrorHandling(fn2[i], instance, type2, args));
  }
  return values;
}
function handleError(err, instance, type2, throwInDev = true) {
  const contextVNode = instance ? instance.vnode : null;
  if (instance) {
    let cur = instance.parent;
    const exposedInstance = instance.proxy;
    const errorInfo = type2;
    while (cur) {
      const errorCapturedHooks = cur.ec;
      if (errorCapturedHooks) {
        for (let i = 0; i < errorCapturedHooks.length; i++) {
          if (errorCapturedHooks[i](err, exposedInstance, errorInfo) === false) {
            return;
          }
        }
      }
      cur = cur.parent;
    }
    const appErrorHandler = instance.appContext.config.errorHandler;
    if (appErrorHandler) {
      callWithErrorHandling(appErrorHandler, null, 10, [err, exposedInstance, errorInfo]);
      return;
    }
  }
  logError(err, type2, contextVNode, throwInDev);
}
function logError(err, type2, contextVNode, throwInDev = true) {
  {
    console.error(err);
  }
}
let isFlushing = false;
let isFlushPending = false;
const queue = [];
let flushIndex = 0;
const pendingPreFlushCbs = [];
let activePreFlushCbs = null;
let preFlushIndex = 0;
const pendingPostFlushCbs = [];
let activePostFlushCbs = null;
let postFlushIndex = 0;
const resolvedPromise = Promise.resolve();
let currentFlushPromise = null;
let currentPreFlushParentJob = null;
function nextTick(fn2) {
  const p2 = currentFlushPromise || resolvedPromise;
  return fn2 ? p2.then(this ? fn2.bind(this) : fn2) : p2;
}
function findInsertionIndex(id2) {
  let start2 = flushIndex + 1;
  let end2 = queue.length;
  while (start2 < end2) {
    const middle = start2 + end2 >>> 1;
    const middleJobId = getId$1(queue[middle]);
    middleJobId < id2 ? start2 = middle + 1 : end2 = middle;
  }
  return start2;
}
function queueJob(job) {
  if ((!queue.length || !queue.includes(job, isFlushing && job.allowRecurse ? flushIndex + 1 : flushIndex)) && job !== currentPreFlushParentJob) {
    if (job.id == null) {
      queue.push(job);
    } else {
      queue.splice(findInsertionIndex(job.id), 0, job);
    }
    queueFlush();
  }
}
function queueFlush() {
  if (!isFlushing && !isFlushPending) {
    isFlushPending = true;
    currentFlushPromise = resolvedPromise.then(flushJobs);
  }
}
function invalidateJob(job) {
  const i = queue.indexOf(job);
  if (i > flushIndex) {
    queue.splice(i, 1);
  }
}
function queueCb(cb, activeQueue, pendingQueue, index2) {
  if (!isArray$2(cb)) {
    if (!activeQueue || !activeQueue.includes(cb, cb.allowRecurse ? index2 + 1 : index2)) {
      pendingQueue.push(cb);
    }
  } else {
    pendingQueue.push(...cb);
  }
  queueFlush();
}
function queuePreFlushCb(cb) {
  queueCb(cb, activePreFlushCbs, pendingPreFlushCbs, preFlushIndex);
}
function queuePostFlushCb(cb) {
  queueCb(cb, activePostFlushCbs, pendingPostFlushCbs, postFlushIndex);
}
function flushPreFlushCbs(seen2, parentJob = null) {
  if (pendingPreFlushCbs.length) {
    currentPreFlushParentJob = parentJob;
    activePreFlushCbs = [...new Set(pendingPreFlushCbs)];
    pendingPreFlushCbs.length = 0;
    for (preFlushIndex = 0; preFlushIndex < activePreFlushCbs.length; preFlushIndex++) {
      activePreFlushCbs[preFlushIndex]();
    }
    activePreFlushCbs = null;
    preFlushIndex = 0;
    currentPreFlushParentJob = null;
    flushPreFlushCbs(seen2, parentJob);
  }
}
function flushPostFlushCbs(seen2) {
  if (pendingPostFlushCbs.length) {
    const deduped = [...new Set(pendingPostFlushCbs)];
    pendingPostFlushCbs.length = 0;
    if (activePostFlushCbs) {
      activePostFlushCbs.push(...deduped);
      return;
    }
    activePostFlushCbs = deduped;
    activePostFlushCbs.sort((a2, b2) => getId$1(a2) - getId$1(b2));
    for (postFlushIndex = 0; postFlushIndex < activePostFlushCbs.length; postFlushIndex++) {
      activePostFlushCbs[postFlushIndex]();
    }
    activePostFlushCbs = null;
    postFlushIndex = 0;
  }
}
const getId$1 = (job) => job.id == null ? Infinity : job.id;
function flushJobs(seen2) {
  isFlushPending = false;
  isFlushing = true;
  flushPreFlushCbs(seen2);
  queue.sort((a2, b2) => getId$1(a2) - getId$1(b2));
  const check2 = NOOP;
  try {
    for (flushIndex = 0; flushIndex < queue.length; flushIndex++) {
      const job = queue[flushIndex];
      if (job && job.active !== false) {
        if (false)
          ;
        callWithErrorHandling(job, null, 14);
      }
    }
  } finally {
    flushIndex = 0;
    queue.length = 0;
    flushPostFlushCbs();
    isFlushing = false;
    currentFlushPromise = null;
    if (queue.length || pendingPreFlushCbs.length || pendingPostFlushCbs.length) {
      flushJobs(seen2);
    }
  }
}
function emit$1(instance, event, ...rawArgs) {
  const props = instance.vnode.props || EMPTY_OBJ;
  let args = rawArgs;
  const isModelListener2 = event.startsWith("update:");
  const modelArg = isModelListener2 && event.slice(7);
  if (modelArg && modelArg in props) {
    const modifiersKey = `${modelArg === "modelValue" ? "model" : modelArg}Modifiers`;
    const { number: number2, trim: trim2 } = props[modifiersKey] || EMPTY_OBJ;
    if (trim2) {
      args = rawArgs.map((a2) => a2.trim());
    } else if (number2) {
      args = rawArgs.map(toNumber);
    }
  }
  let handlerName;
  let handler = props[handlerName = toHandlerKey(event)] || props[handlerName = toHandlerKey(camelize(event))];
  if (!handler && isModelListener2) {
    handler = props[handlerName = toHandlerKey(hyphenate(event))];
  }
  if (handler) {
    callWithAsyncErrorHandling(handler, instance, 6, args);
  }
  const onceHandler = props[handlerName + `Once`];
  if (onceHandler) {
    if (!instance.emitted) {
      instance.emitted = {};
    } else if (instance.emitted[handlerName]) {
      return;
    }
    instance.emitted[handlerName] = true;
    callWithAsyncErrorHandling(onceHandler, instance, 6, args);
  }
}
function normalizeEmitsOptions(comp2, appContext, asMixin = false) {
  const cache2 = appContext.emitsCache;
  const cached = cache2.get(comp2);
  if (cached !== void 0) {
    return cached;
  }
  const raw = comp2.emits;
  let normalized = {};
  let hasExtends = false;
  if (!isFunction$4(comp2)) {
    const extendEmits = (raw2) => {
      const normalizedFromExtend = normalizeEmitsOptions(raw2, appContext, true);
      if (normalizedFromExtend) {
        hasExtends = true;
        extend(normalized, normalizedFromExtend);
      }
    };
    if (!asMixin && appContext.mixins.length) {
      appContext.mixins.forEach(extendEmits);
    }
    if (comp2.extends) {
      extendEmits(comp2.extends);
    }
    if (comp2.mixins) {
      comp2.mixins.forEach(extendEmits);
    }
  }
  if (!raw && !hasExtends) {
    cache2.set(comp2, null);
    return null;
  }
  if (isArray$2(raw)) {
    raw.forEach((key) => normalized[key] = null);
  } else {
    extend(normalized, raw);
  }
  cache2.set(comp2, normalized);
  return normalized;
}
function isEmitListener(options2, key) {
  if (!options2 || !isOn(key)) {
    return false;
  }
  key = key.slice(2).replace(/Once$/, "");
  return hasOwn$1(options2, key[0].toLowerCase() + key.slice(1)) || hasOwn$1(options2, hyphenate(key)) || hasOwn$1(options2, key);
}
let currentRenderingInstance = null;
let currentScopeId = null;
function setCurrentRenderingInstance(instance) {
  const prev2 = currentRenderingInstance;
  currentRenderingInstance = instance;
  currentScopeId = instance && instance.type.__scopeId || null;
  return prev2;
}
function pushScopeId(id2) {
  currentScopeId = id2;
}
function popScopeId() {
  currentScopeId = null;
}
const withScopeId = (_id) => withCtx;
function withCtx(fn2, ctx = currentRenderingInstance, isNonScopedSlot) {
  if (!ctx)
    return fn2;
  if (fn2._n) {
    return fn2;
  }
  const renderFnWithContext = (...args) => {
    if (renderFnWithContext._d) {
      setBlockTracking(-1);
    }
    const prevInstance = setCurrentRenderingInstance(ctx);
    const res = fn2(...args);
    setCurrentRenderingInstance(prevInstance);
    if (renderFnWithContext._d) {
      setBlockTracking(1);
    }
    return res;
  };
  renderFnWithContext._n = true;
  renderFnWithContext._c = true;
  renderFnWithContext._d = true;
  return renderFnWithContext;
}
function markAttrsAccessed() {
}
function renderComponentRoot(instance) {
  const { type: Component, vnode, proxy, withProxy, props, propsOptions: [propsOptions], slots, attrs, emit: emit2, render: render2, renderCache, data, setupState, ctx, inheritAttrs } = instance;
  let result;
  let fallthroughAttrs;
  const prev2 = setCurrentRenderingInstance(instance);
  try {
    if (vnode.shapeFlag & 4) {
      const proxyToUse = withProxy || proxy;
      result = normalizeVNode(render2.call(proxyToUse, proxyToUse, renderCache, props, setupState, data, ctx));
      fallthroughAttrs = attrs;
    } else {
      const render3 = Component;
      if (false)
        ;
      result = normalizeVNode(render3.length > 1 ? render3(props, false ? {
        get attrs() {
          markAttrsAccessed();
          return attrs;
        },
        slots,
        emit: emit2
      } : { attrs, slots, emit: emit2 }) : render3(props, null));
      fallthroughAttrs = Component.props ? attrs : getFunctionalFallthrough(attrs);
    }
  } catch (err) {
    blockStack.length = 0;
    handleError(err, instance, 1);
    result = createVNode(Comment);
  }
  let root = result;
  if (fallthroughAttrs && inheritAttrs !== false) {
    const keys = Object.keys(fallthroughAttrs);
    const { shapeFlag } = root;
    if (keys.length) {
      if (shapeFlag & (1 | 6)) {
        if (propsOptions && keys.some(isModelListener)) {
          fallthroughAttrs = filterModelListeners(fallthroughAttrs, propsOptions);
        }
        root = cloneVNode(root, fallthroughAttrs);
      }
    }
  }
  if (vnode.dirs) {
    root.dirs = root.dirs ? root.dirs.concat(vnode.dirs) : vnode.dirs;
  }
  if (vnode.transition) {
    root.transition = vnode.transition;
  }
  {
    result = root;
  }
  setCurrentRenderingInstance(prev2);
  return result;
}
const getFunctionalFallthrough = (attrs) => {
  let res;
  for (const key in attrs) {
    if (key === "class" || key === "style" || isOn(key)) {
      (res || (res = {}))[key] = attrs[key];
    }
  }
  return res;
};
const filterModelListeners = (attrs, props) => {
  const res = {};
  for (const key in attrs) {
    if (!isModelListener(key) || !(key.slice(9) in props)) {
      res[key] = attrs[key];
    }
  }
  return res;
};
function shouldUpdateComponent(prevVNode, nextVNode, optimized) {
  const { props: prevProps, children: prevChildren, component } = prevVNode;
  const { props: nextProps, children: nextChildren, patchFlag } = nextVNode;
  const emits = component.emitsOptions;
  if (nextVNode.dirs || nextVNode.transition) {
    return true;
  }
  if (optimized && patchFlag >= 0) {
    if (patchFlag & 1024) {
      return true;
    }
    if (patchFlag & 16) {
      if (!prevProps) {
        return !!nextProps;
      }
      return hasPropsChanged(prevProps, nextProps, emits);
    } else if (patchFlag & 8) {
      const dynamicProps = nextVNode.dynamicProps;
      for (let i = 0; i < dynamicProps.length; i++) {
        const key = dynamicProps[i];
        if (nextProps[key] !== prevProps[key] && !isEmitListener(emits, key)) {
          return true;
        }
      }
    }
  } else {
    if (prevChildren || nextChildren) {
      if (!nextChildren || !nextChildren.$stable) {
        return true;
      }
    }
    if (prevProps === nextProps) {
      return false;
    }
    if (!prevProps) {
      return !!nextProps;
    }
    if (!nextProps) {
      return true;
    }
    return hasPropsChanged(prevProps, nextProps, emits);
  }
  return false;
}
function hasPropsChanged(prevProps, nextProps, emitsOptions) {
  const nextKeys = Object.keys(nextProps);
  if (nextKeys.length !== Object.keys(prevProps).length) {
    return true;
  }
  for (let i = 0; i < nextKeys.length; i++) {
    const key = nextKeys[i];
    if (nextProps[key] !== prevProps[key] && !isEmitListener(emitsOptions, key)) {
      return true;
    }
  }
  return false;
}
function updateHOCHostEl({ vnode, parent }, el2) {
  while (parent && parent.subTree === vnode) {
    (vnode = parent.vnode).el = el2;
    parent = parent.parent;
  }
}
const isSuspense = (type2) => type2.__isSuspense;
function queueEffectWithSuspense(fn2, suspense) {
  if (suspense && suspense.pendingBranch) {
    if (isArray$2(fn2)) {
      suspense.effects.push(...fn2);
    } else {
      suspense.effects.push(fn2);
    }
  } else {
    queuePostFlushCb(fn2);
  }
}
function provide(key, value) {
  if (!currentInstance)
    ;
  else {
    let provides = currentInstance.provides;
    const parentProvides = currentInstance.parent && currentInstance.parent.provides;
    if (parentProvides === provides) {
      provides = currentInstance.provides = Object.create(parentProvides);
    }
    provides[key] = value;
  }
}
function inject(key, defaultValue, treatDefaultAsFactory = false) {
  const instance = currentInstance || currentRenderingInstance;
  if (instance) {
    const provides = instance.parent == null ? instance.vnode.appContext && instance.vnode.appContext.provides : instance.parent.provides;
    if (provides && key in provides) {
      return provides[key];
    } else if (arguments.length > 1) {
      return treatDefaultAsFactory && isFunction$4(defaultValue) ? defaultValue.call(instance.proxy) : defaultValue;
    } else
      ;
  }
}
function watchEffect(effect2, options2) {
  return doWatch(effect2, null, options2);
}
function watchPostEffect(effect2, options2) {
  return doWatch(effect2, null, { flush: "post" });
}
const INITIAL_WATCHER_VALUE = {};
function watch(source, cb, options2) {
  return doWatch(source, cb, options2);
}
function doWatch(source, cb, { immediate, deep, flush, onTrack, onTrigger } = EMPTY_OBJ) {
  const instance = currentInstance;
  let getter;
  let forceTrigger = false;
  let isMultiSource = false;
  if (isRef(source)) {
    getter = () => source.value;
    forceTrigger = isShallow(source);
  } else if (isReactive(source)) {
    getter = () => source;
    deep = true;
  } else if (isArray$2(source)) {
    isMultiSource = true;
    forceTrigger = source.some(isReactive);
    getter = () => source.map((s2) => {
      if (isRef(s2)) {
        return s2.value;
      } else if (isReactive(s2)) {
        return traverse(s2);
      } else if (isFunction$4(s2)) {
        return callWithErrorHandling(s2, instance, 2);
      } else
        ;
    });
  } else if (isFunction$4(source)) {
    if (cb) {
      getter = () => callWithErrorHandling(source, instance, 2);
    } else {
      getter = () => {
        if (instance && instance.isUnmounted) {
          return;
        }
        if (cleanup) {
          cleanup();
        }
        return callWithAsyncErrorHandling(source, instance, 3, [onCleanup]);
      };
    }
  } else {
    getter = NOOP;
  }
  if (cb && deep) {
    const baseGetter = getter;
    getter = () => traverse(baseGetter());
  }
  let cleanup;
  let onCleanup = (fn2) => {
    cleanup = effect2.onStop = () => {
      callWithErrorHandling(fn2, instance, 4);
    };
  };
  if (isInSSRComponentSetup) {
    onCleanup = NOOP;
    if (!cb) {
      getter();
    } else if (immediate) {
      callWithAsyncErrorHandling(cb, instance, 3, [
        getter(),
        isMultiSource ? [] : void 0,
        onCleanup
      ]);
    }
    return NOOP;
  }
  let oldValue = isMultiSource ? [] : INITIAL_WATCHER_VALUE;
  const job = () => {
    if (!effect2.active) {
      return;
    }
    if (cb) {
      const newValue = effect2.run();
      if (deep || forceTrigger || (isMultiSource ? newValue.some((v, i) => hasChanged(v, oldValue[i])) : hasChanged(newValue, oldValue)) || false) {
        if (cleanup) {
          cleanup();
        }
        callWithAsyncErrorHandling(cb, instance, 3, [
          newValue,
          oldValue === INITIAL_WATCHER_VALUE ? void 0 : oldValue,
          onCleanup
        ]);
        oldValue = newValue;
      }
    } else {
      effect2.run();
    }
  };
  job.allowRecurse = !!cb;
  let scheduler;
  if (flush === "sync") {
    scheduler = job;
  } else if (flush === "post") {
    scheduler = () => queuePostRenderEffect(job, instance && instance.suspense);
  } else {
    scheduler = () => {
      if (!instance || instance.isMounted) {
        queuePreFlushCb(job);
      } else {
        job();
      }
    };
  }
  const effect2 = new ReactiveEffect(getter, scheduler);
  if (cb) {
    if (immediate) {
      job();
    } else {
      oldValue = effect2.run();
    }
  } else if (flush === "post") {
    queuePostRenderEffect(effect2.run.bind(effect2), instance && instance.suspense);
  } else {
    effect2.run();
  }
  return () => {
    effect2.stop();
    if (instance && instance.scope) {
      remove(instance.scope.effects, effect2);
    }
  };
}
function instanceWatch(source, value, options2) {
  const publicThis = this.proxy;
  const getter = isString$5(source) ? source.includes(".") ? createPathGetter(publicThis, source) : () => publicThis[source] : source.bind(publicThis, publicThis);
  let cb;
  if (isFunction$4(value)) {
    cb = value;
  } else {
    cb = value.handler;
    options2 = value;
  }
  const cur = currentInstance;
  setCurrentInstance(this);
  const res = doWatch(getter, cb.bind(publicThis), options2);
  if (cur) {
    setCurrentInstance(cur);
  } else {
    unsetCurrentInstance();
  }
  return res;
}
function createPathGetter(ctx, path) {
  const segments = path.split(".");
  return () => {
    let cur = ctx;
    for (let i = 0; i < segments.length && cur; i++) {
      cur = cur[segments[i]];
    }
    return cur;
  };
}
function traverse(value, seen2) {
  if (!isObject$6(value) || value["__v_skip"]) {
    return value;
  }
  seen2 = seen2 || /* @__PURE__ */ new Set();
  if (seen2.has(value)) {
    return value;
  }
  seen2.add(value);
  if (isRef(value)) {
    traverse(value.value, seen2);
  } else if (isArray$2(value)) {
    for (let i = 0; i < value.length; i++) {
      traverse(value[i], seen2);
    }
  } else if (isSet(value) || isMap(value)) {
    value.forEach((v) => {
      traverse(v, seen2);
    });
  } else if (isPlainObject$4(value)) {
    for (const key in value) {
      traverse(value[key], seen2);
    }
  }
  return value;
}
function useTransitionState() {
  const state = {
    isMounted: false,
    isLeaving: false,
    isUnmounting: false,
    leavingVNodes: /* @__PURE__ */ new Map()
  };
  onMounted(() => {
    state.isMounted = true;
  });
  onBeforeUnmount(() => {
    state.isUnmounting = true;
  });
  return state;
}
const TransitionHookValidator = [Function, Array];
const BaseTransitionImpl = {
  name: `BaseTransition`,
  props: {
    mode: String,
    appear: Boolean,
    persisted: Boolean,
    onBeforeEnter: TransitionHookValidator,
    onEnter: TransitionHookValidator,
    onAfterEnter: TransitionHookValidator,
    onEnterCancelled: TransitionHookValidator,
    onBeforeLeave: TransitionHookValidator,
    onLeave: TransitionHookValidator,
    onAfterLeave: TransitionHookValidator,
    onLeaveCancelled: TransitionHookValidator,
    onBeforeAppear: TransitionHookValidator,
    onAppear: TransitionHookValidator,
    onAfterAppear: TransitionHookValidator,
    onAppearCancelled: TransitionHookValidator
  },
  setup(props, { slots }) {
    const instance = getCurrentInstance();
    const state = useTransitionState();
    let prevTransitionKey;
    return () => {
      const children = slots.default && getTransitionRawChildren(slots.default(), true);
      if (!children || !children.length) {
        return;
      }
      const rawProps = toRaw(props);
      const { mode } = rawProps;
      const child = children[0];
      if (state.isLeaving) {
        return emptyPlaceholder(child);
      }
      const innerChild = getKeepAliveChild(child);
      if (!innerChild) {
        return emptyPlaceholder(child);
      }
      const enterHooks = resolveTransitionHooks(innerChild, rawProps, state, instance);
      setTransitionHooks(innerChild, enterHooks);
      const oldChild = instance.subTree;
      const oldInnerChild = oldChild && getKeepAliveChild(oldChild);
      let transitionKeyChanged = false;
      const { getTransitionKey } = innerChild.type;
      if (getTransitionKey) {
        const key = getTransitionKey();
        if (prevTransitionKey === void 0) {
          prevTransitionKey = key;
        } else if (key !== prevTransitionKey) {
          prevTransitionKey = key;
          transitionKeyChanged = true;
        }
      }
      if (oldInnerChild && oldInnerChild.type !== Comment && (!isSameVNodeType(innerChild, oldInnerChild) || transitionKeyChanged)) {
        const leavingHooks = resolveTransitionHooks(oldInnerChild, rawProps, state, instance);
        setTransitionHooks(oldInnerChild, leavingHooks);
        if (mode === "out-in") {
          state.isLeaving = true;
          leavingHooks.afterLeave = () => {
            state.isLeaving = false;
            instance.update();
          };
          return emptyPlaceholder(child);
        } else if (mode === "in-out" && innerChild.type !== Comment) {
          leavingHooks.delayLeave = (el2, earlyRemove, delayedLeave) => {
            const leavingVNodesCache = getLeavingNodesForType(state, oldInnerChild);
            leavingVNodesCache[String(oldInnerChild.key)] = oldInnerChild;
            el2._leaveCb = () => {
              earlyRemove();
              el2._leaveCb = void 0;
              delete enterHooks.delayedLeave;
            };
            enterHooks.delayedLeave = delayedLeave;
          };
        }
      }
      return child;
    };
  }
};
const BaseTransition = BaseTransitionImpl;
function getLeavingNodesForType(state, vnode) {
  const { leavingVNodes } = state;
  let leavingVNodesCache = leavingVNodes.get(vnode.type);
  if (!leavingVNodesCache) {
    leavingVNodesCache = /* @__PURE__ */ Object.create(null);
    leavingVNodes.set(vnode.type, leavingVNodesCache);
  }
  return leavingVNodesCache;
}
function resolveTransitionHooks(vnode, props, state, instance) {
  const { appear, mode, persisted = false, onBeforeEnter, onEnter, onAfterEnter, onEnterCancelled, onBeforeLeave, onLeave, onAfterLeave, onLeaveCancelled, onBeforeAppear, onAppear, onAfterAppear, onAppearCancelled } = props;
  const key = String(vnode.key);
  const leavingVNodesCache = getLeavingNodesForType(state, vnode);
  const callHook2 = (hook, args) => {
    hook && callWithAsyncErrorHandling(hook, instance, 9, args);
  };
  const hooks = {
    mode,
    persisted,
    beforeEnter(el2) {
      let hook = onBeforeEnter;
      if (!state.isMounted) {
        if (appear) {
          hook = onBeforeAppear || onBeforeEnter;
        } else {
          return;
        }
      }
      if (el2._leaveCb) {
        el2._leaveCb(true);
      }
      const leavingVNode = leavingVNodesCache[key];
      if (leavingVNode && isSameVNodeType(vnode, leavingVNode) && leavingVNode.el._leaveCb) {
        leavingVNode.el._leaveCb();
      }
      callHook2(hook, [el2]);
    },
    enter(el2) {
      let hook = onEnter;
      let afterHook = onAfterEnter;
      let cancelHook = onEnterCancelled;
      if (!state.isMounted) {
        if (appear) {
          hook = onAppear || onEnter;
          afterHook = onAfterAppear || onAfterEnter;
          cancelHook = onAppearCancelled || onEnterCancelled;
        } else {
          return;
        }
      }
      let called = false;
      const done = el2._enterCb = (cancelled) => {
        if (called)
          return;
        called = true;
        if (cancelled) {
          callHook2(cancelHook, [el2]);
        } else {
          callHook2(afterHook, [el2]);
        }
        if (hooks.delayedLeave) {
          hooks.delayedLeave();
        }
        el2._enterCb = void 0;
      };
      if (hook) {
        hook(el2, done);
        if (hook.length <= 1) {
          done();
        }
      } else {
        done();
      }
    },
    leave(el2, remove2) {
      const key2 = String(vnode.key);
      if (el2._enterCb) {
        el2._enterCb(true);
      }
      if (state.isUnmounting) {
        return remove2();
      }
      callHook2(onBeforeLeave, [el2]);
      let called = false;
      const done = el2._leaveCb = (cancelled) => {
        if (called)
          return;
        called = true;
        remove2();
        if (cancelled) {
          callHook2(onLeaveCancelled, [el2]);
        } else {
          callHook2(onAfterLeave, [el2]);
        }
        el2._leaveCb = void 0;
        if (leavingVNodesCache[key2] === vnode) {
          delete leavingVNodesCache[key2];
        }
      };
      leavingVNodesCache[key2] = vnode;
      if (onLeave) {
        onLeave(el2, done);
        if (onLeave.length <= 1) {
          done();
        }
      } else {
        done();
      }
    },
    clone(vnode2) {
      return resolveTransitionHooks(vnode2, props, state, instance);
    }
  };
  return hooks;
}
function emptyPlaceholder(vnode) {
  if (isKeepAlive(vnode)) {
    vnode = cloneVNode(vnode);
    vnode.children = null;
    return vnode;
  }
}
function getKeepAliveChild(vnode) {
  return isKeepAlive(vnode) ? vnode.children ? vnode.children[0] : void 0 : vnode;
}
function setTransitionHooks(vnode, hooks) {
  if (vnode.shapeFlag & 6 && vnode.component) {
    setTransitionHooks(vnode.component.subTree, hooks);
  } else if (vnode.shapeFlag & 128) {
    vnode.ssContent.transition = hooks.clone(vnode.ssContent);
    vnode.ssFallback.transition = hooks.clone(vnode.ssFallback);
  } else {
    vnode.transition = hooks;
  }
}
function getTransitionRawChildren(children, keepComment = false) {
  let ret = [];
  let keyedFragmentCount = 0;
  for (let i = 0; i < children.length; i++) {
    const child = children[i];
    if (child.type === Fragment) {
      if (child.patchFlag & 128)
        keyedFragmentCount++;
      ret = ret.concat(getTransitionRawChildren(child.children, keepComment));
    } else if (keepComment || child.type !== Comment) {
      ret.push(child);
    }
  }
  if (keyedFragmentCount > 1) {
    for (let i = 0; i < ret.length; i++) {
      ret[i].patchFlag = -2;
    }
  }
  return ret;
}
function defineComponent(options2) {
  return isFunction$4(options2) ? { setup: options2, name: options2.name } : options2;
}
const isAsyncWrapper = (i) => !!i.type.__asyncLoader;
const isKeepAlive = (vnode) => vnode.type.__isKeepAlive;
function onActivated(hook, target2) {
  registerKeepAliveHook(hook, "a", target2);
}
function onDeactivated(hook, target2) {
  registerKeepAliveHook(hook, "da", target2);
}
function registerKeepAliveHook(hook, type2, target2 = currentInstance) {
  const wrappedHook = hook.__wdc || (hook.__wdc = () => {
    let current = target2;
    while (current) {
      if (current.isDeactivated) {
        return;
      }
      current = current.parent;
    }
    return hook();
  });
  injectHook(type2, wrappedHook, target2);
  if (target2) {
    let current = target2.parent;
    while (current && current.parent) {
      if (isKeepAlive(current.parent.vnode)) {
        injectToKeepAliveRoot(wrappedHook, type2, target2, current);
      }
      current = current.parent;
    }
  }
}
function injectToKeepAliveRoot(hook, type2, target2, keepAliveRoot) {
  const injected = injectHook(type2, hook, keepAliveRoot, true);
  onUnmounted(() => {
    remove(keepAliveRoot[type2], injected);
  }, target2);
}
function injectHook(type2, hook, target2 = currentInstance, prepend = false) {
  if (target2) {
    const hooks = target2[type2] || (target2[type2] = []);
    const wrappedHook = hook.__weh || (hook.__weh = (...args) => {
      if (target2.isUnmounted) {
        return;
      }
      pauseTracking();
      setCurrentInstance(target2);
      const res = callWithAsyncErrorHandling(hook, target2, type2, args);
      unsetCurrentInstance();
      resetTracking();
      return res;
    });
    if (prepend) {
      hooks.unshift(wrappedHook);
    } else {
      hooks.push(wrappedHook);
    }
    return wrappedHook;
  }
}
const createHook = (lifecycle) => (hook, target2 = currentInstance) => (!isInSSRComponentSetup || lifecycle === "sp") && injectHook(lifecycle, hook, target2);
const onBeforeMount = createHook("bm");
const onMounted = createHook("m");
const onBeforeUpdate = createHook("bu");
const onUpdated = createHook("u");
const onBeforeUnmount = createHook("bum");
const onUnmounted = createHook("um");
const onServerPrefetch = createHook("sp");
const onRenderTriggered = createHook("rtg");
const onRenderTracked = createHook("rtc");
function onErrorCaptured(hook, target2 = currentInstance) {
  injectHook("ec", hook, target2);
}
let shouldCacheAccess = true;
function applyOptions(instance) {
  const options2 = resolveMergedOptions(instance);
  const publicThis = instance.proxy;
  const ctx = instance.ctx;
  shouldCacheAccess = false;
  if (options2.beforeCreate) {
    callHook$1(options2.beforeCreate, instance, "bc");
  }
  const {
    data: dataOptions,
    computed: computedOptions,
    methods,
    watch: watchOptions,
    provide: provideOptions,
    inject: injectOptions,
    created,
    beforeMount,
    mounted,
    beforeUpdate,
    updated,
    activated,
    deactivated,
    beforeDestroy,
    beforeUnmount,
    destroyed,
    unmounted,
    render: render2,
    renderTracked,
    renderTriggered,
    errorCaptured,
    serverPrefetch,
    expose,
    inheritAttrs,
    components,
    directives,
    filters
  } = options2;
  const checkDuplicateProperties = null;
  if (injectOptions) {
    resolveInjections(injectOptions, ctx, checkDuplicateProperties, instance.appContext.config.unwrapInjectedRef);
  }
  if (methods) {
    for (const key in methods) {
      const methodHandler = methods[key];
      if (isFunction$4(methodHandler)) {
        {
          ctx[key] = methodHandler.bind(publicThis);
        }
      }
    }
  }
  if (dataOptions) {
    const data = dataOptions.call(publicThis, publicThis);
    if (!isObject$6(data))
      ;
    else {
      instance.data = reactive(data);
    }
  }
  shouldCacheAccess = true;
  if (computedOptions) {
    for (const key in computedOptions) {
      const opt = computedOptions[key];
      const get2 = isFunction$4(opt) ? opt.bind(publicThis, publicThis) : isFunction$4(opt.get) ? opt.get.bind(publicThis, publicThis) : NOOP;
      const set3 = !isFunction$4(opt) && isFunction$4(opt.set) ? opt.set.bind(publicThis) : NOOP;
      const c2 = computed({
        get: get2,
        set: set3
      });
      Object.defineProperty(ctx, key, {
        enumerable: true,
        configurable: true,
        get: () => c2.value,
        set: (v) => c2.value = v
      });
    }
  }
  if (watchOptions) {
    for (const key in watchOptions) {
      createWatcher(watchOptions[key], ctx, publicThis, key);
    }
  }
  if (provideOptions) {
    const provides = isFunction$4(provideOptions) ? provideOptions.call(publicThis) : provideOptions;
    Reflect.ownKeys(provides).forEach((key) => {
      provide(key, provides[key]);
    });
  }
  if (created) {
    callHook$1(created, instance, "c");
  }
  function registerLifecycleHook(register, hook) {
    if (isArray$2(hook)) {
      hook.forEach((_hook) => register(_hook.bind(publicThis)));
    } else if (hook) {
      register(hook.bind(publicThis));
    }
  }
  registerLifecycleHook(onBeforeMount, beforeMount);
  registerLifecycleHook(onMounted, mounted);
  registerLifecycleHook(onBeforeUpdate, beforeUpdate);
  registerLifecycleHook(onUpdated, updated);
  registerLifecycleHook(onActivated, activated);
  registerLifecycleHook(onDeactivated, deactivated);
  registerLifecycleHook(onErrorCaptured, errorCaptured);
  registerLifecycleHook(onRenderTracked, renderTracked);
  registerLifecycleHook(onRenderTriggered, renderTriggered);
  registerLifecycleHook(onBeforeUnmount, beforeUnmount);
  registerLifecycleHook(onUnmounted, unmounted);
  registerLifecycleHook(onServerPrefetch, serverPrefetch);
  if (isArray$2(expose)) {
    if (expose.length) {
      const exposed = instance.exposed || (instance.exposed = {});
      expose.forEach((key) => {
        Object.defineProperty(exposed, key, {
          get: () => publicThis[key],
          set: (val) => publicThis[key] = val
        });
      });
    } else if (!instance.exposed) {
      instance.exposed = {};
    }
  }
  if (render2 && instance.render === NOOP) {
    instance.render = render2;
  }
  if (inheritAttrs != null) {
    instance.inheritAttrs = inheritAttrs;
  }
  if (components)
    instance.components = components;
  if (directives)
    instance.directives = directives;
}
function resolveInjections(injectOptions, ctx, checkDuplicateProperties = NOOP, unwrapRef = false) {
  if (isArray$2(injectOptions)) {
    injectOptions = normalizeInject(injectOptions);
  }
  for (const key in injectOptions) {
    const opt = injectOptions[key];
    let injected;
    if (isObject$6(opt)) {
      if ("default" in opt) {
        injected = inject(opt.from || key, opt.default, true);
      } else {
        injected = inject(opt.from || key);
      }
    } else {
      injected = inject(opt);
    }
    if (isRef(injected)) {
      if (unwrapRef) {
        Object.defineProperty(ctx, key, {
          enumerable: true,
          configurable: true,
          get: () => injected.value,
          set: (v) => injected.value = v
        });
      } else {
        ctx[key] = injected;
      }
    } else {
      ctx[key] = injected;
    }
  }
}
function callHook$1(hook, instance, type2) {
  callWithAsyncErrorHandling(isArray$2(hook) ? hook.map((h2) => h2.bind(instance.proxy)) : hook.bind(instance.proxy), instance, type2);
}
function createWatcher(raw, ctx, publicThis, key) {
  const getter = key.includes(".") ? createPathGetter(publicThis, key) : () => publicThis[key];
  if (isString$5(raw)) {
    const handler = ctx[raw];
    if (isFunction$4(handler)) {
      watch(getter, handler);
    }
  } else if (isFunction$4(raw)) {
    watch(getter, raw.bind(publicThis));
  } else if (isObject$6(raw)) {
    if (isArray$2(raw)) {
      raw.forEach((r2) => createWatcher(r2, ctx, publicThis, key));
    } else {
      const handler = isFunction$4(raw.handler) ? raw.handler.bind(publicThis) : ctx[raw.handler];
      if (isFunction$4(handler)) {
        watch(getter, handler, raw);
      }
    }
  } else
    ;
}
function resolveMergedOptions(instance) {
  const base2 = instance.type;
  const { mixins, extends: extendsOptions } = base2;
  const { mixins: globalMixins, optionsCache: cache2, config: { optionMergeStrategies } } = instance.appContext;
  const cached = cache2.get(base2);
  let resolved;
  if (cached) {
    resolved = cached;
  } else if (!globalMixins.length && !mixins && !extendsOptions) {
    {
      resolved = base2;
    }
  } else {
    resolved = {};
    if (globalMixins.length) {
      globalMixins.forEach((m2) => mergeOptions$1(resolved, m2, optionMergeStrategies, true));
    }
    mergeOptions$1(resolved, base2, optionMergeStrategies);
  }
  cache2.set(base2, resolved);
  return resolved;
}
function mergeOptions$1(to, from, strats, asMixin = false) {
  const { mixins, extends: extendsOptions } = from;
  if (extendsOptions) {
    mergeOptions$1(to, extendsOptions, strats, true);
  }
  if (mixins) {
    mixins.forEach((m2) => mergeOptions$1(to, m2, strats, true));
  }
  for (const key in from) {
    if (asMixin && key === "expose")
      ;
    else {
      const strat = internalOptionMergeStrats[key] || strats && strats[key];
      to[key] = strat ? strat(to[key], from[key]) : from[key];
    }
  }
  return to;
}
const internalOptionMergeStrats = {
  data: mergeDataFn,
  props: mergeObjectOptions,
  emits: mergeObjectOptions,
  methods: mergeObjectOptions,
  computed: mergeObjectOptions,
  beforeCreate: mergeAsArray,
  created: mergeAsArray,
  beforeMount: mergeAsArray,
  mounted: mergeAsArray,
  beforeUpdate: mergeAsArray,
  updated: mergeAsArray,
  beforeDestroy: mergeAsArray,
  beforeUnmount: mergeAsArray,
  destroyed: mergeAsArray,
  unmounted: mergeAsArray,
  activated: mergeAsArray,
  deactivated: mergeAsArray,
  errorCaptured: mergeAsArray,
  serverPrefetch: mergeAsArray,
  components: mergeObjectOptions,
  directives: mergeObjectOptions,
  watch: mergeWatchOptions,
  provide: mergeDataFn,
  inject: mergeInject
};
function mergeDataFn(to, from) {
  if (!from) {
    return to;
  }
  if (!to) {
    return from;
  }
  return function mergedDataFn() {
    return extend(isFunction$4(to) ? to.call(this, this) : to, isFunction$4(from) ? from.call(this, this) : from);
  };
}
function mergeInject(to, from) {
  return mergeObjectOptions(normalizeInject(to), normalizeInject(from));
}
function normalizeInject(raw) {
  if (isArray$2(raw)) {
    const res = {};
    for (let i = 0; i < raw.length; i++) {
      res[raw[i]] = raw[i];
    }
    return res;
  }
  return raw;
}
function mergeAsArray(to, from) {
  return to ? [...new Set([].concat(to, from))] : from;
}
function mergeObjectOptions(to, from) {
  return to ? extend(extend(/* @__PURE__ */ Object.create(null), to), from) : from;
}
function mergeWatchOptions(to, from) {
  if (!to)
    return from;
  if (!from)
    return to;
  const merged = extend(/* @__PURE__ */ Object.create(null), to);
  for (const key in from) {
    merged[key] = mergeAsArray(to[key], from[key]);
  }
  return merged;
}
function initProps(instance, rawProps, isStateful, isSSR = false) {
  const props = {};
  const attrs = {};
  def(attrs, InternalObjectKey, 1);
  instance.propsDefaults = /* @__PURE__ */ Object.create(null);
  setFullProps(instance, rawProps, props, attrs);
  for (const key in instance.propsOptions[0]) {
    if (!(key in props)) {
      props[key] = void 0;
    }
  }
  if (isStateful) {
    instance.props = isSSR ? props : shallowReactive(props);
  } else {
    if (!instance.type.props) {
      instance.props = attrs;
    } else {
      instance.props = props;
    }
  }
  instance.attrs = attrs;
}
function updateProps(instance, rawProps, rawPrevProps, optimized) {
  const { props, attrs, vnode: { patchFlag } } = instance;
  const rawCurrentProps = toRaw(props);
  const [options2] = instance.propsOptions;
  let hasAttrsChanged = false;
  if ((optimized || patchFlag > 0) && !(patchFlag & 16)) {
    if (patchFlag & 8) {
      const propsToUpdate = instance.vnode.dynamicProps;
      for (let i = 0; i < propsToUpdate.length; i++) {
        let key = propsToUpdate[i];
        const value = rawProps[key];
        if (options2) {
          if (hasOwn$1(attrs, key)) {
            if (value !== attrs[key]) {
              attrs[key] = value;
              hasAttrsChanged = true;
            }
          } else {
            const camelizedKey = camelize(key);
            props[camelizedKey] = resolvePropValue(options2, rawCurrentProps, camelizedKey, value, instance, false);
          }
        } else {
          if (value !== attrs[key]) {
            attrs[key] = value;
            hasAttrsChanged = true;
          }
        }
      }
    }
  } else {
    if (setFullProps(instance, rawProps, props, attrs)) {
      hasAttrsChanged = true;
    }
    let kebabKey;
    for (const key in rawCurrentProps) {
      if (!rawProps || !hasOwn$1(rawProps, key) && ((kebabKey = hyphenate(key)) === key || !hasOwn$1(rawProps, kebabKey))) {
        if (options2) {
          if (rawPrevProps && (rawPrevProps[key] !== void 0 || rawPrevProps[kebabKey] !== void 0)) {
            props[key] = resolvePropValue(options2, rawCurrentProps, key, void 0, instance, true);
          }
        } else {
          delete props[key];
        }
      }
    }
    if (attrs !== rawCurrentProps) {
      for (const key in attrs) {
        if (!rawProps || !hasOwn$1(rawProps, key) && true) {
          delete attrs[key];
          hasAttrsChanged = true;
        }
      }
    }
  }
  if (hasAttrsChanged) {
    trigger$1(instance, "set", "$attrs");
  }
}
function setFullProps(instance, rawProps, props, attrs) {
  const [options2, needCastKeys] = instance.propsOptions;
  let hasAttrsChanged = false;
  let rawCastValues;
  if (rawProps) {
    for (let key in rawProps) {
      if (isReservedProp(key)) {
        continue;
      }
      const value = rawProps[key];
      let camelKey;
      if (options2 && hasOwn$1(options2, camelKey = camelize(key))) {
        if (!needCastKeys || !needCastKeys.includes(camelKey)) {
          props[camelKey] = value;
        } else {
          (rawCastValues || (rawCastValues = {}))[camelKey] = value;
        }
      } else if (!isEmitListener(instance.emitsOptions, key)) {
        if (!(key in attrs) || value !== attrs[key]) {
          attrs[key] = value;
          hasAttrsChanged = true;
        }
      }
    }
  }
  if (needCastKeys) {
    const rawCurrentProps = toRaw(props);
    const castValues = rawCastValues || EMPTY_OBJ;
    for (let i = 0; i < needCastKeys.length; i++) {
      const key = needCastKeys[i];
      props[key] = resolvePropValue(options2, rawCurrentProps, key, castValues[key], instance, !hasOwn$1(castValues, key));
    }
  }
  return hasAttrsChanged;
}
function resolvePropValue(options2, props, key, value, instance, isAbsent) {
  const opt = options2[key];
  if (opt != null) {
    const hasDefault = hasOwn$1(opt, "default");
    if (hasDefault && value === void 0) {
      const defaultValue = opt.default;
      if (opt.type !== Function && isFunction$4(defaultValue)) {
        const { propsDefaults } = instance;
        if (key in propsDefaults) {
          value = propsDefaults[key];
        } else {
          setCurrentInstance(instance);
          value = propsDefaults[key] = defaultValue.call(null, props);
          unsetCurrentInstance();
        }
      } else {
        value = defaultValue;
      }
    }
    if (opt[0]) {
      if (isAbsent && !hasDefault) {
        value = false;
      } else if (opt[1] && (value === "" || value === hyphenate(key))) {
        value = true;
      }
    }
  }
  return value;
}
function normalizePropsOptions(comp2, appContext, asMixin = false) {
  const cache2 = appContext.propsCache;
  const cached = cache2.get(comp2);
  if (cached) {
    return cached;
  }
  const raw = comp2.props;
  const normalized = {};
  const needCastKeys = [];
  let hasExtends = false;
  if (!isFunction$4(comp2)) {
    const extendProps = (raw2) => {
      hasExtends = true;
      const [props, keys] = normalizePropsOptions(raw2, appContext, true);
      extend(normalized, props);
      if (keys)
        needCastKeys.push(...keys);
    };
    if (!asMixin && appContext.mixins.length) {
      appContext.mixins.forEach(extendProps);
    }
    if (comp2.extends) {
      extendProps(comp2.extends);
    }
    if (comp2.mixins) {
      comp2.mixins.forEach(extendProps);
    }
  }
  if (!raw && !hasExtends) {
    cache2.set(comp2, EMPTY_ARR);
    return EMPTY_ARR;
  }
  if (isArray$2(raw)) {
    for (let i = 0; i < raw.length; i++) {
      const normalizedKey = camelize(raw[i]);
      if (validatePropName(normalizedKey)) {
        normalized[normalizedKey] = EMPTY_OBJ;
      }
    }
  } else if (raw) {
    for (const key in raw) {
      const normalizedKey = camelize(key);
      if (validatePropName(normalizedKey)) {
        const opt = raw[key];
        const prop2 = normalized[normalizedKey] = isArray$2(opt) || isFunction$4(opt) ? { type: opt } : opt;
        if (prop2) {
          const booleanIndex = getTypeIndex(Boolean, prop2.type);
          const stringIndex = getTypeIndex(String, prop2.type);
          prop2[0] = booleanIndex > -1;
          prop2[1] = stringIndex < 0 || booleanIndex < stringIndex;
          if (booleanIndex > -1 || hasOwn$1(prop2, "default")) {
            needCastKeys.push(normalizedKey);
          }
        }
      }
    }
  }
  const res = [normalized, needCastKeys];
  cache2.set(comp2, res);
  return res;
}
function validatePropName(key) {
  if (key[0] !== "$") {
    return true;
  }
  return false;
}
function getType(ctor) {
  const match3 = ctor && ctor.toString().match(/^\s*function (\w+)/);
  return match3 ? match3[1] : ctor === null ? "null" : "";
}
function isSameType(a2, b2) {
  return getType(a2) === getType(b2);
}
function getTypeIndex(type2, expectedTypes) {
  if (isArray$2(expectedTypes)) {
    return expectedTypes.findIndex((t2) => isSameType(t2, type2));
  } else if (isFunction$4(expectedTypes)) {
    return isSameType(expectedTypes, type2) ? 0 : -1;
  }
  return -1;
}
const isInternalKey = (key) => key[0] === "_" || key === "$stable";
const normalizeSlotValue = (value) => isArray$2(value) ? value.map(normalizeVNode) : [normalizeVNode(value)];
const normalizeSlot$1 = (key, rawSlot, ctx) => {
  const normalized = withCtx((...args) => {
    return normalizeSlotValue(rawSlot(...args));
  }, ctx);
  normalized._c = false;
  return normalized;
};
const normalizeObjectSlots = (rawSlots, slots, instance) => {
  const ctx = rawSlots._ctx;
  for (const key in rawSlots) {
    if (isInternalKey(key))
      continue;
    const value = rawSlots[key];
    if (isFunction$4(value)) {
      slots[key] = normalizeSlot$1(key, value, ctx);
    } else if (value != null) {
      const normalized = normalizeSlotValue(value);
      slots[key] = () => normalized;
    }
  }
};
const normalizeVNodeSlots = (instance, children) => {
  const normalized = normalizeSlotValue(children);
  instance.slots.default = () => normalized;
};
const initSlots = (instance, children) => {
  if (instance.vnode.shapeFlag & 32) {
    const type2 = children._;
    if (type2) {
      instance.slots = toRaw(children);
      def(children, "_", type2);
    } else {
      normalizeObjectSlots(children, instance.slots = {});
    }
  } else {
    instance.slots = {};
    if (children) {
      normalizeVNodeSlots(instance, children);
    }
  }
  def(instance.slots, InternalObjectKey, 1);
};
const updateSlots = (instance, children, optimized) => {
  const { vnode, slots } = instance;
  let needDeletionCheck = true;
  let deletionComparisonTarget = EMPTY_OBJ;
  if (vnode.shapeFlag & 32) {
    const type2 = children._;
    if (type2) {
      if (optimized && type2 === 1) {
        needDeletionCheck = false;
      } else {
        extend(slots, children);
        if (!optimized && type2 === 1) {
          delete slots._;
        }
      }
    } else {
      needDeletionCheck = !children.$stable;
      normalizeObjectSlots(children, slots);
    }
    deletionComparisonTarget = children;
  } else if (children) {
    normalizeVNodeSlots(instance, children);
    deletionComparisonTarget = { default: 1 };
  }
  if (needDeletionCheck) {
    for (const key in slots) {
      if (!isInternalKey(key) && !(key in deletionComparisonTarget)) {
        delete slots[key];
      }
    }
  }
};
function withDirectives(vnode, directives) {
  const internalInstance = currentRenderingInstance;
  if (internalInstance === null) {
    return vnode;
  }
  const instance = internalInstance.proxy;
  const bindings = vnode.dirs || (vnode.dirs = []);
  for (let i = 0; i < directives.length; i++) {
    let [dir, value, arg, modifiers = EMPTY_OBJ] = directives[i];
    if (isFunction$4(dir)) {
      dir = {
        mounted: dir,
        updated: dir
      };
    }
    if (dir.deep) {
      traverse(value);
    }
    bindings.push({
      dir,
      instance,
      value,
      oldValue: void 0,
      arg,
      modifiers
    });
  }
  return vnode;
}
function invokeDirectiveHook(vnode, prevVNode, instance, name2) {
  const bindings = vnode.dirs;
  const oldBindings = prevVNode && prevVNode.dirs;
  for (let i = 0; i < bindings.length; i++) {
    const binding = bindings[i];
    if (oldBindings) {
      binding.oldValue = oldBindings[i].value;
    }
    let hook = binding.dir[name2];
    if (hook) {
      pauseTracking();
      callWithAsyncErrorHandling(hook, instance, 8, [
        vnode.el,
        binding,
        vnode,
        prevVNode
      ]);
      resetTracking();
    }
  }
}
function createAppContext() {
  return {
    app: null,
    config: {
      isNativeTag: NO,
      performance: false,
      globalProperties: {},
      optionMergeStrategies: {},
      errorHandler: void 0,
      warnHandler: void 0,
      compilerOptions: {}
    },
    mixins: [],
    components: {},
    directives: {},
    provides: /* @__PURE__ */ Object.create(null),
    optionsCache: /* @__PURE__ */ new WeakMap(),
    propsCache: /* @__PURE__ */ new WeakMap(),
    emitsCache: /* @__PURE__ */ new WeakMap()
  };
}
let uid = 0;
function createAppAPI(render2, hydrate) {
  return function createApp2(rootComponent, rootProps = null) {
    if (rootProps != null && !isObject$6(rootProps)) {
      rootProps = null;
    }
    const context = createAppContext();
    const installedPlugins = /* @__PURE__ */ new Set();
    let isMounted = false;
    const app2 = context.app = {
      _uid: uid++,
      _component: rootComponent,
      _props: rootProps,
      _container: null,
      _context: context,
      _instance: null,
      version: version$9,
      get config() {
        return context.config;
      },
      set config(v) {
      },
      use(plugin, ...options2) {
        if (installedPlugins.has(plugin))
          ;
        else if (plugin && isFunction$4(plugin.install)) {
          installedPlugins.add(plugin);
          plugin.install(app2, ...options2);
        } else if (isFunction$4(plugin)) {
          installedPlugins.add(plugin);
          plugin(app2, ...options2);
        } else
          ;
        return app2;
      },
      mixin(mixin) {
        {
          if (!context.mixins.includes(mixin)) {
            context.mixins.push(mixin);
          }
        }
        return app2;
      },
      component(name2, component) {
        if (!component) {
          return context.components[name2];
        }
        context.components[name2] = component;
        return app2;
      },
      directive(name2, directive) {
        if (!directive) {
          return context.directives[name2];
        }
        context.directives[name2] = directive;
        return app2;
      },
      mount(rootContainer, isHydrate, isSVG) {
        if (!isMounted) {
          const vnode = createVNode(rootComponent, rootProps);
          vnode.appContext = context;
          if (isHydrate && hydrate) {
            hydrate(vnode, rootContainer);
          } else {
            render2(vnode, rootContainer, isSVG);
          }
          isMounted = true;
          app2._container = rootContainer;
          rootContainer.__vue_app__ = app2;
          return getExposeProxy(vnode.component) || vnode.component.proxy;
        }
      },
      unmount() {
        if (isMounted) {
          render2(null, app2._container);
          delete app2._container.__vue_app__;
        }
      },
      provide(key, value) {
        context.provides[key] = value;
        return app2;
      }
    };
    return app2;
  };
}
function setRef(rawRef, oldRawRef, parentSuspense, vnode, isUnmount = false) {
  if (isArray$2(rawRef)) {
    rawRef.forEach((r2, i) => setRef(r2, oldRawRef && (isArray$2(oldRawRef) ? oldRawRef[i] : oldRawRef), parentSuspense, vnode, isUnmount));
    return;
  }
  if (isAsyncWrapper(vnode) && !isUnmount) {
    return;
  }
  const refValue = vnode.shapeFlag & 4 ? getExposeProxy(vnode.component) || vnode.component.proxy : vnode.el;
  const value = isUnmount ? null : refValue;
  const { i: owner, r: ref2 } = rawRef;
  const oldRef = oldRawRef && oldRawRef.r;
  const refs = owner.refs === EMPTY_OBJ ? owner.refs = {} : owner.refs;
  const setupState = owner.setupState;
  if (oldRef != null && oldRef !== ref2) {
    if (isString$5(oldRef)) {
      refs[oldRef] = null;
      if (hasOwn$1(setupState, oldRef)) {
        setupState[oldRef] = null;
      }
    } else if (isRef(oldRef)) {
      oldRef.value = null;
    }
  }
  if (isFunction$4(ref2)) {
    callWithErrorHandling(ref2, owner, 12, [value, refs]);
  } else {
    const _isString = isString$5(ref2);
    const _isRef = isRef(ref2);
    if (_isString || _isRef) {
      const doSet = () => {
        if (rawRef.f) {
          const existing = _isString ? refs[ref2] : ref2.value;
          if (isUnmount) {
            isArray$2(existing) && remove(existing, refValue);
          } else {
            if (!isArray$2(existing)) {
              if (_isString) {
                refs[ref2] = [refValue];
              } else {
                ref2.value = [refValue];
                if (rawRef.k)
                  refs[rawRef.k] = ref2.value;
              }
            } else if (!existing.includes(refValue)) {
              existing.push(refValue);
            }
          }
        } else if (_isString) {
          refs[ref2] = value;
          if (hasOwn$1(setupState, ref2)) {
            setupState[ref2] = value;
          }
        } else if (isRef(ref2)) {
          ref2.value = value;
          if (rawRef.k)
            refs[rawRef.k] = value;
        } else
          ;
      };
      if (value) {
        doSet.id = -1;
        queuePostRenderEffect(doSet, parentSuspense);
      } else {
        doSet();
      }
    }
  }
}
const queuePostRenderEffect = queueEffectWithSuspense;
function createRenderer(options2) {
  return baseCreateRenderer(options2);
}
function baseCreateRenderer(options2, createHydrationFns) {
  const target2 = getGlobalThis$2();
  target2.__VUE__ = true;
  const { insert: hostInsert, remove: hostRemove, patchProp: hostPatchProp, createElement: hostCreateElement, createText: hostCreateText, createComment: hostCreateComment, setText: hostSetText, setElementText: hostSetElementText, parentNode: hostParentNode, nextSibling: hostNextSibling, setScopeId: hostSetScopeId = NOOP, cloneNode: hostCloneNode, insertStaticContent: hostInsertStaticContent } = options2;
  const patch = (n1, n2, container, anchor = null, parentComponent = null, parentSuspense = null, isSVG = false, slotScopeIds = null, optimized = !!n2.dynamicChildren) => {
    if (n1 === n2) {
      return;
    }
    if (n1 && !isSameVNodeType(n1, n2)) {
      anchor = getNextHostNode(n1);
      unmount(n1, parentComponent, parentSuspense, true);
      n1 = null;
    }
    if (n2.patchFlag === -2) {
      optimized = false;
      n2.dynamicChildren = null;
    }
    const { type: type2, ref: ref2, shapeFlag } = n2;
    switch (type2) {
      case Text:
        processText(n1, n2, container, anchor);
        break;
      case Comment:
        processCommentNode(n1, n2, container, anchor);
        break;
      case Static:
        if (n1 == null) {
          mountStaticNode(n2, container, anchor, isSVG);
        }
        break;
      case Fragment:
        processFragment(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        break;
      default:
        if (shapeFlag & 1) {
          processElement(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (shapeFlag & 6) {
          processComponent(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (shapeFlag & 64) {
          type2.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);
        } else if (shapeFlag & 128) {
          type2.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);
        } else
          ;
    }
    if (ref2 != null && parentComponent) {
      setRef(ref2, n1 && n1.ref, parentSuspense, n2 || n1, !n2);
    }
  };
  const processText = (n1, n2, container, anchor) => {
    if (n1 == null) {
      hostInsert(n2.el = hostCreateText(n2.children), container, anchor);
    } else {
      const el2 = n2.el = n1.el;
      if (n2.children !== n1.children) {
        hostSetText(el2, n2.children);
      }
    }
  };
  const processCommentNode = (n1, n2, container, anchor) => {
    if (n1 == null) {
      hostInsert(n2.el = hostCreateComment(n2.children || ""), container, anchor);
    } else {
      n2.el = n1.el;
    }
  };
  const mountStaticNode = (n2, container, anchor, isSVG) => {
    [n2.el, n2.anchor] = hostInsertStaticContent(n2.children, container, anchor, isSVG, n2.el, n2.anchor);
  };
  const moveStaticNode = ({ el: el2, anchor }, container, nextSibling) => {
    let next;
    while (el2 && el2 !== anchor) {
      next = hostNextSibling(el2);
      hostInsert(el2, container, nextSibling);
      el2 = next;
    }
    hostInsert(anchor, container, nextSibling);
  };
  const removeStaticNode = ({ el: el2, anchor }) => {
    let next;
    while (el2 && el2 !== anchor) {
      next = hostNextSibling(el2);
      hostRemove(el2);
      el2 = next;
    }
    hostRemove(anchor);
  };
  const processElement = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    isSVG = isSVG || n2.type === "svg";
    if (n1 == null) {
      mountElement(n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    } else {
      patchElement(n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
  };
  const mountElement = (vnode, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    let el2;
    let vnodeHook;
    const { type: type2, props, shapeFlag, transition, patchFlag, dirs } = vnode;
    if (vnode.el && hostCloneNode !== void 0 && patchFlag === -1) {
      el2 = vnode.el = hostCloneNode(vnode.el);
    } else {
      el2 = vnode.el = hostCreateElement(vnode.type, isSVG, props && props.is, props);
      if (shapeFlag & 8) {
        hostSetElementText(el2, vnode.children);
      } else if (shapeFlag & 16) {
        mountChildren(vnode.children, el2, null, parentComponent, parentSuspense, isSVG && type2 !== "foreignObject", slotScopeIds, optimized);
      }
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "created");
      }
      if (props) {
        for (const key in props) {
          if (key !== "value" && !isReservedProp(key)) {
            hostPatchProp(el2, key, null, props[key], isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
          }
        }
        if ("value" in props) {
          hostPatchProp(el2, "value", null, props.value);
        }
        if (vnodeHook = props.onVnodeBeforeMount) {
          invokeVNodeHook(vnodeHook, parentComponent, vnode);
        }
      }
      setScopeId(el2, vnode, vnode.scopeId, slotScopeIds, parentComponent);
    }
    if (dirs) {
      invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
    }
    const needCallTransitionHooks = (!parentSuspense || parentSuspense && !parentSuspense.pendingBranch) && transition && !transition.persisted;
    if (needCallTransitionHooks) {
      transition.beforeEnter(el2);
    }
    hostInsert(el2, container, anchor);
    if ((vnodeHook = props && props.onVnodeMounted) || needCallTransitionHooks || dirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
        needCallTransitionHooks && transition.enter(el2);
        dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
      }, parentSuspense);
    }
  };
  const setScopeId = (el2, vnode, scopeId, slotScopeIds, parentComponent) => {
    if (scopeId) {
      hostSetScopeId(el2, scopeId);
    }
    if (slotScopeIds) {
      for (let i = 0; i < slotScopeIds.length; i++) {
        hostSetScopeId(el2, slotScopeIds[i]);
      }
    }
    if (parentComponent) {
      let subTree = parentComponent.subTree;
      if (vnode === subTree) {
        const parentVNode = parentComponent.vnode;
        setScopeId(el2, parentVNode, parentVNode.scopeId, parentVNode.slotScopeIds, parentComponent.parent);
      }
    }
  };
  const mountChildren = (children, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, start2 = 0) => {
    for (let i = start2; i < children.length; i++) {
      const child = children[i] = optimized ? cloneIfMounted(children[i]) : normalizeVNode(children[i]);
      patch(null, child, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
  };
  const patchElement = (n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    const el2 = n2.el = n1.el;
    let { patchFlag, dynamicChildren, dirs } = n2;
    patchFlag |= n1.patchFlag & 16;
    const oldProps = n1.props || EMPTY_OBJ;
    const newProps = n2.props || EMPTY_OBJ;
    let vnodeHook;
    parentComponent && toggleRecurse(parentComponent, false);
    if (vnodeHook = newProps.onVnodeBeforeUpdate) {
      invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
    }
    if (dirs) {
      invokeDirectiveHook(n2, n1, parentComponent, "beforeUpdate");
    }
    parentComponent && toggleRecurse(parentComponent, true);
    const areChildrenSVG = isSVG && n2.type !== "foreignObject";
    if (dynamicChildren) {
      patchBlockChildren(n1.dynamicChildren, dynamicChildren, el2, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds);
    } else if (!optimized) {
      patchChildren(n1, n2, el2, null, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds, false);
    }
    if (patchFlag > 0) {
      if (patchFlag & 16) {
        patchProps(el2, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);
      } else {
        if (patchFlag & 2) {
          if (oldProps.class !== newProps.class) {
            hostPatchProp(el2, "class", null, newProps.class, isSVG);
          }
        }
        if (patchFlag & 4) {
          hostPatchProp(el2, "style", oldProps.style, newProps.style, isSVG);
        }
        if (patchFlag & 8) {
          const propsToUpdate = n2.dynamicProps;
          for (let i = 0; i < propsToUpdate.length; i++) {
            const key = propsToUpdate[i];
            const prev2 = oldProps[key];
            const next = newProps[key];
            if (next !== prev2 || key === "value") {
              hostPatchProp(el2, key, prev2, next, isSVG, n1.children, parentComponent, parentSuspense, unmountChildren);
            }
          }
        }
      }
      if (patchFlag & 1) {
        if (n1.children !== n2.children) {
          hostSetElementText(el2, n2.children);
        }
      }
    } else if (!optimized && dynamicChildren == null) {
      patchProps(el2, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);
    }
    if ((vnodeHook = newProps.onVnodeUpdated) || dirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
        dirs && invokeDirectiveHook(n2, n1, parentComponent, "updated");
      }, parentSuspense);
    }
  };
  const patchBlockChildren = (oldChildren, newChildren, fallbackContainer, parentComponent, parentSuspense, isSVG, slotScopeIds) => {
    for (let i = 0; i < newChildren.length; i++) {
      const oldVNode = oldChildren[i];
      const newVNode = newChildren[i];
      const container = oldVNode.el && (oldVNode.type === Fragment || !isSameVNodeType(oldVNode, newVNode) || oldVNode.shapeFlag & (6 | 64)) ? hostParentNode(oldVNode.el) : fallbackContainer;
      patch(oldVNode, newVNode, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, true);
    }
  };
  const patchProps = (el2, vnode, oldProps, newProps, parentComponent, parentSuspense, isSVG) => {
    if (oldProps !== newProps) {
      for (const key in newProps) {
        if (isReservedProp(key))
          continue;
        const next = newProps[key];
        const prev2 = oldProps[key];
        if (next !== prev2 && key !== "value") {
          hostPatchProp(el2, key, prev2, next, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
        }
      }
      if (oldProps !== EMPTY_OBJ) {
        for (const key in oldProps) {
          if (!isReservedProp(key) && !(key in newProps)) {
            hostPatchProp(el2, key, oldProps[key], null, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
          }
        }
      }
      if ("value" in newProps) {
        hostPatchProp(el2, "value", oldProps.value, newProps.value);
      }
    }
  };
  const processFragment = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    const fragmentStartAnchor = n2.el = n1 ? n1.el : hostCreateText("");
    const fragmentEndAnchor = n2.anchor = n1 ? n1.anchor : hostCreateText("");
    let { patchFlag, dynamicChildren, slotScopeIds: fragmentSlotScopeIds } = n2;
    if (fragmentSlotScopeIds) {
      slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
    }
    if (n1 == null) {
      hostInsert(fragmentStartAnchor, container, anchor);
      hostInsert(fragmentEndAnchor, container, anchor);
      mountChildren(n2.children, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    } else {
      if (patchFlag > 0 && patchFlag & 64 && dynamicChildren && n1.dynamicChildren) {
        patchBlockChildren(n1.dynamicChildren, dynamicChildren, container, parentComponent, parentSuspense, isSVG, slotScopeIds);
        if (n2.key != null || parentComponent && n2 === parentComponent.subTree) {
          traverseStaticChildren(n1, n2, true);
        }
      } else {
        patchChildren(n1, n2, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      }
    }
  };
  const processComponent = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    n2.slotScopeIds = slotScopeIds;
    if (n1 == null) {
      if (n2.shapeFlag & 512) {
        parentComponent.ctx.activate(n2, container, anchor, isSVG, optimized);
      } else {
        mountComponent(n2, container, anchor, parentComponent, parentSuspense, isSVG, optimized);
      }
    } else {
      updateComponent(n1, n2, optimized);
    }
  };
  const mountComponent = (initialVNode, container, anchor, parentComponent, parentSuspense, isSVG, optimized) => {
    const instance = initialVNode.component = createComponentInstance(initialVNode, parentComponent, parentSuspense);
    if (isKeepAlive(initialVNode)) {
      instance.ctx.renderer = internals;
    }
    {
      setupComponent(instance);
    }
    if (instance.asyncDep) {
      parentSuspense && parentSuspense.registerDep(instance, setupRenderEffect);
      if (!initialVNode.el) {
        const placeholder = instance.subTree = createVNode(Comment);
        processCommentNode(null, placeholder, container, anchor);
      }
      return;
    }
    setupRenderEffect(instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized);
  };
  const updateComponent = (n1, n2, optimized) => {
    const instance = n2.component = n1.component;
    if (shouldUpdateComponent(n1, n2, optimized)) {
      if (instance.asyncDep && !instance.asyncResolved) {
        updateComponentPreRender(instance, n2, optimized);
        return;
      } else {
        instance.next = n2;
        invalidateJob(instance.update);
        instance.update();
      }
    } else {
      n2.component = n1.component;
      n2.el = n1.el;
      instance.vnode = n2;
    }
  };
  const setupRenderEffect = (instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized) => {
    const componentUpdateFn = () => {
      if (!instance.isMounted) {
        let vnodeHook;
        const { el: el2, props } = initialVNode;
        const { bm, m: m2, parent } = instance;
        const isAsyncWrapperVNode = isAsyncWrapper(initialVNode);
        toggleRecurse(instance, false);
        if (bm) {
          invokeArrayFns(bm);
        }
        if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeBeforeMount)) {
          invokeVNodeHook(vnodeHook, parent, initialVNode);
        }
        toggleRecurse(instance, true);
        if (el2 && hydrateNode) {
          const hydrateSubTree = () => {
            instance.subTree = renderComponentRoot(instance);
            hydrateNode(el2, instance.subTree, instance, parentSuspense, null);
          };
          if (isAsyncWrapperVNode) {
            initialVNode.type.__asyncLoader().then(
              () => !instance.isUnmounted && hydrateSubTree()
            );
          } else {
            hydrateSubTree();
          }
        } else {
          const subTree = instance.subTree = renderComponentRoot(instance);
          patch(null, subTree, container, anchor, instance, parentSuspense, isSVG);
          initialVNode.el = subTree.el;
        }
        if (m2) {
          queuePostRenderEffect(m2, parentSuspense);
        }
        if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeMounted)) {
          const scopedInitialVNode = initialVNode;
          queuePostRenderEffect(() => invokeVNodeHook(vnodeHook, parent, scopedInitialVNode), parentSuspense);
        }
        if (initialVNode.shapeFlag & 256) {
          instance.a && queuePostRenderEffect(instance.a, parentSuspense);
        }
        instance.isMounted = true;
        initialVNode = container = anchor = null;
      } else {
        let { next, bu, u: u2, parent, vnode } = instance;
        let originNext = next;
        let vnodeHook;
        toggleRecurse(instance, false);
        if (next) {
          next.el = vnode.el;
          updateComponentPreRender(instance, next, optimized);
        } else {
          next = vnode;
        }
        if (bu) {
          invokeArrayFns(bu);
        }
        if (vnodeHook = next.props && next.props.onVnodeBeforeUpdate) {
          invokeVNodeHook(vnodeHook, parent, next, vnode);
        }
        toggleRecurse(instance, true);
        const nextTree = renderComponentRoot(instance);
        const prevTree = instance.subTree;
        instance.subTree = nextTree;
        patch(
          prevTree,
          nextTree,
          hostParentNode(prevTree.el),
          getNextHostNode(prevTree),
          instance,
          parentSuspense,
          isSVG
        );
        next.el = nextTree.el;
        if (originNext === null) {
          updateHOCHostEl(instance, nextTree.el);
        }
        if (u2) {
          queuePostRenderEffect(u2, parentSuspense);
        }
        if (vnodeHook = next.props && next.props.onVnodeUpdated) {
          queuePostRenderEffect(() => invokeVNodeHook(vnodeHook, parent, next, vnode), parentSuspense);
        }
      }
    };
    const effect2 = instance.effect = new ReactiveEffect(
      componentUpdateFn,
      () => queueJob(instance.update),
      instance.scope
    );
    const update = instance.update = effect2.run.bind(effect2);
    update.id = instance.uid;
    toggleRecurse(instance, true);
    update();
  };
  const updateComponentPreRender = (instance, nextVNode, optimized) => {
    nextVNode.component = instance;
    const prevProps = instance.vnode.props;
    instance.vnode = nextVNode;
    instance.next = null;
    updateProps(instance, nextVNode.props, prevProps, optimized);
    updateSlots(instance, nextVNode.children, optimized);
    pauseTracking();
    flushPreFlushCbs(void 0, instance.update);
    resetTracking();
  };
  const patchChildren = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized = false) => {
    const c1 = n1 && n1.children;
    const prevShapeFlag = n1 ? n1.shapeFlag : 0;
    const c2 = n2.children;
    const { patchFlag, shapeFlag } = n2;
    if (patchFlag > 0) {
      if (patchFlag & 128) {
        patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        return;
      } else if (patchFlag & 256) {
        patchUnkeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        return;
      }
    }
    if (shapeFlag & 8) {
      if (prevShapeFlag & 16) {
        unmountChildren(c1, parentComponent, parentSuspense);
      }
      if (c2 !== c1) {
        hostSetElementText(container, c2);
      }
    } else {
      if (prevShapeFlag & 16) {
        if (shapeFlag & 16) {
          patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else {
          unmountChildren(c1, parentComponent, parentSuspense, true);
        }
      } else {
        if (prevShapeFlag & 8) {
          hostSetElementText(container, "");
        }
        if (shapeFlag & 16) {
          mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
      }
    }
  };
  const patchUnkeyedChildren = (c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    c1 = c1 || EMPTY_ARR;
    c2 = c2 || EMPTY_ARR;
    const oldLength = c1.length;
    const newLength = c2.length;
    const commonLength = Math.min(oldLength, newLength);
    let i;
    for (i = 0; i < commonLength; i++) {
      const nextChild = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
      patch(c1[i], nextChild, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    }
    if (oldLength > newLength) {
      unmountChildren(c1, parentComponent, parentSuspense, true, false, commonLength);
    } else {
      mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, commonLength);
    }
  };
  const patchKeyedChildren = (c1, c2, container, parentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized) => {
    let i = 0;
    const l2 = c2.length;
    let e1 = c1.length - 1;
    let e2 = l2 - 1;
    while (i <= e1 && i <= e2) {
      const n1 = c1[i];
      const n2 = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
      if (isSameVNodeType(n1, n2)) {
        patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      } else {
        break;
      }
      i++;
    }
    while (i <= e1 && i <= e2) {
      const n1 = c1[e1];
      const n2 = c2[e2] = optimized ? cloneIfMounted(c2[e2]) : normalizeVNode(c2[e2]);
      if (isSameVNodeType(n1, n2)) {
        patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
      } else {
        break;
      }
      e1--;
      e2--;
    }
    if (i > e1) {
      if (i <= e2) {
        const nextPos = e2 + 1;
        const anchor = nextPos < l2 ? c2[nextPos].el : parentAnchor;
        while (i <= e2) {
          patch(null, c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]), container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
          i++;
        }
      }
    } else if (i > e2) {
      while (i <= e1) {
        unmount(c1[i], parentComponent, parentSuspense, true);
        i++;
      }
    } else {
      const s1 = i;
      const s2 = i;
      const keyToNewIndexMap = /* @__PURE__ */ new Map();
      for (i = s2; i <= e2; i++) {
        const nextChild = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
        if (nextChild.key != null) {
          keyToNewIndexMap.set(nextChild.key, i);
        }
      }
      let j;
      let patched = 0;
      const toBePatched = e2 - s2 + 1;
      let moved = false;
      let maxNewIndexSoFar = 0;
      const newIndexToOldIndexMap = new Array(toBePatched);
      for (i = 0; i < toBePatched; i++)
        newIndexToOldIndexMap[i] = 0;
      for (i = s1; i <= e1; i++) {
        const prevChild = c1[i];
        if (patched >= toBePatched) {
          unmount(prevChild, parentComponent, parentSuspense, true);
          continue;
        }
        let newIndex;
        if (prevChild.key != null) {
          newIndex = keyToNewIndexMap.get(prevChild.key);
        } else {
          for (j = s2; j <= e2; j++) {
            if (newIndexToOldIndexMap[j - s2] === 0 && isSameVNodeType(prevChild, c2[j])) {
              newIndex = j;
              break;
            }
          }
        }
        if (newIndex === void 0) {
          unmount(prevChild, parentComponent, parentSuspense, true);
        } else {
          newIndexToOldIndexMap[newIndex - s2] = i + 1;
          if (newIndex >= maxNewIndexSoFar) {
            maxNewIndexSoFar = newIndex;
          } else {
            moved = true;
          }
          patch(prevChild, c2[newIndex], container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
          patched++;
        }
      }
      const increasingNewIndexSequence = moved ? getSequence(newIndexToOldIndexMap) : EMPTY_ARR;
      j = increasingNewIndexSequence.length - 1;
      for (i = toBePatched - 1; i >= 0; i--) {
        const nextIndex = s2 + i;
        const nextChild = c2[nextIndex];
        const anchor = nextIndex + 1 < l2 ? c2[nextIndex + 1].el : parentAnchor;
        if (newIndexToOldIndexMap[i] === 0) {
          patch(null, nextChild, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (moved) {
          if (j < 0 || i !== increasingNewIndexSequence[j]) {
            move(nextChild, container, anchor, 2);
          } else {
            j--;
          }
        }
      }
    }
  };
  const move = (vnode, container, anchor, moveType, parentSuspense = null) => {
    const { el: el2, type: type2, transition, children, shapeFlag } = vnode;
    if (shapeFlag & 6) {
      move(vnode.component.subTree, container, anchor, moveType);
      return;
    }
    if (shapeFlag & 128) {
      vnode.suspense.move(container, anchor, moveType);
      return;
    }
    if (shapeFlag & 64) {
      type2.move(vnode, container, anchor, internals);
      return;
    }
    if (type2 === Fragment) {
      hostInsert(el2, container, anchor);
      for (let i = 0; i < children.length; i++) {
        move(children[i], container, anchor, moveType);
      }
      hostInsert(vnode.anchor, container, anchor);
      return;
    }
    if (type2 === Static) {
      moveStaticNode(vnode, container, anchor);
      return;
    }
    const needTransition = moveType !== 2 && shapeFlag & 1 && transition;
    if (needTransition) {
      if (moveType === 0) {
        transition.beforeEnter(el2);
        hostInsert(el2, container, anchor);
        queuePostRenderEffect(() => transition.enter(el2), parentSuspense);
      } else {
        const { leave, delayLeave, afterLeave } = transition;
        const remove3 = () => hostInsert(el2, container, anchor);
        const performLeave = () => {
          leave(el2, () => {
            remove3();
            afterLeave && afterLeave();
          });
        };
        if (delayLeave) {
          delayLeave(el2, remove3, performLeave);
        } else {
          performLeave();
        }
      }
    } else {
      hostInsert(el2, container, anchor);
    }
  };
  const unmount = (vnode, parentComponent, parentSuspense, doRemove = false, optimized = false) => {
    const { type: type2, props, ref: ref2, children, dynamicChildren, shapeFlag, patchFlag, dirs } = vnode;
    if (ref2 != null) {
      setRef(ref2, null, parentSuspense, vnode, true);
    }
    if (shapeFlag & 256) {
      parentComponent.ctx.deactivate(vnode);
      return;
    }
    const shouldInvokeDirs = shapeFlag & 1 && dirs;
    const shouldInvokeVnodeHook = !isAsyncWrapper(vnode);
    let vnodeHook;
    if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeBeforeUnmount)) {
      invokeVNodeHook(vnodeHook, parentComponent, vnode);
    }
    if (shapeFlag & 6) {
      unmountComponent(vnode.component, parentSuspense, doRemove);
    } else {
      if (shapeFlag & 128) {
        vnode.suspense.unmount(parentSuspense, doRemove);
        return;
      }
      if (shouldInvokeDirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "beforeUnmount");
      }
      if (shapeFlag & 64) {
        vnode.type.remove(vnode, parentComponent, parentSuspense, optimized, internals, doRemove);
      } else if (dynamicChildren && (type2 !== Fragment || patchFlag > 0 && patchFlag & 64)) {
        unmountChildren(dynamicChildren, parentComponent, parentSuspense, false, true);
      } else if (type2 === Fragment && patchFlag & (128 | 256) || !optimized && shapeFlag & 16) {
        unmountChildren(children, parentComponent, parentSuspense);
      }
      if (doRemove) {
        remove2(vnode);
      }
    }
    if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeUnmounted) || shouldInvokeDirs) {
      queuePostRenderEffect(() => {
        vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
        shouldInvokeDirs && invokeDirectiveHook(vnode, null, parentComponent, "unmounted");
      }, parentSuspense);
    }
  };
  const remove2 = (vnode) => {
    const { type: type2, el: el2, anchor, transition } = vnode;
    if (type2 === Fragment) {
      removeFragment(el2, anchor);
      return;
    }
    if (type2 === Static) {
      removeStaticNode(vnode);
      return;
    }
    const performRemove = () => {
      hostRemove(el2);
      if (transition && !transition.persisted && transition.afterLeave) {
        transition.afterLeave();
      }
    };
    if (vnode.shapeFlag & 1 && transition && !transition.persisted) {
      const { leave, delayLeave } = transition;
      const performLeave = () => leave(el2, performRemove);
      if (delayLeave) {
        delayLeave(vnode.el, performRemove, performLeave);
      } else {
        performLeave();
      }
    } else {
      performRemove();
    }
  };
  const removeFragment = (cur, end2) => {
    let next;
    while (cur !== end2) {
      next = hostNextSibling(cur);
      hostRemove(cur);
      cur = next;
    }
    hostRemove(end2);
  };
  const unmountComponent = (instance, parentSuspense, doRemove) => {
    const { bum, scope, update, subTree, um } = instance;
    if (bum) {
      invokeArrayFns(bum);
    }
    scope.stop();
    if (update) {
      update.active = false;
      unmount(subTree, instance, parentSuspense, doRemove);
    }
    if (um) {
      queuePostRenderEffect(um, parentSuspense);
    }
    queuePostRenderEffect(() => {
      instance.isUnmounted = true;
    }, parentSuspense);
    if (parentSuspense && parentSuspense.pendingBranch && !parentSuspense.isUnmounted && instance.asyncDep && !instance.asyncResolved && instance.suspenseId === parentSuspense.pendingId) {
      parentSuspense.deps--;
      if (parentSuspense.deps === 0) {
        parentSuspense.resolve();
      }
    }
  };
  const unmountChildren = (children, parentComponent, parentSuspense, doRemove = false, optimized = false, start2 = 0) => {
    for (let i = start2; i < children.length; i++) {
      unmount(children[i], parentComponent, parentSuspense, doRemove, optimized);
    }
  };
  const getNextHostNode = (vnode) => {
    if (vnode.shapeFlag & 6) {
      return getNextHostNode(vnode.component.subTree);
    }
    if (vnode.shapeFlag & 128) {
      return vnode.suspense.next();
    }
    return hostNextSibling(vnode.anchor || vnode.el);
  };
  const render2 = (vnode, container, isSVG) => {
    if (vnode == null) {
      if (container._vnode) {
        unmount(container._vnode, null, null, true);
      }
    } else {
      patch(container._vnode || null, vnode, container, null, null, null, isSVG);
    }
    flushPostFlushCbs();
    container._vnode = vnode;
  };
  const internals = {
    p: patch,
    um: unmount,
    m: move,
    r: remove2,
    mt: mountComponent,
    mc: mountChildren,
    pc: patchChildren,
    pbc: patchBlockChildren,
    n: getNextHostNode,
    o: options2
  };
  let hydrate;
  let hydrateNode;
  if (createHydrationFns) {
    [hydrate, hydrateNode] = createHydrationFns(internals);
  }
  return {
    render: render2,
    hydrate,
    createApp: createAppAPI(render2, hydrate)
  };
}
function toggleRecurse({ effect: effect2, update }, allowed) {
  effect2.allowRecurse = update.allowRecurse = allowed;
}
function traverseStaticChildren(n1, n2, shallow = false) {
  const ch1 = n1.children;
  const ch2 = n2.children;
  if (isArray$2(ch1) && isArray$2(ch2)) {
    for (let i = 0; i < ch1.length; i++) {
      const c1 = ch1[i];
      let c2 = ch2[i];
      if (c2.shapeFlag & 1 && !c2.dynamicChildren) {
        if (c2.patchFlag <= 0 || c2.patchFlag === 32) {
          c2 = ch2[i] = cloneIfMounted(ch2[i]);
          c2.el = c1.el;
        }
        if (!shallow)
          traverseStaticChildren(c1, c2);
      }
    }
  }
}
function getSequence(arr) {
  const p2 = arr.slice();
  const result = [0];
  let i, j, u2, v, c2;
  const len = arr.length;
  for (i = 0; i < len; i++) {
    const arrI = arr[i];
    if (arrI !== 0) {
      j = result[result.length - 1];
      if (arr[j] < arrI) {
        p2[i] = j;
        result.push(i);
        continue;
      }
      u2 = 0;
      v = result.length - 1;
      while (u2 < v) {
        c2 = u2 + v >> 1;
        if (arr[result[c2]] < arrI) {
          u2 = c2 + 1;
        } else {
          v = c2;
        }
      }
      if (arrI < arr[result[u2]]) {
        if (u2 > 0) {
          p2[i] = result[u2 - 1];
        }
        result[u2] = i;
      }
    }
  }
  u2 = result.length;
  v = result[u2 - 1];
  while (u2-- > 0) {
    result[u2] = v;
    v = p2[v];
  }
  return result;
}
const isTeleport = (type2) => type2.__isTeleport;
const isTeleportDisabled = (props) => props && (props.disabled || props.disabled === "");
const isTargetSVG = (target2) => typeof SVGElement !== "undefined" && target2 instanceof SVGElement;
const resolveTarget = (props, select) => {
  const targetSelector = props && props.to;
  if (isString$5(targetSelector)) {
    if (!select) {
      return null;
    } else {
      const target2 = select(targetSelector);
      return target2;
    }
  } else {
    return targetSelector;
  }
};
const TeleportImpl = {
  __isTeleport: true,
  process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals) {
    const { mc: mountChildren, pc: patchChildren, pbc: patchBlockChildren, o: { insert: insert2, querySelector, createText, createComment } } = internals;
    const disabled = isTeleportDisabled(n2.props);
    let { shapeFlag, children, dynamicChildren } = n2;
    if (n1 == null) {
      const placeholder = n2.el = createText("");
      const mainAnchor = n2.anchor = createText("");
      insert2(placeholder, container, anchor);
      insert2(mainAnchor, container, anchor);
      const target2 = n2.target = resolveTarget(n2.props, querySelector);
      const targetAnchor = n2.targetAnchor = createText("");
      if (target2) {
        insert2(targetAnchor, target2);
        isSVG = isSVG || isTargetSVG(target2);
      }
      const mount = (container2, anchor2) => {
        if (shapeFlag & 16) {
          mountChildren(children, container2, anchor2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
      };
      if (disabled) {
        mount(container, mainAnchor);
      } else if (target2) {
        mount(target2, targetAnchor);
      }
    } else {
      n2.el = n1.el;
      const mainAnchor = n2.anchor = n1.anchor;
      const target2 = n2.target = n1.target;
      const targetAnchor = n2.targetAnchor = n1.targetAnchor;
      const wasDisabled = isTeleportDisabled(n1.props);
      const currentContainer = wasDisabled ? container : target2;
      const currentAnchor = wasDisabled ? mainAnchor : targetAnchor;
      isSVG = isSVG || isTargetSVG(target2);
      if (dynamicChildren) {
        patchBlockChildren(n1.dynamicChildren, dynamicChildren, currentContainer, parentComponent, parentSuspense, isSVG, slotScopeIds);
        traverseStaticChildren(n1, n2, true);
      } else if (!optimized) {
        patchChildren(n1, n2, currentContainer, currentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, false);
      }
      if (disabled) {
        if (!wasDisabled) {
          moveTeleport(n2, container, mainAnchor, internals, 1);
        }
      } else {
        if ((n2.props && n2.props.to) !== (n1.props && n1.props.to)) {
          const nextTarget = n2.target = resolveTarget(n2.props, querySelector);
          if (nextTarget) {
            moveTeleport(n2, nextTarget, null, internals, 0);
          }
        } else if (wasDisabled) {
          moveTeleport(n2, target2, targetAnchor, internals, 1);
        }
      }
    }
  },
  remove(vnode, parentComponent, parentSuspense, optimized, { um: unmount, o: { remove: hostRemove } }, doRemove) {
    const { shapeFlag, children, anchor, targetAnchor, target: target2, props } = vnode;
    if (target2) {
      hostRemove(targetAnchor);
    }
    if (doRemove || !isTeleportDisabled(props)) {
      hostRemove(anchor);
      if (shapeFlag & 16) {
        for (let i = 0; i < children.length; i++) {
          const child = children[i];
          unmount(child, parentComponent, parentSuspense, true, !!child.dynamicChildren);
        }
      }
    }
  },
  move: moveTeleport,
  hydrate: hydrateTeleport
};
function moveTeleport(vnode, container, parentAnchor, { o: { insert: insert2 }, m: move }, moveType = 2) {
  if (moveType === 0) {
    insert2(vnode.targetAnchor, container, parentAnchor);
  }
  const { el: el2, anchor, shapeFlag, children, props } = vnode;
  const isReorder = moveType === 2;
  if (isReorder) {
    insert2(el2, container, parentAnchor);
  }
  if (!isReorder || isTeleportDisabled(props)) {
    if (shapeFlag & 16) {
      for (let i = 0; i < children.length; i++) {
        move(children[i], container, parentAnchor, 2);
      }
    }
  }
  if (isReorder) {
    insert2(anchor, container, parentAnchor);
  }
}
function hydrateTeleport(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, { o: { nextSibling, parentNode, querySelector } }, hydrateChildren) {
  const target2 = vnode.target = resolveTarget(vnode.props, querySelector);
  if (target2) {
    const targetNode = target2._lpa || target2.firstChild;
    if (vnode.shapeFlag & 16) {
      if (isTeleportDisabled(vnode.props)) {
        vnode.anchor = hydrateChildren(nextSibling(node), vnode, parentNode(node), parentComponent, parentSuspense, slotScopeIds, optimized);
        vnode.targetAnchor = targetNode;
      } else {
        vnode.anchor = nextSibling(node);
        vnode.targetAnchor = hydrateChildren(targetNode, vnode, target2, parentComponent, parentSuspense, slotScopeIds, optimized);
      }
      target2._lpa = vnode.targetAnchor && nextSibling(vnode.targetAnchor);
    }
  }
  return vnode.anchor && nextSibling(vnode.anchor);
}
const Teleport = TeleportImpl;
const COMPONENTS = "components";
function resolveComponent(name2, maybeSelfReference) {
  return resolveAsset(COMPONENTS, name2, true, maybeSelfReference) || name2;
}
const NULL_DYNAMIC_COMPONENT = Symbol();
function resolveDynamicComponent(component) {
  if (isString$5(component)) {
    return resolveAsset(COMPONENTS, component, false) || component;
  } else {
    return component || NULL_DYNAMIC_COMPONENT;
  }
}
function resolveAsset(type2, name2, warnMissing = true, maybeSelfReference = false) {
  const instance = currentRenderingInstance || currentInstance;
  if (instance) {
    const Component = instance.type;
    if (type2 === COMPONENTS) {
      const selfName = getComponentName(Component);
      if (selfName && (selfName === name2 || selfName === camelize(name2) || selfName === capitalize(camelize(name2)))) {
        return Component;
      }
    }
    const res = resolve(instance[type2] || Component[type2], name2) || resolve(instance.appContext[type2], name2);
    if (!res && maybeSelfReference) {
      return Component;
    }
    return res;
  }
}
function resolve(registry, name2) {
  return registry && (registry[name2] || registry[camelize(name2)] || registry[capitalize(camelize(name2))]);
}
const Fragment = Symbol(void 0);
const Text = Symbol(void 0);
const Comment = Symbol(void 0);
const Static = Symbol(void 0);
const blockStack = [];
let currentBlock = null;
function openBlock(disableTracking = false) {
  blockStack.push(currentBlock = disableTracking ? null : []);
}
function closeBlock() {
  blockStack.pop();
  currentBlock = blockStack[blockStack.length - 1] || null;
}
let isBlockTreeEnabled = 1;
function setBlockTracking(value) {
  isBlockTreeEnabled += value;
}
function setupBlock(vnode) {
  vnode.dynamicChildren = isBlockTreeEnabled > 0 ? currentBlock || EMPTY_ARR : null;
  closeBlock();
  if (isBlockTreeEnabled > 0 && currentBlock) {
    currentBlock.push(vnode);
  }
  return vnode;
}
function createElementBlock(type2, props, children, patchFlag, dynamicProps, shapeFlag) {
  return setupBlock(createBaseVNode(type2, props, children, patchFlag, dynamicProps, shapeFlag, true));
}
function createBlock(type2, props, children, patchFlag, dynamicProps) {
  return setupBlock(createVNode(type2, props, children, patchFlag, dynamicProps, true));
}
function isVNode(value) {
  return value ? value.__v_isVNode === true : false;
}
function isSameVNodeType(n1, n2) {
  return n1.type === n2.type && n1.key === n2.key;
}
const InternalObjectKey = `__vInternal`;
const normalizeKey = ({ key }) => key != null ? key : null;
const normalizeRef = ({ ref: ref2, ref_key, ref_for }) => {
  return ref2 != null ? isString$5(ref2) || isRef(ref2) || isFunction$4(ref2) ? { i: currentRenderingInstance, r: ref2, k: ref_key, f: !!ref_for } : ref2 : null;
};
function createBaseVNode(type2, props = null, children = null, patchFlag = 0, dynamicProps = null, shapeFlag = type2 === Fragment ? 0 : 1, isBlockNode = false, needFullChildrenNormalization = false) {
  const vnode = {
    __v_isVNode: true,
    __v_skip: true,
    type: type2,
    props,
    key: props && normalizeKey(props),
    ref: props && normalizeRef(props),
    scopeId: currentScopeId,
    slotScopeIds: null,
    children,
    component: null,
    suspense: null,
    ssContent: null,
    ssFallback: null,
    dirs: null,
    transition: null,
    el: null,
    anchor: null,
    target: null,
    targetAnchor: null,
    staticCount: 0,
    shapeFlag,
    patchFlag,
    dynamicProps,
    dynamicChildren: null,
    appContext: null
  };
  if (needFullChildrenNormalization) {
    normalizeChildren(vnode, children);
    if (shapeFlag & 128) {
      type2.normalize(vnode);
    }
  } else if (children) {
    vnode.shapeFlag |= isString$5(children) ? 8 : 16;
  }
  if (isBlockTreeEnabled > 0 && !isBlockNode && currentBlock && (vnode.patchFlag > 0 || shapeFlag & 6) && vnode.patchFlag !== 32) {
    currentBlock.push(vnode);
  }
  return vnode;
}
const createVNode = _createVNode;
function _createVNode(type2, props = null, children = null, patchFlag = 0, dynamicProps = null, isBlockNode = false) {
  if (!type2 || type2 === NULL_DYNAMIC_COMPONENT) {
    type2 = Comment;
  }
  if (isVNode(type2)) {
    const cloned = cloneVNode(type2, props, true);
    if (children) {
      normalizeChildren(cloned, children);
    }
    return cloned;
  }
  if (isClassComponent(type2)) {
    type2 = type2.__vccOpts;
  }
  if (props) {
    props = guardReactiveProps(props);
    let { class: klass, style } = props;
    if (klass && !isString$5(klass)) {
      props.class = normalizeClass(klass);
    }
    if (isObject$6(style)) {
      if (isProxy(style) && !isArray$2(style)) {
        style = extend({}, style);
      }
      props.style = normalizeStyle(style);
    }
  }
  const shapeFlag = isString$5(type2) ? 1 : isSuspense(type2) ? 128 : isTeleport(type2) ? 64 : isObject$6(type2) ? 4 : isFunction$4(type2) ? 2 : 0;
  return createBaseVNode(type2, props, children, patchFlag, dynamicProps, shapeFlag, isBlockNode, true);
}
function guardReactiveProps(props) {
  if (!props)
    return null;
  return isProxy(props) || InternalObjectKey in props ? extend({}, props) : props;
}
function cloneVNode(vnode, extraProps, mergeRef = false) {
  const { props, ref: ref2, patchFlag, children } = vnode;
  const mergedProps = extraProps ? mergeProps(props || {}, extraProps) : props;
  const cloned = {
    __v_isVNode: true,
    __v_skip: true,
    type: vnode.type,
    props: mergedProps,
    key: mergedProps && normalizeKey(mergedProps),
    ref: extraProps && extraProps.ref ? mergeRef && ref2 ? isArray$2(ref2) ? ref2.concat(normalizeRef(extraProps)) : [ref2, normalizeRef(extraProps)] : normalizeRef(extraProps) : ref2,
    scopeId: vnode.scopeId,
    slotScopeIds: vnode.slotScopeIds,
    children,
    target: vnode.target,
    targetAnchor: vnode.targetAnchor,
    staticCount: vnode.staticCount,
    shapeFlag: vnode.shapeFlag,
    patchFlag: extraProps && vnode.type !== Fragment ? patchFlag === -1 ? 16 : patchFlag | 16 : patchFlag,
    dynamicProps: vnode.dynamicProps,
    dynamicChildren: vnode.dynamicChildren,
    appContext: vnode.appContext,
    dirs: vnode.dirs,
    transition: vnode.transition,
    component: vnode.component,
    suspense: vnode.suspense,
    ssContent: vnode.ssContent && cloneVNode(vnode.ssContent),
    ssFallback: vnode.ssFallback && cloneVNode(vnode.ssFallback),
    el: vnode.el,
    anchor: vnode.anchor
  };
  return cloned;
}
function createTextVNode(text3 = " ", flag = 0) {
  return createVNode(Text, null, text3, flag);
}
function createStaticVNode(content, numberOfNodes) {
  const vnode = createVNode(Static, null, content);
  vnode.staticCount = numberOfNodes;
  return vnode;
}
function createCommentVNode(text3 = "", asBlock = false) {
  return asBlock ? (openBlock(), createBlock(Comment, null, text3)) : createVNode(Comment, null, text3);
}
function normalizeVNode(child) {
  if (child == null || typeof child === "boolean") {
    return createVNode(Comment);
  } else if (isArray$2(child)) {
    return createVNode(
      Fragment,
      null,
      child.slice()
    );
  } else if (typeof child === "object") {
    return cloneIfMounted(child);
  } else {
    return createVNode(Text, null, String(child));
  }
}
function cloneIfMounted(child) {
  return child.el === null || child.memo ? child : cloneVNode(child);
}
function normalizeChildren(vnode, children) {
  let type2 = 0;
  const { shapeFlag } = vnode;
  if (children == null) {
    children = null;
  } else if (isArray$2(children)) {
    type2 = 16;
  } else if (typeof children === "object") {
    if (shapeFlag & (1 | 64)) {
      const slot = children.default;
      if (slot) {
        slot._c && (slot._d = false);
        normalizeChildren(vnode, slot());
        slot._c && (slot._d = true);
      }
      return;
    } else {
      type2 = 32;
      const slotFlag = children._;
      if (!slotFlag && !(InternalObjectKey in children)) {
        children._ctx = currentRenderingInstance;
      } else if (slotFlag === 3 && currentRenderingInstance) {
        if (currentRenderingInstance.slots._ === 1) {
          children._ = 1;
        } else {
          children._ = 2;
          vnode.patchFlag |= 1024;
        }
      }
    }
  } else if (isFunction$4(children)) {
    children = { default: children, _ctx: currentRenderingInstance };
    type2 = 32;
  } else {
    children = String(children);
    if (shapeFlag & 64) {
      type2 = 16;
      children = [createTextVNode(children)];
    } else {
      type2 = 8;
    }
  }
  vnode.children = children;
  vnode.shapeFlag |= type2;
}
function mergeProps(...args) {
  const ret = {};
  for (let i = 0; i < args.length; i++) {
    const toMerge = args[i];
    for (const key in toMerge) {
      if (key === "class") {
        if (ret.class !== toMerge.class) {
          ret.class = normalizeClass([ret.class, toMerge.class]);
        }
      } else if (key === "style") {
        ret.style = normalizeStyle([ret.style, toMerge.style]);
      } else if (isOn(key)) {
        const existing = ret[key];
        const incoming = toMerge[key];
        if (incoming && existing !== incoming && !(isArray$2(existing) && existing.includes(incoming))) {
          ret[key] = existing ? [].concat(existing, incoming) : incoming;
        }
      } else if (key !== "") {
        ret[key] = toMerge[key];
      }
    }
  }
  return ret;
}
function invokeVNodeHook(hook, instance, vnode, prevVNode = null) {
  callWithAsyncErrorHandling(hook, instance, 7, [
    vnode,
    prevVNode
  ]);
}
function renderList(source, renderItem, cache2, index2) {
  let ret;
  const cached = cache2 && cache2[index2];
  if (isArray$2(source) || isString$5(source)) {
    ret = new Array(source.length);
    for (let i = 0, l2 = source.length; i < l2; i++) {
      ret[i] = renderItem(source[i], i, void 0, cached && cached[i]);
    }
  } else if (typeof source === "number") {
    ret = new Array(source);
    for (let i = 0; i < source; i++) {
      ret[i] = renderItem(i + 1, i, void 0, cached && cached[i]);
    }
  } else if (isObject$6(source)) {
    if (source[Symbol.iterator]) {
      ret = Array.from(source, (item, i) => renderItem(item, i, void 0, cached && cached[i]));
    } else {
      const keys = Object.keys(source);
      ret = new Array(keys.length);
      for (let i = 0, l2 = keys.length; i < l2; i++) {
        const key = keys[i];
        ret[i] = renderItem(source[key], key, i, cached && cached[i]);
      }
    }
  } else {
    ret = [];
  }
  if (cache2) {
    cache2[index2] = ret;
  }
  return ret;
}
function createSlots(slots, dynamicSlots) {
  for (let i = 0; i < dynamicSlots.length; i++) {
    const slot = dynamicSlots[i];
    if (isArray$2(slot)) {
      for (let j = 0; j < slot.length; j++) {
        slots[slot[j].name] = slot[j].fn;
      }
    } else if (slot) {
      slots[slot.name] = slot.fn;
    }
  }
  return slots;
}
function renderSlot(slots, name2, props = {}, fallback, noSlotted) {
  if (currentRenderingInstance.isCE) {
    return createVNode("slot", name2 === "default" ? null : { name: name2 }, fallback && fallback());
  }
  let slot = slots[name2];
  if (slot && slot._c) {
    slot._d = false;
  }
  openBlock();
  const validSlotContent = slot && ensureValidVNode(slot(props));
  const rendered = createBlock(Fragment, { key: props.key || `_${name2}` }, validSlotContent || (fallback ? fallback() : []), validSlotContent && slots._ === 1 ? 64 : -2);
  if (!noSlotted && rendered.scopeId) {
    rendered.slotScopeIds = [rendered.scopeId + "-s"];
  }
  if (slot && slot._c) {
    slot._d = true;
  }
  return rendered;
}
function ensureValidVNode(vnodes) {
  return vnodes.some((child) => {
    if (!isVNode(child))
      return true;
    if (child.type === Comment)
      return false;
    if (child.type === Fragment && !ensureValidVNode(child.children))
      return false;
    return true;
  }) ? vnodes : null;
}
function toHandlers(obj) {
  const ret = {};
  for (const key in obj) {
    ret[toHandlerKey(key)] = obj[key];
  }
  return ret;
}
const getPublicInstance = (i) => {
  if (!i)
    return null;
  if (isStatefulComponent(i))
    return getExposeProxy(i) || i.proxy;
  return getPublicInstance(i.parent);
};
const publicPropertiesMap = extend(/* @__PURE__ */ Object.create(null), {
  $: (i) => i,
  $el: (i) => i.vnode.el,
  $data: (i) => i.data,
  $props: (i) => i.props,
  $attrs: (i) => i.attrs,
  $slots: (i) => i.slots,
  $refs: (i) => i.refs,
  $parent: (i) => getPublicInstance(i.parent),
  $root: (i) => getPublicInstance(i.root),
  $emit: (i) => i.emit,
  $options: (i) => resolveMergedOptions(i),
  $forceUpdate: (i) => () => queueJob(i.update),
  $nextTick: (i) => nextTick.bind(i.proxy),
  $watch: (i) => instanceWatch.bind(i)
});
const PublicInstanceProxyHandlers = {
  get({ _: instance }, key) {
    const { ctx, setupState, data, props, accessCache, type: type2, appContext } = instance;
    let normalizedProps;
    if (key[0] !== "$") {
      const n = accessCache[key];
      if (n !== void 0) {
        switch (n) {
          case 1:
            return setupState[key];
          case 2:
            return data[key];
          case 4:
            return ctx[key];
          case 3:
            return props[key];
        }
      } else if (setupState !== EMPTY_OBJ && hasOwn$1(setupState, key)) {
        accessCache[key] = 1;
        return setupState[key];
      } else if (data !== EMPTY_OBJ && hasOwn$1(data, key)) {
        accessCache[key] = 2;
        return data[key];
      } else if ((normalizedProps = instance.propsOptions[0]) && hasOwn$1(normalizedProps, key)) {
        accessCache[key] = 3;
        return props[key];
      } else if (ctx !== EMPTY_OBJ && hasOwn$1(ctx, key)) {
        accessCache[key] = 4;
        return ctx[key];
      } else if (shouldCacheAccess) {
        accessCache[key] = 0;
      }
    }
    const publicGetter = publicPropertiesMap[key];
    let cssModule, globalProperties;
    if (publicGetter) {
      if (key === "$attrs") {
        track(instance, "get", key);
      }
      return publicGetter(instance);
    } else if ((cssModule = type2.__cssModules) && (cssModule = cssModule[key])) {
      return cssModule;
    } else if (ctx !== EMPTY_OBJ && hasOwn$1(ctx, key)) {
      accessCache[key] = 4;
      return ctx[key];
    } else if (globalProperties = appContext.config.globalProperties, hasOwn$1(globalProperties, key)) {
      {
        return globalProperties[key];
      }
    } else
      ;
  },
  set({ _: instance }, key, value) {
    const { data, setupState, ctx } = instance;
    if (setupState !== EMPTY_OBJ && hasOwn$1(setupState, key)) {
      setupState[key] = value;
      return true;
    } else if (data !== EMPTY_OBJ && hasOwn$1(data, key)) {
      data[key] = value;
      return true;
    } else if (hasOwn$1(instance.props, key)) {
      return false;
    }
    if (key[0] === "$" && key.slice(1) in instance) {
      return false;
    } else {
      {
        ctx[key] = value;
      }
    }
    return true;
  },
  has({ _: { data, setupState, accessCache, ctx, appContext, propsOptions } }, key) {
    let normalizedProps;
    return !!accessCache[key] || data !== EMPTY_OBJ && hasOwn$1(data, key) || setupState !== EMPTY_OBJ && hasOwn$1(setupState, key) || (normalizedProps = propsOptions[0]) && hasOwn$1(normalizedProps, key) || hasOwn$1(ctx, key) || hasOwn$1(publicPropertiesMap, key) || hasOwn$1(appContext.config.globalProperties, key);
  },
  defineProperty(target2, key, descriptor) {
    if (descriptor.get != null) {
      this.set(target2, key, descriptor.get(), null);
    } else if (descriptor.value != null) {
      this.set(target2, key, descriptor.value, null);
    }
    return Reflect.defineProperty(target2, key, descriptor);
  }
};
const emptyAppContext = createAppContext();
let uid$1 = 0;
function createComponentInstance(vnode, parent, suspense) {
  const type2 = vnode.type;
  const appContext = (parent ? parent.appContext : vnode.appContext) || emptyAppContext;
  const instance = {
    uid: uid$1++,
    vnode,
    type: type2,
    parent,
    appContext,
    root: null,
    next: null,
    subTree: null,
    effect: null,
    update: null,
    scope: new EffectScope(true),
    render: null,
    proxy: null,
    exposed: null,
    exposeProxy: null,
    withProxy: null,
    provides: parent ? parent.provides : Object.create(appContext.provides),
    accessCache: null,
    renderCache: [],
    components: null,
    directives: null,
    propsOptions: normalizePropsOptions(type2, appContext),
    emitsOptions: normalizeEmitsOptions(type2, appContext),
    emit: null,
    emitted: null,
    propsDefaults: EMPTY_OBJ,
    inheritAttrs: type2.inheritAttrs,
    ctx: EMPTY_OBJ,
    data: EMPTY_OBJ,
    props: EMPTY_OBJ,
    attrs: EMPTY_OBJ,
    slots: EMPTY_OBJ,
    refs: EMPTY_OBJ,
    setupState: EMPTY_OBJ,
    setupContext: null,
    suspense,
    suspenseId: suspense ? suspense.pendingId : 0,
    asyncDep: null,
    asyncResolved: false,
    isMounted: false,
    isUnmounted: false,
    isDeactivated: false,
    bc: null,
    c: null,
    bm: null,
    m: null,
    bu: null,
    u: null,
    um: null,
    bum: null,
    da: null,
    a: null,
    rtg: null,
    rtc: null,
    ec: null,
    sp: null
  };
  {
    instance.ctx = { _: instance };
  }
  instance.root = parent ? parent.root : instance;
  instance.emit = emit$1.bind(null, instance);
  if (vnode.ce) {
    vnode.ce(instance);
  }
  return instance;
}
let currentInstance = null;
const getCurrentInstance = () => currentInstance || currentRenderingInstance;
const setCurrentInstance = (instance) => {
  currentInstance = instance;
  instance.scope.on();
};
const unsetCurrentInstance = () => {
  currentInstance && currentInstance.scope.off();
  currentInstance = null;
};
function isStatefulComponent(instance) {
  return instance.vnode.shapeFlag & 4;
}
let isInSSRComponentSetup = false;
function setupComponent(instance, isSSR = false) {
  isInSSRComponentSetup = isSSR;
  const { props, children } = instance.vnode;
  const isStateful = isStatefulComponent(instance);
  initProps(instance, props, isStateful, isSSR);
  initSlots(instance, children);
  const setupResult = isStateful ? setupStatefulComponent(instance, isSSR) : void 0;
  isInSSRComponentSetup = false;
  return setupResult;
}
function setupStatefulComponent(instance, isSSR) {
  const Component = instance.type;
  instance.accessCache = /* @__PURE__ */ Object.create(null);
  instance.proxy = markRaw(new Proxy(instance.ctx, PublicInstanceProxyHandlers));
  const { setup: setup21 } = Component;
  if (setup21) {
    const setupContext = instance.setupContext = setup21.length > 1 ? createSetupContext(instance) : null;
    setCurrentInstance(instance);
    pauseTracking();
    const setupResult = callWithErrorHandling(setup21, instance, 0, [instance.props, setupContext]);
    resetTracking();
    unsetCurrentInstance();
    if (isPromise(setupResult)) {
      setupResult.then(unsetCurrentInstance, unsetCurrentInstance);
      if (isSSR) {
        return setupResult.then((resolvedResult) => {
          handleSetupResult(instance, resolvedResult, isSSR);
        }).catch((e) => {
          handleError(e, instance, 0);
        });
      } else {
        instance.asyncDep = setupResult;
      }
    } else {
      handleSetupResult(instance, setupResult, isSSR);
    }
  } else {
    finishComponentSetup(instance, isSSR);
  }
}
function handleSetupResult(instance, setupResult, isSSR) {
  if (isFunction$4(setupResult)) {
    if (instance.type.__ssrInlineRender) {
      instance.ssrRender = setupResult;
    } else {
      instance.render = setupResult;
    }
  } else if (isObject$6(setupResult)) {
    instance.setupState = proxyRefs(setupResult);
  } else
    ;
  finishComponentSetup(instance, isSSR);
}
let compile$1;
function finishComponentSetup(instance, isSSR, skipOptions) {
  const Component = instance.type;
  if (!instance.render) {
    if (!isSSR && compile$1 && !Component.render) {
      const template = Component.template;
      if (template) {
        const { isCustomElement, compilerOptions } = instance.appContext.config;
        const { delimiters, compilerOptions: componentCompilerOptions } = Component;
        const finalCompilerOptions = extend(extend({
          isCustomElement,
          delimiters
        }, compilerOptions), componentCompilerOptions);
        Component.render = compile$1(template, finalCompilerOptions);
      }
    }
    instance.render = Component.render || NOOP;
  }
  {
    setCurrentInstance(instance);
    pauseTracking();
    applyOptions(instance);
    resetTracking();
    unsetCurrentInstance();
  }
}
function createAttrsProxy(instance) {
  return new Proxy(instance.attrs, {
    get(target2, key) {
      track(instance, "get", "$attrs");
      return target2[key];
    }
  });
}
function createSetupContext(instance) {
  const expose = (exposed) => {
    instance.exposed = exposed || {};
  };
  let attrs;
  {
    return {
      get attrs() {
        return attrs || (attrs = createAttrsProxy(instance));
      },
      slots: instance.slots,
      emit: instance.emit,
      expose
    };
  }
}
function getExposeProxy(instance) {
  if (instance.exposed) {
    return instance.exposeProxy || (instance.exposeProxy = new Proxy(proxyRefs(markRaw(instance.exposed)), {
      get(target2, key) {
        if (key in target2) {
          return target2[key];
        } else if (key in publicPropertiesMap) {
          return publicPropertiesMap[key](instance);
        }
      }
    }));
  }
}
function getComponentName(Component) {
  return isFunction$4(Component) ? Component.displayName || Component.name : Component.name;
}
function isClassComponent(value) {
  return isFunction$4(value) && "__vccOpts" in value;
}
const computed = (getterOrOptions, debugOptions) => {
  return computed$1(getterOrOptions, debugOptions, isInSSRComponentSetup);
};
function useSlots() {
  return getContext().slots;
}
function useAttrs() {
  return getContext().attrs;
}
function getContext() {
  const i = getCurrentInstance();
  return i.setupContext || (i.setupContext = createSetupContext(i));
}
function h$1(type2, propsOrChildren, children) {
  const l2 = arguments.length;
  if (l2 === 2) {
    if (isObject$6(propsOrChildren) && !isArray$2(propsOrChildren)) {
      if (isVNode(propsOrChildren)) {
        return createVNode(type2, null, [propsOrChildren]);
      }
      return createVNode(type2, propsOrChildren);
    } else {
      return createVNode(type2, null, propsOrChildren);
    }
  } else {
    if (l2 > 3) {
      children = Array.prototype.slice.call(arguments, 2);
    } else if (l2 === 3 && isVNode(children)) {
      children = [children];
    }
    return createVNode(type2, propsOrChildren, children);
  }
}
const version$9 = "3.2.31";
const svgNS = "http://www.w3.org/2000/svg";
const doc = typeof document !== "undefined" ? document : null;
const templateContainer = doc && doc.createElement("template");
const nodeOps = {
  insert: (child, parent, anchor) => {
    parent.insertBefore(child, anchor || null);
  },
  remove: (child) => {
    const parent = child.parentNode;
    if (parent) {
      parent.removeChild(child);
    }
  },
  createElement: (tag, isSVG, is, props) => {
    const el2 = isSVG ? doc.createElementNS(svgNS, tag) : doc.createElement(tag, is ? { is } : void 0);
    if (tag === "select" && props && props.multiple != null) {
      el2.setAttribute("multiple", props.multiple);
    }
    return el2;
  },
  createText: (text3) => doc.createTextNode(text3),
  createComment: (text3) => doc.createComment(text3),
  setText: (node, text3) => {
    node.nodeValue = text3;
  },
  setElementText: (el2, text3) => {
    el2.textContent = text3;
  },
  parentNode: (node) => node.parentNode,
  nextSibling: (node) => node.nextSibling,
  querySelector: (selector) => doc.querySelector(selector),
  setScopeId(el2, id2) {
    el2.setAttribute(id2, "");
  },
  cloneNode(el2) {
    const cloned = el2.cloneNode(true);
    if (`_value` in el2) {
      cloned._value = el2._value;
    }
    return cloned;
  },
  insertStaticContent(content, parent, anchor, isSVG, start2, end2) {
    const before = anchor ? anchor.previousSibling : parent.lastChild;
    if (start2 && (start2 === end2 || start2.nextSibling)) {
      while (true) {
        parent.insertBefore(start2.cloneNode(true), anchor);
        if (start2 === end2 || !(start2 = start2.nextSibling))
          break;
      }
    } else {
      templateContainer.innerHTML = isSVG ? `<svg>${content}</svg>` : content;
      const template = templateContainer.content;
      if (isSVG) {
        const wrapper = template.firstChild;
        while (wrapper.firstChild) {
          template.appendChild(wrapper.firstChild);
        }
        template.removeChild(wrapper);
      }
      parent.insertBefore(template, anchor);
    }
    return [
      before ? before.nextSibling : parent.firstChild,
      anchor ? anchor.previousSibling : parent.lastChild
    ];
  }
};
function patchClass(el2, value, isSVG) {
  const transitionClasses = el2._vtc;
  if (transitionClasses) {
    value = (value ? [value, ...transitionClasses] : [...transitionClasses]).join(" ");
  }
  if (value == null) {
    el2.removeAttribute("class");
  } else if (isSVG) {
    el2.setAttribute("class", value);
  } else {
    el2.className = value;
  }
}
function patchStyle(el2, prev2, next) {
  const style = el2.style;
  const isCssString = isString$5(next);
  if (next && !isCssString) {
    for (const key in next) {
      setStyle(style, key, next[key]);
    }
    if (prev2 && !isString$5(prev2)) {
      for (const key in prev2) {
        if (next[key] == null) {
          setStyle(style, key, "");
        }
      }
    }
  } else {
    const currentDisplay = style.display;
    if (isCssString) {
      if (prev2 !== next) {
        style.cssText = next;
      }
    } else if (prev2) {
      el2.removeAttribute("style");
    }
    if ("_vod" in el2) {
      style.display = currentDisplay;
    }
  }
}
const importantRE = /\s*!important$/;
function setStyle(style, name2, val) {
  if (isArray$2(val)) {
    val.forEach((v) => setStyle(style, name2, v));
  } else {
    if (name2.startsWith("--")) {
      style.setProperty(name2, val);
    } else {
      const prefixed = autoPrefix(style, name2);
      if (importantRE.test(val)) {
        style.setProperty(hyphenate(prefixed), val.replace(importantRE, ""), "important");
      } else {
        style[prefixed] = val;
      }
    }
  }
}
const prefixes = ["Webkit", "Moz", "ms"];
const prefixCache = {};
function autoPrefix(style, rawName) {
  const cached = prefixCache[rawName];
  if (cached) {
    return cached;
  }
  let name2 = camelize(rawName);
  if (name2 !== "filter" && name2 in style) {
    return prefixCache[rawName] = name2;
  }
  name2 = capitalize(name2);
  for (let i = 0; i < prefixes.length; i++) {
    const prefixed = prefixes[i] + name2;
    if (prefixed in style) {
      return prefixCache[rawName] = prefixed;
    }
  }
  return rawName;
}
const xlinkNS = "http://www.w3.org/1999/xlink";
function patchAttr(el2, key, value, isSVG, instance) {
  if (isSVG && key.startsWith("xlink:")) {
    if (value == null) {
      el2.removeAttributeNS(xlinkNS, key.slice(6, key.length));
    } else {
      el2.setAttributeNS(xlinkNS, key, value);
    }
  } else {
    const isBoolean2 = isSpecialBooleanAttr(key);
    if (value == null || isBoolean2 && !includeBooleanAttr(value)) {
      el2.removeAttribute(key);
    } else {
      el2.setAttribute(key, isBoolean2 ? "" : value);
    }
  }
}
function patchDOMProp(el2, key, value, prevChildren, parentComponent, parentSuspense, unmountChildren) {
  if (key === "innerHTML" || key === "textContent") {
    if (prevChildren) {
      unmountChildren(prevChildren, parentComponent, parentSuspense);
    }
    el2[key] = value == null ? "" : value;
    return;
  }
  if (key === "value" && el2.tagName !== "PROGRESS" && !el2.tagName.includes("-")) {
    el2._value = value;
    const newValue = value == null ? "" : value;
    if (el2.value !== newValue || el2.tagName === "OPTION") {
      el2.value = newValue;
    }
    if (value == null) {
      el2.removeAttribute(key);
    }
    return;
  }
  if (value === "" || value == null) {
    const type2 = typeof el2[key];
    if (type2 === "boolean") {
      el2[key] = includeBooleanAttr(value);
      return;
    } else if (value == null && type2 === "string") {
      el2[key] = "";
      el2.removeAttribute(key);
      return;
    } else if (type2 === "number") {
      try {
        el2[key] = 0;
      } catch (_a2) {
      }
      el2.removeAttribute(key);
      return;
    }
  }
  try {
    el2[key] = value;
  } catch (e) {
  }
}
let _getNow = Date.now;
let skipTimestampCheck = false;
if (typeof window !== "undefined") {
  if (_getNow() > document.createEvent("Event").timeStamp) {
    _getNow = () => performance.now();
  }
  const ffMatch = navigator.userAgent.match(/firefox\/(\d+)/i);
  skipTimestampCheck = !!(ffMatch && Number(ffMatch[1]) <= 53);
}
let cachedNow = 0;
const p$2 = Promise.resolve();
const reset = () => {
  cachedNow = 0;
};
const getNow = () => cachedNow || (p$2.then(reset), cachedNow = _getNow());
function addEventListener$1(el2, event, handler, options2) {
  el2.addEventListener(event, handler, options2);
}
function removeEventListener$1(el2, event, handler, options2) {
  el2.removeEventListener(event, handler, options2);
}
function patchEvent(el2, rawName, prevValue, nextValue, instance = null) {
  const invokers = el2._vei || (el2._vei = {});
  const existingInvoker = invokers[rawName];
  if (nextValue && existingInvoker) {
    existingInvoker.value = nextValue;
  } else {
    const [name2, options2] = parseName(rawName);
    if (nextValue) {
      const invoker = invokers[rawName] = createInvoker(nextValue, instance);
      addEventListener$1(el2, name2, invoker, options2);
    } else if (existingInvoker) {
      removeEventListener$1(el2, name2, existingInvoker, options2);
      invokers[rawName] = void 0;
    }
  }
}
const optionsModifierRE = /(?:Once|Passive|Capture)$/;
function parseName(name2) {
  let options2;
  if (optionsModifierRE.test(name2)) {
    options2 = {};
    let m2;
    while (m2 = name2.match(optionsModifierRE)) {
      name2 = name2.slice(0, name2.length - m2[0].length);
      options2[m2[0].toLowerCase()] = true;
    }
  }
  return [hyphenate(name2.slice(2)), options2];
}
function createInvoker(initialValue, instance) {
  const invoker = (e) => {
    const timeStamp = e.timeStamp || _getNow();
    if (skipTimestampCheck || timeStamp >= invoker.attached - 1) {
      callWithAsyncErrorHandling(patchStopImmediatePropagation(e, invoker.value), instance, 5, [e]);
    }
  };
  invoker.value = initialValue;
  invoker.attached = getNow();
  return invoker;
}
function patchStopImmediatePropagation(e, value) {
  if (isArray$2(value)) {
    const originalStop = e.stopImmediatePropagation;
    e.stopImmediatePropagation = () => {
      originalStop.call(e);
      e._stopped = true;
    };
    return value.map((fn2) => (e2) => !e2._stopped && fn2 && fn2(e2));
  } else {
    return value;
  }
}
const nativeOnRE = /^on[a-z]/;
const patchProp = (el2, key, prevValue, nextValue, isSVG = false, prevChildren, parentComponent, parentSuspense, unmountChildren) => {
  if (key === "class") {
    patchClass(el2, nextValue, isSVG);
  } else if (key === "style") {
    patchStyle(el2, prevValue, nextValue);
  } else if (isOn(key)) {
    if (!isModelListener(key)) {
      patchEvent(el2, key, prevValue, nextValue, parentComponent);
    }
  } else if (key[0] === "." ? (key = key.slice(1), true) : key[0] === "^" ? (key = key.slice(1), false) : shouldSetAsProp(el2, key, nextValue, isSVG)) {
    patchDOMProp(el2, key, nextValue, prevChildren, parentComponent, parentSuspense, unmountChildren);
  } else {
    if (key === "true-value") {
      el2._trueValue = nextValue;
    } else if (key === "false-value") {
      el2._falseValue = nextValue;
    }
    patchAttr(el2, key, nextValue, isSVG);
  }
};
function shouldSetAsProp(el2, key, value, isSVG) {
  if (isSVG) {
    if (key === "innerHTML" || key === "textContent") {
      return true;
    }
    if (key in el2 && nativeOnRE.test(key) && isFunction$4(value)) {
      return true;
    }
    return false;
  }
  if (key === "spellcheck" || key === "draggable") {
    return false;
  }
  if (key === "form") {
    return false;
  }
  if (key === "list" && el2.tagName === "INPUT") {
    return false;
  }
  if (key === "type" && el2.tagName === "TEXTAREA") {
    return false;
  }
  if (nativeOnRE.test(key) && isString$5(value)) {
    return false;
  }
  return key in el2;
}
function useCssVars(getter) {
  const instance = getCurrentInstance();
  if (!instance) {
    return;
  }
  const setVars = () => setVarsOnVNode(instance.subTree, getter(instance.proxy));
  watchPostEffect(setVars);
  onMounted(() => {
    const ob = new MutationObserver(setVars);
    ob.observe(instance.subTree.el.parentNode, { childList: true });
    onUnmounted(() => ob.disconnect());
  });
}
function setVarsOnVNode(vnode, vars) {
  if (vnode.shapeFlag & 128) {
    const suspense = vnode.suspense;
    vnode = suspense.activeBranch;
    if (suspense.pendingBranch && !suspense.isHydrating) {
      suspense.effects.push(() => {
        setVarsOnVNode(suspense.activeBranch, vars);
      });
    }
  }
  while (vnode.component) {
    vnode = vnode.component.subTree;
  }
  if (vnode.shapeFlag & 1 && vnode.el) {
    setVarsOnNode(vnode.el, vars);
  } else if (vnode.type === Fragment) {
    vnode.children.forEach((c2) => setVarsOnVNode(c2, vars));
  } else if (vnode.type === Static) {
    let { el: el2, anchor } = vnode;
    while (el2) {
      setVarsOnNode(el2, vars);
      if (el2 === anchor)
        break;
      el2 = el2.nextSibling;
    }
  }
}
function setVarsOnNode(el2, vars) {
  if (el2.nodeType === 1) {
    const style = el2.style;
    for (const key in vars) {
      style.setProperty(`--${key}`, vars[key]);
    }
  }
}
const TRANSITION$1 = "transition";
const ANIMATION = "animation";
const Transition = (props, { slots }) => h$1(BaseTransition, resolveTransitionProps(props), slots);
Transition.displayName = "Transition";
const DOMTransitionPropsValidators = {
  name: String,
  type: String,
  css: {
    type: Boolean,
    default: true
  },
  duration: [String, Number, Object],
  enterFromClass: String,
  enterActiveClass: String,
  enterToClass: String,
  appearFromClass: String,
  appearActiveClass: String,
  appearToClass: String,
  leaveFromClass: String,
  leaveActiveClass: String,
  leaveToClass: String
};
const TransitionPropsValidators = Transition.props = /* @__PURE__ */ extend({}, BaseTransition.props, DOMTransitionPropsValidators);
const callHook = (hook, args = []) => {
  if (isArray$2(hook)) {
    hook.forEach((h2) => h2(...args));
  } else if (hook) {
    hook(...args);
  }
};
const hasExplicitCallback = (hook) => {
  return hook ? isArray$2(hook) ? hook.some((h2) => h2.length > 1) : hook.length > 1 : false;
};
function resolveTransitionProps(rawProps) {
  const baseProps = {};
  for (const key in rawProps) {
    if (!(key in DOMTransitionPropsValidators)) {
      baseProps[key] = rawProps[key];
    }
  }
  if (rawProps.css === false) {
    return baseProps;
  }
  const { name: name2 = "v", type: type2, duration, enterFromClass = `${name2}-enter-from`, enterActiveClass = `${name2}-enter-active`, enterToClass = `${name2}-enter-to`, appearFromClass = enterFromClass, appearActiveClass = enterActiveClass, appearToClass = enterToClass, leaveFromClass = `${name2}-leave-from`, leaveActiveClass = `${name2}-leave-active`, leaveToClass = `${name2}-leave-to` } = rawProps;
  const durations = normalizeDuration(duration);
  const enterDuration = durations && durations[0];
  const leaveDuration = durations && durations[1];
  const { onBeforeEnter, onEnter, onEnterCancelled, onLeave, onLeaveCancelled, onBeforeAppear = onBeforeEnter, onAppear = onEnter, onAppearCancelled = onEnterCancelled } = baseProps;
  const finishEnter = (el2, isAppear, done) => {
    removeTransitionClass(el2, isAppear ? appearToClass : enterToClass);
    removeTransitionClass(el2, isAppear ? appearActiveClass : enterActiveClass);
    done && done();
  };
  const finishLeave = (el2, done) => {
    removeTransitionClass(el2, leaveToClass);
    removeTransitionClass(el2, leaveActiveClass);
    done && done();
  };
  const makeEnterHook = (isAppear) => {
    return (el2, done) => {
      const hook = isAppear ? onAppear : onEnter;
      const resolve3 = () => finishEnter(el2, isAppear, done);
      callHook(hook, [el2, resolve3]);
      nextFrame$2(() => {
        removeTransitionClass(el2, isAppear ? appearFromClass : enterFromClass);
        addTransitionClass(el2, isAppear ? appearToClass : enterToClass);
        if (!hasExplicitCallback(hook)) {
          whenTransitionEnds(el2, type2, enterDuration, resolve3);
        }
      });
    };
  };
  return extend(baseProps, {
    onBeforeEnter(el2) {
      callHook(onBeforeEnter, [el2]);
      addTransitionClass(el2, enterFromClass);
      addTransitionClass(el2, enterActiveClass);
    },
    onBeforeAppear(el2) {
      callHook(onBeforeAppear, [el2]);
      addTransitionClass(el2, appearFromClass);
      addTransitionClass(el2, appearActiveClass);
    },
    onEnter: makeEnterHook(false),
    onAppear: makeEnterHook(true),
    onLeave(el2, done) {
      const resolve3 = () => finishLeave(el2, done);
      addTransitionClass(el2, leaveFromClass);
      forceReflow();
      addTransitionClass(el2, leaveActiveClass);
      nextFrame$2(() => {
        removeTransitionClass(el2, leaveFromClass);
        addTransitionClass(el2, leaveToClass);
        if (!hasExplicitCallback(onLeave)) {
          whenTransitionEnds(el2, type2, leaveDuration, resolve3);
        }
      });
      callHook(onLeave, [el2, resolve3]);
    },
    onEnterCancelled(el2) {
      finishEnter(el2, false);
      callHook(onEnterCancelled, [el2]);
    },
    onAppearCancelled(el2) {
      finishEnter(el2, true);
      callHook(onAppearCancelled, [el2]);
    },
    onLeaveCancelled(el2) {
      finishLeave(el2);
      callHook(onLeaveCancelled, [el2]);
    }
  });
}
function normalizeDuration(duration) {
  if (duration == null) {
    return null;
  } else if (isObject$6(duration)) {
    return [NumberOf(duration.enter), NumberOf(duration.leave)];
  } else {
    const n = NumberOf(duration);
    return [n, n];
  }
}
function NumberOf(val) {
  const res = toNumber(val);
  return res;
}
function addTransitionClass(el2, cls) {
  cls.split(/\s+/).forEach((c2) => c2 && el2.classList.add(c2));
  (el2._vtc || (el2._vtc = /* @__PURE__ */ new Set())).add(cls);
}
function removeTransitionClass(el2, cls) {
  cls.split(/\s+/).forEach((c2) => c2 && el2.classList.remove(c2));
  const { _vtc } = el2;
  if (_vtc) {
    _vtc.delete(cls);
    if (!_vtc.size) {
      el2._vtc = void 0;
    }
  }
}
function nextFrame$2(cb) {
  requestAnimationFrame(() => {
    requestAnimationFrame(cb);
  });
}
let endId = 0;
function whenTransitionEnds(el2, expectedType, explicitTimeout, resolve3) {
  const id2 = el2._endId = ++endId;
  const resolveIfNotStale = () => {
    if (id2 === el2._endId) {
      resolve3();
    }
  };
  if (explicitTimeout) {
    return setTimeout(resolveIfNotStale, explicitTimeout);
  }
  const { type: type2, timeout, propCount } = getTransitionInfo(el2, expectedType);
  if (!type2) {
    return resolve3();
  }
  const endEvent = type2 + "end";
  let ended = 0;
  const end2 = () => {
    el2.removeEventListener(endEvent, onEnd);
    resolveIfNotStale();
  };
  const onEnd = (e) => {
    if (e.target === el2 && ++ended >= propCount) {
      end2();
    }
  };
  setTimeout(() => {
    if (ended < propCount) {
      end2();
    }
  }, timeout + 1);
  el2.addEventListener(endEvent, onEnd);
}
function getTransitionInfo(el2, expectedType) {
  const styles = window.getComputedStyle(el2);
  const getStyleProperties = (key) => (styles[key] || "").split(", ");
  const transitionDelays = getStyleProperties(TRANSITION$1 + "Delay");
  const transitionDurations = getStyleProperties(TRANSITION$1 + "Duration");
  const transitionTimeout = getTimeout(transitionDelays, transitionDurations);
  const animationDelays = getStyleProperties(ANIMATION + "Delay");
  const animationDurations = getStyleProperties(ANIMATION + "Duration");
  const animationTimeout = getTimeout(animationDelays, animationDurations);
  let type2 = null;
  let timeout = 0;
  let propCount = 0;
  if (expectedType === TRANSITION$1) {
    if (transitionTimeout > 0) {
      type2 = TRANSITION$1;
      timeout = transitionTimeout;
      propCount = transitionDurations.length;
    }
  } else if (expectedType === ANIMATION) {
    if (animationTimeout > 0) {
      type2 = ANIMATION;
      timeout = animationTimeout;
      propCount = animationDurations.length;
    }
  } else {
    timeout = Math.max(transitionTimeout, animationTimeout);
    type2 = timeout > 0 ? transitionTimeout > animationTimeout ? TRANSITION$1 : ANIMATION : null;
    propCount = type2 ? type2 === TRANSITION$1 ? transitionDurations.length : animationDurations.length : 0;
  }
  const hasTransform = type2 === TRANSITION$1 && /\b(transform|all)(,|$)/.test(styles[TRANSITION$1 + "Property"]);
  return {
    type: type2,
    timeout,
    propCount,
    hasTransform
  };
}
function getTimeout(delays, durations) {
  while (delays.length < durations.length) {
    delays = delays.concat(delays);
  }
  return Math.max(...durations.map((d2, i) => toMs(d2) + toMs(delays[i])));
}
function toMs(s2) {
  return Number(s2.slice(0, -1).replace(",", ".")) * 1e3;
}
function forceReflow() {
  return document.body.offsetHeight;
}
const positionMap = /* @__PURE__ */ new WeakMap();
const newPositionMap = /* @__PURE__ */ new WeakMap();
const TransitionGroupImpl = {
  name: "TransitionGroup",
  props: /* @__PURE__ */ extend({}, TransitionPropsValidators, {
    tag: String,
    moveClass: String
  }),
  setup(props, { slots }) {
    const instance = getCurrentInstance();
    const state = useTransitionState();
    let prevChildren;
    let children;
    onUpdated(() => {
      if (!prevChildren.length) {
        return;
      }
      const moveClass = props.moveClass || `${props.name || "v"}-move`;
      if (!hasCSSTransform(prevChildren[0].el, instance.vnode.el, moveClass)) {
        return;
      }
      prevChildren.forEach(callPendingCbs);
      prevChildren.forEach(recordPosition);
      const movedChildren = prevChildren.filter(applyTranslation);
      forceReflow();
      movedChildren.forEach((c2) => {
        const el2 = c2.el;
        const style = el2.style;
        addTransitionClass(el2, moveClass);
        style.transform = style.webkitTransform = style.transitionDuration = "";
        const cb = el2._moveCb = (e) => {
          if (e && e.target !== el2) {
            return;
          }
          if (!e || /transform$/.test(e.propertyName)) {
            el2.removeEventListener("transitionend", cb);
            el2._moveCb = null;
            removeTransitionClass(el2, moveClass);
          }
        };
        el2.addEventListener("transitionend", cb);
      });
    });
    return () => {
      const rawProps = toRaw(props);
      const cssTransitionProps = resolveTransitionProps(rawProps);
      let tag = rawProps.tag || Fragment;
      prevChildren = children;
      children = slots.default ? getTransitionRawChildren(slots.default()) : [];
      for (let i = 0; i < children.length; i++) {
        const child = children[i];
        if (child.key != null) {
          setTransitionHooks(child, resolveTransitionHooks(child, cssTransitionProps, state, instance));
        }
      }
      if (prevChildren) {
        for (let i = 0; i < prevChildren.length; i++) {
          const child = prevChildren[i];
          setTransitionHooks(child, resolveTransitionHooks(child, cssTransitionProps, state, instance));
          positionMap.set(child, child.el.getBoundingClientRect());
        }
      }
      return createVNode(tag, null, children);
    };
  }
};
const TransitionGroup = TransitionGroupImpl;
function callPendingCbs(c2) {
  const el2 = c2.el;
  if (el2._moveCb) {
    el2._moveCb();
  }
  if (el2._enterCb) {
    el2._enterCb();
  }
}
function recordPosition(c2) {
  newPositionMap.set(c2, c2.el.getBoundingClientRect());
}
function applyTranslation(c2) {
  const oldPos = positionMap.get(c2);
  const newPos = newPositionMap.get(c2);
  const dx = oldPos.left - newPos.left;
  const dy = oldPos.top - newPos.top;
  if (dx || dy) {
    const s2 = c2.el.style;
    s2.transform = s2.webkitTransform = `translate(${dx}px,${dy}px)`;
    s2.transitionDuration = "0s";
    return c2;
  }
}
function hasCSSTransform(el2, root, moveClass) {
  const clone2 = el2.cloneNode();
  if (el2._vtc) {
    el2._vtc.forEach((cls) => {
      cls.split(/\s+/).forEach((c2) => c2 && clone2.classList.remove(c2));
    });
  }
  moveClass.split(/\s+/).forEach((c2) => c2 && clone2.classList.add(c2));
  clone2.style.display = "none";
  const container = root.nodeType === 1 ? root : root.parentNode;
  container.appendChild(clone2);
  const { hasTransform } = getTransitionInfo(clone2);
  container.removeChild(clone2);
  return hasTransform;
}
const getModelAssigner = (vnode) => {
  const fn2 = vnode.props["onUpdate:modelValue"];
  return isArray$2(fn2) ? (value) => invokeArrayFns(fn2, value) : fn2;
};
function onCompositionStart(e) {
  e.target.composing = true;
}
function onCompositionEnd(e) {
  const target2 = e.target;
  if (target2.composing) {
    target2.composing = false;
    trigger(target2, "input");
  }
}
function trigger(el2, type2) {
  const e = document.createEvent("HTMLEvents");
  e.initEvent(type2, true, true);
  el2.dispatchEvent(e);
}
const vModelText = {
  created(el2, { modifiers: { lazy, trim: trim2, number: number2 } }, vnode) {
    el2._assign = getModelAssigner(vnode);
    const castToNumber = number2 || vnode.props && vnode.props.type === "number";
    addEventListener$1(el2, lazy ? "change" : "input", (e) => {
      if (e.target.composing)
        return;
      let domValue = el2.value;
      if (trim2) {
        domValue = domValue.trim();
      } else if (castToNumber) {
        domValue = toNumber(domValue);
      }
      el2._assign(domValue);
    });
    if (trim2) {
      addEventListener$1(el2, "change", () => {
        el2.value = el2.value.trim();
      });
    }
    if (!lazy) {
      addEventListener$1(el2, "compositionstart", onCompositionStart);
      addEventListener$1(el2, "compositionend", onCompositionEnd);
      addEventListener$1(el2, "change", onCompositionEnd);
    }
  },
  mounted(el2, { value }) {
    el2.value = value == null ? "" : value;
  },
  beforeUpdate(el2, { value, modifiers: { lazy, trim: trim2, number: number2 } }, vnode) {
    el2._assign = getModelAssigner(vnode);
    if (el2.composing)
      return;
    if (document.activeElement === el2) {
      if (lazy) {
        return;
      }
      if (trim2 && el2.value.trim() === value) {
        return;
      }
      if ((number2 || el2.type === "number") && toNumber(el2.value) === value) {
        return;
      }
    }
    const newValue = value == null ? "" : value;
    if (el2.value !== newValue) {
      el2.value = newValue;
    }
  }
};
const vModelCheckbox = {
  deep: true,
  created(el2, _2, vnode) {
    el2._assign = getModelAssigner(vnode);
    addEventListener$1(el2, "change", () => {
      const modelValue = el2._modelValue;
      const elementValue = getValue(el2);
      const checked = el2.checked;
      const assign2 = el2._assign;
      if (isArray$2(modelValue)) {
        const index2 = looseIndexOf(modelValue, elementValue);
        const found = index2 !== -1;
        if (checked && !found) {
          assign2(modelValue.concat(elementValue));
        } else if (!checked && found) {
          const filtered = [...modelValue];
          filtered.splice(index2, 1);
          assign2(filtered);
        }
      } else if (isSet(modelValue)) {
        const cloned = new Set(modelValue);
        if (checked) {
          cloned.add(elementValue);
        } else {
          cloned.delete(elementValue);
        }
        assign2(cloned);
      } else {
        assign2(getCheckboxValue(el2, checked));
      }
    });
  },
  mounted: setChecked,
  beforeUpdate(el2, binding, vnode) {
    el2._assign = getModelAssigner(vnode);
    setChecked(el2, binding, vnode);
  }
};
function setChecked(el2, { value, oldValue }, vnode) {
  el2._modelValue = value;
  if (isArray$2(value)) {
    el2.checked = looseIndexOf(value, vnode.props.value) > -1;
  } else if (isSet(value)) {
    el2.checked = value.has(vnode.props.value);
  } else if (value !== oldValue) {
    el2.checked = looseEqual(value, getCheckboxValue(el2, true));
  }
}
const vModelRadio = {
  created(el2, { value }, vnode) {
    el2.checked = looseEqual(value, vnode.props.value);
    el2._assign = getModelAssigner(vnode);
    addEventListener$1(el2, "change", () => {
      el2._assign(getValue(el2));
    });
  },
  beforeUpdate(el2, { value, oldValue }, vnode) {
    el2._assign = getModelAssigner(vnode);
    if (value !== oldValue) {
      el2.checked = looseEqual(value, vnode.props.value);
    }
  }
};
const vModelSelect = {
  deep: true,
  created(el2, { value, modifiers: { number: number2 } }, vnode) {
    const isSetModel = isSet(value);
    addEventListener$1(el2, "change", () => {
      const selectedVal = Array.prototype.filter.call(el2.options, (o2) => o2.selected).map((o2) => number2 ? toNumber(getValue(o2)) : getValue(o2));
      el2._assign(el2.multiple ? isSetModel ? new Set(selectedVal) : selectedVal : selectedVal[0]);
    });
    el2._assign = getModelAssigner(vnode);
  },
  mounted(el2, { value }) {
    setSelected(el2, value);
  },
  beforeUpdate(el2, _binding, vnode) {
    el2._assign = getModelAssigner(vnode);
  },
  updated(el2, { value }) {
    setSelected(el2, value);
  }
};
function setSelected(el2, value) {
  const isMultiple = el2.multiple;
  if (isMultiple && !isArray$2(value) && !isSet(value)) {
    return;
  }
  for (let i = 0, l2 = el2.options.length; i < l2; i++) {
    const option = el2.options[i];
    const optionValue = getValue(option);
    if (isMultiple) {
      if (isArray$2(value)) {
        option.selected = looseIndexOf(value, optionValue) > -1;
      } else {
        option.selected = value.has(optionValue);
      }
    } else {
      if (looseEqual(getValue(option), value)) {
        if (el2.selectedIndex !== i)
          el2.selectedIndex = i;
        return;
      }
    }
  }
  if (!isMultiple && el2.selectedIndex !== -1) {
    el2.selectedIndex = -1;
  }
}
function getValue(el2) {
  return "_value" in el2 ? el2._value : el2.value;
}
function getCheckboxValue(el2, checked) {
  const key = checked ? "_trueValue" : "_falseValue";
  return key in el2 ? el2[key] : checked;
}
const vModelDynamic = {
  created(el2, binding, vnode) {
    callModelHook(el2, binding, vnode, null, "created");
  },
  mounted(el2, binding, vnode) {
    callModelHook(el2, binding, vnode, null, "mounted");
  },
  beforeUpdate(el2, binding, vnode, prevVNode) {
    callModelHook(el2, binding, vnode, prevVNode, "beforeUpdate");
  },
  updated(el2, binding, vnode, prevVNode) {
    callModelHook(el2, binding, vnode, prevVNode, "updated");
  }
};
function callModelHook(el2, binding, vnode, prevVNode, hook) {
  let modelToUse;
  switch (el2.tagName) {
    case "SELECT":
      modelToUse = vModelSelect;
      break;
    case "TEXTAREA":
      modelToUse = vModelText;
      break;
    default:
      switch (vnode.props && vnode.props.type) {
        case "checkbox":
          modelToUse = vModelCheckbox;
          break;
        case "radio":
          modelToUse = vModelRadio;
          break;
        default:
          modelToUse = vModelText;
      }
  }
  const fn2 = modelToUse[hook];
  fn2 && fn2(el2, binding, vnode, prevVNode);
}
const systemModifiers = ["ctrl", "shift", "alt", "meta"];
const modifierGuards = {
  stop: (e) => e.stopPropagation(),
  prevent: (e) => e.preventDefault(),
  self: (e) => e.target !== e.currentTarget,
  ctrl: (e) => !e.ctrlKey,
  shift: (e) => !e.shiftKey,
  alt: (e) => !e.altKey,
  meta: (e) => !e.metaKey,
  left: (e) => "button" in e && e.button !== 0,
  middle: (e) => "button" in e && e.button !== 1,
  right: (e) => "button" in e && e.button !== 2,
  exact: (e, modifiers) => systemModifiers.some((m2) => e[`${m2}Key`] && !modifiers.includes(m2))
};
const withModifiers = (fn2, modifiers) => {
  return (event, ...args) => {
    for (let i = 0; i < modifiers.length; i++) {
      const guard = modifierGuards[modifiers[i]];
      if (guard && guard(event, modifiers))
        return;
    }
    return fn2(event, ...args);
  };
};
const keyNames = {
  esc: "escape",
  space: " ",
  up: "arrow-up",
  left: "arrow-left",
  right: "arrow-right",
  down: "arrow-down",
  delete: "backspace"
};
const withKeys = (fn2, modifiers) => {
  return (event) => {
    if (!("key" in event)) {
      return;
    }
    const eventKey = hyphenate(event.key);
    if (modifiers.some((k) => k === eventKey || keyNames[k] === eventKey)) {
      return fn2(event);
    }
  };
};
const vShow = {
  beforeMount(el2, { value }, { transition }) {
    el2._vod = el2.style.display === "none" ? "" : el2.style.display;
    if (transition && value) {
      transition.beforeEnter(el2);
    } else {
      setDisplay(el2, value);
    }
  },
  mounted(el2, { value }, { transition }) {
    if (transition && value) {
      transition.enter(el2);
    }
  },
  updated(el2, { value, oldValue }, { transition }) {
    if (!value === !oldValue)
      return;
    if (transition) {
      if (value) {
        transition.beforeEnter(el2);
        setDisplay(el2, true);
        transition.enter(el2);
      } else {
        transition.leave(el2, () => {
          setDisplay(el2, false);
        });
      }
    } else {
      setDisplay(el2, value);
    }
  },
  beforeUnmount(el2, { value }) {
    setDisplay(el2, value);
  }
};
function setDisplay(el2, value) {
  el2.style.display = value ? el2._vod : "none";
}
const rendererOptions = extend({ patchProp }, nodeOps);
let renderer$1;
function ensureRenderer() {
  return renderer$1 || (renderer$1 = createRenderer(rendererOptions));
}
const createApp = (...args) => {
  const app2 = ensureRenderer().createApp(...args);
  const { mount } = app2;
  app2.mount = (containerOrSelector) => {
    const container = normalizeContainer(containerOrSelector);
    if (!container)
      return;
    const component = app2._component;
    if (!isFunction$4(component) && !component.render && !component.template) {
      component.template = container.innerHTML;
    }
    container.innerHTML = "";
    const proxy = mount(container, false, container instanceof SVGElement);
    if (container instanceof Element) {
      container.removeAttribute("v-cloak");
      container.setAttribute("data-v-app", "");
    }
    return proxy;
  };
  return app2;
};
function normalizeContainer(container) {
  if (isString$5(container)) {
    const res = document.querySelector(container);
    return res;
  }
  return container;
}
const main$2 = "";
const windi = "";
var nodejsCustomInspectSymbol = typeof Symbol === "function" && typeof Symbol.for === "function" ? Symbol.for("nodejs.util.inspect.custom") : void 0;
const nodejsCustomInspectSymbol$1 = nodejsCustomInspectSymbol;
function _typeof$2(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof$2 = function _typeof2(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof$2 = function _typeof2(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof$2(obj);
}
var MAX_ARRAY_LENGTH = 10;
var MAX_RECURSIVE_DEPTH = 2;
function inspect(value) {
  return formatValue(value, []);
}
function formatValue(value, seenValues) {
  switch (_typeof$2(value)) {
    case "string":
      return JSON.stringify(value);
    case "function":
      return value.name ? "[function ".concat(value.name, "]") : "[function]";
    case "object":
      if (value === null) {
        return "null";
      }
      return formatObjectValue(value, seenValues);
    default:
      return String(value);
  }
}
function formatObjectValue(value, previouslySeenValues) {
  if (previouslySeenValues.indexOf(value) !== -1) {
    return "[Circular]";
  }
  var seenValues = [].concat(previouslySeenValues, [value]);
  var customInspectFn = getCustomFn(value);
  if (customInspectFn !== void 0) {
    var customValue = customInspectFn.call(value);
    if (customValue !== value) {
      return typeof customValue === "string" ? customValue : formatValue(customValue, seenValues);
    }
  } else if (Array.isArray(value)) {
    return formatArray(value, seenValues);
  }
  return formatObject(value, seenValues);
}
function formatObject(object, seenValues) {
  var keys = Object.keys(object);
  if (keys.length === 0) {
    return "{}";
  }
  if (seenValues.length > MAX_RECURSIVE_DEPTH) {
    return "[" + getObjectTag(object) + "]";
  }
  var properties = keys.map(function(key) {
    var value = formatValue(object[key], seenValues);
    return key + ": " + value;
  });
  return "{ " + properties.join(", ") + " }";
}
function formatArray(array, seenValues) {
  if (array.length === 0) {
    return "[]";
  }
  if (seenValues.length > MAX_RECURSIVE_DEPTH) {
    return "[Array]";
  }
  var len = Math.min(MAX_ARRAY_LENGTH, array.length);
  var remaining = array.length - len;
  var items = [];
  for (var i = 0; i < len; ++i) {
    items.push(formatValue(array[i], seenValues));
  }
  if (remaining === 1) {
    items.push("... 1 more item");
  } else if (remaining > 1) {
    items.push("... ".concat(remaining, " more items"));
  }
  return "[" + items.join(", ") + "]";
}
function getCustomFn(object) {
  var customInspectFn = object[String(nodejsCustomInspectSymbol$1)];
  if (typeof customInspectFn === "function") {
    return customInspectFn;
  }
  if (typeof object.inspect === "function") {
    return object.inspect;
  }
}
function getObjectTag(object) {
  var tag = Object.prototype.toString.call(object).replace(/^\[object /, "").replace(/]$/, "");
  if (tag === "Object" && typeof object.constructor === "function") {
    var name2 = object.constructor.name;
    if (typeof name2 === "string" && name2 !== "") {
      return name2;
    }
  }
  return tag;
}
function invariant$2(condition, message) {
  var booleanCondition = Boolean(condition);
  if (!booleanCondition) {
    throw new Error(message != null ? message : "Unexpected invariant triggered.");
  }
}
function defineInspect(classObject) {
  var fn2 = classObject.prototype.toJSON;
  typeof fn2 === "function" || invariant$2(0);
  classObject.prototype.inspect = fn2;
  if (nodejsCustomInspectSymbol$1) {
    classObject.prototype[nodejsCustomInspectSymbol$1] = fn2;
  }
}
var Location = /* @__PURE__ */ function() {
  function Location2(startToken, endToken, source) {
    this.start = startToken.start;
    this.end = endToken.end;
    this.startToken = startToken;
    this.endToken = endToken;
    this.source = source;
  }
  var _proto = Location2.prototype;
  _proto.toJSON = function toJSON() {
    return {
      start: this.start,
      end: this.end
    };
  };
  return Location2;
}();
defineInspect(Location);
var Token$4 = /* @__PURE__ */ function() {
  function Token2(kind, start2, end2, line, column, prev2, value) {
    this.kind = kind;
    this.start = start2;
    this.end = end2;
    this.line = line;
    this.column = column;
    this.value = value;
    this.prev = prev2;
    this.next = null;
  }
  var _proto2 = Token2.prototype;
  _proto2.toJSON = function toJSON() {
    return {
      kind: this.kind,
      value: this.value,
      line: this.line,
      column: this.column
    };
  };
  return Token2;
}();
defineInspect(Token$4);
function isNode$1(maybeNode) {
  return maybeNode != null && typeof maybeNode.kind === "string";
}
var QueryDocumentKeys = {
  Name: [],
  Document: ["definitions"],
  OperationDefinition: ["name", "variableDefinitions", "directives", "selectionSet"],
  VariableDefinition: ["variable", "type", "defaultValue", "directives"],
  Variable: ["name"],
  SelectionSet: ["selections"],
  Field: ["alias", "name", "arguments", "directives", "selectionSet"],
  Argument: ["name", "value"],
  FragmentSpread: ["name", "directives"],
  InlineFragment: ["typeCondition", "directives", "selectionSet"],
  FragmentDefinition: [
    "name",
    "variableDefinitions",
    "typeCondition",
    "directives",
    "selectionSet"
  ],
  IntValue: [],
  FloatValue: [],
  StringValue: [],
  BooleanValue: [],
  NullValue: [],
  EnumValue: [],
  ListValue: ["values"],
  ObjectValue: ["fields"],
  ObjectField: ["name", "value"],
  Directive: ["name", "arguments"],
  NamedType: ["name"],
  ListType: ["type"],
  NonNullType: ["type"],
  SchemaDefinition: ["description", "directives", "operationTypes"],
  OperationTypeDefinition: ["type"],
  ScalarTypeDefinition: ["description", "name", "directives"],
  ObjectTypeDefinition: ["description", "name", "interfaces", "directives", "fields"],
  FieldDefinition: ["description", "name", "arguments", "type", "directives"],
  InputValueDefinition: ["description", "name", "type", "defaultValue", "directives"],
  InterfaceTypeDefinition: ["description", "name", "interfaces", "directives", "fields"],
  UnionTypeDefinition: ["description", "name", "directives", "types"],
  EnumTypeDefinition: ["description", "name", "directives", "values"],
  EnumValueDefinition: ["description", "name", "directives"],
  InputObjectTypeDefinition: ["description", "name", "directives", "fields"],
  DirectiveDefinition: ["description", "name", "arguments", "locations"],
  SchemaExtension: ["directives", "operationTypes"],
  ScalarTypeExtension: ["name", "directives"],
  ObjectTypeExtension: ["name", "interfaces", "directives", "fields"],
  InterfaceTypeExtension: ["name", "interfaces", "directives", "fields"],
  UnionTypeExtension: ["name", "directives", "types"],
  EnumTypeExtension: ["name", "directives", "values"],
  InputObjectTypeExtension: ["name", "directives", "fields"]
};
var BREAK = Object.freeze({});
function visit$1(root, visitor) {
  var visitorKeys = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : QueryDocumentKeys;
  var stack = void 0;
  var inArray = Array.isArray(root);
  var keys = [root];
  var index2 = -1;
  var edits = [];
  var node = void 0;
  var key = void 0;
  var parent = void 0;
  var path = [];
  var ancestors = [];
  var newRoot = root;
  do {
    index2++;
    var isLeaving = index2 === keys.length;
    var isEdited = isLeaving && edits.length !== 0;
    if (isLeaving) {
      key = ancestors.length === 0 ? void 0 : path[path.length - 1];
      node = parent;
      parent = ancestors.pop();
      if (isEdited) {
        if (inArray) {
          node = node.slice();
        } else {
          var clone2 = {};
          for (var _i2 = 0, _Object$keys2 = Object.keys(node); _i2 < _Object$keys2.length; _i2++) {
            var k = _Object$keys2[_i2];
            clone2[k] = node[k];
          }
          node = clone2;
        }
        var editOffset = 0;
        for (var ii2 = 0; ii2 < edits.length; ii2++) {
          var editKey = edits[ii2][0];
          var editValue = edits[ii2][1];
          if (inArray) {
            editKey -= editOffset;
          }
          if (inArray && editValue === null) {
            node.splice(editKey, 1);
            editOffset++;
          } else {
            node[editKey] = editValue;
          }
        }
      }
      index2 = stack.index;
      keys = stack.keys;
      edits = stack.edits;
      inArray = stack.inArray;
      stack = stack.prev;
    } else {
      key = parent ? inArray ? index2 : keys[index2] : void 0;
      node = parent ? parent[key] : newRoot;
      if (node === null || node === void 0) {
        continue;
      }
      if (parent) {
        path.push(key);
      }
    }
    var result = void 0;
    if (!Array.isArray(node)) {
      if (!isNode$1(node)) {
        throw new Error("Invalid AST Node: ".concat(inspect(node), "."));
      }
      var visitFn = getVisitFn(visitor, node.kind, isLeaving);
      if (visitFn) {
        result = visitFn.call(visitor, node, key, parent, path, ancestors);
        if (result === BREAK) {
          break;
        }
        if (result === false) {
          if (!isLeaving) {
            path.pop();
            continue;
          }
        } else if (result !== void 0) {
          edits.push([key, result]);
          if (!isLeaving) {
            if (isNode$1(result)) {
              node = result;
            } else {
              path.pop();
              continue;
            }
          }
        }
      }
    }
    if (result === void 0 && isEdited) {
      edits.push([key, node]);
    }
    if (isLeaving) {
      path.pop();
    } else {
      var _visitorKeys$node$kin;
      stack = {
        inArray,
        index: index2,
        keys,
        edits,
        prev: stack
      };
      inArray = Array.isArray(node);
      keys = inArray ? node : (_visitorKeys$node$kin = visitorKeys[node.kind]) !== null && _visitorKeys$node$kin !== void 0 ? _visitorKeys$node$kin : [];
      index2 = -1;
      edits = [];
      if (parent) {
        ancestors.push(parent);
      }
      parent = node;
    }
  } while (stack !== void 0);
  if (edits.length !== 0) {
    newRoot = edits[edits.length - 1][1];
  }
  return newRoot;
}
function getVisitFn(visitor, kind, isLeaving) {
  var kindVisitor = visitor[kind];
  if (kindVisitor) {
    if (!isLeaving && typeof kindVisitor === "function") {
      return kindVisitor;
    }
    var kindSpecificVisitor = isLeaving ? kindVisitor.leave : kindVisitor.enter;
    if (typeof kindSpecificVisitor === "function") {
      return kindSpecificVisitor;
    }
  } else {
    var specificVisitor = isLeaving ? visitor.leave : visitor.enter;
    if (specificVisitor) {
      if (typeof specificVisitor === "function") {
        return specificVisitor;
      }
      var specificKindVisitor = specificVisitor[kind];
      if (typeof specificKindVisitor === "function") {
        return specificKindVisitor;
      }
    }
  }
}
var Kind = Object.freeze({
  NAME: "Name",
  DOCUMENT: "Document",
  OPERATION_DEFINITION: "OperationDefinition",
  VARIABLE_DEFINITION: "VariableDefinition",
  SELECTION_SET: "SelectionSet",
  FIELD: "Field",
  ARGUMENT: "Argument",
  FRAGMENT_SPREAD: "FragmentSpread",
  INLINE_FRAGMENT: "InlineFragment",
  FRAGMENT_DEFINITION: "FragmentDefinition",
  VARIABLE: "Variable",
  INT: "IntValue",
  FLOAT: "FloatValue",
  STRING: "StringValue",
  BOOLEAN: "BooleanValue",
  NULL: "NullValue",
  ENUM: "EnumValue",
  LIST: "ListValue",
  OBJECT: "ObjectValue",
  OBJECT_FIELD: "ObjectField",
  DIRECTIVE: "Directive",
  NAMED_TYPE: "NamedType",
  LIST_TYPE: "ListType",
  NON_NULL_TYPE: "NonNullType",
  SCHEMA_DEFINITION: "SchemaDefinition",
  OPERATION_TYPE_DEFINITION: "OperationTypeDefinition",
  SCALAR_TYPE_DEFINITION: "ScalarTypeDefinition",
  OBJECT_TYPE_DEFINITION: "ObjectTypeDefinition",
  FIELD_DEFINITION: "FieldDefinition",
  INPUT_VALUE_DEFINITION: "InputValueDefinition",
  INTERFACE_TYPE_DEFINITION: "InterfaceTypeDefinition",
  UNION_TYPE_DEFINITION: "UnionTypeDefinition",
  ENUM_TYPE_DEFINITION: "EnumTypeDefinition",
  ENUM_VALUE_DEFINITION: "EnumValueDefinition",
  INPUT_OBJECT_TYPE_DEFINITION: "InputObjectTypeDefinition",
  DIRECTIVE_DEFINITION: "DirectiveDefinition",
  SCHEMA_EXTENSION: "SchemaExtension",
  SCALAR_TYPE_EXTENSION: "ScalarTypeExtension",
  OBJECT_TYPE_EXTENSION: "ObjectTypeExtension",
  INTERFACE_TYPE_EXTENSION: "InterfaceTypeExtension",
  UNION_TYPE_EXTENSION: "UnionTypeExtension",
  ENUM_TYPE_EXTENSION: "EnumTypeExtension",
  INPUT_OBJECT_TYPE_EXTENSION: "InputObjectTypeExtension"
});
function dedentBlockStringValue(rawString) {
  var lines = rawString.split(/\r\n|[\n\r]/g);
  var commonIndent = getBlockStringIndentation(rawString);
  if (commonIndent !== 0) {
    for (var i = 1; i < lines.length; i++) {
      lines[i] = lines[i].slice(commonIndent);
    }
  }
  var startLine = 0;
  while (startLine < lines.length && isBlank(lines[startLine])) {
    ++startLine;
  }
  var endLine = lines.length;
  while (endLine > startLine && isBlank(lines[endLine - 1])) {
    --endLine;
  }
  return lines.slice(startLine, endLine).join("\n");
}
function isBlank(str) {
  for (var i = 0; i < str.length; ++i) {
    if (str[i] !== " " && str[i] !== "	") {
      return false;
    }
  }
  return true;
}
function getBlockStringIndentation(value) {
  var _commonIndent;
  var isFirstLine = true;
  var isEmptyLine = true;
  var indent2 = 0;
  var commonIndent = null;
  for (var i = 0; i < value.length; ++i) {
    switch (value.charCodeAt(i)) {
      case 13:
        if (value.charCodeAt(i + 1) === 10) {
          ++i;
        }
      case 10:
        isFirstLine = false;
        isEmptyLine = true;
        indent2 = 0;
        break;
      case 9:
      case 32:
        ++indent2;
        break;
      default:
        if (isEmptyLine && !isFirstLine && (commonIndent === null || indent2 < commonIndent)) {
          commonIndent = indent2;
        }
        isEmptyLine = false;
    }
  }
  return (_commonIndent = commonIndent) !== null && _commonIndent !== void 0 ? _commonIndent : 0;
}
function printBlockString(value) {
  var indentation = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "";
  var preferMultipleLines = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
  var isSingleLine = value.indexOf("\n") === -1;
  var hasLeadingSpace = value[0] === " " || value[0] === "	";
  var hasTrailingQuote = value[value.length - 1] === '"';
  var hasTrailingSlash = value[value.length - 1] === "\\";
  var printAsMultipleLines = !isSingleLine || hasTrailingQuote || hasTrailingSlash || preferMultipleLines;
  var result = "";
  if (printAsMultipleLines && !(isSingleLine && hasLeadingSpace)) {
    result += "\n" + indentation;
  }
  result += indentation ? value.replace(/\n/g, "\n" + indentation) : value;
  if (printAsMultipleLines) {
    result += "\n";
  }
  return '"""' + result.replace(/"""/g, '\\"""') + '"""';
}
function print$1(ast2) {
  return visit$1(ast2, {
    leave: printDocASTReducer
  });
}
var MAX_LINE_LENGTH = 80;
var printDocASTReducer = {
  Name: function Name(node) {
    return node.value;
  },
  Variable: function Variable(node) {
    return "$" + node.name;
  },
  Document: function Document(node) {
    return join$1(node.definitions, "\n\n") + "\n";
  },
  OperationDefinition: function OperationDefinition(node) {
    var op = node.operation;
    var name2 = node.name;
    var varDefs = wrap("(", join$1(node.variableDefinitions, ", "), ")");
    var directives = join$1(node.directives, " ");
    var selectionSet = node.selectionSet;
    return !name2 && !directives && !varDefs && op === "query" ? selectionSet : join$1([op, join$1([name2, varDefs]), directives, selectionSet], " ");
  },
  VariableDefinition: function VariableDefinition(_ref) {
    var variable = _ref.variable, type2 = _ref.type, defaultValue = _ref.defaultValue, directives = _ref.directives;
    return variable + ": " + type2 + wrap(" = ", defaultValue) + wrap(" ", join$1(directives, " "));
  },
  SelectionSet: function SelectionSet(_ref2) {
    var selections = _ref2.selections;
    return block$2(selections);
  },
  Field: function Field(_ref3) {
    var alias = _ref3.alias, name2 = _ref3.name, args = _ref3.arguments, directives = _ref3.directives, selectionSet = _ref3.selectionSet;
    var prefix = wrap("", alias, ": ") + name2;
    var argsLine = prefix + wrap("(", join$1(args, ", "), ")");
    if (argsLine.length > MAX_LINE_LENGTH) {
      argsLine = prefix + wrap("(\n", indent(join$1(args, "\n")), "\n)");
    }
    return join$1([argsLine, join$1(directives, " "), selectionSet], " ");
  },
  Argument: function Argument(_ref4) {
    var name2 = _ref4.name, value = _ref4.value;
    return name2 + ": " + value;
  },
  FragmentSpread: function FragmentSpread(_ref5) {
    var name2 = _ref5.name, directives = _ref5.directives;
    return "..." + name2 + wrap(" ", join$1(directives, " "));
  },
  InlineFragment: function InlineFragment(_ref6) {
    var typeCondition = _ref6.typeCondition, directives = _ref6.directives, selectionSet = _ref6.selectionSet;
    return join$1(["...", wrap("on ", typeCondition), join$1(directives, " "), selectionSet], " ");
  },
  FragmentDefinition: function FragmentDefinition(_ref7) {
    var name2 = _ref7.name, typeCondition = _ref7.typeCondition, variableDefinitions = _ref7.variableDefinitions, directives = _ref7.directives, selectionSet = _ref7.selectionSet;
    return "fragment ".concat(name2).concat(wrap("(", join$1(variableDefinitions, ", "), ")"), " ") + "on ".concat(typeCondition, " ").concat(wrap("", join$1(directives, " "), " ")) + selectionSet;
  },
  IntValue: function IntValue(_ref8) {
    var value = _ref8.value;
    return value;
  },
  FloatValue: function FloatValue(_ref9) {
    var value = _ref9.value;
    return value;
  },
  StringValue: function StringValue(_ref10, key) {
    var value = _ref10.value, isBlockString = _ref10.block;
    return isBlockString ? printBlockString(value, key === "description" ? "" : "  ") : JSON.stringify(value);
  },
  BooleanValue: function BooleanValue(_ref11) {
    var value = _ref11.value;
    return value ? "true" : "false";
  },
  NullValue: function NullValue() {
    return "null";
  },
  EnumValue: function EnumValue(_ref12) {
    var value = _ref12.value;
    return value;
  },
  ListValue: function ListValue(_ref13) {
    var values = _ref13.values;
    return "[" + join$1(values, ", ") + "]";
  },
  ObjectValue: function ObjectValue(_ref14) {
    var fields = _ref14.fields;
    return "{" + join$1(fields, ", ") + "}";
  },
  ObjectField: function ObjectField(_ref15) {
    var name2 = _ref15.name, value = _ref15.value;
    return name2 + ": " + value;
  },
  Directive: function Directive(_ref16) {
    var name2 = _ref16.name, args = _ref16.arguments;
    return "@" + name2 + wrap("(", join$1(args, ", "), ")");
  },
  NamedType: function NamedType(_ref17) {
    var name2 = _ref17.name;
    return name2;
  },
  ListType: function ListType(_ref18) {
    var type2 = _ref18.type;
    return "[" + type2 + "]";
  },
  NonNullType: function NonNullType(_ref19) {
    var type2 = _ref19.type;
    return type2 + "!";
  },
  SchemaDefinition: addDescription(function(_ref20) {
    var directives = _ref20.directives, operationTypes = _ref20.operationTypes;
    return join$1(["schema", join$1(directives, " "), block$2(operationTypes)], " ");
  }),
  OperationTypeDefinition: function OperationTypeDefinition(_ref21) {
    var operation = _ref21.operation, type2 = _ref21.type;
    return operation + ": " + type2;
  },
  ScalarTypeDefinition: addDescription(function(_ref22) {
    var name2 = _ref22.name, directives = _ref22.directives;
    return join$1(["scalar", name2, join$1(directives, " ")], " ");
  }),
  ObjectTypeDefinition: addDescription(function(_ref23) {
    var name2 = _ref23.name, interfaces = _ref23.interfaces, directives = _ref23.directives, fields = _ref23.fields;
    return join$1(["type", name2, wrap("implements ", join$1(interfaces, " & ")), join$1(directives, " "), block$2(fields)], " ");
  }),
  FieldDefinition: addDescription(function(_ref24) {
    var name2 = _ref24.name, args = _ref24.arguments, type2 = _ref24.type, directives = _ref24.directives;
    return name2 + (hasMultilineItems(args) ? wrap("(\n", indent(join$1(args, "\n")), "\n)") : wrap("(", join$1(args, ", "), ")")) + ": " + type2 + wrap(" ", join$1(directives, " "));
  }),
  InputValueDefinition: addDescription(function(_ref25) {
    var name2 = _ref25.name, type2 = _ref25.type, defaultValue = _ref25.defaultValue, directives = _ref25.directives;
    return join$1([name2 + ": " + type2, wrap("= ", defaultValue), join$1(directives, " ")], " ");
  }),
  InterfaceTypeDefinition: addDescription(function(_ref26) {
    var name2 = _ref26.name, interfaces = _ref26.interfaces, directives = _ref26.directives, fields = _ref26.fields;
    return join$1(["interface", name2, wrap("implements ", join$1(interfaces, " & ")), join$1(directives, " "), block$2(fields)], " ");
  }),
  UnionTypeDefinition: addDescription(function(_ref27) {
    var name2 = _ref27.name, directives = _ref27.directives, types = _ref27.types;
    return join$1(["union", name2, join$1(directives, " "), types && types.length !== 0 ? "= " + join$1(types, " | ") : ""], " ");
  }),
  EnumTypeDefinition: addDescription(function(_ref28) {
    var name2 = _ref28.name, directives = _ref28.directives, values = _ref28.values;
    return join$1(["enum", name2, join$1(directives, " "), block$2(values)], " ");
  }),
  EnumValueDefinition: addDescription(function(_ref29) {
    var name2 = _ref29.name, directives = _ref29.directives;
    return join$1([name2, join$1(directives, " ")], " ");
  }),
  InputObjectTypeDefinition: addDescription(function(_ref30) {
    var name2 = _ref30.name, directives = _ref30.directives, fields = _ref30.fields;
    return join$1(["input", name2, join$1(directives, " "), block$2(fields)], " ");
  }),
  DirectiveDefinition: addDescription(function(_ref31) {
    var name2 = _ref31.name, args = _ref31.arguments, repeatable = _ref31.repeatable, locations = _ref31.locations;
    return "directive @" + name2 + (hasMultilineItems(args) ? wrap("(\n", indent(join$1(args, "\n")), "\n)") : wrap("(", join$1(args, ", "), ")")) + (repeatable ? " repeatable" : "") + " on " + join$1(locations, " | ");
  }),
  SchemaExtension: function SchemaExtension(_ref32) {
    var directives = _ref32.directives, operationTypes = _ref32.operationTypes;
    return join$1(["extend schema", join$1(directives, " "), block$2(operationTypes)], " ");
  },
  ScalarTypeExtension: function ScalarTypeExtension(_ref33) {
    var name2 = _ref33.name, directives = _ref33.directives;
    return join$1(["extend scalar", name2, join$1(directives, " ")], " ");
  },
  ObjectTypeExtension: function ObjectTypeExtension(_ref34) {
    var name2 = _ref34.name, interfaces = _ref34.interfaces, directives = _ref34.directives, fields = _ref34.fields;
    return join$1(["extend type", name2, wrap("implements ", join$1(interfaces, " & ")), join$1(directives, " "), block$2(fields)], " ");
  },
  InterfaceTypeExtension: function InterfaceTypeExtension(_ref35) {
    var name2 = _ref35.name, interfaces = _ref35.interfaces, directives = _ref35.directives, fields = _ref35.fields;
    return join$1(["extend interface", name2, wrap("implements ", join$1(interfaces, " & ")), join$1(directives, " "), block$2(fields)], " ");
  },
  UnionTypeExtension: function UnionTypeExtension(_ref36) {
    var name2 = _ref36.name, directives = _ref36.directives, types = _ref36.types;
    return join$1(["extend union", name2, join$1(directives, " "), types && types.length !== 0 ? "= " + join$1(types, " | ") : ""], " ");
  },
  EnumTypeExtension: function EnumTypeExtension(_ref37) {
    var name2 = _ref37.name, directives = _ref37.directives, values = _ref37.values;
    return join$1(["extend enum", name2, join$1(directives, " "), block$2(values)], " ");
  },
  InputObjectTypeExtension: function InputObjectTypeExtension(_ref38) {
    var name2 = _ref38.name, directives = _ref38.directives, fields = _ref38.fields;
    return join$1(["extend input", name2, join$1(directives, " "), block$2(fields)], " ");
  }
};
function addDescription(cb) {
  return function(node) {
    return join$1([node.description, cb(node)], "\n");
  };
}
function join$1(maybeArray) {
  var _maybeArray$filter$jo;
  var separator = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "";
  return (_maybeArray$filter$jo = maybeArray === null || maybeArray === void 0 ? void 0 : maybeArray.filter(function(x2) {
    return x2;
  }).join(separator)) !== null && _maybeArray$filter$jo !== void 0 ? _maybeArray$filter$jo : "";
}
function block$2(array) {
  return wrap("{\n", indent(join$1(array, "\n")), "\n}");
}
function wrap(start2, maybeString) {
  var end2 = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : "";
  return maybeString != null && maybeString !== "" ? start2 + maybeString + end2 : "";
}
function indent(str) {
  return wrap("  ", str.replace(/\n/g, "\n  "));
}
function isMultiline(str) {
  return str.indexOf("\n") !== -1;
}
function hasMultilineItems(maybeArray) {
  return maybeArray != null && maybeArray.some(isMultiline);
}
function _typeof$1(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof$1 = function _typeof2(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof$1 = function _typeof2(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof$1(obj);
}
function isObjectLike(value) {
  return _typeof$1(value) == "object" && value !== null;
}
var SYMBOL_TO_STRING_TAG = typeof Symbol === "function" && Symbol.toStringTag != null ? Symbol.toStringTag : "@@toStringTag";
function getLocation(source, position) {
  var lineRegexp = /\r\n|[\n\r]/g;
  var line = 1;
  var column = position + 1;
  var match3;
  while ((match3 = lineRegexp.exec(source.body)) && match3.index < position) {
    line += 1;
    column = position + 1 - (match3.index + match3[0].length);
  }
  return {
    line,
    column
  };
}
function printLocation(location2) {
  return printSourceLocation(location2.source, getLocation(location2.source, location2.start));
}
function printSourceLocation(source, sourceLocation) {
  var firstLineColumnOffset = source.locationOffset.column - 1;
  var body = whitespace(firstLineColumnOffset) + source.body;
  var lineIndex = sourceLocation.line - 1;
  var lineOffset = source.locationOffset.line - 1;
  var lineNum = sourceLocation.line + lineOffset;
  var columnOffset = sourceLocation.line === 1 ? firstLineColumnOffset : 0;
  var columnNum = sourceLocation.column + columnOffset;
  var locationStr = "".concat(source.name, ":").concat(lineNum, ":").concat(columnNum, "\n");
  var lines = body.split(/\r\n|[\n\r]/g);
  var locationLine = lines[lineIndex];
  if (locationLine.length > 120) {
    var subLineIndex = Math.floor(columnNum / 80);
    var subLineColumnNum = columnNum % 80;
    var subLines = [];
    for (var i = 0; i < locationLine.length; i += 80) {
      subLines.push(locationLine.slice(i, i + 80));
    }
    return locationStr + printPrefixedLines([["".concat(lineNum), subLines[0]]].concat(subLines.slice(1, subLineIndex + 1).map(function(subLine) {
      return ["", subLine];
    }), [[" ", whitespace(subLineColumnNum - 1) + "^"], ["", subLines[subLineIndex + 1]]]));
  }
  return locationStr + printPrefixedLines([
    ["".concat(lineNum - 1), lines[lineIndex - 1]],
    ["".concat(lineNum), locationLine],
    ["", whitespace(columnNum - 1) + "^"],
    ["".concat(lineNum + 1), lines[lineIndex + 1]]
  ]);
}
function printPrefixedLines(lines) {
  var existingLines = lines.filter(function(_ref) {
    _ref[0];
    var line = _ref[1];
    return line !== void 0;
  });
  var padLen = Math.max.apply(Math, existingLines.map(function(_ref2) {
    var prefix = _ref2[0];
    return prefix.length;
  }));
  return existingLines.map(function(_ref3) {
    var prefix = _ref3[0], line = _ref3[1];
    return leftPad(padLen, prefix) + (line ? " | " + line : " |");
  }).join("\n");
}
function whitespace(len) {
  return Array(len + 1).join(" ");
}
function leftPad(len, str) {
  return whitespace(len - str.length) + str;
}
function _typeof(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof2(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof = function _typeof2(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof(obj);
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties$1(target2, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target2, descriptor.key, descriptor);
  }
}
function _createClass$1(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties$1(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties$1(Constructor, staticProps);
  return Constructor;
}
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf(subClass, superClass);
}
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
function _possibleConstructorReturn(self2, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized(self2);
}
function _assertThisInitialized(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _wrapNativeSuper(Class) {
  var _cache = typeof Map === "function" ? /* @__PURE__ */ new Map() : void 0;
  _wrapNativeSuper = function _wrapNativeSuper2(Class2) {
    if (Class2 === null || !_isNativeFunction(Class2))
      return Class2;
    if (typeof Class2 !== "function") {
      throw new TypeError("Super expression must either be null or a function");
    }
    if (typeof _cache !== "undefined") {
      if (_cache.has(Class2))
        return _cache.get(Class2);
      _cache.set(Class2, Wrapper);
    }
    function Wrapper() {
      return _construct(Class2, arguments, _getPrototypeOf(this).constructor);
    }
    Wrapper.prototype = Object.create(Class2.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } });
    return _setPrototypeOf(Wrapper, Class2);
  };
  return _wrapNativeSuper(Class);
}
function _construct(Parent, args, Class) {
  if (_isNativeReflectConstruct()) {
    _construct = Reflect.construct;
  } else {
    _construct = function _construct2(Parent2, args2, Class2) {
      var a2 = [null];
      a2.push.apply(a2, args2);
      var Constructor = Function.bind.apply(Parent2, a2);
      var instance = new Constructor();
      if (Class2)
        _setPrototypeOf(instance, Class2.prototype);
      return instance;
    };
  }
  return _construct.apply(null, arguments);
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Date.prototype.toString.call(Reflect.construct(Date, [], function() {
    }));
    return true;
  } catch (e) {
    return false;
  }
}
function _isNativeFunction(fn2) {
  return Function.toString.call(fn2).indexOf("[native code]") !== -1;
}
function _setPrototypeOf(o2, p2) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o3, p3) {
    o3.__proto__ = p3;
    return o3;
  };
  return _setPrototypeOf(o2, p2);
}
function _getPrototypeOf(o2) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o3) {
    return o3.__proto__ || Object.getPrototypeOf(o3);
  };
  return _getPrototypeOf(o2);
}
var GraphQLError = /* @__PURE__ */ function(_Error) {
  _inherits(GraphQLError2, _Error);
  var _super = _createSuper(GraphQLError2);
  function GraphQLError2(message, nodes, source, positions, path, originalError, extensions) {
    var _locations2, _source2, _positions2, _extensions2;
    var _this;
    _classCallCheck(this, GraphQLError2);
    _this = _super.call(this, message);
    var _nodes = Array.isArray(nodes) ? nodes.length !== 0 ? nodes : void 0 : nodes ? [nodes] : void 0;
    var _source = source;
    if (!_source && _nodes) {
      var _nodes$0$loc;
      _source = (_nodes$0$loc = _nodes[0].loc) === null || _nodes$0$loc === void 0 ? void 0 : _nodes$0$loc.source;
    }
    var _positions = positions;
    if (!_positions && _nodes) {
      _positions = _nodes.reduce(function(list3, node) {
        if (node.loc) {
          list3.push(node.loc.start);
        }
        return list3;
      }, []);
    }
    if (_positions && _positions.length === 0) {
      _positions = void 0;
    }
    var _locations;
    if (positions && source) {
      _locations = positions.map(function(pos) {
        return getLocation(source, pos);
      });
    } else if (_nodes) {
      _locations = _nodes.reduce(function(list3, node) {
        if (node.loc) {
          list3.push(getLocation(node.loc.source, node.loc.start));
        }
        return list3;
      }, []);
    }
    var _extensions = extensions;
    if (_extensions == null && originalError != null) {
      var originalExtensions = originalError.extensions;
      if (isObjectLike(originalExtensions)) {
        _extensions = originalExtensions;
      }
    }
    Object.defineProperties(_assertThisInitialized(_this), {
      name: {
        value: "GraphQLError"
      },
      message: {
        value: message,
        enumerable: true,
        writable: true
      },
      locations: {
        value: (_locations2 = _locations) !== null && _locations2 !== void 0 ? _locations2 : void 0,
        enumerable: _locations != null
      },
      path: {
        value: path !== null && path !== void 0 ? path : void 0,
        enumerable: path != null
      },
      nodes: {
        value: _nodes !== null && _nodes !== void 0 ? _nodes : void 0
      },
      source: {
        value: (_source2 = _source) !== null && _source2 !== void 0 ? _source2 : void 0
      },
      positions: {
        value: (_positions2 = _positions) !== null && _positions2 !== void 0 ? _positions2 : void 0
      },
      originalError: {
        value: originalError
      },
      extensions: {
        value: (_extensions2 = _extensions) !== null && _extensions2 !== void 0 ? _extensions2 : void 0,
        enumerable: _extensions != null
      }
    });
    if (originalError !== null && originalError !== void 0 && originalError.stack) {
      Object.defineProperty(_assertThisInitialized(_this), "stack", {
        value: originalError.stack,
        writable: true,
        configurable: true
      });
      return _possibleConstructorReturn(_this);
    }
    if (Error.captureStackTrace) {
      Error.captureStackTrace(_assertThisInitialized(_this), GraphQLError2);
    } else {
      Object.defineProperty(_assertThisInitialized(_this), "stack", {
        value: Error().stack,
        writable: true,
        configurable: true
      });
    }
    return _this;
  }
  _createClass$1(GraphQLError2, [{
    key: "toString",
    value: function toString2() {
      return printError(this);
    }
  }, {
    key: SYMBOL_TO_STRING_TAG,
    get: function get2() {
      return "Object";
    }
  }]);
  return GraphQLError2;
}(/* @__PURE__ */ _wrapNativeSuper(Error));
function printError(error2) {
  var output = error2.message;
  if (error2.nodes) {
    for (var _i2 = 0, _error$nodes2 = error2.nodes; _i2 < _error$nodes2.length; _i2++) {
      var node = _error$nodes2[_i2];
      if (node.loc) {
        output += "\n\n" + printLocation(node.loc);
      }
    }
  } else if (error2.source && error2.locations) {
    for (var _i4 = 0, _error$locations2 = error2.locations; _i4 < _error$locations2.length; _i4++) {
      var location2 = _error$locations2[_i4];
      output += "\n\n" + printSourceLocation(error2.source, location2);
    }
  }
  return output;
}
function syntaxError(source, position, description) {
  return new GraphQLError("Syntax Error: ".concat(description), void 0, source, [position]);
}
var TokenKind = Object.freeze({
  SOF: "<SOF>",
  EOF: "<EOF>",
  BANG: "!",
  DOLLAR: "$",
  AMP: "&",
  PAREN_L: "(",
  PAREN_R: ")",
  SPREAD: "...",
  COLON: ":",
  EQUALS: "=",
  AT: "@",
  BRACKET_L: "[",
  BRACKET_R: "]",
  BRACE_L: "{",
  PIPE: "|",
  BRACE_R: "}",
  NAME: "Name",
  INT: "Int",
  FLOAT: "Float",
  STRING: "String",
  BLOCK_STRING: "BlockString",
  COMMENT: "Comment"
});
function devAssert(condition, message) {
  var booleanCondition = Boolean(condition);
  if (!booleanCondition) {
    throw new Error(message);
  }
}
const instanceOf = function instanceOf2(value, constructor) {
  return value instanceof constructor;
};
function _defineProperties(target2, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target2, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  return Constructor;
}
var Source = /* @__PURE__ */ function() {
  function Source2(body) {
    var name2 = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "GraphQL request";
    var locationOffset = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {
      line: 1,
      column: 1
    };
    typeof body === "string" || devAssert(0, "Body must be a string. Received: ".concat(inspect(body), "."));
    this.body = body;
    this.name = name2;
    this.locationOffset = locationOffset;
    this.locationOffset.line > 0 || devAssert(0, "line in locationOffset is 1-indexed and must be positive.");
    this.locationOffset.column > 0 || devAssert(0, "column in locationOffset is 1-indexed and must be positive.");
  }
  _createClass(Source2, [{
    key: SYMBOL_TO_STRING_TAG,
    get: function get2() {
      return "Source";
    }
  }]);
  return Source2;
}();
function isSource(source) {
  return instanceOf(source, Source);
}
var DirectiveLocation = Object.freeze({
  QUERY: "QUERY",
  MUTATION: "MUTATION",
  SUBSCRIPTION: "SUBSCRIPTION",
  FIELD: "FIELD",
  FRAGMENT_DEFINITION: "FRAGMENT_DEFINITION",
  FRAGMENT_SPREAD: "FRAGMENT_SPREAD",
  INLINE_FRAGMENT: "INLINE_FRAGMENT",
  VARIABLE_DEFINITION: "VARIABLE_DEFINITION",
  SCHEMA: "SCHEMA",
  SCALAR: "SCALAR",
  OBJECT: "OBJECT",
  FIELD_DEFINITION: "FIELD_DEFINITION",
  ARGUMENT_DEFINITION: "ARGUMENT_DEFINITION",
  INTERFACE: "INTERFACE",
  UNION: "UNION",
  ENUM: "ENUM",
  ENUM_VALUE: "ENUM_VALUE",
  INPUT_OBJECT: "INPUT_OBJECT",
  INPUT_FIELD_DEFINITION: "INPUT_FIELD_DEFINITION"
});
var Lexer = /* @__PURE__ */ function() {
  function Lexer2(source) {
    var startOfFileToken = new Token$4(TokenKind.SOF, 0, 0, 0, 0, null);
    this.source = source;
    this.lastToken = startOfFileToken;
    this.token = startOfFileToken;
    this.line = 1;
    this.lineStart = 0;
  }
  var _proto = Lexer2.prototype;
  _proto.advance = function advance() {
    this.lastToken = this.token;
    var token2 = this.token = this.lookahead();
    return token2;
  };
  _proto.lookahead = function lookahead() {
    var token2 = this.token;
    if (token2.kind !== TokenKind.EOF) {
      do {
        var _token$next;
        token2 = (_token$next = token2.next) !== null && _token$next !== void 0 ? _token$next : token2.next = readToken(this, token2);
      } while (token2.kind === TokenKind.COMMENT);
    }
    return token2;
  };
  return Lexer2;
}();
function isPunctuatorTokenKind(kind) {
  return kind === TokenKind.BANG || kind === TokenKind.DOLLAR || kind === TokenKind.AMP || kind === TokenKind.PAREN_L || kind === TokenKind.PAREN_R || kind === TokenKind.SPREAD || kind === TokenKind.COLON || kind === TokenKind.EQUALS || kind === TokenKind.AT || kind === TokenKind.BRACKET_L || kind === TokenKind.BRACKET_R || kind === TokenKind.BRACE_L || kind === TokenKind.PIPE || kind === TokenKind.BRACE_R;
}
function printCharCode(code3) {
  return isNaN(code3) ? TokenKind.EOF : code3 < 127 ? JSON.stringify(String.fromCharCode(code3)) : '"\\u'.concat(("00" + code3.toString(16).toUpperCase()).slice(-4), '"');
}
function readToken(lexer, prev2) {
  var source = lexer.source;
  var body = source.body;
  var bodyLength = body.length;
  var pos = prev2.end;
  while (pos < bodyLength) {
    var code3 = body.charCodeAt(pos);
    var _line = lexer.line;
    var _col = 1 + pos - lexer.lineStart;
    switch (code3) {
      case 65279:
      case 9:
      case 32:
      case 44:
        ++pos;
        continue;
      case 10:
        ++pos;
        ++lexer.line;
        lexer.lineStart = pos;
        continue;
      case 13:
        if (body.charCodeAt(pos + 1) === 10) {
          pos += 2;
        } else {
          ++pos;
        }
        ++lexer.line;
        lexer.lineStart = pos;
        continue;
      case 33:
        return new Token$4(TokenKind.BANG, pos, pos + 1, _line, _col, prev2);
      case 35:
        return readComment(source, pos, _line, _col, prev2);
      case 36:
        return new Token$4(TokenKind.DOLLAR, pos, pos + 1, _line, _col, prev2);
      case 38:
        return new Token$4(TokenKind.AMP, pos, pos + 1, _line, _col, prev2);
      case 40:
        return new Token$4(TokenKind.PAREN_L, pos, pos + 1, _line, _col, prev2);
      case 41:
        return new Token$4(TokenKind.PAREN_R, pos, pos + 1, _line, _col, prev2);
      case 46:
        if (body.charCodeAt(pos + 1) === 46 && body.charCodeAt(pos + 2) === 46) {
          return new Token$4(TokenKind.SPREAD, pos, pos + 3, _line, _col, prev2);
        }
        break;
      case 58:
        return new Token$4(TokenKind.COLON, pos, pos + 1, _line, _col, prev2);
      case 61:
        return new Token$4(TokenKind.EQUALS, pos, pos + 1, _line, _col, prev2);
      case 64:
        return new Token$4(TokenKind.AT, pos, pos + 1, _line, _col, prev2);
      case 91:
        return new Token$4(TokenKind.BRACKET_L, pos, pos + 1, _line, _col, prev2);
      case 93:
        return new Token$4(TokenKind.BRACKET_R, pos, pos + 1, _line, _col, prev2);
      case 123:
        return new Token$4(TokenKind.BRACE_L, pos, pos + 1, _line, _col, prev2);
      case 124:
        return new Token$4(TokenKind.PIPE, pos, pos + 1, _line, _col, prev2);
      case 125:
        return new Token$4(TokenKind.BRACE_R, pos, pos + 1, _line, _col, prev2);
      case 34:
        if (body.charCodeAt(pos + 1) === 34 && body.charCodeAt(pos + 2) === 34) {
          return readBlockString(source, pos, _line, _col, prev2, lexer);
        }
        return readString(source, pos, _line, _col, prev2);
      case 45:
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
        return readNumber(source, pos, code3, _line, _col, prev2);
      case 65:
      case 66:
      case 67:
      case 68:
      case 69:
      case 70:
      case 71:
      case 72:
      case 73:
      case 74:
      case 75:
      case 76:
      case 77:
      case 78:
      case 79:
      case 80:
      case 81:
      case 82:
      case 83:
      case 84:
      case 85:
      case 86:
      case 87:
      case 88:
      case 89:
      case 90:
      case 95:
      case 97:
      case 98:
      case 99:
      case 100:
      case 101:
      case 102:
      case 103:
      case 104:
      case 105:
      case 106:
      case 107:
      case 108:
      case 109:
      case 110:
      case 111:
      case 112:
      case 113:
      case 114:
      case 115:
      case 116:
      case 117:
      case 118:
      case 119:
      case 120:
      case 121:
      case 122:
        return readName(source, pos, _line, _col, prev2);
    }
    throw syntaxError(source, pos, unexpectedCharacterMessage(code3));
  }
  var line = lexer.line;
  var col = 1 + pos - lexer.lineStart;
  return new Token$4(TokenKind.EOF, bodyLength, bodyLength, line, col, prev2);
}
function unexpectedCharacterMessage(code3) {
  if (code3 < 32 && code3 !== 9 && code3 !== 10 && code3 !== 13) {
    return "Cannot contain the invalid character ".concat(printCharCode(code3), ".");
  }
  if (code3 === 39) {
    return `Unexpected single quote character ('), did you mean to use a double quote (")?`;
  }
  return "Cannot parse the unexpected character ".concat(printCharCode(code3), ".");
}
function readComment(source, start2, line, col, prev2) {
  var body = source.body;
  var code3;
  var position = start2;
  do {
    code3 = body.charCodeAt(++position);
  } while (!isNaN(code3) && (code3 > 31 || code3 === 9));
  return new Token$4(TokenKind.COMMENT, start2, position, line, col, prev2, body.slice(start2 + 1, position));
}
function readNumber(source, start2, firstCode, line, col, prev2) {
  var body = source.body;
  var code3 = firstCode;
  var position = start2;
  var isFloat = false;
  if (code3 === 45) {
    code3 = body.charCodeAt(++position);
  }
  if (code3 === 48) {
    code3 = body.charCodeAt(++position);
    if (code3 >= 48 && code3 <= 57) {
      throw syntaxError(source, position, "Invalid number, unexpected digit after 0: ".concat(printCharCode(code3), "."));
    }
  } else {
    position = readDigits(source, position, code3);
    code3 = body.charCodeAt(position);
  }
  if (code3 === 46) {
    isFloat = true;
    code3 = body.charCodeAt(++position);
    position = readDigits(source, position, code3);
    code3 = body.charCodeAt(position);
  }
  if (code3 === 69 || code3 === 101) {
    isFloat = true;
    code3 = body.charCodeAt(++position);
    if (code3 === 43 || code3 === 45) {
      code3 = body.charCodeAt(++position);
    }
    position = readDigits(source, position, code3);
    code3 = body.charCodeAt(position);
  }
  if (code3 === 46 || isNameStart(code3)) {
    throw syntaxError(source, position, "Invalid number, expected digit but got: ".concat(printCharCode(code3), "."));
  }
  return new Token$4(isFloat ? TokenKind.FLOAT : TokenKind.INT, start2, position, line, col, prev2, body.slice(start2, position));
}
function readDigits(source, start2, firstCode) {
  var body = source.body;
  var position = start2;
  var code3 = firstCode;
  if (code3 >= 48 && code3 <= 57) {
    do {
      code3 = body.charCodeAt(++position);
    } while (code3 >= 48 && code3 <= 57);
    return position;
  }
  throw syntaxError(source, position, "Invalid number, expected digit but got: ".concat(printCharCode(code3), "."));
}
function readString(source, start2, line, col, prev2) {
  var body = source.body;
  var position = start2 + 1;
  var chunkStart = position;
  var code3 = 0;
  var value = "";
  while (position < body.length && !isNaN(code3 = body.charCodeAt(position)) && code3 !== 10 && code3 !== 13) {
    if (code3 === 34) {
      value += body.slice(chunkStart, position);
      return new Token$4(TokenKind.STRING, start2, position + 1, line, col, prev2, value);
    }
    if (code3 < 32 && code3 !== 9) {
      throw syntaxError(source, position, "Invalid character within String: ".concat(printCharCode(code3), "."));
    }
    ++position;
    if (code3 === 92) {
      value += body.slice(chunkStart, position - 1);
      code3 = body.charCodeAt(position);
      switch (code3) {
        case 34:
          value += '"';
          break;
        case 47:
          value += "/";
          break;
        case 92:
          value += "\\";
          break;
        case 98:
          value += "\b";
          break;
        case 102:
          value += "\f";
          break;
        case 110:
          value += "\n";
          break;
        case 114:
          value += "\r";
          break;
        case 116:
          value += "	";
          break;
        case 117: {
          var charCode = uniCharCode(body.charCodeAt(position + 1), body.charCodeAt(position + 2), body.charCodeAt(position + 3), body.charCodeAt(position + 4));
          if (charCode < 0) {
            var invalidSequence = body.slice(position + 1, position + 5);
            throw syntaxError(source, position, "Invalid character escape sequence: \\u".concat(invalidSequence, "."));
          }
          value += String.fromCharCode(charCode);
          position += 4;
          break;
        }
        default:
          throw syntaxError(source, position, "Invalid character escape sequence: \\".concat(String.fromCharCode(code3), "."));
      }
      ++position;
      chunkStart = position;
    }
  }
  throw syntaxError(source, position, "Unterminated string.");
}
function readBlockString(source, start2, line, col, prev2, lexer) {
  var body = source.body;
  var position = start2 + 3;
  var chunkStart = position;
  var code3 = 0;
  var rawValue = "";
  while (position < body.length && !isNaN(code3 = body.charCodeAt(position))) {
    if (code3 === 34 && body.charCodeAt(position + 1) === 34 && body.charCodeAt(position + 2) === 34) {
      rawValue += body.slice(chunkStart, position);
      return new Token$4(TokenKind.BLOCK_STRING, start2, position + 3, line, col, prev2, dedentBlockStringValue(rawValue));
    }
    if (code3 < 32 && code3 !== 9 && code3 !== 10 && code3 !== 13) {
      throw syntaxError(source, position, "Invalid character within String: ".concat(printCharCode(code3), "."));
    }
    if (code3 === 10) {
      ++position;
      ++lexer.line;
      lexer.lineStart = position;
    } else if (code3 === 13) {
      if (body.charCodeAt(position + 1) === 10) {
        position += 2;
      } else {
        ++position;
      }
      ++lexer.line;
      lexer.lineStart = position;
    } else if (code3 === 92 && body.charCodeAt(position + 1) === 34 && body.charCodeAt(position + 2) === 34 && body.charCodeAt(position + 3) === 34) {
      rawValue += body.slice(chunkStart, position) + '"""';
      position += 4;
      chunkStart = position;
    } else {
      ++position;
    }
  }
  throw syntaxError(source, position, "Unterminated string.");
}
function uniCharCode(a2, b2, c2, d2) {
  return char2hex(a2) << 12 | char2hex(b2) << 8 | char2hex(c2) << 4 | char2hex(d2);
}
function char2hex(a2) {
  return a2 >= 48 && a2 <= 57 ? a2 - 48 : a2 >= 65 && a2 <= 70 ? a2 - 55 : a2 >= 97 && a2 <= 102 ? a2 - 87 : -1;
}
function readName(source, start2, line, col, prev2) {
  var body = source.body;
  var bodyLength = body.length;
  var position = start2 + 1;
  var code3 = 0;
  while (position !== bodyLength && !isNaN(code3 = body.charCodeAt(position)) && (code3 === 95 || code3 >= 48 && code3 <= 57 || code3 >= 65 && code3 <= 90 || code3 >= 97 && code3 <= 122)) {
    ++position;
  }
  return new Token$4(TokenKind.NAME, start2, position, line, col, prev2, body.slice(start2, position));
}
function isNameStart(code3) {
  return code3 === 95 || code3 >= 65 && code3 <= 90 || code3 >= 97 && code3 <= 122;
}
function parse$4(source, options2) {
  var parser2 = new Parser(source, options2);
  return parser2.parseDocument();
}
var Parser = /* @__PURE__ */ function() {
  function Parser2(source, options2) {
    var sourceObj = isSource(source) ? source : new Source(source);
    this._lexer = new Lexer(sourceObj);
    this._options = options2;
  }
  var _proto = Parser2.prototype;
  _proto.parseName = function parseName2() {
    var token2 = this.expectToken(TokenKind.NAME);
    return {
      kind: Kind.NAME,
      value: token2.value,
      loc: this.loc(token2)
    };
  };
  _proto.parseDocument = function parseDocument() {
    var start2 = this._lexer.token;
    return {
      kind: Kind.DOCUMENT,
      definitions: this.many(TokenKind.SOF, this.parseDefinition, TokenKind.EOF),
      loc: this.loc(start2)
    };
  };
  _proto.parseDefinition = function parseDefinition() {
    if (this.peek(TokenKind.NAME)) {
      switch (this._lexer.token.value) {
        case "query":
        case "mutation":
        case "subscription":
          return this.parseOperationDefinition();
        case "fragment":
          return this.parseFragmentDefinition();
        case "schema":
        case "scalar":
        case "type":
        case "interface":
        case "union":
        case "enum":
        case "input":
        case "directive":
          return this.parseTypeSystemDefinition();
        case "extend":
          return this.parseTypeSystemExtension();
      }
    } else if (this.peek(TokenKind.BRACE_L)) {
      return this.parseOperationDefinition();
    } else if (this.peekDescription()) {
      return this.parseTypeSystemDefinition();
    }
    throw this.unexpected();
  };
  _proto.parseOperationDefinition = function parseOperationDefinition() {
    var start2 = this._lexer.token;
    if (this.peek(TokenKind.BRACE_L)) {
      return {
        kind: Kind.OPERATION_DEFINITION,
        operation: "query",
        name: void 0,
        variableDefinitions: [],
        directives: [],
        selectionSet: this.parseSelectionSet(),
        loc: this.loc(start2)
      };
    }
    var operation = this.parseOperationType();
    var name2;
    if (this.peek(TokenKind.NAME)) {
      name2 = this.parseName();
    }
    return {
      kind: Kind.OPERATION_DEFINITION,
      operation,
      name: name2,
      variableDefinitions: this.parseVariableDefinitions(),
      directives: this.parseDirectives(false),
      selectionSet: this.parseSelectionSet(),
      loc: this.loc(start2)
    };
  };
  _proto.parseOperationType = function parseOperationType() {
    var operationToken = this.expectToken(TokenKind.NAME);
    switch (operationToken.value) {
      case "query":
        return "query";
      case "mutation":
        return "mutation";
      case "subscription":
        return "subscription";
    }
    throw this.unexpected(operationToken);
  };
  _proto.parseVariableDefinitions = function parseVariableDefinitions() {
    return this.optionalMany(TokenKind.PAREN_L, this.parseVariableDefinition, TokenKind.PAREN_R);
  };
  _proto.parseVariableDefinition = function parseVariableDefinition() {
    var start2 = this._lexer.token;
    return {
      kind: Kind.VARIABLE_DEFINITION,
      variable: this.parseVariable(),
      type: (this.expectToken(TokenKind.COLON), this.parseTypeReference()),
      defaultValue: this.expectOptionalToken(TokenKind.EQUALS) ? this.parseValueLiteral(true) : void 0,
      directives: this.parseDirectives(true),
      loc: this.loc(start2)
    };
  };
  _proto.parseVariable = function parseVariable() {
    var start2 = this._lexer.token;
    this.expectToken(TokenKind.DOLLAR);
    return {
      kind: Kind.VARIABLE,
      name: this.parseName(),
      loc: this.loc(start2)
    };
  };
  _proto.parseSelectionSet = function parseSelectionSet() {
    var start2 = this._lexer.token;
    return {
      kind: Kind.SELECTION_SET,
      selections: this.many(TokenKind.BRACE_L, this.parseSelection, TokenKind.BRACE_R),
      loc: this.loc(start2)
    };
  };
  _proto.parseSelection = function parseSelection() {
    return this.peek(TokenKind.SPREAD) ? this.parseFragment() : this.parseField();
  };
  _proto.parseField = function parseField() {
    var start2 = this._lexer.token;
    var nameOrAlias = this.parseName();
    var alias;
    var name2;
    if (this.expectOptionalToken(TokenKind.COLON)) {
      alias = nameOrAlias;
      name2 = this.parseName();
    } else {
      name2 = nameOrAlias;
    }
    return {
      kind: Kind.FIELD,
      alias,
      name: name2,
      arguments: this.parseArguments(false),
      directives: this.parseDirectives(false),
      selectionSet: this.peek(TokenKind.BRACE_L) ? this.parseSelectionSet() : void 0,
      loc: this.loc(start2)
    };
  };
  _proto.parseArguments = function parseArguments(isConst) {
    var item = isConst ? this.parseConstArgument : this.parseArgument;
    return this.optionalMany(TokenKind.PAREN_L, item, TokenKind.PAREN_R);
  };
  _proto.parseArgument = function parseArgument() {
    var start2 = this._lexer.token;
    var name2 = this.parseName();
    this.expectToken(TokenKind.COLON);
    return {
      kind: Kind.ARGUMENT,
      name: name2,
      value: this.parseValueLiteral(false),
      loc: this.loc(start2)
    };
  };
  _proto.parseConstArgument = function parseConstArgument() {
    var start2 = this._lexer.token;
    return {
      kind: Kind.ARGUMENT,
      name: this.parseName(),
      value: (this.expectToken(TokenKind.COLON), this.parseValueLiteral(true)),
      loc: this.loc(start2)
    };
  };
  _proto.parseFragment = function parseFragment() {
    var start2 = this._lexer.token;
    this.expectToken(TokenKind.SPREAD);
    var hasTypeCondition = this.expectOptionalKeyword("on");
    if (!hasTypeCondition && this.peek(TokenKind.NAME)) {
      return {
        kind: Kind.FRAGMENT_SPREAD,
        name: this.parseFragmentName(),
        directives: this.parseDirectives(false),
        loc: this.loc(start2)
      };
    }
    return {
      kind: Kind.INLINE_FRAGMENT,
      typeCondition: hasTypeCondition ? this.parseNamedType() : void 0,
      directives: this.parseDirectives(false),
      selectionSet: this.parseSelectionSet(),
      loc: this.loc(start2)
    };
  };
  _proto.parseFragmentDefinition = function parseFragmentDefinition() {
    var _this$_options;
    var start2 = this._lexer.token;
    this.expectKeyword("fragment");
    if (((_this$_options = this._options) === null || _this$_options === void 0 ? void 0 : _this$_options.experimentalFragmentVariables) === true) {
      return {
        kind: Kind.FRAGMENT_DEFINITION,
        name: this.parseFragmentName(),
        variableDefinitions: this.parseVariableDefinitions(),
        typeCondition: (this.expectKeyword("on"), this.parseNamedType()),
        directives: this.parseDirectives(false),
        selectionSet: this.parseSelectionSet(),
        loc: this.loc(start2)
      };
    }
    return {
      kind: Kind.FRAGMENT_DEFINITION,
      name: this.parseFragmentName(),
      typeCondition: (this.expectKeyword("on"), this.parseNamedType()),
      directives: this.parseDirectives(false),
      selectionSet: this.parseSelectionSet(),
      loc: this.loc(start2)
    };
  };
  _proto.parseFragmentName = function parseFragmentName() {
    if (this._lexer.token.value === "on") {
      throw this.unexpected();
    }
    return this.parseName();
  };
  _proto.parseValueLiteral = function parseValueLiteral(isConst) {
    var token2 = this._lexer.token;
    switch (token2.kind) {
      case TokenKind.BRACKET_L:
        return this.parseList(isConst);
      case TokenKind.BRACE_L:
        return this.parseObject(isConst);
      case TokenKind.INT:
        this._lexer.advance();
        return {
          kind: Kind.INT,
          value: token2.value,
          loc: this.loc(token2)
        };
      case TokenKind.FLOAT:
        this._lexer.advance();
        return {
          kind: Kind.FLOAT,
          value: token2.value,
          loc: this.loc(token2)
        };
      case TokenKind.STRING:
      case TokenKind.BLOCK_STRING:
        return this.parseStringLiteral();
      case TokenKind.NAME:
        this._lexer.advance();
        switch (token2.value) {
          case "true":
            return {
              kind: Kind.BOOLEAN,
              value: true,
              loc: this.loc(token2)
            };
          case "false":
            return {
              kind: Kind.BOOLEAN,
              value: false,
              loc: this.loc(token2)
            };
          case "null":
            return {
              kind: Kind.NULL,
              loc: this.loc(token2)
            };
          default:
            return {
              kind: Kind.ENUM,
              value: token2.value,
              loc: this.loc(token2)
            };
        }
      case TokenKind.DOLLAR:
        if (!isConst) {
          return this.parseVariable();
        }
        break;
    }
    throw this.unexpected();
  };
  _proto.parseStringLiteral = function parseStringLiteral() {
    var token2 = this._lexer.token;
    this._lexer.advance();
    return {
      kind: Kind.STRING,
      value: token2.value,
      block: token2.kind === TokenKind.BLOCK_STRING,
      loc: this.loc(token2)
    };
  };
  _proto.parseList = function parseList(isConst) {
    var _this = this;
    var start2 = this._lexer.token;
    var item = function item2() {
      return _this.parseValueLiteral(isConst);
    };
    return {
      kind: Kind.LIST,
      values: this.any(TokenKind.BRACKET_L, item, TokenKind.BRACKET_R),
      loc: this.loc(start2)
    };
  };
  _proto.parseObject = function parseObject(isConst) {
    var _this2 = this;
    var start2 = this._lexer.token;
    var item = function item2() {
      return _this2.parseObjectField(isConst);
    };
    return {
      kind: Kind.OBJECT,
      fields: this.any(TokenKind.BRACE_L, item, TokenKind.BRACE_R),
      loc: this.loc(start2)
    };
  };
  _proto.parseObjectField = function parseObjectField(isConst) {
    var start2 = this._lexer.token;
    var name2 = this.parseName();
    this.expectToken(TokenKind.COLON);
    return {
      kind: Kind.OBJECT_FIELD,
      name: name2,
      value: this.parseValueLiteral(isConst),
      loc: this.loc(start2)
    };
  };
  _proto.parseDirectives = function parseDirectives(isConst) {
    var directives = [];
    while (this.peek(TokenKind.AT)) {
      directives.push(this.parseDirective(isConst));
    }
    return directives;
  };
  _proto.parseDirective = function parseDirective(isConst) {
    var start2 = this._lexer.token;
    this.expectToken(TokenKind.AT);
    return {
      kind: Kind.DIRECTIVE,
      name: this.parseName(),
      arguments: this.parseArguments(isConst),
      loc: this.loc(start2)
    };
  };
  _proto.parseTypeReference = function parseTypeReference() {
    var start2 = this._lexer.token;
    var type2;
    if (this.expectOptionalToken(TokenKind.BRACKET_L)) {
      type2 = this.parseTypeReference();
      this.expectToken(TokenKind.BRACKET_R);
      type2 = {
        kind: Kind.LIST_TYPE,
        type: type2,
        loc: this.loc(start2)
      };
    } else {
      type2 = this.parseNamedType();
    }
    if (this.expectOptionalToken(TokenKind.BANG)) {
      return {
        kind: Kind.NON_NULL_TYPE,
        type: type2,
        loc: this.loc(start2)
      };
    }
    return type2;
  };
  _proto.parseNamedType = function parseNamedType() {
    var start2 = this._lexer.token;
    return {
      kind: Kind.NAMED_TYPE,
      name: this.parseName(),
      loc: this.loc(start2)
    };
  };
  _proto.parseTypeSystemDefinition = function parseTypeSystemDefinition() {
    var keywordToken = this.peekDescription() ? this._lexer.lookahead() : this._lexer.token;
    if (keywordToken.kind === TokenKind.NAME) {
      switch (keywordToken.value) {
        case "schema":
          return this.parseSchemaDefinition();
        case "scalar":
          return this.parseScalarTypeDefinition();
        case "type":
          return this.parseObjectTypeDefinition();
        case "interface":
          return this.parseInterfaceTypeDefinition();
        case "union":
          return this.parseUnionTypeDefinition();
        case "enum":
          return this.parseEnumTypeDefinition();
        case "input":
          return this.parseInputObjectTypeDefinition();
        case "directive":
          return this.parseDirectiveDefinition();
      }
    }
    throw this.unexpected(keywordToken);
  };
  _proto.peekDescription = function peekDescription() {
    return this.peek(TokenKind.STRING) || this.peek(TokenKind.BLOCK_STRING);
  };
  _proto.parseDescription = function parseDescription() {
    if (this.peekDescription()) {
      return this.parseStringLiteral();
    }
  };
  _proto.parseSchemaDefinition = function parseSchemaDefinition() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("schema");
    var directives = this.parseDirectives(true);
    var operationTypes = this.many(TokenKind.BRACE_L, this.parseOperationTypeDefinition, TokenKind.BRACE_R);
    return {
      kind: Kind.SCHEMA_DEFINITION,
      description,
      directives,
      operationTypes,
      loc: this.loc(start2)
    };
  };
  _proto.parseOperationTypeDefinition = function parseOperationTypeDefinition() {
    var start2 = this._lexer.token;
    var operation = this.parseOperationType();
    this.expectToken(TokenKind.COLON);
    var type2 = this.parseNamedType();
    return {
      kind: Kind.OPERATION_TYPE_DEFINITION,
      operation,
      type: type2,
      loc: this.loc(start2)
    };
  };
  _proto.parseScalarTypeDefinition = function parseScalarTypeDefinition() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("scalar");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    return {
      kind: Kind.SCALAR_TYPE_DEFINITION,
      description,
      name: name2,
      directives,
      loc: this.loc(start2)
    };
  };
  _proto.parseObjectTypeDefinition = function parseObjectTypeDefinition() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("type");
    var name2 = this.parseName();
    var interfaces = this.parseImplementsInterfaces();
    var directives = this.parseDirectives(true);
    var fields = this.parseFieldsDefinition();
    return {
      kind: Kind.OBJECT_TYPE_DEFINITION,
      description,
      name: name2,
      interfaces,
      directives,
      fields,
      loc: this.loc(start2)
    };
  };
  _proto.parseImplementsInterfaces = function parseImplementsInterfaces() {
    var _this$_options2;
    if (!this.expectOptionalKeyword("implements")) {
      return [];
    }
    if (((_this$_options2 = this._options) === null || _this$_options2 === void 0 ? void 0 : _this$_options2.allowLegacySDLImplementsInterfaces) === true) {
      var types = [];
      this.expectOptionalToken(TokenKind.AMP);
      do {
        types.push(this.parseNamedType());
      } while (this.expectOptionalToken(TokenKind.AMP) || this.peek(TokenKind.NAME));
      return types;
    }
    return this.delimitedMany(TokenKind.AMP, this.parseNamedType);
  };
  _proto.parseFieldsDefinition = function parseFieldsDefinition() {
    var _this$_options3;
    if (((_this$_options3 = this._options) === null || _this$_options3 === void 0 ? void 0 : _this$_options3.allowLegacySDLEmptyFields) === true && this.peek(TokenKind.BRACE_L) && this._lexer.lookahead().kind === TokenKind.BRACE_R) {
      this._lexer.advance();
      this._lexer.advance();
      return [];
    }
    return this.optionalMany(TokenKind.BRACE_L, this.parseFieldDefinition, TokenKind.BRACE_R);
  };
  _proto.parseFieldDefinition = function parseFieldDefinition() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    var name2 = this.parseName();
    var args = this.parseArgumentDefs();
    this.expectToken(TokenKind.COLON);
    var type2 = this.parseTypeReference();
    var directives = this.parseDirectives(true);
    return {
      kind: Kind.FIELD_DEFINITION,
      description,
      name: name2,
      arguments: args,
      type: type2,
      directives,
      loc: this.loc(start2)
    };
  };
  _proto.parseArgumentDefs = function parseArgumentDefs() {
    return this.optionalMany(TokenKind.PAREN_L, this.parseInputValueDef, TokenKind.PAREN_R);
  };
  _proto.parseInputValueDef = function parseInputValueDef() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    var name2 = this.parseName();
    this.expectToken(TokenKind.COLON);
    var type2 = this.parseTypeReference();
    var defaultValue;
    if (this.expectOptionalToken(TokenKind.EQUALS)) {
      defaultValue = this.parseValueLiteral(true);
    }
    var directives = this.parseDirectives(true);
    return {
      kind: Kind.INPUT_VALUE_DEFINITION,
      description,
      name: name2,
      type: type2,
      defaultValue,
      directives,
      loc: this.loc(start2)
    };
  };
  _proto.parseInterfaceTypeDefinition = function parseInterfaceTypeDefinition() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("interface");
    var name2 = this.parseName();
    var interfaces = this.parseImplementsInterfaces();
    var directives = this.parseDirectives(true);
    var fields = this.parseFieldsDefinition();
    return {
      kind: Kind.INTERFACE_TYPE_DEFINITION,
      description,
      name: name2,
      interfaces,
      directives,
      fields,
      loc: this.loc(start2)
    };
  };
  _proto.parseUnionTypeDefinition = function parseUnionTypeDefinition() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("union");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var types = this.parseUnionMemberTypes();
    return {
      kind: Kind.UNION_TYPE_DEFINITION,
      description,
      name: name2,
      directives,
      types,
      loc: this.loc(start2)
    };
  };
  _proto.parseUnionMemberTypes = function parseUnionMemberTypes() {
    return this.expectOptionalToken(TokenKind.EQUALS) ? this.delimitedMany(TokenKind.PIPE, this.parseNamedType) : [];
  };
  _proto.parseEnumTypeDefinition = function parseEnumTypeDefinition() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("enum");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var values = this.parseEnumValuesDefinition();
    return {
      kind: Kind.ENUM_TYPE_DEFINITION,
      description,
      name: name2,
      directives,
      values,
      loc: this.loc(start2)
    };
  };
  _proto.parseEnumValuesDefinition = function parseEnumValuesDefinition() {
    return this.optionalMany(TokenKind.BRACE_L, this.parseEnumValueDefinition, TokenKind.BRACE_R);
  };
  _proto.parseEnumValueDefinition = function parseEnumValueDefinition() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    return {
      kind: Kind.ENUM_VALUE_DEFINITION,
      description,
      name: name2,
      directives,
      loc: this.loc(start2)
    };
  };
  _proto.parseInputObjectTypeDefinition = function parseInputObjectTypeDefinition() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("input");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var fields = this.parseInputFieldsDefinition();
    return {
      kind: Kind.INPUT_OBJECT_TYPE_DEFINITION,
      description,
      name: name2,
      directives,
      fields,
      loc: this.loc(start2)
    };
  };
  _proto.parseInputFieldsDefinition = function parseInputFieldsDefinition() {
    return this.optionalMany(TokenKind.BRACE_L, this.parseInputValueDef, TokenKind.BRACE_R);
  };
  _proto.parseTypeSystemExtension = function parseTypeSystemExtension() {
    var keywordToken = this._lexer.lookahead();
    if (keywordToken.kind === TokenKind.NAME) {
      switch (keywordToken.value) {
        case "schema":
          return this.parseSchemaExtension();
        case "scalar":
          return this.parseScalarTypeExtension();
        case "type":
          return this.parseObjectTypeExtension();
        case "interface":
          return this.parseInterfaceTypeExtension();
        case "union":
          return this.parseUnionTypeExtension();
        case "enum":
          return this.parseEnumTypeExtension();
        case "input":
          return this.parseInputObjectTypeExtension();
      }
    }
    throw this.unexpected(keywordToken);
  };
  _proto.parseSchemaExtension = function parseSchemaExtension() {
    var start2 = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("schema");
    var directives = this.parseDirectives(true);
    var operationTypes = this.optionalMany(TokenKind.BRACE_L, this.parseOperationTypeDefinition, TokenKind.BRACE_R);
    if (directives.length === 0 && operationTypes.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.SCHEMA_EXTENSION,
      directives,
      operationTypes,
      loc: this.loc(start2)
    };
  };
  _proto.parseScalarTypeExtension = function parseScalarTypeExtension() {
    var start2 = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("scalar");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    if (directives.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.SCALAR_TYPE_EXTENSION,
      name: name2,
      directives,
      loc: this.loc(start2)
    };
  };
  _proto.parseObjectTypeExtension = function parseObjectTypeExtension() {
    var start2 = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("type");
    var name2 = this.parseName();
    var interfaces = this.parseImplementsInterfaces();
    var directives = this.parseDirectives(true);
    var fields = this.parseFieldsDefinition();
    if (interfaces.length === 0 && directives.length === 0 && fields.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.OBJECT_TYPE_EXTENSION,
      name: name2,
      interfaces,
      directives,
      fields,
      loc: this.loc(start2)
    };
  };
  _proto.parseInterfaceTypeExtension = function parseInterfaceTypeExtension() {
    var start2 = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("interface");
    var name2 = this.parseName();
    var interfaces = this.parseImplementsInterfaces();
    var directives = this.parseDirectives(true);
    var fields = this.parseFieldsDefinition();
    if (interfaces.length === 0 && directives.length === 0 && fields.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.INTERFACE_TYPE_EXTENSION,
      name: name2,
      interfaces,
      directives,
      fields,
      loc: this.loc(start2)
    };
  };
  _proto.parseUnionTypeExtension = function parseUnionTypeExtension() {
    var start2 = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("union");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var types = this.parseUnionMemberTypes();
    if (directives.length === 0 && types.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.UNION_TYPE_EXTENSION,
      name: name2,
      directives,
      types,
      loc: this.loc(start2)
    };
  };
  _proto.parseEnumTypeExtension = function parseEnumTypeExtension() {
    var start2 = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("enum");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var values = this.parseEnumValuesDefinition();
    if (directives.length === 0 && values.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.ENUM_TYPE_EXTENSION,
      name: name2,
      directives,
      values,
      loc: this.loc(start2)
    };
  };
  _proto.parseInputObjectTypeExtension = function parseInputObjectTypeExtension() {
    var start2 = this._lexer.token;
    this.expectKeyword("extend");
    this.expectKeyword("input");
    var name2 = this.parseName();
    var directives = this.parseDirectives(true);
    var fields = this.parseInputFieldsDefinition();
    if (directives.length === 0 && fields.length === 0) {
      throw this.unexpected();
    }
    return {
      kind: Kind.INPUT_OBJECT_TYPE_EXTENSION,
      name: name2,
      directives,
      fields,
      loc: this.loc(start2)
    };
  };
  _proto.parseDirectiveDefinition = function parseDirectiveDefinition() {
    var start2 = this._lexer.token;
    var description = this.parseDescription();
    this.expectKeyword("directive");
    this.expectToken(TokenKind.AT);
    var name2 = this.parseName();
    var args = this.parseArgumentDefs();
    var repeatable = this.expectOptionalKeyword("repeatable");
    this.expectKeyword("on");
    var locations = this.parseDirectiveLocations();
    return {
      kind: Kind.DIRECTIVE_DEFINITION,
      description,
      name: name2,
      arguments: args,
      repeatable,
      locations,
      loc: this.loc(start2)
    };
  };
  _proto.parseDirectiveLocations = function parseDirectiveLocations() {
    return this.delimitedMany(TokenKind.PIPE, this.parseDirectiveLocation);
  };
  _proto.parseDirectiveLocation = function parseDirectiveLocation() {
    var start2 = this._lexer.token;
    var name2 = this.parseName();
    if (DirectiveLocation[name2.value] !== void 0) {
      return name2;
    }
    throw this.unexpected(start2);
  };
  _proto.loc = function loc(startToken) {
    var _this$_options4;
    if (((_this$_options4 = this._options) === null || _this$_options4 === void 0 ? void 0 : _this$_options4.noLocation) !== true) {
      return new Location(startToken, this._lexer.lastToken, this._lexer.source);
    }
  };
  _proto.peek = function peek(kind) {
    return this._lexer.token.kind === kind;
  };
  _proto.expectToken = function expectToken(kind) {
    var token2 = this._lexer.token;
    if (token2.kind === kind) {
      this._lexer.advance();
      return token2;
    }
    throw syntaxError(this._lexer.source, token2.start, "Expected ".concat(getTokenKindDesc(kind), ", found ").concat(getTokenDesc(token2), "."));
  };
  _proto.expectOptionalToken = function expectOptionalToken(kind) {
    var token2 = this._lexer.token;
    if (token2.kind === kind) {
      this._lexer.advance();
      return token2;
    }
    return void 0;
  };
  _proto.expectKeyword = function expectKeyword(value) {
    var token2 = this._lexer.token;
    if (token2.kind === TokenKind.NAME && token2.value === value) {
      this._lexer.advance();
    } else {
      throw syntaxError(this._lexer.source, token2.start, 'Expected "'.concat(value, '", found ').concat(getTokenDesc(token2), "."));
    }
  };
  _proto.expectOptionalKeyword = function expectOptionalKeyword(value) {
    var token2 = this._lexer.token;
    if (token2.kind === TokenKind.NAME && token2.value === value) {
      this._lexer.advance();
      return true;
    }
    return false;
  };
  _proto.unexpected = function unexpected(atToken) {
    var token2 = atToken !== null && atToken !== void 0 ? atToken : this._lexer.token;
    return syntaxError(this._lexer.source, token2.start, "Unexpected ".concat(getTokenDesc(token2), "."));
  };
  _proto.any = function any(openKind, parseFn, closeKind) {
    this.expectToken(openKind);
    var nodes = [];
    while (!this.expectOptionalToken(closeKind)) {
      nodes.push(parseFn.call(this));
    }
    return nodes;
  };
  _proto.optionalMany = function optionalMany(openKind, parseFn, closeKind) {
    if (this.expectOptionalToken(openKind)) {
      var nodes = [];
      do {
        nodes.push(parseFn.call(this));
      } while (!this.expectOptionalToken(closeKind));
      return nodes;
    }
    return [];
  };
  _proto.many = function many(openKind, parseFn, closeKind) {
    this.expectToken(openKind);
    var nodes = [];
    do {
      nodes.push(parseFn.call(this));
    } while (!this.expectOptionalToken(closeKind));
    return nodes;
  };
  _proto.delimitedMany = function delimitedMany(delimiterKind, parseFn) {
    this.expectOptionalToken(delimiterKind);
    var nodes = [];
    do {
      nodes.push(parseFn.call(this));
    } while (this.expectOptionalToken(delimiterKind));
    return nodes;
  };
  return Parser2;
}();
function getTokenDesc(token2) {
  var value = token2.value;
  return getTokenKindDesc(token2.kind) + (value != null ? ' "'.concat(value, '"') : "");
}
function getTokenKindDesc(kind) {
  return isPunctuatorTokenKind(kind) ? '"'.concat(kind, '"') : kind;
}
function l$1(a2, b2) {
  b2.tag = a2;
  return b2;
}
function m() {
}
function p$1(a2) {
  return function(b2) {
    var c2 = a2.length;
    let d2 = false, e = false, f2 = false, g = 0;
    b2(
      l$1(0, [
        function(h2) {
          if (h2) {
            d2 = true;
          } else if (e) {
            f2 = true;
          } else {
            for (e = f2 = true; f2 && !d2; ) {
              g < c2 ? (h2 = a2[g], g = g + 1 | 0, f2 = false, b2(l$1(1, [h2]))) : (d2 = true, b2(0));
            }
            e = false;
          }
        }
      ])
    );
  };
}
function r() {
}
function t(a2) {
  a2(0);
}
function u$1(a2) {
  let b2 = false;
  a2(
    l$1(0, [
      function(c2) {
        c2 ? b2 = true : b2 || a2(0);
      }
    ])
  );
}
function C(a2) {
  return a2(0);
}
function D$1(a2) {
  return function(b2) {
    return function(c2) {
      let e = m, f2 = false, g = [], h2 = false;
      b2(function(b3) {
        "number" == typeof b3 ? h2 || (h2 = true, 0 === g.length && c2(0)) : b3.tag ? h2 || (f2 = false, function(a3) {
          function b4(a4) {
            "number" == typeof a4 ? 0 !== g.length && (g = g.filter(d2), a4 = 0 === g.length, h2 && a4 ? c2(0) : !f2 && a4 && (f2 = true, e(0))) : a4.tag ? 0 !== g.length && (c2(l$1(1, [a4[0]])), k(0)) : (k = a4 = a4[0], g = g.concat(a4), a4(0));
          }
          function d2(a4) {
            return a4 !== k;
          }
          let k = m;
          1 === a3.length ? a3(b4) : a3.bind(null, b4);
        }(a2(b3[0])), f2 || (f2 = true, e(0))) : e = b3[0];
      });
      c2(
        l$1(0, [
          function(a3) {
            a3 ? (h2 || (h2 = true, e(a3)), g.forEach(function(c3) {
              return c3(a3);
            }), g = []) : (f2 || h2 ? f2 = false : (f2 = true, e(0)), g.forEach(C));
          }
        ])
      );
    };
  };
}
function E$1(a2) {
  return a2;
}
function H(a2) {
  return function(b2) {
    return function(c2) {
      let d2 = false;
      return b2(function(e) {
        if ("number" == typeof e) {
          d2 || (d2 = true, c2(e));
        } else if (e.tag) {
          d2 || (a2(e[0]), c2(e));
        } else {
          var g = e[0];
          c2(
            l$1(0, [
              function(a3) {
                if (!d2) {
                  return a3 && (d2 = true), g(a3);
                }
              }
            ])
          );
        }
      });
    };
  };
}
function J$1(a2) {
  a2(0);
}
function K(a2) {
  return function(b2) {
    return function(c2) {
      function d2(a3) {
        h2 && ("number" == typeof a3 ? (h2 = false, n ? c2(a3) : f2 || (f2 = true, e(0))) : a3.tag ? (c2(a3), k ? k = false : g(0)) : (g = a3 = a3[0], k = false, a3(0)));
      }
      let e = m, f2 = false, g = m, h2 = false, k = false, n = false;
      b2(function(b3) {
        "number" == typeof b3 ? n || (n = true, h2 || c2(0)) : b3.tag ? n || (h2 && (g(1), g = m), f2 ? f2 = false : (f2 = true, e(0)), b3 = a2(b3[0]), h2 = true, b3(d2)) : e = b3[0];
      });
      c2(
        l$1(0, [
          function(a3) {
            if (a3) {
              if (n || (n = true, e(1)), h2) {
                return h2 = false, g(1);
              }
            } else {
              n || f2 || (f2 = true, e(0)), h2 && !k && (k = true, g(0));
            }
          }
        ])
      );
    };
  };
}
function M(a2) {
  return function(b2) {
    return function(c2) {
      let d2 = [], e = m;
      return b2(function(b3) {
        "number" == typeof b3 ? p$1(d2)(c2) : b3.tag ? (d2.length >= a2 && 0 < a2 && d2.shift(), d2.push(b3[0]), e(0)) : (b3 = b3[0], 0 >= a2 ? (b3(1), u$1(c2)) : (e = b3, b3(0)));
      });
    };
  };
}
function N$1(a2) {
  return function(b2) {
    let c2 = m, d2 = false;
    b2(function(e) {
      "number" == typeof e ? d2 = true : e.tag ? d2 || (a2(e[0]), c2(0)) : (c2 = e = e[0], e(0));
    });
    return {
      unsubscribe: function() {
        if (!d2) {
          return d2 = true, c2(1);
        }
      }
    };
  };
}
function O() {
}
function buffer$1(a2) {
  return function(b2) {
    return function(c2) {
      function d2(a3) {
        "number" == typeof a3 ? k || (k = true, f2(1), 0 < e.length && c2(l$1(1, [e])), c2(0)) : a3.tag ? !k && 0 < e.length && (a3 = e, e = [], c2(l$1(1, [a3]))) : g = a3[0];
      }
      let e = [], f2 = m, g = m, h2 = false, k = false;
      b2(function(b3) {
        "number" == typeof b3 ? k || (k = true, g(1), 0 < e.length && c2(l$1(1, [e])), c2(0)) : b3.tag ? k || (e.push(b3[0]), h2 ? h2 = false : (h2 = true, f2(0), g(0))) : (f2 = b3[0], a2(d2));
      });
      c2(
        l$1(0, [
          function(a3) {
            if (!k) {
              if (a3) {
                return k = true, f2(1), g(1);
              }
              if (!h2) {
                return h2 = true, f2(0), g(0);
              }
            }
          }
        ])
      );
    };
  };
}
function filter$1(a2) {
  return function(b2) {
    return function(c2) {
      let d2 = m;
      return b2(function(b3) {
        "number" == typeof b3 ? c2(b3) : b3.tag ? a2(b3[0]) ? c2(b3) : d2(0) : (d2 = b3[0], c2(b3));
      });
    };
  };
}
function fromPromise$1(a2) {
  return function(b2) {
    let c2 = false;
    a2.then(function(a3) {
      c2 || (b2(l$1(1, [a3])), b2(0));
      return Promise.resolve(void 0);
    });
    b2(
      l$1(0, [
        function(a3) {
          a3 && (c2 = true);
        }
      ])
    );
  };
}
function fromValue$1(a2) {
  return function(b2) {
    let c2 = false;
    b2(
      l$1(0, [
        function(d2) {
          d2 ? c2 = true : c2 || (c2 = true, b2(l$1(1, [a2])), b2(0));
        }
      ])
    );
  };
}
function make$1(a2) {
  return function(b2) {
    let c2 = r, d2 = false;
    c2 = a2({
      next: function(a3) {
        d2 || b2(l$1(1, [a3]));
      },
      complete: function() {
        d2 || (d2 = true, b2(0));
      }
    });
    b2(
      l$1(0, [
        function(a3) {
          if (a3 && !d2) {
            return d2 = true, c2();
          }
        }
      ])
    );
  };
}
function makeSubject$1() {
  let a2 = [], b2 = false;
  return {
    source: function(c2) {
      function b3(a3) {
        return a3 !== c2;
      }
      a2 = a2.concat(c2);
      c2(
        l$1(0, [
          function(c3) {
            c3 && (a2 = a2.filter(b3));
          }
        ])
      );
    },
    next: function(c2) {
      b2 || a2.forEach(function(a3) {
        a3(l$1(1, [c2]));
      });
    },
    complete: function() {
      b2 || (b2 = true, a2.forEach(t));
    }
  };
}
function map$1$1(a2) {
  return function(b2) {
    return function(c2) {
      return b2(function(b3) {
        b3 = "number" == typeof b3 ? 0 : b3.tag ? l$1(1, [a2(b3[0])]) : l$1(0, [b3[0]]);
        c2(b3);
      });
    };
  };
}
function merge$1(a2) {
  return D$1(E$1)(p$1(a2));
}
function onEnd$1(a2) {
  return function(b2) {
    return function(c2) {
      let d2 = false;
      return b2(function(b3) {
        if ("number" == typeof b3) {
          if (d2) {
            return;
          }
          d2 = true;
          c2(b3);
          return a2();
        }
        if (b3.tag) {
          d2 || c2(b3);
        } else {
          var e = b3[0];
          c2(
            l$1(0, [
              function(c3) {
                if (!d2) {
                  return c3 ? (d2 = true, e(c3), a2()) : e(c3);
                }
              }
            ])
          );
        }
      });
    };
  };
}
function onStart$1(a2) {
  return function(b2) {
    return function(c2) {
      return b2(function(b3) {
        "number" == typeof b3 ? c2(b3) : b3.tag ? c2(b3) : (c2(b3), a2());
      });
    };
  };
}
function pipe() {
  for (var a2 = arguments, b2 = arguments[0], c2 = 1, d2 = arguments.length; c2 < d2; c2++) {
    b2 = a2[c2](b2);
  }
  return b2;
}
function publish$1(a2) {
  return N$1(O)(a2);
}
function share$1(a2) {
  function b2(a3) {
    "number" == typeof a3 ? (c2.forEach(J$1), c2 = []) : a3.tag ? (e = false, c2.forEach(function(b3) {
      b3(a3);
    })) : d2 = a3[0];
  }
  let c2 = [], d2 = m, e = false;
  return function(f2) {
    function g(a3) {
      return a3 !== f2;
    }
    c2 = c2.concat(f2);
    1 === c2.length && a2(b2);
    f2(
      l$1(0, [
        function(a3) {
          if (a3) {
            if (c2 = c2.filter(g), 0 === c2.length) {
              return d2(1);
            }
          } else {
            e || (e = true, d2(a3));
          }
        }
      ])
    );
  };
}
function skipUntil$1(a2) {
  return function(b2) {
    return function(c2) {
      function d2(a3) {
        "number" == typeof a3 ? g && (k = true, e(1)) : a3.tag ? (g = false, f2(1)) : (f2 = a3 = a3[0], a3(0));
      }
      let e = m, f2 = m, g = true, h2 = false, k = false;
      b2(function(b3) {
        "number" == typeof b3 ? (g && f2(1), k = true, c2(0)) : b3.tag ? g || k ? h2 ? h2 = false : (h2 = true, e(0), f2(0)) : (h2 = false, c2(b3)) : (e = b3[0], a2(d2));
      });
      c2(
        l$1(0, [
          function(a3) {
            if (!k) {
              if (a3) {
                if (k = true, e(1), g) {
                  return f2(1);
                }
              } else {
                h2 || (h2 = true, g && f2(0), e(0));
              }
            }
          }
        ])
      );
    };
  };
}
function take$1(a2) {
  return function(b2) {
    return function(c2) {
      let d2 = false, e = 0, f2 = m;
      b2(function(b3) {
        "number" == typeof b3 ? d2 || (d2 = true, c2(0)) : b3.tag ? e < a2 && !d2 && (e = e + 1 | 0, c2(b3), !d2 && e >= a2 && (d2 = true, c2(0), f2(1))) : (b3 = b3[0], 0 >= a2 ? (d2 = true, c2(0), b3(1)) : f2 = b3);
      });
      c2(
        l$1(0, [
          function(b3) {
            if (!d2) {
              if (b3) {
                return d2 = true, f2(1);
              }
              if (e < a2) {
                return f2(0);
              }
            }
          }
        ])
      );
    };
  };
}
function takeUntil$1(a2) {
  return function(b2) {
    return function(c2) {
      function d2(a3) {
        "number" != typeof a3 && (a3.tag ? (e = true, f2(1), c2(0)) : (g = a3 = a3[0], a3(0)));
      }
      let e = false, f2 = m, g = m;
      b2(function(b3) {
        "number" == typeof b3 ? e || (e = true, g(1), c2(0)) : b3.tag ? e || c2(b3) : (f2 = b3[0], a2(d2));
      });
      c2(
        l$1(0, [
          function(a3) {
            if (!e) {
              return a3 ? (e = true, f2(1), g(1)) : f2(0);
            }
          }
        ])
      );
    };
  };
}
function toPromise$1(a2) {
  return new Promise(function(b2) {
    M(1)(a2)(function(a3) {
      if ("number" != typeof a3) {
        if (a3.tag) {
          b2(a3[0]);
        } else {
          a3[0](0);
        }
      }
    });
  });
}
"function" == typeof Symbol ? Symbol.observable || (Symbol.observable = Symbol("observable")) : "@@observable";
function rehydrateGraphQlError(r2) {
  if ("string" == typeof r2) {
    return new GraphQLError(r2);
  } else if ("object" == typeof r2 && r2.message) {
    return new GraphQLError(r2.message, r2.nodes, r2.source, r2.positions, r2.path, r2, r2.extensions || {});
  } else {
    return r2;
  }
}
var o = function(e) {
  function CombinedError(r2) {
    var t2 = r2.networkError;
    var n = r2.response;
    var a2 = (r2.graphQLErrors || []).map(rehydrateGraphQlError);
    var o2 = function generateErrorMessage(e2, r3) {
      var t3 = "";
      if (void 0 !== e2) {
        return t3 = "[Network] " + e2.message;
      }
      if (void 0 !== r3) {
        r3.forEach(function(e3) {
          t3 += "[GraphQL] " + e3.message + "\n";
        });
      }
      return t3.trim();
    }(t2, a2);
    e.call(this, o2);
    this.name = "CombinedError";
    this.message = o2;
    this.graphQLErrors = a2;
    this.networkError = t2;
    this.response = n;
  }
  if (e) {
    CombinedError.__proto__ = e;
  }
  (CombinedError.prototype = Object.create(e && e.prototype)).constructor = CombinedError;
  CombinedError.prototype.toString = function toString2() {
    return this.message;
  };
  return CombinedError;
}(Error);
function phash(e, r2) {
  e |= 0;
  for (var t2 = 0, n = 0 | r2.length; t2 < n; t2++) {
    e = (e << 5) + e + r2.charCodeAt(t2);
  }
  return e;
}
function hash$3(e) {
  return phash(5381, e) >>> 0;
}
var i$2 = /* @__PURE__ */ new Set();
var s = /* @__PURE__ */ new WeakMap();
function stringify(e) {
  if (null === e || i$2.has(e)) {
    return "null";
  } else if ("object" != typeof e) {
    return JSON.stringify(e) || "";
  } else if (e.toJSON) {
    return stringify(e.toJSON());
  } else if (Array.isArray(e)) {
    var r2 = "[";
    for (var t2 = 0, n = e.length; t2 < n; t2++) {
      if (t2 > 0) {
        r2 += ",";
      }
      var a2 = stringify(e[t2]);
      r2 += a2.length > 0 ? a2 : "null";
    }
    return r2 += "]";
  }
  var o2 = Object.keys(e).sort();
  if (!o2.length && e.constructor && e.constructor !== Object) {
    var u2 = s.get(e) || Math.random().toString(36).slice(2);
    s.set(e, u2);
    return '{"__key":"' + u2 + '"}';
  }
  i$2.add(e);
  var f2 = "{";
  for (var c2 = 0, l2 = o2.length; c2 < l2; c2++) {
    var h2 = o2[c2];
    var p2 = stringify(e[h2]);
    if (p2) {
      if (f2.length > 1) {
        f2 += ",";
      }
      f2 += stringify(h2) + ":" + p2;
    }
  }
  i$2.delete(e);
  return f2 += "}";
}
function stringifyVariables(e) {
  i$2.clear();
  return stringify(e);
}
var u = /("{3}[\s\S]*"{3}|"(?:\\.|[^"])*")/g;
var f = /([\s,]|#[^\n\r]+)+/g;
function replaceOutsideStrings(e, r2) {
  return r2 % 2 == 0 ? e.replace(f, " ").trim() : e;
}
function stringifyDocument(e) {
  var r2 = ("string" != typeof e ? e.loc && e.loc.source.body || print$1(e) : e).split(u).map(replaceOutsideStrings).join("");
  if ("string" != typeof e) {
    var t2 = "definitions" in e && getOperationName$1(e);
    if (t2) {
      r2 = "# " + t2 + "\n" + r2;
    }
    if (!e.loc) {
      e.loc = {
        start: 0,
        end: r2.length,
        source: {
          body: r2,
          name: "gql",
          locationOffset: {
            line: 1,
            column: 1
          }
        }
      };
    }
  }
  return r2;
}
var c = /* @__PURE__ */ new Map();
function keyDocument(e) {
  var r2;
  var n;
  if ("string" == typeof e) {
    r2 = hash$3(stringifyDocument(e));
    n = c.get(r2) || parse$4(e, {
      noLocation: true
    });
  } else {
    r2 = e.__key || hash$3(stringifyDocument(e));
    n = c.get(r2) || e;
  }
  if (!n.loc) {
    stringifyDocument(n);
  }
  n.__key = r2;
  c.set(r2, n);
  return n;
}
function createRequest(e, r2) {
  if (!r2) {
    r2 = {};
  }
  var t2 = keyDocument(e);
  return {
    key: phash(t2.__key, stringifyVariables(r2)) >>> 0,
    query: t2,
    variables: r2
  };
}
function getOperationName$1(e) {
  for (var t2 = 0, n = e.definitions.length; t2 < n; t2++) {
    var a2 = e.definitions[t2];
    if (a2.kind === Kind.OPERATION_DEFINITION && a2.name) {
      return a2.name.value;
    }
  }
}
function getOperationType(e) {
  for (var t2 = 0, n = e.definitions.length; t2 < n; t2++) {
    var a2 = e.definitions[t2];
    if (a2.kind === Kind.OPERATION_DEFINITION) {
      return a2.operation;
    }
  }
}
function _extends$3() {
  return (_extends$3 = Object.assign || function(e) {
    for (var r2 = 1; r2 < arguments.length; r2++) {
      var t2 = arguments[r2];
      for (var n in t2) {
        if (Object.prototype.hasOwnProperty.call(t2, n)) {
          e[n] = t2[n];
        }
      }
    }
    return e;
  }).apply(this, arguments);
}
function makeResult(e, r2, t2) {
  if (!("data" in r2) && !("errors" in r2) || "path" in r2) {
    throw new Error("No Content");
  }
  return {
    operation: e,
    data: r2.data,
    error: Array.isArray(r2.errors) ? new o({
      graphQLErrors: r2.errors,
      response: t2
    }) : void 0,
    extensions: "object" == typeof r2.extensions && r2.extensions || void 0,
    hasNext: !!r2.hasNext
  };
}
function mergeResultPatch(e, r2, t2) {
  var n = _extends$3({}, e);
  n.hasNext = !!r2.hasNext;
  if (!("path" in r2)) {
    if ("data" in r2) {
      n.data = r2.data;
    }
    return n;
  }
  if (Array.isArray(r2.errors)) {
    n.error = new o({
      graphQLErrors: n.error ? n.error.graphQLErrors.concat(r2.errors) : r2.errors,
      response: t2
    });
  }
  var a2 = n.data = _extends$3({}, n.data);
  var i = 0;
  var s2;
  while (i < r2.path.length) {
    a2 = a2[s2 = r2.path[i++]] = Array.isArray(a2[s2]) ? [].concat(a2[s2]) : _extends$3({}, a2[s2]);
  }
  _extends$3(a2, r2.data);
  return n;
}
function makeErrorResult(e, r2, t2) {
  return {
    operation: e,
    data: void 0,
    error: new o({
      networkError: r2,
      response: t2
    }),
    extensions: void 0
  };
}
function shouldUseGet(e) {
  return "query" === e.kind && !!e.context.preferGetMethod;
}
function makeFetchBody(e) {
  return {
    query: print$1(e.query),
    operationName: getOperationName$1(e.query),
    variables: e.variables || void 0,
    extensions: void 0
  };
}
function makeFetchURL(e, r2) {
  var t2 = shouldUseGet(e);
  var n = e.context.url;
  if (!t2 || !r2) {
    return n;
  }
  var a2 = [];
  if (r2.operationName) {
    a2.push("operationName=" + encodeURIComponent(r2.operationName));
  }
  if (r2.query) {
    a2.push("query=" + encodeURIComponent(r2.query.replace(/#[^\n\r]+/g, " ").trim()));
  }
  if (r2.variables) {
    a2.push("variables=" + encodeURIComponent(stringifyVariables(r2.variables)));
  }
  if (r2.extensions) {
    a2.push("extensions=" + encodeURIComponent(stringifyVariables(r2.extensions)));
  }
  var o2 = n + "?" + a2.join("&");
  if (o2.length > 2047) {
    e.context.preferGetMethod = false;
    return n;
  }
  return o2;
}
function makeFetchOptions(e, r2) {
  var t2 = shouldUseGet(e);
  var n = "function" == typeof e.context.fetchOptions ? e.context.fetchOptions() : e.context.fetchOptions || {};
  return _extends$3({}, n, {
    body: !t2 && r2 ? JSON.stringify(r2) : void 0,
    method: t2 ? "GET" : "POST",
    headers: t2 ? n.headers : _extends$3({}, {
      "content-type": "application/json"
    }, n.headers)
  });
}
var l = "undefined" != typeof Symbol ? Symbol.asyncIterator : null;
var h = "undefined" != typeof TextDecoder ? new TextDecoder() : null;
var p = /content-type:[^\r\n]*application\/json/i;
var d = /boundary="?([^=";]+)"?/i;
function makeFetchSource(e, r2, t2) {
  var n = "manual" === t2.redirect ? 400 : 300;
  var o2 = e.context.fetch;
  return make$1(function(a2) {
    var i = a2.next;
    var s2 = a2.complete;
    var u2 = "undefined" != typeof AbortController ? new AbortController() : null;
    if (u2) {
      t2.signal = u2.signal;
    }
    var f2 = false;
    function executeIncrementalFetch(e2, r3, t3) {
      var n2 = t3.headers && t3.headers.get("Content-Type") || "";
      if (!/multipart\/mixed/i.test(n2)) {
        return t3.json().then(function(n3) {
          var a4 = makeResult(r3, n3, t3);
          f2 = true;
          e2(a4);
        });
      }
      var a3 = "---";
      var o3 = n2.match(d);
      if (o3) {
        a3 = "--" + o3[1];
      }
      var i2;
      var cancel = function() {
      };
      if (l && t3[l]) {
        var s3 = t3[l]();
        i2 = s3.next.bind(s3);
      } else if ("body" in t3 && t3.body) {
        var u3 = t3.body.getReader();
        cancel = u3.cancel.bind(u3);
        i2 = u3.read.bind(u3);
      } else {
        throw new TypeError("Streaming requests unsupported");
      }
      var c3 = "";
      var v2 = true;
      var m3 = null;
      var g = null;
      return i2().then(function next(n3) {
        if (!n3.done) {
          var o4 = function toString2(e3) {
            return "Buffer" === e3.constructor.name ? e3.toString() : h.decode(e3);
          }(n3.value);
          var s4 = o4.indexOf(a3);
          if (s4 > -1) {
            s4 += c3.length;
          } else {
            s4 = c3.indexOf(a3);
          }
          c3 += o4;
          while (s4 > -1) {
            var u4 = c3.slice(0, s4);
            var l2 = c3.slice(s4 + a3.length);
            if (v2) {
              v2 = false;
            } else {
              var d2 = u4.indexOf("\r\n\r\n") + 4;
              var y2 = u4.slice(0, d2);
              var x2 = u4.slice(d2, u4.lastIndexOf("\r\n"));
              var b2 = void 0;
              if (p.test(y2)) {
                try {
                  b2 = JSON.parse(x2);
                  m3 = g = g ? mergeResultPatch(g, b2, t3) : makeResult(r3, b2, t3);
                } catch (e3) {
                }
              }
              if ("--" === l2.slice(0, 2) || b2 && !b2.hasNext) {
                if (!g) {
                  return e2(makeResult(r3, {}, t3));
                }
                break;
              }
            }
            s4 = (c3 = l2).indexOf(a3);
          }
        } else {
          f2 = true;
        }
        if (m3) {
          e2(m3);
          m3 = null;
        }
        if (!n3.done && (!g || g.hasNext)) {
          return i2().then(next);
        }
      }).finally(cancel);
    }
    var c2 = false;
    var v = false;
    var m2;
    Promise.resolve().then(function() {
      if (c2) {
        return;
      }
      return (o2 || fetch)(r2, t2);
    }).then(function(r3) {
      if (!r3) {
        return;
      }
      v = (m2 = r3).status < 200 || m2.status >= n;
      return executeIncrementalFetch(i, e, m2);
    }).then(s2).catch(function(r3) {
      if (f2) {
        throw r3;
      }
      if ("AbortError" !== r3.name) {
        var t3 = makeErrorResult(e, v ? new Error(m2.statusText) : r3, m2);
        i(t3);
        s2();
      }
    });
    return function() {
      c2 = true;
      if (u2) {
        u2.abort();
      }
    };
  });
}
function collectTypes(e, n) {
  if (Array.isArray(e)) {
    for (var r2 = 0; r2 < e.length; r2++) {
      collectTypes(e[r2], n);
    }
  } else if ("object" == typeof e && null !== e) {
    for (var t2 in e) {
      if ("__typename" === t2 && "string" == typeof e[t2]) {
        n[e[t2]] = 0;
      } else {
        collectTypes(e[t2], n);
      }
    }
  }
  return n;
}
function collectTypesFromResponse(e) {
  return Object.keys(collectTypes(e, {}));
}
var formatNode = function(e) {
  if (e.selectionSet && !e.selectionSet.selections.some(function(e2) {
    return e2.kind === Kind.FIELD && "__typename" === e2.name.value && !e2.alias;
  })) {
    return _extends$3({}, e, {
      selectionSet: _extends$3({}, e.selectionSet, {
        selections: e.selectionSet.selections.concat([{
          kind: Kind.FIELD,
          name: {
            kind: Kind.NAME,
            value: "__typename"
          }
        }])
      })
    });
  }
};
var F$1 = /* @__PURE__ */ new Map();
function formatDocument(n) {
  var r2 = keyDocument(n);
  var a2 = F$1.get(r2.__key);
  if (!a2) {
    a2 = visit$1(r2, {
      Field: formatNode,
      InlineFragment: formatNode
    });
    Object.defineProperty(a2, "__key", {
      value: r2.__key,
      enumerable: false
    });
    F$1.set(r2.__key, a2);
  }
  return a2;
}
function maskTypename(e) {
  if (!e || "object" != typeof e) {
    return e;
  }
  return Object.keys(e).reduce(function(n, r2) {
    var t2 = e[r2];
    if ("__typename" === r2) {
      Object.defineProperty(n, "__typename", {
        enumerable: false,
        value: t2
      });
    } else if (Array.isArray(t2)) {
      n[r2] = t2.map(maskTypename);
    } else if (t2 && "object" == typeof t2 && "__typename" in t2) {
      n[r2] = maskTypename(t2);
    } else {
      n[r2] = t2;
    }
    return n;
  }, Array.isArray(e) ? [] : {});
}
function withPromise(e) {
  e.toPromise = function() {
    return new Promise(function(n) {
      var r2 = N$1(function(e2) {
        if (!e2.stale && !e2.hasNext) {
          Promise.resolve().then(function() {
            r2.unsubscribe();
            n(e2);
          });
        }
      })(e);
    });
  };
  return e;
}
function makeOperation(e, n, r2) {
  if (!r2) {
    r2 = n.context;
  }
  return {
    key: n.key,
    query: n.query,
    variables: n.variables,
    kind: e,
    context: r2
  };
}
function addMetadata(e, n) {
  return makeOperation(e.kind, e, _extends$3({}, e.context, {
    meta: _extends$3({}, e.context.meta, n)
  }));
}
function noop$5() {
}
function applyDefinitions(e, r2, t2) {
  for (var a2 = 0; a2 < t2.length; a2++) {
    if (t2[a2].kind === Kind.FRAGMENT_DEFINITION) {
      var o2 = t2[a2].name.value;
      var i = stringifyDocument(t2[a2]);
      if (!e.has(o2)) {
        e.set(o2, i);
        r2.push(t2[a2]);
      }
    } else {
      r2.push(t2[a2]);
    }
  }
}
function gql() {
  var e = arguments;
  var r2 = /* @__PURE__ */ new Map();
  var a2 = [];
  var o2 = [];
  var i = Array.isArray(arguments[0]) ? arguments[0][0] : arguments[0] || "";
  for (var u2 = 1; u2 < arguments.length; u2++) {
    var c2 = e[u2];
    if (c2 && c2.definitions) {
      o2.push.apply(o2, c2.definitions);
    } else {
      i += c2;
    }
    i += e[0][u2];
  }
  applyDefinitions(r2, a2, keyDocument(i).definitions);
  applyDefinitions(r2, a2, o2);
  return keyDocument({
    kind: Kind.DOCUMENT,
    definitions: a2
  });
}
function shouldSkip(e) {
  var n = e.kind;
  return "mutation" !== n && "query" !== n;
}
function cacheExchange$1(e) {
  var n = e.forward;
  var r2 = e.client;
  e.dispatchDebug;
  var a2 = /* @__PURE__ */ new Map();
  var i = /* @__PURE__ */ Object.create(null);
  function mapTypeNames(e2) {
    var n2 = makeOperation(e2.kind, e2);
    n2.query = formatDocument(e2.query);
    return n2;
  }
  function isOperationCached(e2) {
    var n2 = e2.context.requestPolicy;
    return "query" === e2.kind && "network-only" !== n2 && ("cache-only" === n2 || a2.has(e2.key));
  }
  return function(e2) {
    var u2 = share$1(e2);
    var c2 = map$1$1(function(e3) {
      var n2 = a2.get(e3.key);
      var i2 = _extends$3({}, n2, {
        operation: addMetadata(e3, {
          cacheOutcome: n2 ? "hit" : "miss"
        })
      });
      if ("cache-and-network" === e3.context.requestPolicy) {
        i2.stale = true;
        reexecuteOperation(r2, e3);
      }
      return i2;
    })(filter$1(function(e3) {
      return !shouldSkip(e3) && isOperationCached(e3);
    })(u2));
    var s2 = H(function(e3) {
      var n2 = e3.operation;
      if (!n2) {
        return;
      }
      var o2 = collectTypesFromResponse(e3.data).concat(n2.context.additionalTypenames || []);
      if ("mutation" === e3.operation.kind) {
        var u3 = /* @__PURE__ */ new Set();
        for (var c3 = 0; c3 < o2.length; c3++) {
          var s3 = o2[c3];
          var f2 = i[s3] || (i[s3] = /* @__PURE__ */ new Set());
          f2.forEach(function(e4) {
            u3.add(e4);
          });
          f2.clear();
        }
        u3.forEach(function(e4) {
          if (a2.has(e4)) {
            n2 = a2.get(e4).operation;
            a2.delete(e4);
            reexecuteOperation(r2, n2);
          }
        });
      } else if ("query" === n2.kind && e3.data) {
        a2.set(n2.key, e3);
        for (var p2 = 0; p2 < o2.length; p2++) {
          var l2 = o2[p2];
          (i[l2] || (i[l2] = /* @__PURE__ */ new Set())).add(n2.key);
        }
      }
    })(n(filter$1(function(e3) {
      return "query" !== e3.kind || "cache-only" !== e3.context.requestPolicy;
    })(map$1$1(function(e3) {
      return addMetadata(e3, {
        cacheOutcome: "miss"
      });
    })(merge$1([map$1$1(mapTypeNames)(filter$1(function(e3) {
      return !shouldSkip(e3) && !isOperationCached(e3);
    })(u2)), filter$1(function(e3) {
      return shouldSkip(e3);
    })(u2)])))));
    return merge$1([c2, s2]);
  };
}
function reexecuteOperation(e, n) {
  return e.reexecuteOperation(makeOperation(n.kind, n, _extends$3({}, n.context, {
    requestPolicy: "network-only"
  })));
}
function subscriptionExchange(e) {
  var n = e.forwardSubscription;
  var t2 = e.enableAllOperations;
  return function(e2) {
    var a2 = e2.client;
    var i = e2.forward;
    function isSubscriptionOperation(e3) {
      var n2 = e3.kind;
      return "subscription" === n2 || !!t2 && ("query" === n2 || "mutation" === n2);
    }
    return function(e3) {
      var t3 = share$1(e3);
      var u2 = D$1(function(e4) {
        var i2 = e4.key;
        var u3 = filter$1(function(e5) {
          return "teardown" === e5.kind && e5.key === i2;
        })(t3);
        return takeUntil$1(u3)(function createSubscriptionSource(e5) {
          var t4 = n({
            key: e5.key.toString(36),
            query: print$1(e5.query),
            variables: e5.variables,
            context: _extends$3({}, e5.context)
          });
          return make$1(function(n2) {
            var r2 = n2.next;
            var o2 = n2.complete;
            var i3 = false;
            var u4;
            Promise.resolve().then(function() {
              if (i3) {
                return;
              }
              u4 = t4.subscribe({
                next: function(n3) {
                  return r2(makeResult(e5, n3));
                },
                error: function(n3) {
                  return r2(makeErrorResult(e5, n3));
                },
                complete: function() {
                  if (!i3) {
                    i3 = true;
                    if ("subscription" === e5.kind) {
                      a2.reexecuteOperation(makeOperation("teardown", e5, e5.context));
                    }
                    o2();
                  }
                }
              });
            });
            return function() {
              i3 = true;
              if (u4) {
                u4.unsubscribe();
              }
            };
          });
        }(e4));
      })(filter$1(isSubscriptionOperation)(t3));
      var c2 = i(filter$1(function(e4) {
        return !isSubscriptionOperation(e4);
      })(t3));
      return merge$1([u2, c2]);
    };
  };
}
function dedupExchange(e) {
  var n = e.forward;
  e.dispatchDebug;
  var t2 = /* @__PURE__ */ new Set();
  function filterIncomingOperation(e2) {
    var n2 = e2.key;
    var a2 = e2.kind;
    if ("teardown" === a2) {
      t2.delete(n2);
      return true;
    }
    if ("query" !== a2 && "subscription" !== a2) {
      return true;
    }
    var o2 = t2.has(n2);
    t2.add(n2);
    return !o2;
  }
  function afterOperationResult(e2) {
    if (!e2.hasNext) {
      t2.delete(e2.operation.key);
    }
  }
  return function(e2) {
    var r2 = filter$1(filterIncomingOperation)(e2);
    return H(afterOperationResult)(n(r2));
  };
}
function fetchExchange(e) {
  var n = e.forward;
  e.dispatchDebug;
  return function(e2) {
    var t2 = share$1(e2);
    var a2 = D$1(function(e3) {
      var n2 = e3.key;
      var a3 = filter$1(function(e4) {
        return "teardown" === e4.kind && e4.key === n2;
      })(t2);
      var o3 = makeFetchBody(e3);
      var i = makeFetchURL(e3, o3);
      var u2 = makeFetchOptions(e3, o3);
      return H(function(n3) {
        !n3.data ? n3.error : void 0;
      })(takeUntil$1(a3)(makeFetchSource(e3, i, u2)));
    })(filter$1(function(e3) {
      return "query" === e3.kind || "mutation" === e3.kind;
    })(t2));
    var o2 = n(filter$1(function(e3) {
      return "query" !== e3.kind && "mutation" !== e3.kind;
    })(t2));
    return merge$1([a2, o2]);
  };
}
function fallbackExchange(e) {
  e.dispatchDebug;
  return function(e2) {
    return filter$1(function() {
      return false;
    })(H(function(e3) {
      if ("teardown" !== e3.kind && false) {
        var r2 = 'No exchange has handled operations of kind "' + e3.kind + `". Check whether you've added an exchange responsible for these operations.`;
        console.warn(r2);
      }
    })(e2));
  };
}
fallbackExchange({
  dispatchDebug: noop$5
});
function composeExchanges(e) {
  return function(n) {
    var r2 = n.client;
    n.dispatchDebug;
    return e.reduceRight(function(e2, n2) {
      return n2({
        client: r2,
        forward: e2,
        dispatchDebug: function dispatchDebug$1(e3) {
        }
      });
    }, n.forward);
  };
}
function errorExchange(e) {
  var n = e.onError;
  return function(e2) {
    var r2 = e2.forward;
    return function(e3) {
      return H(function(e4) {
        var r3 = e4.error;
        if (r3) {
          n(r3, e4.operation);
        }
      })(r2(e3));
    };
  };
}
var L$1 = [dedupExchange, cacheExchange$1, fetchExchange];
var J = function Client(e) {
  var n = /* @__PURE__ */ new Map();
  var r2 = /* @__PURE__ */ new Map();
  var t2 = [];
  var a2 = makeSubject$1();
  var i = a2.source;
  var u2 = a2.next;
  var c2 = false;
  function dispatchOperation(e2) {
    c2 = true;
    if (e2) {
      u2(e2);
    }
    while (e2 = t2.shift()) {
      u2(e2);
    }
    c2 = false;
  }
  function makeResultSource(e2) {
    var a3 = filter$1(function(n2) {
      return n2.operation.kind === e2.kind && n2.operation.key === e2.key && (!n2.operation.context._instance || n2.operation.context._instance === e2.context._instance);
    })(y2);
    if (f2.maskTypename) {
      a3 = map$1$1(function(e3) {
        return _extends$3({}, e3, {
          data: maskTypename(e3.data)
        });
      })(a3);
    }
    if ("mutation" === e2.kind) {
      return take$1(1)(onStart$1(function() {
        return dispatchOperation(e2);
      })(a3));
    }
    return share$1(onEnd$1(function() {
      n.delete(e2.key);
      r2.delete(e2.key);
      for (var a4 = t2.length - 1; a4 >= 0; a4--) {
        if (t2[a4].key === e2.key) {
          t2.splice(a4, 1);
        }
      }
      dispatchOperation(makeOperation("teardown", e2, e2.context));
    })(H(function(r3) {
      n.set(e2.key, r3);
    })(K(function(n2) {
      if ("query" !== e2.kind || n2.stale) {
        return fromValue$1(n2);
      }
      return merge$1([fromValue$1(n2), map$1$1(function() {
        return _extends$3({}, n2, {
          stale: true
        });
      })(take$1(1)(filter$1(function(n3) {
        return "query" === n3.kind && n3.key === e2.key && "cache-only" !== n3.context.requestPolicy;
      })(i)))]);
    })(takeUntil$1(filter$1(function(n2) {
      return "teardown" === n2.kind && n2.key === e2.key;
    })(i))(a3)))));
  }
  var s2 = this instanceof Client ? this : Object.create(Client.prototype);
  var f2 = _extends$3(s2, {
    url: e.url,
    fetchOptions: e.fetchOptions,
    fetch: e.fetch,
    suspense: !!e.suspense,
    requestPolicy: e.requestPolicy || "cache-first",
    preferGetMethod: !!e.preferGetMethod,
    maskTypename: !!e.maskTypename,
    operations$: i,
    reexecuteOperation: function reexecuteOperation2(e2) {
      if ("mutation" === e2.kind || r2.has(e2.key)) {
        t2.push(e2);
        if (!c2) {
          Promise.resolve().then(dispatchOperation);
        }
      }
    },
    createOperationContext: function createOperationContext(e2) {
      if (!e2) {
        e2 = {};
      }
      return _extends$3({}, {
        _instance: void 0,
        url: f2.url,
        fetchOptions: f2.fetchOptions,
        fetch: f2.fetch,
        preferGetMethod: f2.preferGetMethod
      }, e2, {
        suspense: e2.suspense || false !== e2.suspense && f2.suspense,
        requestPolicy: e2.requestPolicy || f2.requestPolicy
      });
    },
    createRequestOperation: function createRequestOperation(e2, n2, r3) {
      getOperationType(n2.query);
      var a3 = f2.createOperationContext(r3);
      if ("mutation" === e2) {
        a3._instance = [];
      }
      return makeOperation(e2, n2, a3);
    },
    executeRequestOperation: function executeRequestOperation(e2) {
      if ("mutation" === e2.kind) {
        return makeResultSource(e2);
      }
      return make$1(function(t3) {
        var a3 = r2.get(e2.key);
        if (!a3) {
          r2.set(e2.key, a3 = makeResultSource(e2));
        }
        var i2 = "cache-and-network" === e2.context.requestPolicy || "network-only" === e2.context.requestPolicy;
        return N$1(t3.next)(onEnd$1(t3.complete)(onStart$1(function() {
          var r3 = n.get(e2.key);
          if ("subscription" === e2.kind) {
            return dispatchOperation(e2);
          } else if (i2) {
            dispatchOperation(e2);
          }
          if (null != r3 && r3 === n.get(e2.key)) {
            t3.next(i2 ? _extends$3({}, r3, {
              stale: true
            }) : r3);
          } else if (!i2) {
            dispatchOperation(e2);
          }
        })(a3))).unsubscribe;
      });
    },
    executeQuery: function executeQuery(e2, n2) {
      var r3 = f2.createRequestOperation("query", e2, n2);
      return f2.executeRequestOperation(r3);
    },
    executeSubscription: function executeSubscription(e2, n2) {
      var r3 = f2.createRequestOperation("subscription", e2, n2);
      return f2.executeRequestOperation(r3);
    },
    executeMutation: function executeMutation(e2, n2) {
      var r3 = f2.createRequestOperation("mutation", e2, n2);
      return f2.executeRequestOperation(r3);
    },
    query: function query2(e2, n2, r3) {
      if (!r3 || "boolean" != typeof r3.suspense) {
        r3 = _extends$3({}, r3, {
          suspense: false
        });
      }
      return withPromise(f2.executeQuery(createRequest(e2, n2), r3));
    },
    readQuery: function readQuery2(e2, n2, r3) {
      var t3 = null;
      N$1(function(e3) {
        t3 = e3;
      })(f2.query(e2, n2, r3)).unsubscribe();
      return t3;
    },
    subscription: function subscription(e2, n2, r3) {
      return f2.executeSubscription(createRequest(e2, n2), r3);
    },
    mutation: function mutation(e2, n2, r3) {
      return withPromise(f2.executeMutation(createRequest(e2, n2), r3));
    }
  });
  var p2 = noop$5;
  var h2 = composeExchanges(void 0 !== e.exchanges ? e.exchanges : L$1);
  var y2 = share$1(h2({
    client: f2,
    dispatchDebug: p2,
    forward: fallbackExchange({
      dispatchDebug: p2
    })
  })(i));
  publish$1(y2);
  return f2;
};
var W = J;
function _extends$2() {
  return (_extends$2 = Object.assign || function(e) {
    for (var u2 = 1; u2 < arguments.length; u2++) {
      var n = arguments[u2];
      for (var r2 in n) {
        if (Object.prototype.hasOwnProperty.call(n, r2)) {
          e[r2] = n[r2];
        }
      }
    }
    return e;
  }).apply(this, arguments);
}
function install(u2, t2) {
  var a2;
  if (!isRef(t2)) {
    a2 = ref(t2 instanceof J ? t2 : new J(t2));
  } else {
    a2 = t2;
  }
  u2.provide("$urql", a2);
}
function useClient() {
  var e = inject("$urql");
  return e;
}
function unwrapPossibleProxy(e) {
  return e && isRef(e) ? e.value : e;
}
var y = {
  flush: "pre"
};
function useQuery(e) {
  return callUseQuery(e);
}
function callUseQuery(e, t2, a2) {
  if (void 0 === t2) {
    t2 = useClient();
  }
  if (void 0 === a2) {
    a2 = [];
  }
  var i = reactive(e);
  var l2 = ref();
  var v = ref(false);
  var p2 = ref(false);
  var d2 = ref();
  var b2 = ref();
  var h2 = ref();
  var x2 = isRef(e.pause) ? e.pause : ref(!!e.pause);
  var w2 = ref(createRequest(i.query, unwrapPossibleProxy(i.variables)));
  var P = ref();
  a2.push(watchEffect(function() {
    var e2 = createRequest(i.query, unwrapPossibleProxy(i.variables));
    if (w2.value.key !== e2.key) {
      w2.value = e2;
    }
  }, y));
  a2.push(watchEffect(function() {
    P.value = !x2.value ? t2.value.executeQuery(w2.value, _extends$2({}, {
      requestPolicy: i.requestPolicy
    }, i.context)) : void 0;
  }, y));
  var Q = {
    data: l2,
    stale: v,
    error: d2,
    operation: b2,
    extensions: h2,
    fetching: p2,
    isPaused: x2,
    executeQuery: function executeQuery(e2) {
      var u2 = P.value = t2.value.executeQuery(w2.value, _extends$2({}, {
        requestPolicy: i.requestPolicy
      }, i.context, e2));
      return _extends$2({}, S2, {
        then: function then(e3, n) {
          return new Promise(function(e4) {
            var n2 = false;
            var r2 = N$1(function() {
              if (!Q.fetching.value && !Q.stale.value) {
                if (r2) {
                  r2.unsubscribe();
                }
                n2 = true;
                e4(Q);
              }
            })(u2);
            if (n2) {
              r2.unsubscribe();
            }
          }).then(e3, n);
        }
      });
    },
    pause: function pause() {
      x2.value = true;
    },
    resume: function resume() {
      x2.value = false;
    }
  };
  a2.push(watchEffect(function(e2) {
    if (P.value) {
      p2.value = true;
      v.value = false;
      e2(N$1(function(e3) {
        l2.value = e3.data;
        v.value = !!e3.stale;
        p2.value = false;
        d2.value = e3.error;
        b2.value = e3.operation;
        h2.value = e3.extensions;
      })(onEnd$1(function() {
        p2.value = false;
        v.value = false;
      })(P.value)).unsubscribe);
    } else {
      p2.value = false;
      v.value = false;
    }
  }, {
    flush: "sync"
  }));
  var S2 = _extends$2({}, Q, {
    then: function then(e2, u2) {
      return new Promise(function(e3) {
        if (!P.value) {
          return e3(Q);
        }
        var u3 = false;
        var n = N$1(function() {
          if (!Q.fetching.value && !Q.stale.value) {
            if (n) {
              n.unsubscribe();
            }
            u3 = true;
            e3(Q);
          }
        })(P.value);
        if (u3) {
          n.unsubscribe();
        }
      }).then(e2, u2);
    }
  });
  return S2;
}
function useMutation(e) {
  return callUseMutation(e);
}
function callUseMutation(e, n) {
  if (void 0 === n) {
    n = useClient();
  }
  var t2 = ref();
  var a2 = ref(false);
  var i = ref(false);
  var o2 = ref();
  var s2 = ref();
  var l2 = ref();
  return {
    data: t2,
    stale: a2,
    fetching: i,
    error: o2,
    operation: s2,
    extensions: l2,
    executeMutation: function executeMutation(r2, v) {
      i.value = true;
      return toPromise$1(take$1(1)(n.value.executeMutation(createRequest(e, unwrapPossibleProxy(r2)), v || {}))).then(function(e2) {
        t2.value = e2.data;
        a2.value = !!e2.stale;
        i.value = false;
        o2.value = e2.error;
        s2.value = e2.operation;
        l2.value = e2.extensions;
        return e2;
      });
    }
  };
}
var b$1 = {
  flush: "pre"
};
function useSubscription(e, u2) {
  return callUseSubscription(e, u2);
}
function callUseSubscription(e, t2, a2, i) {
  if (void 0 === a2) {
    a2 = useClient();
  }
  if (void 0 === i) {
    i = [];
  }
  var l2 = reactive(e);
  var v = ref();
  var p2 = ref(false);
  var d2 = ref(false);
  var y2 = ref();
  var h2 = ref();
  var x2 = ref();
  var w2 = ref(t2);
  var P = isRef(e.pause) ? e.pause : ref(!!e.pause);
  var Q = ref(createRequest(l2.query, unwrapPossibleProxy(l2.variables)));
  var S2 = ref();
  i.push(watchEffect(function() {
    var e2 = createRequest(l2.query, unwrapPossibleProxy(l2.variables));
    if (Q.value.key !== e2.key) {
      Q.value = e2;
    }
  }, b$1));
  i.push(watchEffect(function() {
    S2.value = !P.value ? a2.value.executeSubscription(Q.value, _extends$2({}, l2.context)) : void 0;
  }, b$1));
  i.push(watchEffect(function(e2) {
    if (S2.value) {
      d2.value = true;
      e2(N$1(function(e3) {
        d2.value = true;
        v.value = void 0 !== e3.data ? "function" == typeof w2.value ? w2.value(v.value, e3.data) : e3.data : e3.data, y2.value = e3.error;
        x2.value = e3.extensions;
        p2.value = !!e3.stale;
        h2.value = e3.operation;
      })(onEnd$1(function() {
        d2.value = false;
      })(S2.value)).unsubscribe);
    } else {
      d2.value = false;
    }
  }, b$1));
  var m2 = {
    data: v,
    stale: p2,
    error: y2,
    operation: h2,
    extensions: x2,
    fetching: d2,
    isPaused: P,
    executeSubscription: function executeSubscription(e2) {
      S2.value = a2.value.executeSubscription(Q.value, _extends$2({}, l2.context, e2));
      return m2;
    },
    pause: function pause() {
      P.value = true;
    },
    resume: function resume() {
      P.value = false;
    }
  };
  return m2;
}
const _hoisted_1$1x = {
  height: "1em",
  width: "1em",
  style: { "min-width": "16px", "min-height": "16px" },
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1o = /* @__PURE__ */ createBaseVNode("path", {
  "fill-rule": "evenodd",
  "clip-rule": "evenodd",
  d: "M2 8C2 4.68629 4.68629 2 8 2C11.3137 2 14 4.68629 14 8C14 11.3137 11.3137 14 8 14C4.68629 14 2 11.3137 2 8ZM8 0C3.58172 0 0 3.58172 0 8C0 12.4183 3.58172 16 8 16C12.4183 16 16 12.4183 16 8C16 3.58172 12.4183 0 8 0ZM9 5C9 4.44772 8.55228 4 8 4C7.44772 4 7 4.44772 7 5V8C7 8.55228 7.44772 9 8 9C8.55228 9 9 8.55228 9 8V5ZM8 12C8.55228 12 9 11.5523 9 11C9 10.4477 8.55228 10 8 10C7.44772 10 7 10.4477 7 11C7 11.5523 7.44772 12 8 12Z",
  fill: "#DB7903",
  class: "icon-dark"
}, null, -1);
const _hoisted_3$1c = [
  _hoisted_2$1o
];
function render$R(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1x, _hoisted_3$1c);
}
const __unplugin_components_1$8 = { name: "cy-errored-outline_x16", render: render$R };
const hasSymbol$1 = typeof Symbol === "function" && typeof Symbol.toStringTag === "symbol";
const makeSymbol = (name2) => hasSymbol$1 ? Symbol(name2) : name2;
const isNumber$2 = (val) => typeof val === "number" && isFinite(val);
const isRegExp$2 = (val) => toTypeString$1(val) === "[object RegExp]";
const isEmptyObject$1 = (val) => isPlainObject$3(val) && Object.keys(val).length === 0;
const assign$5 = Object.assign;
let _globalThis$1;
const getGlobalThis$1 = () => {
  return _globalThis$1 || (_globalThis$1 = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
};
const hasOwnProperty$2 = Object.prototype.hasOwnProperty;
function hasOwn(obj, key) {
  return hasOwnProperty$2.call(obj, key);
}
const isArray$1 = Array.isArray;
const isFunction$3 = (val) => typeof val === "function";
const isString$4 = (val) => typeof val === "string";
const isBoolean$1 = (val) => typeof val === "boolean";
const isObject$5 = (val) => val !== null && typeof val === "object";
const objectToString$1 = Object.prototype.toString;
const toTypeString$1 = (value) => objectToString$1.call(value);
const isPlainObject$3 = (val) => toTypeString$1(val) === "[object Object]";
const generateFormatCacheKey = (locale, key, source) => friendlyJSONstringify({ l: locale, k: key, s: source });
const friendlyJSONstringify = (json) => JSON.stringify(json).replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029").replace(/\u0027/g, "\\u0027");
const isNumber$1 = (val) => typeof val === "number" && isFinite(val);
const isDate = (val) => toTypeString(val) === "[object Date]";
const isRegExp$1 = (val) => toTypeString(val) === "[object RegExp]";
const isEmptyObject = (val) => isPlainObject$2(val) && Object.keys(val).length === 0;
function warn(msg, err) {
  if (typeof console !== "undefined") {
    console.warn(`[intlify] ` + msg);
    if (err) {
      console.warn(err.stack);
    }
  }
}
const assign$4 = Object.assign;
let _globalThis;
const getGlobalThis = () => {
  return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
};
function escapeHtml$2(rawText) {
  return rawText.replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&apos;");
}
const isArray = Array.isArray;
const isFunction$2 = (val) => typeof val === "function";
const isString$3 = (val) => typeof val === "string";
const isBoolean = (val) => typeof val === "boolean";
const isObject$4 = (val) => val !== null && typeof val === "object";
const objectToString = Object.prototype.toString;
const toTypeString = (value) => objectToString.call(value);
const isPlainObject$2 = (val) => toTypeString(val) === "[object Object]";
const toDisplayString = (val) => {
  return val == null ? "" : isArray(val) || isPlainObject$2(val) && val.toString === objectToString ? JSON.stringify(val, null, 2) : String(val);
};
const CompileErrorCodes = {
  EXPECTED_TOKEN: 1,
  INVALID_TOKEN_IN_PLACEHOLDER: 2,
  UNTERMINATED_SINGLE_QUOTE_IN_PLACEHOLDER: 3,
  UNKNOWN_ESCAPE_SEQUENCE: 4,
  INVALID_UNICODE_ESCAPE_SEQUENCE: 5,
  UNBALANCED_CLOSING_BRACE: 6,
  UNTERMINATED_CLOSING_BRACE: 7,
  EMPTY_PLACEHOLDER: 8,
  NOT_ALLOW_NEST_PLACEHOLDER: 9,
  INVALID_LINKED_FORMAT: 10,
  MUST_HAVE_MESSAGES_IN_PLURAL: 11,
  UNEXPECTED_EMPTY_LINKED_MODIFIER: 12,
  UNEXPECTED_EMPTY_LINKED_KEY: 13,
  UNEXPECTED_LEXICAL_ANALYSIS: 14,
  __EXTEND_POINT__: 15
};
function createCompileError(code3, loc, options2 = {}) {
  const { domain, messages, args } = options2;
  const msg = code3;
  const error2 = new SyntaxError(String(msg));
  error2.code = code3;
  if (loc) {
    error2.location = loc;
  }
  error2.domain = domain;
  return error2;
}
const IntlifyDevToolsHooks = {
  I18nInit: "i18n:init",
  FunctionTranslate: "function:translate"
};
const pathStateMachine = [];
pathStateMachine[0] = {
  ["w"]: [0],
  ["i"]: [3, 0],
  ["["]: [4],
  ["o"]: [7]
};
pathStateMachine[1] = {
  ["w"]: [1],
  ["."]: [2],
  ["["]: [4],
  ["o"]: [7]
};
pathStateMachine[2] = {
  ["w"]: [2],
  ["i"]: [3, 0],
  ["0"]: [3, 0]
};
pathStateMachine[3] = {
  ["i"]: [3, 0],
  ["0"]: [3, 0],
  ["w"]: [1, 1],
  ["."]: [2, 1],
  ["["]: [4, 1],
  ["o"]: [7, 1]
};
pathStateMachine[4] = {
  ["'"]: [5, 0],
  ['"']: [6, 0],
  ["["]: [
    4,
    2
  ],
  ["]"]: [1, 3],
  ["o"]: 8,
  ["l"]: [4, 0]
};
pathStateMachine[5] = {
  ["'"]: [4, 0],
  ["o"]: 8,
  ["l"]: [5, 0]
};
pathStateMachine[6] = {
  ['"']: [4, 0],
  ["o"]: 8,
  ["l"]: [6, 0]
};
const literalValueRE = /^\s?(?:true|false|-?[\d.]+|'[^']*'|"[^"]*")\s?$/;
function isLiteral(exp) {
  return literalValueRE.test(exp);
}
function stripQuotes(str) {
  const a2 = str.charCodeAt(0);
  const b2 = str.charCodeAt(str.length - 1);
  return a2 === b2 && (a2 === 34 || a2 === 39) ? str.slice(1, -1) : str;
}
function getPathCharType(ch) {
  if (ch === void 0 || ch === null) {
    return "o";
  }
  const code3 = ch.charCodeAt(0);
  switch (code3) {
    case 91:
    case 93:
    case 46:
    case 34:
    case 39:
      return ch;
    case 95:
    case 36:
    case 45:
      return "i";
    case 9:
    case 10:
    case 13:
    case 160:
    case 65279:
    case 8232:
    case 8233:
      return "w";
  }
  return "i";
}
function formatSubPath(path) {
  const trimmed = path.trim();
  if (path.charAt(0) === "0" && isNaN(parseInt(path))) {
    return false;
  }
  return isLiteral(trimmed) ? stripQuotes(trimmed) : "*" + trimmed;
}
function parse$3(path) {
  const keys = [];
  let index2 = -1;
  let mode = 0;
  let subPathDepth = 0;
  let c2;
  let key;
  let newChar;
  let type2;
  let transition;
  let action3;
  let typeMap;
  const actions = [];
  actions[0] = () => {
    if (key === void 0) {
      key = newChar;
    } else {
      key += newChar;
    }
  };
  actions[1] = () => {
    if (key !== void 0) {
      keys.push(key);
      key = void 0;
    }
  };
  actions[2] = () => {
    actions[0]();
    subPathDepth++;
  };
  actions[3] = () => {
    if (subPathDepth > 0) {
      subPathDepth--;
      mode = 4;
      actions[0]();
    } else {
      subPathDepth = 0;
      if (key === void 0) {
        return false;
      }
      key = formatSubPath(key);
      if (key === false) {
        return false;
      } else {
        actions[1]();
      }
    }
  };
  function maybeUnescapeQuote() {
    const nextChar = path[index2 + 1];
    if (mode === 5 && nextChar === "'" || mode === 6 && nextChar === '"') {
      index2++;
      newChar = "\\" + nextChar;
      actions[0]();
      return true;
    }
  }
  while (mode !== null) {
    index2++;
    c2 = path[index2];
    if (c2 === "\\" && maybeUnescapeQuote()) {
      continue;
    }
    type2 = getPathCharType(c2);
    typeMap = pathStateMachine[mode];
    transition = typeMap[type2] || typeMap["l"] || 8;
    if (transition === 8) {
      return;
    }
    mode = transition[0];
    if (transition[1] !== void 0) {
      action3 = actions[transition[1]];
      if (action3) {
        newChar = c2;
        if (action3() === false) {
          return;
        }
      }
    }
    if (mode === 7) {
      return keys;
    }
  }
}
const cache$1 = /* @__PURE__ */ new Map();
function resolveWithKeyValue(obj, path) {
  return isObject$4(obj) ? obj[path] : null;
}
function resolveValue(obj, path) {
  if (!isObject$4(obj)) {
    return null;
  }
  let hit = cache$1.get(path);
  if (!hit) {
    hit = parse$3(path);
    if (hit) {
      cache$1.set(path, hit);
    }
  }
  if (!hit) {
    return null;
  }
  const len = hit.length;
  let last = obj;
  let i = 0;
  while (i < len) {
    const val = last[hit[i]];
    if (val === void 0) {
      return null;
    }
    last = val;
    i++;
  }
  return last;
}
const DEFAULT_MODIFIER = (str) => str;
const DEFAULT_MESSAGE = (ctx) => "";
const DEFAULT_MESSAGE_DATA_TYPE = "text";
const DEFAULT_NORMALIZE = (values) => values.length === 0 ? "" : values.join("");
const DEFAULT_INTERPOLATE = toDisplayString;
function pluralDefault(choice, choicesLength) {
  choice = Math.abs(choice);
  if (choicesLength === 2) {
    return choice ? choice > 1 ? 1 : 0 : 1;
  }
  return choice ? Math.min(choice, 2) : 0;
}
function getPluralIndex(options2) {
  const index2 = isNumber$1(options2.pluralIndex) ? options2.pluralIndex : -1;
  return options2.named && (isNumber$1(options2.named.count) || isNumber$1(options2.named.n)) ? isNumber$1(options2.named.count) ? options2.named.count : isNumber$1(options2.named.n) ? options2.named.n : index2 : index2;
}
function normalizeNamed(pluralIndex, props) {
  if (!props.count) {
    props.count = pluralIndex;
  }
  if (!props.n) {
    props.n = pluralIndex;
  }
}
function createMessageContext(options2 = {}) {
  const locale = options2.locale;
  const pluralIndex = getPluralIndex(options2);
  const pluralRule = isObject$4(options2.pluralRules) && isString$3(locale) && isFunction$2(options2.pluralRules[locale]) ? options2.pluralRules[locale] : pluralDefault;
  const orgPluralRule = isObject$4(options2.pluralRules) && isString$3(locale) && isFunction$2(options2.pluralRules[locale]) ? pluralDefault : void 0;
  const plural = (messages) => messages[pluralRule(pluralIndex, messages.length, orgPluralRule)];
  const _list = options2.list || [];
  const list3 = (index2) => _list[index2];
  const _named = options2.named || {};
  isNumber$1(options2.pluralIndex) && normalizeNamed(pluralIndex, _named);
  const named = (key) => _named[key];
  function message(key) {
    const msg = isFunction$2(options2.messages) ? options2.messages(key) : isObject$4(options2.messages) ? options2.messages[key] : false;
    return !msg ? options2.parent ? options2.parent.message(key) : DEFAULT_MESSAGE : msg;
  }
  const _modifier = (name2) => options2.modifiers ? options2.modifiers[name2] : DEFAULT_MODIFIER;
  const normalize4 = isPlainObject$2(options2.processor) && isFunction$2(options2.processor.normalize) ? options2.processor.normalize : DEFAULT_NORMALIZE;
  const interpolate = isPlainObject$2(options2.processor) && isFunction$2(options2.processor.interpolate) ? options2.processor.interpolate : DEFAULT_INTERPOLATE;
  const type2 = isPlainObject$2(options2.processor) && isString$3(options2.processor.type) ? options2.processor.type : DEFAULT_MESSAGE_DATA_TYPE;
  const ctx = {
    ["list"]: list3,
    ["named"]: named,
    ["plural"]: plural,
    ["linked"]: (key, modifier) => {
      const msg = message(key)(ctx);
      return isString$3(modifier) ? _modifier(modifier)(msg) : msg;
    },
    ["message"]: message,
    ["type"]: type2,
    ["interpolate"]: interpolate,
    ["normalize"]: normalize4
  };
  return ctx;
}
let devtools = null;
function setDevToolsHook(hook) {
  devtools = hook;
}
function initI18nDevTools(i18n, version2, meta) {
  devtools && devtools.emit(IntlifyDevToolsHooks.I18nInit, {
    timestamp: Date.now(),
    i18n,
    version: version2,
    meta
  });
}
const translateDevTools = /* @__PURE__ */ createDevToolsHook(IntlifyDevToolsHooks.FunctionTranslate);
function createDevToolsHook(hook) {
  return (payloads) => devtools && devtools.emit(hook, payloads);
}
const CoreWarnCodes = {
  NOT_FOUND_KEY: 1,
  FALLBACK_TO_TRANSLATE: 2,
  CANNOT_FORMAT_NUMBER: 3,
  FALLBACK_TO_NUMBER_FORMAT: 4,
  CANNOT_FORMAT_DATE: 5,
  FALLBACK_TO_DATE_FORMAT: 6,
  __EXTEND_POINT__: 7
};
function fallbackWithSimple(ctx, fallback, start2) {
  return [.../* @__PURE__ */ new Set([
    start2,
    ...isArray(fallback) ? fallback : isObject$4(fallback) ? Object.keys(fallback) : isString$3(fallback) ? [fallback] : [start2]
  ])];
}
function fallbackWithLocaleChain(ctx, fallback, start2) {
  const startLocale = isString$3(start2) ? start2 : DEFAULT_LOCALE;
  const context = ctx;
  if (!context.__localeChainCache) {
    context.__localeChainCache = /* @__PURE__ */ new Map();
  }
  let chain = context.__localeChainCache.get(startLocale);
  if (!chain) {
    chain = [];
    let block3 = [start2];
    while (isArray(block3)) {
      block3 = appendBlockToChain(chain, block3, fallback);
    }
    const defaults2 = isArray(fallback) || !isPlainObject$2(fallback) ? fallback : fallback["default"] ? fallback["default"] : null;
    block3 = isString$3(defaults2) ? [defaults2] : defaults2;
    if (isArray(block3)) {
      appendBlockToChain(chain, block3, false);
    }
    context.__localeChainCache.set(startLocale, chain);
  }
  return chain;
}
function appendBlockToChain(chain, block3, blocks) {
  let follow = true;
  for (let i = 0; i < block3.length && isBoolean(follow); i++) {
    const locale = block3[i];
    if (isString$3(locale)) {
      follow = appendLocaleToChain(chain, block3[i], blocks);
    }
  }
  return follow;
}
function appendLocaleToChain(chain, locale, blocks) {
  let follow;
  const tokens = locale.split("-");
  do {
    const target2 = tokens.join("-");
    follow = appendItemToChain(chain, target2, blocks);
    tokens.splice(-1, 1);
  } while (tokens.length && follow === true);
  return follow;
}
function appendItemToChain(chain, target2, blocks) {
  let follow = false;
  if (!chain.includes(target2)) {
    follow = true;
    if (target2) {
      follow = target2[target2.length - 1] !== "!";
      const locale = target2.replace(/!/g, "");
      chain.push(locale);
      if ((isArray(blocks) || isPlainObject$2(blocks)) && blocks[locale]) {
        follow = blocks[locale];
      }
    }
  }
  return follow;
}
const VERSION$1 = "9.2.0-beta.7";
const NOT_REOSLVED = -1;
const DEFAULT_LOCALE = "en-US";
const MISSING_RESOLVE_VALUE = "";
function getDefaultLinkedModifiers() {
  return {
    upper: (val) => isString$3(val) ? val.toUpperCase() : val,
    lower: (val) => isString$3(val) ? val.toLowerCase() : val,
    capitalize: (val) => isString$3(val) ? `${val.charAt(0).toLocaleUpperCase()}${val.substr(1)}` : val
  };
}
let _compiler;
let _resolver;
function registerMessageResolver(resolver) {
  _resolver = resolver;
}
let _fallbacker;
function registerLocaleFallbacker(fallbacker) {
  _fallbacker = fallbacker;
}
let _additionalMeta = null;
const setAdditionalMeta = (meta) => {
  _additionalMeta = meta;
};
const getAdditionalMeta = () => _additionalMeta;
let _cid = 0;
function createCoreContext(options2 = {}) {
  const version2 = isString$3(options2.version) ? options2.version : VERSION$1;
  const locale = isString$3(options2.locale) ? options2.locale : DEFAULT_LOCALE;
  const fallbackLocale = isArray(options2.fallbackLocale) || isPlainObject$2(options2.fallbackLocale) || isString$3(options2.fallbackLocale) || options2.fallbackLocale === false ? options2.fallbackLocale : locale;
  const messages = isPlainObject$2(options2.messages) ? options2.messages : { [locale]: {} };
  const datetimeFormats = isPlainObject$2(options2.datetimeFormats) ? options2.datetimeFormats : { [locale]: {} };
  const numberFormats = isPlainObject$2(options2.numberFormats) ? options2.numberFormats : { [locale]: {} };
  const modifiers = assign$4({}, options2.modifiers || {}, getDefaultLinkedModifiers());
  const pluralRules = options2.pluralRules || {};
  const missing = isFunction$2(options2.missing) ? options2.missing : null;
  const missingWarn = isBoolean(options2.missingWarn) || isRegExp$1(options2.missingWarn) ? options2.missingWarn : true;
  const fallbackWarn = isBoolean(options2.fallbackWarn) || isRegExp$1(options2.fallbackWarn) ? options2.fallbackWarn : true;
  const fallbackFormat = !!options2.fallbackFormat;
  const unresolving = !!options2.unresolving;
  const postTranslation = isFunction$2(options2.postTranslation) ? options2.postTranslation : null;
  const processor = isPlainObject$2(options2.processor) ? options2.processor : null;
  const warnHtmlMessage = isBoolean(options2.warnHtmlMessage) ? options2.warnHtmlMessage : true;
  const escapeParameter = !!options2.escapeParameter;
  const messageCompiler = isFunction$2(options2.messageCompiler) ? options2.messageCompiler : _compiler;
  const messageResolver = isFunction$2(options2.messageResolver) ? options2.messageResolver : _resolver || resolveWithKeyValue;
  const localeFallbacker = isFunction$2(options2.localeFallbacker) ? options2.localeFallbacker : _fallbacker || fallbackWithSimple;
  const onWarn = isFunction$2(options2.onWarn) ? options2.onWarn : warn;
  const internalOptions = options2;
  const __datetimeFormatters = isObject$4(internalOptions.__datetimeFormatters) ? internalOptions.__datetimeFormatters : /* @__PURE__ */ new Map();
  const __numberFormatters = isObject$4(internalOptions.__numberFormatters) ? internalOptions.__numberFormatters : /* @__PURE__ */ new Map();
  const __meta = isObject$4(internalOptions.__meta) ? internalOptions.__meta : {};
  _cid++;
  const context = {
    version: version2,
    cid: _cid,
    locale,
    fallbackLocale,
    messages,
    modifiers,
    pluralRules,
    missing,
    missingWarn,
    fallbackWarn,
    fallbackFormat,
    unresolving,
    postTranslation,
    processor,
    warnHtmlMessage,
    escapeParameter,
    messageCompiler,
    messageResolver,
    localeFallbacker,
    onWarn,
    __meta
  };
  {
    context.datetimeFormats = datetimeFormats;
    context.numberFormats = numberFormats;
    context.__datetimeFormatters = __datetimeFormatters;
    context.__numberFormatters = __numberFormatters;
  }
  if (__INTLIFY_PROD_DEVTOOLS__) {
    initI18nDevTools(context, version2, __meta);
  }
  return context;
}
function handleMissing(context, key, locale, missingWarn, type2) {
  const { missing, onWarn } = context;
  if (missing !== null) {
    const ret = missing(context, locale, key, type2);
    return isString$3(ret) ? ret : key;
  } else {
    return key;
  }
}
function updateFallbackLocale(ctx, locale, fallback) {
  const context = ctx;
  context.__localeChainCache = /* @__PURE__ */ new Map();
  ctx.localeFallbacker(ctx, fallback, locale);
}
let code$2 = CompileErrorCodes.__EXTEND_POINT__;
const inc$1 = () => code$2++;
const CoreErrorCodes = {
  INVALID_ARGUMENT: code$2,
  INVALID_DATE_ARGUMENT: inc$1(),
  INVALID_ISO_DATE_ARGUMENT: inc$1(),
  __EXTEND_POINT__: inc$1()
};
function createCoreError(code3) {
  return createCompileError(code3, null, void 0);
}
const NOOP_MESSAGE_FUNCTION = () => "";
const isMessageFunction = (val) => isFunction$2(val);
function translate(context, ...args) {
  const { fallbackFormat, postTranslation, unresolving, fallbackLocale, messages } = context;
  const [key, options2] = parseTranslateArgs(...args);
  const missingWarn = isBoolean(options2.missingWarn) ? options2.missingWarn : context.missingWarn;
  const fallbackWarn = isBoolean(options2.fallbackWarn) ? options2.fallbackWarn : context.fallbackWarn;
  const escapeParameter = isBoolean(options2.escapeParameter) ? options2.escapeParameter : context.escapeParameter;
  const resolvedMessage = !!options2.resolvedMessage;
  const defaultMsgOrKey = isString$3(options2.default) || isBoolean(options2.default) ? !isBoolean(options2.default) ? options2.default : key : fallbackFormat ? key : "";
  const enableDefaultMsg = fallbackFormat || defaultMsgOrKey !== "";
  const locale = isString$3(options2.locale) ? options2.locale : context.locale;
  escapeParameter && escapeParams(options2);
  let [format3, targetLocale, message] = !resolvedMessage ? resolveMessageFormat(context, key, locale, fallbackLocale, fallbackWarn, missingWarn) : [
    key,
    locale,
    messages[locale] || {}
  ];
  let cacheBaseKey = key;
  if (!resolvedMessage && !(isString$3(format3) || isMessageFunction(format3))) {
    if (enableDefaultMsg) {
      format3 = defaultMsgOrKey;
      cacheBaseKey = format3;
    }
  }
  if (!resolvedMessage && (!(isString$3(format3) || isMessageFunction(format3)) || !isString$3(targetLocale))) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let occurred = false;
  const errorDetector = () => {
    occurred = true;
  };
  const msg = !isMessageFunction(format3) ? compileMessageFormat(context, key, targetLocale, format3, cacheBaseKey, errorDetector) : format3;
  if (occurred) {
    return format3;
  }
  const ctxOptions = getMessageContextOptions(context, targetLocale, message, options2);
  const msgContext = createMessageContext(ctxOptions);
  const messaged = evaluateMessage(context, msg, msgContext);
  const ret = postTranslation ? postTranslation(messaged) : messaged;
  if (__INTLIFY_PROD_DEVTOOLS__) {
    const payloads = {
      timestamp: Date.now(),
      key: isString$3(key) ? key : isMessageFunction(format3) ? format3.key : "",
      locale: targetLocale || (isMessageFunction(format3) ? format3.locale : ""),
      format: isString$3(format3) ? format3 : isMessageFunction(format3) ? format3.source : "",
      message: ret
    };
    payloads.meta = assign$4({}, context.__meta, getAdditionalMeta() || {});
    translateDevTools(payloads);
  }
  return ret;
}
function escapeParams(options2) {
  if (isArray(options2.list)) {
    options2.list = options2.list.map((item) => isString$3(item) ? escapeHtml$2(item) : item);
  } else if (isObject$4(options2.named)) {
    Object.keys(options2.named).forEach((key) => {
      if (isString$3(options2.named[key])) {
        options2.named[key] = escapeHtml$2(options2.named[key]);
      }
    });
  }
}
function resolveMessageFormat(context, key, locale, fallbackLocale, fallbackWarn, missingWarn) {
  const { messages, onWarn, messageResolver: resolveValue2, localeFallbacker } = context;
  const locales = localeFallbacker(context, fallbackLocale, locale);
  let message = {};
  let targetLocale;
  let format3 = null;
  const type2 = "translate";
  for (let i = 0; i < locales.length; i++) {
    targetLocale = locales[i];
    message = messages[targetLocale] || {};
    if ((format3 = resolveValue2(message, key)) === null) {
      format3 = message[key];
    }
    if (isString$3(format3) || isFunction$2(format3))
      break;
    const missingRet = handleMissing(
      context,
      key,
      targetLocale,
      missingWarn,
      type2
    );
    if (missingRet !== key) {
      format3 = missingRet;
    }
  }
  return [format3, targetLocale, message];
}
function compileMessageFormat(context, key, targetLocale, format3, cacheBaseKey, errorDetector) {
  const { messageCompiler, warnHtmlMessage } = context;
  if (isMessageFunction(format3)) {
    const msg2 = format3;
    msg2.locale = msg2.locale || targetLocale;
    msg2.key = msg2.key || key;
    return msg2;
  }
  const msg = messageCompiler(format3, getCompileOptions(context, targetLocale, cacheBaseKey, format3, warnHtmlMessage, errorDetector));
  msg.locale = targetLocale;
  msg.key = key;
  msg.source = format3;
  return msg;
}
function evaluateMessage(context, msg, msgCtx) {
  const messaged = msg(msgCtx);
  return messaged;
}
function parseTranslateArgs(...args) {
  const [arg1, arg2, arg3] = args;
  const options2 = {};
  if (!isString$3(arg1) && !isNumber$1(arg1) && !isMessageFunction(arg1)) {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  const key = isNumber$1(arg1) ? String(arg1) : isMessageFunction(arg1) ? arg1 : arg1;
  if (isNumber$1(arg2)) {
    options2.plural = arg2;
  } else if (isString$3(arg2)) {
    options2.default = arg2;
  } else if (isPlainObject$2(arg2) && !isEmptyObject(arg2)) {
    options2.named = arg2;
  } else if (isArray(arg2)) {
    options2.list = arg2;
  }
  if (isNumber$1(arg3)) {
    options2.plural = arg3;
  } else if (isString$3(arg3)) {
    options2.default = arg3;
  } else if (isPlainObject$2(arg3)) {
    assign$4(options2, arg3);
  }
  return [key, options2];
}
function getCompileOptions(context, locale, key, source, warnHtmlMessage, errorDetector) {
  return {
    warnHtmlMessage,
    onError: (err) => {
      errorDetector && errorDetector(err);
      {
        throw err;
      }
    },
    onCacheKey: (source2) => generateFormatCacheKey(locale, key, source2)
  };
}
function getMessageContextOptions(context, locale, message, options2) {
  const { modifiers, pluralRules, messageResolver: resolveValue2 } = context;
  const resolveMessage = (key) => {
    const val = resolveValue2(message, key);
    if (isString$3(val)) {
      let occurred = false;
      const errorDetector = () => {
        occurred = true;
      };
      const msg = compileMessageFormat(context, key, locale, val, key, errorDetector);
      return !occurred ? msg : NOOP_MESSAGE_FUNCTION;
    } else if (isMessageFunction(val)) {
      return val;
    } else {
      return NOOP_MESSAGE_FUNCTION;
    }
  };
  const ctxOptions = {
    locale,
    modifiers,
    pluralRules,
    messages: resolveMessage
  };
  if (context.processor) {
    ctxOptions.processor = context.processor;
  }
  if (options2.list) {
    ctxOptions.list = options2.list;
  }
  if (options2.named) {
    ctxOptions.named = options2.named;
  }
  if (isNumber$1(options2.plural)) {
    ctxOptions.pluralIndex = options2.plural;
  }
  return ctxOptions;
}
function datetime(context, ...args) {
  const { datetimeFormats, unresolving, fallbackLocale, onWarn, localeFallbacker } = context;
  const { __datetimeFormatters } = context;
  const [key, value, options2, overrides] = parseDateTimeArgs(...args);
  const missingWarn = isBoolean(options2.missingWarn) ? options2.missingWarn : context.missingWarn;
  isBoolean(options2.fallbackWarn) ? options2.fallbackWarn : context.fallbackWarn;
  const part2 = !!options2.part;
  const locale = isString$3(options2.locale) ? options2.locale : context.locale;
  const locales = localeFallbacker(
    context,
    fallbackLocale,
    locale
  );
  if (!isString$3(key) || key === "") {
    return new Intl.DateTimeFormat(locale).format(value);
  }
  let datetimeFormat = {};
  let targetLocale;
  let format3 = null;
  const type2 = "datetime format";
  for (let i = 0; i < locales.length; i++) {
    targetLocale = locales[i];
    datetimeFormat = datetimeFormats[targetLocale] || {};
    format3 = datetimeFormat[key];
    if (isPlainObject$2(format3))
      break;
    handleMissing(context, key, targetLocale, missingWarn, type2);
  }
  if (!isPlainObject$2(format3) || !isString$3(targetLocale)) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let id2 = `${targetLocale}__${key}`;
  if (!isEmptyObject(overrides)) {
    id2 = `${id2}__${JSON.stringify(overrides)}`;
  }
  let formatter = __datetimeFormatters.get(id2);
  if (!formatter) {
    formatter = new Intl.DateTimeFormat(targetLocale, assign$4({}, format3, overrides));
    __datetimeFormatters.set(id2, formatter);
  }
  return !part2 ? formatter.format(value) : formatter.formatToParts(value);
}
function parseDateTimeArgs(...args) {
  const [arg1, arg2, arg3, arg4] = args;
  let options2 = {};
  let overrides = {};
  let value;
  if (isString$3(arg1)) {
    const matches2 = arg1.match(/(\d{4}-\d{2}-\d{2})(T|\s)?(.*)/);
    if (!matches2) {
      throw createCoreError(CoreErrorCodes.INVALID_ISO_DATE_ARGUMENT);
    }
    const dateTime = matches2[3] ? matches2[3].trim().startsWith("T") ? `${matches2[1].trim()}${matches2[3].trim()}` : `${matches2[1].trim()}T${matches2[3].trim()}` : matches2[1].trim();
    value = new Date(dateTime);
    try {
      value.toISOString();
    } catch (e) {
      throw createCoreError(CoreErrorCodes.INVALID_ISO_DATE_ARGUMENT);
    }
  } else if (isDate(arg1)) {
    if (isNaN(arg1.getTime())) {
      throw createCoreError(CoreErrorCodes.INVALID_DATE_ARGUMENT);
    }
    value = arg1;
  } else if (isNumber$1(arg1)) {
    value = arg1;
  } else {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  if (isString$3(arg2)) {
    options2.key = arg2;
  } else if (isPlainObject$2(arg2)) {
    options2 = arg2;
  }
  if (isString$3(arg3)) {
    options2.locale = arg3;
  } else if (isPlainObject$2(arg3)) {
    overrides = arg3;
  }
  if (isPlainObject$2(arg4)) {
    overrides = arg4;
  }
  return [options2.key || "", value, options2, overrides];
}
function clearDateTimeFormat(ctx, locale, format3) {
  const context = ctx;
  for (const key in format3) {
    const id2 = `${locale}__${key}`;
    if (!context.__datetimeFormatters.has(id2)) {
      continue;
    }
    context.__datetimeFormatters.delete(id2);
  }
}
function number(context, ...args) {
  const { numberFormats, unresolving, fallbackLocale, onWarn, localeFallbacker } = context;
  const { __numberFormatters } = context;
  const [key, value, options2, overrides] = parseNumberArgs(...args);
  const missingWarn = isBoolean(options2.missingWarn) ? options2.missingWarn : context.missingWarn;
  isBoolean(options2.fallbackWarn) ? options2.fallbackWarn : context.fallbackWarn;
  const part2 = !!options2.part;
  const locale = isString$3(options2.locale) ? options2.locale : context.locale;
  const locales = localeFallbacker(
    context,
    fallbackLocale,
    locale
  );
  if (!isString$3(key) || key === "") {
    return new Intl.NumberFormat(locale).format(value);
  }
  let numberFormat = {};
  let targetLocale;
  let format3 = null;
  const type2 = "number format";
  for (let i = 0; i < locales.length; i++) {
    targetLocale = locales[i];
    numberFormat = numberFormats[targetLocale] || {};
    format3 = numberFormat[key];
    if (isPlainObject$2(format3))
      break;
    handleMissing(context, key, targetLocale, missingWarn, type2);
  }
  if (!isPlainObject$2(format3) || !isString$3(targetLocale)) {
    return unresolving ? NOT_REOSLVED : key;
  }
  let id2 = `${targetLocale}__${key}`;
  if (!isEmptyObject(overrides)) {
    id2 = `${id2}__${JSON.stringify(overrides)}`;
  }
  let formatter = __numberFormatters.get(id2);
  if (!formatter) {
    formatter = new Intl.NumberFormat(targetLocale, assign$4({}, format3, overrides));
    __numberFormatters.set(id2, formatter);
  }
  return !part2 ? formatter.format(value) : formatter.formatToParts(value);
}
function parseNumberArgs(...args) {
  const [arg1, arg2, arg3, arg4] = args;
  let options2 = {};
  let overrides = {};
  if (!isNumber$1(arg1)) {
    throw createCoreError(CoreErrorCodes.INVALID_ARGUMENT);
  }
  const value = arg1;
  if (isString$3(arg2)) {
    options2.key = arg2;
  } else if (isPlainObject$2(arg2)) {
    options2 = arg2;
  }
  if (isString$3(arg3)) {
    options2.locale = arg3;
  } else if (isPlainObject$2(arg3)) {
    overrides = arg3;
  }
  if (isPlainObject$2(arg4)) {
    overrides = arg4;
  }
  return [options2.key || "", value, options2, overrides];
}
function clearNumberFormat(ctx, locale, format3) {
  const context = ctx;
  for (const key in format3) {
    const id2 = `${locale}__${key}`;
    if (!context.__numberFormatters.has(id2)) {
      continue;
    }
    context.__numberFormatters.delete(id2);
  }
}
{
  if (typeof __INTLIFY_PROD_DEVTOOLS__ !== "boolean") {
    getGlobalThis().__INTLIFY_PROD_DEVTOOLS__ = false;
  }
}
const VERSION = "9.2.0-beta.7";
function initFeatureFlags() {
  if (typeof __INTLIFY_PROD_DEVTOOLS__ !== "boolean") {
    getGlobalThis$1().__INTLIFY_PROD_DEVTOOLS__ = false;
  }
}
CoreWarnCodes.__EXTEND_POINT__;
let code$1 = CompileErrorCodes.__EXTEND_POINT__;
const inc = () => code$1++;
const I18nErrorCodes = {
  UNEXPECTED_RETURN_TYPE: code$1,
  INVALID_ARGUMENT: inc(),
  MUST_BE_CALL_SETUP_TOP: inc(),
  NOT_INSLALLED: inc(),
  NOT_AVAILABLE_IN_LEGACY_MODE: inc(),
  REQUIRED_VALUE: inc(),
  INVALID_VALUE: inc(),
  CANNOT_SETUP_VUE_DEVTOOLS_PLUGIN: inc(),
  NOT_INSLALLED_WITH_PROVIDE: inc(),
  UNEXPECTED_ERROR: inc(),
  NOT_COMPATIBLE_LEGACY_VUE_I18N: inc(),
  BRIDGE_SUPPORT_VUE_2_ONLY: inc(),
  __EXTEND_POINT__: inc()
};
function createI18nError(code3, ...args) {
  return createCompileError(code3, null, void 0);
}
const TransrateVNodeSymbol = /* @__PURE__ */ makeSymbol("__transrateVNode");
const DatetimePartsSymbol = /* @__PURE__ */ makeSymbol("__datetimeParts");
const NumberPartsSymbol = /* @__PURE__ */ makeSymbol("__numberParts");
const SetPluralRulesSymbol = makeSymbol("__setPluralRules");
makeSymbol("__intlifyMeta");
function handleFlatJson(obj) {
  if (!isObject$5(obj)) {
    return obj;
  }
  for (const key in obj) {
    if (!hasOwn(obj, key)) {
      continue;
    }
    if (!key.includes(".")) {
      if (isObject$5(obj[key])) {
        handleFlatJson(obj[key]);
      }
    } else {
      const subKeys = key.split(".");
      const lastIndex = subKeys.length - 1;
      let currentObj = obj;
      for (let i = 0; i < lastIndex; i++) {
        if (!(subKeys[i] in currentObj)) {
          currentObj[subKeys[i]] = {};
        }
        currentObj = currentObj[subKeys[i]];
      }
      currentObj[subKeys[lastIndex]] = obj[key];
      delete obj[key];
      if (isObject$5(currentObj[subKeys[lastIndex]])) {
        handleFlatJson(currentObj[subKeys[lastIndex]]);
      }
    }
  }
  return obj;
}
function getLocaleMessages(locale, options2) {
  const { messages, __i18n, messageResolver, flatJson } = options2;
  const ret = isPlainObject$3(messages) ? messages : isArray$1(__i18n) ? {} : { [locale]: {} };
  if (isArray$1(__i18n)) {
    __i18n.forEach((custom) => {
      if ("locale" in custom && "resource" in custom) {
        const { locale: locale2, resource } = custom;
        if (locale2) {
          ret[locale2] = ret[locale2] || {};
          deepCopy(resource, ret[locale2]);
        } else {
          deepCopy(resource, ret);
        }
      } else {
        isString$4(custom) && deepCopy(JSON.parse(custom), ret);
      }
    });
  }
  if (messageResolver == null && flatJson) {
    for (const key in ret) {
      if (hasOwn(ret, key)) {
        handleFlatJson(ret[key]);
      }
    }
  }
  return ret;
}
const isNotObjectOrIsArray = (val) => !isObject$5(val) || isArray$1(val);
function deepCopy(src, des) {
  if (isNotObjectOrIsArray(src) || isNotObjectOrIsArray(des)) {
    throw createI18nError(I18nErrorCodes.INVALID_VALUE);
  }
  for (const key in src) {
    if (hasOwn(src, key)) {
      if (isNotObjectOrIsArray(src[key]) || isNotObjectOrIsArray(des[key])) {
        des[key] = src[key];
      } else {
        deepCopy(src[key], des[key]);
      }
    }
  }
}
function getComponentOptions(instance) {
  return instance.type;
}
const DEVTOOLS_META = "__INTLIFY_META__";
let composerID = 0;
function defineCoreMissingHandler(missing) {
  return (ctx, locale, key, type2) => {
    return missing(locale, key, getCurrentInstance() || void 0, type2);
  };
}
const getMetaInfo = () => {
  const instance = getCurrentInstance();
  let meta = null;
  return instance && (meta = getComponentOptions(instance)[DEVTOOLS_META]) ? { [DEVTOOLS_META]: meta } : null;
};
function createComposer(options2 = {}, VueI18nLegacy) {
  const { __root } = options2;
  const _isGlobal = __root === void 0;
  let _inheritLocale = isBoolean$1(options2.inheritLocale) ? options2.inheritLocale : true;
  const _locale = ref(
    __root && _inheritLocale ? __root.locale.value : isString$4(options2.locale) ? options2.locale : DEFAULT_LOCALE
  );
  const _fallbackLocale = ref(
    __root && _inheritLocale ? __root.fallbackLocale.value : isString$4(options2.fallbackLocale) || isArray$1(options2.fallbackLocale) || isPlainObject$3(options2.fallbackLocale) || options2.fallbackLocale === false ? options2.fallbackLocale : _locale.value
  );
  const _messages = ref(getLocaleMessages(_locale.value, options2));
  const _datetimeFormats = ref(isPlainObject$3(options2.datetimeFormats) ? options2.datetimeFormats : { [_locale.value]: {} });
  const _numberFormats = ref(isPlainObject$3(options2.numberFormats) ? options2.numberFormats : { [_locale.value]: {} });
  let _missingWarn = __root ? __root.missingWarn : isBoolean$1(options2.missingWarn) || isRegExp$2(options2.missingWarn) ? options2.missingWarn : true;
  let _fallbackWarn = __root ? __root.fallbackWarn : isBoolean$1(options2.fallbackWarn) || isRegExp$2(options2.fallbackWarn) ? options2.fallbackWarn : true;
  let _fallbackRoot = __root ? __root.fallbackRoot : isBoolean$1(options2.fallbackRoot) ? options2.fallbackRoot : true;
  let _fallbackFormat = !!options2.fallbackFormat;
  let _missing = isFunction$3(options2.missing) ? options2.missing : null;
  let _runtimeMissing = isFunction$3(options2.missing) ? defineCoreMissingHandler(options2.missing) : null;
  let _postTranslation = isFunction$3(options2.postTranslation) ? options2.postTranslation : null;
  let _warnHtmlMessage = isBoolean$1(options2.warnHtmlMessage) ? options2.warnHtmlMessage : true;
  let _escapeParameter = !!options2.escapeParameter;
  const _modifiers = __root ? __root.modifiers : isPlainObject$3(options2.modifiers) ? options2.modifiers : {};
  let _pluralRules = options2.pluralRules || __root && __root.pluralRules;
  let _context;
  function getCoreContext() {
    const ctxOptions = {
      version: VERSION,
      locale: _locale.value,
      fallbackLocale: _fallbackLocale.value,
      messages: _messages.value,
      modifiers: _modifiers,
      pluralRules: _pluralRules,
      missing: _runtimeMissing === null ? void 0 : _runtimeMissing,
      missingWarn: _missingWarn,
      fallbackWarn: _fallbackWarn,
      fallbackFormat: _fallbackFormat,
      unresolving: true,
      postTranslation: _postTranslation === null ? void 0 : _postTranslation,
      warnHtmlMessage: _warnHtmlMessage,
      escapeParameter: _escapeParameter,
      messageResolver: options2.messageResolver,
      __meta: { framework: "vue" }
    };
    {
      ctxOptions.datetimeFormats = _datetimeFormats.value;
      ctxOptions.numberFormats = _numberFormats.value;
      ctxOptions.__datetimeFormatters = isPlainObject$3(_context) ? _context.__datetimeFormatters : void 0;
      ctxOptions.__numberFormatters = isPlainObject$3(_context) ? _context.__numberFormatters : void 0;
    }
    return createCoreContext(ctxOptions);
  }
  _context = getCoreContext();
  updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
  function trackReactivityValues() {
    return [
      _locale.value,
      _fallbackLocale.value,
      _messages.value,
      _datetimeFormats.value,
      _numberFormats.value
    ];
  }
  const locale = computed({
    get: () => _locale.value,
    set: (val) => {
      _locale.value = val;
      _context.locale = _locale.value;
    }
  });
  const fallbackLocale = computed({
    get: () => _fallbackLocale.value,
    set: (val) => {
      _fallbackLocale.value = val;
      _context.fallbackLocale = _fallbackLocale.value;
      updateFallbackLocale(_context, _locale.value, val);
    }
  });
  const messages = computed(() => _messages.value);
  const datetimeFormats = /* @__PURE__ */ computed(() => _datetimeFormats.value);
  const numberFormats = /* @__PURE__ */ computed(() => _numberFormats.value);
  function getPostTranslationHandler() {
    return isFunction$3(_postTranslation) ? _postTranslation : null;
  }
  function setPostTranslationHandler(handler) {
    _postTranslation = handler;
    _context.postTranslation = handler;
  }
  function getMissingHandler() {
    return _missing;
  }
  function setMissingHandler(handler) {
    if (handler !== null) {
      _runtimeMissing = defineCoreMissingHandler(handler);
    }
    _missing = handler;
    _context.missing = _runtimeMissing;
  }
  function wrapWithDeps(fn2, argumentParser, warnType, fallbackSuccess, fallbackFail, successCondition) {
    trackReactivityValues();
    let ret;
    if (__INTLIFY_PROD_DEVTOOLS__) {
      try {
        setAdditionalMeta(getMetaInfo());
        ret = fn2(_context);
      } finally {
        setAdditionalMeta(null);
      }
    } else {
      ret = fn2(_context);
    }
    if (isNumber$2(ret) && ret === NOT_REOSLVED) {
      const [key, arg2] = argumentParser();
      return __root && _fallbackRoot ? fallbackSuccess(__root) : fallbackFail(key);
    } else if (successCondition(ret)) {
      return ret;
    } else {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_RETURN_TYPE);
    }
  }
  function t2(...args) {
    return wrapWithDeps((context) => Reflect.apply(translate, null, [context, ...args]), () => parseTranslateArgs(...args), "translate", (root) => Reflect.apply(root.t, root, [...args]), (key) => key, (val) => isString$4(val));
  }
  function rt(...args) {
    const [arg1, arg2, arg3] = args;
    if (arg3 && !isObject$5(arg3)) {
      throw createI18nError(I18nErrorCodes.INVALID_ARGUMENT);
    }
    return t2(...[arg1, arg2, assign$5({ resolvedMessage: true }, arg3 || {})]);
  }
  function d2(...args) {
    return wrapWithDeps((context) => Reflect.apply(datetime, null, [context, ...args]), () => parseDateTimeArgs(...args), "datetime format", (root) => Reflect.apply(root.d, root, [...args]), () => MISSING_RESOLVE_VALUE, (val) => isString$4(val));
  }
  function n(...args) {
    return wrapWithDeps((context) => Reflect.apply(number, null, [context, ...args]), () => parseNumberArgs(...args), "number format", (root) => Reflect.apply(root.n, root, [...args]), () => MISSING_RESOLVE_VALUE, (val) => isString$4(val));
  }
  function normalize4(values) {
    return values.map((val) => isString$4(val) ? createVNode(Text, null, val, 0) : val);
  }
  const interpolate = (val) => val;
  const processor = {
    normalize: normalize4,
    interpolate,
    type: "vnode"
  };
  function transrateVNode(...args) {
    return wrapWithDeps(
      (context) => {
        let ret;
        const _context2 = context;
        try {
          _context2.processor = processor;
          ret = Reflect.apply(translate, null, [_context2, ...args]);
        } finally {
          _context2.processor = null;
        }
        return ret;
      },
      () => parseTranslateArgs(...args),
      "translate",
      (root) => root[TransrateVNodeSymbol](...args),
      (key) => [createVNode(Text, null, key, 0)],
      (val) => isArray$1(val)
    );
  }
  function numberParts(...args) {
    return wrapWithDeps(
      (context) => Reflect.apply(number, null, [context, ...args]),
      () => parseNumberArgs(...args),
      "number format",
      (root) => root[NumberPartsSymbol](...args),
      () => [],
      (val) => isString$4(val) || isArray$1(val)
    );
  }
  function datetimeParts(...args) {
    return wrapWithDeps(
      (context) => Reflect.apply(datetime, null, [context, ...args]),
      () => parseDateTimeArgs(...args),
      "datetime format",
      (root) => root[DatetimePartsSymbol](...args),
      () => [],
      (val) => isString$4(val) || isArray$1(val)
    );
  }
  function setPluralRules(rules) {
    _pluralRules = rules;
    _context.pluralRules = _pluralRules;
  }
  function te(key, locale2) {
    const targetLocale = isString$4(locale2) ? locale2 : _locale.value;
    const message = getLocaleMessage(targetLocale);
    return _context.messageResolver(message, key) !== null;
  }
  function resolveMessages(key) {
    let messages2 = null;
    const locales = fallbackWithLocaleChain(_context, _fallbackLocale.value, _locale.value);
    for (let i = 0; i < locales.length; i++) {
      const targetLocaleMessages = _messages.value[locales[i]] || {};
      const messageValue = _context.messageResolver(targetLocaleMessages, key);
      if (messageValue != null) {
        messages2 = messageValue;
        break;
      }
    }
    return messages2;
  }
  function tm(key) {
    const messages2 = resolveMessages(key);
    return messages2 != null ? messages2 : __root ? __root.tm(key) || {} : {};
  }
  function getLocaleMessage(locale2) {
    return _messages.value[locale2] || {};
  }
  function setLocaleMessage(locale2, message) {
    _messages.value[locale2] = message;
    _context.messages = _messages.value;
  }
  function mergeLocaleMessage(locale2, message) {
    _messages.value[locale2] = _messages.value[locale2] || {};
    deepCopy(message, _messages.value[locale2]);
    _context.messages = _messages.value;
  }
  function getDateTimeFormat(locale2) {
    return _datetimeFormats.value[locale2] || {};
  }
  function setDateTimeFormat(locale2, format3) {
    _datetimeFormats.value[locale2] = format3;
    _context.datetimeFormats = _datetimeFormats.value;
    clearDateTimeFormat(_context, locale2, format3);
  }
  function mergeDateTimeFormat(locale2, format3) {
    _datetimeFormats.value[locale2] = assign$5(_datetimeFormats.value[locale2] || {}, format3);
    _context.datetimeFormats = _datetimeFormats.value;
    clearDateTimeFormat(_context, locale2, format3);
  }
  function getNumberFormat(locale2) {
    return _numberFormats.value[locale2] || {};
  }
  function setNumberFormat(locale2, format3) {
    _numberFormats.value[locale2] = format3;
    _context.numberFormats = _numberFormats.value;
    clearNumberFormat(_context, locale2, format3);
  }
  function mergeNumberFormat(locale2, format3) {
    _numberFormats.value[locale2] = assign$5(_numberFormats.value[locale2] || {}, format3);
    _context.numberFormats = _numberFormats.value;
    clearNumberFormat(_context, locale2, format3);
  }
  composerID++;
  if (__root) {
    watch(__root.locale, (val) => {
      if (_inheritLocale) {
        _locale.value = val;
        _context.locale = val;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    });
    watch(__root.fallbackLocale, (val) => {
      if (_inheritLocale) {
        _fallbackLocale.value = val;
        _context.fallbackLocale = val;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    });
  }
  const composer = {
    id: composerID,
    locale,
    fallbackLocale,
    get inheritLocale() {
      return _inheritLocale;
    },
    set inheritLocale(val) {
      _inheritLocale = val;
      if (val && __root) {
        _locale.value = __root.locale.value;
        _fallbackLocale.value = __root.fallbackLocale.value;
        updateFallbackLocale(_context, _locale.value, _fallbackLocale.value);
      }
    },
    get availableLocales() {
      return Object.keys(_messages.value).sort();
    },
    messages,
    get modifiers() {
      return _modifiers;
    },
    get pluralRules() {
      return _pluralRules || {};
    },
    get isGlobal() {
      return _isGlobal;
    },
    get missingWarn() {
      return _missingWarn;
    },
    set missingWarn(val) {
      _missingWarn = val;
      _context.missingWarn = _missingWarn;
    },
    get fallbackWarn() {
      return _fallbackWarn;
    },
    set fallbackWarn(val) {
      _fallbackWarn = val;
      _context.fallbackWarn = _fallbackWarn;
    },
    get fallbackRoot() {
      return _fallbackRoot;
    },
    set fallbackRoot(val) {
      _fallbackRoot = val;
    },
    get fallbackFormat() {
      return _fallbackFormat;
    },
    set fallbackFormat(val) {
      _fallbackFormat = val;
      _context.fallbackFormat = _fallbackFormat;
    },
    get warnHtmlMessage() {
      return _warnHtmlMessage;
    },
    set warnHtmlMessage(val) {
      _warnHtmlMessage = val;
      _context.warnHtmlMessage = val;
    },
    get escapeParameter() {
      return _escapeParameter;
    },
    set escapeParameter(val) {
      _escapeParameter = val;
      _context.escapeParameter = val;
    },
    t: t2,
    getLocaleMessage,
    setLocaleMessage,
    mergeLocaleMessage,
    getPostTranslationHandler,
    setPostTranslationHandler,
    getMissingHandler,
    setMissingHandler,
    [SetPluralRulesSymbol]: setPluralRules
  };
  {
    composer.datetimeFormats = datetimeFormats;
    composer.numberFormats = numberFormats;
    composer.rt = rt;
    composer.te = te;
    composer.tm = tm;
    composer.d = d2;
    composer.n = n;
    composer.getDateTimeFormat = getDateTimeFormat;
    composer.setDateTimeFormat = setDateTimeFormat;
    composer.mergeDateTimeFormat = mergeDateTimeFormat;
    composer.getNumberFormat = getNumberFormat;
    composer.setNumberFormat = setNumberFormat;
    composer.mergeNumberFormat = mergeNumberFormat;
    {
      composer[TransrateVNodeSymbol] = transrateVNode;
      composer[NumberPartsSymbol] = numberParts;
      composer[DatetimePartsSymbol] = datetimeParts;
    }
  }
  return composer;
}
const baseFormatProps = {
  tag: {
    type: [String, Object]
  },
  locale: {
    type: String
  },
  scope: {
    type: String,
    validator: (val) => val === "parent" || val === "global",
    default: "parent"
  },
  i18n: {
    type: Object
  }
};
const Translation = /* @__PURE__ */ defineComponent({
  name: "i18n-t",
  props: assign$5({
    keypath: {
      type: String,
      required: true
    },
    plural: {
      type: [Number, String],
      validator: (val) => isNumber$2(val) || !isNaN(val)
    }
  }, baseFormatProps),
  setup(props, context) {
    const { slots, attrs } = context;
    const i18n = props.i18n || useI18n$1({ useScope: props.scope });
    const keys = Object.keys(slots).filter((key) => key !== "_");
    return () => {
      const options2 = {};
      if (props.locale) {
        options2.locale = props.locale;
      }
      if (props.plural !== void 0) {
        options2.plural = isString$4(props.plural) ? +props.plural : props.plural;
      }
      const arg = getInterpolateArg(context, keys);
      const children = i18n[TransrateVNodeSymbol](props.keypath, arg, options2);
      const assignedAttrs = assign$5({}, attrs);
      const tag = isString$4(props.tag) || isObject$5(props.tag) ? props.tag : Fragment;
      return h$1(tag, assignedAttrs, children);
    };
  }
});
function getInterpolateArg({ slots }, keys) {
  if (keys.length === 1 && keys[0] === "default") {
    return slots.default ? slots.default() : [];
  } else {
    return keys.reduce((arg, key) => {
      const slot = slots[key];
      if (slot) {
        arg[key] = slot();
      }
      return arg;
    }, {});
  }
}
function renderFormatter(props, context, slotKeys, partFormatter) {
  const { slots, attrs } = context;
  return () => {
    const options2 = { part: true };
    let overrides = {};
    if (props.locale) {
      options2.locale = props.locale;
    }
    if (isString$4(props.format)) {
      options2.key = props.format;
    } else if (isObject$5(props.format)) {
      if (isString$4(props.format.key)) {
        options2.key = props.format.key;
      }
      overrides = Object.keys(props.format).reduce((options3, prop2) => {
        return slotKeys.includes(prop2) ? assign$5({}, options3, { [prop2]: props.format[prop2] }) : options3;
      }, {});
    }
    const parts2 = partFormatter(...[props.value, options2, overrides]);
    let children = [options2.key];
    if (isArray$1(parts2)) {
      children = parts2.map((part2, index2) => {
        const slot = slots[part2.type];
        return slot ? slot({ [part2.type]: part2.value, index: index2, parts: parts2 }) : [part2.value];
      });
    } else if (isString$4(parts2)) {
      children = [parts2];
    }
    const assignedAttrs = assign$5({}, attrs);
    const tag = isString$4(props.tag) || isObject$5(props.tag) ? props.tag : Fragment;
    return h$1(tag, assignedAttrs, children);
  };
}
const NUMBER_FORMAT_KEYS = [
  "localeMatcher",
  "style",
  "unit",
  "unitDisplay",
  "currency",
  "currencyDisplay",
  "useGrouping",
  "numberingSystem",
  "minimumIntegerDigits",
  "minimumFractionDigits",
  "maximumFractionDigits",
  "minimumSignificantDigits",
  "maximumSignificantDigits",
  "notation",
  "formatMatcher"
];
const NumberFormat = /* @__PURE__ */ defineComponent({
  name: "i18n-n",
  props: assign$5({
    value: {
      type: Number,
      required: true
    },
    format: {
      type: [String, Object]
    }
  }, baseFormatProps),
  setup(props, context) {
    const i18n = props.i18n || useI18n$1({ useScope: "parent" });
    return renderFormatter(props, context, NUMBER_FORMAT_KEYS, (...args) => i18n[NumberPartsSymbol](...args));
  }
});
const DATETIME_FORMAT_KEYS = [
  "dateStyle",
  "timeStyle",
  "fractionalSecondDigits",
  "calendar",
  "dayPeriod",
  "numberingSystem",
  "localeMatcher",
  "timeZone",
  "hour12",
  "hourCycle",
  "formatMatcher",
  "weekday",
  "era",
  "year",
  "month",
  "day",
  "hour",
  "minute",
  "second",
  "timeZoneName"
];
const DatetimeFormat = /* @__PURE__ */ defineComponent({
  name: "i18n-d",
  props: assign$5({
    value: {
      type: [Number, Date],
      required: true
    },
    format: {
      type: [String, Object]
    }
  }, baseFormatProps),
  setup(props, context) {
    const i18n = props.i18n || useI18n$1({ useScope: "parent" });
    return renderFormatter(props, context, DATETIME_FORMAT_KEYS, (...args) => i18n[DatetimePartsSymbol](...args));
  }
});
function getComposer$2(i18n, instance) {
  const i18nInternal = i18n;
  if (i18n.mode === "composition") {
    return i18nInternal.__getInstance(instance) || i18n.global;
  } else {
    const vueI18n = i18nInternal.__getInstance(instance);
    return vueI18n != null ? vueI18n.__composer : i18n.global.__composer;
  }
}
function vTDirective(i18n) {
  const bind = (el2, { instance, value, modifiers }) => {
    if (!instance || !instance.$) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    const composer = getComposer$2(i18n, instance.$);
    const parsedValue = parseValue(value);
    el2.textContent = Reflect.apply(composer.t, composer, [
      ...makeParams(parsedValue)
    ]);
  };
  return {
    beforeMount: bind,
    beforeUpdate: bind
  };
}
function parseValue(value) {
  if (isString$4(value)) {
    return { path: value };
  } else if (isPlainObject$3(value)) {
    if (!("path" in value)) {
      throw createI18nError(I18nErrorCodes.REQUIRED_VALUE, "path");
    }
    return value;
  } else {
    throw createI18nError(I18nErrorCodes.INVALID_VALUE);
  }
}
function makeParams(value) {
  const { path, locale, args, choice, plural } = value;
  const options2 = {};
  const named = args || {};
  if (isString$4(locale)) {
    options2.locale = locale;
  }
  if (isNumber$2(choice)) {
    options2.plural = choice;
  }
  if (isNumber$2(plural)) {
    options2.plural = plural;
  }
  return [path, named, options2];
}
function apply(app2, i18n, ...options2) {
  const pluginOptions = isPlainObject$3(options2[0]) ? options2[0] : {};
  const useI18nComponentName = !!pluginOptions.useI18nComponentName;
  const globalInstall = isBoolean$1(pluginOptions.globalInstall) ? pluginOptions.globalInstall : true;
  if (globalInstall) {
    app2.component(!useI18nComponentName ? Translation.name : "i18n", Translation);
    app2.component(NumberFormat.name, NumberFormat);
    app2.component(DatetimeFormat.name, DatetimeFormat);
  }
  {
    app2.directive("t", vTDirective(i18n));
  }
}
const I18nInjectionKey = /* @__PURE__ */ makeSymbol("global-vue-i18n");
function createI18n$1(options2 = {}, VueI18nLegacy) {
  const __globalInjection = !!options2.globalInjection;
  const __instances = /* @__PURE__ */ new Map();
  const __global = createGlobal(options2);
  const symbol = makeSymbol("");
  function __getInstance(component) {
    return __instances.get(component) || null;
  }
  function __setInstance(component, instance) {
    __instances.set(component, instance);
  }
  function __deleteInstance(component) {
    __instances.delete(component);
  }
  {
    const i18n = {
      get mode() {
        return "composition";
      },
      async install(app2, ...options3) {
        {
          app2.__VUE_I18N_SYMBOL__ = symbol;
          app2.provide(app2.__VUE_I18N_SYMBOL__, i18n);
        }
        if (__globalInjection) {
          injectGlobalFields(app2, i18n.global);
        }
        {
          apply(app2, i18n, ...options3);
        }
      },
      get global() {
        return __global;
      },
      __instances,
      __getInstance,
      __setInstance,
      __deleteInstance
    };
    return i18n;
  }
}
function useI18n$1(options2 = {}) {
  const instance = getCurrentInstance();
  if (instance == null) {
    throw createI18nError(I18nErrorCodes.MUST_BE_CALL_SETUP_TOP);
  }
  if (!instance.isCE && instance.appContext.app != null && !instance.appContext.app.__VUE_I18N_SYMBOL__) {
    throw createI18nError(I18nErrorCodes.NOT_INSLALLED);
  }
  const i18n = getI18nInstance(instance);
  const global2 = getGlobalComposer(i18n);
  const componentOptions = getComponentOptions(instance);
  const scope = getScope(options2, componentOptions);
  if (scope === "global") {
    adjustI18nResources(global2, options2, componentOptions);
    return global2;
  }
  if (scope === "parent") {
    let composer2 = getComposer(i18n, instance);
    if (composer2 == null) {
      composer2 = global2;
    }
    return composer2;
  }
  if (i18n.mode === "legacy") {
    throw createI18nError(I18nErrorCodes.NOT_AVAILABLE_IN_LEGACY_MODE);
  }
  const i18nInternal = i18n;
  let composer = i18nInternal.__getInstance(instance);
  if (composer == null) {
    const composerOptions = assign$5({}, options2);
    if ("__i18n" in componentOptions) {
      composerOptions.__i18n = componentOptions.__i18n;
    }
    if (global2) {
      composerOptions.__root = global2;
    }
    composer = createComposer(composerOptions);
    setupLifeCycle(i18nInternal, instance);
    i18nInternal.__setInstance(instance, composer);
  }
  return composer;
}
function createGlobal(options2, legacyMode, VueI18nLegacy) {
  {
    return createComposer(options2);
  }
}
function getI18nInstance(instance) {
  {
    const i18n = inject(!instance.isCE ? instance.appContext.app.__VUE_I18N_SYMBOL__ : I18nInjectionKey);
    if (!i18n) {
      throw createI18nError(!instance.isCE ? I18nErrorCodes.UNEXPECTED_ERROR : I18nErrorCodes.NOT_INSLALLED_WITH_PROVIDE);
    }
    return i18n;
  }
}
function getScope(options2, componentOptions) {
  return isEmptyObject$1(options2) ? "__i18n" in componentOptions ? "local" : "global" : !options2.useScope ? "local" : options2.useScope;
}
function getGlobalComposer(i18n) {
  return i18n.mode === "composition" ? i18n.global : i18n.global.__composer;
}
function adjustI18nResources(global2, options2, componentOptions) {
  let messages = isObject$5(options2.messages) ? options2.messages : {};
  if ("__i18nGlobal" in componentOptions) {
    messages = getLocaleMessages(global2.locale.value, {
      messages,
      __i18n: componentOptions.__i18nGlobal
    });
  }
  const locales = Object.keys(messages);
  if (locales.length) {
    locales.forEach((locale) => {
      global2.mergeLocaleMessage(locale, messages[locale]);
    });
  }
  {
    if (isObject$5(options2.datetimeFormats)) {
      const locales2 = Object.keys(options2.datetimeFormats);
      if (locales2.length) {
        locales2.forEach((locale) => {
          global2.mergeDateTimeFormat(locale, options2.datetimeFormats[locale]);
        });
      }
    }
    if (isObject$5(options2.numberFormats)) {
      const locales2 = Object.keys(options2.numberFormats);
      if (locales2.length) {
        locales2.forEach((locale) => {
          global2.mergeNumberFormat(locale, options2.numberFormats[locale]);
        });
      }
    }
  }
}
function getComposer(i18n, target2) {
  let composer = null;
  const root = target2.root;
  let current = target2.parent;
  while (current != null) {
    const i18nInternal = i18n;
    if (i18n.mode === "composition") {
      composer = i18nInternal.__getInstance(current);
    }
    if (composer != null) {
      break;
    }
    if (root === current) {
      break;
    }
    current = current.parent;
  }
  return composer;
}
function setupLifeCycle(i18n, target2, composer) {
  {
    onMounted(() => {
    }, target2);
    onUnmounted(() => {
      i18n.__deleteInstance(target2);
    }, target2);
  }
}
const globalExportProps = [
  "locale",
  "fallbackLocale",
  "availableLocales"
];
const globalExportMethods = ["t", "rt", "d", "n", "tm"];
function injectGlobalFields(app2, composer) {
  const i18n = /* @__PURE__ */ Object.create(null);
  globalExportProps.forEach((prop2) => {
    const desc = Object.getOwnPropertyDescriptor(composer, prop2);
    if (!desc) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    const wrap2 = isRef(desc.value) ? {
      get() {
        return desc.value.value;
      },
      set(val) {
        desc.value.value = val;
      }
    } : {
      get() {
        return desc.get && desc.get();
      }
    };
    Object.defineProperty(i18n, prop2, wrap2);
  });
  app2.config.globalProperties.$i18n = i18n;
  globalExportMethods.forEach((method) => {
    const desc = Object.getOwnPropertyDescriptor(composer, method);
    if (!desc || !desc.value) {
      throw createI18nError(I18nErrorCodes.UNEXPECTED_ERROR);
    }
    Object.defineProperty(app2.config.globalProperties, `$${method}`, desc);
  });
}
registerMessageResolver(resolveValue);
registerLocaleFallbacker(fallbackWithLocaleChain);
{
  initFeatureFlags();
}
if (__INTLIFY_PROD_DEVTOOLS__) {
  const target2 = getGlobalThis$1();
  target2.__INTLIFY__ = true;
  setDevToolsHook(target2.__INTLIFY_DEVTOOLS_GLOBAL_HOOK__);
}
const compiledMessages = {
  "en-US": {
    "links": {
      "learnMore": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Learn more."]);
      },
      "learnMoreButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Learn more"]);
      },
      "needHelp": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Need help"]);
      }
    },
    "components": {
      "modal": {
        "dismiss": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Dismiss"]);
        }
      },
      "fileSearch": {
        "noMatchesForExtension": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["No files found when searching for the file extension"]);
        },
        "noMatchesForFileName": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize([]);
        },
        "byFilenameInput": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Search by filename..."]);
        },
        "byExtensionInput": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Extensions to include e.g. *.tsx, *.vue"]);
        },
        "matchesIndicatorEmptyFileSearch": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize(["No matches"]), _normalize(["1 match"]), _normalize([_interpolate(_named("denominator")), " matches"])]);
        },
        "matchesIndicator": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize(["No matches"]), _normalize([_interpolate(_named("numerator")), " of ", _interpolate(_named("denominator")), " matches"]), _normalize([_interpolate(_named("numerator")), " of ", _interpolate(_named("denominator")), " matches"])]);
        }
      },
      "button": {
        "cancel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cancel"]);
        },
        "back": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Back"]);
        }
      },
      "loading": {
        "config": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Initializing config..."]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Please wait while we load your project and find browsers installed on your system"]);
          }
        }
      },
      "select": {
        "placeholder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Choose an option..."]);
        }
      },
      "alert": {
        "dismissAriaLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Dismiss"]);
        }
      },
      "specPattern": {
        "matches": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize(["No matches"]), _normalize([_interpolate(_named("n")), " match"]), _normalize([_interpolate(_named("n")), " matches"])]);
        }
      },
      "specPatternModal": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Spec pattern settings"]);
        }
      }
    },
    "clipboard": {
      "copy": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Copy"]);
      },
      "copied": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Copied!"]);
      }
    },
    "actions": {
      "close": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Close"]);
      }
    },
    "file": {
      "edit": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Edit"]);
      },
      "git": {
        "modified": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Modified"]);
        },
        "created": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Created"]);
        }
      }
    },
    "status": {
      "enabled": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Enabled"]);
      },
      "disabled": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Disabled"]);
      }
    },
    "createSpec": {
      "newSpec": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["New spec"]);
      },
      "createSpec": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Create spec"]);
      },
      "done": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Done!"]);
      },
      "noComponentsFound": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["No components found"]);
      },
      "unableToParseFile": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Unable to parse file"]);
      },
      "updateSpecPattern": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Update spec pattern"]);
      },
      "newSpecModalTitle": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Create new spec"]);
      },
      "successPage": {
        "header": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Great! The spec was successfully added"]);
        },
        "runSpecButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Okay, run the spec"]);
        },
        "createAnotherSpecButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Create another spec"]);
        }
      },
      "page": {
        "defaultPatternNoSpecs": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Create your first spec"]);
          },
          "component": {
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Since this project looks new, we recommend that you get started by creating a spec for one of your components."]);
            }
          },
          "e2e": {
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Since this project looks new, we recommend that you use the specs and tests that we've written for you to get started."]);
            }
          }
        },
        "customPatternNoSpecs": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["No specs found"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["We couldn't find any files matching the following spec patterns. You may need to move your specs or update your ", _interpolate(_list(0)), " to find them."]);
          }
        }
      },
      "noSpecsMessage": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["If you feel that you're seeing this screen in error, and there should be specs listed here, you likely need to update the spec pattern."]);
      },
      "viewSpecPatternButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["View spec pattern"]);
      },
      "e2e": {
        "importFromScaffold": {
          "header": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Scaffold example specs"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We'll generate several example specs to help guide you on how to write tests in Cypress."]);
          },
          "specsAddedHeader": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Great! We added the following files to your project:"]);
          },
          "specsAddedButton": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Okay, I got it!"]);
          },
          "specsAddingHeader": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Adding specs..."]);
          }
        },
        "importTemplateSpec": {
          "header": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Create new spec"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We'll generate a template spec file which can be used to start testing your application."]);
          },
          "chooseFilenameHeader": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Enter the path for your new spec"]);
          },
          "inputPlaceholder": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Enter a relative path..."]);
          },
          "invalidSpecWarning": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["This path is invalid because it doesn't match the following "]);
          },
          "specExtensionWarning": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We recommend naming your spec to match the following pattern: "]);
          }
        }
      },
      "component": {
        "importFromComponent": {
          "header": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Create from component"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Generate a basic component test for any of the components in this project."]);
          },
          "chooseAComponentHeader": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Choose a component"]);
          }
        },
        "importTemplateSpec": {
          "header": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Create new spec"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We'll generate a template spec file which can be used to start testing your components."]);
          },
          "invalidComponentWarning": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We couldn't generate a valid path matching your custom "]);
          }
        }
      }
    },
    "specPage": {
      "pageTitle": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Specs"]);
      },
      "newSpecButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["New spec"]);
      },
      "searchPlaceholder": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Search specs"]);
      },
      "clearSearch": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Clear search field"]);
      },
      "componentSpecsHeader": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Component specs"]);
      },
      "e2eSpecsHeader": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["E2E specs"]);
      },
      "lastUpdated": {
        "header": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Last updated"]);
        },
        "tooltip": {
          "gitStatus": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Git status"]);
          },
          "gitInfo": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["git info"]);
          },
          "gitInfoAvailable": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize([_interpolate(_list(0)), " of the spec files within this project"]);
          },
          "gitInfoUnavailable": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["Cypress is unable to detect ", _interpolate(_list(0)), " for this project and has defaulted to showing file system data instead"]);
          }
        }
      },
      "latestRuns": {
        "header": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Latest runs"]);
        },
        "headerShort": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Runs"]);
        },
        "tooltip": {
          "connected": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["The ", _interpolate(_list(0)), " in Cypress Cloud"]);
          },
          "notConnected": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["Connect to Cypress Cloud to see the ", _interpolate(_list(0))]);
          },
          "noAccess": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["Request access to this project in Cypress Cloud to view the ", _interpolate(_list(0))]);
          },
          "linkText": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["status of your latest runs"]);
          }
        }
      },
      "averageDuration": {
        "header": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Average duration"]);
        },
        "headerShort": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Duration"]);
        },
        "tooltip": {
          "connected": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["The ", _interpolate(_list(0)), " of your latest runs in Cypress Cloud"]);
          },
          "notConnected": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["Connect to Cypress Cloud to see the ", _interpolate(_list(0)), " of your latest runs"]);
          },
          "noAccess": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["Request access to this project in Cypress Cloud to view the ", _interpolate(_list(0)), " of your latest runs"]);
          },
          "linkText": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["average spec durations"]);
          }
        }
      },
      "flaky": {
        "badgeLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Flaky"]);
        },
        "severityLow": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Low"]);
        },
        "severityMedium": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Medium"]);
        },
        "severityHigh": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["High"]);
        },
        "flakyRate": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize([_interpolate(_list(0)), "% flaky rate"]);
        },
        "flakyRuns": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize([_interpolate(_named("flakyRuns")), " flaky runs / ", _interpolate(_named("totalRuns")), " total"]), _normalize([_interpolate(_named("flakyRuns")), " flaky run / ", _interpolate(_named("totalRuns")), " total"]), _normalize([_interpolate(_named("flakyRuns")), " flaky runs / ", _interpolate(_named("totalRuns")), " total"])]);
        },
        "lastFlaky": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize(["Last run flaky"]), _normalize(["Last flaky ", _interpolate(_named("runsSinceLastFlake")), " run ago"]), _normalize(["Last flaky ", _interpolate(_named("runsSinceLastFlake")), " runs ago"])]);
        }
      },
      "hoverButton": {
        "connect": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Connect"]);
        },
        "connectProject": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Connect project"]);
        },
        "connectProjectShort": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Connect"]);
        },
        "requestAccess": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Request access"]);
        },
        "requestAccessShort": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Request"]);
        },
        "requestSent": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Request sent"]);
        },
        "requestSentShort": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Sent"]);
        }
      },
      "connectProjectButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Connect your project"]);
      },
      "cloudLoginButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Log in to Cypress Cloud"]);
      },
      "reconnectProjectButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Reconnect your project"]);
      },
      "unauthorizedBannerTitle": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Request access to project"]);
      },
      "requestAccessButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Request access"]);
      },
      "requestSentButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Request sent"]);
      },
      "rows": {
        "gitTooltipSubtext": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize([_interpolate(_named("shortHash")), " by ", _interpolate(_named("author"))]);
        }
      },
      "noResultsMessage": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["No specs matched your search:"]);
      },
      "noSpecError": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Spec not found"]);
        },
        "intro": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["There is no spec matching the following location:"]);
        },
        "explainer": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["It is possible that the file has been moved or deleted. Please choose from the list of specs below."]);
        }
      },
      "offlineWarning": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["No internet connection"]);
        },
        "explainer": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Please check your internet connection to resolve this issue. When your internet connection is fixed, we will automatically attempt to fetch the run metrics from Cypress Cloud."]);
        }
      },
      "fetchFailedWarning": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Lost connection"]);
        },
        "explainer1": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["The request timed out or failed when trying to retrieve the recorded run metrics from Cypress Cloud. The information that you're seeing in the table below may be incomplete as a result."]);
        },
        "explainer2": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Please refresh the page to try again and visit our ", _interpolate(_list(0)), " if this behavior continues."]);
        },
        "refreshButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Try again"]);
        }
      },
      "banners": {
        "login": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Optimize and record your CI test runs with Cypress Cloud"]);
          },
          "contentA": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Parallelize your tests in CI and visualize every error by watching full video recordings of each test you run."]);
          },
          "contentB": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["When you configure Cypress to record tests to Cypress Cloud, you'll see data from your latest recorded runs in the Cypress app. This increased visibility into your test history allows you to debug your tests faster and more effectively, all within your local workflow."]);
          },
          "buttonLabel": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Get started with Cypress Cloud"]);
          }
        },
        "createOrganization": {
          "titleA": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Finish setting up Cypress Cloud"]);
          },
          "titleB": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Create or join an organization"]);
          },
          "content": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Join or create an organization in Cypress Cloud to access your projects and recorded test runs."]);
          },
          "buttonLabel": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Set up your organization"]);
          }
        },
        "connectProject": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Connect your project to Cypress Cloud"]);
          },
          "contentA": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["View recorded test runs directly in the Cypress app to monitor, run, and fix tests locally."]);
          },
          "contentB": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Bring your recorded test results into your local development workflow to monitor, run, and fix tests all in the Cypress app."]);
          },
          "buttonLabel": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Connect your project"]);
          }
        },
        "record": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Record your first run"]);
          },
          "content": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Record a run to see your test results in Cypress Cloud. You can then optimize your test suite, debug failing and flaky tests, and integrate with your favorite tools."]);
          }
        }
      },
      "runSelectedSpecs": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
        return _plural([_normalize(["Run ", _interpolate(_named("n")), " spec"]), _normalize(["Run ", _interpolate(_named("n")), " specs"])]);
      }
    },
    "noResults": {
      "defaultMessage": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["No results matched your search:"]);
      },
      "clearSearch": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Clear search"]);
      }
    },
    "sidebar": {
      "keyboardShortcuts": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Keyboard shortcuts"]);
        },
        "rerun": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Re-run tests"]);
        },
        "stop": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Stop tests"]);
        },
        "toggle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Toggle specs list"]);
        }
      },
      "toggleLabel": {
        "expanded": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Collapse sidebar"]);
        },
        "collapsed": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Expand sidebar"]);
        }
      },
      "nav": {
        "ariaLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Pages"]);
        }
      }
    },
    "topNav": {
      "released": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Released"]);
      },
      "version": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Version"]);
      },
      "versionUnsupported": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Unsupported"]);
      },
      "installed": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Installed"]);
      },
      "latest": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Latest"]);
      },
      "seeAllReleases": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["See all releases"]);
      },
      "runningOldVersion": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["You're currently running an old version of Cypress. Update to the latest version for the best experience."]);
      },
      "docsMenu": {
        "docsHeading": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Docs"]);
        },
        "gettingStartedTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Getting started"]);
        },
        "firstTest": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Write your first test"]);
        },
        "testingApp": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Testing your app"]);
        },
        "organizingTests": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Organizing tests"]);
        },
        "referencesTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["References"]);
        },
        "bestPractices": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Best practices"]);
        },
        "configuration": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Configuration"]);
        },
        "api": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["API"]);
        },
        "ciTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Run in CI/CD"]);
        },
        "ciSetup": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Set up CI"]);
        },
        "fasterTests": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Run tests faster"]);
        },
        "prompts": {
          "ci1": {
            "title": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Configure CI"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Optimize your tests in CI by following these guides."]);
            },
            "seeOtherGuides": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["See other guides"]);
            },
            "intro": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Introduction to CI"]);
            },
            "learnTheBasics": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Learn the basics of running Cypress in CI."]);
            }
          },
          "orchestration1": {
            "title": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Run tests faster in CI"]);
            },
            "parallelTime": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["5 mins"]);
            },
            "noParallelTime": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["12 mins"]);
            },
            "withParallelization": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["with Parallelization"]);
            },
            "withoutParallelization": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["without Parallelization"]);
            },
            "intro": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["With Smart Orchestration, you'll be able to:"]);
            },
            "bullet1": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Run spec files in parallel"]);
            },
            "bullet2": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Prioritize failed specs to run first"]);
            },
            "bullet3": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Cancel CI runs on test failure"]);
            },
            "learnMore": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Learn more"]);
            }
          }
        }
      },
      "login": {
        "bodyInitial": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Logging in gives you access to ", _interpolate(_list(0)), ". You can set up projects to be recorded and see test data from your project."]);
        },
        "bodySuccess": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["You are now logged in as ", _interpolate(_list(0)), "."]);
        },
        "bodyError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["An error occurred while attempting to log in:"]);
        },
        "bodyBrowserError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["The browser could not be opened."]);
        },
        "bodyBrowserErrorDetails": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress was unable to open your installed browser. To continue logging in, please paste this URL into your web browser:"]);
        },
        "cloud": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress Cloud"]);
        },
        "titleInitial": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Log in to Cypress"]);
        },
        "titleSuccess": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Login successful"]);
        },
        "titleFailed": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Login failed"]);
        },
        "titleBrowserError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Browser error"]);
        },
        "actionLogin": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Log in"]);
        },
        "profileMenuLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Profile and logout"]);
        },
        "actionLogout": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Log out"]);
        },
        "actionContinue": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Continue"]);
        },
        "actionOpening": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Opening browser"]);
        },
        "actionWaiting": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Waiting for you to log in"]);
        },
        "actionTryAgain": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Try again"]);
        },
        "actionCancel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cancel"]);
        }
      },
      "updateCypress": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Upgrade to Cypress"]);
        },
        "currentlyRunning": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["You are currently running Version ", _interpolate(_list(0)), " of Cypress. "]);
        },
        "pasteToUpgradeProject": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["To upgrade to the latest version for your project, first ", _interpolate(_list(0)), ", then paste the command below into your terminal:"]);
        },
        "pasteToUpgradeGlobal": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["To upgrade to the latest version, first ", _interpolate(_list(0)), ", then paste the command below into your terminal:"]);
        },
        "rememberToCloseInsert": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["close this app"]);
        }
      },
      "upgradeText": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Upgrade"]);
      },
      "global": {
        "projects": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Projects"]);
        }
      }
    },
    "launchpadErrors": {
      "generic": {
        "configErrorTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress configuration error"]);
        },
        "retryButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Try again"]);
        },
        "stackTraceLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Stack trace"]);
        },
        "docsButton": {
          "configGuide": {
            "text": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Configuration guide"]);
            },
            "link": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["https://docs.cypress.io/guides/references/configuration"]);
            }
          },
          "cloudGuide": {
            "text": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Cypress Cloud guide"]);
            },
            "link": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["https://on.cypress.io/features-dashboard"]);
            }
          },
          "docsHomepage": {
            "text": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Cypress docs"]);
            },
            "link": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["https://docs.cypress.io"]);
            }
          }
        }
      },
      "noInternet": {
        "header": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You have no internet connection"]);
        },
        "message": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Check your internet connection to pull the latest data from Cypress Cloud."]);
        },
        "connectProject": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Please check your internet connection to resolve this issue. When your internet connection is fixed, we will automatically attempt to fetch your latest runs for this project."]);
        }
      }
    },
    "setupPage": {
      "projectSetup": {
        "frameworkLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Front-end framework"]);
        },
        "frameworkPlaceholder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Pick a framework"]);
        },
        "bundlerLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Bundler"]);
        },
        "bundlerLabelDescription": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["(dev server)"]);
        },
        "bundlerPlaceholder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Pick a bundler"]);
        },
        "languageLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Language"]);
        },
        "configFileLanguageLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress config file"]);
        },
        "detected": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["(detected)"]);
        }
      },
      "step": {
        "continue": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Continue"]);
        },
        "next": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Next step"]);
        },
        "back": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Back"]);
        },
        "skip": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Skip"]);
        }
      },
      "configFile": {
        "createManually": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Create file manually"]);
        },
        "skippedLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Skipped"]);
        },
        "changesRequiredLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Changes required"]);
        },
        "changesRequiredBadge": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Changes required"]);
        },
        "changesRequiredDescription": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Please merge the code below with your existing ", _interpolate(_list(0))]);
        }
      },
      "testingCard": {
        "configured": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Configured"]);
        },
        "notConfigured": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Not Configured"]);
        },
        "running": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Running"]);
        },
        "chooseABrowser": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Choose a browser"]);
        },
        "reconfigure": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Reconfigure"]);
        },
        "disabled": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Disabled"]);
        }
      }
    },
    "globalPage": {
      "empty": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Add project"]);
        },
        "helper": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Get started by adding your first project below."]);
        },
        "dropText": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Drag your project directory here or ", _interpolate(_list(0))]);
        },
        "browseManually": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["browse manually."]);
        }
      },
      "settings": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Settings"]);
      },
      "saveChanges": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Save changes"]);
      },
      "cancel": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Cancel"]);
      },
      "externalEditorPreferences": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["External editor preferences"]);
      },
      "externalEditorPreferencesDescription1": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Select your preference for opening files on your system."]);
      },
      "externalEditorPreferencesDescription2": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
        return _normalize(["You can change this later in the ", _interpolate(_list(0)), " page."]);
      },
      "recentProjectsHeader": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Recent projects"]);
      },
      "searchPlaceholder": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Search projects"]);
      },
      "addProjectButton": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Add project"]);
      },
      "projectActions": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Project actions"]);
      },
      "removeProject": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Remove project"]);
      },
      "openInIDE": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Open in IDE"]);
      },
      "openInFinder": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Open in Finder"]);
      },
      "noResultsMessage": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["No projects matched your search:"]);
      }
    },
    "welcomePage": {
      "review": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Review the differences between each testing type"]);
      },
      "codeExample": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Code example"]);
      },
      "compareTypes": {
        "content": {
          "e2eTitle": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["End-to-end tests"]);
          },
          "e2eBullet1": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Visit URLs via"]);
          },
          "e2eBullet2": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Test flows and functionality across multiple pages"]);
          },
          "e2eBullet3": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Ideal for testing integrated flows in CD workflows"]);
          },
          "componentTitle": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Component tests"]);
          },
          "ctBullet1": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Import components via"]);
          },
          "ctBullet2": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Test individual components of a design system in isolation"]);
          },
          "ctBullet3": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Ideal for testing isolated flows and components in CI"]);
          }
        },
        "modalTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Key differences"]);
        }
      },
      "title": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Welcome to Cypress!"]);
      }
    },
    "settingsPage": {
      "config": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Resolved configuration"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Since the options in the ", _interpolate(_list(0)), " can be set dynamically by your development environment, please refer to the legend below to understand how the configuration options are resolved."]);
        },
        "legend": {
          "env": {
            "label": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["env"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Set from environment variables"]);
            }
          },
          "default": {
            "label": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["default"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Default values"]);
            }
          },
          "dynamic": {
            "label": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["dynamic"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
              return _normalize(["Set by the ", _interpolate(_list(0)), " function"]);
            }
          },
          "cli": {
            "label": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["cli"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Set from CLI arguments"]);
            }
          },
          "config": {
            "label": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["config"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
              return _normalize(["Set from ", _interpolate(_list(0))]);
            }
          }
        }
      },
      "proxy": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Proxy settings"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress auto-detected the following proxy settings from your operating system."]);
        },
        "bypassList": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Proxy bypass list"]);
        },
        "proxyServer": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Proxy server"]);
        }
      },
      "editor": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["External editor"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["External editor to use for editing code opened when using Cypress."]);
        },
        "noEditorSelectedPlaceholder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Choose your editor..."]);
        },
        "customPathPlaceholder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["/path/to/editor"]);
        }
      },
      "projectId": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Project ID"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["The Project ID configured for this project inside of Cypress Cloud. ", _interpolate(_list(0))]);
        }
      },
      "specPattern": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Spec patterns"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["The globs pointing Cypress to your spec files configured for this project. ", _interpolate(_list(0))]);
        }
      },
      "recordKey": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Record key"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["The Record Key configured for this project inside of Cypress Cloud. ", _interpolate(_list(0))]);
        },
        "manageKeys": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Manage keys"]);
        },
        "errorEmpty": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You do not have permission to record on this project"]);
        },
        "errorEmptyButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Request record rights"]);
        },
        "errorAccess": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You do not have permission to view this project"]);
        },
        "errorAccessPending": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Your request for access to this project is pending approval"]);
        },
        "errorAccessButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Request access"]);
        },
        "errorNotFound": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Project not found"]);
        },
        "errorNotFoundButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Connect it again"]);
        },
        "errorNotLoggedIn": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You are not connected to Cypress Cloud"]);
        },
        "errorNotLoggedInButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Log in to Cypress Cloud"]);
        }
      },
      "project": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Project settings"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Review the configuration settings currently in use for this project."]);
        }
      },
      "cloud": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cypress Cloud settings"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Review the configuration settings for recording to Cypress Cloud."]);
        }
      },
      "experiments": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Experiments"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["If you'd like to try out new features that we're working on, you can enable beta features for your project by turning on the experimental features you'd like to try. ", _interpolate(_list(0))]);
        },
        "experimentalFetchPolyfill": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Fetch polyfill"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Automatically replaces `window.fetch` with a polyfill that Cypress can spy on and stub. Note: `experimentalFetchPolyfill` has been deprecated in Cypress 6.0.0 and will be removed in a future release. Consider using [`cy.intercept()`](https://on.cypress.io/intercept) to intercept `fetch` requests instead."]);
          }
        },
        "experimentalInteractiveRunEvents": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Interactive run events"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Allows listening to the [`before:run`](https://on.cypress.io/before-run), [`after:run`](https://on.cypress.io/after-run), [`before:spec`](https://on.cypress.io/before-spec), and [`after:spec`](https://on.cypress.io/after-spec) events in plugins during interactive mode."]);
          }
        },
        "experimentalModifyObstructiveThirdPartyCode": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Modify obstructive third party code"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Applies `modifyObstructiveCode` to third party `.html` and `.js`, removes subresource integrity, and modifies the user agent in Electron."]);
          }
        },
        "experimentalSingleTabRunMode": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Single tab run mode"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Runs all component specs in a single tab, trading spec isolation for faster run mode execution."]);
          }
        },
        "experimentalSourceRewriting": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Source rewriting"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Enables AST-based JS/HTML rewriting. This may fix issues caused by the existing regex-based JS/HTML replacement algorithm. See [#5273](https://github.com/cypress-io/cypress/issues/5273) for details."]);
          }
        },
        "experimentalStudio": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Studio"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Generate and save commands directly to your test suite by interacting with your app as an end user would."]);
          }
        },
        "experimentalWebKitSupport": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["WebKit Support"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Adds support for testing in the WebKit browser engine used by Safari. See https://on.cypress.io/webkit-experiment for more information."]);
          }
        },
        "experimentalRunAllSpecs": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Run All Specs"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(['Enables the "Run All Specs" UI feature, allowing the execution of multiple specs sequentially.']);
          }
        },
        "experimentalOriginDependencies": {
          "name": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Origin Dependencies"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Enables support for `require`/`import` within `cy.origin`."]);
          }
        }
      },
      "device": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Device settings"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Review the configuration settings currently in use for this device."]);
        }
      },
      "testingPreferences": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Testing preferences"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Configure your testing environment with these flags"]);
        },
        "autoScrollingEnabled": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Auto scrolling enabled"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Scroll behavior when running tests."]);
          }
        }
      },
      "footer": {
        "text": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["You can reconfigure the ", _interpolate(_named("testingType")), " testing settings for this project if you're experiencing issues with your Cypress configuration."]);
        },
        "button": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Configuration guide"]);
        },
        "buttonLink": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["https://docs.cypress.io/guides/references/configuration"]);
        }
      }
    },
    "runs": {
      "connect": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["View your recorded runs from Cypress Cloud"]);
        },
        "smartText": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Scale your test runs with built-in Smart Orchestration."]);
        },
        "debugText": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Debug tests that fail in CI with visual feedback."]);
        },
        "chartText": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Keep your tests in tip-top shape with powerful analytics."]);
        },
        "buttonUser": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Log in to Cypress Cloud"]);
        },
        "buttonProject": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Connect your project to Cypress Cloud"]);
        },
        "modal": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Connect project"]);
          },
          "cancel": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cancel"]);
          },
          "createOrg": {
            "description": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["You need to create an organization in Cypress Cloud to continue."]);
            },
            "button": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Create organization"]);
            },
            "waitingButton": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Waiting for you to create an organization..."]);
            },
            "refreshButton": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Refresh organizations list"]);
            }
          },
          "selectProject": {
            "organization": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Organization"]);
            },
            "noOrganizationSelectedError": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["required when creating a new project"]);
            },
            "manageOrgs": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Manage organizations"]);
            },
            "project": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Project"]);
            },
            "projectName": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Project name"]);
            },
            "projectNameDisclaimer": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["(You can change this later)"]);
            },
            "createNewProject": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Create new"]);
            },
            "chooseExistingProject": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Choose an existing project"]);
            },
            "newProjectAccess": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Project access"]);
            },
            "privateLabel": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Private"]);
            },
            "privateDescription": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Only invited users can view recorded test results."]);
            },
            "publicLabel": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Public"]);
            },
            "publicDescription": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Anyone can view recorded test results."]);
            },
            "connectProject": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Connect project"]);
            },
            "createProject": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Create project"]);
            },
            "placeholderOrganizations": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Pick an organization"]);
            },
            "placeholderProjects": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Pick a project"]);
            },
            "placeholderProjectsPending": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Pick an organization first"]);
            }
          },
          "connectManually": {
            "title": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Connect project manually"]);
            },
            "warning": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["We couldn't add the projectId to your cypress.config.js file automatically."]);
            },
            "mainMessage": (ctx) => {
              const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
              return _normalize(["Manually add the ", _interpolate(_named("projectId")), " to the root of the config object in your ", _interpolate(_named("configFile")), " file."]);
            },
            "waitingButton": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Waiting for you to add the projectId..."]);
            }
          }
        },
        "errors": {
          "baseError": {
            "title": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Cypress Cloud error"]);
            }
          },
          "internalServerError": {
            "title": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Cannot connect to Cypress Cloud"]);
            },
            "description": (ctx) => {
              const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
              return _normalize(["The request times out when trying to retrieve the info from Cypress Cloud. Please refresh the page to try again and visit out ", _interpolate(_list(0)), " if this behavior continues."]);
            },
            "link": (ctx) => {
              const { normalize: _normalize } = ctx;
              return _normalize(["Support Page"]);
            }
          }
        }
      },
      "connectSuccessAlert": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["This project is now connected to Cypress Cloud!"]);
        },
        "item1": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["We automatically added the ", _interpolate(_named("projectId")), " to your ", _interpolate(_named("configFile")), " file."]);
        },
        "item2": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Please ensure that your ", _interpolate(_list(0)), " file is checked into source control."]);
        }
      },
      "empty": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Record your first run to Cypress Cloud"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Run the command below in your local development terminal or in CI."]);
        }
      },
      "results": {
        "skipped": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["skipped"]);
        },
        "pending": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["pending"]);
        },
        "passed": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["passed"]);
        },
        "failed": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["failed"]);
        }
      },
      "errors": {
        "notFound": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Couldn't find your project"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["We were unable to find an existing project matching the ", _interpolate(_list(0)), " set in your Cypress config file. You can reconnect with an existing project or create a new project."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Reconnect your project"]);
          }
        },
        "unauthorized": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Request access to view the recorded runs"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["This is a private project that you do not currently have access to. Please request access from the project owner in order to view the list of runs."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Request access"]);
          }
        },
        "unauthorizedRequested": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Your access request for this project has been sent."]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["The owner of this project has been notified of your request. We'll notify you via email when your access request has been granted."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Request Sent"]);
          }
        },
        "connectionFailed": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cannot connect to Cypress Cloud"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["The request times out when trying to retrieve the recorded runs from Cypress Cloud. Please refresh the page to try again and visit out ", _interpolate(_list(0)), " if this behavior continues."]);
          },
          "link": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Support page"]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Try again"]);
          }
        }
      }
    },
    "testingType": {
      "modalTitle": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Choose a testing type"]);
      },
      "e2e": {
        "name": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["E2E Testing"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Build and test the entire experience of your application from end-to-end to ensure each flow matches your expectations."]);
        }
      },
      "component": {
        "name": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Component Testing"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Build and test your components from your design system in isolation in order to ensure each state matches your expectations."]);
        }
      },
      "componentDisabled": {
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["To test your components you must ", _interpolate(_list(0)), " as an NPM dependency for this project."]);
        },
        "link": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["install Cypress"]);
        }
      }
    },
    "migration": {
      "before": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Before"]);
      },
      "after": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["After"]);
      },
      "heresWhy": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["here's why:"]);
      },
      "renameAuto": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We recommend automatically renaming your specs in this step"]);
        },
        "changeButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["change"]);
        },
        "changedSpecFolder": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We've changed the default spec folder from:"]);
        },
        "changedSpecExt": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We've changed the default spec file extension from:"]);
        },
        "changedSpecPatternExplain": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["We've changed the default spec file extension to ", _interpolate(_list(0)), " in order to avoid conflicts with any existing testing frameworks."]);
        },
        "optedOutMessage": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You've opted not to rename your spec file extension. You may need to change your specPattern later so we can still find your spec files."]);
        },
        "folderRenameMessage": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You've opted not to rename your spec file extension, we'll only rename the folder"]);
        },
        "modal": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Change the existing spec file extension"]);
          },
          "warning": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We recommend using the default extension to avoid inconsistencies, framework conflicts, and confusion with your team."]);
          },
          "line1": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cypress now supports the ability to create new spec files from within the UI for both E2E and component specs."]);
          },
          "line2": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["All new spec files created within Cypress will use the default pattern of: "]);
          },
          "line3": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We want to rename your existing specs so that they have a consistent filename pattern for both E2E and component testing."]);
          },
          "line4": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["All documentation and example code will be using: "]);
          },
          "line5": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["We've changed the placement of component specs to be next to their source files (e.g. src/Button.jsx and src/Button.cy.jsx)"]);
          },
          "line6": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["The new default pattern of ", _interpolate(_list(0)), " prevents targeting conflicts with other testing frameworks. (e.g. Jest)"]);
          },
          "label": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Choose from the following filename patterns:"]);
          },
          "option1": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize([_interpolate(_list(0)), " (recommended)"]);
          },
          "option2": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Don't rename anything — keep what I have."]);
          },
          "option3": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Rename folder only."]);
          },
          "optOutAdditional": (ctx) => {
            const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
            return _normalize(["I may need to change my ", _interpolate(_list(0)), " later if I don't use the recommended filename extension."]);
          },
          "buttonSave": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Save changes"]);
          },
          "buttonCancel": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cancel"]);
          }
        }
      },
      "renameManual": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We need you to move your component specs manually"]);
        },
        "componentFolderRemoved": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["We've removed the ", _interpolate(_list(0)), " options from the Cypress config."]);
        },
        "addedSpecPattern": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["We've added a new ", _interpolate(_list(0)), " option in the Cypress config that tells us where to find your component specs."]);
        },
        "cannotAuto": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["We can't automatically migrate your existing component spec files. We recommend that you move the following component spec files next to your source component files (e.g. ", _interpolate(_list(0)), ")"]);
        },
        "ifSkipNote": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["If you skip this step, Cypress will still be able to find them, but any new specs that you create will automatically be created next to your component files."]);
        }
      },
      "renameSupport": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We'll automatically rename your existing E2E support file in this step"]);
        },
        "serveDifferentTypes": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We now serve different support files for E2E and Component Testing."]);
        },
        "changedSupportFile": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We've renamed the E2E support file from:"]);
        }
      },
      "configFile": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We need to migrate to the new Cypress configuration file"]);
        },
        "changedDefault": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We've changed the default Cypress config file from:"]);
        },
        "customOptions": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["We've set a custom ", _interpolate(_named("specPattern")), " option based on your ", _interpolate(_named("options")), "."]);
        },
        "willConvert": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["We'll automatically create a new ", _interpolate(_named("jsFile")), " file and seed it with your options from your existing ", _interpolate(_named("jsonFile")), "."]);
        }
      },
      "setupComponent": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You need to reconfigure Cypress for component testing"]);
        },
        "line1": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We've detected that you are currently using the experimental version of component testing."]);
        },
        "line2": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Your existing configuration is no longer compatible with new component testing configuration options."]);
        },
        "line3": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["In a previous step, we renamed your component specs, but can't automatically migrate your existing component testing configuration."]);
        },
        "line4": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["In the next screen, you'll be able to reconfigure component testing in a new guided configuration wizard."]);
        }
      },
      "wizard": {
        "title": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["Migrating to Cypress ", _interpolate(_named("version"))]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Your project requires updates to work with this version."]);
        },
        "typicalMigrationLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Typical migration:"]);
        },
        "typicalMigrationTime": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["5-10 minutes"]);
        },
        "step1": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Migrate existing specs"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["In this step, we'll automatically rename and/or move your existing spec files as needed."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Rename these specs for me"]);
          },
          "buttonSkip": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Skip renaming specs"]);
          },
          "buttonRenameFolder": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Rename the folder for me"]);
          }
        },
        "step2": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Move your existing component specs"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["In this step, you'll manually move your existing component specs to their new default location."]);
          },
          "buttonWait": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Waiting for you to move your component specs..."]);
          },
          "buttonDone": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Continue to next step"]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["I'll do this later"]);
          }
        },
        "step3": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Rename the Cypress support file"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["In this step, we'll automatically rename your existing support file."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Rename the support file for me"]);
          }
        },
        "step4": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Migrate to the new Cypress configuration file"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["In this step, we'll automatically migrate your existing Cypress configuration to the new Cypress configuration file."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Migrate the configuration for me"]);
          }
        },
        "step5": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Reconfigure component testing"]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["In this step, we'll explain how you will reconfigure Cypress for component testing."]);
          },
          "button": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Finish migration and continue"]);
          }
        }
      }
    },
    "majorVersionWelcome": {
      "title": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["What's New in Cypress"]);
      },
      "actionContinue": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Continue"]);
      },
      "linkReleaseNotes": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["View full changelog"]);
      }
    },
    "setupWizard": {
      "selectFramework": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Project setup"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Confirm the front-end framework and bundler used in your project."]);
        }
      },
      "installDependencies": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Install dev dependencies"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Based on your previous selection, the following dependencies are required."]);
        },
        "pasteCommand": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Paste this command into your terminal to install the following packages:"]);
        },
        "waitForInstall": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Waiting for you to install the dependencies..."]);
        },
        "installed": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["installed"]);
        },
        "pendingInstall": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["pending installation"]);
        },
        "installationAlertSuccess": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["You've successfully installed all required dependencies."]);
        }
      },
      "configFiles": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Configuration files"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["We added the following files to your project:"]);
        }
      },
      "chooseBrowser": {
        "title": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Choose a browser"]);
        },
        "description": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["Choose your preferred browser for ", _interpolate(_named("testingType")), " testing."]);
        }
      }
    },
    "e2eProjectSetup": {
      "title": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Project setup"]);
      },
      "description": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Confirm your project's preferred language."]);
      }
    },
    "openBrowser": {
      "startComponent": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
        return _normalize(["Start Component Testing in ", _interpolate(_named("browser"))]);
      },
      "startE2E": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
        return _normalize(["Start E2E Testing in ", _interpolate(_named("browser"))]);
      },
      "openingComponent": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
        return _normalize(["Opening Component Testing in ", _interpolate(_named("browser"))]);
      },
      "openingE2E": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
        return _normalize(["Opening E2E Testing in ", _interpolate(_named("browser"))]);
      },
      "running": (ctx) => {
        const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
        return _normalize(["Running ", _interpolate(_named("browser"))]);
      },
      "focus": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Focus"]);
      },
      "close": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Close"]);
      },
      "switchTestingType": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Switch testing type"]);
      }
    },
    "runner": {
      "header": {
        "reviewDocs": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Review the docs"]);
        },
        "troubleRendering": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["if you're having trouble rendering your components properly."]);
        }
      },
      "snapshot": {
        "highlightsLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Highlights"]);
        },
        "testsRunningError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cannot show snapshot while tests are running"]);
        },
        "snapshotMissingError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["The snapshot is missing. Displaying current state of the DOM."]);
        },
        "defaultTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["DOM snapshot"]);
        },
        "pinnedTitle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Pinned"]);
        },
        "studioActiveError": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cannot show snapshot while creating commands in Studio"]);
        }
      },
      "selectorPlayground": {
        "matches": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named, plural: _plural } = ctx;
          return _plural([_normalize(["No matches"]), _normalize([_interpolate(_named("n")), " match"]), _normalize([_interpolate(_named("n")), " matches"])]);
        },
        "playgroundTooltip": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Click an element to see a suggested selector"]);
        },
        "copyTooltip": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Copy to clipboard"]);
        },
        "copyTooltipAction": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Copied!"]);
        },
        "printTooltip": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Print to console"]);
        },
        "printTooltipAction": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Printed!"]);
        },
        "invalidSelector": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Invalid"]);
        },
        "selectorMethodsLabel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Selector methods"]);
        },
        "toggle": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Toggle playground"]);
        }
      },
      "automation": {
        "disconnected": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["The Cypress extension has disconnected."]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cypress cannot run tests without this extension."]);
          },
          "reload": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Reload the browser"]);
          }
        },
        "missing": {
          "title": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["The Cypress extension is missing."]);
          },
          "description": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Cypress cannot run tests without this extension. Please choose another browser."]);
          }
        },
        "shared": {
          "link": (ctx) => {
            const { normalize: _normalize } = ctx;
            return _normalize(["Read more about browser management"]);
          }
        }
      },
      "viewportTooltip": {
        "buttonText": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Review the guide on viewports"]);
        },
        "buttonHref": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["https://on.cypress.io/viewport"]);
        },
        "infoText": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["The viewport determines the width and height of your application under test. By default the viewport will be ", _interpolate(_list(0)), " by ", _interpolate(_list(1)), " for ", _interpolate(_list(2)), " testing."]);
        },
        "configText": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, named: _named } = ctx;
          return _normalize(["Additionally, you can override this value in your ", _interpolate(_named("configFile")), " or via the ", _interpolate(_named("viewportCommand")), " command."]);
        }
      },
      "studio": {
        "studio": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Studio"]);
        },
        "studioDescription": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Generate Cypress commands by interacting with your site as an end user would. Then, save these commands directly to your test file."]);
        },
        "studioDetailedDescription": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Generate and save commands directly to your test suite by interacting with your app as an end user would. Right click on an element to add an assertion. Studio will track events that generate the following commands:"]);
        },
        "getStartedButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Get started"]);
        },
        "feedbackPrompt": (ctx) => {
          const { normalize: _normalize, interpolate: _interpolate, list: _list } = ctx;
          return _normalize(["Your ", _interpolate(_list(0)), " will be highly influential to our team."]);
        },
        "experimentalMessage": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["This feature is currently experimental and we will be adding more commands and abilities in the future."]);
        },
        "feedbackLink": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["feedback"]);
        },
        "saveTest": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Save test"]);
        },
        "testName": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Test name"]);
        },
        "saveTestButton": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Save"]);
        },
        "closeStudio": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Close Studio"]);
        },
        "restartStudio": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Restart Studio"]);
        },
        "copyCommands": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Copy commands to clipboard"]);
        },
        "commandsCopied": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Commands copied!"]);
        },
        "availableCommands": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Available commands"]);
        },
        "giveFeedback": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Give feedback"]);
        },
        "enterValidUrl": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Enter a valid URL to visit"]);
        },
        "continue": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Continue"]);
        },
        "actionCancel": (ctx) => {
          const { normalize: _normalize } = ctx;
          return _normalize(["Cancel"]);
        }
      }
    },
    "warnings": {
      "retry": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Try again"]);
      }
    },
    "versions": {
      "alpha": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Alpha"]);
      },
      "beta": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["Beta"]);
      },
      "new": (ctx) => {
        const { normalize: _normalize } = ctx;
        return _normalize(["New"]);
      }
    }
  }
};
const rawJsonMessages = `{
  "links": {
    "learnMore": "Learn more.",
    "learnMoreButton": "Learn more",
    "needHelp": "Need help"
  },
  "components": {
    "modal": {
      "dismiss": "Dismiss"
    },
    "fileSearch": {
      "noMatchesForExtension": "No files found when searching for the file extension",
      "noMatchesForFileName": "",
      "byFilenameInput": "Search by filename...",
      "byExtensionInput": "Extensions to include e.g. *.tsx, *.vue",
      "matchesIndicatorEmptyFileSearch": "No matches | 1 match | { denominator } matches",
      "matchesIndicator": "No matches | {numerator} of {denominator} matches | {numerator} of {denominator} matches"
    },
    "button": {
      "cancel": "Cancel",
      "back": "Back"
    },
    "loading": {
      "config": {
        "title": "Initializing config...",
        "description": "Please wait while we load your project and find browsers installed on your system"
      }
    },
    "select": {
      "placeholder": "Choose an option..."
    },
    "alert": {
      "dismissAriaLabel": "Dismiss"
    },
    "specPattern": {
      "matches": "No matches | {n} match | {n} matches"
    },
    "specPatternModal": {
      "title": "Spec pattern settings"
    }
  },
  "clipboard": {
    "copy": "Copy",
    "copied": "Copied!"
  },
  "actions": {
    "close": "Close"
  },
  "file": {
    "edit": "Edit",
    "git": {
      "modified": "Modified",
      "created": "Created"
    }
  },
  "status": {
    "enabled": "Enabled",
    "disabled": "Disabled"
  },
  "createSpec": {
    "newSpec": "New spec",
    "createSpec": "Create spec",
    "done": "Done!",
    "noComponentsFound": "No components found",
    "unableToParseFile": "Unable to parse file",
    "updateSpecPattern": "Update spec pattern",
    "newSpecModalTitle": "Create new spec",
    "successPage": {
      "header": "Great! The spec was successfully added",
      "runSpecButton": "Okay, run the spec",
      "createAnotherSpecButton": "Create another spec"
    },
    "page": {
      "defaultPatternNoSpecs": {
        "title": "Create your first spec",
        "component": {
          "description": "Since this project looks new, we recommend that you get started by creating a spec for one of your components."
        },
        "e2e": {
          "description": "Since this project looks new, we recommend that you use the specs and tests that we've written for you to get started."
        }
      },
      "customPatternNoSpecs": {
        "title": "No specs found",
        "description": "We couldn't find any files matching the following spec patterns. You may need to move your specs or update your {0} to find them."
      }
    },
    "noSpecsMessage": "If you feel that you're seeing this screen in error, and there should be specs listed here, you likely need to update the spec pattern.",
    "viewSpecPatternButton": "View spec pattern",
    "e2e": {
      "importFromScaffold": {
        "header": "Scaffold example specs",
        "description": "We'll generate several example specs to help guide you on how to write tests in Cypress.",
        "specsAddedHeader": "Great! We added the following files to your project:",
        "specsAddedButton": "Okay, I got it!",
        "specsAddingHeader": "Adding specs..."
      },
      "importTemplateSpec": {
        "header": "Create new spec",
        "description": "We'll generate a template spec file which can be used to start testing your application.",
        "chooseFilenameHeader": "Enter the path for your new spec",
        "inputPlaceholder": "Enter a relative path...",
        "invalidSpecWarning": "This path is invalid because it doesn't match the following ",
        "specExtensionWarning": "We recommend naming your spec to match the following pattern: "
      }
    },
    "component": {
      "importFromComponent": {
        "header": "Create from component",
        "description": "Generate a basic component test for any of the components in this project.",
        "chooseAComponentHeader": "Choose a component"
      },
      "importTemplateSpec": {
        "header": "Create new spec",
        "description": "We'll generate a template spec file which can be used to start testing your components.",
        "invalidComponentWarning": "We couldn't generate a valid path matching your custom "
      }
    }
  },
  "specPage": {
    "pageTitle": "Specs",
    "newSpecButton": "New spec",
    "searchPlaceholder": "Search specs",
    "clearSearch": "Clear search field",
    "componentSpecsHeader": "Component specs",
    "e2eSpecsHeader": "E2E specs",
    "lastUpdated": {
      "header": "Last updated",
      "tooltip": {
        "gitStatus": "Git status",
        "gitInfo": "git info",
        "gitInfoAvailable": "{0} of the spec files within this project",
        "gitInfoUnavailable": "Cypress is unable to detect {0} for this project and has defaulted to showing file system data instead"
      }
    },
    "latestRuns": {
      "header": "Latest runs",
      "headerShort": "Runs",
      "tooltip": {
        "connected": "The {0} in Cypress Cloud",
        "notConnected": "Connect to Cypress Cloud to see the {0}",
        "noAccess": "Request access to this project in Cypress Cloud to view the {0}",
        "linkText": "status of your latest runs"
      }
    },
    "averageDuration": {
      "header": "Average duration",
      "headerShort": "Duration",
      "tooltip": {
        "connected": "The {0} of your latest runs in Cypress Cloud",
        "notConnected": "Connect to Cypress Cloud to see the {0} of your latest runs",
        "noAccess": "Request access to this project in Cypress Cloud to view the {0} of your latest runs",
        "linkText": "average spec durations"
      }
    },
    "flaky": {
      "badgeLabel": "Flaky",
      "severityLow": "Low",
      "severityMedium": "Medium",
      "severityHigh": "High",
      "flakyRate": "{0}% flaky rate",
      "flakyRuns": "{flakyRuns} flaky runs / {totalRuns} total | {flakyRuns} flaky run / {totalRuns} total | {flakyRuns} flaky runs / {totalRuns} total",
      "lastFlaky": "Last run flaky | Last flaky {runsSinceLastFlake} run ago | Last flaky {runsSinceLastFlake} runs ago"
    },
    "hoverButton": {
      "connect": "Connect",
      "connectProject": "Connect project",
      "connectProjectShort": "Connect",
      "requestAccess": "Request access",
      "requestAccessShort": "Request",
      "requestSent": "Request sent",
      "requestSentShort": "Sent"
    },
    "connectProjectButton": "Connect your project",
    "cloudLoginButton": "Log in to Cypress Cloud",
    "reconnectProjectButton": "Reconnect your project",
    "unauthorizedBannerTitle": "Request access to project",
    "requestAccessButton": "Request access",
    "requestSentButton": "Request sent",
    "rows": {
      "gitTooltipSubtext": "{shortHash} by {author}"
    },
    "noResultsMessage": "No specs matched your search:",
    "noSpecError": {
      "title": "Spec not found",
      "intro": "There is no spec matching the following location:",
      "explainer": "It is possible that the file has been moved or deleted. Please choose from the list of specs below."
    },
    "offlineWarning": {
      "title": "No internet connection",
      "explainer": "Please check your internet connection to resolve this issue. When your internet connection is fixed, we will automatically attempt to fetch the run metrics from Cypress Cloud."
    },
    "fetchFailedWarning": {
      "title": "Lost connection",
      "explainer1": "The request timed out or failed when trying to retrieve the recorded run metrics from Cypress Cloud. The information that you're seeing in the table below may be incomplete as a result.",
      "explainer2": "Please refresh the page to try again and visit our {0} if this behavior continues.",
      "refreshButton": "Try again"
    },
    "banners": {
      "login": {
        "title": "Optimize and record your CI test runs with Cypress Cloud",
        "contentA": "Parallelize your tests in CI and visualize every error by watching full video recordings of each test you run.",
        "contentB": "When you configure Cypress to record tests to Cypress Cloud, you'll see data from your latest recorded runs in the Cypress app. This increased visibility into your test history allows you to debug your tests faster and more effectively, all within your local workflow.",
        "buttonLabel": "Get started with Cypress Cloud"
      },
      "createOrganization": {
        "titleA": "Finish setting up Cypress Cloud",
        "titleB": "Create or join an organization",
        "content": "Join or create an organization in Cypress Cloud to access your projects and recorded test runs.",
        "buttonLabel": "Set up your organization"
      },
      "connectProject": {
        "title": "Connect your project to Cypress Cloud",
        "contentA": "View recorded test runs directly in the Cypress app to monitor, run, and fix tests locally.",
        "contentB": "Bring your recorded test results into your local development workflow to monitor, run, and fix tests all in the Cypress app.",
        "buttonLabel": "Connect your project"
      },
      "record": {
        "title": "Record your first run",
        "content": "Record a run to see your test results in Cypress Cloud. You can then optimize your test suite, debug failing and flaky tests, and integrate with your favorite tools."
      }
    },
    "runSelectedSpecs": "Run {n} spec | Run {n} specs"
  },
  "noResults": {
    "defaultMessage": "No results matched your search:",
    "clearSearch": "Clear search"
  },
  "sidebar": {
    "keyboardShortcuts": {
      "title": "Keyboard shortcuts",
      "rerun": "Re-run tests",
      "stop": "Stop tests",
      "toggle": "Toggle specs list"
    },
    "toggleLabel": {
      "expanded": "Collapse sidebar",
      "collapsed": "Expand sidebar"
    },
    "nav": {
      "ariaLabel": "Pages"
    }
  },
  "topNav": {
    "released": "Released",
    "version": "Version",
    "versionUnsupported": "Unsupported",
    "installed": "Installed",
    "latest": "Latest",
    "seeAllReleases": "See all releases",
    "runningOldVersion": "You're currently running an old version of Cypress. Update to the latest version for the best experience.",
    "docsMenu": {
      "docsHeading": "Docs",
      "gettingStartedTitle": "Getting started",
      "firstTest": "Write your first test",
      "testingApp": "Testing your app",
      "organizingTests": "Organizing tests",
      "referencesTitle": "References",
      "bestPractices": "Best practices",
      "configuration": "Configuration",
      "api": "API",
      "ciTitle": "Run in CI/CD",
      "ciSetup": "Set up CI",
      "fasterTests": "Run tests faster",
      "prompts": {
        "ci1": {
          "title": "Configure CI",
          "description": "Optimize your tests in CI by following these guides.",
          "seeOtherGuides": "See other guides",
          "intro": "Introduction to CI",
          "learnTheBasics": "Learn the basics of running Cypress in CI."
        },
        "orchestration1": {
          "title": "Run tests faster in CI",
          "parallelTime": "5 mins",
          "noParallelTime": "12 mins",
          "withParallelization": "with Parallelization",
          "withoutParallelization": "without Parallelization",
          "intro": "With Smart Orchestration, you'll be able to:",
          "bullet1": "Run spec files in parallel",
          "bullet2": "Prioritize failed specs to run first",
          "bullet3": "Cancel CI runs on test failure",
          "learnMore": "Learn more"
        }
      }
    },
    "login": {
      "bodyInitial": "Logging in gives you access to {0}. You can set up projects to be recorded and see test data from your project.",
      "bodySuccess": "You are now logged in as {0}.",
      "bodyError": "An error occurred while attempting to log in:",
      "bodyBrowserError": "The browser could not be opened.",
      "bodyBrowserErrorDetails": "Cypress was unable to open your installed browser. To continue logging in, please paste this URL into your web browser:",
      "cloud": "Cypress Cloud",
      "titleInitial": "Log in to Cypress",
      "titleSuccess": "Login successful",
      "titleFailed": "Login failed",
      "titleBrowserError": "Browser error",
      "actionLogin": "Log in",
      "profileMenuLabel": "Profile and logout",
      "actionLogout": "Log out",
      "actionContinue": "Continue",
      "actionOpening": "Opening browser",
      "actionWaiting": "Waiting for you to log in",
      "actionTryAgain": "Try again",
      "actionCancel": "Cancel"
    },
    "updateCypress": {
      "title": "Upgrade to Cypress",
      "currentlyRunning": "You are currently running Version {0} of Cypress. ",
      "pasteToUpgradeProject": "To upgrade to the latest version for your project, first {0}, then paste the command below into your terminal:",
      "pasteToUpgradeGlobal": "To upgrade to the latest version, first {0}, then paste the command below into your terminal:",
      "rememberToCloseInsert": "close this app"
    },
    "upgradeText": "Upgrade",
    "global": {
      "projects": "Projects"
    }
  },
  "launchpadErrors": {
    "generic": {
      "configErrorTitle": "Cypress configuration error",
      "retryButton": "Try again",
      "stackTraceLabel": "Stack trace",
      "docsButton": {
        "configGuide": {
          "text": "Configuration guide",
          "link": "https://docs.cypress.io/guides/references/configuration"
        },
        "cloudGuide": {
          "text": "Cypress Cloud guide",
          "link": "https://on.cypress.io/features-dashboard"
        },
        "docsHomepage": {
          "text": "Cypress docs",
          "link": "https://docs.cypress.io"
        }
      }
    },
    "noInternet": {
      "header": "You have no internet connection",
      "message": "Check your internet connection to pull the latest data from Cypress Cloud.",
      "connectProject": "Please check your internet connection to resolve this issue. When your internet connection is fixed, we will automatically attempt to fetch your latest runs for this project."
    }
  },
  "setupPage": {
    "projectSetup": {
      "frameworkLabel": "Front-end framework",
      "frameworkPlaceholder": "Pick a framework",
      "bundlerLabel": "Bundler",
      "bundlerLabelDescription": "(dev server)",
      "bundlerPlaceholder": "Pick a bundler",
      "languageLabel": "Language",
      "configFileLanguageLabel": "Cypress config file",
      "detected": "(detected)"
    },
    "step": {
      "continue": "Continue",
      "next": "Next step",
      "back": "Back",
      "skip": "Skip"
    },
    "configFile": {
      "createManually": "Create file manually",
      "skippedLabel": "Skipped",
      "changesRequiredLabel": "Changes required",
      "changesRequiredBadge": "Changes required",
      "changesRequiredDescription": "Please merge the code below with your existing {0}"
    },
    "testingCard": {
      "configured": "Configured",
      "notConfigured": "Not Configured",
      "running": "Running",
      "chooseABrowser": "Choose a browser",
      "reconfigure": "Reconfigure",
      "disabled": "Disabled"
    }
  },
  "globalPage": {
    "empty": {
      "title": "Add project",
      "helper": "Get started by adding your first project below.",
      "dropText": "Drag your project directory here or {0}",
      "browseManually": "browse manually."
    },
    "settings": "Settings",
    "saveChanges": "Save changes",
    "cancel": "Cancel",
    "externalEditorPreferences": "External editor preferences",
    "externalEditorPreferencesDescription1": "Select your preference for opening files on your system.",
    "externalEditorPreferencesDescription2": "You can change this later in the {0} page.",
    "recentProjectsHeader": "Recent projects",
    "searchPlaceholder": "Search projects",
    "addProjectButton": "Add project",
    "projectActions": "Project actions",
    "removeProject": "Remove project",
    "openInIDE": "Open in IDE",
    "openInFinder": "Open in Finder",
    "noResultsMessage": "No projects matched your search:"
  },
  "welcomePage": {
    "review": "Review the differences between each testing type",
    "codeExample": "Code example",
    "compareTypes": {
      "content": {
        "e2eTitle": "End-to-end tests",
        "e2eBullet1": "Visit URLs via",
        "e2eBullet2": "Test flows and functionality across multiple pages",
        "e2eBullet3": "Ideal for testing integrated flows in CD workflows",
        "componentTitle": "Component tests",
        "ctBullet1": "Import components via",
        "ctBullet2": "Test individual components of a design system in isolation",
        "ctBullet3": "Ideal for testing isolated flows and components in CI"
      },
      "modalTitle": "Key differences"
    },
    "title": "Welcome to Cypress!"
  },
  "settingsPage": {
    "config": {
      "title": "Resolved configuration",
      "description": "Since the options in the {0} can be set dynamically by your development environment, please refer to the legend below to understand how the configuration options are resolved.",
      "legend": {
        "env": {
          "label": "env",
          "description": "Set from environment variables"
        },
        "default": {
          "label": "default",
          "description": "Default values"
        },
        "dynamic": {
          "label": "dynamic",
          "description": "Set by the {0} function"
        },
        "cli": {
          "label": "cli",
          "description": "Set from CLI arguments"
        },
        "config": {
          "label": "config",
          "description": "Set from {0}"
        }
      }
    },
    "proxy": {
      "title": "Proxy settings",
      "description": "Cypress auto-detected the following proxy settings from your operating system.",
      "bypassList": "Proxy bypass list",
      "proxyServer": "Proxy server"
    },
    "editor": {
      "title": "External editor",
      "description": "External editor to use for editing code opened when using Cypress.",
      "noEditorSelectedPlaceholder": "Choose your editor...",
      "customPathPlaceholder": "/path/to/editor"
    },
    "projectId": {
      "title": "Project ID",
      "description": "The Project ID configured for this project inside of Cypress Cloud. {0}"
    },
    "specPattern": {
      "title": "Spec patterns",
      "description": "The globs pointing Cypress to your spec files configured for this project. {0}"
    },
    "recordKey": {
      "title": "Record key",
      "description": "The Record Key configured for this project inside of Cypress Cloud. {0}",
      "manageKeys": "Manage keys",
      "errorEmpty": "You do not have permission to record on this project",
      "errorEmptyButton": "Request record rights",
      "errorAccess": "You do not have permission to view this project",
      "errorAccessPending": "Your request for access to this project is pending approval",
      "errorAccessButton": "Request access",
      "errorNotFound": "Project not found",
      "errorNotFoundButton": "Connect it again",
      "errorNotLoggedIn": "You are not connected to Cypress Cloud",
      "errorNotLoggedInButton": "Log in to Cypress Cloud"
    },
    "project": {
      "title": "Project settings",
      "description": "Review the configuration settings currently in use for this project."
    },
    "cloud": {
      "title": "Cypress Cloud settings",
      "description": "Review the configuration settings for recording to Cypress Cloud."
    },
    "experiments": {
      "title": "Experiments",
      "description": "If you'd like to try out new features that we're working on, you can enable beta features for your project by turning on the experimental features you'd like to try. {0}",
      "experimentalFetchPolyfill": {
        "name": "Fetch polyfill",
        "description": "Automatically replaces \`window.fetch\` with a polyfill that Cypress can spy on and stub. Note: \`experimentalFetchPolyfill\` has been deprecated in Cypress 6.0.0 and will be removed in a future release. Consider using [\`cy.intercept()\`](https://on.cypress.io/intercept) to intercept \`fetch\` requests instead."
      },
      "experimentalInteractiveRunEvents": {
        "name": "Interactive run events",
        "description": "Allows listening to the [\`before:run\`](https://on.cypress.io/before-run), [\`after:run\`](https://on.cypress.io/after-run), [\`before:spec\`](https://on.cypress.io/before-spec), and [\`after:spec\`](https://on.cypress.io/after-spec) events in plugins during interactive mode."
      },
      "experimentalModifyObstructiveThirdPartyCode": {
        "name": "Modify obstructive third party code",
        "description": "Applies \`modifyObstructiveCode\` to third party \`.html\` and \`.js\`, removes subresource integrity, and modifies the user agent in Electron."
      },
      "experimentalSingleTabRunMode": {
        "name": "Single tab run mode",
        "description": "Runs all component specs in a single tab, trading spec isolation for faster run mode execution."
      },
      "experimentalSourceRewriting": {
        "name": "Source rewriting",
        "description": "Enables AST-based JS/HTML rewriting. This may fix issues caused by the existing regex-based JS/HTML replacement algorithm. See [#5273](https://github.com/cypress-io/cypress/issues/5273) for details."
      },
      "experimentalStudio": {
        "name": "Studio",
        "description": "Generate and save commands directly to your test suite by interacting with your app as an end user would."
      },
      "experimentalWebKitSupport": {
        "name": "WebKit Support",
        "description": "Adds support for testing in the WebKit browser engine used by Safari. See https://on.cypress.io/webkit-experiment for more information."
      },
      "experimentalRunAllSpecs": {
        "name": "Run All Specs",
        "description": "Enables the \\"Run All Specs\\" UI feature, allowing the execution of multiple specs sequentially."
      },
      "experimentalOriginDependencies": {
        "name": "Origin Dependencies",
        "description": "Enables support for \`require\`/\`import\` within \`cy.origin\`."
      }
    },
    "device": {
      "title": "Device settings",
      "description": "Review the configuration settings currently in use for this device."
    },
    "testingPreferences": {
      "title": "Testing preferences",
      "description": "Configure your testing environment with these flags",
      "autoScrollingEnabled": {
        "title": "Auto scrolling enabled",
        "description": "Scroll behavior when running tests."
      }
    },
    "footer": {
      "text": "You can reconfigure the {testingType} testing settings for this project if you're experiencing issues with your Cypress configuration.",
      "button": "Configuration guide",
      "buttonLink": "https://docs.cypress.io/guides/references/configuration"
    }
  },
  "runs": {
    "connect": {
      "title": "View your recorded runs from Cypress Cloud",
      "smartText": "Scale your test runs with built-in Smart Orchestration.",
      "debugText": "Debug tests that fail in CI with visual feedback.",
      "chartText": "Keep your tests in tip-top shape with powerful analytics.",
      "buttonUser": "Log in to Cypress Cloud",
      "buttonProject": "Connect your project to Cypress Cloud",
      "modal": {
        "title": "Connect project",
        "cancel": "Cancel",
        "createOrg": {
          "description": "You need to create an organization in Cypress Cloud to continue.",
          "button": "Create organization",
          "waitingButton": "Waiting for you to create an organization...",
          "refreshButton": "Refresh organizations list"
        },
        "selectProject": {
          "organization": "Organization",
          "noOrganizationSelectedError": "required when creating a new project",
          "manageOrgs": "Manage organizations",
          "project": "Project",
          "projectName": "Project name",
          "projectNameDisclaimer": "(You can change this later)",
          "createNewProject": "Create new",
          "chooseExistingProject": "Choose an existing project",
          "newProjectAccess": "Project access",
          "privateLabel": "Private",
          "privateDescription": "Only invited users can view recorded test results.",
          "publicLabel": "Public",
          "publicDescription": "Anyone can view recorded test results.",
          "connectProject": "Connect project",
          "createProject": "Create project",
          "placeholderOrganizations": "Pick an organization",
          "placeholderProjects": "Pick a project",
          "placeholderProjectsPending": "Pick an organization first"
        },
        "connectManually": {
          "title": "Connect project manually",
          "warning": "We couldn't add the projectId to your cypress.config.js file automatically.",
          "mainMessage": "Manually add the {projectId} to the root of the config object in your {configFile} file.",
          "waitingButton": "Waiting for you to add the projectId..."
        }
      },
      "errors": {
        "baseError": {
          "title": "Cypress Cloud error"
        },
        "internalServerError": {
          "title": "Cannot connect to Cypress Cloud",
          "description": "The request times out when trying to retrieve the info from Cypress Cloud. Please refresh the page to try again and visit out {0} if this behavior continues.",
          "link": "Support Page"
        }
      }
    },
    "connectSuccessAlert": {
      "title": "This project is now connected to Cypress Cloud!",
      "item1": "We automatically added the {projectId} to your {configFile} file.",
      "item2": "Please ensure that your {0} file is checked into source control."
    },
    "empty": {
      "title": "Record your first run to Cypress Cloud",
      "description": "Run the command below in your local development terminal or in CI."
    },
    "results": {
      "skipped": "skipped",
      "pending": "pending",
      "passed": "passed",
      "failed": "failed"
    },
    "errors": {
      "notFound": {
        "title": "Couldn't find your project",
        "description": "We were unable to find an existing project matching the {0} set in your Cypress config file. You can reconnect with an existing project or create a new project.",
        "button": "Reconnect your project"
      },
      "unauthorized": {
        "title": "Request access to view the recorded runs",
        "description": "This is a private project that you do not currently have access to. Please request access from the project owner in order to view the list of runs.",
        "button": "Request access"
      },
      "unauthorizedRequested": {
        "title": "Your access request for this project has been sent.",
        "description": "The owner of this project has been notified of your request. We'll notify you via email when your access request has been granted.",
        "button": "Request Sent"
      },
      "connectionFailed": {
        "title": "Cannot connect to Cypress Cloud",
        "description": "The request times out when trying to retrieve the recorded runs from Cypress Cloud. Please refresh the page to try again and visit out {0} if this behavior continues.",
        "link": "Support page",
        "button": "Try again"
      }
    }
  },
  "testingType": {
    "modalTitle": "Choose a testing type",
    "e2e": {
      "name": "E2E Testing",
      "description": "Build and test the entire experience of your application from end-to-end to ensure each flow matches your expectations."
    },
    "component": {
      "name": "Component Testing",
      "description": "Build and test your components from your design system in isolation in order to ensure each state matches your expectations."
    },
    "componentDisabled": {
      "description": "To test your components you must {0} as an NPM dependency for this project.",
      "link": "install Cypress"
    }
  },
  "migration": {
    "before": "Before",
    "after": "After",
    "heresWhy": "here's why:",
    "renameAuto": {
      "title": "We recommend automatically renaming your specs in this step",
      "changeButton": "change",
      "changedSpecFolder": "We've changed the default spec folder from:",
      "changedSpecExt": "We've changed the default spec file extension from:",
      "changedSpecPatternExplain": "We've changed the default spec file extension to {0} in order to avoid conflicts with any existing testing frameworks.",
      "optedOutMessage": "You've opted not to rename your spec file extension. You may need to change your specPattern later so we can still find your spec files.",
      "folderRenameMessage": "You've opted not to rename your spec file extension, we'll only rename the folder",
      "modal": {
        "title": "Change the existing spec file extension",
        "warning": "We recommend using the default extension to avoid inconsistencies, framework conflicts, and confusion with your team.",
        "line1": "Cypress now supports the ability to create new spec files from within the UI for both E2E and component specs.",
        "line2": "All new spec files created within Cypress will use the default pattern of: ",
        "line3": "We want to rename your existing specs so that they have a consistent filename pattern for both E2E and component testing.",
        "line4": "All documentation and example code will be using: ",
        "line5": "We've changed the placement of component specs to be next to their source files (e.g. src/Button.jsx and src/Button.cy.jsx)",
        "line6": "The new default pattern of {0} prevents targeting conflicts with other testing frameworks. (e.g. Jest)",
        "label": "Choose from the following filename patterns:",
        "option1": "{0} (recommended)",
        "option2": "Don't rename anything — keep what I have.",
        "option3": "Rename folder only.",
        "optOutAdditional": "I may need to change my {0} later if I don't use the recommended filename extension.",
        "buttonSave": "Save changes",
        "buttonCancel": "Cancel"
      }
    },
    "renameManual": {
      "title": "We need you to move your component specs manually",
      "componentFolderRemoved": "We've removed the {0} options from the Cypress config.",
      "addedSpecPattern": "We've added a new {0} option in the Cypress config that tells us where to find your component specs.",
      "cannotAuto": "We can't automatically migrate your existing component spec files. We recommend that you move the following component spec files next to your source component files (e.g. {0})",
      "ifSkipNote": "If you skip this step, Cypress will still be able to find them, but any new specs that you create will automatically be created next to your component files."
    },
    "renameSupport": {
      "title": "We'll automatically rename your existing E2E support file in this step",
      "serveDifferentTypes": "We now serve different support files for E2E and Component Testing.",
      "changedSupportFile": "We've renamed the E2E support file from:"
    },
    "configFile": {
      "title": "We need to migrate to the new Cypress configuration file",
      "changedDefault": "We've changed the default Cypress config file from:",
      "customOptions": "We've set a custom {specPattern} option based on your {options}.",
      "willConvert": "We'll automatically create a new {jsFile} file and seed it with your options from your existing {jsonFile}."
    },
    "setupComponent": {
      "title": "You need to reconfigure Cypress for component testing",
      "line1": "We've detected that you are currently using the experimental version of component testing.",
      "line2": "Your existing configuration is no longer compatible with new component testing configuration options.",
      "line3": "In a previous step, we renamed your component specs, but can't automatically migrate your existing component testing configuration.",
      "line4": "In the next screen, you'll be able to reconfigure component testing in a new guided configuration wizard."
    },
    "wizard": {
      "title": "Migrating to Cypress {version}",
      "description": "Your project requires updates to work with this version.",
      "typicalMigrationLabel": "Typical migration:",
      "typicalMigrationTime": "5-10 minutes",
      "step1": {
        "title": "Migrate existing specs",
        "description": "In this step, we'll automatically rename and/or move your existing spec files as needed.",
        "button": "Rename these specs for me",
        "buttonSkip": "Skip renaming specs",
        "buttonRenameFolder": "Rename the folder for me"
      },
      "step2": {
        "title": "Move your existing component specs",
        "description": "In this step, you'll manually move your existing component specs to their new default location.",
        "buttonWait": "Waiting for you to move your component specs...",
        "buttonDone": "Continue to next step",
        "button": "I'll do this later"
      },
      "step3": {
        "title": "Rename the Cypress support file",
        "description": "In this step, we'll automatically rename your existing support file.",
        "button": "Rename the support file for me"
      },
      "step4": {
        "title": "Migrate to the new Cypress configuration file",
        "description": "In this step, we'll automatically migrate your existing Cypress configuration to the new Cypress configuration file.",
        "button": "Migrate the configuration for me"
      },
      "step5": {
        "title": "Reconfigure component testing",
        "description": "In this step, we'll explain how you will reconfigure Cypress for component testing.",
        "button": "Finish migration and continue"
      }
    }
  },
  "majorVersionWelcome": {
    "title": "What's New in Cypress",
    "actionContinue": "Continue",
    "linkReleaseNotes": "View full changelog"
  },
  "setupWizard": {
    "selectFramework": {
      "title": "Project setup",
      "description": "Confirm the front-end framework and bundler used in your project."
    },
    "installDependencies": {
      "title": "Install dev dependencies",
      "description": "Based on your previous selection, the following dependencies are required.",
      "pasteCommand": "Paste this command into your terminal to install the following packages:",
      "waitForInstall": "Waiting for you to install the dependencies...",
      "installed": "installed",
      "pendingInstall": "pending installation",
      "installationAlertSuccess": "You've successfully installed all required dependencies."
    },
    "configFiles": {
      "title": "Configuration files",
      "description": "We added the following files to your project:"
    },
    "chooseBrowser": {
      "title": "Choose a browser",
      "description": "Choose your preferred browser for {testingType} testing."
    }
  },
  "e2eProjectSetup": {
    "title": "Project setup",
    "description": "Confirm your project's preferred language."
  },
  "openBrowser": {
    "startComponent": "Start Component Testing in {browser}",
    "startE2E": "Start E2E Testing in {browser}",
    "openingComponent": "Opening Component Testing in {browser}",
    "openingE2E": "Opening E2E Testing in {browser}",
    "running": "Running {browser}",
    "focus": "Focus",
    "close": "Close",
    "switchTestingType": "Switch testing type"
  },
  "runner": {
    "header": {
      "reviewDocs": "Review the docs",
      "troubleRendering": "if you're having trouble rendering your components properly."
    },
    "snapshot": {
      "highlightsLabel": "Highlights",
      "testsRunningError": "Cannot show snapshot while tests are running",
      "snapshotMissingError": "The snapshot is missing. Displaying current state of the DOM.",
      "defaultTitle": "DOM snapshot",
      "pinnedTitle": "Pinned",
      "studioActiveError": "Cannot show snapshot while creating commands in Studio"
    },
    "selectorPlayground": {
      "matches": "No matches | {n} match | {n} matches",
      "playgroundTooltip": "Click an element to see a suggested selector",
      "copyTooltip": "Copy to clipboard",
      "copyTooltipAction": "Copied!",
      "printTooltip": "Print to console",
      "printTooltipAction": "Printed!",
      "invalidSelector": "Invalid",
      "selectorMethodsLabel": "Selector methods",
      "toggle": "Toggle playground"
    },
    "automation": {
      "disconnected": {
        "title": "The Cypress extension has disconnected.",
        "description": "Cypress cannot run tests without this extension.",
        "reload": "Reload the browser"
      },
      "missing": {
        "title": "The Cypress extension is missing.",
        "description": "Cypress cannot run tests without this extension. Please choose another browser."
      },
      "shared": {
        "link": "Read more about browser management"
      }
    },
    "viewportTooltip": {
      "buttonText": "Review the guide on viewports",
      "buttonHref": "https://on.cypress.io/viewport",
      "infoText": "The viewport determines the width and height of your application under test. By default the viewport will be {0} by {1} for {2} testing.",
      "configText": "Additionally, you can override this value in your {configFile} or via the {viewportCommand} command."
    },
    "studio": {
      "studio": "Studio",
      "studioDescription": "Generate Cypress commands by interacting with your site as an end user would. Then, save these commands directly to your test file.",
      "studioDetailedDescription": "Generate and save commands directly to your test suite by interacting with your app as an end user would. Right click on an element to add an assertion. Studio will track events that generate the following commands:",
      "getStartedButton": "Get started",
      "feedbackPrompt": "Your {0} will be highly influential to our team.",
      "experimentalMessage": "This feature is currently experimental and we will be adding more commands and abilities in the future.",
      "feedbackLink": "feedback",
      "saveTest": "Save test",
      "testName": "Test name",
      "saveTestButton": "Save",
      "closeStudio": "Close Studio",
      "restartStudio": "Restart Studio",
      "copyCommands": "Copy commands to clipboard",
      "commandsCopied": "Commands copied!",
      "availableCommands": "Available commands",
      "giveFeedback": "Give feedback",
      "enterValidUrl": "Enter a valid URL to visit",
      "continue": "Continue",
      "actionCancel": "Cancel"
    }
  },
  "warnings": {
    "retry": "Try again"
  },
  "versions": {
    "alpha": "Alpha",
    "beta": "Beta",
    "new": "New"
  }
}
`;
const defaultMessages = JSON.parse(rawJsonMessages);
createI18n();
function createI18n(opts = {}) {
  return createI18n$1({
    locale: "en-US",
    messages: compiledMessages,
    ...opts
  });
}
function useI18n() {
  return useI18n$1({ useScope: "global" });
}
const _hoisted_1$1w = {
  height: "1em",
  width: "1em",
  style: { "min-width": "16px", "min-height": "16px" },
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1n = /* @__PURE__ */ createBaseVNode("path", {
  d: "M13 8C13 10.7614 10.7614 13 8 13C5.23858 13 3 10.7614 3 8C3 5.23858 5.23858 3 8 3H11M11 3L9 5M11 3L9 1",
  stroke: "currentColor",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round",
  class: "icon-light"
}, null, -1);
const _hoisted_3$1b = [
  _hoisted_2$1n
];
function render$Q(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1w, _hoisted_3$1b);
}
const __unplugin_components_3$1 = { name: "cy-action-restart_x16", render: render$Q };
const _hoisted_1$1v = {
  height: "1em",
  width: "1em",
  style: { "min-width": "16px", "min-height": "16px" },
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1m = /* @__PURE__ */ createBaseVNode("circle", {
  id: "Circle",
  cx: "8",
  cy: "8",
  r: "6",
  stroke: "#E1E3ED",
  class: "icon-light",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round"
}, null, -1);
const _hoisted_3$1a = /* @__PURE__ */ createBaseVNode("path", {
  id: "Progress",
  d: "M14 8C14 4.68629 11.3137 2 8 2",
  stroke: "#6470F3",
  class: "icon-dark",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round"
}, null, -1);
const _hoisted_4$H = [
  _hoisted_2$1m,
  _hoisted_3$1a
];
function render$P(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1v, _hoisted_4$H);
}
const __unplugin_components_0$e = { name: "cy-loading_x16", render: render$P };
var isVue2 = false;
function tryOnScopeDispose(fn2) {
  if (getCurrentScope()) {
    onScopeDispose(fn2);
    return true;
  }
  return false;
}
const isClient = typeof window !== "undefined";
const isString$2 = (val) => typeof val === "string";
const noop$4 = () => {
};
function createFilterWrapper(filter, fn2) {
  function wrapper(...args) {
    filter(() => fn2.apply(this, args), { fn: fn2, thisArg: this, args });
  }
  return wrapper;
}
const bypassFilter = (invoke) => {
  return invoke();
};
function debounceFilter(ms2, options2 = {}) {
  let timer;
  let maxTimer;
  const filter = (invoke) => {
    const duration = unref(ms2);
    const maxDuration = unref(options2.maxWait);
    if (timer)
      clearTimeout(timer);
    if (duration <= 0 || maxDuration !== void 0 && maxDuration <= 0) {
      if (maxTimer) {
        clearTimeout(maxTimer);
        maxTimer = null;
      }
      return invoke();
    }
    if (maxDuration && !maxTimer) {
      maxTimer = setTimeout(() => {
        if (timer)
          clearTimeout(timer);
        maxTimer = null;
        invoke();
      }, maxDuration);
    }
    timer = setTimeout(() => {
      if (maxTimer)
        clearTimeout(maxTimer);
      maxTimer = null;
      invoke();
    }, duration);
  };
  return filter;
}
function useDebounceFn(fn2, ms2 = 200, options2 = {}) {
  return createFilterWrapper(debounceFilter(ms2, options2), fn2);
}
function useDebounce(value, ms2 = 200, options2 = {}) {
  if (ms2 <= 0)
    return value;
  const debounced = ref(value.value);
  const updater = useDebounceFn(() => {
    debounced.value = value.value;
  }, ms2, options2);
  watch(value, () => updater());
  return debounced;
}
var __getOwnPropSymbols$9$1 = Object.getOwnPropertySymbols;
var __hasOwnProp$9$1 = Object.prototype.hasOwnProperty;
var __propIsEnum$9$1 = Object.prototype.propertyIsEnumerable;
var __objRest$5 = (source, exclude) => {
  var target2 = {};
  for (var prop2 in source)
    if (__hasOwnProp$9$1.call(source, prop2) && exclude.indexOf(prop2) < 0)
      target2[prop2] = source[prop2];
  if (source != null && __getOwnPropSymbols$9$1)
    for (var prop2 of __getOwnPropSymbols$9$1(source)) {
      if (exclude.indexOf(prop2) < 0 && __propIsEnum$9$1.call(source, prop2))
        target2[prop2] = source[prop2];
    }
  return target2;
};
function watchWithFilter(source, cb, options2 = {}) {
  const _a2 = options2, {
    eventFilter = bypassFilter
  } = _a2, watchOptions = __objRest$5(_a2, [
    "eventFilter"
  ]);
  return watch(source, createFilterWrapper(eventFilter, cb), watchOptions);
}
var __defProp$7 = Object.defineProperty;
var __defProps$4 = Object.defineProperties;
var __getOwnPropDescs$4 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$8 = Object.getOwnPropertySymbols;
var __hasOwnProp$8 = Object.prototype.hasOwnProperty;
var __propIsEnum$8 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$7 = (obj, key, value) => key in obj ? __defProp$7(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$7 = (a2, b2) => {
  for (var prop2 in b2 || (b2 = {}))
    if (__hasOwnProp$8.call(b2, prop2))
      __defNormalProp$7(a2, prop2, b2[prop2]);
  if (__getOwnPropSymbols$8)
    for (var prop2 of __getOwnPropSymbols$8(b2)) {
      if (__propIsEnum$8.call(b2, prop2))
        __defNormalProp$7(a2, prop2, b2[prop2]);
    }
  return a2;
};
var __spreadProps$4 = (a2, b2) => __defProps$4(a2, __getOwnPropDescs$4(b2));
var __objRest$4 = (source, exclude) => {
  var target2 = {};
  for (var prop2 in source)
    if (__hasOwnProp$8.call(source, prop2) && exclude.indexOf(prop2) < 0)
      target2[prop2] = source[prop2];
  if (source != null && __getOwnPropSymbols$8)
    for (var prop2 of __getOwnPropSymbols$8(source)) {
      if (exclude.indexOf(prop2) < 0 && __propIsEnum$8.call(source, prop2))
        target2[prop2] = source[prop2];
    }
  return target2;
};
function debouncedWatch(source, cb, options2 = {}) {
  const _a2 = options2, {
    debounce: debounce2 = 0
  } = _a2, watchOptions = __objRest$4(_a2, [
    "debounce"
  ]);
  return watchWithFilter(source, cb, __spreadProps$4(__spreadValues$7({}, watchOptions), {
    eventFilter: debounceFilter(debounce2)
  }));
}
function not$1(v) {
  return computed(() => !unref(v));
}
function tryOnMounted(fn2, sync = true) {
  if (getCurrentInstance())
    onMounted(fn2);
  else if (sync)
    fn2();
  else
    nextTick(fn2);
}
function useIntervalFn(cb, interval = 1e3, options2 = {}) {
  const {
    immediate = true,
    immediateCallback = false
  } = options2;
  let timer = null;
  const isActive = ref(false);
  function clean() {
    if (timer) {
      clearInterval(timer);
      timer = null;
    }
  }
  function pause() {
    isActive.value = false;
    clean();
  }
  function resume() {
    if (interval <= 0)
      return;
    isActive.value = true;
    if (immediateCallback)
      cb();
    clean();
    timer = setInterval(cb, interval);
  }
  if (immediate && isClient)
    resume();
  tryOnScopeDispose(pause);
  return {
    isActive,
    pause,
    resume
  };
}
function useTimeoutFn(cb, interval, options2 = {}) {
  const {
    immediate = true
  } = options2;
  const isPending = ref(false);
  let timer = null;
  function clear2() {
    if (timer) {
      clearTimeout(timer);
      timer = null;
    }
  }
  function stop() {
    isPending.value = false;
    clear2();
  }
  function start2(...args) {
    clear2();
    isPending.value = true;
    timer = setTimeout(() => {
      isPending.value = false;
      timer = null;
      cb(...args);
    }, unref(interval));
  }
  if (immediate) {
    isPending.value = true;
    if (isClient)
      start2();
  }
  tryOnScopeDispose(stop);
  return {
    isPending,
    start: start2,
    stop
  };
}
var __defProp$2 = Object.defineProperty;
var __getOwnPropSymbols$1$1 = Object.getOwnPropertySymbols;
var __hasOwnProp$1$1 = Object.prototype.hasOwnProperty;
var __propIsEnum$1$1 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2 = (obj, key, value) => key in obj ? __defProp$2(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2 = (a2, b2) => {
  for (var prop2 in b2 || (b2 = {}))
    if (__hasOwnProp$1$1.call(b2, prop2))
      __defNormalProp$2(a2, prop2, b2[prop2]);
  if (__getOwnPropSymbols$1$1)
    for (var prop2 of __getOwnPropSymbols$1$1(b2)) {
      if (__propIsEnum$1$1.call(b2, prop2))
        __defNormalProp$2(a2, prop2, b2[prop2]);
    }
  return a2;
};
function useTimeout(interval = 1e3, options2 = {}) {
  const {
    controls: exposeControls = false
  } = options2;
  const controls = useTimeoutFn(noop$4, interval, options2);
  const ready = computed(() => !controls.isPending.value);
  if (exposeControls) {
    return __spreadValues$2({
      ready
    }, controls);
  } else {
    return ready;
  }
}
function useToggle(initialValue = false) {
  if (isRef(initialValue)) {
    return (value) => {
      initialValue.value = typeof value === "boolean" ? value : !initialValue.value;
    };
  } else {
    const boolean = ref(initialValue);
    const toggle = (value) => {
      boolean.value = typeof value === "boolean" ? value : !boolean.value;
    };
    return [boolean, toggle];
  }
}
function whenever(source, cb, options2) {
  return watch(source, (v, ov, onInvalidate) => {
    if (v)
      cb(v, ov, onInvalidate);
  }, options2);
}
function unrefElement(elRef) {
  var _a2;
  const plain = unref(elRef);
  return (_a2 = plain == null ? void 0 : plain.$el) != null ? _a2 : plain;
}
const defaultWindow = isClient ? window : void 0;
function useEventListener(...args) {
  let target2;
  let event;
  let listener;
  let options2;
  if (isString$2(args[0])) {
    [event, listener, options2] = args;
    target2 = defaultWindow;
  } else {
    [target2, event, listener, options2] = args;
  }
  if (!target2)
    return noop$4;
  let cleanup = noop$4;
  const stopWatch = watch(() => unref(target2), (el2) => {
    cleanup();
    if (!el2)
      return;
    el2.addEventListener(event, listener, options2);
    cleanup = () => {
      el2.removeEventListener(event, listener, options2);
      cleanup = noop$4;
    };
  }, { immediate: true, flush: "post" });
  const stop = () => {
    stopWatch();
    cleanup();
  };
  tryOnScopeDispose(stop);
  return stop;
}
function onClickOutside(target2, handler, options2 = {}) {
  const { window: window2 = defaultWindow } = options2;
  if (!window2)
    return;
  const shouldListen = ref(true);
  const listener = (event) => {
    const el2 = unrefElement(target2);
    if (!el2 || el2 === event.target || event.composedPath().includes(el2) || !shouldListen.value)
      return;
    handler(event);
  };
  const cleanup = [
    useEventListener(window2, "click", listener, { passive: true, capture: true }),
    useEventListener(window2, "pointerdown", (e) => {
      const el2 = unrefElement(target2);
      shouldListen.value = !!el2 && !e.composedPath().includes(el2);
    }, { passive: true })
  ];
  const stop = () => cleanup.forEach((fn2) => fn2());
  return stop;
}
const createKeyPredicate = (keyFilter) => {
  if (typeof keyFilter === "function")
    return keyFilter;
  else if (typeof keyFilter === "string")
    return (event) => event.key === keyFilter;
  else if (Array.isArray(keyFilter))
    return (event) => keyFilter.includes(event.key);
  else if (keyFilter)
    return () => true;
  else
    return () => false;
};
function onKeyStroke(key, handler, options2 = {}) {
  const { target: target2 = defaultWindow, eventName = "keydown", passive: passive2 = false } = options2;
  const predicate = createKeyPredicate(key);
  const listener = (e) => {
    if (predicate(e))
      handler(e);
  };
  return useEventListener(target2, eventName, listener, passive2);
}
var __getOwnPropSymbols$9 = Object.getOwnPropertySymbols;
var __hasOwnProp$9 = Object.prototype.hasOwnProperty;
var __propIsEnum$9 = Object.prototype.propertyIsEnumerable;
var __objRest$2 = (source, exclude) => {
  var target2 = {};
  for (var prop2 in source)
    if (__hasOwnProp$9.call(source, prop2) && exclude.indexOf(prop2) < 0)
      target2[prop2] = source[prop2];
  if (source != null && __getOwnPropSymbols$9)
    for (var prop2 of __getOwnPropSymbols$9(source)) {
      if (exclude.indexOf(prop2) < 0 && __propIsEnum$9.call(source, prop2))
        target2[prop2] = source[prop2];
    }
  return target2;
};
function useResizeObserver(target2, callback, options2 = {}) {
  const _a2 = options2, { window: window2 = defaultWindow } = _a2, observerOptions = __objRest$2(_a2, ["window"]);
  let observer;
  const isSupported = window2 && "ResizeObserver" in window2;
  const cleanup = () => {
    if (observer) {
      observer.disconnect();
      observer = void 0;
    }
  };
  const stopWatch = watch(() => unrefElement(target2), (el2) => {
    cleanup();
    if (isSupported && window2 && el2) {
      observer = new window2.ResizeObserver(callback);
      observer.observe(el2, observerOptions);
    }
  }, { immediate: true, flush: "post" });
  const stop = () => {
    cleanup();
    stopWatch();
  };
  tryOnScopeDispose(stop);
  return {
    isSupported,
    stop
  };
}
function useElementHover(el2) {
  const isHovered = ref(false);
  useEventListener(el2, "mouseenter", () => isHovered.value = true);
  useEventListener(el2, "mouseleave", () => isHovered.value = false);
  return isHovered;
}
function useElementSize(target2, initialSize = { width: 0, height: 0 }, options2 = {}) {
  const width = ref(initialSize.width);
  const height = ref(initialSize.height);
  useResizeObserver(target2, ([entry]) => {
    width.value = entry.contentRect.width;
    height.value = entry.contentRect.height;
  }, options2);
  return {
    width,
    height
  };
}
function useRafFn(fn2, options2 = {}) {
  const {
    immediate = true,
    window: window2 = defaultWindow
  } = options2;
  const isActive = ref(false);
  function loop() {
    if (!isActive.value)
      return;
    fn2();
    if (window2)
      window2.requestAnimationFrame(loop);
  }
  function resume() {
    if (!isActive.value) {
      isActive.value = true;
      loop();
    }
  }
  function pause() {
    isActive.value = false;
  }
  if (immediate)
    resume();
  tryOnScopeDispose(pause);
  return {
    isActive,
    pause,
    resume
  };
}
function useNetwork(options2 = {}) {
  const { window: window2 = defaultWindow } = options2;
  const navigator2 = window2 == null ? void 0 : window2.navigator;
  const isSupported = Boolean(navigator2 && "connection" in navigator2);
  const isOnline = ref(true);
  const saveData = ref(false);
  const offlineAt = ref(void 0);
  const downlink = ref(void 0);
  const downlinkMax = ref(void 0);
  const rtt = ref(void 0);
  const effectiveType = ref(void 0);
  const type2 = ref("unknown");
  const connection = isSupported && navigator2.connection;
  function updateNetworkInformation() {
    if (!navigator2)
      return;
    isOnline.value = navigator2.onLine;
    offlineAt.value = isOnline.value ? void 0 : Date.now();
    if (connection) {
      downlink.value = connection.downlink;
      downlinkMax.value = connection.downlinkMax;
      effectiveType.value = connection.effectiveType;
      rtt.value = connection.rtt;
      saveData.value = connection.saveData;
      type2.value = connection.type;
    }
  }
  if (window2) {
    useEventListener(window2, "offline", () => {
      isOnline.value = false;
      offlineAt.value = Date.now();
    });
    useEventListener(window2, "online", () => {
      isOnline.value = true;
    });
  }
  if (connection)
    useEventListener(connection, "change", updateNetworkInformation, false);
  updateNetworkInformation();
  return {
    isSupported,
    isOnline,
    saveData,
    offlineAt,
    downlink,
    downlinkMax,
    effectiveType,
    rtt,
    type: type2
  };
}
var __defProp$5 = Object.defineProperty;
var __getOwnPropSymbols$5 = Object.getOwnPropertySymbols;
var __hasOwnProp$5 = Object.prototype.hasOwnProperty;
var __propIsEnum$5 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$5 = (obj, key, value) => key in obj ? __defProp$5(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$5 = (a2, b2) => {
  for (var prop2 in b2 || (b2 = {}))
    if (__hasOwnProp$5.call(b2, prop2))
      __defNormalProp$5(a2, prop2, b2[prop2]);
  if (__getOwnPropSymbols$5)
    for (var prop2 of __getOwnPropSymbols$5(b2)) {
      if (__propIsEnum$5.call(b2, prop2))
        __defNormalProp$5(a2, prop2, b2[prop2]);
    }
  return a2;
};
function useNow(options2 = {}) {
  const {
    controls: exposeControls = false,
    interval = "requestAnimationFrame"
  } = options2;
  const now = ref(new Date());
  const update = () => now.value = new Date();
  const controls = interval === "requestAnimationFrame" ? useRafFn(update, { immediate: true }) : useIntervalFn(update, interval, { immediate: true });
  if (exposeControls) {
    return __spreadValues$5({
      now
    }, controls);
  } else {
    return now;
  }
}
function useOnline(options2 = {}) {
  const { isOnline } = useNetwork(options2);
  return isOnline;
}
var SwipeDirection;
(function(SwipeDirection2) {
  SwipeDirection2["UP"] = "UP";
  SwipeDirection2["RIGHT"] = "RIGHT";
  SwipeDirection2["DOWN"] = "DOWN";
  SwipeDirection2["LEFT"] = "LEFT";
  SwipeDirection2["NONE"] = "NONE";
})(SwipeDirection || (SwipeDirection = {}));
var _a$2, _b;
isClient && (window == null ? void 0 : window.navigator) && ((_a$2 = window == null ? void 0 : window.navigator) == null ? void 0 : _a$2.platform) && /iP(ad|hone|od)/.test((_b = window == null ? void 0 : window.navigator) == null ? void 0 : _b.platform);
var __defProp$1$1 = Object.defineProperty;
var __getOwnPropSymbols$1 = Object.getOwnPropertySymbols;
var __hasOwnProp$1 = Object.prototype.hasOwnProperty;
var __propIsEnum$1 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1 = (obj, key, value) => key in obj ? __defProp$1$1(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1 = (a2, b2) => {
  for (var prop2 in b2 || (b2 = {}))
    if (__hasOwnProp$1.call(b2, prop2))
      __defNormalProp$1(a2, prop2, b2[prop2]);
  if (__getOwnPropSymbols$1)
    for (var prop2 of __getOwnPropSymbols$1(b2)) {
      if (__propIsEnum$1.call(b2, prop2))
        __defNormalProp$1(a2, prop2, b2[prop2]);
    }
  return a2;
};
var __objRest = (source, exclude) => {
  var target2 = {};
  for (var prop2 in source)
    if (__hasOwnProp$1.call(source, prop2) && exclude.indexOf(prop2) < 0)
      target2[prop2] = source[prop2];
  if (source != null && __getOwnPropSymbols$1)
    for (var prop2 of __getOwnPropSymbols$1(source)) {
      if (exclude.indexOf(prop2) < 0 && __propIsEnum$1.call(source, prop2))
        target2[prop2] = source[prop2];
    }
  return target2;
};
const UNITS = [
  { max: 6e4, value: 1e3, name: "second" },
  { max: 276e4, value: 6e4, name: "minute" },
  { max: 72e6, value: 36e5, name: "hour" },
  { max: 5184e5, value: 864e5, name: "day" },
  { max: 24192e5, value: 6048e5, name: "week" },
  { max: 28512e6, value: 2592e6, name: "month" },
  { max: Infinity, value: 31536e6, name: "year" }
];
const DEFAULT_MESSAGES = {
  justNow: "just now",
  past: (n) => n.match(/\d/) ? `${n} ago` : n,
  future: (n) => n.match(/\d/) ? `in ${n}` : n,
  month: (n, past) => n === 1 ? past ? "last month" : "next month" : `${n} month${n > 1 ? "s" : ""}`,
  year: (n, past) => n === 1 ? past ? "last year" : "next year" : `${n} year${n > 1 ? "s" : ""}`,
  day: (n, past) => n === 1 ? past ? "yesterday" : "tomorrow" : `${n} day${n > 1 ? "s" : ""}`,
  week: (n, past) => n === 1 ? past ? "last week" : "next week" : `${n} week${n > 1 ? "s" : ""}`,
  hour: (n) => `${n} hour${n > 1 ? "s" : ""}`,
  minute: (n) => `${n} minute${n > 1 ? "s" : ""}`,
  second: (n) => `${n} second${n > 1 ? "s" : ""}`
};
const DEFAULT_FORMATTER = (date) => date.toISOString().slice(0, 10);
function useTimeAgo(time, options2 = {}) {
  const {
    controls: exposeControls = false,
    max: max2,
    updateInterval = 3e4,
    messages = DEFAULT_MESSAGES,
    fullDateFormatter = DEFAULT_FORMATTER
  } = options2;
  const { abs, round: round2 } = Math;
  const _a2 = useNow({ interval: updateInterval, controls: true }), { now } = _a2, controls = __objRest(_a2, ["now"]);
  function getTimeago(from, now2) {
    var _a22;
    const diff = +now2 - +from;
    const absDiff = abs(diff);
    if (absDiff < 6e4)
      return messages.justNow;
    if (typeof max2 === "number" && absDiff > max2)
      return fullDateFormatter(new Date(from));
    if (typeof max2 === "string") {
      const unitMax = (_a22 = UNITS.find((i) => i.name === max2)) == null ? void 0 : _a22.max;
      if (unitMax && absDiff > unitMax)
        return fullDateFormatter(new Date(from));
    }
    for (const unit of UNITS) {
      if (absDiff < unit.max)
        return format3(diff, unit);
    }
  }
  function applyFormat(name2, val, isPast) {
    const formatter = messages[name2];
    if (typeof formatter === "function")
      return formatter(val, isPast);
    return formatter.replace("{0}", val.toString());
  }
  function format3(diff, unit) {
    const val = round2(abs(diff) / unit.value);
    const past = diff > 0;
    const str = applyFormat(unit.name, val, past);
    return applyFormat(past ? "past" : "future", str, past);
  }
  const timeAgo = computed(() => getTimeago(new Date(unref(time)), unref(now.value)));
  if (exposeControls) {
    return __spreadValues$1({
      timeAgo
    }, controls);
  } else {
    return timeAgo;
  }
}
function useVModel(props, key, emit2, options2 = {}) {
  var _a2;
  const {
    passive: passive2 = false,
    eventName,
    deep = false
  } = options2;
  const vm = getCurrentInstance();
  const _emit = emit2 || (vm == null ? void 0 : vm.emit) || ((_a2 = vm == null ? void 0 : vm.$emit) == null ? void 0 : _a2.bind(vm));
  let event = eventName;
  if (!key) {
    {
      key = "modelValue";
    }
  }
  event = eventName || event || `update:${key}`;
  if (passive2) {
    const proxy = ref(props[key]);
    watch(() => props[key], (v) => proxy.value = v);
    watch(proxy, (v) => {
      if (v !== props[key] || deep)
        _emit(event, v);
    }, {
      deep
    });
    return proxy;
  } else {
    return computed({
      get() {
        return props[key];
      },
      set(value) {
        _emit(event, value);
      }
    });
  }
}
function useVModels(props, emit2, options2 = {}) {
  const ret = {};
  for (const key in props)
    ret[key] = useVModel(props, key, emit2, options2);
  return ret;
}
function useWindowSize({ window: window2 = defaultWindow, initialWidth = Infinity, initialHeight = Infinity } = {}) {
  const width = ref(initialWidth);
  const height = ref(initialHeight);
  const update = () => {
    if (window2) {
      width.value = window2.innerWidth;
      height.value = window2.innerHeight;
    }
  };
  update();
  tryOnMounted(update);
  useEventListener("resize", update, { passive: true });
  return { width, height };
}
function getUtmSource() {
  return window.__CYPRESS_MODE__ ? "Binary: App" : "Binary: Launchpad";
}
const _hoisted_1$1u = {
  height: "1em",
  width: "1em",
  style: { "min-width": "16px", "min-height": "16px" },
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1l = /* @__PURE__ */ createBaseVNode("path", {
  d: "M10 3C9.44771 3 9 3.44772 9 4C9 4.55228 9.44771 5 10 5V3ZM10 11C9.44771 11 9 11.4477 9 12C9 12.5523 9.44771 13 10 13V11ZM6 5C6.55228 5 7 4.55228 7 4C7 3.44772 6.55228 3 6 3V5ZM6 13C6.55228 13 7 12.5523 7 12C7 11.4477 6.55228 11 6 11V13ZM5 7C4.44772 7 4 7.44772 4 8C4 8.55228 4.44772 9 5 9V7ZM11 9C11.5523 9 12 8.55228 12 8C12 7.44772 11.5523 7 11 7V9ZM10 5H11V3H10V5ZM11 11H10V13H11V11ZM5 5H6V3H5V5ZM6 11H5V13H6V11ZM5 9H11V7H5V9ZM2 8C2 6.34315 3.34315 5 5 5V3C2.23858 3 0 5.23858 0 8H2ZM0 8C0 10.7614 2.23858 13 5 13V11C3.34315 11 2 9.65685 2 8H0ZM14 8C14 9.65685 12.6569 11 11 11V13C13.7614 13 16 10.7614 16 8H14ZM16 8C16 5.23858 13.7614 3 11 3V5C12.6569 5 14 6.34315 14 8H16Z",
  fill: "currentColor",
  class: "icon-dark"
}, null, -1);
const _hoisted_3$19 = [
  _hoisted_2$1l
];
function render$O(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1u, _hoisted_3$19);
}
const ConnectIcon = { name: "cy-chain-link_x16", render: render$O };
const Auth_LogoutDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "Auth_Logout" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "logout" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }] } }] } }] };
const Auth_LoginDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "Auth_Login" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "utmSource" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "utmMedium" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "utmContent" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "login" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "utmSource" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "utmSource" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "utmContent" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "utmContent" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "utmMedium" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "utmMedium" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }] } }] } }] };
const Auth_ResetAuthStateDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "Auth_ResetAuthState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "resetAuthState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }] } }] } }] };
const ChooseExternalEditorModal_SetPreferredEditorBinaryDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "ChooseExternalEditorModal_SetPreferredEditorBinary" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setPreferences" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "value" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "type" }, "value": { "kind": "EnumValue", "value": "global" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferredEditorBinary" } }] } }] } }] } }] } }] };
const CloudViewerAndProject_RequiredDataDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "CloudViewerAndProject_RequiredData" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cachedUser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "config" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isFullConfigReady" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasNonExampleSpec" } }, { "kind": "Field", "name": { "kind": "Name", "value": "savedState" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "runs" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "10" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "url" } }] } }] } }] } }] } }] } }] } }] };
const CloudViewerAndProject_CheckCloudOrgMembershipDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "CloudViewerAndProject_CheckCloudOrgMembership" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewerChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cachedUser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "config" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isFullConfigReady" } }, { "kind": "Field", "name": { "kind": "Name", "value": "hasNonExampleSpec" } }, { "kind": "Field", "name": { "kind": "Name", "value": "savedState" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "runs" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "10" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "url" } }] } }] } }] } }] } }] } }] } }] } }] };
const HeaderBar_HeaderBarQueryDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "HeaderBar_HeaderBarQuery" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "config" } }, { "kind": "Field", "name": { "kind": "Name", "value": "savedState" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "branch" } }, { "kind": "Field", "name": { "kind": "Name", "value": "packageManager" } }, { "kind": "Field", "name": { "kind": "Name", "value": "activeBrowser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "displayName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "majorVersion" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "browsers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isSelected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "displayName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "majorVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isVersionSupported" } }, { "kind": "Field", "name": { "kind": "Name", "value": "warning" } }, { "kind": "Field", "name": { "kind": "Name", "value": "disabled" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "isGlobalMode" } }, { "kind": "Field", "name": { "kind": "Name", "value": "versions" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "current" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "released" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "latest" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "released" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cachedUser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }] } }] } }] };
const HeaderBarContent_AuthChangeDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "HeaderBarContent_authChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "authChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "cachedUser" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }] } }] } }] } }] };
const GlobalPageHeader_ClearCurrentProjectDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "GlobalPageHeader_clearCurrentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "clearCurrentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "baseError" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorStack" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUserCodeError" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeFrame" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "line" } }, { "kind": "Field", "name": { "kind": "Name", "value": "column" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeBlock" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }] };
const LoginConnectModals_LoginConnectModalsQueryDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "LoginConnectModals_LoginConnectModalsQuery" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "email" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fullName" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "createCloudOrganizationUrl" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "authState" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "browserOpened" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "message" } }] } }] } }] };
const OpenFileInIdeDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "OpenFileInIDE" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferredEditorBinary" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "availableEditors" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "binary" } }] } }] } }] } }] };
const OpenFileInIde_MutationDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "OpenFileInIDE_Mutation" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "input" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "FileDetailsInput" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "openFileInIDE" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "input" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "input" } } }] }] } }] };
const RecordPromptAdapterDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "query", "name": { "kind": "Name", "value": "RecordPromptAdapter" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentTestingType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "recordKeys" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "key" } }] } }] } }] } }] } }] } }] };
const UseCohorts_DetermineCohortDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "UseCohorts_DetermineCohort" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "name" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "cohorts" } }, "type": { "kind": "NonNullType", "type": { "kind": "ListType", "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "determineCohort" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "cohortConfig" }, "value": { "kind": "ObjectValue", "fields": [{ "kind": "ObjectField", "name": { "kind": "Name", "value": "name" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "name" } } }, { "kind": "ObjectField", "name": { "kind": "Name", "value": "cohorts" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "cohorts" } } }] } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cohort" } }] } }] } }] };
const UsePromptManager_SetProjectPreferencesDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "UsePromptManager_SetProjectPreferences" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setPreferences" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "type" }, "value": { "kind": "EnumValue", "value": "project" } }, { "kind": "Argument", "name": { "kind": "Name", "value": "value" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "savedState" } }] } }] } }] } }] };
const UsePromptManager_SetGlobalPreferencesDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "UsePromptManager_SetGlobalPreferences" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setPreferences" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "type" }, "value": { "kind": "EnumValue", "value": "global" } }, { "kind": "Argument", "name": { "kind": "Name", "value": "value" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "value" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "localSettings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "preferences" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "majorVersionWelcomeDismissed" } }] } }] } }] } }] } }] };
const CloudConnectModals_MonitorCloudViewerDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "CloudConnectModals_MonitorCloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewerChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "createCloudOrganizationUrl" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }] } }] } }] } }] };
const CreateCloudOrgModal_CloudOrganizationsCheckDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "CreateCloudOrgModal_CloudOrganizationsCheck" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "refreshCloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudViewer" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudOrganizationsUrl" } }, { "kind": "Field", "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projects" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "100" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "createCloudOrganizationUrl" } }, { "kind": "Field", "alias": { "kind": "Name", "value": "firstOrganization" }, "name": { "kind": "Name", "value": "organizations" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "1" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }] } }] } }] } }] };
const SelectCloudProjectModal_SetProjectIdDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "SelectCloudProjectModal_SetProjectId" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "projectId" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setProjectIdInConfigFile" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "projectId" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "projectId" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "currentProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "projectId" } }, { "kind": "Field", "name": { "kind": "Name", "value": "cloudProject" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "__typename" } }, { "kind": "InlineFragment", "typeCondition": { "kind": "NamedType", "name": { "kind": "Name", "value": "CloudProject" } }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "runs" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "first" }, "value": { "kind": "IntValue", "value": "10" } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "nodes" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "createdAt" } }, { "kind": "Field", "name": { "kind": "Name", "value": "status" } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalDuration" } }, { "kind": "Field", "name": { "kind": "Name", "value": "url" } }, { "kind": "Field", "name": { "kind": "Name", "value": "tags" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "name" } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalPassed" } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalFailed" } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalPending" } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalSkipped" } }, { "kind": "Field", "name": { "kind": "Name", "value": "totalFlakyTests" } }, { "kind": "Field", "name": { "kind": "Name", "value": "commitInfo" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "authorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "authorEmail" } }, { "kind": "Field", "name": { "kind": "Name", "value": "summary" } }, { "kind": "Field", "name": { "kind": "Name", "value": "branch" } }] } }] } }] } }] } }] } }] } }] } }] } }] };
const SelectCloudProjectModal_CreateCloudProjectDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "SelectCloudProjectModal_CreateCloudProject" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "name" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "orgId" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "ID" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "public" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "Boolean" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "campaign" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "cohort" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "medium" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "source" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "cloudProjectCreate" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "name" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "name" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "orgId" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "orgId" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "public" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "public" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "campaign" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "campaign" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "cohort" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "cohort" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "medium" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "medium" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "source" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "source" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "slug" } }] } }] } }] };
const TopNav_SetPromptShownDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "TopNav_SetPromptShown" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "slug" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "setPromptShown" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "slug" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "slug" } } }] }] } }] };
const VerticalBrowserListItems_SetBrowserDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "VerticalBrowserListItems_SetBrowser" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "id" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "ID" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "specPath" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "launchpadSetBrowser" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "id" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "id" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "browsers" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isSelected" } }, { "kind": "Field", "name": { "kind": "Name", "value": "displayName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "version" } }, { "kind": "Field", "name": { "kind": "Name", "value": "majorVersion" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isVersionSupported" } }, { "kind": "Field", "name": { "kind": "Name", "value": "warning" } }, { "kind": "Field", "name": { "kind": "Name", "value": "disabled" } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "launchOpenProject" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "specPath" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "specPath" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }] } }] } }] };
const Clipboard_CopyToClipboardDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "Clipboard_CopyToClipboard" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "text" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "copyTextToClipboard" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "text" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "text" } } }] }] } }] };
const ExternalLink_OpenExternalDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "mutation", "name": { "kind": "Name", "value": "ExternalLink_OpenExternal" }, "variableDefinitions": [{ "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "url" } }, "type": { "kind": "NonNullType", "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "String" } } } }, { "kind": "VariableDefinition", "variable": { "kind": "Variable", "name": { "kind": "Name", "value": "includeGraphqlPort" } }, "type": { "kind": "NamedType", "name": { "kind": "Name", "value": "Boolean" } } }], "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "openExternal" }, "arguments": [{ "kind": "Argument", "name": { "kind": "Name", "value": "url" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "url" } } }, { "kind": "Argument", "name": { "kind": "Name", "value": "includeGraphqlPort" }, "value": { "kind": "Variable", "name": { "kind": "Name", "value": "includeGraphqlPort" } } }] }] } }] };
const GlobalSubscriptions_PushFragmentDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "GlobalSubscriptions_PushFragment" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "pushFragment" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "target" } }, { "kind": "Field", "name": { "kind": "Name", "value": "fragment" } }, { "kind": "Field", "name": { "kind": "Name", "value": "data" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errors" } }, { "kind": "Field", "name": { "kind": "Name", "value": "variables" } }, { "kind": "Field", "name": { "kind": "Name", "value": "invalidateCache" } }] } }] } }] };
const GlobalSubscriptions_ErrorWarningChangeDocument = { "kind": "Document", "definitions": [{ "kind": "OperationDefinition", "operation": "subscription", "name": { "kind": "Name", "value": "GlobalSubscriptions_ErrorWarningChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "errorWarningChange" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "baseError" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorName" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorStack" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }, { "kind": "Field", "name": { "kind": "Name", "value": "isUserCodeError" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeFrame" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "line" } }, { "kind": "Field", "name": { "kind": "Name", "value": "column" } }, { "kind": "Field", "name": { "kind": "Name", "value": "codeBlock" } }, { "kind": "Field", "name": { "kind": "Name", "value": "file" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "absolute" } }, { "kind": "Field", "name": { "kind": "Name", "value": "relative" } }] } }] } }] } }, { "kind": "Field", "name": { "kind": "Name", "value": "warnings" }, "selectionSet": { "kind": "SelectionSet", "selections": [{ "kind": "Field", "name": { "kind": "Name", "value": "id" } }, { "kind": "Field", "name": { "kind": "Name", "value": "title" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorType" } }, { "kind": "Field", "name": { "kind": "Name", "value": "errorMessage" } }] } }] } }] } }] };
const hasSymbol = typeof Symbol === "function" && typeof Symbol.toStringTag === "symbol";
const PolySymbol = (name2) => hasSymbol ? Symbol(name2) : "_vr_" + name2;
const matchedRouteKey = /* @__PURE__ */ PolySymbol("rvlm");
const viewDepthKey = /* @__PURE__ */ PolySymbol("rvd");
const routerKey = /* @__PURE__ */ PolySymbol("r");
const routeLocationKey = /* @__PURE__ */ PolySymbol("rl");
const routerViewLocationKey = /* @__PURE__ */ PolySymbol("rvl");
const isBrowser$2 = typeof window !== "undefined";
function isESModule(obj) {
  return obj.__esModule || hasSymbol && obj[Symbol.toStringTag] === "Module";
}
const assign$3 = Object.assign;
function applyToParams(fn2, params2) {
  const newParams = {};
  for (const key in params2) {
    const value = params2[key];
    newParams[key] = Array.isArray(value) ? value.map(fn2) : fn2(value);
  }
  return newParams;
}
const noop$3 = () => {
};
const TRAILING_SLASH_RE = /\/$/;
const removeTrailingSlash = (path) => path.replace(TRAILING_SLASH_RE, "");
function parseURL(parseQuery2, location2, currentLocation = "/") {
  let path, query2 = {}, searchString = "", hash2 = "";
  const searchPos = location2.indexOf("?");
  const hashPos = location2.indexOf("#", searchPos > -1 ? searchPos : 0);
  if (searchPos > -1) {
    path = location2.slice(0, searchPos);
    searchString = location2.slice(searchPos + 1, hashPos > -1 ? hashPos : location2.length);
    query2 = parseQuery2(searchString);
  }
  if (hashPos > -1) {
    path = path || location2.slice(0, hashPos);
    hash2 = location2.slice(hashPos, location2.length);
  }
  path = resolveRelativePath(path != null ? path : location2, currentLocation);
  return {
    fullPath: path + (searchString && "?") + searchString + hash2,
    path,
    query: query2,
    hash: hash2
  };
}
function stringifyURL(stringifyQuery2, location2) {
  const query2 = location2.query ? stringifyQuery2(location2.query) : "";
  return location2.path + (query2 && "?") + query2 + (location2.hash || "");
}
function stripBase(pathname, base2) {
  if (!base2 || !pathname.toLowerCase().startsWith(base2.toLowerCase()))
    return pathname;
  return pathname.slice(base2.length) || "/";
}
function isSameRouteLocation(stringifyQuery2, a2, b2) {
  const aLastIndex = a2.matched.length - 1;
  const bLastIndex = b2.matched.length - 1;
  return aLastIndex > -1 && aLastIndex === bLastIndex && isSameRouteRecord(a2.matched[aLastIndex], b2.matched[bLastIndex]) && isSameRouteLocationParams(a2.params, b2.params) && stringifyQuery2(a2.query) === stringifyQuery2(b2.query) && a2.hash === b2.hash;
}
function isSameRouteRecord(a2, b2) {
  return (a2.aliasOf || a2) === (b2.aliasOf || b2);
}
function isSameRouteLocationParams(a2, b2) {
  if (Object.keys(a2).length !== Object.keys(b2).length)
    return false;
  for (const key in a2) {
    if (!isSameRouteLocationParamsValue(a2[key], b2[key]))
      return false;
  }
  return true;
}
function isSameRouteLocationParamsValue(a2, b2) {
  return Array.isArray(a2) ? isEquivalentArray(a2, b2) : Array.isArray(b2) ? isEquivalentArray(b2, a2) : a2 === b2;
}
function isEquivalentArray(a2, b2) {
  return Array.isArray(b2) ? a2.length === b2.length && a2.every((value, i) => value === b2[i]) : a2.length === 1 && a2[0] === b2;
}
function resolveRelativePath(to, from) {
  if (to.startsWith("/"))
    return to;
  if (!to)
    return from;
  const fromSegments = from.split("/");
  const toSegments = to.split("/");
  let position = fromSegments.length - 1;
  let toPosition;
  let segment;
  for (toPosition = 0; toPosition < toSegments.length; toPosition++) {
    segment = toSegments[toPosition];
    if (position === 1 || segment === ".")
      continue;
    if (segment === "..")
      position--;
    else
      break;
  }
  return fromSegments.slice(0, position).join("/") + "/" + toSegments.slice(toPosition - (toPosition === toSegments.length ? 1 : 0)).join("/");
}
var NavigationType;
(function(NavigationType2) {
  NavigationType2["pop"] = "pop";
  NavigationType2["push"] = "push";
})(NavigationType || (NavigationType = {}));
var NavigationDirection;
(function(NavigationDirection2) {
  NavigationDirection2["back"] = "back";
  NavigationDirection2["forward"] = "forward";
  NavigationDirection2["unknown"] = "";
})(NavigationDirection || (NavigationDirection = {}));
function normalizeBase(base2) {
  if (!base2) {
    if (isBrowser$2) {
      const baseEl = document.querySelector("base");
      base2 = baseEl && baseEl.getAttribute("href") || "/";
      base2 = base2.replace(/^\w+:\/\/[^\/]+/, "");
    } else {
      base2 = "/";
    }
  }
  if (base2[0] !== "/" && base2[0] !== "#")
    base2 = "/" + base2;
  return removeTrailingSlash(base2);
}
const BEFORE_HASH_RE = /^[^#]+#/;
function createHref(base2, location2) {
  return base2.replace(BEFORE_HASH_RE, "#") + location2;
}
function getElementPosition(el2, offset2) {
  const docRect = document.documentElement.getBoundingClientRect();
  const elRect = el2.getBoundingClientRect();
  return {
    behavior: offset2.behavior,
    left: elRect.left - docRect.left - (offset2.left || 0),
    top: elRect.top - docRect.top - (offset2.top || 0)
  };
}
const computeScrollPosition = () => ({
  left: window.pageXOffset,
  top: window.pageYOffset
});
function scrollToPosition(position) {
  let scrollToOptions;
  if ("el" in position) {
    const positionEl = position.el;
    const isIdSelector = typeof positionEl === "string" && positionEl.startsWith("#");
    const el2 = typeof positionEl === "string" ? isIdSelector ? document.getElementById(positionEl.slice(1)) : document.querySelector(positionEl) : positionEl;
    if (!el2) {
      return;
    }
    scrollToOptions = getElementPosition(el2, position);
  } else {
    scrollToOptions = position;
  }
  if ("scrollBehavior" in document.documentElement.style)
    window.scrollTo(scrollToOptions);
  else {
    window.scrollTo(scrollToOptions.left != null ? scrollToOptions.left : window.pageXOffset, scrollToOptions.top != null ? scrollToOptions.top : window.pageYOffset);
  }
}
function getScrollKey(path, delta2) {
  const position = history.state ? history.state.position - delta2 : -1;
  return position + path;
}
const scrollPositions = /* @__PURE__ */ new Map();
function saveScrollPosition(key, scrollPosition) {
  scrollPositions.set(key, scrollPosition);
}
function getSavedScrollPosition(key) {
  const scroll = scrollPositions.get(key);
  scrollPositions.delete(key);
  return scroll;
}
let createBaseLocation = () => location.protocol + "//" + location.host;
function createCurrentLocation(base2, location2) {
  const { pathname, search, hash: hash2 } = location2;
  const hashPos = base2.indexOf("#");
  if (hashPos > -1) {
    let slicePos = hash2.includes(base2.slice(hashPos)) ? base2.slice(hashPos).length : 1;
    let pathFromHash = hash2.slice(slicePos);
    if (pathFromHash[0] !== "/")
      pathFromHash = "/" + pathFromHash;
    return stripBase(pathFromHash, "");
  }
  const path = stripBase(pathname, base2);
  return path + search + hash2;
}
function useHistoryListeners(base2, historyState, currentLocation, replace2) {
  let listeners2 = [];
  let teardowns = [];
  let pauseState = null;
  const popStateHandler = ({ state }) => {
    const to = createCurrentLocation(base2, location);
    const from = currentLocation.value;
    const fromState = historyState.value;
    let delta2 = 0;
    if (state) {
      currentLocation.value = to;
      historyState.value = state;
      if (pauseState && pauseState === from) {
        pauseState = null;
        return;
      }
      delta2 = fromState ? state.position - fromState.position : 0;
    } else {
      replace2(to);
    }
    listeners2.forEach((listener) => {
      listener(currentLocation.value, from, {
        delta: delta2,
        type: NavigationType.pop,
        direction: delta2 ? delta2 > 0 ? NavigationDirection.forward : NavigationDirection.back : NavigationDirection.unknown
      });
    });
  };
  function pauseListeners() {
    pauseState = currentLocation.value;
  }
  function listen(callback) {
    listeners2.push(callback);
    const teardown2 = () => {
      const index2 = listeners2.indexOf(callback);
      if (index2 > -1)
        listeners2.splice(index2, 1);
    };
    teardowns.push(teardown2);
    return teardown2;
  }
  function beforeUnloadListener() {
    const { history: history2 } = window;
    if (!history2.state)
      return;
    history2.replaceState(assign$3({}, history2.state, { scroll: computeScrollPosition() }), "");
  }
  function destroy() {
    for (const teardown2 of teardowns)
      teardown2();
    teardowns = [];
    window.removeEventListener("popstate", popStateHandler);
    window.removeEventListener("beforeunload", beforeUnloadListener);
  }
  window.addEventListener("popstate", popStateHandler);
  window.addEventListener("beforeunload", beforeUnloadListener);
  return {
    pauseListeners,
    listen,
    destroy
  };
}
function buildState(back, current, forward, replaced = false, computeScroll = false) {
  return {
    back,
    current,
    forward,
    replaced,
    position: window.history.length,
    scroll: computeScroll ? computeScrollPosition() : null
  };
}
function useHistoryStateNavigation(base2) {
  const { history: history2, location: location2 } = window;
  const currentLocation = {
    value: createCurrentLocation(base2, location2)
  };
  const historyState = { value: history2.state };
  if (!historyState.value) {
    changeLocation(currentLocation.value, {
      back: null,
      current: currentLocation.value,
      forward: null,
      position: history2.length - 1,
      replaced: true,
      scroll: null
    }, true);
  }
  function changeLocation(to, state, replace3) {
    const hashIndex = base2.indexOf("#");
    const url2 = hashIndex > -1 ? (location2.host && document.querySelector("base") ? base2 : base2.slice(hashIndex)) + to : createBaseLocation() + base2 + to;
    try {
      history2[replace3 ? "replaceState" : "pushState"](state, "", url2);
      historyState.value = state;
    } catch (err) {
      {
        console.error(err);
      }
      location2[replace3 ? "replace" : "assign"](url2);
    }
  }
  function replace2(to, data) {
    const state = assign$3({}, history2.state, buildState(
      historyState.value.back,
      to,
      historyState.value.forward,
      true
    ), data, { position: historyState.value.position });
    changeLocation(to, state, true);
    currentLocation.value = to;
  }
  function push2(to, data) {
    const currentState = assign$3(
      {},
      historyState.value,
      history2.state,
      {
        forward: to,
        scroll: computeScrollPosition()
      }
    );
    changeLocation(currentState.current, currentState, true);
    const state = assign$3({}, buildState(currentLocation.value, to, null), { position: currentState.position + 1 }, data);
    changeLocation(to, state, false);
    currentLocation.value = to;
  }
  return {
    location: currentLocation,
    state: historyState,
    push: push2,
    replace: replace2
  };
}
function createWebHistory(base2) {
  base2 = normalizeBase(base2);
  const historyNavigation = useHistoryStateNavigation(base2);
  const historyListeners = useHistoryListeners(base2, historyNavigation.state, historyNavigation.location, historyNavigation.replace);
  function go(delta2, triggerListeners = true) {
    if (!triggerListeners)
      historyListeners.pauseListeners();
    history.go(delta2);
  }
  const routerHistory = assign$3({
    location: "",
    base: base2,
    go,
    createHref: createHref.bind(null, base2)
  }, historyNavigation, historyListeners);
  Object.defineProperty(routerHistory, "location", {
    enumerable: true,
    get: () => historyNavigation.location.value
  });
  Object.defineProperty(routerHistory, "state", {
    enumerable: true,
    get: () => historyNavigation.state.value
  });
  return routerHistory;
}
function createWebHashHistory(base2) {
  base2 = location.host ? base2 || location.pathname + location.search : "";
  if (!base2.includes("#"))
    base2 += "#";
  return createWebHistory(base2);
}
function isRouteLocation(route) {
  return typeof route === "string" || route && typeof route === "object";
}
function isRouteName(name2) {
  return typeof name2 === "string" || typeof name2 === "symbol";
}
const START_LOCATION_NORMALIZED = {
  path: "/",
  name: void 0,
  params: {},
  query: {},
  hash: "",
  fullPath: "/",
  matched: [],
  meta: {},
  redirectedFrom: void 0
};
const NavigationFailureSymbol = /* @__PURE__ */ PolySymbol("nf");
var NavigationFailureType;
(function(NavigationFailureType2) {
  NavigationFailureType2[NavigationFailureType2["aborted"] = 4] = "aborted";
  NavigationFailureType2[NavigationFailureType2["cancelled"] = 8] = "cancelled";
  NavigationFailureType2[NavigationFailureType2["duplicated"] = 16] = "duplicated";
})(NavigationFailureType || (NavigationFailureType = {}));
function createRouterError(type2, params2) {
  {
    return assign$3(new Error(), {
      type: type2,
      [NavigationFailureSymbol]: true
    }, params2);
  }
}
function isNavigationFailure(error2, type2) {
  return error2 instanceof Error && NavigationFailureSymbol in error2 && (type2 == null || !!(error2.type & type2));
}
const BASE_PARAM_PATTERN = "[^/]+?";
const BASE_PATH_PARSER_OPTIONS = {
  sensitive: false,
  strict: false,
  start: true,
  end: true
};
const REGEX_CHARS_RE = /[.+*?^${}()[\]/\\]/g;
function tokensToParser(segments, extraOptions) {
  const options2 = assign$3({}, BASE_PATH_PARSER_OPTIONS, extraOptions);
  const score = [];
  let pattern = options2.start ? "^" : "";
  const keys = [];
  for (const segment of segments) {
    const segmentScores = segment.length ? [] : [90];
    if (options2.strict && !segment.length)
      pattern += "/";
    for (let tokenIndex = 0; tokenIndex < segment.length; tokenIndex++) {
      const token2 = segment[tokenIndex];
      let subSegmentScore = 40 + (options2.sensitive ? 0.25 : 0);
      if (token2.type === 0) {
        if (!tokenIndex)
          pattern += "/";
        pattern += token2.value.replace(REGEX_CHARS_RE, "\\$&");
        subSegmentScore += 40;
      } else if (token2.type === 1) {
        const { value, repeatable, optional, regexp } = token2;
        keys.push({
          name: value,
          repeatable,
          optional
        });
        const re3 = regexp ? regexp : BASE_PARAM_PATTERN;
        if (re3 !== BASE_PARAM_PATTERN) {
          subSegmentScore += 10;
          try {
            new RegExp(`(${re3})`);
          } catch (err) {
            throw new Error(`Invalid custom RegExp for param "${value}" (${re3}): ` + err.message);
          }
        }
        let subPattern = repeatable ? `((?:${re3})(?:/(?:${re3}))*)` : `(${re3})`;
        if (!tokenIndex)
          subPattern = optional && segment.length < 2 ? `(?:/${subPattern})` : "/" + subPattern;
        if (optional)
          subPattern += "?";
        pattern += subPattern;
        subSegmentScore += 20;
        if (optional)
          subSegmentScore += -8;
        if (repeatable)
          subSegmentScore += -20;
        if (re3 === ".*")
          subSegmentScore += -50;
      }
      segmentScores.push(subSegmentScore);
    }
    score.push(segmentScores);
  }
  if (options2.strict && options2.end) {
    const i = score.length - 1;
    score[i][score[i].length - 1] += 0.7000000000000001;
  }
  if (!options2.strict)
    pattern += "/?";
  if (options2.end)
    pattern += "$";
  else if (options2.strict)
    pattern += "(?:/|$)";
  const re2 = new RegExp(pattern, options2.sensitive ? "" : "i");
  function parse3(path) {
    const match3 = path.match(re2);
    const params2 = {};
    if (!match3)
      return null;
    for (let i = 1; i < match3.length; i++) {
      const value = match3[i] || "";
      const key = keys[i - 1];
      params2[key.name] = value && key.repeatable ? value.split("/") : value;
    }
    return params2;
  }
  function stringify3(params2) {
    let path = "";
    let avoidDuplicatedSlash = false;
    for (const segment of segments) {
      if (!avoidDuplicatedSlash || !path.endsWith("/"))
        path += "/";
      avoidDuplicatedSlash = false;
      for (const token2 of segment) {
        if (token2.type === 0) {
          path += token2.value;
        } else if (token2.type === 1) {
          const { value, repeatable, optional } = token2;
          const param = value in params2 ? params2[value] : "";
          if (Array.isArray(param) && !repeatable)
            throw new Error(`Provided param "${value}" is an array but it is not repeatable (* or + modifiers)`);
          const text3 = Array.isArray(param) ? param.join("/") : param;
          if (!text3) {
            if (optional) {
              if (segment.length < 2) {
                if (path.endsWith("/"))
                  path = path.slice(0, -1);
                else
                  avoidDuplicatedSlash = true;
              }
            } else
              throw new Error(`Missing required param "${value}"`);
          }
          path += text3;
        }
      }
    }
    return path;
  }
  return {
    re: re2,
    score,
    keys,
    parse: parse3,
    stringify: stringify3
  };
}
function compareScoreArray(a2, b2) {
  let i = 0;
  while (i < a2.length && i < b2.length) {
    const diff = b2[i] - a2[i];
    if (diff)
      return diff;
    i++;
  }
  if (a2.length < b2.length) {
    return a2.length === 1 && a2[0] === 40 + 40 ? -1 : 1;
  } else if (a2.length > b2.length) {
    return b2.length === 1 && b2[0] === 40 + 40 ? 1 : -1;
  }
  return 0;
}
function comparePathParserScore(a2, b2) {
  let i = 0;
  const aScore = a2.score;
  const bScore = b2.score;
  while (i < aScore.length && i < bScore.length) {
    const comp2 = compareScoreArray(aScore[i], bScore[i]);
    if (comp2)
      return comp2;
    i++;
  }
  return bScore.length - aScore.length;
}
const ROOT_TOKEN = {
  type: 0,
  value: ""
};
const VALID_PARAM_RE = /[a-zA-Z0-9_]/;
function tokenizePath(path) {
  if (!path)
    return [[]];
  if (path === "/")
    return [[ROOT_TOKEN]];
  if (!path.startsWith("/")) {
    throw new Error(`Invalid path "${path}"`);
  }
  function crash(message) {
    throw new Error(`ERR (${state})/"${buffer}": ${message}`);
  }
  let state = 0;
  let previousState = state;
  const tokens = [];
  let segment;
  function finalizeSegment() {
    if (segment)
      tokens.push(segment);
    segment = [];
  }
  let i = 0;
  let char;
  let buffer = "";
  let customRe = "";
  function consumeBuffer() {
    if (!buffer)
      return;
    if (state === 0) {
      segment.push({
        type: 0,
        value: buffer
      });
    } else if (state === 1 || state === 2 || state === 3) {
      if (segment.length > 1 && (char === "*" || char === "+"))
        crash(`A repeatable param (${buffer}) must be alone in its segment. eg: '/:ids+.`);
      segment.push({
        type: 1,
        value: buffer,
        regexp: customRe,
        repeatable: char === "*" || char === "+",
        optional: char === "*" || char === "?"
      });
    } else {
      crash("Invalid state to consume buffer");
    }
    buffer = "";
  }
  function addCharToBuffer() {
    buffer += char;
  }
  while (i < path.length) {
    char = path[i++];
    if (char === "\\" && state !== 2) {
      previousState = state;
      state = 4;
      continue;
    }
    switch (state) {
      case 0:
        if (char === "/") {
          if (buffer) {
            consumeBuffer();
          }
          finalizeSegment();
        } else if (char === ":") {
          consumeBuffer();
          state = 1;
        } else {
          addCharToBuffer();
        }
        break;
      case 4:
        addCharToBuffer();
        state = previousState;
        break;
      case 1:
        if (char === "(") {
          state = 2;
        } else if (VALID_PARAM_RE.test(char)) {
          addCharToBuffer();
        } else {
          consumeBuffer();
          state = 0;
          if (char !== "*" && char !== "?" && char !== "+")
            i--;
        }
        break;
      case 2:
        if (char === ")") {
          if (customRe[customRe.length - 1] == "\\")
            customRe = customRe.slice(0, -1) + char;
          else
            state = 3;
        } else {
          customRe += char;
        }
        break;
      case 3:
        consumeBuffer();
        state = 0;
        if (char !== "*" && char !== "?" && char !== "+")
          i--;
        customRe = "";
        break;
      default:
        crash("Unknown state");
        break;
    }
  }
  if (state === 2)
    crash(`Unfinished custom RegExp for param "${buffer}"`);
  consumeBuffer();
  finalizeSegment();
  return tokens;
}
function createRouteRecordMatcher(record, parent, options2) {
  const parser2 = tokensToParser(tokenizePath(record.path), options2);
  const matcher = assign$3(parser2, {
    record,
    parent,
    children: [],
    alias: []
  });
  if (parent) {
    if (!matcher.record.aliasOf === !parent.record.aliasOf)
      parent.children.push(matcher);
  }
  return matcher;
}
function createRouterMatcher(routes2, globalOptions) {
  const matchers = [];
  const matcherMap = /* @__PURE__ */ new Map();
  globalOptions = mergeOptions({ strict: false, end: true, sensitive: false }, globalOptions);
  function getRecordMatcher(name2) {
    return matcherMap.get(name2);
  }
  function addRoute(record, parent, originalRecord) {
    const isRootAdd = !originalRecord;
    const mainNormalizedRecord = normalizeRouteRecord(record);
    mainNormalizedRecord.aliasOf = originalRecord && originalRecord.record;
    const options2 = mergeOptions(globalOptions, record);
    const normalizedRecords = [
      mainNormalizedRecord
    ];
    if ("alias" in record) {
      const aliases = typeof record.alias === "string" ? [record.alias] : record.alias;
      for (const alias of aliases) {
        normalizedRecords.push(assign$3({}, mainNormalizedRecord, {
          components: originalRecord ? originalRecord.record.components : mainNormalizedRecord.components,
          path: alias,
          aliasOf: originalRecord ? originalRecord.record : mainNormalizedRecord
        }));
      }
    }
    let matcher;
    let originalMatcher;
    for (const normalizedRecord of normalizedRecords) {
      const { path } = normalizedRecord;
      if (parent && path[0] !== "/") {
        const parentPath = parent.record.path;
        const connectingSlash = parentPath[parentPath.length - 1] === "/" ? "" : "/";
        normalizedRecord.path = parent.record.path + (path && connectingSlash + path);
      }
      matcher = createRouteRecordMatcher(normalizedRecord, parent, options2);
      if (originalRecord) {
        originalRecord.alias.push(matcher);
      } else {
        originalMatcher = originalMatcher || matcher;
        if (originalMatcher !== matcher)
          originalMatcher.alias.push(matcher);
        if (isRootAdd && record.name && !isAliasRecord(matcher))
          removeRoute(record.name);
      }
      if ("children" in mainNormalizedRecord) {
        const children = mainNormalizedRecord.children;
        for (let i = 0; i < children.length; i++) {
          addRoute(children[i], matcher, originalRecord && originalRecord.children[i]);
        }
      }
      originalRecord = originalRecord || matcher;
      insertMatcher(matcher);
    }
    return originalMatcher ? () => {
      removeRoute(originalMatcher);
    } : noop$3;
  }
  function removeRoute(matcherRef) {
    if (isRouteName(matcherRef)) {
      const matcher = matcherMap.get(matcherRef);
      if (matcher) {
        matcherMap.delete(matcherRef);
        matchers.splice(matchers.indexOf(matcher), 1);
        matcher.children.forEach(removeRoute);
        matcher.alias.forEach(removeRoute);
      }
    } else {
      const index2 = matchers.indexOf(matcherRef);
      if (index2 > -1) {
        matchers.splice(index2, 1);
        if (matcherRef.record.name)
          matcherMap.delete(matcherRef.record.name);
        matcherRef.children.forEach(removeRoute);
        matcherRef.alias.forEach(removeRoute);
      }
    }
  }
  function getRoutes() {
    return matchers;
  }
  function insertMatcher(matcher) {
    let i = 0;
    while (i < matchers.length && comparePathParserScore(matcher, matchers[i]) >= 0)
      i++;
    matchers.splice(i, 0, matcher);
    if (matcher.record.name && !isAliasRecord(matcher))
      matcherMap.set(matcher.record.name, matcher);
  }
  function resolve3(location2, currentLocation) {
    let matcher;
    let params2 = {};
    let path;
    let name2;
    if ("name" in location2 && location2.name) {
      matcher = matcherMap.get(location2.name);
      if (!matcher)
        throw createRouterError(1, {
          location: location2
        });
      name2 = matcher.record.name;
      params2 = assign$3(
        paramsFromLocation(
          currentLocation.params,
          matcher.keys.filter((k) => !k.optional).map((k) => k.name)
        ),
        location2.params
      );
      path = matcher.stringify(params2);
    } else if ("path" in location2) {
      path = location2.path;
      matcher = matchers.find((m2) => m2.re.test(path));
      if (matcher) {
        params2 = matcher.parse(path);
        name2 = matcher.record.name;
      }
    } else {
      matcher = currentLocation.name ? matcherMap.get(currentLocation.name) : matchers.find((m2) => m2.re.test(currentLocation.path));
      if (!matcher)
        throw createRouterError(1, {
          location: location2,
          currentLocation
        });
      name2 = matcher.record.name;
      params2 = assign$3({}, currentLocation.params, location2.params);
      path = matcher.stringify(params2);
    }
    const matched = [];
    let parentMatcher = matcher;
    while (parentMatcher) {
      matched.unshift(parentMatcher.record);
      parentMatcher = parentMatcher.parent;
    }
    return {
      name: name2,
      path,
      params: params2,
      matched,
      meta: mergeMetaFields(matched)
    };
  }
  routes2.forEach((route) => addRoute(route));
  return { addRoute, resolve: resolve3, removeRoute, getRoutes, getRecordMatcher };
}
function paramsFromLocation(params2, keys) {
  const newParams = {};
  for (const key of keys) {
    if (key in params2)
      newParams[key] = params2[key];
  }
  return newParams;
}
function normalizeRouteRecord(record) {
  return {
    path: record.path,
    redirect: record.redirect,
    name: record.name,
    meta: record.meta || {},
    aliasOf: void 0,
    beforeEnter: record.beforeEnter,
    props: normalizeRecordProps(record),
    children: record.children || [],
    instances: {},
    leaveGuards: /* @__PURE__ */ new Set(),
    updateGuards: /* @__PURE__ */ new Set(),
    enterCallbacks: {},
    components: "components" in record ? record.components || {} : { default: record.component }
  };
}
function normalizeRecordProps(record) {
  const propsObject = {};
  const props = record.props || false;
  if ("component" in record) {
    propsObject.default = props;
  } else {
    for (const name2 in record.components)
      propsObject[name2] = typeof props === "boolean" ? props : props[name2];
  }
  return propsObject;
}
function isAliasRecord(record) {
  while (record) {
    if (record.record.aliasOf)
      return true;
    record = record.parent;
  }
  return false;
}
function mergeMetaFields(matched) {
  return matched.reduce((meta, record) => assign$3(meta, record.meta), {});
}
function mergeOptions(defaults2, partialOptions) {
  const options2 = {};
  for (const key in defaults2) {
    options2[key] = key in partialOptions ? partialOptions[key] : defaults2[key];
  }
  return options2;
}
const HASH_RE = /#/g;
const AMPERSAND_RE = /&/g;
const SLASH_RE = /\//g;
const EQUAL_RE = /=/g;
const IM_RE = /\?/g;
const PLUS_RE = /\+/g;
const ENC_BRACKET_OPEN_RE = /%5B/g;
const ENC_BRACKET_CLOSE_RE = /%5D/g;
const ENC_CARET_RE = /%5E/g;
const ENC_BACKTICK_RE = /%60/g;
const ENC_CURLY_OPEN_RE = /%7B/g;
const ENC_PIPE_RE = /%7C/g;
const ENC_CURLY_CLOSE_RE = /%7D/g;
const ENC_SPACE_RE = /%20/g;
function commonEncode(text3) {
  return encodeURI("" + text3).replace(ENC_PIPE_RE, "|").replace(ENC_BRACKET_OPEN_RE, "[").replace(ENC_BRACKET_CLOSE_RE, "]");
}
function encodeHash(text3) {
  return commonEncode(text3).replace(ENC_CURLY_OPEN_RE, "{").replace(ENC_CURLY_CLOSE_RE, "}").replace(ENC_CARET_RE, "^");
}
function encodeQueryValue(text3) {
  return commonEncode(text3).replace(PLUS_RE, "%2B").replace(ENC_SPACE_RE, "+").replace(HASH_RE, "%23").replace(AMPERSAND_RE, "%26").replace(ENC_BACKTICK_RE, "`").replace(ENC_CURLY_OPEN_RE, "{").replace(ENC_CURLY_CLOSE_RE, "}").replace(ENC_CARET_RE, "^");
}
function encodeQueryKey(text3) {
  return encodeQueryValue(text3).replace(EQUAL_RE, "%3D");
}
function encodePath(text3) {
  return commonEncode(text3).replace(HASH_RE, "%23").replace(IM_RE, "%3F");
}
function encodeParam(text3) {
  return text3 == null ? "" : encodePath(text3).replace(SLASH_RE, "%2F");
}
function decode$4(text3) {
  try {
    return decodeURIComponent("" + text3);
  } catch (err) {
  }
  return "" + text3;
}
function parseQuery(search) {
  const query2 = {};
  if (search === "" || search === "?")
    return query2;
  const hasLeadingIM = search[0] === "?";
  const searchParams = (hasLeadingIM ? search.slice(1) : search).split("&");
  for (let i = 0; i < searchParams.length; ++i) {
    const searchParam = searchParams[i].replace(PLUS_RE, " ");
    const eqPos = searchParam.indexOf("=");
    const key = decode$4(eqPos < 0 ? searchParam : searchParam.slice(0, eqPos));
    const value = eqPos < 0 ? null : decode$4(searchParam.slice(eqPos + 1));
    if (key in query2) {
      let currentValue = query2[key];
      if (!Array.isArray(currentValue)) {
        currentValue = query2[key] = [currentValue];
      }
      currentValue.push(value);
    } else {
      query2[key] = value;
    }
  }
  return query2;
}
function stringifyQuery(query2) {
  let search = "";
  for (let key in query2) {
    const value = query2[key];
    key = encodeQueryKey(key);
    if (value == null) {
      if (value !== void 0) {
        search += (search.length ? "&" : "") + key;
      }
      continue;
    }
    const values = Array.isArray(value) ? value.map((v) => v && encodeQueryValue(v)) : [value && encodeQueryValue(value)];
    values.forEach((value2) => {
      if (value2 !== void 0) {
        search += (search.length ? "&" : "") + key;
        if (value2 != null)
          search += "=" + value2;
      }
    });
  }
  return search;
}
function normalizeQuery(query2) {
  const normalizedQuery = {};
  for (const key in query2) {
    const value = query2[key];
    if (value !== void 0) {
      normalizedQuery[key] = Array.isArray(value) ? value.map((v) => v == null ? null : "" + v) : value == null ? value : "" + value;
    }
  }
  return normalizedQuery;
}
function useCallbacks() {
  let handlers = [];
  function add3(handler) {
    handlers.push(handler);
    return () => {
      const i = handlers.indexOf(handler);
      if (i > -1)
        handlers.splice(i, 1);
    };
  }
  function reset2() {
    handlers = [];
  }
  return {
    add: add3,
    list: () => handlers,
    reset: reset2
  };
}
function guardToPromiseFn(guard, to, from, record, name2) {
  const enterCallbackArray = record && (record.enterCallbacks[name2] = record.enterCallbacks[name2] || []);
  return () => new Promise((resolve3, reject) => {
    const next = (valid) => {
      if (valid === false)
        reject(createRouterError(4, {
          from,
          to
        }));
      else if (valid instanceof Error) {
        reject(valid);
      } else if (isRouteLocation(valid)) {
        reject(createRouterError(2, {
          from: to,
          to: valid
        }));
      } else {
        if (enterCallbackArray && record.enterCallbacks[name2] === enterCallbackArray && typeof valid === "function")
          enterCallbackArray.push(valid);
        resolve3();
      }
    };
    const guardReturn = guard.call(record && record.instances[name2], to, from, next);
    let guardCall = Promise.resolve(guardReturn);
    if (guard.length < 3)
      guardCall = guardCall.then(next);
    guardCall.catch((err) => reject(err));
  });
}
function extractComponentsGuards(matched, guardType, to, from) {
  const guards = [];
  for (const record of matched) {
    for (const name2 in record.components) {
      let rawComponent = record.components[name2];
      if (guardType !== "beforeRouteEnter" && !record.instances[name2])
        continue;
      if (isRouteComponent(rawComponent)) {
        const options2 = rawComponent.__vccOpts || rawComponent;
        const guard = options2[guardType];
        guard && guards.push(guardToPromiseFn(guard, to, from, record, name2));
      } else {
        let componentPromise = rawComponent();
        guards.push(() => componentPromise.then((resolved) => {
          if (!resolved)
            return Promise.reject(new Error(`Couldn't resolve component "${name2}" at "${record.path}"`));
          const resolvedComponent = isESModule(resolved) ? resolved.default : resolved;
          record.components[name2] = resolvedComponent;
          const options2 = resolvedComponent.__vccOpts || resolvedComponent;
          const guard = options2[guardType];
          return guard && guardToPromiseFn(guard, to, from, record, name2)();
        }));
      }
    }
  }
  return guards;
}
function isRouteComponent(component) {
  return typeof component === "object" || "displayName" in component || "props" in component || "__vccOpts" in component;
}
function useLink(props) {
  const router = inject(routerKey);
  const currentRoute = inject(routeLocationKey);
  const route = computed(() => router.resolve(unref(props.to)));
  const activeRecordIndex = computed(() => {
    const { matched } = route.value;
    const { length: length2 } = matched;
    const routeMatched = matched[length2 - 1];
    const currentMatched = currentRoute.matched;
    if (!routeMatched || !currentMatched.length)
      return -1;
    const index2 = currentMatched.findIndex(isSameRouteRecord.bind(null, routeMatched));
    if (index2 > -1)
      return index2;
    const parentRecordPath = getOriginalPath(matched[length2 - 2]);
    return length2 > 1 && getOriginalPath(routeMatched) === parentRecordPath && currentMatched[currentMatched.length - 1].path !== parentRecordPath ? currentMatched.findIndex(isSameRouteRecord.bind(null, matched[length2 - 2])) : index2;
  });
  const isActive = computed(() => activeRecordIndex.value > -1 && includesParams(currentRoute.params, route.value.params));
  const isExactActive = computed(() => activeRecordIndex.value > -1 && activeRecordIndex.value === currentRoute.matched.length - 1 && isSameRouteLocationParams(currentRoute.params, route.value.params));
  function navigate(e = {}) {
    if (guardEvent(e)) {
      return router[unref(props.replace) ? "replace" : "push"](
        unref(props.to)
      ).catch(noop$3);
    }
    return Promise.resolve();
  }
  return {
    route,
    href: computed(() => route.value.href),
    isActive,
    isExactActive,
    navigate
  };
}
const RouterLinkImpl = /* @__PURE__ */ defineComponent({
  name: "RouterLink",
  props: {
    to: {
      type: [String, Object],
      required: true
    },
    replace: Boolean,
    activeClass: String,
    exactActiveClass: String,
    custom: Boolean,
    ariaCurrentValue: {
      type: String,
      default: "page"
    }
  },
  useLink,
  setup(props, { slots }) {
    const link4 = reactive(useLink(props));
    const { options: options2 } = inject(routerKey);
    const elClass = computed(() => ({
      [getLinkClass(props.activeClass, options2.linkActiveClass, "router-link-active")]: link4.isActive,
      [getLinkClass(props.exactActiveClass, options2.linkExactActiveClass, "router-link-exact-active")]: link4.isExactActive
    }));
    return () => {
      const children = slots.default && slots.default(link4);
      return props.custom ? children : h$1("a", {
        "aria-current": link4.isExactActive ? props.ariaCurrentValue : null,
        href: link4.href,
        onClick: link4.navigate,
        class: elClass.value
      }, children);
    };
  }
});
const RouterLink = RouterLinkImpl;
function guardEvent(e) {
  if (e.metaKey || e.altKey || e.ctrlKey || e.shiftKey)
    return;
  if (e.defaultPrevented)
    return;
  if (e.button !== void 0 && e.button !== 0)
    return;
  if (e.currentTarget && e.currentTarget.getAttribute) {
    const target2 = e.currentTarget.getAttribute("target");
    if (/\b_blank\b/i.test(target2))
      return;
  }
  if (e.preventDefault)
    e.preventDefault();
  return true;
}
function includesParams(outer, inner) {
  for (const key in inner) {
    const innerValue = inner[key];
    const outerValue = outer[key];
    if (typeof innerValue === "string") {
      if (innerValue !== outerValue)
        return false;
    } else {
      if (!Array.isArray(outerValue) || outerValue.length !== innerValue.length || innerValue.some((value, i) => value !== outerValue[i]))
        return false;
    }
  }
  return true;
}
function getOriginalPath(record) {
  return record ? record.aliasOf ? record.aliasOf.path : record.path : "";
}
const getLinkClass = (propClass, globalClass, defaultClass) => propClass != null ? propClass : globalClass != null ? globalClass : defaultClass;
const RouterViewImpl = /* @__PURE__ */ defineComponent({
  name: "RouterView",
  inheritAttrs: false,
  props: {
    name: {
      type: String,
      default: "default"
    },
    route: Object
  },
  setup(props, { attrs, slots }) {
    const injectedRoute = inject(routerViewLocationKey);
    const routeToDisplay = computed(() => props.route || injectedRoute.value);
    const depth = inject(viewDepthKey, 0);
    const matchedRouteRef = computed(() => routeToDisplay.value.matched[depth]);
    provide(viewDepthKey, depth + 1);
    provide(matchedRouteKey, matchedRouteRef);
    provide(routerViewLocationKey, routeToDisplay);
    const viewRef = ref();
    watch(() => [viewRef.value, matchedRouteRef.value, props.name], ([instance, to, name2], [oldInstance, from, oldName]) => {
      if (to) {
        to.instances[name2] = instance;
        if (from && from !== to && instance && instance === oldInstance) {
          if (!to.leaveGuards.size) {
            to.leaveGuards = from.leaveGuards;
          }
          if (!to.updateGuards.size) {
            to.updateGuards = from.updateGuards;
          }
        }
      }
      if (instance && to && (!from || !isSameRouteRecord(to, from) || !oldInstance)) {
        (to.enterCallbacks[name2] || []).forEach((callback) => callback(instance));
      }
    }, { flush: "post" });
    return () => {
      const route = routeToDisplay.value;
      const matchedRoute = matchedRouteRef.value;
      const ViewComponent = matchedRoute && matchedRoute.components[props.name];
      const currentName = props.name;
      if (!ViewComponent) {
        return normalizeSlot(slots.default, { Component: ViewComponent, route });
      }
      const routePropsOption = matchedRoute.props[props.name];
      const routeProps = routePropsOption ? routePropsOption === true ? route.params : typeof routePropsOption === "function" ? routePropsOption(route) : routePropsOption : null;
      const onVnodeUnmounted = (vnode) => {
        if (vnode.component.isUnmounted) {
          matchedRoute.instances[currentName] = null;
        }
      };
      const component = h$1(ViewComponent, assign$3({}, routeProps, attrs, {
        onVnodeUnmounted,
        ref: viewRef
      }));
      return normalizeSlot(slots.default, { Component: component, route }) || component;
    };
  }
});
function normalizeSlot(slot, data) {
  if (!slot)
    return null;
  const slotContent = slot(data);
  return slotContent.length === 1 ? slotContent[0] : slotContent;
}
const RouterView = RouterViewImpl;
function createRouter$1(options2) {
  const matcher = createRouterMatcher(options2.routes, options2);
  const parseQuery$1 = options2.parseQuery || parseQuery;
  const stringifyQuery$1 = options2.stringifyQuery || stringifyQuery;
  const routerHistory = options2.history;
  const beforeGuards = useCallbacks();
  const beforeResolveGuards = useCallbacks();
  const afterGuards = useCallbacks();
  const currentRoute = shallowRef(START_LOCATION_NORMALIZED);
  let pendingLocation = START_LOCATION_NORMALIZED;
  if (isBrowser$2 && options2.scrollBehavior && "scrollRestoration" in history) {
    history.scrollRestoration = "manual";
  }
  const normalizeParams = applyToParams.bind(null, (paramValue) => "" + paramValue);
  const encodeParams = applyToParams.bind(null, encodeParam);
  const decodeParams = applyToParams.bind(null, decode$4);
  function addRoute(parentOrRoute, route) {
    let parent;
    let record;
    if (isRouteName(parentOrRoute)) {
      parent = matcher.getRecordMatcher(parentOrRoute);
      record = route;
    } else {
      record = parentOrRoute;
    }
    return matcher.addRoute(record, parent);
  }
  function removeRoute(name2) {
    const recordMatcher = matcher.getRecordMatcher(name2);
    if (recordMatcher) {
      matcher.removeRoute(recordMatcher);
    }
  }
  function getRoutes() {
    return matcher.getRoutes().map((routeMatcher) => routeMatcher.record);
  }
  function hasRoute(name2) {
    return !!matcher.getRecordMatcher(name2);
  }
  function resolve3(rawLocation, currentLocation) {
    currentLocation = assign$3({}, currentLocation || currentRoute.value);
    if (typeof rawLocation === "string") {
      const locationNormalized = parseURL(parseQuery$1, rawLocation, currentLocation.path);
      const matchedRoute2 = matcher.resolve({ path: locationNormalized.path }, currentLocation);
      const href2 = routerHistory.createHref(locationNormalized.fullPath);
      return assign$3(locationNormalized, matchedRoute2, {
        params: decodeParams(matchedRoute2.params),
        hash: decode$4(locationNormalized.hash),
        redirectedFrom: void 0,
        href: href2
      });
    }
    let matcherLocation;
    if ("path" in rawLocation) {
      matcherLocation = assign$3({}, rawLocation, {
        path: parseURL(parseQuery$1, rawLocation.path, currentLocation.path).path
      });
    } else {
      const targetParams = assign$3({}, rawLocation.params);
      for (const key in targetParams) {
        if (targetParams[key] == null) {
          delete targetParams[key];
        }
      }
      matcherLocation = assign$3({}, rawLocation, {
        params: encodeParams(rawLocation.params)
      });
      currentLocation.params = encodeParams(currentLocation.params);
    }
    const matchedRoute = matcher.resolve(matcherLocation, currentLocation);
    const hash2 = rawLocation.hash || "";
    matchedRoute.params = normalizeParams(decodeParams(matchedRoute.params));
    const fullPath = stringifyURL(stringifyQuery$1, assign$3({}, rawLocation, {
      hash: encodeHash(hash2),
      path: matchedRoute.path
    }));
    const href = routerHistory.createHref(fullPath);
    return assign$3({
      fullPath,
      hash: hash2,
      query: stringifyQuery$1 === stringifyQuery ? normalizeQuery(rawLocation.query) : rawLocation.query || {}
    }, matchedRoute, {
      redirectedFrom: void 0,
      href
    });
  }
  function locationAsObject(to) {
    return typeof to === "string" ? parseURL(parseQuery$1, to, currentRoute.value.path) : assign$3({}, to);
  }
  function checkCanceledNavigation(to, from) {
    if (pendingLocation !== to) {
      return createRouterError(8, {
        from,
        to
      });
    }
  }
  function push2(to) {
    return pushWithRedirect(to);
  }
  function replace2(to) {
    return push2(assign$3(locationAsObject(to), { replace: true }));
  }
  function handleRedirectRecord(to) {
    const lastMatched = to.matched[to.matched.length - 1];
    if (lastMatched && lastMatched.redirect) {
      const { redirect } = lastMatched;
      let newTargetLocation = typeof redirect === "function" ? redirect(to) : redirect;
      if (typeof newTargetLocation === "string") {
        newTargetLocation = newTargetLocation.includes("?") || newTargetLocation.includes("#") ? newTargetLocation = locationAsObject(newTargetLocation) : { path: newTargetLocation };
        newTargetLocation.params = {};
      }
      return assign$3({
        query: to.query,
        hash: to.hash,
        params: to.params
      }, newTargetLocation);
    }
  }
  function pushWithRedirect(to, redirectedFrom) {
    const targetLocation = pendingLocation = resolve3(to);
    const from = currentRoute.value;
    const data = to.state;
    const force = to.force;
    const replace3 = to.replace === true;
    const shouldRedirect = handleRedirectRecord(targetLocation);
    if (shouldRedirect)
      return pushWithRedirect(
        assign$3(locationAsObject(shouldRedirect), {
          state: data,
          force,
          replace: replace3
        }),
        redirectedFrom || targetLocation
      );
    const toLocation = targetLocation;
    toLocation.redirectedFrom = redirectedFrom;
    let failure;
    if (!force && isSameRouteLocation(stringifyQuery$1, from, targetLocation)) {
      failure = createRouterError(16, { to: toLocation, from });
      handleScroll(
        from,
        from,
        true,
        false
      );
    }
    return (failure ? Promise.resolve(failure) : navigate(toLocation, from)).catch((error2) => isNavigationFailure(error2) ? error2 : triggerError(error2, toLocation, from)).then((failure2) => {
      if (failure2) {
        if (isNavigationFailure(failure2, 2)) {
          return pushWithRedirect(
            assign$3(locationAsObject(failure2.to), {
              state: data,
              force,
              replace: replace3
            }),
            redirectedFrom || toLocation
          );
        }
      } else {
        failure2 = finalizeNavigation(toLocation, from, true, replace3, data);
      }
      triggerAfterEach(toLocation, from, failure2);
      return failure2;
    });
  }
  function checkCanceledNavigationAndReject(to, from) {
    const error2 = checkCanceledNavigation(to, from);
    return error2 ? Promise.reject(error2) : Promise.resolve();
  }
  function navigate(to, from) {
    let guards;
    const [leavingRecords, updatingRecords, enteringRecords] = extractChangingRecords(to, from);
    guards = extractComponentsGuards(leavingRecords.reverse(), "beforeRouteLeave", to, from);
    for (const record of leavingRecords) {
      record.leaveGuards.forEach((guard) => {
        guards.push(guardToPromiseFn(guard, to, from));
      });
    }
    const canceledNavigationCheck = checkCanceledNavigationAndReject.bind(null, to, from);
    guards.push(canceledNavigationCheck);
    return runGuardQueue(guards).then(() => {
      guards = [];
      for (const guard of beforeGuards.list()) {
        guards.push(guardToPromiseFn(guard, to, from));
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      guards = extractComponentsGuards(updatingRecords, "beforeRouteUpdate", to, from);
      for (const record of updatingRecords) {
        record.updateGuards.forEach((guard) => {
          guards.push(guardToPromiseFn(guard, to, from));
        });
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      guards = [];
      for (const record of to.matched) {
        if (record.beforeEnter && !from.matched.includes(record)) {
          if (Array.isArray(record.beforeEnter)) {
            for (const beforeEnter of record.beforeEnter)
              guards.push(guardToPromiseFn(beforeEnter, to, from));
          } else {
            guards.push(guardToPromiseFn(record.beforeEnter, to, from));
          }
        }
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      to.matched.forEach((record) => record.enterCallbacks = {});
      guards = extractComponentsGuards(enteringRecords, "beforeRouteEnter", to, from);
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).then(() => {
      guards = [];
      for (const guard of beforeResolveGuards.list()) {
        guards.push(guardToPromiseFn(guard, to, from));
      }
      guards.push(canceledNavigationCheck);
      return runGuardQueue(guards);
    }).catch((err) => isNavigationFailure(err, 8) ? err : Promise.reject(err));
  }
  function triggerAfterEach(to, from, failure) {
    for (const guard of afterGuards.list())
      guard(to, from, failure);
  }
  function finalizeNavigation(toLocation, from, isPush, replace3, data) {
    const error2 = checkCanceledNavigation(toLocation, from);
    if (error2)
      return error2;
    const isFirstNavigation = from === START_LOCATION_NORMALIZED;
    const state = !isBrowser$2 ? {} : history.state;
    if (isPush) {
      if (replace3 || isFirstNavigation)
        routerHistory.replace(toLocation.fullPath, assign$3({
          scroll: isFirstNavigation && state && state.scroll
        }, data));
      else
        routerHistory.push(toLocation.fullPath, data);
    }
    currentRoute.value = toLocation;
    handleScroll(toLocation, from, isPush, isFirstNavigation);
    markAsReady();
  }
  let removeHistoryListener;
  function setupListeners() {
    removeHistoryListener = routerHistory.listen((to, _from, info) => {
      const toLocation = resolve3(to);
      const shouldRedirect = handleRedirectRecord(toLocation);
      if (shouldRedirect) {
        pushWithRedirect(assign$3(shouldRedirect, { replace: true }), toLocation).catch(noop$3);
        return;
      }
      pendingLocation = toLocation;
      const from = currentRoute.value;
      if (isBrowser$2) {
        saveScrollPosition(getScrollKey(from.fullPath, info.delta), computeScrollPosition());
      }
      navigate(toLocation, from).catch((error2) => {
        if (isNavigationFailure(error2, 4 | 8)) {
          return error2;
        }
        if (isNavigationFailure(error2, 2)) {
          pushWithRedirect(
            error2.to,
            toLocation
          ).then((failure) => {
            if (isNavigationFailure(failure, 4 | 16) && !info.delta && info.type === NavigationType.pop) {
              routerHistory.go(-1, false);
            }
          }).catch(noop$3);
          return Promise.reject();
        }
        if (info.delta)
          routerHistory.go(-info.delta, false);
        return triggerError(error2, toLocation, from);
      }).then((failure) => {
        failure = failure || finalizeNavigation(
          toLocation,
          from,
          false
        );
        if (failure) {
          if (info.delta) {
            routerHistory.go(-info.delta, false);
          } else if (info.type === NavigationType.pop && isNavigationFailure(failure, 4 | 16)) {
            routerHistory.go(-1, false);
          }
        }
        triggerAfterEach(toLocation, from, failure);
      }).catch(noop$3);
    });
  }
  let readyHandlers = useCallbacks();
  let errorHandlers = useCallbacks();
  let ready;
  function triggerError(error2, to, from) {
    markAsReady(error2);
    const list3 = errorHandlers.list();
    if (list3.length) {
      list3.forEach((handler) => handler(error2, to, from));
    } else {
      console.error(error2);
    }
    return Promise.reject(error2);
  }
  function isReady() {
    if (ready && currentRoute.value !== START_LOCATION_NORMALIZED)
      return Promise.resolve();
    return new Promise((resolve4, reject) => {
      readyHandlers.add([resolve4, reject]);
    });
  }
  function markAsReady(err) {
    if (ready)
      return;
    ready = true;
    setupListeners();
    readyHandlers.list().forEach(([resolve4, reject]) => err ? reject(err) : resolve4());
    readyHandlers.reset();
  }
  function handleScroll(to, from, isPush, isFirstNavigation) {
    const { scrollBehavior } = options2;
    if (!isBrowser$2 || !scrollBehavior)
      return Promise.resolve();
    const scrollPosition = !isPush && getSavedScrollPosition(getScrollKey(to.fullPath, 0)) || (isFirstNavigation || !isPush) && history.state && history.state.scroll || null;
    return nextTick().then(() => scrollBehavior(to, from, scrollPosition)).then((position) => position && scrollToPosition(position)).catch((err) => triggerError(err, to, from));
  }
  const go = (delta2) => routerHistory.go(delta2);
  let started;
  const installedApps = /* @__PURE__ */ new Set();
  const router = {
    currentRoute,
    addRoute,
    removeRoute,
    hasRoute,
    getRoutes,
    resolve: resolve3,
    options: options2,
    push: push2,
    replace: replace2,
    go,
    back: () => go(-1),
    forward: () => go(1),
    beforeEach: beforeGuards.add,
    beforeResolve: beforeResolveGuards.add,
    afterEach: afterGuards.add,
    onError: errorHandlers.add,
    isReady,
    install(app2) {
      const router2 = this;
      app2.component("RouterLink", RouterLink);
      app2.component("RouterView", RouterView);
      app2.config.globalProperties.$router = router2;
      Object.defineProperty(app2.config.globalProperties, "$route", {
        enumerable: true,
        get: () => unref(currentRoute)
      });
      if (isBrowser$2 && !started && currentRoute.value === START_LOCATION_NORMALIZED) {
        started = true;
        push2(routerHistory.location).catch((err) => {
        });
      }
      const reactiveRoute = {};
      for (const key in START_LOCATION_NORMALIZED) {
        reactiveRoute[key] = computed(() => currentRoute.value[key]);
      }
      app2.provide(routerKey, router2);
      app2.provide(routeLocationKey, reactive(reactiveRoute));
      app2.provide(routerViewLocationKey, currentRoute);
      const unmountApp = app2.unmount;
      installedApps.add(app2);
      app2.unmount = function() {
        installedApps.delete(app2);
        if (installedApps.size < 1) {
          pendingLocation = START_LOCATION_NORMALIZED;
          removeHistoryListener && removeHistoryListener();
          currentRoute.value = START_LOCATION_NORMALIZED;
          started = false;
          ready = false;
        }
        unmountApp();
      };
    }
  };
  return router;
}
function runGuardQueue(guards) {
  return guards.reduce((promise, guard) => promise.then(() => guard()), Promise.resolve());
}
function extractChangingRecords(to, from) {
  const leavingRecords = [];
  const updatingRecords = [];
  const enteringRecords = [];
  const len = Math.max(from.matched.length, to.matched.length);
  for (let i = 0; i < len; i++) {
    const recordFrom = from.matched[i];
    if (recordFrom) {
      if (to.matched.find((record) => isSameRouteRecord(record, recordFrom)))
        updatingRecords.push(recordFrom);
      else
        leavingRecords.push(recordFrom);
    }
    const recordTo = to.matched[i];
    if (recordTo) {
      if (!from.matched.find((record) => isSameRouteRecord(record, recordTo))) {
        enteringRecords.push(recordTo);
      }
    }
  }
  return [leavingRecords, updatingRecords, enteringRecords];
}
function useRouter() {
  return inject(routerKey);
}
function useRoute() {
  return inject(routeLocationKey);
}
const _hoisted_1$1t = {
  key: 0,
  class: "flex justify-self-start items-center"
};
const _hoisted_2$1k = { class: "flex-grow" };
const _hoisted_3$18 = {
  key: 1,
  class: "flex justify-self-start items-center"
};
const __default__$5 = defineComponent({
  inheritAttrs: true
});
const _sfc_main$11 = /* @__PURE__ */ defineComponent({
  ...__default__$5,
  props: {
    prefixIcon: null,
    suffixIcon: null,
    prefixIconClass: null,
    suffixIconClass: null
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        __props.prefixIcon || _ctx.$slots.prefix ? (openBlock(), createElementBlock("span", _hoisted_1$1t, [
          renderSlot(_ctx.$slots, "prefix", {}, () => [
            (openBlock(), createBlock(resolveDynamicComponent(__props.prefixIcon), {
              class: normalizeClass(__props.prefixIconClass)
            }, null, 8, ["class"]))
          ])
        ])) : createCommentVNode("", true),
        createBaseVNode("span", _hoisted_2$1k, [
          renderSlot(_ctx.$slots, "default")
        ]),
        __props.suffixIcon || _ctx.$slots.suffix ? (openBlock(), createElementBlock("span", _hoisted_3$18, [
          renderSlot(_ctx.$slots, "suffix", {}, () => [
            (openBlock(), createBlock(resolveDynamicComponent(__props.suffixIcon), {
              class: normalizeClass(__props.suffixIconClass)
            }, null, 8, ["class"]))
          ])
        ])) : createCommentVNode("", true)
      ], 64);
    };
  }
});
const _hoisted_1$1s = ["href"];
const _sfc_main$10 = /* @__PURE__ */ defineComponent({
  props: {
    href: { default: "" },
    useDefaultHocus: { type: Boolean, default: true }
  },
  setup(__props) {
    const props = __props;
    const attrs = useAttrs();
    const classes = computed(() => {
      const hocus = props.useDefaultHocus ? "hocus-link-default" : "";
      return `${attrs.class ?? "text-indigo-500"} ${hocus}`;
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("a", {
        href: props.href,
        class: normalizeClass(unref(classes))
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 10, _hoisted_1$1s);
    };
  }
});
gql`
mutation ExternalLink_OpenExternal ($url: String!, $includeGraphqlPort: Boolean) {
  openExternal(url: $url, includeGraphqlPort: $includeGraphqlPort)
}
`;
const useExternalLink = ($href, includeGraphqlPort = false) => {
  const openExternalMutation = useMutation(ExternalLink_OpenExternalDocument);
  return (href) => {
    const resolvedHref = unref(typeof href === "string" ? href : $href);
    if (!resolvedHref) {
      return new Error(`Cannot open external link. Possible urls passed in were ${{ localHref: href, initialHref: unref($href) }}`);
    }
    return openExternalMutation.executeMutation({ url: resolvedHref, includeGraphqlPort });
  };
};
const __default__$4 = defineComponent({
  inheritAttrs: true
});
const _sfc_main$$ = /* @__PURE__ */ defineComponent({
  ...__default__$4,
  props: {
    href: { default: "" },
    useDefaultHocus: { type: Boolean, default: true },
    includeGraphqlPort: { type: Boolean, default: false }
  },
  setup(__props) {
    const props = __props;
    const open = useExternalLink(props.href, props.includeGraphqlPort);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$10, {
        "data-cy": "external",
        href: props.href,
        "use-default-hocus": props.useDefaultHocus,
        onClick: withModifiers(unref(open), ["prevent"]),
        onKeypress: withKeys(withModifiers(unref(open), ["prevent"]), ["enter"])
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
      }, 8, ["href", "use-default-hocus", "onClick", "onKeypress"]);
    };
  }
});
const _hoisted_1$1r = ["disabled"];
const VariantClassesTable = {
  primary: "border-indigo-500 bg-indigo-500 text-white hocus-default",
  outline: "border-gray-100 text-indigo-600 hocus-default",
  tertiary: "text-indigo-500 bg-indigo-50 border-transparent hocus-default",
  pending: "bg-gray-500 text-white",
  link: "border-transparent text-indigo-600 hocus-default",
  linkBold: "border-transparent text-indigo-500 font-medium",
  text: "border-0",
  secondary: "bg-jade-500 text-white hocus-secondary"
};
const SizeClassesTable = {
  sm: "px-6px py-2px text-14px h-24px",
  md: "px-12px py-8px text-14px h-32px",
  lg: "px-16px py-11px max-h-40px",
  "lg-wide": "px-32px py-8px"
};
const _sfc_main$_ = /* @__PURE__ */ defineComponent({
  props: {
    prefixIcon: null,
    suffixIcon: null,
    size: null,
    variant: null,
    prefixIconClass: null,
    suffixIconClass: null,
    href: null,
    to: null,
    internalLink: { type: Boolean },
    disabled: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    const attrs = useAttrs();
    const variantClasses = computed(() => VariantClassesTable[props.variant || "primary"]);
    const sizeClasses = computed(() => SizeClassesTable[props.size || "md"]);
    const classes = computed(() => {
      return [
        variantClasses.value,
        sizeClasses.value,
        attrs.class,
        props.disabled && props.variant !== "pending" ? "opacity-50" : "",
        props.disabled ? "cursor-default" : ""
      ];
    });
    const linkVersion = computed(() => {
      if (!props.to) {
        return props.internalLink ? _sfc_main$10 : _sfc_main$$;
      }
      return RouterLink;
    });
    const linkProps = computed(() => {
      if (props.disabled) {
        return {
          role: "link",
          ariaDisabled: "disabled",
          href: null
        };
      }
      if (props.to)
        return { to: props.to };
      if (props.href)
        return { href: props.href };
      return {};
    });
    return (_ctx, _cache) => {
      return !props.href && !props.to ? (openBlock(), createElementBlock("button", {
        key: 0,
        style: { "width": "fit-content" },
        class: normalizeClass(["border rounded flex outline-none leading-tight gap-8px items-center", unref(classes)]),
        disabled: __props.disabled
      }, [
        createVNode(_sfc_main$11, null, createSlots({
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default")
          ]),
          _: 2
        }, [
          __props.prefixIcon || _ctx.$slots.prefix ? {
            name: "prefix",
            fn: withCtx(() => [
              renderSlot(_ctx.$slots, "prefix", {}, () => [
                (openBlock(), createBlock(resolveDynamicComponent(__props.prefixIcon), {
                  class: normalizeClass(__props.prefixIconClass)
                }, null, 8, ["class"]))
              ])
            ])
          } : void 0,
          __props.suffixIcon || _ctx.$slots.suffix ? {
            name: "suffix",
            fn: withCtx(() => [
              renderSlot(_ctx.$slots, "suffix", {}, () => [
                (openBlock(), createBlock(resolveDynamicComponent(__props.suffixIcon), {
                  class: normalizeClass(__props.suffixIconClass)
                }, null, 8, ["class"]))
              ])
            ])
          } : void 0
        ]), 1024)
      ], 10, _hoisted_1$1r)) : (openBlock(), createBlock(resolveDynamicComponent(unref(linkVersion)), mergeProps({ key: 1 }, unref(linkProps), {
        style: { "width": "fit-content" },
        class: ["border rounded flex outline-none gap-8px items-center select-none", unref(classes)],
        "use-default-hocus": false
      }), {
        default: withCtx(() => [
          createVNode(_sfc_main$11, null, createSlots({
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            suffix: withCtx(() => [
              __props.suffixIcon || _ctx.$slots.suffix ? renderSlot(_ctx.$slots, "suffix", { key: 0 }, () => [
                (openBlock(), createBlock(resolveDynamicComponent(__props.suffixIcon), {
                  class: normalizeClass(__props.suffixIconClass)
                }, null, 8, ["class"]))
              ]) : createCommentVNode("", true)
            ]),
            _: 2
          }, [
            __props.prefixIcon || _ctx.$slots.prefix ? {
              name: "prefix",
              fn: withCtx(() => [
                renderSlot(_ctx.$slots, "prefix", {}, () => [
                  (openBlock(), createBlock(resolveDynamicComponent(__props.prefixIcon), {
                    class: normalizeClass(__props.prefixIconClass)
                  }, null, 8, ["class"]))
                ])
              ])
            } : void 0
          ]), 1024)
        ]),
        _: 3
      }, 16, ["class"]));
    };
  }
});
let activePinia;
const setActivePinia = (pinia) => activePinia = pinia;
const piniaSymbol = Symbol();
function isPlainObject$1(o2) {
  return o2 && typeof o2 === "object" && Object.prototype.toString.call(o2) === "[object Object]" && typeof o2.toJSON !== "function";
}
var MutationType;
(function(MutationType2) {
  MutationType2["direct"] = "direct";
  MutationType2["patchObject"] = "patch object";
  MutationType2["patchFunction"] = "patch function";
})(MutationType || (MutationType = {}));
function createPinia$1() {
  const scope = effectScope(true);
  const state = scope.run(() => ref({}));
  let _p = [];
  const toBeInstalled = [];
  const pinia = markRaw({
    install(app2) {
      setActivePinia(pinia);
      {
        pinia._a = app2;
        app2.provide(piniaSymbol, pinia);
        app2.config.globalProperties.$pinia = pinia;
        toBeInstalled.forEach((plugin) => _p.push(plugin));
      }
    },
    use(plugin) {
      if (!this._a && !isVue2) {
        toBeInstalled.push(plugin);
      } else {
        _p.push(plugin);
      }
      return this;
    },
    _p,
    _a: null,
    _e: scope,
    _s: /* @__PURE__ */ new Map(),
    state
  });
  return pinia;
}
function addSubscription(subscriptions, callback, detached) {
  subscriptions.push(callback);
  const removeSubscription = () => {
    const idx = subscriptions.indexOf(callback);
    if (idx > -1) {
      subscriptions.splice(idx, 1);
    }
  };
  if (!detached && getCurrentInstance()) {
    onUnmounted(removeSubscription);
  }
  return removeSubscription;
}
function triggerSubscriptions(subscriptions, ...args) {
  subscriptions.forEach((callback) => {
    callback(...args);
  });
}
function innerPatch(target2, patchToApply) {
  for (const key in patchToApply) {
    const subPatch = patchToApply[key];
    const targetValue = target2[key];
    if (isPlainObject$1(targetValue) && isPlainObject$1(subPatch) && !isRef(subPatch) && !isReactive(subPatch)) {
      target2[key] = innerPatch(targetValue, subPatch);
    } else {
      target2[key] = subPatch;
    }
  }
  return target2;
}
const { assign: assign$2 } = Object;
function isComputed$1(o2) {
  return !!(isRef(o2) && o2.effect);
}
function createOptionsStore(id2, options2, pinia, hot) {
  const { state, actions, getters } = options2;
  const initialState = pinia.state.value[id2];
  let store;
  function setup21() {
    if (!initialState && true) {
      {
        pinia.state.value[id2] = state ? state() : {};
      }
    }
    const localState = toRefs(pinia.state.value[id2]);
    return assign$2(localState, actions, Object.keys(getters || {}).reduce((computedGetters, name2) => {
      computedGetters[name2] = markRaw(computed(() => {
        setActivePinia(pinia);
        const store2 = pinia._s.get(id2);
        return getters[name2].call(store2, store2);
      }));
      return computedGetters;
    }, {}));
  }
  store = createSetupStore(id2, setup21, options2, pinia);
  store.$reset = function $reset() {
    const newState = state ? state() : {};
    this.$patch(($state) => {
      assign$2($state, newState);
    });
  };
  return store;
}
const noop$2 = () => {
};
function createSetupStore($id, setup21, options2 = {}, pinia, hot) {
  let scope;
  const buildState2 = options2.state;
  const optionsForPlugin = {
    actions: {},
    ...options2
  };
  const $subscribeOptions = {
    deep: true
  };
  let isListening;
  let subscriptions = markRaw([]);
  let actionSubscriptions = markRaw([]);
  let debuggerEvents;
  const initialState = pinia.state.value[$id];
  if (!buildState2 && !initialState && true) {
    {
      pinia.state.value[$id] = {};
    }
  }
  ref({});
  function $patch(partialStateOrMutator) {
    let subscriptionMutation;
    isListening = false;
    if (typeof partialStateOrMutator === "function") {
      partialStateOrMutator(pinia.state.value[$id]);
      subscriptionMutation = {
        type: MutationType.patchFunction,
        storeId: $id,
        events: debuggerEvents
      };
    } else {
      innerPatch(pinia.state.value[$id], partialStateOrMutator);
      subscriptionMutation = {
        type: MutationType.patchObject,
        payload: partialStateOrMutator,
        storeId: $id,
        events: debuggerEvents
      };
    }
    isListening = true;
    triggerSubscriptions(subscriptions, subscriptionMutation, pinia.state.value[$id]);
  }
  const $reset = noop$2;
  function $dispose() {
    scope.stop();
    subscriptions = [];
    actionSubscriptions = [];
    pinia._s.delete($id);
  }
  function wrapAction(name2, action3) {
    return function() {
      setActivePinia(pinia);
      const args = Array.from(arguments);
      let afterCallback = noop$2;
      let onErrorCallback = noop$2;
      function after(callback) {
        afterCallback = callback;
      }
      function onError(callback) {
        onErrorCallback = callback;
      }
      triggerSubscriptions(actionSubscriptions, {
        args,
        name: name2,
        store,
        after,
        onError
      });
      let ret;
      try {
        ret = action3.apply(this && this.$id === $id ? this : store, args);
      } catch (error2) {
        if (onErrorCallback(error2) !== false) {
          throw error2;
        }
      }
      if (ret instanceof Promise) {
        return ret.then((value) => {
          const newRet2 = afterCallback(value);
          return newRet2 === void 0 ? value : newRet2;
        }).catch((error2) => {
          if (onErrorCallback(error2) !== false) {
            return Promise.reject(error2);
          }
        });
      }
      const newRet = afterCallback(ret);
      return newRet === void 0 ? ret : newRet;
    };
  }
  const partialStore = {
    _p: pinia,
    $id,
    $onAction: addSubscription.bind(null, actionSubscriptions),
    $patch,
    $reset,
    $subscribe(callback, options3 = {}) {
      const _removeSubscription = addSubscription(
        subscriptions,
        callback,
        options3.detached
      );
      const stopWatcher = scope.run(() => watch(() => pinia.state.value[$id], (state, oldState) => {
        if (isListening) {
          callback({
            storeId: $id,
            type: MutationType.direct,
            events: debuggerEvents
          }, state);
        }
      }, assign$2({}, $subscribeOptions, options3)));
      const removeSubscription = () => {
        stopWatcher();
        _removeSubscription();
      };
      return removeSubscription;
    },
    $dispose
  };
  const store = reactive(assign$2(
    {},
    partialStore
  ));
  pinia._s.set($id, store);
  const setupStore = pinia._e.run(() => {
    scope = effectScope();
    return scope.run(() => setup21());
  });
  for (const key in setupStore) {
    const prop2 = setupStore[key];
    if (isRef(prop2) && !isComputed$1(prop2) || isReactive(prop2)) {
      if (!buildState2) {
        if (initialState) {
          if (isRef(prop2)) {
            prop2.value = initialState[key];
          } else {
            innerPatch(prop2, initialState[key]);
          }
        }
        {
          pinia.state.value[$id][key] = prop2;
        }
      }
    } else if (typeof prop2 === "function") {
      const actionValue = wrapAction(key, prop2);
      {
        setupStore[key] = actionValue;
      }
      optionsForPlugin.actions[key] = prop2;
    } else
      ;
  }
  {
    assign$2(store, setupStore);
  }
  Object.defineProperty(store, "$state", {
    get: () => pinia.state.value[$id],
    set: (state) => {
      $patch(($state) => {
        assign$2($state, state);
      });
    }
  });
  pinia._p.forEach((extender) => {
    {
      assign$2(store, scope.run(() => extender({
        store,
        app: pinia._a,
        pinia,
        options: optionsForPlugin
      })));
    }
  });
  if (initialState && buildState2) {
    (options2.hydrate || innerPatch)(store, initialState);
  }
  isListening = true;
  return store;
}
function defineStore(idOrOptions, setup21, setupOptions) {
  let id2;
  let options2;
  const isSetupStore = typeof setup21 === "function";
  if (typeof idOrOptions === "string") {
    id2 = idOrOptions;
    options2 = isSetupStore ? setupOptions : setup21;
  } else {
    options2 = idOrOptions;
    id2 = idOrOptions.id;
  }
  function useStore(pinia, hot) {
    const currentInstance2 = getCurrentInstance();
    pinia = pinia || currentInstance2 && inject(piniaSymbol);
    if (pinia)
      setActivePinia(pinia);
    pinia = activePinia;
    if (!pinia._s.has(id2)) {
      if (isSetupStore) {
        createSetupStore(id2, setup21, options2, pinia);
      } else {
        createOptionsStore(id2, options2, pinia);
      }
    }
    const store = pinia._s.get(id2);
    return store;
  }
  useStore.$id = id2;
  return useStore;
}
const useLoginConnectStore = defineStore({
  id: "loginConnect",
  state() {
    return {
      utmMedium: "",
      isLoginConnectOpen: false,
      cypressFirstOpened: void 0,
      userData: void 0,
      user: {
        isLoggedIn: false,
        loginError: false,
        isOrganizationLoaded: false,
        isMemberOfOrganization: false
      },
      project: {
        isProjectConnected: false,
        isConfigLoaded: false,
        hasNoRecordedRuns: false,
        hasNonExampleSpec: false,
        isNotAuthorized: false,
        isNotFound: false
      },
      promptsShown: {},
      bannersState: {},
      _latestBannerShownTimeForTesting: void 0
    };
  },
  actions: {
    openLoginConnectModal({ utmMedium }) {
      this.isLoginConnectOpen = true;
      this.utmMedium = utmMedium;
    },
    closeLoginConnectModal() {
      this.isLoginConnectOpen = false;
      this.utmMedium = "";
    },
    setUserFlag(name2, newVal) {
      this.user[name2] = newVal;
    },
    setProjectFlag(name2, newVal) {
      this.project[name2] = newVal;
    },
    setLoginError(error2) {
      this.user.loginError = error2;
    },
    setUserData(userData) {
      this.userData = userData;
    },
    setPromptShown(slug, timestamp) {
      this.promptsShown[slug] = timestamp;
    },
    setCypressFirstOpened(timestamp) {
      this.cypressFirstOpened = timestamp;
    },
    setBannersState(banners) {
      this.bannersState = banners;
    },
    setLatestBannerShownTime(timestamp) {
      this._latestBannerShownTimeForTesting = timestamp;
    }
  },
  getters: {
    userStatus(state) {
      const { user, project } = state;
      let userStatus;
      switch (true) {
        case !user.isLoggedIn:
          userStatus = "isLoggedOut";
          break;
        case (user.isLoggedIn && user.isOrganizationLoaded && !user.isMemberOfOrganization):
          userStatus = "needsOrgConnect";
          break;
        case (user.isLoggedIn && user.isMemberOfOrganization && !project.isProjectConnected && project.isConfigLoaded):
          userStatus = "needsProjectConnect";
          break;
        case (user.isLoggedIn && user.isMemberOfOrganization && project.isProjectConnected && project.hasNoRecordedRuns && project.hasNonExampleSpec && project.isConfigLoaded):
          userStatus = "needsRecordedRun";
          break;
        default:
          userStatus = "allTasksCompleted";
      }
      return userStatus;
    },
    userStatusMatches() {
      return (status) => this.userStatus === status;
    },
    latestBannerShownTime(state) {
      return state._latestBannerShownTimeForTesting;
    }
  }
});
const _hoisted_1$1q = {
  key: 0,
  class: "flex gap-16px"
};
const _hoisted_2$1j = { key: 1 };
const _hoisted_3$17 = { key: 2 };
const _sfc_main$Z = /* @__PURE__ */ defineComponent({
  props: {
    gql: null,
    showRetry: { type: Boolean },
    showLogout: { type: Boolean },
    utmMedium: null,
    utmContent: null
  },
  emits: ["close", "cancel"],
  setup(__props, { emit: emit2 }) {
    const props = __props;
    const loginConnectStore = useLoginConnectStore();
    const { t: t2 } = useI18n();
    const isOnline = useOnline();
    gql`
fragment Auth on Query {
  ...SelectCloudProjectModal
  cloudViewer {
    id
    email
    fullName
    firstOrganization: organizations(first: 1) {
      nodes {
        id
      }
    }
  }
  authState {
    browserOpened
    name
    message
  }
  currentProject {
    id
    cloudProject {
      __typename
      ... on CloudProject {
        id
      }
    }
  }
}
`;
    gql`
mutation Auth_Logout {
  logout {
    ...Auth
  }
}
`;
    gql`
mutation Auth_Login ($utmSource: String!, $utmMedium: String!, $utmContent: String) {
  login (utmSource: $utmSource, utmContent: $utmContent, utmMedium: $utmMedium) {
    ...Auth
  }
}
`;
    gql`
mutation Auth_ResetAuthState {
  resetAuthState {
    ...Auth
  }
}
`;
    const login = useMutation(Auth_LoginDocument);
    const logout = useMutation(Auth_LogoutDocument);
    const reset2 = useMutation(Auth_ResetAuthStateDocument);
    const loginButtonRef = ref(_sfc_main$_);
    const loginInitiated = ref(false);
    onMounted(() => {
      var _a2, _b2;
      (_b2 = (_a2 = loginButtonRef == null ? void 0 : loginButtonRef.value) == null ? void 0 : _a2.$el) == null ? void 0 : _b2.focus();
    });
    onBeforeUnmount(() => {
      if (loginInitiated.value) {
        reset2.executeMutation({});
      }
    });
    const showConnectButton = computed(() => {
      return loginConnectStore.project.isConfigLoaded && loginConnectStore.userStatusMatches("needsProjectConnect");
    });
    const cloudViewer = computed(() => {
      return props.gql.cloudViewer;
    });
    const browserOpened = computed(() => {
      return props.gql.authState.browserOpened;
    });
    const loginMutationIsPending = computed(() => {
      return !cloudViewer.value && (loginInitiated.value || browserOpened.value);
    });
    const handleLoginOrContinue = async () => {
      if (loginConnectStore.user.isLoggedIn) {
        emit2("close");
        return;
      }
      loginInitiated.value = true;
      login.executeMutation({ utmMedium: props.utmMedium, utmContent: props.utmContent || null, utmSource: getUtmSource() });
    };
    const handleCancel = () => {
      emit2("cancel");
    };
    const handleLogout = () => {
      logout.executeMutation({});
    };
    const handleTryAgain = async () => {
      await reset2.executeMutation({});
      login.executeMutation({ utmMedium: props.utmMedium, utmContent: props.utmContent || null, utmSource: getUtmSource() });
    };
    const buttonText = computed(() => {
      const strings = {
        login: t2("topNav.login.actionLogin"),
        connectProject: t2("runs.connect.modal.selectProject.connectProject"),
        continue: t2("topNav.login.actionContinue")
      };
      if (showConnectButton.value) {
        return strings.connectProject;
      }
      if (loginConnectStore.user.isLoggedIn) {
        return strings.continue;
      }
      return strings.login;
    });
    const buttonPrefixIcon = computed(() => {
      return showConnectButton.value ? ConnectIcon : void 0;
    });
    return (_ctx, _cache) => {
      const _component_i_cy_action_restart_x16 = __unplugin_components_3$1;
      const _component_i_cy_loading_x16 = __unplugin_components_0$e;
      return props.showRetry ? (openBlock(), createElementBlock("div", _hoisted_1$1q, [
        createVNode(_sfc_main$_, {
          size: "lg",
          onClick: handleTryAgain
        }, {
          prefix: withCtx(() => [
            createVNode(_component_i_cy_action_restart_x16, { class: "icon-light-white" })
          ]),
          default: withCtx(() => [
            createTextVNode(" " + toDisplayString$1(unref(t2)("topNav.login.actionTryAgain")), 1)
          ]),
          _: 1
        }),
        createVNode(_sfc_main$_, {
          variant: "outline",
          size: "lg",
          onClick: handleCancel
        }, {
          default: withCtx(() => [
            createTextVNode(toDisplayString$1(unref(t2)("topNav.login.actionCancel")), 1)
          ]),
          _: 1
        })
      ])) : props.showLogout ? (openBlock(), createElementBlock("div", _hoisted_2$1j, [
        createBaseVNode("button", {
          class: "bg-white border-rounded outline-transparent border-gray-100 border-1 w-full py-8px text-14px text-indigo-500 block whitespace-nowrap hocus:border-gray-200 hover:no-underline",
          onClick: handleLogout
        }, toDisplayString$1(unref(t2)("topNav.login.actionLogout")), 1)
      ])) : (openBlock(), createElementBlock("div", _hoisted_3$17, [
        unref(loginMutationIsPending) ? (openBlock(), createBlock(_sfc_main$_, {
          key: 0,
          size: "lg",
          variant: "pending",
          "aria-live": "polite",
          disabled: true
        }, {
          prefix: withCtx(() => [
            createVNode(_component_i_cy_loading_x16, { class: "animate-spin icon-dark-white icon-light-gray-400" })
          ]),
          default: withCtx(() => [
            createTextVNode(" " + toDisplayString$1(unref(browserOpened) ? unref(t2)("topNav.login.actionWaiting") : unref(t2)("topNav.login.actionOpening")), 1)
          ]),
          _: 1
        })) : (openBlock(), createBlock(_sfc_main$_, {
          key: 1,
          ref_key: "loginButtonRef",
          ref: loginButtonRef,
          size: "lg",
          variant: "primary",
          "aria-live": "polite",
          disabled: !unref(cloudViewer) && !unref(isOnline),
          "prefix-icon": unref(buttonPrefixIcon),
          onClick: handleLoginOrContinue
        }, {
          default: withCtx(() => [
            createTextVNode(toDisplayString$1(unref(buttonText)), 1)
          ]),
          _: 1
        }, 8, ["disabled", "prefix-icon"]))
      ]));
    };
  }
});
const _hoisted_1$1p = {
  height: "1em",
  width: "1em",
  style: { "min-width": "48px", "min-height": "48px" },
  viewBox: "0 0 48 48",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1i = /* @__PURE__ */ createStaticVNode('<path d="M40 8H8C6.34315 8 5 9.34315 5 11V16H43V11C43 9.34315 41.6569 8 40 8Z" fill="#E1E3ED"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M8 8C6.34315 8 5 9.34315 5 11V16H43V11C43 9.34315 41.6569 8 40 8H8Z" fill="#E1E3ED"></path><path d="M19 30L14 28L9 31V36H38C38.5523 36 39 35.5523 39 35V23L34 24L29 27L24 25L19 30Z" fill="#E1E3ED"></path><path d="M5 16H4C4 16.5523 4.44772 17 5 17V16ZM43 16V17C43.5523 17 44 16.5523 44 16H43ZM19 11C18.4477 11 18 11.4477 18 12C18 12.5523 18.4477 13 19 13V11ZM39 13C39.5523 13 40 12.5523 40 12C40 11.4477 39.5523 11 39 11V13ZM14 28L14.3714 27.0715C14.0812 26.9555 13.7535 26.9817 13.4855 27.1425L14 28ZM19 30L18.6286 30.9285C19 31.077 19.4242 30.99 19.7071 30.7071L19 30ZM24 25L24.3714 24.0715C24 23.923 23.5758 24.01 23.2929 24.2929L24 25ZM29 27L28.6286 27.9285C28.9188 28.0445 29.2465 28.0183 29.5145 27.8575L29 27ZM9 31L8.4855 30.1425C8.1843 30.3232 8 30.6487 8 31H9ZM34 24L33.8039 23.0194C33.6915 23.0419 33.5838 23.0835 33.4855 23.1425L34 24ZM9 36H8C8 36.5523 8.44772 37 9 37V36ZM8 9H40V7H8V9ZM42 11V37H44V11H42ZM6 37V11H4V37H6ZM5 17H43V15H5V17ZM19 13H39V11H19V13ZM8 39C6.89543 39 6 38.1046 6 37H4C4 39.2091 5.79086 41 8 41V39ZM42 37C42 38.1046 41.1046 39 40 39V41C42.2091 41 44 39.2091 44 37H42ZM40 9C41.1046 9 42 9.89543 42 11H44C44 8.79086 42.2091 7 40 7V9ZM8 7C5.79086 7 4 8.79086 4 11H6C6 9.89543 6.89543 9 8 9V7ZM4 11V16H6V11H4ZM44 16V11H42V16H44ZM38 19H10V21H38V19ZM13.6286 28.9285L18.6286 30.9285L19.3714 29.0715L14.3714 27.0715L13.6286 28.9285ZM19.7071 30.7071L24.7071 25.7071L23.2929 24.2929L18.2929 29.2929L19.7071 30.7071ZM23.6286 25.9285L28.6286 27.9285L29.3714 26.0715L24.3714 24.0715L23.6286 25.9285ZM40 35V23H38V35H40ZM40 23V21H38V23H40ZM40 39H24V41H40V39ZM24 39H16V41H24V39ZM16 39H8V41H16V39ZM9.5145 31.8575L14.5145 28.8575L13.4855 27.1425L8.4855 30.1425L9.5145 31.8575ZM29.5145 27.8575L34.5145 24.8575L33.4855 23.1425L28.4855 26.1425L29.5145 27.8575ZM34.1961 24.9806L39.1961 23.9806L38.8039 22.0194L33.8039 23.0194L34.1961 24.9806ZM38 35H9V37H38V35ZM10 36V21H8V36H10ZM8 31V36H10V31H8ZM38 21H40C40 19.8954 39.1046 19 38 19V21ZM38 35V37C39.1046 37 40 36.1046 40 35H38ZM10 19C8.89543 19 8 19.8954 8 21H10H10V19Z" fill="#9095AD"></path><path d="M10 12C10 12.5523 9.55228 13 9 13C8.44772 13 8 12.5523 8 12C8 11.4477 8.44772 11 9 11C9.55228 11 10 11.4477 10 12Z" fill="#9095AD"></path><path d="M13 12C13 12.5523 12.5523 13 12 13C11.4477 13 11 12.5523 11 12C11 11.4477 11.4477 11 12 11C12.5523 11 13 11.4477 13 12Z" fill="#9095AD"></path><path d="M16 12C16 12.5523 15.5523 13 15 13C14.4477 13 14 12.5523 14 12C14 11.4477 14.4477 11 15 11C15.5523 11 16 11.4477 16 12Z" fill="#9095AD"></path><path d="M35.2426 41.2426C32.8995 43.5858 29.1005 43.5858 26.7574 41.2426C24.4142 38.8995 24.4142 35.1005 26.7574 32.7574C29.1005 30.4142 32.8995 30.4142 35.2426 32.7574C37.5858 35.1005 37.5858 38.8995 35.2426 41.2426Z" fill="#F59AA9"></path><path d="M32.5 35.5L29.5 38.5M32.5 38.5L29.5 35.5M35.2426 41.2426C32.8995 43.5858 29.1005 43.5858 26.7574 41.2426C24.4142 38.8995 24.4142 35.1005 26.7574 32.7574C29.1005 30.4142 32.8995 30.4142 35.2426 32.7574C37.5858 35.1005 37.5858 38.8995 35.2426 41.2426Z" stroke="#C62B49" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>', 9);
const _hoisted_11$6 = [
  _hoisted_2$1i
];
function render$N(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1p, _hoisted_11$6);
}
const __unplugin_components_0$d = { name: "cy-no-internet_x48", render: render$N };
const _hoisted_1$1o = { class: "flex flex-col h-full text-center justify-center items-center" };
const _hoisted_2$1h = { class: "mt-24px mb-4px text-gray-900 text-18px leading-24px w-640px" };
const _hoisted_3$16 = { class: "font-normal mt-8px mb-24px text-gray-600 text-16px leading-24px w-672px" };
const _sfc_main$Y = /* @__PURE__ */ defineComponent({
  setup(__props) {
    const { t: t2 } = useI18n();
    return (_ctx, _cache) => {
      const _component_i_cy_no_internet_x48 = __unplugin_components_0$d;
      return openBlock(), createElementBlock("div", _hoisted_1$1o, [
        createVNode(_component_i_cy_no_internet_x48, {
          "data-cy": "no-connection-icon",
          "aria-hidden": "",
          class: "h-48px w-48px icon-dark-gray-500 icon-light-gray-100 icon-dark-secondary-jade-400 icon-light-secondary-jade-200"
        }),
        createBaseVNode("h2", _hoisted_2$1h, toDisplayString$1(unref(t2)("launchpadErrors.noInternet.header")), 1),
        createBaseVNode("p", _hoisted_3$16, [
          renderSlot(_ctx.$slots, "default")
        ])
      ]);
    };
  }
});
const _hoisted_1$1n = {
  height: "1em",
  width: "1em",
  style: { "min-width": "16px", "min-height": "16px" },
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1g = /* @__PURE__ */ createBaseVNode("path", {
  d: "M6.82489 6.84375C7.20878 7.37466 6.80705 7.64512 6.2982 7.98769C5.83364 8.30045 5.27979 8.67332 5.15302 9.35938C5.00805 10.1439 5.28125 10.9219 6.32812 11.4375C6.56597 11.5546 6.50949 12.7308 6.45832 13.7964C6.44049 14.1678 6.4233 14.5258 6.41944 14.8208C6.48106 14.835 6.54298 14.8484 6.60521 14.861C8.64877 14.0046 10.0688 12.7787 10.7969 11.1406C11.2188 9.98438 10.3906 8.64062 9.48438 8.1875C9.03125 6.25 11.1094 6.70312 11.6719 6.84375C11.8387 6.84375 11.7942 6.65067 11.7265 6.35632C11.6166 5.87867 11.4452 5.13434 12.0156 4.51562C12.4404 4.05487 13.0142 3.5235 13.2197 3.33573C11.9379 1.90225 10.0743 1 8 1C7.18411 1 6.40082 1.13959 5.67271 1.39618C4.4022 4.78576 5.05965 5.34405 6.57478 6.63067C6.65575 6.69944 6.73918 6.77028 6.82489 6.84375Z",
  fill: "#D0D2E0",
  class: "icon-light"
}, null, -1);
const _hoisted_3$15 = /* @__PURE__ */ createBaseVNode("path", {
  "fill-rule": "evenodd",
  "clip-rule": "evenodd",
  d: "M6.60521 14.861C6.54298 14.8484 6.48106 14.835 6.41944 14.8208C6.4233 14.5258 6.44049 14.1678 6.45832 13.7964C6.50949 12.7308 6.56597 11.5546 6.32812 11.4375C5.28125 10.9219 5.00805 10.1439 5.15302 9.35938C5.27979 8.67332 5.83364 8.30045 6.2982 7.98769C6.80705 7.64512 7.20878 7.37466 6.82489 6.84375C6.73918 6.77028 6.65575 6.69944 6.57478 6.63067C5.05965 5.34405 4.4022 4.78576 5.67271 1.39618C6.40082 1.13959 7.18411 1 8 1C10.0743 1 11.9379 1.90225 13.2197 3.33573C13.0142 3.5235 12.4404 4.05487 12.0156 4.51562C11.4452 5.13434 11.6166 5.87867 11.7265 6.35632C11.7942 6.65067 11.8387 6.84375 11.6719 6.84375C11.1094 6.70312 9.03125 6.25 9.48438 8.1875C10.3906 8.64062 11.2188 9.98438 10.7969 11.1406C10.0688 12.7787 8.64877 14.0046 6.60521 14.861Z",
  fill: "#D0D2E0",
  class: "icon-light"
}, null, -1);
const _hoisted_4$G = /* @__PURE__ */ createBaseVNode("path", {
  d: "M5.67271 1.39618C2.95077 2.35543 1 4.9499 1 8C1 11.3224 3.31469 14.1043 6.41944 14.8208M5.67271 1.39618C6.40082 1.13959 7.18411 1 8 1C10.0743 1 11.9379 1.90225 13.2197 3.33573M5.67271 1.39618C4.4022 4.78576 5.05965 5.34405 6.57478 6.63067C6.65575 6.69944 6.73918 6.77028 6.82489 6.84375C7.20878 7.37466 6.80705 7.64512 6.2982 7.98769C5.83364 8.30045 5.27979 8.67332 5.15302 9.35938C5.00805 10.1439 5.28125 10.9219 6.32812 11.4375C6.56597 11.5546 6.50949 12.7308 6.45832 13.7964C6.44049 14.1678 6.4233 14.5258 6.41944 14.8208M13.2197 3.33573C13.0142 3.5235 12.4404 4.05487 12.0156 4.51562C11.4452 5.13434 11.6166 5.87867 11.7265 6.35632C11.7942 6.65067 11.8387 6.84375 11.6719 6.84375C11.1094 6.70312 9.03125 6.25 9.48438 8.1875C10.3906 8.64062 11.2188 9.98438 10.7969 11.1406C10.0688 12.7787 8.64877 14.0046 6.60521 14.861M13.2197 3.33573C14.3269 4.57387 15 6.20833 15 8C15 11.866 11.866 15 8 15C7.52239 15 7.05595 14.9522 6.60521 14.861M6.60521 14.861C6.54298 14.8484 6.48106 14.835 6.41944 14.8208",
  stroke: "#1B1E2E",
  "stroke-width": "2",
  class: "icon-dark"
}, null, -1);
const _hoisted_5$r = [
  _hoisted_2$1g,
  _hoisted_3$15,
  _hoisted_4$G
];
function render$M(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1n, _hoisted_5$r);
}
const __unplugin_components_0$c = { name: "cy-globe_x16", render: render$M };
const _hoisted_1$1m = {
  height: "1em",
  width: "1em",
  style: { "min-width": "16px", "min-height": "16px" },
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1f = /* @__PURE__ */ createBaseVNode("path", {
  class: "icon-dark",
  d: "M19.5 18.5854C18.9174 18.7913 18.5 19.3469 18.5 20V29.5C18.5 30.3284 19.1716 31 20 31H28C28.8284 31 29.5 30.3284 29.5 29.5V20C29.5 19.3469 29.0826 18.7913 28.5 18.5854M23 20H25C25.5523 20 26 19.5523 26 19V18C26 17.4477 25.5523 17 25 17H23C22.4477 17 22 17.4477 22 18V19C22 19.5523 22.4477 20 23 20Z",
  stroke: "#1B1E2E",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round",
  style: { "transform": "translate(-16px, -16px)" }
}, null, -1);
const _hoisted_3$14 = [
  _hoisted_2$1f
];
function render$L(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1m, _hoisted_3$14);
}
const __unplugin_components_2$2 = { name: "cy-copy-clipboard_x16", render: render$L };
gql`
mutation Clipboard_CopyToClipboard($text: String!) {
  copyTextToClipboard(text: $text)
}
`;
function useClipboard(options2 = {}) {
  const copyMutation = useMutation(Clipboard_CopyToClipboardDocument);
  const copied = ref(false);
  let timer;
  const copy2 = async (text3) => {
    const { data } = await copyMutation.executeMutation({ text: text3 });
    copied.value = (data == null ? void 0 : data.copyTextToClipboard) ?? false;
    if (timer) {
      clearTimeout(timer);
    }
    timer = setTimeout(() => {
      copied.value = false;
      timer = void 0;
    }, options2.copiedDuring || 2e3);
  };
  return { copy: copy2, copied };
}
const _export_sfc$1 = (sfc, props) => {
  const target2 = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target2[key] = val;
  }
  return target2;
};
const _sfc_main$X = {};
function _sfc_render$4(_ctx, _cache) {
  return openBlock(), createBlock(Transition, {
    "enter-active-class": "transition duration-200 ease-out",
    "enter-from-class": "translate-y-1 opacity-0",
    "enter-to-class": "translate-y-0 opacity-100",
    "leave-active-class": "transition duration-150 ease-in",
    "leave-from-class": "translate-y-0 opacity-100",
    "leave-to-class": "translate-y-1 opacity-0"
  }, {
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default")
    ]),
    _: 3
  });
}
const TransitionQuickFade = /* @__PURE__ */ _export_sfc$1(_sfc_main$X, [["render", _sfc_render$4]]);
const _hoisted_1$1l = { key: 0 };
const _hoisted_2$1e = { key: 1 };
const _sfc_main$W = /* @__PURE__ */ defineComponent({
  props: {
    text: null,
    noIcon: { type: Boolean, default: false },
    variant: { default: "tertiary" },
    size: { default: "md" }
  },
  setup(__props) {
    const props = __props;
    const { copy: copy2, copied } = useClipboard({ copiedDuring: 2e3 });
    const copyToClipboard = () => {
      if (props.text) {
        copy2(props.text);
      }
    };
    const { t: t2 } = useI18n();
    return (_ctx, _cache) => {
      const _component_i_cy_copy_clipboard_x16 = __unplugin_components_2$2;
      return openBlock(), createBlock(_sfc_main$_, {
        size: __props.size,
        variant: __props.variant,
        "data-cy": "copy-button",
        onClick: copyToClipboard
      }, createSlots({
        default: withCtx(() => [
          createVNode(TransitionQuickFade, { mode: "out-in" }, {
            default: withCtx(() => [
              !unref(copied) ? (openBlock(), createElementBlock("span", _hoisted_1$1l, toDisplayString$1(unref(t2)("clipboard.copy")), 1)) : (openBlock(), createElementBlock("span", _hoisted_2$1e, toDisplayString$1(unref(t2)("clipboard.copied")), 1))
            ]),
            _: 1
          })
        ]),
        _: 2
      }, [
        !__props.noIcon ? {
          name: "prefix",
          fn: withCtx(() => [
            createVNode(_component_i_cy_copy_clipboard_x16, {
              class: normalizeClass(["h-16px w-16px", {
                "icon-dark-indigo-500": __props.variant === "tertiary",
                "icon-dark-gray-500": __props.variant === "outline"
              }])
            }, null, 8, ["class"])
          ])
        } : void 0
      ]), 1032, ["size", "variant"]);
    };
  }
});
const _hoisted_1$1k = { class: "border rounded flex font-light bg-gray-50 border-gray-100 px-16px text-gray-600 text-14px leading-40px relative items-center whitespace-nowrap overflow-hidden" };
const _hoisted_2$1d = { class: "font-sans opacity-gradient p-4px pl-32px top-0 right-0 bottom-0 absolute" };
const _sfc_main$V = /* @__PURE__ */ defineComponent({
  props: {
    text: null
  },
  setup(__props) {
    const props = __props;
    return (_ctx, _cache) => {
      const _component_i_cy_globe_x16 = __unplugin_components_0$c;
      return openBlock(), createElementBlock("code", _hoisted_1$1k, [
        createVNode(_component_i_cy_globe_x16, { class: "flex-shrink-0 h-16px mr-8px w-16px icon-dark-gray-500 icon-light-gray-100" }),
        createTextVNode(" " + toDisplayString$1(props.text) + " ", 1),
        createBaseVNode("div", _hoisted_2$1d, [
          createVNode(_sfc_main$W, {
            class: "bg-indigo-100",
            text: __props.text
          }, null, 8, ["text"])
        ])
      ]);
    };
  }
});
const CopyText_vue_vue_type_style_index_0_scoped_98359a1d_lang = "";
const CopyText = /* @__PURE__ */ _export_sfc$1(_sfc_main$V, [["__scopeId", "data-v-98359a1d"]]);
const _hoisted_1$1j = {
  height: "1em",
  width: "1em",
  style: { "min-width": "16px", "min-height": "16px" },
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1c = /* @__PURE__ */ createBaseVNode("path", {
  d: "M13.6569 13.6569C10.5327 16.781 5.46734 16.781 2.34315 13.6569C-0.781048 10.5327 -0.781048 5.46734 2.34315 2.34315C5.46734 -0.781048 10.5327 -0.781048 13.6569 2.34315C16.781 5.46734 16.781 10.5327 13.6569 13.6569Z",
  fill: "currentColor",
  class: "icon-light"
}, null, -1);
const _hoisted_3$13 = /* @__PURE__ */ createBaseVNode("path", {
  "fill-rule": "evenodd",
  style: { "transform": "translate(5px, 2.8px)" },
  "clip-rule": "evenodd",
  d: "M1.84477 2.53525L1.84393 2.53644C1.55247 2.99535 0.945841 3.13804 0.479622 2.85394C0.00800347 2.56655 -0.141341 1.95125 0.146051 1.47963L0.999992 2C0.146051 1.47963 0.146312 1.4792 0.146575 1.47877L0.147114 1.47789L0.148242 1.47605L0.150693 1.47208L0.15638 1.463L0.170928 1.44042C0.182042 1.42347 0.196048 1.40275 0.213011 1.37881C0.246877 1.33103 0.292902 1.2699 0.351663 1.20004C0.468602 1.06102 0.639738 0.88294 0.870176 0.706317C1.33799 0.347756 2.04656 0 2.99999 0C4.09902 0 4.91097 0.431523 5.41403 1.1133C5.87907 1.74355 5.99999 2.47764 5.99999 3C5.99999 3.62988 5.82686 4.14716 5.53741 4.57449C5.26535 4.97613 4.9179 5.25422 4.6658 5.44689C4.05784 5.9115 4.01123 5.9631 3.99314 6.11684C3.92861 6.66534 3.43165 7.05768 2.88315 6.99315C2.33465 6.92862 1.94231 6.43166 2.00684 5.88316C2.1317 4.8219 2.92228 4.24504 3.33392 3.94468C3.3778 3.91266 3.41737 3.88379 3.45138 3.8578C3.67974 3.68328 3.80299 3.56879 3.88152 3.45286C3.94266 3.3626 3.99999 3.23731 3.99999 3C3.99999 2.74111 3.93342 2.4752 3.8047 2.30076C3.71401 2.17785 3.52597 2 2.99999 2C2.5628 2 2.27137 2.15224 2.08684 2.29368C1.99111 2.36706 1.92298 2.43898 1.88221 2.48746C1.86211 2.51135 1.84967 2.52835 1.84477 2.53525ZM2.99999 10C3.55228 10 3.99999 9.55229 3.99999 9C3.99999 8.44771 3.55228 8 2.99999 8C2.44771 8 1.99999 8.44771 1.99999 9C1.99999 9.55229 2.44771 10 2.99999 10Z",
  fill: "white",
  class: "icon-dark"
}, null, -1);
const _hoisted_4$F = [
  _hoisted_2$1c,
  _hoisted_3$13
];
function render$K(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1j, _hoisted_4$F);
}
const __unplugin_components_0$b = { name: "cy-circle-bg-question-mark_x16", render: render$K };
const _hoisted_1$1i = {
  height: "1em",
  width: "1em",
  style: { "min-width": "12px", "min-height": "12px" },
  viewBox: "0 0 12 12",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1b = /* @__PURE__ */ createBaseVNode("path", {
  d: "M1 11L11 1M1 1L11 11",
  stroke: "#1B1E2E",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round",
  class: "icon-dark"
}, null, -1);
const _hoisted_3$12 = [
  _hoisted_2$1b
];
function render$J(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1i, _hoisted_3$12);
}
const __unplugin_components_0$a = { name: "cy-delete_x12", render: render$J };
function _extends$1() {
  _extends$1 = Object.assign || function(target2) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target2[key] = source[key];
        }
      }
    }
    return target2;
  };
  return _extends$1.apply(this, arguments);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null)
    return {};
  var target2 = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0)
      continue;
    target2[key] = source[key];
  }
  return target2;
}
function _unsupportedIterableToArray(o2, minLen) {
  if (!o2)
    return;
  if (typeof o2 === "string")
    return _arrayLikeToArray(o2, minLen);
  var n = Object.prototype.toString.call(o2).slice(8, -1);
  if (n === "Object" && o2.constructor)
    n = o2.constructor.name;
  if (n === "Map" || n === "Set")
    return Array.from(o2);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
    return _arrayLikeToArray(o2, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length)
    len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++)
    arr2[i] = arr[i];
  return arr2;
}
function _createForOfIteratorHelperLoose(o2, allowArrayLike) {
  var it2;
  if (typeof Symbol === "undefined" || o2[Symbol.iterator] == null) {
    if (Array.isArray(o2) || (it2 = _unsupportedIterableToArray(o2)) || allowArrayLike && o2 && typeof o2.length === "number") {
      if (it2)
        o2 = it2;
      var i = 0;
      return function() {
        if (i >= o2.length)
          return {
            done: true
          };
        return {
          done: false,
          value: o2[i++]
        };
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  it2 = o2[Symbol.iterator]();
  return it2.next.bind(it2);
}
function match(value, lookup) {
  if (value in lookup) {
    var returnValue = lookup[value];
    for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }
    return typeof returnValue === "function" ? returnValue.apply(void 0, args) : returnValue;
  }
  var error2 = new Error('Tried to handle "' + value + '" but there is no handler defined. Only defined handlers are: ' + Object.keys(lookup).map(function(key) {
    return '"' + key + '"';
  }).join(", ") + ".");
  if (Error.captureStackTrace)
    Error.captureStackTrace(error2, match);
  throw error2;
}
var Features;
(function(Features2) {
  Features2[Features2["None"] = 0] = "None";
  Features2[Features2["RenderStrategy"] = 1] = "RenderStrategy";
  Features2[Features2["Static"] = 2] = "Static";
})(Features || (Features = {}));
var RenderStrategy;
(function(RenderStrategy2) {
  RenderStrategy2[RenderStrategy2["Unmount"] = 0] = "Unmount";
  RenderStrategy2[RenderStrategy2["Hidden"] = 1] = "Hidden";
})(RenderStrategy || (RenderStrategy = {}));
function render$I(_ref) {
  var _ref$visible = _ref.visible, visible = _ref$visible === void 0 ? true : _ref$visible, _ref$features = _ref.features, features = _ref$features === void 0 ? Features.None : _ref$features, main2 = _objectWithoutPropertiesLoose(_ref, ["visible", "features"]);
  if (visible)
    return _render(main2);
  if (features & Features.Static) {
    if (main2.props["static"])
      return _render(main2);
  }
  if (features & Features.RenderStrategy) {
    var _main$props$unmount, _match;
    var strategy = ((_main$props$unmount = main2.props.unmount) != null ? _main$props$unmount : true) ? RenderStrategy.Unmount : RenderStrategy.Hidden;
    return match(strategy, (_match = {}, _match[RenderStrategy.Unmount] = function() {
      return null;
    }, _match[RenderStrategy.Hidden] = function() {
      return _render(_extends$1({}, main2, {
        props: _extends$1({}, main2.props, {
          hidden: true,
          style: {
            display: "none"
          }
        })
      }));
    }, _match));
  }
  return _render(main2);
}
function _render(_ref2) {
  var props = _ref2.props, attrs = _ref2.attrs, slots = _ref2.slots, slot = _ref2.slot, name2 = _ref2.name;
  var _omit = omit(props, ["unmount", "static"]), as = _omit.as, passThroughProps = _objectWithoutPropertiesLoose(_omit, ["as"]);
  var children = slots["default"] == null ? void 0 : slots["default"](slot);
  if (as === "template") {
    if (Object.keys(passThroughProps).length > 0 || Object.keys(attrs).length > 0) {
      var _ref3 = children != null ? children : [], firstChild = _ref3[0], other = _ref3.slice(1);
      if (!isValidElement(firstChild) || other.length > 0) {
        throw new Error(['Passing props on "template"!', "", "The current component <" + name2 + ' /> is rendering a "template".', "However we need to passthrough the following props:", Object.keys(passThroughProps).concat(Object.keys(attrs)).map(function(line) {
          return "  - " + line;
        }).join("\n"), "", "You can apply a few solutions:", ['Add an `as="..."` prop, to ensure that we render an actual element instead of a "template".', "Render a single element as the child so that we can forward the props onto that element."].map(function(line) {
          return "  - " + line;
        }).join("\n")].join("\n"));
      }
      return cloneVNode(firstChild, passThroughProps);
    }
    if (Array.isArray(children) && children.length === 1) {
      return children[0];
    }
    return children;
  }
  return h$1(as, passThroughProps, children);
}
function omit(object, keysToOmit) {
  if (keysToOmit === void 0) {
    keysToOmit = [];
  }
  var clone2 = Object.assign({}, object);
  for (var _iterator = _createForOfIteratorHelperLoose(keysToOmit), _step; !(_step = _iterator()).done; ) {
    var key = _step.value;
    if (key in clone2)
      delete clone2[key];
  }
  return clone2;
}
function isValidElement(input) {
  if (input == null)
    return false;
  if (typeof input.type === "string")
    return true;
  if (typeof input.type === "object")
    return true;
  if (typeof input.type === "function")
    return true;
  return false;
}
var Keys;
(function(Keys2) {
  Keys2["Space"] = " ";
  Keys2["Enter"] = "Enter";
  Keys2["Escape"] = "Escape";
  Keys2["Backspace"] = "Backspace";
  Keys2["ArrowLeft"] = "ArrowLeft";
  Keys2["ArrowUp"] = "ArrowUp";
  Keys2["ArrowRight"] = "ArrowRight";
  Keys2["ArrowDown"] = "ArrowDown";
  Keys2["Home"] = "Home";
  Keys2["End"] = "End";
  Keys2["PageUp"] = "PageUp";
  Keys2["PageDown"] = "PageDown";
  Keys2["Tab"] = "Tab";
})(Keys || (Keys = {}));
var id = 0;
function generateId() {
  return ++id;
}
function useId() {
  return generateId();
}
var focusableSelector = /* @__PURE__ */ ["[contentEditable=true]", "[tabindex]", "a[href]", "area[href]", "button:not([disabled])", "iframe", "input:not([disabled])", "select:not([disabled])", "textarea:not([disabled])"].map(function(selector) {
  return selector + ":not([tabindex='-1'])";
}).join(",");
var Focus;
(function(Focus2) {
  Focus2[Focus2["First"] = 1] = "First";
  Focus2[Focus2["Previous"] = 2] = "Previous";
  Focus2[Focus2["Next"] = 4] = "Next";
  Focus2[Focus2["Last"] = 8] = "Last";
  Focus2[Focus2["WrapAround"] = 16] = "WrapAround";
  Focus2[Focus2["NoScroll"] = 32] = "NoScroll";
})(Focus || (Focus = {}));
var FocusResult;
(function(FocusResult2) {
  FocusResult2[FocusResult2["Error"] = 0] = "Error";
  FocusResult2[FocusResult2["Overflow"] = 1] = "Overflow";
  FocusResult2[FocusResult2["Success"] = 2] = "Success";
  FocusResult2[FocusResult2["Underflow"] = 3] = "Underflow";
})(FocusResult || (FocusResult = {}));
var Direction;
(function(Direction2) {
  Direction2[Direction2["Previous"] = -1] = "Previous";
  Direction2[Direction2["Next"] = 1] = "Next";
})(Direction || (Direction = {}));
function getFocusableElements(container) {
  if (container === void 0) {
    container = document.body;
  }
  if (container == null)
    return [];
  return Array.from(container.querySelectorAll(focusableSelector));
}
var FocusableMode;
(function(FocusableMode2) {
  FocusableMode2[FocusableMode2["Strict"] = 0] = "Strict";
  FocusableMode2[FocusableMode2["Loose"] = 1] = "Loose";
})(FocusableMode || (FocusableMode = {}));
function isFocusableElement(element, mode) {
  var _match;
  if (mode === void 0) {
    mode = FocusableMode.Strict;
  }
  if (element === document.body)
    return false;
  return match(mode, (_match = {}, _match[FocusableMode.Strict] = function() {
    return element.matches(focusableSelector);
  }, _match[FocusableMode.Loose] = function() {
    var next = element;
    while (next !== null) {
      if (next.matches(focusableSelector))
        return true;
      next = next.parentElement;
    }
    return false;
  }, _match));
}
function focusElement(element) {
  element == null ? void 0 : element.focus({
    preventScroll: true
  });
}
function focusIn(container, focus) {
  var elements = Array.isArray(container) ? container : getFocusableElements(container);
  var active = document.activeElement;
  var direction = function() {
    if (focus & (Focus.First | Focus.Next))
      return Direction.Next;
    if (focus & (Focus.Previous | Focus.Last))
      return Direction.Previous;
    throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
  }();
  var startIndex = function() {
    if (focus & Focus.First)
      return 0;
    if (focus & Focus.Previous)
      return Math.max(0, elements.indexOf(active)) - 1;
    if (focus & Focus.Next)
      return Math.max(0, elements.indexOf(active)) + 1;
    if (focus & Focus.Last)
      return elements.length - 1;
    throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
  }();
  var focusOptions = focus & Focus.NoScroll ? {
    preventScroll: true
  } : {};
  var offset2 = 0;
  var total = elements.length;
  var next = void 0;
  do {
    var _next;
    if (offset2 >= total || offset2 + total <= 0)
      return FocusResult.Error;
    var nextIdx = startIndex + offset2;
    if (focus & Focus.WrapAround) {
      nextIdx = (nextIdx + total) % total;
    } else {
      if (nextIdx < 0)
        return FocusResult.Underflow;
      if (nextIdx >= total)
        return FocusResult.Overflow;
    }
    next = elements[nextIdx];
    (_next = next) == null ? void 0 : _next.focus(focusOptions);
    offset2 += direction;
  } while (next !== document.activeElement);
  if (!next.hasAttribute("tabindex"))
    next.setAttribute("tabindex", "0");
  return FocusResult.Success;
}
function useWindowEvent(type2, listener, options2) {
  window.addEventListener(type2, listener, options2);
  onUnmounted(function() {
    return window.removeEventListener(type2, listener, options2);
  });
}
function contains$2(containers, element) {
  for (var _iterator = _createForOfIteratorHelperLoose(containers), _step; !(_step = _iterator()).done; ) {
    var container = _step.value;
    if (container.contains(element))
      return true;
  }
  return false;
}
function useFocusTrap(containers, enabled, options2) {
  if (enabled === void 0) {
    enabled = ref(true);
  }
  if (options2 === void 0) {
    options2 = ref({});
  }
  var restoreElement = ref(typeof window !== "undefined" ? document.activeElement : null);
  var previousActiveElement = ref(null);
  function handleFocus() {
    if (!enabled.value)
      return;
    if (containers.value.size !== 1)
      return;
    var initialFocus = options2.value.initialFocus;
    var activeElement = document.activeElement;
    if (initialFocus) {
      if (initialFocus === activeElement) {
        return;
      }
    } else if (contains$2(containers.value, activeElement)) {
      return;
    }
    restoreElement.value = activeElement;
    if (initialFocus) {
      focusElement(initialFocus);
    } else {
      var couldFocus = false;
      for (var _iterator = _createForOfIteratorHelperLoose(containers.value), _step; !(_step = _iterator()).done; ) {
        var container = _step.value;
        var result = focusIn(container, Focus.First);
        if (result === FocusResult.Success) {
          couldFocus = true;
          break;
        }
      }
      if (!couldFocus)
        throw new Error("There are no focusable elements inside the <FocusTrap />");
    }
    previousActiveElement.value = document.activeElement;
  }
  function restore2() {
    focusElement(restoreElement.value);
    restoreElement.value = null;
    previousActiveElement.value = null;
  }
  watchEffect(handleFocus);
  onUpdated(function() {
    enabled.value ? handleFocus() : restore2();
  });
  onUnmounted(restore2);
  useWindowEvent("keydown", function(event) {
    if (!enabled.value)
      return;
    if (event.key !== Keys.Tab)
      return;
    if (!document.activeElement)
      return;
    if (containers.value.size !== 1)
      return;
    event.preventDefault();
    for (var _iterator2 = _createForOfIteratorHelperLoose(containers.value), _step2; !(_step2 = _iterator2()).done; ) {
      var element = _step2.value;
      var result = focusIn(element, (event.shiftKey ? Focus.Previous : Focus.Next) | Focus.WrapAround);
      if (result === FocusResult.Success) {
        previousActiveElement.value = document.activeElement;
        break;
      }
    }
  });
  useWindowEvent("focus", function(event) {
    if (!enabled.value)
      return;
    if (containers.value.size !== 1)
      return;
    var previous = previousActiveElement.value;
    if (!previous)
      return;
    var toElement = event.target;
    if (toElement && toElement instanceof HTMLElement) {
      if (!contains$2(containers.value, toElement)) {
        event.preventDefault();
        event.stopPropagation();
        focusElement(previous);
      } else {
        previousActiveElement.value = toElement;
        focusElement(toElement);
      }
    } else {
      focusElement(previousActiveElement.value);
    }
  }, true);
}
var CHILDREN_SELECTOR = "body > *";
var interactables = /* @__PURE__ */ new Set();
var originals = /* @__PURE__ */ new Map();
function inert(element) {
  element.setAttribute("aria-hidden", "true");
  element.inert = true;
}
function restore(element) {
  var original = originals.get(element);
  if (!original)
    return;
  if (original["aria-hidden"] === null)
    element.removeAttribute("aria-hidden");
  else
    element.setAttribute("aria-hidden", original["aria-hidden"]);
  element.inert = original.inert;
}
function useInertOthers(container, enabled) {
  if (enabled === void 0) {
    enabled = ref(true);
  }
  watchEffect(function(onInvalidate) {
    if (!enabled.value)
      return;
    if (!container.value)
      return;
    var element = container.value;
    interactables.add(element);
    for (var _iterator = _createForOfIteratorHelperLoose(originals.keys()), _step; !(_step = _iterator()).done; ) {
      var original = _step.value;
      if (original.contains(element)) {
        restore(original);
        originals["delete"](original);
      }
    }
    document.querySelectorAll(CHILDREN_SELECTOR).forEach(function(child) {
      if (!(child instanceof HTMLElement))
        return;
      for (var _iterator2 = _createForOfIteratorHelperLoose(interactables), _step2; !(_step2 = _iterator2()).done; ) {
        var interactable = _step2.value;
        if (child.contains(interactable))
          return;
      }
      if (interactables.size === 1) {
        originals.set(child, {
          "aria-hidden": child.getAttribute("aria-hidden"),
          inert: child.inert
        });
        inert(child);
      }
    });
    onInvalidate(function() {
      interactables["delete"](element);
      if (interactables.size > 0) {
        document.querySelectorAll(CHILDREN_SELECTOR).forEach(function(child) {
          if (!(child instanceof HTMLElement))
            return;
          if (originals.has(child))
            return;
          for (var _iterator3 = _createForOfIteratorHelperLoose(interactables), _step3; !(_step3 = _iterator3()).done; ) {
            var interactable = _step3.value;
            if (child.contains(interactable))
              return;
          }
          originals.set(child, {
            "aria-hidden": child.getAttribute("aria-hidden"),
            inert: child.inert
          });
          inert(child);
        });
      } else {
        for (var _iterator4 = _createForOfIteratorHelperLoose(originals.keys()), _step4; !(_step4 = _iterator4()).done; ) {
          var _element = _step4.value;
          restore(_element);
          originals["delete"](_element);
        }
      }
    });
  });
}
var StackContext = /* @__PURE__ */ Symbol("StackContext");
var StackMessage;
(function(StackMessage2) {
  StackMessage2[StackMessage2["AddElement"] = 0] = "AddElement";
  StackMessage2[StackMessage2["RemoveElement"] = 1] = "RemoveElement";
})(StackMessage || (StackMessage = {}));
function useStackContext() {
  return inject(StackContext, function() {
  });
}
function useElemenStack(element) {
  var notify = useStackContext();
  watchEffect(function(onInvalidate) {
    var domElement = element == null ? void 0 : element.value;
    if (!domElement)
      return;
    notify(StackMessage.AddElement, domElement);
    onInvalidate(function() {
      return notify(StackMessage.RemoveElement, domElement);
    });
  });
}
function useStackProvider(onUpdate) {
  var parentUpdate = useStackContext();
  function notify() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    onUpdate == null ? void 0 : onUpdate.apply(void 0, args);
    parentUpdate.apply(void 0, args);
  }
  provide(StackContext, notify);
}
var ForcePortalRootContext = /* @__PURE__ */ Symbol("ForcePortalRootContext");
function usePortalRoot() {
  return inject(ForcePortalRootContext, false);
}
var ForcePortalRoot = /* @__PURE__ */ defineComponent({
  name: "ForcePortalRoot",
  props: {
    as: {
      type: [Object, String],
      "default": "template"
    },
    force: {
      type: Boolean,
      "default": false
    }
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots, attrs = _ref.attrs;
    provide(ForcePortalRootContext, props.force);
    return function() {
      var passThroughProps = _objectWithoutPropertiesLoose(props, ["force"]);
      return render$I({
        props: passThroughProps,
        slot: {},
        slots,
        attrs,
        name: "ForcePortalRoot"
      });
    };
  }
});
function getPortalRoot() {
  var existingRoot = document.getElementById("headlessui-portal-root");
  if (existingRoot)
    return existingRoot;
  var root = document.createElement("div");
  root.setAttribute("id", "headlessui-portal-root");
  return document.body.appendChild(root);
}
var Portal = /* @__PURE__ */ defineComponent({
  name: "Portal",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    }
  },
  setup: function setup2(props, _ref) {
    var slots = _ref.slots, attrs = _ref.attrs;
    var forcePortalRoot = usePortalRoot();
    var groupContext = inject(PortalGroupContext, null);
    var myTarget = ref(forcePortalRoot === true ? getPortalRoot() : groupContext === null ? getPortalRoot() : groupContext.resolveTarget());
    watchEffect(function() {
      if (forcePortalRoot)
        return;
      if (groupContext === null)
        return;
      myTarget.value = groupContext.resolveTarget();
    });
    var element = ref(null);
    useElemenStack(element);
    onUnmounted(function() {
      var root = document.getElementById("headlessui-portal-root");
      if (!root)
        return;
      if (myTarget.value !== root)
        return;
      if (myTarget.value.children.length <= 0) {
        var _myTarget$value$paren;
        (_myTarget$value$paren = myTarget.value.parentElement) == null ? void 0 : _myTarget$value$paren.removeChild(myTarget.value);
      }
    });
    useStackProvider();
    return function() {
      if (myTarget.value === null)
        return null;
      var propsWeControl = {
        ref: element
      };
      return h$1(
        Teleport,
        {
          to: myTarget.value
        },
        render$I({
          props: _extends$1({}, props, propsWeControl),
          slot: {},
          attrs,
          slots,
          name: "Portal"
        })
      );
    };
  }
});
var PortalGroupContext = /* @__PURE__ */ Symbol("PortalGroupContext");
var PortalGroup = /* @__PURE__ */ defineComponent({
  name: "PortalGroup",
  props: {
    as: {
      type: [Object, String],
      "default": "template"
    },
    target: {
      type: Object,
      "default": null
    }
  },
  setup: function setup3(props, _ref2) {
    var attrs = _ref2.attrs, slots = _ref2.slots;
    var api = reactive({
      resolveTarget: function resolveTarget2() {
        return props.target;
      }
    });
    provide(PortalGroupContext, api);
    return function() {
      var passThroughProps = _objectWithoutPropertiesLoose(props, ["target"]);
      return render$I({
        props: passThroughProps,
        slot: {},
        attrs,
        slots,
        name: "PortalGroup"
      });
    };
  }
});
var DescriptionContext = /* @__PURE__ */ Symbol("DescriptionContext");
function useDescriptionContext() {
  var context = inject(DescriptionContext, null);
  if (context === null) {
    throw new Error("Missing parent");
  }
  return context;
}
function useDescriptions(_temp) {
  var _ref = _temp === void 0 ? {} : _temp, _ref$slot = _ref.slot, slot = _ref$slot === void 0 ? ref({}) : _ref$slot, _ref$name = _ref.name, name2 = _ref$name === void 0 ? "Description" : _ref$name, _ref$props = _ref.props, props = _ref$props === void 0 ? {} : _ref$props;
  var descriptionIds = ref([]);
  function register(value) {
    descriptionIds.value.push(value);
    return function() {
      var idx = descriptionIds.value.indexOf(value);
      if (idx === -1)
        return;
      descriptionIds.value.splice(idx, 1);
    };
  }
  provide(DescriptionContext, {
    register,
    slot,
    name: name2,
    props
  });
  return computed(function() {
    return descriptionIds.value.length > 0 ? descriptionIds.value.join(" ") : void 0;
  });
}
var Description = /* @__PURE__ */ defineComponent({
  name: "Description",
  props: {
    as: {
      type: [Object, String],
      "default": "p"
    }
  },
  render: function render$1() {
    var _this$context = this.context, _this$context$name = _this$context.name, name2 = _this$context$name === void 0 ? "Description" : _this$context$name, _this$context$slot = _this$context.slot, slot = _this$context$slot === void 0 ? ref({}) : _this$context$slot, _this$context$props = _this$context.props, props = _this$context$props === void 0 ? {} : _this$context$props;
    var passThroughProps = this.$props;
    var propsWeControl = _extends$1({}, Object.entries(props).reduce(function(acc, _ref2) {
      var _Object$assign;
      var key = _ref2[0], value = _ref2[1];
      return Object.assign(acc, (_Object$assign = {}, _Object$assign[key] = unref(value), _Object$assign));
    }, {}), {
      id: this.id
    });
    return render$I({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot: slot.value,
      attrs: this.$attrs,
      slots: this.$slots,
      name: name2
    });
  },
  setup: function setup4() {
    var context = useDescriptionContext();
    var id2 = "headlessui-description-" + useId();
    onMounted(function() {
      return onUnmounted(context.register(id2));
    });
    return {
      id: id2,
      context
    };
  }
});
function dom(ref2) {
  var _ref$value$$el;
  if (ref2 == null)
    return null;
  if (ref2.value == null)
    return null;
  return (_ref$value$$el = ref2.value.$el) != null ? _ref$value$$el : ref2.value;
}
var Context = /* @__PURE__ */ Symbol("Context");
var State;
(function(State2) {
  State2[State2["Open"] = 0] = "Open";
  State2[State2["Closed"] = 1] = "Closed";
})(State || (State = {}));
function useOpenClosed() {
  return inject(Context, null);
}
function useOpenClosedProvider(value) {
  provide(Context, value);
}
var DialogStates;
(function(DialogStates2) {
  DialogStates2[DialogStates2["Open"] = 0] = "Open";
  DialogStates2[DialogStates2["Closed"] = 1] = "Closed";
})(DialogStates || (DialogStates = {}));
var DialogContext = /* @__PURE__ */ Symbol("DialogContext");
function useDialogContext(component) {
  var context = inject(DialogContext, null);
  if (context === null) {
    var err = new Error("<" + component + " /> is missing a parent <Dialog /> component.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useDialogContext);
    throw err;
  }
  return context;
}
var Missing = "DC8F892D-2EBD-447C-A4C8-A03058436FF4";
var Dialog = /* @__PURE__ */ defineComponent({
  name: "Dialog",
  inheritAttrs: false,
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    },
    "static": {
      type: Boolean,
      "default": false
    },
    unmount: {
      type: Boolean,
      "default": true
    },
    open: {
      type: [Boolean, String],
      "default": Missing
    },
    initialFocus: {
      type: Object,
      "default": null
    }
  },
  emits: ["close"],
  render: function render$12() {
    var _this = this;
    var propsWeControl = _extends$1({}, this.$attrs, {
      ref: "el",
      id: this.id,
      role: "dialog",
      "aria-modal": this.dialogState === DialogStates.Open ? true : void 0,
      "aria-labelledby": this.titleId,
      "aria-describedby": this.describedby,
      onClick: this.handleClick,
      onKeydown: this.handleKeyDown
    });
    var _this$$props = this.$props, passThroughProps = _objectWithoutPropertiesLoose(_this$$props, ["open", "initialFocus"]);
    var slot = {
      open: this.dialogState === DialogStates.Open
    };
    return h$1(ForcePortalRoot, {
      force: true
    }, function() {
      return h$1(Portal, function() {
        return h$1(PortalGroup, {
          target: _this.dialogRef
        }, function() {
          return h$1(ForcePortalRoot, {
            force: false
          }, function() {
            return render$I({
              props: _extends$1({}, passThroughProps, propsWeControl),
              slot,
              attrs: _this.$attrs,
              slots: _this.$slots,
              visible: _this.visible,
              features: Features.RenderStrategy | Features.Static,
              name: "Dialog"
            });
          });
        });
      });
    });
  },
  setup: function setup5(props, _ref) {
    var emit2 = _ref.emit;
    var containers = ref(/* @__PURE__ */ new Set());
    var usesOpenClosedState = useOpenClosed();
    var open = computed(function() {
      if (props.open === Missing && usesOpenClosedState !== null) {
        var _match;
        return match(usesOpenClosedState.value, (_match = {}, _match[State.Open] = true, _match[State.Closed] = false, _match));
      }
      return props.open;
    });
    var hasOpen = props.open !== Missing || usesOpenClosedState !== null;
    if (!hasOpen) {
      throw new Error("You forgot to provide an `open` prop to the `Dialog`.");
    }
    if (typeof open.value !== "boolean") {
      throw new Error("You provided an `open` prop to the `Dialog`, but the value is not a boolean. Received: " + (open.value === Missing ? void 0 : props.open));
    }
    var dialogState = computed(function() {
      return props.open ? DialogStates.Open : DialogStates.Closed;
    });
    var visible = computed(function() {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === State.Open;
      }
      return dialogState.value === DialogStates.Open;
    });
    var internalDialogRef = ref(null);
    var enabled = ref(dialogState.value === DialogStates.Open);
    onUpdated(function() {
      enabled.value = dialogState.value === DialogStates.Open;
    });
    var id2 = "headlessui-dialog-" + useId();
    var focusTrapOptions = computed(function() {
      return {
        initialFocus: props.initialFocus
      };
    });
    useFocusTrap(containers, enabled, focusTrapOptions);
    useInertOthers(internalDialogRef, enabled);
    useStackProvider(function(message, element) {
      var _match2;
      return match(message, (_match2 = {}, _match2[StackMessage.AddElement] = function() {
        containers.value.add(element);
      }, _match2[StackMessage.RemoveElement] = function() {
        containers.value["delete"](element);
      }, _match2));
    });
    var describedby = useDescriptions({
      name: "DialogDescription",
      slot: computed(function() {
        return {
          open: open.value
        };
      })
    });
    var titleId = ref(null);
    var api = {
      titleId,
      dialogState,
      setTitleId: function setTitleId(id3) {
        if (titleId.value === id3)
          return;
        titleId.value = id3;
      },
      close: function close() {
        emit2("close", false);
      }
    };
    provide(DialogContext, api);
    useWindowEvent("mousedown", function(event) {
      var target2 = event.target;
      if (dialogState.value !== DialogStates.Open)
        return;
      if (containers.value.size !== 1)
        return;
      if (contains$2(containers.value, target2))
        return;
      api.close();
      nextTick(function() {
        return target2 == null ? void 0 : target2.focus();
      });
    });
    watchEffect(function(onInvalidate) {
      if (dialogState.value !== DialogStates.Open)
        return;
      var overflow = document.documentElement.style.overflow;
      var paddingRight = document.documentElement.style.paddingRight;
      var scrollbarWidth = window.innerWidth - document.documentElement.clientWidth;
      document.documentElement.style.overflow = "hidden";
      document.documentElement.style.paddingRight = scrollbarWidth + "px";
      onInvalidate(function() {
        document.documentElement.style.overflow = overflow;
        document.documentElement.style.paddingRight = paddingRight;
      });
    });
    watchEffect(function(onInvalidate) {
      if (dialogState.value !== DialogStates.Open)
        return;
      var container = dom(internalDialogRef);
      if (!container)
        return;
      var observer = new IntersectionObserver(function(entries) {
        for (var _iterator = _createForOfIteratorHelperLoose(entries), _step; !(_step = _iterator()).done; ) {
          var entry = _step.value;
          if (entry.boundingClientRect.x === 0 && entry.boundingClientRect.y === 0 && entry.boundingClientRect.width === 0 && entry.boundingClientRect.height === 0) {
            api.close();
          }
        }
      });
      observer.observe(container);
      onInvalidate(function() {
        return observer.disconnect();
      });
    });
    return {
      id: id2,
      el: internalDialogRef,
      dialogRef: internalDialogRef,
      containers,
      dialogState,
      titleId,
      describedby,
      visible,
      open,
      handleClick: function handleClick(event) {
        event.stopPropagation();
      },
      handleKeyDown: function handleKeyDown(event) {
        if (event.key !== Keys.Escape)
          return;
        if (dialogState.value !== DialogStates.Open)
          return;
        if (containers.value.size > 1)
          return;
        event.preventDefault();
        event.stopPropagation();
        api.close();
      }
    };
  }
});
var DialogOverlay = /* @__PURE__ */ defineComponent({
  name: "DialogOverlay",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    }
  },
  render: function render$13() {
    var api = useDialogContext("DialogOverlay");
    var propsWeControl = {
      ref: "el",
      id: this.id,
      "aria-hidden": true,
      onClick: this.handleClick
    };
    var passThroughProps = this.$props;
    return render$I({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot: {
        open: api.dialogState.value === DialogStates.Open
      },
      attrs: this.$attrs,
      slots: this.$slots,
      name: "DialogOverlay"
    });
  },
  setup: function setup6() {
    var api = useDialogContext("DialogOverlay");
    var id2 = "headlessui-dialog-overlay-" + useId();
    return {
      id: id2,
      handleClick: function handleClick(event) {
        event.preventDefault();
        event.stopPropagation();
        api.close();
      }
    };
  }
});
var DialogTitle = /* @__PURE__ */ defineComponent({
  name: "DialogTitle",
  props: {
    as: {
      type: [Object, String],
      "default": "h2"
    }
  },
  render: function render$14() {
    var api = useDialogContext("DialogTitle");
    var propsWeControl = {
      id: this.id
    };
    var passThroughProps = this.$props;
    return render$I({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot: {
        open: api.dialogState.value === DialogStates.Open
      },
      attrs: this.$attrs,
      slots: this.$slots,
      name: "DialogTitle"
    });
  },
  setup: function setup7() {
    var api = useDialogContext("DialogTitle");
    var id2 = "headlessui-dialog-title-" + useId();
    onMounted(function() {
      api.setTitleId(id2);
      onUnmounted(function() {
        return api.setTitleId(null);
      });
    });
    return {
      id: id2
    };
  }
});
var DialogDescription = Description;
var DisclosureStates;
(function(DisclosureStates2) {
  DisclosureStates2[DisclosureStates2["Open"] = 0] = "Open";
  DisclosureStates2[DisclosureStates2["Closed"] = 1] = "Closed";
})(DisclosureStates || (DisclosureStates = {}));
function assertNever(x2) {
  throw new Error("Unexpected object: " + x2);
}
var Focus$1;
(function(Focus2) {
  Focus2[Focus2["First"] = 0] = "First";
  Focus2[Focus2["Previous"] = 1] = "Previous";
  Focus2[Focus2["Next"] = 2] = "Next";
  Focus2[Focus2["Last"] = 3] = "Last";
  Focus2[Focus2["Specific"] = 4] = "Specific";
  Focus2[Focus2["Nothing"] = 5] = "Nothing";
})(Focus$1 || (Focus$1 = {}));
function calculateActiveIndex(action3, resolvers) {
  var items = resolvers.resolveItems();
  if (items.length <= 0)
    return null;
  var currentActiveIndex = resolvers.resolveActiveIndex();
  var activeIndex = currentActiveIndex != null ? currentActiveIndex : -1;
  var nextActiveIndex = function() {
    switch (action3.focus) {
      case Focus$1.First:
        return items.findIndex(function(item) {
          return !resolvers.resolveDisabled(item);
        });
      case Focus$1.Previous: {
        var idx = items.slice().reverse().findIndex(function(item, idx2, all) {
          if (activeIndex !== -1 && all.length - idx2 - 1 >= activeIndex)
            return false;
          return !resolvers.resolveDisabled(item);
        });
        if (idx === -1)
          return idx;
        return items.length - 1 - idx;
      }
      case Focus$1.Next:
        return items.findIndex(function(item, idx2) {
          if (idx2 <= activeIndex)
            return false;
          return !resolvers.resolveDisabled(item);
        });
      case Focus$1.Last: {
        var _idx = items.slice().reverse().findIndex(function(item) {
          return !resolvers.resolveDisabled(item);
        });
        if (_idx === -1)
          return _idx;
        return items.length - 1 - _idx;
      }
      case Focus$1.Specific:
        return items.findIndex(function(item) {
          return resolvers.resolveId(item) === action3.id;
        });
      case Focus$1.Nothing:
        return null;
      default:
        assertNever(action3);
    }
  }();
  return nextActiveIndex === -1 ? currentActiveIndex : nextActiveIndex;
}
var ListboxStates;
(function(ListboxStates2) {
  ListboxStates2[ListboxStates2["Open"] = 0] = "Open";
  ListboxStates2[ListboxStates2["Closed"] = 1] = "Closed";
})(ListboxStates || (ListboxStates = {}));
function nextFrame$1(cb) {
  requestAnimationFrame(function() {
    return requestAnimationFrame(cb);
  });
}
var ListboxContext = /* @__PURE__ */ Symbol("ListboxContext");
function useListboxContext(component) {
  var context = inject(ListboxContext, null);
  if (context === null) {
    var err = new Error("<" + component + " /> is missing a parent <Listbox /> component.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useListboxContext);
    throw err;
  }
  return context;
}
var Listbox = /* @__PURE__ */ defineComponent({
  name: "Listbox",
  emits: ["update:modelValue"],
  props: {
    as: {
      type: [Object, String],
      "default": "template"
    },
    disabled: {
      type: [Boolean],
      "default": false
    },
    horizontal: {
      type: [Boolean],
      "default": false
    },
    modelValue: {
      type: [Object, String, Number, Boolean]
    }
  },
  setup: function setup8(props, _ref) {
    var slots = _ref.slots, attrs = _ref.attrs, emit2 = _ref.emit;
    var listboxState = ref(ListboxStates.Closed);
    var labelRef = ref(null);
    var buttonRef = ref(null);
    var optionsRef = ref(null);
    var options2 = ref([]);
    var searchQuery = ref("");
    var activeOptionIndex = ref(null);
    var value = computed(function() {
      return props.modelValue;
    });
    var api = {
      listboxState,
      value,
      orientation: computed(function() {
        return props.horizontal ? "horizontal" : "vertical";
      }),
      labelRef,
      buttonRef,
      optionsRef,
      disabled: computed(function() {
        return props.disabled;
      }),
      options: options2,
      searchQuery,
      activeOptionIndex,
      closeListbox: function closeListbox() {
        if (props.disabled)
          return;
        if (listboxState.value === ListboxStates.Closed)
          return;
        listboxState.value = ListboxStates.Closed;
        activeOptionIndex.value = null;
      },
      openListbox: function openListbox() {
        if (props.disabled)
          return;
        if (listboxState.value === ListboxStates.Open)
          return;
        listboxState.value = ListboxStates.Open;
      },
      goToOption: function goToOption(focus, id2) {
        if (props.disabled)
          return;
        if (listboxState.value === ListboxStates.Closed)
          return;
        var nextActiveOptionIndex = calculateActiveIndex(focus === Focus$1.Specific ? {
          focus: Focus$1.Specific,
          id: id2
        } : {
          focus
        }, {
          resolveItems: function resolveItems() {
            return options2.value;
          },
          resolveActiveIndex: function resolveActiveIndex() {
            return activeOptionIndex.value;
          },
          resolveId: function resolveId(option) {
            return option.id;
          },
          resolveDisabled: function resolveDisabled(option) {
            return option.dataRef.disabled;
          }
        });
        if (searchQuery.value === "" && activeOptionIndex.value === nextActiveOptionIndex)
          return;
        searchQuery.value = "";
        activeOptionIndex.value = nextActiveOptionIndex;
      },
      search: function search(value2) {
        if (props.disabled)
          return;
        if (listboxState.value === ListboxStates.Closed)
          return;
        searchQuery.value += value2.toLowerCase();
        var match3 = options2.value.findIndex(function(option) {
          return !option.dataRef.disabled && option.dataRef.textValue.startsWith(searchQuery.value);
        });
        if (match3 === -1 || match3 === activeOptionIndex.value)
          return;
        activeOptionIndex.value = match3;
      },
      clearSearch: function clearSearch() {
        if (props.disabled)
          return;
        if (listboxState.value === ListboxStates.Closed)
          return;
        if (searchQuery.value === "")
          return;
        searchQuery.value = "";
      },
      registerOption: function registerOption(id2, dataRef) {
        options2.value.push({
          id: id2,
          dataRef
        });
      },
      unregisterOption: function unregisterOption(id2) {
        var nextOptions = options2.value.slice();
        var currentActiveOption = activeOptionIndex.value !== null ? nextOptions[activeOptionIndex.value] : null;
        var idx = nextOptions.findIndex(function(a2) {
          return a2.id === id2;
        });
        if (idx !== -1)
          nextOptions.splice(idx, 1);
        options2.value = nextOptions;
        activeOptionIndex.value = function() {
          if (idx === activeOptionIndex.value)
            return null;
          if (currentActiveOption === null)
            return null;
          return nextOptions.indexOf(currentActiveOption);
        }();
      },
      select: function select(value2) {
        if (props.disabled)
          return;
        emit2("update:modelValue", value2);
      }
    };
    useWindowEvent("mousedown", function(event) {
      var _dom, _dom2, _dom3;
      var target2 = event.target;
      var active = document.activeElement;
      if (listboxState.value !== ListboxStates.Open)
        return;
      if ((_dom = dom(buttonRef)) == null ? void 0 : _dom.contains(target2))
        return;
      if (!((_dom2 = dom(optionsRef)) == null ? void 0 : _dom2.contains(target2)))
        api.closeListbox();
      if (active !== document.body && (active == null ? void 0 : active.contains(target2)))
        return;
      if (!event.defaultPrevented)
        (_dom3 = dom(buttonRef)) == null ? void 0 : _dom3.focus({
          preventScroll: true
        });
    });
    provide(ListboxContext, api);
    useOpenClosedProvider(computed(function() {
      var _match;
      return match(listboxState.value, (_match = {}, _match[ListboxStates.Open] = State.Open, _match[ListboxStates.Closed] = State.Closed, _match));
    }));
    return function() {
      var slot = {
        open: listboxState.value === ListboxStates.Open,
        disabled: props.disabled
      };
      return render$I({
        props: omit(props, ["modelValue", "onUpdate:modelValue", "disabled", "horizontal"]),
        slot,
        slots,
        attrs,
        name: "Listbox"
      });
    };
  }
});
var ListboxLabel = /* @__PURE__ */ defineComponent({
  name: "ListboxLabel",
  props: {
    as: {
      type: [Object, String],
      "default": "label"
    }
  },
  render: function render$15() {
    var api = useListboxContext("ListboxLabel");
    var slot = {
      open: api.listboxState.value === ListboxStates.Open,
      disabled: api.disabled.value
    };
    var propsWeControl = {
      id: this.id,
      ref: "el",
      onClick: this.handleClick
    };
    return render$I({
      props: _extends$1({}, this.$props, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      name: "ListboxLabel"
    });
  },
  setup: function setup9() {
    var api = useListboxContext("ListboxLabel");
    var id2 = "headlessui-listbox-label-" + useId();
    return {
      id: id2,
      el: api.labelRef,
      handleClick: function handleClick() {
        var _dom4;
        (_dom4 = dom(api.buttonRef)) == null ? void 0 : _dom4.focus({
          preventScroll: true
        });
      }
    };
  }
});
var ListboxButton = /* @__PURE__ */ defineComponent({
  name: "ListboxButton",
  props: {
    as: {
      type: [Object, String],
      "default": "button"
    }
  },
  render: function render$16() {
    var _dom5, _dom6;
    var api = useListboxContext("ListboxButton");
    var slot = {
      open: api.listboxState.value === ListboxStates.Open,
      disabled: api.disabled.value
    };
    var propsWeControl = {
      ref: "el",
      id: this.id,
      type: "button",
      "aria-haspopup": true,
      "aria-controls": (_dom5 = dom(api.optionsRef)) == null ? void 0 : _dom5.id,
      "aria-expanded": api.disabled.value ? void 0 : api.listboxState.value === ListboxStates.Open,
      "aria-labelledby": api.labelRef.value ? [(_dom6 = dom(api.labelRef)) == null ? void 0 : _dom6.id, this.id].join(" ") : void 0,
      disabled: api.disabled.value === true ? true : void 0,
      onKeydown: this.handleKeyDown,
      onKeyup: this.handleKeyUp,
      onClick: this.handleClick
    };
    return render$I({
      props: _extends$1({}, this.$props, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      name: "ListboxButton"
    });
  },
  setup: function setup10() {
    var api = useListboxContext("ListboxButton");
    var id2 = "headlessui-listbox-button-" + useId();
    function handleKeyDown(event) {
      switch (event.key) {
        case Keys.Space:
        case Keys.Enter:
        case Keys.ArrowDown:
          event.preventDefault();
          api.openListbox();
          nextTick(function() {
            var _dom7;
            (_dom7 = dom(api.optionsRef)) == null ? void 0 : _dom7.focus({
              preventScroll: true
            });
            if (!api.value.value)
              api.goToOption(Focus$1.First);
          });
          break;
        case Keys.ArrowUp:
          event.preventDefault();
          api.openListbox();
          nextTick(function() {
            var _dom8;
            (_dom8 = dom(api.optionsRef)) == null ? void 0 : _dom8.focus({
              preventScroll: true
            });
            if (!api.value.value)
              api.goToOption(Focus$1.Last);
          });
          break;
      }
    }
    function handleKeyUp(event) {
      switch (event.key) {
        case Keys.Space:
          event.preventDefault();
          break;
      }
    }
    function handleClick(event) {
      if (api.disabled.value)
        return;
      if (api.listboxState.value === ListboxStates.Open) {
        api.closeListbox();
        nextTick(function() {
          var _dom9;
          return (_dom9 = dom(api.buttonRef)) == null ? void 0 : _dom9.focus({
            preventScroll: true
          });
        });
      } else {
        event.preventDefault();
        api.openListbox();
        nextFrame$1(function() {
          var _dom10;
          return (_dom10 = dom(api.optionsRef)) == null ? void 0 : _dom10.focus({
            preventScroll: true
          });
        });
      }
    }
    return {
      id: id2,
      el: api.buttonRef,
      handleKeyDown,
      handleKeyUp,
      handleClick
    };
  }
});
var ListboxOptions = /* @__PURE__ */ defineComponent({
  name: "ListboxOptions",
  props: {
    as: {
      type: [Object, String],
      "default": "ul"
    },
    "static": {
      type: Boolean,
      "default": false
    },
    unmount: {
      type: Boolean,
      "default": true
    }
  },
  render: function render$17() {
    var _api$options$value$ap, _dom$id, _dom11, _dom12;
    var api = useListboxContext("ListboxOptions");
    var slot = {
      open: api.listboxState.value === ListboxStates.Open
    };
    var propsWeControl = {
      "aria-activedescendant": api.activeOptionIndex.value === null ? void 0 : (_api$options$value$ap = api.options.value[api.activeOptionIndex.value]) == null ? void 0 : _api$options$value$ap.id,
      "aria-labelledby": (_dom$id = (_dom11 = dom(api.labelRef)) == null ? void 0 : _dom11.id) != null ? _dom$id : (_dom12 = dom(api.buttonRef)) == null ? void 0 : _dom12.id,
      "aria-orientation": api.orientation.value,
      id: this.id,
      onKeydown: this.handleKeyDown,
      role: "listbox",
      tabIndex: 0,
      ref: "el"
    };
    var passThroughProps = this.$props;
    return render$I({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      features: Features.RenderStrategy | Features.Static,
      visible: this.visible,
      name: "ListboxOptions"
    });
  },
  setup: function setup11() {
    var api = useListboxContext("ListboxOptions");
    var id2 = "headlessui-listbox-options-" + useId();
    var searchDebounce = ref(null);
    function handleKeyDown(event) {
      if (searchDebounce.value)
        clearTimeout(searchDebounce.value);
      switch (event.key) {
        case Keys.Space:
          if (api.searchQuery.value !== "") {
            event.preventDefault();
            event.stopPropagation();
            return api.search(event.key);
          }
        case Keys.Enter:
          event.preventDefault();
          event.stopPropagation();
          if (api.activeOptionIndex.value !== null) {
            var dataRef = api.options.value[api.activeOptionIndex.value].dataRef;
            api.select(dataRef.value);
          }
          api.closeListbox();
          nextTick(function() {
            var _dom13;
            return (_dom13 = dom(api.buttonRef)) == null ? void 0 : _dom13.focus({
              preventScroll: true
            });
          });
          break;
        case match(api.orientation.value, {
          vertical: Keys.ArrowDown,
          horizontal: Keys.ArrowRight
        }):
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(Focus$1.Next);
        case match(api.orientation.value, {
          vertical: Keys.ArrowUp,
          horizontal: Keys.ArrowLeft
        }):
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(Focus$1.Previous);
        case Keys.Home:
        case Keys.PageUp:
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(Focus$1.First);
        case Keys.End:
        case Keys.PageDown:
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(Focus$1.Last);
        case Keys.Escape:
          event.preventDefault();
          event.stopPropagation();
          api.closeListbox();
          nextTick(function() {
            var _dom14;
            return (_dom14 = dom(api.buttonRef)) == null ? void 0 : _dom14.focus({
              preventScroll: true
            });
          });
          break;
        case Keys.Tab:
          event.preventDefault();
          event.stopPropagation();
          break;
        default:
          if (event.key.length === 1) {
            api.search(event.key);
            searchDebounce.value = setTimeout(function() {
              return api.clearSearch();
            }, 350);
          }
          break;
      }
    }
    var usesOpenClosedState = useOpenClosed();
    var visible = computed(function() {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === State.Open;
      }
      return api.listboxState.value === ListboxStates.Open;
    });
    return {
      id: id2,
      el: api.optionsRef,
      handleKeyDown,
      visible
    };
  }
});
var ListboxOption = /* @__PURE__ */ defineComponent({
  name: "ListboxOption",
  props: {
    as: {
      type: [Object, String],
      "default": "li"
    },
    value: {
      type: [Object, String, Number, Boolean]
    },
    disabled: {
      type: Boolean,
      "default": false
    }
  },
  setup: function setup12(props, _ref2) {
    var slots = _ref2.slots, attrs = _ref2.attrs;
    var api = useListboxContext("ListboxOption");
    var id2 = "headlessui-listbox-option-" + useId();
    var active = computed(function() {
      return api.activeOptionIndex.value !== null ? api.options.value[api.activeOptionIndex.value].id === id2 : false;
    });
    var selected = computed(function() {
      return toRaw(api.value.value) === toRaw(props.value);
    });
    var dataRef = ref({
      disabled: props.disabled,
      value: props.value,
      textValue: ""
    });
    onMounted(function() {
      var _document$getElementB, _document$getElementB2;
      var textValue = (_document$getElementB = document.getElementById(id2)) == null ? void 0 : (_document$getElementB2 = _document$getElementB.textContent) == null ? void 0 : _document$getElementB2.toLowerCase().trim();
      if (textValue !== void 0)
        dataRef.value.textValue = textValue;
    });
    onMounted(function() {
      return api.registerOption(id2, dataRef);
    });
    onUnmounted(function() {
      return api.unregisterOption(id2);
    });
    onMounted(function() {
      watch([api.listboxState, selected], function() {
        var _document$getElementB3;
        if (api.listboxState.value !== ListboxStates.Open)
          return;
        if (!selected.value)
          return;
        api.goToOption(Focus$1.Specific, id2);
        (_document$getElementB3 = document.getElementById(id2)) == null ? void 0 : _document$getElementB3.focus == null ? void 0 : _document$getElementB3.focus();
      }, {
        immediate: true
      });
    });
    watchEffect(function() {
      if (api.listboxState.value !== ListboxStates.Open)
        return;
      if (!active.value)
        return;
      nextTick(function() {
        var _document$getElementB4;
        return (_document$getElementB4 = document.getElementById(id2)) == null ? void 0 : _document$getElementB4.scrollIntoView == null ? void 0 : _document$getElementB4.scrollIntoView({
          block: "nearest"
        });
      });
    });
    function handleClick(event) {
      if (props.disabled)
        return event.preventDefault();
      api.select(props.value);
      api.closeListbox();
      nextTick(function() {
        var _dom15;
        return (_dom15 = dom(api.buttonRef)) == null ? void 0 : _dom15.focus({
          preventScroll: true
        });
      });
    }
    function handleFocus() {
      if (props.disabled)
        return api.goToOption(Focus$1.Nothing);
      api.goToOption(Focus$1.Specific, id2);
    }
    function handleMove() {
      if (props.disabled)
        return;
      if (active.value)
        return;
      api.goToOption(Focus$1.Specific, id2);
    }
    function handleLeave() {
      if (props.disabled)
        return;
      if (!active.value)
        return;
      api.goToOption(Focus$1.Nothing);
    }
    return function() {
      var disabled = props.disabled;
      var slot = {
        active: active.value,
        selected: selected.value,
        disabled
      };
      var propsWeControl = {
        id: id2,
        role: "option",
        tabIndex: disabled === true ? void 0 : -1,
        "aria-disabled": disabled === true ? true : void 0,
        "aria-selected": selected.value === true ? selected.value : void 0,
        disabled: void 0,
        onClick: handleClick,
        onFocus: handleFocus,
        onPointermove: handleMove,
        onMousemove: handleMove,
        onPointerleave: handleLeave,
        onMouseleave: handleLeave
      };
      return render$I({
        props: _extends$1({}, props, propsWeControl),
        slot,
        attrs,
        slots,
        name: "ListboxOption"
      });
    };
  }
});
function useTreeWalker(_ref) {
  var container = _ref.container, accept = _ref.accept, walk = _ref.walk, enabled = _ref.enabled;
  watchEffect(function() {
    var root = container.value;
    if (!root)
      return;
    if (enabled !== void 0 && !enabled.value)
      return;
    var acceptNode = Object.assign(function(node) {
      return accept(node);
    }, {
      acceptNode: accept
    });
    var walker = document.createTreeWalker(root, NodeFilter.SHOW_ELEMENT, acceptNode, false);
    while (walker.nextNode()) {
      walk(walker.currentNode);
    }
  });
}
var MenuStates;
(function(MenuStates2) {
  MenuStates2[MenuStates2["Open"] = 0] = "Open";
  MenuStates2[MenuStates2["Closed"] = 1] = "Closed";
})(MenuStates || (MenuStates = {}));
function nextFrame$1$1(cb) {
  requestAnimationFrame(function() {
    return requestAnimationFrame(cb);
  });
}
var MenuContext = /* @__PURE__ */ Symbol("MenuContext");
function useMenuContext(component) {
  var context = inject(MenuContext, null);
  if (context === null) {
    var err = new Error("<" + component + " /> is missing a parent <Menu /> component.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useMenuContext);
    throw err;
  }
  return context;
}
var Menu$1 = /* @__PURE__ */ defineComponent({
  name: "Menu",
  props: {
    as: {
      type: [Object, String],
      "default": "template"
    }
  },
  setup: function setup13(props, _ref) {
    var slots = _ref.slots, attrs = _ref.attrs;
    var menuState = ref(MenuStates.Closed);
    var buttonRef = ref(null);
    var itemsRef = ref(null);
    var items = ref([]);
    var searchQuery = ref("");
    var activeItemIndex = ref(null);
    var api = {
      menuState,
      buttonRef,
      itemsRef,
      items,
      searchQuery,
      activeItemIndex,
      closeMenu: function closeMenu() {
        menuState.value = MenuStates.Closed;
        activeItemIndex.value = null;
      },
      openMenu: function openMenu() {
        return menuState.value = MenuStates.Open;
      },
      goToItem: function goToItem(focus, id2) {
        var nextActiveItemIndex = calculateActiveIndex(focus === Focus$1.Specific ? {
          focus: Focus$1.Specific,
          id: id2
        } : {
          focus
        }, {
          resolveItems: function resolveItems() {
            return items.value;
          },
          resolveActiveIndex: function resolveActiveIndex() {
            return activeItemIndex.value;
          },
          resolveId: function resolveId(item) {
            return item.id;
          },
          resolveDisabled: function resolveDisabled(item) {
            return item.dataRef.disabled;
          }
        });
        if (searchQuery.value === "" && activeItemIndex.value === nextActiveItemIndex)
          return;
        searchQuery.value = "";
        activeItemIndex.value = nextActiveItemIndex;
      },
      search: function search(value) {
        searchQuery.value += value.toLowerCase();
        var match3 = items.value.findIndex(function(item) {
          return item.dataRef.textValue.startsWith(searchQuery.value) && !item.dataRef.disabled;
        });
        if (match3 === -1 || match3 === activeItemIndex.value)
          return;
        activeItemIndex.value = match3;
      },
      clearSearch: function clearSearch() {
        searchQuery.value = "";
      },
      registerItem: function registerItem(id2, dataRef) {
        items.value.push({
          id: id2,
          dataRef
        });
      },
      unregisterItem: function unregisterItem(id2) {
        var nextItems = items.value.slice();
        var currentActiveItem = activeItemIndex.value !== null ? nextItems[activeItemIndex.value] : null;
        var idx = nextItems.findIndex(function(a2) {
          return a2.id === id2;
        });
        if (idx !== -1)
          nextItems.splice(idx, 1);
        items.value = nextItems;
        activeItemIndex.value = function() {
          if (idx === activeItemIndex.value)
            return null;
          if (currentActiveItem === null)
            return null;
          return nextItems.indexOf(currentActiveItem);
        }();
      }
    };
    useWindowEvent("mousedown", function(event) {
      var _dom, _dom2, _dom3;
      var target2 = event.target;
      var active = document.activeElement;
      if (menuState.value !== MenuStates.Open)
        return;
      if ((_dom = dom(buttonRef)) == null ? void 0 : _dom.contains(target2))
        return;
      if (!((_dom2 = dom(itemsRef)) == null ? void 0 : _dom2.contains(target2)))
        api.closeMenu();
      if (active !== document.body && (active == null ? void 0 : active.contains(target2)))
        return;
      if (!event.defaultPrevented)
        (_dom3 = dom(buttonRef)) == null ? void 0 : _dom3.focus({
          preventScroll: true
        });
    });
    provide(MenuContext, api);
    useOpenClosedProvider(computed(function() {
      var _match;
      return match(menuState.value, (_match = {}, _match[MenuStates.Open] = State.Open, _match[MenuStates.Closed] = State.Closed, _match));
    }));
    return function() {
      var slot = {
        open: menuState.value === MenuStates.Open
      };
      return render$I({
        props,
        slot,
        slots,
        attrs,
        name: "Menu"
      });
    };
  }
});
var MenuButton = /* @__PURE__ */ defineComponent({
  name: "MenuButton",
  props: {
    disabled: {
      type: Boolean,
      "default": false
    },
    as: {
      type: [Object, String],
      "default": "button"
    }
  },
  render: function render$18() {
    var _dom4;
    var api = useMenuContext("MenuButton");
    var slot = {
      open: api.menuState.value === MenuStates.Open
    };
    var propsWeControl = {
      ref: "el",
      id: this.id,
      type: "button",
      "aria-haspopup": true,
      "aria-controls": (_dom4 = dom(api.itemsRef)) == null ? void 0 : _dom4.id,
      "aria-expanded": this.$props.disabled ? void 0 : api.menuState.value === MenuStates.Open,
      onKeydown: this.handleKeyDown,
      onKeyup: this.handleKeyUp,
      onClick: this.handleClick
    };
    return render$I({
      props: _extends$1({}, this.$props, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      name: "MenuButton"
    });
  },
  setup: function setup14(props) {
    var api = useMenuContext("MenuButton");
    var id2 = "headlessui-menu-button-" + useId();
    function handleKeyDown(event) {
      switch (event.key) {
        case Keys.Space:
        case Keys.Enter:
        case Keys.ArrowDown:
          event.preventDefault();
          event.stopPropagation();
          api.openMenu();
          nextTick(function() {
            var _dom5;
            (_dom5 = dom(api.itemsRef)) == null ? void 0 : _dom5.focus({
              preventScroll: true
            });
            api.goToItem(Focus$1.First);
          });
          break;
        case Keys.ArrowUp:
          event.preventDefault();
          event.stopPropagation();
          api.openMenu();
          nextTick(function() {
            var _dom6;
            (_dom6 = dom(api.itemsRef)) == null ? void 0 : _dom6.focus({
              preventScroll: true
            });
            api.goToItem(Focus$1.Last);
          });
          break;
      }
    }
    function handleKeyUp(event) {
      switch (event.key) {
        case Keys.Space:
          event.preventDefault();
          break;
      }
    }
    function handleClick(event) {
      if (props.disabled)
        return;
      if (api.menuState.value === MenuStates.Open) {
        api.closeMenu();
        nextTick(function() {
          var _dom7;
          return (_dom7 = dom(api.buttonRef)) == null ? void 0 : _dom7.focus({
            preventScroll: true
          });
        });
      } else {
        event.preventDefault();
        event.stopPropagation();
        api.openMenu();
        nextFrame$1$1(function() {
          var _dom8;
          return (_dom8 = dom(api.itemsRef)) == null ? void 0 : _dom8.focus({
            preventScroll: true
          });
        });
      }
    }
    return {
      id: id2,
      el: api.buttonRef,
      handleKeyDown,
      handleKeyUp,
      handleClick
    };
  }
});
var MenuItems = /* @__PURE__ */ defineComponent({
  name: "MenuItems",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    },
    "static": {
      type: Boolean,
      "default": false
    },
    unmount: {
      type: Boolean,
      "default": true
    }
  },
  render: function render$19() {
    var _api$items$value$api$, _dom9;
    var api = useMenuContext("MenuItems");
    var slot = {
      open: api.menuState.value === MenuStates.Open
    };
    var propsWeControl = {
      "aria-activedescendant": api.activeItemIndex.value === null ? void 0 : (_api$items$value$api$ = api.items.value[api.activeItemIndex.value]) == null ? void 0 : _api$items$value$api$.id,
      "aria-labelledby": (_dom9 = dom(api.buttonRef)) == null ? void 0 : _dom9.id,
      id: this.id,
      onKeydown: this.handleKeyDown,
      onKeyup: this.handleKeyUp,
      role: "menu",
      tabIndex: 0,
      ref: "el"
    };
    var passThroughProps = this.$props;
    return render$I({
      props: _extends$1({}, passThroughProps, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      features: Features.RenderStrategy | Features.Static,
      visible: this.visible,
      name: "MenuItems"
    });
  },
  setup: function setup15() {
    var api = useMenuContext("MenuItems");
    var id2 = "headlessui-menu-items-" + useId();
    var searchDebounce = ref(null);
    useTreeWalker({
      container: computed(function() {
        return dom(api.itemsRef);
      }),
      enabled: computed(function() {
        return api.menuState.value === MenuStates.Open;
      }),
      accept: function accept(node) {
        if (node.getAttribute("role") === "menuitem")
          return NodeFilter.FILTER_REJECT;
        if (node.hasAttribute("role"))
          return NodeFilter.FILTER_SKIP;
        return NodeFilter.FILTER_ACCEPT;
      },
      walk: function walk(node) {
        node.setAttribute("role", "none");
      }
    });
    function handleKeyDown(event) {
      if (searchDebounce.value)
        clearTimeout(searchDebounce.value);
      switch (event.key) {
        case Keys.Space:
          if (api.searchQuery.value !== "") {
            event.preventDefault();
            event.stopPropagation();
            return api.search(event.key);
          }
        case Keys.Enter:
          event.preventDefault();
          event.stopPropagation();
          if (api.activeItemIndex.value !== null) {
            var _document$getElementB;
            var _id = api.items.value[api.activeItemIndex.value].id;
            (_document$getElementB = document.getElementById(_id)) == null ? void 0 : _document$getElementB.click();
          }
          api.closeMenu();
          nextTick(function() {
            var _dom10;
            return (_dom10 = dom(api.buttonRef)) == null ? void 0 : _dom10.focus({
              preventScroll: true
            });
          });
          break;
        case Keys.ArrowDown:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(Focus$1.Next);
        case Keys.ArrowUp:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(Focus$1.Previous);
        case Keys.Home:
        case Keys.PageUp:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(Focus$1.First);
        case Keys.End:
        case Keys.PageDown:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(Focus$1.Last);
        case Keys.Escape:
          event.preventDefault();
          event.stopPropagation();
          api.closeMenu();
          nextTick(function() {
            var _dom11;
            return (_dom11 = dom(api.buttonRef)) == null ? void 0 : _dom11.focus({
              preventScroll: true
            });
          });
          break;
        case Keys.Tab:
          event.preventDefault();
          event.stopPropagation();
          break;
        default:
          if (event.key.length === 1) {
            api.search(event.key);
            searchDebounce.value = setTimeout(function() {
              return api.clearSearch();
            }, 350);
          }
          break;
      }
    }
    function handleKeyUp(event) {
      switch (event.key) {
        case Keys.Space:
          event.preventDefault();
          break;
      }
    }
    var usesOpenClosedState = useOpenClosed();
    var visible = computed(function() {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === State.Open;
      }
      return api.menuState.value === MenuStates.Open;
    });
    return {
      id: id2,
      el: api.itemsRef,
      handleKeyDown,
      handleKeyUp,
      visible
    };
  }
});
var MenuItem = /* @__PURE__ */ defineComponent({
  name: "MenuItem",
  props: {
    as: {
      type: [Object, String],
      "default": "template"
    },
    disabled: {
      type: Boolean,
      "default": false
    }
  },
  setup: function setup16(props, _ref2) {
    var slots = _ref2.slots, attrs = _ref2.attrs;
    var api = useMenuContext("MenuItem");
    var id2 = "headlessui-menu-item-" + useId();
    var active = computed(function() {
      return api.activeItemIndex.value !== null ? api.items.value[api.activeItemIndex.value].id === id2 : false;
    });
    var dataRef = ref({
      disabled: props.disabled,
      textValue: ""
    });
    onMounted(function() {
      var _document$getElementB2, _document$getElementB3;
      var textValue = (_document$getElementB2 = document.getElementById(id2)) == null ? void 0 : (_document$getElementB3 = _document$getElementB2.textContent) == null ? void 0 : _document$getElementB3.toLowerCase().trim();
      if (textValue !== void 0)
        dataRef.value.textValue = textValue;
    });
    onMounted(function() {
      return api.registerItem(id2, dataRef);
    });
    onUnmounted(function() {
      return api.unregisterItem(id2);
    });
    watchEffect(function() {
      if (api.menuState.value !== MenuStates.Open)
        return;
      if (!active.value)
        return;
      nextTick(function() {
        var _document$getElementB4;
        return (_document$getElementB4 = document.getElementById(id2)) == null ? void 0 : _document$getElementB4.scrollIntoView == null ? void 0 : _document$getElementB4.scrollIntoView({
          block: "nearest"
        });
      });
    });
    function handleClick(event) {
      if (props.disabled)
        return event.preventDefault();
      api.closeMenu();
      nextTick(function() {
        var _dom12;
        return (_dom12 = dom(api.buttonRef)) == null ? void 0 : _dom12.focus({
          preventScroll: true
        });
      });
    }
    function handleFocus() {
      if (props.disabled)
        return api.goToItem(Focus$1.Nothing);
      api.goToItem(Focus$1.Specific, id2);
    }
    function handleMove() {
      if (props.disabled)
        return;
      if (active.value)
        return;
      api.goToItem(Focus$1.Specific, id2);
    }
    function handleLeave() {
      if (props.disabled)
        return;
      if (!active.value)
        return;
      api.goToItem(Focus$1.Nothing);
    }
    return function() {
      var disabled = props.disabled;
      var slot = {
        active: active.value,
        disabled
      };
      var propsWeControl = {
        id: id2,
        role: "menuitem",
        tabIndex: disabled === true ? void 0 : -1,
        "aria-disabled": disabled === true ? true : void 0,
        onClick: handleClick,
        onFocus: handleFocus,
        onPointermove: handleMove,
        onMousemove: handleMove,
        onPointerleave: handleLeave,
        onMouseleave: handleLeave
      };
      return render$I({
        props: _extends$1({}, props, propsWeControl),
        slot,
        attrs,
        slots,
        name: "MenuItem"
      });
    };
  }
});
var PopoverStates;
(function(PopoverStates2) {
  PopoverStates2[PopoverStates2["Open"] = 0] = "Open";
  PopoverStates2[PopoverStates2["Closed"] = 1] = "Closed";
})(PopoverStates || (PopoverStates = {}));
var PopoverContext = /* @__PURE__ */ Symbol("PopoverContext");
function usePopoverContext(component) {
  var context = inject(PopoverContext, null);
  if (context === null) {
    var err = new Error("<" + component + " /> is missing a parent <" + Popover.name + " /> component.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, usePopoverContext);
    throw err;
  }
  return context;
}
var PopoverGroupContext = /* @__PURE__ */ Symbol("PopoverGroupContext");
function usePopoverGroupContext() {
  return inject(PopoverGroupContext, null);
}
var PopoverPanelContext = /* @__PURE__ */ Symbol("PopoverPanelContext");
function usePopoverPanelContext() {
  return inject(PopoverPanelContext, null);
}
var Popover = /* @__PURE__ */ defineComponent({
  name: "Popover",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    }
  },
  setup: function setup17(props, _ref) {
    var slots = _ref.slots, attrs = _ref.attrs;
    var buttonId = "headlessui-popover-button-" + useId();
    var panelId = "headlessui-popover-panel-" + useId();
    var popoverState = ref(PopoverStates.Closed);
    var button = ref(null);
    var panel = ref(null);
    var api = {
      popoverState,
      buttonId,
      panelId,
      panel,
      button,
      togglePopover: function togglePopover() {
        var _match;
        popoverState.value = match(popoverState.value, (_match = {}, _match[PopoverStates.Open] = PopoverStates.Closed, _match[PopoverStates.Closed] = PopoverStates.Open, _match));
      },
      closePopover: function closePopover() {
        if (popoverState.value === PopoverStates.Closed)
          return;
        popoverState.value = PopoverStates.Closed;
      },
      close: function close(focusableElement) {
        api.closePopover();
        var restoreElement = function() {
          if (!focusableElement)
            return dom(api.button);
          if (focusableElement instanceof HTMLElement)
            return focusableElement;
          if (focusableElement.value instanceof HTMLElement)
            return dom(focusableElement);
          return dom(api.button);
        }();
        restoreElement == null ? void 0 : restoreElement.focus();
      }
    };
    provide(PopoverContext, api);
    useOpenClosedProvider(computed(function() {
      var _match2;
      return match(popoverState.value, (_match2 = {}, _match2[PopoverStates.Open] = State.Open, _match2[PopoverStates.Closed] = State.Closed, _match2));
    }));
    var registerBag = {
      buttonId,
      panelId,
      close: function close() {
        api.closePopover();
      }
    };
    var groupContext = usePopoverGroupContext();
    var registerPopover = groupContext == null ? void 0 : groupContext.registerPopover;
    function isFocusWithinPopoverGroup() {
      var _groupContext$isFocus, _dom, _dom2;
      return (_groupContext$isFocus = groupContext == null ? void 0 : groupContext.isFocusWithinPopoverGroup()) != null ? _groupContext$isFocus : ((_dom = dom(button)) == null ? void 0 : _dom.contains(document.activeElement)) || ((_dom2 = dom(panel)) == null ? void 0 : _dom2.contains(document.activeElement));
    }
    watchEffect(function() {
      return registerPopover == null ? void 0 : registerPopover(registerBag);
    });
    useWindowEvent("focus", function() {
      if (popoverState.value !== PopoverStates.Open)
        return;
      if (isFocusWithinPopoverGroup())
        return;
      if (!button)
        return;
      if (!panel)
        return;
      api.closePopover();
    }, true);
    useWindowEvent("mousedown", function(event) {
      var _dom3, _dom4;
      var target2 = event.target;
      if (popoverState.value !== PopoverStates.Open)
        return;
      if ((_dom3 = dom(button)) == null ? void 0 : _dom3.contains(target2))
        return;
      if ((_dom4 = dom(panel)) == null ? void 0 : _dom4.contains(target2))
        return;
      api.closePopover();
      if (!isFocusableElement(target2, FocusableMode.Loose)) {
        var _dom5;
        event.preventDefault();
        (_dom5 = dom(button)) == null ? void 0 : _dom5.focus();
      }
    });
    return function() {
      var slot = {
        open: popoverState.value === PopoverStates.Open,
        close: api.close
      };
      return render$I({
        props,
        slot,
        slots,
        attrs,
        name: "Popover"
      });
    };
  }
});
var PopoverButton = /* @__PURE__ */ defineComponent({
  name: "PopoverButton",
  props: {
    as: {
      type: [Object, String],
      "default": "button"
    },
    disabled: {
      type: [Boolean],
      "default": false
    }
  },
  render: function render$110() {
    var api = usePopoverContext("PopoverButton");
    var slot = {
      open: api.popoverState.value === PopoverStates.Open
    };
    var propsWeControl = this.isWithinPanel ? {
      type: "button",
      onKeydown: this.handleKeyDown,
      onClick: this.handleClick
    } : {
      ref: "el",
      id: api.buttonId,
      type: "button",
      "aria-expanded": this.$props.disabled ? void 0 : api.popoverState.value === PopoverStates.Open,
      "aria-controls": dom(api.panel) ? api.panelId : void 0,
      disabled: this.$props.disabled ? true : void 0,
      onKeydown: this.handleKeyDown,
      onKeyup: this.handleKeyUp,
      onClick: this.handleClick
    };
    return render$I({
      props: _extends$1({}, this.$props, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      name: "PopoverButton"
    });
  },
  setup: function setup18(props) {
    var api = usePopoverContext("PopoverButton");
    var groupContext = usePopoverGroupContext();
    var closeOthers = groupContext == null ? void 0 : groupContext.closeOthers;
    var panelContext = usePopoverPanelContext();
    var isWithinPanel = panelContext === null ? false : panelContext === api.panelId;
    var activeElementRef = ref(null);
    var previousActiveElementRef = ref(typeof window === "undefined" ? null : document.activeElement);
    useWindowEvent("focus", function() {
      previousActiveElementRef.value = activeElementRef.value;
      activeElementRef.value = document.activeElement;
    }, true);
    return {
      isWithinPanel,
      el: isWithinPanel ? null : api.button,
      handleKeyDown: function handleKeyDown(event) {
        var _dom6, _dom7;
        if (isWithinPanel) {
          if (api.popoverState.value === PopoverStates.Closed)
            return;
          switch (event.key) {
            case Keys.Space:
            case Keys.Enter:
              event.preventDefault();
              event.stopPropagation();
              api.closePopover();
              (_dom6 = dom(api.button)) == null ? void 0 : _dom6.focus();
              break;
          }
        } else {
          switch (event.key) {
            case Keys.Space:
            case Keys.Enter:
              event.preventDefault();
              event.stopPropagation();
              if (api.popoverState.value === PopoverStates.Closed)
                closeOthers == null ? void 0 : closeOthers(api.buttonId);
              api.togglePopover();
              break;
            case Keys.Escape:
              if (api.popoverState.value !== PopoverStates.Open)
                return closeOthers == null ? void 0 : closeOthers(api.buttonId);
              if (!dom(api.button))
                return;
              if (!((_dom7 = dom(api.button)) == null ? void 0 : _dom7.contains(document.activeElement)))
                return;
              api.closePopover();
              break;
            case Keys.Tab:
              if (api.popoverState.value !== PopoverStates.Open)
                return;
              if (!api.panel)
                return;
              if (!api.button)
                return;
              if (event.shiftKey) {
                var _dom8, _dom9;
                if (!previousActiveElementRef.value)
                  return;
                if ((_dom8 = dom(api.button)) == null ? void 0 : _dom8.contains(previousActiveElementRef.value))
                  return;
                if ((_dom9 = dom(api.panel)) == null ? void 0 : _dom9.contains(previousActiveElementRef.value))
                  return;
                var focusableElements = getFocusableElements();
                var previousIdx = focusableElements.indexOf(previousActiveElementRef.value);
                var buttonIdx = focusableElements.indexOf(dom(api.button));
                if (buttonIdx > previousIdx)
                  return;
                event.preventDefault();
                event.stopPropagation();
                focusIn(dom(api.panel), Focus.Last);
              } else {
                event.preventDefault();
                event.stopPropagation();
                focusIn(dom(api.panel), Focus.First);
              }
              break;
          }
        }
      },
      handleKeyUp: function handleKeyUp(event) {
        var _dom10, _dom11;
        if (isWithinPanel)
          return;
        if (event.key === Keys.Space) {
          event.preventDefault();
        }
        if (api.popoverState.value !== PopoverStates.Open)
          return;
        if (!api.panel)
          return;
        if (!api.button)
          return;
        switch (event.key) {
          case Keys.Tab:
            if (!previousActiveElementRef.value)
              return;
            if ((_dom10 = dom(api.button)) == null ? void 0 : _dom10.contains(previousActiveElementRef.value))
              return;
            if ((_dom11 = dom(api.panel)) == null ? void 0 : _dom11.contains(previousActiveElementRef.value))
              return;
            var focusableElements = getFocusableElements();
            var previousIdx = focusableElements.indexOf(previousActiveElementRef.value);
            var buttonIdx = focusableElements.indexOf(dom(api.button));
            if (buttonIdx > previousIdx)
              return;
            event.preventDefault();
            event.stopPropagation();
            focusIn(dom(api.panel), Focus.Last);
            break;
        }
      },
      handleClick: function handleClick() {
        if (props.disabled)
          return;
        if (isWithinPanel) {
          var _dom12;
          api.closePopover();
          (_dom12 = dom(api.button)) == null ? void 0 : _dom12.focus();
        } else {
          var _dom13;
          if (api.popoverState.value === PopoverStates.Closed)
            closeOthers == null ? void 0 : closeOthers(api.buttonId);
          (_dom13 = dom(api.button)) == null ? void 0 : _dom13.focus();
          api.togglePopover();
        }
      },
      handleFocus: function handleFocus() {
      }
    };
  }
});
var PopoverPanel = /* @__PURE__ */ defineComponent({
  name: "PopoverPanel",
  props: {
    as: {
      type: [Object, String],
      "default": "div"
    },
    "static": {
      type: Boolean,
      "default": false
    },
    unmount: {
      type: Boolean,
      "default": true
    },
    focus: {
      type: Boolean,
      "default": false
    }
  },
  render: function render$111() {
    var api = usePopoverContext("PopoverPanel");
    var slot = {
      open: api.popoverState.value === PopoverStates.Open,
      close: api.close
    };
    var propsWeControl = {
      ref: "el",
      id: this.id,
      onKeydown: this.handleKeyDown
    };
    return render$I({
      props: _extends$1({}, this.$props, propsWeControl),
      slot,
      attrs: this.$attrs,
      slots: this.$slots,
      features: Features.RenderStrategy | Features.Static,
      visible: this.visible,
      name: "PopoverPanel"
    });
  },
  setup: function setup19(props) {
    var focus = props.focus;
    var api = usePopoverContext("PopoverPanel");
    provide(PopoverPanelContext, api.panelId);
    onUnmounted(function() {
      api.panel.value = null;
    });
    watchEffect(function() {
      var _dom14;
      if (!focus)
        return;
      if (api.popoverState.value !== PopoverStates.Open)
        return;
      if (!api.panel)
        return;
      var activeElement = document.activeElement;
      if ((_dom14 = dom(api.panel)) == null ? void 0 : _dom14.contains(activeElement))
        return;
      focusIn(dom(api.panel), Focus.First);
    });
    useWindowEvent("keydown", function(event) {
      var _dom15;
      if (api.popoverState.value !== PopoverStates.Open)
        return;
      if (!dom(api.panel))
        return;
      if (event.key !== Keys.Tab)
        return;
      if (!document.activeElement)
        return;
      if (!((_dom15 = dom(api.panel)) == null ? void 0 : _dom15.contains(document.activeElement)))
        return;
      event.preventDefault();
      var result = focusIn(dom(api.panel), event.shiftKey ? Focus.Previous : Focus.Next);
      if (result === FocusResult.Underflow) {
        var _dom16;
        return (_dom16 = dom(api.button)) == null ? void 0 : _dom16.focus();
      } else if (result === FocusResult.Overflow) {
        if (!dom(api.button))
          return;
        var elements = getFocusableElements();
        var buttonIdx = elements.indexOf(dom(api.button));
        var nextElements = elements.splice(buttonIdx + 1).filter(function(element) {
          var _dom17;
          return !((_dom17 = dom(api.panel)) == null ? void 0 : _dom17.contains(element));
        });
        if (focusIn(nextElements, Focus.First) === FocusResult.Error) {
          focusIn(document.body, Focus.First);
        }
      }
    });
    useWindowEvent("focus", function() {
      var _dom18;
      if (!focus)
        return;
      if (api.popoverState.value !== PopoverStates.Open)
        return;
      if (!dom(api.panel))
        return;
      if ((_dom18 = dom(api.panel)) == null ? void 0 : _dom18.contains(document.activeElement))
        return;
      api.closePopover();
    }, true);
    var usesOpenClosedState = useOpenClosed();
    var visible = computed(function() {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === State.Open;
      }
      return api.popoverState.value === PopoverStates.Open;
    });
    return {
      id: api.panelId,
      el: api.panel,
      handleKeyDown: function handleKeyDown(event) {
        var _dom19, _dom20;
        switch (event.key) {
          case Keys.Escape:
            if (api.popoverState.value !== PopoverStates.Open)
              return;
            if (!dom(api.panel))
              return;
            if (!((_dom19 = dom(api.panel)) == null ? void 0 : _dom19.contains(document.activeElement)))
              return;
            event.preventDefault();
            api.closePopover();
            (_dom20 = dom(api.button)) == null ? void 0 : _dom20.focus();
            break;
        }
      },
      visible
    };
  }
});
var OptionState;
(function(OptionState2) {
  OptionState2[OptionState2["Empty"] = 1] = "Empty";
  OptionState2[OptionState2["Active"] = 2] = "Active";
})(OptionState || (OptionState = {}));
var Reason;
(function(Reason2) {
  Reason2["Finished"] = "finished";
  Reason2["Cancelled"] = "cancelled";
})(Reason || (Reason = {}));
var TreeStates;
(function(TreeStates2) {
  TreeStates2["Visible"] = "visible";
  TreeStates2["Hidden"] = "hidden";
})(TreeStates || (TreeStates = {}));
Features.RenderStrategy;
const _hoisted_1$1h = { class: "bg-white rounded-t flex border-b-1px border-b-gray-100 min-h-56px px-24px top-0 z-1 sticky items-center justify-between" };
const _hoisted_2$1a = /* @__PURE__ */ createBaseVNode("span", { class: "border-t border-t-gray-100 h-6px mx-8px w-32px inline-block" }, null, -1);
const _hoisted_3$11 = { class: "group-hocus:underline" };
const _hoisted_4$E = ["aria-label"];
const _sfc_main$U = /* @__PURE__ */ defineComponent({
  props: {
    helpLink: null,
    helpText: null,
    noHelp: { type: Boolean, default: false }
  },
  emits: ["close"],
  setup(__props) {
    const { t: t2 } = useI18n();
    return (_ctx, _cache) => {
      const _component_i_cy_circle_bg_question_mark_x16 = __unplugin_components_0$b;
      const _component_i_cy_delete_x12 = __unplugin_components_0$a;
      return openBlock(), createElementBlock("div", _hoisted_1$1h, [
        createBaseVNode("div", null, [
          createVNode(unref(DialogTitle), { class: "text-gray-900 text-18px inline-block" }, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            _: 3
          }),
          !__props.noHelp ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            _hoisted_2$1a,
            createVNode(_sfc_main$$, {
              href: __props.helpLink,
              class: "outline-transparent text-indigo-500 text-16px group"
            }, {
              default: withCtx(() => [
                createBaseVNode("span", _hoisted_3$11, toDisplayString$1(__props.helpText), 1)
              ]),
              _: 1
            }, 8, ["href"]),
            createVNode(_component_i_cy_circle_bg_question_mark_x16, { class: "ml-8px -top-2px relative inline-block icon-dark-indigo-500 icon-light-indigo-100" })
          ], 64)) : createCommentVNode("", true)
        ]),
        createBaseVNode("button", {
          "aria-label": unref(t2)(`actions.close`),
          class: "border-transparent rounded-full outline-none border-1 group",
          onClick: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("close"))
        }, [
          createVNode(_component_i_cy_delete_x12, { class: "h-12px w-12px icon-dark-gray-400 group-hocus:icon-dark-indigo-400 children:transition-all" })
        ], 8, _hoisted_4$E)
      ]);
    };
  }
});
function getBasePlacement$1(placement) {
  return placement.split("-")[0];
}
function getAlignment(placement) {
  return placement.split("-")[1];
}
function getMainAxisFromPlacement$1(placement) {
  return ["top", "bottom"].includes(getBasePlacement$1(placement)) ? "x" : "y";
}
function getLengthFromAxis(axis) {
  return axis === "y" ? "height" : "width";
}
function computeCoordsFromPlacement(_ref) {
  let {
    reference: reference3,
    floating,
    placement
  } = _ref;
  const commonX = reference3.x + reference3.width / 2 - floating.width / 2;
  const commonY = reference3.y + reference3.height / 2 - floating.height / 2;
  let coords;
  switch (getBasePlacement$1(placement)) {
    case "top":
      coords = {
        x: commonX,
        y: reference3.y - floating.height
      };
      break;
    case "bottom":
      coords = {
        x: commonX,
        y: reference3.y + reference3.height
      };
      break;
    case "right":
      coords = {
        x: reference3.x + reference3.width,
        y: commonY
      };
      break;
    case "left":
      coords = {
        x: reference3.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference3.x,
        y: reference3.y
      };
  }
  const mainAxis = getMainAxisFromPlacement$1(placement);
  const length2 = getLengthFromAxis(mainAxis);
  switch (getAlignment(placement)) {
    case "start":
      coords[mainAxis] = coords[mainAxis] - (reference3[length2] / 2 - floating[length2] / 2);
      break;
    case "end":
      coords[mainAxis] = coords[mainAxis] + (reference3[length2] / 2 - floating[length2] / 2);
      break;
  }
  return coords;
}
const computePosition$1 = async (reference3, floating, config2) => {
  const {
    placement = "bottom",
    strategy = "absolute",
    middleware = [],
    platform: platform2
  } = config2;
  let rects = await platform2.getElementRects({
    reference: reference3,
    floating,
    strategy
  });
  let {
    x: x2,
    y: y2
  } = computeCoordsFromPlacement({
    ...rects,
    placement
  });
  let statefulPlacement = placement;
  let middlewareData = {};
  for (let i = 0; i < middleware.length; i++) {
    const {
      name: name2,
      fn: fn2
    } = middleware[i];
    const {
      x: nextX,
      y: nextY,
      data,
      reset: reset2
    } = await fn2({
      x: x2,
      y: y2,
      initialPlacement: placement,
      placement: statefulPlacement,
      strategy,
      middlewareData,
      rects,
      platform: platform2,
      elements: {
        reference: reference3,
        floating
      }
    });
    x2 = nextX != null ? nextX : x2;
    y2 = nextY != null ? nextY : y2;
    middlewareData = {
      ...middlewareData,
      [name2]: data != null ? data : {}
    };
    if (reset2) {
      if (typeof reset2 === "object") {
        if (reset2.placement) {
          statefulPlacement = reset2.placement;
        }
        if (reset2.rects) {
          rects = reset2.rects === true ? await platform2.getElementRects({
            reference: reference3,
            floating,
            strategy
          }) : reset2.rects;
        }
        ({
          x: x2,
          y: y2
        } = computeCoordsFromPlacement({
          ...rects,
          placement: statefulPlacement
        }));
      }
      i = -1;
      continue;
    }
  }
  return {
    x: x2,
    y: y2,
    placement: statefulPlacement,
    strategy,
    middlewareData
  };
};
function expandPaddingObject(padding) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...padding
  };
}
function getSideObjectFromPadding(padding) {
  return typeof padding !== "number" ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}
function rectToClientRect$1(rect2) {
  return {
    ...rect2,
    top: rect2.y,
    left: rect2.x,
    right: rect2.x + rect2.width,
    bottom: rect2.y + rect2.height
  };
}
async function detectOverflow$1(middlewareArguments, options2) {
  if (options2 === void 0) {
    options2 = {};
  }
  const {
    x: x2,
    y: y2,
    platform: platform2,
    rects,
    elements,
    strategy
  } = middlewareArguments;
  const {
    boundary = "clippingParents",
    rootBoundary = "viewport",
    elementContext = "floating",
    altBoundary = false,
    padding = 0
  } = options2;
  const paddingObject = getSideObjectFromPadding(padding);
  const altContext = elementContext === "floating" ? "reference" : "floating";
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = await platform2.getClippingClientRect({
    element: await platform2.isElement(element) ? element : element.contextElement || await platform2.getDocumentElement({
      element: elements.floating
    }),
    boundary,
    rootBoundary
  });
  const elementClientRect = rectToClientRect$1(await platform2.convertOffsetParentRelativeRectToViewportRelativeRect({
    rect: elementContext === "floating" ? {
      ...rects.floating,
      x: x2,
      y: y2
    } : rects.reference,
    offsetParent: await platform2.getOffsetParent({
      element: elements.floating
    }),
    strategy
  }));
  return {
    top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
    bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
    left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
    right: elementClientRect.right - clippingClientRect.right + paddingObject.right
  };
}
const min$2 = Math.min;
const max$2 = Math.max;
function within$1(min$12, value, max$12) {
  return max$2(min$12, min$2(value, max$12));
}
const arrow$2 = (options2) => ({
  name: "arrow",
  options: options2,
  async fn(middlewareArguments) {
    const {
      element,
      padding = 0
    } = options2 != null ? options2 : {};
    const {
      x: x2,
      y: y2,
      placement,
      rects,
      platform: platform2
    } = middlewareArguments;
    if (element == null) {
      return {};
    }
    const paddingObject = getSideObjectFromPadding(padding);
    const coords = {
      x: x2,
      y: y2
    };
    const basePlacement = getBasePlacement$1(placement);
    const axis = getMainAxisFromPlacement$1(basePlacement);
    const length2 = getLengthFromAxis(axis);
    const arrowDimensions = await platform2.getDimensions({
      element
    });
    const minProp = axis === "y" ? "top" : "left";
    const maxProp = axis === "y" ? "bottom" : "right";
    const endDiff = rects.reference[length2] + rects.reference[axis] - coords[axis] - rects.floating[length2];
    const startDiff = coords[axis] - rects.reference[axis];
    const arrowOffsetParent = await platform2.getOffsetParent({
      element
    });
    const clientSize = arrowOffsetParent ? axis === "y" ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
    const centerToReference = endDiff / 2 - startDiff / 2;
    const min2 = paddingObject[minProp];
    const max2 = clientSize - arrowDimensions[length2] - paddingObject[maxProp];
    const center = clientSize / 2 - arrowDimensions[length2] / 2 + centerToReference;
    const offset2 = within$1(min2, center, max2);
    return {
      data: {
        [axis]: offset2,
        centerOffset: center - offset2
      }
    };
  }
});
const hash$1$1 = {
  left: "right",
  right: "left",
  bottom: "top",
  top: "bottom"
};
function getOppositePlacement$1(placement) {
  return placement.replace(/left|right|bottom|top/g, (matched) => hash$1$1[matched]);
}
function getAlignmentSides(placement, rects) {
  const isStart = getAlignment(placement) === "start";
  const mainAxis = getMainAxisFromPlacement$1(placement);
  const length2 = getLengthFromAxis(mainAxis);
  let mainAlignmentSide = mainAxis === "x" ? isStart ? "right" : "left" : isStart ? "bottom" : "top";
  if (rects.reference[length2] > rects.floating[length2]) {
    mainAlignmentSide = getOppositePlacement$1(mainAlignmentSide);
  }
  return {
    main: mainAlignmentSide,
    cross: getOppositePlacement$1(mainAlignmentSide)
  };
}
const hash$2 = {
  start: "end",
  end: "start"
};
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, (matched) => hash$2[matched]);
}
const basePlacements$1 = ["top", "right", "bottom", "left"];
const allPlacements = /* @__PURE__ */ basePlacements$1.reduce((acc, basePlacement) => acc.concat(basePlacement, basePlacement + "-start", basePlacement + "-end"), []);
function getPlacementList(alignment, autoAlignment, allowedPlacements) {
  const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter((placement) => getAlignment(placement) === alignment), ...allowedPlacements.filter((placement) => getAlignment(placement) !== alignment)] : allowedPlacements.filter((placement) => getBasePlacement$1(placement) === placement);
  return allowedPlacementsSortedByAlignment.filter((placement) => {
    if (alignment) {
      return getAlignment(placement) === alignment || (autoAlignment ? getOppositeAlignmentPlacement(placement) !== placement : false);
    }
    return true;
  });
}
const autoPlacement = function(options2) {
  if (options2 === void 0) {
    options2 = {};
  }
  return {
    name: "autoPlacement",
    options: options2,
    async fn(middlewareArguments) {
      var _middlewareData$autoP, _middlewareData$autoP2, _middlewareData$autoP3, _middlewareData$autoP4, _middlewareData$autoP5, _placementsSortedByLe;
      const {
        x: x2,
        y: y2,
        rects,
        middlewareData,
        placement
      } = middlewareArguments;
      const {
        alignment = null,
        allowedPlacements = allPlacements,
        autoAlignment = true,
        ...detectOverflowOptions
      } = options2;
      if ((_middlewareData$autoP = middlewareData.autoPlacement) != null && _middlewareData$autoP.skip) {
        return {};
      }
      const placements2 = getPlacementList(alignment, autoAlignment, allowedPlacements);
      const overflow = await detectOverflow$1(middlewareArguments, detectOverflowOptions);
      const currentIndex = (_middlewareData$autoP2 = (_middlewareData$autoP3 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP3.index) != null ? _middlewareData$autoP2 : 0;
      const currentPlacement = placements2[currentIndex];
      const {
        main: main2,
        cross: cross2
      } = getAlignmentSides(currentPlacement, rects);
      if (placement !== currentPlacement) {
        return {
          x: x2,
          y: y2,
          reset: {
            placement: placements2[0]
          }
        };
      }
      const currentOverflows = [overflow[getBasePlacement$1(currentPlacement)], overflow[main2], overflow[cross2]];
      const allOverflows = [...(_middlewareData$autoP4 = (_middlewareData$autoP5 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP5.overflows) != null ? _middlewareData$autoP4 : [], {
        placement: currentPlacement,
        overflows: currentOverflows
      }];
      const nextPlacement = placements2[currentIndex + 1];
      if (nextPlacement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: nextPlacement
          }
        };
      }
      const placementsSortedByLeastOverflow = allOverflows.slice().sort((a2, b2) => a2.overflows[0] - b2.overflows[0]);
      const placementThatFitsOnAllSides = (_placementsSortedByLe = placementsSortedByLeastOverflow.find((_ref) => {
        let {
          overflows
        } = _ref;
        return overflows.every((overflow2) => overflow2 <= 0);
      })) == null ? void 0 : _placementsSortedByLe.placement;
      return {
        data: {
          skip: true
        },
        reset: {
          placement: placementThatFitsOnAllSides != null ? placementThatFitsOnAllSides : placementsSortedByLeastOverflow[0].placement
        }
      };
    }
  };
};
function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement$1(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}
const flip$2 = function(options2) {
  if (options2 === void 0) {
    options2 = {};
  }
  return {
    name: "flip",
    options: options2,
    async fn(middlewareArguments) {
      var _middlewareData$flip, _middlewareData$flip2;
      const {
        placement,
        middlewareData,
        rects,
        initialPlacement
      } = middlewareArguments;
      if ((_middlewareData$flip = middlewareData.flip) != null && _middlewareData$flip.skip) {
        return {};
      }
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true,
        fallbackPlacements: specifiedFallbackPlacements,
        fallbackStrategy = "bestFit",
        flipAlignment = true,
        ...detectOverflowOptions
      } = options2;
      const basePlacement = getBasePlacement$1(placement);
      const isBasePlacement = basePlacement === initialPlacement;
      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [getOppositePlacement$1(initialPlacement)] : getExpandedPlacements(initialPlacement));
      const placements2 = [initialPlacement, ...fallbackPlacements];
      const overflow = await detectOverflow$1(middlewareArguments, detectOverflowOptions);
      const overflows = [];
      let overflowsData = ((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.overflows) || [];
      if (checkMainAxis) {
        overflows.push(overflow[basePlacement]);
      }
      if (checkCrossAxis) {
        const {
          main: main2,
          cross: cross2
        } = getAlignmentSides(placement, rects);
        overflows.push(overflow[main2], overflow[cross2]);
      }
      overflowsData = [...overflowsData, {
        placement,
        overflows
      }];
      if (!overflows.every((side) => side <= 0)) {
        var _middlewareData$flip$, _middlewareData$flip3;
        const nextIndex = ((_middlewareData$flip$ = (_middlewareData$flip3 = middlewareData.flip) == null ? void 0 : _middlewareData$flip3.index) != null ? _middlewareData$flip$ : 0) + 1;
        const nextPlacement = placements2[nextIndex];
        if (nextPlacement) {
          return {
            data: {
              index: nextIndex,
              overflows: overflowsData
            },
            reset: {
              placement: nextPlacement
            }
          };
        }
        let resetPlacement = "bottom";
        switch (fallbackStrategy) {
          case "bestFit": {
            var _overflowsData$slice$;
            const placement2 = (_overflowsData$slice$ = overflowsData.slice().sort((a2, b2) => a2.overflows.filter((overflow2) => overflow2 > 0).reduce((acc, overflow2) => acc + overflow2, 0) - b2.overflows.filter((overflow2) => overflow2 > 0).reduce((acc, overflow2) => acc + overflow2, 0))[0]) == null ? void 0 : _overflowsData$slice$.placement;
            if (placement2) {
              resetPlacement = placement2;
            }
            break;
          }
          case "initialPlacement":
            resetPlacement = initialPlacement;
            break;
        }
        return {
          data: {
            skip: true
          },
          reset: {
            placement: resetPlacement
          }
        };
      }
      return {};
    }
  };
};
function convertValueToCoords(_ref) {
  let {
    placement,
    rects,
    value
  } = _ref;
  const basePlacement = getBasePlacement$1(placement);
  const multiplier = ["left", "top"].includes(basePlacement) ? -1 : 1;
  const rawValue = typeof value === "function" ? value({
    ...rects,
    placement
  }) : value;
  const {
    mainAxis,
    crossAxis
  } = typeof rawValue === "number" ? {
    mainAxis: rawValue,
    crossAxis: 0
  } : {
    mainAxis: 0,
    crossAxis: 0,
    ...rawValue
  };
  return getMainAxisFromPlacement$1(basePlacement) === "x" ? {
    x: crossAxis,
    y: mainAxis * multiplier
  } : {
    x: mainAxis * multiplier,
    y: crossAxis
  };
}
const offset$2 = function(value) {
  if (value === void 0) {
    value = 0;
  }
  return {
    name: "offset",
    options: value,
    fn(middlewareArguments) {
      const {
        x: x2,
        y: y2,
        placement,
        rects
      } = middlewareArguments;
      const diffCoords = convertValueToCoords({
        placement,
        rects,
        value
      });
      return {
        x: x2 + diffCoords.x,
        y: y2 + diffCoords.y,
        data: diffCoords
      };
    }
  };
};
function getCrossAxis(axis) {
  return axis === "x" ? "y" : "x";
}
const shift = function(options2) {
  if (options2 === void 0) {
    options2 = {};
  }
  return {
    name: "shift",
    options: options2,
    async fn(middlewareArguments) {
      const {
        x: x2,
        y: y2,
        placement
      } = middlewareArguments;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = false,
        limiter = {
          fn: (_ref) => {
            let {
              x: x3,
              y: y3
            } = _ref;
            return {
              x: x3,
              y: y3
            };
          }
        },
        ...detectOverflowOptions
      } = options2;
      const coords = {
        x: x2,
        y: y2
      };
      const overflow = await detectOverflow$1(middlewareArguments, detectOverflowOptions);
      const mainAxis = getMainAxisFromPlacement$1(getBasePlacement$1(placement));
      const crossAxis = getCrossAxis(mainAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      if (checkMainAxis) {
        const minSide = mainAxis === "y" ? "top" : "left";
        const maxSide = mainAxis === "y" ? "bottom" : "right";
        const min2 = mainAxisCoord + overflow[minSide];
        const max2 = mainAxisCoord - overflow[maxSide];
        mainAxisCoord = within$1(min2, mainAxisCoord, max2);
      }
      if (checkCrossAxis) {
        const minSide = crossAxis === "y" ? "top" : "left";
        const maxSide = crossAxis === "y" ? "bottom" : "right";
        const min2 = crossAxisCoord + overflow[minSide];
        const max2 = crossAxisCoord - overflow[maxSide];
        crossAxisCoord = within$1(min2, crossAxisCoord, max2);
      }
      const limitedCoords = limiter.fn({
        ...middlewareArguments,
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      });
      return {
        ...limitedCoords,
        data: {
          x: limitedCoords.x - x2,
          y: limitedCoords.y - y2
        }
      };
    }
  };
};
const size = function(options2) {
  if (options2 === void 0) {
    options2 = {};
  }
  return {
    name: "size",
    options: options2,
    async fn(middlewareArguments) {
      var _middlewareData$size;
      const {
        placement,
        rects,
        middlewareData
      } = middlewareArguments;
      const {
        apply: apply2,
        ...detectOverflowOptions
      } = options2;
      if ((_middlewareData$size = middlewareData.size) != null && _middlewareData$size.skip) {
        return {};
      }
      const overflow = await detectOverflow$1(middlewareArguments, detectOverflowOptions);
      const basePlacement = getBasePlacement$1(placement);
      const isEnd = getAlignment(placement) === "end";
      let heightSide;
      let widthSide;
      if (basePlacement === "top" || basePlacement === "bottom") {
        heightSide = basePlacement;
        widthSide = isEnd ? "left" : "right";
      } else {
        widthSide = basePlacement;
        heightSide = isEnd ? "top" : "bottom";
      }
      const xMin = max$2(overflow.left, 0);
      const xMax = max$2(overflow.right, 0);
      const yMin = max$2(overflow.top, 0);
      const yMax = max$2(overflow.bottom, 0);
      const dimensions = {
        height: rects.floating.height - (["left", "right"].includes(placement) ? 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : max$2(overflow.top, overflow.bottom)) : overflow[heightSide]),
        width: rects.floating.width - (["top", "bottom"].includes(placement) ? 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : max$2(overflow.left, overflow.right)) : overflow[widthSide])
      };
      apply2 == null ? void 0 : apply2({
        ...dimensions,
        ...rects
      });
      return {
        data: {
          skip: true
        },
        reset: {
          rects: true
        }
      };
    }
  };
};
function isWindow(value) {
  return (value == null ? void 0 : value.toString()) === "[object Window]";
}
function getWindow$1(node) {
  if (node == null) {
    return window;
  }
  if (!isWindow(node)) {
    const ownerDocument = node.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView || window : window;
  }
  return node;
}
function getComputedStyle$1$1(element) {
  return getWindow$1(element).getComputedStyle(element);
}
function getNodeName$1(node) {
  return isWindow(node) ? "" : node ? (node.nodeName || "").toLowerCase() : "";
}
function isHTMLElement$1(value) {
  return value instanceof getWindow$1(value).HTMLElement;
}
function isElement$1(value) {
  return value instanceof getWindow$1(value).Element;
}
function isNode(value) {
  return value instanceof getWindow$1(value).Node;
}
function isShadowRoot$1(node) {
  const OwnElement = getWindow$1(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}
function isScrollParent$1(element) {
  const {
    overflow,
    overflowX,
    overflowY
  } = getComputedStyle$1$1(element);
  return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}
function isTableElement$1(element) {
  return ["table", "td", "th"].includes(getNodeName$1(element));
}
function isContainingBlock(element) {
  const isFirefox = navigator.userAgent.toLowerCase().includes("firefox");
  const css = getComputedStyle$1$1(element);
  return css.transform !== "none" || css.perspective !== "none" || css.contain === "paint" || ["transform", "perspective"].includes(css.willChange) || isFirefox && css.willChange === "filter" || isFirefox && (css.filter ? css.filter !== "none" : false);
}
const min$1 = Math.min;
const max$1 = Math.max;
const round$1 = Math.round;
function getBoundingClientRect$1(element, includeScale) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  const clientRect = element.getBoundingClientRect();
  let scaleX = 1;
  let scaleY = 1;
  if (includeScale && isHTMLElement$1(element)) {
    scaleX = element.offsetWidth > 0 ? round$1(clientRect.width) / element.offsetWidth || 1 : 1;
    scaleY = element.offsetHeight > 0 ? round$1(clientRect.height) / element.offsetHeight || 1 : 1;
  }
  return {
    width: clientRect.width / scaleX,
    height: clientRect.height / scaleY,
    top: clientRect.top / scaleY,
    right: clientRect.right / scaleX,
    bottom: clientRect.bottom / scaleY,
    left: clientRect.left / scaleX,
    x: clientRect.left / scaleX,
    y: clientRect.top / scaleY
  };
}
function getDocumentElement$1(node) {
  return ((isNode(node) ? node.ownerDocument : node.document) || window.document).documentElement;
}
function getNodeScroll$1(element) {
  if (isWindow(element)) {
    return {
      scrollLeft: element.pageXOffset,
      scrollTop: element.pageYOffset
    };
  }
  return {
    scrollLeft: element.scrollLeft,
    scrollTop: element.scrollTop
  };
}
function getWindowScrollBarX$1(element) {
  return getBoundingClientRect$1(getDocumentElement$1(element)).left + getNodeScroll$1(element).scrollLeft;
}
function isScaled(element) {
  const rect2 = getBoundingClientRect$1(element);
  return round$1(rect2.width) !== element.offsetWidth || round$1(rect2.height) !== element.offsetHeight;
}
function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = isHTMLElement$1(offsetParent);
  const documentElement = getDocumentElement$1(offsetParent);
  const rect2 = getBoundingClientRect$1(element, isOffsetParentAnElement && isScaled(offsetParent));
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = {
    x: 0,
    y: 0
  };
  if (isOffsetParentAnElement || !isOffsetParentAnElement && strategy !== "fixed") {
    if (getNodeName$1(offsetParent) !== "body" || isScrollParent$1(documentElement)) {
      scroll = getNodeScroll$1(offsetParent);
    }
    if (isHTMLElement$1(offsetParent)) {
      const offsetRect = getBoundingClientRect$1(offsetParent, true);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX$1(documentElement);
    }
  }
  return {
    x: rect2.left + scroll.scrollLeft - offsets.x,
    y: rect2.top + scroll.scrollTop - offsets.y,
    width: rect2.width,
    height: rect2.height
  };
}
function getParentNode$1(node) {
  if (getNodeName$1(node) === "html") {
    return node;
  }
  return node.assignedSlot || node.parentNode || (isShadowRoot$1(node) ? node.host : null) || getDocumentElement$1(node);
}
function getTrueOffsetParent$1(element) {
  if (!isHTMLElement$1(element) || getComputedStyle(element).position === "fixed") {
    return null;
  }
  return element.offsetParent;
}
function getContainingBlock$1(element) {
  let currentNode = getParentNode$1(element);
  while (isHTMLElement$1(currentNode) && !["html", "body"].includes(getNodeName$1(currentNode))) {
    if (isContainingBlock(currentNode)) {
      return currentNode;
    } else {
      currentNode = currentNode.parentNode;
    }
  }
  return null;
}
function getOffsetParent$1(element) {
  const window2 = getWindow$1(element);
  let offsetParent = getTrueOffsetParent$1(element);
  while (offsetParent && isTableElement$1(offsetParent) && getComputedStyle(offsetParent).position === "static") {
    offsetParent = getTrueOffsetParent$1(offsetParent);
  }
  if (offsetParent && (getNodeName$1(offsetParent) === "html" || getNodeName$1(offsetParent) === "body" && getComputedStyle(offsetParent).position === "static" && !isContainingBlock(offsetParent))) {
    return window2;
  }
  return offsetParent || getContainingBlock$1(element) || window2;
}
function getDimensions(element) {
  return {
    width: element.offsetWidth,
    height: element.offsetHeight
  };
}
function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    rect: rect2,
    offsetParent,
    strategy
  } = _ref;
  const isOffsetParentAnElement = isHTMLElement$1(offsetParent);
  const documentElement = getDocumentElement$1(offsetParent);
  if (offsetParent === documentElement) {
    return rect2;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = {
    x: 0,
    y: 0
  };
  if (isOffsetParentAnElement || !isOffsetParentAnElement && strategy !== "fixed") {
    if (getNodeName$1(offsetParent) !== "body" || isScrollParent$1(documentElement)) {
      scroll = getNodeScroll$1(offsetParent);
    }
    if (isHTMLElement$1(offsetParent)) {
      const offsetRect = getBoundingClientRect$1(offsetParent, true);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  return {
    ...rect2,
    x: rect2.x - scroll.scrollLeft + offsets.x,
    y: rect2.y - scroll.scrollTop + offsets.y
  };
}
function getViewportRect$1(element) {
  const win = getWindow$1(element);
  const html = getDocumentElement$1(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x2 = 0;
  let y2 = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    if (Math.abs(win.innerWidth / visualViewport.scale - visualViewport.width) < 0.01) {
      x2 = visualViewport.offsetLeft;
      y2 = visualViewport.offsetTop;
    }
  }
  return {
    width,
    height,
    x: x2,
    y: y2
  };
}
function getDocumentRect$1(element) {
  var _element$ownerDocumen;
  const html = getDocumentElement$1(element);
  const scroll = getNodeScroll$1(element);
  const body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
  const width = max$1(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
  const height = max$1(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
  let x2 = -scroll.scrollLeft + getWindowScrollBarX$1(element);
  const y2 = -scroll.scrollTop;
  if (getComputedStyle$1$1(body || html).direction === "rtl") {
    x2 += max$1(html.clientWidth, body ? body.clientWidth : 0) - width;
  }
  return {
    width,
    height,
    x: x2,
    y: y2
  };
}
function getScrollParent$1(node) {
  if (["html", "body", "#document"].includes(getNodeName$1(node))) {
    return node.ownerDocument.body;
  }
  if (isHTMLElement$1(node) && isScrollParent$1(node)) {
    return node;
  }
  return getScrollParent$1(getParentNode$1(node));
}
function getScrollParents(node, list3) {
  var _node$ownerDocument;
  if (list3 === void 0) {
    list3 = [];
  }
  const scrollParent = getScrollParent$1(node);
  const isBody = scrollParent === ((_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.body);
  const win = getWindow$1(scrollParent);
  const target2 = isBody ? [win].concat(win.visualViewport || [], isScrollParent$1(scrollParent) ? scrollParent : []) : scrollParent;
  const updatedList = list3.concat(target2);
  return isBody ? updatedList : updatedList.concat(getScrollParents(getParentNode$1(target2)));
}
function contains$1(parent, child) {
  const rootNode = child.getRootNode == null ? void 0 : child.getRootNode();
  if (parent.contains(child)) {
    return true;
  } else if (rootNode && isShadowRoot$1(rootNode)) {
    let next = child;
    do {
      if (next && parent === next) {
        return true;
      }
      next = next.parentNode || next.host;
    } while (next);
  }
  return false;
}
function getInnerBoundingClientRect$1(element) {
  const clientRect = getBoundingClientRect$1(element);
  const top2 = clientRect.top + element.clientTop;
  const left2 = clientRect.left + element.clientLeft;
  return {
    top: top2,
    left: left2,
    x: left2,
    y: top2,
    right: left2 + element.clientWidth,
    bottom: top2 + element.clientHeight,
    width: element.clientWidth,
    height: element.clientHeight
  };
}
function getClientRectFromClippingParent(element, clippingParent) {
  if (clippingParent === "viewport") {
    return rectToClientRect$1(getViewportRect$1(element));
  }
  if (isElement$1(clippingParent)) {
    return getInnerBoundingClientRect$1(clippingParent);
  }
  return rectToClientRect$1(getDocumentRect$1(getDocumentElement$1(element)));
}
function getClippingParents$1(element) {
  const clippingParents2 = getScrollParents(getParentNode$1(element));
  const canEscapeClipping = ["absolute", "fixed"].includes(getComputedStyle$1$1(element).position);
  const clipperElement = canEscapeClipping && isHTMLElement$1(element) ? getOffsetParent$1(element) : element;
  if (!isElement$1(clipperElement)) {
    return [];
  }
  return clippingParents2.filter((clippingParent) => isElement$1(clippingParent) && contains$1(clippingParent, clipperElement) && getNodeName$1(clippingParent) !== "body");
}
function getClippingClientRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary
  } = _ref;
  const mainClippingParents = boundary === "clippingParents" ? getClippingParents$1(element) : [].concat(boundary);
  const clippingParents2 = [...mainClippingParents, rootBoundary];
  const firstClippingParent = clippingParents2[0];
  const clippingRect = clippingParents2.reduce((accRect, clippingParent) => {
    const rect2 = getClientRectFromClippingParent(element, clippingParent);
    accRect.top = max$1(rect2.top, accRect.top);
    accRect.right = min$1(rect2.right, accRect.right);
    accRect.bottom = min$1(rect2.bottom, accRect.bottom);
    accRect.left = max$1(rect2.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingParent(element, firstClippingParent));
  clippingRect.width = clippingRect.right - clippingRect.left;
  clippingRect.height = clippingRect.bottom - clippingRect.top;
  clippingRect.x = clippingRect.left;
  clippingRect.y = clippingRect.top;
  return clippingRect;
}
const platform = {
  getElementRects: (_ref) => {
    let {
      reference: reference3,
      floating,
      strategy
    } = _ref;
    return {
      reference: getRectRelativeToOffsetParent(reference3, getOffsetParent$1(floating), strategy),
      floating: {
        ...getDimensions(floating),
        x: 0,
        y: 0
      }
    };
  },
  convertOffsetParentRelativeRectToViewportRelativeRect: (args) => convertOffsetParentRelativeRectToViewportRelativeRect(args),
  getOffsetParent: (_ref2) => {
    let {
      element
    } = _ref2;
    return getOffsetParent$1(element);
  },
  isElement: (value) => isElement$1(value),
  getDocumentElement: (_ref3) => {
    let {
      element
    } = _ref3;
    return getDocumentElement$1(element);
  },
  getClippingClientRect: (args) => getClippingClientRect(args),
  getDimensions: (_ref4) => {
    let {
      element
    } = _ref4;
    return getDimensions(element);
  },
  getClientRects: (_ref5) => {
    let {
      element
    } = _ref5;
    return element.getClientRects();
  }
};
const computePosition = (reference3, floating, options2) => computePosition$1(reference3, floating, {
  platform,
  ...options2
});
var __defProp$1 = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp$1(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a2, b2) => {
  for (var prop2 in b2 || (b2 = {}))
    if (__hasOwnProp.call(b2, prop2))
      __defNormalProp(a2, prop2, b2[prop2]);
  if (__getOwnPropSymbols)
    for (var prop2 of __getOwnPropSymbols(b2)) {
      if (__propIsEnum.call(b2, prop2))
        __defNormalProp(a2, prop2, b2[prop2]);
    }
  return a2;
};
var __spreadProps = (a2, b2) => __defProps(a2, __getOwnPropDescs(b2));
const config$2 = {
  disabled: false,
  distance: 5,
  skidding: 0,
  container: "body",
  boundary: void 0,
  instantMove: false,
  disposeTimeout: 5e3,
  popperTriggers: [],
  strategy: "absolute",
  preventOverflow: true,
  flip: true,
  shift: true,
  overflowPadding: 0,
  arrowPadding: 0,
  arrowOverflow: true,
  themes: {
    tooltip: {
      placement: "top",
      triggers: ["hover", "focus", "touch"],
      hideTriggers: (events2) => [...events2, "click"],
      delay: {
        show: 200,
        hide: 0
      },
      handleResize: false,
      html: false,
      loadingContent: "..."
    },
    dropdown: {
      placement: "bottom",
      triggers: ["click"],
      delay: 0,
      handleResize: true,
      autoHide: true
    },
    menu: {
      $extend: "dropdown",
      triggers: ["hover", "focus"],
      popperTriggers: ["hover", "focus"],
      delay: {
        show: 0,
        hide: 400
      }
    }
  }
};
function getDefaultConfig(theme, key) {
  let themeConfig = config$2.themes[theme] || {};
  let value;
  do {
    value = themeConfig[key];
    if (typeof value === "undefined") {
      if (themeConfig.$extend) {
        themeConfig = config$2.themes[themeConfig.$extend] || {};
      } else {
        themeConfig = null;
        value = config$2[key];
      }
    } else {
      themeConfig = null;
    }
  } while (themeConfig);
  return value;
}
function getThemeClasses(theme) {
  const result = [theme];
  let themeConfig = config$2.themes[theme] || {};
  do {
    if (themeConfig.$extend && !themeConfig.$resetCss) {
      result.push(themeConfig.$extend);
      themeConfig = config$2.themes[themeConfig.$extend] || {};
    } else {
      themeConfig = null;
    }
  } while (themeConfig);
  return result.map((c2) => `v-popper--theme-${c2}`);
}
function getAllParentThemes(theme) {
  const result = [theme];
  let themeConfig = config$2.themes[theme] || {};
  do {
    if (themeConfig.$extend) {
      result.push(themeConfig.$extend);
      themeConfig = config$2.themes[themeConfig.$extend] || {};
    } else {
      themeConfig = null;
    }
  } while (themeConfig);
  return result;
}
let supportsPassive = false;
if (typeof window !== "undefined") {
  supportsPassive = false;
  try {
    const opts = Object.defineProperty({}, "passive", {
      get() {
        supportsPassive = true;
      }
    });
    window.addEventListener("test", null, opts);
  } catch (e) {
  }
}
let isIOS = false;
if (typeof window !== "undefined" && typeof navigator !== "undefined") {
  isIOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;
}
const placements$1 = ["auto", "top", "bottom", "left", "right"].reduce((acc, base2) => acc.concat([
  base2,
  `${base2}-start`,
  `${base2}-end`
]), []);
const SHOW_EVENT_MAP = {
  hover: "mouseenter",
  focus: "focus",
  click: "click",
  touch: "touchstart"
};
const HIDE_EVENT_MAP = {
  hover: "mouseleave",
  focus: "blur",
  click: "click",
  touch: "touchend"
};
function removeFromArray(array, item) {
  const index2 = array.indexOf(item);
  if (index2 !== -1) {
    array.splice(index2, 1);
  }
}
function nextFrame() {
  return new Promise((resolve3) => requestAnimationFrame(() => {
    requestAnimationFrame(resolve3);
  }));
}
const shownPoppers = [];
let hidingPopper = null;
const shownPoppersByTheme = {};
function getShownPoppersByTheme(theme) {
  let list3 = shownPoppersByTheme[theme];
  if (!list3) {
    list3 = shownPoppersByTheme[theme] = [];
  }
  return list3;
}
let Element$2 = function() {
};
if (typeof window !== "undefined") {
  Element$2 = window.Element;
}
function defaultPropFactory(prop2) {
  return function(props) {
    return getDefaultConfig(props.theme, prop2);
  };
}
const PROVIDE_KEY = "__floating-vue__popper";
var PrivatePopper = () => defineComponent({
  name: "VPopper",
  provide() {
    return {
      [PROVIDE_KEY]: {
        parentPopper: this
      }
    };
  },
  inject: {
    [PROVIDE_KEY]: { default: null }
  },
  props: {
    theme: {
      type: String,
      required: true
    },
    targetNodes: {
      type: Function,
      required: true
    },
    referenceNode: {
      type: Function,
      required: true
    },
    popperNode: {
      type: Function,
      required: true
    },
    shown: {
      type: Boolean,
      default: false
    },
    showGroup: {
      type: String,
      default: null
    },
    ariaId: {
      default: null
    },
    disabled: {
      type: Boolean,
      default: defaultPropFactory("disabled")
    },
    positioningDisabled: {
      type: Boolean,
      default: defaultPropFactory("positioningDisabled")
    },
    placement: {
      type: String,
      default: defaultPropFactory("placement"),
      validator: (value) => placements$1.includes(value)
    },
    delay: {
      type: [String, Number, Object],
      default: defaultPropFactory("delay")
    },
    distance: {
      type: [Number, String],
      default: defaultPropFactory("distance")
    },
    skidding: {
      type: [Number, String],
      default: defaultPropFactory("skidding")
    },
    triggers: {
      type: Array,
      default: defaultPropFactory("triggers")
    },
    showTriggers: {
      type: [Array, Function],
      default: defaultPropFactory("showTriggers")
    },
    hideTriggers: {
      type: [Array, Function],
      default: defaultPropFactory("hideTriggers")
    },
    popperTriggers: {
      type: Array,
      default: defaultPropFactory("popperTriggers")
    },
    popperShowTriggers: {
      type: [Array, Function],
      default: defaultPropFactory("popperShowTriggers")
    },
    popperHideTriggers: {
      type: [Array, Function],
      default: defaultPropFactory("popperHideTriggers")
    },
    container: {
      type: [String, Object, Element$2, Boolean],
      default: defaultPropFactory("container")
    },
    boundary: {
      type: [String, Element$2],
      default: defaultPropFactory("boundary")
    },
    strategy: {
      type: String,
      validator: (value) => ["absolute", "fixed"].includes(value),
      default: defaultPropFactory("strategy")
    },
    autoHide: {
      type: [Boolean, Function],
      default: defaultPropFactory("autoHide")
    },
    handleResize: {
      type: Boolean,
      default: defaultPropFactory("handleResize")
    },
    instantMove: {
      type: Boolean,
      default: defaultPropFactory("instantMove")
    },
    eagerMount: {
      type: Boolean,
      default: defaultPropFactory("eagerMount")
    },
    popperClass: {
      type: [String, Array, Object],
      default: defaultPropFactory("popperClass")
    },
    computeTransformOrigin: {
      type: Boolean,
      default: defaultPropFactory("computeTransformOrigin")
    },
    autoMinSize: {
      type: Boolean,
      default: defaultPropFactory("autoMinSize")
    },
    autoSize: {
      type: [Boolean, String],
      default: defaultPropFactory("autoSize")
    },
    autoMaxSize: {
      type: Boolean,
      default: defaultPropFactory("autoMaxSize")
    },
    autoBoundaryMaxSize: {
      type: Boolean,
      default: defaultPropFactory("autoBoundaryMaxSize")
    },
    preventOverflow: {
      type: Boolean,
      default: defaultPropFactory("preventOverflow")
    },
    overflowPadding: {
      type: [Number, String],
      default: defaultPropFactory("overflowPadding")
    },
    arrowPadding: {
      type: [Number, String],
      default: defaultPropFactory("arrowPadding")
    },
    arrowOverflow: {
      type: Boolean,
      default: defaultPropFactory("arrowOverflow")
    },
    flip: {
      type: Boolean,
      default: defaultPropFactory("flip")
    },
    shift: {
      type: Boolean,
      default: defaultPropFactory("shift")
    },
    shiftCrossAxis: {
      type: Boolean,
      default: defaultPropFactory("shiftCrossAxis")
    }
  },
  emits: [
    "show",
    "hide",
    "update:shown",
    "apply-show",
    "apply-hide",
    "close-group",
    "close-directive",
    "auto-hide",
    "resize",
    "dispose"
  ],
  data() {
    return {
      isShown: false,
      isMounted: false,
      skipTransition: false,
      classes: {
        showFrom: false,
        showTo: false,
        hideFrom: false,
        hideTo: true
      },
      result: {
        x: 0,
        y: 0,
        placement: "",
        strategy: this.strategy,
        arrow: {
          x: 0,
          y: 0,
          centerOffset: 0
        },
        transformOrigin: null
      },
      shownChildren: /* @__PURE__ */ new Set(),
      lastAutoHide: true
    };
  },
  computed: {
    popperId() {
      return this.ariaId != null ? this.ariaId : this.randomId;
    },
    shouldMountContent() {
      return this.eagerMount || this.isMounted;
    },
    slotData() {
      return {
        popperId: this.popperId,
        isShown: this.isShown,
        shouldMountContent: this.shouldMountContent,
        skipTransition: this.skipTransition,
        autoHide: typeof this.autoHide === "function" ? this.lastAutoHide : this.autoHide,
        show: this.show,
        hide: this.hide,
        handleResize: this.handleResize,
        onResize: this.onResize,
        classes: __spreadProps(__spreadValues({}, this.classes), {
          popperClass: this.popperClass
        }),
        result: this.positioningDisabled ? null : this.result,
        attrs: this.$attrs
      };
    },
    parentPopper() {
      var _a2;
      return (_a2 = this[PROVIDE_KEY]) == null ? void 0 : _a2.parentPopper;
    },
    hasPopperShowTriggerHover() {
      var _a2, _b2;
      return ((_a2 = this.popperTriggers) == null ? void 0 : _a2.includes("hover")) || ((_b2 = this.popperShowTriggers) == null ? void 0 : _b2.includes("hover"));
    }
  },
  watch: __spreadValues(__spreadValues({
    shown: "$_autoShowHide",
    disabled(value) {
      if (value) {
        this.dispose();
      } else {
        this.init();
      }
    },
    async container() {
      if (this.isShown) {
        this.$_ensureTeleport();
        await this.$_computePosition();
      }
    }
  }, [
    "triggers",
    "positioningDisabled"
  ].reduce((acc, prop2) => {
    acc[prop2] = "$_refreshListeners";
    return acc;
  }, {})), [
    "placement",
    "distance",
    "skidding",
    "boundary",
    "strategy",
    "overflowPadding",
    "arrowPadding",
    "preventOverflow",
    "shift",
    "shiftCrossAxis",
    "flip"
  ].reduce((acc, prop2) => {
    acc[prop2] = "$_computePosition";
    return acc;
  }, {})),
  created() {
    this.$_isDisposed = true;
    this.randomId = `popper_${[Math.random(), Date.now()].map((n) => n.toString(36).substring(2, 10)).join("_")}`;
    if (this.autoMinSize) {
      console.warn('[floating-vue] `autoMinSize` option is deprecated. Use `autoSize="min"` instead.');
    }
    if (this.autoMaxSize) {
      console.warn("[floating-vue] `autoMaxSize` option is deprecated. Use `autoBoundaryMaxSize` instead.");
    }
  },
  mounted() {
    this.init();
    this.$_detachPopperNode();
  },
  activated() {
    this.$_autoShowHide();
  },
  deactivated() {
    this.hide();
  },
  beforeUnmount() {
    this.dispose();
  },
  methods: {
    show({ event = null, skipDelay = false, force = false } = {}) {
      var _a2, _b2;
      if (((_a2 = this.parentPopper) == null ? void 0 : _a2.lockedChild) && this.parentPopper.lockedChild !== this)
        return;
      this.$_pendingHide = false;
      if (force || !this.disabled) {
        if (((_b2 = this.parentPopper) == null ? void 0 : _b2.lockedChild) === this) {
          this.parentPopper.lockedChild = null;
        }
        this.$_scheduleShow(event, skipDelay);
        this.$emit("show");
        this.$_showFrameLocked = true;
        requestAnimationFrame(() => {
          this.$_showFrameLocked = false;
        });
      }
      this.$emit("update:shown", true);
    },
    hide({ event = null, skipDelay = false } = {}) {
      var _a2;
      if (this.$_hideInProgress)
        return;
      if (this.shownChildren.size > 0) {
        this.$_pendingHide = true;
        return;
      }
      if (this.hasPopperShowTriggerHover && this.$_isAimingPopper()) {
        if (this.parentPopper) {
          this.parentPopper.lockedChild = this;
          clearTimeout(this.parentPopper.lockedChildTimer);
          this.parentPopper.lockedChildTimer = setTimeout(() => {
            if (this.parentPopper.lockedChild === this) {
              this.parentPopper.lockedChild.hide({ skipDelay });
              this.parentPopper.lockedChild = null;
            }
          }, 1e3);
        }
        return;
      }
      if (((_a2 = this.parentPopper) == null ? void 0 : _a2.lockedChild) === this) {
        this.parentPopper.lockedChild = null;
      }
      this.$_pendingHide = false;
      this.$_scheduleHide(event, skipDelay);
      this.$emit("hide");
      this.$emit("update:shown", false);
    },
    init() {
      if (!this.$_isDisposed)
        return;
      this.$_isDisposed = false;
      this.isMounted = false;
      this.$_events = [];
      this.$_preventShow = false;
      this.$_referenceNode = this.referenceNode();
      this.$_targetNodes = this.targetNodes().filter((e) => e.nodeType === e.ELEMENT_NODE);
      this.$_popperNode = this.popperNode();
      this.$_innerNode = this.$_popperNode.querySelector(".v-popper__inner");
      this.$_arrowNode = this.$_popperNode.querySelector(".v-popper__arrow-container");
      this.$_swapTargetAttrs("title", "data-original-title");
      this.$_detachPopperNode();
      if (this.triggers.length) {
        this.$_addEventListeners();
      }
      if (this.shown) {
        this.show();
      }
    },
    dispose() {
      if (this.$_isDisposed)
        return;
      this.$_isDisposed = true;
      this.$_removeEventListeners();
      this.hide({ skipDelay: true });
      this.$_detachPopperNode();
      this.isMounted = false;
      this.isShown = false;
      this.$_updateParentShownChildren(false);
      this.$_swapTargetAttrs("data-original-title", "title");
      this.$emit("dispose");
    },
    async onResize() {
      if (this.isShown) {
        await this.$_computePosition();
        this.$emit("resize");
      }
    },
    async $_computePosition() {
      var _a2;
      if (this.$_isDisposed || this.positioningDisabled)
        return;
      const options2 = {
        strategy: this.strategy,
        middleware: []
      };
      if (this.distance || this.skidding) {
        options2.middleware.push(offset$2({
          mainAxis: this.distance,
          crossAxis: this.skidding
        }));
      }
      const isPlacementAuto = this.placement.startsWith("auto");
      if (isPlacementAuto) {
        options2.middleware.push(autoPlacement({
          alignment: (_a2 = this.placement.split("-")[1]) != null ? _a2 : ""
        }));
      } else {
        options2.placement = this.placement;
      }
      if (this.preventOverflow) {
        if (this.shift) {
          options2.middleware.push(shift({
            padding: this.overflowPadding,
            boundary: this.boundary,
            crossAxis: this.shiftCrossAxis
          }));
        }
        if (!isPlacementAuto && this.flip) {
          options2.middleware.push(flip$2({
            padding: this.overflowPadding,
            boundary: this.boundary
          }));
        }
      }
      options2.middleware.push(arrow$2({
        element: this.$_arrowNode,
        padding: this.arrowPadding
      }));
      if (this.arrowOverflow) {
        options2.middleware.push({
          name: "arrowOverflow",
          fn: ({ placement, rects, middlewareData }) => {
            let overflow;
            const { centerOffset } = middlewareData.arrow;
            if (placement.startsWith("top") || placement.startsWith("bottom")) {
              overflow = Math.abs(centerOffset) > rects.reference.width / 2;
            } else {
              overflow = Math.abs(centerOffset) > rects.reference.height / 2;
            }
            return {
              data: {
                overflow
              }
            };
          }
        });
      }
      if (this.autoMinSize || this.autoSize) {
        const autoSize = this.autoSize ? this.autoSize : this.autoMinSize ? "min" : null;
        options2.middleware.push({
          name: "autoSize",
          fn: ({ rects, placement, middlewareData }) => {
            var _a22;
            if ((_a22 = middlewareData.autoSize) == null ? void 0 : _a22.skip) {
              return {};
            }
            let width;
            let height;
            if (placement.startsWith("top") || placement.startsWith("bottom")) {
              width = rects.reference.width;
            } else {
              height = rects.reference.height;
            }
            this.$_innerNode.style[autoSize === "min" ? "minWidth" : autoSize === "max" ? "maxWidth" : "width"] = width != null ? `${width}px` : null;
            this.$_innerNode.style[autoSize === "min" ? "minHeight" : autoSize === "max" ? "maxHeight" : "height"] = height != null ? `${height}px` : null;
            return {
              data: {
                skip: true
              },
              reset: {
                rects: true
              }
            };
          }
        });
      }
      if (this.autoMaxSize || this.autoBoundaryMaxSize) {
        this.$_innerNode.style.maxWidth = null;
        this.$_innerNode.style.maxHeight = null;
        options2.middleware.push(size({
          boundary: this.boundary,
          padding: this.overflowPadding,
          apply: ({ width, height }) => {
            this.$_innerNode.style.maxWidth = width != null ? `${width}px` : null;
            this.$_innerNode.style.maxHeight = height != null ? `${height}px` : null;
          }
        }));
      }
      const data = await computePosition(this.$_referenceNode, this.$_popperNode, options2);
      Object.assign(this.result, {
        x: data.x,
        y: data.y,
        placement: data.placement,
        strategy: data.strategy,
        arrow: __spreadValues(__spreadValues({}, data.middlewareData.arrow), data.middlewareData.arrowOverflow)
      });
    },
    $_scheduleShow(event = null, skipDelay = false) {
      this.$_updateParentShownChildren(true);
      this.$_hideInProgress = false;
      clearTimeout(this.$_scheduleTimer);
      if (hidingPopper && this.instantMove && hidingPopper.instantMove && hidingPopper !== this.parentPopper) {
        hidingPopper.$_applyHide(true);
        this.$_applyShow(true);
        return;
      }
      if (skipDelay) {
        this.$_applyShow();
      } else {
        this.$_scheduleTimer = setTimeout(this.$_applyShow.bind(this), this.$_computeDelay("show"));
      }
    },
    $_scheduleHide(event = null, skipDelay = false) {
      if (this.shownChildren.size > 0) {
        this.$_pendingHide = true;
        return;
      }
      this.$_updateParentShownChildren(false);
      this.$_hideInProgress = true;
      clearTimeout(this.$_scheduleTimer);
      if (this.isShown) {
        hidingPopper = this;
      }
      if (skipDelay) {
        this.$_applyHide();
      } else {
        this.$_scheduleTimer = setTimeout(this.$_applyHide.bind(this), this.$_computeDelay("hide"));
      }
    },
    $_computeDelay(type2) {
      const delay = this.delay;
      return parseInt(delay && delay[type2] || delay || 0);
    },
    async $_applyShow(skipTransition = false) {
      clearTimeout(this.$_disposeTimer);
      clearTimeout(this.$_scheduleTimer);
      this.skipTransition = skipTransition;
      if (this.isShown) {
        return;
      }
      this.$_ensureTeleport();
      await nextFrame();
      await this.$_computePosition();
      await this.$_applyShowEffect();
      if (!this.positioningDisabled) {
        this.$_registerEventListeners([
          ...getScrollParents(this.$_referenceNode),
          ...getScrollParents(this.$_popperNode)
        ], "scroll", () => {
          this.$_computePosition();
        });
      }
    },
    async $_applyShowEffect() {
      if (this.$_hideInProgress)
        return;
      if (this.computeTransformOrigin) {
        const bounds = this.$_referenceNode.getBoundingClientRect();
        const popperWrapper = this.$_popperNode.querySelector(".v-popper__wrapper");
        const parentBounds = popperWrapper.parentNode.getBoundingClientRect();
        const x2 = bounds.x + bounds.width / 2 - (parentBounds.left + popperWrapper.offsetLeft);
        const y2 = bounds.y + bounds.height / 2 - (parentBounds.top + popperWrapper.offsetTop);
        this.result.transformOrigin = `${x2}px ${y2}px`;
      }
      this.isShown = true;
      this.$_applyAttrsToTarget({
        "aria-describedby": this.popperId,
        "data-popper-shown": ""
      });
      const showGroup = this.showGroup;
      if (showGroup) {
        let popover;
        for (let i = 0; i < shownPoppers.length; i++) {
          popover = shownPoppers[i];
          if (popover.showGroup !== showGroup) {
            popover.hide();
            popover.$emit("close-group");
          }
        }
      }
      shownPoppers.push(this);
      document.body.classList.add("v-popper--some-open");
      for (const theme of getAllParentThemes(this.theme)) {
        getShownPoppersByTheme(theme).push(this);
        document.body.classList.add(`v-popper--some-open--${theme}`);
      }
      this.$emit("apply-show");
      this.classes.showFrom = true;
      this.classes.showTo = false;
      this.classes.hideFrom = false;
      this.classes.hideTo = false;
      await nextFrame();
      this.classes.showFrom = false;
      this.classes.showTo = true;
      this.$_popperNode.focus();
    },
    async $_applyHide(skipTransition = false) {
      if (this.shownChildren.size > 0) {
        this.$_pendingHide = true;
        this.$_hideInProgress = false;
        return;
      }
      clearTimeout(this.$_scheduleTimer);
      if (!this.isShown) {
        return;
      }
      this.skipTransition = skipTransition;
      removeFromArray(shownPoppers, this);
      if (shownPoppers.length === 0) {
        document.body.classList.remove("v-popper--some-open");
      }
      for (const theme of getAllParentThemes(this.theme)) {
        const list3 = getShownPoppersByTheme(theme);
        removeFromArray(list3, this);
        if (list3.length === 0) {
          document.body.classList.remove(`v-popper--some-open--${theme}`);
        }
      }
      if (hidingPopper === this) {
        hidingPopper = null;
      }
      this.isShown = false;
      this.$_applyAttrsToTarget({
        "aria-describedby": void 0,
        "data-popper-shown": void 0
      });
      clearTimeout(this.$_disposeTimer);
      const disposeTime = getDefaultConfig(this.theme, "disposeTimeout");
      if (disposeTime !== null) {
        this.$_disposeTimer = setTimeout(() => {
          if (this.$_popperNode) {
            this.$_detachPopperNode();
            this.isMounted = false;
          }
        }, disposeTime);
      }
      this.$_removeEventListeners("scroll");
      this.$emit("apply-hide");
      this.classes.showFrom = false;
      this.classes.showTo = false;
      this.classes.hideFrom = true;
      this.classes.hideTo = false;
      await nextFrame();
      this.classes.hideFrom = false;
      this.classes.hideTo = true;
    },
    $_autoShowHide() {
      if (this.shown) {
        this.show();
      } else {
        this.hide();
      }
    },
    $_ensureTeleport() {
      if (this.$_isDisposed)
        return;
      let container = this.container;
      if (typeof container === "string") {
        container = window.document.querySelector(container);
      } else if (container === false) {
        container = this.$_targetNodes[0].parentNode;
      }
      if (!container) {
        throw new Error("No container for popover: " + this.container);
      }
      container.appendChild(this.$_popperNode);
      this.isMounted = true;
    },
    $_addEventListeners() {
      const handleShow = (event) => {
        if (this.isShown && !this.$_hideInProgress) {
          return;
        }
        event.usedByTooltip = true;
        !this.$_preventShow && this.show({ event });
      };
      this.$_registerTriggerListeners(this.$_targetNodes, SHOW_EVENT_MAP, this.triggers, this.showTriggers, handleShow);
      this.$_registerTriggerListeners([this.$_popperNode], SHOW_EVENT_MAP, this.popperTriggers, this.popperShowTriggers, handleShow);
      const handleHide = (event) => {
        if (event.usedByTooltip) {
          return;
        }
        this.hide({ event });
      };
      this.$_registerTriggerListeners(this.$_targetNodes, HIDE_EVENT_MAP, this.triggers, this.hideTriggers, handleHide);
      this.$_registerTriggerListeners([this.$_popperNode], HIDE_EVENT_MAP, this.popperTriggers, this.popperHideTriggers, handleHide);
    },
    $_registerEventListeners(targetNodes, eventType, handler) {
      this.$_events.push({ targetNodes, eventType, handler });
      targetNodes.forEach((node) => node.addEventListener(eventType, handler, supportsPassive ? {
        passive: true
      } : void 0));
    },
    $_registerTriggerListeners(targetNodes, eventMap, commonTriggers, customTrigger, handler) {
      let triggers = commonTriggers;
      if (customTrigger != null) {
        triggers = typeof customTrigger === "function" ? customTrigger(triggers) : customTrigger;
      }
      triggers.forEach((trigger2) => {
        const eventType = eventMap[trigger2];
        if (eventType) {
          this.$_registerEventListeners(targetNodes, eventType, handler);
        }
      });
    },
    $_removeEventListeners(filterEventType) {
      const newList = [];
      this.$_events.forEach((listener) => {
        const { targetNodes, eventType, handler } = listener;
        if (!filterEventType || filterEventType === eventType) {
          targetNodes.forEach((node) => node.removeEventListener(eventType, handler));
        } else {
          newList.push(listener);
        }
      });
      this.$_events = newList;
    },
    $_refreshListeners() {
      if (!this.$_isDisposed) {
        this.$_removeEventListeners();
        this.$_addEventListeners();
      }
    },
    $_handleGlobalClose(event, touch = false) {
      if (this.$_showFrameLocked)
        return;
      this.hide({ event });
      if (event.closePopover) {
        this.$emit("close-directive");
      } else {
        this.$emit("auto-hide");
      }
      if (touch) {
        this.$_preventShow = true;
        setTimeout(() => {
          this.$_preventShow = false;
        }, 300);
      }
    },
    $_detachPopperNode() {
      this.$_popperNode.parentNode && this.$_popperNode.parentNode.removeChild(this.$_popperNode);
    },
    $_swapTargetAttrs(attrFrom, attrTo) {
      for (const el2 of this.$_targetNodes) {
        const value = el2.getAttribute(attrFrom);
        if (value) {
          el2.removeAttribute(attrFrom);
          el2.setAttribute(attrTo, value);
        }
      }
    },
    $_applyAttrsToTarget(attrs) {
      for (const el2 of this.$_targetNodes) {
        for (const n in attrs) {
          const value = attrs[n];
          if (value == null) {
            el2.removeAttribute(n);
          } else {
            el2.setAttribute(n, value);
          }
        }
      }
    },
    $_updateParentShownChildren(value) {
      let parent = this.parentPopper;
      while (parent) {
        if (value) {
          parent.shownChildren.add(this.randomId);
        } else {
          parent.shownChildren.delete(this.randomId);
          if (parent.$_pendingHide) {
            parent.hide();
          }
        }
        parent = parent.parentPopper;
      }
    },
    $_isAimingPopper() {
      const referenceBounds = this.$_referenceNode.getBoundingClientRect();
      if (mouseX >= referenceBounds.left && mouseX <= referenceBounds.right && mouseY >= referenceBounds.top && mouseY <= referenceBounds.bottom) {
        const popperBounds = this.$_popperNode.getBoundingClientRect();
        const vectorX = mouseX - mousePreviousX;
        const vectorY = mouseY - mousePreviousY;
        const distance = popperBounds.left + popperBounds.width / 2 - mousePreviousX + (popperBounds.top + popperBounds.height / 2) - mousePreviousY;
        const newVectorLength = distance + popperBounds.width + popperBounds.height;
        const edgeX = mousePreviousX + vectorX * newVectorLength;
        const edgeY = mousePreviousY + vectorY * newVectorLength;
        return lineIntersectsLine(mousePreviousX, mousePreviousY, edgeX, edgeY, popperBounds.left, popperBounds.top, popperBounds.left, popperBounds.bottom) || lineIntersectsLine(mousePreviousX, mousePreviousY, edgeX, edgeY, popperBounds.left, popperBounds.top, popperBounds.right, popperBounds.top) || lineIntersectsLine(mousePreviousX, mousePreviousY, edgeX, edgeY, popperBounds.right, popperBounds.top, popperBounds.right, popperBounds.bottom) || lineIntersectsLine(mousePreviousX, mousePreviousY, edgeX, edgeY, popperBounds.left, popperBounds.bottom, popperBounds.right, popperBounds.bottom);
      }
      return false;
    }
  },
  render() {
    return this.$slots.default(this.slotData);
  }
});
if (typeof document !== "undefined" && typeof window !== "undefined") {
  if (isIOS) {
    document.addEventListener("touchstart", handleGlobalMousedown, supportsPassive ? {
      passive: true,
      capture: true
    } : true);
    document.addEventListener("touchend", handleGlobalTouchend, supportsPassive ? {
      passive: true,
      capture: true
    } : true);
  } else {
    window.addEventListener("mousedown", handleGlobalMousedown, true);
    window.addEventListener("click", handleGlobalClick, true);
  }
  window.addEventListener("resize", computePositionAllShownPoppers);
}
function handleGlobalMousedown(event) {
  for (let i = 0; i < shownPoppers.length; i++) {
    const popper2 = shownPoppers[i];
    try {
      const popperContent = popper2.popperNode();
      popper2.$_mouseDownContains = popperContent.contains(event.target);
    } catch (e) {
    }
  }
}
function handleGlobalClick(event) {
  handleGlobalClose(event);
}
function handleGlobalTouchend(event) {
  handleGlobalClose(event, true);
}
function handleGlobalClose(event, touch = false) {
  const preventClose = {};
  for (let i = shownPoppers.length - 1; i >= 0; i--) {
    const popper2 = shownPoppers[i];
    try {
      const contains2 = popper2.$_containsGlobalTarget = isContainingEventTarget(popper2, event);
      popper2.$_pendingHide = false;
      requestAnimationFrame(() => {
        popper2.$_pendingHide = false;
        if (preventClose[popper2.randomId])
          return;
        if (shouldAutoHide(popper2, contains2, event)) {
          popper2.$_handleGlobalClose(event, touch);
          if (!event.closeAllPopover && event.closePopover && contains2) {
            let parent2 = popper2.parentPopper;
            while (parent2) {
              preventClose[parent2.randomId] = true;
              parent2 = parent2.parentPopper;
            }
            return;
          }
          let parent = popper2.parentPopper;
          while (parent) {
            if (shouldAutoHide(parent, parent.$_containsGlobalTarget, event)) {
              parent.$_handleGlobalClose(event, touch);
            } else {
              break;
            }
            parent = parent.parentPopper;
          }
        }
      });
    } catch (e) {
    }
  }
}
function isContainingEventTarget(popper2, event) {
  const popperContent = popper2.popperNode();
  return popper2.$_mouseDownContains || popperContent.contains(event.target);
}
function shouldAutoHide(popper2, contains2, event) {
  return event.closeAllPopover || event.closePopover && contains2 || getAutoHideResult(popper2, event) && !contains2;
}
function getAutoHideResult(popper2, event) {
  if (typeof popper2.autoHide === "function") {
    const result = popper2.autoHide(event);
    popper2.lastAutoHide = result;
    return result;
  }
  return popper2.autoHide;
}
function computePositionAllShownPoppers(event) {
  for (let i = 0; i < shownPoppers.length; i++) {
    const popper2 = shownPoppers[i];
    popper2.$_computePosition(event);
  }
}
function hideAllPoppers() {
  for (let i = 0; i < shownPoppers.length; i++) {
    const popper2 = shownPoppers[i];
    popper2.hide();
  }
}
let mousePreviousX = 0;
let mousePreviousY = 0;
let mouseX = 0;
let mouseY = 0;
if (typeof window !== "undefined") {
  window.addEventListener("mousemove", (event) => {
    mousePreviousX = mouseX;
    mousePreviousY = mouseY;
    mouseX = event.clientX;
    mouseY = event.clientY;
  }, supportsPassive ? {
    passive: true
  } : void 0);
}
function lineIntersectsLine(x1, y1, x2, y2, x3, y3, x4, y4) {
  const uA = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
  const uB = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
  return uA >= 0 && uA <= 1 && uB >= 0 && uB <= 1;
}
var _export_sfc = (sfc, props) => {
  const target2 = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target2[key] = val;
  }
  return target2;
};
const _sfc_main$6$1 = {
  extends: PrivatePopper()
};
function _sfc_render$3(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", mergeProps({
    ref: "reference",
    class: "v-popper"
  }, _ctx.$attrs, {
    class: {
      "v-popper--shown": _ctx.slotData.isShown
    }
  }), [
    renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(_ctx.slotData)))
  ], 16);
}
var Popper$1 = /* @__PURE__ */ _export_sfc(_sfc_main$6$1, [["render", _sfc_render$3]]);
function getInternetExplorerVersion() {
  var ua = window.navigator.userAgent;
  var msie = ua.indexOf("MSIE ");
  if (msie > 0) {
    return parseInt(ua.substring(msie + 5, ua.indexOf(".", msie)), 10);
  }
  var trident = ua.indexOf("Trident/");
  if (trident > 0) {
    var rv = ua.indexOf("rv:");
    return parseInt(ua.substring(rv + 3, ua.indexOf(".", rv)), 10);
  }
  var edge = ua.indexOf("Edge/");
  if (edge > 0) {
    return parseInt(ua.substring(edge + 5, ua.indexOf(".", edge)), 10);
  }
  return -1;
}
let isIE;
function initCompat() {
  if (!initCompat.init) {
    initCompat.init = true;
    isIE = getInternetExplorerVersion() !== -1;
  }
}
var script$a = {
  name: "ResizeObserver",
  props: {
    emitOnMount: {
      type: Boolean,
      default: false
    },
    ignoreWidth: {
      type: Boolean,
      default: false
    },
    ignoreHeight: {
      type: Boolean,
      default: false
    }
  },
  emits: [
    "notify"
  ],
  mounted() {
    initCompat();
    nextTick(() => {
      this._w = this.$el.offsetWidth;
      this._h = this.$el.offsetHeight;
      if (this.emitOnMount) {
        this.emitSize();
      }
    });
    const object = document.createElement("object");
    this._resizeObject = object;
    object.setAttribute("aria-hidden", "true");
    object.setAttribute("tabindex", -1);
    object.onload = this.addResizeHandlers;
    object.type = "text/html";
    if (isIE) {
      this.$el.appendChild(object);
    }
    object.data = "about:blank";
    if (!isIE) {
      this.$el.appendChild(object);
    }
  },
  beforeUnmount() {
    this.removeResizeHandlers();
  },
  methods: {
    compareAndNotify() {
      if (!this.ignoreWidth && this._w !== this.$el.offsetWidth || !this.ignoreHeight && this._h !== this.$el.offsetHeight) {
        this._w = this.$el.offsetWidth;
        this._h = this.$el.offsetHeight;
        this.emitSize();
      }
    },
    emitSize() {
      this.$emit("notify", {
        width: this._w,
        height: this._h
      });
    },
    addResizeHandlers() {
      this._resizeObject.contentDocument.defaultView.addEventListener("resize", this.compareAndNotify);
      this.compareAndNotify();
    },
    removeResizeHandlers() {
      if (this._resizeObject && this._resizeObject.onload) {
        if (!isIE && this._resizeObject.contentDocument) {
          this._resizeObject.contentDocument.defaultView.removeEventListener("resize", this.compareAndNotify);
        }
        this.$el.removeChild(this._resizeObject);
        this._resizeObject.onload = null;
        this._resizeObject = null;
      }
    }
  }
};
const _withId = /* @__PURE__ */ withScopeId();
pushScopeId("data-v-b329ee4c");
const _hoisted_1$2$2 = {
  class: "resize-observer",
  tabindex: "-1"
};
popScopeId();
const render$H = /* @__PURE__ */ _withId((_ctx, _cache, $props, $setup, $data, $options) => {
  return openBlock(), createBlock("div", _hoisted_1$2$2);
});
script$a.render = render$H;
script$a.__scopeId = "data-v-b329ee4c";
script$a.__file = "src/components/ResizeObserver.vue";
var PrivateThemeClass = (prop2 = "theme") => ({
  computed: {
    themeClass() {
      return getThemeClasses(this[prop2]);
    }
  }
});
const _sfc_main$5$1 = defineComponent({
  name: "VPopperContent",
  components: {
    ResizeObserver: script$a
  },
  mixins: [
    PrivateThemeClass()
  ],
  props: {
    popperId: String,
    theme: String,
    shown: Boolean,
    mounted: Boolean,
    skipTransition: Boolean,
    autoHide: Boolean,
    handleResize: Boolean,
    classes: Object,
    result: Object
  },
  emits: [
    "hide",
    "resize"
  ],
  methods: {
    toPx(value) {
      if (value != null && !isNaN(value)) {
        return `${value}px`;
      }
      return null;
    }
  }
});
const _hoisted_1$1$2 = ["id", "aria-hidden", "tabindex", "data-popper-placement"];
const _hoisted_2$1$2 = {
  ref: "inner",
  class: "v-popper__inner"
};
const _hoisted_3$10 = /* @__PURE__ */ createBaseVNode("div", { class: "v-popper__arrow-outer" }, null, -1);
const _hoisted_4$D = /* @__PURE__ */ createBaseVNode("div", { class: "v-popper__arrow-inner" }, null, -1);
const _hoisted_5$q = [
  _hoisted_3$10,
  _hoisted_4$D
];
function _sfc_render$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_ResizeObserver = resolveComponent("ResizeObserver");
  return openBlock(), createElementBlock("div", {
    id: _ctx.popperId,
    ref: "popover",
    class: normalizeClass(["v-popper__popper", [
      _ctx.themeClass,
      _ctx.classes.popperClass,
      {
        "v-popper__popper--shown": _ctx.shown,
        "v-popper__popper--hidden": !_ctx.shown,
        "v-popper__popper--show-from": _ctx.classes.showFrom,
        "v-popper__popper--show-to": _ctx.classes.showTo,
        "v-popper__popper--hide-from": _ctx.classes.hideFrom,
        "v-popper__popper--hide-to": _ctx.classes.hideTo,
        "v-popper__popper--skip-transition": _ctx.skipTransition,
        "v-popper__popper--arrow-overflow": _ctx.result && _ctx.result.arrow.overflow,
        "v-popper__popper--no-positioning": !_ctx.result
      }
    ]]),
    style: normalizeStyle(_ctx.result ? {
      position: _ctx.result.strategy,
      transform: `translate3d(${Math.round(_ctx.result.x)}px,${Math.round(_ctx.result.y)}px,0)`
    } : void 0),
    "aria-hidden": _ctx.shown ? "false" : "true",
    tabindex: _ctx.autoHide ? 0 : void 0,
    "data-popper-placement": _ctx.result ? _ctx.result.placement : void 0,
    onKeyup: _cache[2] || (_cache[2] = withKeys(($event) => _ctx.autoHide && _ctx.$emit("hide"), ["esc"]))
  }, [
    createBaseVNode("div", {
      class: "v-popper__backdrop",
      onClick: _cache[0] || (_cache[0] = ($event) => _ctx.autoHide && _ctx.$emit("hide"))
    }),
    createBaseVNode("div", {
      class: "v-popper__wrapper",
      style: normalizeStyle(_ctx.result ? {
        transformOrigin: _ctx.result.transformOrigin
      } : void 0)
    }, [
      createBaseVNode("div", _hoisted_2$1$2, [
        _ctx.mounted ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
          createBaseVNode("div", null, [
            renderSlot(_ctx.$slots, "default")
          ]),
          _ctx.handleResize ? (openBlock(), createBlock(_component_ResizeObserver, {
            key: 0,
            onNotify: _cache[1] || (_cache[1] = ($event) => _ctx.$emit("resize", $event))
          })) : createCommentVNode("", true)
        ], 64)) : createCommentVNode("", true)
      ], 512),
      createBaseVNode("div", {
        ref: "arrow",
        class: "v-popper__arrow-container",
        style: normalizeStyle(_ctx.result ? {
          left: _ctx.toPx(_ctx.result.arrow.x),
          top: _ctx.toPx(_ctx.result.arrow.y)
        } : void 0)
      }, _hoisted_5$q, 4)
    ], 4)
  ], 46, _hoisted_1$1$2);
}
var PrivatePopperContent = /* @__PURE__ */ _export_sfc(_sfc_main$5$1, [["render", _sfc_render$2]]);
var PrivatePopperMethods = {
  methods: {
    show(...args) {
      return this.$refs.popper.show(...args);
    },
    hide(...args) {
      return this.$refs.popper.hide(...args);
    },
    dispose(...args) {
      return this.$refs.popper.dispose(...args);
    },
    onResize(...args) {
      return this.$refs.popper.onResize(...args);
    }
  }
};
const _sfc_main$4$1 = defineComponent({
  name: "VPopperWrapper",
  components: {
    Popper: Popper$1,
    PopperContent: PrivatePopperContent
  },
  mixins: [
    PrivatePopperMethods,
    PrivateThemeClass("finalTheme")
  ],
  props: {
    theme: {
      type: String,
      default: null
    }
  },
  computed: {
    finalTheme() {
      var _a2;
      return (_a2 = this.theme) != null ? _a2 : this.$options.vPopperTheme;
    }
  },
  methods: {
    getTargetNodes() {
      return Array.from(this.$refs.popper.$el.children).filter((node) => node !== this.$refs.popperContent.$el);
    }
  }
});
function _sfc_render$1$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_PopperContent = resolveComponent("PopperContent");
  const _component_Popper = resolveComponent("Popper");
  return openBlock(), createBlock(_component_Popper, {
    ref: "popper",
    theme: _ctx.finalTheme,
    "target-nodes": _ctx.getTargetNodes,
    "reference-node": () => _ctx.$refs.popper.$el,
    "popper-node": () => _ctx.$refs.popperContent.$el,
    class: normalizeClass([
      _ctx.themeClass
    ])
  }, {
    default: withCtx(({
      popperId,
      isShown,
      shouldMountContent,
      skipTransition,
      autoHide,
      show,
      hide: hide2,
      handleResize,
      onResize,
      classes,
      result
    }) => [
      renderSlot(_ctx.$slots, "default", {
        shown: isShown,
        show,
        hide: hide2
      }),
      createVNode(_component_PopperContent, {
        ref: "popperContent",
        "popper-id": popperId,
        theme: _ctx.finalTheme,
        shown: isShown,
        mounted: shouldMountContent,
        "skip-transition": skipTransition,
        "auto-hide": autoHide,
        "handle-resize": handleResize,
        classes,
        result,
        onHide: hide2,
        onResize
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "popper", {
            shown: isShown,
            hide: hide2
          })
        ]),
        _: 2
      }, 1032, ["popper-id", "theme", "shown", "mounted", "skip-transition", "auto-hide", "handle-resize", "classes", "result", "onHide", "onResize"])
    ]),
    _: 3
  }, 8, ["theme", "target-nodes", "reference-node", "popper-node", "class"]);
}
var PrivatePopperWrapper = /* @__PURE__ */ _export_sfc(_sfc_main$4$1, [["render", _sfc_render$1$1]]);
defineComponent(__spreadProps(__spreadValues({}, PrivatePopperWrapper), {
  name: "VDropdown",
  vPopperTheme: "dropdown"
}));
const _sfc_main$2$1 = defineComponent(__spreadProps(__spreadValues({}, PrivatePopperWrapper), {
  name: "VMenu",
  vPopperTheme: "menu"
}));
const _sfc_main$1$1 = defineComponent(__spreadProps(__spreadValues({}, PrivatePopperWrapper), {
  name: "VTooltip",
  vPopperTheme: "tooltip"
}));
defineComponent({
  name: "VTooltipDirective",
  components: {
    Popper: PrivatePopper(),
    PopperContent: PrivatePopperContent
  },
  mixins: [
    PrivatePopperMethods
  ],
  inheritAttrs: false,
  props: {
    theme: {
      type: String,
      default: "tooltip"
    },
    html: {
      type: Boolean,
      default: (props) => getDefaultConfig(props.theme, "html")
    },
    content: {
      type: [String, Number, Function],
      default: null
    },
    loadingContent: {
      type: String,
      default: (props) => getDefaultConfig(props.theme, "loadingContent")
    }
  },
  data() {
    return {
      asyncContent: null
    };
  },
  computed: {
    isContentAsync() {
      return typeof this.content === "function";
    },
    loading() {
      return this.isContentAsync && this.asyncContent == null;
    },
    finalContent() {
      if (this.isContentAsync) {
        return this.loading ? this.loadingContent : this.asyncContent;
      }
      return this.content;
    }
  },
  watch: {
    content: {
      handler() {
        this.fetchContent(true);
      },
      immediate: true
    },
    async finalContent() {
      await this.$nextTick();
      this.$refs.popper.onResize();
    }
  },
  created() {
    this.$_fetchId = 0;
  },
  methods: {
    fetchContent(force) {
      if (typeof this.content === "function" && this.$_isShown && (force || !this.$_loading && this.asyncContent == null)) {
        this.asyncContent = null;
        this.$_loading = true;
        const fetchId = ++this.$_fetchId;
        const result = this.content(this);
        if (result.then) {
          result.then((res) => this.onResult(fetchId, res));
        } else {
          this.onResult(fetchId, result);
        }
      }
    },
    onResult(fetchId, result) {
      if (fetchId !== this.$_fetchId)
        return;
      this.$_loading = false;
      this.asyncContent = result;
    },
    onShow() {
      this.$_isShown = true;
      this.fetchContent();
    },
    onHide() {
      this.$_isShown = false;
    }
  }
});
const options = config$2;
const Menu = _sfc_main$2$1;
const Tooltip = _sfc_main$1$1;
const _hoisted_1$1g = { class: "flex min-h-screen items-center justify-center" };
const _hoisted_2$19 = { class: "bg-white rounded mx-auto min-w-480px max-w-600px relative" };
const _hoisted_3$$ = { key: 2 };
const _hoisted_4$C = { class: "rounded flex font-medium bg-red-100 mb-20px p-16px text-red-600 gap-8px items-center" };
const _hoisted_5$p = { key: 3 };
const _hoisted_6$f = { class: "rounded flex bg-red-100 mt-16px p-16px text-red-600 gap-8px items-center" };
const _sfc_main$T = /* @__PURE__ */ defineComponent({
  props: {
    gql: null,
    utmMedium: null,
    utmContent: null
  },
  emits: ["close", "cancel"],
  setup(__props, { emit: emit2 }) {
    const props = __props;
    const online = useOnline();
    gql`
fragment LoginModal on Query {
  ...Auth
}
`;
    hideAllPoppers();
    const { t: t2 } = useI18n();
    const viewer = computed(() => {
      var _a2;
      return (_a2 = props.gql) == null ? void 0 : _a2.cloudViewer;
    });
    const error2 = computed(() => {
      const { name: name2 } = props.gql.authState;
      if (name2 !== "AUTH_BROWSER_LAUNCHED") {
        return name2;
      }
      return null;
    });
    const showFooter = computed(() => error2.value !== "AUTH_COULD_NOT_LAUNCH_BROWSER");
    const title = computed(() => {
      if (viewer.value) {
        return t2("topNav.login.titleSuccess");
      }
      if (error2.value === "AUTH_COULD_NOT_LAUNCH_BROWSER") {
        return t2("topNav.login.titleBrowserError");
      }
      if (error2.value === "AUTH_ERROR_DURING_LOGIN") {
        return t2("topNav.login.titleFailed");
      }
      return t2("topNav.login.titleInitial");
    });
    const isOnline = computed(() => online.value);
    const cancelLogin = () => {
      emit2("cancel");
    };
    return (_ctx, _cache) => {
      const _component_i18n_t = resolveComponent("i18n-t");
      const _component_i_cy_errored_outline_x16 = __unplugin_components_1$8;
      return openBlock(), createBlock(unref(Dialog), {
        open: "",
        class: "inset-0 z-50 fixed overflow-y-auto",
        onClose: cancelLogin
      }, {
        default: withCtx(() => [
          createBaseVNode("div", _hoisted_1$1g, [
            createVNode(unref(DialogOverlay), { class: "bg-gray-800 opacity-90 inset-0 fixed" }),
            createBaseVNode("div", _hoisted_2$19, [
              createVNode(_sfc_main$U, {
                "help-link": "https://on.cypress.io",
                "help-text": unref(t2)("links.needHelp"),
                onClose: cancelLogin
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString$1(unref(title)), 1)
                ]),
                _: 1
              }, 8, ["help-text"]),
              !unref(isOnline) ? (openBlock(), createBlock(_sfc_main$Y, {
                key: 0,
                class: "mt-24px"
              })) : unref(isOnline) ? (openBlock(), createBlock(unref(DialogDescription), {
                key: 1,
                class: "font-normal p-24px text-gray-700"
              }, {
                default: withCtx(() => [
                  !unref(viewer) && !unref(error2) ? (openBlock(), createBlock(_component_i18n_t, {
                    key: 0,
                    scope: "global",
                    keypath: "topNav.login.bodyInitial"
                  }, {
                    default: withCtx(() => [
                      createVNode(_sfc_main$$, { href: "https://on.cypress.io/dashboard-introduction" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString$1(unref(t2)("topNav.login.cloud")), 1)
                        ]),
                        _: 1
                      })
                    ]),
                    _: 1
                  })) : unref(viewer) ? (openBlock(), createBlock(_component_i18n_t, {
                    key: 1,
                    scope: "global",
                    keypath: "topNav.login.bodySuccess"
                  }, {
                    default: withCtx(() => [
                      createVNode(_sfc_main$$, {
                        href: "https://on.cypress.io/dashboard/profile",
                        class: "font-medium text-indigo-500"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString$1(unref(viewer).fullName || unref(viewer).email), 1)
                        ]),
                        _: 1
                      })
                    ]),
                    _: 1
                  })) : unref(error2) === "AUTH_COULD_NOT_LAUNCH_BROWSER" ? (openBlock(), createElementBlock("div", _hoisted_3$$, [
                    createBaseVNode("div", _hoisted_4$C, [
                      createVNode(_component_i_cy_errored_outline_x16, { class: "h-16px min-w-16px w-16px icon-dark-red-400" }),
                      createTextVNode(" " + toDisplayString$1(unref(t2)("topNav.login.bodyBrowserError")), 1)
                    ]),
                    createTextVNode(" " + toDisplayString$1(unref(t2)("topNav.login.bodyBrowserErrorDetails")) + " ", 1),
                    props.gql.authState.message ? (openBlock(), createBlock(CopyText, {
                      key: 0,
                      class: "mt-12px",
                      text: props.gql.authState.message
                    }, null, 8, ["text"])) : createCommentVNode("", true)
                  ])) : unref(error2) === "AUTH_ERROR_DURING_LOGIN" ? (openBlock(), createElementBlock("div", _hoisted_5$p, [
                    createTextVNode(toDisplayString$1(unref(t2)("topNav.login.bodyError")) + " ", 1),
                    createBaseVNode("div", _hoisted_6$f, [
                      createVNode(_component_i_cy_errored_outline_x16, { class: "h-16px min-w-16px w-16px icon-dark-red-400" }),
                      createTextVNode(" " + toDisplayString$1(props.gql.authState.message), 1)
                    ])
                  ])) : createCommentVNode("", true)
                ]),
                _: 1
              })) : createCommentVNode("", true),
              createBaseVNode("div", {
                class: normalizeClass(["bg-gray-50 border-t-1px py-16px px-24px", { "hidden": !unref(showFooter) }])
              }, [
                createVNode(_sfc_main$Z, {
                  gql: props.gql,
                  "show-retry": !!unref(error2),
                  "utm-medium": props.utmMedium,
                  "utm-content": props.utmContent,
                  onClose: _cache[0] || (_cache[0] = ($event) => emit2("close")),
                  onCancel: _cache[1] || (_cache[1] = ($event) => emit2("cancel"))
                }, null, 8, ["gql", "show-retry", "utm-medium", "utm-content"])
              ], 2)
            ])
          ])
        ]),
        _: 1
      });
    };
  }
});
const _sfc_main$S = /* @__PURE__ */ defineComponent({
  props: {
    variant: null
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(__props.variant === "bare" ? "p-0" : "p-24px")
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});
const _sfc_main$R = {};
const _hoisted_1$1f = { class: "rounded-b bg-gray-50 border-t-1px border-gray-100 h-72px py-16px px-24px" };
function _sfc_render$1(_ctx, _cache) {
  return openBlock(), createElementBlock("div", _hoisted_1$1f, [
    renderSlot(_ctx.$slots, "default")
  ]);
}
const StandardModalFooter = /* @__PURE__ */ _export_sfc$1(_sfc_main$R, [["render", _sfc_render$1]]);
const _hoisted_1$1e = { class: "flex min-h-screen items-center justify-center" };
const _sfc_main$Q = /* @__PURE__ */ defineComponent({
  props: {
    modelValue: { type: Boolean, default: false },
    helpLink: { default: "https://on.cypress.io" },
    helpText: { default: `${defaultMessages.links.needHelp}` },
    variant: { default: void 0 },
    noHelp: { type: Boolean, default: false },
    title: { default: "" },
    class: { default: void 0 }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: emit2 }) {
    const props = __props;
    const setIsOpen = (val) => {
      emit2("update:modelValue", val);
    };
    watch(
      () => props.modelValue,
      (value) => {
        if (value) {
          hideAllPoppers();
        }
      },
      { immediate: true }
    );
    const closeModal = () => {
      setIsOpen(false);
    };
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Dialog), {
        open: __props.modelValue,
        class: "inset-0 z-10 fixed overflow-y-auto",
        onClose: _cache[0] || (_cache[0] = ($event) => closeModal())
      }, {
        default: withCtx(() => [
          createBaseVNode("div", _hoisted_1$1e, [
            renderSlot(_ctx.$slots, "overlay", { classes: "fixed inset-0" }, () => [
              createVNode(unref(DialogOverlay), { class: "bg-gray-800 opacity-90 fixed sm:inset-0" })
            ]),
            createBaseVNode("div", {
              "data-cy": "standard-modal",
              class: normalizeClass(["bg-white rounded mx-auto ring-[#9095AD40] ring-4 relative", props.class || ""])
            }, [
              createVNode(_sfc_main$U, {
                "no-help": __props.noHelp,
                "help-link": __props.helpLink,
                "help-text": __props.helpText,
                onClose: closeModal
              }, {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "title", {}, () => [
                    createTextVNode(toDisplayString$1(__props.title), 1)
                  ])
                ]),
                _: 3
              }, 8, ["no-help", "help-link", "help-text"]),
              _ctx.$slots.description ? (openBlock(), createBlock(unref(DialogDescription), {
                key: 0,
                class: "font-normal p-24px text-gray-700"
              }, {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "description")
                ]),
                _: 3
              })) : createCommentVNode("", true),
              createVNode(_sfc_main$S, { variant: __props.variant }, {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "default")
                ]),
                _: 3
              }, 8, ["variant"]),
              _ctx.$slots.footer ? (openBlock(), createBlock(StandardModalFooter, { key: 1 }, {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "footer")
                ]),
                _: 3
              })) : createCommentVNode("", true)
            ], 2)
          ])
        ]),
        _: 3
      }, 8, ["open"]);
    };
  }
});
const _hoisted_1$1d = {
  height: "1em",
  width: "1em",
  viewBox: "0 0 16 16",
  fill: "none",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$18 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M2 5L8 11L14 5",
  stroke: "#1B1E2E",
  class: "icon-dark",
  "stroke-width": "2",
  "stroke-linecap": "round",
  "stroke-linejoin": "round"
}, null, -1);
const _hoisted_3$_ = [
  _hoisted_2$18
];
function render$G(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1d, _hoisted_3$_);
}
const __unplugin_components_0$9 = { name: "cy-chevron-down", render: render$G };
const _hoisted_1$1c = {
  width: "1em",
  height: "1em",
  preserveAspectRatio: "xMidYMid meet",
  viewBox: "0 0 24 24"
};
const _hoisted_2$17 = /* @__PURE__ */ createBaseVNode("path", {
  d: "M21 7L9 19l-5.5-5.5l1.41-1.41L9 16.17L19.59 5.59L21 7z",
  fill: "currentColor"
}, null, -1);
const _hoisted_3$Z = [
  _hoisted_2$17
];
function render$F(_ctx, _cache) {
  return openBlock(), createElementBlock("svg", _hoisted_1$1c, _hoisted_3$Z);
}
const __unplugin_components_1$7 = { name: "mdi-check", render: render$F };
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x2) {
  return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
}
function getAugmentedNamespace(n) {
  var f2 = n.default;
  if (typeof f2 == "function") {
    var a2 = function a3() {
      if (this instanceof a3) {
        var args = [null];
        args.push.apply(args, arguments);
        var Ctor = Function.bind.apply(f2, args);
        return new Ctor();
      }
      return f2.apply(this, arguments);
    };
    a2.prototype = f2.prototype;
  } else
    a2 = {};
  Object.defineProperty(a2, "__esModule", { value: true });
  Object.keys(n).forEach(function(k) {
    var d2 = Object.getOwnPropertyDescriptor(n, k);
    Object.defineProperty(a2, k, d2.get ? d2 : {
      enumerable: true,
      get: function() {
        return n[k];
      }
    });
  });
  return a2;
}
var lodash = { exports: {} };
(function(module, exports) {
  (function() {
    var undefined$1;
    var VERSION2 = "4.17.21";
    var LARGE_ARRAY_SIZE = 200;
    var CORE_ERROR_TEXT = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.", FUNC_ERROR_TEXT = "Expected a function", INVALID_TEMPL_VAR_ERROR_TEXT = "Invalid `variable` option passed into `_.template`";
    var HASH_UNDEFINED = "__lodash_hash_undefined__";
    var MAX_MEMOIZE_SIZE = 500;
    var PLACEHOLDER = "__lodash_placeholder__";
    var CLONE_DEEP_FLAG = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG = 4;
    var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
    var WRAP_BIND_FLAG = 1, WRAP_BIND_KEY_FLAG = 2, WRAP_CURRY_BOUND_FLAG = 4, WRAP_CURRY_FLAG = 8, WRAP_CURRY_RIGHT_FLAG = 16, WRAP_PARTIAL_FLAG = 32, WRAP_PARTIAL_RIGHT_FLAG = 64, WRAP_ARY_FLAG = 128, WRAP_REARG_FLAG = 256, WRAP_FLIP_FLAG = 512;
    var DEFAULT_TRUNC_LENGTH = 30, DEFAULT_TRUNC_OMISSION = "...";
    var HOT_COUNT = 800, HOT_SPAN = 16;
    var LAZY_FILTER_FLAG = 1, LAZY_MAP_FLAG = 2, LAZY_WHILE_FLAG = 3;
    var INFINITY = 1 / 0, MAX_SAFE_INTEGER = 9007199254740991, MAX_INTEGER = 17976931348623157e292, NAN = 0 / 0;
    var MAX_ARRAY_LENGTH2 = 4294967295, MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH2 - 1, HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH2 >>> 1;
    var wrapFlags = [
      ["ary", WRAP_ARY_FLAG],
      ["bind", WRAP_BIND_FLAG],
      ["bindKey", WRAP_BIND_KEY_FLAG],
      ["curry", WRAP_CURRY_FLAG],
      ["curryRight", WRAP_CURRY_RIGHT_FLAG],
      ["flip", WRAP_FLIP_FLAG],
      ["partial", WRAP_PARTIAL_FLAG],
      ["partialRight", WRAP_PARTIAL_RIGHT_FLAG],
      ["rearg", WRAP_REARG_FLAG]
    ];
    var argsTag = "[object Arguments]", arrayTag = "[object Array]", asyncTag = "[object AsyncFunction]", boolTag = "[object Boolean]", dateTag = "[object Date]", domExcTag = "[object DOMException]", errorTag = "[object Error]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", mapTag = "[object Map]", numberTag = "[object Number]", nullTag = "[object Null]", objectTag = "[object Object]", promiseTag = "[object Promise]", proxyTag = "[object Proxy]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", symbolTag = "[object Symbol]", undefinedTag = "[object Undefined]", weakMapTag = "[object WeakMap]", weakSetTag = "[object WeakSet]";
    var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
    var reEmptyStringLeading = /\b__p \+= '';/g, reEmptyStringMiddle = /\b(__p \+=) '' \+/g, reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
    var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g, reUnescapedHtml = /[&<>"']/g, reHasEscapedHtml = RegExp(reEscapedHtml.source), reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
    var reEscape = /<%-([\s\S]+?)%>/g, reEvaluate = /<%([\s\S]+?)%>/g, reInterpolate = /<%=([\s\S]+?)%>/g;
    var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/, rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g, reHasRegExpChar = RegExp(reRegExpChar.source);
    var reTrimStart = /^\s+/;
    var reWhitespace = /\s/;
    var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/, reSplitDetails = /,? & /;
    var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
    var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
    var reEscapeChar = /\\(\\)?/g;
    var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
    var reFlags = /\w*$/;
    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
    var reIsBinary = /^0b[01]+$/i;
    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    var reIsOctal = /^0o[0-7]+$/i;
    var reIsUint = /^(?:0|[1-9]\d*)$/;
    var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
    var reNoMatch = /($^)/;
    var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
    var rsAstralRange = "\\ud800-\\udfff", rsComboMarksRange = "\\u0300-\\u036f", reComboHalfMarksRange = "\\ufe20-\\ufe2f", rsComboSymbolsRange = "\\u20d0-\\u20ff", rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange, rsDingbatRange = "\\u2700-\\u27bf", rsLowerRange = "a-z\\xdf-\\xf6\\xf8-\\xff", rsMathOpRange = "\\xac\\xb1\\xd7\\xf7", rsNonCharRange = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", rsPunctuationRange = "\\u2000-\\u206f", rsSpaceRange = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", rsUpperRange = "A-Z\\xc0-\\xd6\\xd8-\\xde", rsVarRange = "\\ufe0e\\ufe0f", rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
    var rsApos = "['’]", rsAstral = "[" + rsAstralRange + "]", rsBreak = "[" + rsBreakRange + "]", rsCombo = "[" + rsComboRange + "]", rsDigits = "\\d+", rsDingbat = "[" + rsDingbatRange + "]", rsLower = "[" + rsLowerRange + "]", rsMisc = "[^" + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + "]", rsFitz = "\\ud83c[\\udffb-\\udfff]", rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")", rsNonAstral = "[^" + rsAstralRange + "]", rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}", rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]", rsUpper = "[" + rsUpperRange + "]", rsZWJ = "\\u200d";
    var rsMiscLower = "(?:" + rsLower + "|" + rsMisc + ")", rsMiscUpper = "(?:" + rsUpper + "|" + rsMisc + ")", rsOptContrLower = "(?:" + rsApos + "(?:d|ll|m|re|s|t|ve))?", rsOptContrUpper = "(?:" + rsApos + "(?:D|LL|M|RE|S|T|VE))?", reOptMod = rsModifier + "?", rsOptVar = "[" + rsVarRange + "]?", rsOptJoin = "(?:" + rsZWJ + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*", rsOrdLower = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", rsOrdUpper = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", rsSeq = rsOptVar + reOptMod + rsOptJoin, rsEmoji = "(?:" + [rsDingbat, rsRegional, rsSurrPair].join("|") + ")" + rsSeq, rsSymbol = "(?:" + [rsNonAstral + rsCombo + "?", rsCombo, rsRegional, rsSurrPair, rsAstral].join("|") + ")";
    var reApos = RegExp(rsApos, "g");
    var reComboMark = RegExp(rsCombo, "g");
    var reUnicode = RegExp(rsFitz + "(?=" + rsFitz + ")|" + rsSymbol + rsSeq, "g");
    var reUnicodeWord = RegExp([
      rsUpper + "?" + rsLower + "+" + rsOptContrLower + "(?=" + [rsBreak, rsUpper, "$"].join("|") + ")",
      rsMiscUpper + "+" + rsOptContrUpper + "(?=" + [rsBreak, rsUpper + rsMiscLower, "$"].join("|") + ")",
      rsUpper + "?" + rsMiscLower + "+" + rsOptContrLower,
      rsUpper + "+" + rsOptContrUpper,
      rsOrdUpper,
      rsOrdLower,
      rsDigits,
      rsEmoji
    ].join("|"), "g");
    var reHasUnicode = RegExp("[" + rsZWJ + rsAstralRange + rsComboRange + rsVarRange + "]");
    var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
    var contextProps = [
      "Array",
      "Buffer",
      "DataView",
      "Date",
      "Error",
      "Float32Array",
      "Float64Array",
      "Function",
      "Int8Array",
      "Int16Array",
      "Int32Array",
      "Map",
      "Math",
      "Object",
      "Promise",
      "RegExp",
      "Set",
      "String",
      "Symbol",
      "TypeError",
      "Uint8Array",
      "Uint8ClampedArray",
      "Uint16Array",
      "Uint32Array",
      "WeakMap",
      "_",
      "clearTimeout",
      "isFinite",
      "parseInt",
      "setTimeout"
    ];
    var templateCounter = -1;
    var typedArrayTags = {};
    typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
    typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
    var cloneableTags = {};
    cloneableTags[argsTag] = cloneableTags[arrayTag] = cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] = cloneableTags[boolTag] = cloneableTags[dateTag] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[mapTag] = cloneableTags[numberTag] = cloneableTags[objectTag] = cloneableTags[regexpTag] = cloneableTags[setTag] = cloneableTags[stringTag] = cloneableTags[symbolTag] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
    cloneableTags[errorTag] = cloneableTags[funcTag] = cloneableTags[weakMapTag] = false;
    var deburredLetters = {
      "À": "A",
      "Á": "A",
      "Â": "A",
      "Ã": "A",
      "Ä": "A",
      "Å": "A",
      "à": "a",
      "á": "a",
      "â": "a",
      "ã": "a",
      "ä": "a",
      "å": "a",
      "Ç": "C",
      "ç": "c",
      "Ð": "D",
      "ð": "d",
      "È": "E",
      "É": "E",
      "Ê": "E",
      "Ë": "E",
      "è": "e",
      "é": "e",
      "ê": "e",
      "ë": "e",
      "Ì": "I",
      "Í": "I",
      "Î": "I",
      "Ï": "I",
      "ì": "i",
      "í": "i",
      "î": "i",
      "ï": "i",
      "Ñ": "N",
      "ñ": "n",
      "Ò": "O",
      "Ó": "O",
      "Ô": "O",
      "Õ": "O",
      "Ö": "O",
      "Ø": "O",
      "ò": "o",
      "ó": "o",
      "ô": "o",
      "õ": "o",
      "ö": "o",
      "ø": "o",
      "Ù": "U",
      "Ú": "U",
      "Û": "U",
      "Ü": "U",
      "ù": "u",
      "ú": "u",
      "û": "u",
      "ü": "u",
      "Ý": "Y",
      "ý": "y",
      "ÿ": "y",
      "Æ": "Ae",
      "æ": "ae",
      "Þ": "Th",
      "þ": "th",
      "ß": "ss",
      "Ā": "A",
      "Ă": "A",
      "Ą": "A",
      "ā": "a",
      "ă": "a",
      "ą": "a",
      "Ć": "C",
      "Ĉ": "C",
      "Ċ": "C",
      "Č": "C",
      "ć": "c",
      "ĉ": "c",
      "ċ": "c",
      "č": "c",
      "Ď": "D",
      "Đ": "D",
      "ď": "d",
      "đ": "d",
      "Ē": "E",
      "Ĕ": "E",
      "Ė": "E",
      "Ę": "E",
      "Ě": "E",
      "ē": "e",
      "ĕ": "e",
      "ė": "e",
      "ę": "e",
      "ě": "e",
      "Ĝ": "G",
      "Ğ": "G",
      "Ġ": "G",
      "Ģ": "G",
      "ĝ": "g",
      "ğ": "g",
      "ġ": "g",
      "ģ": "g",
      "Ĥ": "H",
      "Ħ": "H",
      "ĥ": "h",
      "ħ": "h",
      "Ĩ": "I",
      "Ī": "I",
      "Ĭ": "I",
      "Į": "I",
      "İ": "I",
      "ĩ": "i",
      "ī": "i",
      "ĭ": "i",
      "į": "i",
      "ı": "i",
      "Ĵ": "J",
      "ĵ": "j",
      "Ķ": "K",
      "ķ": "k",
      "ĸ": "k",
      "Ĺ": "L",
      "Ļ": "L",
      "Ľ": "L",
      "Ŀ": "L",
      "Ł": "L",
      "ĺ": "l",
      "ļ": "l",
      "ľ": "l",
      "ŀ": "l",
      "ł": "l",
      "Ń": "N",
      "Ņ": "N",
      "Ň": "N",
      "Ŋ": "N",
      "ń": "n",
      "ņ": "n",
      "ň": "n",
      "ŋ": "n",
      "Ō": "O",
      "Ŏ": "O",
      "Ő": "O",
      "ō": "o",
      "ŏ": "o",
      "ő": "o",
      "Ŕ": "R",
      "Ŗ": "R",
      "Ř": "R",
      "ŕ": "r",
      "ŗ": "r",
      "ř": "r",
      "Ś": "S",
      "Ŝ": "S",
      "Ş": "S",
      "Š": "S",
      "ś": "s",
      "ŝ": "s",
      "ş": "s",
      "š": "s",
      "Ţ": "T",
      "Ť": "T",
      "Ŧ": "T",
      "ţ": "t",
      "ť": "t",
      "ŧ": "t",
      "Ũ": "U",
      "Ū": "U",
      "Ŭ": "U",
      "Ů": "U",
      "Ű": "U",
      "Ų": "U",
      "ũ": "u",
      "ū": "u",
      "ŭ": "u",
      "ů": "u",
      "ű": "u",
      "ų": "u",
      "Ŵ": "W",
      "ŵ": "w",
      "Ŷ": "Y",
      "ŷ": "y",
      "Ÿ": "Y",
      "Ź": "Z",
      "Ż": "Z",
      "Ž": "Z",
      "ź": "z",
      "ż": "z",
      "ž": "z",
      "Ĳ": "IJ",
      "ĳ": "ij",
      "Œ": "Oe",
      "œ": "oe",
      "ŉ": "'n",
      "ſ": "s"
    };
    var htmlEscapes2 = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#39;"
    };
    var htmlUnescapes = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#39;": "'"
    };
    var stringEscapes = {
      "\\": "\\",
      "'": "'",
      "\n": "n",
      "\r": "r",
      "\u2028": "u2028",
      "\u2029": "u2029"
    };
    var freeParseFloat = parseFloat, freeParseInt = parseInt;
    var freeGlobal = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root = freeGlobal || freeSelf || Function("return this")();
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule = freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && freeGlobal.process;
    var nodeUtil = function() {
      try {
        var types = freeModule && freeModule.require && freeModule.require("util").types;
        if (types) {
          return types;
        }
        return freeProcess && freeProcess.binding && freeProcess.binding("util");
      } catch (e) {
      }
    }();
    var nodeIsArrayBuffer = nodeUtil && nodeUtil.isArrayBuffer, nodeIsDate = nodeUtil && nodeUtil.isDate, nodeIsMap = nodeUtil && nodeUtil.isMap, nodeIsRegExp = nodeUtil && nodeUtil.isRegExp, nodeIsSet = nodeUtil && nodeUtil.isSet, nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
    function apply2(func, thisArg, args) {
      switch (args.length) {
        case 0:
          return func.call(thisArg);
        case 1:
          return func.call(thisArg, args[0]);
        case 2:
          return func.call(thisArg, args[0], args[1]);
        case 3:
          return func.call(thisArg, args[0], args[1], args[2]);
      }
      return func.apply(thisArg, args);
    }
    function arrayAggregator(array, setter, iteratee, accumulator) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      while (++index2 < length2) {
        var value = array[index2];
        setter(accumulator, value, iteratee(value), array);
      }
      return accumulator;
    }
    function arrayEach(array, iteratee) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      while (++index2 < length2) {
        if (iteratee(array[index2], index2, array) === false) {
          break;
        }
      }
      return array;
    }
    function arrayEachRight(array, iteratee) {
      var length2 = array == null ? 0 : array.length;
      while (length2--) {
        if (iteratee(array[length2], length2, array) === false) {
          break;
        }
      }
      return array;
    }
    function arrayEvery(array, predicate) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      while (++index2 < length2) {
        if (!predicate(array[index2], index2, array)) {
          return false;
        }
      }
      return true;
    }
    function arrayFilter(array, predicate) {
      var index2 = -1, length2 = array == null ? 0 : array.length, resIndex = 0, result = [];
      while (++index2 < length2) {
        var value = array[index2];
        if (predicate(value, index2, array)) {
          result[resIndex++] = value;
        }
      }
      return result;
    }
    function arrayIncludes(array, value) {
      var length2 = array == null ? 0 : array.length;
      return !!length2 && baseIndexOf(array, value, 0) > -1;
    }
    function arrayIncludesWith(array, value, comparator) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      while (++index2 < length2) {
        if (comparator(value, array[index2])) {
          return true;
        }
      }
      return false;
    }
    function arrayMap(array, iteratee) {
      var index2 = -1, length2 = array == null ? 0 : array.length, result = Array(length2);
      while (++index2 < length2) {
        result[index2] = iteratee(array[index2], index2, array);
      }
      return result;
    }
    function arrayPush(array, values) {
      var index2 = -1, length2 = values.length, offset2 = array.length;
      while (++index2 < length2) {
        array[offset2 + index2] = values[index2];
      }
      return array;
    }
    function arrayReduce(array, iteratee, accumulator, initAccum) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      if (initAccum && length2) {
        accumulator = array[++index2];
      }
      while (++index2 < length2) {
        accumulator = iteratee(accumulator, array[index2], index2, array);
      }
      return accumulator;
    }
    function arrayReduceRight(array, iteratee, accumulator, initAccum) {
      var length2 = array == null ? 0 : array.length;
      if (initAccum && length2) {
        accumulator = array[--length2];
      }
      while (length2--) {
        accumulator = iteratee(accumulator, array[length2], length2, array);
      }
      return accumulator;
    }
    function arraySome(array, predicate) {
      var index2 = -1, length2 = array == null ? 0 : array.length;
      while (++index2 < length2) {
        if (predicate(array[index2], index2, array)) {
          return true;
        }
      }
      return false;
    }
    var asciiSize = baseProperty("length");
    function asciiToArray(string) {
      return string.split("");
    }
    function asciiWords(string) {
      return string.match(reAsciiWord) || [];
    }
    function baseFindKey(collection, predicate, eachFunc) {
      var result;
      eachFunc(collection, function(value, key, collection2) {
        if (predicate(value, key, collection2)) {
          result = key;
          return false;
        }
      });
      return result;
    }
    function baseFindIndex(array, predicate, fromIndex, fromRight) {
      var length2 = array.length, index2 = fromIndex + (fromRight ? 1 : -1);
      while (fromRight ? index2-- : ++index2 < length2) {
        if (predicate(array[index2], index2, array)) {
          return index2;
        }
      }
      return -1;
    }
    function baseIndexOf(array, value, fromIndex) {
      return value === value ? strictIndexOf(array, value, fromIndex) : baseFindIndex(array, baseIsNaN, fromIndex);
    }
    function baseIndexOfWith(array, value, fromIndex, comparator) {
      var index2 = fromIndex - 1, length2 = array.length;
      while (++index2 < length2) {
        if (comparator(array[index2], value)) {
          return index2;
        }
      }
      return -1;
    }
    function baseIsNaN(value) {
      return value !== value;
    }
    function baseMean(array, iteratee) {
      var length2 = array == null ? 0 : array.length;
      return length2 ? baseSum(array, iteratee) / length2 : NAN;
    }
    function baseProperty(key) {
      return function(object) {
        return object == null ? undefined$1 : object[key];
      };
    }
    function basePropertyOf(object) {
      return function(key) {
        return object == null ? undefined$1 : object[key];
      };
    }
    function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
      eachFunc(collection, function(value, index2, collection2) {
        accumulator = initAccum ? (initAccum = false, value) : iteratee(accumulator, value, index2, collection2);
      });
      return accumulator;
    }
    function baseSortBy(array, comparer2) {
      var length2 = array.length;
      array.sort(comparer2);
      while (length2--) {
        array[length2] = array[length2].value;
      }
      return array;
    }
    function baseSum(array, iteratee) {
      var result, index2 = -1, length2 = array.length;
      while (++index2 < length2) {
        var current = iteratee(array[index2]);
        if (current !== undefined$1) {
          result = result === undefined$1 ? current : result + current;
        }
      }
      return result;
    }
    function baseTimes(n, iteratee) {
      var index2 = -1, result = Array(n);
      while (++index2 < n) {
        result[index2] = iteratee(index2);
      }
      return result;
    }
    function baseToPairs(object, props) {
      return arrayMap(props, function(key) {
        return [key, object[key]];
      });
    }
    function baseTrim(string) {
      return string ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, "") : string;
    }
    function baseUnary(func) {
      return function(value) {
        return func(value);
      };
    }
    function baseValues(object, props) {
      return arrayMap(props, function(key) {
        return object[key];
      });
    }
    function cacheHas(cache2, key) {
      return cache2.has(key);
    }
    function charsStartIndex(strSymbols, chrSymbols) {
      var index2 = -1, length2 = strSymbols.length;
      while (++index2 < length2 && baseIndexOf(chrSymbols, strSymbols[index2], 0) > -1) {
      }
      return index2;
    }
    function charsEndIndex(strSymbols, chrSymbols) {
      var index2 = strSymbols.length;
      while (index2-- && baseIndexOf(chrSymbols, strSymbols[index2], 0) > -1) {
      }
      return index2;
    }
    function countHolders(array, placeholder) {
      var length2 = array.length, result = 0;
      while (length2--) {
        if (array[length2] === placeholder) {
          ++result;
        }
      }
      return result;
    }
    var deburrLetter = basePropertyOf(deburredLetters);
    var escapeHtmlChar = basePropertyOf(htmlEscapes2);
    function escapeStringChar(chr) {
      return "\\" + stringEscapes[chr];
    }
    function getValue2(object, key) {
      return object == null ? undefined$1 : object[key];
    }
    function hasUnicode(string) {
      return reHasUnicode.test(string);
    }
    function hasUnicodeWord(string) {
      return reHasUnicodeWord.test(string);
    }
    function iteratorToArray(iterator2) {
      var data, result = [];
      while (!(data = iterator2.next()).done) {
        result.push(data.value);
      }
      return result;
    }
    function mapToArray(map2) {
      var index2 = -1, result = Array(map2.size);
      map2.forEach(function(value, key) {
        result[++index2] = [key, value];
      });
      return result;
    }
    function overArg(func, transform) {
      return function(arg) {
        return func(transform(arg));
      };
    }
    function replaceHolders(array, placeholder) {
      var index2 = -1, length2 = array.length, resIndex = 0, result = [];
      while (++index2 < length2) {
        var value = array[index2];
        if (value === placeholder || value === PLACEHOLDER) {
          array[index2] = PLACEHOLDER;
          result[resIndex++] = index2;
        }
      }
      return result;
    }
    function setToArray(set3) {
      var index2 = -1, result = Array(set3.size);
      set3.forEach(function(value) {
        result[++index2] = value;
      });
      return result;
    }
    function setToPairs(set3) {
      var index2 = -1, result = Array(set3.size);
      set3.forEach(function(value) {
        result[++index2] = [value, value];
      });
      return result;
    }
    function strictIndexOf(array, value, fromIndex) {
      var index2 = fromIndex - 1, length2 = array.length;
      while (++index2 < length2) {
        if (array[index2] === value) {
          return index2;
        }
      }
      return -1;
    }
    function strictLastIndexOf(array, value, fromIndex) {
      var index2 = fromIndex + 1;
      while (index2--) {
        if (array[index2] === value) {
          return index2;
        }
      }
      return index2;
    }
    function stringSize(string) {
      return hasUnicode(string) ? unicodeSize(string) : asciiSize(string);
    }
    function stringToArray(string) {
      return hasUnicode(string) ? unicodeToArray(string) : asciiToArray(string);
    }
    function trimmedEndIndex(string) {
      var index2 = string.length;
      while (index2-- && reWhitespace.test(string.charAt(index2))) {
      }
      return index2;
    }
    var unescapeHtmlChar = basePropertyOf(htmlUnescapes);
    function unicodeSize(string) {
      var result = reUnicode.lastIndex = 0;
      while (reUnicode.test(string)) {
        ++result;
      }
      return result;
    }
    function unicodeToArray(string) {
      return string.match(reUnicode) || [];
    }
    function unicodeWords(string) {
      return string.match(reUnicodeWord) || [];
    }
    var runInContext = function runInContext2(context) {
      context = context == null ? root : _2.defaults(root.Object(), context, _2.pick(root, contextProps));
      var Array2 = context.Array, Date2 = context.Date, Error2 = context.Error, Function2 = context.Function, Math2 = context.Math, Object2 = context.Object, RegExp2 = context.RegExp, String2 = context.String, TypeError2 = context.TypeError;
      var arrayProto = Array2.prototype, funcProto = Function2.prototype, objectProto = Object2.prototype;
      var coreJsData = context["__core-js_shared__"];
      var funcToString = funcProto.toString;
      var hasOwnProperty2 = objectProto.hasOwnProperty;
      var idCounter = 0;
      var maskSrcKey = function() {
        var uid2 = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
        return uid2 ? "Symbol(src)_1." + uid2 : "";
      }();
      var nativeObjectToString = objectProto.toString;
      var objectCtorString = funcToString.call(Object2);
      var oldDash = root._;
      var reIsNative = RegExp2(
        "^" + funcToString.call(hasOwnProperty2).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
      );
      var Buffer2 = moduleExports ? context.Buffer : undefined$1, Symbol2 = context.Symbol, Uint8Array2 = context.Uint8Array, allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : undefined$1, getPrototype = overArg(Object2.getPrototypeOf, Object2), objectCreate = Object2.create, propertyIsEnumerable = objectProto.propertyIsEnumerable, splice = arrayProto.splice, spreadableSymbol = Symbol2 ? Symbol2.isConcatSpreadable : undefined$1, symIterator = Symbol2 ? Symbol2.iterator : undefined$1, symToStringTag = Symbol2 ? Symbol2.toStringTag : undefined$1;
      var defineProperty = function() {
        try {
          var func = getNative(Object2, "defineProperty");
          func({}, "", {});
          return func;
        } catch (e) {
        }
      }();
      var ctxClearTimeout = context.clearTimeout !== root.clearTimeout && context.clearTimeout, ctxNow = Date2 && Date2.now !== root.Date.now && Date2.now, ctxSetTimeout = context.setTimeout !== root.setTimeout && context.setTimeout;
      var nativeCeil = Math2.ceil, nativeFloor = Math2.floor, nativeGetSymbols = Object2.getOwnPropertySymbols, nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : undefined$1, nativeIsFinite = context.isFinite, nativeJoin = arrayProto.join, nativeKeys = overArg(Object2.keys, Object2), nativeMax = Math2.max, nativeMin = Math2.min, nativeNow = Date2.now, nativeParseInt = context.parseInt, nativeRandom = Math2.random, nativeReverse = arrayProto.reverse;
      var DataView = getNative(context, "DataView"), Map2 = getNative(context, "Map"), Promise2 = getNative(context, "Promise"), Set2 = getNative(context, "Set"), WeakMap2 = getNative(context, "WeakMap"), nativeCreate = getNative(Object2, "create");
      var metaMap = WeakMap2 && new WeakMap2();
      var realNames = {};
      var dataViewCtorString = toSource(DataView), mapCtorString = toSource(Map2), promiseCtorString = toSource(Promise2), setCtorString = toSource(Set2), weakMapCtorString = toSource(WeakMap2);
      var symbolProto = Symbol2 ? Symbol2.prototype : undefined$1, symbolValueOf = symbolProto ? symbolProto.valueOf : undefined$1, symbolToString = symbolProto ? symbolProto.toString : undefined$1;
      function lodash2(value) {
        if (isObjectLike2(value) && !isArray2(value) && !(value instanceof LazyWrapper)) {
          if (value instanceof LodashWrapper) {
            return value;
          }
          if (hasOwnProperty2.call(value, "__wrapped__")) {
            return wrapperClone(value);
          }
        }
        return new LodashWrapper(value);
      }
      var baseCreate = function() {
        function object() {
        }
        return function(proto2) {
          if (!isObject2(proto2)) {
            return {};
          }
          if (objectCreate) {
            return objectCreate(proto2);
          }
          object.prototype = proto2;
          var result2 = new object();
          object.prototype = undefined$1;
          return result2;
        };
      }();
      function baseLodash() {
      }
      function LodashWrapper(value, chainAll) {
        this.__wrapped__ = value;
        this.__actions__ = [];
        this.__chain__ = !!chainAll;
        this.__index__ = 0;
        this.__values__ = undefined$1;
      }
      lodash2.templateSettings = {
        "escape": reEscape,
        "evaluate": reEvaluate,
        "interpolate": reInterpolate,
        "variable": "",
        "imports": {
          "_": lodash2
        }
      };
      lodash2.prototype = baseLodash.prototype;
      lodash2.prototype.constructor = lodash2;
      LodashWrapper.prototype = baseCreate(baseLodash.prototype);
      LodashWrapper.prototype.constructor = LodashWrapper;
      function LazyWrapper(value) {
        this.__wrapped__ = value;
        this.__actions__ = [];
        this.__dir__ = 1;
        this.__filtered__ = false;
        this.__iteratees__ = [];
        this.__takeCount__ = MAX_ARRAY_LENGTH2;
        this.__views__ = [];
      }
      function lazyClone() {
        var result2 = new LazyWrapper(this.__wrapped__);
        result2.__actions__ = copyArray(this.__actions__);
        result2.__dir__ = this.__dir__;
        result2.__filtered__ = this.__filtered__;
        result2.__iteratees__ = copyArray(this.__iteratees__);
        result2.__takeCount__ = this.__takeCount__;
        result2.__views__ = copyArray(this.__views__);
        return result2;
      }
      function lazyReverse() {
        if (this.__filtered__) {
          var result2 = new LazyWrapper(this);
          result2.__dir__ = -1;
          result2.__filtered__ = true;
        } else {
          result2 = this.clone();
          result2.__dir__ *= -1;
        }
        return result2;
      }
      function lazyValue() {
        var array = this.__wrapped__.value(), dir = this.__dir__, isArr = isArray2(array), isRight = dir < 0, arrLength = isArr ? array.length : 0, view = getView(0, arrLength, this.__views__), start2 = view.start, end2 = view.end, length2 = end2 - start2, index2 = isRight ? end2 : start2 - 1, iteratees = this.__iteratees__, iterLength = iteratees.length, resIndex = 0, takeCount = nativeMin(length2, this.__takeCount__);
        if (!isArr || !isRight && arrLength == length2 && takeCount == length2) {
          return baseWrapperValue(array, this.__actions__);
        }
        var result2 = [];
        outer:
          while (length2-- && resIndex < takeCount) {
            index2 += dir;
            var iterIndex = -1, value = array[index2];
            while (++iterIndex < iterLength) {
              var data = iteratees[iterIndex], iteratee2 = data.iteratee, type2 = data.type, computed2 = iteratee2(value);
              if (type2 == LAZY_MAP_FLAG) {
                value = computed2;
              } else if (!computed2) {
                if (type2 == LAZY_FILTER_FLAG) {
                  continue outer;
                } else {
                  break outer;
                }
              }
            }
            result2[resIndex++] = value;
          }
        return result2;
      }
      LazyWrapper.prototype = baseCreate(baseLodash.prototype);
      LazyWrapper.prototype.constructor = LazyWrapper;
      function Hash(entries) {
        var index2 = -1, length2 = entries == null ? 0 : entries.length;
        this.clear();
        while (++index2 < length2) {
          var entry = entries[index2];
          this.set(entry[0], entry[1]);
        }
      }
      function hashClear() {
        this.__data__ = nativeCreate ? nativeCreate(null) : {};
        this.size = 0;
      }
      function hashDelete(key) {
        var result2 = this.has(key) && delete this.__data__[key];
        this.size -= result2 ? 1 : 0;
        return result2;
      }
      function hashGet(key) {
        var data = this.__data__;
        if (nativeCreate) {
          var result2 = data[key];
          return result2 === HASH_UNDEFINED ? undefined$1 : result2;
        }
        return hasOwnProperty2.call(data, key) ? data[key] : undefined$1;
      }
      function hashHas(key) {
        var data = this.__data__;
        return nativeCreate ? data[key] !== undefined$1 : hasOwnProperty2.call(data, key);
      }
      function hashSet(key, value) {
        var data = this.__data__;
        this.size += this.has(key) ? 0 : 1;
        data[key] = nativeCreate && value === undefined$1 ? HASH_UNDEFINED : value;
        return this;
      }
      Hash.prototype.clear = hashClear;
      Hash.prototype["delete"] = hashDelete;
      Hash.prototype.get = hashGet;
      Hash.prototype.has = hashHas;
      Hash.prototype.set = hashSet;
      function ListCache(entries) {
        var index2 = -1, length2 = entries == null ? 0 : entries.length;
        this.clear();
        while (++index2 < length2) {
          var entry = entries[index2];
          this.set(entry[0], entry[1]);
        }
      }
      function listCacheClear() {
        this.__data__ = [];
        this.size = 0;
      }
      function listCacheDelete(key) {
        var data = this.__data__, index2 = assocIndexOf(data, key);
        if (index2 < 0) {
          return false;
        }
        var lastIndex = data.length - 1;
        if (index2 == lastIndex) {
          data.pop();
        } else {
          splice.call(data, index2, 1);
        }
        --this.size;
        return true;
      }
      function listCacheGet(key) {
        var data = this.__data__, index2 = assocIndexOf(data, key);
        return index2 < 0 ? undefined$1 : data[index2][1];
      }
      function listCacheHas(key) {
        return assocIndexOf(this.__data__, key) > -1;
      }
      function listCacheSet(key, value) {
        var data = this.__data__, index2 = assocIndexOf(data, key);
        if (index2 < 0) {
          ++this.size;
          data.push([key, value]);
        } else {
          data[index2][1] = value;
        }
        return this;
      }
      ListCache.prototype.clear = listCacheClear;
      ListCache.prototype["delete"] = listCacheDelete;
      ListCache.prototype.get = listCacheGet;
      ListCache.prototype.has = listCacheHas;
      ListCache.prototype.set = listCacheSet;
      function MapCache(entries) {
        var index2 = -1, length2 = entries == null ? 0 : entries.length;
        this.clear();
        while (++index2 < length2) {
          var entry = entries[index2];
          this.set(entry[0], entry[1]);
        }
      }
      function mapCacheClear() {
        this.size = 0;
        this.__data__ = {
          "hash": new Hash(),
          "map": new (Map2 || ListCache)(),
          "string": new Hash()
        };
      }
      function mapCacheDelete(key) {
        var result2 = getMapData(this, key)["delete"](key);
        this.size -= result2 ? 1 : 0;
        return result2;
      }
      function mapCacheGet(key) {
        return getMapData(this, key).get(key);
      }
      function mapCacheHas(key) {
        return getMapData(this, key).has(key);
      }
      function mapCacheSet(key, value) {
        var data = getMapData(this, key), size3 = data.size;
        data.set(key, value);
        this.size += data.size == size3 ? 0 : 1;
        return this;
      }
      MapCache.prototype.clear = mapCacheClear;
      MapCache.prototype["delete"] = mapCacheDelete;
      MapCache.prototype.get = mapCacheGet;
      MapCache.prototype.has = mapCacheHas;
      MapCache.prototype.set = mapCacheSet;
      function SetCache(values2) {
        var index2 = -1, length2 = values2 == null ? 0 : values2.length;
        this.__data__ = new MapCache();
        while (++index2 < length2) {
          this.add(values2[index2]);
        }
      }
      function setCacheAdd(value) {
        this.__data__.set(value, HASH_UNDEFINED);
        return this;
      }
      function setCacheHas(value) {
        return this.__data__.has(value);
      }
      SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
      SetCache.prototype.has = setCacheHas;
      function Stack(entries) {
        var data = this.__data__ = new ListCache(entries);
        this.size = data.size;
      }
      function stackClear() {
        this.__data__ = new ListCache();
        this.size = 0;
      }
      function stackDelete(key) {
        var data = this.__data__, result2 = data["delete"](key);
        this.size = data.size;
        return result2;
      }
      function stackGet(key) {
        return this.__data__.get(key);
      }
      function stackHas(key) {
        return this.__data__.has(key);
      }
      function stackSet(key, value) {
        var data = this.__data__;
        if (data instanceof ListCache) {
          var pairs = data.__data__;
          if (!Map2 || pairs.length < LARGE_ARRAY_SIZE - 1) {
            pairs.push([key, value]);
            this.size = ++data.size;
            return this;
          }
          data = this.__data__ = new MapCache(pairs);
        }
        data.set(key, value);
        this.size = data.size;
        return this;
      }
      Stack.prototype.clear = stackClear;
      Stack.prototype["delete"] = stackDelete;
      Stack.prototype.get = stackGet;
      Stack.prototype.has = stackHas;
      Stack.prototype.set = stackSet;
      function arrayLikeKeys(value, inherited) {
        var isArr = isArray2(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer(value), isType = !isArr && !isArg && !isBuff && isTypedArray(value), skipIndexes = isArr || isArg || isBuff || isType, result2 = skipIndexes ? baseTimes(value.length, String2) : [], length2 = result2.length;
        for (var key in value) {
          if ((inherited || hasOwnProperty2.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex(key, length2)))) {
            result2.push(key);
          }
        }
        return result2;
      }
      function arraySample(array) {
        var length2 = array.length;
        return length2 ? array[baseRandom(0, length2 - 1)] : undefined$1;
      }
      function arraySampleSize(array, n) {
        return shuffleSelf(copyArray(array), baseClamp(n, 0, array.length));
      }
      function arrayShuffle(array) {
        return shuffleSelf(copyArray(array));
      }
      function assignMergeValue(object, key, value) {
        if (value !== undefined$1 && !eq2(object[key], value) || value === undefined$1 && !(key in object)) {
          baseAssignValue(object, key, value);
        }
      }
      function assignValue(object, key, value) {
        var objValue = object[key];
        if (!(hasOwnProperty2.call(object, key) && eq2(objValue, value)) || value === undefined$1 && !(key in object)) {
          baseAssignValue(object, key, value);
        }
      }
      function assocIndexOf(array, key) {
        var length2 = array.length;
        while (length2--) {
          if (eq2(array[length2][0], key)) {
            return length2;
          }
        }
        return -1;
      }
      function baseAggregator(collection, setter, iteratee2, accumulator) {
        baseEach(collection, function(value, key, collection2) {
          setter(accumulator, value, iteratee2(value), collection2);
        });
        return accumulator;
      }
      function baseAssign(object, source) {
        return object && copyObject(source, keys(source), object);
      }
      function baseAssignIn(object, source) {
        return object && copyObject(source, keysIn(source), object);
      }
      function baseAssignValue(object, key, value) {
        if (key == "__proto__" && defineProperty) {
          defineProperty(object, key, {
            "configurable": true,
            "enumerable": true,
            "value": value,
            "writable": true
          });
        } else {
          object[key] = value;
        }
      }
      function baseAt(object, paths) {
        var index2 = -1, length2 = paths.length, result2 = Array2(length2), skip = object == null;
        while (++index2 < length2) {
          result2[index2] = skip ? undefined$1 : get2(object, paths[index2]);
        }
        return result2;
      }
      function baseClamp(number2, lower, upper) {
        if (number2 === number2) {
          if (upper !== undefined$1) {
            number2 = number2 <= upper ? number2 : upper;
          }
          if (lower !== undefined$1) {
            number2 = number2 >= lower ? number2 : lower;
          }
        }
        return number2;
      }
      function baseClone(value, bitmask, customizer, key, object, stack) {
        var result2, isDeep = bitmask & CLONE_DEEP_FLAG, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG;
        if (customizer) {
          result2 = object ? customizer(value, key, object, stack) : customizer(value);
        }
        if (result2 !== undefined$1) {
          return result2;
        }
        if (!isObject2(value)) {
          return value;
        }
        var isArr = isArray2(value);
        if (isArr) {
          result2 = initCloneArray(value);
          if (!isDeep) {
            return copyArray(value, result2);
          }
        } else {
          var tag = getTag(value), isFunc = tag == funcTag || tag == genTag;
          if (isBuffer(value)) {
            return cloneBuffer(value, isDeep);
          }
          if (tag == objectTag || tag == argsTag || isFunc && !object) {
            result2 = isFlat || isFunc ? {} : initCloneObject(value);
            if (!isDeep) {
              return isFlat ? copySymbolsIn(value, baseAssignIn(result2, value)) : copySymbols(value, baseAssign(result2, value));
            }
          } else {
            if (!cloneableTags[tag]) {
              return object ? value : {};
            }
            result2 = initCloneByTag(value, tag, isDeep);
          }
        }
        stack || (stack = new Stack());
        var stacked = stack.get(value);
        if (stacked) {
          return stacked;
        }
        stack.set(value, result2);
        if (isSet2(value)) {
          value.forEach(function(subValue) {
            result2.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
          });
        } else if (isMap2(value)) {
          value.forEach(function(subValue, key2) {
            result2.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
          });
        }
        var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys : isFlat ? keysIn : keys;
        var props = isArr ? undefined$1 : keysFunc(value);
        arrayEach(props || value, function(subValue, key2) {
          if (props) {
            key2 = subValue;
            subValue = value[key2];
          }
          assignValue(result2, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
        });
        return result2;
      }
      function baseConforms(source) {
        var props = keys(source);
        return function(object) {
          return baseConformsTo(object, source, props);
        };
      }
      function baseConformsTo(object, source, props) {
        var length2 = props.length;
        if (object == null) {
          return !length2;
        }
        object = Object2(object);
        while (length2--) {
          var key = props[length2], predicate = source[key], value = object[key];
          if (value === undefined$1 && !(key in object) || !predicate(value)) {
            return false;
          }
        }
        return true;
      }
      function baseDelay(func, wait, args) {
        if (typeof func != "function") {
          throw new TypeError2(FUNC_ERROR_TEXT);
        }
        return setTimeout2(function() {
          func.apply(undefined$1, args);
        }, wait);
      }
      function baseDifference(array, values2, iteratee2, comparator) {
        var index2 = -1, includes2 = arrayIncludes, isCommon = true, length2 = array.length, result2 = [], valuesLength = values2.length;
        if (!length2) {
          return result2;
        }
        if (iteratee2) {
          values2 = arrayMap(values2, baseUnary(iteratee2));
        }
        if (comparator) {
          includes2 = arrayIncludesWith;
          isCommon = false;
        } else if (values2.length >= LARGE_ARRAY_SIZE) {
          includes2 = cacheHas;
          isCommon = false;
          values2 = new SetCache(values2);
        }
        outer:
          while (++index2 < length2) {
            var value = array[index2], computed2 = iteratee2 == null ? value : iteratee2(value);
            value = comparator || value !== 0 ? value : 0;
            if (isCommon && computed2 === computed2) {
              var valuesIndex = valuesLength;
              while (valuesIndex--) {
                if (values2[valuesIndex] === computed2) {
                  continue outer;
                }
              }
              result2.push(value);
            } else if (!includes2(values2, computed2, comparator)) {
              result2.push(value);
            }
          }
        return result2;
      }
      var baseEach = createBaseEach(baseForOwn);
      var baseEachRight = createBaseEach(baseForOwnRight, true);
      function baseEvery(collection, predicate) {
        var result2 = true;
        baseEach(collection, function(value, index2, collection2) {
          result2 = !!predicate(value, index2, collection2);
          return result2;
        });
        return result2;
      }
      function baseExtremum(array, iteratee2, comparator) {
        var index2 = -1, length2 = array.length;
        while (++index2 < length2) {
          var value = array[index2], current = iteratee2(value);
          if (current != null && (computed2 === undefined$1 ? current === current && !isSymbol2(current) : comparator(current, computed2))) {
            var computed2 = current, result2 = value;
          }
        }
        return result2;
      }
      function baseFill(array, value, start2, end2) {
        var length2 = array.length;
        start2 = toInteger(start2);
        if (start2 < 0) {
          start2 = -start2 > length2 ? 0 : length2 + start2;
        }
        end2 = end2 === undefined$1 || end2 > length2 ? length2 : toInteger(end2);
        if (end2 < 0) {
          end2 += length2;
        }
        end2 = start2 > end2 ? 0 : toLength(end2);
        while (start2 < end2) {
          array[start2++] = value;
        }
        return array;
      }
      function baseFilter(collection, predicate) {
        var result2 = [];
        baseEach(collection, function(value, index2, collection2) {
          if (predicate(value, index2, collection2)) {
            result2.push(value);
          }
        });
        return result2;
      }
      function baseFlatten(array, depth, predicate, isStrict, result2) {
        var index2 = -1, length2 = array.length;
        predicate || (predicate = isFlattenable);
        result2 || (result2 = []);
        while (++index2 < length2) {
          var value = array[index2];
          if (depth > 0 && predicate(value)) {
            if (depth > 1) {
              baseFlatten(value, depth - 1, predicate, isStrict, result2);
            } else {
              arrayPush(result2, value);
            }
          } else if (!isStrict) {
            result2[result2.length] = value;
          }
        }
        return result2;
      }
      var baseFor = createBaseFor();
      var baseForRight = createBaseFor(true);
      function baseForOwn(object, iteratee2) {
        return object && baseFor(object, iteratee2, keys);
      }
      function baseForOwnRight(object, iteratee2) {
        return object && baseForRight(object, iteratee2, keys);
      }
      function baseFunctions(object, props) {
        return arrayFilter(props, function(key) {
          return isFunction2(object[key]);
        });
      }
      function baseGet(object, path) {
        path = castPath(path, object);
        var index2 = 0, length2 = path.length;
        while (object != null && index2 < length2) {
          object = object[toKey(path[index2++])];
        }
        return index2 && index2 == length2 ? object : undefined$1;
      }
      function baseGetAllKeys(object, keysFunc, symbolsFunc) {
        var result2 = keysFunc(object);
        return isArray2(object) ? result2 : arrayPush(result2, symbolsFunc(object));
      }
      function baseGetTag(value) {
        if (value == null) {
          return value === undefined$1 ? undefinedTag : nullTag;
        }
        return symToStringTag && symToStringTag in Object2(value) ? getRawTag(value) : objectToString2(value);
      }
      function baseGt(value, other) {
        return value > other;
      }
      function baseHas(object, key) {
        return object != null && hasOwnProperty2.call(object, key);
      }
      function baseHasIn(object, key) {
        return object != null && key in Object2(object);
      }
      function baseInRange(number2, start2, end2) {
        return number2 >= nativeMin(start2, end2) && number2 < nativeMax(start2, end2);
      }
      function baseIntersection(arrays, iteratee2, comparator) {
        var includes2 = comparator ? arrayIncludesWith : arrayIncludes, length2 = arrays[0].length, othLength = arrays.length, othIndex = othLength, caches = Array2(othLength), maxLength = Infinity, result2 = [];
        while (othIndex--) {
          var array = arrays[othIndex];
          if (othIndex && iteratee2) {
            array = arrayMap(array, baseUnary(iteratee2));
          }
          maxLength = nativeMin(array.length, maxLength);
          caches[othIndex] = !comparator && (iteratee2 || length2 >= 120 && array.length >= 120) ? new SetCache(othIndex && array) : undefined$1;
        }
        array = arrays[0];
        var index2 = -1, seen2 = caches[0];
        outer:
          while (++index2 < length2 && result2.length < maxLength) {
            var value = array[index2], computed2 = iteratee2 ? iteratee2(value) : value;
            value = comparator || value !== 0 ? value : 0;
            if (!(seen2 ? cacheHas(seen2, computed2) : includes2(result2, computed2, comparator))) {
              othIndex = othLength;
              while (--othIndex) {
                var cache2 = caches[othIndex];
                if (!(cache2 ? cacheHas(cache2, computed2) : includes2(arrays[othIndex], computed2, comparator))) {
                  continue outer;
                }
              }
              if (seen2) {
                seen2.push(computed2);
              }
              result2.push(value);
            }
          }
        return result2;
      }
      function baseInverter(object, setter, iteratee2, accumulator) {
        baseForOwn(object, function(value, key, object2) {
          setter(accumulator, iteratee2(value), key, object2);
        });
        return accumulator;
      }
      function baseInvoke(object, path, args) {
        path = castPath(path, object);
        object = parent(object, path);
        var func = object == null ? object : object[toKey(last(path))];
        return func == null ? undefined$1 : apply2(func, object, args);
      }
      function baseIsArguments(value) {
        return isObjectLike2(value) && baseGetTag(value) == argsTag;
      }
      function baseIsArrayBuffer(value) {
        return isObjectLike2(value) && baseGetTag(value) == arrayBufferTag;
      }
      function baseIsDate(value) {
        return isObjectLike2(value) && baseGetTag(value) == dateTag;
      }
      function baseIsEqual(value, other, bitmask, customizer, stack) {
        if (value === other) {
          return true;
        }
        if (value == null || other == null || !isObjectLike2(value) && !isObjectLike2(other)) {
          return value !== value && other !== other;
        }
        return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
      }
      function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
        var objIsArr = isArray2(object), othIsArr = isArray2(other), objTag = objIsArr ? arrayTag : getTag(object), othTag = othIsArr ? arrayTag : getTag(other);
        objTag = objTag == argsTag ? objectTag : objTag;
        othTag = othTag == argsTag ? objectTag : othTag;
        var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
        if (isSameTag && isBuffer(object)) {
          if (!isBuffer(other)) {
            return false;
          }
          objIsArr = true;
          objIsObj = false;
        }
        if (isSameTag && !objIsObj) {
          stack || (stack = new Stack());
          return objIsArr || isTypedArray(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
        }
        if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
          var objIsWrapped = objIsObj && hasOwnProperty2.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty2.call(other, "__wrapped__");
          if (objIsWrapped || othIsWrapped) {
            var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
            stack || (stack = new Stack());
            return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
          }
        }
        if (!isSameTag) {
          return false;
        }
        stack || (stack = new Stack());
        return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
      }
      function baseIsMap(value) {
        return isObjectLike2(value) && getTag(value) == mapTag;
      }
      function baseIsMatch(object, source, matchData, customizer) {
        var index2 = matchData.length, length2 = index2, noCustomizer = !customizer;
        if (object == null) {
          return !length2;
        }
        object = Object2(object);
        while (index2--) {
          var data = matchData[index2];
          if (noCustomizer && data[2] ? data[1] !== object[data[0]] : !(data[0] in object)) {
            return false;
          }
        }
        while (++index2 < length2) {
          data = matchData[index2];
          var key = data[0], objValue = object[key], srcValue = data[1];
          if (noCustomizer && data[2]) {
            if (objValue === undefined$1 && !(key in object)) {
              return false;
            }
          } else {
            var stack = new Stack();
            if (customizer) {
              var result2 = customizer(objValue, srcValue, key, object, source, stack);
            }
            if (!(result2 === undefined$1 ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack) : result2)) {
              return false;
            }
          }
        }
        return true;
      }
      function baseIsNative(value) {
        if (!isObject2(value) || isMasked(value)) {
          return false;
        }
        var pattern = isFunction2(value) ? reIsNative : reIsHostCtor;
        return pattern.test(toSource(value));
      }
      function baseIsRegExp(value) {
        return isObjectLike2(value) && baseGetTag(value) == regexpTag;
      }
      function baseIsSet(value) {
        return isObjectLike2(value) && getTag(value) == setTag;
      }
      function baseIsTypedArray(value) {
        return isObjectLike2(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
      }
      function baseIteratee(value) {
        if (typeof value == "function") {
          return value;
        }
        if (value == null) {
          return identity;
        }
        if (typeof value == "object") {
          return isArray2(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
        }
        return property(value);
      }
      function baseKeys(object) {
        if (!isPrototype(object)) {
          return nativeKeys(object);
        }
        var result2 = [];
        for (var key in Object2(object)) {
          if (hasOwnProperty2.call(object, key) && key != "constructor") {
            result2.push(key);
          }
        }
        return result2;
      }
      function baseKeysIn(object) {
        if (!isObject2(object)) {
          return nativeKeysIn(object);
        }
        var isProto = isPrototype(object), result2 = [];
        for (var key in object) {
          if (!(key == "constructor" && (isProto || !hasOwnProperty2.call(object, key)))) {
            result2.push(key);
          }
        }
        return result2;
      }
      function baseLt(value, other) {
        return value < other;
      }
      function baseMap(collection, iteratee2) {
        var index2 = -1, result2 = isArrayLike(collection) ? Array2(collection.length) : [];
        baseEach(collection, function(value, key, collection2) {
          result2[++index2] = iteratee2(value, key, collection2);
        });
        return result2;
      }
      function baseMatches(source) {
        var matchData = getMatchData(source);
        if (matchData.length == 1 && matchData[0][2]) {
          return matchesStrictComparable(matchData[0][0], matchData[0][1]);
        }
        return function(object) {
          return object === source || baseIsMatch(object, source, matchData);
        };
      }
      function baseMatchesProperty(path, srcValue) {
        if (isKey(path) && isStrictComparable(srcValue)) {
          return matchesStrictComparable(toKey(path), srcValue);
        }
        return function(object) {
          var objValue = get2(object, path);
          return objValue === undefined$1 && objValue === srcValue ? hasIn(object, path) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
        };
      }
      function baseMerge(object, source, srcIndex, customizer, stack) {
        if (object === source) {
          return;
        }
        baseFor(source, function(srcValue, key) {
          stack || (stack = new Stack());
          if (isObject2(srcValue)) {
            baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
          } else {
            var newValue = customizer ? customizer(safeGet(object, key), srcValue, key + "", object, source, stack) : undefined$1;
            if (newValue === undefined$1) {
              newValue = srcValue;
            }
            assignMergeValue(object, key, newValue);
          }
        }, keysIn);
      }
      function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
        var objValue = safeGet(object, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
        if (stacked) {
          assignMergeValue(object, key, stacked);
          return;
        }
        var newValue = customizer ? customizer(objValue, srcValue, key + "", object, source, stack) : undefined$1;
        var isCommon = newValue === undefined$1;
        if (isCommon) {
          var isArr = isArray2(srcValue), isBuff = !isArr && isBuffer(srcValue), isTyped = !isArr && !isBuff && isTypedArray(srcValue);
          newValue = srcValue;
          if (isArr || isBuff || isTyped) {
            if (isArray2(objValue)) {
              newValue = objValue;
            } else if (isArrayLikeObject(objValue)) {
              newValue = copyArray(objValue);
            } else if (isBuff) {
              isCommon = false;
              newValue = cloneBuffer(srcValue, true);
            } else if (isTyped) {
              isCommon = false;
              newValue = cloneTypedArray(srcValue, true);
            } else {
              newValue = [];
            }
          } else if (isPlainObject2(srcValue) || isArguments(srcValue)) {
            newValue = objValue;
            if (isArguments(objValue)) {
              newValue = toPlainObject(objValue);
            } else if (!isObject2(objValue) || isFunction2(objValue)) {
              newValue = initCloneObject(srcValue);
            }
          } else {
            isCommon = false;
          }
        }
        if (isCommon) {
          stack.set(srcValue, newValue);
          mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
          stack["delete"](srcValue);
        }
        assignMergeValue(object, key, newValue);
      }
      function baseNth(array, n) {
        var length2 = array.length;
        if (!length2) {
          return;
        }
        n += n < 0 ? length2 : 0;
        return isIndex(n, length2) ? array[n] : undefined$1;
      }
      function baseOrderBy(collection, iteratees, orders) {
        if (iteratees.length) {
          iteratees = arrayMap(iteratees, function(iteratee2) {
            if (isArray2(iteratee2)) {
              return function(value) {
                return baseGet(value, iteratee2.length === 1 ? iteratee2[0] : iteratee2);
              };
            }
            return iteratee2;
          });
        } else {
          iteratees = [identity];
        }
        var index2 = -1;
        iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
        var result2 = baseMap(collection, function(value, key, collection2) {
          var criteria = arrayMap(iteratees, function(iteratee2) {
            return iteratee2(value);
          });
          return { "criteria": criteria, "index": ++index2, "value": value };
        });
        return baseSortBy(result2, function(object, other) {
          return compareMultiple(object, other, orders);
        });
      }
      function basePick(object, paths) {
        return basePickBy(object, paths, function(value, path) {
          return hasIn(object, path);
        });
      }
      function basePickBy(object, paths, predicate) {
        var index2 = -1, length2 = paths.length, result2 = {};
        while (++index2 < length2) {
          var path = paths[index2], value = baseGet(object, path);
          if (predicate(value, path)) {
            baseSet(result2, castPath(path, object), value);
          }
        }
        return result2;
      }
      function basePropertyDeep(path) {
        return function(object) {
          return baseGet(object, path);
        };
      }
      function basePullAll(array, values2, iteratee2, comparator) {
        var indexOf3 = comparator ? baseIndexOfWith : baseIndexOf, index2 = -1, length2 = values2.length, seen2 = array;
        if (array === values2) {
          values2 = copyArray(values2);
        }
        if (iteratee2) {
          seen2 = arrayMap(array, baseUnary(iteratee2));
        }
        while (++index2 < length2) {
          var fromIndex = 0, value = values2[index2], computed2 = iteratee2 ? iteratee2(value) : value;
          while ((fromIndex = indexOf3(seen2, computed2, fromIndex, comparator)) > -1) {
            if (seen2 !== array) {
              splice.call(seen2, fromIndex, 1);
            }
            splice.call(array, fromIndex, 1);
          }
        }
        return array;
      }
      function basePullAt(array, indexes) {
        var length2 = array ? indexes.length : 0, lastIndex = length2 - 1;
        while (length2--) {
          var index2 = indexes[length2];
          if (length2 == lastIndex || index2 !== previous) {
            var previous = index2;
            if (isIndex(index2)) {
              splice.call(array, index2, 1);
            } else {
              baseUnset(array, index2);
            }
          }
        }
        return array;
      }
      function baseRandom(lower, upper) {
        return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
      }
      function baseRange(start2, end2, step, fromRight) {
        var index2 = -1, length2 = nativeMax(nativeCeil((end2 - start2) / (step || 1)), 0), result2 = Array2(length2);
        while (length2--) {
          result2[fromRight ? length2 : ++index2] = start2;
          start2 += step;
        }
        return result2;
      }
      function baseRepeat(string, n) {
        var result2 = "";
        if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
          return result2;
        }
        do {
          if (n % 2) {
            result2 += string;
          }
          n = nativeFloor(n / 2);
          if (n) {
            string += string;
          }
        } while (n);
        return result2;
      }
      function baseRest(func, start2) {
        return setToString(overRest(func, start2, identity), func + "");
      }
      function baseSample(collection) {
        return arraySample(values(collection));
      }
      function baseSampleSize(collection, n) {
        var array = values(collection);
        return shuffleSelf(array, baseClamp(n, 0, array.length));
      }
      function baseSet(object, path, value, customizer) {
        if (!isObject2(object)) {
          return object;
        }
        path = castPath(path, object);
        var index2 = -1, length2 = path.length, lastIndex = length2 - 1, nested = object;
        while (nested != null && ++index2 < length2) {
          var key = toKey(path[index2]), newValue = value;
          if (key === "__proto__" || key === "constructor" || key === "prototype") {
            return object;
          }
          if (index2 != lastIndex) {
            var objValue = nested[key];
            newValue = customizer ? customizer(objValue, key, nested) : undefined$1;
            if (newValue === undefined$1) {
              newValue = isObject2(objValue) ? objValue : isIndex(path[index2 + 1]) ? [] : {};
            }
          }
          assignValue(nested, key, newValue);
          nested = nested[key];
        }
        return object;
      }
      var baseSetData = !metaMap ? identity : function(func, data) {
        metaMap.set(func, data);
        return func;
      };
      var baseSetToString = !defineProperty ? identity : function(func, string) {
        return defineProperty(func, "toString", {
          "configurable": true,
          "enumerable": false,
          "value": constant(string),
          "writable": true
        });
      };
      function baseShuffle(collection) {
        return shuffleSelf(values(collection));
      }
      function baseSlice(array, start2, end2) {
        var index2 = -1, length2 = array.length;
        if (start2 < 0) {
          start2 = -start2 > length2 ? 0 : length2 + start2;
        }
        end2 = end2 > length2 ? length2 : end2;
        if (end2 < 0) {
          end2 += length2;
        }
        length2 = start2 > end2 ? 0 : end2 - start2 >>> 0;
        start2 >>>= 0;
        var result2 = Array2(length2);
        while (++index2 < length2) {
          result2[index2] = array[index2 + start2];
        }
        return result2;
      }
      function baseSome(collection, predicate) {
        var result2;
        baseEach(collection, function(value, index2, collection2) {
          result2 = predicate(value, index2, collection2);
          return !result2;
        });
        return !!result2;
      }
      function baseSortedIndex(array, value, retHighest) {
        var low = 0, high = array == null ? low : array.length;
        if (typeof value == "number" && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
          while (low < high) {
            var mid2 = low + high >>> 1, computed2 = array[mid2];
            if (computed2 !== null && !isSymbol2(computed2) && (retHighest ? computed2 <= value : computed2 < value)) {
              low = mid2 + 1;
            } else {
              high = mid2;
            }
          }
          return high;
        }
        return baseSortedIndexBy(array, value, identity, retHighest);
      }
      function baseSortedIndexBy(array, value, iteratee2, retHighest) {
        var low = 0, high = array == null ? 0 : array.length;
        if (high === 0) {
          return 0;
        }
        value = iteratee2(value);
        var valIsNaN = value !== value, valIsNull = value === null, valIsSymbol = isSymbol2(value), valIsUndefined = value === undefined$1;
        while (low < high) {
          var mid2 = nativeFloor((low + high) / 2), computed2 = iteratee2(array[mid2]), othIsDefined = computed2 !== undefined$1, othIsNull = computed2 === null, othIsReflexive = computed2 === computed2, othIsSymbol = isSymbol2(computed2);
          if (valIsNaN) {
            var setLow = retHighest || othIsReflexive;
          } else if (valIsUndefined) {
            setLow = othIsReflexive && (retHighest || othIsDefined);
          } else if (valIsNull) {
            setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
          } else if (valIsSymbol) {
            setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
          } else if (othIsNull || othIsSymbol) {
            setLow = false;
          } else {
            setLow = retHighest ? computed2 <= value : computed2 < value;
          }
          if (setLow) {
            low = mid2 + 1;
          } else {
            high = mid2;
          }
        }
        return nativeMin(high, MAX_ARRAY_INDEX);
      }
      function baseSortedUniq(array, iteratee2) {
        var index2 = -1, length2 = array.length, resIndex = 0, result2 = [];
        while (++index2 < length2) {
          var value = array[index2], computed2 = iteratee2 ? iteratee2(value) : value;
          if (!index2 || !eq2(computed2, seen2)) {
            var seen2 = computed2;
            result2[resIndex++] = value === 0 ? 0 : value;
          }
        }
        return result2;
      }
      function baseToNumber(value) {
        if (typeof value == "number") {
          return value;
        }
        if (isSymbol2(value)) {
          return NAN;
        }
        return +value;
      }
      function baseToString(value) {
        if (typeof value == "string") {
          return value;
        }
        if (isArray2(value)) {
          return arrayMap(value, baseToString) + "";
        }
        if (isSymbol2(value)) {
          return symbolToString ? symbolToString.call(value) : "";
        }
        var result2 = value + "";
        return result2 == "0" && 1 / value == -INFINITY ? "-0" : result2;
      }
      function baseUniq(array, iteratee2, comparator) {
        var index2 = -1, includes2 = arrayIncludes, length2 = array.length, isCommon = true, result2 = [], seen2 = result2;
        if (comparator) {
          isCommon = false;
          includes2 = arrayIncludesWith;
        } else if (length2 >= LARGE_ARRAY_SIZE) {
          var set4 = iteratee2 ? null : createSet(array);
          if (set4) {
            return setToArray(set4);
          }
          isCommon = false;
          includes2 = cacheHas;
          seen2 = new SetCache();
        } else {
          seen2 = iteratee2 ? [] : result2;
        }
        outer:
          while (++index2 < length2) {
            var value = array[index2], computed2 = iteratee2 ? iteratee2(value) : value;
            value = comparator || value !== 0 ? value : 0;
            if (isCommon && computed2 === computed2) {
              var seenIndex = seen2.length;
              while (seenIndex--) {
                if (seen2[seenIndex] === computed2) {
                  continue outer;
                }
              }
              if (iteratee2) {
                seen2.push(computed2);
              }
              result2.push(value);
            } else if (!includes2(seen2, computed2, comparator)) {
              if (seen2 !== result2) {
                seen2.push(computed2);
              }
              result2.push(value);
            }
          }
        return result2;
      }
      function baseUnset(object, path) {
        path = castPath(path, object);
        object = parent(object, path);
        return object == null || delete object[toKey(last(path))];
      }
      function baseUpdate(object, path, updater, customizer) {
        return baseSet(object, path, updater(baseGet(object, path)), customizer);
      }
      function baseWhile(array, predicate, isDrop, fromRight) {
        var length2 = array.length, index2 = fromRight ? length2 : -1;
        while ((fromRight ? index2-- : ++index2 < length2) && predicate(array[index2], index2, array)) {
        }
        return isDrop ? baseSlice(array, fromRight ? 0 : index2, fromRight ? index2 + 1 : length2) : baseSlice(array, fromRight ? index2 + 1 : 0, fromRight ? length2 : index2);
      }
      function baseWrapperValue(value, actions) {
        var result2 = value;
        if (result2 instanceof LazyWrapper) {
          result2 = result2.value();
        }
        return arrayReduce(actions, function(result3, action3) {
          return action3.func.apply(action3.thisArg, arrayPush([result3], action3.args));
        }, result2);
      }
      function baseXor(arrays, iteratee2, comparator) {
        var length2 = arrays.length;
        if (length2 < 2) {
          return length2 ? baseUniq(arrays[0]) : [];
        }
        var index2 = -1, result2 = Array2(length2);
        while (++index2 < length2) {
          var array = arrays[index2], othIndex = -1;
          while (++othIndex < length2) {
            if (othIndex != index2) {
              result2[index2] = baseDifference(result2[index2] || array, arrays[othIndex], iteratee2, comparator);
            }
          }
        }
        return baseUniq(baseFlatten(result2, 1), iteratee2, comparator);
      }
      function baseZipObject(props, values2, assignFunc) {
        var index2 = -1, length2 = props.length, valsLength = values2.length, result2 = {};
        while (++index2 < length2) {
          var value = index2 < valsLength ? values2[index2] : undefined$1;
          assignFunc(result2, props[index2], value);
        }
        return result2;
      }
      function castArrayLikeObject(value) {
        return isArrayLikeObject(value) ? value : [];
      }
      function castFunction(value) {
        return typeof value == "function" ? value : identity;
      }
      function castPath(value, object) {
        if (isArray2(value)) {
          return value;
        }
        return isKey(value, object) ? [value] : stringToPath(toString2(value));
      }
      var castRest = baseRest;
      function castSlice(array, start2, end2) {
        var length2 = array.length;
        end2 = end2 === undefined$1 ? length2 : end2;
        return !start2 && end2 >= length2 ? array : baseSlice(array, start2, end2);
      }
      var clearTimeout2 = ctxClearTimeout || function(id2) {
        return root.clearTimeout(id2);
      };
      function cloneBuffer(buffer, isDeep) {
        if (isDeep) {
          return buffer.slice();
        }
        var length2 = buffer.length, result2 = allocUnsafe ? allocUnsafe(length2) : new buffer.constructor(length2);
        buffer.copy(result2);
        return result2;
      }
      function cloneArrayBuffer(arrayBuffer) {
        var result2 = new arrayBuffer.constructor(arrayBuffer.byteLength);
        new Uint8Array2(result2).set(new Uint8Array2(arrayBuffer));
        return result2;
      }
      function cloneDataView(dataView, isDeep) {
        var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
        return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
      }
      function cloneRegExp(regexp) {
        var result2 = new regexp.constructor(regexp.source, reFlags.exec(regexp));
        result2.lastIndex = regexp.lastIndex;
        return result2;
      }
      function cloneSymbol(symbol) {
        return symbolValueOf ? Object2(symbolValueOf.call(symbol)) : {};
      }
      function cloneTypedArray(typedArray, isDeep) {
        var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
        return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
      }
      function compareAscending(value, other) {
        if (value !== other) {
          var valIsDefined = value !== undefined$1, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = isSymbol2(value);
          var othIsDefined = other !== undefined$1, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol2(other);
          if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
            return 1;
          }
          if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
            return -1;
          }
        }
        return 0;
      }
      function compareMultiple(object, other, orders) {
        var index2 = -1, objCriteria = object.criteria, othCriteria = other.criteria, length2 = objCriteria.length, ordersLength = orders.length;
        while (++index2 < length2) {
          var result2 = compareAscending(objCriteria[index2], othCriteria[index2]);
          if (result2) {
            if (index2 >= ordersLength) {
              return result2;
            }
            var order2 = orders[index2];
            return result2 * (order2 == "desc" ? -1 : 1);
          }
        }
        return object.index - other.index;
      }
      function composeArgs(args, partials, holders, isCurried) {
        var argsIndex = -1, argsLength = args.length, holdersLength = holders.length, leftIndex = -1, leftLength = partials.length, rangeLength = nativeMax(argsLength - holdersLength, 0), result2 = Array2(leftLength + rangeLength), isUncurried = !isCurried;
        while (++leftIndex < leftLength) {
          result2[leftIndex] = partials[leftIndex];
        }
        while (++argsIndex < holdersLength) {
          if (isUncurried || argsIndex < argsLength) {
            result2[holders[argsIndex]] = args[argsIndex];
          }
        }
        while (rangeLength--) {
          result2[leftIndex++] = args[argsIndex++];
        }
        return result2;
      }
      function composeArgsRight(args, partials, holders, isCurried) {
        var argsIndex = -1, argsLength = args.length, holdersIndex = -1, holdersLength = holders.length, rightIndex = -1, rightLength = partials.length, rangeLength = nativeMax(argsLength - holdersLength, 0), result2 = Array2(rangeLength + rightLength), isUncurried = !isCurried;
        while (++argsIndex < rangeLength) {
          result2[argsIndex] = args[argsIndex];
        }
        var offset2 = argsIndex;
        while (++rightIndex < rightLength) {
          result2[offset2 + rightIndex] = partials[rightIndex];
        }
        while (++holdersIndex < holdersLength) {
          if (isUncurried || argsIndex < argsLength) {
            result2[offset2 + holders[holdersIndex]] = args[argsIndex++];
          }
        }
        return result2;
      }
      function copyArray(source, array) {
        var index2 = -1, length2 = source.length;
        array || (array = Array2(length2));
        while (++index2 < length2) {
          array[index2] = source[index2];
        }
        return array;
      }
      function copyObject(source, props, object, customizer) {
        var isNew = !object;
        object || (object = {});
        var index2 = -1, length2 = props.length;
        while (++index2 < length2) {
          var key = props[index2];
          var newValue = customizer ? customizer(object[key], source[key], key, object, source) : undefined$1;
          if (newValue === undefined$1) {
            newValue = source[key];
          }
          if (isNew) {
            baseAssignValue(object, key, newValue);
          } else {
            assignValue(object, key, newValue);
          }
        }
        return object;
      }
      function copySymbols(source, object) {
        return copyObject(source, getSymbols(source), object);
      }
      function copySymbolsIn(source, object) {
        return copyObject(source, getSymbolsIn(source), object);
      }
      function createAggregator(setter, initializer) {
        return function(collection, iteratee2) {
          var func = isArray2(collection) ? arrayAggregator : baseAggregator, accumulator = initializer ? initializer() : {};
          return func(collection, setter, getIteratee(iteratee2, 2), accumulator);
        };
      }
      function createAssigner(assigner) {
        return baseRest(function(object, sources) {
          var index2 = -1, length2 = sources.length, customizer = length2 > 1 ? sources[length2 - 1] : undefined$1, guard = length2 > 2 ? sources[2] : undefined$1;
          customizer = assigner.length > 3 && typeof customizer == "function" ? (length2--, customizer) : undefined$1;
          if (guard && isIterateeCall(sources[0], sources[1], guard)) {
            customizer = length2 < 3 ? undefined$1 : customizer;
            length2 = 1;
          }
          object = Object2(object);
          while (++index2 < length2) {
            var source = sources[index2];
            if (source) {
              assigner(object, source, index2, customizer);
            }
          }
          return object;
        });
      }
      function createBaseEach(eachFunc, fromRight) {
        return function(collection, iteratee2) {
          if (collection == null) {
            return collection;
          }
          if (!isArrayLike(collection)) {
            return eachFunc(collection, iteratee2);
          }
          var length2 = collection.length, index2 = fromRight ? length2 : -1, iterable = Object2(collection);
          while (fromRight ? index2-- : ++index2 < length2) {
            if (iteratee2(iterable[index2], index2, iterable) === false) {
              break;
            }
          }
          return collection;
        };
      }
      function createBaseFor(fromRight) {
        return function(object, iteratee2, keysFunc) {
          var index2 = -1, iterable = Object2(object), props = keysFunc(object), length2 = props.length;
          while (length2--) {
            var key = props[fromRight ? length2 : ++index2];
            if (iteratee2(iterable[key], key, iterable) === false) {
              break;
            }
          }
          return object;
        };
      }
      function createBind(func, bitmask, thisArg) {
        var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
        function wrapper() {
          var fn2 = this && this !== root && this instanceof wrapper ? Ctor : func;
          return fn2.apply(isBind ? thisArg : this, arguments);
        }
        return wrapper;
      }
      function createCaseFirst(methodName) {
        return function(string) {
          string = toString2(string);
          var strSymbols = hasUnicode(string) ? stringToArray(string) : undefined$1;
          var chr = strSymbols ? strSymbols[0] : string.charAt(0);
          var trailing = strSymbols ? castSlice(strSymbols, 1).join("") : string.slice(1);
          return chr[methodName]() + trailing;
        };
      }
      function createCompounder(callback) {
        return function(string) {
          return arrayReduce(words(deburr(string).replace(reApos, "")), callback, "");
        };
      }
      function createCtor(Ctor) {
        return function() {
          var args = arguments;
          switch (args.length) {
            case 0:
              return new Ctor();
            case 1:
              return new Ctor(args[0]);
            case 2:
              return new Ctor(args[0], args[1]);
            case 3:
              return new Ctor(args[0], args[1], args[2]);
            case 4:
              return new Ctor(args[0], args[1], args[2], args[3]);
            case 5:
              return new Ctor(args[0], args[1], args[2], args[3], args[4]);
            case 6:
              return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
            case 7:
              return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
          }
          var thisBinding = baseCreate(Ctor.prototype), result2 = Ctor.apply(thisBinding, args);
          return isObject2(result2) ? result2 : thisBinding;
        };
      }
      function createCurry(func, bitmask, arity) {
        var Ctor = createCtor(func);
        function wrapper() {
          var length2 = arguments.length, args = Array2(length2), index2 = length2, placeholder = getHolder(wrapper);
          while (index2--) {
            args[index2] = arguments[index2];
          }
          var holders = length2 < 3 && args[0] !== placeholder && args[length2 - 1] !== placeholder ? [] : replaceHolders(args, placeholder);
          length2 -= holders.length;
          if (length2 < arity) {
            return createRecurry(
              func,
              bitmask,
              createHybrid,
              wrapper.placeholder,
              undefined$1,
              args,
              holders,
              undefined$1,
              undefined$1,
              arity - length2
            );
          }
          var fn2 = this && this !== root && this instanceof wrapper ? Ctor : func;
          return apply2(fn2, this, args);
        }
        return wrapper;
      }
      function createFind(findIndexFunc) {
        return function(collection, predicate, fromIndex) {
          var iterable = Object2(collection);
          if (!isArrayLike(collection)) {
            var iteratee2 = getIteratee(predicate, 3);
            collection = keys(collection);
            predicate = function(key) {
              return iteratee2(iterable[key], key, iterable);
            };
          }
          var index2 = findIndexFunc(collection, predicate, fromIndex);
          return index2 > -1 ? iterable[iteratee2 ? collection[index2] : index2] : undefined$1;
        };
      }
      function createFlow(fromRight) {
        return flatRest(function(funcs) {
          var length2 = funcs.length, index2 = length2, prereq = LodashWrapper.prototype.thru;
          if (fromRight) {
            funcs.reverse();
          }
          while (index2--) {
            var func = funcs[index2];
            if (typeof func != "function") {
              throw new TypeError2(FUNC_ERROR_TEXT);
            }
            if (prereq && !wrapper && getFuncName(func) == "wrapper") {
              var wrapper = new LodashWrapper([], true);
            }
          }
          index2 = wrapper ? index2 : length2;
          while (++index2 < length2) {
            func = funcs[index2];
            var funcName = getFuncName(func), data = funcName == "wrapper" ? getData(func) : undefined$1;
            if (data && isLaziable(data[0]) && data[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) && !data[4].length && data[9] == 1) {
              wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
            } else {
              wrapper = func.length == 1 && isLaziable(func) ? wrapper[funcName]() : wrapper.thru(func);
            }
          }
          return function() {
            var args = arguments, value = args[0];
            if (wrapper && args.length == 1 && isArray2(value)) {
              return wrapper.plant(value).value();
            }
            var index3 = 0, result2 = length2 ? funcs[index3].apply(this, args) : value;
            while (++index3 < length2) {
              result2 = funcs[index3].call(this, result2);
            }
            return result2;
          };
        });
      }
      function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary2, arity) {
        var isAry = bitmask & WRAP_ARY_FLAG, isBind = bitmask & WRAP_BIND_FLAG, isBindKey = bitmask & WRAP_BIND_KEY_FLAG, isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG), isFlip = bitmask & WRAP_FLIP_FLAG, Ctor = isBindKey ? undefined$1 : createCtor(func);
        function wrapper() {
          var length2 = arguments.length, args = Array2(length2), index2 = length2;
          while (index2--) {
            args[index2] = arguments[index2];
          }
          if (isCurried) {
            var placeholder = getHolder(wrapper), holdersCount = countHolders(args, placeholder);
          }
          if (partials) {
            args = composeArgs(args, partials, holders, isCurried);
          }
          if (partialsRight) {
            args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
          }
          length2 -= holdersCount;
          if (isCurried && length2 < arity) {
            var newHolders = replaceHolders(args, placeholder);
            return createRecurry(
              func,
              bitmask,
              createHybrid,
              wrapper.placeholder,
              thisArg,
              args,
              newHolders,
              argPos,
              ary2,
              arity - length2
            );
          }
          var thisBinding = isBind ? thisArg : this, fn2 = isBindKey ? thisBinding[func] : func;
          length2 = args.length;
          if (argPos) {
            args = reorder(args, argPos);
          } else if (isFlip && length2 > 1) {
            args.reverse();
          }
          if (isAry && ary2 < length2) {
            args.length = ary2;
          }
          if (this && this !== root && this instanceof wrapper) {
            fn2 = Ctor || createCtor(fn2);
          }
          return fn2.apply(thisBinding, args);
        }
        return wrapper;
      }
      function createInverter(setter, toIteratee) {
        return function(object, iteratee2) {
          return baseInverter(object, setter, toIteratee(iteratee2), {});
        };
      }
      function createMathOperation(operator, defaultValue) {
        return function(value, other) {
          var result2;
          if (value === undefined$1 && other === undefined$1) {
            return defaultValue;
          }
          if (value !== undefined$1) {
            result2 = value;
          }
          if (other !== undefined$1) {
            if (result2 === undefined$1) {
              return other;
            }
            if (typeof value == "string" || typeof other == "string") {
              value = baseToString(value);
              other = baseToString(other);
            } else {
              value = baseToNumber(value);
              other = baseToNumber(other);
            }
            result2 = operator(value, other);
          }
          return result2;
        };
      }
      function createOver(arrayFunc) {
        return flatRest(function(iteratees) {
          iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
          return baseRest(function(args) {
            var thisArg = this;
            return arrayFunc(iteratees, function(iteratee2) {
              return apply2(iteratee2, thisArg, args);
            });
          });
        });
      }
      function createPadding(length2, chars) {
        chars = chars === undefined$1 ? " " : baseToString(chars);
        var charsLength = chars.length;
        if (charsLength < 2) {
          return charsLength ? baseRepeat(chars, length2) : chars;
        }
        var result2 = baseRepeat(chars, nativeCeil(length2 / stringSize(chars)));
        return hasUnicode(chars) ? castSlice(stringToArray(result2), 0, length2).join("") : result2.slice(0, length2);
      }
      function createPartial(func, bitmask, thisArg, partials) {
        var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
        function wrapper() {
          var argsIndex = -1, argsLength = arguments.length, leftIndex = -1, leftLength = partials.length, args = Array2(leftLength + argsLength), fn2 = this && this !== root && this instanceof wrapper ? Ctor : func;
          while (++leftIndex < leftLength) {
            args[leftIndex] = partials[leftIndex];
          }
          while (argsLength--) {
            args[leftIndex++] = arguments[++argsIndex];
          }
          return apply2(fn2, isBind ? thisArg : this, args);
        }
        return wrapper;
      }
      function createRange(fromRight) {
        return function(start2, end2, step) {
          if (step && typeof step != "number" && isIterateeCall(start2, end2, step)) {
            end2 = step = undefined$1;
          }
          start2 = toFinite(start2);
          if (end2 === undefined$1) {
            end2 = start2;
            start2 = 0;
          } else {
            end2 = toFinite(end2);
          }
          step = step === undefined$1 ? start2 < end2 ? 1 : -1 : toFinite(step);
          return baseRange(start2, end2, step, fromRight);
        };
      }
      function createRelationalOperation(operator) {
        return function(value, other) {
          if (!(typeof value == "string" && typeof other == "string")) {
            value = toNumber2(value);
            other = toNumber2(other);
          }
          return operator(value, other);
        };
      }
      function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary2, arity) {
        var isCurry = bitmask & WRAP_CURRY_FLAG, newHolders = isCurry ? holders : undefined$1, newHoldersRight = isCurry ? undefined$1 : holders, newPartials = isCurry ? partials : undefined$1, newPartialsRight = isCurry ? undefined$1 : partials;
        bitmask |= isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG;
        bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);
        if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
          bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
        }
        var newData = [
          func,
          bitmask,
          thisArg,
          newPartials,
          newHolders,
          newPartialsRight,
          newHoldersRight,
          argPos,
          ary2,
          arity
        ];
        var result2 = wrapFunc.apply(undefined$1, newData);
        if (isLaziable(func)) {
          setData(result2, newData);
        }
        result2.placeholder = placeholder;
        return setWrapToString(result2, func, bitmask);
      }
      function createRound(methodName) {
        var func = Math2[methodName];
        return function(number2, precision) {
          number2 = toNumber2(number2);
          precision = precision == null ? 0 : nativeMin(toInteger(precision), 292);
          if (precision && nativeIsFinite(number2)) {
            var pair = (toString2(number2) + "e").split("e"), value = func(pair[0] + "e" + (+pair[1] + precision));
            pair = (toString2(value) + "e").split("e");
            return +(pair[0] + "e" + (+pair[1] - precision));
          }
          return func(number2);
        };
      }
      var createSet = !(Set2 && 1 / setToArray(new Set2([, -0]))[1] == INFINITY) ? noop2 : function(values2) {
        return new Set2(values2);
      };
      function createToPairs(keysFunc) {
        return function(object) {
          var tag = getTag(object);
          if (tag == mapTag) {
            return mapToArray(object);
          }
          if (tag == setTag) {
            return setToPairs(object);
          }
          return baseToPairs(object, keysFunc(object));
        };
      }
      function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary2, arity) {
        var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
        if (!isBindKey && typeof func != "function") {
          throw new TypeError2(FUNC_ERROR_TEXT);
        }
        var length2 = partials ? partials.length : 0;
        if (!length2) {
          bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
          partials = holders = undefined$1;
        }
        ary2 = ary2 === undefined$1 ? ary2 : nativeMax(toInteger(ary2), 0);
        arity = arity === undefined$1 ? arity : toInteger(arity);
        length2 -= holders ? holders.length : 0;
        if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
          var partialsRight = partials, holdersRight = holders;
          partials = holders = undefined$1;
        }
        var data = isBindKey ? undefined$1 : getData(func);
        var newData = [
          func,
          bitmask,
          thisArg,
          partials,
          holders,
          partialsRight,
          holdersRight,
          argPos,
          ary2,
          arity
        ];
        if (data) {
          mergeData(newData, data);
        }
        func = newData[0];
        bitmask = newData[1];
        thisArg = newData[2];
        partials = newData[3];
        holders = newData[4];
        arity = newData[9] = newData[9] === undefined$1 ? isBindKey ? 0 : func.length : nativeMax(newData[9] - length2, 0);
        if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
          bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
        }
        if (!bitmask || bitmask == WRAP_BIND_FLAG) {
          var result2 = createBind(func, bitmask, thisArg);
        } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
          result2 = createCurry(func, bitmask, arity);
        } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
          result2 = createPartial(func, bitmask, thisArg, partials);
        } else {
          result2 = createHybrid.apply(undefined$1, newData);
        }
        var setter = data ? baseSetData : setData;
        return setWrapToString(setter(result2, newData), func, bitmask);
      }
      function customDefaultsAssignIn(objValue, srcValue, key, object) {
        if (objValue === undefined$1 || eq2(objValue, objectProto[key]) && !hasOwnProperty2.call(object, key)) {
          return srcValue;
        }
        return objValue;
      }
      function customDefaultsMerge(objValue, srcValue, key, object, source, stack) {
        if (isObject2(objValue) && isObject2(srcValue)) {
          stack.set(srcValue, objValue);
          baseMerge(objValue, srcValue, undefined$1, customDefaultsMerge, stack);
          stack["delete"](srcValue);
        }
        return objValue;
      }
      function customOmitClone(value) {
        return isPlainObject2(value) ? undefined$1 : value;
      }
      function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG, arrLength = array.length, othLength = other.length;
        if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
          return false;
        }
        var arrStacked = stack.get(array);
        var othStacked = stack.get(other);
        if (arrStacked && othStacked) {
          return arrStacked == other && othStacked == array;
        }
        var index2 = -1, result2 = true, seen2 = bitmask & COMPARE_UNORDERED_FLAG ? new SetCache() : undefined$1;
        stack.set(array, other);
        stack.set(other, array);
        while (++index2 < arrLength) {
          var arrValue = array[index2], othValue = other[index2];
          if (customizer) {
            var compared = isPartial ? customizer(othValue, arrValue, index2, other, array, stack) : customizer(arrValue, othValue, index2, array, other, stack);
          }
          if (compared !== undefined$1) {
            if (compared) {
              continue;
            }
            result2 = false;
            break;
          }
          if (seen2) {
            if (!arraySome(other, function(othValue2, othIndex) {
              if (!cacheHas(seen2, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
                return seen2.push(othIndex);
              }
            })) {
              result2 = false;
              break;
            }
          } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
            result2 = false;
            break;
          }
        }
        stack["delete"](array);
        stack["delete"](other);
        return result2;
      }
      function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
        switch (tag) {
          case dataViewTag:
            if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
              return false;
            }
            object = object.buffer;
            other = other.buffer;
          case arrayBufferTag:
            if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array2(object), new Uint8Array2(other))) {
              return false;
            }
            return true;
          case boolTag:
          case dateTag:
          case numberTag:
            return eq2(+object, +other);
          case errorTag:
            return object.name == other.name && object.message == other.message;
          case regexpTag:
          case stringTag:
            return object == other + "";
          case mapTag:
            var convert = mapToArray;
          case setTag:
            var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
            convert || (convert = setToArray);
            if (object.size != other.size && !isPartial) {
              return false;
            }
            var stacked = stack.get(object);
            if (stacked) {
              return stacked == other;
            }
            bitmask |= COMPARE_UNORDERED_FLAG;
            stack.set(object, other);
            var result2 = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
            stack["delete"](object);
            return result2;
          case symbolTag:
            if (symbolValueOf) {
              return symbolValueOf.call(object) == symbolValueOf.call(other);
            }
        }
        return false;
      }
      function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG, objProps = getAllKeys(object), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
        if (objLength != othLength && !isPartial) {
          return false;
        }
        var index2 = objLength;
        while (index2--) {
          var key = objProps[index2];
          if (!(isPartial ? key in other : hasOwnProperty2.call(other, key))) {
            return false;
          }
        }
        var objStacked = stack.get(object);
        var othStacked = stack.get(other);
        if (objStacked && othStacked) {
          return objStacked == other && othStacked == object;
        }
        var result2 = true;
        stack.set(object, other);
        stack.set(other, object);
        var skipCtor = isPartial;
        while (++index2 < objLength) {
          key = objProps[index2];
          var objValue = object[key], othValue = other[key];
          if (customizer) {
            var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
          }
          if (!(compared === undefined$1 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
            result2 = false;
            break;
          }
          skipCtor || (skipCtor = key == "constructor");
        }
        if (result2 && !skipCtor) {
          var objCtor = object.constructor, othCtor = other.constructor;
          if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
            result2 = false;
          }
        }
        stack["delete"](object);
        stack["delete"](other);
        return result2;
      }
      function flatRest(func) {
        return setToString(overRest(func, undefined$1, flatten), func + "");
      }
      function getAllKeys(object) {
        return baseGetAllKeys(object, keys, getSymbols);
      }
      function getAllKeysIn(object) {
        return baseGetAllKeys(object, keysIn, getSymbolsIn);
      }
      var getData = !metaMap ? noop2 : function(func) {
        return metaMap.get(func);
      };
      function getFuncName(func) {
        var result2 = func.name + "", array = realNames[result2], length2 = hasOwnProperty2.call(realNames, result2) ? array.length : 0;
        while (length2--) {
          var data = array[length2], otherFunc = data.func;
          if (otherFunc == null || otherFunc == func) {
            return data.name;
          }
        }
        return result2;
      }
      function getHolder(func) {
        var object = hasOwnProperty2.call(lodash2, "placeholder") ? lodash2 : func;
        return object.placeholder;
      }
      function getIteratee() {
        var result2 = lodash2.iteratee || iteratee;
        result2 = result2 === iteratee ? baseIteratee : result2;
        return arguments.length ? result2(arguments[0], arguments[1]) : result2;
      }
      function getMapData(map3, key) {
        var data = map3.__data__;
        return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
      }
      function getMatchData(object) {
        var result2 = keys(object), length2 = result2.length;
        while (length2--) {
          var key = result2[length2], value = object[key];
          result2[length2] = [key, value, isStrictComparable(value)];
        }
        return result2;
      }
      function getNative(object, key) {
        var value = getValue2(object, key);
        return baseIsNative(value) ? value : undefined$1;
      }
      function getRawTag(value) {
        var isOwn = hasOwnProperty2.call(value, symToStringTag), tag = value[symToStringTag];
        try {
          value[symToStringTag] = undefined$1;
          var unmasked = true;
        } catch (e) {
        }
        var result2 = nativeObjectToString.call(value);
        if (unmasked) {
          if (isOwn) {
            value[symToStringTag] = tag;
          } else {
            delete value[symToStringTag];
          }
        }
        return result2;
      }
      var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
        if (object == null) {
          return [];
        }
        object = Object2(object);
        return arrayFilter(nativeGetSymbols(object), function(symbol) {
          return propertyIsEnumerable.call(object, symbol);
        });
      };
      var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
        var result2 = [];
        while (object) {
          arrayPush(result2, getSymbols(object));
          object = getPrototype(object);
        }
        return result2;
      };
      var getTag = baseGetTag;
      if (DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag || Map2 && getTag(new Map2()) != mapTag || Promise2 && getTag(Promise2.resolve()) != promiseTag || Set2 && getTag(new Set2()) != setTag || WeakMap2 && getTag(new WeakMap2()) != weakMapTag) {
        getTag = function(value) {
          var result2 = baseGetTag(value), Ctor = result2 == objectTag ? value.constructor : undefined$1, ctorString = Ctor ? toSource(Ctor) : "";
          if (ctorString) {
            switch (ctorString) {
              case dataViewCtorString:
                return dataViewTag;
              case mapCtorString:
                return mapTag;
              case promiseCtorString:
                return promiseTag;
              case setCtorString:
                return setTag;
              case weakMapCtorString:
                return weakMapTag;
            }
          }
          return result2;
        };
      }
      function getView(start2, end2, transforms) {
        var index2 = -1, length2 = transforms.length;
        while (++index2 < length2) {
          var data = transforms[index2], size3 = data.size;
          switch (data.type) {
            case "drop":
              start2 += size3;
              break;
            case "dropRight":
              end2 -= size3;
              break;
            case "take":
              end2 = nativeMin(end2, start2 + size3);
              break;
            case "takeRight":
              start2 = nativeMax(start2, end2 - size3);
              break;
          }
        }
        return { "start": start2, "end": end2 };
      }
      function getWrapDetails(source) {
        var match3 = source.match(reWrapDetails);
        return match3 ? match3[1].split(reSplitDetails) : [];
      }
      function hasPath(object, path, hasFunc) {
        path = castPath(path, object);
        var index2 = -1, length2 = path.length, result2 = false;
        while (++index2 < length2) {
          var key = toKey(path[index2]);
          if (!(result2 = object != null && hasFunc(object, key))) {
            break;
          }
          object = object[key];
        }
        if (result2 || ++index2 != length2) {
          return result2;
        }
        length2 = object == null ? 0 : object.length;
        return !!length2 && isLength(length2) && isIndex(key, length2) && (isArray2(object) || isArguments(object));
      }
      function initCloneArray(array) {
        var length2 = array.length, result2 = new array.constructor(length2);
        if (length2 && typeof array[0] == "string" && hasOwnProperty2.call(array, "index")) {
          result2.index = array.index;
          result2.input = array.input;
        }
        return result2;
      }
      function initCloneObject(object) {
        return typeof object.constructor == "function" && !isPrototype(object) ? baseCreate(getPrototype(object)) : {};
      }
      function initCloneByTag(object, tag, isDeep) {
        var Ctor = object.constructor;
        switch (tag) {
          case arrayBufferTag:
            return cloneArrayBuffer(object);
          case boolTag:
          case dateTag:
            return new Ctor(+object);
          case dataViewTag:
            return cloneDataView(object, isDeep);
          case float32Tag:
          case float64Tag:
          case int8Tag:
          case int16Tag:
          case int32Tag:
          case uint8Tag:
          case uint8ClampedTag:
          case uint16Tag:
          case uint32Tag:
            return cloneTypedArray(object, isDeep);
          case mapTag:
            return new Ctor();
          case numberTag:
          case stringTag:
            return new Ctor(object);
          case regexpTag:
            return cloneRegExp(object);
          case setTag:
            return new Ctor();
          case symbolTag:
            return cloneSymbol(object);
        }
      }
      function insertWrapDetails(source, details) {
        var length2 = details.length;
        if (!length2) {
          return source;
        }
        var lastIndex = length2 - 1;
        details[lastIndex] = (length2 > 1 ? "& " : "") + details[lastIndex];
        details = details.join(length2 > 2 ? ", " : " ");
        return source.replace(reWrapComment, "{\n/* [wrapped with " + details + "] */\n");
      }
      function isFlattenable(value) {
        return isArray2(value) || isArguments(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
      }
      function isIndex(value, length2) {
        var type2 = typeof value;
        length2 = length2 == null ? MAX_SAFE_INTEGER : length2;
        return !!length2 && (type2 == "number" || type2 != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length2);
      }
      function isIterateeCall(value, index2, object) {
        if (!isObject2(object)) {
          return false;
        }
        var type2 = typeof index2;
        if (type2 == "number" ? isArrayLike(object) && isIndex(index2, object.length) : type2 == "string" && index2 in object) {
          return eq2(object[index2], value);
        }
        return false;
      }
      function isKey(value, object) {
        if (isArray2(value)) {
          return false;
        }
        var type2 = typeof value;
        if (type2 == "number" || type2 == "symbol" || type2 == "boolean" || value == null || isSymbol2(value)) {
          return true;
        }
        return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object2(object);
      }
      function isKeyable(value) {
        var type2 = typeof value;
        return type2 == "string" || type2 == "number" || type2 == "symbol" || type2 == "boolean" ? value !== "__proto__" : value === null;
      }
      function isLaziable(func) {
        var funcName = getFuncName(func), other = lodash2[funcName];
        if (typeof other != "function" || !(funcName in LazyWrapper.prototype)) {
          return false;
        }
        if (func === other) {
          return true;
        }
        var data = getData(other);
        return !!data && func === data[0];
      }
      function isMasked(func) {
        return !!maskSrcKey && maskSrcKey in func;
      }
      var isMaskable = coreJsData ? isFunction2 : stubFalse;
      function isPrototype(value) {
        var Ctor = value && value.constructor, proto2 = typeof Ctor == "function" && Ctor.prototype || objectProto;
        return value === proto2;
      }
      function isStrictComparable(value) {
        return value === value && !isObject2(value);
      }
      function matchesStrictComparable(key, srcValue) {
        return function(object) {
          if (object == null) {
            return false;
          }
          return object[key] === srcValue && (srcValue !== undefined$1 || key in Object2(object));
        };
      }
      function memoizeCapped(func) {
        var result2 = memoize(func, function(key) {
          if (cache2.size === MAX_MEMOIZE_SIZE) {
            cache2.clear();
          }
          return key;
        });
        var cache2 = result2.cache;
        return result2;
      }
      function mergeData(data, source) {
        var bitmask = data[1], srcBitmask = source[1], newBitmask = bitmask | srcBitmask, isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);
        var isCombo = srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_CURRY_FLAG || srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_REARG_FLAG && data[7].length <= source[8] || srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG) && source[7].length <= source[8] && bitmask == WRAP_CURRY_FLAG;
        if (!(isCommon || isCombo)) {
          return data;
        }
        if (srcBitmask & WRAP_BIND_FLAG) {
          data[2] = source[2];
          newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
        }
        var value = source[3];
        if (value) {
          var partials = data[3];
          data[3] = partials ? composeArgs(partials, value, source[4]) : value;
          data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : source[4];
        }
        value = source[5];
        if (value) {
          partials = data[5];
          data[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
          data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : source[6];
        }
        value = source[7];
        if (value) {
          data[7] = value;
        }
        if (srcBitmask & WRAP_ARY_FLAG) {
          data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
        }
        if (data[9] == null) {
          data[9] = source[9];
        }
        data[0] = source[0];
        data[1] = newBitmask;
        return data;
      }
      function nativeKeysIn(object) {
        var result2 = [];
        if (object != null) {
          for (var key in Object2(object)) {
            result2.push(key);
          }
        }
        return result2;
      }
      function objectToString2(value) {
        return nativeObjectToString.call(value);
      }
      function overRest(func, start2, transform2) {
        start2 = nativeMax(start2 === undefined$1 ? func.length - 1 : start2, 0);
        return function() {
          var args = arguments, index2 = -1, length2 = nativeMax(args.length - start2, 0), array = Array2(length2);
          while (++index2 < length2) {
            array[index2] = args[start2 + index2];
          }
          index2 = -1;
          var otherArgs = Array2(start2 + 1);
          while (++index2 < start2) {
            otherArgs[index2] = args[index2];
          }
          otherArgs[start2] = transform2(array);
          return apply2(func, this, otherArgs);
        };
      }
      function parent(object, path) {
        return path.length < 2 ? object : baseGet(object, baseSlice(path, 0, -1));
      }
      function reorder(array, indexes) {
        var arrLength = array.length, length2 = nativeMin(indexes.length, arrLength), oldArray = copyArray(array);
        while (length2--) {
          var index2 = indexes[length2];
          array[length2] = isIndex(index2, arrLength) ? oldArray[index2] : undefined$1;
        }
        return array;
      }
      function safeGet(object, key) {
        if (key === "constructor" && typeof object[key] === "function") {
          return;
        }
        if (key == "__proto__") {
          return;
        }
        return object[key];
      }
      var setData = shortOut(baseSetData);
      var setTimeout2 = ctxSetTimeout || function(func, wait) {
        return root.setTimeout(func, wait);
      };
      var setToString = shortOut(baseSetToString);
      function setWrapToString(wrapper, reference3, bitmask) {
        var source = reference3 + "";
        return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
      }
      function shortOut(func) {
        var count = 0, lastCalled = 0;
        return function() {
          var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
          lastCalled = stamp;
          if (remaining > 0) {
            if (++count >= HOT_COUNT) {
              return arguments[0];
            }
          } else {
            count = 0;
          }
          return func.apply(undefined$1, arguments);
        };
      }
      function shuffleSelf(array, size3) {
        var index2 = -1, length2 = array.length, lastIndex = length2 - 1;
        size3 = size3 === undefined$1 ? length2 : size3;
        while (++index2 < size3) {
          var rand = baseRandom(index2, lastIndex), value = array[rand];
          array[rand] = array[index2];
          array[index2] = value;
        }
        array.length = size3;
        return array;
      }
      var stringToPath = memoizeCapped(function(string) {
        var result2 = [];
        if (string.charCodeAt(0) === 46) {
          result2.push("");
        }
        string.replace(rePropName, function(match3, number2, quote, subString) {
          result2.push(quote ? subString.replace(reEscapeChar, "$1") : number2 || match3);
        });
        return result2;
      });
      function toKey(value) {
        if (typeof value == "string" || isSymbol2(value)) {
          return value;
        }
        var result2 = value + "";
        return result2 == "0" && 1 / value == -INFINITY ? "-0" : result2;
      }
      function toSource(func) {
        if (func != null) {
          try {
            return funcToString.call(func);
          } catch (e) {
          }
          try {
            return func + "";
          } catch (e) {
          }
        }
        return "";
      }
      function updateWrapDetails(details, bitmask) {
        arrayEach(wrapFlags, function(pair) {
          var value = "_." + pair[0];
          if (bitmask & pair[1] && !arrayIncludes(details, value)) {
            details.push(value);
          }
        });
        return details.sort();
      }
      function wrapperClone(wrapper) {
        if (wrapper instanceof LazyWrapper) {
          return wrapper.clone();
        }
        var result2 = new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__);
        result2.__actions__ = copyArray(wrapper.__actions__);
        result2.__index__ = wrapper.__index__;
        result2.__values__ = wrapper.__values__;
        return result2;
      }
      function chunk(array, size3, guard) {
        if (guard ? isIterateeCall(array, size3, guard) : size3 === undefined$1) {
          size3 = 1;
        } else {
          size3 = nativeMax(toInteger(size3), 0);
        }
        var length2 = array == null ? 0 : array.length;
        if (!length2 || size3 < 1) {
          return [];
        }
        var index2 = 0, resIndex = 0, result2 = Array2(nativeCeil(length2 / size3));
        while (index2 < length2) {
          result2[resIndex++] = baseSlice(array, index2, index2 += size3);
        }
        return result2;
      }
      function compact(array) {
        var index2 = -1, length2 = array == null ? 0 : array.length, resIndex = 0, result2 = [];
        while (++index2 < length2) {
          var value = array[index2];
          if (value) {
            result2[resIndex++] = value;
          }
        }
        return result2;
      }
      function concat() {
        var length2 = arguments.length;
        if (!length2) {
          return [];
        }
        var args = Array2(length2 - 1), array = arguments[0], index2 = length2;
        while (index2--) {
          args[index2 - 1] = arguments[index2];
        }
        return arrayPush(isArray2(array) ? copyArray(array) : [array], baseFlatten(args, 1));
      }
      var difference = baseRest(function(array, values2) {
        return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true)) : [];
      });
      var differenceBy = baseRest(function(array, values2) {
        var iteratee2 = last(values2);
        if (isArrayLikeObject(iteratee2)) {
          iteratee2 = undefined$1;
        }
        return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2)) : [];
      });
      var differenceWith = baseRest(function(array, values2) {
        var comparator = last(values2);
        if (isArrayLikeObject(comparator)) {
          comparator = undefined$1;
        }
        return isArrayLikeObject(array) ? baseDifference(array, baseFlatten(values2, 1, isArrayLikeObject, true), undefined$1, comparator) : [];
      });
      function drop(array, n, guard) {
        var length2 = array == null ? 0 : array.length;
        if (!length2) {
          return [];
        }
        n = guard || n === undefined$1 ? 1 : toInteger(n);
        return baseSlice(array, n < 0 ? 0 : n, length2);
      }
      function dropRight(array, n, guard) {
        var length2 = array == null ? 0 : array.length;
        if (!length2) {
          return [];
        }
        n = guard || n === undefined$1 ? 1 : toInteger(n);
        n = length2 - n;
        return baseSlice(array, 0, n < 0 ? 0 : n);
      }
      function dropRightWhile(array, predicate) {
        return array && array.length ? baseWhile(array, getIteratee(predicate, 3), true, true) : [];
      }
      function dropWhile(array, predicate) {
        return array && array.length ? baseWhile(array, getIteratee(predicate, 3), true) : [];
      }
      function fill(array, value, start2, end2) {
        var length2 = array == null ? 0 : array.length;
        if (!length2) {
          return [];
        }
        if (start2 && typeof start2 != "number" && isIterateeCall(array, value, start2)) {
          start2 = 0;
          end2 = length2;
        }
        return baseFill(array, value, start2, end2);
      }
      function findIndex(array, predicate, fromIndex) {
        var length2 = array == null ? 0 : array.length;
        if (!length2) {
          return -1;
        }
        var index2 = fromIndex == null ? 0 : toInteger(fromIndex);
        if (index2 < 0) {
          index2 = nativeMax(length2 + index2, 0);
        }
        return baseFindIndex(array, getIteratee(predicate, 3), index2);
      }
      function findLastIndex(array, predicate, fromIndex) {
        var length2 = array == null ? 0 : array.length;
        if (!length2) {
          return -1;
        }
        var index2 = length2 - 1;
        if (fromIndex !== undefined$1) {
          index2 = toInteger(fromIndex);
          index2 = fromIndex < 0 ? nativeMax(length2 + index2, 0) : nativeMin(index2, length2 - 1);
        }
        return baseFindIndex(array, getIteratee(predicate, 3), index2, true);
      }
      function flatten(array) {
        var length2 = array == null ? 0 : array.length;
        return length2 ? baseFlatten(array, 1) : [];
      }
      function flattenDeep(array) {
        var length2 = array == null ? 0 : array.length;
        return length2 ? baseFlatten(array, INFINITY) : [];
      }
      function flattenDepth(array, depth) {
        var length2 = array == null ? 0 : array.length;
        if (!length2) {
          return [];
        }
        depth = depth === undefined$1 ? 1 : toInteger(depth);
        return baseFlatten(array, depth);
      }
      function fromPairs(pairs) {
        var index2 = -1, length2 = pairs == null ? 0 : pairs.length, res